/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import processing.app.Base;
import processing.app.Editor;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.tools.Tool;

public class FixEncoding
implements Tool {
    Editor editor;

    public String getMenuTitle() {
        return "Fix Encoding & Reload";
    }

    public void init(Editor editor) {
        this.editor = editor;
    }

    public void run() {
        int n;
        Sketch sketch = this.editor.getSketch();
        if (sketch.isModified() && (n = JOptionPane.showConfirmDialog(this.editor, "Discard all changes and reload sketch?", "Fix Encoding & Reload", 0, 3)) == 1) {
            return;
        }
        try {
            for (n = 0; n < sketch.getCodeCount(); ++n) {
                SketchCode sketchCode = sketch.getCode(n);
                sketchCode.setProgram(this.loadWithLocalEncoding(sketchCode.getFile()));
                sketchCode.setModified(true);
            }
            this.editor.setText(sketch.getCurrentCode().getProgram());
        }
        catch (IOException iOException) {
            String string = "An error occurred while trying to fix the file encoding.\nDo not attempt to save this sketch as it may overwrite\nthe old version. Use Open to re-open the sketch and try again.\n" + iOException.getMessage();
            Base.showWarning("Fix Encoding & Reload", string, iOException);
        }
    }

    protected String loadWithLocalEncoding(File file) throws IOException {
        FileReader fileReader = new FileReader(file);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append('\n');
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }
}

