/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import processing.app.HttpConstants;
import processing.app.WebServerWorker;

public class WebServer
implements HttpConstants {
    static Vector threads = new Vector();
    static int timeout = 10000;
    static int workers = 5;

    protected static void log(String string) {
    }

    public static int launch(String string) throws IOException {
        Runnable runnable;
        final ZipFile zipFile = new ZipFile(string);
        final HashMap<String, ZipEntry> hashMap = new HashMap<String, ZipEntry>();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            hashMap.put(zipEntry.getName(), zipEntry);
        }
        for (int i = 0; i < workers; ++i) {
            runnable = new WebServerWorker(zipFile, hashMap);
            Thread thread = new Thread(runnable, "Web Server Worker #" + i);
            thread.start();
            threads.addElement(runnable);
        }
        runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    ServerSocket serverSocket = new ServerSocket(8080);
                    while (true) {
                        Socket socket = serverSocket.accept();
                        WebServerWorker webServerWorker = null;
                        Vector vector = threads;
                        synchronized (vector) {
                            if (threads.isEmpty()) {
                                WebServerWorker webServerWorker2 = new WebServerWorker(zipFile, hashMap);
                                webServerWorker2.setSocket(socket);
                                new Thread((Runnable)webServerWorker2, "additional worker").start();
                            } else {
                                webServerWorker = (WebServerWorker)threads.elementAt(0);
                                threads.removeElementAt(0);
                                webServerWorker.setSocket(socket);
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    return;
                }
            }
        };
        new Thread(runnable).start();
        return 8080;
    }
}

