/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.function.LongConsumer;
import org.apache.solr.analytics.ExpressionFactory;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class DateParseFunction {
    public static final String name = "date";
    public static final ExpressionFactory.CreatorFunction creatorFunction = params -> {
        if (params.length != 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date function requires 1 paramater, " + params.length + " found.");
        }
        if (params[0] instanceof LongValue) {
            return new LongToDateParseFunction((LongValue)params[0]);
        }
        if (params[0] instanceof LongValueStream) {
            return new LongStreamToDateParseFunction((LongValueStream)params[0]);
        }
        if (params[0] instanceof StringValue) {
            return new StringToDateParseFunction((StringValue)params[0]);
        }
        if (params[0] instanceof StringValueStream) {
            return new StringStreamToDateParseFunction((StringValueStream)params[0]);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The date function requires a string or long parameter. Incorrect parameter: " + params[0].getExpressionStr());
    };

    static class StringStreamToDateParseFunction
    extends DateValueStream.AbstractDateValueStream {
        private final StringValueStream param;
        public static final String name = "date";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public StringStreamToDateParseFunction(StringValueStream param) throws SolrException {
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString("date", param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            this.param.streamStrings(value -> {
                try {
                    cons.accept(Instant.parse(value).toEpochMilli());
                }
                catch (DateTimeParseException dateTimeParseException) {
                    // empty catch block
                }
            });
        }

        @Override
        public String getName() {
            return "date";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class StringToDateParseFunction
    extends DateValue.AbstractDateValue {
        private final StringValue param;
        public static final String name = "date";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;
        private boolean exists = false;

        public StringToDateParseFunction(StringValue param) throws SolrException {
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString("date", param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public long getLong() {
            long value = 0L;
            try {
                String paramStr = this.param.getString();
                this.exists = this.param.exists();
                if (this.exists) {
                    value = Instant.parse(paramStr).toEpochMilli();
                }
            }
            catch (DateTimeParseException e) {
                this.exists = false;
            }
            return value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public String getName() {
            return "date";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongStreamToDateParseFunction
    extends DateValueStream.AbstractDateValueStream {
        private final LongValueStream param;
        public static final String name = "date";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongStreamToDateParseFunction(LongValueStream param) throws SolrException {
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString("date", param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public void streamLongs(LongConsumer cons) {
            this.param.streamLongs(cons);
        }

        @Override
        public String getName() {
            return "date";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }

    static class LongToDateParseFunction
    extends DateValue.AbstractDateValue {
        private final LongValue param;
        public static final String name = "date";
        private final String exprStr;
        private final AnalyticsValueStream.ExpressionType funcType;

        public LongToDateParseFunction(LongValue param) throws SolrException {
            this.param = param;
            this.exprStr = AnalyticsValueStream.createExpressionString("date", param);
            this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param);
        }

        @Override
        public long getLong() {
            return this.param.getLong();
        }

        @Override
        public boolean exists() {
            return this.param.exists();
        }

        @Override
        public String getName() {
            return "date";
        }

        @Override
        public String getExpressionStr() {
            return this.exprStr;
        }

        @Override
        public AnalyticsValueStream.ExpressionType getExpressionType() {
            return this.funcType;
        }
    }
}

