/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response.transform;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.transform.DocTransformer;
import org.apache.solr.response.transform.RenameFieldTransformer;
import org.apache.solr.response.transform.TransformerFactory;

public class RawValueTransformerFactory
extends TransformerFactory
implements TransformerFactory.FieldRenamer {
    String applyToWT = null;

    public RawValueTransformerFactory() {
    }

    public RawValueTransformerFactory(String wt) {
        this.applyToWT = wt;
    }

    @Override
    public void init(NamedList<?> args) {
        super.init(args);
        if (this.defaultUserArgs != null && this.defaultUserArgs.startsWith("wt=")) {
            this.applyToWT = this.defaultUserArgs.substring(3);
        }
    }

    @Override
    public DocTransformer create(String display, SolrParams params, SolrQueryRequest req) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean mayModifyValue() {
        return false;
    }

    @Override
    public DocTransformer create(String display, SolrParams params, SolrQueryRequest req, Map<String, String> renamedFields, Set<String> reqFieldNames) {
        boolean copy;
        String field = params.get("f");
        if (StrUtils.isNullOrEmpty((String)field)) {
            field = display;
        }
        boolean rename = !(field = renamedFields.getOrDefault(field, field)).equals(display);
        boolean bl = copy = rename && reqFieldNames != null && reqFieldNames.contains(field);
        if (!copy) {
            renamedFields.put(field, display);
        }
        boolean apply = true;
        if (this.applyToWT != null) {
            String qwt = req.getParams().get("wt");
            if (qwt == null) {
                QueryResponseWriter dw;
                QueryResponseWriter qw = req.getCore().getQueryResponseWriter(req);
                if (qw != (dw = req.getCore().getQueryResponseWriter(this.applyToWT))) {
                    apply = false;
                }
            } else {
                apply = this.applyToWT.equals(qwt);
            }
        }
        if (apply) {
            return new RawTransformer(field, display, copy);
        }
        if (!rename) {
            return new DocTransformer.NoopFieldTransformer(field);
        }
        return new RenameFieldTransformer(field, display, copy);
    }

    static class RawTransformer
    extends DocTransformer {
        final String field;
        final String display;
        final boolean copy;

        public RawTransformer(String field, String display, boolean copy) {
            this.field = field;
            this.display = display;
            this.copy = copy;
        }

        @Override
        public String getName() {
            return this.display;
        }

        @Override
        public Collection<String> getRawFields() {
            return Collections.singleton(this.display);
        }

        @Override
        public void transform(SolrDocument doc, int docid) {
            Object val;
            Object object = val = this.copy ? doc.get((Object)this.field) : doc.remove((Object)this.field);
            if (val != null) {
                doc.setField(this.display, val);
            }
        }

        @Override
        public String[] getExtraRequestFields() {
            return new String[]{this.field};
        }
    }
}

