/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.sis.internal.system.Threads;
import org.apache.sis.util.logging.Logging;

public final class Shutdown
extends Thread {
    private static String container;
    private static Shutdown hook;
    private static final List<Callable<?>> resources;

    private Shutdown() {
        super(Threads.SIS, "Shutdown");
    }

    @Override
    public void run() {
        try {
            Shutdown.stop(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContainer() {
        List<Callable<?>> list = resources;
        synchronized (list) {
            return container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContainer(String string) {
        Objects.requireNonNull(string);
        List<Callable<?>> list = resources;
        synchronized (list) {
            Shutdown.removeShutdownHook();
            container = string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Callable<?> callable) {
        List<Callable<?>> list = resources;
        synchronized (list) {
            assert (!resources.contains(callable));
            resources.add(callable);
            if (hook == null && container == null) {
                hook = new Shutdown();
                Runtime.getRuntime().addShutdownHook(hook);
            }
        }
    }

    private static void removeShutdownHook() {
        assert (Thread.holdsLock(resources));
        if (hook != null) {
            Runtime.getRuntime().removeShutdownHook(hook);
            hook = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Callable<?> callable) {
        List<Callable<?>> list = resources;
        synchronized (list) {
            int n = resources.size();
            while (--n >= 0) {
                if (resources.get(n) != callable) continue;
                resources.remove(n);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(Class<?> clazz) throws Exception {
        Object object;
        block14: {
            object = resources;
            synchronized (object) {
                container = "Shutdown";
                if (clazz != null) {
                    Shutdown.removeShutdownHook();
                }
            }
            object = null;
            List<Callable<?>> list = resources;
            synchronized (list) {
                int n;
                while ((n = resources.size()) != 0) {
                    try {
                        resources.remove(n - 1).call();
                    }
                    catch (Exception exception) {
                        if (object != null) {
                            exception.addSuppressed((Throwable)object);
                        }
                        object = exception;
                    }
                }
            }
            try {
                Threads.shutdown(System.nanoTime() + 4000L);
            }
            catch (InterruptedException interruptedException) {
                if (clazz == null) break block14;
                Logging.unexpectedException(Logging.getLogger("org.apache.sis.system"), clazz, "stop", interruptedException);
            }
        }
        if (object != null) {
            throw object;
        }
    }

    static {
        resources = new ArrayList();
    }
}

