/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

public class StringPattern {
    private static final int INITAL_CAPITAL_LETTER = 1;
    private static final int ALL_CAPITAL_LETTER = 2;
    private static final int ALL_LOWERCASE_LETTER = 4;
    private static final int ALL_LETTERS = 8;
    private static final int ALL_DIGIT = 16;
    private static final int ALL_HIRAGANA = 32;
    private static final int ALL_KATAKANA = 64;
    private static final int CONTAINS_PERIOD = 128;
    private static final int CONTAINS_COMMA = 256;
    private static final int CONTAINS_SLASH = 512;
    private static final int CONTAINS_DIGIT = 1024;
    private static final int CONTAINS_HYPHEN = 2048;
    private static final int CONTAINS_LETTERS = 4096;
    private static final int CONTAINS_UPPERCASE = 8192;
    private final int pattern;
    private final int digits;

    private StringPattern(int pattern, int digits) {
        this.pattern = pattern;
        this.digits = digits;
    }

    public static StringPattern recognize(String token) {
        int pattern = 126;
        int digits = 0;
        for (int i = 0; i < token.length(); ++i) {
            boolean isLetter;
            char ch = token.charAt(i);
            int letterType = Character.getType(ch);
            boolean bl = isLetter = letterType == 1 || letterType == 2 || letterType == 3 || letterType == 4 || letterType == 5;
            if (isLetter) {
                pattern |= 0x1000;
                pattern &= 0xFFFFFFEF;
                if (letterType == 1) {
                    if (i == 0) {
                        pattern |= 1;
                    }
                    pattern |= 0x2000;
                    pattern &= 0xFFFFFFFB;
                } else {
                    pattern &= 0xFFFFFFFD;
                }
            } else {
                pattern &= 0xFFFFFFF7;
                pattern &= 0xFFFFFFFD;
                pattern &= 0xFFFFFFFB;
                if (letterType == 9) {
                    pattern |= 0x400;
                    pattern &= 0xFFFFFF9F;
                    ++digits;
                } else {
                    pattern &= 0xFFFFFFEF;
                }
                switch (ch) {
                    case ',': {
                        pattern |= 0x100;
                        break;
                    }
                    case '.': {
                        pattern |= 0x80;
                        break;
                    }
                    case '/': {
                        pattern |= 0x200;
                        break;
                    }
                    case '-': {
                        pattern |= 0x800;
                        break;
                    }
                }
            }
            int codePoint = token.codePointAt(i);
            Character.UnicodeScript us = Character.UnicodeScript.of(codePoint);
            if (us != Character.UnicodeScript.COMMON) {
                if (us == Character.UnicodeScript.LATIN) {
                    pattern &= 0xFFFFFF9F;
                    continue;
                }
                if (us == Character.UnicodeScript.HAN) {
                    pattern &= 0xFFFFFF9B;
                    continue;
                }
                if (us == Character.UnicodeScript.HIRAGANA) {
                    pattern &= 0xFFFFFFBB;
                    continue;
                }
                if (us != Character.UnicodeScript.KATAKANA) continue;
                pattern &= 0xFFFFFFDB;
                continue;
            }
            if (ch == '\u30fb' || ch == '\u30fc' || ch == '\u301c') continue;
            pattern &= 0xFFFFFF9F;
        }
        return new StringPattern(pattern, digits);
    }

    public boolean isAllLetter() {
        return (this.pattern & 8) > 0;
    }

    public boolean isInitialCapitalLetter() {
        return (this.pattern & 1) > 0;
    }

    public boolean isAllCapitalLetter() {
        return (this.pattern & 2) > 0;
    }

    public boolean isAllLowerCaseLetter() {
        return (this.pattern & 4) > 0;
    }

    public boolean isAllDigit() {
        return (this.pattern & 0x10) > 0;
    }

    public boolean isAllHiragana() {
        return (this.pattern & 0x20) > 0;
    }

    public boolean isAllKatakana() {
        return (this.pattern & 0x40) > 0;
    }

    public int digits() {
        return this.digits;
    }

    public boolean containsPeriod() {
        return (this.pattern & 0x80) > 0;
    }

    public boolean containsComma() {
        return (this.pattern & 0x100) > 0;
    }

    public boolean containsSlash() {
        return (this.pattern & 0x200) > 0;
    }

    public boolean containsDigit() {
        return (this.pattern & 0x400) > 0;
    }

    public boolean containsHyphen() {
        return (this.pattern & 0x800) > 0;
    }

    public boolean containsLetters() {
        return (this.pattern & 0x1000) > 0;
    }
}

