%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "/lilypond-2.24.4/input/regression/other/grace-start-and-length.ly"
\sourcefileline 0
\version "2.23.4"

\header {
  texidoc = "This tests the calculation of music start and length for
various kinds of grace music.  Problems are reported on stderr."
}

\include "testing-functions.ily"
#(ly:set-option 'warning-as-error #t)
#(ly:expect-warning (G_ "skipping zero-duration score"))
#(ly:expect-warning (G_ "to suppress this, consider adding a spacer rest"))

\fixed c' <<

\testStartAndLength \grace \partial 1*0
#ZERO-MOMENT
#ZERO-MOMENT

\testStartAndLength \grace { \partial 1*0 }
#ZERO-MOMENT
#ZERO-MOMENT

\testStartAndLength \grace << \partial 1*0 >>
#ZERO-MOMENT
#ZERO-MOMENT

\testStartAndLength \grace \partial 8
#ZERO-MOMENT
#ZERO-MOMENT

\testStartAndLength \grace { \partial 8 }
#ZERO-MOMENT
#ZERO-MOMENT

\testStartAndLength \grace << \partial 8 >>
#ZERO-MOMENT
#ZERO-MOMENT

\testStartAndLength \grace r8
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace { r8 }
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace << r8 >>
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace s8
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace { s8 }
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace << s8 >>
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace \skip 8
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace { \skip 8 }
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace << \skip 8 >>
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace <d>8
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace { <d>8 }
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace { <d>8 q }
#(ly:make-moment 0 -1/4)
#ZERO-MOMENT

\testStartAndLength { \grace <d>8 q }
#(ly:make-moment 0 -1/8)
#(ly:make-moment 1/8)

\testStartAndLength \grace c8
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace { c8 }
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength \grace << c8 >>
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength { \grace c8 }
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength << \grace c8 >>
#(ly:make-moment 0 -1/8)
#ZERO-MOMENT

\testStartAndLength { \grace c8 c4 }
#(ly:make-moment 0 -1/8)
#(ly:make-moment 1/4)

\testStartAndLength << \grace c8 c4 >>
#(ly:make-moment 0 -1/8)
#(ly:make-moment 1/4)

\testStartAndLength \grace { c8 c4 }
#(ly:make-moment 0 -3/8)
#ZERO-MOMENT

\testStartAndLength \grace << c8 c4 >>
#(ly:make-moment 0 -1/4)
#ZERO-MOMENT

\testStartAndLength \grace \times 2/3 c4.
#(ly:make-moment 0 -1/4)
#ZERO-MOMENT

\testStartAndLength \times 2/3 \grace c4.
#(ly:make-moment 0 -1/4)
#ZERO-MOMENT

\testStartAndLength \tuplet 3/2 4 \grace c4.
#(ly:make-moment 0 -1/4)
#ZERO-MOMENT

\testStartAndLength \grace \tuplet 3/2 4 c4.
#(ly:make-moment 0 -1/4)
#ZERO-MOMENT

>>



% ****************************************************************
% end ly snippet
% ****************************************************************
