//autogenerated:yes
//nolint:revive,misspell,govet,lll
package ardupilotmega

// Send a secure command. Data should be signed with a private key corresponding with a public key known to the recipient. Signature should be over the concatenation of the sequence number (little-endian format), the operation (little-endian format) the data and the session key. For SECURE_COMMAND_GET_SESSION_KEY the session key should be zero length. The data array consists of the data followed by the signature. The sum of the data_length and the sig_length cannot be more than 220. The format of the data is command specific.
type MessageSecureCommand struct {
	// System ID.
	TargetSystem uint8
	// Component ID.
	TargetComponent uint8
	// Sequence ID for tagging reply.
	Sequence uint32
	// Operation being requested.
	Operation SECURE_COMMAND_OP `mavenum:"uint32"`
	// Data length.
	DataLength uint8
	// Signature length.
	SigLength uint8
	// Signed data.
	Data [220]uint8
}

// GetID implements the message.Message interface.
func (*MessageSecureCommand) GetID() uint32 {
	return 11004
}
