//autogenerated:yes
//nolint:revive,misspell,govet,lll
package asluav

// Send a command with up to seven parameters to the MAV and additional metadata
type MessageCommandLongStamped struct {
	// UTC time, seconds elapsed since 01.01.1970
	UtcTime uint32
	// Microseconds elapsed since vehicle boot
	VehicleTimestamp uint64
	// System which should execute the command
	TargetSystem uint8
	// Component which should execute the command, 0 for all components
	TargetComponent uint8
	// Command ID, as defined by MAV_CMD enum.
	Command MAV_CMD `mavenum:"uint16"`
	// 0: First transmission of this command. 1-255: Confirmation transmissions (e.g. for kill command)
	Confirmation uint8
	// Parameter 1, as defined by MAV_CMD enum.
	Param1 float32
	// Parameter 2, as defined by MAV_CMD enum.
	Param2 float32
	// Parameter 3, as defined by MAV_CMD enum.
	Param3 float32
	// Parameter 4, as defined by MAV_CMD enum.
	Param4 float32
	// Parameter 5, as defined by MAV_CMD enum.
	Param5 float32
	// Parameter 6, as defined by MAV_CMD enum.
	Param6 float32
	// Parameter 7, as defined by MAV_CMD enum.
	Param7 float32
}

// GetID implements the message.Message interface.
func (*MessageCommandLongStamped) GetID() uint32 {
	return 224
}
