//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Data for filling the OpenDroneID Self ID message. The Self ID Message is an opportunity for the operator to (optionally) declare their identity and purpose of the flight. This message can provide additional information that could reduce the threat profile of a UA (Unmanned Aircraft) flying in a particular area or manner. This message can also be used to provide optional additional clarification in an emergency/remote ID system failure situation.
type MessageOpenDroneIdSelfId struct {
	// System ID (0 for broadcast).
	TargetSystem uint8
	// Component ID (0 for broadcast).
	TargetComponent uint8
	// Only used for drone ID data received from other UAs. See detailed description at https://mavlink.io/en/services/opendroneid.html.
	IdOrMac [20]uint8
	// Indicates the type of the description field.
	DescriptionType MAV_ODID_DESC_TYPE `mavenum:"uint8"`
	// Text description or numeric value expressed as ASCII characters. Shall be filled with nulls in the unused portion of the field.
	Description string `mavlen:"23"`
}

// GetID implements the message.Message interface.
func (*MessageOpenDroneIdSelfId) GetID() uint32 {
	return 12903
}
