//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package ualberta

import (
	"fmt"
	"strconv"
)

// Mode currently commanded by pilot
type UALBERTA_PILOT_MODE uint64

const (
	PILOT_MANUAL UALBERTA_PILOT_MODE = 1
	PILOT_AUTO   UALBERTA_PILOT_MODE = 2
	// Rotomotion mode
	PILOT_ROTO UALBERTA_PILOT_MODE = 3
)

var value_to_label_UALBERTA_PILOT_MODE = map[UALBERTA_PILOT_MODE]string{
	PILOT_MANUAL: "PILOT_MANUAL",
	PILOT_AUTO:   "PILOT_AUTO",
	PILOT_ROTO:   "PILOT_ROTO",
}

var label_to_value_UALBERTA_PILOT_MODE = map[string]UALBERTA_PILOT_MODE{
	"PILOT_MANUAL": PILOT_MANUAL,
	"PILOT_AUTO":   PILOT_AUTO,
	"PILOT_ROTO":   PILOT_ROTO,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e UALBERTA_PILOT_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_UALBERTA_PILOT_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *UALBERTA_PILOT_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_UALBERTA_PILOT_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = UALBERTA_PILOT_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e UALBERTA_PILOT_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
