//autogenerated:yes
//nolint:revive,misspell,govet,lll
package development

// Global position measurement or estimate.
type MessageGlobalPosition struct {
	// Sensor ID
	Id uint8
	// Timestamp (UNIX Epoch time or time since system boot). The receiving end can infer timestamp format (since 1.1.1970 or since system boot) by checking for the magnitude of the number.
	TimeUsec uint64
	// Source of position/estimate (such as GNSS, estimator, etc.)
	Source GLOBAL_POSITION_SRC `mavenum:"uint8"`
	// Status flags
	Flags GLOBAL_POSITION_FLAGS `mavenum:"uint8"`
	// Latitude (WGS84)
	Lat int32
	// Longitude (WGS84)
	Lon int32
	// Altitude (MSL - position-system specific value)
	Alt float32
	// Altitude (WGS84 elipsoid)
	AltEllipsoid float32
	// Standard deviation of horizontal position error
	Eph float32
	// Standard deviation of vertical position error
	Epv float32
}

// GetID implements the message.Message interface.
func (*MessageGlobalPosition) GetID() uint32 {
	return 296
}
