//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package standard

import (
	"fmt"
	"strconv"
	"strings"
)

// Enum used to indicate true or false (also: success or failure, enabled or disabled, active or inactive).
type MAV_BOOL uint64

const (
	// False.
	MAV_BOOL_FALSE MAV_BOOL = 0
	// True.
	MAV_BOOL_TRUE MAV_BOOL = 1
)

var values_MAV_BOOL = []MAV_BOOL{
	MAV_BOOL_FALSE,
	MAV_BOOL_TRUE,
}

var value_to_label_MAV_BOOL = map[MAV_BOOL]string{
	MAV_BOOL_FALSE: "MAV_BOOL_FALSE",
	MAV_BOOL_TRUE:  "MAV_BOOL_TRUE",
}

var label_to_value_MAV_BOOL = map[string]MAV_BOOL{
	"MAV_BOOL_FALSE": MAV_BOOL_FALSE,
	"MAV_BOOL_TRUE":  MAV_BOOL_TRUE,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_BOOL) MarshalText() ([]byte, error) {
	if e == 0 {
		return []byte("0"), nil
	}
	var names []string
	for _, val := range values_MAV_BOOL {
		if e&val == val {
			names = append(names, value_to_label_MAV_BOOL[val])
		}
	}
	return []byte(strings.Join(names, " | ")), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_BOOL) UnmarshalText(text []byte) error {
	labels := strings.Split(string(text), " | ")
	var mask MAV_BOOL
	for _, label := range labels {
		if value, ok := label_to_value_MAV_BOOL[label]; ok {
			mask |= value
		} else if value, err := strconv.Atoi(label); err == nil {
			mask |= MAV_BOOL(value)
		} else {
			return fmt.Errorf("invalid label '%s'", label)
		}
	}
	*e = mask
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_BOOL) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
