// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/ai/generativelanguage/v1beta/prediction_service.proto

package generativelanguagepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for
// [PredictionService.Predict][google.ai.generativelanguage.v1beta.PredictionService.Predict].
type PredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the model for prediction.
	// Format: `name=models/{model}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The instances that are the input to the prediction call.
	Instances []*structpb.Value `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
	// Optional. The parameters that govern the prediction call.
	Parameters *structpb.Value `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *PredictRequest) Reset() {
	*x = PredictRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictRequest) ProtoMessage() {}

func (x *PredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictRequest.ProtoReflect.Descriptor instead.
func (*PredictRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP(), []int{0}
}

func (x *PredictRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *PredictRequest) GetInstances() []*structpb.Value {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *PredictRequest) GetParameters() *structpb.Value {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Request message for [PredictionService.PredictLongRunning].
type PredictLongRunningRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the model for prediction.
	// Format: `name=models/{model}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The instances that are the input to the prediction call.
	Instances []*structpb.Value `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
	// Optional. The parameters that govern the prediction call.
	Parameters *structpb.Value `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *PredictLongRunningRequest) Reset() {
	*x = PredictLongRunningRequest{}
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredictLongRunningRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictLongRunningRequest) ProtoMessage() {}

func (x *PredictLongRunningRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictLongRunningRequest.ProtoReflect.Descriptor instead.
func (*PredictLongRunningRequest) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP(), []int{1}
}

func (x *PredictLongRunningRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *PredictLongRunningRequest) GetInstances() []*structpb.Value {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *PredictLongRunningRequest) GetParameters() *structpb.Value {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Response message for [PredictionService.Predict].
type PredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The outputs of the prediction call.
	Predictions []*structpb.Value `protobuf:"bytes,1,rep,name=predictions,proto3" json:"predictions,omitempty"`
}

func (x *PredictResponse) Reset() {
	*x = PredictResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictResponse) ProtoMessage() {}

func (x *PredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictResponse.ProtoReflect.Descriptor instead.
func (*PredictResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP(), []int{2}
}

func (x *PredictResponse) GetPredictions() []*structpb.Value {
	if x != nil {
		return x.Predictions
	}
	return nil
}

// Response message for [PredictionService.PredictLongRunning]
type PredictLongRunningResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The response of the long running operation.
	//
	// Types that are assignable to Response:
	//
	//	*PredictLongRunningResponse_GenerateVideoResponse
	Response isPredictLongRunningResponse_Response `protobuf_oneof:"response"`
}

func (x *PredictLongRunningResponse) Reset() {
	*x = PredictLongRunningResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredictLongRunningResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictLongRunningResponse) ProtoMessage() {}

func (x *PredictLongRunningResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictLongRunningResponse.ProtoReflect.Descriptor instead.
func (*PredictLongRunningResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP(), []int{3}
}

func (m *PredictLongRunningResponse) GetResponse() isPredictLongRunningResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *PredictLongRunningResponse) GetGenerateVideoResponse() *GenerateVideoResponse {
	if x, ok := x.GetResponse().(*PredictLongRunningResponse_GenerateVideoResponse); ok {
		return x.GenerateVideoResponse
	}
	return nil
}

type isPredictLongRunningResponse_Response interface {
	isPredictLongRunningResponse_Response()
}

type PredictLongRunningResponse_GenerateVideoResponse struct {
	// The response of the video generation prediction.
	GenerateVideoResponse *GenerateVideoResponse `protobuf:"bytes,1,opt,name=generate_video_response,json=generateVideoResponse,proto3,oneof"`
}

func (*PredictLongRunningResponse_GenerateVideoResponse) isPredictLongRunningResponse_Response() {}

// Metadata for PredictLongRunning long running operations.
type PredictLongRunningMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PredictLongRunningMetadata) Reset() {
	*x = PredictLongRunningMetadata{}
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredictLongRunningMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictLongRunningMetadata) ProtoMessage() {}

func (x *PredictLongRunningMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictLongRunningMetadata.ProtoReflect.Descriptor instead.
func (*PredictLongRunningMetadata) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP(), []int{4}
}

// A proto encapsulate various type of media.
type Media struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of media.
	//
	// Types that are assignable to Type:
	//
	//	*Media_Video
	Type isMedia_Type `protobuf_oneof:"type"`
}

func (x *Media) Reset() {
	*x = Media{}
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Media) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Media) ProtoMessage() {}

func (x *Media) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Media.ProtoReflect.Descriptor instead.
func (*Media) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP(), []int{5}
}

func (m *Media) GetType() isMedia_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *Media) GetVideo() *Video {
	if x, ok := x.GetType().(*Media_Video); ok {
		return x.Video
	}
	return nil
}

type isMedia_Type interface {
	isMedia_Type()
}

type Media_Video struct {
	// Video as the only one for now.  This is mimicking Vertex proto.
	Video *Video `protobuf:"bytes,1,opt,name=video,proto3,oneof"`
}

func (*Media_Video) isMedia_Type() {}

// Representation of a video.
type Video struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Where the video content is.
	//
	// Types that are assignable to Content:
	//
	//	*Video_Video
	//	*Video_Uri
	Content isVideo_Content `protobuf_oneof:"content"`
}

func (x *Video) Reset() {
	*x = Video{}
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Video) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Video) ProtoMessage() {}

func (x *Video) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Video.ProtoReflect.Descriptor instead.
func (*Video) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP(), []int{6}
}

func (m *Video) GetContent() isVideo_Content {
	if m != nil {
		return m.Content
	}
	return nil
}

func (x *Video) GetVideo() []byte {
	if x, ok := x.GetContent().(*Video_Video); ok {
		return x.Video
	}
	return nil
}

func (x *Video) GetUri() string {
	if x, ok := x.GetContent().(*Video_Uri); ok {
		return x.Uri
	}
	return ""
}

type isVideo_Content interface {
	isVideo_Content()
}

type Video_Video struct {
	// Raw bytes.
	Video []byte `protobuf:"bytes,1,opt,name=video,proto3,oneof"`
}

type Video_Uri struct {
	// Path to another storage.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3,oneof"`
}

func (*Video_Video) isVideo_Content() {}

func (*Video_Uri) isVideo_Content() {}

// Veo response.
type GenerateVideoResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The generated samples.
	GeneratedSamples []*Media `protobuf:"bytes,1,rep,name=generated_samples,json=generatedSamples,proto3" json:"generated_samples,omitempty"`
	// Returns if any videos were filtered due to RAI policies.
	RaiMediaFilteredCount int32 `protobuf:"varint,2,opt,name=rai_media_filtered_count,json=raiMediaFilteredCount,proto3" json:"rai_media_filtered_count,omitempty"`
	// Returns rai failure reasons if any.
	RaiMediaFilteredReasons []string `protobuf:"bytes,3,rep,name=rai_media_filtered_reasons,json=raiMediaFilteredReasons,proto3" json:"rai_media_filtered_reasons,omitempty"`
}

func (x *GenerateVideoResponse) Reset() {
	*x = GenerateVideoResponse{}
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateVideoResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateVideoResponse) ProtoMessage() {}

func (x *GenerateVideoResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateVideoResponse.ProtoReflect.Descriptor instead.
func (*GenerateVideoResponse) Descriptor() ([]byte, []int) {
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP(), []int{7}
}

func (x *GenerateVideoResponse) GetGeneratedSamples() []*Media {
	if x != nil {
		return x.GeneratedSamples
	}
	return nil
}

func (x *GenerateVideoResponse) GetRaiMediaFilteredCount() int32 {
	if x != nil {
		return x.RaiMediaFilteredCount
	}
	return 0
}

func (x *GenerateVideoResponse) GetRaiMediaFilteredReasons() []string {
	if x != nil {
		return x.RaiMediaFilteredReasons
	}
	return nil
}

var File_google_ai_generativelanguage_v1beta_prediction_service_proto protoreflect.FileDescriptor

var file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x69, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcf, 0x01, 0x0a, 0x0e, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x05,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x39, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3b,
	0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xda, 0x01, 0x0a, 0x19,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x0a, 0x27, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x39, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x4b, 0x0a, 0x0f, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0x9e, 0x01, 0x0a, 0x1a, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x74, 0x0a, 0x17, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65,
	0x5f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x48, 0x00, 0x52, 0x15, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1c, 0x0a, 0x1a, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x53, 0x0a, 0x05, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x12, 0x42, 0x0a,
	0x05, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x48, 0x00, 0x52, 0x05, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0x3e, 0x0a, 0x05, 0x56, 0x69, 0x64,
	0x65, 0x6f, 0x12, 0x16, 0x0a, 0x05, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x48, 0x00, 0x52, 0x05, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x12, 0x12, 0x0a, 0x03, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x42, 0x09,
	0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0xe6, 0x01, 0x0a, 0x15, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x57, 0x0a, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x64, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x18,
	0x72, 0x61, 0x69, 0x5f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x65, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x15,
	0x72, 0x61, 0x69, 0x4d, 0x65, 0x64, 0x69, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x1a, 0x72, 0x61, 0x69, 0x5f, 0x6d, 0x65, 0x64,
	0x69, 0x61, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x17, 0x72, 0x61, 0x69, 0x4d, 0x65,
	0x64, 0x69, 0x61, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x73, 0x32, 0xeb, 0x03, 0x0a, 0x11, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xb3, 0x01, 0x0a, 0x07, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x69,
	0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3d, 0xda, 0x41, 0x0f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x3a, 0x01, 0x2a, 0x22, 0x20, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0xf9,
	0x01, 0x0a, 0x12, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0xca, 0x41, 0x38, 0x0a, 0x1a, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x4c, 0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x1a, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4c,
	0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x0f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x30, 0x3a, 0x01, 0x2a, 0x22, 0x2b, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x4c,
	0x6f, 0x6e, 0x67, 0x52, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x1a, 0x24, 0xca, 0x41, 0x21, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x42, 0xa2, 0x01, 0x0a, 0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x69, 0x2e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x16, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x5d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x2f, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x70, 0x62,
	0x3b, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescOnce sync.Once
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescData = file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDesc
)

func file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescGZIP() []byte {
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescOnce.Do(func() {
		file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescData)
	})
	return file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDescData
}

var file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_ai_generativelanguage_v1beta_prediction_service_proto_goTypes = []any{
	(*PredictRequest)(nil),             // 0: google.ai.generativelanguage.v1beta.PredictRequest
	(*PredictLongRunningRequest)(nil),  // 1: google.ai.generativelanguage.v1beta.PredictLongRunningRequest
	(*PredictResponse)(nil),            // 2: google.ai.generativelanguage.v1beta.PredictResponse
	(*PredictLongRunningResponse)(nil), // 3: google.ai.generativelanguage.v1beta.PredictLongRunningResponse
	(*PredictLongRunningMetadata)(nil), // 4: google.ai.generativelanguage.v1beta.PredictLongRunningMetadata
	(*Media)(nil),                      // 5: google.ai.generativelanguage.v1beta.Media
	(*Video)(nil),                      // 6: google.ai.generativelanguage.v1beta.Video
	(*GenerateVideoResponse)(nil),      // 7: google.ai.generativelanguage.v1beta.GenerateVideoResponse
	(*structpb.Value)(nil),             // 8: google.protobuf.Value
	(*longrunningpb.Operation)(nil),    // 9: google.longrunning.Operation
}
var file_google_ai_generativelanguage_v1beta_prediction_service_proto_depIdxs = []int32{
	8,  // 0: google.ai.generativelanguage.v1beta.PredictRequest.instances:type_name -> google.protobuf.Value
	8,  // 1: google.ai.generativelanguage.v1beta.PredictRequest.parameters:type_name -> google.protobuf.Value
	8,  // 2: google.ai.generativelanguage.v1beta.PredictLongRunningRequest.instances:type_name -> google.protobuf.Value
	8,  // 3: google.ai.generativelanguage.v1beta.PredictLongRunningRequest.parameters:type_name -> google.protobuf.Value
	8,  // 4: google.ai.generativelanguage.v1beta.PredictResponse.predictions:type_name -> google.protobuf.Value
	7,  // 5: google.ai.generativelanguage.v1beta.PredictLongRunningResponse.generate_video_response:type_name -> google.ai.generativelanguage.v1beta.GenerateVideoResponse
	6,  // 6: google.ai.generativelanguage.v1beta.Media.video:type_name -> google.ai.generativelanguage.v1beta.Video
	5,  // 7: google.ai.generativelanguage.v1beta.GenerateVideoResponse.generated_samples:type_name -> google.ai.generativelanguage.v1beta.Media
	0,  // 8: google.ai.generativelanguage.v1beta.PredictionService.Predict:input_type -> google.ai.generativelanguage.v1beta.PredictRequest
	1,  // 9: google.ai.generativelanguage.v1beta.PredictionService.PredictLongRunning:input_type -> google.ai.generativelanguage.v1beta.PredictLongRunningRequest
	2,  // 10: google.ai.generativelanguage.v1beta.PredictionService.Predict:output_type -> google.ai.generativelanguage.v1beta.PredictResponse
	9,  // 11: google.ai.generativelanguage.v1beta.PredictionService.PredictLongRunning:output_type -> google.longrunning.Operation
	10, // [10:12] is the sub-list for method output_type
	8,  // [8:10] is the sub-list for method input_type
	8,  // [8:8] is the sub-list for extension type_name
	8,  // [8:8] is the sub-list for extension extendee
	0,  // [0:8] is the sub-list for field type_name
}

func init() { file_google_ai_generativelanguage_v1beta_prediction_service_proto_init() }
func file_google_ai_generativelanguage_v1beta_prediction_service_proto_init() {
	if File_google_ai_generativelanguage_v1beta_prediction_service_proto != nil {
		return
	}
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[3].OneofWrappers = []any{
		(*PredictLongRunningResponse_GenerateVideoResponse)(nil),
	}
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[5].OneofWrappers = []any{
		(*Media_Video)(nil),
	}
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes[6].OneofWrappers = []any{
		(*Video_Video)(nil),
		(*Video_Uri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_ai_generativelanguage_v1beta_prediction_service_proto_goTypes,
		DependencyIndexes: file_google_ai_generativelanguage_v1beta_prediction_service_proto_depIdxs,
		MessageInfos:      file_google_ai_generativelanguage_v1beta_prediction_service_proto_msgTypes,
	}.Build()
	File_google_ai_generativelanguage_v1beta_prediction_service_proto = out.File
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_rawDesc = nil
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_goTypes = nil
	file_google_ai_generativelanguage_v1beta_prediction_service_proto_depIdxs = nil
}
