// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/documentai/v1/document.proto

package documentaipb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	color "google.golang.org/genproto/googleapis/type/color"
	date "google.golang.org/genproto/googleapis/type/date"
	datetime "google.golang.org/genproto/googleapis/type/datetime"
	money "google.golang.org/genproto/googleapis/type/money"
	postaladdress "google.golang.org/genproto/googleapis/type/postaladdress"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Detected human reading orientation.
type Document_Page_Layout_Orientation int32

const (
	// Unspecified orientation.
	Document_Page_Layout_ORIENTATION_UNSPECIFIED Document_Page_Layout_Orientation = 0
	// Orientation is aligned with page up.
	Document_Page_Layout_PAGE_UP Document_Page_Layout_Orientation = 1
	// Orientation is aligned with page right.
	// Turn the head 90 degrees clockwise from upright to read.
	Document_Page_Layout_PAGE_RIGHT Document_Page_Layout_Orientation = 2
	// Orientation is aligned with page down.
	// Turn the head 180 degrees from upright to read.
	Document_Page_Layout_PAGE_DOWN Document_Page_Layout_Orientation = 3
	// Orientation is aligned with page left.
	// Turn the head 90 degrees counterclockwise from upright to read.
	Document_Page_Layout_PAGE_LEFT Document_Page_Layout_Orientation = 4
)

// Enum value maps for Document_Page_Layout_Orientation.
var (
	Document_Page_Layout_Orientation_name = map[int32]string{
		0: "ORIENTATION_UNSPECIFIED",
		1: "PAGE_UP",
		2: "PAGE_RIGHT",
		3: "PAGE_DOWN",
		4: "PAGE_LEFT",
	}
	Document_Page_Layout_Orientation_value = map[string]int32{
		"ORIENTATION_UNSPECIFIED": 0,
		"PAGE_UP":                 1,
		"PAGE_RIGHT":              2,
		"PAGE_DOWN":               3,
		"PAGE_LEFT":               4,
	}
)

func (x Document_Page_Layout_Orientation) Enum() *Document_Page_Layout_Orientation {
	p := new(Document_Page_Layout_Orientation)
	*p = x
	return p
}

func (x Document_Page_Layout_Orientation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_Page_Layout_Orientation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_proto_enumTypes[0].Descriptor()
}

func (Document_Page_Layout_Orientation) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_proto_enumTypes[0]
}

func (x Document_Page_Layout_Orientation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Document_Page_Layout_Orientation.Descriptor instead.
func (Document_Page_Layout_Orientation) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 3, 0}
}

// Enum to denote the type of break found.
type Document_Page_Token_DetectedBreak_Type int32

const (
	// Unspecified break type.
	Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED Document_Page_Token_DetectedBreak_Type = 0
	// A single whitespace.
	Document_Page_Token_DetectedBreak_SPACE Document_Page_Token_DetectedBreak_Type = 1
	// A wider whitespace.
	Document_Page_Token_DetectedBreak_WIDE_SPACE Document_Page_Token_DetectedBreak_Type = 2
	// A hyphen that indicates that a token has been split across lines.
	Document_Page_Token_DetectedBreak_HYPHEN Document_Page_Token_DetectedBreak_Type = 3
)

// Enum value maps for Document_Page_Token_DetectedBreak_Type.
var (
	Document_Page_Token_DetectedBreak_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "SPACE",
		2: "WIDE_SPACE",
		3: "HYPHEN",
	}
	Document_Page_Token_DetectedBreak_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"SPACE":            1,
		"WIDE_SPACE":       2,
		"HYPHEN":           3,
	}
)

func (x Document_Page_Token_DetectedBreak_Type) Enum() *Document_Page_Token_DetectedBreak_Type {
	p := new(Document_Page_Token_DetectedBreak_Type)
	*p = x
	return p
}

func (x Document_Page_Token_DetectedBreak_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_Page_Token_DetectedBreak_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_proto_enumTypes[1].Descriptor()
}

func (Document_Page_Token_DetectedBreak_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_proto_enumTypes[1]
}

func (x Document_Page_Token_DetectedBreak_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Document_Page_Token_DetectedBreak_Type.Descriptor instead.
func (Document_Page_Token_DetectedBreak_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 7, 0, 0}
}

// The type of layout that is being referenced.
type Document_PageAnchor_PageRef_LayoutType int32

const (
	// Layout Unspecified.
	Document_PageAnchor_PageRef_LAYOUT_TYPE_UNSPECIFIED Document_PageAnchor_PageRef_LayoutType = 0
	// References a
	// [Page.blocks][google.cloud.documentai.v1.Document.Page.blocks]
	// element.
	Document_PageAnchor_PageRef_BLOCK Document_PageAnchor_PageRef_LayoutType = 1
	// References a
	// [Page.paragraphs][google.cloud.documentai.v1.Document.Page.paragraphs]
	// element.
	Document_PageAnchor_PageRef_PARAGRAPH Document_PageAnchor_PageRef_LayoutType = 2
	// References a
	// [Page.lines][google.cloud.documentai.v1.Document.Page.lines] element.
	Document_PageAnchor_PageRef_LINE Document_PageAnchor_PageRef_LayoutType = 3
	// References a
	// [Page.tokens][google.cloud.documentai.v1.Document.Page.tokens]
	// element.
	Document_PageAnchor_PageRef_TOKEN Document_PageAnchor_PageRef_LayoutType = 4
	// References a
	// [Page.visual_elements][google.cloud.documentai.v1.Document.Page.visual_elements]
	// element.
	Document_PageAnchor_PageRef_VISUAL_ELEMENT Document_PageAnchor_PageRef_LayoutType = 5
	// Refrrences a
	// [Page.tables][google.cloud.documentai.v1.Document.Page.tables]
	// element.
	Document_PageAnchor_PageRef_TABLE Document_PageAnchor_PageRef_LayoutType = 6
	// References a
	// [Page.form_fields][google.cloud.documentai.v1.Document.Page.form_fields]
	// element.
	Document_PageAnchor_PageRef_FORM_FIELD Document_PageAnchor_PageRef_LayoutType = 7
)

// Enum value maps for Document_PageAnchor_PageRef_LayoutType.
var (
	Document_PageAnchor_PageRef_LayoutType_name = map[int32]string{
		0: "LAYOUT_TYPE_UNSPECIFIED",
		1: "BLOCK",
		2: "PARAGRAPH",
		3: "LINE",
		4: "TOKEN",
		5: "VISUAL_ELEMENT",
		6: "TABLE",
		7: "FORM_FIELD",
	}
	Document_PageAnchor_PageRef_LayoutType_value = map[string]int32{
		"LAYOUT_TYPE_UNSPECIFIED": 0,
		"BLOCK":                   1,
		"PARAGRAPH":               2,
		"LINE":                    3,
		"TOKEN":                   4,
		"VISUAL_ELEMENT":          5,
		"TABLE":                   6,
		"FORM_FIELD":              7,
	}
)

func (x Document_PageAnchor_PageRef_LayoutType) Enum() *Document_PageAnchor_PageRef_LayoutType {
	p := new(Document_PageAnchor_PageRef_LayoutType)
	*p = x
	return p
}

func (x Document_PageAnchor_PageRef_LayoutType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_PageAnchor_PageRef_LayoutType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_proto_enumTypes[2].Descriptor()
}

func (Document_PageAnchor_PageRef_LayoutType) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_proto_enumTypes[2]
}

func (x Document_PageAnchor_PageRef_LayoutType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Document_PageAnchor_PageRef_LayoutType.Descriptor instead.
func (Document_PageAnchor_PageRef_LayoutType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 6, 0, 0}
}

// If a processor or agent does an explicit operation on existing elements.
type Document_Provenance_OperationType int32

const (
	// Operation type unspecified. If no operation is specified a provenance
	// entry is simply used to match against a `parent`.
	Document_Provenance_OPERATION_TYPE_UNSPECIFIED Document_Provenance_OperationType = 0
	// Add an element.
	Document_Provenance_ADD Document_Provenance_OperationType = 1
	// Remove an element identified by `parent`.
	Document_Provenance_REMOVE Document_Provenance_OperationType = 2
	// Updates any fields within the given provenance scope of the message. It
	// overwrites the fields rather than replacing them.  Use this when you
	// want to update a field value of an entity without also updating all the
	// child properties.
	Document_Provenance_UPDATE Document_Provenance_OperationType = 7
	// Currently unused. Replace an element identified by `parent`.
	Document_Provenance_REPLACE Document_Provenance_OperationType = 3
	// Deprecated. Request human review for the element identified by
	// `parent`.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Document_Provenance_EVAL_REQUESTED Document_Provenance_OperationType = 4
	// Deprecated. Element is reviewed and approved at human review,
	// confidence will be set to 1.0.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Document_Provenance_EVAL_APPROVED Document_Provenance_OperationType = 5
	// Deprecated. Element is skipped in the validation process.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Document_Provenance_EVAL_SKIPPED Document_Provenance_OperationType = 6
)

// Enum value maps for Document_Provenance_OperationType.
var (
	Document_Provenance_OperationType_name = map[int32]string{
		0: "OPERATION_TYPE_UNSPECIFIED",
		1: "ADD",
		2: "REMOVE",
		7: "UPDATE",
		3: "REPLACE",
		4: "EVAL_REQUESTED",
		5: "EVAL_APPROVED",
		6: "EVAL_SKIPPED",
	}
	Document_Provenance_OperationType_value = map[string]int32{
		"OPERATION_TYPE_UNSPECIFIED": 0,
		"ADD":                        1,
		"REMOVE":                     2,
		"UPDATE":                     7,
		"REPLACE":                    3,
		"EVAL_REQUESTED":             4,
		"EVAL_APPROVED":              5,
		"EVAL_SKIPPED":               6,
	}
)

func (x Document_Provenance_OperationType) Enum() *Document_Provenance_OperationType {
	p := new(Document_Provenance_OperationType)
	*p = x
	return p
}

func (x Document_Provenance_OperationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Document_Provenance_OperationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1_document_proto_enumTypes[3].Descriptor()
}

func (Document_Provenance_OperationType) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1_document_proto_enumTypes[3]
}

func (x Document_Provenance_OperationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Document_Provenance_OperationType.Descriptor instead.
func (Document_Provenance_OperationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 7, 0}
}

// Document represents the canonical document resource in Document AI. It is an
// interchange format that provides insights into documents and allows for
// collaboration between users and Document AI to iterate and optimize for
// quality.
type Document struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Original source document from the user.
	//
	// Types that are assignable to Source:
	//	*Document_Uri
	//	*Document_Content
	Source isDocument_Source `protobuf_oneof:"source"`
	// An IANA published [media type (MIME
	// type)](https://www.iana.org/assignments/media-types/media-types.xhtml).
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Optional. UTF-8 encoded text in reading order from the document.
	Text string `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
	// Styles for the [Document.text][google.cloud.documentai.v1.Document.text].
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	TextStyles []*Document_Style `protobuf:"bytes,5,rep,name=text_styles,json=textStyles,proto3" json:"text_styles,omitempty"`
	// Visual page layout for the [Document][google.cloud.documentai.v1.Document].
	Pages []*Document_Page `protobuf:"bytes,6,rep,name=pages,proto3" json:"pages,omitempty"`
	// A list of entities detected on
	// [Document.text][google.cloud.documentai.v1.Document.text]. For document
	// shards, entities in this list may cross shard boundaries.
	Entities []*Document_Entity `protobuf:"bytes,7,rep,name=entities,proto3" json:"entities,omitempty"`
	// Placeholder.  Relationship among
	// [Document.entities][google.cloud.documentai.v1.Document.entities].
	EntityRelations []*Document_EntityRelation `protobuf:"bytes,8,rep,name=entity_relations,json=entityRelations,proto3" json:"entity_relations,omitempty"`
	// Placeholder.  A list of text corrections made to
	// [Document.text][google.cloud.documentai.v1.Document.text].  This is usually
	// used for annotating corrections to OCR mistakes.  Text changes for a given
	// revision may not overlap with each other.
	TextChanges []*Document_TextChange `protobuf:"bytes,14,rep,name=text_changes,json=textChanges,proto3" json:"text_changes,omitempty"`
	// Information about the sharding if this document is sharded part of a larger
	// document. If the document is not sharded, this message is not specified.
	ShardInfo *Document_ShardInfo `protobuf:"bytes,9,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
	// Any error that occurred while processing this document.
	Error *status.Status `protobuf:"bytes,10,opt,name=error,proto3" json:"error,omitempty"`
	// Placeholder. Revision history of this document.
	Revisions []*Document_Revision `protobuf:"bytes,13,rep,name=revisions,proto3" json:"revisions,omitempty"`
}

func (x *Document) Reset() {
	*x = Document{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document) ProtoMessage() {}

func (x *Document) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document.ProtoReflect.Descriptor instead.
func (*Document) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0}
}

func (m *Document) GetSource() isDocument_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Document) GetUri() string {
	if x, ok := x.GetSource().(*Document_Uri); ok {
		return x.Uri
	}
	return ""
}

func (x *Document) GetContent() []byte {
	if x, ok := x.GetSource().(*Document_Content); ok {
		return x.Content
	}
	return nil
}

func (x *Document) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *Document) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document) GetTextStyles() []*Document_Style {
	if x != nil {
		return x.TextStyles
	}
	return nil
}

func (x *Document) GetPages() []*Document_Page {
	if x != nil {
		return x.Pages
	}
	return nil
}

func (x *Document) GetEntities() []*Document_Entity {
	if x != nil {
		return x.Entities
	}
	return nil
}

func (x *Document) GetEntityRelations() []*Document_EntityRelation {
	if x != nil {
		return x.EntityRelations
	}
	return nil
}

func (x *Document) GetTextChanges() []*Document_TextChange {
	if x != nil {
		return x.TextChanges
	}
	return nil
}

func (x *Document) GetShardInfo() *Document_ShardInfo {
	if x != nil {
		return x.ShardInfo
	}
	return nil
}

func (x *Document) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *Document) GetRevisions() []*Document_Revision {
	if x != nil {
		return x.Revisions
	}
	return nil
}

type isDocument_Source interface {
	isDocument_Source()
}

type Document_Uri struct {
	// Optional. Currently supports Google Cloud Storage URI of the form
	// `gs://bucket_name/object_name`. Object versioning is not supported.
	// For more information, refer to [Google Cloud Storage Request
	// URIs](https://cloud.google.com/storage/docs/reference-uris).
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type Document_Content struct {
	// Optional. Inline document content, represented as a stream of bytes.
	// Note: As with all `bytes` fields, protobuffers use a pure binary
	// representation, whereas JSON representations use base64.
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

func (*Document_Uri) isDocument_Source() {}

func (*Document_Content) isDocument_Source() {}

// For a large document, sharding may be performed to produce several
// document shards. Each document shard contains this field to detail which
// shard it is.
type Document_ShardInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The 0-based index of this shard.
	ShardIndex int64 `protobuf:"varint,1,opt,name=shard_index,json=shardIndex,proto3" json:"shard_index,omitempty"`
	// Total number of shards.
	ShardCount int64 `protobuf:"varint,2,opt,name=shard_count,json=shardCount,proto3" json:"shard_count,omitempty"`
	// The index of the first character in
	// [Document.text][google.cloud.documentai.v1.Document.text] in the overall
	// document global text.
	TextOffset int64 `protobuf:"varint,3,opt,name=text_offset,json=textOffset,proto3" json:"text_offset,omitempty"`
}

func (x *Document_ShardInfo) Reset() {
	*x = Document_ShardInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_ShardInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_ShardInfo) ProtoMessage() {}

func (x *Document_ShardInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_ShardInfo.ProtoReflect.Descriptor instead.
func (*Document_ShardInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Document_ShardInfo) GetShardIndex() int64 {
	if x != nil {
		return x.ShardIndex
	}
	return 0
}

func (x *Document_ShardInfo) GetShardCount() int64 {
	if x != nil {
		return x.ShardCount
	}
	return 0
}

func (x *Document_ShardInfo) GetTextOffset() int64 {
	if x != nil {
		return x.TextOffset
	}
	return 0
}

// Annotation for common text style attributes. This adheres to CSS
// conventions as much as possible.
type Document_Style struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Text color.
	Color *color.Color `protobuf:"bytes,2,opt,name=color,proto3" json:"color,omitempty"`
	// Text background color.
	BackgroundColor *color.Color `protobuf:"bytes,3,opt,name=background_color,json=backgroundColor,proto3" json:"background_color,omitempty"`
	// [Font weight](https://www.w3schools.com/cssref/pr_font_weight.asp).
	// Possible values are `normal`, `bold`, `bolder`, and `lighter`.
	FontWeight string `protobuf:"bytes,4,opt,name=font_weight,json=fontWeight,proto3" json:"font_weight,omitempty"`
	// [Text style](https://www.w3schools.com/cssref/pr_font_font-style.asp).
	// Possible values are `normal`, `italic`, and `oblique`.
	TextStyle string `protobuf:"bytes,5,opt,name=text_style,json=textStyle,proto3" json:"text_style,omitempty"`
	// [Text
	// decoration](https://www.w3schools.com/cssref/pr_text_text-decoration.asp).
	// Follows CSS standard. <text-decoration-line> <text-decoration-color>
	// <text-decoration-style>
	TextDecoration string `protobuf:"bytes,6,opt,name=text_decoration,json=textDecoration,proto3" json:"text_decoration,omitempty"`
	// Font size.
	FontSize *Document_Style_FontSize `protobuf:"bytes,7,opt,name=font_size,json=fontSize,proto3" json:"font_size,omitempty"`
	// Font family such as `Arial`, `Times New Roman`.
	// https://www.w3schools.com/cssref/pr_font_font-family.asp
	FontFamily string `protobuf:"bytes,8,opt,name=font_family,json=fontFamily,proto3" json:"font_family,omitempty"`
}

func (x *Document_Style) Reset() {
	*x = Document_Style{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Style) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Style) ProtoMessage() {}

func (x *Document_Style) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Style.ProtoReflect.Descriptor instead.
func (*Document_Style) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Document_Style) GetTextAnchor() *Document_TextAnchor {
	if x != nil {
		return x.TextAnchor
	}
	return nil
}

func (x *Document_Style) GetColor() *color.Color {
	if x != nil {
		return x.Color
	}
	return nil
}

func (x *Document_Style) GetBackgroundColor() *color.Color {
	if x != nil {
		return x.BackgroundColor
	}
	return nil
}

func (x *Document_Style) GetFontWeight() string {
	if x != nil {
		return x.FontWeight
	}
	return ""
}

func (x *Document_Style) GetTextStyle() string {
	if x != nil {
		return x.TextStyle
	}
	return ""
}

func (x *Document_Style) GetTextDecoration() string {
	if x != nil {
		return x.TextDecoration
	}
	return ""
}

func (x *Document_Style) GetFontSize() *Document_Style_FontSize {
	if x != nil {
		return x.FontSize
	}
	return nil
}

func (x *Document_Style) GetFontFamily() string {
	if x != nil {
		return x.FontFamily
	}
	return ""
}

// A page in a [Document][google.cloud.documentai.v1.Document].
type Document_Page struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// 1-based index for current
	// [Page][google.cloud.documentai.v1.Document.Page] in a parent
	// [Document][google.cloud.documentai.v1.Document]. Useful when a page is
	// taken out of a [Document][google.cloud.documentai.v1.Document] for
	// individual processing.
	PageNumber int32 `protobuf:"varint,1,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
	// Rendered image for this page. This image is preprocessed to remove any
	// skew, rotation, and distortions such that the annotation bounding boxes
	// can be upright and axis-aligned.
	Image *Document_Page_Image `protobuf:"bytes,13,opt,name=image,proto3" json:"image,omitempty"`
	// Transformation matrices that were applied to the original document image
	// to produce [Page.image][google.cloud.documentai.v1.Document.Page.image].
	Transforms []*Document_Page_Matrix `protobuf:"bytes,14,rep,name=transforms,proto3" json:"transforms,omitempty"`
	// Physical dimension of the page.
	Dimension *Document_Page_Dimension `protobuf:"bytes,2,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for the page.
	Layout *Document_Page_Layout `protobuf:"bytes,3,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// A list of visually detected text blocks on the page.
	// A block has a set of lines (collected into paragraphs) that have a common
	// line-spacing and orientation.
	Blocks []*Document_Page_Block `protobuf:"bytes,5,rep,name=blocks,proto3" json:"blocks,omitempty"`
	// A list of visually detected text paragraphs on the page.
	// A collection of lines that a human would perceive as a paragraph.
	Paragraphs []*Document_Page_Paragraph `protobuf:"bytes,6,rep,name=paragraphs,proto3" json:"paragraphs,omitempty"`
	// A list of visually detected text lines on the page.
	// A collection of tokens that a human would perceive as a line.
	Lines []*Document_Page_Line `protobuf:"bytes,7,rep,name=lines,proto3" json:"lines,omitempty"`
	// A list of visually detected tokens on the page.
	Tokens []*Document_Page_Token `protobuf:"bytes,8,rep,name=tokens,proto3" json:"tokens,omitempty"`
	// A list of detected non-text visual elements e.g. checkbox,
	// signature etc. on the page.
	VisualElements []*Document_Page_VisualElement `protobuf:"bytes,9,rep,name=visual_elements,json=visualElements,proto3" json:"visual_elements,omitempty"`
	// A list of visually detected tables on the page.
	Tables []*Document_Page_Table `protobuf:"bytes,10,rep,name=tables,proto3" json:"tables,omitempty"`
	// A list of visually detected form fields on the page.
	FormFields []*Document_Page_FormField `protobuf:"bytes,11,rep,name=form_fields,json=formFields,proto3" json:"form_fields,omitempty"`
	// A list of visually detected symbols on the page.
	Symbols []*Document_Page_Symbol `protobuf:"bytes,12,rep,name=symbols,proto3" json:"symbols,omitempty"`
	// A list of detected barcodes.
	DetectedBarcodes []*Document_Page_DetectedBarcode `protobuf:"bytes,15,rep,name=detected_barcodes,json=detectedBarcodes,proto3" json:"detected_barcodes,omitempty"`
	// Image quality scores.
	ImageQualityScores *Document_Page_ImageQualityScores `protobuf:"bytes,17,opt,name=image_quality_scores,json=imageQualityScores,proto3" json:"image_quality_scores,omitempty"`
	// The history of this page.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Provenance *Document_Provenance `protobuf:"bytes,16,opt,name=provenance,proto3" json:"provenance,omitempty"`
}

func (x *Document_Page) Reset() {
	*x = Document_Page{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page) ProtoMessage() {}

func (x *Document_Page) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page.ProtoReflect.Descriptor instead.
func (*Document_Page) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Document_Page) GetPageNumber() int32 {
	if x != nil {
		return x.PageNumber
	}
	return 0
}

func (x *Document_Page) GetImage() *Document_Page_Image {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *Document_Page) GetTransforms() []*Document_Page_Matrix {
	if x != nil {
		return x.Transforms
	}
	return nil
}

func (x *Document_Page) GetDimension() *Document_Page_Dimension {
	if x != nil {
		return x.Dimension
	}
	return nil
}

func (x *Document_Page) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

func (x *Document_Page) GetBlocks() []*Document_Page_Block {
	if x != nil {
		return x.Blocks
	}
	return nil
}

func (x *Document_Page) GetParagraphs() []*Document_Page_Paragraph {
	if x != nil {
		return x.Paragraphs
	}
	return nil
}

func (x *Document_Page) GetLines() []*Document_Page_Line {
	if x != nil {
		return x.Lines
	}
	return nil
}

func (x *Document_Page) GetTokens() []*Document_Page_Token {
	if x != nil {
		return x.Tokens
	}
	return nil
}

func (x *Document_Page) GetVisualElements() []*Document_Page_VisualElement {
	if x != nil {
		return x.VisualElements
	}
	return nil
}

func (x *Document_Page) GetTables() []*Document_Page_Table {
	if x != nil {
		return x.Tables
	}
	return nil
}

func (x *Document_Page) GetFormFields() []*Document_Page_FormField {
	if x != nil {
		return x.FormFields
	}
	return nil
}

func (x *Document_Page) GetSymbols() []*Document_Page_Symbol {
	if x != nil {
		return x.Symbols
	}
	return nil
}

func (x *Document_Page) GetDetectedBarcodes() []*Document_Page_DetectedBarcode {
	if x != nil {
		return x.DetectedBarcodes
	}
	return nil
}

func (x *Document_Page) GetImageQualityScores() *Document_Page_ImageQualityScores {
	if x != nil {
		return x.ImageQualityScores
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Page) GetProvenance() *Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

// An entity that could be a phrase in the text or a property that belongs to
// the document. It is a known entity type, such as a person, an organization,
// or location.
type Document_Entity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Provenance of the entity.
	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Required. Entity type from a schema e.g. `Address`.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Optional. Text value of the entity e.g. `1600 Amphitheatre Pkwy`.
	MentionText string `protobuf:"bytes,3,opt,name=mention_text,json=mentionText,proto3" json:"mention_text,omitempty"`
	// Optional. Deprecated.  Use `id` field instead.
	MentionId string `protobuf:"bytes,4,opt,name=mention_id,json=mentionId,proto3" json:"mention_id,omitempty"`
	// Optional. Confidence of detected Schema entity. Range `[0, 1]`.
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Optional. Represents the provenance of this entity wrt. the location on
	// the page where it was found.
	PageAnchor *Document_PageAnchor `protobuf:"bytes,6,opt,name=page_anchor,json=pageAnchor,proto3" json:"page_anchor,omitempty"`
	// Optional. Canonical id. This will be a unique value in the entity list
	// for this document.
	Id string `protobuf:"bytes,7,opt,name=id,proto3" json:"id,omitempty"`
	// Optional. Normalized entity value. Absent if the extracted value could
	// not be converted or the type (e.g. address) is not supported for certain
	// parsers. This field is also only populated for certain supported document
	// types.
	NormalizedValue *Document_Entity_NormalizedValue `protobuf:"bytes,9,opt,name=normalized_value,json=normalizedValue,proto3" json:"normalized_value,omitempty"`
	// Optional. Entities can be nested to form a hierarchical data structure
	// representing the content in the document.
	Properties []*Document_Entity `protobuf:"bytes,10,rep,name=properties,proto3" json:"properties,omitempty"`
	// Optional. The history of this annotation.
	Provenance *Document_Provenance `protobuf:"bytes,11,opt,name=provenance,proto3" json:"provenance,omitempty"`
	// Optional. Whether the entity will be redacted for de-identification
	// purposes.
	Redacted bool `protobuf:"varint,12,opt,name=redacted,proto3" json:"redacted,omitempty"`
}

func (x *Document_Entity) Reset() {
	*x = Document_Entity{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Entity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Entity) ProtoMessage() {}

func (x *Document_Entity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Entity.ProtoReflect.Descriptor instead.
func (*Document_Entity) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Document_Entity) GetTextAnchor() *Document_TextAnchor {
	if x != nil {
		return x.TextAnchor
	}
	return nil
}

func (x *Document_Entity) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Document_Entity) GetMentionText() string {
	if x != nil {
		return x.MentionText
	}
	return ""
}

func (x *Document_Entity) GetMentionId() string {
	if x != nil {
		return x.MentionId
	}
	return ""
}

func (x *Document_Entity) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *Document_Entity) GetPageAnchor() *Document_PageAnchor {
	if x != nil {
		return x.PageAnchor
	}
	return nil
}

func (x *Document_Entity) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Document_Entity) GetNormalizedValue() *Document_Entity_NormalizedValue {
	if x != nil {
		return x.NormalizedValue
	}
	return nil
}

func (x *Document_Entity) GetProperties() []*Document_Entity {
	if x != nil {
		return x.Properties
	}
	return nil
}

func (x *Document_Entity) GetProvenance() *Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

func (x *Document_Entity) GetRedacted() bool {
	if x != nil {
		return x.Redacted
	}
	return false
}

// Relationship between
// [Entities][google.cloud.documentai.v1.Document.Entity].
type Document_EntityRelation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Subject entity id.
	SubjectId string `protobuf:"bytes,1,opt,name=subject_id,json=subjectId,proto3" json:"subject_id,omitempty"`
	// Object entity id.
	ObjectId string `protobuf:"bytes,2,opt,name=object_id,json=objectId,proto3" json:"object_id,omitempty"`
	// Relationship description.
	Relation string `protobuf:"bytes,3,opt,name=relation,proto3" json:"relation,omitempty"`
}

func (x *Document_EntityRelation) Reset() {
	*x = Document_EntityRelation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_EntityRelation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_EntityRelation) ProtoMessage() {}

func (x *Document_EntityRelation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_EntityRelation.ProtoReflect.Descriptor instead.
func (*Document_EntityRelation) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Document_EntityRelation) GetSubjectId() string {
	if x != nil {
		return x.SubjectId
	}
	return ""
}

func (x *Document_EntityRelation) GetObjectId() string {
	if x != nil {
		return x.ObjectId
	}
	return ""
}

func (x *Document_EntityRelation) GetRelation() string {
	if x != nil {
		return x.Relation
	}
	return ""
}

// Text reference indexing into the
// [Document.text][google.cloud.documentai.v1.Document.text].
type Document_TextAnchor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The text segments from the
	// [Document.text][google.cloud.documentai.v1.Document.text].
	TextSegments []*Document_TextAnchor_TextSegment `protobuf:"bytes,1,rep,name=text_segments,json=textSegments,proto3" json:"text_segments,omitempty"`
	// Contains the content of the text span so that users do
	// not have to look it up in the text_segments.  It is always
	// populated for formFields.
	Content string `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
}

func (x *Document_TextAnchor) Reset() {
	*x = Document_TextAnchor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_TextAnchor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_TextAnchor) ProtoMessage() {}

func (x *Document_TextAnchor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_TextAnchor.ProtoReflect.Descriptor instead.
func (*Document_TextAnchor) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Document_TextAnchor) GetTextSegments() []*Document_TextAnchor_TextSegment {
	if x != nil {
		return x.TextSegments
	}
	return nil
}

func (x *Document_TextAnchor) GetContent() string {
	if x != nil {
		return x.Content
	}
	return ""
}

// Referencing the visual context of the entity in the
// [Document.pages][google.cloud.documentai.v1.Document.pages]. Page anchors
// can be cross-page, consist of multiple bounding polygons and optionally
// reference specific layout element types.
type Document_PageAnchor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One or more references to visual page elements
	PageRefs []*Document_PageAnchor_PageRef `protobuf:"bytes,1,rep,name=page_refs,json=pageRefs,proto3" json:"page_refs,omitempty"`
}

func (x *Document_PageAnchor) Reset() {
	*x = Document_PageAnchor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_PageAnchor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_PageAnchor) ProtoMessage() {}

func (x *Document_PageAnchor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_PageAnchor.ProtoReflect.Descriptor instead.
func (*Document_PageAnchor) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Document_PageAnchor) GetPageRefs() []*Document_PageAnchor_PageRef {
	if x != nil {
		return x.PageRefs
	}
	return nil
}

// Structure to identify provenance relationships between annotations in
// different revisions.
type Document_Provenance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The index of the revision that produced this element.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Revision int32 `protobuf:"varint,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// The Id of this operation.  Needs to be unique within the scope of the
	// revision.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Id int32 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// References to the original elements that are replaced.
	Parents []*Document_Provenance_Parent `protobuf:"bytes,3,rep,name=parents,proto3" json:"parents,omitempty"`
	// The type of provenance operation.
	Type Document_Provenance_OperationType `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.documentai.v1.Document_Provenance_OperationType" json:"type,omitempty"`
}

func (x *Document_Provenance) Reset() {
	*x = Document_Provenance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Provenance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Provenance) ProtoMessage() {}

func (x *Document_Provenance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Provenance.ProtoReflect.Descriptor instead.
func (*Document_Provenance) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 7}
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Provenance) GetRevision() int32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Provenance) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

func (x *Document_Provenance) GetParents() []*Document_Provenance_Parent {
	if x != nil {
		return x.Parents
	}
	return nil
}

func (x *Document_Provenance) GetType() Document_Provenance_OperationType {
	if x != nil {
		return x.Type
	}
	return Document_Provenance_OPERATION_TYPE_UNSPECIFIED
}

// Contains past or forward revisions of this document.
type Document_Revision struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Who/what made the change
	//
	// Types that are assignable to Source:
	//	*Document_Revision_Agent
	//	*Document_Revision_Processor
	Source isDocument_Revision_Source `protobuf_oneof:"source"`
	// Id of the revision, internally generated by doc proto storage.
	// Unique within the context of the document.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The revisions that this revision is based on.  This can include one or
	// more parent (when documents are merged.)  This field represents the
	// index into the `revisions` field.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Parent []int32 `protobuf:"varint,2,rep,packed,name=parent,proto3" json:"parent,omitempty"`
	// The revisions that this revision is based on. Must include all the ids
	// that have anything to do with this revision - eg. there are
	// `provenance.parent.revision` fields that index into this field.
	ParentIds []string `protobuf:"bytes,7,rep,name=parent_ids,json=parentIds,proto3" json:"parent_ids,omitempty"`
	// The time that the revision was created, internally generated by
	// doc proto storage at the time of create.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Human Review information of this revision.
	HumanReview *Document_Revision_HumanReview `protobuf:"bytes,6,opt,name=human_review,json=humanReview,proto3" json:"human_review,omitempty"`
}

func (x *Document_Revision) Reset() {
	*x = Document_Revision{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Revision) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Revision) ProtoMessage() {}

func (x *Document_Revision) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Revision.ProtoReflect.Descriptor instead.
func (*Document_Revision) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 8}
}

func (m *Document_Revision) GetSource() isDocument_Revision_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *Document_Revision) GetAgent() string {
	if x, ok := x.GetSource().(*Document_Revision_Agent); ok {
		return x.Agent
	}
	return ""
}

func (x *Document_Revision) GetProcessor() string {
	if x, ok := x.GetSource().(*Document_Revision_Processor); ok {
		return x.Processor
	}
	return ""
}

func (x *Document_Revision) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Revision) GetParent() []int32 {
	if x != nil {
		return x.Parent
	}
	return nil
}

func (x *Document_Revision) GetParentIds() []string {
	if x != nil {
		return x.ParentIds
	}
	return nil
}

func (x *Document_Revision) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Document_Revision) GetHumanReview() *Document_Revision_HumanReview {
	if x != nil {
		return x.HumanReview
	}
	return nil
}

type isDocument_Revision_Source interface {
	isDocument_Revision_Source()
}

type Document_Revision_Agent struct {
	// If the change was made by a person specify the name or id of that
	// person.
	Agent string `protobuf:"bytes,4,opt,name=agent,proto3,oneof"`
}

type Document_Revision_Processor struct {
	// If the annotation was made by processor identify the processor by its
	// resource name.
	Processor string `protobuf:"bytes,5,opt,name=processor,proto3,oneof"`
}

func (*Document_Revision_Agent) isDocument_Revision_Source() {}

func (*Document_Revision_Processor) isDocument_Revision_Source() {}

// This message is used for text changes aka. OCR corrections.
type Document_TextChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Provenance of the correction.
	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1.Document.text].  There can
	// only be a single `TextAnchor.text_segments` element.  If the start and
	// end index of the text segment are the same, the text change is inserted
	// before that index.
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// The text that replaces the text identified in the `text_anchor`.
	ChangedText string `protobuf:"bytes,2,opt,name=changed_text,json=changedText,proto3" json:"changed_text,omitempty"`
	// The history of this annotation.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Provenance []*Document_Provenance `protobuf:"bytes,3,rep,name=provenance,proto3" json:"provenance,omitempty"`
}

func (x *Document_TextChange) Reset() {
	*x = Document_TextChange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_TextChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_TextChange) ProtoMessage() {}

func (x *Document_TextChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_TextChange.ProtoReflect.Descriptor instead.
func (*Document_TextChange) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 9}
}

func (x *Document_TextChange) GetTextAnchor() *Document_TextAnchor {
	if x != nil {
		return x.TextAnchor
	}
	return nil
}

func (x *Document_TextChange) GetChangedText() string {
	if x != nil {
		return x.ChangedText
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_TextChange) GetProvenance() []*Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

// Font size with unit.
type Document_Style_FontSize struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Font size for the text.
	Size float32 `protobuf:"fixed32,1,opt,name=size,proto3" json:"size,omitempty"`
	// Unit for the font size. Follows CSS naming (such as `in`, `px`, and
	// `pt`).
	Unit string `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *Document_Style_FontSize) Reset() {
	*x = Document_Style_FontSize{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Style_FontSize) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Style_FontSize) ProtoMessage() {}

func (x *Document_Style_FontSize) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Style_FontSize.ProtoReflect.Descriptor instead.
func (*Document_Style_FontSize) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Document_Style_FontSize) GetSize() float32 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Document_Style_FontSize) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// Dimension for the page.
type Document_Page_Dimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Page width.
	Width float32 `protobuf:"fixed32,1,opt,name=width,proto3" json:"width,omitempty"`
	// Page height.
	Height float32 `protobuf:"fixed32,2,opt,name=height,proto3" json:"height,omitempty"`
	// Dimension unit.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *Document_Page_Dimension) Reset() {
	*x = Document_Page_Dimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Dimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Dimension) ProtoMessage() {}

func (x *Document_Page_Dimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Dimension.ProtoReflect.Descriptor instead.
func (*Document_Page_Dimension) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *Document_Page_Dimension) GetWidth() float32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *Document_Page_Dimension) GetHeight() float32 {
	if x != nil {
		return x.Height
	}
	return 0
}

func (x *Document_Page_Dimension) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// Rendered image contents for this page.
type Document_Page_Image struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Raw byte content of the image.
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3" json:"content,omitempty"`
	// Encoding [media type (MIME
	// type)](https://www.iana.org/assignments/media-types/media-types.xhtml)
	// for the image.
	MimeType string `protobuf:"bytes,2,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Width of the image in pixels.
	Width int32 `protobuf:"varint,3,opt,name=width,proto3" json:"width,omitempty"`
	// Height of the image in pixels.
	Height int32 `protobuf:"varint,4,opt,name=height,proto3" json:"height,omitempty"`
}

func (x *Document_Page_Image) Reset() {
	*x = Document_Page_Image{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Image) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Image) ProtoMessage() {}

func (x *Document_Page_Image) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Image.ProtoReflect.Descriptor instead.
func (*Document_Page_Image) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *Document_Page_Image) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Document_Page_Image) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *Document_Page_Image) GetWidth() int32 {
	if x != nil {
		return x.Width
	}
	return 0
}

func (x *Document_Page_Image) GetHeight() int32 {
	if x != nil {
		return x.Height
	}
	return 0
}

// Representation for transformation matrix, intended to be compatible and
// used with OpenCV format for image manipulation.
type Document_Page_Matrix struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of rows in the matrix.
	Rows int32 `protobuf:"varint,1,opt,name=rows,proto3" json:"rows,omitempty"`
	// Number of columns in the matrix.
	Cols int32 `protobuf:"varint,2,opt,name=cols,proto3" json:"cols,omitempty"`
	// This encodes information about what data type the matrix uses.
	// For example, 0 (CV_8U) is an unsigned 8-bit image. For the full list
	// of OpenCV primitive data types, please refer to
	// https://docs.opencv.org/4.3.0/d1/d1b/group__core__hal__interface.html
	Type int32 `protobuf:"varint,3,opt,name=type,proto3" json:"type,omitempty"`
	// The matrix data.
	Data []byte `protobuf:"bytes,4,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *Document_Page_Matrix) Reset() {
	*x = Document_Page_Matrix{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Matrix) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Matrix) ProtoMessage() {}

func (x *Document_Page_Matrix) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Matrix.ProtoReflect.Descriptor instead.
func (*Document_Page_Matrix) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 2}
}

func (x *Document_Page_Matrix) GetRows() int32 {
	if x != nil {
		return x.Rows
	}
	return 0
}

func (x *Document_Page_Matrix) GetCols() int32 {
	if x != nil {
		return x.Cols
	}
	return 0
}

func (x *Document_Page_Matrix) GetType() int32 {
	if x != nil {
		return x.Type
	}
	return 0
}

func (x *Document_Page_Matrix) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// Visual element describing a layout unit on a page.
type Document_Page_Layout struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Confidence of the current
	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] within
	// context of the object this layout is for. e.g. confidence can be for a
	// single token, a table, a visual element, etc. depending on context.
	// Range `[0, 1]`.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The bounding polygon for the
	// [Layout][google.cloud.documentai.v1.Document.Page.Layout].
	BoundingPoly *BoundingPoly `protobuf:"bytes,3,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Detected orientation for the
	// [Layout][google.cloud.documentai.v1.Document.Page.Layout].
	Orientation Document_Page_Layout_Orientation `protobuf:"varint,4,opt,name=orientation,proto3,enum=google.cloud.documentai.v1.Document_Page_Layout_Orientation" json:"orientation,omitempty"`
}

func (x *Document_Page_Layout) Reset() {
	*x = Document_Page_Layout{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Layout) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Layout) ProtoMessage() {}

func (x *Document_Page_Layout) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Layout.ProtoReflect.Descriptor instead.
func (*Document_Page_Layout) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 3}
}

func (x *Document_Page_Layout) GetTextAnchor() *Document_TextAnchor {
	if x != nil {
		return x.TextAnchor
	}
	return nil
}

func (x *Document_Page_Layout) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

func (x *Document_Page_Layout) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *Document_Page_Layout) GetOrientation() Document_Page_Layout_Orientation {
	if x != nil {
		return x.Orientation
	}
	return Document_Page_Layout_ORIENTATION_UNSPECIFIED
}

// A block has a set of lines (collected into paragraphs) that have a
// common line-spacing and orientation.
type Document_Page_Block struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [Block][google.cloud.documentai.v1.Document.Page.Block].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// The history of this annotation.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Provenance *Document_Provenance `protobuf:"bytes,3,opt,name=provenance,proto3" json:"provenance,omitempty"`
}

func (x *Document_Page_Block) Reset() {
	*x = Document_Page_Block{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Block) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Block) ProtoMessage() {}

func (x *Document_Page_Block) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Block.ProtoReflect.Descriptor instead.
func (*Document_Page_Block) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 4}
}

func (x *Document_Page_Block) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Block) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Page_Block) GetProvenance() *Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

// A collection of lines that a human would perceive as a paragraph.
type Document_Page_Paragraph struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [Paragraph][google.cloud.documentai.v1.Document.Page.Paragraph].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// The  history of this annotation.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Provenance *Document_Provenance `protobuf:"bytes,3,opt,name=provenance,proto3" json:"provenance,omitempty"`
}

func (x *Document_Page_Paragraph) Reset() {
	*x = Document_Page_Paragraph{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Paragraph) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Paragraph) ProtoMessage() {}

func (x *Document_Page_Paragraph) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Paragraph.ProtoReflect.Descriptor instead.
func (*Document_Page_Paragraph) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 5}
}

func (x *Document_Page_Paragraph) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Paragraph) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Page_Paragraph) GetProvenance() *Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

// A collection of tokens that a human would perceive as a line.
// Does not cross column boundaries, can be horizontal, vertical, etc.
type Document_Page_Line struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [Line][google.cloud.documentai.v1.Document.Page.Line].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// The  history of this annotation.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Provenance *Document_Provenance `protobuf:"bytes,3,opt,name=provenance,proto3" json:"provenance,omitempty"`
}

func (x *Document_Page_Line) Reset() {
	*x = Document_Page_Line{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Line) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Line) ProtoMessage() {}

func (x *Document_Page_Line) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Line.ProtoReflect.Descriptor instead.
func (*Document_Page_Line) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 6}
}

func (x *Document_Page_Line) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Line) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Page_Line) GetProvenance() *Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

// A detected token.
type Document_Page_Token struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [Token][google.cloud.documentai.v1.Document.Page.Token].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Detected break at the end of a
	// [Token][google.cloud.documentai.v1.Document.Page.Token].
	DetectedBreak *Document_Page_Token_DetectedBreak `protobuf:"bytes,2,opt,name=detected_break,json=detectedBreak,proto3" json:"detected_break,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// The history of this annotation.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Provenance *Document_Provenance `protobuf:"bytes,4,opt,name=provenance,proto3" json:"provenance,omitempty"`
	// Text style attributes.
	StyleInfo *Document_Page_Token_StyleInfo `protobuf:"bytes,5,opt,name=style_info,json=styleInfo,proto3" json:"style_info,omitempty"`
}

func (x *Document_Page_Token) Reset() {
	*x = Document_Page_Token{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Token) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Token) ProtoMessage() {}

func (x *Document_Page_Token) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Token.ProtoReflect.Descriptor instead.
func (*Document_Page_Token) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 7}
}

func (x *Document_Page_Token) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Token) GetDetectedBreak() *Document_Page_Token_DetectedBreak {
	if x != nil {
		return x.DetectedBreak
	}
	return nil
}

func (x *Document_Page_Token) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Page_Token) GetProvenance() *Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

func (x *Document_Page_Token) GetStyleInfo() *Document_Page_Token_StyleInfo {
	if x != nil {
		return x.StyleInfo
	}
	return nil
}

// A detected symbol.
type Document_Page_Symbol struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [Symbol][google.cloud.documentai.v1.Document.Page.Symbol].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_Symbol) Reset() {
	*x = Document_Page_Symbol{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Symbol) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Symbol) ProtoMessage() {}

func (x *Document_Page_Symbol) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Symbol.ProtoReflect.Descriptor instead.
func (*Document_Page_Symbol) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 8}
}

func (x *Document_Page_Symbol) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Symbol) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// Detected non-text visual elements e.g. checkbox, signature etc. on the
// page.
type Document_Page_VisualElement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [VisualElement][google.cloud.documentai.v1.Document.Page.VisualElement].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Type of the
	// [VisualElement][google.cloud.documentai.v1.Document.Page.VisualElement].
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_VisualElement) Reset() {
	*x = Document_Page_VisualElement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_VisualElement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_VisualElement) ProtoMessage() {}

func (x *Document_Page_VisualElement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_VisualElement.ProtoReflect.Descriptor instead.
func (*Document_Page_VisualElement) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 9}
}

func (x *Document_Page_VisualElement) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_VisualElement) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Document_Page_VisualElement) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// A table representation similar to HTML table structure.
type Document_Page_Table struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [Table][google.cloud.documentai.v1.Document.Page.Table].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Header rows of the table.
	HeaderRows []*Document_Page_Table_TableRow `protobuf:"bytes,2,rep,name=header_rows,json=headerRows,proto3" json:"header_rows,omitempty"`
	// Body rows of the table.
	BodyRows []*Document_Page_Table_TableRow `protobuf:"bytes,3,rep,name=body_rows,json=bodyRows,proto3" json:"body_rows,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// The history of this table.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Provenance *Document_Provenance `protobuf:"bytes,5,opt,name=provenance,proto3" json:"provenance,omitempty"`
}

func (x *Document_Page_Table) Reset() {
	*x = Document_Page_Table{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Table) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Table) ProtoMessage() {}

func (x *Document_Page_Table) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Table.ProtoReflect.Descriptor instead.
func (*Document_Page_Table) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 10}
}

func (x *Document_Page_Table) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Table) GetHeaderRows() []*Document_Page_Table_TableRow {
	if x != nil {
		return x.HeaderRows
	}
	return nil
}

func (x *Document_Page_Table) GetBodyRows() []*Document_Page_Table_TableRow {
	if x != nil {
		return x.BodyRows
	}
	return nil
}

func (x *Document_Page_Table) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Page_Table) GetProvenance() *Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

// A form field detected on the page.
type Document_Page_FormField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for the
	// [FormField][google.cloud.documentai.v1.Document.Page.FormField] name.
	// e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
	FieldName *Document_Page_Layout `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for the
	// [FormField][google.cloud.documentai.v1.Document.Page.FormField] value.
	FieldValue *Document_Page_Layout `protobuf:"bytes,2,opt,name=field_value,json=fieldValue,proto3" json:"field_value,omitempty"`
	// A list of detected languages for name together with confidence.
	NameDetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=name_detected_languages,json=nameDetectedLanguages,proto3" json:"name_detected_languages,omitempty"`
	// A list of detected languages for value together with confidence.
	ValueDetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=value_detected_languages,json=valueDetectedLanguages,proto3" json:"value_detected_languages,omitempty"`
	// If the value is non-textual, this field represents the type. Current
	// valid values are:
	//
	// - blank (this indicates the `field_value` is normal text)
	// - `unfilled_checkbox`
	// - `filled_checkbox`
	ValueType string `protobuf:"bytes,5,opt,name=value_type,json=valueType,proto3" json:"value_type,omitempty"`
	// Created for Labeling UI to export key text.
	// If corrections were made to the text identified by the
	// `field_name.text_anchor`, this field will contain the correction.
	CorrectedKeyText string `protobuf:"bytes,6,opt,name=corrected_key_text,json=correctedKeyText,proto3" json:"corrected_key_text,omitempty"`
	// Created for Labeling UI to export value text.
	// If corrections were made to the text identified by the
	// `field_value.text_anchor`, this field will contain the correction.
	CorrectedValueText string `protobuf:"bytes,7,opt,name=corrected_value_text,json=correctedValueText,proto3" json:"corrected_value_text,omitempty"`
	// The history of this annotation.
	Provenance *Document_Provenance `protobuf:"bytes,8,opt,name=provenance,proto3" json:"provenance,omitempty"`
}

func (x *Document_Page_FormField) Reset() {
	*x = Document_Page_FormField{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_FormField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_FormField) ProtoMessage() {}

func (x *Document_Page_FormField) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_FormField.ProtoReflect.Descriptor instead.
func (*Document_Page_FormField) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 11}
}

func (x *Document_Page_FormField) GetFieldName() *Document_Page_Layout {
	if x != nil {
		return x.FieldName
	}
	return nil
}

func (x *Document_Page_FormField) GetFieldValue() *Document_Page_Layout {
	if x != nil {
		return x.FieldValue
	}
	return nil
}

func (x *Document_Page_FormField) GetNameDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.NameDetectedLanguages
	}
	return nil
}

func (x *Document_Page_FormField) GetValueDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.ValueDetectedLanguages
	}
	return nil
}

func (x *Document_Page_FormField) GetValueType() string {
	if x != nil {
		return x.ValueType
	}
	return ""
}

func (x *Document_Page_FormField) GetCorrectedKeyText() string {
	if x != nil {
		return x.CorrectedKeyText
	}
	return ""
}

func (x *Document_Page_FormField) GetCorrectedValueText() string {
	if x != nil {
		return x.CorrectedValueText
	}
	return ""
}

func (x *Document_Page_FormField) GetProvenance() *Document_Provenance {
	if x != nil {
		return x.Provenance
	}
	return nil
}

// A detected barcode.
type Document_Page_DetectedBarcode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [DetectedBarcode][google.cloud.documentai.v1.Document.Page.DetectedBarcode].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Detailed barcode information of the
	// [DetectedBarcode][google.cloud.documentai.v1.Document.Page.DetectedBarcode].
	Barcode *Barcode `protobuf:"bytes,2,opt,name=barcode,proto3" json:"barcode,omitempty"`
}

func (x *Document_Page_DetectedBarcode) Reset() {
	*x = Document_Page_DetectedBarcode{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_DetectedBarcode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_DetectedBarcode) ProtoMessage() {}

func (x *Document_Page_DetectedBarcode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_DetectedBarcode.ProtoReflect.Descriptor instead.
func (*Document_Page_DetectedBarcode) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 12}
}

func (x *Document_Page_DetectedBarcode) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_DetectedBarcode) GetBarcode() *Barcode {
	if x != nil {
		return x.Barcode
	}
	return nil
}

// Detected language for a structural component.
type Document_Page_DetectedLanguage struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The [BCP-47 language
	// code](https://www.unicode.org/reports/tr35/#Unicode_locale_identifier),
	// such as `en-US` or `sr-Latn`.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Confidence of detected language. Range `[0, 1]`.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *Document_Page_DetectedLanguage) Reset() {
	*x = Document_Page_DetectedLanguage{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_DetectedLanguage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_DetectedLanguage) ProtoMessage() {}

func (x *Document_Page_DetectedLanguage) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_DetectedLanguage.ProtoReflect.Descriptor instead.
func (*Document_Page_DetectedLanguage) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 13}
}

func (x *Document_Page_DetectedLanguage) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *Document_Page_DetectedLanguage) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Image quality scores for the page image.
type Document_Page_ImageQualityScores struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The overall quality score. Range `[0, 1]` where `1` is perfect quality.
	QualityScore float32 `protobuf:"fixed32,1,opt,name=quality_score,json=qualityScore,proto3" json:"quality_score,omitempty"`
	// A list of detected defects.
	DetectedDefects []*Document_Page_ImageQualityScores_DetectedDefect `protobuf:"bytes,2,rep,name=detected_defects,json=detectedDefects,proto3" json:"detected_defects,omitempty"`
}

func (x *Document_Page_ImageQualityScores) Reset() {
	*x = Document_Page_ImageQualityScores{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_ImageQualityScores) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_ImageQualityScores) ProtoMessage() {}

func (x *Document_Page_ImageQualityScores) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_ImageQualityScores.ProtoReflect.Descriptor instead.
func (*Document_Page_ImageQualityScores) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 14}
}

func (x *Document_Page_ImageQualityScores) GetQualityScore() float32 {
	if x != nil {
		return x.QualityScore
	}
	return 0
}

func (x *Document_Page_ImageQualityScores) GetDetectedDefects() []*Document_Page_ImageQualityScores_DetectedDefect {
	if x != nil {
		return x.DetectedDefects
	}
	return nil
}

// Detected break at the end of a
// [Token][google.cloud.documentai.v1.Document.Page.Token].
type Document_Page_Token_DetectedBreak struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Detected break type.
	Type Document_Page_Token_DetectedBreak_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.documentai.v1.Document_Page_Token_DetectedBreak_Type" json:"type,omitempty"`
}

func (x *Document_Page_Token_DetectedBreak) Reset() {
	*x = Document_Page_Token_DetectedBreak{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Token_DetectedBreak) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Token_DetectedBreak) ProtoMessage() {}

func (x *Document_Page_Token_DetectedBreak) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Token_DetectedBreak.ProtoReflect.Descriptor instead.
func (*Document_Page_Token_DetectedBreak) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 7, 0}
}

func (x *Document_Page_Token_DetectedBreak) GetType() Document_Page_Token_DetectedBreak_Type {
	if x != nil {
		return x.Type
	}
	return Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED
}

// Font and other text style attributes.
type Document_Page_Token_StyleInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Font size in points (`1` point is `¹⁄₇₂` inches).
	FontSize int32 `protobuf:"varint,1,opt,name=font_size,json=fontSize,proto3" json:"font_size,omitempty"`
	// Font size in pixels, equal to _unrounded
	// [font_size][google.cloud.documentai.v1.Document.Page.Token.StyleInfo.font_size]_
	// * _resolution_ ÷ `72.0`.
	PixelFontSize float64 `protobuf:"fixed64,2,opt,name=pixel_font_size,json=pixelFontSize,proto3" json:"pixel_font_size,omitempty"`
	// Letter spacing in points.
	LetterSpacing float64 `protobuf:"fixed64,3,opt,name=letter_spacing,json=letterSpacing,proto3" json:"letter_spacing,omitempty"`
	// Name or style of the font.
	FontType string `protobuf:"bytes,4,opt,name=font_type,json=fontType,proto3" json:"font_type,omitempty"`
	// Whether the text is bold (equivalent to
	// [font_weight][google.cloud.documentai.v1.Document.Page.Token.StyleInfo.font_weight]
	// is at least `700`).
	Bold bool `protobuf:"varint,5,opt,name=bold,proto3" json:"bold,omitempty"`
	// Whether the text is italic.
	Italic bool `protobuf:"varint,6,opt,name=italic,proto3" json:"italic,omitempty"`
	// Whether the text is underlined.
	Underlined bool `protobuf:"varint,7,opt,name=underlined,proto3" json:"underlined,omitempty"`
	// Whether the text is strikethrough.
	Strikeout bool `protobuf:"varint,8,opt,name=strikeout,proto3" json:"strikeout,omitempty"`
	// Whether the text is a subscript.
	Subscript bool `protobuf:"varint,9,opt,name=subscript,proto3" json:"subscript,omitempty"`
	// Whether the text is a superscript.
	Superscript bool `protobuf:"varint,10,opt,name=superscript,proto3" json:"superscript,omitempty"`
	// Whether the text is in small caps.
	Smallcaps bool `protobuf:"varint,11,opt,name=smallcaps,proto3" json:"smallcaps,omitempty"`
	// TrueType weight on a scale `100` (thin) to `1000` (ultra-heavy).
	// Normal is `400`, bold is `700`.
	FontWeight int32 `protobuf:"varint,12,opt,name=font_weight,json=fontWeight,proto3" json:"font_weight,omitempty"`
	// Whether the text is handwritten.
	Handwritten bool `protobuf:"varint,13,opt,name=handwritten,proto3" json:"handwritten,omitempty"`
	// Color of the text.
	TextColor *color.Color `protobuf:"bytes,14,opt,name=text_color,json=textColor,proto3" json:"text_color,omitempty"`
	// Color of the background.
	BackgroundColor *color.Color `protobuf:"bytes,15,opt,name=background_color,json=backgroundColor,proto3" json:"background_color,omitempty"`
}

func (x *Document_Page_Token_StyleInfo) Reset() {
	*x = Document_Page_Token_StyleInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Token_StyleInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Token_StyleInfo) ProtoMessage() {}

func (x *Document_Page_Token_StyleInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Token_StyleInfo.ProtoReflect.Descriptor instead.
func (*Document_Page_Token_StyleInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 7, 1}
}

func (x *Document_Page_Token_StyleInfo) GetFontSize() int32 {
	if x != nil {
		return x.FontSize
	}
	return 0
}

func (x *Document_Page_Token_StyleInfo) GetPixelFontSize() float64 {
	if x != nil {
		return x.PixelFontSize
	}
	return 0
}

func (x *Document_Page_Token_StyleInfo) GetLetterSpacing() float64 {
	if x != nil {
		return x.LetterSpacing
	}
	return 0
}

func (x *Document_Page_Token_StyleInfo) GetFontType() string {
	if x != nil {
		return x.FontType
	}
	return ""
}

func (x *Document_Page_Token_StyleInfo) GetBold() bool {
	if x != nil {
		return x.Bold
	}
	return false
}

func (x *Document_Page_Token_StyleInfo) GetItalic() bool {
	if x != nil {
		return x.Italic
	}
	return false
}

func (x *Document_Page_Token_StyleInfo) GetUnderlined() bool {
	if x != nil {
		return x.Underlined
	}
	return false
}

func (x *Document_Page_Token_StyleInfo) GetStrikeout() bool {
	if x != nil {
		return x.Strikeout
	}
	return false
}

func (x *Document_Page_Token_StyleInfo) GetSubscript() bool {
	if x != nil {
		return x.Subscript
	}
	return false
}

func (x *Document_Page_Token_StyleInfo) GetSuperscript() bool {
	if x != nil {
		return x.Superscript
	}
	return false
}

func (x *Document_Page_Token_StyleInfo) GetSmallcaps() bool {
	if x != nil {
		return x.Smallcaps
	}
	return false
}

func (x *Document_Page_Token_StyleInfo) GetFontWeight() int32 {
	if x != nil {
		return x.FontWeight
	}
	return 0
}

func (x *Document_Page_Token_StyleInfo) GetHandwritten() bool {
	if x != nil {
		return x.Handwritten
	}
	return false
}

func (x *Document_Page_Token_StyleInfo) GetTextColor() *color.Color {
	if x != nil {
		return x.TextColor
	}
	return nil
}

func (x *Document_Page_Token_StyleInfo) GetBackgroundColor() *color.Color {
	if x != nil {
		return x.BackgroundColor
	}
	return nil
}

// A row of table cells.
type Document_Page_Table_TableRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cells that make up this row.
	Cells []*Document_Page_Table_TableCell `protobuf:"bytes,1,rep,name=cells,proto3" json:"cells,omitempty"`
}

func (x *Document_Page_Table_TableRow) Reset() {
	*x = Document_Page_Table_TableRow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Table_TableRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Table_TableRow) ProtoMessage() {}

func (x *Document_Page_Table_TableRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Table_TableRow.ProtoReflect.Descriptor instead.
func (*Document_Page_Table_TableRow) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 10, 0}
}

func (x *Document_Page_Table_TableRow) GetCells() []*Document_Page_Table_TableCell {
	if x != nil {
		return x.Cells
	}
	return nil
}

// A cell representation inside the table.
type Document_Page_Table_TableCell struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Layout][google.cloud.documentai.v1.Document.Page.Layout] for
	// [TableCell][google.cloud.documentai.v1.Document.Page.Table.TableCell].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// How many rows this cell spans.
	RowSpan int32 `protobuf:"varint,2,opt,name=row_span,json=rowSpan,proto3" json:"row_span,omitempty"`
	// How many columns this cell spans.
	ColSpan int32 `protobuf:"varint,3,opt,name=col_span,json=colSpan,proto3" json:"col_span,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
}

func (x *Document_Page_Table_TableCell) Reset() {
	*x = Document_Page_Table_TableCell{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[30]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_Table_TableCell) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_Table_TableCell) ProtoMessage() {}

func (x *Document_Page_Table_TableCell) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[30]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_Table_TableCell.ProtoReflect.Descriptor instead.
func (*Document_Page_Table_TableCell) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 10, 1}
}

func (x *Document_Page_Table_TableCell) GetLayout() *Document_Page_Layout {
	if x != nil {
		return x.Layout
	}
	return nil
}

func (x *Document_Page_Table_TableCell) GetRowSpan() int32 {
	if x != nil {
		return x.RowSpan
	}
	return 0
}

func (x *Document_Page_Table_TableCell) GetColSpan() int32 {
	if x != nil {
		return x.ColSpan
	}
	return 0
}

func (x *Document_Page_Table_TableCell) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if x != nil {
		return x.DetectedLanguages
	}
	return nil
}

// Image Quality Defects
type Document_Page_ImageQualityScores_DetectedDefect struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the defect type. Supported values are:
	//
	// - `quality/defect_blurry`
	// - `quality/defect_noisy`
	// - `quality/defect_dark`
	// - `quality/defect_faint`
	// - `quality/defect_text_too_small`
	// - `quality/defect_document_cutoff`
	// - `quality/defect_text_cutoff`
	// - `quality/defect_glare`
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// Confidence of detected defect. Range `[0, 1]` where `1` indicates
	// strong confidence that the defect exists.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *Document_Page_ImageQualityScores_DetectedDefect) Reset() {
	*x = Document_Page_ImageQualityScores_DetectedDefect{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[31]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Page_ImageQualityScores_DetectedDefect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Page_ImageQualityScores_DetectedDefect) ProtoMessage() {}

func (x *Document_Page_ImageQualityScores_DetectedDefect) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[31]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Page_ImageQualityScores_DetectedDefect.ProtoReflect.Descriptor instead.
func (*Document_Page_ImageQualityScores_DetectedDefect) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 2, 14, 0}
}

func (x *Document_Page_ImageQualityScores_DetectedDefect) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *Document_Page_ImageQualityScores_DetectedDefect) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Parsed and normalized entity value.
type Document_Entity_NormalizedValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An optional structured entity value.
	// Must match entity type defined in schema if
	// known. If this field is present, the `text` field could also be
	// populated.
	//
	// Types that are assignable to StructuredValue:
	//	*Document_Entity_NormalizedValue_MoneyValue
	//	*Document_Entity_NormalizedValue_DateValue
	//	*Document_Entity_NormalizedValue_DatetimeValue
	//	*Document_Entity_NormalizedValue_AddressValue
	//	*Document_Entity_NormalizedValue_BooleanValue
	//	*Document_Entity_NormalizedValue_IntegerValue
	//	*Document_Entity_NormalizedValue_FloatValue
	StructuredValue isDocument_Entity_NormalizedValue_StructuredValue `protobuf_oneof:"structured_value"`
	// Optional. An optional field to store a normalized string.
	// For some entity types, one of respective `structured_value` fields may
	// also be populated. Also not all the types of `structured_value` will be
	// normalized. For example, some processors may not generate `float`
	// or `integer` normalized text by default.
	//
	// Below are sample formats mapped to structured values.
	//
	// - Money/Currency type (`money_value`) is in the ISO 4217 text format.
	// - Date type (`date_value`) is in the ISO 8601 text format.
	// - Datetime type (`datetime_value`) is in the ISO 8601 text format.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *Document_Entity_NormalizedValue) Reset() {
	*x = Document_Entity_NormalizedValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[32]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Entity_NormalizedValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Entity_NormalizedValue) ProtoMessage() {}

func (x *Document_Entity_NormalizedValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[32]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Entity_NormalizedValue.ProtoReflect.Descriptor instead.
func (*Document_Entity_NormalizedValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (m *Document_Entity_NormalizedValue) GetStructuredValue() isDocument_Entity_NormalizedValue_StructuredValue {
	if m != nil {
		return m.StructuredValue
	}
	return nil
}

func (x *Document_Entity_NormalizedValue) GetMoneyValue() *money.Money {
	if x, ok := x.GetStructuredValue().(*Document_Entity_NormalizedValue_MoneyValue); ok {
		return x.MoneyValue
	}
	return nil
}

func (x *Document_Entity_NormalizedValue) GetDateValue() *date.Date {
	if x, ok := x.GetStructuredValue().(*Document_Entity_NormalizedValue_DateValue); ok {
		return x.DateValue
	}
	return nil
}

func (x *Document_Entity_NormalizedValue) GetDatetimeValue() *datetime.DateTime {
	if x, ok := x.GetStructuredValue().(*Document_Entity_NormalizedValue_DatetimeValue); ok {
		return x.DatetimeValue
	}
	return nil
}

func (x *Document_Entity_NormalizedValue) GetAddressValue() *postaladdress.PostalAddress {
	if x, ok := x.GetStructuredValue().(*Document_Entity_NormalizedValue_AddressValue); ok {
		return x.AddressValue
	}
	return nil
}

func (x *Document_Entity_NormalizedValue) GetBooleanValue() bool {
	if x, ok := x.GetStructuredValue().(*Document_Entity_NormalizedValue_BooleanValue); ok {
		return x.BooleanValue
	}
	return false
}

func (x *Document_Entity_NormalizedValue) GetIntegerValue() int32 {
	if x, ok := x.GetStructuredValue().(*Document_Entity_NormalizedValue_IntegerValue); ok {
		return x.IntegerValue
	}
	return 0
}

func (x *Document_Entity_NormalizedValue) GetFloatValue() float32 {
	if x, ok := x.GetStructuredValue().(*Document_Entity_NormalizedValue_FloatValue); ok {
		return x.FloatValue
	}
	return 0
}

func (x *Document_Entity_NormalizedValue) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

type isDocument_Entity_NormalizedValue_StructuredValue interface {
	isDocument_Entity_NormalizedValue_StructuredValue()
}

type Document_Entity_NormalizedValue_MoneyValue struct {
	// Money value. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/money.proto
	MoneyValue *money.Money `protobuf:"bytes,2,opt,name=money_value,json=moneyValue,proto3,oneof"`
}

type Document_Entity_NormalizedValue_DateValue struct {
	// Date value. Includes year, month, day. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/date.proto
	DateValue *date.Date `protobuf:"bytes,3,opt,name=date_value,json=dateValue,proto3,oneof"`
}

type Document_Entity_NormalizedValue_DatetimeValue struct {
	// DateTime value. Includes date, time, and timezone. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/datetime.proto
	DatetimeValue *datetime.DateTime `protobuf:"bytes,4,opt,name=datetime_value,json=datetimeValue,proto3,oneof"`
}

type Document_Entity_NormalizedValue_AddressValue struct {
	// Postal address. See also:
	// https://github.com/googleapis/googleapis/blob/master/google/type/postal_address.proto
	AddressValue *postaladdress.PostalAddress `protobuf:"bytes,5,opt,name=address_value,json=addressValue,proto3,oneof"`
}

type Document_Entity_NormalizedValue_BooleanValue struct {
	// Boolean value. Can be used for entities with binary values, or for
	// checkboxes.
	BooleanValue bool `protobuf:"varint,6,opt,name=boolean_value,json=booleanValue,proto3,oneof"`
}

type Document_Entity_NormalizedValue_IntegerValue struct {
	// Integer value.
	IntegerValue int32 `protobuf:"varint,7,opt,name=integer_value,json=integerValue,proto3,oneof"`
}

type Document_Entity_NormalizedValue_FloatValue struct {
	// Float value.
	FloatValue float32 `protobuf:"fixed32,8,opt,name=float_value,json=floatValue,proto3,oneof"`
}

func (*Document_Entity_NormalizedValue_MoneyValue) isDocument_Entity_NormalizedValue_StructuredValue() {
}

func (*Document_Entity_NormalizedValue_DateValue) isDocument_Entity_NormalizedValue_StructuredValue() {
}

func (*Document_Entity_NormalizedValue_DatetimeValue) isDocument_Entity_NormalizedValue_StructuredValue() {
}

func (*Document_Entity_NormalizedValue_AddressValue) isDocument_Entity_NormalizedValue_StructuredValue() {
}

func (*Document_Entity_NormalizedValue_BooleanValue) isDocument_Entity_NormalizedValue_StructuredValue() {
}

func (*Document_Entity_NormalizedValue_IntegerValue) isDocument_Entity_NormalizedValue_StructuredValue() {
}

func (*Document_Entity_NormalizedValue_FloatValue) isDocument_Entity_NormalizedValue_StructuredValue() {
}

// A text segment in the
// [Document.text][google.cloud.documentai.v1.Document.text]. The indices
// may be out of bounds which indicate that the text extends into another
// document shard for large sharded documents. See
// [ShardInfo.text_offset][google.cloud.documentai.v1.Document.ShardInfo.text_offset]
type Document_TextAnchor_TextSegment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [TextSegment][google.cloud.documentai.v1.Document.TextAnchor.TextSegment]
	// start UTF-8 char index in the
	// [Document.text][google.cloud.documentai.v1.Document.text].
	StartIndex int64 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// [TextSegment][google.cloud.documentai.v1.Document.TextAnchor.TextSegment]
	// half open end UTF-8 char index in the
	// [Document.text][google.cloud.documentai.v1.Document.text].
	EndIndex int64 `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
}

func (x *Document_TextAnchor_TextSegment) Reset() {
	*x = Document_TextAnchor_TextSegment{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[33]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_TextAnchor_TextSegment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_TextAnchor_TextSegment) ProtoMessage() {}

func (x *Document_TextAnchor_TextSegment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[33]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_TextAnchor_TextSegment.ProtoReflect.Descriptor instead.
func (*Document_TextAnchor_TextSegment) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 5, 0}
}

func (x *Document_TextAnchor_TextSegment) GetStartIndex() int64 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *Document_TextAnchor_TextSegment) GetEndIndex() int64 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

// Represents a weak reference to a page element within a document.
type Document_PageAnchor_PageRef struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Index into the
	// [Document.pages][google.cloud.documentai.v1.Document.pages] element,
	// for example using
	// `[Document.pages][page_refs.page]` to locate the related page element.
	// This field is skipped when its value is the default `0`. See
	// https://developers.google.com/protocol-buffers/docs/proto3#json.
	Page int64 `protobuf:"varint,1,opt,name=page,proto3" json:"page,omitempty"`
	// Optional. The type of the layout element that is being referenced if
	// any.
	LayoutType Document_PageAnchor_PageRef_LayoutType `protobuf:"varint,2,opt,name=layout_type,json=layoutType,proto3,enum=google.cloud.documentai.v1.Document_PageAnchor_PageRef_LayoutType" json:"layout_type,omitempty"`
	// Optional. Deprecated.  Use
	// [PageRef.bounding_poly][google.cloud.documentai.v1.Document.PageAnchor.PageRef.bounding_poly]
	// instead.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	LayoutId string `protobuf:"bytes,3,opt,name=layout_id,json=layoutId,proto3" json:"layout_id,omitempty"`
	// Optional. Identifies the bounding polygon of a layout element on the
	// page.
	BoundingPoly *BoundingPoly `protobuf:"bytes,4,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Optional. Confidence of detected page element, if applicable. Range
	// `[0, 1]`.
	Confidence float32 `protobuf:"fixed32,5,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *Document_PageAnchor_PageRef) Reset() {
	*x = Document_PageAnchor_PageRef{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[34]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_PageAnchor_PageRef) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_PageAnchor_PageRef) ProtoMessage() {}

func (x *Document_PageAnchor_PageRef) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[34]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_PageAnchor_PageRef.ProtoReflect.Descriptor instead.
func (*Document_PageAnchor_PageRef) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 6, 0}
}

func (x *Document_PageAnchor_PageRef) GetPage() int64 {
	if x != nil {
		return x.Page
	}
	return 0
}

func (x *Document_PageAnchor_PageRef) GetLayoutType() Document_PageAnchor_PageRef_LayoutType {
	if x != nil {
		return x.LayoutType
	}
	return Document_PageAnchor_PageRef_LAYOUT_TYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_PageAnchor_PageRef) GetLayoutId() string {
	if x != nil {
		return x.LayoutId
	}
	return ""
}

func (x *Document_PageAnchor_PageRef) GetBoundingPoly() *BoundingPoly {
	if x != nil {
		return x.BoundingPoly
	}
	return nil
}

func (x *Document_PageAnchor_PageRef) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// The parent element the current element is based on. Used for
// referencing/aligning, removal and replacement operations.
type Document_Provenance_Parent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The index of the index into current revision's parent_ids list.
	Revision int32 `protobuf:"varint,1,opt,name=revision,proto3" json:"revision,omitempty"`
	// The index of the parent item in the corresponding item list (eg. list
	// of entities, properties within entities, etc.) in the parent revision.
	Index int32 `protobuf:"varint,3,opt,name=index,proto3" json:"index,omitempty"`
	// The id of the parent provenance.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
	Id int32 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
}

func (x *Document_Provenance_Parent) Reset() {
	*x = Document_Provenance_Parent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[35]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Provenance_Parent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Provenance_Parent) ProtoMessage() {}

func (x *Document_Provenance_Parent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[35]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Provenance_Parent.ProtoReflect.Descriptor instead.
func (*Document_Provenance_Parent) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 7, 0}
}

func (x *Document_Provenance_Parent) GetRevision() int32 {
	if x != nil {
		return x.Revision
	}
	return 0
}

func (x *Document_Provenance_Parent) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1/document.proto.
func (x *Document_Provenance_Parent) GetId() int32 {
	if x != nil {
		return x.Id
	}
	return 0
}

// Human Review information of the document.
type Document_Revision_HumanReview struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Human review state. e.g. `requested`, `succeeded`, `rejected`.
	State string `protobuf:"bytes,1,opt,name=state,proto3" json:"state,omitempty"`
	// A message providing more details about the current state of processing.
	// For example, the rejection reason when the state is `rejected`.
	StateMessage string `protobuf:"bytes,2,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
}

func (x *Document_Revision_HumanReview) Reset() {
	*x = Document_Revision_HumanReview{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[36]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Document_Revision_HumanReview) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Document_Revision_HumanReview) ProtoMessage() {}

func (x *Document_Revision_HumanReview) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1_document_proto_msgTypes[36]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Document_Revision_HumanReview.ProtoReflect.Descriptor instead.
func (*Document_Revision_HumanReview) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1_document_proto_rawDescGZIP(), []int{0, 8, 0}
}

func (x *Document_Revision_HumanReview) GetState() string {
	if x != nil {
		return x.State
	}
	return ""
}

func (x *Document_Revision_HumanReview) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

var File_google_cloud_documentai_v1_document_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1_document_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2f, 0x76, 0x31, 0x2f, 0x62, 0x61, 0x72, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x2f, 0x67,
	0x65, 0x6f, 0x6d, 0x65, 0x74, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x2f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61,
	0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70,
	0x65, 0x2f, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x70, 0x6f, 0x73, 0x74, 0x61,
	0x6c, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xe3, 0x53, 0x0a, 0x08, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x03,
	0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1f, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4f, 0x0a, 0x0b,
	0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x12, 0x3f, 0x0a,
	0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x52, 0x05, 0x70, 0x61, 0x67, 0x65, 0x73, 0x12, 0x47,
	0x0a, 0x08, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x08, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x5e, 0x0a, 0x10, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x52, 0x65,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x52, 0x0a, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x0b,
	0x74, 0x65, 0x78, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x12, 0x4d, 0x0a, 0x0a, 0x73,
	0x68, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x52,
	0x09, 0x73, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x4b, 0x0a, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65,
	0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x1a, 0x6e, 0x0a, 0x09, 0x53, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x68, 0x61, 0x72, 0x64, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x73, 0x68, 0x61, 0x72, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x1a, 0xd2, 0x03, 0x0a, 0x05, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x50, 0x0a, 0x0b, 0x74,
	0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f,
	0x72, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x28, 0x0a,
	0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72,
	0x52, 0x05, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x3d, 0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x67,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e,
	0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x77,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x6f, 0x6e,
	0x74, 0x57, 0x65, 0x69, 0x67, 0x68, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f,
	0x73, 0x74, 0x79, 0x6c, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x74, 0x65, 0x78,
	0x74, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x64,
	0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x74, 0x65, 0x78, 0x74, 0x44, 0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x50, 0x0a, 0x09, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x2e, 0x46,
	0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x52, 0x08, 0x66, 0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x66, 0x6f, 0x6e, 0x74, 0x46, 0x61, 0x6d, 0x69,
	0x6c, 0x79, 0x1a, 0x32, 0x0a, 0x08, 0x46, 0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x12,
	0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x04, 0x73, 0x69,
	0x7a, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x1a, 0x82, 0x32, 0x0a, 0x04, 0x50, 0x61, 0x67, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x45, 0x0a, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x52, 0x05, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x12, 0x50, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x6f, 0x72, 0x6d, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x52, 0x0a, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x12, 0x51, 0x0a, 0x09, 0x64, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x48, 0x0a, 0x06,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x69, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x73, 0x12, 0x47, 0x0a, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x52, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x67, 0x72,
	0x61, 0x70, 0x68, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x67, 0x72, 0x61, 0x70, 0x68, 0x73, 0x12,
	0x44, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x69, 0x6e, 0x65, 0x52, 0x05,
	0x6c, 0x69, 0x6e, 0x65, 0x73, 0x12, 0x47, 0x0a, 0x06, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18,
	0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x06, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x60,
	0x0a, 0x0f, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x5f, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x2e, 0x56, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x0e, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x12, 0x47, 0x0a, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x06, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x0b, 0x66, 0x6f, 0x72,
	0x6d, 0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x52, 0x0a, 0x66, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12,
	0x4a, 0x0a, 0x07, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x53, 0x79, 0x6d, 0x62,
	0x6f, 0x6c, 0x52, 0x07, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73, 0x12, 0x66, 0x0a, 0x11, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x61, 0x72, 0x63, 0x6f, 0x64, 0x65, 0x73,
	0x18, 0x0f, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67,
	0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x61, 0x72, 0x63, 0x6f, 0x64,
	0x65, 0x52, 0x10, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x61, 0x72, 0x63, 0x6f,
	0x64, 0x65, 0x73, 0x12, 0x6e, 0x0a, 0x14, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x71, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x11, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x52,
	0x12, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f,
	0x72, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x4d, 0x0a, 0x09, 0x44, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a, 0x06, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x06, 0x68, 0x65, 0x69,
	0x67, 0x68, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x1a, 0x6c, 0x0a, 0x05, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69,
	0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6d,
	0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x05, 0x77, 0x69, 0x64, 0x74, 0x68, 0x12, 0x16, 0x0a,
	0x06, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x68,
	0x65, 0x69, 0x67, 0x68, 0x74, 0x1a, 0x58, 0x0a, 0x06, 0x4d, 0x61, 0x74, 0x72, 0x69, 0x78, 0x12,
	0x12, 0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x72,
	0x6f, 0x77, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x6f, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x04, 0x63, 0x6f, 0x6c, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x1a,
	0x90, 0x03, 0x0a, 0x06, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x61, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72,
	0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x0d,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x6f, 0x6c, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x52, 0x0c, 0x62,
	0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x5e, 0x0a, 0x0b, 0x6f,
	0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f,
	0x75, 0x74, 0x2e, 0x4f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x0b, 0x4f,
	0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x4f, 0x52,
	0x49, 0x45, 0x4e, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x41, 0x47, 0x45, 0x5f,
	0x55, 0x50, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x50, 0x41, 0x47, 0x45, 0x5f, 0x52, 0x49, 0x47,
	0x48, 0x54, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x41, 0x47, 0x45, 0x5f, 0x44, 0x4f, 0x57,
	0x4e, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x41, 0x47, 0x45, 0x5f, 0x4c, 0x45, 0x46, 0x54,
	0x10, 0x04, 0x1a, 0x91, 0x02, 0x0a, 0x05, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x12, 0x48, 0x0a, 0x06,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06,
	0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x69, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x73, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x76,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x76,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x95, 0x02, 0x0a, 0x09, 0x50, 0x61, 0x72, 0x61, 0x67,
	0x72, 0x61, 0x70, 0x68, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e,
	0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x69,
	0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x90,
	0x02, 0x0a, 0x04, 0x4c, 0x69, 0x6e, 0x65, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x12, 0x69, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63,
	0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0a,
	0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x1a, 0x94, 0x09, 0x0a, 0x05, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x48, 0x0a, 0x06, 0x6c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x64, 0x0a, 0x0e, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2e, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x0d, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x12, 0x69, 0x0a, 0x12, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x58, 0x0a, 0x0a, 0x73,
	0x74, 0x79, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x2e, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x09, 0x73, 0x74, 0x79, 0x6c,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xac, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x12, 0x56, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42,
	0x72, 0x65, 0x61, 0x6b, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22,
	0x43, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a,
	0x05, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x57, 0x49, 0x44, 0x45,
	0x5f, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x48, 0x59, 0x50, 0x48,
	0x45, 0x4e, 0x10, 0x03, 0x1a, 0x91, 0x04, 0x0a, 0x09, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x1b, 0x0a, 0x09, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x66, 0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x26, 0x0a, 0x0f, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x5f, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x0d, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x46,
	0x6f, 0x6e, 0x74, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6c, 0x65, 0x74, 0x74, 0x65,
	0x72, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x0d, 0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x53, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x12, 0x1b,
	0x0a, 0x09, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x66, 0x6f, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x62,
	0x6f, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x62, 0x6f, 0x6c, 0x64, 0x12,
	0x16, 0x0a, 0x06, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x06, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x63, 0x12, 0x1e, 0x0a, 0x0a, 0x75, 0x6e, 0x64, 0x65, 0x72,
	0x6c, 0x69, 0x6e, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x75, 0x6e, 0x64,
	0x65, 0x72, 0x6c, 0x69, 0x6e, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x69, 0x6b,
	0x65, 0x6f, 0x75, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x74, 0x72, 0x69,
	0x6b, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x73, 0x75, 0x70, 0x65, 0x72, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x73, 0x75, 0x70, 0x65, 0x72, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x1c, 0x0a, 0x09, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x63, 0x61,
	0x70, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x63,
	0x61, 0x70, 0x73, 0x12, 0x1f, 0x0a, 0x0b, 0x66, 0x6f, 0x6e, 0x74, 0x5f, 0x77, 0x65, 0x69, 0x67,
	0x68, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x66, 0x6f, 0x6e, 0x74, 0x57, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x68, 0x61, 0x6e, 0x64, 0x77, 0x72, 0x69, 0x74,
	0x74, 0x65, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0b, 0x68, 0x61, 0x6e, 0x64, 0x77,
	0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x12, 0x31, 0x0a, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x63,
	0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x09,
	0x74, 0x65, 0x78, 0x74, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x12, 0x3d, 0x0a, 0x10, 0x62, 0x61, 0x63,
	0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x5f, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x52, 0x0f, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x43, 0x6f, 0x6c, 0x6f, 0x72, 0x1a, 0xbd, 0x01, 0x0a, 0x06, 0x53, 0x79, 0x6d,
	0x62, 0x6f, 0x6c, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x69, 0x0a,
	0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x1a, 0xd8, 0x01, 0x0a, 0x0d, 0x56, 0x69, 0x73,
	0x75, 0x61, 0x6c, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61,
	0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61,
	0x79, 0x6f, 0x75, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x69, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x73, 0x1a, 0x99, 0x06, 0x0a, 0x05, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x48, 0x0a,
	0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52,
	0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x59, 0x0a, 0x0b, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x54, 0x61,
	0x62, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x0a, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x52, 0x6f,
	0x77, 0x73, 0x12, 0x55, 0x0a, 0x09, 0x62, 0x6f, 0x64, 0x79, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x52,
	0x08, 0x62, 0x6f, 0x64, 0x79, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x69, 0x0a, 0x12, 0x64, 0x65, 0x74,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x52, 0x11, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0a, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x5b, 0x0a, 0x08, 0x54, 0x61, 0x62,
	0x6c, 0x65, 0x52, 0x6f, 0x77, 0x12, 0x4f, 0x0a, 0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x65, 0x6c, 0x6c, 0x52,
	0x05, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x1a, 0xf6, 0x01, 0x0a, 0x09, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x43, 0x65, 0x6c, 0x6c, 0x12, 0x48, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e,
	0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x19,
	0x0a, 0x08, 0x72, 0x6f, 0x77, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x07, 0x72, 0x6f, 0x77, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x63, 0x6f, 0x6c,
	0x5f, 0x73, 0x70, 0x61, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x07, 0x63, 0x6f, 0x6c,
	0x53, 0x70, 0x61, 0x6e, 0x12, 0x69, 0x0a, 0x12, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x11, 0x64, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x1a,
	0xe9, 0x04, 0x0a, 0x09, 0x46, 0x6f, 0x72, 0x6d, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x4f, 0x0a,
	0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79,
	0x6f, 0x75, 0x74, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x51,
	0x0a, 0x0b, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c,
	0x61, 0x79, 0x6f, 0x75, 0x74, 0x52, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x72, 0x0a, 0x17, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x44, 0x65,
	0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x52, 0x15,
	0x6e, 0x61, 0x6d, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67,
	0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x74, 0x0a, 0x18, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x52, 0x16, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x6f,
	0x72, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x4b, 0x65, 0x79, 0x54, 0x65, 0x78, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f, 0x72, 0x72,
	0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x54, 0x65, 0x78, 0x74, 0x12, 0x4f, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x1a, 0x9a, 0x01, 0x0a, 0x0f,
	0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x42, 0x61, 0x72, 0x63, 0x6f, 0x64, 0x65, 0x12,
	0x48, 0x0a, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x52, 0x06, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x12, 0x3d, 0x0a, 0x07, 0x62, 0x61, 0x72,
	0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x72, 0x63, 0x6f, 0x64, 0x65, 0x52,
	0x07, 0x62, 0x61, 0x72, 0x63, 0x6f, 0x64, 0x65, 0x1a, 0x57, 0x0a, 0x10, 0x44, 0x65, 0x74, 0x65,
	0x63, 0x74, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x23, 0x0a, 0x0d,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64,
	0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x1a, 0xf7, 0x01, 0x0a, 0x12, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x71, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x0c, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x76, 0x0a,
	0x10, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x65, 0x63, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53,
	0x63, 0x6f, 0x72, 0x65, 0x73, 0x2e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65,
	0x66, 0x65, 0x63, 0x74, 0x52, 0x0f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65,
	0x66, 0x65, 0x63, 0x74, 0x73, 0x1a, 0x44, 0x0a, 0x0e, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65,
	0x64, 0x44, 0x65, 0x66, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52,
	0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0xab, 0x08, 0x0a, 0x06,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x12, 0x55, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61,
	0x6e, 0x63, 0x68, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x17, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x78, 0x74, 0x12, 0x22,
	0x0a, 0x0a, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x64, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x55, 0x0a, 0x0b, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x61, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x13,
	0x0a, 0x02, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x02, 0x69, 0x64, 0x12, 0x6b, 0x0a, 0x10, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x4e, 0x6f, 0x72, 0x6d, 0x61,
	0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x6e, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x50, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x12, 0x54, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x50, 0x72, 0x6f,
	0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x72, 0x65, 0x64, 0x61,
	0x63, 0x74, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x72, 0x65, 0x64, 0x61, 0x63, 0x74, 0x65, 0x64, 0x1a, 0x9d, 0x03, 0x0a, 0x0f, 0x4e, 0x6f,
	0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x35, 0x0a,
	0x0b, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65,
	0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x32, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x48, 0x00, 0x52, 0x09, 0x64,
	0x61, 0x74, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3e, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x65,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x65, 0x74,
	0x69, 0x6d, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x41, 0x0a, 0x0d, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x6f,
	0x73, 0x74, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x62,
	0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x08, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x6f, 0x6f, 0x6c, 0x65, 0x61, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x74,
	0x65, 0x67, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x66, 0x6c, 0x6f,
	0x61, 0x74, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00,
	0x52, 0x0a, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x42, 0x12, 0x0a, 0x10, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x68, 0x0a, 0x0e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x73,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1b, 0x0a, 0x09, 0x6f, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0xd5, 0x01, 0x0a, 0x0a, 0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68,
	0x6f, 0x72, 0x12, 0x60, 0x0a, 0x0d, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x54, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x2e, 0x54, 0x65, 0x78, 0x74, 0x53,
	0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x74, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x1a, 0x4b,
	0x0a, 0x0b, 0x54, 0x65, 0x78, 0x74, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x1b,
	0x0a, 0x09, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x1a, 0x98, 0x04, 0x0a, 0x0a,
	0x50, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x12, 0x54, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x2e, 0x50,
	0x61, 0x67, 0x65, 0x52, 0x65, 0x66, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x52, 0x65, 0x66, 0x73,
	0x1a, 0xb3, 0x03, 0x0a, 0x07, 0x50, 0x61, 0x67, 0x65, 0x52, 0x65, 0x66, 0x12, 0x17, 0x0a, 0x04,
	0x70, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x70, 0x61, 0x67, 0x65, 0x12, 0x68, 0x0a, 0x0b, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x50, 0x61, 0x67, 0x65, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x2e, 0x50, 0x61, 0x67, 0x65,
	0x52, 0x65, 0x66, 0x2e, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x22, 0x0a, 0x09, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52, 0x08, 0x6c, 0x61, 0x79, 0x6f, 0x75,
	0x74, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x0d, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f,
	0x70, 0x6f, 0x6c, 0x79, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x50, 0x6f, 0x6c, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x62, 0x6f, 0x75, 0x6e, 0x64,
	0x69, 0x6e, 0x67, 0x50, 0x6f, 0x6c, 0x79, 0x12, 0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x87, 0x01, 0x0a,
	0x0a, 0x4c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x4c,
	0x41, 0x59, 0x4f, 0x55, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x4c, 0x4f, 0x43,
	0x4b, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x50, 0x41, 0x52, 0x41, 0x47, 0x52, 0x41, 0x50, 0x48,
	0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05,
	0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x56, 0x49, 0x53, 0x55, 0x41,
	0x4c, 0x5f, 0x45, 0x4c, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x54,
	0x41, 0x42, 0x4c, 0x45, 0x10, 0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x4f, 0x52, 0x4d, 0x5f, 0x46,
	0x49, 0x45, 0x4c, 0x44, 0x10, 0x07, 0x1a, 0xda, 0x03, 0x0a, 0x0a, 0x50, 0x72, 0x6f, 0x76, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x02, 0x69, 0x64, 0x12, 0x50, 0x0a, 0x07, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x52, 0x07, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x51, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
	0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x4e,
	0x0a, 0x06, 0x50, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x12, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x02, 0x69, 0x64, 0x22, 0xa2,
	0x01, 0x0a, 0x0d, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1e, 0x0a, 0x1a, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x41, 0x44, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x52, 0x45, 0x4d,
	0x4f, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x55, 0x50, 0x44, 0x41, 0x54, 0x45, 0x10,
	0x07, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x03, 0x12, 0x16,
	0x0a, 0x0e, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x45, 0x44,
	0x10, 0x04, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x15, 0x0a, 0x0d, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x41,
	0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x44, 0x10, 0x05, 0x1a, 0x02, 0x08, 0x01, 0x12, 0x14, 0x0a,
	0x0c, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x53, 0x4b, 0x49, 0x50, 0x50, 0x45, 0x44, 0x10, 0x06, 0x1a,
	0x02, 0x08, 0x01, 0x1a, 0xfc, 0x02, 0x0a, 0x08, 0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x16, 0x0a, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x00, 0x52, 0x05, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x09, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x69,
	0x64, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x5c, 0x0a, 0x0c, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x5f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x52, 0x0b, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x1a, 0x48,
	0x0a, 0x0b, 0x48, 0x75, 0x6d, 0x61, 0x6e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x14, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x1a, 0xd6, 0x01, 0x0a, 0x0a, 0x54, 0x65, 0x78, 0x74, 0x43, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x12, 0x50, 0x0a, 0x0b, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x61, 0x6e, 0x63, 0x68, 0x6f, 0x72,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x54, 0x65, 0x78,
	0x74, 0x41, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x52, 0x0a, 0x74, 0x65, 0x78, 0x74, 0x41, 0x6e, 0x63,
	0x68, 0x6f, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x68, 0x61, 0x6e, 0x67,
	0x65, 0x64, 0x54, 0x65, 0x78, 0x74, 0x12, 0x53, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x02, 0x18, 0x01, 0x52,
	0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0xcb, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62, 0x3b, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62, 0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_documentai_v1_document_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1_document_proto_rawDescData = file_google_cloud_documentai_v1_document_proto_rawDesc
)

func file_google_cloud_documentai_v1_document_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1_document_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1_document_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1_document_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1_document_proto_rawDescData
}

var file_google_cloud_documentai_v1_document_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_documentai_v1_document_proto_msgTypes = make([]protoimpl.MessageInfo, 37)
var file_google_cloud_documentai_v1_document_proto_goTypes = []interface{}{
	(Document_Page_Layout_Orientation)(0),                   // 0: google.cloud.documentai.v1.Document.Page.Layout.Orientation
	(Document_Page_Token_DetectedBreak_Type)(0),             // 1: google.cloud.documentai.v1.Document.Page.Token.DetectedBreak.Type
	(Document_PageAnchor_PageRef_LayoutType)(0),             // 2: google.cloud.documentai.v1.Document.PageAnchor.PageRef.LayoutType
	(Document_Provenance_OperationType)(0),                  // 3: google.cloud.documentai.v1.Document.Provenance.OperationType
	(*Document)(nil),                                        // 4: google.cloud.documentai.v1.Document
	(*Document_ShardInfo)(nil),                              // 5: google.cloud.documentai.v1.Document.ShardInfo
	(*Document_Style)(nil),                                  // 6: google.cloud.documentai.v1.Document.Style
	(*Document_Page)(nil),                                   // 7: google.cloud.documentai.v1.Document.Page
	(*Document_Entity)(nil),                                 // 8: google.cloud.documentai.v1.Document.Entity
	(*Document_EntityRelation)(nil),                         // 9: google.cloud.documentai.v1.Document.EntityRelation
	(*Document_TextAnchor)(nil),                             // 10: google.cloud.documentai.v1.Document.TextAnchor
	(*Document_PageAnchor)(nil),                             // 11: google.cloud.documentai.v1.Document.PageAnchor
	(*Document_Provenance)(nil),                             // 12: google.cloud.documentai.v1.Document.Provenance
	(*Document_Revision)(nil),                               // 13: google.cloud.documentai.v1.Document.Revision
	(*Document_TextChange)(nil),                             // 14: google.cloud.documentai.v1.Document.TextChange
	(*Document_Style_FontSize)(nil),                         // 15: google.cloud.documentai.v1.Document.Style.FontSize
	(*Document_Page_Dimension)(nil),                         // 16: google.cloud.documentai.v1.Document.Page.Dimension
	(*Document_Page_Image)(nil),                             // 17: google.cloud.documentai.v1.Document.Page.Image
	(*Document_Page_Matrix)(nil),                            // 18: google.cloud.documentai.v1.Document.Page.Matrix
	(*Document_Page_Layout)(nil),                            // 19: google.cloud.documentai.v1.Document.Page.Layout
	(*Document_Page_Block)(nil),                             // 20: google.cloud.documentai.v1.Document.Page.Block
	(*Document_Page_Paragraph)(nil),                         // 21: google.cloud.documentai.v1.Document.Page.Paragraph
	(*Document_Page_Line)(nil),                              // 22: google.cloud.documentai.v1.Document.Page.Line
	(*Document_Page_Token)(nil),                             // 23: google.cloud.documentai.v1.Document.Page.Token
	(*Document_Page_Symbol)(nil),                            // 24: google.cloud.documentai.v1.Document.Page.Symbol
	(*Document_Page_VisualElement)(nil),                     // 25: google.cloud.documentai.v1.Document.Page.VisualElement
	(*Document_Page_Table)(nil),                             // 26: google.cloud.documentai.v1.Document.Page.Table
	(*Document_Page_FormField)(nil),                         // 27: google.cloud.documentai.v1.Document.Page.FormField
	(*Document_Page_DetectedBarcode)(nil),                   // 28: google.cloud.documentai.v1.Document.Page.DetectedBarcode
	(*Document_Page_DetectedLanguage)(nil),                  // 29: google.cloud.documentai.v1.Document.Page.DetectedLanguage
	(*Document_Page_ImageQualityScores)(nil),                // 30: google.cloud.documentai.v1.Document.Page.ImageQualityScores
	(*Document_Page_Token_DetectedBreak)(nil),               // 31: google.cloud.documentai.v1.Document.Page.Token.DetectedBreak
	(*Document_Page_Token_StyleInfo)(nil),                   // 32: google.cloud.documentai.v1.Document.Page.Token.StyleInfo
	(*Document_Page_Table_TableRow)(nil),                    // 33: google.cloud.documentai.v1.Document.Page.Table.TableRow
	(*Document_Page_Table_TableCell)(nil),                   // 34: google.cloud.documentai.v1.Document.Page.Table.TableCell
	(*Document_Page_ImageQualityScores_DetectedDefect)(nil), // 35: google.cloud.documentai.v1.Document.Page.ImageQualityScores.DetectedDefect
	(*Document_Entity_NormalizedValue)(nil),                 // 36: google.cloud.documentai.v1.Document.Entity.NormalizedValue
	(*Document_TextAnchor_TextSegment)(nil),                 // 37: google.cloud.documentai.v1.Document.TextAnchor.TextSegment
	(*Document_PageAnchor_PageRef)(nil),                     // 38: google.cloud.documentai.v1.Document.PageAnchor.PageRef
	(*Document_Provenance_Parent)(nil),                      // 39: google.cloud.documentai.v1.Document.Provenance.Parent
	(*Document_Revision_HumanReview)(nil),                   // 40: google.cloud.documentai.v1.Document.Revision.HumanReview
	(*status.Status)(nil),                                   // 41: google.rpc.Status
	(*color.Color)(nil),                                     // 42: google.type.Color
	(*timestamppb.Timestamp)(nil),                           // 43: google.protobuf.Timestamp
	(*BoundingPoly)(nil),                                    // 44: google.cloud.documentai.v1.BoundingPoly
	(*Barcode)(nil),                                         // 45: google.cloud.documentai.v1.Barcode
	(*money.Money)(nil),                                     // 46: google.type.Money
	(*date.Date)(nil),                                       // 47: google.type.Date
	(*datetime.DateTime)(nil),                               // 48: google.type.DateTime
	(*postaladdress.PostalAddress)(nil),                     // 49: google.type.PostalAddress
}
var file_google_cloud_documentai_v1_document_proto_depIdxs = []int32{
	6,  // 0: google.cloud.documentai.v1.Document.text_styles:type_name -> google.cloud.documentai.v1.Document.Style
	7,  // 1: google.cloud.documentai.v1.Document.pages:type_name -> google.cloud.documentai.v1.Document.Page
	8,  // 2: google.cloud.documentai.v1.Document.entities:type_name -> google.cloud.documentai.v1.Document.Entity
	9,  // 3: google.cloud.documentai.v1.Document.entity_relations:type_name -> google.cloud.documentai.v1.Document.EntityRelation
	14, // 4: google.cloud.documentai.v1.Document.text_changes:type_name -> google.cloud.documentai.v1.Document.TextChange
	5,  // 5: google.cloud.documentai.v1.Document.shard_info:type_name -> google.cloud.documentai.v1.Document.ShardInfo
	41, // 6: google.cloud.documentai.v1.Document.error:type_name -> google.rpc.Status
	13, // 7: google.cloud.documentai.v1.Document.revisions:type_name -> google.cloud.documentai.v1.Document.Revision
	10, // 8: google.cloud.documentai.v1.Document.Style.text_anchor:type_name -> google.cloud.documentai.v1.Document.TextAnchor
	42, // 9: google.cloud.documentai.v1.Document.Style.color:type_name -> google.type.Color
	42, // 10: google.cloud.documentai.v1.Document.Style.background_color:type_name -> google.type.Color
	15, // 11: google.cloud.documentai.v1.Document.Style.font_size:type_name -> google.cloud.documentai.v1.Document.Style.FontSize
	17, // 12: google.cloud.documentai.v1.Document.Page.image:type_name -> google.cloud.documentai.v1.Document.Page.Image
	18, // 13: google.cloud.documentai.v1.Document.Page.transforms:type_name -> google.cloud.documentai.v1.Document.Page.Matrix
	16, // 14: google.cloud.documentai.v1.Document.Page.dimension:type_name -> google.cloud.documentai.v1.Document.Page.Dimension
	19, // 15: google.cloud.documentai.v1.Document.Page.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	29, // 16: google.cloud.documentai.v1.Document.Page.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	20, // 17: google.cloud.documentai.v1.Document.Page.blocks:type_name -> google.cloud.documentai.v1.Document.Page.Block
	21, // 18: google.cloud.documentai.v1.Document.Page.paragraphs:type_name -> google.cloud.documentai.v1.Document.Page.Paragraph
	22, // 19: google.cloud.documentai.v1.Document.Page.lines:type_name -> google.cloud.documentai.v1.Document.Page.Line
	23, // 20: google.cloud.documentai.v1.Document.Page.tokens:type_name -> google.cloud.documentai.v1.Document.Page.Token
	25, // 21: google.cloud.documentai.v1.Document.Page.visual_elements:type_name -> google.cloud.documentai.v1.Document.Page.VisualElement
	26, // 22: google.cloud.documentai.v1.Document.Page.tables:type_name -> google.cloud.documentai.v1.Document.Page.Table
	27, // 23: google.cloud.documentai.v1.Document.Page.form_fields:type_name -> google.cloud.documentai.v1.Document.Page.FormField
	24, // 24: google.cloud.documentai.v1.Document.Page.symbols:type_name -> google.cloud.documentai.v1.Document.Page.Symbol
	28, // 25: google.cloud.documentai.v1.Document.Page.detected_barcodes:type_name -> google.cloud.documentai.v1.Document.Page.DetectedBarcode
	30, // 26: google.cloud.documentai.v1.Document.Page.image_quality_scores:type_name -> google.cloud.documentai.v1.Document.Page.ImageQualityScores
	12, // 27: google.cloud.documentai.v1.Document.Page.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	10, // 28: google.cloud.documentai.v1.Document.Entity.text_anchor:type_name -> google.cloud.documentai.v1.Document.TextAnchor
	11, // 29: google.cloud.documentai.v1.Document.Entity.page_anchor:type_name -> google.cloud.documentai.v1.Document.PageAnchor
	36, // 30: google.cloud.documentai.v1.Document.Entity.normalized_value:type_name -> google.cloud.documentai.v1.Document.Entity.NormalizedValue
	8,  // 31: google.cloud.documentai.v1.Document.Entity.properties:type_name -> google.cloud.documentai.v1.Document.Entity
	12, // 32: google.cloud.documentai.v1.Document.Entity.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	37, // 33: google.cloud.documentai.v1.Document.TextAnchor.text_segments:type_name -> google.cloud.documentai.v1.Document.TextAnchor.TextSegment
	38, // 34: google.cloud.documentai.v1.Document.PageAnchor.page_refs:type_name -> google.cloud.documentai.v1.Document.PageAnchor.PageRef
	39, // 35: google.cloud.documentai.v1.Document.Provenance.parents:type_name -> google.cloud.documentai.v1.Document.Provenance.Parent
	3,  // 36: google.cloud.documentai.v1.Document.Provenance.type:type_name -> google.cloud.documentai.v1.Document.Provenance.OperationType
	43, // 37: google.cloud.documentai.v1.Document.Revision.create_time:type_name -> google.protobuf.Timestamp
	40, // 38: google.cloud.documentai.v1.Document.Revision.human_review:type_name -> google.cloud.documentai.v1.Document.Revision.HumanReview
	10, // 39: google.cloud.documentai.v1.Document.TextChange.text_anchor:type_name -> google.cloud.documentai.v1.Document.TextAnchor
	12, // 40: google.cloud.documentai.v1.Document.TextChange.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	10, // 41: google.cloud.documentai.v1.Document.Page.Layout.text_anchor:type_name -> google.cloud.documentai.v1.Document.TextAnchor
	44, // 42: google.cloud.documentai.v1.Document.Page.Layout.bounding_poly:type_name -> google.cloud.documentai.v1.BoundingPoly
	0,  // 43: google.cloud.documentai.v1.Document.Page.Layout.orientation:type_name -> google.cloud.documentai.v1.Document.Page.Layout.Orientation
	19, // 44: google.cloud.documentai.v1.Document.Page.Block.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	29, // 45: google.cloud.documentai.v1.Document.Page.Block.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	12, // 46: google.cloud.documentai.v1.Document.Page.Block.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	19, // 47: google.cloud.documentai.v1.Document.Page.Paragraph.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	29, // 48: google.cloud.documentai.v1.Document.Page.Paragraph.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	12, // 49: google.cloud.documentai.v1.Document.Page.Paragraph.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	19, // 50: google.cloud.documentai.v1.Document.Page.Line.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	29, // 51: google.cloud.documentai.v1.Document.Page.Line.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	12, // 52: google.cloud.documentai.v1.Document.Page.Line.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	19, // 53: google.cloud.documentai.v1.Document.Page.Token.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	31, // 54: google.cloud.documentai.v1.Document.Page.Token.detected_break:type_name -> google.cloud.documentai.v1.Document.Page.Token.DetectedBreak
	29, // 55: google.cloud.documentai.v1.Document.Page.Token.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	12, // 56: google.cloud.documentai.v1.Document.Page.Token.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	32, // 57: google.cloud.documentai.v1.Document.Page.Token.style_info:type_name -> google.cloud.documentai.v1.Document.Page.Token.StyleInfo
	19, // 58: google.cloud.documentai.v1.Document.Page.Symbol.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	29, // 59: google.cloud.documentai.v1.Document.Page.Symbol.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	19, // 60: google.cloud.documentai.v1.Document.Page.VisualElement.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	29, // 61: google.cloud.documentai.v1.Document.Page.VisualElement.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	19, // 62: google.cloud.documentai.v1.Document.Page.Table.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	33, // 63: google.cloud.documentai.v1.Document.Page.Table.header_rows:type_name -> google.cloud.documentai.v1.Document.Page.Table.TableRow
	33, // 64: google.cloud.documentai.v1.Document.Page.Table.body_rows:type_name -> google.cloud.documentai.v1.Document.Page.Table.TableRow
	29, // 65: google.cloud.documentai.v1.Document.Page.Table.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	12, // 66: google.cloud.documentai.v1.Document.Page.Table.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	19, // 67: google.cloud.documentai.v1.Document.Page.FormField.field_name:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	19, // 68: google.cloud.documentai.v1.Document.Page.FormField.field_value:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	29, // 69: google.cloud.documentai.v1.Document.Page.FormField.name_detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	29, // 70: google.cloud.documentai.v1.Document.Page.FormField.value_detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	12, // 71: google.cloud.documentai.v1.Document.Page.FormField.provenance:type_name -> google.cloud.documentai.v1.Document.Provenance
	19, // 72: google.cloud.documentai.v1.Document.Page.DetectedBarcode.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	45, // 73: google.cloud.documentai.v1.Document.Page.DetectedBarcode.barcode:type_name -> google.cloud.documentai.v1.Barcode
	35, // 74: google.cloud.documentai.v1.Document.Page.ImageQualityScores.detected_defects:type_name -> google.cloud.documentai.v1.Document.Page.ImageQualityScores.DetectedDefect
	1,  // 75: google.cloud.documentai.v1.Document.Page.Token.DetectedBreak.type:type_name -> google.cloud.documentai.v1.Document.Page.Token.DetectedBreak.Type
	42, // 76: google.cloud.documentai.v1.Document.Page.Token.StyleInfo.text_color:type_name -> google.type.Color
	42, // 77: google.cloud.documentai.v1.Document.Page.Token.StyleInfo.background_color:type_name -> google.type.Color
	34, // 78: google.cloud.documentai.v1.Document.Page.Table.TableRow.cells:type_name -> google.cloud.documentai.v1.Document.Page.Table.TableCell
	19, // 79: google.cloud.documentai.v1.Document.Page.Table.TableCell.layout:type_name -> google.cloud.documentai.v1.Document.Page.Layout
	29, // 80: google.cloud.documentai.v1.Document.Page.Table.TableCell.detected_languages:type_name -> google.cloud.documentai.v1.Document.Page.DetectedLanguage
	46, // 81: google.cloud.documentai.v1.Document.Entity.NormalizedValue.money_value:type_name -> google.type.Money
	47, // 82: google.cloud.documentai.v1.Document.Entity.NormalizedValue.date_value:type_name -> google.type.Date
	48, // 83: google.cloud.documentai.v1.Document.Entity.NormalizedValue.datetime_value:type_name -> google.type.DateTime
	49, // 84: google.cloud.documentai.v1.Document.Entity.NormalizedValue.address_value:type_name -> google.type.PostalAddress
	2,  // 85: google.cloud.documentai.v1.Document.PageAnchor.PageRef.layout_type:type_name -> google.cloud.documentai.v1.Document.PageAnchor.PageRef.LayoutType
	44, // 86: google.cloud.documentai.v1.Document.PageAnchor.PageRef.bounding_poly:type_name -> google.cloud.documentai.v1.BoundingPoly
	87, // [87:87] is the sub-list for method output_type
	87, // [87:87] is the sub-list for method input_type
	87, // [87:87] is the sub-list for extension type_name
	87, // [87:87] is the sub-list for extension extendee
	0,  // [0:87] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1_document_proto_init() }
func file_google_cloud_documentai_v1_document_proto_init() {
	if File_google_cloud_documentai_v1_document_proto != nil {
		return
	}
	file_google_cloud_documentai_v1_barcode_proto_init()
	file_google_cloud_documentai_v1_geometry_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_documentai_v1_document_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_ShardInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Style); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Entity); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_EntityRelation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_TextAnchor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_PageAnchor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Provenance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Revision); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_TextChange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Style_FontSize); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Dimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Image); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Matrix); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Layout); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Block); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Paragraph); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Line); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Token); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Symbol); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_VisualElement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Table); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_FormField); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_DetectedBarcode); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_DetectedLanguage); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_ImageQualityScores); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Token_DetectedBreak); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Token_StyleInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Table_TableRow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[30].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_Table_TableCell); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[31].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Page_ImageQualityScores_DetectedDefect); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[32].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Entity_NormalizedValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[33].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_TextAnchor_TextSegment); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[34].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_PageAnchor_PageRef); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[35].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Provenance_Parent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1_document_proto_msgTypes[36].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Document_Revision_HumanReview); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_documentai_v1_document_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Document_Uri)(nil),
		(*Document_Content)(nil),
	}
	file_google_cloud_documentai_v1_document_proto_msgTypes[9].OneofWrappers = []interface{}{
		(*Document_Revision_Agent)(nil),
		(*Document_Revision_Processor)(nil),
	}
	file_google_cloud_documentai_v1_document_proto_msgTypes[32].OneofWrappers = []interface{}{
		(*Document_Entity_NormalizedValue_MoneyValue)(nil),
		(*Document_Entity_NormalizedValue_DateValue)(nil),
		(*Document_Entity_NormalizedValue_DatetimeValue)(nil),
		(*Document_Entity_NormalizedValue_AddressValue)(nil),
		(*Document_Entity_NormalizedValue_BooleanValue)(nil),
		(*Document_Entity_NormalizedValue_IntegerValue)(nil),
		(*Document_Entity_NormalizedValue_FloatValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1_document_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   37,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_documentai_v1_document_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1_document_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1_document_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1_document_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1_document_proto = out.File
	file_google_cloud_documentai_v1_document_proto_rawDesc = nil
	file_google_cloud_documentai_v1_document_proto_goTypes = nil
	file_google_cloud_documentai_v1_document_proto_depIdxs = nil
}
