//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armappcontainers

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ContainerAppsAPIClient contains the methods for the ContainerAppsAPIClient group.
// Don't use this type directly, use NewContainerAppsAPIClient() instead.
type ContainerAppsAPIClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewContainerAppsAPIClient creates a new instance of ContainerAppsAPIClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewContainerAppsAPIClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ContainerAppsAPIClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ContainerAppsAPIClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// GetCustomDomainVerificationID - Get the verification id of a subscription used for verifying custom domains
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01
//   - options - ContainerAppsAPIClientGetCustomDomainVerificationIDOptions contains the optional parameters for the ContainerAppsAPIClient.GetCustomDomainVerificationID
//     method.
func (client *ContainerAppsAPIClient) GetCustomDomainVerificationID(ctx context.Context, options *ContainerAppsAPIClientGetCustomDomainVerificationIDOptions) (ContainerAppsAPIClientGetCustomDomainVerificationIDResponse, error) {
	var err error
	const operationName = "ContainerAppsAPIClient.GetCustomDomainVerificationID"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCustomDomainVerificationIDCreateRequest(ctx, options)
	if err != nil {
		return ContainerAppsAPIClientGetCustomDomainVerificationIDResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ContainerAppsAPIClientGetCustomDomainVerificationIDResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ContainerAppsAPIClientGetCustomDomainVerificationIDResponse{}, err
	}
	resp, err := client.getCustomDomainVerificationIDHandleResponse(httpResp)
	return resp, err
}

// getCustomDomainVerificationIDCreateRequest creates the GetCustomDomainVerificationID request.
func (client *ContainerAppsAPIClient) getCustomDomainVerificationIDCreateRequest(ctx context.Context, options *ContainerAppsAPIClientGetCustomDomainVerificationIDOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.App/getCustomDomainVerificationId"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getCustomDomainVerificationIDHandleResponse handles the GetCustomDomainVerificationID response.
func (client *ContainerAppsAPIClient) getCustomDomainVerificationIDHandleResponse(resp *http.Response) (ContainerAppsAPIClientGetCustomDomainVerificationIDResponse, error) {
	result := ContainerAppsAPIClientGetCustomDomainVerificationIDResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Value); err != nil {
		return ContainerAppsAPIClientGetCustomDomainVerificationIDResponse{}, err
	}
	return result, nil
}

// JobExecution - Get details of a single job execution
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2024-03-01
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - jobName - Job Name
//   - jobExecutionName - Job execution name.
//   - options - ContainerAppsAPIClientJobExecutionOptions contains the optional parameters for the ContainerAppsAPIClient.JobExecution
//     method.
func (client *ContainerAppsAPIClient) JobExecution(ctx context.Context, resourceGroupName string, jobName string, jobExecutionName string, options *ContainerAppsAPIClientJobExecutionOptions) (ContainerAppsAPIClientJobExecutionResponse, error) {
	var err error
	const operationName = "ContainerAppsAPIClient.JobExecution"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.jobExecutionCreateRequest(ctx, resourceGroupName, jobName, jobExecutionName, options)
	if err != nil {
		return ContainerAppsAPIClientJobExecutionResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ContainerAppsAPIClientJobExecutionResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ContainerAppsAPIClientJobExecutionResponse{}, err
	}
	resp, err := client.jobExecutionHandleResponse(httpResp)
	return resp, err
}

// jobExecutionCreateRequest creates the JobExecution request.
func (client *ContainerAppsAPIClient) jobExecutionCreateRequest(ctx context.Context, resourceGroupName string, jobName string, jobExecutionName string, options *ContainerAppsAPIClientJobExecutionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.App/jobs/{jobName}/executions/{jobExecutionName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if jobName == "" {
		return nil, errors.New("parameter jobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{jobName}", url.PathEscape(jobName))
	if jobExecutionName == "" {
		return nil, errors.New("parameter jobExecutionName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{jobExecutionName}", url.PathEscape(jobExecutionName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2024-03-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// jobExecutionHandleResponse handles the JobExecution response.
func (client *ContainerAppsAPIClient) jobExecutionHandleResponse(resp *http.Response) (ContainerAppsAPIClientJobExecutionResponse, error) {
	result := ContainerAppsAPIClientJobExecutionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.JobExecution); err != nil {
		return ContainerAppsAPIClientJobExecutionResponse{}, err
	}
	return result, nil
}
