// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/osconfig/v1alpha/os_policy_assignment_reports.proto

package osconfigpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Possible compliance states for an os policy.
type OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState int32

const (
	// The policy is in an unknown compliance state.
	//
	// Refer to the field `compliance_state_reason` to learn the exact reason
	// for the policy to be in this compliance state.
	OSPolicyAssignmentReport_OSPolicyCompliance_UNKNOWN OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState = 0
	// Policy is compliant.
	//
	// The policy is compliant if all the underlying resources are also
	// compliant.
	OSPolicyAssignmentReport_OSPolicyCompliance_COMPLIANT OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState = 1
	// Policy is non-compliant.
	//
	// The policy is non-compliant if one or more underlying resources are
	// non-compliant.
	OSPolicyAssignmentReport_OSPolicyCompliance_NON_COMPLIANT OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState = 2
)

// Enum value maps for OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState.
var (
	OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState_name = map[int32]string{
		0: "UNKNOWN",
		1: "COMPLIANT",
		2: "NON_COMPLIANT",
	}
	OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState_value = map[string]int32{
		"UNKNOWN":       0,
		"COMPLIANT":     1,
		"NON_COMPLIANT": 2,
	}
)

func (x OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState) Enum() *OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState {
	p := new(OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState)
	*p = x
	return p
}

func (x OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_enumTypes[0].Descriptor()
}

func (OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_enumTypes[0]
}

func (x OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState.Descriptor instead.
func (OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{3, 0, 0}
}

// Possible compliance states for a resource.
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState int32

const (
	// The resource is in an unknown compliance state.
	//
	// To get more details about why the policy is in this state, review
	// the output of the `compliance_state_reason` field.
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_UNKNOWN OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState = 0
	// Resource is compliant.
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_COMPLIANT OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState = 1
	// Resource is non-compliant.
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_NON_COMPLIANT OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState = 2
)

// Enum value maps for OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState.
var (
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState_name = map[int32]string{
		0: "UNKNOWN",
		1: "COMPLIANT",
		2: "NON_COMPLIANT",
	}
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState_value = map[string]int32{
		"UNKNOWN":       0,
		"COMPLIANT":     1,
		"NON_COMPLIANT": 2,
	}
)

func (x OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState) Enum() *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState {
	p := new(OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState)
	*p = x
	return p
}

func (x OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_enumTypes[1].Descriptor()
}

func (OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_enumTypes[1]
}

func (x OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState.Descriptor instead.
func (OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{3, 0, 0, 0}
}

// Supported configuration step types
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type int32

const (
	// Default value. This value is unused.
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_TYPE_UNSPECIFIED OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type = 0
	// Checks for resource conflicts such as schema errors.
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_VALIDATION OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type = 1
	// Checks the current status of the desired state for a resource.
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_CHECK OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type = 2
	// Enforces the desired state for a resource that is not in desired
	// state.
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_ENFORCEMENT OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type = 3
	// Re-checks the status of the desired state. This check is done
	// for a resource after the enforcement of all OS policies.
	//
	// This step is used to determine the final desired state status for
	// the resource. It accounts for any resources that might have drifted
	// from their desired state due to side effects from executing other
	// resources.
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_DESIRED_STATE_CHECK_POST_ENFORCEMENT OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type = 4
)

// Enum value maps for OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type.
var (
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "VALIDATION",
		2: "DESIRED_STATE_CHECK",
		3: "DESIRED_STATE_ENFORCEMENT",
		4: "DESIRED_STATE_CHECK_POST_ENFORCEMENT",
	}
	OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":                     0,
		"VALIDATION":                           1,
		"DESIRED_STATE_CHECK":                  2,
		"DESIRED_STATE_ENFORCEMENT":            3,
		"DESIRED_STATE_CHECK_POST_ENFORCEMENT": 4,
	}
)

func (x OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type) Enum() *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type {
	p := new(OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type)
	*p = x
	return p
}

func (x OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_enumTypes[2].Descriptor()
}

func (OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_enumTypes[2]
}

func (x OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type.Descriptor instead.
func (OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{3, 0, 0, 0, 0}
}

// Get a report of the OS policy assignment for a VM instance.
type GetOSPolicyAssignmentReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. API resource name for OS policy assignment report.
	//
	// Format:
	// `/projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/report`
	//
	// For `{project}`, either `project-number` or `project-id` can be provided.
	// For `{instance_id}`, either Compute Engine `instance-id` or `instance-name`
	// can be provided.
	// For `{assignment_id}`, the OSPolicyAssignment id must be provided.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetOSPolicyAssignmentReportRequest) Reset() {
	*x = GetOSPolicyAssignmentReportRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetOSPolicyAssignmentReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetOSPolicyAssignmentReportRequest) ProtoMessage() {}

func (x *GetOSPolicyAssignmentReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetOSPolicyAssignmentReportRequest.ProtoReflect.Descriptor instead.
func (*GetOSPolicyAssignmentReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{0}
}

func (x *GetOSPolicyAssignmentReportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// List the OS policy assignment reports for VM instances.
type ListOSPolicyAssignmentReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource name.
	//
	// Format:
	// `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/{assignment}/reports`
	//
	// For `{project}`, either `project-number` or `project-id` can be provided.
	// For `{instance}`, either `instance-name`, `instance-id`, or `-` can be
	// provided. If '-' is provided, the response will include
	// OSPolicyAssignmentReports for all instances in the project/location.
	// For `{assignment}`, either `assignment-id` or `-` can be provided. If '-'
	// is provided, the response will include OSPolicyAssignmentReports for all
	// OSPolicyAssignments in the project/location.
	// Either {instance} or {assignment} must be `-`.
	//
	// For example:
	// `projects/{project}/locations/{location}/instances/{instance}/osPolicyAssignments/-/reports`
	//
	//	returns all reports for the instance
	//
	// `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/{assignment-id}/reports`
	//
	//	returns all the reports for the given assignment across all instances.
	//
	// `projects/{project}/locations/{location}/instances/-/osPolicyAssignments/-/reports`
	//
	//	returns all the reports for all assignments across all instances.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of results to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// If provided, this field specifies the criteria that must be met by the
	// `OSPolicyAssignmentReport` API resource that is included in the response.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// A pagination token returned from a previous call to the
	// `ListOSPolicyAssignmentReports` method that indicates where this listing
	// should continue from.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListOSPolicyAssignmentReportsRequest) Reset() {
	*x = ListOSPolicyAssignmentReportsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOSPolicyAssignmentReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOSPolicyAssignmentReportsRequest) ProtoMessage() {}

func (x *ListOSPolicyAssignmentReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOSPolicyAssignmentReportsRequest.ProtoReflect.Descriptor instead.
func (*ListOSPolicyAssignmentReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{1}
}

func (x *ListOSPolicyAssignmentReportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListOSPolicyAssignmentReportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListOSPolicyAssignmentReportsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListOSPolicyAssignmentReportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// A response message for listing OS Policy assignment reports including the
// page of results and page token.
type ListOSPolicyAssignmentReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of OS policy assignment reports.
	OsPolicyAssignmentReports []*OSPolicyAssignmentReport `protobuf:"bytes,1,rep,name=os_policy_assignment_reports,json=osPolicyAssignmentReports,proto3" json:"os_policy_assignment_reports,omitempty"`
	// The pagination token to retrieve the next page of OS policy assignment
	// report objects.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListOSPolicyAssignmentReportsResponse) Reset() {
	*x = ListOSPolicyAssignmentReportsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListOSPolicyAssignmentReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListOSPolicyAssignmentReportsResponse) ProtoMessage() {}

func (x *ListOSPolicyAssignmentReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListOSPolicyAssignmentReportsResponse.ProtoReflect.Descriptor instead.
func (*ListOSPolicyAssignmentReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{2}
}

func (x *ListOSPolicyAssignmentReportsResponse) GetOsPolicyAssignmentReports() []*OSPolicyAssignmentReport {
	if x != nil {
		return x.OsPolicyAssignmentReports
	}
	return nil
}

func (x *ListOSPolicyAssignmentReportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A report of the OS policy assignment status for a given instance.
type OSPolicyAssignmentReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The `OSPolicyAssignmentReport` API resource name.
	//
	// Format:
	// `projects/{project_number}/locations/{location}/instances/{instance_id}/osPolicyAssignments/{os_policy_assignment_id}/report`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The Compute Engine VM instance name.
	Instance string `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
	// Reference to the `OSPolicyAssignment` API resource that the `OSPolicy`
	// belongs to.
	//
	// Format:
	// `projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id@revision_id}`
	OsPolicyAssignment string `protobuf:"bytes,3,opt,name=os_policy_assignment,json=osPolicyAssignment,proto3" json:"os_policy_assignment,omitempty"`
	// Compliance data for each `OSPolicy` that is applied to the VM.
	OsPolicyCompliances []*OSPolicyAssignmentReport_OSPolicyCompliance `protobuf:"bytes,4,rep,name=os_policy_compliances,json=osPolicyCompliances,proto3" json:"os_policy_compliances,omitempty"`
	// Timestamp for when the report was last generated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Unique identifier of the last attempted run to apply the OS policies
	// associated with this assignment on the VM.
	//
	// This ID is logged by the OS Config agent while applying the OS
	// policies associated with this assignment on the VM.
	// NOTE: If the service is unable to successfully connect to the agent for
	// this run, then this id will not be available in the agent logs.
	LastRunId string `protobuf:"bytes,6,opt,name=last_run_id,json=lastRunId,proto3" json:"last_run_id,omitempty"`
}

func (x *OSPolicyAssignmentReport) Reset() {
	*x = OSPolicyAssignmentReport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignmentReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignmentReport) ProtoMessage() {}

func (x *OSPolicyAssignmentReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignmentReport.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignmentReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{3}
}

func (x *OSPolicyAssignmentReport) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *OSPolicyAssignmentReport) GetInstance() string {
	if x != nil {
		return x.Instance
	}
	return ""
}

func (x *OSPolicyAssignmentReport) GetOsPolicyAssignment() string {
	if x != nil {
		return x.OsPolicyAssignment
	}
	return ""
}

func (x *OSPolicyAssignmentReport) GetOsPolicyCompliances() []*OSPolicyAssignmentReport_OSPolicyCompliance {
	if x != nil {
		return x.OsPolicyCompliances
	}
	return nil
}

func (x *OSPolicyAssignmentReport) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *OSPolicyAssignmentReport) GetLastRunId() string {
	if x != nil {
		return x.LastRunId
	}
	return ""
}

// Compliance data for an OS policy
type OSPolicyAssignmentReport_OSPolicyCompliance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OS policy id
	OsPolicyId string `protobuf:"bytes,1,opt,name=os_policy_id,json=osPolicyId,proto3" json:"os_policy_id,omitempty"`
	// The compliance state of the OS policy.
	ComplianceState OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState `protobuf:"varint,2,opt,name=compliance_state,json=complianceState,proto3,enum=google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState" json:"compliance_state,omitempty"`
	// The reason for the OS policy to be in an unknown compliance state.
	// This field is always populated when `compliance_state` is `UNKNOWN`.
	//
	// If populated, the field can contain one of the following values:
	//
	// * `vm-not-running`: The VM was not running.
	// * `os-policies-not-supported-by-agent`: The version of the OS Config
	// agent running on the VM does not support running OS policies.
	// * `no-agent-detected`: The OS Config agent is not detected for the VM.
	// * `resource-execution-errors`: The OS Config agent encountered errors
	// while executing one or more resources in the policy. See
	// `os_policy_resource_compliances` for details.
	// * `task-timeout`: The task sent to the agent to apply the policy timed
	// out.
	// * `unexpected-agent-state`: The OS Config agent did not report the final
	// status of the task that attempted to apply the policy. Instead, the agent
	// unexpectedly started working on a different task. This mostly happens
	// when the agent or VM unexpectedly restarts while applying OS policies.
	// * `internal-service-errors`: Internal service errors were encountered
	// while attempting to apply the policy.
	ComplianceStateReason string `protobuf:"bytes,3,opt,name=compliance_state_reason,json=complianceStateReason,proto3" json:"compliance_state_reason,omitempty"`
	// Compliance data for each resource within the policy that is applied to
	// the VM.
	OsPolicyResourceCompliances []*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance `protobuf:"bytes,4,rep,name=os_policy_resource_compliances,json=osPolicyResourceCompliances,proto3" json:"os_policy_resource_compliances,omitempty"`
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance) Reset() {
	*x = OSPolicyAssignmentReport_OSPolicyCompliance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignmentReport_OSPolicyCompliance) ProtoMessage() {}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignmentReport_OSPolicyCompliance.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignmentReport_OSPolicyCompliance) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{3, 0}
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance) GetOsPolicyId() string {
	if x != nil {
		return x.OsPolicyId
	}
	return ""
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance) GetComplianceState() OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState {
	if x != nil {
		return x.ComplianceState
	}
	return OSPolicyAssignmentReport_OSPolicyCompliance_UNKNOWN
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance) GetComplianceStateReason() string {
	if x != nil {
		return x.ComplianceStateReason
	}
	return ""
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance) GetOsPolicyResourceCompliances() []*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance {
	if x != nil {
		return x.OsPolicyResourceCompliances
	}
	return nil
}

// Compliance data for an OS policy resource.
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the OS policy resource.
	OsPolicyResourceId string `protobuf:"bytes,1,opt,name=os_policy_resource_id,json=osPolicyResourceId,proto3" json:"os_policy_resource_id,omitempty"`
	// Ordered list of configuration completed by the agent for the OS policy
	// resource.
	ConfigSteps []*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep `protobuf:"bytes,2,rep,name=config_steps,json=configSteps,proto3" json:"config_steps,omitempty"`
	// The compliance state of the resource.
	ComplianceState OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState `protobuf:"varint,3,opt,name=compliance_state,json=complianceState,proto3,enum=google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState" json:"compliance_state,omitempty"`
	// A reason for the resource to be in the given compliance state.
	// This field is always populated when `compliance_state` is `UNKNOWN`.
	//
	// The following values are supported when `compliance_state == UNKNOWN`
	//
	// * `execution-errors`: Errors were encountered by the agent while
	// executing the resource and the compliance state couldn't be
	// determined.
	// * `execution-skipped-by-agent`: Resource execution was skipped by the
	// agent because errors were encountered while executing prior resources
	// in the OS policy.
	// * `os-policy-execution-attempt-failed`: The execution of the OS policy
	// containing this resource failed and the compliance state couldn't be
	// determined.
	ComplianceStateReason string `protobuf:"bytes,4,opt,name=compliance_state_reason,json=complianceStateReason,proto3" json:"compliance_state_reason,omitempty"`
	// Resource specific output.
	//
	// Types that are assignable to Output:
	//
	//	*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_
	Output isOSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_Output `protobuf_oneof:"output"`
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) Reset() {
	*x = OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) ProtoMessage() {}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{3, 0, 0}
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) GetOsPolicyResourceId() string {
	if x != nil {
		return x.OsPolicyResourceId
	}
	return ""
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) GetConfigSteps() []*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep {
	if x != nil {
		return x.ConfigSteps
	}
	return nil
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) GetComplianceState() OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState {
	if x != nil {
		return x.ComplianceState
	}
	return OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_UNKNOWN
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) GetComplianceStateReason() string {
	if x != nil {
		return x.ComplianceStateReason
	}
	return ""
}

func (m *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) GetOutput() isOSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance) GetExecResourceOutput() *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput {
	if x, ok := x.GetOutput().(*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_); ok {
		return x.ExecResourceOutput
	}
	return nil
}

type isOSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_Output interface {
	isOSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_Output()
}

type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_ struct {
	// ExecResource specific output.
	ExecResourceOutput *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput `protobuf:"bytes,5,opt,name=exec_resource_output,json=execResourceOutput,proto3,oneof"`
}

func (*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_) isOSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_Output() {
}

// Step performed by the OS Config agent for configuring an
// `OSPolicy` resource to its desired state.
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Configuration step type.
	Type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type" json:"type,omitempty"`
	// An error message recorded during the execution of this step.
	// Only populated if errors were encountered during this step execution.
	ErrorMessage string `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep) Reset() {
	*x = OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep) ProtoMessage() {
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{3, 0, 0, 0}
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep) GetType() OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type {
	if x != nil {
		return x.Type
	}
	return OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_TYPE_UNSPECIFIED
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// ExecResource specific output.
type OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output from enforcement phase output file (if run).
	// Output size is limited to 100K bytes.
	EnforcementOutput []byte `protobuf:"bytes,2,opt,name=enforcement_output,json=enforcementOutput,proto3" json:"enforcement_output,omitempty"`
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput) Reset() {
	*x = OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput) ProtoMessage() {
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput.ProtoReflect.Descriptor instead.
func (*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP(), []int{3, 0, 0, 1}
}

func (x *OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput) GetEnforcementOutput() []byte {
	if x != nil {
		return x.EnforcementOutput
	}
	return nil
}

var File_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDesc = []byte{
	0x0a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x72,
	0x0a, 0x22, 0x47, 0x65, 0x74, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xcd, 0x01, 0x0a, 0x24, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x39, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x33, 0x0a, 0x31, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0xc9, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74, 0x4f, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x78, 0x0a, 0x1c,
	0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70,
	0x68, 0x61, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x19, 0x6f, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x97,
	0x11, 0x0a, 0x18, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x1a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x61, 0x0a, 0x14, 0x6f,
	0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x6f, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x7e,
	0x0a, 0x15, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x13, 0x6f, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x3b,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x0b, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x75, 0x6e, 0x49, 0x64, 0x1a, 0xeb, 0x0c, 0x0a, 0x12,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x49, 0x64, 0x12, 0x85, 0x01, 0x0a, 0x10, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x5a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a, 0x17,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x63,
	0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x65,
	0x61, 0x73, 0x6f, 0x6e, 0x12, 0xaa, 0x01, 0x0a, 0x1e, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69,
	0x61, 0x6e, 0x63, 0x65, 0x52, 0x1b, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x1a, 0x83, 0x09, 0x0a, 0x1a, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x12, 0x31, 0x0a, 0x15, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x12, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x49, 0x64, 0x12, 0xa4, 0x01, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x73,
	0x74, 0x65, 0x70, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x80, 0x01, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x53, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x65, 0x70, 0x52, 0x0b, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53, 0x74, 0x65, 0x70, 0x73, 0x12, 0xa0, 0x01, 0x0a, 0x10, 0x63,
	0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x75, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x4f,
	0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x36, 0x0a,
	0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0xac, 0x01, 0x0a, 0x14, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x78, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73,
	0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x48, 0x00,
	0x52, 0x12, 0x65, 0x78, 0x65, 0x63, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x1a, 0xef, 0x02, 0x0a, 0x1a, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x53,
	0x74, 0x65, 0x70, 0x12, 0x9a, 0x01, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x85, 0x01, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69,
	0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x4f, 0x53, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x53, 0x74, 0x65, 0x70, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x8e, 0x01, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14,
	0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x01, 0x12, 0x17, 0x0a, 0x13, 0x44, 0x45, 0x53, 0x49, 0x52, 0x45, 0x44, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x10, 0x02, 0x12, 0x1d, 0x0a,
	0x19, 0x44, 0x45, 0x53, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x45,
	0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x28, 0x0a, 0x24,
	0x44, 0x45, 0x53, 0x49, 0x52, 0x45, 0x44, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x48,
	0x45, 0x43, 0x4b, 0x5f, 0x50, 0x4f, 0x53, 0x54, 0x5f, 0x45, 0x4e, 0x46, 0x4f, 0x52, 0x43, 0x45,
	0x4d, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x1a, 0x43, 0x0a, 0x12, 0x45, 0x78, 0x65, 0x63, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x2d, 0x0a, 0x12,
	0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x40, 0x0a, 0x0f, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b,
	0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x4f, 0x4d, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f,
	0x4e, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x54, 0x10, 0x02, 0x42, 0x08, 0x0a,
	0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x40, 0x0a, 0x0f, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e,
	0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c,
	0x49, 0x41, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4e, 0x4f, 0x4e, 0x5f, 0x43, 0x4f,
	0x4d, 0x50, 0x4c, 0x49, 0x41, 0x4e, 0x54, 0x10, 0x02, 0x3a, 0x9c, 0x01, 0xea, 0x41, 0x98, 0x01,
	0x0a, 0x30, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x12, 0x64, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d,
	0x2f, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x42, 0xfd, 0x02, 0xea, 0x41, 0x92, 0x01, 0x0a,
	0x31, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x5d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d,
	0x2f, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
	0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x42, 0x1e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73,
	0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x70, 0x62, 0x3b, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x31,
	0x41, 0x6c, 0x70, 0x68, 0x61, 0xca, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5c, 0x56, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0xea, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3a,
	0x3a, 0x56, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescData = file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDesc
)

func file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescData)
	})
	return file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDescData
}

var file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_goTypes = []any{
	(OSPolicyAssignmentReport_OSPolicyCompliance_ComplianceState)(0),                                            // 0: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState
	(OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ComplianceState)(0),                 // 1: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState
	(OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep_Type)(0), // 2: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type
	(*GetOSPolicyAssignmentReportRequest)(nil),                                                                  // 3: google.cloud.osconfig.v1alpha.GetOSPolicyAssignmentReportRequest
	(*ListOSPolicyAssignmentReportsRequest)(nil),                                                                // 4: google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentReportsRequest
	(*ListOSPolicyAssignmentReportsResponse)(nil),                                                               // 5: google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentReportsResponse
	(*OSPolicyAssignmentReport)(nil),                                                                            // 6: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport
	(*OSPolicyAssignmentReport_OSPolicyCompliance)(nil),                                                         // 7: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance
	(*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance)(nil),                              // 8: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance
	(*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep)(nil),   // 9: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep
	(*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput)(nil),           // 10: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput
	(*timestamppb.Timestamp)(nil),                                                                               // 11: google.protobuf.Timestamp
}
var file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_depIdxs = []int32{
	6,  // 0: google.cloud.osconfig.v1alpha.ListOSPolicyAssignmentReportsResponse.os_policy_assignment_reports:type_name -> google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport
	7,  // 1: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.os_policy_compliances:type_name -> google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance
	11, // 2: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.update_time:type_name -> google.protobuf.Timestamp
	0,  // 3: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.compliance_state:type_name -> google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.ComplianceState
	8,  // 4: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.os_policy_resource_compliances:type_name -> google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance
	9,  // 5: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.config_steps:type_name -> google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep
	1,  // 6: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.compliance_state:type_name -> google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ComplianceState
	10, // 7: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.exec_resource_output:type_name -> google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.ExecResourceOutput
	2,  // 8: google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.type:type_name -> google.cloud.osconfig.v1alpha.OSPolicyAssignmentReport.OSPolicyCompliance.OSPolicyResourceCompliance.OSPolicyResourceConfigStep.Type
	9,  // [9:9] is the sub-list for method output_type
	9,  // [9:9] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_init() }
func file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_init() {
	if File_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*GetOSPolicyAssignmentReportRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ListOSPolicyAssignmentReportsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ListOSPolicyAssignmentReportsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*OSPolicyAssignmentReport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*OSPolicyAssignmentReport_OSPolicyCompliance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_OSPolicyResourceConfigStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes[5].OneofWrappers = []any{
		(*OSPolicyAssignmentReport_OSPolicyCompliance_OSPolicyResourceCompliance_ExecResourceOutput_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto = out.File
	file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_rawDesc = nil
	file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_goTypes = nil
	file_google_cloud_osconfig_v1alpha_os_policy_assignment_reports_proto_depIdxs = nil
}
