/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the DataStreamingEndpointTypeKafka type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DataStreamingEndpointTypeKafka{}

// DataStreamingEndpointTypeKafka struct for DataStreamingEndpointTypeKafka
type DataStreamingEndpointTypeKafka struct {
	EndpointType *string `json:"endpoint_type,omitempty"`
	UseTls *bool `json:"use_tls,omitempty"`
	KafkaTopic *string `json:"kafka_topic,omitempty"`
	BootstrapServers *string `json:"bootstrap_servers,omitempty"`
}

// NewDataStreamingEndpointTypeKafka instantiates a new DataStreamingEndpointTypeKafka object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDataStreamingEndpointTypeKafka() *DataStreamingEndpointTypeKafka {
	this := DataStreamingEndpointTypeKafka{}
	return &this
}

// NewDataStreamingEndpointTypeKafkaWithDefaults instantiates a new DataStreamingEndpointTypeKafka object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDataStreamingEndpointTypeKafkaWithDefaults() *DataStreamingEndpointTypeKafka {
	this := DataStreamingEndpointTypeKafka{}
	return &this
}

// GetEndpointType returns the EndpointType field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeKafka) GetEndpointType() string {
	if o == nil || IsNil(o.EndpointType) {
		var ret string
		return ret
	}
	return *o.EndpointType
}

// GetEndpointTypeOk returns a tuple with the EndpointType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeKafka) GetEndpointTypeOk() (*string, bool) {
	if o == nil || IsNil(o.EndpointType) {
		return nil, false
	}
	return o.EndpointType, true
}

// HasEndpointType returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeKafka) HasEndpointType() bool {
	if o != nil && !IsNil(o.EndpointType) {
		return true
	}

	return false
}

// SetEndpointType gets a reference to the given string and assigns it to the EndpointType field.
func (o *DataStreamingEndpointTypeKafka) SetEndpointType(v string) {
	o.EndpointType = &v
}

// GetUseTls returns the UseTls field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeKafka) GetUseTls() bool {
	if o == nil || IsNil(o.UseTls) {
		var ret bool
		return ret
	}
	return *o.UseTls
}

// GetUseTlsOk returns a tuple with the UseTls field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeKafka) GetUseTlsOk() (*bool, bool) {
	if o == nil || IsNil(o.UseTls) {
		return nil, false
	}
	return o.UseTls, true
}

// HasUseTls returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeKafka) HasUseTls() bool {
	if o != nil && !IsNil(o.UseTls) {
		return true
	}

	return false
}

// SetUseTls gets a reference to the given bool and assigns it to the UseTls field.
func (o *DataStreamingEndpointTypeKafka) SetUseTls(v bool) {
	o.UseTls = &v
}

// GetKafkaTopic returns the KafkaTopic field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeKafka) GetKafkaTopic() string {
	if o == nil || IsNil(o.KafkaTopic) {
		var ret string
		return ret
	}
	return *o.KafkaTopic
}

// GetKafkaTopicOk returns a tuple with the KafkaTopic field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeKafka) GetKafkaTopicOk() (*string, bool) {
	if o == nil || IsNil(o.KafkaTopic) {
		return nil, false
	}
	return o.KafkaTopic, true
}

// HasKafkaTopic returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeKafka) HasKafkaTopic() bool {
	if o != nil && !IsNil(o.KafkaTopic) {
		return true
	}

	return false
}

// SetKafkaTopic gets a reference to the given string and assigns it to the KafkaTopic field.
func (o *DataStreamingEndpointTypeKafka) SetKafkaTopic(v string) {
	o.KafkaTopic = &v
}

// GetBootstrapServers returns the BootstrapServers field value if set, zero value otherwise.
func (o *DataStreamingEndpointTypeKafka) GetBootstrapServers() string {
	if o == nil || IsNil(o.BootstrapServers) {
		var ret string
		return ret
	}
	return *o.BootstrapServers
}

// GetBootstrapServersOk returns a tuple with the BootstrapServers field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingEndpointTypeKafka) GetBootstrapServersOk() (*string, bool) {
	if o == nil || IsNil(o.BootstrapServers) {
		return nil, false
	}
	return o.BootstrapServers, true
}

// HasBootstrapServers returns a boolean if a field has been set.
func (o *DataStreamingEndpointTypeKafka) HasBootstrapServers() bool {
	if o != nil && !IsNil(o.BootstrapServers) {
		return true
	}

	return false
}

// SetBootstrapServers gets a reference to the given string and assigns it to the BootstrapServers field.
func (o *DataStreamingEndpointTypeKafka) SetBootstrapServers(v string) {
	o.BootstrapServers = &v
}

func (o DataStreamingEndpointTypeKafka) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DataStreamingEndpointTypeKafka) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.EndpointType) {
		toSerialize["endpoint_type"] = o.EndpointType
	}
	if !IsNil(o.UseTls) {
		toSerialize["use_tls"] = o.UseTls
	}
	if !IsNil(o.KafkaTopic) {
		toSerialize["kafka_topic"] = o.KafkaTopic
	}
	if !IsNil(o.BootstrapServers) {
		toSerialize["bootstrap_servers"] = o.BootstrapServers
	}
	return toSerialize, nil
}

type NullableDataStreamingEndpointTypeKafka struct {
	value *DataStreamingEndpointTypeKafka
	isSet bool
}

func (v NullableDataStreamingEndpointTypeKafka) Get() *DataStreamingEndpointTypeKafka {
	return v.value
}

func (v *NullableDataStreamingEndpointTypeKafka) Set(val *DataStreamingEndpointTypeKafka) {
	v.value = val
	v.isSet = true
}

func (v NullableDataStreamingEndpointTypeKafka) IsSet() bool {
	return v.isSet
}

func (v *NullableDataStreamingEndpointTypeKafka) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDataStreamingEndpointTypeKafka(val *DataStreamingEndpointTypeKafka) *NullableDataStreamingEndpointTypeKafka {
	return &NullableDataStreamingEndpointTypeKafka{value: val, isSet: true}
}

func (v NullableDataStreamingEndpointTypeKafka) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDataStreamingEndpointTypeKafka) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


