/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the DataStreamingsDomainResult type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &DataStreamingsDomainResult{}

// DataStreamingsDomainResult struct for DataStreamingsDomainResult
type DataStreamingsDomainResult struct {
	DomainId *int32 `json:"domain_id,omitempty"`
	Name *string `json:"name,omitempty"`
	Selected NullableBool `json:"selected,omitempty"`
}

// NewDataStreamingsDomainResult instantiates a new DataStreamingsDomainResult object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewDataStreamingsDomainResult() *DataStreamingsDomainResult {
	this := DataStreamingsDomainResult{}
	return &this
}

// NewDataStreamingsDomainResultWithDefaults instantiates a new DataStreamingsDomainResult object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewDataStreamingsDomainResultWithDefaults() *DataStreamingsDomainResult {
	this := DataStreamingsDomainResult{}
	return &this
}

// GetDomainId returns the DomainId field value if set, zero value otherwise.
func (o *DataStreamingsDomainResult) GetDomainId() int32 {
	if o == nil || IsNil(o.DomainId) {
		var ret int32
		return ret
	}
	return *o.DomainId
}

// GetDomainIdOk returns a tuple with the DomainId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingsDomainResult) GetDomainIdOk() (*int32, bool) {
	if o == nil || IsNil(o.DomainId) {
		return nil, false
	}
	return o.DomainId, true
}

// HasDomainId returns a boolean if a field has been set.
func (o *DataStreamingsDomainResult) HasDomainId() bool {
	if o != nil && !IsNil(o.DomainId) {
		return true
	}

	return false
}

// SetDomainId gets a reference to the given int32 and assigns it to the DomainId field.
func (o *DataStreamingsDomainResult) SetDomainId(v int32) {
	o.DomainId = &v
}

// GetName returns the Name field value if set, zero value otherwise.
func (o *DataStreamingsDomainResult) GetName() string {
	if o == nil || IsNil(o.Name) {
		var ret string
		return ret
	}
	return *o.Name
}

// GetNameOk returns a tuple with the Name field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *DataStreamingsDomainResult) GetNameOk() (*string, bool) {
	if o == nil || IsNil(o.Name) {
		return nil, false
	}
	return o.Name, true
}

// HasName returns a boolean if a field has been set.
func (o *DataStreamingsDomainResult) HasName() bool {
	if o != nil && !IsNil(o.Name) {
		return true
	}

	return false
}

// SetName gets a reference to the given string and assigns it to the Name field.
func (o *DataStreamingsDomainResult) SetName(v string) {
	o.Name = &v
}

// GetSelected returns the Selected field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *DataStreamingsDomainResult) GetSelected() bool {
	if o == nil || IsNil(o.Selected.Get()) {
		var ret bool
		return ret
	}
	return *o.Selected.Get()
}

// GetSelectedOk returns a tuple with the Selected field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *DataStreamingsDomainResult) GetSelectedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return o.Selected.Get(), o.Selected.IsSet()
}

// HasSelected returns a boolean if a field has been set.
func (o *DataStreamingsDomainResult) HasSelected() bool {
	if o != nil && o.Selected.IsSet() {
		return true
	}

	return false
}

// SetSelected gets a reference to the given NullableBool and assigns it to the Selected field.
func (o *DataStreamingsDomainResult) SetSelected(v bool) {
	o.Selected.Set(&v)
}
// SetSelectedNil sets the value for Selected to be an explicit nil
func (o *DataStreamingsDomainResult) SetSelectedNil() {
	o.Selected.Set(nil)
}

// UnsetSelected ensures that no value is present for Selected, not even an explicit nil
func (o *DataStreamingsDomainResult) UnsetSelected() {
	o.Selected.Unset()
}

func (o DataStreamingsDomainResult) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o DataStreamingsDomainResult) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.DomainId) {
		toSerialize["domain_id"] = o.DomainId
	}
	if !IsNil(o.Name) {
		toSerialize["name"] = o.Name
	}
	if o.Selected.IsSet() {
		toSerialize["selected"] = o.Selected.Get()
	}
	return toSerialize, nil
}

type NullableDataStreamingsDomainResult struct {
	value *DataStreamingsDomainResult
	isSet bool
}

func (v NullableDataStreamingsDomainResult) Get() *DataStreamingsDomainResult {
	return v.value
}

func (v *NullableDataStreamingsDomainResult) Set(val *DataStreamingsDomainResult) {
	v.value = val
	v.isSet = true
}

func (v NullableDataStreamingsDomainResult) IsSet() bool {
	return v.isSet
}

func (v *NullableDataStreamingsDomainResult) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableDataStreamingsDomainResult(val *DataStreamingsDomainResult) *NullableDataStreamingsDomainResult {
	return &NullableDataStreamingsDomainResult{value: val, isSet: true}
}

func (v NullableDataStreamingsDomainResult) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableDataStreamingsDomainResult) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


