/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the EndpointSplunk type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &EndpointSplunk{}

// EndpointSplunk struct for EndpointSplunk
type EndpointSplunk struct {
	EndpointType *string `json:"endpoint_type,omitempty"`
	Url *string `json:"url,omitempty"`
	ApiKey *string `json:"api_key,omitempty"`
}

// NewEndpointSplunk instantiates a new EndpointSplunk object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewEndpointSplunk() *EndpointSplunk {
	this := EndpointSplunk{}
	return &this
}

// NewEndpointSplunkWithDefaults instantiates a new EndpointSplunk object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewEndpointSplunkWithDefaults() *EndpointSplunk {
	this := EndpointSplunk{}
	return &this
}

// GetEndpointType returns the EndpointType field value if set, zero value otherwise.
func (o *EndpointSplunk) GetEndpointType() string {
	if o == nil || IsNil(o.EndpointType) {
		var ret string
		return ret
	}
	return *o.EndpointType
}

// GetEndpointTypeOk returns a tuple with the EndpointType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointSplunk) GetEndpointTypeOk() (*string, bool) {
	if o == nil || IsNil(o.EndpointType) {
		return nil, false
	}
	return o.EndpointType, true
}

// HasEndpointType returns a boolean if a field has been set.
func (o *EndpointSplunk) HasEndpointType() bool {
	if o != nil && !IsNil(o.EndpointType) {
		return true
	}

	return false
}

// SetEndpointType gets a reference to the given string and assigns it to the EndpointType field.
func (o *EndpointSplunk) SetEndpointType(v string) {
	o.EndpointType = &v
}

// GetUrl returns the Url field value if set, zero value otherwise.
func (o *EndpointSplunk) GetUrl() string {
	if o == nil || IsNil(o.Url) {
		var ret string
		return ret
	}
	return *o.Url
}

// GetUrlOk returns a tuple with the Url field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointSplunk) GetUrlOk() (*string, bool) {
	if o == nil || IsNil(o.Url) {
		return nil, false
	}
	return o.Url, true
}

// HasUrl returns a boolean if a field has been set.
func (o *EndpointSplunk) HasUrl() bool {
	if o != nil && !IsNil(o.Url) {
		return true
	}

	return false
}

// SetUrl gets a reference to the given string and assigns it to the Url field.
func (o *EndpointSplunk) SetUrl(v string) {
	o.Url = &v
}

// GetApiKey returns the ApiKey field value if set, zero value otherwise.
func (o *EndpointSplunk) GetApiKey() string {
	if o == nil || IsNil(o.ApiKey) {
		var ret string
		return ret
	}
	return *o.ApiKey
}

// GetApiKeyOk returns a tuple with the ApiKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *EndpointSplunk) GetApiKeyOk() (*string, bool) {
	if o == nil || IsNil(o.ApiKey) {
		return nil, false
	}
	return o.ApiKey, true
}

// HasApiKey returns a boolean if a field has been set.
func (o *EndpointSplunk) HasApiKey() bool {
	if o != nil && !IsNil(o.ApiKey) {
		return true
	}

	return false
}

// SetApiKey gets a reference to the given string and assigns it to the ApiKey field.
func (o *EndpointSplunk) SetApiKey(v string) {
	o.ApiKey = &v
}

func (o EndpointSplunk) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o EndpointSplunk) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.EndpointType) {
		toSerialize["endpoint_type"] = o.EndpointType
	}
	if !IsNil(o.Url) {
		toSerialize["url"] = o.Url
	}
	if !IsNil(o.ApiKey) {
		toSerialize["api_key"] = o.ApiKey
	}
	return toSerialize, nil
}

type NullableEndpointSplunk struct {
	value *EndpointSplunk
	isSet bool
}

func (v NullableEndpointSplunk) Get() *EndpointSplunk {
	return v.value
}

func (v *NullableEndpointSplunk) Set(val *EndpointSplunk) {
	v.value = val
	v.isSet = true
}

func (v NullableEndpointSplunk) IsSet() bool {
	return v.isSet
}

func (v *NullableEndpointSplunk) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableEndpointSplunk(val *EndpointSplunk) *NullableEndpointSplunk {
	return &NullableEndpointSplunk{value: val, isSet: true}
}

func (v NullableEndpointSplunk) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableEndpointSplunk) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


