/*
Data Streaming - OpenAPI

The Data Streaming API allows you to manage your existing data streamings and templates. Data Streaming allows you to feed your stream processing, SIEM, and big data platforms with the event logs from your applications on Azion in real time. 

API version: 1.0.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package data_streaming

import (
	"encoding/json"
)

// checks if the TemplateResults type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &TemplateResults{}

// TemplateResults struct for TemplateResults
type TemplateResults struct {
	Results []Template `json:"results,omitempty"`
	SchemaVersion *float32 `json:"schema_version,omitempty"`
}

// NewTemplateResults instantiates a new TemplateResults object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTemplateResults() *TemplateResults {
	this := TemplateResults{}
	return &this
}

// NewTemplateResultsWithDefaults instantiates a new TemplateResults object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTemplateResultsWithDefaults() *TemplateResults {
	this := TemplateResults{}
	return &this
}

// GetResults returns the Results field value if set, zero value otherwise.
func (o *TemplateResults) GetResults() []Template {
	if o == nil || IsNil(o.Results) {
		var ret []Template
		return ret
	}
	return o.Results
}

// GetResultsOk returns a tuple with the Results field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TemplateResults) GetResultsOk() ([]Template, bool) {
	if o == nil || IsNil(o.Results) {
		return nil, false
	}
	return o.Results, true
}

// HasResults returns a boolean if a field has been set.
func (o *TemplateResults) HasResults() bool {
	if o != nil && !IsNil(o.Results) {
		return true
	}

	return false
}

// SetResults gets a reference to the given []Template and assigns it to the Results field.
func (o *TemplateResults) SetResults(v []Template) {
	o.Results = v
}

// GetSchemaVersion returns the SchemaVersion field value if set, zero value otherwise.
func (o *TemplateResults) GetSchemaVersion() float32 {
	if o == nil || IsNil(o.SchemaVersion) {
		var ret float32
		return ret
	}
	return *o.SchemaVersion
}

// GetSchemaVersionOk returns a tuple with the SchemaVersion field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TemplateResults) GetSchemaVersionOk() (*float32, bool) {
	if o == nil || IsNil(o.SchemaVersion) {
		return nil, false
	}
	return o.SchemaVersion, true
}

// HasSchemaVersion returns a boolean if a field has been set.
func (o *TemplateResults) HasSchemaVersion() bool {
	if o != nil && !IsNil(o.SchemaVersion) {
		return true
	}

	return false
}

// SetSchemaVersion gets a reference to the given float32 and assigns it to the SchemaVersion field.
func (o *TemplateResults) SetSchemaVersion(v float32) {
	o.SchemaVersion = &v
}

func (o TemplateResults) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o TemplateResults) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.Results) {
		toSerialize["results"] = o.Results
	}
	if !IsNil(o.SchemaVersion) {
		toSerialize["schema_version"] = o.SchemaVersion
	}
	return toSerialize, nil
}

type NullableTemplateResults struct {
	value *TemplateResults
	isSet bool
}

func (v NullableTemplateResults) Get() *TemplateResults {
	return v.value
}

func (v *NullableTemplateResults) Set(val *TemplateResults) {
	v.value = val
	v.isSet = true
}

func (v NullableTemplateResults) IsSet() bool {
	return v.isSet
}

func (v *NullableTemplateResults) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTemplateResults(val *TemplateResults) *NullableTemplateResults {
	return &NullableTemplateResults{value: val, isSet: true}
}

func (v NullableTemplateResults) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTemplateResults) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


