# Go API client for digital_certificates

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

## Overview
This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [OpenAPI-spec](https://www.openapis.org/) from a remote server, you can easily generate an API client.

- API version: 2.0.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.GoClientCodegen

## Installation

Install the following dependencies:

```shell
go get github.com/stretchr/testify/assert
go get golang.org/x/net/context
```

Put the package under your project folder and add the following in import:

```golang
import digital_certificates "github.com/GIT_USER_ID/GIT_REPO_ID"
```

To use a proxy, set the environment variable `HTTP_PROXY`:

```golang
os.Setenv("HTTP_PROXY", "http://proxy_name:proxy_port")
```

## Configuration of Server URL

Default configuration comes with `Servers` field that contains server objects as defined in the OpenAPI specification.

### Select Server Configuration

For using other server than the one defined on index 0 set context value `sw.ContextServerIndex` of type `int`.

```golang
ctx := context.WithValue(context.Background(), digital_certificates.ContextServerIndex, 1)
```

### Templated Server URL

Templated server URL is formatted using default variables from configuration or from context value `sw.ContextServerVariables` of type `map[string]string`.

```golang
ctx := context.WithValue(context.Background(), digital_certificates.ContextServerVariables, map[string]string{
	"basePath": "v2",
})
```

Note, enum values are always validated and all unused variables are silently ignored.

### URLs Configuration per Operation

Each operation can use different server URL defined using `OperationServers` map in the `Configuration`.
An operation is uniquely identified by `"{classname}Service.{nickname}"` string.
Similar rules for overriding default operation server index and variables applies by using `sw.ContextOperationServerIndices` and `sw.ContextOperationServerVariables` context maps.

```golang
ctx := context.WithValue(context.Background(), digital_certificates.ContextOperationServerIndices, map[string]int{
	"{classname}Service.{nickname}": 2,
})
ctx = context.WithValue(context.Background(), digital_certificates.ContextOperationServerVariables, map[string]map[string]string{
	"{classname}Service.{nickname}": {
		"port": "8443",
	},
})
```

## Documentation for API Endpoints

All URIs are relative to *https://api.azionapi.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CreateCSRApi* | [**CreateCSR**](docs/CreateCSRApi.md#createcsr) | **Post** /digital_certificates/csr | Create an encrypted Certificate Request with Azion, which can then be sent for signing to a CA
*CreateDigitalCertificateApi* | [**CreateCertificate**](docs/CreateDigitalCertificateApi.md#createcertificate) | **Post** /digital_certificates | Create a new digital certificate
*DeleteDigitalCertificateApi* | [**RemoveDigitalCertificates**](docs/DeleteDigitalCertificateApi.md#removedigitalcertificates) | **Delete** /digital_certificates/{digital_certificate_id} | Remove a digital certificate or CSR from your account
*OverwriteDigitalCertificateApi* | [**OverwriteDigitalCertificate**](docs/OverwriteDigitalCertificateApi.md#overwritedigitalcertificate) | **Put** /digital_certificates/{digital_certificate_id} | Overwrite a digital certificate with another complete digital certificate
*RetrieveDigitalCertificateByIDApi* | [**GetCertificate**](docs/RetrieveDigitalCertificateByIDApi.md#getcertificate) | **Get** /digital_certificates/{digital_certificate_id} | Get more data on a specific digital certificate or CSR.
*RetrieveDigitalCertificateListApi* | [**ListDigitalCertificates**](docs/RetrieveDigitalCertificateListApi.md#listdigitalcertificates) | **Get** /digital_certificates | List all existing digital certificates and CSRs registered to your account
*UpdateDigitalCertificateApi* | [**UpdateDigitalCertificate**](docs/UpdateDigitalCertificateApi.md#updatedigitalcertificate) | **Patch** /digital_certificates/{digital_certificate_id} | Change only select settings of your digital certificate or CSR.


## Documentation For Models

 - [CreateCSRRequest](docs/CreateCSRRequest.md)
 - [CreateCertificateRequest](docs/CreateCertificateRequest.md)
 - [DC200](docs/DC200.md)
 - [DC200List](docs/DC200List.md)
 - [DC200ListLinks](docs/DC200ListLinks.md)
 - [DC400](docs/DC400.md)
 - [DC401](docs/DC401.md)
 - [DC403](docs/DC403.md)
 - [DC404](docs/DC404.md)
 - [DC406](docs/DC406.md)
 - [DC409](docs/DC409.md)
 - [ResultsInner](docs/ResultsInner.md)
 - [SingleResult](docs/SingleResult.md)
 - [UpdateDigitalCertificateRequest](docs/UpdateDigitalCertificateRequest.md)


## Documentation For Authorization


Authentication schemes defined for the API:
### tokenAuth

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header

Note, each API key must be added to a map of `map[string]APIKey` where the key is: Authorization and passed in as the auth context for each request.


## Documentation for Utility Methods

Due to the fact that model structure members are all pointers, this package contains
a number of utility functions to easily obtain pointers to values of basic types.
Each of these functions takes a value of the given basic type and returns a pointer to it:

* `PtrBool`
* `PtrInt`
* `PtrInt32`
* `PtrInt64`
* `PtrFloat`
* `PtrFloat32`
* `PtrFloat64`
* `PtrString`
* `PtrTime`

## Author



