/*
Object Storage

REST API OpenAPI documentation for the Object Storage

API version: 1.0.0 (v1)
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package storage

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the BucketCreate type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &BucketCreate{}

// BucketCreate struct for BucketCreate
type BucketCreate struct {
	Name string `json:"name"`
	EdgeAccess EdgeAccessEnum `json:"edge_access"`
}

type _BucketCreate BucketCreate

// NewBucketCreate instantiates a new BucketCreate object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewBucketCreate(name string, edgeAccess EdgeAccessEnum) *BucketCreate {
	this := BucketCreate{}
	this.Name = name
	this.EdgeAccess = edgeAccess
	return &this
}

// NewBucketCreateWithDefaults instantiates a new BucketCreate object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewBucketCreateWithDefaults() *BucketCreate {
	this := BucketCreate{}
	return &this
}

// GetName returns the Name field value
func (o *BucketCreate) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *BucketCreate) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *BucketCreate) SetName(v string) {
	o.Name = v
}

// GetEdgeAccess returns the EdgeAccess field value
func (o *BucketCreate) GetEdgeAccess() EdgeAccessEnum {
	if o == nil {
		var ret EdgeAccessEnum
		return ret
	}

	return o.EdgeAccess
}

// GetEdgeAccessOk returns a tuple with the EdgeAccess field value
// and a boolean to check if the value has been set.
func (o *BucketCreate) GetEdgeAccessOk() (*EdgeAccessEnum, bool) {
	if o == nil {
		return nil, false
	}
	return &o.EdgeAccess, true
}

// SetEdgeAccess sets field value
func (o *BucketCreate) SetEdgeAccess(v EdgeAccessEnum) {
	o.EdgeAccess = v
}

func (o BucketCreate) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o BucketCreate) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name
	toSerialize["edge_access"] = o.EdgeAccess
	return toSerialize, nil
}

func (o *BucketCreate) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"name",
		"edge_access",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varBucketCreate := _BucketCreate{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varBucketCreate)

	if err != nil {
		return err
	}

	*o = BucketCreate(varBucketCreate)

	return err
}

type NullableBucketCreate struct {
	value *BucketCreate
	isSet bool
}

func (v NullableBucketCreate) Get() *BucketCreate {
	return v.value
}

func (v *NullableBucketCreate) Set(val *BucketCreate) {
	v.value = val
	v.isSet = true
}

func (v NullableBucketCreate) IsSet() bool {
	return v.isSet
}

func (v *NullableBucketCreate) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableBucketCreate(val *BucketCreate) *NullableBucketCreate {
	return &NullableBucketCreate{value: val, isSet: true}
}

func (v NullableBucketCreate) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableBucketCreate) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


