# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_icmpv6_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-icmpv6-types - based on the path /openconfig-icmpv6-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: OpenConfig module defining the types and coresponding subcodes for
ICMPv6.
  """
  _pyangbind_elements = {}

  

class openconfig_packet_match(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-packet-match - based on the path /openconfig-packet-match. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines data related to packet header fields
used in matching operations, for example in ACLs.  When a
field is omitted from a match expression, the effect is a
wildcard ('any') for that field.
  """
  _pyangbind_elements = {}

  

class openconfig_packet_match_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-packet-match-types - based on the path /openconfig-packet-match-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines common types for use in models requiring
data definitions related to packet matches.
  """
  _pyangbind_elements = {}

  

class openconfig_icmpv4_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-icmpv4-types - based on the path /openconfig-icmpv4-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: OpenConfig module defining the types and coresponding codes for
ICMPv4.
  """
  _pyangbind_elements = {}

  

class yc_state_openconfig_acl__acl_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Global operational state data for ACLs
  """
  __slots__ = ('_path_helper', '_extmethods', '__counter_capability',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__counter_capability = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="counter-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'state']

  def _get_counter_capability(self):
    """
    Getter method for counter_capability, mapped from YANG variable /acl/state/counter_capability (identityref)

    YANG Description: System reported indication of how ACL counters are reported
by the target
    """
    return self.__counter_capability
      
  def _set_counter_capability(self, v, load=False):
    """
    Setter method for counter_capability, mapped from YANG variable /acl/state/counter_capability (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counter_capability is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counter_capability() directly.

    YANG Description: System reported indication of how ACL counters are reported
by the target
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="counter-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counter_capability must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="counter-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__counter_capability = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counter_capability(self):
    self.__counter_capability = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:AGGREGATE_ONLY': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:INTERFACE_AGGREGATE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="counter-capability", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

  counter_capability = __builtin__.property(_get_counter_capability)


  _pyangbind_elements = OrderedDict([('counter_capability', counter_capability), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Access list config
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__description',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /acl/acl_sets/acl_set/config/name (string)

    YANG Description: The name of the access-list set
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /acl/acl_sets/acl_set/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the access-list set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/config/type (identityref)

    YANG Description: The type determines the fields allowed in the ACL entries
belonging to the ACL set (e.g., IPv4, IPv6, etc.)
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type determines the fields allowed in the ACL entries
belonging to the ACL set (e.g., IPv4, IPv6, etc.)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /acl/acl_sets/acl_set/config/description (string)

    YANG Description: Description, or comment, for the ACL set
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /acl/acl_sets/acl_set/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Description, or comment, for the ACL set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  description = __builtin__.property(_get_description, _set_description)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('description', description), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Access list state information
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__description',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /acl/acl_sets/acl_set/state/name (string)

    YANG Description: The name of the access-list set
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /acl/acl_sets/acl_set/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the access-list set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/state/type (identityref)

    YANG Description: The type determines the fields allowed in the ACL entries
belonging to the ACL set (e.g., IPv4, IPv6, etc.)
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type determines the fields allowed in the ACL entries
belonging to the ACL set (e.g., IPv4, IPv6, etc.)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV4': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_IPV6': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_L2': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MIXED': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACL_MPLS': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /acl/acl_sets/acl_set/state/description (string)

    YANG Description: Description, or comment, for the ACL set
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /acl/acl_sets/acl_set/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Description, or comment, for the ACL set
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  description = __builtin__.property(_get_description)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('description', description), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Access list entries config
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__description',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'config']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config/sequence_id (uint32)

    YANG Description: The sequence id determines the order in which ACL entries
are applied.  The sequence id must be unique for each entry
in an ACL set.  Target devices should apply the ACL entry
rules in ascending order determined by sequence id (low to
high), rather than the relying only on order in the list.
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config/sequence_id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: The sequence id determines the order in which ACL entries
are applied.  The sequence id must be unique for each entry
in an ACL set.  Target devices should apply the ACL entry
rules in ascending order determined by sequence id (low to
high), rather than the relying only on order in the list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=True)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config/description (string)

    YANG Description: A user-defined description, or comment, for this Access List
Entry.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user-defined description, or comment, for this Access List
Entry.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=True)

  sequence_id = __builtin__.property(_get_sequence_id, _set_sequence_id)
  description = __builtin__.property(_get_description, _set_description)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('description', description), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information for ACL entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__sequence_id','__description','__matched_packets','__matched_octets',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__sequence_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'state']

  def _get_sequence_id(self):
    """
    Getter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/sequence_id (uint32)

    YANG Description: The sequence id determines the order in which ACL entries
are applied.  The sequence id must be unique for each entry
in an ACL set.  Target devices should apply the ACL entry
rules in ascending order determined by sequence id (low to
high), rather than the relying only on order in the list.
    """
    return self.__sequence_id
      
  def _set_sequence_id(self, v, load=False):
    """
    Setter method for sequence_id, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/sequence_id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sequence_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sequence_id() directly.

    YANG Description: The sequence id determines the order in which ACL entries
are applied.  The sequence id must be unique for each entry
in an ACL set.  Target devices should apply the ACL entry
rules in ascending order determined by sequence id (low to
high), rather than the relying only on order in the list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sequence_id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=False)""",
        })

    self.__sequence_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sequence_id(self):
    self.__sequence_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="sequence-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint32', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/description (string)

    YANG Description: A user-defined description, or comment, for this Access List
Entry.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A user-defined description, or comment, for this Access List
Entry.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='string', is_config=False)


  def _get_matched_packets(self):
    """
    Getter method for matched_packets, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/matched_packets (oc-yang:counter64)

    YANG Description: Count of the number of packets matching the current ACL
entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    return self.__matched_packets
      
  def _set_matched_packets(self, v, load=False):
    """
    Setter method for matched_packets, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/matched_packets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_packets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_packets() directly.

    YANG Description: Count of the number of packets matching the current ACL
entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_packets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_packets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_packets(self):
    self.__matched_packets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-packets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)


  def _get_matched_octets(self):
    """
    Getter method for matched_octets, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/matched_octets (oc-yang:counter64)

    YANG Description: Count of the number of octets (bytes) matching the current
ACL entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    return self.__matched_octets
      
  def _set_matched_octets(self, v, load=False):
    """
    Setter method for matched_octets, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/state/matched_octets (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_matched_octets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_matched_octets() directly.

    YANG Description: Count of the number of octets (bytes) matching the current
ACL entry.

An implementation should provide this counter on a
per-interface per-ACL-entry if possible.

If an implementation only supports ACL counters per entry
(i.e., not broken out per interface), then the value
should be equal to the aggregate count across all interfaces.

An implementation that provides counters per entry per
interface is not required to also provide an aggregate count,
e.g., per entry -- the user is expected to be able implement
the required aggregation if such a count is needed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """matched_octets must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__matched_octets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_matched_octets(self):
    self.__matched_octets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="matched-octets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:counter64', is_config=False)

  sequence_id = __builtin__.property(_get_sequence_id)
  description = __builtin__.property(_get_description)
  matched_packets = __builtin__.property(_get_matched_packets)
  matched_octets = __builtin__.property(_get_matched_octets)


  _pyangbind_elements = OrderedDict([('sequence_id', sequence_id), ('description', description), ('matched_packets', matched_packets), ('matched_octets', matched_octets), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/l2/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_mac','__source_mac_mask','__destination_mac','__destination_mac_mask','__ethertype',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'l2', 'config']

  def _get_source_mac(self):
    """
    Getter method for source_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/source_mac (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address.
    """
    return self.__source_mac
      
  def _set_source_mac(self, v, load=False):
    """
    Setter method for source_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/source_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac() directly.

    YANG Description: Source IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__source_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac(self):
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)


  def _get_source_mac_mask(self):
    """
    Getter method for source_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/source_mac_mask (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address mask.
    """
    return self.__source_mac_mask
      
  def _set_source_mac_mask(self, v, load=False):
    """
    Setter method for source_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/source_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac_mask() directly.

    YANG Description: Source IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__source_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac_mask(self):
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)


  def _get_destination_mac(self):
    """
    Getter method for destination_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/destination_mac (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address.
    """
    return self.__destination_mac
      
  def _set_destination_mac(self, v, load=False):
    """
    Setter method for destination_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/destination_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac() directly.

    YANG Description: Destination IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__destination_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac(self):
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)


  def _get_destination_mac_mask(self):
    """
    Getter method for destination_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/destination_mac_mask (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    return self.__destination_mac_mask
      
  def _set_destination_mac_mask(self, v, load=False):
    """
    Setter method for destination_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/destination_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac_mask() directly.

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__destination_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac_mask(self):
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=True)


  def _get_ethertype(self):
    """
    Getter method for ethertype, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/ethertype (oc-pkt-match-types:ethertype-type)

    YANG Description: Ethertype field to match in Ethernet packets
    """
    return self.__ethertype
      
  def _set_ethertype(self, v, load=False):
    """
    Setter method for ethertype, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config/ethertype (oc-pkt-match-types:ethertype-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethertype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethertype() directly.

    YANG Description: Ethertype field to match in Ethernet packets
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethertype must be of a type compatible with oc-pkt-match-types:ethertype-type""",
          'defined-type': "oc-pkt-match-types:ethertype-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)""",
        })

    self.__ethertype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethertype(self):
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=True)

  source_mac = __builtin__.property(_get_source_mac, _set_source_mac)
  source_mac_mask = __builtin__.property(_get_source_mac_mask, _set_source_mac_mask)
  destination_mac = __builtin__.property(_get_destination_mac, _set_destination_mac)
  destination_mac_mask = __builtin__.property(_get_destination_mac_mask, _set_destination_mac_mask)
  ethertype = __builtin__.property(_get_ethertype, _set_ethertype)


  _pyangbind_elements = OrderedDict([('source_mac', source_mac), ('source_mac_mask', source_mac_mask), ('destination_mac', destination_mac), ('destination_mac_mask', destination_mac_mask), ('ethertype', ethertype), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/l2/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State Information.
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_mac','__source_mac_mask','__destination_mac','__destination_mac_mask','__ethertype',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'l2', 'state']

  def _get_source_mac(self):
    """
    Getter method for source_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/source_mac (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address.
    """
    return self.__source_mac
      
  def _set_source_mac(self, v, load=False):
    """
    Setter method for source_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/source_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac() directly.

    YANG Description: Source IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__source_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac(self):
    self.__source_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)


  def _get_source_mac_mask(self):
    """
    Getter method for source_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/source_mac_mask (oc-yang:mac-address)

    YANG Description: Source IEEE 802 MAC address mask.
    """
    return self.__source_mac_mask
      
  def _set_source_mac_mask(self, v, load=False):
    """
    Setter method for source_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/source_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_mac_mask() directly.

    YANG Description: Source IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__source_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_mac_mask(self):
    self.__source_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="source-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)


  def _get_destination_mac(self):
    """
    Getter method for destination_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/destination_mac (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address.
    """
    return self.__destination_mac
      
  def _set_destination_mac(self, v, load=False):
    """
    Setter method for destination_mac, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/destination_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac() directly.

    YANG Description: Destination IEEE 802 MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__destination_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac(self):
    self.__destination_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)


  def _get_destination_mac_mask(self):
    """
    Getter method for destination_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/destination_mac_mask (oc-yang:mac-address)

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    return self.__destination_mac_mask
      
  def _set_destination_mac_mask(self, v, load=False):
    """
    Setter method for destination_mac_mask, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/destination_mac_mask (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_mac_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_mac_mask() directly.

    YANG Description: Destination IEEE 802 MAC address mask.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_mac_mask must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__destination_mac_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_mac_mask(self):
    self.__destination_mac_mask = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="destination-mac-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-yang:mac-address', is_config=False)


  def _get_ethertype(self):
    """
    Getter method for ethertype, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/ethertype (oc-pkt-match-types:ethertype-type)

    YANG Description: Ethertype field to match in Ethernet packets
    """
    return self.__ethertype
      
  def _set_ethertype(self, v, load=False):
    """
    Setter method for ethertype, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state/ethertype (oc-pkt-match-types:ethertype-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethertype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethertype() directly.

    YANG Description: Ethertype field to match in Ethernet packets
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethertype must be of a type compatible with oc-pkt-match-types:ethertype-type""",
          'defined-type': "oc-pkt-match-types:ethertype-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)""",
        })

    self.__ethertype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethertype(self):
    self.__ethertype = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1536..65535']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV4': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ARP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_VLAN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_IPV6': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_MPLS': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_LLDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:ETHERTYPE_ROCE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="ethertype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ethertype-type', is_config=False)

  source_mac = __builtin__.property(_get_source_mac)
  source_mac_mask = __builtin__.property(_get_source_mac_mask)
  destination_mac = __builtin__.property(_get_destination_mac)
  destination_mac_mask = __builtin__.property(_get_destination_mac_mask)
  ethertype = __builtin__.property(_get_ethertype)


  _pyangbind_elements = OrderedDict([('source_mac', source_mac), ('source_mac_mask', source_mac_mask), ('destination_mac', destination_mac), ('destination_mac_mask', destination_mac_mask), ('ethertype', ethertype), ])


class yc_l2_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/l2. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Ethernet header fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'l2'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'l2']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config (container)

    YANG Description: Configuration data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state (container)

    YANG Description: State Information.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/l2/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State Information.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_l2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv4 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_address_prefix_set','__destination_address','__destination_address_prefix_set','__dscp','__dscp_set','__length','__protocol','__hop_limit',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=True)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4', 'config']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/source_address (oc-inet:ipv4-prefix)

    YANG Description: Source IPv4 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/source_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_source_address_prefix_set(self):
    """
    Getter method for source_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/source_address_prefix_set (leafref)

    YANG Description: Reference to a IPv4 address prefix Set
to match the source address
    """
    return self.__source_address_prefix_set
      
  def _set_source_address_prefix_set(self, v, load=False):
    """
    Setter method for source_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/source_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address_prefix_set() directly.

    YANG Description: Reference to a IPv4 address prefix Set
to match the source address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__source_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address_prefix_set(self):
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/destination_address (oc-inet:ipv4-prefix)

    YANG Description: Destination IPv4 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/destination_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=True)


  def _get_destination_address_prefix_set(self):
    """
    Getter method for destination_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/destination_address_prefix_set (leafref)

    YANG Description: Reference to a IPv4 address prefix set
to match the destination address
    """
    return self.__destination_address_prefix_set
      
  def _set_destination_address_prefix_set(self, v, load=False):
    """
    Setter method for destination_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/destination_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address_prefix_set() directly.

    YANG Description: Reference to a IPv4 address prefix set
to match the destination address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__destination_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address_prefix_set(self):
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)


  def _get_length(self):
    """
    Getter method for length, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/length (uint16)

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    return self.__length
      
  def _set_length(self, v, load=False):
    """
    Setter method for length, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/length (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_length is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_length() directly.

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """length must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=True)""",
        })

    self.__length = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_length(self):
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

  source_address = __builtin__.property(_get_source_address, _set_source_address)
  source_address_prefix_set = __builtin__.property(_get_source_address_prefix_set, _set_source_address_prefix_set)
  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  destination_address_prefix_set = __builtin__.property(_get_destination_address_prefix_set, _set_destination_address_prefix_set)
  dscp = __builtin__.property(_get_dscp, _set_dscp)
  dscp_set = __builtin__.property(_get_dscp_set, _set_dscp_set)
  length = __builtin__.property(_get_length, _set_length)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  hop_limit = __builtin__.property(_get_hop_limit, _set_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_address_prefix_set', source_address_prefix_set), ('destination_address', destination_address), ('destination_address_prefix_set', destination_address_prefix_set), ('dscp', dscp), ('dscp_set', dscp_set), ('length', length), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State information for IPv4 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_address_prefix_set','__destination_address','__destination_address_prefix_set','__dscp','__dscp_set','__length','__protocol','__hop_limit',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=False)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4', 'state']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/source_address (oc-inet:ipv4-prefix)

    YANG Description: Source IPv4 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/source_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_source_address_prefix_set(self):
    """
    Getter method for source_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/source_address_prefix_set (leafref)

    YANG Description: Reference to a IPv4 address prefix Set
to match the source address
    """
    return self.__source_address_prefix_set
      
  def _set_source_address_prefix_set(self, v, load=False):
    """
    Setter method for source_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/source_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address_prefix_set() directly.

    YANG Description: Reference to a IPv4 address prefix Set
to match the source address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__source_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address_prefix_set(self):
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/destination_address (oc-inet:ipv4-prefix)

    YANG Description: Destination IPv4 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/destination_address (oc-inet:ipv4-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv4 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv4-prefix""",
          'defined-type': "oc-inet:ipv4-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}/([0-9]|[12][0-9]|3[0-2])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv4-prefix', is_config=False)


  def _get_destination_address_prefix_set(self):
    """
    Getter method for destination_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/destination_address_prefix_set (leafref)

    YANG Description: Reference to a IPv4 address prefix set
to match the destination address
    """
    return self.__destination_address_prefix_set
      
  def _set_destination_address_prefix_set(self, v, load=False):
    """
    Setter method for destination_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/destination_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address_prefix_set() directly.

    YANG Description: Reference to a IPv4 address prefix set
to match the destination address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__destination_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address_prefix_set(self):
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)


  def _get_length(self):
    """
    Getter method for length, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/length (uint16)

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    return self.__length
      
  def _set_length(self, v, load=False):
    """
    Setter method for length, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/length (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_length is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_length() directly.

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """length must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=False)""",
        })

    self.__length = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_length(self):
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

  source_address = __builtin__.property(_get_source_address)
  source_address_prefix_set = __builtin__.property(_get_source_address_prefix_set)
  destination_address = __builtin__.property(_get_destination_address)
  destination_address_prefix_set = __builtin__.property(_get_destination_address_prefix_set)
  dscp = __builtin__.property(_get_dscp)
  dscp_set = __builtin__.property(_get_dscp_set)
  length = __builtin__.property(_get_length)
  protocol = __builtin__.property(_get_protocol)
  hop_limit = __builtin__.property(_get_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_address_prefix_set', source_address_prefix_set), ('destination_address', destination_address), ('destination_address_prefix_set', destination_address_prefix_set), ('dscp', dscp), ('dscp_set', dscp_set), ('length', length), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration attributes for ICMPv4 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__code',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4', 'icmpv4', 'config']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/config/type (identityref)

    YANG Description: ICMPv4 type to be matched.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: ICMPv4 type to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)


  def _get_code(self):
    """
    Getter method for code, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/config/code (identityref)

    YANG Description: ICMPv4 code to be matched.
    """
    return self.__code
      
  def _set_code(self, v, load=False):
    """
    Setter method for code, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/config/code (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_code() directly.

    YANG Description: ICMPv4 code to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """code must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_code(self):
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

  type = __builtin__.property(_get_type, _set_type)
  code = __builtin__.property(_get_code, _set_code)


  _pyangbind_elements = OrderedDict([('type', type), ('code', code), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State attributes for ICMPv4 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__code',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4', 'icmpv4', 'state']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/state/type (identityref)

    YANG Description: ICMPv4 type to be matched.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: ICMPv4 type to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TRACEROUTE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)


  def _get_code(self):
    """
    Getter method for code, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/state/code (identityref)

    YANG Description: ICMPv4 code to be matched.
    """
    return self.__code
      
  def _set_code(self, v, load=False):
    """
    Setter method for code, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/state/code (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_code() directly.

    YANG Description: ICMPv4 code to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """code must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_code(self):
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_REPLY_NONE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PROTOCOL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_CANNOT_FRAGMENT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_ROUTE_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_UNKNOWN': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_SRC_HOST_ISOLATED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_NET_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_DST_HOST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_NET_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_UNREACHABLE_FOR_TOS': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_HOST_PRECEDENCE_VIOLATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:DST_UNREACHABLE_PRECEDENCE_CUTOFF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_NETWORK': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:REDIRECT_TOS_HOST': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ECHO_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_NORMAL': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_ADVERTISEMENT_DOES_NOT_ROUTE_COMMON': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:ROUTER_SELECTION_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY_IN_TRANSIT': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_POINTER_INDICATES_ERR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_MISSING_REQ_OPTION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PARAM_PROBLEM_BAD_LENGTH': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:TIMESTAMP_REPLY_NO_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_BAD_SPI': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_AUTH_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECOMPRESS_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_DECRYPTION_FAILED': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHENTICATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:PHOTURIS_NEED_AUTHORIZATION': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUCH_INTF': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_NO_SUB_TABLE_ENTRY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}, 'oc-icmpv4-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv4-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv4-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

  type = __builtin__.property(_get_type)
  code = __builtin__.property(_get_code)


  _pyangbind_elements = OrderedDict([('type', type), ('code', code), ])


class yc_icmpv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4/icmpv4. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top container for ICMPv4 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'icmpv4'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4', 'icmpv4']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/config (container)

    YANG Description: Configuration attributes for ICMPv4 filtering
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration attributes for ICMPv4 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/state (container)

    YANG Description: State attributes for ICMPv4 filtering
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State attributes for ICMPv4 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_ipv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv4. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for IPv4 match field data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__icmpv4',)

  _yang_name = 'ipv4'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__icmpv4 = YANGDynClass(base=yc_icmpv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4, is_container='container', yang_name="icmpv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv4']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config (container)

    YANG Description: Configuration data for IPv4 match fields
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv4 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state (container)

    YANG Description: State information for IPv4 match fields
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State information for IPv4 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_icmpv4(self):
    """
    Getter method for icmpv4, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4 (container)

    YANG Description: Top container for ICMPv4 filtering
    """
    return self.__icmpv4
      
  def _set_icmpv4(self, v, load=False):
    """
    Setter method for icmpv4, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv4/icmpv4 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_icmpv4 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_icmpv4() directly.

    YANG Description: Top container for ICMPv4 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_icmpv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4, is_container='container', yang_name="icmpv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """icmpv4 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_icmpv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4, is_container='container', yang_name="icmpv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__icmpv4 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_icmpv4(self):
    self.__icmpv4 = YANGDynClass(base=yc_icmpv4_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv4_icmpv4, is_container='container', yang_name="icmpv4", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  icmpv4 = __builtin__.property(_get_icmpv4, _set_icmpv4)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('icmpv4', icmpv4), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to fields within
the MPLS header.
  """
  __slots__ = ('_path_helper', '_extmethods', '__traffic_class','__start_label_value','__end_label_value','__ttl_value',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=True)
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'mpls', 'config']

  def _get_traffic_class(self):
    """
    Getter method for traffic_class, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/traffic_class (oc-mpls:mpls-tc)

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    return self.__traffic_class
      
  def _set_traffic_class(self, v, load=False):
    """
    Setter method for traffic_class, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/traffic_class (oc-mpls:mpls-tc)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_traffic_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_traffic_class() directly.

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """traffic_class must be of a type compatible with oc-mpls:mpls-tc""",
          'defined-type': "oc-mpls:mpls-tc",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=True)""",
        })

    self.__traffic_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_traffic_class(self):
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=True)


  def _get_start_label_value(self):
    """
    Getter method for start_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/start_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__start_label_value
      
  def _set_start_label_value(self, v, load=False):
    """
    Setter method for start_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/start_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)""",
        })

    self.__start_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_label_value(self):
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)


  def _get_end_label_value(self):
    """
    Getter method for end_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/end_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__end_label_value
      
  def _set_end_label_value(self, v, load=False):
    """
    Setter method for end_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/end_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)""",
        })

    self.__end_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_label_value(self):
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=True)


  def _get_ttl_value(self):
    """
    Getter method for ttl_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/ttl_value (uint8)

    YANG Description: Time-to-live MPLS packet value match.
    """
    return self.__ttl_value
      
  def _set_ttl_value(self, v, load=False):
    """
    Setter method for ttl_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config/ttl_value (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ttl_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ttl_value() directly.

    YANG Description: Time-to-live MPLS packet value match.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ttl_value must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)""",
        })

    self.__ttl_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ttl_value(self):
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

  traffic_class = __builtin__.property(_get_traffic_class, _set_traffic_class)
  start_label_value = __builtin__.property(_get_start_label_value, _set_start_label_value)
  end_label_value = __builtin__.property(_get_end_label_value, _set_end_label_value)
  ttl_value = __builtin__.property(_get_ttl_value, _set_ttl_value)


  _pyangbind_elements = OrderedDict([('traffic_class', traffic_class), ('start_label_value', start_label_value), ('end_label_value', end_label_value), ('ttl_value', ttl_value), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/mpls/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to fields
within the MPLS header
  """
  __slots__ = ('_path_helper', '_extmethods', '__traffic_class','__start_label_value','__end_label_value','__ttl_value',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=False)
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'mpls', 'state']

  def _get_traffic_class(self):
    """
    Getter method for traffic_class, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/traffic_class (oc-mpls:mpls-tc)

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    return self.__traffic_class
      
  def _set_traffic_class(self, v, load=False):
    """
    Setter method for traffic_class, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/traffic_class (oc-mpls:mpls-tc)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_traffic_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_traffic_class() directly.

    YANG Description: The value of the MPLS traffic class (TC) bits,
formerly known as the EXP bits.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """traffic_class must be of a type compatible with oc-mpls:mpls-tc""",
          'defined-type': "oc-mpls:mpls-tc",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=False)""",
        })

    self.__traffic_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_traffic_class(self):
    self.__traffic_class = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..7']}), is_leaf=True, yang_name="traffic-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-tc', is_config=False)


  def _get_start_label_value(self):
    """
    Getter method for start_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/start_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__start_label_value
      
  def _set_start_label_value(self, v, load=False):
    """
    Setter method for start_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/start_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_start_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_start_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """start_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)""",
        })

    self.__start_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_start_label_value(self):
    self.__start_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="start-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)


  def _get_end_label_value(self):
    """
    Getter method for end_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/end_label_value (oc-mpls:mpls-label)

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    return self.__end_label_value
      
  def _set_end_label_value(self, v, load=False):
    """
    Setter method for end_label_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/end_label_value (oc-mpls:mpls-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_end_label_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_end_label_value() directly.

    YANG Description: Match MPLS label value on the MPLS header.
The usage of this field indicated the upper
range value in the top of the stack.
The range that is used is inclusive. The match that
is done for a particular received pkt_label is:
start-label-value <= pkt_label <= end-label-value.
The 20-bit label value in an MPLS label
stack as specified in RFC 3032.
This label value does not include the
encodings of Traffic Class and TTL.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """end_label_value must be of a type compatible with oc-mpls:mpls-label""",
          'defined-type': "oc-mpls:mpls-label",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)""",
        })

    self.__end_label_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_end_label_value(self):
    self.__end_label_value = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['16..1048575']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'IPV4_EXPLICIT_NULL': {'value': 0}, 'ROUTER_ALERT': {'value': 1}, 'IPV6_EXPLICIT_NULL': {'value': 2}, 'IMPLICIT_NULL': {'value': 3}, 'ENTROPY_LABEL_INDICATOR': {'value': 7}, 'NO_LABEL': {}},),], is_leaf=True, yang_name="end-label-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-mpls:mpls-label', is_config=False)


  def _get_ttl_value(self):
    """
    Getter method for ttl_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/ttl_value (uint8)

    YANG Description: Time-to-live MPLS packet value match.
    """
    return self.__ttl_value
      
  def _set_ttl_value(self, v, load=False):
    """
    Setter method for ttl_value, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state/ttl_value (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ttl_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ttl_value() directly.

    YANG Description: Time-to-live MPLS packet value match.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ttl_value must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)""",
        })

    self.__ttl_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ttl_value(self):
    self.__ttl_value = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="ttl-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

  traffic_class = __builtin__.property(_get_traffic_class)
  start_label_value = __builtin__.property(_get_start_label_value)
  end_label_value = __builtin__.property(_get_end_label_value)
  ttl_value = __builtin__.property(_get_ttl_value)


  _pyangbind_elements = OrderedDict([('traffic_class', traffic_class), ('start_label_value', start_label_value), ('end_label_value', end_label_value), ('ttl_value', ttl_value), ])


class yc_mpls_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/mpls. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: MPLS header fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'mpls'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'mpls']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config (container)

    YANG Description: Configuration parameters relating to fields within
the MPLS header.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to fields within
the MPLS header.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state (container)

    YANG Description: Operational state parameters relating to fields
within the MPLS header
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/mpls/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to fields
within the MPLS header
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_mpls_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for IPv6 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_address_prefix_set','__source_flow_label','__destination_address','__destination_address_prefix_set','__destination_flow_label','__dscp','__dscp_set','__length','__protocol','__hop_limit',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=True)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6', 'config']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_address (oc-inet:ipv6-prefix)

    YANG Description: Source IPv6 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_source_address_prefix_set(self):
    """
    Getter method for source_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_address_prefix_set (leafref)

    YANG Description: Reference to a IPv6 address prefix set
to match the source address
    """
    return self.__source_address_prefix_set
      
  def _set_source_address_prefix_set(self, v, load=False):
    """
    Setter method for source_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address_prefix_set() directly.

    YANG Description: Reference to a IPv6 address prefix set
to match the source address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__source_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address_prefix_set(self):
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_source_flow_label(self):
    """
    Getter method for source_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Source IPv6 Flow label.
    """
    return self.__source_flow_label
      
  def _set_source_flow_label(self, v, load=False):
    """
    Setter method for source_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/source_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_flow_label() directly.

    YANG Description: Source IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)""",
        })

    self.__source_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_flow_label(self):
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_address (oc-inet:ipv6-prefix)

    YANG Description: Destination IPv6 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=True)


  def _get_destination_address_prefix_set(self):
    """
    Getter method for destination_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_address_prefix_set (leafref)

    YANG Description: Reference to a IPv6 address prefix set
to match the destination address
    """
    return self.__destination_address_prefix_set
      
  def _set_destination_address_prefix_set(self, v, load=False):
    """
    Setter method for destination_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address_prefix_set() directly.

    YANG Description: Reference to a IPv6 address prefix set
to match the destination address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__destination_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address_prefix_set(self):
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_destination_flow_label(self):
    """
    Getter method for destination_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Destination IPv6 Flow label.
    """
    return self.__destination_flow_label
      
  def _set_destination_flow_label(self, v, load=False):
    """
    Setter method for destination_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/destination_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_flow_label() directly.

    YANG Description: Destination IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)""",
        })

    self.__destination_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_flow_label(self):
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=True)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=True)


  def _get_length(self):
    """
    Getter method for length, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/length (uint16)

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    return self.__length
      
  def _set_length(self, v, load=False):
    """
    Setter method for length, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/length (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_length is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_length() directly.

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """length must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=True)""",
        })

    self.__length = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_length(self):
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=True)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=True)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=True)

  source_address = __builtin__.property(_get_source_address, _set_source_address)
  source_address_prefix_set = __builtin__.property(_get_source_address_prefix_set, _set_source_address_prefix_set)
  source_flow_label = __builtin__.property(_get_source_flow_label, _set_source_flow_label)
  destination_address = __builtin__.property(_get_destination_address, _set_destination_address)
  destination_address_prefix_set = __builtin__.property(_get_destination_address_prefix_set, _set_destination_address_prefix_set)
  destination_flow_label = __builtin__.property(_get_destination_flow_label, _set_destination_flow_label)
  dscp = __builtin__.property(_get_dscp, _set_dscp)
  dscp_set = __builtin__.property(_get_dscp_set, _set_dscp_set)
  length = __builtin__.property(_get_length, _set_length)
  protocol = __builtin__.property(_get_protocol, _set_protocol)
  hop_limit = __builtin__.property(_get_hop_limit, _set_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_address_prefix_set', source_address_prefix_set), ('source_flow_label', source_flow_label), ('destination_address', destination_address), ('destination_address_prefix_set', destination_address_prefix_set), ('destination_flow_label', destination_flow_label), ('dscp', dscp), ('dscp_set', dscp_set), ('length', length), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for IPv6 match fields
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_address','__source_address_prefix_set','__source_flow_label','__destination_address','__destination_address_prefix_set','__destination_flow_label','__dscp','__dscp_set','__length','__protocol','__hop_limit',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=False)
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6', 'state']

  def _get_source_address(self):
    """
    Getter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_address (oc-inet:ipv6-prefix)

    YANG Description: Source IPv6 address prefix.
    """
    return self.__source_address
      
  def _set_source_address(self, v, load=False):
    """
    Setter method for source_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address() directly.

    YANG Description: Source IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__source_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address(self):
    self.__source_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="source-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_source_address_prefix_set(self):
    """
    Getter method for source_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_address_prefix_set (leafref)

    YANG Description: Reference to a IPv6 address prefix set
to match the source address
    """
    return self.__source_address_prefix_set
      
  def _set_source_address_prefix_set(self, v, load=False):
    """
    Setter method for source_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_address_prefix_set() directly.

    YANG Description: Reference to a IPv6 address prefix set
to match the source address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__source_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_address_prefix_set(self):
    self.__source_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_source_flow_label(self):
    """
    Getter method for source_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Source IPv6 Flow label.
    """
    return self.__source_flow_label
      
  def _set_source_flow_label(self, v, load=False):
    """
    Setter method for source_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/source_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_flow_label() directly.

    YANG Description: Source IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)""",
        })

    self.__source_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_flow_label(self):
    self.__source_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="source-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)


  def _get_destination_address(self):
    """
    Getter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_address (oc-inet:ipv6-prefix)

    YANG Description: Destination IPv6 address prefix.
    """
    return self.__destination_address
      
  def _set_destination_address(self, v, load=False):
    """
    Setter method for destination_address, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_address (oc-inet:ipv6-prefix)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address() directly.

    YANG Description: Destination IPv6 address prefix.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address must be of a type compatible with oc-inet:ipv6-prefix""",
          'defined-type': "oc-inet:ipv6-prefix",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)""",
        })

    self.__destination_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address(self):
    self.__destination_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])'}), is_leaf=True, yang_name="destination-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-prefix', is_config=False)


  def _get_destination_address_prefix_set(self):
    """
    Getter method for destination_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_address_prefix_set (leafref)

    YANG Description: Reference to a IPv6 address prefix set
to match the destination address
    """
    return self.__destination_address_prefix_set
      
  def _set_destination_address_prefix_set(self, v, load=False):
    """
    Setter method for destination_address_prefix_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_address_prefix_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_address_prefix_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_address_prefix_set() directly.

    YANG Description: Reference to a IPv6 address prefix set
to match the destination address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_address_prefix_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__destination_address_prefix_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_address_prefix_set(self):
    self.__destination_address_prefix_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-address-prefix-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_destination_flow_label(self):
    """
    Getter method for destination_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_flow_label (oc-inet:ipv6-flow-label)

    YANG Description: Destination IPv6 Flow label.
    """
    return self.__destination_flow_label
      
  def _set_destination_flow_label(self, v, load=False):
    """
    Setter method for destination_flow_label, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/destination_flow_label (oc-inet:ipv6-flow-label)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_flow_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_flow_label() directly.

    YANG Description: Destination IPv6 Flow label.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_flow_label must be of a type compatible with oc-inet:ipv6-flow-label""",
          'defined-type': "oc-inet:ipv6-flow-label",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)""",
        })

    self.__destination_flow_label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_flow_label(self):
    self.__destination_flow_label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..1048575']}), is_leaf=True, yang_name="destination-flow-label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:ipv6-flow-label', is_config=False)


  def _get_dscp(self):
    """
    Getter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/dscp (oc-inet:dscp)

    YANG Description: Value of diffserv codepoint.
    """
    return self.__dscp
      
  def _set_dscp(self, v, load=False):
    """
    Setter method for dscp, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/dscp (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp() directly.

    YANG Description: Value of diffserv codepoint.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp(self):
    self.__dscp = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']}), is_leaf=True, yang_name="dscp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)


  def _get_dscp_set(self):
    """
    Getter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/dscp_set (oc-inet:dscp)

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    return self.__dscp_set
      
  def _set_dscp_set(self, v, load=False):
    """
    Setter method for dscp_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/dscp_set (oc-inet:dscp)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dscp_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dscp_set() directly.

    YANG Description: A list of DSCP values to be matched for incoming packets. AN OR match should
be performed, such that a packet must match one of the values defined in this
list. If the field is left empty then any DSCP value matches unless the 'dscp'
leaf is specified. It is not valid to specify both 'dscp' and 'dscp-set together.'
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dscp_set must be of a type compatible with oc-inet:dscp""",
          'defined-type': "oc-inet:dscp",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)""",
        })

    self.__dscp_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dscp_set(self):
    self.__dscp_set = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..63']})), is_leaf=False, yang_name="dscp-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-inet:dscp', is_config=False)


  def _get_length(self):
    """
    Getter method for length, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/length (uint16)

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    return self.__length
      
  def _set_length(self, v, load=False):
    """
    Setter method for length, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/length (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_length is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_length() directly.

    YANG Description: In the IPv4 header field, this field is known as the Total
Length.  Total Length is the length of the datagram, measured
in octets, including internet header and data.
In the IPv6 header field, this field is known as the Payload
Length, which is the length of the IPv6 payload, i.e., the rest
of the packet following the IPv6 header, in octets.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """length must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=False)""",
        })

    self.__length = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_length(self):
    self.__length = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="length", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint16', is_config=False)


  def _get_protocol(self):
    """
    Getter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/protocol (oc-pkt-match-types:ip-protocol-type)

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    return self.__protocol
      
  def _set_protocol(self, v, load=False):
    """
    Setter method for protocol, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/protocol (oc-pkt-match-types:ip-protocol-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_protocol() directly.

    YANG Description: The protocol carried in the IP packet, expressed either
as its IP protocol number, or by a defined identity.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """protocol must be of a type compatible with oc-pkt-match-types:ip-protocol-type""",
          'defined-type': "oc-pkt-match-types:ip-protocol-type",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)""",
        })

    self.__protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_protocol(self):
    self.__protocol = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..254']}),RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_TCP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_UDP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_ICMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IGMP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_PIM': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_RSVP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_GRE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_AUTH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_L2TP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:IP_IN_IP': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},),], is_leaf=True, yang_name="protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:ip-protocol-type', is_config=False)


  def _get_hop_limit(self):
    """
    Getter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/hop_limit (uint8)

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    return self.__hop_limit
      
  def _set_hop_limit(self, v, load=False):
    """
    Setter method for hop_limit, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state/hop_limit (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_limit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_limit() directly.

    YANG Description: The IP packet's hop limit -- known as TTL (in hops) in
IPv4 packets, and hop limit in IPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_limit must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)""",
        })

    self.__hop_limit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_limit(self):
    self.__hop_limit = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..255']}), is_leaf=True, yang_name="hop-limit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='uint8', is_config=False)

  source_address = __builtin__.property(_get_source_address)
  source_address_prefix_set = __builtin__.property(_get_source_address_prefix_set)
  source_flow_label = __builtin__.property(_get_source_flow_label)
  destination_address = __builtin__.property(_get_destination_address)
  destination_address_prefix_set = __builtin__.property(_get_destination_address_prefix_set)
  destination_flow_label = __builtin__.property(_get_destination_flow_label)
  dscp = __builtin__.property(_get_dscp)
  dscp_set = __builtin__.property(_get_dscp_set)
  length = __builtin__.property(_get_length)
  protocol = __builtin__.property(_get_protocol)
  hop_limit = __builtin__.property(_get_hop_limit)


  _pyangbind_elements = OrderedDict([('source_address', source_address), ('source_address_prefix_set', source_address_prefix_set), ('source_flow_label', source_flow_label), ('destination_address', destination_address), ('destination_address_prefix_set', destination_address_prefix_set), ('destination_flow_label', destination_flow_label), ('dscp', dscp), ('dscp_set', dscp_set), ('length', length), ('protocol', protocol), ('hop_limit', hop_limit), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration attributes for ICMPv6 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__code',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6', 'icmpv6', 'config']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/config/type (identityref)

    YANG Description: ICMPv6 type to be matched.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: ICMPv6 type to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)


  def _get_code(self):
    """
    Getter method for code, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/config/code (identityref)

    YANG Description: ICMP code to be matched.
    """
    return self.__code
      
  def _set_code(self, v, load=False):
    """
    Setter method for code, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/config/code (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_code() directly.

    YANG Description: ICMP code to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """code must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_code(self):
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

  type = __builtin__.property(_get_type, _set_type)
  code = __builtin__.property(_get_code, _set_code)


  _pyangbind_elements = OrderedDict([('type', type), ('code', code), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State attributes for ICMPv6 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__code',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6', 'icmpv6', 'state']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/state/type (identityref)

    YANG Description: ICMPv6 type to be matched.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: ICMPv6 type to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DESTINATION_UNREACHABLE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAMETER_PROBLEM': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:VERSION2_MULTICAST_LISTENER': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:CERTIFICATION_PATH_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_ADVERTISEMENT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_SOLICITATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_ROUTER_TERMINATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:FMIPV6': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ILNPV6_LOCATOR_UPDATE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_CONFIRMATION': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MPL_CONTROL': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)


  def _get_code(self):
    """
    Getter method for code, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/state/code (identityref)

    YANG Description: ICMP code to be matched.
    """
    return self.__code
      
  def _set_code(self, v, load=False):
    """
    Setter method for code, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/state/code (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_code is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_code() directly.

    YANG Description: ICMP code to be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """code must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__code = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_code(self):
    self.__code = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_NO_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_DST_ADMIN_PROHIBITED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_BEYOND_SCOPE_OF_SRC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_PORT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_SRC_ADDR_FAILED_POLICY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_REJECT_ROUTE_TO_DST': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_ERR_IN_SRC_ROUTING_HDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DST_UNREACHABLE_HDRS_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PACKET_TOO_BIG_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_HOP_LIMIT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:TIME_EXCEEDED_FRAGMENT_REASSEMBLY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_ERR_HDR_FIELD': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NET_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_IPV6_OPT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_INCOMPLETE_HDR_CHAIN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_SR_UPPER_HDR_ERR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_UNRECOGNIZED_NEXT_HDR_TYPE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_EXT_HDR_CHAIN_TOO_LONG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_EXT_HDRS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_TOO_MANY_OPTS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:PARAM_PROBLEM_OPT_TOO_BIG': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ECHO_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_QUERY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_REPORT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MULTICAST_LISTENER_DONE_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:ROUTER_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:REDIRECT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUMBERING_COMMAND': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_RESULT': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:RENUNBERING_SEQ_NUM_RESET': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV6_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_NAME': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_QUERY_IPV4_ADDR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NDDE_INFORMATION_RESPONSE_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_SUCCESS': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_REFUSED': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:NODE_INFORMATION_RESPONSE_UNKNOWN': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:INVERSE_NEIGHBOR_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REQUEST_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:HOME_AGENT_ADDRESS_DISCOVERY_REPLY_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_SOLICITATION_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:MOBILE_PREFIX_ADVERTISEMENT_NO_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_DAR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REQUEST_EDAR_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_DAC': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR64': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR128': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR192': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:DUPLICATE_ADDRESS_REPLY_EDAC_ROVR256': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REQUEST_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_CODE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_ERROR': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MALFORMED_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_INTERFACE': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_NO_SUCH_TABLE_ENTRY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}, 'oc-icmpv6-types:EXT_ECHO_REPLY_MULTIPLE_INTF_SATISFY_QUERY': {'@module': 'openconfig-icmpv6-types', '@namespace': 'http://openconfig.net/yang/openconfig-icmpv6-types'}},), is_leaf=True, yang_name="code", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)

  type = __builtin__.property(_get_type)
  code = __builtin__.property(_get_code)


  _pyangbind_elements = OrderedDict([('type', type), ('code', code), ])


class yc_icmpv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6/icmpv6. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top container for ICMPv6 filtering
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'icmpv6'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6', 'icmpv6']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/config (container)

    YANG Description: Configuration attributes for ICMPv6 filtering
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration attributes for ICMPv6 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/state (container)

    YANG Description: State attributes for ICMPv6 filtering
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State attributes for ICMPv6 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_ipv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/ipv6. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for IPv6 match field data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__icmpv6',)

  _yang_name = 'ipv6'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__icmpv6 = YANGDynClass(base=yc_icmpv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6, is_container='container', yang_name="icmpv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'ipv6']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config (container)

    YANG Description: Configuration data for IPv6 match fields
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for IPv6 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state (container)

    YANG Description: Operational state data for IPv6 match fields
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for IPv6 match fields
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_icmpv6(self):
    """
    Getter method for icmpv6, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6 (container)

    YANG Description: Top container for ICMPv6 filtering
    """
    return self.__icmpv6
      
  def _set_icmpv6(self, v, load=False):
    """
    Setter method for icmpv6, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/ipv6/icmpv6 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_icmpv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_icmpv6() directly.

    YANG Description: Top container for ICMPv6 filtering
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_icmpv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6, is_container='container', yang_name="icmpv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """icmpv6 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_icmpv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6, is_container='container', yang_name="icmpv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__icmpv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_icmpv6(self):
    self.__icmpv6 = YANGDynClass(base=yc_icmpv6_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_ipv6_icmpv6, is_container='container', yang_name="icmpv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  icmpv6 = __builtin__.property(_get_icmpv6, _set_icmpv6)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('icmpv6', icmpv6), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/transport/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_port','__source_port_set','__destination_port','__destination_port_set','__detail_mode','__explicit_detail_match_mode','__explicit_tcp_flags','__builtin_detail',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    self.__source_port_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    self.__destination_port_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__detail_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EXPLICIT': {}, 'BUILTIN': {}},), is_leaf=True, yang_name="detail-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)
    self.__explicit_detail_match_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="explicit-detail-match-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)
    self.__explicit_tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="explicit-tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    self.__builtin_detail = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TCP_INITIAL': {}, 'TCP_ESTABLISHED': {}, 'FRAGMENT': {}},), is_leaf=True, yang_name="builtin-detail", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'transport', 'config']

  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/source_port (oc-pkt-match-types:port-num-range)

    YANG Description: Source port or range
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/source_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.

    YANG Description: Source port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)


  def _get_source_port_set(self):
    """
    Getter method for source_port_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/source_port_set (leafref)

    YANG Description: Reference to a port set
to match the source port
    """
    return self.__source_port_set
      
  def _set_source_port_set(self, v, load=False):
    """
    Setter method for source_port_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/source_port_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port_set() directly.

    YANG Description: Reference to a port set
to match the source port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__source_port_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port_set(self):
    self.__source_port_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/destination_port (oc-pkt-match-types:port-num-range)

    YANG Description: Destination port or range
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/destination_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Destination port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=True)


  def _get_destination_port_set(self):
    """
    Getter method for destination_port_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/destination_port_set (leafref)

    YANG Description: Reference to a port set
to match the destination port
    """
    return self.__destination_port_set
      
  def _set_destination_port_set(self, v, load=False):
    """
    Setter method for destination_port_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/destination_port_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port_set() directly.

    YANG Description: Reference to a port set
to match the destination port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__destination_port_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port_set(self):
    self.__destination_port_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_detail_mode(self):
    """
    Getter method for detail_mode, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/detail_mode (enumeration)

    YANG Description: Mode that is used for matching detailed fields at the transport
layer. When EXPLICIT is specified, the implementation should
match based on the explicit flags that are specified in the
corresponding leaf. When BUILTIN is specified, the implementation
must expand the contents of the corresponding leaf to the flags
and/or fields that match the pre-defined built-in values.
    """
    return self.__detail_mode
      
  def _set_detail_mode(self, v, load=False):
    """
    Setter method for detail_mode, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/detail_mode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_detail_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_detail_mode() directly.

    YANG Description: Mode that is used for matching detailed fields at the transport
layer. When EXPLICIT is specified, the implementation should
match based on the explicit flags that are specified in the
corresponding leaf. When BUILTIN is specified, the implementation
must expand the contents of the corresponding leaf to the flags
and/or fields that match the pre-defined built-in values.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EXPLICIT': {}, 'BUILTIN': {}},), is_leaf=True, yang_name="detail-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """detail_mode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-acl:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EXPLICIT': {}, 'BUILTIN': {}},), is_leaf=True, yang_name="detail-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)""",
        })

    self.__detail_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_detail_mode(self):
    self.__detail_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EXPLICIT': {}, 'BUILTIN': {}},), is_leaf=True, yang_name="detail-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)


  def _get_explicit_detail_match_mode(self):
    """
    Getter method for explicit_detail_match_mode, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/explicit_detail_match_mode (enumeration)

    YANG Description: Specifies how the contents of the explicit-details-flags list
are to be treated. ANY implies that any of the flags may match,
where ALL indicates that all the flags must be matched.
    """
    return self.__explicit_detail_match_mode
      
  def _set_explicit_detail_match_mode(self, v, load=False):
    """
    Setter method for explicit_detail_match_mode, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/explicit_detail_match_mode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_explicit_detail_match_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_explicit_detail_match_mode() directly.

    YANG Description: Specifies how the contents of the explicit-details-flags list
are to be treated. ANY implies that any of the flags may match,
where ALL indicates that all the flags must be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="explicit-detail-match-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """explicit_detail_match_mode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-acl:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="explicit-detail-match-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)""",
        })

    self.__explicit_detail_match_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_explicit_detail_match_mode(self):
    self.__explicit_detail_match_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="explicit-detail-match-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)


  def _get_explicit_tcp_flags(self):
    """
    Getter method for explicit_tcp_flags, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/explicit_tcp_flags (identityref)

    YANG Description: An explicit list of the TCP flags that are to be matched. The
mechanism for the match is specified by the explicit-detail-match-mode
leaf.
    """
    return self.__explicit_tcp_flags
      
  def _set_explicit_tcp_flags(self, v, load=False):
    """
    Setter method for explicit_tcp_flags, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/explicit_tcp_flags (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_explicit_tcp_flags is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_explicit_tcp_flags() directly.

    YANG Description: An explicit list of the TCP flags that are to be matched. The
mechanism for the match is specified by the explicit-detail-match-mode
leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="explicit-tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """explicit_tcp_flags must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="explicit-tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__explicit_tcp_flags = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_explicit_tcp_flags(self):
    self.__explicit_tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="explicit-tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)


  def _get_builtin_detail(self):
    """
    Getter method for builtin_detail, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/builtin_detail (enumeration)

    YANG Description: Specifies a built-in (alias) for a match condition that matches
multiple flags, or specifies particular logic as to the flag matches
to be implemented. This leaf is only valid when the detail-match-mode
leaf is BUILTIN.
    """
    return self.__builtin_detail
      
  def _set_builtin_detail(self, v, load=False):
    """
    Setter method for builtin_detail, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config/builtin_detail (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_builtin_detail is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_builtin_detail() directly.

    YANG Description: Specifies a built-in (alias) for a match condition that matches
multiple flags, or specifies particular logic as to the flag matches
to be implemented. This leaf is only valid when the detail-match-mode
leaf is BUILTIN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TCP_INITIAL': {}, 'TCP_ESTABLISHED': {}, 'FRAGMENT': {}},), is_leaf=True, yang_name="builtin-detail", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """builtin_detail must be of a type compatible with enumeration""",
          'defined-type': "openconfig-acl:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TCP_INITIAL': {}, 'TCP_ESTABLISHED': {}, 'FRAGMENT': {}},), is_leaf=True, yang_name="builtin-detail", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)""",
        })

    self.__builtin_detail = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_builtin_detail(self):
    self.__builtin_detail = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TCP_INITIAL': {}, 'TCP_ESTABLISHED': {}, 'FRAGMENT': {}},), is_leaf=True, yang_name="builtin-detail", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=True)

  source_port = __builtin__.property(_get_source_port, _set_source_port)
  source_port_set = __builtin__.property(_get_source_port_set, _set_source_port_set)
  destination_port = __builtin__.property(_get_destination_port, _set_destination_port)
  destination_port_set = __builtin__.property(_get_destination_port_set, _set_destination_port_set)
  detail_mode = __builtin__.property(_get_detail_mode, _set_detail_mode)
  explicit_detail_match_mode = __builtin__.property(_get_explicit_detail_match_mode, _set_explicit_detail_match_mode)
  explicit_tcp_flags = __builtin__.property(_get_explicit_tcp_flags, _set_explicit_tcp_flags)
  builtin_detail = __builtin__.property(_get_builtin_detail, _set_builtin_detail)


  _pyangbind_elements = OrderedDict([('source_port', source_port), ('source_port_set', source_port_set), ('destination_port', destination_port), ('destination_port_set', destination_port_set), ('detail_mode', detail_mode), ('explicit_detail_match_mode', explicit_detail_match_mode), ('explicit_tcp_flags', explicit_tcp_flags), ('builtin_detail', builtin_detail), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/transport/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_port','__source_port_set','__destination_port','__destination_port_set','__detail_mode','__explicit_detail_match_mode','__explicit_tcp_flags','__builtin_detail',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    self.__source_port_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    self.__destination_port_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__detail_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EXPLICIT': {}, 'BUILTIN': {}},), is_leaf=True, yang_name="detail-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)
    self.__explicit_detail_match_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="explicit-detail-match-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)
    self.__explicit_tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="explicit-tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    self.__builtin_detail = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TCP_INITIAL': {}, 'TCP_ESTABLISHED': {}, 'FRAGMENT': {}},), is_leaf=True, yang_name="builtin-detail", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'transport', 'state']

  def _get_source_port(self):
    """
    Getter method for source_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/source_port (oc-pkt-match-types:port-num-range)

    YANG Description: Source port or range
    """
    return self.__source_port
      
  def _set_source_port(self, v, load=False):
    """
    Setter method for source_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/source_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port() directly.

    YANG Description: Source port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)""",
        })

    self.__source_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port(self):
    self.__source_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="source-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)


  def _get_source_port_set(self):
    """
    Getter method for source_port_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/source_port_set (leafref)

    YANG Description: Reference to a port set
to match the source port
    """
    return self.__source_port_set
      
  def _set_source_port_set(self, v, load=False):
    """
    Setter method for source_port_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/source_port_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_port_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_port_set() directly.

    YANG Description: Reference to a port set
to match the source port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_port_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__source_port_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_port_set(self):
    self.__source_port_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_destination_port(self):
    """
    Getter method for destination_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/destination_port (oc-pkt-match-types:port-num-range)

    YANG Description: Destination port or range
    """
    return self.__destination_port
      
  def _set_destination_port(self, v, load=False):
    """
    Setter method for destination_port, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/destination_port (oc-pkt-match-types:port-num-range)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port() directly.

    YANG Description: Destination port or range
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port must be of a type compatible with oc-pkt-match-types:port-num-range""",
          'defined-type': "oc-pkt-match-types:port-num-range",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)""",
        })

    self.__destination_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port(self):
    self.__destination_port = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])\\.\\.(0{0,4}[0-9]|0{0,3}[1-9][0-9]|0{0,2}[1-9][0-9]{2}|0?[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}},),], is_leaf=True, yang_name="destination-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='oc-pkt-match-types:port-num-range', is_config=False)


  def _get_destination_port_set(self):
    """
    Getter method for destination_port_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/destination_port_set (leafref)

    YANG Description: Reference to a port set
to match the destination port
    """
    return self.__destination_port_set
      
  def _set_destination_port_set(self, v, load=False):
    """
    Setter method for destination_port_set, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/destination_port_set (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_destination_port_set is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_destination_port_set() directly.

    YANG Description: Reference to a port set
to match the destination port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="destination-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """destination_port_set must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__destination_port_set = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_destination_port_set(self):
    self.__destination_port_set = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="destination-port-set", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_detail_mode(self):
    """
    Getter method for detail_mode, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/detail_mode (enumeration)

    YANG Description: Mode that is used for matching detailed fields at the transport
layer. When EXPLICIT is specified, the implementation should
match based on the explicit flags that are specified in the
corresponding leaf. When BUILTIN is specified, the implementation
must expand the contents of the corresponding leaf to the flags
and/or fields that match the pre-defined built-in values.
    """
    return self.__detail_mode
      
  def _set_detail_mode(self, v, load=False):
    """
    Setter method for detail_mode, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/detail_mode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_detail_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_detail_mode() directly.

    YANG Description: Mode that is used for matching detailed fields at the transport
layer. When EXPLICIT is specified, the implementation should
match based on the explicit flags that are specified in the
corresponding leaf. When BUILTIN is specified, the implementation
must expand the contents of the corresponding leaf to the flags
and/or fields that match the pre-defined built-in values.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EXPLICIT': {}, 'BUILTIN': {}},), is_leaf=True, yang_name="detail-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """detail_mode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-acl:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EXPLICIT': {}, 'BUILTIN': {}},), is_leaf=True, yang_name="detail-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)""",
        })

    self.__detail_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_detail_mode(self):
    self.__detail_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'EXPLICIT': {}, 'BUILTIN': {}},), is_leaf=True, yang_name="detail-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)


  def _get_explicit_detail_match_mode(self):
    """
    Getter method for explicit_detail_match_mode, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/explicit_detail_match_mode (enumeration)

    YANG Description: Specifies how the contents of the explicit-details-flags list
are to be treated. ANY implies that any of the flags may match,
where ALL indicates that all the flags must be matched.
    """
    return self.__explicit_detail_match_mode
      
  def _set_explicit_detail_match_mode(self, v, load=False):
    """
    Setter method for explicit_detail_match_mode, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/explicit_detail_match_mode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_explicit_detail_match_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_explicit_detail_match_mode() directly.

    YANG Description: Specifies how the contents of the explicit-details-flags list
are to be treated. ANY implies that any of the flags may match,
where ALL indicates that all the flags must be matched.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="explicit-detail-match-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """explicit_detail_match_mode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-acl:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="explicit-detail-match-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)""",
        })

    self.__explicit_detail_match_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_explicit_detail_match_mode(self):
    self.__explicit_detail_match_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ANY': {}, 'ALL': {}},), is_leaf=True, yang_name="explicit-detail-match-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)


  def _get_explicit_tcp_flags(self):
    """
    Getter method for explicit_tcp_flags, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/explicit_tcp_flags (identityref)

    YANG Description: An explicit list of the TCP flags that are to be matched. The
mechanism for the match is specified by the explicit-detail-match-mode
leaf.
    """
    return self.__explicit_tcp_flags
      
  def _set_explicit_tcp_flags(self, v, load=False):
    """
    Setter method for explicit_tcp_flags, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/explicit_tcp_flags (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_explicit_tcp_flags is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_explicit_tcp_flags() directly.

    YANG Description: An explicit list of the TCP flags that are to be matched. The
mechanism for the match is specified by the explicit-detail-match-mode
leaf.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="explicit-tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """explicit_tcp_flags must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="explicit-tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)""",
        })

    self.__explicit_tcp_flags = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_explicit_tcp_flags(self):
    self.__explicit_tcp_flags = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_SYN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_FIN': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_RST': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_PSH': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ACK': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_URG': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_ECE': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}, 'oc-pkt-match-types:TCP_CWR': {'@module': 'openconfig-packet-match-types', '@namespace': 'http://openconfig.net/yang/packet-match-types'}},)), is_leaf=False, yang_name="explicit-tcp-flags", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=False)


  def _get_builtin_detail(self):
    """
    Getter method for builtin_detail, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/builtin_detail (enumeration)

    YANG Description: Specifies a built-in (alias) for a match condition that matches
multiple flags, or specifies particular logic as to the flag matches
to be implemented. This leaf is only valid when the detail-match-mode
leaf is BUILTIN.
    """
    return self.__builtin_detail
      
  def _set_builtin_detail(self, v, load=False):
    """
    Setter method for builtin_detail, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state/builtin_detail (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_builtin_detail is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_builtin_detail() directly.

    YANG Description: Specifies a built-in (alias) for a match condition that matches
multiple flags, or specifies particular logic as to the flag matches
to be implemented. This leaf is only valid when the detail-match-mode
leaf is BUILTIN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TCP_INITIAL': {}, 'TCP_ESTABLISHED': {}, 'FRAGMENT': {}},), is_leaf=True, yang_name="builtin-detail", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """builtin_detail must be of a type compatible with enumeration""",
          'defined-type': "openconfig-acl:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TCP_INITIAL': {}, 'TCP_ESTABLISHED': {}, 'FRAGMENT': {}},), is_leaf=True, yang_name="builtin-detail", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)""",
        })

    self.__builtin_detail = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_builtin_detail(self):
    self.__builtin_detail = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TCP_INITIAL': {}, 'TCP_ESTABLISHED': {}, 'FRAGMENT': {}},), is_leaf=True, yang_name="builtin-detail", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='enumeration', is_config=False)

  source_port = __builtin__.property(_get_source_port)
  source_port_set = __builtin__.property(_get_source_port_set)
  destination_port = __builtin__.property(_get_destination_port)
  destination_port_set = __builtin__.property(_get_destination_port_set)
  detail_mode = __builtin__.property(_get_detail_mode)
  explicit_detail_match_mode = __builtin__.property(_get_explicit_detail_match_mode)
  explicit_tcp_flags = __builtin__.property(_get_explicit_tcp_flags)
  builtin_detail = __builtin__.property(_get_builtin_detail)


  _pyangbind_elements = OrderedDict([('source_port', source_port), ('source_port_set', source_port_set), ('destination_port', destination_port), ('destination_port_set', destination_port_set), ('detail_mode', detail_mode), ('explicit_detail_match_mode', explicit_detail_match_mode), ('explicit_tcp_flags', explicit_tcp_flags), ('builtin_detail', builtin_detail), ])


class yc_transport_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/transport. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Transport fields container
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'transport'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'transport']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config (container)

    YANG Description: Configuration data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state (container)

    YANG Description: State data
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/transport/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_transport_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'input-interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'input-interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'input-interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_input_interface_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/input-interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Input interface container. The interface is resolved based
on the interface and subinterface leaves of the interface-ref
container, which are references to entries in the /interfaces
list.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_ref',)

  _yang_name = 'input-interface'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'input-interface']

  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/input_interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_input_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='container', is_config=True)

  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)


  _pyangbind_elements = OrderedDict([('interface_ref', interface_ref), ])


class yc_config_openconfig_acl__acl_acl_sets_acl_set_acl_entries_acl_entry_actions_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-acl - based on the path /acl/acl-sets/acl-set/acl-entries/acl-entry/actions/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Config data for ACL actions
  """
  __slots__ = ('_path_helper', '_extmethods', '__forwarding_action','__log_action',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/acl'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__forwarding_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    self.__log_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['acl', 'acl-sets', 'acl-set', 'acl-entries', 'acl-entry', 'actions', 'config']

  def _get_forwarding_action(self):
    """
    Getter method for forwarding_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config/forwarding_action (identityref)

    YANG Description: Specifies the forwarding action.  One forwarding action
must be specified for each ACL entry
    """
    return self.__forwarding_action
      
  def _set_forwarding_action(self, v, load=False):
    """
    Setter method for forwarding_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config/forwarding_action (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_action is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_action() directly.

    YANG Description: Specifies the forwarding action.  One forwarding action
must be specified for each ACL entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_action must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__forwarding_action = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_action(self):
    self.__forwarding_action = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:ACCEPT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:DROP': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:REJECT': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), is_leaf=True, yang_name="forwarding-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)


  def _get_log_action(self):
    """
    Getter method for log_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config/log_action (identityref)

    YANG Description: Specifies the log action and destination for
matched packets.  The default is not to log the
packet.
    """
    return self.__log_action
      
  def _set_log_action(self, v, load=False):
    """
    Setter method for log_action, mapped from YANG variable /acl/acl_sets/acl_set/acl_entries/acl_entry/actions/config/log_action (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_log_action is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_log_action() directly.

    YANG Description: Specifies the log action and destination for
matched packets.  The default is not to log the
packet.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """log_action must be of a type compatible with identityref""",
          'defined-type': "openconfig-acl:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_SYSLOG': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}, 'oc-acl:LOG_NONE': {'@module': 'openconfig-acl', '@namespace': 'http://openconfig.net/yang/acl'}},), default=six.text_type("LOG_NONE"), is_leaf=True, yang_name="log-action", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/acl', defining_module='openconfig-acl', yang_type='identityref', is_config=True)""",
        })

    self.__log_action = t
    if hasattr(self, '_set'):
      self.