# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Static features or properties which characterize the
operational mode.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mode_id','__mode_type',)

  _yang_name = 'state'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mode_id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='uint16', is_config=False)
    self.__mode_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRANSCEIVER_MODE_TYPE_STANDARD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:TRANSCEIVER_MODE_TYPE_STANDARD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'TRANSCEIVER_MODE_TYPE_EXPLICIT': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:TRANSCEIVER_MODE_TYPE_EXPLICIT': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="mode-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'state']

  def _get_mode_id(self):
    """
    Getter method for mode_id, mapped from YANG variable /operational_modes/mode_descriptor/state/mode_id (uint16)

    YANG Description: Two-octet encoding of the vendor-defined operational
mode
    """
    return self.__mode_id
      
  def _set_mode_id(self, v, load=False):
    """
    Setter method for mode_id, mapped from YANG variable /operational_modes/mode_descriptor/state/mode_id (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mode_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mode_id() directly.

    YANG Description: Two-octet encoding of the vendor-defined operational
mode
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mode_id must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='uint16', is_config=False)""",
        })

    self.__mode_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mode_id(self):
    self.__mode_id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='uint16', is_config=False)


  def _get_mode_type(self):
    """
    Getter method for mode_type, mapped from YANG variable /operational_modes/mode_descriptor/state/mode_type (identityref)

    YANG Description: Indicates whether the transceiver's mode is a standard
mode, an organizational mode or an explicit mode.
    """
    return self.__mode_type
      
  def _set_mode_type(self, v, load=False):
    """
    Setter method for mode_type, mapped from YANG variable /operational_modes/mode_descriptor/state/mode_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mode_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mode_type() directly.

    YANG Description: Indicates whether the transceiver's mode is a standard
mode, an organizational mode or an explicit mode.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRANSCEIVER_MODE_TYPE_STANDARD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:TRANSCEIVER_MODE_TYPE_STANDARD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'TRANSCEIVER_MODE_TYPE_EXPLICIT': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:TRANSCEIVER_MODE_TYPE_EXPLICIT': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="mode-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mode_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device-properties:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRANSCEIVER_MODE_TYPE_STANDARD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:TRANSCEIVER_MODE_TYPE_STANDARD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'TRANSCEIVER_MODE_TYPE_EXPLICIT': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:TRANSCEIVER_MODE_TYPE_EXPLICIT': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="mode-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='identityref', is_config=False)""",
        })

    self.__mode_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mode_type(self):
    self.__mode_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRANSCEIVER_MODE_TYPE_STANDARD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:TRANSCEIVER_MODE_TYPE_STANDARD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'TRANSCEIVER_MODE_TYPE_EXPLICIT': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:TRANSCEIVER_MODE_TYPE_EXPLICIT': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="mode-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='identityref', is_config=False)

  mode_id = __builtin__.property(_get_mode_id)
  mode_type = __builtin__.property(_get_mode_type)


  _pyangbind_elements = OrderedDict([('mode_id', mode_id), ('mode_type', mode_type), ])


class yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/G.698.2/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational-mode standard mode state top container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__standard_mode',)

  _yang_name = 'state'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__standard_mode = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="standard-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:standard-mode', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'G.698.2', 'state']

  def _get_standard_mode(self):
    """
    Getter method for standard_mode, mapped from YANG variable /operational_modes/mode_descriptor/G_698_2/state/standard_mode (oc-opt-term-prop-types:standard-mode)

    YANG Description: G.698.2 (11/18) standard mode
    """
    return self.__standard_mode
      
  def _set_standard_mode(self, v, load=False):
    """
    Setter method for standard_mode, mapped from YANG variable /operational_modes/mode_descriptor/G_698_2/state/standard_mode (oc-opt-term-prop-types:standard-mode)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_standard_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_standard_mode() directly.

    YANG Description: G.698.2 (11/18) standard mode
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="standard-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:standard-mode', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """standard_mode must be of a type compatible with oc-opt-term-prop-types:standard-mode""",
          'defined-type': "oc-opt-term-prop-types:standard-mode",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="standard-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:standard-mode', is_config=False)""",
        })

    self.__standard_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_standard_mode(self):
    self.__standard_mode = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="standard-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:standard-mode', is_config=False)

  standard_mode = __builtin__.property(_get_standard_mode)


  _pyangbind_elements = OrderedDict([('standard_mode', standard_mode), ])


class yc_G_698_2_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/G.698.2. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: ITU-T G.698.2 (11/18) standard mode that guarantees interoperability.
It must be an string with the following format:
B-DScW-ytz(v) where all these attributes are conformant
to the ITU-T G.698.2 (11/18) recommendation.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'G.698.2'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'G.698.2']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /operational_modes/mode_descriptor/G_698_2/state (container)

    YANG Description: Operational-mode standard mode state top container.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /operational_modes/mode_descriptor/G_698_2/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational-mode standard mode state top container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational-mode explicit mode capabilities state container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__modulation_format','__bit_rate','__baud_rate','__optical_channel_spectrum_width','__min_tx_osnr','__min_rx_osnr','__min_input_power','__max_input_power','__max_chromatic_dispersion','__max_differential_group_delay','__max_polarization_dependent_loss',)

  _yang_name = 'state'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__modulation_format = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODULATION_FORMAT_BPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_BPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PAM4': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PAM4': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PAM8': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PAM8': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PROPRIETARY': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PROPRIETARY': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="modulation-format", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)
    self.__bit_rate = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="bit-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:bit-rate', is_config=False)
    self.__baud_rate = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="baud-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__optical_channel_spectrum_width = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="optical-channel-spectrum-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__min_tx_osnr = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-tx-osnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__min_rx_osnr = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-rx-osnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__min_input_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__max_input_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__max_chromatic_dispersion = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-chromatic-dispersion", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__max_differential_group_delay = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-differential-group-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__max_polarization_dependent_loss = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-polarization-dependent-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities', 'state']

  def _get_modulation_format(self):
    """
    Getter method for modulation_format, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/modulation_format (union)

    YANG Description: Optical modulation format associated to the mode. The
modulation format associated to the optical signal.
    """
    return self.__modulation_format
      
  def _set_modulation_format(self, v, load=False):
    """
    Setter method for modulation_format, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/modulation_format (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_modulation_format is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_modulation_format() directly.

    YANG Description: Optical modulation format associated to the mode. The
modulation format associated to the optical signal.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODULATION_FORMAT_BPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_BPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PAM4': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PAM4': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PAM8': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PAM8': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PROPRIETARY': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PROPRIETARY': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="modulation-format", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """modulation_format must be of a type compatible with union""",
          'defined-type': "openconfig-terminal-device-properties:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODULATION_FORMAT_BPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_BPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PAM4': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PAM4': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PAM8': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PAM8': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PROPRIETARY': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PROPRIETARY': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="modulation-format", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)""",
        })

    self.__modulation_format = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_modulation_format(self):
    self.__modulation_format = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODULATION_FORMAT_BPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_BPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_QPSK': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_8QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_16QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_32QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_DC_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_DC_DP_64QAM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PAM4': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PAM4': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PAM8': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PAM8': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'MODULATION_FORMAT_PROPRIETARY': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:MODULATION_FORMAT_PROPRIETARY': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="modulation-format", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)


  def _get_bit_rate(self):
    """
    Getter method for bit_rate, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/bit_rate (oc-opt-term-prop-types:bit-rate)

    YANG Description: Rounded bit rate of the tributary signal delivered by the
optical channel associated to the specific operational mode.
Exact bit rate will be refined by protocol selection at the
associated tributary logical channel.
    """
    return self.__bit_rate
      
  def _set_bit_rate(self, v, load=False):
    """
    Setter method for bit_rate, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/bit_rate (oc-opt-term-prop-types:bit-rate)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bit_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bit_rate() directly.

    YANG Description: Rounded bit rate of the tributary signal delivered by the
optical channel associated to the specific operational mode.
Exact bit rate will be refined by protocol selection at the
associated tributary logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="bit-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:bit-rate', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bit_rate must be of a type compatible with oc-opt-term-prop-types:bit-rate""",
          'defined-type': "oc-opt-term-prop-types:bit-rate",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="bit-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:bit-rate', is_config=False)""",
        })

    self.__bit_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bit_rate(self):
    self.__bit_rate = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="bit-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:bit-rate', is_config=False)


  def _get_baud_rate(self):
    """
    Getter method for baud_rate, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/baud_rate (decimal64)

    YANG Description: Baud-rate or symbol rate.
    """
    return self.__baud_rate
      
  def _set_baud_rate(self, v, load=False):
    """
    Setter method for baud_rate, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/baud_rate (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_baud_rate is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_baud_rate() directly.

    YANG Description: Baud-rate or symbol rate.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="baud-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """baud_rate must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="baud-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__baud_rate = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_baud_rate(self):
    self.__baud_rate = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="baud-rate", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_optical_channel_spectrum_width(self):
    """
    Getter method for optical_channel_spectrum_width, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/optical_channel_spectrum_width (decimal64)

    YANG Description: Spectrum width of the optical channel associated to this
operational mode, calculated as the baud-rate*(1+roll-off).
    """
    return self.__optical_channel_spectrum_width
      
  def _set_optical_channel_spectrum_width(self, v, load=False):
    """
    Setter method for optical_channel_spectrum_width, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/optical_channel_spectrum_width (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_channel_spectrum_width is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_channel_spectrum_width() directly.

    YANG Description: Spectrum width of the optical channel associated to this
operational mode, calculated as the baud-rate*(1+roll-off).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="optical-channel-spectrum-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_channel_spectrum_width must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="optical-channel-spectrum-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__optical_channel_spectrum_width = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_channel_spectrum_width(self):
    self.__optical_channel_spectrum_width = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="optical-channel-spectrum-width", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_min_tx_osnr(self):
    """
    Getter method for min_tx_osnr, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/min_tx_osnr (decimal64)

    YANG Description: Minimum in-band transmitter OSNR measured at 0.1nm@193.6Thz,
considering the maximum transceiver inserted noise. 
    """
    return self.__min_tx_osnr
      
  def _set_min_tx_osnr(self, v, load=False):
    """
    Setter method for min_tx_osnr, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/min_tx_osnr (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_tx_osnr is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_tx_osnr() directly.

    YANG Description: Minimum in-band transmitter OSNR measured at 0.1nm@193.6Thz,
considering the maximum transceiver inserted noise. 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-tx-osnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_tx_osnr must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-tx-osnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__min_tx_osnr = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_tx_osnr(self):
    self.__min_tx_osnr = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-tx-osnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_min_rx_osnr(self):
    """
    Getter method for min_rx_osnr, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/min_rx_osnr (decimal64)

    YANG Description: Minimum back-to-back OSNR measured over 0.1nm@193.6Thz or
12.5GHz noise resolution bandwidth at the min-input-power.
If received OSNR at min-input-power is lower than this value,
an increased level of bit-errors post-FEC needs to be
expected.
    """
    return self.__min_rx_osnr
      
  def _set_min_rx_osnr(self, v, load=False):
    """
    Setter method for min_rx_osnr, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/min_rx_osnr (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_rx_osnr is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_rx_osnr() directly.

    YANG Description: Minimum back-to-back OSNR measured over 0.1nm@193.6Thz or
12.5GHz noise resolution bandwidth at the min-input-power.
If received OSNR at min-input-power is lower than this value,
an increased level of bit-errors post-FEC needs to be
expected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-rx-osnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_rx_osnr must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-rx-osnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__min_rx_osnr = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_rx_osnr(self):
    self.__min_rx_osnr = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-rx-osnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_min_input_power(self):
    """
    Getter method for min_input_power, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/min_input_power (decimal64)

    YANG Description: Minimum value required input power in dBm of an optical channel
at the receiver (Rx) according to the given min-rx-osnr value. If
the input-power is lower it is expected to introduce an OSNR
penalty.
    """
    return self.__min_input_power
      
  def _set_min_input_power(self, v, load=False):
    """
    Setter method for min_input_power, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/min_input_power (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_input_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_input_power() directly.

    YANG Description: Minimum value required input power in dBm of an optical channel
at the receiver (Rx) according to the given min-rx-osnr value. If
the input-power is lower it is expected to introduce an OSNR
penalty.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_input_power must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__min_input_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_input_power(self):
    self.__min_input_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_max_input_power(self):
    """
    Getter method for max_input_power, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/max_input_power (decimal64)

    YANG Description: Maximum tolerated input power in dBm at the receiver (Rx)
of the coherence transceiver, which if exceeded can cause an
overload.
    """
    return self.__max_input_power
      
  def _set_max_input_power(self, v, load=False):
    """
    Setter method for max_input_power, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/max_input_power (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_input_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_input_power() directly.

    YANG Description: Maximum tolerated input power in dBm at the receiver (Rx)
of the coherence transceiver, which if exceeded can cause an
overload.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_input_power must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__max_input_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_input_power(self):
    self.__max_input_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-input-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_max_chromatic_dispersion(self):
    """
    Getter method for max_chromatic_dispersion, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/max_chromatic_dispersion (decimal64)

    YANG Description: Maximum chromatic-dispersion, accumulated value, supported by the
optical channel associated to the associated transmission mode
(operational model), expressed in picoseconds / nanometer (ps/nm).
    """
    return self.__max_chromatic_dispersion
      
  def _set_max_chromatic_dispersion(self, v, load=False):
    """
    Setter method for max_chromatic_dispersion, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/max_chromatic_dispersion (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_chromatic_dispersion is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_chromatic_dispersion() directly.

    YANG Description: Maximum chromatic-dispersion, accumulated value, supported by the
optical channel associated to the associated transmission mode
(operational model), expressed in picoseconds / nanometer (ps/nm).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-chromatic-dispersion", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_chromatic_dispersion must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-chromatic-dispersion", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__max_chromatic_dispersion = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_chromatic_dispersion(self):
    self.__max_chromatic_dispersion = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-chromatic-dispersion", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_max_differential_group_delay(self):
    """
    Getter method for max_differential_group_delay, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/max_differential_group_delay (decimal64)

    YANG Description: Maximum differential-group-delay, absolute value, supported by the
optical channel associated to the associated tranmission mode
(operational model), expressed in picoseconds (ps).
    """
    return self.__max_differential_group_delay
      
  def _set_max_differential_group_delay(self, v, load=False):
    """
    Setter method for max_differential_group_delay, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/max_differential_group_delay (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_differential_group_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_differential_group_delay() directly.

    YANG Description: Maximum differential-group-delay, absolute value, supported by the
optical channel associated to the associated tranmission mode
(operational model), expressed in picoseconds (ps).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-differential-group-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_differential_group_delay must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-differential-group-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__max_differential_group_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_differential_group_delay(self):
    self.__max_differential_group_delay = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-differential-group-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_max_polarization_dependent_loss(self):
    """
    Getter method for max_polarization_dependent_loss, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/max_polarization_dependent_loss (decimal64)

    YANG Description: Maximum polarization-dependent-loss accumulated value, supported by the
optical channel associated to the associated transmission mode
(operational model), expressed in decibels (dB)
    """
    return self.__max_polarization_dependent_loss
      
  def _set_max_polarization_dependent_loss(self, v, load=False):
    """
    Setter method for max_polarization_dependent_loss, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state/max_polarization_dependent_loss (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_polarization_dependent_loss is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_polarization_dependent_loss() directly.

    YANG Description: Maximum polarization-dependent-loss accumulated value, supported by the
optical channel associated to the associated transmission mode
(operational model), expressed in decibels (dB)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-polarization-dependent-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_polarization_dependent_loss must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-polarization-dependent-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__max_polarization_dependent_loss = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_polarization_dependent_loss(self):
    self.__max_polarization_dependent_loss = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-polarization-dependent-loss", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

  modulation_format = __builtin__.property(_get_modulation_format)
  bit_rate = __builtin__.property(_get_bit_rate)
  baud_rate = __builtin__.property(_get_baud_rate)
  optical_channel_spectrum_width = __builtin__.property(_get_optical_channel_spectrum_width)
  min_tx_osnr = __builtin__.property(_get_min_tx_osnr)
  min_rx_osnr = __builtin__.property(_get_min_rx_osnr)
  min_input_power = __builtin__.property(_get_min_input_power)
  max_input_power = __builtin__.property(_get_max_input_power)
  max_chromatic_dispersion = __builtin__.property(_get_max_chromatic_dispersion)
  max_differential_group_delay = __builtin__.property(_get_max_differential_group_delay)
  max_polarization_dependent_loss = __builtin__.property(_get_max_polarization_dependent_loss)


  _pyangbind_elements = OrderedDict([('modulation_format', modulation_format), ('bit_rate', bit_rate), ('baud_rate', baud_rate), ('optical_channel_spectrum_width', optical_channel_spectrum_width), ('min_tx_osnr', min_tx_osnr), ('min_rx_osnr', min_rx_osnr), ('min_input_power', min_input_power), ('max_input_power', max_input_power), ('max_chromatic_dispersion', max_chromatic_dispersion), ('max_differential_group_delay', max_differential_group_delay), ('max_polarization_dependent_loss', max_polarization_dependent_loss), ])


class yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities/fec/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: FEC state attributes top container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__fec_coding','__coding_overhead','__coding_gain','__pre_fec_ber_threshold',)

  _yang_name = 'state'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__fec_coding = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FEC_HD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_HD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_G': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_G': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_E': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_E': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_O': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_O': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_C': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_C': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_OTHER': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_OTHER': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="fec-coding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)
    self.__coding_overhead = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="coding-overhead", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__coding_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0.00), is_leaf=True, yang_name="coding-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__pre_fec_ber_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="pre-fec-ber-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities', 'fec', 'state']

  def _get_fec_coding(self):
    """
    Getter method for fec_coding, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state/fec_coding (union)

    YANG Description: Forward error correction (FEC) coding schema used in the
transmission mode. Type union of string (for proprietary codes)
and a set of standard codes encoded as identity references
    """
    return self.__fec_coding
      
  def _set_fec_coding(self, v, load=False):
    """
    Setter method for fec_coding, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state/fec_coding (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fec_coding is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fec_coding() directly.

    YANG Description: Forward error correction (FEC) coding schema used in the
transmission mode. Type union of string (for proprietary codes)
and a set of standard codes encoded as identity references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FEC_HD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_HD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_G': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_G': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_E': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_E': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_O': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_O': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_C': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_C': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_OTHER': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_OTHER': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="fec-coding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fec_coding must be of a type compatible with union""",
          'defined-type': "openconfig-terminal-device-properties:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FEC_HD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_HD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_G': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_G': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_E': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_E': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_O': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_O': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_C': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_C': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_OTHER': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_OTHER': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="fec-coding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)""",
        })

    self.__fec_coding = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fec_coding(self):
    self.__fec_coding = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FEC_HD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_HD': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_G': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_G': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_E': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_E': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_O': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_O': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_C': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_C': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FEC_OTHER': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FEC_OTHER': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="fec-coding", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)


  def _get_coding_overhead(self):
    """
    Getter method for coding_overhead, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state/coding_overhead (decimal64)

    YANG Description: Coding overhead rate in %.
    """
    return self.__coding_overhead
      
  def _set_coding_overhead(self, v, load=False):
    """
    Setter method for coding_overhead, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state/coding_overhead (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_coding_overhead is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_coding_overhead() directly.

    YANG Description: Coding overhead rate in %.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="coding-overhead", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """coding_overhead must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="coding-overhead", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__coding_overhead = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_coding_overhead(self):
    self.__coding_overhead = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="coding-overhead", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_coding_gain(self):
    """
    Getter method for coding_gain, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state/coding_gain (decimal64)

    YANG Description: Net coding gain (NCG) in dB units at 10E-15 bit error rate.
It may vary depending on the modulation format used in the
associated transmission mode (operational-mode).
    """
    return self.__coding_gain
      
  def _set_coding_gain(self, v, load=False):
    """
    Setter method for coding_gain, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state/coding_gain (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_coding_gain is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_coding_gain() directly.

    YANG Description: Net coding gain (NCG) in dB units at 10E-15 bit error rate.
It may vary depending on the modulation format used in the
associated transmission mode (operational-mode).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0.00), is_leaf=True, yang_name="coding-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """coding_gain must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0.00), is_leaf=True, yang_name="coding-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__coding_gain = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_coding_gain(self):
    self.__coding_gain = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), default=Decimal(0.00), is_leaf=True, yang_name="coding-gain", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_pre_fec_ber_threshold(self):
    """
    Getter method for pre_fec_ber_threshold, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state/pre_fec_ber_threshold (decimal64)

    YANG Description: Threshold on the PRE-FEC-BER, for which FEC code is able to
correct errors.
    """
    return self.__pre_fec_ber_threshold
      
  def _set_pre_fec_ber_threshold(self, v, load=False):
    """
    Setter method for pre_fec_ber_threshold, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state/pre_fec_ber_threshold (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pre_fec_ber_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pre_fec_ber_threshold() directly.

    YANG Description: Threshold on the PRE-FEC-BER, for which FEC code is able to
correct errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="pre-fec-ber-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pre_fec_ber_threshold must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="pre-fec-ber-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__pre_fec_ber_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pre_fec_ber_threshold(self):
    self.__pre_fec_ber_threshold = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="pre-fec-ber-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

  fec_coding = __builtin__.property(_get_fec_coding)
  coding_overhead = __builtin__.property(_get_coding_overhead)
  coding_gain = __builtin__.property(_get_coding_gain)
  pre_fec_ber_threshold = __builtin__.property(_get_pre_fec_ber_threshold)


  _pyangbind_elements = OrderedDict([('fec_coding', fec_coding), ('coding_overhead', coding_overhead), ('coding_gain', coding_gain), ('pre_fec_ber_threshold', pre_fec_ber_threshold), ])


class yc_fec_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities/fec. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The Forward Error Coding (FEC) coding schema used,
including the name, overhead, pre-fec-ber threshold and
gain properties.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'fec'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities', 'fec']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state (container)

    YANG Description: FEC state attributes top container.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: FEC state attributes top container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities/penalties/penalty/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Penalties list element's state attributes top container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__parameter_and_unit','__up_to_boundary','__penalty_value',)

  _yang_name = 'state'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__parameter_and_unit = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CD_PS_NM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:CD_PS_NM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'PMD_PS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:PMD_PS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'PDL_DB': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:PDL_DB': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="parameter-and-unit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:impairment-type', is_config=False)
    self.__up_to_boundary = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="up-to-boundary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__penalty_value = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="penalty-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities', 'penalties', 'penalty', 'state']

  def _get_parameter_and_unit(self):
    """
    Getter method for parameter_and_unit, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/state/parameter_and_unit (oc-opt-term-prop-types:impairment-type)

    YANG Description: Impairment and unit leading to the penalty (i.e., cd-ps)
    """
    return self.__parameter_and_unit
      
  def _set_parameter_and_unit(self, v, load=False):
    """
    Setter method for parameter_and_unit, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/state/parameter_and_unit (oc-opt-term-prop-types:impairment-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_parameter_and_unit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_parameter_and_unit() directly.

    YANG Description: Impairment and unit leading to the penalty (i.e., cd-ps)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CD_PS_NM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:CD_PS_NM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'PMD_PS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:PMD_PS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'PDL_DB': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:PDL_DB': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="parameter-and-unit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:impairment-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """parameter_and_unit must be of a type compatible with oc-opt-term-prop-types:impairment-type""",
          'defined-type': "oc-opt-term-prop-types:impairment-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CD_PS_NM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:CD_PS_NM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'PMD_PS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:PMD_PS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'PDL_DB': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:PDL_DB': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="parameter-and-unit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:impairment-type', is_config=False)""",
        })

    self.__parameter_and_unit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_parameter_and_unit(self):
    self.__parameter_and_unit = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'CD_PS_NM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:CD_PS_NM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'PMD_PS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:PMD_PS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'PDL_DB': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:PDL_DB': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="parameter-and-unit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:impairment-type', is_config=False)


  def _get_up_to_boundary(self):
    """
    Getter method for up_to_boundary, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/state/up_to_boundary (decimal64)

    YANG Description: defines the upper (for positive values) and lower (for negative values)
limit for which the penalty value is valid.
    """
    return self.__up_to_boundary
      
  def _set_up_to_boundary(self, v, load=False):
    """
    Setter method for up_to_boundary, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/state/up_to_boundary (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up_to_boundary is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up_to_boundary() directly.

    YANG Description: defines the upper (for positive values) and lower (for negative values)
limit for which the penalty value is valid.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="up-to-boundary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up_to_boundary must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="up-to-boundary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__up_to_boundary = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up_to_boundary(self):
    self.__up_to_boundary = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="up-to-boundary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_penalty_value(self):
    """
    Getter method for penalty_value, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/state/penalty_value (decimal64)

    YANG Description: OSNR penalty associated to the given values, expressed in dB.
    """
    return self.__penalty_value
      
  def _set_penalty_value(self, v, load=False):
    """
    Setter method for penalty_value, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/state/penalty_value (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_penalty_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_penalty_value() directly.

    YANG Description: OSNR penalty associated to the given values, expressed in dB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="penalty-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """penalty_value must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="penalty-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__penalty_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_penalty_value(self):
    self.__penalty_value = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="penalty-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

  parameter_and_unit = __builtin__.property(_get_parameter_and_unit)
  up_to_boundary = __builtin__.property(_get_up_to_boundary)
  penalty_value = __builtin__.property(_get_penalty_value)


  _pyangbind_elements = OrderedDict([('parameter_and_unit', parameter_and_unit), ('up_to_boundary', up_to_boundary), ('penalty_value', penalty_value), ])


class yc_penalty_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities/penalties/penalty. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Penalties includes contributions from different impairments including
cd, pmd, low RX Power, pdl,...
- For parameter values below lowest up-to-boundary value, the penalty is 0.
- For parameter values between lowest and highest up-to-boundary
values, penalty could be linearly interpolated.
- For parameter values above highest up-to-boundary value, the penalty is the one
included within penalty-value attribute associated to the highest up-to-boundary
  """
  __slots__ = ('_path_helper', '_extmethods', '__parameter_and_unit','__up_to_boundary','__state',)

  _yang_name = 'penalty'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__parameter_and_unit = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parameter-and-unit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)
    self.__up_to_boundary = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="up-to-boundary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities', 'penalties', 'penalty']

  def _get_parameter_and_unit(self):
    """
    Getter method for parameter_and_unit, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/parameter_and_unit (leafref)

    YANG Description: Impairment and unit leading to the penalty (i.e., cd-ps)
    """
    return self.__parameter_and_unit
      
  def _set_parameter_and_unit(self, v, load=False):
    """
    Setter method for parameter_and_unit, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/parameter_and_unit (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_parameter_and_unit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_parameter_and_unit() directly.

    YANG Description: Impairment and unit leading to the penalty (i.e., cd-ps)
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="parameter-and-unit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """parameter_and_unit must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parameter-and-unit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)""",
        })

    self.__parameter_and_unit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_parameter_and_unit(self):
    self.__parameter_and_unit = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="parameter-and-unit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)


  def _get_up_to_boundary(self):
    """
    Getter method for up_to_boundary, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/up_to_boundary (leafref)

    YANG Description: defines the upper (for positive values) and lower (for negative values)
limit for which the penalty value is valid.
    """
    return self.__up_to_boundary
      
  def _set_up_to_boundary(self, v, load=False):
    """
    Setter method for up_to_boundary, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/up_to_boundary (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_up_to_boundary is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_up_to_boundary() directly.

    YANG Description: defines the upper (for positive values) and lower (for negative values)
limit for which the penalty value is valid.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="up-to-boundary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """up_to_boundary must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="up-to-boundary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)""",
        })

    self.__up_to_boundary = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_up_to_boundary(self):
    self.__up_to_boundary = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="up-to-boundary", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/state (container)

    YANG Description: Penalties list element's state attributes top container.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Penalties list element's state attributes top container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

  parameter_and_unit = __builtin__.property(_get_parameter_and_unit)
  up_to_boundary = __builtin__.property(_get_up_to_boundary)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('parameter_and_unit', parameter_and_unit), ('up_to_boundary', up_to_boundary), ('state', state), ])


class yc_penalties_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities/penalties. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enconsing list's container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__penalty',)

  _yang_name = 'penalties'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__penalty = YANGDynClass(base=YANGListType("parameter_and_unit up_to_boundary",yc_penalty_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty, yang_name="penalty", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='parameter-and-unit up-to-boundary', extensions=None), is_container='list', yang_name="penalty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities', 'penalties']

  def _get_penalty(self):
    """
    Getter method for penalty, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty (list)

    YANG Description: Penalties includes contributions from different impairments including
cd, pmd, low RX Power, pdl,...
- For parameter values below lowest up-to-boundary value, the penalty is 0.
- For parameter values between lowest and highest up-to-boundary
values, penalty could be linearly interpolated.
- For parameter values above highest up-to-boundary value, the penalty is the one
included within penalty-value attribute associated to the highest up-to-boundary
    """
    return self.__penalty
      
  def _set_penalty(self, v, load=False):
    """
    Setter method for penalty, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties/penalty (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_penalty is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_penalty() directly.

    YANG Description: Penalties includes contributions from different impairments including
cd, pmd, low RX Power, pdl,...
- For parameter values below lowest up-to-boundary value, the penalty is 0.
- For parameter values between lowest and highest up-to-boundary
values, penalty could be linearly interpolated.
- For parameter values above highest up-to-boundary value, the penalty is the one
included within penalty-value attribute associated to the highest up-to-boundary
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("parameter_and_unit up_to_boundary",yc_penalty_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty, yang_name="penalty", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='parameter-and-unit up-to-boundary', extensions=None), is_container='list', yang_name="penalty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """penalty must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("parameter_and_unit up_to_boundary",yc_penalty_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty, yang_name="penalty", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='parameter-and-unit up-to-boundary', extensions=None), is_container='list', yang_name="penalty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='list', is_config=False)""",
        })

    self.__penalty = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_penalty(self):
    self.__penalty = YANGDynClass(base=YANGListType("parameter_and_unit up_to_boundary",yc_penalty_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties_penalty, yang_name="penalty", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='parameter-and-unit up-to-boundary', extensions=None), is_container='list', yang_name="penalty", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='list', is_config=False)

  penalty = __builtin__.property(_get_penalty)


  _pyangbind_elements = OrderedDict([('penalty', penalty), ])


class yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities/filter/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Filter's state attributes top container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__pulse_shaping_type','__roll_off',)

  _yang_name = 'state'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__pulse_shaping_type = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:RC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'RRC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:RRC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'OFF': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:OFF': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="pulse-shaping-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)
    self.__roll_off = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="roll-off", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities', 'filter', 'state']

  def _get_pulse_shaping_type(self):
    """
    Getter method for pulse_shaping_type, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/filter/state/pulse_shaping_type (union)

    YANG Description: Pulse/spectral shaping type such as Raised-cosine (RC),
 root-raised-cosine (RRC) and OFF. The attribute allows
 other pulse-shaping types to be encoded as strings.
    """
    return self.__pulse_shaping_type
      
  def _set_pulse_shaping_type(self, v, load=False):
    """
    Setter method for pulse_shaping_type, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/filter/state/pulse_shaping_type (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pulse_shaping_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pulse_shaping_type() directly.

    YANG Description: Pulse/spectral shaping type such as Raised-cosine (RC),
 root-raised-cosine (RRC) and OFF. The attribute allows
 other pulse-shaping types to be encoded as strings.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:RC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'RRC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:RRC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'OFF': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:OFF': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="pulse-shaping-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pulse_shaping_type must be of a type compatible with union""",
          'defined-type': "openconfig-terminal-device-properties:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:RC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'RRC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:RRC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'OFF': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:OFF': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="pulse-shaping-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)""",
        })

    self.__pulse_shaping_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pulse_shaping_type(self):
    self.__pulse_shaping_type = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:RC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'RRC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:RRC': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'OFF': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:OFF': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},),], is_leaf=True, yang_name="pulse-shaping-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='union', is_config=False)


  def _get_roll_off(self):
    """
    Getter method for roll_off, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/filter/state/roll_off (decimal64)

    YANG Description: Decimal fraction between 0 and 1. Roll-off parameter (𝛽) of the
TX pulse shaping filter. This assumes a raised-cosine filter
    """
    return self.__roll_off
      
  def _set_roll_off(self, v, load=False):
    """
    Setter method for roll_off, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/filter/state/roll_off (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_roll_off is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_roll_off() directly.

    YANG Description: Decimal fraction between 0 and 1. Roll-off parameter (𝛽) of the
TX pulse shaping filter. This assumes a raised-cosine filter
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="roll-off", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """roll_off must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="roll-off", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__roll_off = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_roll_off(self):
    self.__roll_off = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="roll-off", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

  pulse_shaping_type = __builtin__.property(_get_pulse_shaping_type)
  roll_off = __builtin__.property(_get_roll_off)


  _pyangbind_elements = OrderedDict([('pulse_shaping_type', pulse_shaping_type), ('roll_off', roll_off), ])


class yc_filter_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities/filter. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container includes information which characterises the filter at
transceiver transmission for the given operational-mode.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'filter'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities', 'filter']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/filter/state (container)

    YANG Description: Filter's state attributes top container.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/filter/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Filter's state attributes top container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_operational_mode_capabilities_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/operational-mode-capabilities. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Set of attributes which characterizes the operational-mode for optimal
optical-channel transmission and receiver functions. This attributes
are intending to describe all the relevant data used during the
network planning phase, to estimate the physical-impairment
tolerances which can be introduced by the DWDM optical path,
while assuring optimal transmission function.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state','__fec','__penalties','__filter',)

  _yang_name = 'operational-mode-capabilities'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    self.__fec = YANGDynClass(base=yc_fec_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec, is_container='container', yang_name="fec", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    self.__penalties = YANGDynClass(base=yc_penalties_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties, is_container='container', yang_name="penalties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    self.__filter = YANGDynClass(base=yc_filter_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter, is_container='container', yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'operational-mode-capabilities']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state (container)

    YANG Description: Operational-mode explicit mode capabilities state container.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational-mode explicit mode capabilities state container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)


  def _get_fec(self):
    """
    Getter method for fec, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec (container)

    YANG Description: The Forward Error Coding (FEC) coding schema used,
including the name, overhead, pre-fec-ber threshold and
gain properties.
    """
    return self.__fec
      
  def _set_fec(self, v, load=False):
    """
    Setter method for fec, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/fec (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fec is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fec() directly.

    YANG Description: The Forward Error Coding (FEC) coding schema used,
including the name, overhead, pre-fec-ber threshold and
gain properties.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_fec_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec, is_container='container', yang_name="fec", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fec must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_fec_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec, is_container='container', yang_name="fec", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__fec = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fec(self):
    self.__fec = YANGDynClass(base=yc_fec_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_fec, is_container='container', yang_name="fec", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)


  def _get_penalties(self):
    """
    Getter method for penalties, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties (container)

    YANG Description: Enconsing list's container.
    """
    return self.__penalties
      
  def _set_penalties(self, v, load=False):
    """
    Setter method for penalties, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/penalties (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_penalties is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_penalties() directly.

    YANG Description: Enconsing list's container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_penalties_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties, is_container='container', yang_name="penalties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """penalties must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_penalties_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties, is_container='container', yang_name="penalties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__penalties = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_penalties(self):
    self.__penalties = YANGDynClass(base=yc_penalties_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_penalties, is_container='container', yang_name="penalties", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)


  def _get_filter(self):
    """
    Getter method for filter, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/filter (container)

    YANG Description: This container includes information which characterises the filter at
transceiver transmission for the given operational-mode.
    """
    return self.__filter
      
  def _set_filter(self, v, load=False):
    """
    Setter method for filter, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities/filter (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_filter() directly.

    YANG Description: This container includes information which characterises the filter at
transceiver transmission for the given operational-mode.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_filter_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter, is_container='container', yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """filter must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_filter_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter, is_container='container', yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_filter(self):
    self.__filter = YANGDynClass(base=yc_filter_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities_filter, is_container='container', yang_name="filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)
  fec = __builtin__.property(_get_fec)
  penalties = __builtin__.property(_get_penalties)
  filter = __builtin__.property(_get_filter)


  _pyangbind_elements = OrderedDict([('state', state), ('fec', fec), ('penalties', penalties), ('filter', filter), ])


class yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/optical-channel-config-value-constraints/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational-mode explicit mode config value constrains state top
container.
  """
  __slots__ = ('_path_helper', '_extmethods', '__min_central_frequency','__max_central_frequency','__grid_type','__adjustment_granularity','__min_channel_spacing','__min_output_power','__max_output_power',)

  _yang_name = 'state'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__min_central_frequency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-central-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-types:frequency-type', is_config=False)
    self.__max_central_frequency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-central-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-types:frequency-type', is_config=False)
    self.__grid_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:DWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'CWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:CWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FLEX': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FLEX': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'GRIDLESS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:GRIDLESS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'UNSPECIFIED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:UNSPECIFIED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="grid-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:grid-type', is_config=False)
    self.__adjustment_granularity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'G_100GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_100GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_50GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_50GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_12_5GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_12_5GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_6_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_6_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_3_125GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_3_125GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'UNCONSTRAINED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:UNCONSTRAINED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="adjustment-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:adjustment-granularity', is_config=False)
    self.__min_channel_spacing = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-channel-spacing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__min_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    self.__max_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'optical-channel-config-value-constraints', 'state']

  def _get_min_central_frequency(self):
    """
    Getter method for min_central_frequency, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/min_central_frequency (oc-opt-types:frequency-type)

    YANG Description: The lowest configurable central frequency in MHz.
    """
    return self.__min_central_frequency
      
  def _set_min_central_frequency(self, v, load=False):
    """
    Setter method for min_central_frequency, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/min_central_frequency (oc-opt-types:frequency-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_central_frequency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_central_frequency() directly.

    YANG Description: The lowest configurable central frequency in MHz.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-central-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-types:frequency-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_central_frequency must be of a type compatible with oc-opt-types:frequency-type""",
          'defined-type': "oc-opt-types:frequency-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-central-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-types:frequency-type', is_config=False)""",
        })

    self.__min_central_frequency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_central_frequency(self):
    self.__min_central_frequency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-central-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-types:frequency-type', is_config=False)


  def _get_max_central_frequency(self):
    """
    Getter method for max_central_frequency, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/max_central_frequency (oc-opt-types:frequency-type)

    YANG Description: The highest configurable central frequency in MHz.
    """
    return self.__max_central_frequency
      
  def _set_max_central_frequency(self, v, load=False):
    """
    Setter method for max_central_frequency, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/max_central_frequency (oc-opt-types:frequency-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_central_frequency is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_central_frequency() directly.

    YANG Description: The highest configurable central frequency in MHz.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-central-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-types:frequency-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_central_frequency must be of a type compatible with oc-opt-types:frequency-type""",
          'defined-type': "oc-opt-types:frequency-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-central-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-types:frequency-type', is_config=False)""",
        })

    self.__max_central_frequency = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_central_frequency(self):
    self.__max_central_frequency = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-central-frequency", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-types:frequency-type', is_config=False)


  def _get_grid_type(self):
    """
    Getter method for grid_type, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/grid_type (oc-opt-term-prop-types:grid-type)

    YANG Description: Frequency  ITU-T G.694.1 (10/2020) grid specification attribute.
    """
    return self.__grid_type
      
  def _set_grid_type(self, v, load=False):
    """
    Setter method for grid_type, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/grid_type (oc-opt-term-prop-types:grid-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_grid_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_grid_type() directly.

    YANG Description: Frequency  ITU-T G.694.1 (10/2020) grid specification attribute.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:DWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'CWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:CWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FLEX': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FLEX': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'GRIDLESS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:GRIDLESS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'UNSPECIFIED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:UNSPECIFIED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="grid-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:grid-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """grid_type must be of a type compatible with oc-opt-term-prop-types:grid-type""",
          'defined-type': "oc-opt-term-prop-types:grid-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:DWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'CWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:CWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FLEX': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FLEX': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'GRIDLESS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:GRIDLESS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'UNSPECIFIED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:UNSPECIFIED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="grid-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:grid-type', is_config=False)""",
        })

    self.__grid_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_grid_type(self):
    self.__grid_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:DWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'CWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:CWDM': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'FLEX': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:FLEX': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'GRIDLESS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:GRIDLESS': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'UNSPECIFIED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:UNSPECIFIED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="grid-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:grid-type', is_config=False)


  def _get_adjustment_granularity(self):
    """
    Getter method for adjustment_granularity, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/adjustment_granularity (oc-opt-term-prop-types:adjustment-granularity)

    YANG Description: Adjustment granularity in Gigahertz. As per  ITU-T G.694.1
(10/2020), it is used to calculate nominal central frequency of an
optical channel. It defines the minimum granularity supporting by the
optical channel's central frequency setting.
    """
    return self.__adjustment_granularity
      
  def _set_adjustment_granularity(self, v, load=False):
    """
    Setter method for adjustment_granularity, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/adjustment_granularity (oc-opt-term-prop-types:adjustment-granularity)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_adjustment_granularity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_adjustment_granularity() directly.

    YANG Description: Adjustment granularity in Gigahertz. As per  ITU-T G.694.1
(10/2020), it is used to calculate nominal central frequency of an
optical channel. It defines the minimum granularity supporting by the
optical channel's central frequency setting.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'G_100GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_100GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_50GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_50GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_12_5GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_12_5GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_6_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_6_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_3_125GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_3_125GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'UNCONSTRAINED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:UNCONSTRAINED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="adjustment-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:adjustment-granularity', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """adjustment_granularity must be of a type compatible with oc-opt-term-prop-types:adjustment-granularity""",
          'defined-type': "oc-opt-term-prop-types:adjustment-granularity",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'G_100GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_100GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_50GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_50GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_12_5GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_12_5GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_6_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_6_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_3_125GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_3_125GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'UNCONSTRAINED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:UNCONSTRAINED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="adjustment-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:adjustment-granularity', is_config=False)""",
        })

    self.__adjustment_granularity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_adjustment_granularity(self):
    self.__adjustment_granularity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'G_100GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_100GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_50GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_50GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_12_5GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_12_5GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_6_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_6_25GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'G_3_125GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:G_3_125GHZ': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'UNCONSTRAINED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}, 'oc-opt-term-prop-types:UNCONSTRAINED': {'@module': 'openconfig-terminal-device-property-types', '@namespace': 'http://example.net/yang/openconfig-terminal-device-property-types'}},), is_leaf=True, yang_name="adjustment-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='oc-opt-term-prop-types:adjustment-granularity', is_config=False)


  def _get_min_channel_spacing(self):
    """
    Getter method for min_channel_spacing, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/min_channel_spacing (decimal64)

    YANG Description: Minimum recommended spectrum spacing between the central frequency of two
adjacent optical channels of the same mode. In case of two adjacent optical
channels with different operational-modes, it is up to the path computation
engine to determine the minimum distance between the central frequencies of
these two optical channels.
    """
    return self.__min_channel_spacing
      
  def _set_min_channel_spacing(self, v, load=False):
    """
    Setter method for min_channel_spacing, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/min_channel_spacing (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_channel_spacing is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_channel_spacing() directly.

    YANG Description: Minimum recommended spectrum spacing between the central frequency of two
adjacent optical channels of the same mode. In case of two adjacent optical
channels with different operational-modes, it is up to the path computation
engine to determine the minimum distance between the central frequencies of
these two optical channels.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-channel-spacing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_channel_spacing must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-channel-spacing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__min_channel_spacing = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_channel_spacing(self):
    self.__min_channel_spacing = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-channel-spacing", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_min_output_power(self):
    """
    Getter method for min_output_power, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/min_output_power (decimal64)

    YANG Description: Minimum target output optical power level of the optical channel,
configurable according to the optical transceiver mode properties,
expressed in increments of 0.01 dBm (decibel-milliwats)
    """
    return self.__min_output_power
      
  def _set_min_output_power(self, v, load=False):
    """
    Setter method for min_output_power, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/min_output_power (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_output_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_output_power() directly.

    YANG Description: Minimum target output optical power level of the optical channel,
configurable according to the optical transceiver mode properties,
expressed in increments of 0.01 dBm (decibel-milliwats)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_output_power must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__min_output_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_output_power(self):
    self.__min_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)


  def _get_max_output_power(self):
    """
    Getter method for max_output_power, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/max_output_power (decimal64)

    YANG Description: Maximum target output optical power level of the optical channel,
configurable according to the optical transceiver mode properties,
expressed in increments of 0.01 dBm (decibel-milliwatts)
    """
    return self.__max_output_power
      
  def _set_max_output_power(self, v, load=False):
    """
    Setter method for max_output_power, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state/max_output_power (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_output_power is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_output_power() directly.

    YANG Description: Maximum target output optical power level of the optical channel,
configurable according to the optical transceiver mode properties,
expressed in increments of 0.01 dBm (decibel-milliwatts)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_output_power must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)""",
        })

    self.__max_output_power = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_output_power(self):
    self.__max_output_power = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max-output-power", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='decimal64', is_config=False)

  min_central_frequency = __builtin__.property(_get_min_central_frequency)
  max_central_frequency = __builtin__.property(_get_max_central_frequency)
  grid_type = __builtin__.property(_get_grid_type)
  adjustment_granularity = __builtin__.property(_get_adjustment_granularity)
  min_channel_spacing = __builtin__.property(_get_min_channel_spacing)
  min_output_power = __builtin__.property(_get_min_output_power)
  max_output_power = __builtin__.property(_get_max_output_power)


  _pyangbind_elements = OrderedDict([('min_central_frequency', min_central_frequency), ('max_central_frequency', max_central_frequency), ('grid_type', grid_type), ('adjustment_granularity', adjustment_granularity), ('min_channel_spacing', min_channel_spacing), ('min_output_power', min_output_power), ('max_output_power', max_output_power), ])


class yc_optical_channel_config_value_constraints_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode/optical-channel-config-value-constraints. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Set of constraints of the configuration attributes
of the optical-channel associated to the selected
operational-mode.
  """
  __slots__ = ('_path_helper', '_extmethods', '__state',)

  _yang_name = 'optical-channel-config-value-constraints'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode', 'optical-channel-config-value-constraints']

  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state (container)

    YANG Description: Operational-mode explicit mode config value constrains state top
container.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational-mode explicit mode config value constrains state top
container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('state', state), ])


class yc_explicit_mode_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor/explicit-mode. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Explicit definition of the operational-mode. Typically this is used
for non-standard/proprietary modes defined by the terminal-device
vendor and it is self-described by the capabilities included in
the subtree underneath.
  """
  __slots__ = ('_path_helper', '_extmethods', '__operational_mode_capabilities','__optical_channel_config_value_constraints',)

  _yang_name = 'explicit-mode'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__operational_mode_capabilities = YANGDynClass(base=yc_operational_mode_capabilities_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities, is_container='container', yang_name="operational-mode-capabilities", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    self.__optical_channel_config_value_constraints = YANGDynClass(base=yc_optical_channel_config_value_constraints_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints, is_container='container', yang_name="optical-channel-config-value-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor', 'explicit-mode']

  def _get_operational_mode_capabilities(self):
    """
    Getter method for operational_mode_capabilities, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities (container)

    YANG Description: Set of attributes which characterizes the operational-mode for optimal
optical-channel transmission and receiver functions. This attributes
are intending to describe all the relevant data used during the
network planning phase, to estimate the physical-impairment
tolerances which can be introduced by the DWDM optical path,
while assuring optimal transmission function.
    """
    return self.__operational_mode_capabilities
      
  def _set_operational_mode_capabilities(self, v, load=False):
    """
    Setter method for operational_mode_capabilities, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/operational_mode_capabilities (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_operational_mode_capabilities is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_operational_mode_capabilities() directly.

    YANG Description: Set of attributes which characterizes the operational-mode for optimal
optical-channel transmission and receiver functions. This attributes
are intending to describe all the relevant data used during the
network planning phase, to estimate the physical-impairment
tolerances which can be introduced by the DWDM optical path,
while assuring optimal transmission function.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_operational_mode_capabilities_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities, is_container='container', yang_name="operational-mode-capabilities", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """operational_mode_capabilities must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_operational_mode_capabilities_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities, is_container='container', yang_name="operational-mode-capabilities", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__operational_mode_capabilities = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_operational_mode_capabilities(self):
    self.__operational_mode_capabilities = YANGDynClass(base=yc_operational_mode_capabilities_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_operational_mode_capabilities, is_container='container', yang_name="operational-mode-capabilities", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)


  def _get_optical_channel_config_value_constraints(self):
    """
    Getter method for optical_channel_config_value_constraints, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints (container)

    YANG Description: Set of constraints of the configuration attributes
of the optical-channel associated to the selected
operational-mode.
    """
    return self.__optical_channel_config_value_constraints
      
  def _set_optical_channel_config_value_constraints(self, v, load=False):
    """
    Setter method for optical_channel_config_value_constraints, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode/optical_channel_config_value_constraints (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_channel_config_value_constraints is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_channel_config_value_constraints() directly.

    YANG Description: Set of constraints of the configuration attributes
of the optical-channel associated to the selected
operational-mode.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_optical_channel_config_value_constraints_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints, is_container='container', yang_name="optical-channel-config-value-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_channel_config_value_constraints must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_optical_channel_config_value_constraints_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints, is_container='container', yang_name="optical-channel-config-value-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__optical_channel_config_value_constraints = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_channel_config_value_constraints(self):
    self.__optical_channel_config_value_constraints = YANGDynClass(base=yc_optical_channel_config_value_constraints_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode_optical_channel_config_value_constraints, is_container='container', yang_name="optical-channel-config-value-constraints", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

  operational_mode_capabilities = __builtin__.property(_get_operational_mode_capabilities)
  optical_channel_config_value_constraints = __builtin__.property(_get_optical_channel_config_value_constraints)


  _pyangbind_elements = OrderedDict([('operational_mode_capabilities', operational_mode_capabilities), ('optical_channel_config_value_constraints', optical_channel_config_value_constraints), ])


class yc_mode_descriptor_openconfig_terminal_device_properties__operational_modes_mode_descriptor(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes/mode-descriptor. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of operational modes supported by the platform.
The operational mode provides a platform-defined summary
of information such as symbol rate, modulation, pulse
shaping, etc.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mode_id','__state','__G_698_2','__explicit_mode',)

  _yang_name = 'mode-descriptor'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mode_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    self.__G_698_2 = YANGDynClass(base=yc_G_698_2_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2, is_container='container', yang_name="G.698.2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    self.__explicit_mode = YANGDynClass(base=yc_explicit_mode_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode, is_container='container', yang_name="explicit-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes', 'mode-descriptor']

  def _get_mode_id(self):
    """
    Getter method for mode_id, mapped from YANG variable /operational_modes/mode_descriptor/mode_id (leafref)

    YANG Description: Reference to mode-id
    """
    return self.__mode_id
      
  def _set_mode_id(self, v, load=False):
    """
    Setter method for mode_id, mapped from YANG variable /operational_modes/mode_descriptor/mode_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mode_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mode_id() directly.

    YANG Description: Reference to mode-id
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mode_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)""",
        })

    self.__mode_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mode_id(self):
    self.__mode_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /operational_modes/mode_descriptor/state (container)

    YANG Description: Static features or properties which characterize the
operational mode.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /operational_modes/mode_descriptor/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Static features or properties which characterize the
operational mode.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device_properties__operational_modes_mode_descriptor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)


  def _get_G_698_2(self):
    """
    Getter method for G_698_2, mapped from YANG variable /operational_modes/mode_descriptor/G_698_2 (container)

    YANG Description: ITU-T G.698.2 (11/18) standard mode that guarantees interoperability.
It must be an string with the following format:
B-DScW-ytz(v) where all these attributes are conformant
to the ITU-T G.698.2 (11/18) recommendation.
    """
    return self.__G_698_2
      
  def _set_G_698_2(self, v, load=False):
    """
    Setter method for G_698_2, mapped from YANG variable /operational_modes/mode_descriptor/G_698_2 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_G_698_2 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_G_698_2() directly.

    YANG Description: ITU-T G.698.2 (11/18) standard mode that guarantees interoperability.
It must be an string with the following format:
B-DScW-ytz(v) where all these attributes are conformant
to the ITU-T G.698.2 (11/18) recommendation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_G_698_2_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2, is_container='container', yang_name="G.698.2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """G_698_2 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_G_698_2_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2, is_container='container', yang_name="G.698.2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__G_698_2 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_G_698_2(self):
    self.__G_698_2 = YANGDynClass(base=yc_G_698_2_openconfig_terminal_device_properties__operational_modes_mode_descriptor_G_698_2, is_container='container', yang_name="G.698.2", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)


  def _get_explicit_mode(self):
    """
    Getter method for explicit_mode, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode (container)

    YANG Description: Explicit definition of the operational-mode. Typically this is used
for non-standard/proprietary modes defined by the terminal-device
vendor and it is self-described by the capabilities included in
the subtree underneath.
    """
    return self.__explicit_mode
      
  def _set_explicit_mode(self, v, load=False):
    """
    Setter method for explicit_mode, mapped from YANG variable /operational_modes/mode_descriptor/explicit_mode (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_explicit_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_explicit_mode() directly.

    YANG Description: Explicit definition of the operational-mode. Typically this is used
for non-standard/proprietary modes defined by the terminal-device
vendor and it is self-described by the capabilities included in
the subtree underneath.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_explicit_mode_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode, is_container='container', yang_name="explicit-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """explicit_mode must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_explicit_mode_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode, is_container='container', yang_name="explicit-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)""",
        })

    self.__explicit_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_explicit_mode(self):
    self.__explicit_mode = YANGDynClass(base=yc_explicit_mode_openconfig_terminal_device_properties__operational_modes_mode_descriptor_explicit_mode, is_container='container', yang_name="explicit-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=False)

  mode_id = __builtin__.property(_get_mode_id)
  state = __builtin__.property(_get_state)
  G_698_2 = __builtin__.property(_get_G_698_2)
  explicit_mode = __builtin__.property(_get_explicit_mode)


  _pyangbind_elements = OrderedDict([('mode_id', mode_id), ('state', state), ('G_698_2', G_698_2), ('explicit_mode', explicit_mode), ])


class yc_operational_modes_openconfig_terminal_device_properties__operational_modes(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /operational-modes. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Indicates the transceiver's list of supported operational
modes and its associated transmission features
  """
  __slots__ = ('_path_helper', '_extmethods', '__mode_descriptor',)

  _yang_name = 'operational-modes'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mode_descriptor = YANGDynClass(base=YANGListType("mode_id",yc_mode_descriptor_openconfig_terminal_device_properties__operational_modes_mode_descriptor, yang_name="mode-descriptor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mode-id', extensions=None), is_container='list', yang_name="mode-descriptor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['operational-modes']

  def _get_mode_descriptor(self):
    """
    Getter method for mode_descriptor, mapped from YANG variable /operational_modes/mode_descriptor (list)

    YANG Description: List of operational modes supported by the platform.
The operational mode provides a platform-defined summary
of information such as symbol rate, modulation, pulse
shaping, etc.
    """
    return self.__mode_descriptor
      
  def _set_mode_descriptor(self, v, load=False):
    """
    Setter method for mode_descriptor, mapped from YANG variable /operational_modes/mode_descriptor (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mode_descriptor is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mode_descriptor() directly.

    YANG Description: List of operational modes supported by the platform.
The operational mode provides a platform-defined summary
of information such as symbol rate, modulation, pulse
shaping, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("mode_id",yc_mode_descriptor_openconfig_terminal_device_properties__operational_modes_mode_descriptor, yang_name="mode-descriptor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mode-id', extensions=None), is_container='list', yang_name="mode-descriptor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mode_descriptor must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("mode_id",yc_mode_descriptor_openconfig_terminal_device_properties__operational_modes_mode_descriptor, yang_name="mode-descriptor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mode-id', extensions=None), is_container='list', yang_name="mode-descriptor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='list', is_config=False)""",
        })

    self.__mode_descriptor = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mode_descriptor(self):
    self.__mode_descriptor = YANGDynClass(base=YANGListType("mode_id",yc_mode_descriptor_openconfig_terminal_device_properties__operational_modes_mode_descriptor, yang_name="mode-descriptor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mode-id', extensions=None), is_container='list', yang_name="mode-descriptor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='list', is_config=False)

  mode_descriptor = __builtin__.property(_get_mode_descriptor)


  _pyangbind_elements = OrderedDict([('mode_descriptor', mode_descriptor), ])


class openconfig_terminal_device_properties(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-properties - based on the path /openconfig-terminal-device-properties. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Module to extend OpenConfig terminal device's operational modes'
data. It supports operational modes for one Optical
Channel, with a single OTSi. The operational mode includes key
attributes such modulation format, symbol rate, nominal central
frequency (NFC) tunability constraints (grid, min/max NCF), FEC
gain, minimum and maximum output power of the transmitter or
minimum OSNR at the receiver as well as the spectrum width of
the OTSi (OTSiMC). It also includes (optional) aspects such as
filter characterization, CD and DGD tolerance.
  """
  __slots__ = ('_path_helper', '_extmethods', '__operational_modes',)

  _yang_name = 'openconfig-terminal-device-properties'
  _yang_namespace = 'http://example.net/yang/openconfig-terminal-device-properties'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__operational_modes = YANGDynClass(base=yc_operational_modes_openconfig_terminal_device_properties__operational_modes, is_container='container', yang_name="operational-modes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_operational_modes(self):
    """
    Getter method for operational_modes, mapped from YANG variable /operational_modes (container)

    YANG Description: Indicates the transceiver's list of supported operational
modes and its associated transmission features
    """
    return self.__operational_modes
      
  def _set_operational_modes(self, v, load=False):
    """
    Setter method for operational_modes, mapped from YANG variable /operational_modes (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_operational_modes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_operational_modes() directly.

    YANG Description: Indicates the transceiver's list of supported operational
modes and its associated transmission features
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_operational_modes_openconfig_terminal_device_properties__operational_modes, is_container='container', yang_name="operational-modes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """operational_modes must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_operational_modes_openconfig_terminal_device_properties__operational_modes, is_container='container', yang_name="operational-modes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=True)""",
        })

    self.__operational_modes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_operational_modes(self):
    self.__operational_modes = YANGDynClass(base=yc_operational_modes_openconfig_terminal_device_properties__operational_modes, is_container='container', yang_name="operational-modes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://example.net/yang/openconfig-terminal-device-properties', defining_module='openconfig-terminal-device-properties', yang_type='container', is_config=True)

  operational_modes = __builtin__.property(_get_operational_modes, _set_operational_modes)


  _pyangbind_elements = OrderedDict([('operational_modes', operational_modes), ])


class openconfig_terminal_device_property_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device-property-types - based on the path /openconfig-terminal-device-property-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Supplementary module to expose identity types for the
openconfig-terminal-device-properties model. This model includes
definitions of the set of modulation format, FEC codes and adjustment
granularity types use in the reffered model.
  """
  _pyangbind_elements = {}

  

