# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__admin_state','__rate_class','__trib_protocol','__logical_channel_type','__loopback_mode','__test_signal','__client_mapping_mode',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    self.__admin_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=True)
    self.__rate_class = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    self.__trib_protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    self.__logical_channel_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    self.__loopback_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=True)
    self.__test_signal = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)
    self.__client_mapping_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/config/index (uint32)

    YANG Description: Index of the current logical channel
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/config/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Index of the current logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/config/description (string)

    YANG Description: Description of the logical channel
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Description of the logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)


  def _get_admin_state(self):
    """
    Getter method for admin_state, mapped from YANG variable /terminal_device/logical_channels/channel/config/admin_state (oc-opt-types:admin-state-type)

    YANG Description: Sets the admin state of the logical channel
    """
    return self.__admin_state
      
  def _set_admin_state(self, v, load=False):
    """
    Setter method for admin_state, mapped from YANG variable /terminal_device/logical_channels/channel/config/admin_state (oc-opt-types:admin-state-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_state() directly.

    YANG Description: Sets the admin state of the logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_state must be of a type compatible with oc-opt-types:admin-state-type""",
          'defined-type': "oc-opt-types:admin-state-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=True)""",
        })

    self.__admin_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_state(self):
    self.__admin_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=True)


  def _get_rate_class(self):
    """
    Getter method for rate_class, mapped from YANG variable /terminal_device/logical_channels/channel/config/rate_class (identityref)

    YANG Description: Rounded bit rate of the tributary signal. Exact bit rate
will be refined by protocol selection.
    """
    return self.__rate_class
      
  def _set_rate_class(self, v, load=False):
    """
    Setter method for rate_class, mapped from YANG variable /terminal_device/logical_channels/channel/config/rate_class (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rate_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rate_class() directly.

    YANG Description: Rounded bit rate of the tributary signal. Exact bit rate
will be refined by protocol selection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rate_class must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)""",
        })

    self.__rate_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rate_class(self):
    self.__rate_class = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)


  def _get_trib_protocol(self):
    """
    Getter method for trib_protocol, mapped from YANG variable /terminal_device/logical_channels/channel/config/trib_protocol (identityref)

    YANG Description: Protocol framing of the tributary signal. If this
LogicalChannel is directly connected to a Client-Port or
Optical-Channel, this is the protocol of the associated port.
If the LogicalChannel is connected to other LogicalChannels,
the TributaryProtocol of the LogicalChannels will define a
specific mapping/demapping or multiplexing/demultiplexing
function.

Not all protocols are valid, depending on the value
of trib-rate-class.  The expectation is that the NMS
will validate that a correct combination of rate class
and protocol are specfied.  Basic combinations are:

rate class: 1G
protocols: 1GE

rate class: 2.5G
protocols: OC48, STM16

rate class: 10G
protocols:  10GE LAN, 10GE WAN, OC192, STM64, OTU2, OTU2e,
           OTU1e, ODU2, ODU2e, ODU1e

rate class: 40G
protocols:  40GE, OC768, STM256, OTU3, ODU3

rate class: 100G
protocols:  100GE, 100G MLG, OTU4, OTUCn, ODU4
    """
    return self.__trib_protocol
      
  def _set_trib_protocol(self, v, load=False):
    """
    Setter method for trib_protocol, mapped from YANG variable /terminal_device/logical_channels/channel/config/trib_protocol (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_trib_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_trib_protocol() directly.

    YANG Description: Protocol framing of the tributary signal. If this
LogicalChannel is directly connected to a Client-Port or
Optical-Channel, this is the protocol of the associated port.
If the LogicalChannel is connected to other LogicalChannels,
the TributaryProtocol of the LogicalChannels will define a
specific mapping/demapping or multiplexing/demultiplexing
function.

Not all protocols are valid, depending on the value
of trib-rate-class.  The expectation is that the NMS
will validate that a correct combination of rate class
and protocol are specfied.  Basic combinations are:

rate class: 1G
protocols: 1GE

rate class: 2.5G
protocols: OC48, STM16

rate class: 10G
protocols:  10GE LAN, 10GE WAN, OC192, STM64, OTU2, OTU2e,
           OTU1e, ODU2, ODU2e, ODU1e

rate class: 40G
protocols:  40GE, OC768, STM256, OTU3, ODU3

rate class: 100G
protocols:  100GE, 100G MLG, OTU4, OTUCn, ODU4
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """trib_protocol must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)""",
        })

    self.__trib_protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_trib_protocol(self):
    self.__trib_protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)


  def _get_logical_channel_type(self):
    """
    Getter method for logical_channel_type, mapped from YANG variable /terminal_device/logical_channels/channel/config/logical_channel_type (identityref)

    YANG Description: The type / stage of the logical element determines the
configuration and operational state parameters (PMs)
available for the logical element
    """
    return self.__logical_channel_type
      
  def _set_logical_channel_type(self, v, load=False):
    """
    Setter method for logical_channel_type, mapped from YANG variable /terminal_device/logical_channels/channel/config/logical_channel_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical_channel_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical_channel_type() directly.

    YANG Description: The type / stage of the logical element determines the
configuration and operational state parameters (PMs)
available for the logical element
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical_channel_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)""",
        })

    self.__logical_channel_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical_channel_type(self):
    self.__logical_channel_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)


  def _get_loopback_mode(self):
    """
    Getter method for loopback_mode, mapped from YANG variable /terminal_device/logical_channels/channel/config/loopback_mode (oc-opt-types:loopback-mode-type)

    YANG Description: Sets the loopback type on the logical channel. Setting the
mode to something besides NONE activates the loopback in
the specified mode.
    """
    return self.__loopback_mode
      
  def _set_loopback_mode(self, v, load=False):
    """
    Setter method for loopback_mode, mapped from YANG variable /terminal_device/logical_channels/channel/config/loopback_mode (oc-opt-types:loopback-mode-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_mode() directly.

    YANG Description: Sets the loopback type on the logical channel. Setting the
mode to something besides NONE activates the loopback in
the specified mode.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_mode must be of a type compatible with oc-opt-types:loopback-mode-type""",
          'defined-type': "oc-opt-types:loopback-mode-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=True)""",
        })

    self.__loopback_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_mode(self):
    self.__loopback_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=True)


  def _get_test_signal(self):
    """
    Getter method for test_signal, mapped from YANG variable /terminal_device/logical_channels/channel/config/test_signal (boolean)

    YANG Description: When enabled the logical channel's DSP will generate a pseudo
randmon bit stream (PRBS) which can be used during testing.
    """
    return self.__test_signal
      
  def _set_test_signal(self, v, load=False):
    """
    Setter method for test_signal, mapped from YANG variable /terminal_device/logical_channels/channel/config/test_signal (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_test_signal is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_test_signal() directly.

    YANG Description: When enabled the logical channel's DSP will generate a pseudo
randmon bit stream (PRBS) which can be used during testing.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """test_signal must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)""",
        })

    self.__test_signal = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_test_signal(self):
    self.__test_signal = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)


  def _get_client_mapping_mode(self):
    """
    Getter method for client_mapping_mode, mapped from YANG variable /terminal_device/logical_channels/channel/config/client_mapping_mode (identityref)

    YANG Description: The client side mapping mode internal to the device that
specifies the number of client electrical interfaces and
the data rate of each client electrical interface. For
example, a ZR+ transceiver with an optical line rate of 400G
could be configured to break out into four 100G client
signals which might connect to an interface or a
physical-channel. This would be configured on the aggregate
logical channel as MODE_4X100G. This is only valid on the
aggregate logical channel that is connected directly to the
optical-channel.
    """
    return self.__client_mapping_mode
      
  def _set_client_mapping_mode(self, v, load=False):
    """
    Setter method for client_mapping_mode, mapped from YANG variable /terminal_device/logical_channels/channel/config/client_mapping_mode (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_client_mapping_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_client_mapping_mode() directly.

    YANG Description: The client side mapping mode internal to the device that
specifies the number of client electrical interfaces and
the data rate of each client electrical interface. For
example, a ZR+ transceiver with an optical line rate of 400G
could be configured to break out into four 100G client
signals which might connect to an interface or a
physical-channel. This would be configured on the aggregate
logical channel as MODE_4X100G. This is only valid on the
aggregate logical channel that is connected directly to the
optical-channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """client_mapping_mode must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)""",
        })

    self.__client_mapping_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_client_mapping_mode(self):
    self.__client_mapping_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  description = __builtin__.property(_get_description, _set_description)
  admin_state = __builtin__.property(_get_admin_state, _set_admin_state)
  rate_class = __builtin__.property(_get_rate_class, _set_rate_class)
  trib_protocol = __builtin__.property(_get_trib_protocol, _set_trib_protocol)
  logical_channel_type = __builtin__.property(_get_logical_channel_type, _set_logical_channel_type)
  loopback_mode = __builtin__.property(_get_loopback_mode, _set_loopback_mode)
  test_signal = __builtin__.property(_get_test_signal, _set_test_signal)
  client_mapping_mode = __builtin__.property(_get_client_mapping_mode, _set_client_mapping_mode)


  _pyangbind_elements = OrderedDict([('index', index), ('description', description), ('admin_state', admin_state), ('rate_class', rate_class), ('trib_protocol', trib_protocol), ('logical_channel_type', logical_channel_type), ('loopback_mode', loopback_mode), ('test_signal', test_signal), ('client_mapping_mode', client_mapping_mode), ])


class yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__admin_state','__rate_class','__trib_protocol','__logical_channel_type','__loopback_mode','__test_signal','__client_mapping_mode','__link_state',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__admin_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=False)
    self.__rate_class = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    self.__trib_protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    self.__logical_channel_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    self.__loopback_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=False)
    self.__test_signal = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)
    self.__client_mapping_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    self.__link_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="link-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'state']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/state/index (uint32)

    YANG Description: Index of the current logical channel
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/state/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Index of the current logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/state/description (string)

    YANG Description: Description of the logical channel
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Description of the logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_admin_state(self):
    """
    Getter method for admin_state, mapped from YANG variable /terminal_device/logical_channels/channel/state/admin_state (oc-opt-types:admin-state-type)

    YANG Description: Sets the admin state of the logical channel
    """
    return self.__admin_state
      
  def _set_admin_state(self, v, load=False):
    """
    Setter method for admin_state, mapped from YANG variable /terminal_device/logical_channels/channel/state/admin_state (oc-opt-types:admin-state-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_admin_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_admin_state() directly.

    YANG Description: Sets the admin state of the logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """admin_state must be of a type compatible with oc-opt-types:admin-state-type""",
          'defined-type': "oc-opt-types:admin-state-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=False)""",
        })

    self.__admin_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_admin_state(self):
    self.__admin_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ENABLED': {}, 'DISABLED': {}, 'MAINT': {}},), is_leaf=True, yang_name="admin-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:admin-state-type', is_config=False)


  def _get_rate_class(self):
    """
    Getter method for rate_class, mapped from YANG variable /terminal_device/logical_channels/channel/state/rate_class (identityref)

    YANG Description: Rounded bit rate of the tributary signal. Exact bit rate
will be refined by protocol selection.
    """
    return self.__rate_class
      
  def _set_rate_class(self, v, load=False):
    """
    Setter method for rate_class, mapped from YANG variable /terminal_device/logical_channels/channel/state/rate_class (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rate_class is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rate_class() directly.

    YANG Description: Rounded bit rate of the tributary signal. Exact bit rate
will be refined by protocol selection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rate_class must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)""",
        })

    self.__rate_class = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rate_class(self):
    self.__rate_class = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_10G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_40G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_650G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_700G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_750G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_800G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_850G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_900G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_950G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1000G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1050G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1150G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1250G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1300G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1350G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1450G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1500G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1550G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_RATE_1600G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="rate-class", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)


  def _get_trib_protocol(self):
    """
    Getter method for trib_protocol, mapped from YANG variable /terminal_device/logical_channels/channel/state/trib_protocol (identityref)

    YANG Description: Protocol framing of the tributary signal. If this
LogicalChannel is directly connected to a Client-Port or
Optical-Channel, this is the protocol of the associated port.
If the LogicalChannel is connected to other LogicalChannels,
the TributaryProtocol of the LogicalChannels will define a
specific mapping/demapping or multiplexing/demultiplexing
function.

Not all protocols are valid, depending on the value
of trib-rate-class.  The expectation is that the NMS
will validate that a correct combination of rate class
and protocol are specfied.  Basic combinations are:

rate class: 1G
protocols: 1GE

rate class: 2.5G
protocols: OC48, STM16

rate class: 10G
protocols:  10GE LAN, 10GE WAN, OC192, STM64, OTU2, OTU2e,
           OTU1e, ODU2, ODU2e, ODU1e

rate class: 40G
protocols:  40GE, OC768, STM256, OTU3, ODU3

rate class: 100G
protocols:  100GE, 100G MLG, OTU4, OTUCn, ODU4
    """
    return self.__trib_protocol
      
  def _set_trib_protocol(self, v, load=False):
    """
    Setter method for trib_protocol, mapped from YANG variable /terminal_device/logical_channels/channel/state/trib_protocol (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_trib_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_trib_protocol() directly.

    YANG Description: Protocol framing of the tributary signal. If this
LogicalChannel is directly connected to a Client-Port or
Optical-Channel, this is the protocol of the associated port.
If the LogicalChannel is connected to other LogicalChannels,
the TributaryProtocol of the LogicalChannels will define a
specific mapping/demapping or multiplexing/demultiplexing
function.

Not all protocols are valid, depending on the value
of trib-rate-class.  The expectation is that the NMS
will validate that a correct combination of rate class
and protocol are specfied.  Basic combinations are:

rate class: 1G
protocols: 1GE

rate class: 2.5G
protocols: OC48, STM16

rate class: 10G
protocols:  10GE LAN, 10GE WAN, OC192, STM64, OTU2, OTU2e,
           OTU1e, ODU2, ODU2e, ODU1e

rate class: 40G
protocols:  40GE, OC768, STM256, OTU3, ODU3

rate class: 100G
protocols:  100GE, 100G MLG, OTU4, OTUCn, ODU4
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """trib_protocol must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)""",
        })

    self.__trib_protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_trib_protocol(self):
    self.__trib_protocol = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_1GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC48': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM16': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_LAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_10GE_WAN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC192': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM64': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU1E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU2E': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_40GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OC768': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_STM256': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU3': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_100G_MLG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUCN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODU4': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_400GE': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTSIG': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ODUFLEX_GFP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="trib-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)


  def _get_logical_channel_type(self):
    """
    Getter method for logical_channel_type, mapped from YANG variable /terminal_device/logical_channels/channel/state/logical_channel_type (identityref)

    YANG Description: The type / stage of the logical element determines the
configuration and operational state parameters (PMs)
available for the logical element
    """
    return self.__logical_channel_type
      
  def _set_logical_channel_type(self, v, load=False):
    """
    Setter method for logical_channel_type, mapped from YANG variable /terminal_device/logical_channels/channel/state/logical_channel_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical_channel_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical_channel_type() directly.

    YANG Description: The type / stage of the logical element determines the
configuration and operational state parameters (PMs)
available for the logical element
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical_channel_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)""",
        })

    self.__logical_channel_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical_channel_type(self):
    self.__logical_channel_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_ETHERNET': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:PROT_OTN': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="logical-channel-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)


  def _get_loopback_mode(self):
    """
    Getter method for loopback_mode, mapped from YANG variable /terminal_device/logical_channels/channel/state/loopback_mode (oc-opt-types:loopback-mode-type)

    YANG Description: Sets the loopback type on the logical channel. Setting the
mode to something besides NONE activates the loopback in
the specified mode.
    """
    return self.__loopback_mode
      
  def _set_loopback_mode(self, v, load=False):
    """
    Setter method for loopback_mode, mapped from YANG variable /terminal_device/logical_channels/channel/state/loopback_mode (oc-opt-types:loopback-mode-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_mode() directly.

    YANG Description: Sets the loopback type on the logical channel. Setting the
mode to something besides NONE activates the loopback in
the specified mode.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_mode must be of a type compatible with oc-opt-types:loopback-mode-type""",
          'defined-type': "oc-opt-types:loopback-mode-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=False)""",
        })

    self.__loopback_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_mode(self):
    self.__loopback_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'FACILITY': {}, 'TERMINAL': {}},), default=six.text_type("NONE"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-opt-types:loopback-mode-type', is_config=False)


  def _get_test_signal(self):
    """
    Getter method for test_signal, mapped from YANG variable /terminal_device/logical_channels/channel/state/test_signal (boolean)

    YANG Description: When enabled the logical channel's DSP will generate a pseudo
randmon bit stream (PRBS) which can be used during testing.
    """
    return self.__test_signal
      
  def _set_test_signal(self, v, load=False):
    """
    Setter method for test_signal, mapped from YANG variable /terminal_device/logical_channels/channel/state/test_signal (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_test_signal is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_test_signal() directly.

    YANG Description: When enabled the logical channel's DSP will generate a pseudo
randmon bit stream (PRBS) which can be used during testing.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """test_signal must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)""",
        })

    self.__test_signal = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_test_signal(self):
    self.__test_signal = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="test-signal", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)


  def _get_client_mapping_mode(self):
    """
    Getter method for client_mapping_mode, mapped from YANG variable /terminal_device/logical_channels/channel/state/client_mapping_mode (identityref)

    YANG Description: The client side mapping mode internal to the device that
specifies the number of client electrical interfaces and
the data rate of each client electrical interface. For
example, a ZR+ transceiver with an optical line rate of 400G
could be configured to break out into four 100G client
signals which might connect to an interface or a
physical-channel. This would be configured on the aggregate
logical channel as MODE_4X100G. This is only valid on the
aggregate logical channel that is connected directly to the
optical-channel.
    """
    return self.__client_mapping_mode
      
  def _set_client_mapping_mode(self, v, load=False):
    """
    Setter method for client_mapping_mode, mapped from YANG variable /terminal_device/logical_channels/channel/state/client_mapping_mode (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_client_mapping_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_client_mapping_mode() directly.

    YANG Description: The client side mapping mode internal to the device that
specifies the number of client electrical interfaces and
the data rate of each client electrical interface. For
example, a ZR+ transceiver with an optical line rate of 400G
could be configured to break out into four 100G client
signals which might connect to an interface or a
physical-channel. This would be configured on the aggregate
logical channel as MODE_4X100G. This is only valid on the
aggregate logical channel that is connected directly to the
optical-channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """client_mapping_mode must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)""",
        })

    self.__client_mapping_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_client_mapping_mode(self):
    self.__client_mapping_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_1X400G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_2X200G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_3X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:MODE_4X100G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="client-mapping-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)


  def _get_link_state(self):
    """
    Getter method for link_state, mapped from YANG variable /terminal_device/logical_channels/channel/state/link_state (enumeration)

    YANG Description: Link-state of the Ethernet protocol on the logical channel,
SONET / SDH framed signal, etc.
    """
    return self.__link_state
      
  def _set_link_state(self, v, load=False):
    """
    Setter method for link_state, mapped from YANG variable /terminal_device/logical_channels/channel/state/link_state (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_state() directly.

    YANG Description: Link-state of the Ethernet protocol on the logical channel,
SONET / SDH framed signal, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="link-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_state must be of a type compatible with enumeration""",
          'defined-type': "openconfig-terminal-device:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="link-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)""",
        })

    self.__link_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_state(self):
    self.__link_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'UP': {}, 'DOWN': {}, 'TESTING': {}},), is_leaf=True, yang_name="link-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)

  index = __builtin__.property(_get_index)
  description = __builtin__.property(_get_description)
  admin_state = __builtin__.property(_get_admin_state)
  rate_class = __builtin__.property(_get_rate_class)
  trib_protocol = __builtin__.property(_get_trib_protocol)
  logical_channel_type = __builtin__.property(_get_logical_channel_type)
  loopback_mode = __builtin__.property(_get_loopback_mode)
  test_signal = __builtin__.property(_get_test_signal)
  client_mapping_mode = __builtin__.property(_get_client_mapping_mode)
  link_state = __builtin__.property(_get_link_state)


  _pyangbind_elements = OrderedDict([('index', index), ('description', description), ('admin_state', admin_state), ('rate_class', rate_class), ('trib_protocol', trib_protocol), ('logical_channel_type', logical_channel_type), ('loopback_mode', loopback_mode), ('test_signal', test_signal), ('client_mapping_mode', client_mapping_mode), ('link_state', link_state), ])


class yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/otn/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for OTN protocol framing
  """
  __slots__ = ('_path_helper', '_extmethods', '__tti_msg_transmit','__tti_msg_expected','__tti_msg_auto','__tributary_slot_granularity',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tti_msg_transmit = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-transmit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    self.__tti_msg_expected = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-expected", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    self.__tti_msg_auto = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="tti-msg-auto", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)
    self.__tributary_slot_granularity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="tributary-slot-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'otn', 'config']

  def _get_tti_msg_transmit(self):
    """
    Getter method for tti_msg_transmit, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config/tti_msg_transmit (string)

    YANG Description: Trail trace identifier (TTI) message transmitted
    """
    return self.__tti_msg_transmit
      
  def _set_tti_msg_transmit(self, v, load=False):
    """
    Setter method for tti_msg_transmit, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config/tti_msg_transmit (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tti_msg_transmit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tti_msg_transmit() directly.

    YANG Description: Trail trace identifier (TTI) message transmitted
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="tti-msg-transmit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tti_msg_transmit must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-transmit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)""",
        })

    self.__tti_msg_transmit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tti_msg_transmit(self):
    self.__tti_msg_transmit = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-transmit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)


  def _get_tti_msg_expected(self):
    """
    Getter method for tti_msg_expected, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config/tti_msg_expected (string)

    YANG Description: Trail trace identifier (TTI) message expected
    """
    return self.__tti_msg_expected
      
  def _set_tti_msg_expected(self, v, load=False):
    """
    Setter method for tti_msg_expected, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config/tti_msg_expected (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tti_msg_expected is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tti_msg_expected() directly.

    YANG Description: Trail trace identifier (TTI) message expected
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="tti-msg-expected", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tti_msg_expected must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-expected", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)""",
        })

    self.__tti_msg_expected = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tti_msg_expected(self):
    self.__tti_msg_expected = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-expected", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)


  def _get_tti_msg_auto(self):
    """
    Getter method for tti_msg_auto, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config/tti_msg_auto (boolean)

    YANG Description: Trail trace identifier (TTI) transmit message automatically
created.  If true, then setting a custom transmit message
would be invalid.
    """
    return self.__tti_msg_auto
      
  def _set_tti_msg_auto(self, v, load=False):
    """
    Setter method for tti_msg_auto, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config/tti_msg_auto (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tti_msg_auto is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tti_msg_auto() directly.

    YANG Description: Trail trace identifier (TTI) transmit message automatically
created.  If true, then setting a custom transmit message
would be invalid.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="tti-msg-auto", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tti_msg_auto must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="tti-msg-auto", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)""",
        })

    self.__tti_msg_auto = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tti_msg_auto(self):
    self.__tti_msg_auto = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="tti-msg-auto", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)


  def _get_tributary_slot_granularity(self):
    """
    Getter method for tributary_slot_granularity, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config/tributary_slot_granularity (identityref)

    YANG Description: Granularity value of OPUk or OPUCn tributary slots for OTN
signal allocation. The currently defined values follow the
existing ITU-T G.709 standard, which can be extended as
needed in future.
    """
    return self.__tributary_slot_granularity
      
  def _set_tributary_slot_granularity(self, v, load=False):
    """
    Setter method for tributary_slot_granularity, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config/tributary_slot_granularity (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tributary_slot_granularity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tributary_slot_granularity() directly.

    YANG Description: Granularity value of OPUk or OPUCn tributary slots for OTN
signal allocation. The currently defined values follow the
existing ITU-T G.709 standard, which can be extended as
needed in future.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="tributary-slot-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tributary_slot_granularity must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="tributary-slot-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)""",
        })

    self.__tributary_slot_granularity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tributary_slot_granularity(self):
    self.__tributary_slot_granularity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="tributary-slot-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)

  tti_msg_transmit = __builtin__.property(_get_tti_msg_transmit, _set_tti_msg_transmit)
  tti_msg_expected = __builtin__.property(_get_tti_msg_expected, _set_tti_msg_expected)
  tti_msg_auto = __builtin__.property(_get_tti_msg_auto, _set_tti_msg_auto)
  tributary_slot_granularity = __builtin__.property(_get_tributary_slot_granularity, _set_tributary_slot_granularity)


  _pyangbind_elements = OrderedDict([('tti_msg_transmit', tti_msg_transmit), ('tti_msg_expected', tti_msg_expected), ('tti_msg_auto', tti_msg_auto), ('tributary_slot_granularity', tributary_slot_granularity), ])


class yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_pre_fec_ber(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/otn/state/pre-fec-ber. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Bit error rate before forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'pre-fec-ber'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'otn', 'state', 'pre-fec-ber']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_post_fec_ber(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/otn/state/post-fec-ber. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Bit error rate after forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'post-fec-ber'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'otn', 'state', 'post-fec-ber']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_q_value(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/otn/state/q-value. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Quality value (factor) in dB of a channel with two
decimal precision. Values include the instantaneous,
average, minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'q-value'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'otn', 'state', 'q-value']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/min (decimal64)

    YANG Description: The minimum value of the statistic over the time interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_esnr(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/otn/state/esnr. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Electrical signal to noise ratio. Baud rate
normalized signal to noise ratio based on
error vector magnitude in dB with two decimal
precision. Values include the instantaneous, average,
minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'esnr'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'otn', 'state', 'esnr']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/min (decimal64)

    YANG Description: The minimum value of the statistic over the time interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/otn/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for OTN protocol PMs, statistics,
etc.
  """
  __slots__ = ('_path_helper', '_extmethods', '__tti_msg_transmit','__tti_msg_expected','__tti_msg_auto','__tributary_slot_granularity','__tti_msg_recv','__rdi_msg','__errored_seconds','__severely_errored_seconds','__unavailable_seconds','__code_violations','__errored_blocks','__fec_uncorrectable_words','__fec_corrected_bytes','__fec_corrected_bits','__background_block_errors','__fec_uncorrectable_blocks','__pre_fec_ber','__post_fec_ber','__q_value','__esnr',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tti_msg_transmit = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-transmit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__tti_msg_expected = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-expected", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__tti_msg_auto = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="tti-msg-auto", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)
    self.__tributary_slot_granularity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="tributary-slot-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    self.__tti_msg_recv = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-recv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__rdi_msg = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="rdi-msg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__errored_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__severely_errored_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="severely-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__unavailable_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unavailable-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__code_violations = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="code-violations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__errored_blocks = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errored-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__fec_uncorrectable_words = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-words", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__fec_corrected_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-corrected-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__fec_corrected_bits = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-corrected-bits", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__background_block_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="background-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__fec_uncorrectable_blocks = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__pre_fec_ber = YANGDynClass(base=yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_pre_fec_ber, is_container='container', yang_name="pre-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    self.__post_fec_ber = YANGDynClass(base=yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_post_fec_ber, is_container='container', yang_name="post-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    self.__q_value = YANGDynClass(base=yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_q_value, is_container='container', yang_name="q-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    self.__esnr = YANGDynClass(base=yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_esnr, is_container='container', yang_name="esnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'otn', 'state']

  def _get_tti_msg_transmit(self):
    """
    Getter method for tti_msg_transmit, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tti_msg_transmit (string)

    YANG Description: Trail trace identifier (TTI) message transmitted
    """
    return self.__tti_msg_transmit
      
  def _set_tti_msg_transmit(self, v, load=False):
    """
    Setter method for tti_msg_transmit, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tti_msg_transmit (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tti_msg_transmit is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tti_msg_transmit() directly.

    YANG Description: Trail trace identifier (TTI) message transmitted
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="tti-msg-transmit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tti_msg_transmit must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-transmit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__tti_msg_transmit = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tti_msg_transmit(self):
    self.__tti_msg_transmit = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-transmit", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_tti_msg_expected(self):
    """
    Getter method for tti_msg_expected, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tti_msg_expected (string)

    YANG Description: Trail trace identifier (TTI) message expected
    """
    return self.__tti_msg_expected
      
  def _set_tti_msg_expected(self, v, load=False):
    """
    Setter method for tti_msg_expected, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tti_msg_expected (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tti_msg_expected is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tti_msg_expected() directly.

    YANG Description: Trail trace identifier (TTI) message expected
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="tti-msg-expected", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tti_msg_expected must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-expected", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__tti_msg_expected = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tti_msg_expected(self):
    self.__tti_msg_expected = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-expected", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_tti_msg_auto(self):
    """
    Getter method for tti_msg_auto, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tti_msg_auto (boolean)

    YANG Description: Trail trace identifier (TTI) transmit message automatically
created.  If true, then setting a custom transmit message
would be invalid.
    """
    return self.__tti_msg_auto
      
  def _set_tti_msg_auto(self, v, load=False):
    """
    Setter method for tti_msg_auto, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tti_msg_auto (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tti_msg_auto is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tti_msg_auto() directly.

    YANG Description: Trail trace identifier (TTI) transmit message automatically
created.  If true, then setting a custom transmit message
would be invalid.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="tti-msg-auto", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tti_msg_auto must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="tti-msg-auto", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)""",
        })

    self.__tti_msg_auto = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tti_msg_auto(self):
    self.__tti_msg_auto = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="tti-msg-auto", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)


  def _get_tributary_slot_granularity(self):
    """
    Getter method for tributary_slot_granularity, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tributary_slot_granularity (identityref)

    YANG Description: Granularity value of OPUk or OPUCn tributary slots for OTN
signal allocation. The currently defined values follow the
existing ITU-T G.709 standard, which can be extended as
needed in future.
    """
    return self.__tributary_slot_granularity
      
  def _set_tributary_slot_granularity(self, v, load=False):
    """
    Setter method for tributary_slot_granularity, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tributary_slot_granularity (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tributary_slot_granularity is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tributary_slot_granularity() directly.

    YANG Description: Granularity value of OPUk or OPUCn tributary slots for OTN
signal allocation. The currently defined values follow the
existing ITU-T G.709 standard, which can be extended as
needed in future.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="tributary-slot-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tributary_slot_granularity must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="tributary-slot-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)""",
        })

    self.__tributary_slot_granularity = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tributary_slot_granularity(self):
    self.__tributary_slot_granularity = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_1.25G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_2.5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:TRIB_SLOT_5G': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="tributary-slot-granularity", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)


  def _get_tti_msg_recv(self):
    """
    Getter method for tti_msg_recv, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tti_msg_recv (string)

    YANG Description: Trail trace identifier (TTI) message received
    """
    return self.__tti_msg_recv
      
  def _set_tti_msg_recv(self, v, load=False):
    """
    Setter method for tti_msg_recv, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/tti_msg_recv (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tti_msg_recv is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tti_msg_recv() directly.

    YANG Description: Trail trace identifier (TTI) message received
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="tti-msg-recv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tti_msg_recv must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-recv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__tti_msg_recv = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tti_msg_recv(self):
    self.__tti_msg_recv = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="tti-msg-recv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_rdi_msg(self):
    """
    Getter method for rdi_msg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/rdi_msg (string)

    YANG Description: Remote defect indication (RDI) message received
    """
    return self.__rdi_msg
      
  def _set_rdi_msg(self, v, load=False):
    """
    Setter method for rdi_msg, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/rdi_msg (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rdi_msg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rdi_msg() directly.

    YANG Description: Remote defect indication (RDI) message received
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="rdi-msg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rdi_msg must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="rdi-msg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__rdi_msg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rdi_msg(self):
    self.__rdi_msg = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="rdi-msg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_errored_seconds(self):
    """
    Getter method for errored_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/errored_seconds (yang:counter64)

    YANG Description: The number of seconds that at least one errored blocks
occurs, at least one code violation occurs, loss of sync is
detected or loss of signal is detected
    """
    return self.__errored_seconds
      
  def _set_errored_seconds(self, v, load=False):
    """
    Setter method for errored_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/errored_seconds (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_errored_seconds is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_errored_seconds() directly.

    YANG Description: The number of seconds that at least one errored blocks
occurs, at least one code violation occurs, loss of sync is
detected or loss of signal is detected
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """errored_seconds must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__errored_seconds = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_errored_seconds(self):
    self.__errored_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_severely_errored_seconds(self):
    """
    Getter method for severely_errored_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/severely_errored_seconds (yang:counter64)

    YANG Description: The number of seconds that loss of frame is detected OR
the number of errored blocks, code violations, loss of sync
or loss of signal is detected exceeds a predefined
threshold
    """
    return self.__severely_errored_seconds
      
  def _set_severely_errored_seconds(self, v, load=False):
    """
    Setter method for severely_errored_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/severely_errored_seconds (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_severely_errored_seconds is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_severely_errored_seconds() directly.

    YANG Description: The number of seconds that loss of frame is detected OR
the number of errored blocks, code violations, loss of sync
or loss of signal is detected exceeds a predefined
threshold
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="severely-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """severely_errored_seconds must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="severely-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__severely_errored_seconds = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_severely_errored_seconds(self):
    self.__severely_errored_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="severely-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_unavailable_seconds(self):
    """
    Getter method for unavailable_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/unavailable_seconds (yang:counter64)

    YANG Description: The number of seconds during which the link is unavailable
    """
    return self.__unavailable_seconds
      
  def _set_unavailable_seconds(self, v, load=False):
    """
    Setter method for unavailable_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/unavailable_seconds (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_unavailable_seconds is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_unavailable_seconds() directly.

    YANG Description: The number of seconds during which the link is unavailable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unavailable-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """unavailable_seconds must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unavailable-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__unavailable_seconds = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_unavailable_seconds(self):
    self.__unavailable_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="unavailable-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_code_violations(self):
    """
    Getter method for code_violations, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/code_violations (yang:counter64)

    YANG Description: For ethernet or fiberchannel links, the number of 8b/10b
coding violations. For SONET/SDH, the number of BIP (bit
interleaved parity) errors
    """
    return self.__code_violations
      
  def _set_code_violations(self, v, load=False):
    """
    Setter method for code_violations, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/code_violations (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_code_violations is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_code_violations() directly.

    YANG Description: For ethernet or fiberchannel links, the number of 8b/10b
coding violations. For SONET/SDH, the number of BIP (bit
interleaved parity) errors
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="code-violations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """code_violations must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="code-violations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__code_violations = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_code_violations(self):
    self.__code_violations = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="code-violations", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_errored_blocks(self):
    """
    Getter method for errored_blocks, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/errored_blocks (yang:counter64)

    YANG Description: The number of errored blocks. Error detection codes are
capable to detect whether one or more errors have occurred
in a given sequence of bits – the block. It is normally not
possible to determine the exact number of errored bits within
the block.
    """
    return self.__errored_blocks
      
  def _set_errored_blocks(self, v, load=False):
    """
    Setter method for errored_blocks, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/errored_blocks (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_errored_blocks is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_errored_blocks() directly.

    YANG Description: The number of errored blocks. Error detection codes are
capable to detect whether one or more errors have occurred
in a given sequence of bits – the block. It is normally not
possible to determine the exact number of errored bits within
the block.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errored-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """errored_blocks must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errored-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__errored_blocks = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_errored_blocks(self):
    self.__errored_blocks = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="errored-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_fec_uncorrectable_words(self):
    """
    Getter method for fec_uncorrectable_words, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/fec_uncorrectable_words (yang:counter64)

    YANG Description: The number of words that were uncorrectable by the FEC
    """
    return self.__fec_uncorrectable_words
      
  def _set_fec_uncorrectable_words(self, v, load=False):
    """
    Setter method for fec_uncorrectable_words, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/fec_uncorrectable_words (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fec_uncorrectable_words is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fec_uncorrectable_words() directly.

    YANG Description: The number of words that were uncorrectable by the FEC
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-words", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fec_uncorrectable_words must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-words", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__fec_uncorrectable_words = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fec_uncorrectable_words(self):
    self.__fec_uncorrectable_words = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-words", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_fec_corrected_bytes(self):
    """
    Getter method for fec_corrected_bytes, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/fec_corrected_bytes (yang:counter64)

    YANG Description: The number of bytes that were corrected by the FEC
    """
    return self.__fec_corrected_bytes
      
  def _set_fec_corrected_bytes(self, v, load=False):
    """
    Setter method for fec_corrected_bytes, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/fec_corrected_bytes (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fec_corrected_bytes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fec_corrected_bytes() directly.

    YANG Description: The number of bytes that were corrected by the FEC
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-corrected-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fec_corrected_bytes must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-corrected-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__fec_corrected_bytes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fec_corrected_bytes(self):
    self.__fec_corrected_bytes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-corrected-bytes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_fec_corrected_bits(self):
    """
    Getter method for fec_corrected_bits, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/fec_corrected_bits (yang:counter64)

    YANG Description: The number of bits that were corrected by the FEC
    """
    return self.__fec_corrected_bits
      
  def _set_fec_corrected_bits(self, v, load=False):
    """
    Setter method for fec_corrected_bits, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/fec_corrected_bits (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fec_corrected_bits is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fec_corrected_bits() directly.

    YANG Description: The number of bits that were corrected by the FEC
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-corrected-bits", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fec_corrected_bits must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-corrected-bits", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__fec_corrected_bits = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fec_corrected_bits(self):
    self.__fec_corrected_bits = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-corrected-bits", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_background_block_errors(self):
    """
    Getter method for background_block_errors, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/background_block_errors (yang:counter64)

    YANG Description: The number of background block errors
    """
    return self.__background_block_errors
      
  def _set_background_block_errors(self, v, load=False):
    """
    Setter method for background_block_errors, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/background_block_errors (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_background_block_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_background_block_errors() directly.

    YANG Description: The number of background block errors
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="background-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """background_block_errors must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="background-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__background_block_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_background_block_errors(self):
    self.__background_block_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="background-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_fec_uncorrectable_blocks(self):
    """
    Getter method for fec_uncorrectable_blocks, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/fec_uncorrectable_blocks (yang:counter64)

    YANG Description: The number of blocks or frames that were uncorrectable by
the FEC
    """
    return self.__fec_uncorrectable_blocks
      
  def _set_fec_uncorrectable_blocks(self, v, load=False):
    """
    Setter method for fec_uncorrectable_blocks, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/fec_uncorrectable_blocks (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fec_uncorrectable_blocks is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fec_uncorrectable_blocks() directly.

    YANG Description: The number of blocks or frames that were uncorrectable by
the FEC
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fec_uncorrectable_blocks must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__fec_uncorrectable_blocks = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fec_uncorrectable_blocks(self):
    self.__fec_uncorrectable_blocks = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_pre_fec_ber(self):
    """
    Getter method for pre_fec_ber, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber (container)

    YANG Description: Bit error rate before forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
    """
    return self.__pre_fec_ber
      
  def _set_pre_fec_ber(self, v, load=False):
    """
    Setter method for pre_fec_ber, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/pre_fec_ber (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pre_fec_ber is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pre_fec_ber() directly.

    YANG Description: Bit error rate before forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_pre_fec_ber, is_container='container', yang_name="pre-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pre_fec_ber must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_pre_fec_ber, is_container='container', yang_name="pre-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__pre_fec_ber = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pre_fec_ber(self):
    self.__pre_fec_ber = YANGDynClass(base=yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_pre_fec_ber, is_container='container', yang_name="pre-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)


  def _get_post_fec_ber(self):
    """
    Getter method for post_fec_ber, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber (container)

    YANG Description: Bit error rate after forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
    """
    return self.__post_fec_ber
      
  def _set_post_fec_ber(self, v, load=False):
    """
    Setter method for post_fec_ber, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/post_fec_ber (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_post_fec_ber is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_post_fec_ber() directly.

    YANG Description: Bit error rate after forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_post_fec_ber, is_container='container', yang_name="post-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """post_fec_ber must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_post_fec_ber, is_container='container', yang_name="post-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__post_fec_ber = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_post_fec_ber(self):
    self.__post_fec_ber = YANGDynClass(base=yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_post_fec_ber, is_container='container', yang_name="post-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)


  def _get_q_value(self):
    """
    Getter method for q_value, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value (container)

    YANG Description: Quality value (factor) in dB of a channel with two
decimal precision. Values include the instantaneous,
average, minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
    """
    return self.__q_value
      
  def _set_q_value(self, v, load=False):
    """
    Setter method for q_value, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/q_value (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_q_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_q_value() directly.

    YANG Description: Quality value (factor) in dB of a channel with two
decimal precision. Values include the instantaneous,
average, minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_q_value, is_container='container', yang_name="q-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """q_value must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_q_value, is_container='container', yang_name="q-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__q_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_q_value(self):
    self.__q_value = YANGDynClass(base=yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_q_value, is_container='container', yang_name="q-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)


  def _get_esnr(self):
    """
    Getter method for esnr, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr (container)

    YANG Description: Electrical signal to noise ratio. Baud rate
normalized signal to noise ratio based on
error vector magnitude in dB with two decimal
precision. Values include the instantaneous, average,
minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
    """
    return self.__esnr
      
  def _set_esnr(self, v, load=False):
    """
    Setter method for esnr, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state/esnr (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_esnr is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_esnr() directly.

    YANG Description: Electrical signal to noise ratio. Baud rate
normalized signal to noise ratio based on
error vector magnitude in dB with two decimal
precision. Values include the instantaneous, average,
minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_esnr, is_container='container', yang_name="esnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """esnr must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_esnr, is_container='container', yang_name="esnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__esnr = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_esnr(self):
    self.__esnr = YANGDynClass(base=yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state_esnr, is_container='container', yang_name="esnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

  tti_msg_transmit = __builtin__.property(_get_tti_msg_transmit)
  tti_msg_expected = __builtin__.property(_get_tti_msg_expected)
  tti_msg_auto = __builtin__.property(_get_tti_msg_auto)
  tributary_slot_granularity = __builtin__.property(_get_tributary_slot_granularity)
  tti_msg_recv = __builtin__.property(_get_tti_msg_recv)
  rdi_msg = __builtin__.property(_get_rdi_msg)
  errored_seconds = __builtin__.property(_get_errored_seconds)
  severely_errored_seconds = __builtin__.property(_get_severely_errored_seconds)
  unavailable_seconds = __builtin__.property(_get_unavailable_seconds)
  code_violations = __builtin__.property(_get_code_violations)
  errored_blocks = __builtin__.property(_get_errored_blocks)
  fec_uncorrectable_words = __builtin__.property(_get_fec_uncorrectable_words)
  fec_corrected_bytes = __builtin__.property(_get_fec_corrected_bytes)
  fec_corrected_bits = __builtin__.property(_get_fec_corrected_bits)
  background_block_errors = __builtin__.property(_get_background_block_errors)
  fec_uncorrectable_blocks = __builtin__.property(_get_fec_uncorrectable_blocks)
  pre_fec_ber = __builtin__.property(_get_pre_fec_ber)
  post_fec_ber = __builtin__.property(_get_post_fec_ber)
  q_value = __builtin__.property(_get_q_value)
  esnr = __builtin__.property(_get_esnr)


  _pyangbind_elements = OrderedDict([('tti_msg_transmit', tti_msg_transmit), ('tti_msg_expected', tti_msg_expected), ('tti_msg_auto', tti_msg_auto), ('tributary_slot_granularity', tributary_slot_granularity), ('tti_msg_recv', tti_msg_recv), ('rdi_msg', rdi_msg), ('errored_seconds', errored_seconds), ('severely_errored_seconds', severely_errored_seconds), ('unavailable_seconds', unavailable_seconds), ('code_violations', code_violations), ('errored_blocks', errored_blocks), ('fec_uncorrectable_words', fec_uncorrectable_words), ('fec_corrected_bytes', fec_corrected_bytes), ('fec_corrected_bits', fec_corrected_bits), ('background_block_errors', background_block_errors), ('fec_uncorrectable_blocks', fec_uncorrectable_blocks), ('pre_fec_ber', pre_fec_ber), ('post_fec_ber', post_fec_ber), ('q_value', q_value), ('esnr', esnr), ])


class yc_otn_openconfig_terminal_device__terminal_device_logical_channels_channel_otn(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/otn. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for OTU configuration when logical
channel framing is using an OTU protocol, e.g., OTU1, OTU3,
etc.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'otn'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'otn']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config (container)

    YANG Description: Configuration data for OTN protocol framing
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/otn/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for OTN protocol framing
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state (container)

    YANG Description: Operational state data for OTN protocol PMs, statistics,
etc.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/otn/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for OTN protocol PMs, statistics,
etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_otn_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for Ethernet protocol framing on
logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__client_als','__als_delay',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__client_als = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'LASER_SHUTDOWN': {}, 'ETHERNET': {}},), default=six.text_type("ETHERNET"), is_leaf=True, yang_name="client-als", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=True)
    self.__als_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="als-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'config']

  def _get_client_als(self):
    """
    Getter method for client_als, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/config/client_als (enumeration)

    YANG Description: Sets the client port behavior that defines if the actions
of automatic laser shutdown (als), ethernet fault
propagation, or nothing will be done upon the detection
of a failure on the line port or the upstream remote
client port.
    """
    return self.__client_als
      
  def _set_client_als(self, v, load=False):
    """
    Setter method for client_als, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/config/client_als (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_client_als is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_client_als() directly.

    YANG Description: Sets the client port behavior that defines if the actions
of automatic laser shutdown (als), ethernet fault
propagation, or nothing will be done upon the detection
of a failure on the line port or the upstream remote
client port.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'LASER_SHUTDOWN': {}, 'ETHERNET': {}},), default=six.text_type("ETHERNET"), is_leaf=True, yang_name="client-als", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """client_als must be of a type compatible with enumeration""",
          'defined-type': "openconfig-terminal-device:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'LASER_SHUTDOWN': {}, 'ETHERNET': {}},), default=six.text_type("ETHERNET"), is_leaf=True, yang_name="client-als", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=True)""",
        })

    self.__client_als = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_client_als(self):
    self.__client_als = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'LASER_SHUTDOWN': {}, 'ETHERNET': {}},), default=six.text_type("ETHERNET"), is_leaf=True, yang_name="client-als", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=True)


  def _get_als_delay(self):
    """
    Getter method for als_delay, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/config/als_delay (uint32)

    YANG Description: The timer to delay the client-als actions on the client
port when a local or remote fault is detected on the line
port. The delay will only be valid when the client-als is
set to LASER_SHUTDOWN
    """
    return self.__als_delay
      
  def _set_als_delay(self, v, load=False):
    """
    Setter method for als_delay, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/config/als_delay (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_als_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_als_delay() directly.

    YANG Description: The timer to delay the client-als actions on the client
port when a local or remote fault is detected on the line
port. The delay will only be valid when the client-als is
set to LASER_SHUTDOWN
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="als-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """als_delay must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="als-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)""",
        })

    self.__als_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_als_delay(self):
    self.__als_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="als-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)

  client_als = __builtin__.property(_get_client_als, _set_client_als)
  als_delay = __builtin__.property(_get_als_delay, _set_als_delay)


  _pyangbind_elements = OrderedDict([('client_als', client_als), ('als_delay', als_delay), ])


class yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_pre_fec_ber(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/state/pre-fec-ber. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Bit error rate before forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'pre-fec-ber'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'state', 'pre-fec-ber']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_post_fec_ber(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/state/post-fec-ber. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Bit error rate after forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'post-fec-ber'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'state', 'post-fec-ber']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/min (decimal64)

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=18), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_q_value(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/state/q-value. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Quality value (factor) in dB of a channel with two
decimal precision. Values include the instantaneous,
average, minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'q-value'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'state', 'q-value']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/min (decimal64)

    YANG Description: The minimum value of the statistic over the time interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_esnr(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/state/esnr. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Electrical signal to noise ratio. Baud rate
normalized signal to noise ratio based on
error vector magnitude in dB with two decimal
precision. Values include the instantaneous, average,
minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
  """
  __slots__ = ('_path_helper', '_extmethods', '__instant','__avg','__min_','__max_','__interval','__min_time','__max_time',)

  _yang_name = 'esnr'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'state', 'esnr']

  def _get_instant(self):
    """
    Getter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/instant (decimal64)

    YANG Description: The instantaneous value of the statistic.
    """
    return self.__instant
      
  def _set_instant(self, v, load=False):
    """
    Setter method for instant, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/instant (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_instant is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_instant() directly.

    YANG Description: The instantaneous value of the statistic.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """instant must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__instant = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_instant(self):
    self.__instant = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="instant", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_avg(self):
    """
    Getter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/avg (decimal64)

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    return self.__avg
      
  def _set_avg(self, v, load=False):
    """
    Setter method for avg, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/avg (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_avg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_avg() directly.

    YANG Description: The arithmetic mean value of the statistic over the
time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """avg must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__avg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_avg(self):
    self.__avg = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="avg", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_min_(self):
    """
    Getter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/min (decimal64)

    YANG Description: The minimum value of the statistic over the time interval.
    """
    return self.__min_
      
  def _set_min_(self, v, load=False):
    """
    Setter method for min_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/min (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_() directly.

    YANG Description: The minimum value of the statistic over the time interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__min_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_(self):
    self.__min_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="min", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_max_(self):
    """
    Getter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/max (decimal64)

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    return self.__max_
      
  def _set_max_(self, v, load=False):
    """
    Setter method for max_, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/max (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_() directly.

    YANG Description: The maximum value of the statistic over the time
interval.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_ must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__max_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_(self):
    self.__max_ = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=2), is_leaf=True, yang_name="max", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_interval(self):
    """
    Getter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/interval (oc-types:stat-interval)

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    return self.__interval
      
  def _set_interval(self, v, load=False):
    """
    Setter method for interval, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/interval (oc-types:stat-interval)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interval() directly.

    YANG Description: If supported by the system, this reports the time interval
over which the min/max/average statistics are computed by
the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interval must be of a type compatible with oc-types:stat-interval""",
          'defined-type': "oc-types:stat-interval",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)""",
        })

    self.__interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interval(self):
    self.__interval = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:stat-interval', is_config=False)


  def _get_min_time(self):
    """
    Getter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/min_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__min_time
      
  def _set_min_time(self, v, load=False):
    """
    Setter method for min_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/min_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_min_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_min_time() directly.

    YANG Description: The absolute time at which the minimum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """min_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__min_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_min_time(self):
    self.__min_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="min-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)


  def _get_max_time(self):
    """
    Getter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/max_time (oc-types:timeticks64)

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    return self.__max_time
      
  def _set_max_time(self, v, load=False):
    """
    Setter method for max_time, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr/max_time (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_time() directly.

    YANG Description: The absolute time at which the maximum value occurred.
The value is the timestamp in nanoseconds relative to
 the Unix Epoch (Jan 1, 1970 00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_time must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__max_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_time(self):
    self.__max_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="max-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-types:timeticks64', is_config=False)

  instant = __builtin__.property(_get_instant)
  avg = __builtin__.property(_get_avg)
  min_ = __builtin__.property(_get_min_)
  max_ = __builtin__.property(_get_max_)
  interval = __builtin__.property(_get_interval)
  min_time = __builtin__.property(_get_min_time)
  max_time = __builtin__.property(_get_max_time)


  _pyangbind_elements = OrderedDict([('instant', instant), ('avg', avg), ('min_', min_), ('max_', max_), ('interval', interval), ('min_time', min_time), ('max_time', max_time), ])


class yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for Ethernet protocol framing
on logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__client_als','__als_delay','__in_mac_control_frames','__in_mac_pause_frames','__in_oversize_frames','__in_undersize_frames','__in_jabber_frames','__in_fragment_frames','__in_8021q_frames','__in_crc_errors','__in_block_errors','__in_carrier_errors','__in_interrupted_tx','__in_late_collision','__in_mac_errors_rx','__in_single_collision','__in_symbol_error','__in_maxsize_exceeded','__out_mac_control_frames','__out_mac_pause_frames','__out_8021q_frames','__out_mac_errors_tx','__in_pcs_bip_errors','__in_pcs_errored_seconds','__in_pcs_severely_errored_seconds','__in_pcs_unavailable_seconds','__out_pcs_bip_errors','__out_crc_errors','__out_block_errors','__fec_uncorrectable_blocks','__pre_fec_ber','__post_fec_ber','__q_value','__esnr',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__client_als = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'LASER_SHUTDOWN': {}, 'ETHERNET': {}},), default=six.text_type("ETHERNET"), is_leaf=True, yang_name="client-als", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)
    self.__als_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="als-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)
    self.__in_mac_control_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_mac_pause_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_oversize_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-oversize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_undersize_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-undersize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_jabber_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-jabber-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_fragment_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fragment-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_8021q_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_crc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_block_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_carrier_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-carrier-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_interrupted_tx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-interrupted-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_late_collision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-late-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_mac_errors_rx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-errors-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_single_collision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-single-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_symbol_error = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-symbol-error", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_maxsize_exceeded = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-maxsize-exceeded", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__out_mac_control_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__out_mac_pause_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__out_8021q_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__out_mac_errors_tx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-errors-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pcs_bip_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-bip-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pcs_errored_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pcs_severely_errored_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-severely-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__in_pcs_unavailable_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-unavailable-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__out_pcs_bip_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pcs-bip-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__out_crc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__out_block_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    self.__fec_uncorrectable_blocks = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__pre_fec_ber = YANGDynClass(base=yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_pre_fec_ber, is_container='container', yang_name="pre-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    self.__post_fec_ber = YANGDynClass(base=yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_post_fec_ber, is_container='container', yang_name="post-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    self.__q_value = YANGDynClass(base=yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_q_value, is_container='container', yang_name="q-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    self.__esnr = YANGDynClass(base=yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_esnr, is_container='container', yang_name="esnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'state']

  def _get_client_als(self):
    """
    Getter method for client_als, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/client_als (enumeration)

    YANG Description: Sets the client port behavior that defines if the actions
of automatic laser shutdown (als), ethernet fault
propagation, or nothing will be done upon the detection
of a failure on the line port or the upstream remote
client port.
    """
    return self.__client_als
      
  def _set_client_als(self, v, load=False):
    """
    Setter method for client_als, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/client_als (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_client_als is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_client_als() directly.

    YANG Description: Sets the client port behavior that defines if the actions
of automatic laser shutdown (als), ethernet fault
propagation, or nothing will be done upon the detection
of a failure on the line port or the upstream remote
client port.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'LASER_SHUTDOWN': {}, 'ETHERNET': {}},), default=six.text_type("ETHERNET"), is_leaf=True, yang_name="client-als", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """client_als must be of a type compatible with enumeration""",
          'defined-type': "openconfig-terminal-device:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'LASER_SHUTDOWN': {}, 'ETHERNET': {}},), default=six.text_type("ETHERNET"), is_leaf=True, yang_name="client-als", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)""",
        })

    self.__client_als = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_client_als(self):
    self.__client_als = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'NONE': {}, 'LASER_SHUTDOWN': {}, 'ETHERNET': {}},), default=six.text_type("ETHERNET"), is_leaf=True, yang_name="client-als", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)


  def _get_als_delay(self):
    """
    Getter method for als_delay, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/als_delay (uint32)

    YANG Description: The timer to delay the client-als actions on the client
port when a local or remote fault is detected on the line
port. The delay will only be valid when the client-als is
set to LASER_SHUTDOWN
    """
    return self.__als_delay
      
  def _set_als_delay(self, v, load=False):
    """
    Setter method for als_delay, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/als_delay (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_als_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_als_delay() directly.

    YANG Description: The timer to delay the client-als actions on the client
port when a local or remote fault is detected on the line
port. The delay will only be valid when the client-als is
set to LASER_SHUTDOWN
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="als-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """als_delay must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="als-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)""",
        })

    self.__als_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_als_delay(self):
    self.__als_delay = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), default=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32)(0), is_leaf=True, yang_name="als-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)


  def _get_in_mac_control_frames(self):
    """
    Getter method for in_mac_control_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_mac_control_frames (oc-yang:counter64)

    YANG Description: MAC layer control frames received on the interface
    """
    return self.__in_mac_control_frames
      
  def _set_in_mac_control_frames(self, v, load=False):
    """
    Setter method for in_mac_control_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_mac_control_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mac_control_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mac_control_frames() directly.

    YANG Description: MAC layer control frames received on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mac_control_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mac_control_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mac_control_frames(self):
    self.__in_mac_control_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_mac_pause_frames(self):
    """
    Getter method for in_mac_pause_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_mac_pause_frames (oc-yang:counter64)

    YANG Description: MAC layer PAUSE frames received on the interface
    """
    return self.__in_mac_pause_frames
      
  def _set_in_mac_pause_frames(self, v, load=False):
    """
    Setter method for in_mac_pause_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_mac_pause_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mac_pause_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mac_pause_frames() directly.

    YANG Description: MAC layer PAUSE frames received on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mac_pause_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mac_pause_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mac_pause_frames(self):
    self.__in_mac_pause_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_oversize_frames(self):
    """
    Getter method for in_oversize_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_oversize_frames (oc-yang:counter64)

    YANG Description: The total number of frames received that were
longer than 1518 octets (excluding framing bits,
but including FCS octets) and were otherwise
well formed.
    """
    return self.__in_oversize_frames
      
  def _set_in_oversize_frames(self, v, load=False):
    """
    Setter method for in_oversize_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_oversize_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_oversize_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_oversize_frames() directly.

    YANG Description: The total number of frames received that were
longer than 1518 octets (excluding framing bits,
but including FCS octets) and were otherwise
well formed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-oversize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_oversize_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-oversize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_oversize_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_oversize_frames(self):
    self.__in_oversize_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-oversize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_undersize_frames(self):
    """
    Getter method for in_undersize_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_undersize_frames (oc-yang:counter64)

    YANG Description: The total number of frames received that were
less than 64 octets long (excluding framing bits,
but including FCS octets) and were otherwise well
formed.
    """
    return self.__in_undersize_frames
      
  def _set_in_undersize_frames(self, v, load=False):
    """
    Setter method for in_undersize_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_undersize_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_undersize_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_undersize_frames() directly.

    YANG Description: The total number of frames received that were
less than 64 octets long (excluding framing bits,
but including FCS octets) and were otherwise well
formed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-undersize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_undersize_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-undersize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_undersize_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_undersize_frames(self):
    self.__in_undersize_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-undersize-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_jabber_frames(self):
    """
    Getter method for in_jabber_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_jabber_frames (oc-yang:counter64)

    YANG Description: Number of jabber frames received on the
interface.  Jabber frames are typically defined as oversize
frames which also have a bad CRC.  Implementations may use
slightly different definitions of what constitutes a jabber
frame.  Often indicative of a NIC hardware problem.
    """
    return self.__in_jabber_frames
      
  def _set_in_jabber_frames(self, v, load=False):
    """
    Setter method for in_jabber_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_jabber_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_jabber_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_jabber_frames() directly.

    YANG Description: Number of jabber frames received on the
interface.  Jabber frames are typically defined as oversize
frames which also have a bad CRC.  Implementations may use
slightly different definitions of what constitutes a jabber
frame.  Often indicative of a NIC hardware problem.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-jabber-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_jabber_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-jabber-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_jabber_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_jabber_frames(self):
    self.__in_jabber_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-jabber-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_fragment_frames(self):
    """
    Getter method for in_fragment_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_fragment_frames (oc-yang:counter64)

    YANG Description: The total number of frames received that were less than
64 octets in length (excluding framing bits but including
FCS octets) and had either a bad Frame Check Sequence
(FCS) with an integral number of octets (FCS Error) or a
bad FCS with a non-integral number of octets (Alignment
Error).
    """
    return self.__in_fragment_frames
      
  def _set_in_fragment_frames(self, v, load=False):
    """
    Setter method for in_fragment_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_fragment_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_fragment_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_fragment_frames() directly.

    YANG Description: The total number of frames received that were less than
64 octets in length (excluding framing bits but including
FCS octets) and had either a bad Frame Check Sequence
(FCS) with an integral number of octets (FCS Error) or a
bad FCS with a non-integral number of octets (Alignment
Error).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fragment-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_fragment_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fragment-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_fragment_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_fragment_frames(self):
    self.__in_fragment_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-fragment-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_8021q_frames(self):
    """
    Getter method for in_8021q_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_8021q_frames (oc-yang:counter64)

    YANG Description: Number of 802.1q tagged frames received on the interface
    """
    return self.__in_8021q_frames
      
  def _set_in_8021q_frames(self, v, load=False):
    """
    Setter method for in_8021q_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_8021q_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_8021q_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_8021q_frames() directly.

    YANG Description: Number of 802.1q tagged frames received on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_8021q_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_8021q_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_8021q_frames(self):
    self.__in_8021q_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_crc_errors(self):
    """
    Getter method for in_crc_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_crc_errors (oc-yang:counter64)

    YANG Description: The total number of frames received that
had a length (excluding framing bits, but
including FCS octets) of between 64 and 1518
octets, inclusive, but had either a bad
Frame Check Sequence (FCS) with an integral
number of octets (FCS Error) or a bad FCS with
a non-integral number of octets (Alignment Error)
    """
    return self.__in_crc_errors
      
  def _set_in_crc_errors(self, v, load=False):
    """
    Setter method for in_crc_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_crc_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_crc_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_crc_errors() directly.

    YANG Description: The total number of frames received that
had a length (excluding framing bits, but
including FCS octets) of between 64 and 1518
octets, inclusive, but had either a bad
Frame Check Sequence (FCS) with an integral
number of octets (FCS Error) or a bad FCS with
a non-integral number of octets (Alignment Error)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_crc_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_crc_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_crc_errors(self):
    self.__in_crc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_block_errors(self):
    """
    Getter method for in_block_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_block_errors (oc-yang:counter64)

    YANG Description: The number of received errored blocks. Error detection codes
are capable of detecting whether one or more errors have
occurred in a given sequence of bits – the block. It is
normally not possible to determine the exact number of errored
bits within the block
    """
    return self.__in_block_errors
      
  def _set_in_block_errors(self, v, load=False):
    """
    Setter method for in_block_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_block_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_block_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_block_errors() directly.

    YANG Description: The number of received errored blocks. Error detection codes
are capable of detecting whether one or more errors have
occurred in a given sequence of bits – the block. It is
normally not possible to determine the exact number of errored
bits within the block
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_block_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_block_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_block_errors(self):
    self.__in_block_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_carrier_errors(self):
    """
    Getter method for in_carrier_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_carrier_errors (oc-yang:counter64)

    YANG Description: The number of received errored frames due to a carrier issue.
The value refers to MIB counter for
dot3StatsCarrierSenseErrors
oid=1.3.6.1.2.1.10.7.2.1.11
    """
    return self.__in_carrier_errors
      
  def _set_in_carrier_errors(self, v, load=False):
    """
    Setter method for in_carrier_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_carrier_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_carrier_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_carrier_errors() directly.

    YANG Description: The number of received errored frames due to a carrier issue.
The value refers to MIB counter for
dot3StatsCarrierSenseErrors
oid=1.3.6.1.2.1.10.7.2.1.11
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-carrier-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_carrier_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-carrier-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_carrier_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_carrier_errors(self):
    self.__in_carrier_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-carrier-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_interrupted_tx(self):
    """
    Getter method for in_interrupted_tx, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_interrupted_tx (oc-yang:counter64)

    YANG Description: The number of received errored frames due to interrupted
transmission issue. The value refers to MIB counter for
dot3StatsDeferredTransmissions
oid=1.3.6.1.2.1.10.7.2.1.7
    """
    return self.__in_interrupted_tx
      
  def _set_in_interrupted_tx(self, v, load=False):
    """
    Setter method for in_interrupted_tx, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_interrupted_tx (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_interrupted_tx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_interrupted_tx() directly.

    YANG Description: The number of received errored frames due to interrupted
transmission issue. The value refers to MIB counter for
dot3StatsDeferredTransmissions
oid=1.3.6.1.2.1.10.7.2.1.7
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-interrupted-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_interrupted_tx must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-interrupted-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_interrupted_tx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_interrupted_tx(self):
    self.__in_interrupted_tx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-interrupted-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_late_collision(self):
    """
    Getter method for in_late_collision, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_late_collision (oc-yang:counter64)

    YANG Description: The number of received errored frames due to late collision
issue. The value refers to MIB counter for
dot3StatsLateCollisions
oid=1.3.6.1.2.1.10.7.2.1.8
    """
    return self.__in_late_collision
      
  def _set_in_late_collision(self, v, load=False):
    """
    Setter method for in_late_collision, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_late_collision (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_late_collision is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_late_collision() directly.

    YANG Description: The number of received errored frames due to late collision
issue. The value refers to MIB counter for
dot3StatsLateCollisions
oid=1.3.6.1.2.1.10.7.2.1.8
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-late-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_late_collision must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-late-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_late_collision = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_late_collision(self):
    self.__in_late_collision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-late-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_mac_errors_rx(self):
    """
    Getter method for in_mac_errors_rx, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_mac_errors_rx (oc-yang:counter64)

    YANG Description: The number of received errored frames due to MAC errors
received. The value refers to MIB counter for
dot3StatsInternalMacReceiveErrors
oid=1.3.6.1.2.1.10.7.2.1.16
    """
    return self.__in_mac_errors_rx
      
  def _set_in_mac_errors_rx(self, v, load=False):
    """
    Setter method for in_mac_errors_rx, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_mac_errors_rx (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_mac_errors_rx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_mac_errors_rx() directly.

    YANG Description: The number of received errored frames due to MAC errors
received. The value refers to MIB counter for
dot3StatsInternalMacReceiveErrors
oid=1.3.6.1.2.1.10.7.2.1.16
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-errors-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_mac_errors_rx must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-errors-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_mac_errors_rx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_mac_errors_rx(self):
    self.__in_mac_errors_rx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-mac-errors-rx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_single_collision(self):
    """
    Getter method for in_single_collision, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_single_collision (oc-yang:counter64)

    YANG Description: The number of received errored frames due to single collision
issue. The value refers to MIB counter for
dot3StatsSingleCollisionFrames
oid=1.3.6.1.2.1.10.7.2.1.4
    """
    return self.__in_single_collision
      
  def _set_in_single_collision(self, v, load=False):
    """
    Setter method for in_single_collision, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_single_collision (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_single_collision is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_single_collision() directly.

    YANG Description: The number of received errored frames due to single collision
issue. The value refers to MIB counter for
dot3StatsSingleCollisionFrames
oid=1.3.6.1.2.1.10.7.2.1.4
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-single-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_single_collision must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-single-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_single_collision = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_single_collision(self):
    self.__in_single_collision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-single-collision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_symbol_error(self):
    """
    Getter method for in_symbol_error, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_symbol_error (oc-yang:counter64)

    YANG Description: The number of received errored frames due to symbol error.
The value refers to MIB counter for
in-symbol-error
oid=1.3.6.1.2.1.10.7.2.1.18
    """
    return self.__in_symbol_error
      
  def _set_in_symbol_error(self, v, load=False):
    """
    Setter method for in_symbol_error, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_symbol_error (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_symbol_error is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_symbol_error() directly.

    YANG Description: The number of received errored frames due to symbol error.
The value refers to MIB counter for
in-symbol-error
oid=1.3.6.1.2.1.10.7.2.1.18
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-symbol-error", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_symbol_error must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-symbol-error", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_symbol_error = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_symbol_error(self):
    self.__in_symbol_error = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-symbol-error", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_maxsize_exceeded(self):
    """
    Getter method for in_maxsize_exceeded, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_maxsize_exceeded (oc-yang:counter64)

    YANG Description: The total number frames received that are well-formed but
dropped due to exceeding the maximum frame size on the interface
(e.g., MTU or MRU)
    """
    return self.__in_maxsize_exceeded
      
  def _set_in_maxsize_exceeded(self, v, load=False):
    """
    Setter method for in_maxsize_exceeded, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_maxsize_exceeded (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_maxsize_exceeded is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_maxsize_exceeded() directly.

    YANG Description: The total number frames received that are well-formed but
dropped due to exceeding the maximum frame size on the interface
(e.g., MTU or MRU)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-maxsize-exceeded", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_maxsize_exceeded must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-maxsize-exceeded", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_maxsize_exceeded = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_maxsize_exceeded(self):
    self.__in_maxsize_exceeded = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-maxsize-exceeded", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_mac_control_frames(self):
    """
    Getter method for out_mac_control_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_mac_control_frames (oc-yang:counter64)

    YANG Description: MAC layer control frames sent on the interface
    """
    return self.__out_mac_control_frames
      
  def _set_out_mac_control_frames(self, v, load=False):
    """
    Setter method for out_mac_control_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_mac_control_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_mac_control_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_mac_control_frames() directly.

    YANG Description: MAC layer control frames sent on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_mac_control_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_mac_control_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_mac_control_frames(self):
    self.__out_mac_control_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-control-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_mac_pause_frames(self):
    """
    Getter method for out_mac_pause_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_mac_pause_frames (oc-yang:counter64)

    YANG Description: MAC layer PAUSE frames sent on the interface
    """
    return self.__out_mac_pause_frames
      
  def _set_out_mac_pause_frames(self, v, load=False):
    """
    Setter method for out_mac_pause_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_mac_pause_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_mac_pause_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_mac_pause_frames() directly.

    YANG Description: MAC layer PAUSE frames sent on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_mac_pause_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_mac_pause_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_mac_pause_frames(self):
    self.__out_mac_pause_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-pause-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_8021q_frames(self):
    """
    Getter method for out_8021q_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_8021q_frames (oc-yang:counter64)

    YANG Description: Number of 802.1q tagged frames sent on the interface
    """
    return self.__out_8021q_frames
      
  def _set_out_8021q_frames(self, v, load=False):
    """
    Setter method for out_8021q_frames, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_8021q_frames (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_8021q_frames is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_8021q_frames() directly.

    YANG Description: Number of 802.1q tagged frames sent on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_8021q_frames must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_8021q_frames = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_8021q_frames(self):
    self.__out_8021q_frames = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-8021q-frames", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_mac_errors_tx(self):
    """
    Getter method for out_mac_errors_tx, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_mac_errors_tx (oc-yang:counter64)

    YANG Description: The number of sent errored frames due to MAC errors
transmitted. The value refers to MIB counter for
dot3StatsInternalMacTransmitErrors
oid=1.3.6.1.2.1.10.7.2.1.10
    """
    return self.__out_mac_errors_tx
      
  def _set_out_mac_errors_tx(self, v, load=False):
    """
    Setter method for out_mac_errors_tx, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_mac_errors_tx (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_mac_errors_tx is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_mac_errors_tx() directly.

    YANG Description: The number of sent errored frames due to MAC errors
transmitted. The value refers to MIB counter for
dot3StatsInternalMacTransmitErrors
oid=1.3.6.1.2.1.10.7.2.1.10
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-errors-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_mac_errors_tx must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-errors-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_mac_errors_tx = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_mac_errors_tx(self):
    self.__out_mac_errors_tx = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-mac-errors-tx", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pcs_bip_errors(self):
    """
    Getter method for in_pcs_bip_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_pcs_bip_errors (oc-yang:counter64)

    YANG Description: The number of received bit interleaved parity (BIP) errors
at the physical coding sublayer (PCS). If the interface
consists of multiple lanes, this will be the sum of all
errors on the lane
    """
    return self.__in_pcs_bip_errors
      
  def _set_in_pcs_bip_errors(self, v, load=False):
    """
    Setter method for in_pcs_bip_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_pcs_bip_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pcs_bip_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pcs_bip_errors() directly.

    YANG Description: The number of received bit interleaved parity (BIP) errors
at the physical coding sublayer (PCS). If the interface
consists of multiple lanes, this will be the sum of all
errors on the lane
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-bip-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pcs_bip_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-bip-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pcs_bip_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pcs_bip_errors(self):
    self.__in_pcs_bip_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-bip-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pcs_errored_seconds(self):
    """
    Getter method for in_pcs_errored_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_pcs_errored_seconds (oc-yang:counter64)

    YANG Description: The number of seconds that physical coding sublayer (PCS)
errors have crossed a sytem defined threshold indicating the
link is erroring
    """
    return self.__in_pcs_errored_seconds
      
  def _set_in_pcs_errored_seconds(self, v, load=False):
    """
    Setter method for in_pcs_errored_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_pcs_errored_seconds (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pcs_errored_seconds is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pcs_errored_seconds() directly.

    YANG Description: The number of seconds that physical coding sublayer (PCS)
errors have crossed a sytem defined threshold indicating the
link is erroring
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pcs_errored_seconds must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pcs_errored_seconds = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pcs_errored_seconds(self):
    self.__in_pcs_errored_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pcs_severely_errored_seconds(self):
    """
    Getter method for in_pcs_severely_errored_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_pcs_severely_errored_seconds (oc-yang:counter64)

    YANG Description: The number of seconds that physical coding sublayer (PCS)
errors have crossed a system defined threshold indicating the
link is severely erroring
    """
    return self.__in_pcs_severely_errored_seconds
      
  def _set_in_pcs_severely_errored_seconds(self, v, load=False):
    """
    Setter method for in_pcs_severely_errored_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_pcs_severely_errored_seconds (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pcs_severely_errored_seconds is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pcs_severely_errored_seconds() directly.

    YANG Description: The number of seconds that physical coding sublayer (PCS)
errors have crossed a system defined threshold indicating the
link is severely erroring
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-severely-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pcs_severely_errored_seconds must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-severely-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pcs_severely_errored_seconds = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pcs_severely_errored_seconds(self):
    self.__in_pcs_severely_errored_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-severely-errored-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_in_pcs_unavailable_seconds(self):
    """
    Getter method for in_pcs_unavailable_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_pcs_unavailable_seconds (oc-yang:counter64)

    YANG Description: The number of seconds that physical coding sublayer (PCS)
errors have crossed a system defined threshold indicating the
link is unavailable
    """
    return self.__in_pcs_unavailable_seconds
      
  def _set_in_pcs_unavailable_seconds(self, v, load=False):
    """
    Setter method for in_pcs_unavailable_seconds, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/in_pcs_unavailable_seconds (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_in_pcs_unavailable_seconds is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_in_pcs_unavailable_seconds() directly.

    YANG Description: The number of seconds that physical coding sublayer (PCS)
errors have crossed a system defined threshold indicating the
link is unavailable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-unavailable-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """in_pcs_unavailable_seconds must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-unavailable-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__in_pcs_unavailable_seconds = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_in_pcs_unavailable_seconds(self):
    self.__in_pcs_unavailable_seconds = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="in-pcs-unavailable-seconds", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_pcs_bip_errors(self):
    """
    Getter method for out_pcs_bip_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_pcs_bip_errors (oc-yang:counter64)

    YANG Description: The number of transmitted bit interleaved parity (BIP) errors
at the physical coding sublayer (PCS). If the interface
consists of multiple lanes, this will be the sum of all
errors on the lane
    """
    return self.__out_pcs_bip_errors
      
  def _set_out_pcs_bip_errors(self, v, load=False):
    """
    Setter method for out_pcs_bip_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_pcs_bip_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_pcs_bip_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_pcs_bip_errors() directly.

    YANG Description: The number of transmitted bit interleaved parity (BIP) errors
at the physical coding sublayer (PCS). If the interface
consists of multiple lanes, this will be the sum of all
errors on the lane
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pcs-bip-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_pcs_bip_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pcs-bip-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_pcs_bip_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_pcs_bip_errors(self):
    self.__out_pcs_bip_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-pcs-bip-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_crc_errors(self):
    """
    Getter method for out_crc_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_crc_errors (oc-yang:counter64)

    YANG Description: Number of FCS/CRC error check failures sent on the interface
    """
    return self.__out_crc_errors
      
  def _set_out_crc_errors(self, v, load=False):
    """
    Setter method for out_crc_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_crc_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_crc_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_crc_errors() directly.

    YANG Description: Number of FCS/CRC error check failures sent on the interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_crc_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_crc_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_crc_errors(self):
    self.__out_crc_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-crc-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_out_block_errors(self):
    """
    Getter method for out_block_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_block_errors (oc-yang:counter64)

    YANG Description: The number of transmitted errored blocks. Error detection
codes are capable of detecting whether one or more errors have
occurred in a given sequence of bits – the block. It is
normally not possible to determine the exact number of errored
bits within the block
    """
    return self.__out_block_errors
      
  def _set_out_block_errors(self, v, load=False):
    """
    Setter method for out_block_errors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/out_block_errors (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_out_block_errors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_out_block_errors() directly.

    YANG Description: The number of transmitted errored blocks. Error detection
codes are capable of detecting whether one or more errors have
occurred in a given sequence of bits – the block. It is
normally not possible to determine the exact number of errored
bits within the block
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """out_block_errors must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__out_block_errors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_out_block_errors(self):
    self.__out_block_errors = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="out-block-errors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-yang:counter64', is_config=False)


  def _get_fec_uncorrectable_blocks(self):
    """
    Getter method for fec_uncorrectable_blocks, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/fec_uncorrectable_blocks (yang:counter64)

    YANG Description: The number of blocks or frames that were uncorrectable by
the FEC
    """
    return self.__fec_uncorrectable_blocks
      
  def _set_fec_uncorrectable_blocks(self, v, load=False):
    """
    Setter method for fec_uncorrectable_blocks, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/fec_uncorrectable_blocks (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fec_uncorrectable_blocks is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fec_uncorrectable_blocks() directly.

    YANG Description: The number of blocks or frames that were uncorrectable by
the FEC
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fec_uncorrectable_blocks must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__fec_uncorrectable_blocks = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fec_uncorrectable_blocks(self):
    self.__fec_uncorrectable_blocks = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="fec-uncorrectable-blocks", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_pre_fec_ber(self):
    """
    Getter method for pre_fec_ber, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber (container)

    YANG Description: Bit error rate before forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
    """
    return self.__pre_fec_ber
      
  def _set_pre_fec_ber(self, v, load=False):
    """
    Setter method for pre_fec_ber, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/pre_fec_ber (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pre_fec_ber is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pre_fec_ber() directly.

    YANG Description: Bit error rate before forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_pre_fec_ber, is_container='container', yang_name="pre-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pre_fec_ber must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_pre_fec_ber, is_container='container', yang_name="pre-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__pre_fec_ber = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pre_fec_ber(self):
    self.__pre_fec_ber = YANGDynClass(base=yc_pre_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_pre_fec_ber, is_container='container', yang_name="pre-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)


  def _get_post_fec_ber(self):
    """
    Getter method for post_fec_ber, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber (container)

    YANG Description: Bit error rate after forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
    """
    return self.__post_fec_ber
      
  def _set_post_fec_ber(self, v, load=False):
    """
    Setter method for post_fec_ber, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/post_fec_ber (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_post_fec_ber is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_post_fec_ber() directly.

    YANG Description: Bit error rate after forward error correction -- computed
value with 18 decimal precision. Note that decimal64
supports values as small as i x 10^-18 where i is an
integer. Values smaller than this should be reported as 0
to inidicate error free or near error free performance.
Values include the instantaneous, average, minimum, and
maximum statistics. If avg/min/max statistics are not
supported, the target is expected to just supply the
instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_post_fec_ber, is_container='container', yang_name="post-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """post_fec_ber must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_post_fec_ber, is_container='container', yang_name="post-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__post_fec_ber = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_post_fec_ber(self):
    self.__post_fec_ber = YANGDynClass(base=yc_post_fec_ber_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_post_fec_ber, is_container='container', yang_name="post-fec-ber", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)


  def _get_q_value(self):
    """
    Getter method for q_value, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value (container)

    YANG Description: Quality value (factor) in dB of a channel with two
decimal precision. Values include the instantaneous,
average, minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
    """
    return self.__q_value
      
  def _set_q_value(self, v, load=False):
    """
    Setter method for q_value, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/q_value (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_q_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_q_value() directly.

    YANG Description: Quality value (factor) in dB of a channel with two
decimal precision. Values include the instantaneous,
average, minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_q_value, is_container='container', yang_name="q-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """q_value must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_q_value, is_container='container', yang_name="q-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__q_value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_q_value(self):
    self.__q_value = YANGDynClass(base=yc_q_value_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_q_value, is_container='container', yang_name="q-value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)


  def _get_esnr(self):
    """
    Getter method for esnr, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr (container)

    YANG Description: Electrical signal to noise ratio. Baud rate
normalized signal to noise ratio based on
error vector magnitude in dB with two decimal
precision. Values include the instantaneous, average,
minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
    """
    return self.__esnr
      
  def _set_esnr(self, v, load=False):
    """
    Setter method for esnr, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state/esnr (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_esnr is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_esnr() directly.

    YANG Description: Electrical signal to noise ratio. Baud rate
normalized signal to noise ratio based on
error vector magnitude in dB with two decimal
precision. Values include the instantaneous, average,
minimum, and maximum statistics. If avg/min/max
statistics are not supported, the target is expected
to just supply the instant value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_esnr, is_container='container', yang_name="esnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """esnr must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_esnr, is_container='container', yang_name="esnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__esnr = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_esnr(self):
    self.__esnr = YANGDynClass(base=yc_esnr_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state_esnr, is_container='container', yang_name="esnr", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

  client_als = __builtin__.property(_get_client_als)
  als_delay = __builtin__.property(_get_als_delay)
  in_mac_control_frames = __builtin__.property(_get_in_mac_control_frames)
  in_mac_pause_frames = __builtin__.property(_get_in_mac_pause_frames)
  in_oversize_frames = __builtin__.property(_get_in_oversize_frames)
  in_undersize_frames = __builtin__.property(_get_in_undersize_frames)
  in_jabber_frames = __builtin__.property(_get_in_jabber_frames)
  in_fragment_frames = __builtin__.property(_get_in_fragment_frames)
  in_8021q_frames = __builtin__.property(_get_in_8021q_frames)
  in_crc_errors = __builtin__.property(_get_in_crc_errors)
  in_block_errors = __builtin__.property(_get_in_block_errors)
  in_carrier_errors = __builtin__.property(_get_in_carrier_errors)
  in_interrupted_tx = __builtin__.property(_get_in_interrupted_tx)
  in_late_collision = __builtin__.property(_get_in_late_collision)
  in_mac_errors_rx = __builtin__.property(_get_in_mac_errors_rx)
  in_single_collision = __builtin__.property(_get_in_single_collision)
  in_symbol_error = __builtin__.property(_get_in_symbol_error)
  in_maxsize_exceeded = __builtin__.property(_get_in_maxsize_exceeded)
  out_mac_control_frames = __builtin__.property(_get_out_mac_control_frames)
  out_mac_pause_frames = __builtin__.property(_get_out_mac_pause_frames)
  out_8021q_frames = __builtin__.property(_get_out_8021q_frames)
  out_mac_errors_tx = __builtin__.property(_get_out_mac_errors_tx)
  in_pcs_bip_errors = __builtin__.property(_get_in_pcs_bip_errors)
  in_pcs_errored_seconds = __builtin__.property(_get_in_pcs_errored_seconds)
  in_pcs_severely_errored_seconds = __builtin__.property(_get_in_pcs_severely_errored_seconds)
  in_pcs_unavailable_seconds = __builtin__.property(_get_in_pcs_unavailable_seconds)
  out_pcs_bip_errors = __builtin__.property(_get_out_pcs_bip_errors)
  out_crc_errors = __builtin__.property(_get_out_crc_errors)
  out_block_errors = __builtin__.property(_get_out_block_errors)
  fec_uncorrectable_blocks = __builtin__.property(_get_fec_uncorrectable_blocks)
  pre_fec_ber = __builtin__.property(_get_pre_fec_ber)
  post_fec_ber = __builtin__.property(_get_post_fec_ber)
  q_value = __builtin__.property(_get_q_value)
  esnr = __builtin__.property(_get_esnr)


  _pyangbind_elements = OrderedDict([('client_als', client_als), ('als_delay', als_delay), ('in_mac_control_frames', in_mac_control_frames), ('in_mac_pause_frames', in_mac_pause_frames), ('in_oversize_frames', in_oversize_frames), ('in_undersize_frames', in_undersize_frames), ('in_jabber_frames', in_jabber_frames), ('in_fragment_frames', in_fragment_frames), ('in_8021q_frames', in_8021q_frames), ('in_crc_errors', in_crc_errors), ('in_block_errors', in_block_errors), ('in_carrier_errors', in_carrier_errors), ('in_interrupted_tx', in_interrupted_tx), ('in_late_collision', in_late_collision), ('in_mac_errors_rx', in_mac_errors_rx), ('in_single_collision', in_single_collision), ('in_symbol_error', in_symbol_error), ('in_maxsize_exceeded', in_maxsize_exceeded), ('out_mac_control_frames', out_mac_control_frames), ('out_mac_pause_frames', out_mac_pause_frames), ('out_8021q_frames', out_8021q_frames), ('out_mac_errors_tx', out_mac_errors_tx), ('in_pcs_bip_errors', in_pcs_bip_errors), ('in_pcs_errored_seconds', in_pcs_errored_seconds), ('in_pcs_severely_errored_seconds', in_pcs_severely_errored_seconds), ('in_pcs_unavailable_seconds', in_pcs_unavailable_seconds), ('out_pcs_bip_errors', out_pcs_bip_errors), ('out_crc_errors', out_crc_errors), ('out_block_errors', out_block_errors), ('fec_uncorrectable_blocks', fec_uncorrectable_blocks), ('pre_fec_ber', pre_fec_ber), ('post_fec_ber', post_fec_ber), ('q_value', q_value), ('esnr', esnr), ])


class yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: LLDP configuration data for logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__snooping',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)
    self.__snooping = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="snooping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'config']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/config/enabled (boolean)

    YANG Description: Enable or disable the LLDP protocol on the logical channel.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Enable or disable the LLDP protocol on the logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)


  def _get_snooping(self):
    """
    Getter method for snooping, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/config/snooping (boolean)

    YANG Description: If true, LLDP PDUs are only received and processed on
the logical-channel, but are not originated by the local
agent. The PDUs are not dropped by the logical channel after
processing, but relayed to the downstream link layer
neighbors. The snooping mode is valid only when LLDP is
enabled on the logical channel. The snooping mode is useful
when a logical channel does not want its link layer neighbors
to discover itself since, for example, it is a lower-layer
logical channel.
    """
    return self.__snooping
      
  def _set_snooping(self, v, load=False):
    """
    Setter method for snooping, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/config/snooping (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_snooping is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_snooping() directly.

    YANG Description: If true, LLDP PDUs are only received and processed on
the logical-channel, but are not originated by the local
agent. The PDUs are not dropped by the logical channel after
processing, but relayed to the downstream link layer
neighbors. The snooping mode is valid only when LLDP is
enabled on the logical channel. The snooping mode is useful
when a logical channel does not want its link layer neighbors
to discover itself since, for example, it is a lower-layer
logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="snooping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """snooping must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="snooping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)""",
        })

    self.__snooping = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_snooping(self):
    self.__snooping = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="snooping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=True)

  enabled = __builtin__.property(_get_enabled, _set_enabled)
  snooping = __builtin__.property(_get_snooping, _set_snooping)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('snooping', snooping), ])


class yc_counters_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: LLDP counters on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__frame_in','__frame_out','__frame_error_in','__frame_discard','__tlv_discard','__tlv_unknown','__last_clear','__frame_error_out',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__frame_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__frame_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__frame_error_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__frame_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__tlv_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__tlv_unknown = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:date-and-time', is_config=False)
    self.__frame_error_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'state', 'counters']

  def _get_frame_in(self):
    """
    Getter method for frame_in, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_in (yang:counter64)

    YANG Description: The number of lldp frames received.
    """
    return self.__frame_in
      
  def _set_frame_in(self, v, load=False):
    """
    Setter method for frame_in, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_in (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_in() directly.

    YANG Description: The number of lldp frames received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_in must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_in(self):
    self.__frame_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_frame_out(self):
    """
    Getter method for frame_out, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_out (yang:counter64)

    YANG Description: The number of frames transmitted out.
    """
    return self.__frame_out
      
  def _set_frame_out(self, v, load=False):
    """
    Setter method for frame_out, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_out (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_out is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_out() directly.

    YANG Description: The number of frames transmitted out.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_out must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_out = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_out(self):
    self.__frame_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_frame_error_in(self):
    """
    Getter method for frame_error_in, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_error_in (yang:counter64)

    YANG Description: The number of LLDP frames received with errors.
    """
    return self.__frame_error_in
      
  def _set_frame_error_in(self, v, load=False):
    """
    Setter method for frame_error_in, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_error_in (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_error_in is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_error_in() directly.

    YANG Description: The number of LLDP frames received with errors.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_error_in must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_error_in = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_error_in(self):
    self.__frame_error_in = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-in", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_frame_discard(self):
    """
    Getter method for frame_discard, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_discard (yang:counter64)

    YANG Description: The number of LLDP frames received and discarded.
    """
    return self.__frame_discard
      
  def _set_frame_discard(self, v, load=False):
    """
    Setter method for frame_discard, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_discard (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_discard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_discard() directly.

    YANG Description: The number of LLDP frames received and discarded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_discard must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_discard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_discard(self):
    self.__frame_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_tlv_discard(self):
    """
    Getter method for tlv_discard, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/tlv_discard (yang:counter64)

    YANG Description: The number of TLV frames received and discarded.
    """
    return self.__tlv_discard
      
  def _set_tlv_discard(self, v, load=False):
    """
    Setter method for tlv_discard, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/tlv_discard (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv_discard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv_discard() directly.

    YANG Description: The number of TLV frames received and discarded.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv_discard must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__tlv_discard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv_discard(self):
    self.__tlv_discard = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-discard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_tlv_unknown(self):
    """
    Getter method for tlv_unknown, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/tlv_unknown (yang:counter64)

    YANG Description: The number of frames received with unknown TLV.
    """
    return self.__tlv_unknown
      
  def _set_tlv_unknown(self, v, load=False):
    """
    Setter method for tlv_unknown, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/tlv_unknown (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv_unknown is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv_unknown() directly.

    YANG Description: The number of frames received with unknown TLV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv_unknown must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__tlv_unknown = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv_unknown(self):
    self.__tlv_unknown = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="tlv-unknown", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)


  def _get_last_clear(self):
    """
    Getter method for last_clear, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/last_clear (yang:date-and-time)

    YANG Description: Indicates the last time the counters were
cleared.
    """
    return self.__last_clear
      
  def _set_last_clear(self, v, load=False):
    """
    Setter method for last_clear, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/last_clear (yang:date-and-time)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_clear is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_clear() directly.

    YANG Description: Indicates the last time the counters were
cleared.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:date-and-time', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_clear must be of a type compatible with yang:date-and-time""",
          'defined-type': "yang:date-and-time",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:date-and-time', is_config=False)""",
        })

    self.__last_clear = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_clear(self):
    self.__last_clear = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}(\\.\\d+)?(Z|[\\+\\-]\\d{2}:\\d{2})'}), is_leaf=True, yang_name="last-clear", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:date-and-time', is_config=False)


  def _get_frame_error_out(self):
    """
    Getter method for frame_error_out, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_error_out (yang:counter64)

    YANG Description: The number of frame transmit errors on the
interface.
    """
    return self.__frame_error_out
      
  def _set_frame_error_out(self, v, load=False):
    """
    Setter method for frame_error_out, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters/frame_error_out (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_frame_error_out is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_frame_error_out() directly.

    YANG Description: The number of frame transmit errors on the
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """frame_error_out must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)""",
        })

    self.__frame_error_out = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_frame_error_out(self):
    self.__frame_error_out = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="frame-error-out", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='yang:counter64', is_config=False)

  frame_in = __builtin__.property(_get_frame_in)
  frame_out = __builtin__.property(_get_frame_out)
  frame_error_in = __builtin__.property(_get_frame_error_in)
  frame_discard = __builtin__.property(_get_frame_discard)
  tlv_discard = __builtin__.property(_get_tlv_discard)
  tlv_unknown = __builtin__.property(_get_tlv_unknown)
  last_clear = __builtin__.property(_get_last_clear)
  frame_error_out = __builtin__.property(_get_frame_error_out)


  _pyangbind_elements = OrderedDict([('frame_in', frame_in), ('frame_out', frame_out), ('frame_error_in', frame_error_in), ('frame_discard', frame_discard), ('tlv_discard', tlv_discard), ('tlv_unknown', tlv_unknown), ('last_clear', last_clear), ('frame_error_out', frame_error_out), ])


class yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: LLDP operational state data for logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled','__snooping','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)
    self.__snooping = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="snooping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'state']

  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/enabled (boolean)

    YANG Description: Enable or disable the LLDP protocol on the logical channel.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: Enable or disable the LLDP protocol on the logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)


  def _get_snooping(self):
    """
    Getter method for snooping, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/snooping (boolean)

    YANG Description: If true, LLDP PDUs are only received and processed on
the logical-channel, but are not originated by the local
agent. The PDUs are not dropped by the logical channel after
processing, but relayed to the downstream link layer
neighbors. The snooping mode is valid only when LLDP is
enabled on the logical channel. The snooping mode is useful
when a logical channel does not want its link layer neighbors
to discover itself since, for example, it is a lower-layer
logical channel.
    """
    return self.__snooping
      
  def _set_snooping(self, v, load=False):
    """
    Setter method for snooping, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/snooping (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_snooping is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_snooping() directly.

    YANG Description: If true, LLDP PDUs are only received and processed on
the logical-channel, but are not originated by the local
agent. The PDUs are not dropped by the logical channel after
processing, but relayed to the downstream link layer
neighbors. The snooping mode is valid only when LLDP is
enabled on the logical channel. The snooping mode is useful
when a logical channel does not want its link layer neighbors
to discover itself since, for example, it is a lower-layer
logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="snooping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """snooping must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="snooping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)""",
        })

    self.__snooping = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_snooping(self):
    self.__snooping = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="snooping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='boolean', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters (container)

    YANG Description: LLDP counters on each interface
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: LLDP counters on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

  enabled = __builtin__.property(_get_enabled)
  snooping = __builtin__.property(_get_snooping)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('enabled', enabled), ('snooping', snooping), ('counters', counters), ])


class yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__system_name','__system_description','__chassis_id','__chassis_id_type','__id','__age','__last_update','__ttl','__port_id','__port_id_type','__port_description','__management_address','__management_address_type',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__system_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__system_description = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__chassis_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__chassis_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-lldp-types:chassis-id-type', is_config=False)
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__age = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint64', is_config=False)
    self.__last_update = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="last-update", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int64', is_config=False)
    self.__ttl = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ttl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint16', is_config=False)
    self.__port_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__port_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'AGENT_CIRCUIT_ID': {}, 'LOCAL': {}},), is_leaf=True, yang_name="port-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-lldp-types:port-id-type', is_config=False)
    self.__port_description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__management_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__management_address_type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'neighbors', 'neighbor', 'state']

  def _get_system_name(self):
    """
    Getter method for system_name, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/system_name (string)

    YANG Description: The system name field shall contain an alpha-numeric string
that indicates the system's administratively assigned name.
The system name should be the system's fully qualified domain
name. If implementations support IETF RFC 3418, the sysName
object should be used for this field.
    """
    return self.__system_name
      
  def _set_system_name(self, v, load=False):
    """
    Setter method for system_name, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/system_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_name() directly.

    YANG Description: The system name field shall contain an alpha-numeric string
that indicates the system's administratively assigned name.
The system name should be the system's fully qualified domain
name. If implementations support IETF RFC 3418, the sysName
object should be used for this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__system_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_name(self):
    self.__system_name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_system_description(self):
    """
    Getter method for system_description, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/system_description (string)

    YANG Description: The system description field shall contain an alpha-numeric
string that is the textual description of the network entity.
The system description should include the full name and
version identification of the system's hardware type,
software operating system, and networking software. If
implementations support IETF RFC 3418, the sysDescr object
should be used for this field.
    """
    return self.__system_description
      
  def _set_system_description(self, v, load=False):
    """
    Setter method for system_description, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/system_description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_system_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_system_description() directly.

    YANG Description: The system description field shall contain an alpha-numeric
string that is the textual description of the network entity.
The system description should include the full name and
version identification of the system's hardware type,
software operating system, and networking software. If
implementations support IETF RFC 3418, the sysDescr object
should be used for this field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """system_description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__system_description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_system_description(self):
    self.__system_description = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['0..255']}), is_leaf=True, yang_name="system-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_chassis_id(self):
    """
    Getter method for chassis_id, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/chassis_id (string)

    YANG Description: The Chassis ID is a mandatory TLV which identifies the
chassis component of the endpoint identifier associated with
the transmitting LLDP agent
    """
    return self.__chassis_id
      
  def _set_chassis_id(self, v, load=False):
    """
    Setter method for chassis_id, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/chassis_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis_id() directly.

    YANG Description: The Chassis ID is a mandatory TLV which identifies the
chassis component of the endpoint identifier associated with
the transmitting LLDP agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__chassis_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis_id(self):
    self.__chassis_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="chassis-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_chassis_id_type(self):
    """
    Getter method for chassis_id_type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/chassis_id_type (oc-lldp-types:chassis-id-type)

    YANG Description: This field identifies the format and source of the chassis
identifier string. It is an enumerator defined by the
LldpChassisIdSubtype object from IEEE 802.1AB MIB.
    """
    return self.__chassis_id_type
      
  def _set_chassis_id_type(self, v, load=False):
    """
    Setter method for chassis_id_type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/chassis_id_type (oc-lldp-types:chassis-id-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_chassis_id_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_chassis_id_type() directly.

    YANG Description: This field identifies the format and source of the chassis
identifier string. It is an enumerator defined by the
LldpChassisIdSubtype object from IEEE 802.1AB MIB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-lldp-types:chassis-id-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """chassis_id_type must be of a type compatible with oc-lldp-types:chassis-id-type""",
          'defined-type': "oc-lldp-types:chassis-id-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-lldp-types:chassis-id-type', is_config=False)""",
        })

    self.__chassis_id_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_chassis_id_type(self):
    self.__chassis_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'CHASSIS_COMPONENT': {}, 'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'LOCAL': {}},), is_leaf=True, yang_name="chassis-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-lldp-types:chassis-id-type', is_config=False)


  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/id (string)

    YANG Description: System generated identifier for the neighbor on the
interface.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: System generated identifier for the neighbor on the
interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_age(self):
    """
    Getter method for age, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/age (uint64)

    YANG Description: Age since discovery
    """
    return self.__age
      
  def _set_age(self, v, load=False):
    """
    Setter method for age, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/age (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_age() directly.

    YANG Description: Age since discovery
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """age must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint64', is_config=False)""",
        })

    self.__age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_age(self):
    self.__age = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint64', is_config=False)


  def _get_last_update(self):
    """
    Getter method for last_update, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/last_update (int64)

    YANG Description: Seconds since last update received.
    """
    return self.__last_update
      
  def _set_last_update(self, v, load=False):
    """
    Setter method for last_update, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/last_update (int64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_update is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_update() directly.

    YANG Description: Seconds since last update received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="last-update", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_update must be of a type compatible with int64""",
          'defined-type': "int64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="last-update", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int64', is_config=False)""",
        })

    self.__last_update = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_update(self):
    self.__last_update = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-9223372036854775808..9223372036854775807']}, int_size=64), is_leaf=True, yang_name="last-update", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int64', is_config=False)


  def _get_ttl(self):
    """
    Getter method for ttl, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/ttl (uint16)

    YANG Description: The time-to-live (TTL) is a mandatory TLV which indicates
how long information from the neighbor should be considered
valid.
    """
    return self.__ttl
      
  def _set_ttl(self, v, load=False):
    """
    Setter method for ttl, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/ttl (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ttl is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ttl() directly.

    YANG Description: The time-to-live (TTL) is a mandatory TLV which indicates
how long information from the neighbor should be considered
valid.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ttl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ttl must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ttl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint16', is_config=False)""",
        })

    self.__ttl = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ttl(self):
    self.__ttl = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ttl", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint16', is_config=False)


  def _get_port_id(self):
    """
    Getter method for port_id, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/port_id (string)

    YANG Description: The Port ID is a mandatory TLV which identifies the port
component of the endpoint identifier associated with the
transmitting LLDP agent. If the specified port is an IEEE
802.3 Repeater port, then this TLV is optional.
    """
    return self.__port_id
      
  def _set_port_id(self, v, load=False):
    """
    Setter method for port_id, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/port_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_id() directly.

    YANG Description: The Port ID is a mandatory TLV which identifies the port
component of the endpoint identifier associated with the
transmitting LLDP agent. If the specified port is an IEEE
802.3 Repeater port, then this TLV is optional.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="port-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__port_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_id(self):
    self.__port_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_port_id_type(self):
    """
    Getter method for port_id_type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/port_id_type (oc-lldp-types:port-id-type)

    YANG Description: This field identifies the format and source of the port
identifier string. It is an enumerator defined by the
PtopoPortIdType object from RFC2922.
    """
    return self.__port_id_type
      
  def _set_port_id_type(self, v, load=False):
    """
    Setter method for port_id_type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/port_id_type (oc-lldp-types:port-id-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_id_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_id_type() directly.

    YANG Description: This field identifies the format and source of the port
identifier string. It is an enumerator defined by the
PtopoPortIdType object from RFC2922.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'AGENT_CIRCUIT_ID': {}, 'LOCAL': {}},), is_leaf=True, yang_name="port-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-lldp-types:port-id-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_id_type must be of a type compatible with oc-lldp-types:port-id-type""",
          'defined-type': "oc-lldp-types:port-id-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'AGENT_CIRCUIT_ID': {}, 'LOCAL': {}},), is_leaf=True, yang_name="port-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-lldp-types:port-id-type', is_config=False)""",
        })

    self.__port_id_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_id_type(self):
    self.__port_id_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'INTERFACE_ALIAS': {}, 'PORT_COMPONENT': {}, 'MAC_ADDRESS': {}, 'NETWORK_ADDRESS': {}, 'INTERFACE_NAME': {}, 'AGENT_CIRCUIT_ID': {}, 'LOCAL': {}},), is_leaf=True, yang_name="port-id-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-lldp-types:port-id-type', is_config=False)


  def _get_port_description(self):
    """
    Getter method for port_description, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/port_description (string)

    YANG Description: The binary string containing the actual port identifier for
the port which this LLDP PDU was transmitted. The source and
format of this field is defined by PtopoPortId from
RFC2922.
    """
    return self.__port_description
      
  def _set_port_description(self, v, load=False):
    """
    Setter method for port_description, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/port_description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_description() directly.

    YANG Description: The binary string containing the actual port identifier for
the port which this LLDP PDU was transmitted. The source and
format of this field is defined by PtopoPortId from
RFC2922.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="port-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__port_description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_description(self):
    self.__port_description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="port-description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_management_address(self):
    """
    Getter method for management_address, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/management_address (string)

    YANG Description: The Management Address is a mandatory TLV which identifies a
network address associated with the local LLDP agent, which
can be used to reach the agent on the port identified in the
Port ID TLV.
    """
    return self.__management_address
      
  def _set_management_address(self, v, load=False):
    """
    Setter method for management_address, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/management_address (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_management_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_management_address() directly.

    YANG Description: The Management Address is a mandatory TLV which identifies a
network address associated with the local LLDP agent, which
can be used to reach the agent on the port identified in the
Port ID TLV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="management-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """management_address must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__management_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_management_address(self):
    self.__management_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_management_address_type(self):
    """
    Getter method for management_address_type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/management_address_type (string)

    YANG Description: The enumerated value for the network address type
identified in this TLV. This enumeration is defined in the
'Assigned Numbers' RFC [RFC3232] and the
ianaAddressFamilyNumbers object.
    """
    return self.__management_address_type
      
  def _set_management_address_type(self, v, load=False):
    """
    Setter method for management_address_type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state/management_address_type (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_management_address_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_management_address_type() directly.

    YANG Description: The enumerated value for the network address type
identified in this TLV. This enumeration is defined in the
'Assigned Numbers' RFC [RFC3232] and the
ianaAddressFamilyNumbers object.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="management-address-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """management_address_type must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__management_address_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_management_address_type(self):
    self.__management_address_type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="management-address-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)

  system_name = __builtin__.property(_get_system_name)
  system_description = __builtin__.property(_get_system_description)
  chassis_id = __builtin__.property(_get_chassis_id)
  chassis_id_type = __builtin__.property(_get_chassis_id_type)
  id = __builtin__.property(_get_id)
  age = __builtin__.property(_get_age)
  last_update = __builtin__.property(_get_last_update)
  ttl = __builtin__.property(_get_ttl)
  port_id = __builtin__.property(_get_port_id)
  port_id_type = __builtin__.property(_get_port_id_type)
  port_description = __builtin__.property(_get_port_description)
  management_address = __builtin__.property(_get_management_address)
  management_address_type = __builtin__.property(_get_management_address_type)


  _pyangbind_elements = OrderedDict([('system_name', system_name), ('system_description', system_description), ('chassis_id', chassis_id), ('chassis_id_type', chassis_id_type), ('id', id), ('age', age), ('last_update', last_update), ('ttl', ttl), ('port_id', port_id), ('port_id_type', port_id_type), ('port_description', port_description), ('management_address', management_address), ('management_address_type', management_address_type), ])


class yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/custom-tlvs/tlv/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__oui','__oui_subtype','__value',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=False)
    self.__oui = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__oui_subtype = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__value = YANGDynClass(base=bitarray, is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='binary', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'neighbors', 'neighbor', 'custom-tlvs', 'tlv', 'state']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state/type (int32)

    YANG Description: The integer value identifying the type of information
contained in the value field.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state/type (int32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The integer value identifying the type of information
contained in the value field.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with int32""",
          'defined-type': "int32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=False)


  def _get_oui(self):
    """
    Getter method for oui, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state/oui (string)

    YANG Description: The organizationally unique identifier field shall contain
the organization's OUI as defined in Clause 9 of IEEE Std
802. The high-order octet is 0 and the low-order 3 octets
are the SMI Network Management Private Enterprise Code of
the Vendor in network byte order, as defined in the
'Assigned Numbers' RFC [RFC3232].
    """
    return self.__oui
      
  def _set_oui(self, v, load=False):
    """
    Setter method for oui, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state/oui (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oui is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oui() directly.

    YANG Description: The organizationally unique identifier field shall contain
the organization's OUI as defined in Clause 9 of IEEE Std
802. The high-order octet is 0 and the low-order 3 octets
are the SMI Network Management Private Enterprise Code of
the Vendor in network byte order, as defined in the
'Assigned Numbers' RFC [RFC3232].
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oui must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__oui = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oui(self):
    self.__oui = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_oui_subtype(self):
    """
    Getter method for oui_subtype, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state/oui_subtype (string)

    YANG Description: The organizationally defined subtype field shall contain a
unique subtype value assigned by the defining organization.
    """
    return self.__oui_subtype
      
  def _set_oui_subtype(self, v, load=False):
    """
    Setter method for oui_subtype, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state/oui_subtype (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oui_subtype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oui_subtype() directly.

    YANG Description: The organizationally defined subtype field shall contain a
unique subtype value assigned by the defining organization.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oui_subtype must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__oui_subtype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oui_subtype(self):
    self.__oui_subtype = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_value(self):
    """
    Getter method for value, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state/value (binary)

    YANG Description: A variable-length octet-string containing the
instance-specific information for this TLV.
    """
    return self.__value
      
  def _set_value(self, v, load=False):
    """
    Setter method for value, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state/value (binary)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_value is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_value() directly.

    YANG Description: A variable-length octet-string containing the
instance-specific information for this TLV.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=bitarray, is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='binary', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """value must be of a type compatible with binary""",
          'defined-type': "binary",
          'generated-type': """YANGDynClass(base=bitarray, is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='binary', is_config=False)""",
        })

    self.__value = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_value(self):
    self.__value = YANGDynClass(base=bitarray, is_leaf=True, yang_name="value", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='binary', is_config=False)

  type = __builtin__.property(_get_type)
  oui = __builtin__.property(_get_oui)
  oui_subtype = __builtin__.property(_get_oui_subtype)
  value = __builtin__.property(_get_value)


  _pyangbind_elements = OrderedDict([('type', type), ('oui', oui), ('oui_subtype', oui_subtype), ('value', value), ])


class yc_tlv_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/custom-tlvs/tlv. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of custom LLDP TLVs from a neighbor
  """
  __slots__ = ('_path_helper', '_extmethods', '__type','__oui','__oui_subtype','__state',)

  _yang_name = 'tlv'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__oui = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__oui_subtype = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'neighbors', 'neighbor', 'custom-tlvs', 'tlv']

  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/type (leafref)

    YANG Description: Reference to type list key
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/type (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: Reference to type list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_oui(self):
    """
    Getter method for oui, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/oui (leafref)

    YANG Description: Reference to oui list key
    """
    return self.__oui
      
  def _set_oui(self, v, load=False):
    """
    Setter method for oui, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/oui (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oui is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oui() directly.

    YANG Description: Reference to oui list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oui must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__oui = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oui(self):
    self.__oui = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_oui_subtype(self):
    """
    Getter method for oui_subtype, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/oui_subtype (leafref)

    YANG Description: Reference to oui-subtype list key
    """
    return self.__oui_subtype
      
  def _set_oui_subtype(self, v, load=False):
    """
    Setter method for oui_subtype, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/oui_subtype (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_oui_subtype is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_oui_subtype() directly.

    YANG Description: Reference to oui-subtype list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """oui_subtype must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__oui_subtype = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_oui_subtype(self):
    self.__oui_subtype = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="oui-subtype", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

  type = __builtin__.property(_get_type)
  oui = __builtin__.property(_get_oui)
  oui_subtype = __builtin__.property(_get_oui_subtype)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('type', type), ('oui', oui), ('oui_subtype', oui_subtype), ('state', state), ])


class yc_custom_tlvs_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor/custom-tlvs. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of custom TLVs from a
neighbor
  """
  __slots__ = ('_path_helper', '_extmethods', '__tlv',)

  _yang_name = 'custom-tlvs'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tlv = YANGDynClass(base=YANGListType("type oui oui_subtype",yc_tlv_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv, yang_name="tlv", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type oui oui-subtype', extensions=None), is_container='list', yang_name="tlv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'neighbors', 'neighbor', 'custom-tlvs']

  def _get_tlv(self):
    """
    Getter method for tlv, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv (list)

    YANG Description: List of custom LLDP TLVs from a neighbor
    """
    return self.__tlv
      
  def _set_tlv(self, v, load=False):
    """
    Setter method for tlv, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs/tlv (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tlv is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tlv() directly.

    YANG Description: List of custom LLDP TLVs from a neighbor
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("type oui oui_subtype",yc_tlv_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv, yang_name="tlv", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type oui oui-subtype', extensions=None), is_container='list', yang_name="tlv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tlv must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("type oui oui_subtype",yc_tlv_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv, yang_name="tlv", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type oui oui-subtype', extensions=None), is_container='list', yang_name="tlv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=False)""",
        })

    self.__tlv = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tlv(self):
    self.__tlv = YANGDynClass(base=YANGListType("type oui oui_subtype",yc_tlv_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs_tlv, yang_name="tlv", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='type oui oui-subtype', extensions=None), is_container='list', yang_name="tlv", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=False)

  tlv = __builtin__.property(_get_tlv)


  _pyangbind_elements = OrderedDict([('tlv', tlv), ])


class yc_neighbor_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/neighbors/neighbor. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of LLDP neighbors. If the implementation only
supports one neighbor, this would always be a list with
one item. If the device and neighbor supported multiple
neighbors, which can be achieved via LLDP forwarding, then
this would be supported
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__state','__custom_tlvs',)

  _yang_name = 'neighbor'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    self.__custom_tlvs = YANGDynClass(base=yc_custom_tlvs_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs, is_container='container', yang_name="custom-tlvs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'neighbors', 'neighbor']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/id (leafref)

    YANG Description: System generated identifier for the neighbor on
the logical channel.
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: System generated identifier for the neighbor on
the logical channel.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)


  def _get_custom_tlvs(self):
    """
    Getter method for custom_tlvs, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs (container)

    YANG Description: Enclosing container for list of custom TLVs from a
neighbor
    """
    return self.__custom_tlvs
      
  def _set_custom_tlvs(self, v, load=False):
    """
    Setter method for custom_tlvs, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor/custom_tlvs (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_custom_tlvs is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_custom_tlvs() directly.

    YANG Description: Enclosing container for list of custom TLVs from a
neighbor
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_custom_tlvs_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs, is_container='container', yang_name="custom-tlvs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """custom_tlvs must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_custom_tlvs_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs, is_container='container', yang_name="custom-tlvs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__custom_tlvs = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_custom_tlvs(self):
    self.__custom_tlvs = YANGDynClass(base=yc_custom_tlvs_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor_custom_tlvs, is_container='container', yang_name="custom-tlvs", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  state = __builtin__.property(_get_state)
  custom_tlvs = __builtin__.property(_get_custom_tlvs)


  _pyangbind_elements = OrderedDict([('id', id), ('state', state), ('custom_tlvs', custom_tlvs), ])


class yc_neighbors_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp/neighbors. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of LLDP neighbors on
a logical channel
  """
  __slots__ = ('_path_helper', '_extmethods', '__neighbor',)

  _yang_name = 'neighbors'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__neighbor = YANGDynClass(base=YANGListType("id",yc_neighbor_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp', 'neighbors']

  def _get_neighbor(self):
    """
    Getter method for neighbor, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor (list)

    YANG Description: List of LLDP neighbors. If the implementation only
supports one neighbor, this would always be a list with
one item. If the device and neighbor supported multiple
neighbors, which can be achieved via LLDP forwarding, then
this would be supported
    """
    return self.__neighbor
      
  def _set_neighbor(self, v, load=False):
    """
    Setter method for neighbor, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors/neighbor (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_neighbor is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_neighbor() directly.

    YANG Description: List of LLDP neighbors. If the implementation only
supports one neighbor, this would always be a list with
one item. If the device and neighbor supported multiple
neighbors, which can be achieved via LLDP forwarding, then
this would be supported
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_neighbor_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """neighbor must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_neighbor_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=False)""",
        })

    self.__neighbor = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_neighbor(self):
    self.__neighbor = YANGDynClass(base=YANGListType("id",yc_neighbor_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors_neighbor, yang_name="neighbor", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="neighbor", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=False)

  neighbor = __builtin__.property(_get_neighbor)


  _pyangbind_elements = OrderedDict([('neighbor', neighbor), ])


class yc_lldp_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet/lldp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: LLDP data for logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__neighbors',)

  _yang_name = 'lldp'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__neighbors = YANGDynClass(base=yc_neighbors_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet', 'lldp']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/config (container)

    YANG Description: LLDP configuration data for logical channels
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: LLDP configuration data for logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state (container)

    YANG Description: LLDP operational state data for logical channels
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: LLDP operational state data for logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_neighbors(self):
    """
    Getter method for neighbors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors (container)

    YANG Description: Enclosing container for list of LLDP neighbors on
a logical channel
    """
    return self.__neighbors
      
  def _set_neighbors(self, v, load=False):
    """
    Setter method for neighbors, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp/neighbors (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_neighbors is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_neighbors() directly.

    YANG Description: Enclosing container for list of LLDP neighbors on
a logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_neighbors_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """neighbors must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_neighbors_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__neighbors = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_neighbors(self):
    self.__neighbors = YANGDynClass(base=yc_neighbors_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp_neighbors, is_container='container', yang_name="neighbors", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  neighbors = __builtin__.property(_get_neighbors, _set_neighbors)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('neighbors', neighbors), ])


class yc_ethernet_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ethernet. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for data related to Ethernet framing
for the logical channel
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__lldp',)

  _yang_name = 'ethernet'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__lldp = YANGDynClass(base=yc_lldp_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp, is_container='container', yang_name="lldp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ethernet']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/config (container)

    YANG Description: Configuration data for Ethernet protocol framing on
logical channels
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for Ethernet protocol framing on
logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state (container)

    YANG Description: Operational state data for Ethernet protocol framing
on logical channels
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for Ethernet protocol framing
on logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_lldp(self):
    """
    Getter method for lldp, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp (container)

    YANG Description: LLDP data for logical channels
    """
    return self.__lldp
      
  def _set_lldp(self, v, load=False):
    """
    Setter method for lldp, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet/lldp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_lldp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_lldp() directly.

    YANG Description: LLDP data for logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_lldp_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp, is_container='container', yang_name="lldp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """lldp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_lldp_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp, is_container='container', yang_name="lldp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__lldp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_lldp(self):
    self.__lldp = YANGDynClass(base=yc_lldp_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet_lldp, is_container='container', yang_name="lldp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  lldp = __builtin__.property(_get_lldp, _set_lldp)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('lldp', lldp), ])


class yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ingress/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the signal source for the
logical channel
  """
  __slots__ = ('_path_helper', '_extmethods', '__transceiver','__physical_channel','__interface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__transceiver = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="transceiver", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    self.__physical_channel = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="physical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-if:base-interface-ref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ingress', 'config']

  def _get_transceiver(self):
    """
    Getter method for transceiver, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/config/transceiver (leafref)

    YANG Description: Reference to the transceiver carrying the input signal
for the logical channel.  If specific physical channels
are mapped to the logical channel (as opposed to all
physical channels carried by the transceiver), they can be
specified in the list of physical channel references.
    """
    return self.__transceiver
      
  def _set_transceiver(self, v, load=False):
    """
    Setter method for transceiver, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/config/transceiver (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transceiver is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transceiver() directly.

    YANG Description: Reference to the transceiver carrying the input signal
for the logical channel.  If specific physical channels
are mapped to the logical channel (as opposed to all
physical channels carried by the transceiver), they can be
specified in the list of physical channel references.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="transceiver", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transceiver must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="transceiver", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)""",
        })

    self.__transceiver = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transceiver(self):
    self.__transceiver = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="transceiver", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)


  def _get_physical_channel(self):
    """
    Getter method for physical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/config/physical_channel (leafref)

    YANG Description: This list should be populated with references
to the client physical channels that feed this logical
channel from the transceiver specified in the 'transceiver'
leaf, which must be specified.  If this leaf-list is empty,
all physical channels in the transceiver are assumed to be
mapped to the logical channel.
    """
    return self.__physical_channel
      
  def _set_physical_channel(self, v, load=False):
    """
    Setter method for physical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/config/physical_channel (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_physical_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_physical_channel() directly.

    YANG Description: This list should be populated with references
to the client physical channels that feed this logical
channel from the transceiver specified in the 'transceiver'
leaf, which must be specified.  If this leaf-list is empty,
all physical channels in the transceiver are assumed to be
mapped to the logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="physical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """physical_channel must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="physical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)""",
        })

    self.__physical_channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_physical_channel(self):
    self.__physical_channel = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="physical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)


  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/config/interface (oc-if:base-interface-ref)

    YANG Description: Reference to the interface carrying the input signal
for the logical channel. The ingress will specify an interface
in the case of a transceiver being utilized directly in a
router and bypassing a dedicated terminal device. When
specified, the other leaves in the ingress config must be
empty.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/config/interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to the interface carrying the input signal
for the logical channel. The ingress will specify an interface
in the case of a transceiver being utilized directly in a
router and bypassing a dedicated terminal device. When
specified, the other leaves in the ingress config must be
empty.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-if:base-interface-ref', is_config=True)

  transceiver = __builtin__.property(_get_transceiver, _set_transceiver)
  physical_channel = __builtin__.property(_get_physical_channel, _set_physical_channel)
  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('transceiver', transceiver), ('physical_channel', physical_channel), ('interface', interface), ])


class yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ingress/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the signal source for the
logical channel
  """
  __slots__ = ('_path_helper', '_extmethods', '__transceiver','__physical_channel','__interface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__transceiver = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="transceiver", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__physical_channel = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="physical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-if:base-interface-ref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ingress', 'state']

  def _get_transceiver(self):
    """
    Getter method for transceiver, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/state/transceiver (leafref)

    YANG Description: Reference to the transceiver carrying the input signal
for the logical channel.  If specific physical channels
are mapped to the logical channel (as opposed to all
physical channels carried by the transceiver), they can be
specified in the list of physical channel references.
    """
    return self.__transceiver
      
  def _set_transceiver(self, v, load=False):
    """
    Setter method for transceiver, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/state/transceiver (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_transceiver is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_transceiver() directly.

    YANG Description: Reference to the transceiver carrying the input signal
for the logical channel.  If specific physical channels
are mapped to the logical channel (as opposed to all
physical channels carried by the transceiver), they can be
specified in the list of physical channel references.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="transceiver", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """transceiver must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="transceiver", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__transceiver = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_transceiver(self):
    self.__transceiver = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="transceiver", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_physical_channel(self):
    """
    Getter method for physical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/state/physical_channel (leafref)

    YANG Description: This list should be populated with references
to the client physical channels that feed this logical
channel from the transceiver specified in the 'transceiver'
leaf, which must be specified.  If this leaf-list is empty,
all physical channels in the transceiver are assumed to be
mapped to the logical channel.
    """
    return self.__physical_channel
      
  def _set_physical_channel(self, v, load=False):
    """
    Setter method for physical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/state/physical_channel (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_physical_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_physical_channel() directly.

    YANG Description: This list should be populated with references
to the client physical channels that feed this logical
channel from the transceiver specified in the 'transceiver'
leaf, which must be specified.  If this leaf-list is empty,
all physical channels in the transceiver are assumed to be
mapped to the logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="physical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """physical_channel must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="physical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__physical_channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_physical_channel(self):
    self.__physical_channel = YANGDynClass(unique=True, base=TypedListType(allowed_type=six.text_type), is_leaf=False, yang_name="physical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/state/interface (oc-if:base-interface-ref)

    YANG Description: Reference to the interface carrying the input signal
for the logical channel. The ingress will specify an interface
in the case of a transceiver being utilized directly in a
router and bypassing a dedicated terminal device. When
specified, the other leaves in the ingress config must be
empty.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/state/interface (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to the interface carrying the input signal
for the logical channel. The ingress will specify an interface
in the case of a transceiver being utilized directly in a
router and bypassing a dedicated terminal device. When
specified, the other leaves in the ingress config must be
empty.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='oc-if:base-interface-ref', is_config=False)

  transceiver = __builtin__.property(_get_transceiver)
  physical_channel = __builtin__.property(_get_physical_channel)
  interface = __builtin__.property(_get_interface)


  _pyangbind_elements = OrderedDict([('transceiver', transceiver), ('physical_channel', physical_channel), ('interface', interface), ])


class yc_ingress_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/ingress. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for specifying references to the
source of signal for the logical channel, either a
transceiver, individual physical channels, or an interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'ingress'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'ingress']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/config (container)

    YANG Description: Configuration data for the signal source for the
logical channel
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the signal source for the
logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/state (container)

    YANG Description: Operational state data for the signal source for the
logical channel
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/ingress/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the signal source for the
logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/logical-channel-assignments/assignment/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for tributary assignments
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__assignment_type','__logical_channel','__optical_channel','__allocation','__tributary_slot_index','__mapping',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    self.__assignment_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOGICAL_CHANNEL': {}, 'OPTICAL_CHANNEL': {}},), is_leaf=True, yang_name="assignment-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=True)
    self.__logical_channel = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    self.__optical_channel = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="optical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    self.__allocation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=3), is_leaf=True, yang_name="allocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=True)
    self.__tributary_slot_index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="tributary-slot-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=True)
    self.__mapping = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="mapping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'logical-channel-assignments', 'assignment', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/index (uint32)

    YANG Description: Index of the current logical client channel to tributary
mapping
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Index of the current logical client channel to tributary
mapping
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/description (string)

    YANG Description: Name assigned to the logical client channel
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Name assigned to the logical client channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=True)


  def _get_assignment_type(self):
    """
    Getter method for assignment_type, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/assignment_type (enumeration)

    YANG Description: Each logical channel element may be assigned to subsequent
stages of logical elements to implement further grooming, or
can be assigned to a line-side optical channel for
transmission.  Each assignment also has an associated
bandwidth allocation.
    """
    return self.__assignment_type
      
  def _set_assignment_type(self, v, load=False):
    """
    Setter method for assignment_type, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/assignment_type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_assignment_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_assignment_type() directly.

    YANG Description: Each logical channel element may be assigned to subsequent
stages of logical elements to implement further grooming, or
can be assigned to a line-side optical channel for
transmission.  Each assignment also has an associated
bandwidth allocation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOGICAL_CHANNEL': {}, 'OPTICAL_CHANNEL': {}},), is_leaf=True, yang_name="assignment-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """assignment_type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-terminal-device:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOGICAL_CHANNEL': {}, 'OPTICAL_CHANNEL': {}},), is_leaf=True, yang_name="assignment-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=True)""",
        })

    self.__assignment_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_assignment_type(self):
    self.__assignment_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOGICAL_CHANNEL': {}, 'OPTICAL_CHANNEL': {}},), is_leaf=True, yang_name="assignment-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=True)


  def _get_logical_channel(self):
    """
    Getter method for logical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/logical_channel (leafref)

    YANG Description: Reference to another stage of logical channel elements.
    """
    return self.__logical_channel
      
  def _set_logical_channel(self, v, load=False):
    """
    Setter method for logical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/logical_channel (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical_channel() directly.

    YANG Description: Reference to another stage of logical channel elements.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="logical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical_channel must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)""",
        })

    self.__logical_channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical_channel(self):
    self.__logical_channel = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)


  def _get_optical_channel(self):
    """
    Getter method for optical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/optical_channel (leafref)

    YANG Description: Reference to the line-side optical channel that should
carry the current logical channel element.  Use this
reference to exit the logical element stage.
    """
    return self.__optical_channel
      
  def _set_optical_channel(self, v, load=False):
    """
    Setter method for optical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/optical_channel (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_channel() directly.

    YANG Description: Reference to the line-side optical channel that should
carry the current logical channel element.  Use this
reference to exit the logical element stage.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="optical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_channel must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="optical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)""",
        })

    self.__optical_channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_channel(self):
    self.__optical_channel = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="optical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)


  def _get_allocation(self):
    """
    Getter method for allocation, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/allocation (decimal64)

    YANG Description: Allocation of the logical client channel to the tributary
or sub-channel, expressed in Gbps. Please note that if the
assignment is to an OTN logical channel, the allocation must
be an integer multiplication to tributary-slot-granularity
of the OTN logical channel.
    """
    return self.__allocation
      
  def _set_allocation(self, v, load=False):
    """
    Setter method for allocation, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/allocation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_allocation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_allocation() directly.

    YANG Description: Allocation of the logical client channel to the tributary
or sub-channel, expressed in Gbps. Please note that if the
assignment is to an OTN logical channel, the allocation must
be an integer multiplication to tributary-slot-granularity
of the OTN logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=3), is_leaf=True, yang_name="allocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """allocation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=3), is_leaf=True, yang_name="allocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=True)""",
        })

    self.__allocation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_allocation(self):
    self.__allocation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=3), is_leaf=True, yang_name="allocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=True)


  def _get_tributary_slot_index(self):
    """
    Getter method for tributary_slot_index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/tributary_slot_index (int32)

    YANG Description: Indicates the first tributary slot index allocated to the
client signal or logical channel in the assignment. Valid
only when the assignment is to an OTN logical channel.
    """
    return self.__tributary_slot_index
      
  def _set_tributary_slot_index(self, v, load=False):
    """
    Setter method for tributary_slot_index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/tributary_slot_index (int32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tributary_slot_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tributary_slot_index() directly.

    YANG Description: Indicates the first tributary slot index allocated to the
client signal or logical channel in the assignment. Valid
only when the assignment is to an OTN logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="tributary-slot-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tributary_slot_index must be of a type compatible with int32""",
          'defined-type': "int32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="tributary-slot-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=True)""",
        })

    self.__tributary_slot_index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tributary_slot_index(self):
    self.__tributary_slot_index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="tributary-slot-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=True)


  def _get_mapping(self):
    """
    Getter method for mapping, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/mapping (identityref)

    YANG Description: Logical channel mapping procedure. Valid only when the
assignment is to an OTN logical channel.
    """
    return self.__mapping
      
  def _set_mapping(self, v, load=False):
    """
    Setter method for mapping, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config/mapping (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mapping is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mapping() directly.

    YANG Description: Logical channel mapping procedure. Valid only when the
assignment is to an OTN logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="mapping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mapping must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="mapping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)""",
        })

    self.__mapping = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mapping(self):
    self.__mapping = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="mapping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  description = __builtin__.property(_get_description, _set_description)
  assignment_type = __builtin__.property(_get_assignment_type, _set_assignment_type)
  logical_channel = __builtin__.property(_get_logical_channel, _set_logical_channel)
  optical_channel = __builtin__.property(_get_optical_channel, _set_optical_channel)
  allocation = __builtin__.property(_get_allocation, _set_allocation)
  tributary_slot_index = __builtin__.property(_get_tributary_slot_index, _set_tributary_slot_index)
  mapping = __builtin__.property(_get_mapping, _set_mapping)


  _pyangbind_elements = OrderedDict([('index', index), ('description', description), ('assignment_type', assignment_type), ('logical_channel', logical_channel), ('optical_channel', optical_channel), ('allocation', allocation), ('tributary_slot_index', tributary_slot_index), ('mapping', mapping), ])


class yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/logical-channel-assignments/assignment/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for tributary assignments
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__description','__assignment_type','__logical_channel','__optical_channel','__allocation','__tributary_slot_index','__mapping',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__assignment_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOGICAL_CHANNEL': {}, 'OPTICAL_CHANNEL': {}},), is_leaf=True, yang_name="assignment-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)
    self.__logical_channel = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__optical_channel = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="optical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__allocation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=3), is_leaf=True, yang_name="allocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    self.__tributary_slot_index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="tributary-slot-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=False)
    self.__mapping = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="mapping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'logical-channel-assignments', 'assignment', 'state']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/index (uint32)

    YANG Description: Index of the current logical client channel to tributary
mapping
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Index of the current logical client channel to tributary
mapping
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint32', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/description (string)

    YANG Description: Name assigned to the logical client channel
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Name assigned to the logical client channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_assignment_type(self):
    """
    Getter method for assignment_type, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/assignment_type (enumeration)

    YANG Description: Each logical channel element may be assigned to subsequent
stages of logical elements to implement further grooming, or
can be assigned to a line-side optical channel for
transmission.  Each assignment also has an associated
bandwidth allocation.
    """
    return self.__assignment_type
      
  def _set_assignment_type(self, v, load=False):
    """
    Setter method for assignment_type, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/assignment_type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_assignment_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_assignment_type() directly.

    YANG Description: Each logical channel element may be assigned to subsequent
stages of logical elements to implement further grooming, or
can be assigned to a line-side optical channel for
transmission.  Each assignment also has an associated
bandwidth allocation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOGICAL_CHANNEL': {}, 'OPTICAL_CHANNEL': {}},), is_leaf=True, yang_name="assignment-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """assignment_type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-terminal-device:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOGICAL_CHANNEL': {}, 'OPTICAL_CHANNEL': {}},), is_leaf=True, yang_name="assignment-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)""",
        })

    self.__assignment_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_assignment_type(self):
    self.__assignment_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOGICAL_CHANNEL': {}, 'OPTICAL_CHANNEL': {}},), is_leaf=True, yang_name="assignment-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='enumeration', is_config=False)


  def _get_logical_channel(self):
    """
    Getter method for logical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/logical_channel (leafref)

    YANG Description: Reference to another stage of logical channel elements.
    """
    return self.__logical_channel
      
  def _set_logical_channel(self, v, load=False):
    """
    Setter method for logical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/logical_channel (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical_channel() directly.

    YANG Description: Reference to another stage of logical channel elements.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="logical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical_channel must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__logical_channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical_channel(self):
    self.__logical_channel = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="logical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_optical_channel(self):
    """
    Getter method for optical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/optical_channel (leafref)

    YANG Description: Reference to the line-side optical channel that should
carry the current logical channel element.  Use this
reference to exit the logical element stage.
    """
    return self.__optical_channel
      
  def _set_optical_channel(self, v, load=False):
    """
    Setter method for optical_channel, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/optical_channel (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_optical_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_optical_channel() directly.

    YANG Description: Reference to the line-side optical channel that should
carry the current logical channel element.  Use this
reference to exit the logical element stage.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="optical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """optical_channel must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="optical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__optical_channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_optical_channel(self):
    self.__optical_channel = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="optical-channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_allocation(self):
    """
    Getter method for allocation, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/allocation (decimal64)

    YANG Description: Allocation of the logical client channel to the tributary
or sub-channel, expressed in Gbps. Please note that if the
assignment is to an OTN logical channel, the allocation must
be an integer multiplication to tributary-slot-granularity
of the OTN logical channel.
    """
    return self.__allocation
      
  def _set_allocation(self, v, load=False):
    """
    Setter method for allocation, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/allocation (decimal64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_allocation is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_allocation() directly.

    YANG Description: Allocation of the logical client channel to the tributary
or sub-channel, expressed in Gbps. Please note that if the
assignment is to an OTN logical channel, the allocation must
be an integer multiplication to tributary-slot-granularity
of the OTN logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedPrecisionDecimalType(precision=3), is_leaf=True, yang_name="allocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """allocation must be of a type compatible with decimal64""",
          'defined-type': "decimal64",
          'generated-type': """YANGDynClass(base=RestrictedPrecisionDecimalType(precision=3), is_leaf=True, yang_name="allocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)""",
        })

    self.__allocation = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_allocation(self):
    self.__allocation = YANGDynClass(base=RestrictedPrecisionDecimalType(precision=3), is_leaf=True, yang_name="allocation", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='decimal64', is_config=False)


  def _get_tributary_slot_index(self):
    """
    Getter method for tributary_slot_index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/tributary_slot_index (int32)

    YANG Description: Indicates the first tributary slot index allocated to the
client signal or logical channel in the assignment. Valid
only when the assignment is to an OTN logical channel.
    """
    return self.__tributary_slot_index
      
  def _set_tributary_slot_index(self, v, load=False):
    """
    Setter method for tributary_slot_index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/tributary_slot_index (int32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tributary_slot_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tributary_slot_index() directly.

    YANG Description: Indicates the first tributary slot index allocated to the
client signal or logical channel in the assignment. Valid
only when the assignment is to an OTN logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="tributary-slot-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tributary_slot_index must be of a type compatible with int32""",
          'defined-type': "int32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="tributary-slot-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=False)""",
        })

    self.__tributary_slot_index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tributary_slot_index(self):
    self.__tributary_slot_index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['-2147483648..2147483647']}, int_size=32), is_leaf=True, yang_name="tributary-slot-index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='int32', is_config=False)


  def _get_mapping(self):
    """
    Getter method for mapping, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/mapping (identityref)

    YANG Description: Logical channel mapping procedure. Valid only when the
assignment is to an OTN logical channel.
    """
    return self.__mapping
      
  def _set_mapping(self, v, load=False):
    """
    Setter method for mapping, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state/mapping (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mapping is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mapping() directly.

    YANG Description: Logical channel mapping procedure. Valid only when the
assignment is to an OTN logical channel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="mapping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mapping must be of a type compatible with identityref""",
          'defined-type': "openconfig-terminal-device:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="mapping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)""",
        })

    self.__mapping = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mapping(self):
    self.__mapping = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:AMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:BMP': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:CBR': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_T': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:GFP_F': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="mapping", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='identityref', is_config=False)

  index = __builtin__.property(_get_index)
  description = __builtin__.property(_get_description)
  assignment_type = __builtin__.property(_get_assignment_type)
  logical_channel = __builtin__.property(_get_logical_channel)
  optical_channel = __builtin__.property(_get_optical_channel)
  allocation = __builtin__.property(_get_allocation)
  tributary_slot_index = __builtin__.property(_get_tributary_slot_index)
  mapping = __builtin__.property(_get_mapping)


  _pyangbind_elements = OrderedDict([('index', index), ('description', description), ('assignment_type', assignment_type), ('logical_channel', logical_channel), ('optical_channel', optical_channel), ('allocation', allocation), ('tributary_slot_index', tributary_slot_index), ('mapping', mapping), ])


class yc_assignment_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/logical-channel-assignments/assignment. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Logical channel elements may be assigned directly to
optical channels for line-side transmission, or can be
further groomed into additional stages of logical channel
elements.  The grooming can multiplex (i.e., split the
current element into multiple elements in the subsequent
stage) or de-multiplex (i.e., combine the current element
with other elements into the same element in the subsequent
stage) logical elements in each stage.

Note that to support the ability to groom the logical
elements, the list of logical channel elements should be
populated with an entry for the logical elements at
each stage, starting with the initial assignment from the
respective client physical port.

Each logical element assignment consists of a pointer to
an element in the next stage, or to an optical channel,
along with a bandwidth allocation for the corresponding
assignment (e.g., to split or combine signal).
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__config','__state',)

  _yang_name = 'assignment'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'logical-channel-assignments', 'assignment']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/index (leafref)

    YANG Description: Reference to the index for the current tributary
assignment
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/index (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Reference to the index for the current tributary
assignment
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config (container)

    YANG Description: Configuration data for tributary assignments
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for tributary assignments
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state (container)

    YANG Description: Operational state data for tributary assignments
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for tributary assignments
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('index', index), ('config', config), ('state', state), ])


class yc_logical_channel_assignments_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel/logical-channel-assignments. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for tributary assignments
  """
  __slots__ = ('_path_helper', '_extmethods', '__assignment',)

  _yang_name = 'logical-channel-assignments'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__assignment = YANGDynClass(base=YANGListType("index",yc_assignment_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment, yang_name="assignment", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="assignment", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel', 'logical-channel-assignments']

  def _get_assignment(self):
    """
    Getter method for assignment, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment (list)

    YANG Description: Logical channel elements may be assigned directly to
optical channels for line-side transmission, or can be
further groomed into additional stages of logical channel
elements.  The grooming can multiplex (i.e., split the
current element into multiple elements in the subsequent
stage) or de-multiplex (i.e., combine the current element
with other elements into the same element in the subsequent
stage) logical elements in each stage.

Note that to support the ability to groom the logical
elements, the list of logical channel elements should be
populated with an entry for the logical elements at
each stage, starting with the initial assignment from the
respective client physical port.

Each logical element assignment consists of a pointer to
an element in the next stage, or to an optical channel,
along with a bandwidth allocation for the corresponding
assignment (e.g., to split or combine signal).
    """
    return self.__assignment
      
  def _set_assignment(self, v, load=False):
    """
    Setter method for assignment, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments/assignment (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_assignment is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_assignment() directly.

    YANG Description: Logical channel elements may be assigned directly to
optical channels for line-side transmission, or can be
further groomed into additional stages of logical channel
elements.  The grooming can multiplex (i.e., split the
current element into multiple elements in the subsequent
stage) or de-multiplex (i.e., combine the current element
with other elements into the same element in the subsequent
stage) logical elements in each stage.

Note that to support the ability to groom the logical
elements, the list of logical channel elements should be
populated with an entry for the logical elements at
each stage, starting with the initial assignment from the
respective client physical port.

Each logical element assignment consists of a pointer to
an element in the next stage, or to an optical channel,
along with a bandwidth allocation for the corresponding
assignment (e.g., to split or combine signal).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",yc_assignment_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment, yang_name="assignment", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="assignment", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """assignment must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",yc_assignment_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment, yang_name="assignment", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="assignment", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)""",
        })

    self.__assignment = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_assignment(self):
    self.__assignment = YANGDynClass(base=YANGListType("index",yc_assignment_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments_assignment, yang_name="assignment", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="assignment", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)

  assignment = __builtin__.property(_get_assignment, _set_assignment)


  _pyangbind_elements = OrderedDict([('assignment', assignment), ])


class yc_channel_openconfig_terminal_device__terminal_device_logical_channels_channel(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels/channel. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__config','__state','__otn','__ethernet','__ingress','__logical_channel_assignments',)

  _yang_name = 'channel'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__otn = YANGDynClass(base=yc_otn_openconfig_terminal_device__terminal_device_logical_channels_channel_otn, is_container='container', yang_name="otn", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__ethernet = YANGDynClass(base=yc_ethernet_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet, is_container='container', yang_name="ethernet", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__ingress = YANGDynClass(base=yc_ingress_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress, is_container='container', yang_name="ingress", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__logical_channel_assignments = YANGDynClass(base=yc_logical_channel_assignments_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments, is_container='container', yang_name="logical-channel-assignments", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels', 'channel']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/index (leafref)

    YANG Description: Reference to the index of the logical channel
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /terminal_device/logical_channels/channel/index (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Reference to the index of the logical channel
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/config (container)

    YANG Description: Configuration data for logical channels
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /terminal_device/logical_channels/channel/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_terminal_device__terminal_device_logical_channels_channel_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/state (container)

    YANG Description: Operational state data for logical channels
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/logical_channels/channel/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_logical_channels_channel_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_otn(self):
    """
    Getter method for otn, mapped from YANG variable /terminal_device/logical_channels/channel/otn (container)

    YANG Description: Top level container for OTU configuration when logical
channel framing is using an OTU protocol, e.g., OTU1, OTU3,
etc.
    """
    return self.__otn
      
  def _set_otn(self, v, load=False):
    """
    Setter method for otn, mapped from YANG variable /terminal_device/logical_channels/channel/otn (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_otn is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_otn() directly.

    YANG Description: Top level container for OTU configuration when logical
channel framing is using an OTU protocol, e.g., OTU1, OTU3,
etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_otn_openconfig_terminal_device__terminal_device_logical_channels_channel_otn, is_container='container', yang_name="otn", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """otn must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_otn_openconfig_terminal_device__terminal_device_logical_channels_channel_otn, is_container='container', yang_name="otn", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__otn = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_otn(self):
    self.__otn = YANGDynClass(base=yc_otn_openconfig_terminal_device__terminal_device_logical_channels_channel_otn, is_container='container', yang_name="otn", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_ethernet(self):
    """
    Getter method for ethernet, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet (container)

    YANG Description: Top level container for data related to Ethernet framing
for the logical channel
    """
    return self.__ethernet
      
  def _set_ethernet(self, v, load=False):
    """
    Setter method for ethernet, mapped from YANG variable /terminal_device/logical_channels/channel/ethernet (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ethernet is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ethernet() directly.

    YANG Description: Top level container for data related to Ethernet framing
for the logical channel
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ethernet_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet, is_container='container', yang_name="ethernet", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ethernet must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ethernet_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet, is_container='container', yang_name="ethernet", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__ethernet = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ethernet(self):
    self.__ethernet = YANGDynClass(base=yc_ethernet_openconfig_terminal_device__terminal_device_logical_channels_channel_ethernet, is_container='container', yang_name="ethernet", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_ingress(self):
    """
    Getter method for ingress, mapped from YANG variable /terminal_device/logical_channels/channel/ingress (container)

    YANG Description: Top-level container for specifying references to the
source of signal for the logical channel, either a
transceiver, individual physical channels, or an interface
    """
    return self.__ingress
      
  def _set_ingress(self, v, load=False):
    """
    Setter method for ingress, mapped from YANG variable /terminal_device/logical_channels/channel/ingress (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ingress is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ingress() directly.

    YANG Description: Top-level container for specifying references to the
source of signal for the logical channel, either a
transceiver, individual physical channels, or an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_ingress_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress, is_container='container', yang_name="ingress", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ingress must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_ingress_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress, is_container='container', yang_name="ingress", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__ingress = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ingress(self):
    self.__ingress = YANGDynClass(base=yc_ingress_openconfig_terminal_device__terminal_device_logical_channels_channel_ingress, is_container='container', yang_name="ingress", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_logical_channel_assignments(self):
    """
    Getter method for logical_channel_assignments, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments (container)

    YANG Description: Enclosing container for tributary assignments
    """
    return self.__logical_channel_assignments
      
  def _set_logical_channel_assignments(self, v, load=False):
    """
    Setter method for logical_channel_assignments, mapped from YANG variable /terminal_device/logical_channels/channel/logical_channel_assignments (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical_channel_assignments is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical_channel_assignments() directly.

    YANG Description: Enclosing container for tributary assignments
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_logical_channel_assignments_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments, is_container='container', yang_name="logical-channel-assignments", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical_channel_assignments must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_logical_channel_assignments_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments, is_container='container', yang_name="logical-channel-assignments", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__logical_channel_assignments = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical_channel_assignments(self):
    self.__logical_channel_assignments = YANGDynClass(base=yc_logical_channel_assignments_openconfig_terminal_device__terminal_device_logical_channels_channel_logical_channel_assignments, is_container='container', yang_name="logical-channel-assignments", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  otn = __builtin__.property(_get_otn, _set_otn)
  ethernet = __builtin__.property(_get_ethernet, _set_ethernet)
  ingress = __builtin__.property(_get_ingress, _set_ingress)
  logical_channel_assignments = __builtin__.property(_get_logical_channel_assignments, _set_logical_channel_assignments)


  _pyangbind_elements = OrderedDict([('index', index), ('config', config), ('state', state), ('otn', otn), ('ethernet', ethernet), ('ingress', ingress), ('logical_channel_assignments', logical_channel_assignments), ])


class yc_logical_channels_openconfig_terminal_device__terminal_device_logical_channels(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/logical-channels. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container the list of logical channels
  """
  __slots__ = ('_path_helper', '_extmethods', '__channel',)

  _yang_name = 'logical-channels'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__channel = YANGDynClass(base=YANGListType("index",yc_channel_openconfig_terminal_device__terminal_device_logical_channels_channel, yang_name="channel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'logical-channels']

  def _get_channel(self):
    """
    Getter method for channel, mapped from YANG variable /terminal_device/logical_channels/channel (list)

    YANG Description: List of logical channels
    """
    return self.__channel
      
  def _set_channel(self, v, load=False):
    """
    Setter method for channel, mapped from YANG variable /terminal_device/logical_channels/channel (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_channel is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_channel() directly.

    YANG Description: List of logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",yc_channel_openconfig_terminal_device__terminal_device_logical_channels_channel, yang_name="channel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """channel must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",yc_channel_openconfig_terminal_device__terminal_device_logical_channels_channel, yang_name="channel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)""",
        })

    self.__channel = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_channel(self):
    self.__channel = YANGDynClass(base=YANGListType("index",yc_channel_openconfig_terminal_device__terminal_device_logical_channels_channel, yang_name="channel", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="channel", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)

  channel = __builtin__.property(_get_channel, _set_channel)


  _pyangbind_elements = OrderedDict([('channel', channel), ])


class yc_state_openconfig_terminal_device__terminal_device_operational_modes_mode_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/operational-modes/mode/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the platform-defined
operational mode
  """
  __slots__ = ('_path_helper', '_extmethods', '__mode_id','__description','__vendor_id',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mode_id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint16', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    self.__vendor_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vendor-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'operational-modes', 'mode', 'state']

  def _get_mode_id(self):
    """
    Getter method for mode_id, mapped from YANG variable /terminal_device/operational_modes/mode/state/mode_id (uint16)

    YANG Description: Two-octet encoding of the vendor-defined operational
mode
    """
    return self.__mode_id
      
  def _set_mode_id(self, v, load=False):
    """
    Setter method for mode_id, mapped from YANG variable /terminal_device/operational_modes/mode/state/mode_id (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mode_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mode_id() directly.

    YANG Description: Two-octet encoding of the vendor-defined operational
mode
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mode_id must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint16', is_config=False)""",
        })

    self.__mode_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mode_id(self):
    self.__mode_id = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='uint16', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /terminal_device/operational_modes/mode/state/description (string)

    YANG Description: Vendor-supplied textual description of the characteristics
of this operational mode to enable operators to select the
appropriate mode for the application.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /terminal_device/operational_modes/mode/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: Vendor-supplied textual description of the characteristics
of this operational mode to enable operators to select the
appropriate mode for the application.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)


  def _get_vendor_id(self):
    """
    Getter method for vendor_id, mapped from YANG variable /terminal_device/operational_modes/mode/state/vendor_id (string)

    YANG Description: Identifier to represent the vendor / supplier of the
platform and the associated operational mode information
    """
    return self.__vendor_id
      
  def _set_vendor_id(self, v, load=False):
    """
    Setter method for vendor_id, mapped from YANG variable /terminal_device/operational_modes/mode/state/vendor_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vendor_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vendor_id() directly.

    YANG Description: Identifier to represent the vendor / supplier of the
platform and the associated operational mode information
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="vendor-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vendor_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vendor-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)""",
        })

    self.__vendor_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vendor_id(self):
    self.__vendor_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vendor-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='string', is_config=False)

  mode_id = __builtin__.property(_get_mode_id)
  description = __builtin__.property(_get_description)
  vendor_id = __builtin__.property(_get_vendor_id)


  _pyangbind_elements = OrderedDict([('mode_id', mode_id), ('description', description), ('vendor_id', vendor_id), ])


class yc_mode_openconfig_terminal_device__terminal_device_operational_modes_mode(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/operational-modes/mode. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of operational modes supported by the platform.
The operational mode provides a platform-defined summary
of information such as symbol rate, modulation, pulse
shaping, etc.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mode_id','__state',)

  _yang_name = 'mode'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mode_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_operational_modes_mode_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'operational-modes', 'mode']

  def _get_mode_id(self):
    """
    Getter method for mode_id, mapped from YANG variable /terminal_device/operational_modes/mode/mode_id (leafref)

    YANG Description: Reference to mode-id
    """
    return self.__mode_id
      
  def _set_mode_id(self, v, load=False):
    """
    Setter method for mode_id, mapped from YANG variable /terminal_device/operational_modes/mode/mode_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mode_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mode_id() directly.

    YANG Description: Reference to mode-id
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mode_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)""",
        })

    self.__mode_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mode_id(self):
    self.__mode_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mode-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /terminal_device/operational_modes/mode/state (container)

    YANG Description: Operational state data for the platform-defined
operational mode
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /terminal_device/operational_modes/mode/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the platform-defined
operational mode
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_terminal_device__terminal_device_operational_modes_mode_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_operational_modes_mode_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_terminal_device__terminal_device_operational_modes_mode_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=False)

  mode_id = __builtin__.property(_get_mode_id)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('mode_id', mode_id), ('state', state), ])


class yc_operational_modes_openconfig_terminal_device__terminal_device_operational_modes(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device/operational-modes. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of operational modes
  """
  __slots__ = ('_path_helper', '_extmethods', '__mode',)

  _yang_name = 'operational-modes'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mode = YANGDynClass(base=YANGListType("mode_id",yc_mode_openconfig_terminal_device__terminal_device_operational_modes_mode, yang_name="mode", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mode-id', extensions=None), is_container='list', yang_name="mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device', 'operational-modes']

  def _get_mode(self):
    """
    Getter method for mode, mapped from YANG variable /terminal_device/operational_modes/mode (list)

    YANG Description: List of operational modes supported by the platform.
The operational mode provides a platform-defined summary
of information such as symbol rate, modulation, pulse
shaping, etc.
    """
    return self.__mode
      
  def _set_mode(self, v, load=False):
    """
    Setter method for mode, mapped from YANG variable /terminal_device/operational_modes/mode (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mode() directly.

    YANG Description: List of operational modes supported by the platform.
The operational mode provides a platform-defined summary
of information such as symbol rate, modulation, pulse
shaping, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("mode_id",yc_mode_openconfig_terminal_device__terminal_device_operational_modes_mode, yang_name="mode", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mode-id', extensions=None), is_container='list', yang_name="mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mode must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("mode_id",yc_mode_openconfig_terminal_device__terminal_device_operational_modes_mode, yang_name="mode", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mode-id', extensions=None), is_container='list', yang_name="mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)""",
        })

    self.__mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mode(self):
    self.__mode = YANGDynClass(base=YANGListType("mode_id",yc_mode_openconfig_terminal_device__terminal_device_operational_modes_mode, yang_name="mode", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mode-id', extensions=None), is_container='list', yang_name="mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='list', is_config=True)

  mode = __builtin__.property(_get_mode, _set_mode)


  _pyangbind_elements = OrderedDict([('mode', mode), ])


class yc_terminal_device_openconfig_terminal_device__terminal_device(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /terminal-device. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for the terminal device
  """
  __slots__ = ('_path_helper', '_extmethods', '__logical_channels','__operational_modes',)

  _yang_name = 'terminal-device'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__logical_channels = YANGDynClass(base=yc_logical_channels_openconfig_terminal_device__terminal_device_logical_channels, is_container='container', yang_name="logical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    self.__operational_modes = YANGDynClass(base=yc_operational_modes_openconfig_terminal_device__terminal_device_operational_modes, is_container='container', yang_name="operational-modes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['terminal-device']

  def _get_logical_channels(self):
    """
    Getter method for logical_channels, mapped from YANG variable /terminal_device/logical_channels (container)

    YANG Description: Enclosing container the list of logical channels
    """
    return self.__logical_channels
      
  def _set_logical_channels(self, v, load=False):
    """
    Setter method for logical_channels, mapped from YANG variable /terminal_device/logical_channels (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_logical_channels is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_logical_channels() directly.

    YANG Description: Enclosing container the list of logical channels
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_logical_channels_openconfig_terminal_device__terminal_device_logical_channels, is_container='container', yang_name="logical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """logical_channels must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_logical_channels_openconfig_terminal_device__terminal_device_logical_channels, is_container='container', yang_name="logical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__logical_channels = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_logical_channels(self):
    self.__logical_channels = YANGDynClass(base=yc_logical_channels_openconfig_terminal_device__terminal_device_logical_channels, is_container='container', yang_name="logical-channels", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)


  def _get_operational_modes(self):
    """
    Getter method for operational_modes, mapped from YANG variable /terminal_device/operational_modes (container)

    YANG Description: Enclosing container for list of operational modes
    """
    return self.__operational_modes
      
  def _set_operational_modes(self, v, load=False):
    """
    Setter method for operational_modes, mapped from YANG variable /terminal_device/operational_modes (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_operational_modes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_operational_modes() directly.

    YANG Description: Enclosing container for list of operational modes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_operational_modes_openconfig_terminal_device__terminal_device_operational_modes, is_container='container', yang_name="operational-modes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """operational_modes must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_operational_modes_openconfig_terminal_device__terminal_device_operational_modes, is_container='container', yang_name="operational-modes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__operational_modes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_operational_modes(self):
    self.__operational_modes = YANGDynClass(base=yc_operational_modes_openconfig_terminal_device__terminal_device_operational_modes, is_container='container', yang_name="operational-modes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

  logical_channels = __builtin__.property(_get_logical_channels, _set_logical_channels)
  operational_modes = __builtin__.property(_get_operational_modes, _set_operational_modes)


  _pyangbind_elements = OrderedDict([('logical_channels', logical_channels), ('operational_modes', operational_modes), ])


class openconfig_terminal_device(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-terminal-device - based on the path /openconfig-terminal-device. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module describes a terminal optics device model for
managing the terminal systems (client and line side) in a
DWDM transport network.

Elements of the model:

physical port: corresponds to a physical, pluggable client
port on the terminal device. Examples includes 10G, 40G, 100G
(e.g., 10x10G, 4x25G or 1x100G) and 400G/1T in the future.
Physical client ports will have associated operational state or
PMs.

physical channel: a physical lane or channel in the
physical client port.  Each physical client port has 1 or more
channels. An example is 100GBASE-LR4 client physical port having
4x25G channels. Channels have their own optical PMs and can be
monitored independently within a client physical port (e.g.,
channel power).  Physical client channels are defined in the
model as part of a physical client port, and are modeled
primarily for reading their PMs.

logical channel: a logical grouping of logical grooming elements
that may be assigned to subsequent grooming stages for
multiplexing / de-multiplexing, or to an optical channel for
line side transmission.  The logical channels can represent, for
example, an ODU/OTU logical packing of the client
data onto the line side.  Tributaries are similarly logical
groupings of demand that can be represented in this structure and
assigned to an optical channel.  Note that different types of
logical channels may be present, each with their corresponding
PMs.

optical channel:  corresponds to an optical carrier and is
assigned a wavelength/frequency.  Optical channels have PMs
such as power, BER, and operational mode.

Directionality:

To maintain simplicity in the model, the configuration is
described from client-to-line direction.  The assumption is that
equivalent reverse configuration is implicit, resulting in
the same line-to-client configuration.

Physical layout:

The model does not assume a particular physical layout of client
and line ports on the terminal device (e.g., such as number of
ports per linecard, separate linecards for client and line ports,
etc.).
  """
  __slots__ = ('_path_helper', '_extmethods', '__terminal_device',)

  _yang_name = 'openconfig-terminal-device'
  _yang_namespace = 'http://openconfig.net/yang/terminal-device'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__terminal_device = YANGDynClass(base=yc_terminal_device_openconfig_terminal_device__terminal_device, is_container='container', yang_name="terminal-device", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_terminal_device(self):
    """
    Getter method for terminal_device, mapped from YANG variable /terminal_device (container)

    YANG Description: Top-level container for the terminal device
    """
    return self.__terminal_device
      
  def _set_terminal_device(self, v, load=False):
    """
    Setter method for terminal_device, mapped from YANG variable /terminal_device (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_terminal_device is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_terminal_device() directly.

    YANG Description: Top-level container for the terminal device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_terminal_device_openconfig_terminal_device__terminal_device, is_container='container', yang_name="terminal-device", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """terminal_device must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_terminal_device_openconfig_terminal_device__terminal_device, is_container='container', yang_name="terminal-device", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)""",
        })

    self.__terminal_device = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_terminal_device(self):
    self.__terminal_device = YANGDynClass(base=yc_terminal_device_openconfig_terminal_device__terminal_device, is_container='container', yang_name="terminal-device", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/terminal-device', defining_module='openconfig-terminal-device', yang_type='container', is_config=True)

  terminal_device = __builtin__.property(_get_terminal_device, _set_terminal_device)


  _pyangbind_elements = OrderedDict([('terminal_device', terminal_device), ])


class yc_config_openconfig_transport_line_connectivity__connections_connection_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-connectivity - based on the path /connections/connection/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__source','__dest','__fiber_type',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/openconfig-transport-line-connectivity'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='uint32', is_config=True)
    self.__source = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=True)
    self.__dest = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="dest", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=True)
    self.__fiber_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="fiber-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='identityref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['connections', 'connection', 'config']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /connections/connection/config/index (uint32)

    YANG Description: Index for the defined connection
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /connections/connection/config/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Index for the defined connection
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='uint32', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='uint32', is_config=True)


  def _get_source(self):
    """
    Getter method for source, mapped from YANG variable /connections/connection/config/source (union)

    YANG Description: The user supplied name of the source port of the connection
within the system. If the port is within the device, the
string should reflect the name of the port as it appears in
the components model. If the port is not represented in the
components model (e.g., a port on a passive chassis), the
string should reflect the system assigned name of the port.
If the source port is not within the device, then an
identityref of EXTERNAL should be specified.
    """
    return self.__source
      
  def _set_source(self, v, load=False):
    """
    Setter method for source, mapped from YANG variable /connections/connection/config/source (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source() directly.

    YANG Description: The user supplied name of the source port of the connection
within the system. If the port is within the device, the
string should reflect the name of the port as it appears in
the components model. If the port is not represented in the
components model (e.g., a port on a passive chassis), the
string should reflect the system assigned name of the port.
If the source port is not within the device, then an
identityref of EXTERNAL should be specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source must be of a type compatible with union""",
          'defined-type': "openconfig-transport-line-connectivity:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=True)""",
        })

    self.__source = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source(self):
    self.__source = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=True)


  def _get_dest(self):
    """
    Getter method for dest, mapped from YANG variable /connections/connection/config/dest (union)

    YANG Description: The user supplied name of the destination port of the connection
within the system. If the port is within the device, the string
should reflect the name of the port as it appears in the
components model. If the port is not represented in the components
model (e.g., a port on a passive chassis), the string should
reflect the system assigned name of the port. If the destination
port is not within the device, then an identityref of EXTERNAL
should be specified.
    """
    return self.__dest
      
  def _set_dest(self, v, load=False):
    """
    Setter method for dest, mapped from YANG variable /connections/connection/config/dest (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dest is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dest() directly.

    YANG Description: The user supplied name of the destination port of the connection
within the system. If the port is within the device, the string
should reflect the name of the port as it appears in the
components model. If the port is not represented in the components
model (e.g., a port on a passive chassis), the string should
reflect the system assigned name of the port. If the destination
port is not within the device, then an identityref of EXTERNAL
should be specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="dest", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dest must be of a type compatible with union""",
          'defined-type': "openconfig-transport-line-connectivity:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="dest", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=True)""",
        })

    self.__dest = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dest(self):
    self.__dest = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="dest", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=True)


  def _get_fiber_type(self):
    """
    Getter method for fiber_type, mapped from YANG variable /connections/connection/config/fiber_type (identityref)

    YANG Description: The type of fiber jumper used for the connection.
    """
    return self.__fiber_type
      
  def _set_fiber_type(self, v, load=False):
    """
    Setter method for fiber_type, mapped from YANG variable /connections/connection/config/fiber_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fiber_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fiber_type() directly.

    YANG Description: The type of fiber jumper used for the connection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="fiber-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fiber_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-transport-line-connectivity:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="fiber-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='identityref', is_config=True)""",
        })

    self.__fiber_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fiber_type(self):
    self.__fiber_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="fiber-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='identityref', is_config=True)

  index = __builtin__.property(_get_index, _set_index)
  source = __builtin__.property(_get_source, _set_source)
  dest = __builtin__.property(_get_dest, _set_dest)
  fiber_type = __builtin__.property(_get_fiber_type, _set_fiber_type)


  _pyangbind_elements = OrderedDict([('index', index), ('source', source), ('dest', dest), ('fiber_type', fiber_type), ])


class yc_state_openconfig_transport_line_connectivity__connections_connection_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-connectivity - based on the path /connections/connection/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__source','__dest','__fiber_type',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/openconfig-transport-line-connectivity'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='uint32', is_config=False)
    self.__source = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=False)
    self.__dest = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="dest", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=False)
    self.__fiber_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="fiber-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='identityref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['connections', 'connection', 'state']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /connections/connection/state/index (uint32)

    YANG Description: Index for the defined connection
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /connections/connection/state/index (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Index for the defined connection
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='uint32', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='uint32', is_config=False)


  def _get_source(self):
    """
    Getter method for source, mapped from YANG variable /connections/connection/state/source (union)

    YANG Description: The user supplied name of the source port of the connection
within the system. If the port is within the device, the
string should reflect the name of the port as it appears in
the components model. If the port is not represented in the
components model (e.g., a port on a passive chassis), the
string should reflect the system assigned name of the port.
If the source port is not within the device, then an
identityref of EXTERNAL should be specified.
    """
    return self.__source
      
  def _set_source(self, v, load=False):
    """
    Setter method for source, mapped from YANG variable /connections/connection/state/source (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source() directly.

    YANG Description: The user supplied name of the source port of the connection
within the system. If the port is within the device, the
string should reflect the name of the port as it appears in
the components model. If the port is not represented in the
components model (e.g., a port on a passive chassis), the
string should reflect the system assigned name of the port.
If the source port is not within the device, then an
identityref of EXTERNAL should be specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source must be of a type compatible with union""",
          'defined-type': "openconfig-transport-line-connectivity:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=False)""",
        })

    self.__source = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source(self):
    self.__source = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=False)


  def _get_dest(self):
    """
    Getter method for dest, mapped from YANG variable /connections/connection/state/dest (union)

    YANG Description: The user supplied name of the destination port of the connection
within the system. If the port is within the device, the string
should reflect the name of the port as it appears in the
components model. If the port is not represented in the components
model (e.g., a port on a passive chassis), the string should
reflect the system assigned name of the port. If the destination
port is not within the device, then an identityref of EXTERNAL
should be specified.
    """
    return self.__dest
      
  def _set_dest(self, v, load=False):
    """
    Setter method for dest, mapped from YANG variable /connections/connection/state/dest (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dest is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dest() directly.

    YANG Description: The user supplied name of the destination port of the connection
within the system. If the port is within the device, the string
should reflect the name of the port as it appears in the
components model. If the port is not represented in the components
model (e.g., a port on a passive chassis), the string should
reflect the system assigned name of the port. If the destination
port is not within the device, then an identityref of EXTERNAL
should be specified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="dest", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dest must be of a type compatible with union""",
          'defined-type': "openconfig-transport-line-connectivity:union",
          'generated-type': """YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="dest", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=False)""",
        })

    self.__dest = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dest(self):
    self.__dest = YANGDynClass(base=[six.text_type,RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}, 'oc-line-connect:EXTERNAL': {'@module': 'openconfig-transport-line-connectivity', '@namespace': 'http://openconfig.net/yang/openconfig-transport-line-connectivity'}},),], is_leaf=True, yang_name="dest", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='union', is_config=False)


  def _get_fiber_type(self):
    """
    Getter method for fiber_type, mapped from YANG variable /connections/connection/state/fiber_type (identityref)

    YANG Description: The type of fiber jumper used for the connection.
    """
    return self.__fiber_type
      
  def _set_fiber_type(self, v, load=False):
    """
    Setter method for fiber_type, mapped from YANG variable /connections/connection/state/fiber_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fiber_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fiber_type() directly.

    YANG Description: The type of fiber jumper used for the connection.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="fiber-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fiber_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-transport-line-connectivity:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="fiber-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='identityref', is_config=False)""",
        })

    self.__fiber_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fiber_type(self):
    self.__fiber_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_SIMPLEX': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}, 'oc-opt-types:FIBER_JUMPER_MULTI_FIBER_STRAND': {'@module': 'openconfig-transport-types', '@namespace': 'http://openconfig.net/yang/transport-types'}},), is_leaf=True, yang_name="fiber-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='identityref', is_config=False)

  index = __builtin__.property(_get_index)
  source = __builtin__.property(_get_source)
  dest = __builtin__.property(_get_dest)
  fiber_type = __builtin__.property(_get_fiber_type)


  _pyangbind_elements = OrderedDict([('index', index), ('source', source), ('dest', dest), ('fiber_type', fiber_type), ])


class yc_connection_openconfig_transport_line_connectivity__connections_connection(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-transport-line-connectivity - based on the path /connections/connection. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of line system connections
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__config','__state',)

  _yang_name = 'connection'
  _yang_namespace = 'http://openconfig.net/yang/openconfig-transport-line-connectivity'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_connectivity__connections_connection_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_transport_line_connectivity__connections_connection_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['connections', 'connection']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /connections/connection/index (leafref)

    YANG Description: Reference to index number of the connection
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /connections/connection/index (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: Reference to index number of the connection
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='leafref', is_config=True)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /connections/connection/config (container)

    YANG Description: Configuration data
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /connections/connection/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_transport_line_connectivity__connections_connection_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_transport_line_connectivity__connections_connection_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_transport_line_connectivity__connections_connection_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /connections/connection/state (container)

    YANG Description: Operational state data
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /connections/connection/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_transport_line_connectivity__connections_connection_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/openconfig-transport-line-connectivity', defining_module='openconfig-transport-line-connectivity', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-