# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_spanning_tree_types(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree-types - based on the path /openconfig-spanning-tree-types. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines types related to the
spanning-tree protocol model.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_spanning_tree__stp_global_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/global/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Global spanning tree configuration
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled_protocol','__bridge_assurance','__etherchannel_misconfig_guard','__bpduguard_timeout_recovery','__loop_guard','__bpdu_guard','__bpdu_filter',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled_protocol = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},)), is_leaf=False, yang_name="enabled-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=True)
    self.__bridge_assurance = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bridge-assurance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    self.__etherchannel_misconfig_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="etherchannel-misconfig-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    self.__bpduguard_timeout_recovery = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="bpduguard-timeout-recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__loop_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="loop-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    self.__bpdu_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    self.__bpdu_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'global', 'config']

  def _get_enabled_protocol(self):
    """
    Getter method for enabled_protocol, mapped from YANG variable /stp/global/config/enabled_protocol (identityref)

    YANG Description: List of the spanning tree protocols enabled on the
device
    """
    return self.__enabled_protocol
      
  def _set_enabled_protocol(self, v, load=False):
    """
    Setter method for enabled_protocol, mapped from YANG variable /stp/global/config/enabled_protocol (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled_protocol() directly.

    YANG Description: List of the spanning tree protocols enabled on the
device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},)), is_leaf=False, yang_name="enabled-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled_protocol must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},)), is_leaf=False, yang_name="enabled-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=True)""",
        })

    self.__enabled_protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled_protocol(self):
    self.__enabled_protocol = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},)), is_leaf=False, yang_name="enabled-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=True)


  def _get_bridge_assurance(self):
    """
    Getter method for bridge_assurance, mapped from YANG variable /stp/global/config/bridge_assurance (boolean)

    YANG Description: Enable bridge assurance to protect against unidirectional
link failure
    """
    return self.__bridge_assurance
      
  def _set_bridge_assurance(self, v, load=False):
    """
    Setter method for bridge_assurance, mapped from YANG variable /stp/global/config/bridge_assurance (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_assurance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_assurance() directly.

    YANG Description: Enable bridge assurance to protect against unidirectional
link failure
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bridge-assurance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_assurance must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bridge-assurance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)""",
        })

    self.__bridge_assurance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_assurance(self):
    self.__bridge_assurance = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bridge-assurance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)


  def _get_etherchannel_misconfig_guard(self):
    """
    Getter method for etherchannel_misconfig_guard, mapped from YANG variable /stp/global/config/etherchannel_misconfig_guard (boolean)

    YANG Description: EtherChannel guard detects a misconfigured EtherChannel
when interfaces on the switch are configured as an
EtherChannel while interfaces on the other device are not
or when not all the interfaces on the other device are in
the same EtherChannel.
    """
    return self.__etherchannel_misconfig_guard
      
  def _set_etherchannel_misconfig_guard(self, v, load=False):
    """
    Setter method for etherchannel_misconfig_guard, mapped from YANG variable /stp/global/config/etherchannel_misconfig_guard (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_etherchannel_misconfig_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_etherchannel_misconfig_guard() directly.

    YANG Description: EtherChannel guard detects a misconfigured EtherChannel
when interfaces on the switch are configured as an
EtherChannel while interfaces on the other device are not
or when not all the interfaces on the other device are in
the same EtherChannel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="etherchannel-misconfig-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """etherchannel_misconfig_guard must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="etherchannel-misconfig-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)""",
        })

    self.__etherchannel_misconfig_guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_etherchannel_misconfig_guard(self):
    self.__etherchannel_misconfig_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="etherchannel-misconfig-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)


  def _get_bpduguard_timeout_recovery(self):
    """
    Getter method for bpduguard_timeout_recovery, mapped from YANG variable /stp/global/config/bpduguard_timeout_recovery (uint8)

    YANG Description: Amount of time, in seconds, the interface receiving BPDUs
is disabled. Once the timeout expires, the interface is
brought back into service.
    """
    return self.__bpduguard_timeout_recovery
      
  def _set_bpduguard_timeout_recovery(self, v, load=False):
    """
    Setter method for bpduguard_timeout_recovery, mapped from YANG variable /stp/global/config/bpduguard_timeout_recovery (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpduguard_timeout_recovery is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpduguard_timeout_recovery() directly.

    YANG Description: Amount of time, in seconds, the interface receiving BPDUs
is disabled. Once the timeout expires, the interface is
brought back into service.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="bpduguard-timeout-recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpduguard_timeout_recovery must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="bpduguard-timeout-recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__bpduguard_timeout_recovery = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpduguard_timeout_recovery(self):
    self.__bpduguard_timeout_recovery = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="bpduguard-timeout-recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_loop_guard(self):
    """
    Getter method for loop_guard, mapped from YANG variable /stp/global/config/loop_guard (boolean)

    YANG Description: The loop guard default setting for the bridge
    """
    return self.__loop_guard
      
  def _set_loop_guard(self, v, load=False):
    """
    Setter method for loop_guard, mapped from YANG variable /stp/global/config/loop_guard (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loop_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loop_guard() directly.

    YANG Description: The loop guard default setting for the bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="loop-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loop_guard must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="loop-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)""",
        })

    self.__loop_guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loop_guard(self):
    self.__loop_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="loop-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)


  def _get_bpdu_guard(self):
    """
    Getter method for bpdu_guard, mapped from YANG variable /stp/global/config/bpdu_guard (boolean)

    YANG Description: Enable edge port BPDU guard
    """
    return self.__bpdu_guard
      
  def _set_bpdu_guard(self, v, load=False):
    """
    Setter method for bpdu_guard, mapped from YANG variable /stp/global/config/bpdu_guard (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_guard() directly.

    YANG Description: Enable edge port BPDU guard
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_guard must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)""",
        })

    self.__bpdu_guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_guard(self):
    self.__bpdu_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)


  def _get_bpdu_filter(self):
    """
    Getter method for bpdu_filter, mapped from YANG variable /stp/global/config/bpdu_filter (boolean)

    YANG Description: Enable edge port BPDU filter
    """
    return self.__bpdu_filter
      
  def _set_bpdu_filter(self, v, load=False):
    """
    Setter method for bpdu_filter, mapped from YANG variable /stp/global/config/bpdu_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_filter() directly.

    YANG Description: Enable edge port BPDU filter
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)""",
        })

    self.__bpdu_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_filter(self):
    self.__bpdu_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)

  enabled_protocol = __builtin__.property(_get_enabled_protocol, _set_enabled_protocol)
  bridge_assurance = __builtin__.property(_get_bridge_assurance, _set_bridge_assurance)
  etherchannel_misconfig_guard = __builtin__.property(_get_etherchannel_misconfig_guard, _set_etherchannel_misconfig_guard)
  bpduguard_timeout_recovery = __builtin__.property(_get_bpduguard_timeout_recovery, _set_bpduguard_timeout_recovery)
  loop_guard = __builtin__.property(_get_loop_guard, _set_loop_guard)
  bpdu_guard = __builtin__.property(_get_bpdu_guard, _set_bpdu_guard)
  bpdu_filter = __builtin__.property(_get_bpdu_filter, _set_bpdu_filter)


  _pyangbind_elements = OrderedDict([('enabled_protocol', enabled_protocol), ('bridge_assurance', bridge_assurance), ('etherchannel_misconfig_guard', etherchannel_misconfig_guard), ('bpduguard_timeout_recovery', bpduguard_timeout_recovery), ('loop_guard', loop_guard), ('bpdu_guard', bpdu_guard), ('bpdu_filter', bpdu_filter), ])


class yc_state_openconfig_spanning_tree__stp_global_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/global/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Global spanning tree state
  """
  __slots__ = ('_path_helper', '_extmethods', '__enabled_protocol','__bridge_assurance','__etherchannel_misconfig_guard','__bpduguard_timeout_recovery','__loop_guard','__bpdu_guard','__bpdu_filter',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enabled_protocol = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},)), is_leaf=False, yang_name="enabled-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    self.__bridge_assurance = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bridge-assurance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    self.__etherchannel_misconfig_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="etherchannel-misconfig-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    self.__bpduguard_timeout_recovery = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="bpduguard-timeout-recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__loop_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="loop-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    self.__bpdu_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    self.__bpdu_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'global', 'state']

  def _get_enabled_protocol(self):
    """
    Getter method for enabled_protocol, mapped from YANG variable /stp/global/state/enabled_protocol (identityref)

    YANG Description: List of the spanning tree protocols enabled on the
device
    """
    return self.__enabled_protocol
      
  def _set_enabled_protocol(self, v, load=False):
    """
    Setter method for enabled_protocol, mapped from YANG variable /stp/global/state/enabled_protocol (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled_protocol is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled_protocol() directly.

    YANG Description: List of the spanning tree protocols enabled on the
device
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},)), is_leaf=False, yang_name="enabled-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled_protocol must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},)), is_leaf=False, yang_name="enabled-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)""",
        })

    self.__enabled_protocol = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled_protocol(self):
    self.__enabled_protocol = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:MSTP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:RAPID_PVST': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},)), is_leaf=False, yang_name="enabled-protocol", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)


  def _get_bridge_assurance(self):
    """
    Getter method for bridge_assurance, mapped from YANG variable /stp/global/state/bridge_assurance (boolean)

    YANG Description: Enable bridge assurance to protect against unidirectional
link failure
    """
    return self.__bridge_assurance
      
  def _set_bridge_assurance(self, v, load=False):
    """
    Setter method for bridge_assurance, mapped from YANG variable /stp/global/state/bridge_assurance (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_assurance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_assurance() directly.

    YANG Description: Enable bridge assurance to protect against unidirectional
link failure
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bridge-assurance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_assurance must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bridge-assurance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)""",
        })

    self.__bridge_assurance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_assurance(self):
    self.__bridge_assurance = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bridge-assurance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)


  def _get_etherchannel_misconfig_guard(self):
    """
    Getter method for etherchannel_misconfig_guard, mapped from YANG variable /stp/global/state/etherchannel_misconfig_guard (boolean)

    YANG Description: EtherChannel guard detects a misconfigured EtherChannel
when interfaces on the switch are configured as an
EtherChannel while interfaces on the other device are not
or when not all the interfaces on the other device are in
the same EtherChannel.
    """
    return self.__etherchannel_misconfig_guard
      
  def _set_etherchannel_misconfig_guard(self, v, load=False):
    """
    Setter method for etherchannel_misconfig_guard, mapped from YANG variable /stp/global/state/etherchannel_misconfig_guard (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_etherchannel_misconfig_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_etherchannel_misconfig_guard() directly.

    YANG Description: EtherChannel guard detects a misconfigured EtherChannel
when interfaces on the switch are configured as an
EtherChannel while interfaces on the other device are not
or when not all the interfaces on the other device are in
the same EtherChannel.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="etherchannel-misconfig-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """etherchannel_misconfig_guard must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="etherchannel-misconfig-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)""",
        })

    self.__etherchannel_misconfig_guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_etherchannel_misconfig_guard(self):
    self.__etherchannel_misconfig_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="etherchannel-misconfig-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)


  def _get_bpduguard_timeout_recovery(self):
    """
    Getter method for bpduguard_timeout_recovery, mapped from YANG variable /stp/global/state/bpduguard_timeout_recovery (uint8)

    YANG Description: Amount of time, in seconds, the interface receiving BPDUs
is disabled. Once the timeout expires, the interface is
brought back into service.
    """
    return self.__bpduguard_timeout_recovery
      
  def _set_bpduguard_timeout_recovery(self, v, load=False):
    """
    Setter method for bpduguard_timeout_recovery, mapped from YANG variable /stp/global/state/bpduguard_timeout_recovery (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpduguard_timeout_recovery is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpduguard_timeout_recovery() directly.

    YANG Description: Amount of time, in seconds, the interface receiving BPDUs
is disabled. Once the timeout expires, the interface is
brought back into service.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="bpduguard-timeout-recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpduguard_timeout_recovery must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="bpduguard-timeout-recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__bpduguard_timeout_recovery = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpduguard_timeout_recovery(self):
    self.__bpduguard_timeout_recovery = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="bpduguard-timeout-recovery", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_loop_guard(self):
    """
    Getter method for loop_guard, mapped from YANG variable /stp/global/state/loop_guard (boolean)

    YANG Description: The loop guard default setting for the bridge
    """
    return self.__loop_guard
      
  def _set_loop_guard(self, v, load=False):
    """
    Setter method for loop_guard, mapped from YANG variable /stp/global/state/loop_guard (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loop_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loop_guard() directly.

    YANG Description: The loop guard default setting for the bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="loop-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loop_guard must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="loop-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)""",
        })

    self.__loop_guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loop_guard(self):
    self.__loop_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="loop-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)


  def _get_bpdu_guard(self):
    """
    Getter method for bpdu_guard, mapped from YANG variable /stp/global/state/bpdu_guard (boolean)

    YANG Description: Enable edge port BPDU guard
    """
    return self.__bpdu_guard
      
  def _set_bpdu_guard(self, v, load=False):
    """
    Setter method for bpdu_guard, mapped from YANG variable /stp/global/state/bpdu_guard (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_guard() directly.

    YANG Description: Enable edge port BPDU guard
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_guard must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)""",
        })

    self.__bpdu_guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_guard(self):
    self.__bpdu_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)


  def _get_bpdu_filter(self):
    """
    Getter method for bpdu_filter, mapped from YANG variable /stp/global/state/bpdu_filter (boolean)

    YANG Description: Enable edge port BPDU filter
    """
    return self.__bpdu_filter
      
  def _set_bpdu_filter(self, v, load=False):
    """
    Setter method for bpdu_filter, mapped from YANG variable /stp/global/state/bpdu_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_filter() directly.

    YANG Description: Enable edge port BPDU filter
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)""",
        })

    self.__bpdu_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_filter(self):
    self.__bpdu_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)

  enabled_protocol = __builtin__.property(_get_enabled_protocol)
  bridge_assurance = __builtin__.property(_get_bridge_assurance)
  etherchannel_misconfig_guard = __builtin__.property(_get_etherchannel_misconfig_guard)
  bpduguard_timeout_recovery = __builtin__.property(_get_bpduguard_timeout_recovery)
  loop_guard = __builtin__.property(_get_loop_guard)
  bpdu_guard = __builtin__.property(_get_bpdu_guard)
  bpdu_filter = __builtin__.property(_get_bpdu_filter)


  _pyangbind_elements = OrderedDict([('enabled_protocol', enabled_protocol), ('bridge_assurance', bridge_assurance), ('etherchannel_misconfig_guard', etherchannel_misconfig_guard), ('bpduguard_timeout_recovery', bpduguard_timeout_recovery), ('loop_guard', loop_guard), ('bpdu_guard', bpdu_guard), ('bpdu_filter', bpdu_filter), ])


class yc_global__openconfig_spanning_tree__stp_global(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/global. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Global configuration and state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'global'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_global_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_global_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'global']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/global/config (container)

    YANG Description: Global spanning tree configuration
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/global/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Global spanning tree configuration
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_global_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_global_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_global_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/global/state (container)

    YANG Description: Global spanning tree state
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/global/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Global spanning tree state
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_global_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_global_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_global_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_spanning_tree__stp_rstp_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rstp/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for RSTP
  """
  __slots__ = ('_path_helper', '_extmethods', '__hello_time','__max_age','__forwarding_delay','__hold_count','__bridge_priority',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rstp', 'config']

  def _get_hello_time(self):
    """
    Getter method for hello_time, mapped from YANG variable /stp/rstp/config/hello_time (uint8)

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    return self.__hello_time
      
  def _set_hello_time(self, v, load=False):
    """
    Setter method for hello_time, mapped from YANG variable /stp/rstp/config/hello_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_time() directly.

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__hello_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_time(self):
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_max_age(self):
    """
    Getter method for max_age, mapped from YANG variable /stp/rstp/config/max_age (uint8)

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    return self.__max_age
      
  def _set_max_age(self, v, load=False):
    """
    Setter method for max_age, mapped from YANG variable /stp/rstp/config/max_age (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_age() directly.

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_age must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__max_age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_age(self):
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_forwarding_delay(self):
    """
    Getter method for forwarding_delay, mapped from YANG variable /stp/rstp/config/forwarding_delay (uint8)

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    return self.__forwarding_delay
      
  def _set_forwarding_delay(self, v, load=False):
    """
    Setter method for forwarding_delay, mapped from YANG variable /stp/rstp/config/forwarding_delay (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_delay() directly.

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_delay must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__forwarding_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_delay(self):
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_hold_count(self):
    """
    Getter method for hold_count, mapped from YANG variable /stp/rstp/config/hold_count (uint8)

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    return self.__hold_count
      
  def _set_hold_count(self, v, load=False):
    """
    Setter method for hold_count, mapped from YANG variable /stp/rstp/config/hold_count (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_count is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_count() directly.

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_count must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__hold_count = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_count(self):
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_bridge_priority(self):
    """
    Getter method for bridge_priority, mapped from YANG variable /stp/rstp/config/bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The manageable component of the Bridge Identifier
    """
    return self.__bridge_priority
      
  def _set_bridge_priority(self, v, load=False):
    """
    Setter method for bridge_priority, mapped from YANG variable /stp/rstp/config/bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_priority() directly.

    YANG Description: The manageable component of the Bridge Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)""",
        })

    self.__bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_priority(self):
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)

  hello_time = __builtin__.property(_get_hello_time, _set_hello_time)
  max_age = __builtin__.property(_get_max_age, _set_max_age)
  forwarding_delay = __builtin__.property(_get_forwarding_delay, _set_forwarding_delay)
  hold_count = __builtin__.property(_get_hold_count, _set_hold_count)
  bridge_priority = __builtin__.property(_get_bridge_priority, _set_bridge_priority)


  _pyangbind_elements = OrderedDict([('hello_time', hello_time), ('max_age', max_age), ('forwarding_delay', forwarding_delay), ('hold_count', hold_count), ('bridge_priority', bridge_priority), ])


class yc_state_openconfig_spanning_tree__stp_rstp_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rstp/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for RSTP
  """
  __slots__ = ('_path_helper', '_extmethods', '__hello_time','__max_age','__forwarding_delay','__hold_count','__bridge_priority','__bridge_address','__designated_root_priority','__designated_root_address','__root_port','__root_cost','__hold_time','__topology_changes','__last_topology_change',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__root_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__root_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__hold_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__topology_changes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__last_topology_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rstp', 'state']

  def _get_hello_time(self):
    """
    Getter method for hello_time, mapped from YANG variable /stp/rstp/state/hello_time (uint8)

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    return self.__hello_time
      
  def _set_hello_time(self, v, load=False):
    """
    Setter method for hello_time, mapped from YANG variable /stp/rstp/state/hello_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_time() directly.

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hello_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_time(self):
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_max_age(self):
    """
    Getter method for max_age, mapped from YANG variable /stp/rstp/state/max_age (uint8)

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    return self.__max_age
      
  def _set_max_age(self, v, load=False):
    """
    Setter method for max_age, mapped from YANG variable /stp/rstp/state/max_age (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_age() directly.

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_age must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__max_age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_age(self):
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_forwarding_delay(self):
    """
    Getter method for forwarding_delay, mapped from YANG variable /stp/rstp/state/forwarding_delay (uint8)

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    return self.__forwarding_delay
      
  def _set_forwarding_delay(self, v, load=False):
    """
    Setter method for forwarding_delay, mapped from YANG variable /stp/rstp/state/forwarding_delay (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_delay() directly.

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_delay must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__forwarding_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_delay(self):
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_hold_count(self):
    """
    Getter method for hold_count, mapped from YANG variable /stp/rstp/state/hold_count (uint8)

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    return self.__hold_count
      
  def _set_hold_count(self, v, load=False):
    """
    Setter method for hold_count, mapped from YANG variable /stp/rstp/state/hold_count (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_count is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_count() directly.

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_count must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hold_count = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_count(self):
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_bridge_priority(self):
    """
    Getter method for bridge_priority, mapped from YANG variable /stp/rstp/state/bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The manageable component of the Bridge Identifier
    """
    return self.__bridge_priority
      
  def _set_bridge_priority(self, v, load=False):
    """
    Setter method for bridge_priority, mapped from YANG variable /stp/rstp/state/bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_priority() directly.

    YANG Description: The manageable component of the Bridge Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_priority(self):
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_bridge_address(self):
    """
    Getter method for bridge_address, mapped from YANG variable /stp/rstp/state/bridge_address (oc-yang:mac-address)

    YANG Description: A unique 48-bit Universally Administered MAC Address
assigned to the bridge
    """
    return self.__bridge_address
      
  def _set_bridge_address(self, v, load=False):
    """
    Setter method for bridge_address, mapped from YANG variable /stp/rstp/state/bridge_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_address() directly.

    YANG Description: A unique 48-bit Universally Administered MAC Address
assigned to the bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__bridge_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_address(self):
    self.__bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_root_priority(self):
    """
    Getter method for designated_root_priority, mapped from YANG variable /stp/rstp/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    return self.__designated_root_priority
      
  def _set_designated_root_priority(self, v, load=False):
    """
    Setter method for designated_root_priority, mapped from YANG variable /stp/rstp/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_priority() directly.

    YANG Description: The bridge priority of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_root_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_priority(self):
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_root_address(self):
    """
    Getter method for designated_root_address, mapped from YANG variable /stp/rstp/state/designated_root_address (oc-yang:mac-address)

    YANG Description: The bridge address of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    return self.__designated_root_address
      
  def _set_designated_root_address(self, v, load=False):
    """
    Setter method for designated_root_address, mapped from YANG variable /stp/rstp/state/designated_root_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_address() directly.

    YANG Description: The bridge address of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_root_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_address(self):
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_root_port(self):
    """
    Getter method for root_port, mapped from YANG variable /stp/rstp/state/root_port (uint16)

    YANG Description: The port number of the port which offers the lowest
cost path from this bridge to the root bridge
    """
    return self.__root_port
      
  def _set_root_port(self, v, load=False):
    """
    Setter method for root_port, mapped from YANG variable /stp/rstp/state/root_port (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_root_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_root_port() directly.

    YANG Description: The port number of the port which offers the lowest
cost path from this bridge to the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """root_port must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__root_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_root_port(self):
    self.__root_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_root_cost(self):
    """
    Getter method for root_cost, mapped from YANG variable /stp/rstp/state/root_cost (uint32)

    YANG Description: The cost of the path to the root as seen from this bridge
    """
    return self.__root_cost
      
  def _set_root_cost(self, v, load=False):
    """
    Setter method for root_cost, mapped from YANG variable /stp/rstp/state/root_cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_root_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_root_cost() directly.

    YANG Description: The cost of the path to the root as seen from this bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """root_cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__root_cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_root_cost(self):
    self.__root_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_hold_time(self):
    """
    Getter method for hold_time, mapped from YANG variable /stp/rstp/state/hold_time (uint8)

    YANG Description: This time value determines the interval length
during which no more than two Configuration bridge
PDUs shall be transmitted by this node
    """
    return self.__hold_time
      
  def _set_hold_time(self, v, load=False):
    """
    Setter method for hold_time, mapped from YANG variable /stp/rstp/state/hold_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_time() directly.

    YANG Description: This time value determines the interval length
during which no more than two Configuration bridge
PDUs shall be transmitted by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hold_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_time(self):
    self.__hold_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_topology_changes(self):
    """
    Getter method for topology_changes, mapped from YANG variable /stp/rstp/state/topology_changes (oc-yang:counter64)

    YANG Description: The total number of topology changes detected by
this bridge since the management entity was last
reset or initialized
    """
    return self.__topology_changes
      
  def _set_topology_changes(self, v, load=False):
    """
    Setter method for topology_changes, mapped from YANG variable /stp/rstp/state/topology_changes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_topology_changes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_topology_changes() directly.

    YANG Description: The total number of topology changes detected by
this bridge since the management entity was last
reset or initialized
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """topology_changes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__topology_changes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_topology_changes(self):
    self.__topology_changes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_last_topology_change(self):
    """
    Getter method for last_topology_change, mapped from YANG variable /stp/rstp/state/last_topology_change (oc-types:timeticks64)

    YANG Description: The time at which the last topology change was
detected by the bridge entity. The value is
expressed relative to the Unix Epoch (Jan 1, 1970
00:00:00 UTC).
    """
    return self.__last_topology_change
      
  def _set_last_topology_change(self, v, load=False):
    """
    Setter method for last_topology_change, mapped from YANG variable /stp/rstp/state/last_topology_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_topology_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_topology_change() directly.

    YANG Description: The time at which the last topology change was
detected by the bridge entity. The value is
expressed relative to the Unix Epoch (Jan 1, 1970
00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_topology_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_topology_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_topology_change(self):
    self.__last_topology_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)

  hello_time = __builtin__.property(_get_hello_time)
  max_age = __builtin__.property(_get_max_age)
  forwarding_delay = __builtin__.property(_get_forwarding_delay)
  hold_count = __builtin__.property(_get_hold_count)
  bridge_priority = __builtin__.property(_get_bridge_priority)
  bridge_address = __builtin__.property(_get_bridge_address)
  designated_root_priority = __builtin__.property(_get_designated_root_priority)
  designated_root_address = __builtin__.property(_get_designated_root_address)
  root_port = __builtin__.property(_get_root_port)
  root_cost = __builtin__.property(_get_root_cost)
  hold_time = __builtin__.property(_get_hold_time)
  topology_changes = __builtin__.property(_get_topology_changes)
  last_topology_change = __builtin__.property(_get_last_topology_change)


  _pyangbind_elements = OrderedDict([('hello_time', hello_time), ('max_age', max_age), ('forwarding_delay', forwarding_delay), ('hold_count', hold_count), ('bridge_priority', bridge_priority), ('bridge_address', bridge_address), ('designated_root_priority', designated_root_priority), ('designated_root_address', designated_root_address), ('root_port', root_port), ('root_cost', root_cost), ('hold_time', hold_time), ('topology_changes', topology_changes), ('last_topology_change', last_topology_change), ])


class yc_config_openconfig_spanning_tree__stp_rstp_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rstp/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for STP on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__cost','__port_priority',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rstp', 'interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/rstp/interfaces/interface/config/name (oc-if:base-interface-ref)

    YANG Description: Reference to the STP ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/rstp/interfaces/interface/config/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the STP ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_cost(self):
    """
    Getter method for cost, mapped from YANG variable /stp/rstp/interfaces/interface/config/cost (uint32)

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    return self.__cost
      
  def _set_cost(self, v, load=False):
    """
    Setter method for cost, mapped from YANG variable /stp/rstp/interfaces/interface/config/cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cost() directly.

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)""",
        })

    self.__cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cost(self):
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)


  def _get_port_priority(self):
    """
    Getter method for port_priority, mapped from YANG variable /stp/rstp/interfaces/interface/config/port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    return self.__port_priority
      
  def _set_port_priority(self, v, load=False):
    """
    Setter method for port_priority, mapped from YANG variable /stp/rstp/interfaces/interface/config/port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_priority() directly.

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)""",
        })

    self.__port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_priority(self):
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  cost = __builtin__.property(_get_cost, _set_cost)
  port_priority = __builtin__.property(_get_port_priority, _set_port_priority)


  _pyangbind_elements = OrderedDict([('name', name), ('cost', cost), ('port_priority', port_priority), ])


class yc_counters_openconfig_spanning_tree__stp_rstp_interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rstp/interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The BPDU packet transmition statistics
  """
  __slots__ = ('_path_helper', '_extmethods', '__bpdu_sent','__bpdu_received',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__bpdu_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__bpdu_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rstp', 'interfaces', 'interface', 'state', 'counters']

  def _get_bpdu_sent(self):
    """
    Getter method for bpdu_sent, mapped from YANG variable /stp/rstp/interfaces/interface/state/counters/bpdu_sent (oc-yang:counter64)

    YANG Description: The number of BPDU packet sent
    """
    return self.__bpdu_sent
      
  def _set_bpdu_sent(self, v, load=False):
    """
    Setter method for bpdu_sent, mapped from YANG variable /stp/rstp/interfaces/interface/state/counters/bpdu_sent (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_sent() directly.

    YANG Description: The number of BPDU packet sent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_sent must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bpdu_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_sent(self):
    self.__bpdu_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_bpdu_received(self):
    """
    Getter method for bpdu_received, mapped from YANG variable /stp/rstp/interfaces/interface/state/counters/bpdu_received (oc-yang:counter64)

    YANG Description: The number of BPDU packet received
    """
    return self.__bpdu_received
      
  def _set_bpdu_received(self, v, load=False):
    """
    Setter method for bpdu_received, mapped from YANG variable /stp/rstp/interfaces/interface/state/counters/bpdu_received (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_received() directly.

    YANG Description: The number of BPDU packet received
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_received must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bpdu_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_received(self):
    self.__bpdu_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)

  bpdu_sent = __builtin__.property(_get_bpdu_sent)
  bpdu_received = __builtin__.property(_get_bpdu_received)


  _pyangbind_elements = OrderedDict([('bpdu_sent', bpdu_sent), ('bpdu_received', bpdu_received), ])


class yc_state_openconfig_spanning_tree__stp_rstp_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rstp/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for STP on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__cost','__port_priority','__port_num','__role','__port_state','__designated_root_priority','__designated_root_address','__designated_cost','__designated_bridge_priority','__designated_bridge_address','__designated_port_priority','__designated_port_num','__forward_transisitions','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    self.__port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    self.__port_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__designated_bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    self.__designated_port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__forward_transisitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_rstp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rstp', 'interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/rstp/interfaces/interface/state/name (oc-if:base-interface-ref)

    YANG Description: Reference to the STP ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/rstp/interfaces/interface/state/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the STP ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_cost(self):
    """
    Getter method for cost, mapped from YANG variable /stp/rstp/interfaces/interface/state/cost (uint32)

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    return self.__cost
      
  def _set_cost(self, v, load=False):
    """
    Setter method for cost, mapped from YANG variable /stp/rstp/interfaces/interface/state/cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cost() directly.

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cost(self):
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_port_priority(self):
    """
    Getter method for port_priority, mapped from YANG variable /stp/rstp/interfaces/interface/state/port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    return self.__port_priority
      
  def _set_port_priority(self, v, load=False):
    """
    Setter method for port_priority, mapped from YANG variable /stp/rstp/interfaces/interface/state/port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_priority() directly.

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)""",
        })

    self.__port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_priority(self):
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)


  def _get_port_num(self):
    """
    Getter method for port_num, mapped from YANG variable /stp/rstp/interfaces/interface/state/port_num (uint16)

    YANG Description: The port number of the bridge port
    """
    return self.__port_num
      
  def _set_port_num(self, v, load=False):
    """
    Setter method for port_num, mapped from YANG variable /stp/rstp/interfaces/interface/state/port_num (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_num is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_num() directly.

    YANG Description: The port number of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_num must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__port_num = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_num(self):
    self.__port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_role(self):
    """
    Getter method for role, mapped from YANG variable /stp/rstp/interfaces/interface/state/role (identityref)

    YANG Description: The current role of the bridge port
    """
    return self.__role
      
  def _set_role(self, v, load=False):
    """
    Setter method for role, mapped from YANG variable /stp/rstp/interfaces/interface/state/role (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_role is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_role() directly.

    YANG Description: The current role of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """role must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)""",
        })

    self.__role = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_role(self):
    self.__role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)


  def _get_port_state(self):
    """
    Getter method for port_state, mapped from YANG variable /stp/rstp/interfaces/interface/state/port_state (identityref)

    YANG Description: The current state of the bridge port
    """
    return self.__port_state
      
  def _set_port_state(self, v, load=False):
    """
    Setter method for port_state, mapped from YANG variable /stp/rstp/interfaces/interface/state/port_state (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_state() directly.

    YANG Description: The current state of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_state must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)""",
        })

    self.__port_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_state(self):
    self.__port_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)


  def _get_designated_root_priority(self):
    """
    Getter method for designated_root_priority, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    return self.__designated_root_priority
      
  def _set_designated_root_priority(self, v, load=False):
    """
    Setter method for designated_root_priority, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_priority() directly.

    YANG Description: The bridge priority of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_root_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_priority(self):
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_root_address(self):
    """
    Getter method for designated_root_address, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_root_address (oc-yang:mac-address)

    YANG Description: The bridge address of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    return self.__designated_root_address
      
  def _set_designated_root_address(self, v, load=False):
    """
    Setter method for designated_root_address, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_root_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_address() directly.

    YANG Description: The bridge address of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_root_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_address(self):
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_cost(self):
    """
    Getter method for designated_cost, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_cost (uint32)

    YANG Description: The path cost of the Designated Port of the
segment connected to this port
    """
    return self.__designated_cost
      
  def _set_designated_cost(self, v, load=False):
    """
    Setter method for designated_cost, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_cost() directly.

    YANG Description: The path cost of the Designated Port of the
segment connected to this port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__designated_cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_cost(self):
    self.__designated_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_designated_bridge_priority(self):
    """
    Getter method for designated_bridge_priority, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    return self.__designated_bridge_priority
      
  def _set_designated_bridge_priority(self, v, load=False):
    """
    Setter method for designated_bridge_priority, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_bridge_priority() directly.

    YANG Description: The bridge priority of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_bridge_priority(self):
    self.__designated_bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_bridge_address(self):
    """
    Getter method for designated_bridge_address, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_bridge_address (oc-yang:mac-address)

    YANG Description: The bridge address of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    return self.__designated_bridge_address
      
  def _set_designated_bridge_address(self, v, load=False):
    """
    Setter method for designated_bridge_address, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_bridge_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_bridge_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_bridge_address() directly.

    YANG Description: The bridge address of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_bridge_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_bridge_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_bridge_address(self):
    self.__designated_bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_port_priority(self):
    """
    Getter method for designated_port_priority, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The Port priority of the port on the Designated
Bridge for this port's segment, two octet string
    """
    return self.__designated_port_priority
      
  def _set_designated_port_priority(self, v, load=False):
    """
    Setter method for designated_port_priority, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_port_priority() directly.

    YANG Description: The Port priority of the port on the Designated
Bridge for this port's segment, two octet string
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)""",
        })

    self.__designated_port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_port_priority(self):
    self.__designated_port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)


  def _get_designated_port_num(self):
    """
    Getter method for designated_port_num, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_port_num (uint16)

    YANG Description: The Port number of the port on the Designated
Bridge for this port's segment, two octet string
    """
    return self.__designated_port_num
      
  def _set_designated_port_num(self, v, load=False):
    """
    Setter method for designated_port_num, mapped from YANG variable /stp/rstp/interfaces/interface/state/designated_port_num (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_port_num is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_port_num() directly.

    YANG Description: The Port number of the port on the Designated
Bridge for this port's segment, two octet string
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_port_num must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__designated_port_num = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_port_num(self):
    self.__designated_port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_forward_transisitions(self):
    """
    Getter method for forward_transisitions, mapped from YANG variable /stp/rstp/interfaces/interface/state/forward_transisitions (oc-yang:counter64)

    YANG Description: The number of times this port has transitioned
from the Learning state to the Forwarding state
    """
    return self.__forward_transisitions
      
  def _set_forward_transisitions(self, v, load=False):
    """
    Setter method for forward_transisitions, mapped from YANG variable /stp/rstp/interfaces/interface/state/forward_transisitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forward_transisitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forward_transisitions() directly.

    YANG Description: The number of times this port has transitioned
from the Learning state to the Forwarding state
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forward_transisitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__forward_transisitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forward_transisitions(self):
    self.__forward_transisitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /stp/rstp/interfaces/interface/state/counters (container)

    YANG Description: The BPDU packet transmition statistics
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /stp/rstp/interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: The BPDU packet transmition statistics
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_spanning_tree__stp_rstp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_rstp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_rstp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  cost = __builtin__.property(_get_cost)
  port_priority = __builtin__.property(_get_port_priority)
  port_num = __builtin__.property(_get_port_num)
  role = __builtin__.property(_get_role)
  port_state = __builtin__.property(_get_port_state)
  designated_root_priority = __builtin__.property(_get_designated_root_priority)
  designated_root_address = __builtin__.property(_get_designated_root_address)
  designated_cost = __builtin__.property(_get_designated_cost)
  designated_bridge_priority = __builtin__.property(_get_designated_bridge_priority)
  designated_bridge_address = __builtin__.property(_get_designated_bridge_address)
  designated_port_priority = __builtin__.property(_get_designated_port_priority)
  designated_port_num = __builtin__.property(_get_designated_port_num)
  forward_transisitions = __builtin__.property(_get_forward_transisitions)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('name', name), ('cost', cost), ('port_priority', port_priority), ('port_num', port_num), ('role', role), ('port_state', port_state), ('designated_root_priority', designated_root_priority), ('designated_root_address', designated_root_address), ('designated_cost', designated_cost), ('designated_bridge_priority', designated_bridge_priority), ('designated_bridge_address', designated_bridge_address), ('designated_port_priority', designated_port_priority), ('designated_port_num', designated_port_num), ('forward_transisitions', forward_transisitions), ('counters', counters), ])


class yc_interface_openconfig_spanning_tree__stp_rstp_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rstp/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which STP is enable
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rstp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rstp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rstp', 'interfaces', 'interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/rstp/interfaces/interface/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/rstp/interfaces/interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/rstp/interfaces/interface/config (container)

    YANG Description: Configuration data for STP on each interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/rstp/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for STP on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_rstp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rstp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rstp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/rstp/interfaces/interface/state (container)

    YANG Description: Operational state data for STP on each interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/rstp/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for STP on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_rstp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rstp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rstp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_interfaces_openconfig_spanning_tree__stp_rstp_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rstp/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interface references
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_rstp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rstp', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /stp/rstp/interfaces/interface (list)

    YANG Description: List of interfaces on which STP is enable
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /stp/rstp/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which STP is enable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_rstp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_rstp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_rstp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_rstp_openconfig_spanning_tree__stp_rstp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rstp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Rapid Spanning-tree protocol configuration and operation
data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__interfaces',)

  _yang_name = 'rstp'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rstp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rstp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_rstp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rstp']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/rstp/config (container)

    YANG Description: Configuration data for RSTP
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/rstp/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for RSTP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_rstp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rstp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rstp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/rstp/state (container)

    YANG Description: Operational state data for RSTP
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/rstp/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for RSTP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_rstp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rstp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rstp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /stp/rstp/interfaces (container)

    YANG Description: Enclosing container for the list of interface references
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /stp/rstp/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the list of interface references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_spanning_tree__stp_rstp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_rstp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_rstp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('interfaces', interfaces), ])


class yc_config_openconfig_spanning_tree__stp_mstp_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for MSTP
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__revision','__max_hop','__hello_time','__max_age','__forwarding_delay','__hold_count',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['1..32']}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='string', is_config=True)
    self.__revision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)
    self.__max_hop = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..255']}), is_leaf=True, yang_name="max-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/mstp/config/name (string)

    YANG Description: The Configuration Name in the MST Configuration Identifier
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/mstp/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The Configuration Name in the MST Configuration Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['1..32']}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['1..32']}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['1..32']}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='string', is_config=True)


  def _get_revision(self):
    """
    Getter method for revision, mapped from YANG variable /stp/mstp/config/revision (uint32)

    YANG Description: The Revision Level in the MST Configuration Identifier
    """
    return self.__revision
      
  def _set_revision(self, v, load=False):
    """
    Setter method for revision, mapped from YANG variable /stp/mstp/config/revision (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_revision is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_revision() directly.

    YANG Description: The Revision Level in the MST Configuration Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """revision must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)""",
        })

    self.__revision = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_revision(self):
    self.__revision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)


  def _get_max_hop(self):
    """
    Getter method for max_hop, mapped from YANG variable /stp/mstp/config/max_hop (uint8)

    YANG Description: The max hop determines the number of bridges in an MST
region that a BPDU can traverse before it is discarded
    """
    return self.__max_hop
      
  def _set_max_hop(self, v, load=False):
    """
    Setter method for max_hop, mapped from YANG variable /stp/mstp/config/max_hop (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_hop() directly.

    YANG Description: The max hop determines the number of bridges in an MST
region that a BPDU can traverse before it is discarded
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..255']}), is_leaf=True, yang_name="max-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_hop must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..255']}), is_leaf=True, yang_name="max-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__max_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_hop(self):
    self.__max_hop = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..255']}), is_leaf=True, yang_name="max-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_hello_time(self):
    """
    Getter method for hello_time, mapped from YANG variable /stp/mstp/config/hello_time (uint8)

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    return self.__hello_time
      
  def _set_hello_time(self, v, load=False):
    """
    Setter method for hello_time, mapped from YANG variable /stp/mstp/config/hello_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_time() directly.

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__hello_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_time(self):
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_max_age(self):
    """
    Getter method for max_age, mapped from YANG variable /stp/mstp/config/max_age (uint8)

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    return self.__max_age
      
  def _set_max_age(self, v, load=False):
    """
    Setter method for max_age, mapped from YANG variable /stp/mstp/config/max_age (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_age() directly.

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_age must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__max_age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_age(self):
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_forwarding_delay(self):
    """
    Getter method for forwarding_delay, mapped from YANG variable /stp/mstp/config/forwarding_delay (uint8)

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    return self.__forwarding_delay
      
  def _set_forwarding_delay(self, v, load=False):
    """
    Setter method for forwarding_delay, mapped from YANG variable /stp/mstp/config/forwarding_delay (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_delay() directly.

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_delay must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__forwarding_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_delay(self):
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_hold_count(self):
    """
    Getter method for hold_count, mapped from YANG variable /stp/mstp/config/hold_count (uint8)

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    return self.__hold_count
      
  def _set_hold_count(self, v, load=False):
    """
    Setter method for hold_count, mapped from YANG variable /stp/mstp/config/hold_count (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_count is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_count() directly.

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_count must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__hold_count = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_count(self):
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  revision = __builtin__.property(_get_revision, _set_revision)
  max_hop = __builtin__.property(_get_max_hop, _set_max_hop)
  hello_time = __builtin__.property(_get_hello_time, _set_hello_time)
  max_age = __builtin__.property(_get_max_age, _set_max_age)
  forwarding_delay = __builtin__.property(_get_forwarding_delay, _set_forwarding_delay)
  hold_count = __builtin__.property(_get_hold_count, _set_hold_count)


  _pyangbind_elements = OrderedDict([('name', name), ('revision', revision), ('max_hop', max_hop), ('hello_time', hello_time), ('max_age', max_age), ('forwarding_delay', forwarding_delay), ('hold_count', hold_count), ])


class yc_state_openconfig_spanning_tree__stp_mstp_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational data for MSTP
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__revision','__max_hop','__hello_time','__max_age','__forwarding_delay','__hold_count',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['1..32']}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='string', is_config=False)
    self.__revision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__max_hop = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..255']}), is_leaf=True, yang_name="max-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/mstp/state/name (string)

    YANG Description: The Configuration Name in the MST Configuration Identifier
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/mstp/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The Configuration Name in the MST Configuration Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['1..32']}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['1..32']}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'length': ['1..32']}), is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='string', is_config=False)


  def _get_revision(self):
    """
    Getter method for revision, mapped from YANG variable /stp/mstp/state/revision (uint32)

    YANG Description: The Revision Level in the MST Configuration Identifier
    """
    return self.__revision
      
  def _set_revision(self, v, load=False):
    """
    Setter method for revision, mapped from YANG variable /stp/mstp/state/revision (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_revision is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_revision() directly.

    YANG Description: The Revision Level in the MST Configuration Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """revision must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__revision = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_revision(self):
    self.__revision = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="revision", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_max_hop(self):
    """
    Getter method for max_hop, mapped from YANG variable /stp/mstp/state/max_hop (uint8)

    YANG Description: The max hop determines the number of bridges in an MST
region that a BPDU can traverse before it is discarded
    """
    return self.__max_hop
      
  def _set_max_hop(self, v, load=False):
    """
    Setter method for max_hop, mapped from YANG variable /stp/mstp/state/max_hop (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_hop() directly.

    YANG Description: The max hop determines the number of bridges in an MST
region that a BPDU can traverse before it is discarded
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..255']}), is_leaf=True, yang_name="max-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_hop must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..255']}), is_leaf=True, yang_name="max-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__max_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_hop(self):
    self.__max_hop = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..255']}), is_leaf=True, yang_name="max-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_hello_time(self):
    """
    Getter method for hello_time, mapped from YANG variable /stp/mstp/state/hello_time (uint8)

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    return self.__hello_time
      
  def _set_hello_time(self, v, load=False):
    """
    Setter method for hello_time, mapped from YANG variable /stp/mstp/state/hello_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_time() directly.

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hello_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_time(self):
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_max_age(self):
    """
    Getter method for max_age, mapped from YANG variable /stp/mstp/state/max_age (uint8)

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    return self.__max_age
      
  def _set_max_age(self, v, load=False):
    """
    Setter method for max_age, mapped from YANG variable /stp/mstp/state/max_age (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_age() directly.

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_age must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__max_age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_age(self):
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_forwarding_delay(self):
    """
    Getter method for forwarding_delay, mapped from YANG variable /stp/mstp/state/forwarding_delay (uint8)

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    return self.__forwarding_delay
      
  def _set_forwarding_delay(self, v, load=False):
    """
    Setter method for forwarding_delay, mapped from YANG variable /stp/mstp/state/forwarding_delay (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_delay() directly.

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_delay must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__forwarding_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_delay(self):
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_hold_count(self):
    """
    Getter method for hold_count, mapped from YANG variable /stp/mstp/state/hold_count (uint8)

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    return self.__hold_count
      
  def _set_hold_count(self, v, load=False):
    """
    Setter method for hold_count, mapped from YANG variable /stp/mstp/state/hold_count (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_count is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_count() directly.

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_count must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hold_count = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_count(self):
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)

  name = __builtin__.property(_get_name)
  revision = __builtin__.property(_get_revision)
  max_hop = __builtin__.property(_get_max_hop)
  hello_time = __builtin__.property(_get_hello_time)
  max_age = __builtin__.property(_get_max_age)
  forwarding_delay = __builtin__.property(_get_forwarding_delay)
  hold_count = __builtin__.property(_get_hold_count)


  _pyangbind_elements = OrderedDict([('name', name), ('revision', revision), ('max_hop', max_hop), ('hello_time', hello_time), ('max_age', max_age), ('forwarding_delay', forwarding_delay), ('hold_count', hold_count), ])


class yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances/mst-instance/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for MSTP instance
  """
  __slots__ = ('_path_helper', '_extmethods', '__mst_id','__vlan','__bridge_priority',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mst_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=True)
    self.__vlan = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])'}),]), is_leaf=False, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='union', is_config=True)
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances', 'mst-instance', 'config']

  def _get_mst_id(self):
    """
    Getter method for mst_id, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/config/mst_id (uint16)

    YANG Description: In an MSTP Bridge, an MSTID, i.e., a value used to identify
a spanning tree (or MST) instance.
    """
    return self.__mst_id
      
  def _set_mst_id(self, v, load=False):
    """
    Setter method for mst_id, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/config/mst_id (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mst_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mst_id() directly.

    YANG Description: In an MSTP Bridge, an MSTID, i.e., a value used to identify
a spanning tree (or MST) instance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mst_id must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=True)""",
        })

    self.__mst_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mst_id(self):
    self.__mst_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=True)


  def _get_vlan(self):
    """
    Getter method for vlan, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/config/vlan (union)

    YANG Description: list of vlans mapped to the MST instance
    """
    return self.__vlan
      
  def _set_vlan(self, v, load=False):
    """
    Setter method for vlan, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/config/vlan (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan() directly.

    YANG Description: list of vlans mapped to the MST instance
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])'}),]), is_leaf=False, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan must be of a type compatible with union""",
          'defined-type': "openconfig-spanning-tree:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])'}),]), is_leaf=False, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='union', is_config=True)""",
        })

    self.__vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan(self):
    self.__vlan = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])'}),]), is_leaf=False, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='union', is_config=True)


  def _get_bridge_priority(self):
    """
    Getter method for bridge_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/config/bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The manageable component of the Bridge Identifier
    """
    return self.__bridge_priority
      
  def _set_bridge_priority(self, v, load=False):
    """
    Setter method for bridge_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/config/bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_priority() directly.

    YANG Description: The manageable component of the Bridge Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)""",
        })

    self.__bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_priority(self):
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)

  mst_id = __builtin__.property(_get_mst_id, _set_mst_id)
  vlan = __builtin__.property(_get_vlan, _set_vlan)
  bridge_priority = __builtin__.property(_get_bridge_priority, _set_bridge_priority)


  _pyangbind_elements = OrderedDict([('mst_id', mst_id), ('vlan', vlan), ('bridge_priority', bridge_priority), ])


class yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances/mst-instance/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational data for MSTP instance
  """
  __slots__ = ('_path_helper', '_extmethods', '__mst_id','__vlan','__bridge_priority','__bridge_address','__designated_root_priority','__designated_root_address','__root_port','__root_cost','__hold_time','__topology_changes','__last_topology_change',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mst_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__vlan = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])'}),]), is_leaf=False, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='union', is_config=False)
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__root_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__root_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__hold_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__topology_changes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__last_topology_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances', 'mst-instance', 'state']

  def _get_mst_id(self):
    """
    Getter method for mst_id, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/mst_id (uint16)

    YANG Description: In an MSTP Bridge, an MSTID, i.e., a value used to identify
a spanning tree (or MST) instance.
    """
    return self.__mst_id
      
  def _set_mst_id(self, v, load=False):
    """
    Setter method for mst_id, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/mst_id (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mst_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mst_id() directly.

    YANG Description: In an MSTP Bridge, an MSTID, i.e., a value used to identify
a spanning tree (or MST) instance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mst_id must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__mst_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mst_id(self):
    self.__mst_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_vlan(self):
    """
    Getter method for vlan, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/vlan (union)

    YANG Description: list of vlans mapped to the MST instance
    """
    return self.__vlan
      
  def _set_vlan(self, v, load=False):
    """
    Setter method for vlan, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/vlan (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan() directly.

    YANG Description: list of vlans mapped to the MST instance
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])'}),]), is_leaf=False, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan must be of a type compatible with union""",
          'defined-type': "openconfig-spanning-tree:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])'}),]), is_leaf=False, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='union', is_config=False)""",
        })

    self.__vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan(self):
    self.__vlan = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])'}),]), is_leaf=False, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='union', is_config=False)


  def _get_bridge_priority(self):
    """
    Getter method for bridge_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The manageable component of the Bridge Identifier
    """
    return self.__bridge_priority
      
  def _set_bridge_priority(self, v, load=False):
    """
    Setter method for bridge_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_priority() directly.

    YANG Description: The manageable component of the Bridge Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_priority(self):
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_bridge_address(self):
    """
    Getter method for bridge_address, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/bridge_address (oc-yang:mac-address)

    YANG Description: A unique 48-bit Universally Administered MAC Address
assigned to the bridge
    """
    return self.__bridge_address
      
  def _set_bridge_address(self, v, load=False):
    """
    Setter method for bridge_address, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/bridge_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_address() directly.

    YANG Description: A unique 48-bit Universally Administered MAC Address
assigned to the bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__bridge_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_address(self):
    self.__bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_root_priority(self):
    """
    Getter method for designated_root_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    return self.__designated_root_priority
      
  def _set_designated_root_priority(self, v, load=False):
    """
    Setter method for designated_root_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_priority() directly.

    YANG Description: The bridge priority of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_root_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_priority(self):
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_root_address(self):
    """
    Getter method for designated_root_address, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/designated_root_address (oc-yang:mac-address)

    YANG Description: The bridge address of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    return self.__designated_root_address
      
  def _set_designated_root_address(self, v, load=False):
    """
    Setter method for designated_root_address, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/designated_root_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_address() directly.

    YANG Description: The bridge address of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_root_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_address(self):
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_root_port(self):
    """
    Getter method for root_port, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/root_port (uint16)

    YANG Description: The port number of the port which offers the lowest
cost path from this bridge to the root bridge
    """
    return self.__root_port
      
  def _set_root_port(self, v, load=False):
    """
    Setter method for root_port, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/root_port (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_root_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_root_port() directly.

    YANG Description: The port number of the port which offers the lowest
cost path from this bridge to the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """root_port must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__root_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_root_port(self):
    self.__root_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_root_cost(self):
    """
    Getter method for root_cost, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/root_cost (uint32)

    YANG Description: The cost of the path to the root as seen from this bridge
    """
    return self.__root_cost
      
  def _set_root_cost(self, v, load=False):
    """
    Setter method for root_cost, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/root_cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_root_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_root_cost() directly.

    YANG Description: The cost of the path to the root as seen from this bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """root_cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__root_cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_root_cost(self):
    self.__root_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_hold_time(self):
    """
    Getter method for hold_time, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/hold_time (uint8)

    YANG Description: This time value determines the interval length
during which no more than two Configuration bridge
PDUs shall be transmitted by this node
    """
    return self.__hold_time
      
  def _set_hold_time(self, v, load=False):
    """
    Setter method for hold_time, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/hold_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_time() directly.

    YANG Description: This time value determines the interval length
during which no more than two Configuration bridge
PDUs shall be transmitted by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hold_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_time(self):
    self.__hold_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_topology_changes(self):
    """
    Getter method for topology_changes, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/topology_changes (oc-yang:counter64)

    YANG Description: The total number of topology changes detected by
this bridge since the management entity was last
reset or initialized
    """
    return self.__topology_changes
      
  def _set_topology_changes(self, v, load=False):
    """
    Setter method for topology_changes, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/topology_changes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_topology_changes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_topology_changes() directly.

    YANG Description: The total number of topology changes detected by
this bridge since the management entity was last
reset or initialized
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """topology_changes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__topology_changes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_topology_changes(self):
    self.__topology_changes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_last_topology_change(self):
    """
    Getter method for last_topology_change, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/last_topology_change (oc-types:timeticks64)

    YANG Description: The time at which the last topology change was
detected by the bridge entity. The value is
expressed relative to the Unix Epoch (Jan 1, 1970
00:00:00 UTC).
    """
    return self.__last_topology_change
      
  def _set_last_topology_change(self, v, load=False):
    """
    Setter method for last_topology_change, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state/last_topology_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_topology_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_topology_change() directly.

    YANG Description: The time at which the last topology change was
detected by the bridge entity. The value is
expressed relative to the Unix Epoch (Jan 1, 1970
00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_topology_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_topology_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_topology_change(self):
    self.__last_topology_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)

  mst_id = __builtin__.property(_get_mst_id)
  vlan = __builtin__.property(_get_vlan)
  bridge_priority = __builtin__.property(_get_bridge_priority)
  bridge_address = __builtin__.property(_get_bridge_address)
  designated_root_priority = __builtin__.property(_get_designated_root_priority)
  designated_root_address = __builtin__.property(_get_designated_root_address)
  root_port = __builtin__.property(_get_root_port)
  root_cost = __builtin__.property(_get_root_cost)
  hold_time = __builtin__.property(_get_hold_time)
  topology_changes = __builtin__.property(_get_topology_changes)
  last_topology_change = __builtin__.property(_get_last_topology_change)


  _pyangbind_elements = OrderedDict([('mst_id', mst_id), ('vlan', vlan), ('bridge_priority', bridge_priority), ('bridge_address', bridge_address), ('designated_root_priority', designated_root_priority), ('designated_root_address', designated_root_address), ('root_port', root_port), ('root_cost', root_cost), ('hold_time', hold_time), ('topology_changes', topology_changes), ('last_topology_change', last_topology_change), ])


class yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances/mst-instance/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for STP on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__cost','__port_priority',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances', 'mst-instance', 'interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/config/name (oc-if:base-interface-ref)

    YANG Description: Reference to the STP ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/config/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the STP ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_cost(self):
    """
    Getter method for cost, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/config/cost (uint32)

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    return self.__cost
      
  def _set_cost(self, v, load=False):
    """
    Setter method for cost, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/config/cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cost() directly.

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)""",
        })

    self.__cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cost(self):
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)


  def _get_port_priority(self):
    """
    Getter method for port_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/config/port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    return self.__port_priority
      
  def _set_port_priority(self, v, load=False):
    """
    Setter method for port_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/config/port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_priority() directly.

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)""",
        })

    self.__port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_priority(self):
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  cost = __builtin__.property(_get_cost, _set_cost)
  port_priority = __builtin__.property(_get_port_priority, _set_port_priority)


  _pyangbind_elements = OrderedDict([('name', name), ('cost', cost), ('port_priority', port_priority), ])


class yc_counters_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances/mst-instance/interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The BPDU packet transmition statistics
  """
  __slots__ = ('_path_helper', '_extmethods', '__bpdu_sent','__bpdu_received',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__bpdu_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__bpdu_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances', 'mst-instance', 'interfaces', 'interface', 'state', 'counters']

  def _get_bpdu_sent(self):
    """
    Getter method for bpdu_sent, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/counters/bpdu_sent (oc-yang:counter64)

    YANG Description: The number of BPDU packet sent
    """
    return self.__bpdu_sent
      
  def _set_bpdu_sent(self, v, load=False):
    """
    Setter method for bpdu_sent, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/counters/bpdu_sent (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_sent() directly.

    YANG Description: The number of BPDU packet sent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_sent must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bpdu_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_sent(self):
    self.__bpdu_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_bpdu_received(self):
    """
    Getter method for bpdu_received, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/counters/bpdu_received (oc-yang:counter64)

    YANG Description: The number of BPDU packet received
    """
    return self.__bpdu_received
      
  def _set_bpdu_received(self, v, load=False):
    """
    Setter method for bpdu_received, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/counters/bpdu_received (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_received() directly.

    YANG Description: The number of BPDU packet received
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_received must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bpdu_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_received(self):
    self.__bpdu_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)

  bpdu_sent = __builtin__.property(_get_bpdu_sent)
  bpdu_received = __builtin__.property(_get_bpdu_received)


  _pyangbind_elements = OrderedDict([('bpdu_sent', bpdu_sent), ('bpdu_received', bpdu_received), ])


class yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances/mst-instance/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for STP on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__cost','__port_priority','__port_num','__role','__port_state','__designated_root_priority','__designated_root_address','__designated_cost','__designated_bridge_priority','__designated_bridge_address','__designated_port_priority','__designated_port_num','__forward_transisitions','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    self.__port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    self.__port_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__designated_bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    self.__designated_port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__forward_transisitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances', 'mst-instance', 'interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/name (oc-if:base-interface-ref)

    YANG Description: Reference to the STP ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the STP ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_cost(self):
    """
    Getter method for cost, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/cost (uint32)

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    return self.__cost
      
  def _set_cost(self, v, load=False):
    """
    Setter method for cost, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cost() directly.

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cost(self):
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_port_priority(self):
    """
    Getter method for port_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    return self.__port_priority
      
  def _set_port_priority(self, v, load=False):
    """
    Setter method for port_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_priority() directly.

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)""",
        })

    self.__port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_priority(self):
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)


  def _get_port_num(self):
    """
    Getter method for port_num, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/port_num (uint16)

    YANG Description: The port number of the bridge port
    """
    return self.__port_num
      
  def _set_port_num(self, v, load=False):
    """
    Setter method for port_num, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/port_num (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_num is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_num() directly.

    YANG Description: The port number of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_num must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__port_num = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_num(self):
    self.__port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_role(self):
    """
    Getter method for role, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/role (identityref)

    YANG Description: The current role of the bridge port
    """
    return self.__role
      
  def _set_role(self, v, load=False):
    """
    Setter method for role, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/role (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_role is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_role() directly.

    YANG Description: The current role of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """role must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)""",
        })

    self.__role = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_role(self):
    self.__role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)


  def _get_port_state(self):
    """
    Getter method for port_state, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/port_state (identityref)

    YANG Description: The current state of the bridge port
    """
    return self.__port_state
      
  def _set_port_state(self, v, load=False):
    """
    Setter method for port_state, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/port_state (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_state() directly.

    YANG Description: The current state of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_state must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)""",
        })

    self.__port_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_state(self):
    self.__port_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)


  def _get_designated_root_priority(self):
    """
    Getter method for designated_root_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    return self.__designated_root_priority
      
  def _set_designated_root_priority(self, v, load=False):
    """
    Setter method for designated_root_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_priority() directly.

    YANG Description: The bridge priority of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_root_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_priority(self):
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_root_address(self):
    """
    Getter method for designated_root_address, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_root_address (oc-yang:mac-address)

    YANG Description: The bridge address of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    return self.__designated_root_address
      
  def _set_designated_root_address(self, v, load=False):
    """
    Setter method for designated_root_address, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_root_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_address() directly.

    YANG Description: The bridge address of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_root_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_address(self):
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_cost(self):
    """
    Getter method for designated_cost, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_cost (uint32)

    YANG Description: The path cost of the Designated Port of the
segment connected to this port
    """
    return self.__designated_cost
      
  def _set_designated_cost(self, v, load=False):
    """
    Setter method for designated_cost, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_cost() directly.

    YANG Description: The path cost of the Designated Port of the
segment connected to this port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__designated_cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_cost(self):
    self.__designated_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_designated_bridge_priority(self):
    """
    Getter method for designated_bridge_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    return self.__designated_bridge_priority
      
  def _set_designated_bridge_priority(self, v, load=False):
    """
    Setter method for designated_bridge_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_bridge_priority() directly.

    YANG Description: The bridge priority of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_bridge_priority(self):
    self.__designated_bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_bridge_address(self):
    """
    Getter method for designated_bridge_address, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_bridge_address (oc-yang:mac-address)

    YANG Description: The bridge address of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    return self.__designated_bridge_address
      
  def _set_designated_bridge_address(self, v, load=False):
    """
    Setter method for designated_bridge_address, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_bridge_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_bridge_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_bridge_address() directly.

    YANG Description: The bridge address of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_bridge_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_bridge_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_bridge_address(self):
    self.__designated_bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_port_priority(self):
    """
    Getter method for designated_port_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The Port priority of the port on the Designated
Bridge for this port's segment, two octet string
    """
    return self.__designated_port_priority
      
  def _set_designated_port_priority(self, v, load=False):
    """
    Setter method for designated_port_priority, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_port_priority() directly.

    YANG Description: The Port priority of the port on the Designated
Bridge for this port's segment, two octet string
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)""",
        })

    self.__designated_port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_port_priority(self):
    self.__designated_port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)


  def _get_designated_port_num(self):
    """
    Getter method for designated_port_num, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_port_num (uint16)

    YANG Description: The Port number of the port on the Designated
Bridge for this port's segment, two octet string
    """
    return self.__designated_port_num
      
  def _set_designated_port_num(self, v, load=False):
    """
    Setter method for designated_port_num, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/designated_port_num (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_port_num is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_port_num() directly.

    YANG Description: The Port number of the port on the Designated
Bridge for this port's segment, two octet string
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_port_num must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__designated_port_num = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_port_num(self):
    self.__designated_port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_forward_transisitions(self):
    """
    Getter method for forward_transisitions, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/forward_transisitions (oc-yang:counter64)

    YANG Description: The number of times this port has transitioned
from the Learning state to the Forwarding state
    """
    return self.__forward_transisitions
      
  def _set_forward_transisitions(self, v, load=False):
    """
    Setter method for forward_transisitions, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/forward_transisitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forward_transisitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forward_transisitions() directly.

    YANG Description: The number of times this port has transitioned
from the Learning state to the Forwarding state
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forward_transisitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__forward_transisitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forward_transisitions(self):
    self.__forward_transisitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/counters (container)

    YANG Description: The BPDU packet transmition statistics
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: The BPDU packet transmition statistics
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  cost = __builtin__.property(_get_cost)
  port_priority = __builtin__.property(_get_port_priority)
  port_num = __builtin__.property(_get_port_num)
  role = __builtin__.property(_get_role)
  port_state = __builtin__.property(_get_port_state)
  designated_root_priority = __builtin__.property(_get_designated_root_priority)
  designated_root_address = __builtin__.property(_get_designated_root_address)
  designated_cost = __builtin__.property(_get_designated_cost)
  designated_bridge_priority = __builtin__.property(_get_designated_bridge_priority)
  designated_bridge_address = __builtin__.property(_get_designated_bridge_address)
  designated_port_priority = __builtin__.property(_get_designated_port_priority)
  designated_port_num = __builtin__.property(_get_designated_port_num)
  forward_transisitions = __builtin__.property(_get_forward_transisitions)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('name', name), ('cost', cost), ('port_priority', port_priority), ('port_num', port_num), ('role', role), ('port_state', port_state), ('designated_root_priority', designated_root_priority), ('designated_root_address', designated_root_address), ('designated_cost', designated_cost), ('designated_bridge_priority', designated_bridge_priority), ('designated_bridge_address', designated_bridge_address), ('designated_port_priority', designated_port_priority), ('designated_port_num', designated_port_num), ('forward_transisitions', forward_transisitions), ('counters', counters), ])


class yc_interface_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances/mst-instance/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which STP is enable
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances', 'mst-instance', 'interfaces', 'interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/config (container)

    YANG Description: Configuration data for STP on each interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for STP on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state (container)

    YANG Description: Operational state data for STP on each interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for STP on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_interfaces_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances/mst-instance/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interface references
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances', 'mst-instance', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface (list)

    YANG Description: List of interfaces on which STP is enable
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which STP is enable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_mst_instance_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances/mst-instance. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of the mstp instances
  """
  __slots__ = ('_path_helper', '_extmethods', '__mst_id','__config','__state','__interfaces',)

  _yang_name = 'mst-instance'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mst_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances', 'mst-instance']

  def _get_mst_id(self):
    """
    Getter method for mst_id, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/mst_id (leafref)

    YANG Description: Reference to the list key
    """
    return self.__mst_id
      
  def _set_mst_id(self, v, load=False):
    """
    Setter method for mst_id, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/mst_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mst_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mst_id() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mst_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)""",
        })

    self.__mst_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mst_id(self):
    self.__mst_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mst-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/config (container)

    YANG Description: Configuration data for MSTP instance
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for MSTP instance
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state (container)

    YANG Description: Operational data for MSTP instance
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational data for MSTP instance
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces (container)

    YANG Description: Enclosing container for the list of interface references
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /stp/mstp/mst_instances/mst_instance/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the list of interface references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  mst_id = __builtin__.property(_get_mst_id, _set_mst_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('mst_id', mst_id), ('config', config), ('state', state), ('interfaces', interfaces), ])


class yc_mst_instances_openconfig_spanning_tree__stp_mstp_mst_instances(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp/mst-instances. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration and operation data for MSTP instances
  """
  __slots__ = ('_path_helper', '_extmethods', '__mst_instance',)

  _yang_name = 'mst-instances'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mst_instance = YANGDynClass(base=YANGListType("mst_id",yc_mst_instance_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance, yang_name="mst-instance", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mst-id', extensions=None), is_container='list', yang_name="mst-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp', 'mst-instances']

  def _get_mst_instance(self):
    """
    Getter method for mst_instance, mapped from YANG variable /stp/mstp/mst_instances/mst_instance (list)

    YANG Description: List of the mstp instances
    """
    return self.__mst_instance
      
  def _set_mst_instance(self, v, load=False):
    """
    Setter method for mst_instance, mapped from YANG variable /stp/mstp/mst_instances/mst_instance (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mst_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mst_instance() directly.

    YANG Description: List of the mstp instances
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("mst_id",yc_mst_instance_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance, yang_name="mst-instance", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mst-id', extensions=None), is_container='list', yang_name="mst-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mst_instance must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("mst_id",yc_mst_instance_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance, yang_name="mst-instance", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mst-id', extensions=None), is_container='list', yang_name="mst-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)""",
        })

    self.__mst_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mst_instance(self):
    self.__mst_instance = YANGDynClass(base=YANGListType("mst_id",yc_mst_instance_openconfig_spanning_tree__stp_mstp_mst_instances_mst_instance, yang_name="mst-instance", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mst-id', extensions=None), is_container='list', yang_name="mst-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

  mst_instance = __builtin__.property(_get_mst_instance, _set_mst_instance)


  _pyangbind_elements = OrderedDict([('mst_instance', mst_instance), ])


class yc_mstp_openconfig_spanning_tree__stp_mstp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/mstp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Multi Spanning-tree protocol configuration and operation
data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__mst_instances',)

  _yang_name = 'mstp'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__mst_instances = YANGDynClass(base=yc_mst_instances_openconfig_spanning_tree__stp_mstp_mst_instances, is_container='container', yang_name="mst-instances", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'mstp']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/mstp/config (container)

    YANG Description: Configuration data for MSTP
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/mstp/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for MSTP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_mstp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_mstp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/mstp/state (container)

    YANG Description: Operational data for MSTP
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/mstp/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational data for MSTP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_mstp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_mstp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_mst_instances(self):
    """
    Getter method for mst_instances, mapped from YANG variable /stp/mstp/mst_instances (container)

    YANG Description: Configuration and operation data for MSTP instances
    """
    return self.__mst_instances
      
  def _set_mst_instances(self, v, load=False):
    """
    Setter method for mst_instances, mapped from YANG variable /stp/mstp/mst_instances (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mst_instances is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mst_instances() directly.

    YANG Description: Configuration and operation data for MSTP instances
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mst_instances_openconfig_spanning_tree__stp_mstp_mst_instances, is_container='container', yang_name="mst-instances", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mst_instances must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mst_instances_openconfig_spanning_tree__stp_mstp_mst_instances, is_container='container', yang_name="mst-instances", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__mst_instances = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mst_instances(self):
    self.__mst_instances = YANGDynClass(base=yc_mst_instances_openconfig_spanning_tree__stp_mstp_mst_instances, is_container='container', yang_name="mst-instances", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  mst_instances = __builtin__.property(_get_mst_instances, _set_mst_instances)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('mst_instances', mst_instances), ])


class yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst/vlan/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for each vlan
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_id','__hello_time','__max_age','__forwarding_delay','__hold_count','__bridge_priority',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-vlan-types:vlan-id', is_config=True)
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst', 'vlan', 'config']

  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /stp/rapid_pvst/vlan/config/vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Interface VLAN ID
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /stp/rapid_pvst/vlan/config/vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: Interface VLAN ID
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-vlan-types:vlan-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-vlan-types:vlan-id', is_config=True)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-vlan-types:vlan-id', is_config=True)


  def _get_hello_time(self):
    """
    Getter method for hello_time, mapped from YANG variable /stp/rapid_pvst/vlan/config/hello_time (uint8)

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    return self.__hello_time
      
  def _set_hello_time(self, v, load=False):
    """
    Setter method for hello_time, mapped from YANG variable /stp/rapid_pvst/vlan/config/hello_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_time() directly.

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__hello_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_time(self):
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_max_age(self):
    """
    Getter method for max_age, mapped from YANG variable /stp/rapid_pvst/vlan/config/max_age (uint8)

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    return self.__max_age
      
  def _set_max_age(self, v, load=False):
    """
    Setter method for max_age, mapped from YANG variable /stp/rapid_pvst/vlan/config/max_age (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_age() directly.

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_age must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__max_age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_age(self):
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_forwarding_delay(self):
    """
    Getter method for forwarding_delay, mapped from YANG variable /stp/rapid_pvst/vlan/config/forwarding_delay (uint8)

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    return self.__forwarding_delay
      
  def _set_forwarding_delay(self, v, load=False):
    """
    Setter method for forwarding_delay, mapped from YANG variable /stp/rapid_pvst/vlan/config/forwarding_delay (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_delay() directly.

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_delay must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__forwarding_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_delay(self):
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_hold_count(self):
    """
    Getter method for hold_count, mapped from YANG variable /stp/rapid_pvst/vlan/config/hold_count (uint8)

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    return self.__hold_count
      
  def _set_hold_count(self, v, load=False):
    """
    Setter method for hold_count, mapped from YANG variable /stp/rapid_pvst/vlan/config/hold_count (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_count is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_count() directly.

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_count must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)""",
        })

    self.__hold_count = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_count(self):
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=True)


  def _get_bridge_priority(self):
    """
    Getter method for bridge_priority, mapped from YANG variable /stp/rapid_pvst/vlan/config/bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The manageable component of the Bridge Identifier
    """
    return self.__bridge_priority
      
  def _set_bridge_priority(self, v, load=False):
    """
    Setter method for bridge_priority, mapped from YANG variable /stp/rapid_pvst/vlan/config/bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_priority() directly.

    YANG Description: The manageable component of the Bridge Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)""",
        })

    self.__bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_priority(self):
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=True)

  vlan_id = __builtin__.property(_get_vlan_id, _set_vlan_id)
  hello_time = __builtin__.property(_get_hello_time, _set_hello_time)
  max_age = __builtin__.property(_get_max_age, _set_max_age)
  forwarding_delay = __builtin__.property(_get_forwarding_delay, _set_forwarding_delay)
  hold_count = __builtin__.property(_get_hold_count, _set_hold_count)
  bridge_priority = __builtin__.property(_get_bridge_priority, _set_bridge_priority)


  _pyangbind_elements = OrderedDict([('vlan_id', vlan_id), ('hello_time', hello_time), ('max_age', max_age), ('forwarding_delay', forwarding_delay), ('hold_count', hold_count), ('bridge_priority', bridge_priority), ])


class yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst/vlan/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational data for each vlan
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_id','__hello_time','__max_age','__forwarding_delay','__hold_count','__bridge_priority','__bridge_address','__designated_root_priority','__designated_root_address','__root_port','__root_cost','__hold_time','__topology_changes','__last_topology_change',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-vlan-types:vlan-id', is_config=False)
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__root_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__root_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__hold_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    self.__topology_changes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__last_topology_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst', 'vlan', 'state']

  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /stp/rapid_pvst/vlan/state/vlan_id (oc-vlan-types:vlan-id)

    YANG Description: Interface VLAN ID
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /stp/rapid_pvst/vlan/state/vlan_id (oc-vlan-types:vlan-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: Interface VLAN ID
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-vlan-types:vlan-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with oc-vlan-types:vlan-id""",
          'defined-type': "oc-vlan-types:vlan-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-vlan-types:vlan-id', is_config=False)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4094']}), is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-vlan-types:vlan-id', is_config=False)


  def _get_hello_time(self):
    """
    Getter method for hello_time, mapped from YANG variable /stp/rapid_pvst/vlan/state/hello_time (uint8)

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    return self.__hello_time
      
  def _set_hello_time(self, v, load=False):
    """
    Setter method for hello_time, mapped from YANG variable /stp/rapid_pvst/vlan/state/hello_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hello_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hello_time() directly.

    YANG Description: The interval between periodic transmissions of
configuration messages by designated ports
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hello_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hello_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hello_time(self):
    self.__hello_time = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), is_leaf=True, yang_name="hello-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_max_age(self):
    """
    Getter method for max_age, mapped from YANG variable /stp/rapid_pvst/vlan/state/max_age (uint8)

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    return self.__max_age
      
  def _set_max_age(self, v, load=False):
    """
    Setter method for max_age, mapped from YANG variable /stp/rapid_pvst/vlan/state/max_age (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_max_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_max_age() directly.

    YANG Description: The maximum age of the information transmitted by the
bridge when it is the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """max_age must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__max_age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_max_age(self):
    self.__max_age = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['6..40']}), is_leaf=True, yang_name="max-age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_forwarding_delay(self):
    """
    Getter method for forwarding_delay, mapped from YANG variable /stp/rapid_pvst/vlan/state/forwarding_delay (uint8)

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    return self.__forwarding_delay
      
  def _set_forwarding_delay(self, v, load=False):
    """
    Setter method for forwarding_delay, mapped from YANG variable /stp/rapid_pvst/vlan/state/forwarding_delay (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forwarding_delay is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forwarding_delay() directly.

    YANG Description: The delay used by STP bridges to transition root and
designated ports to forwarding
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forwarding_delay must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__forwarding_delay = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forwarding_delay(self):
    self.__forwarding_delay = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['4..30']}), is_leaf=True, yang_name="forwarding-delay", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_hold_count(self):
    """
    Getter method for hold_count, mapped from YANG variable /stp/rapid_pvst/vlan/state/hold_count (uint8)

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    return self.__hold_count
      
  def _set_hold_count(self, v, load=False):
    """
    Setter method for hold_count, mapped from YANG variable /stp/rapid_pvst/vlan/state/hold_count (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_count is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_count() directly.

    YANG Description: the maximum number of BPDUs per second that the
switch can send from an interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_count must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hold_count = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_count(self):
    self.__hold_count = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..10']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(6), is_leaf=True, yang_name="hold-count", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_bridge_priority(self):
    """
    Getter method for bridge_priority, mapped from YANG variable /stp/rapid_pvst/vlan/state/bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The manageable component of the Bridge Identifier
    """
    return self.__bridge_priority
      
  def _set_bridge_priority(self, v, load=False):
    """
    Setter method for bridge_priority, mapped from YANG variable /stp/rapid_pvst/vlan/state/bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_priority() directly.

    YANG Description: The manageable component of the Bridge Identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_priority(self):
    self.__bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_bridge_address(self):
    """
    Getter method for bridge_address, mapped from YANG variable /stp/rapid_pvst/vlan/state/bridge_address (oc-yang:mac-address)

    YANG Description: A unique 48-bit Universally Administered MAC Address
assigned to the bridge
    """
    return self.__bridge_address
      
  def _set_bridge_address(self, v, load=False):
    """
    Setter method for bridge_address, mapped from YANG variable /stp/rapid_pvst/vlan/state/bridge_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bridge_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bridge_address() directly.

    YANG Description: A unique 48-bit Universally Administered MAC Address
assigned to the bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bridge_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__bridge_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bridge_address(self):
    self.__bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_root_priority(self):
    """
    Getter method for designated_root_priority, mapped from YANG variable /stp/rapid_pvst/vlan/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    return self.__designated_root_priority
      
  def _set_designated_root_priority(self, v, load=False):
    """
    Setter method for designated_root_priority, mapped from YANG variable /stp/rapid_pvst/vlan/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_priority() directly.

    YANG Description: The bridge priority of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_root_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_priority(self):
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_root_address(self):
    """
    Getter method for designated_root_address, mapped from YANG variable /stp/rapid_pvst/vlan/state/designated_root_address (oc-yang:mac-address)

    YANG Description: The bridge address of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    return self.__designated_root_address
      
  def _set_designated_root_address(self, v, load=False):
    """
    Setter method for designated_root_address, mapped from YANG variable /stp/rapid_pvst/vlan/state/designated_root_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_address() directly.

    YANG Description: The bridge address of the root of the spanning
tree, as determined by the Spanning Tree Protocol,
as executed by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_root_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_address(self):
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_root_port(self):
    """
    Getter method for root_port, mapped from YANG variable /stp/rapid_pvst/vlan/state/root_port (uint16)

    YANG Description: The port number of the port which offers the lowest
cost path from this bridge to the root bridge
    """
    return self.__root_port
      
  def _set_root_port(self, v, load=False):
    """
    Setter method for root_port, mapped from YANG variable /stp/rapid_pvst/vlan/state/root_port (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_root_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_root_port() directly.

    YANG Description: The port number of the port which offers the lowest
cost path from this bridge to the root bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """root_port must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__root_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_root_port(self):
    self.__root_port = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="root-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_root_cost(self):
    """
    Getter method for root_cost, mapped from YANG variable /stp/rapid_pvst/vlan/state/root_cost (uint32)

    YANG Description: The cost of the path to the root as seen from this bridge
    """
    return self.__root_cost
      
  def _set_root_cost(self, v, load=False):
    """
    Setter method for root_cost, mapped from YANG variable /stp/rapid_pvst/vlan/state/root_cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_root_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_root_cost() directly.

    YANG Description: The cost of the path to the root as seen from this bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """root_cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__root_cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_root_cost(self):
    self.__root_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="root-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_hold_time(self):
    """
    Getter method for hold_time, mapped from YANG variable /stp/rapid_pvst/vlan/state/hold_time (uint8)

    YANG Description: This time value determines the interval length
during which no more than two Configuration bridge
PDUs shall be transmitted by this node
    """
    return self.__hold_time
      
  def _set_hold_time(self, v, load=False):
    """
    Setter method for hold_time, mapped from YANG variable /stp/rapid_pvst/vlan/state/hold_time (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hold_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hold_time() directly.

    YANG Description: This time value determines the interval length
during which no more than two Configuration bridge
PDUs shall be transmitted by this node
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hold_time must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)""",
        })

    self.__hold_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hold_time(self):
    self.__hold_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), is_leaf=True, yang_name="hold-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint8', is_config=False)


  def _get_topology_changes(self):
    """
    Getter method for topology_changes, mapped from YANG variable /stp/rapid_pvst/vlan/state/topology_changes (oc-yang:counter64)

    YANG Description: The total number of topology changes detected by
this bridge since the management entity was last
reset or initialized
    """
    return self.__topology_changes
      
  def _set_topology_changes(self, v, load=False):
    """
    Setter method for topology_changes, mapped from YANG variable /stp/rapid_pvst/vlan/state/topology_changes (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_topology_changes is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_topology_changes() directly.

    YANG Description: The total number of topology changes detected by
this bridge since the management entity was last
reset or initialized
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """topology_changes must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__topology_changes = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_topology_changes(self):
    self.__topology_changes = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="topology-changes", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_last_topology_change(self):
    """
    Getter method for last_topology_change, mapped from YANG variable /stp/rapid_pvst/vlan/state/last_topology_change (oc-types:timeticks64)

    YANG Description: The time at which the last topology change was
detected by the bridge entity. The value is
expressed relative to the Unix Epoch (Jan 1, 1970
00:00:00 UTC).
    """
    return self.__last_topology_change
      
  def _set_last_topology_change(self, v, load=False):
    """
    Setter method for last_topology_change, mapped from YANG variable /stp/rapid_pvst/vlan/state/last_topology_change (oc-types:timeticks64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_last_topology_change is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_last_topology_change() directly.

    YANG Description: The time at which the last topology change was
detected by the bridge entity. The value is
expressed relative to the Unix Epoch (Jan 1, 1970
00:00:00 UTC).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """last_topology_change must be of a type compatible with oc-types:timeticks64""",
          'defined-type': "oc-types:timeticks64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)""",
        })

    self.__last_topology_change = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_last_topology_change(self):
    self.__last_topology_change = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="last-topology-change", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-types:timeticks64', is_config=False)

  vlan_id = __builtin__.property(_get_vlan_id)
  hello_time = __builtin__.property(_get_hello_time)
  max_age = __builtin__.property(_get_max_age)
  forwarding_delay = __builtin__.property(_get_forwarding_delay)
  hold_count = __builtin__.property(_get_hold_count)
  bridge_priority = __builtin__.property(_get_bridge_priority)
  bridge_address = __builtin__.property(_get_bridge_address)
  designated_root_priority = __builtin__.property(_get_designated_root_priority)
  designated_root_address = __builtin__.property(_get_designated_root_address)
  root_port = __builtin__.property(_get_root_port)
  root_cost = __builtin__.property(_get_root_cost)
  hold_time = __builtin__.property(_get_hold_time)
  topology_changes = __builtin__.property(_get_topology_changes)
  last_topology_change = __builtin__.property(_get_last_topology_change)


  _pyangbind_elements = OrderedDict([('vlan_id', vlan_id), ('hello_time', hello_time), ('max_age', max_age), ('forwarding_delay', forwarding_delay), ('hold_count', hold_count), ('bridge_priority', bridge_priority), ('bridge_address', bridge_address), ('designated_root_priority', designated_root_priority), ('designated_root_address', designated_root_address), ('root_port', root_port), ('root_cost', root_cost), ('hold_time', hold_time), ('topology_changes', topology_changes), ('last_topology_change', last_topology_change), ])


class yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst/vlan/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for STP on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__cost','__port_priority',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst', 'vlan', 'interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/config/name (oc-if:base-interface-ref)

    YANG Description: Reference to the STP ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/config/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the STP ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_cost(self):
    """
    Getter method for cost, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/config/cost (uint32)

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    return self.__cost
      
  def _set_cost(self, v, load=False):
    """
    Setter method for cost, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/config/cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cost() directly.

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)""",
        })

    self.__cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cost(self):
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=True)


  def _get_port_priority(self):
    """
    Getter method for port_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/config/port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    return self.__port_priority
      
  def _set_port_priority(self, v, load=False):
    """
    Setter method for port_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/config/port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_priority() directly.

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)""",
        })

    self.__port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_priority(self):
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  cost = __builtin__.property(_get_cost, _set_cost)
  port_priority = __builtin__.property(_get_port_priority, _set_port_priority)


  _pyangbind_elements = OrderedDict([('name', name), ('cost', cost), ('port_priority', port_priority), ])


class yc_counters_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst/vlan/interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: The BPDU packet transmition statistics
  """
  __slots__ = ('_path_helper', '_extmethods', '__bpdu_sent','__bpdu_received',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__bpdu_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__bpdu_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst', 'vlan', 'interfaces', 'interface', 'state', 'counters']

  def _get_bpdu_sent(self):
    """
    Getter method for bpdu_sent, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/counters/bpdu_sent (oc-yang:counter64)

    YANG Description: The number of BPDU packet sent
    """
    return self.__bpdu_sent
      
  def _set_bpdu_sent(self, v, load=False):
    """
    Setter method for bpdu_sent, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/counters/bpdu_sent (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_sent() directly.

    YANG Description: The number of BPDU packet sent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_sent must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bpdu_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_sent(self):
    self.__bpdu_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_bpdu_received(self):
    """
    Getter method for bpdu_received, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/counters/bpdu_received (oc-yang:counter64)

    YANG Description: The number of BPDU packet received
    """
    return self.__bpdu_received
      
  def _set_bpdu_received(self, v, load=False):
    """
    Setter method for bpdu_received, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/counters/bpdu_received (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_received() directly.

    YANG Description: The number of BPDU packet received
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_received must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__bpdu_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_received(self):
    self.__bpdu_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bpdu-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)

  bpdu_sent = __builtin__.property(_get_bpdu_sent)
  bpdu_received = __builtin__.property(_get_bpdu_received)


  _pyangbind_elements = OrderedDict([('bpdu_sent', bpdu_sent), ('bpdu_received', bpdu_received), ])


class yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst/vlan/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for STP on each interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__cost','__port_priority','__port_num','__role','__port_state','__designated_root_priority','__designated_root_address','__designated_cost','__designated_bridge_priority','__designated_bridge_address','__designated_port_priority','__designated_port_num','__forward_transisitions','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    self.__port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    self.__port_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    self.__designated_bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    self.__designated_bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    self.__designated_port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    self.__designated_port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    self.__forward_transisitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst', 'vlan', 'interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/name (oc-if:base-interface-ref)

    YANG Description: Reference to the STP ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the STP ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_cost(self):
    """
    Getter method for cost, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/cost (uint32)

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    return self.__cost
      
  def _set_cost(self, v, load=False):
    """
    Setter method for cost, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_cost() directly.

    YANG Description: The port's contribution, when it is the Root Port,
to the Root Path Cost for the Bridge
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_cost(self):
    self.__cost = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..200000000']}), is_leaf=True, yang_name="cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_port_priority(self):
    """
    Getter method for port_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    return self.__port_priority
      
  def _set_port_priority(self, v, load=False):
    """
    Setter method for port_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_priority() directly.

    YANG Description: The manageable component of the Port Identifier,
also known as the Port Priority
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)""",
        })

    self.__port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_priority(self):
    self.__port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)


  def _get_port_num(self):
    """
    Getter method for port_num, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/port_num (uint16)

    YANG Description: The port number of the bridge port
    """
    return self.__port_num
      
  def _set_port_num(self, v, load=False):
    """
    Setter method for port_num, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/port_num (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_num is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_num() directly.

    YANG Description: The port number of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_num must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__port_num = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_num(self):
    self.__port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_role(self):
    """
    Getter method for role, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/role (identityref)

    YANG Description: The current role of the bridge port
    """
    return self.__role
      
  def _set_role(self, v, load=False):
    """
    Setter method for role, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/role (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_role is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_role() directly.

    YANG Description: The current role of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """role must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)""",
        })

    self.__role = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_role(self):
    self.__role = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ROOT': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DESIGNATED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:ALTERNATE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BACKUP': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="role", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)


  def _get_port_state(self):
    """
    Getter method for port_state, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/port_state (identityref)

    YANG Description: The current state of the bridge port
    """
    return self.__port_state
      
  def _set_port_state(self, v, load=False):
    """
    Setter method for port_state, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/port_state (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_port_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_port_state() directly.

    YANG Description: The current state of the bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """port_state must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)""",
        })

    self.__port_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_port_state(self):
    self.__port_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:DISABLED': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LISTENING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:LEARNING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:BLOCKING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:FORWARDING': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="port-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)


  def _get_designated_root_priority(self):
    """
    Getter method for designated_root_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    return self.__designated_root_priority
      
  def _set_designated_root_priority(self, v, load=False):
    """
    Setter method for designated_root_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_root_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_priority() directly.

    YANG Description: The bridge priority of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_root_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_priority(self):
    self.__designated_root_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-root-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_root_address(self):
    """
    Getter method for designated_root_address, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_root_address (oc-yang:mac-address)

    YANG Description: The bridge address of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    return self.__designated_root_address
      
  def _set_designated_root_address(self, v, load=False):
    """
    Setter method for designated_root_address, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_root_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_root_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_root_address() directly.

    YANG Description: The bridge address of the bridge recorded as the
root in the configuration BPDUs transmitted by the designated
bridge for the segment to which the port is attached
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_root_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_root_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_root_address(self):
    self.__designated_root_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-root-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_cost(self):
    """
    Getter method for designated_cost, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_cost (uint32)

    YANG Description: The path cost of the Designated Port of the
segment connected to this port
    """
    return self.__designated_cost
      
  def _set_designated_cost(self, v, load=False):
    """
    Setter method for designated_cost, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_cost (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_cost is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_cost() directly.

    YANG Description: The path cost of the Designated Port of the
segment connected to this port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_cost must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)""",
        })

    self.__designated_cost = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_cost(self):
    self.__designated_cost = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="designated-cost", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint32', is_config=False)


  def _get_designated_bridge_priority(self):
    """
    Getter method for designated_bridge_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_bridge_priority (oc-stp-types:stp-bridge-priority-type)

    YANG Description: The bridge priority of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    return self.__designated_bridge_priority
      
  def _set_designated_bridge_priority(self, v, load=False):
    """
    Setter method for designated_bridge_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_bridge_priority (oc-stp-types:stp-bridge-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_bridge_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_bridge_priority() directly.

    YANG Description: The bridge priority of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_bridge_priority must be of a type compatible with oc-stp-types:stp-bridge-priority-type""",
          'defined-type': "oc-stp-types:stp-bridge-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)""",
        })

    self.__designated_bridge_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_bridge_priority(self):
    self.__designated_bridge_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..61440']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(32768), is_leaf=True, yang_name="designated-bridge-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-bridge-priority-type', is_config=False)


  def _get_designated_bridge_address(self):
    """
    Getter method for designated_bridge_address, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_bridge_address (oc-yang:mac-address)

    YANG Description: The bridge address of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    return self.__designated_bridge_address
      
  def _set_designated_bridge_address(self, v, load=False):
    """
    Setter method for designated_bridge_address, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_bridge_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_bridge_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_bridge_address() directly.

    YANG Description: The bridge address of the bridge that this port considers
to be the designated bridge for this port's segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_bridge_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__designated_bridge_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_bridge_address(self):
    self.__designated_bridge_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="designated-bridge-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:mac-address', is_config=False)


  def _get_designated_port_priority(self):
    """
    Getter method for designated_port_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_port_priority (oc-stp-types:stp-port-priority-type)

    YANG Description: The Port priority of the port on the Designated
Bridge for this port's segment, two octet string
    """
    return self.__designated_port_priority
      
  def _set_designated_port_priority(self, v, load=False):
    """
    Setter method for designated_port_priority, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_port_priority (oc-stp-types:stp-port-priority-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_port_priority is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_port_priority() directly.

    YANG Description: The Port priority of the port on the Designated
Bridge for this port's segment, two octet string
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_port_priority must be of a type compatible with oc-stp-types:stp-port-priority-type""",
          'defined-type': "oc-stp-types:stp-port-priority-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)""",
        })

    self.__designated_port_priority = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_port_priority(self):
    self.__designated_port_priority = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['1..240']}), is_leaf=True, yang_name="designated-port-priority", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-port-priority-type', is_config=False)


  def _get_designated_port_num(self):
    """
    Getter method for designated_port_num, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_port_num (uint16)

    YANG Description: The Port number of the port on the Designated
Bridge for this port's segment, two octet string
    """
    return self.__designated_port_num
      
  def _set_designated_port_num(self, v, load=False):
    """
    Setter method for designated_port_num, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/designated_port_num (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_designated_port_num is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_designated_port_num() directly.

    YANG Description: The Port number of the port on the Designated
Bridge for this port's segment, two octet string
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """designated_port_num must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)""",
        })

    self.__designated_port_num = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_designated_port_num(self):
    self.__designated_port_num = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="designated-port-num", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='uint16', is_config=False)


  def _get_forward_transisitions(self):
    """
    Getter method for forward_transisitions, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/forward_transisitions (oc-yang:counter64)

    YANG Description: The number of times this port has transitioned
from the Learning state to the Forwarding state
    """
    return self.__forward_transisitions
      
  def _set_forward_transisitions(self, v, load=False):
    """
    Setter method for forward_transisitions, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/forward_transisitions (oc-yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_forward_transisitions is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_forward_transisitions() directly.

    YANG Description: The number of times this port has transitioned
from the Learning state to the Forwarding state
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """forward_transisitions must be of a type compatible with oc-yang:counter64""",
          'defined-type': "oc-yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)""",
        })

    self.__forward_transisitions = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_forward_transisitions(self):
    self.__forward_transisitions = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="forward-transisitions", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-yang:counter64', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/counters (container)

    YANG Description: The BPDU packet transmition statistics
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: The BPDU packet transmition statistics
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=False)

  name = __builtin__.property(_get_name)
  cost = __builtin__.property(_get_cost)
  port_priority = __builtin__.property(_get_port_priority)
  port_num = __builtin__.property(_get_port_num)
  role = __builtin__.property(_get_role)
  port_state = __builtin__.property(_get_port_state)
  designated_root_priority = __builtin__.property(_get_designated_root_priority)
  designated_root_address = __builtin__.property(_get_designated_root_address)
  designated_cost = __builtin__.property(_get_designated_cost)
  designated_bridge_priority = __builtin__.property(_get_designated_bridge_priority)
  designated_bridge_address = __builtin__.property(_get_designated_bridge_address)
  designated_port_priority = __builtin__.property(_get_designated_port_priority)
  designated_port_num = __builtin__.property(_get_designated_port_num)
  forward_transisitions = __builtin__.property(_get_forward_transisitions)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('name', name), ('cost', cost), ('port_priority', port_priority), ('port_num', port_num), ('role', role), ('port_state', port_state), ('designated_root_priority', designated_root_priority), ('designated_root_address', designated_root_address), ('designated_cost', designated_cost), ('designated_bridge_priority', designated_bridge_priority), ('designated_bridge_address', designated_bridge_address), ('designated_port_priority', designated_port_priority), ('designated_port_num', designated_port_num), ('forward_transisitions', forward_transisitions), ('counters', counters), ])


class yc_interface_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst/vlan/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which STP is enable
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst', 'vlan', 'interfaces', 'interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/config (container)

    YANG Description: Configuration data for STP on each interface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for STP on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state (container)

    YANG Description: Operational state data for STP on each interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for STP on each interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_interfaces_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst/vlan/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interface references
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst', 'vlan', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface (list)

    YANG Description: List of interfaces on which STP is enable
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which STP is enable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_vlan_openconfig_spanning_tree__stp_rapid_pvst_vlan(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst/vlan. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of the vlans
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan_id','__config','__state','__interfaces',)

  _yang_name = 'vlan'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst', 'vlan']

  def _get_vlan_id(self):
    """
    Getter method for vlan_id, mapped from YANG variable /stp/rapid_pvst/vlan/vlan_id (leafref)

    YANG Description: Reference to the list key
    """
    return self.__vlan_id
      
  def _set_vlan_id(self, v, load=False):
    """
    Setter method for vlan_id, mapped from YANG variable /stp/rapid_pvst/vlan/vlan_id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan_id() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan_id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)""",
        })

    self.__vlan_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan_id(self):
    self.__vlan_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/rapid_pvst/vlan/config (container)

    YANG Description: Configuration data for each vlan
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/rapid_pvst/vlan/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for each vlan
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_rapid_pvst_vlan_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/rapid_pvst/vlan/state (container)

    YANG Description: Operational data for each vlan
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/rapid_pvst/vlan/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational data for each vlan
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_rapid_pvst_vlan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces (container)

    YANG Description: Enclosing container for the list of interface references
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /stp/rapid_pvst/vlan/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the list of interface references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_rapid_pvst_vlan_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  vlan_id = __builtin__.property(_get_vlan_id, _set_vlan_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('vlan_id', vlan_id), ('config', config), ('state', state), ('interfaces', interfaces), ])


class yc_rapid_pvst_openconfig_spanning_tree__stp_rapid_pvst(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/rapid-pvst. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Rapid per vlan Spanning-tree protocol configuration and
operational data
  """
  __slots__ = ('_path_helper', '_extmethods', '__vlan',)

  _yang_name = 'rapid-pvst'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vlan = YANGDynClass(base=YANGListType("vlan_id",yc_vlan_openconfig_spanning_tree__stp_rapid_pvst_vlan, yang_name="vlan", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='vlan-id', extensions=None), is_container='list', yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'rapid-pvst']

  def _get_vlan(self):
    """
    Getter method for vlan, mapped from YANG variable /stp/rapid_pvst/vlan (list)

    YANG Description: List of the vlans
    """
    return self.__vlan
      
  def _set_vlan(self, v, load=False):
    """
    Setter method for vlan, mapped from YANG variable /stp/rapid_pvst/vlan (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan() directly.

    YANG Description: List of the vlans
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("vlan_id",yc_vlan_openconfig_spanning_tree__stp_rapid_pvst_vlan, yang_name="vlan", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='vlan-id', extensions=None), is_container='list', yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("vlan_id",yc_vlan_openconfig_spanning_tree__stp_rapid_pvst_vlan, yang_name="vlan", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='vlan-id', extensions=None), is_container='list', yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)""",
        })

    self.__vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan(self):
    self.__vlan = YANGDynClass(base=YANGListType("vlan_id",yc_vlan_openconfig_spanning_tree__stp_rapid_pvst_vlan, yang_name="vlan", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='vlan-id', extensions=None), is_container='list', yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

  vlan = __builtin__.property(_get_vlan, _set_vlan)


  _pyangbind_elements = OrderedDict([('vlan', vlan), ])


class yc_config_openconfig_spanning_tree__stp_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for STP on each bridge port
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__edge_port','__link_type','__guard','__bpdu_guard','__bpdu_filter',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)
    self.__edge_port = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="edge-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=True)
    self.__link_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'P2P': {}, 'SHARED': {}},), is_leaf=True, yang_name="link-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-link-type', is_config=True)
    self.__guard = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ROOT': {}, 'LOOP': {}, 'NONE': {}},), is_leaf=True, yang_name="guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-guard-type', is_config=True)
    self.__bpdu_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    self.__bpdu_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/interfaces/interface/config/name (oc-if:base-interface-ref)

    YANG Description: Reference to the STP Ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/interfaces/interface/config/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the STP Ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=True)


  def _get_edge_port(self):
    """
    Getter method for edge_port, mapped from YANG variable /stp/interfaces/interface/config/edge_port (identityref)

    YANG Description: Configure the edge port state
    """
    return self.__edge_port
      
  def _set_edge_port(self, v, load=False):
    """
    Setter method for edge_port, mapped from YANG variable /stp/interfaces/interface/config/edge_port (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_edge_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_edge_port() directly.

    YANG Description: Configure the edge port state
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="edge-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """edge_port must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="edge-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=True)""",
        })

    self.__edge_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_edge_port(self):
    self.__edge_port = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="edge-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=True)


  def _get_link_type(self):
    """
    Getter method for link_type, mapped from YANG variable /stp/interfaces/interface/config/link_type (oc-stp-types:stp-link-type)

    YANG Description: specifies the interface's link type
    """
    return self.__link_type
      
  def _set_link_type(self, v, load=False):
    """
    Setter method for link_type, mapped from YANG variable /stp/interfaces/interface/config/link_type (oc-stp-types:stp-link-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_type() directly.

    YANG Description: specifies the interface's link type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'P2P': {}, 'SHARED': {}},), is_leaf=True, yang_name="link-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-link-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_type must be of a type compatible with oc-stp-types:stp-link-type""",
          'defined-type': "oc-stp-types:stp-link-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'P2P': {}, 'SHARED': {}},), is_leaf=True, yang_name="link-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-link-type', is_config=True)""",
        })

    self.__link_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_type(self):
    self.__link_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'P2P': {}, 'SHARED': {}},), is_leaf=True, yang_name="link-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-link-type', is_config=True)


  def _get_guard(self):
    """
    Getter method for guard, mapped from YANG variable /stp/interfaces/interface/config/guard (oc-stp-types:stp-guard-type)

    YANG Description: Enable root guard or loop guard
    """
    return self.__guard
      
  def _set_guard(self, v, load=False):
    """
    Setter method for guard, mapped from YANG variable /stp/interfaces/interface/config/guard (oc-stp-types:stp-guard-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_guard() directly.

    YANG Description: Enable root guard or loop guard
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ROOT': {}, 'LOOP': {}, 'NONE': {}},), is_leaf=True, yang_name="guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-guard-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """guard must be of a type compatible with oc-stp-types:stp-guard-type""",
          'defined-type': "oc-stp-types:stp-guard-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ROOT': {}, 'LOOP': {}, 'NONE': {}},), is_leaf=True, yang_name="guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-guard-type', is_config=True)""",
        })

    self.__guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_guard(self):
    self.__guard = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ROOT': {}, 'LOOP': {}, 'NONE': {}},), is_leaf=True, yang_name="guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-guard-type', is_config=True)


  def _get_bpdu_guard(self):
    """
    Getter method for bpdu_guard, mapped from YANG variable /stp/interfaces/interface/config/bpdu_guard (boolean)

    YANG Description: Enable edge port BPDU guard
    """
    return self.__bpdu_guard
      
  def _set_bpdu_guard(self, v, load=False):
    """
    Setter method for bpdu_guard, mapped from YANG variable /stp/interfaces/interface/config/bpdu_guard (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_guard() directly.

    YANG Description: Enable edge port BPDU guard
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_guard must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)""",
        })

    self.__bpdu_guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_guard(self):
    self.__bpdu_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)


  def _get_bpdu_filter(self):
    """
    Getter method for bpdu_filter, mapped from YANG variable /stp/interfaces/interface/config/bpdu_filter (boolean)

    YANG Description: Enable edge port BPDU filter
    """
    return self.__bpdu_filter
      
  def _set_bpdu_filter(self, v, load=False):
    """
    Setter method for bpdu_filter, mapped from YANG variable /stp/interfaces/interface/config/bpdu_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_filter() directly.

    YANG Description: Enable edge port BPDU filter
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)""",
        })

    self.__bpdu_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_filter(self):
    self.__bpdu_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  edge_port = __builtin__.property(_get_edge_port, _set_edge_port)
  link_type = __builtin__.property(_get_link_type, _set_link_type)
  guard = __builtin__.property(_get_guard, _set_guard)
  bpdu_guard = __builtin__.property(_get_bpdu_guard, _set_bpdu_guard)
  bpdu_filter = __builtin__.property(_get_bpdu_filter, _set_bpdu_filter)


  _pyangbind_elements = OrderedDict([('name', name), ('edge_port', edge_port), ('link_type', link_type), ('guard', guard), ('bpdu_guard', bpdu_guard), ('bpdu_filter', bpdu_filter), ])


class yc_state_openconfig_spanning_tree__stp_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for STP on each bridge port
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__edge_port','__link_type','__guard','__bpdu_guard','__bpdu_filter',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)
    self.__edge_port = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="edge-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    self.__link_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'P2P': {}, 'SHARED': {}},), is_leaf=True, yang_name="link-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-link-type', is_config=False)
    self.__guard = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ROOT': {}, 'LOOP': {}, 'NONE': {}},), is_leaf=True, yang_name="guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-guard-type', is_config=False)
    self.__bpdu_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    self.__bpdu_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'interfaces', 'interface', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/interfaces/interface/state/name (oc-if:base-interface-ref)

    YANG Description: Reference to the STP Ethernet interface
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/interfaces/interface/state/name (oc-if:base-interface-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the STP Ethernet interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with oc-if:base-interface-ref""",
          'defined-type': "oc-if:base-interface-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-if:base-interface-ref', is_config=False)


  def _get_edge_port(self):
    """
    Getter method for edge_port, mapped from YANG variable /stp/interfaces/interface/state/edge_port (identityref)

    YANG Description: Configure the edge port state
    """
    return self.__edge_port
      
  def _set_edge_port(self, v, load=False):
    """
    Setter method for edge_port, mapped from YANG variable /stp/interfaces/interface/state/edge_port (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_edge_port is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_edge_port() directly.

    YANG Description: Configure the edge port state
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="edge-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """edge_port must be of a type compatible with identityref""",
          'defined-type': "openconfig-spanning-tree:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="edge-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)""",
        })

    self.__edge_port = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_edge_port(self):
    self.__edge_port = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_ENABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_DISABLE': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}, 'oc-stp-types:EDGE_AUTO': {'@module': 'openconfig-spanning-tree-types', '@namespace': 'http://openconfig.net/yang/spanning-tree/types'}},), is_leaf=True, yang_name="edge-port", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='identityref', is_config=False)


  def _get_link_type(self):
    """
    Getter method for link_type, mapped from YANG variable /stp/interfaces/interface/state/link_type (oc-stp-types:stp-link-type)

    YANG Description: specifies the interface's link type
    """
    return self.__link_type
      
  def _set_link_type(self, v, load=False):
    """
    Setter method for link_type, mapped from YANG variable /stp/interfaces/interface/state/link_type (oc-stp-types:stp-link-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_link_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_link_type() directly.

    YANG Description: specifies the interface's link type
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'P2P': {}, 'SHARED': {}},), is_leaf=True, yang_name="link-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-link-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """link_type must be of a type compatible with oc-stp-types:stp-link-type""",
          'defined-type': "oc-stp-types:stp-link-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'P2P': {}, 'SHARED': {}},), is_leaf=True, yang_name="link-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-link-type', is_config=False)""",
        })

    self.__link_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_link_type(self):
    self.__link_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'P2P': {}, 'SHARED': {}},), is_leaf=True, yang_name="link-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-link-type', is_config=False)


  def _get_guard(self):
    """
    Getter method for guard, mapped from YANG variable /stp/interfaces/interface/state/guard (oc-stp-types:stp-guard-type)

    YANG Description: Enable root guard or loop guard
    """
    return self.__guard
      
  def _set_guard(self, v, load=False):
    """
    Setter method for guard, mapped from YANG variable /stp/interfaces/interface/state/guard (oc-stp-types:stp-guard-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_guard() directly.

    YANG Description: Enable root guard or loop guard
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ROOT': {}, 'LOOP': {}, 'NONE': {}},), is_leaf=True, yang_name="guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-guard-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """guard must be of a type compatible with oc-stp-types:stp-guard-type""",
          'defined-type': "oc-stp-types:stp-guard-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ROOT': {}, 'LOOP': {}, 'NONE': {}},), is_leaf=True, yang_name="guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-guard-type', is_config=False)""",
        })

    self.__guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_guard(self):
    self.__guard = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'ROOT': {}, 'LOOP': {}, 'NONE': {}},), is_leaf=True, yang_name="guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='oc-stp-types:stp-guard-type', is_config=False)


  def _get_bpdu_guard(self):
    """
    Getter method for bpdu_guard, mapped from YANG variable /stp/interfaces/interface/state/bpdu_guard (boolean)

    YANG Description: Enable edge port BPDU guard
    """
    return self.__bpdu_guard
      
  def _set_bpdu_guard(self, v, load=False):
    """
    Setter method for bpdu_guard, mapped from YANG variable /stp/interfaces/interface/state/bpdu_guard (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_guard is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_guard() directly.

    YANG Description: Enable edge port BPDU guard
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_guard must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)""",
        })

    self.__bpdu_guard = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_guard(self):
    self.__bpdu_guard = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-guard", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)


  def _get_bpdu_filter(self):
    """
    Getter method for bpdu_filter, mapped from YANG variable /stp/interfaces/interface/state/bpdu_filter (boolean)

    YANG Description: Enable edge port BPDU filter
    """
    return self.__bpdu_filter
      
  def _set_bpdu_filter(self, v, load=False):
    """
    Setter method for bpdu_filter, mapped from YANG variable /stp/interfaces/interface/state/bpdu_filter (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bpdu_filter is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bpdu_filter() directly.

    YANG Description: Enable edge port BPDU filter
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bpdu_filter must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)""",
        })

    self.__bpdu_filter = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bpdu_filter(self):
    self.__bpdu_filter = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="bpdu-filter", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='boolean', is_config=False)

  name = __builtin__.property(_get_name)
  edge_port = __builtin__.property(_get_edge_port)
  link_type = __builtin__.property(_get_link_type)
  guard = __builtin__.property(_get_guard)
  bpdu_guard = __builtin__.property(_get_bpdu_guard)
  bpdu_filter = __builtin__.property(_get_bpdu_filter)


  _pyangbind_elements = OrderedDict([('name', name), ('edge_port', edge_port), ('link_type', link_type), ('guard', guard), ('bpdu_guard', bpdu_guard), ('bpdu_filter', bpdu_filter), ])


class yc_interface_openconfig_spanning_tree__stp_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which STP is enable
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'interfaces', 'interface']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /stp/interfaces/interface/name (leafref)

    YANG Description: Reference to the list key
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /stp/interfaces/interface/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Reference to the list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /stp/interfaces/interface/config (container)

    YANG Description: Configuration data for STP on each bridge port
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /stp/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for STP on each bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_spanning_tree__stp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_spanning_tree__stp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /stp/interfaces/interface/state (container)

    YANG Description: Operational state data for STP on each bridge port
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /stp/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for STP on each bridge port
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_spanning_tree__stp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_spanning_tree__stp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('name', name), ('config', config), ('state', state), ])


class yc_interfaces_openconfig_spanning_tree__stp_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interface references
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /stp/interfaces/interface (list)

    YANG Description: List of interfaces on which STP is enable
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /stp/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which STP is enable
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("name",yc_interface_openconfig_spanning_tree__stp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='name', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_stp_openconfig_spanning_tree__stp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /stp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for spanning tree configuration and
state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__global_','__rstp','__mstp','__rapid_pvst','__interfaces',)

  _yang_name = 'stp'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__global_ = YANGDynClass(base=yc_global__openconfig_spanning_tree__stp_global, is_container='container', yang_name="global", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__rstp = YANGDynClass(base=yc_rstp_openconfig_spanning_tree__stp_rstp, is_container='container', yang_name="rstp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__mstp = YANGDynClass(base=yc_mstp_openconfig_spanning_tree__stp_mstp, is_container='container', yang_name="mstp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__rapid_pvst = YANGDynClass(base=yc_rapid_pvst_openconfig_spanning_tree__stp_rapid_pvst, is_container='container', yang_name="rapid-pvst", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['stp']

  def _get_global_(self):
    """
    Getter method for global_, mapped from YANG variable /stp/global (container)

    YANG Description: Global configuration and state data
    """
    return self.__global_
      
  def _set_global_(self, v, load=False):
    """
    Setter method for global_, mapped from YANG variable /stp/global (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_global_ is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_global_() directly.

    YANG Description: Global configuration and state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_global__openconfig_spanning_tree__stp_global, is_container='container', yang_name="global", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """global_ must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_global__openconfig_spanning_tree__stp_global, is_container='container', yang_name="global", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__global_ = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_global_(self):
    self.__global_ = YANGDynClass(base=yc_global__openconfig_spanning_tree__stp_global, is_container='container', yang_name="global", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_rstp(self):
    """
    Getter method for rstp, mapped from YANG variable /stp/rstp (container)

    YANG Description: Rapid Spanning-tree protocol configuration and operation
data
    """
    return self.__rstp
      
  def _set_rstp(self, v, load=False):
    """
    Setter method for rstp, mapped from YANG variable /stp/rstp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rstp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rstp() directly.

    YANG Description: Rapid Spanning-tree protocol configuration and operation
data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_rstp_openconfig_spanning_tree__stp_rstp, is_container='container', yang_name="rstp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rstp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_rstp_openconfig_spanning_tree__stp_rstp, is_container='container', yang_name="rstp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__rstp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rstp(self):
    self.__rstp = YANGDynClass(base=yc_rstp_openconfig_spanning_tree__stp_rstp, is_container='container', yang_name="rstp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_mstp(self):
    """
    Getter method for mstp, mapped from YANG variable /stp/mstp (container)

    YANG Description: Multi Spanning-tree protocol configuration and operation
data
    """
    return self.__mstp
      
  def _set_mstp(self, v, load=False):
    """
    Setter method for mstp, mapped from YANG variable /stp/mstp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mstp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mstp() directly.

    YANG Description: Multi Spanning-tree protocol configuration and operation
data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mstp_openconfig_spanning_tree__stp_mstp, is_container='container', yang_name="mstp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mstp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mstp_openconfig_spanning_tree__stp_mstp, is_container='container', yang_name="mstp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__mstp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mstp(self):
    self.__mstp = YANGDynClass(base=yc_mstp_openconfig_spanning_tree__stp_mstp, is_container='container', yang_name="mstp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_rapid_pvst(self):
    """
    Getter method for rapid_pvst, mapped from YANG variable /stp/rapid_pvst (container)

    YANG Description: Rapid per vlan Spanning-tree protocol configuration and
operational data
    """
    return self.__rapid_pvst
      
  def _set_rapid_pvst(self, v, load=False):
    """
    Setter method for rapid_pvst, mapped from YANG variable /stp/rapid_pvst (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_rapid_pvst is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_rapid_pvst() directly.

    YANG Description: Rapid per vlan Spanning-tree protocol configuration and
operational data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_rapid_pvst_openconfig_spanning_tree__stp_rapid_pvst, is_container='container', yang_name="rapid-pvst", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """rapid_pvst must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_rapid_pvst_openconfig_spanning_tree__stp_rapid_pvst, is_container='container', yang_name="rapid-pvst", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__rapid_pvst = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_rapid_pvst(self):
    self.__rapid_pvst = YANGDynClass(base=yc_rapid_pvst_openconfig_spanning_tree__stp_rapid_pvst, is_container='container', yang_name="rapid-pvst", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /stp/interfaces (container)

    YANG Description: Enclosing container for the list of interface references
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /stp/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the list of interface references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_spanning_tree__stp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_spanning_tree__stp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  global_ = __builtin__.property(_get_global_, _set_global_)
  rstp = __builtin__.property(_get_rstp, _set_rstp)
  mstp = __builtin__.property(_get_mstp, _set_mstp)
  rapid_pvst = __builtin__.property(_get_rapid_pvst, _set_rapid_pvst)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('global_', global_), ('rstp', rstp), ('mstp', mstp), ('rapid_pvst', rapid_pvst), ('interfaces', interfaces), ])


class openconfig_spanning_tree(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-spanning-tree - based on the path /openconfig-spanning-tree. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines configuration and operational state data
for the spanning tree protocol.
  """
  __slots__ = ('_path_helper', '_extmethods', '__stp',)

  _yang_name = 'openconfig-spanning-tree'
  _yang_namespace = 'http://openconfig.net/yang/spanning-tree'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__stp = YANGDynClass(base=yc_stp_openconfig_spanning_tree__stp, is_container='container', yang_name="stp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_stp(self):
    """
    Getter method for stp, mapped from YANG variable /stp (container)

    YANG Description: Top-level container for spanning tree configuration and
state data
    """
    return self.__stp
      
  def _set_stp(self, v, load=False):
    """
    Setter method for stp, mapped from YANG variable /stp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_stp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_stp() directly.

    YANG Description: Top-level container for spanning tree configuration and
state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_stp_openconfig_spanning_tree__stp, is_container='container', yang_name="stp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """stp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_stp_openconfig_spanning_tree__stp, is_container='container', yang_name="stp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)""",
        })

    self.__stp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_stp(self):
    self.__stp = YANGDynClass(base=yc_stp_openconfig_spanning_tree__stp, is_container='container', yang_name="stp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/spanning-tree', defining_module='openconfig-spanning-tree', yang_type='container', is_config=True)

  stp = __builtin__.property(_get_stp, _set_stp)


  _pyangbind_elements = OrderedDict([('stp', stp), ])


