# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class openconfig_network_instance_l3(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance-l3 - based on the path /openconfig-network-instance-l3. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module contains groupings which specifically relate to
Layer 3 network instance configuration and operational state
parameters.
  """
  _pyangbind_elements = {}

  

class openconfig_route_summary(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-route-summary - based on the path /openconfig-route-summary. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module provides summary of route counts per route type for each network
instance.
  """
  _pyangbind_elements = {}

  

class openconfig_network_instance_policy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance-policy - based on the path /openconfig-network-instance-policy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module defines routing policy statements (conditions and
actions) for the network instance model.  These statements are
generally added to the routing policy model.
  """
  _pyangbind_elements = {}

  

class yc_config_openconfig_network_instance__network_instances_network_instance_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to a network
instance
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__description','__router_id','__route_distinguisher','__fallback_network_instance',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    self.__router_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="router-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:dotted-quad', is_config=True)
    self.__route_distinguisher = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-ni-types:route-distinguisher', is_config=True)
    self.__fallback_network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="fallback-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='network-instance-ref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /network_instances/network_instance/config/name (string)

    YANG Description: An operator-assigned unique name for the network instance.
If the operator does not designate a name for the instance of
type 'DEFAULT_INSTANCE' (e.g. config), the implementation
should use the name of 'DEFAULT' (e.g. state).
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /network_instances/network_instance/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: An operator-assigned unique name for the network instance.
If the operator does not designate a name for the instance of
type 'DEFAULT_INSTANCE' (e.g. config), the implementation
should use the name of 'DEFAULT' (e.g. state).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /network_instances/network_instance/config/type (identityref)

    YANG Description: The type of network instance. The value of this leaf
indicates the type of forwarding entries that should be
supported by this network instance. Signalling protocols also
use the network instance type to infer the type of service
they advertise; for example MPLS signalling for an L2VSI
network instance would infer a VPLS service whereas a type of
L2PTP would infer a VPWS (pseudo-wire) service.

An implementation must support only a single network-instance
of type 'DEFAULT_INSTANCE'.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /network_instances/network_instance/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type of network instance. The value of this leaf
indicates the type of forwarding entries that should be
supported by this network instance. Signalling protocols also
use the network instance type to infer the type of service
they advertise; for example MPLS signalling for an L2VSI
network instance would infer a VPLS service whereas a type of
L2PTP would infer a VPWS (pseudo-wire) service.

An implementation must support only a single network-instance
of type 'DEFAULT_INSTANCE'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-network-instance:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /network_instances/network_instance/config/description (string)

    YANG Description: A free-form string to be used by the network operator to
describe the function of this network instance
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /network_instances/network_instance/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A free-form string to be used by the network operator to
describe the function of this network instance
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)


  def _get_router_id(self):
    """
    Getter method for router_id, mapped from YANG variable /network_instances/network_instance/config/router_id (oc-yang:dotted-quad)

    YANG Description: A identifier for the local network instance - typically
used within associated routing protocols or signalling
routing information in another network instance
    """
    return self.__router_id
      
  def _set_router_id(self, v, load=False):
    """
    Setter method for router_id, mapped from YANG variable /network_instances/network_instance/config/router_id (oc-yang:dotted-quad)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_router_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_router_id() directly.

    YANG Description: A identifier for the local network instance - typically
used within associated routing protocols or signalling
routing information in another network instance
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="router-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:dotted-quad', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """router_id must be of a type compatible with oc-yang:dotted-quad""",
          'defined-type': "oc-yang:dotted-quad",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="router-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:dotted-quad', is_config=True)""",
        })

    self.__router_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_router_id(self):
    self.__router_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="router-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:dotted-quad', is_config=True)


  def _get_route_distinguisher(self):
    """
    Getter method for route_distinguisher, mapped from YANG variable /network_instances/network_instance/config/route_distinguisher (oc-ni-types:route-distinguisher)

    YANG Description: The route distinguisher that should be used for the local
VRF or VSI instance when it is signalled via BGP.
    """
    return self.__route_distinguisher
      
  def _set_route_distinguisher(self, v, load=False):
    """
    Setter method for route_distinguisher, mapped from YANG variable /network_instances/network_instance/config/route_distinguisher (oc-ni-types:route-distinguisher)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_route_distinguisher is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_route_distinguisher() directly.

    YANG Description: The route distinguisher that should be used for the local
VRF or VSI instance when it is signalled via BGP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-ni-types:route-distinguisher', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """route_distinguisher must be of a type compatible with oc-ni-types:route-distinguisher""",
          'defined-type': "oc-ni-types:route-distinguisher",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-ni-types:route-distinguisher', is_config=True)""",
        })

    self.__route_distinguisher = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_route_distinguisher(self):
    self.__route_distinguisher = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-ni-types:route-distinguisher', is_config=True)


  def _get_fallback_network_instance(self):
    """
    Getter method for fallback_network_instance, mapped from YANG variable /network_instances/network_instance/config/fallback_network_instance (network-instance-ref)

    YANG Description: When this leaf is populated, the specified network instance
should be used as a fallback instance when a route cannot
be resolved in the local network-instance.
This configuration is only valid when specified in a non-default
instance which must be a L3 capable VRF (i.e., L2L3, or L3VRF).
    """
    return self.__fallback_network_instance
      
  def _set_fallback_network_instance(self, v, load=False):
    """
    Setter method for fallback_network_instance, mapped from YANG variable /network_instances/network_instance/config/fallback_network_instance (network-instance-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fallback_network_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fallback_network_instance() directly.

    YANG Description: When this leaf is populated, the specified network instance
should be used as a fallback instance when a route cannot
be resolved in the local network-instance.
This configuration is only valid when specified in a non-default
instance which must be a L3 capable VRF (i.e., L2L3, or L3VRF).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="fallback-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='network-instance-ref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fallback_network_instance must be of a type compatible with network-instance-ref""",
          'defined-type': "openconfig-network-instance:network-instance-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="fallback-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='network-instance-ref', is_config=True)""",
        })

    self.__fallback_network_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fallback_network_instance(self):
    self.__fallback_network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="fallback-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='network-instance-ref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  description = __builtin__.property(_get_description, _set_description)
  router_id = __builtin__.property(_get_router_id, _set_router_id)
  route_distinguisher = __builtin__.property(_get_route_distinguisher, _set_route_distinguisher)
  fallback_network_instance = __builtin__.property(_get_fallback_network_instance, _set_fallback_network_instance)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('description', description), ('router_id', router_id), ('route_distinguisher', route_distinguisher), ('fallback_network_instance', fallback_network_instance), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to a network
instance
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__description','__router_id','__route_distinguisher','__fallback_network_instance',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    self.__router_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="router-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:dotted-quad', is_config=False)
    self.__route_distinguisher = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-ni-types:route-distinguisher', is_config=False)
    self.__fallback_network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="fallback-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='network-instance-ref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /network_instances/network_instance/state/name (string)

    YANG Description: An operator-assigned unique name for the network instance.
If the operator does not designate a name for the instance of
type 'DEFAULT_INSTANCE' (e.g. config), the implementation
should use the name of 'DEFAULT' (e.g. state).
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /network_instances/network_instance/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: An operator-assigned unique name for the network instance.
If the operator does not designate a name for the instance of
type 'DEFAULT_INSTANCE' (e.g. config), the implementation
should use the name of 'DEFAULT' (e.g. state).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /network_instances/network_instance/state/type (identityref)

    YANG Description: The type of network instance. The value of this leaf
indicates the type of forwarding entries that should be
supported by this network instance. Signalling protocols also
use the network instance type to infer the type of service
they advertise; for example MPLS signalling for an L2VSI
network instance would infer a VPLS service whereas a type of
L2PTP would infer a VPWS (pseudo-wire) service.

An implementation must support only a single network-instance
of type 'DEFAULT_INSTANCE'.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /network_instances/network_instance/state/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type of network instance. The value of this leaf
indicates the type of forwarding entries that should be
supported by this network instance. Signalling protocols also
use the network instance type to infer the type of service
they advertise; for example MPLS signalling for an L2VSI
network instance would infer a VPLS service whereas a type of
L2PTP would infer a VPWS (pseudo-wire) service.

An implementation must support only a single network-instance
of type 'DEFAULT_INSTANCE'.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-network-instance:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:DEFAULT_INSTANCE': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L3VRF': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2VSI': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2P2P': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:L2L3': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /network_instances/network_instance/state/description (string)

    YANG Description: A free-form string to be used by the network operator to
describe the function of this network instance
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /network_instances/network_instance/state/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A free-form string to be used by the network operator to
describe the function of this network instance
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)


  def _get_router_id(self):
    """
    Getter method for router_id, mapped from YANG variable /network_instances/network_instance/state/router_id (oc-yang:dotted-quad)

    YANG Description: A identifier for the local network instance - typically
used within associated routing protocols or signalling
routing information in another network instance
    """
    return self.__router_id
      
  def _set_router_id(self, v, load=False):
    """
    Setter method for router_id, mapped from YANG variable /network_instances/network_instance/state/router_id (oc-yang:dotted-quad)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_router_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_router_id() directly.

    YANG Description: A identifier for the local network instance - typically
used within associated routing protocols or signalling
routing information in another network instance
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="router-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:dotted-quad', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """router_id must be of a type compatible with oc-yang:dotted-quad""",
          'defined-type': "oc-yang:dotted-quad",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="router-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:dotted-quad', is_config=False)""",
        })

    self.__router_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_router_id(self):
    self.__router_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}), is_leaf=True, yang_name="router-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:dotted-quad', is_config=False)


  def _get_route_distinguisher(self):
    """
    Getter method for route_distinguisher, mapped from YANG variable /network_instances/network_instance/state/route_distinguisher (oc-ni-types:route-distinguisher)

    YANG Description: The route distinguisher that should be used for the local
VRF or VSI instance when it is signalled via BGP.
    """
    return self.__route_distinguisher
      
  def _set_route_distinguisher(self, v, load=False):
    """
    Setter method for route_distinguisher, mapped from YANG variable /network_instances/network_instance/state/route_distinguisher (oc-ni-types:route-distinguisher)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_route_distinguisher is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_route_distinguisher() directly.

    YANG Description: The route distinguisher that should be used for the local
VRF or VSI instance when it is signalled via BGP.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-ni-types:route-distinguisher', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """route_distinguisher must be of a type compatible with oc-ni-types:route-distinguisher""",
          'defined-type': "oc-ni-types:route-distinguisher",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-ni-types:route-distinguisher', is_config=False)""",
        })

    self.__route_distinguisher = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_route_distinguisher(self):
    self.__route_distinguisher = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-ni-types:route-distinguisher', is_config=False)


  def _get_fallback_network_instance(self):
    """
    Getter method for fallback_network_instance, mapped from YANG variable /network_instances/network_instance/state/fallback_network_instance (network-instance-ref)

    YANG Description: When this leaf is populated, the specified network instance
should be used as a fallback instance when a route cannot
be resolved in the local network-instance.
This configuration is only valid when specified in a non-default
instance which must be a L3 capable VRF (i.e., L2L3, or L3VRF).
    """
    return self.__fallback_network_instance
      
  def _set_fallback_network_instance(self, v, load=False):
    """
    Setter method for fallback_network_instance, mapped from YANG variable /network_instances/network_instance/state/fallback_network_instance (network-instance-ref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_fallback_network_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_fallback_network_instance() directly.

    YANG Description: When this leaf is populated, the specified network instance
should be used as a fallback instance when a route cannot
be resolved in the local network-instance.
This configuration is only valid when specified in a non-default
instance which must be a L3 capable VRF (i.e., L2L3, or L3VRF).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="fallback-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='network-instance-ref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """fallback_network_instance must be of a type compatible with network-instance-ref""",
          'defined-type': "openconfig-network-instance:network-instance-ref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="fallback-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='network-instance-ref', is_config=False)""",
        })

    self.__fallback_network_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_fallback_network_instance(self):
    self.__fallback_network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="fallback-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='network-instance-ref', is_config=False)

  name = __builtin__.property(_get_name)
  type = __builtin__.property(_get_type)
  description = __builtin__.property(_get_description)
  router_id = __builtin__.property(_get_router_id)
  route_distinguisher = __builtin__.property(_get_route_distinguisher)
  fallback_network_instance = __builtin__.property(_get_fallback_network_instance)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('description', description), ('router_id', router_id), ('route_distinguisher', route_distinguisher), ('fallback_network_instance', fallback_network_instance), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_fdb_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters relating to the FDB
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_learning','__mac_aging_time','__maximum_entries','__anycast_gateway_mac','__flood_unknown_unicast_supression',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_learning = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-learning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    self.__mac_aging_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mac-aging-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    self.__maximum_entries = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="maximum-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    self.__anycast_gateway_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="anycast-gateway-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)
    self.__flood_unknown_unicast_supression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="flood-unknown-unicast-supression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'config']

  def _get_mac_learning(self):
    """
    Getter method for mac_learning, mapped from YANG variable /network_instances/network_instance/fdb/config/mac_learning (boolean)

    YANG Description: When this leaf is set to true, MAC learning is enabled for
the network instance, such that MAC addresses are learned
from ingress frames and added to the FDB.
    """
    return self.__mac_learning
      
  def _set_mac_learning(self, v, load=False):
    """
    Setter method for mac_learning, mapped from YANG variable /network_instances/network_instance/fdb/config/mac_learning (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_learning is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_learning() directly.

    YANG Description: When this leaf is set to true, MAC learning is enabled for
the network instance, such that MAC addresses are learned
from ingress frames and added to the FDB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="mac-learning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_learning must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-learning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__mac_learning = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_learning(self):
    self.__mac_learning = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-learning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)


  def _get_mac_aging_time(self):
    """
    Getter method for mac_aging_time, mapped from YANG variable /network_instances/network_instance/fdb/config/mac_aging_time (uint16)

    YANG Description: The number of seconds of inactivity after which the entry
in the local FDB is timed out.
    """
    return self.__mac_aging_time
      
  def _set_mac_aging_time(self, v, load=False):
    """
    Setter method for mac_aging_time, mapped from YANG variable /network_instances/network_instance/fdb/config/mac_aging_time (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_aging_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_aging_time() directly.

    YANG Description: The number of seconds of inactivity after which the entry
in the local FDB is timed out.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mac-aging-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_aging_time must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mac-aging-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__mac_aging_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_aging_time(self):
    self.__mac_aging_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mac-aging-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)


  def _get_maximum_entries(self):
    """
    Getter method for maximum_entries, mapped from YANG variable /network_instances/network_instance/fdb/config/maximum_entries (uint16)

    YANG Description: The maximum number of MAC address entries that should be
accepted into the FDB
    """
    return self.__maximum_entries
      
  def _set_maximum_entries(self, v, load=False):
    """
    Setter method for maximum_entries, mapped from YANG variable /network_instances/network_instance/fdb/config/maximum_entries (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maximum_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maximum_entries() directly.

    YANG Description: The maximum number of MAC address entries that should be
accepted into the FDB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="maximum-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maximum_entries must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="maximum-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__maximum_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maximum_entries(self):
    self.__maximum_entries = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="maximum-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)


  def _get_anycast_gateway_mac(self):
    """
    Getter method for anycast_gateway_mac, mapped from YANG variable /network_instances/network_instance/fdb/config/anycast_gateway_mac (oc-yang:mac-address)

    YANG Description: Configure the anycast gateway MAC address that all VTEPs
use for the network instance. When a VM sends an Address
Resolution Protocol (ARP) request for the anycast gateway
IP address in a VXLAN virtual network, the VTEP responds
with the configured anycast MAC address.
    """
    return self.__anycast_gateway_mac
      
  def _set_anycast_gateway_mac(self, v, load=False):
    """
    Setter method for anycast_gateway_mac, mapped from YANG variable /network_instances/network_instance/fdb/config/anycast_gateway_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_anycast_gateway_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_anycast_gateway_mac() directly.

    YANG Description: Configure the anycast gateway MAC address that all VTEPs
use for the network instance. When a VM sends an Address
Resolution Protocol (ARP) request for the anycast gateway
IP address in a VXLAN virtual network, the VTEP responds
with the configured anycast MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="anycast-gateway-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """anycast_gateway_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="anycast-gateway-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__anycast_gateway_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_anycast_gateway_mac(self):
    self.__anycast_gateway_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="anycast-gateway-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)


  def _get_flood_unknown_unicast_supression(self):
    """
    Getter method for flood_unknown_unicast_supression, mapped from YANG variable /network_instances/network_instance/fdb/config/flood_unknown_unicast_supression (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) the Unknown Unicast Flooding
Suppression. If the Unknown Unicast Flooding Suppression is on,
the unicast traffic towards an unknown host will be dropped.
    """
    return self.__flood_unknown_unicast_supression
      
  def _set_flood_unknown_unicast_supression(self, v, load=False):
    """
    Setter method for flood_unknown_unicast_supression, mapped from YANG variable /network_instances/network_instance/fdb/config/flood_unknown_unicast_supression (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_flood_unknown_unicast_supression is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_flood_unknown_unicast_supression() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) the Unknown Unicast Flooding
Suppression. If the Unknown Unicast Flooding Suppression is on,
the unicast traffic towards an unknown host will be dropped.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="flood-unknown-unicast-supression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """flood_unknown_unicast_supression must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="flood-unknown-unicast-supression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__flood_unknown_unicast_supression = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_flood_unknown_unicast_supression(self):
    self.__flood_unknown_unicast_supression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="flood-unknown-unicast-supression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)

  mac_learning = __builtin__.property(_get_mac_learning, _set_mac_learning)
  mac_aging_time = __builtin__.property(_get_mac_aging_time, _set_mac_aging_time)
  maximum_entries = __builtin__.property(_get_maximum_entries, _set_maximum_entries)
  anycast_gateway_mac = __builtin__.property(_get_anycast_gateway_mac, _set_anycast_gateway_mac)
  flood_unknown_unicast_supression = __builtin__.property(_get_flood_unknown_unicast_supression, _set_flood_unknown_unicast_supression)


  _pyangbind_elements = OrderedDict([('mac_learning', mac_learning), ('mac_aging_time', mac_aging_time), ('maximum_entries', maximum_entries), ('anycast_gateway_mac', anycast_gateway_mac), ('flood_unknown_unicast_supression', flood_unknown_unicast_supression), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state parameters relating to the FDB
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_learning','__mac_aging_time','__maximum_entries','__anycast_gateway_mac','__flood_unknown_unicast_supression',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_learning = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-learning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__mac_aging_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mac-aging-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    self.__maximum_entries = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="maximum-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    self.__anycast_gateway_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="anycast-gateway-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    self.__flood_unknown_unicast_supression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="flood-unknown-unicast-supression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'state']

  def _get_mac_learning(self):
    """
    Getter method for mac_learning, mapped from YANG variable /network_instances/network_instance/fdb/state/mac_learning (boolean)

    YANG Description: When this leaf is set to true, MAC learning is enabled for
the network instance, such that MAC addresses are learned
from ingress frames and added to the FDB.
    """
    return self.__mac_learning
      
  def _set_mac_learning(self, v, load=False):
    """
    Setter method for mac_learning, mapped from YANG variable /network_instances/network_instance/fdb/state/mac_learning (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_learning is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_learning() directly.

    YANG Description: When this leaf is set to true, MAC learning is enabled for
the network instance, such that MAC addresses are learned
from ingress frames and added to the FDB.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="mac-learning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_learning must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-learning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__mac_learning = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_learning(self):
    self.__mac_learning = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-learning", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_mac_aging_time(self):
    """
    Getter method for mac_aging_time, mapped from YANG variable /network_instances/network_instance/fdb/state/mac_aging_time (uint16)

    YANG Description: The number of seconds of inactivity after which the entry
in the local FDB is timed out.
    """
    return self.__mac_aging_time
      
  def _set_mac_aging_time(self, v, load=False):
    """
    Setter method for mac_aging_time, mapped from YANG variable /network_instances/network_instance/fdb/state/mac_aging_time (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_aging_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_aging_time() directly.

    YANG Description: The number of seconds of inactivity after which the entry
in the local FDB is timed out.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mac-aging-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_aging_time must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mac-aging-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__mac_aging_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_aging_time(self):
    self.__mac_aging_time = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mac-aging-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)


  def _get_maximum_entries(self):
    """
    Getter method for maximum_entries, mapped from YANG variable /network_instances/network_instance/fdb/state/maximum_entries (uint16)

    YANG Description: The maximum number of MAC address entries that should be
accepted into the FDB
    """
    return self.__maximum_entries
      
  def _set_maximum_entries(self, v, load=False):
    """
    Setter method for maximum_entries, mapped from YANG variable /network_instances/network_instance/fdb/state/maximum_entries (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maximum_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maximum_entries() directly.

    YANG Description: The maximum number of MAC address entries that should be
accepted into the FDB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="maximum-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maximum_entries must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="maximum-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__maximum_entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maximum_entries(self):
    self.__maximum_entries = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="maximum-entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)


  def _get_anycast_gateway_mac(self):
    """
    Getter method for anycast_gateway_mac, mapped from YANG variable /network_instances/network_instance/fdb/state/anycast_gateway_mac (oc-yang:mac-address)

    YANG Description: Configure the anycast gateway MAC address that all VTEPs
use for the network instance. When a VM sends an Address
Resolution Protocol (ARP) request for the anycast gateway
IP address in a VXLAN virtual network, the VTEP responds
with the configured anycast MAC address.
    """
    return self.__anycast_gateway_mac
      
  def _set_anycast_gateway_mac(self, v, load=False):
    """
    Setter method for anycast_gateway_mac, mapped from YANG variable /network_instances/network_instance/fdb/state/anycast_gateway_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_anycast_gateway_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_anycast_gateway_mac() directly.

    YANG Description: Configure the anycast gateway MAC address that all VTEPs
use for the network instance. When a VM sends an Address
Resolution Protocol (ARP) request for the anycast gateway
IP address in a VXLAN virtual network, the VTEP responds
with the configured anycast MAC address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="anycast-gateway-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """anycast_gateway_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="anycast-gateway-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__anycast_gateway_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_anycast_gateway_mac(self):
    self.__anycast_gateway_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="anycast-gateway-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)


  def _get_flood_unknown_unicast_supression(self):
    """
    Getter method for flood_unknown_unicast_supression, mapped from YANG variable /network_instances/network_instance/fdb/state/flood_unknown_unicast_supression (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) the Unknown Unicast Flooding
Suppression. If the Unknown Unicast Flooding Suppression is on,
the unicast traffic towards an unknown host will be dropped.
    """
    return self.__flood_unknown_unicast_supression
      
  def _set_flood_unknown_unicast_supression(self, v, load=False):
    """
    Setter method for flood_unknown_unicast_supression, mapped from YANG variable /network_instances/network_instance/fdb/state/flood_unknown_unicast_supression (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_flood_unknown_unicast_supression is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_flood_unknown_unicast_supression() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) the Unknown Unicast Flooding
Suppression. If the Unknown Unicast Flooding Suppression is on,
the unicast traffic towards an unknown host will be dropped.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="flood-unknown-unicast-supression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """flood_unknown_unicast_supression must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="flood-unknown-unicast-supression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__flood_unknown_unicast_supression = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_flood_unknown_unicast_supression(self):
    self.__flood_unknown_unicast_supression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="flood-unknown-unicast-supression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)

  mac_learning = __builtin__.property(_get_mac_learning)
  mac_aging_time = __builtin__.property(_get_mac_aging_time)
  maximum_entries = __builtin__.property(_get_maximum_entries)
  anycast_gateway_mac = __builtin__.property(_get_anycast_gateway_mac)
  flood_unknown_unicast_supression = __builtin__.property(_get_flood_unknown_unicast_supression)


  _pyangbind_elements = OrderedDict([('mac_learning', mac_learning), ('mac_aging_time', mac_aging_time), ('maximum_entries', maximum_entries), ('anycast_gateway_mac', anycast_gateway_mac), ('flood_unknown_unicast_supression', flood_unknown_unicast_supression), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table/entries/entry/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for MAC table entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_address','__vlan',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table', 'entries', 'entry', 'config']

  def _get_mac_address(self):
    """
    Getter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/config/mac_address (oc-yang:mac-address)

    YANG Description: MAC address for the dynamic or static MAC table
entry
    """
    return self.__mac_address
      
  def _set_mac_address(self, v, load=False):
    """
    Setter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/config/mac_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_address() directly.

    YANG Description: MAC address for the dynamic or static MAC table
entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__mac_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_address(self):
    self.__mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)


  def _get_vlan(self):
    """
    Getter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/config/vlan (leafref)

    YANG Description: VLAN on which the MAC address is present. The same MAC
address may be seen on multiple VLANs in some cases.
    """
    return self.__vlan
      
  def _set_vlan(self, v, load=False):
    """
    Setter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/config/vlan (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan() directly.

    YANG Description: VLAN on which the MAC address is present. The same MAC
address may be seen on multiple VLANs in some cases.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan(self):
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)

  mac_address = __builtin__.property(_get_mac_address, _set_mac_address)
  vlan = __builtin__.property(_get_vlan, _set_vlan)


  _pyangbind_elements = OrderedDict([('mac_address', mac_address), ('vlan', vlan), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table/entries/entry/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for MAC table entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_address','__vlan','__age','__entry_type','__evi',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__age = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)
    self.__entry_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC': {}, 'DYNAMIC': {}},), is_leaf=True, yang_name="entry-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    self.__evi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table', 'entries', 'entry', 'state']

  def _get_mac_address(self):
    """
    Getter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/mac_address (oc-yang:mac-address)

    YANG Description: MAC address for the dynamic or static MAC table
entry
    """
    return self.__mac_address
      
  def _set_mac_address(self, v, load=False):
    """
    Setter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/mac_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_address() directly.

    YANG Description: MAC address for the dynamic or static MAC table
entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__mac_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_address(self):
    self.__mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)


  def _get_vlan(self):
    """
    Getter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/vlan (leafref)

    YANG Description: VLAN on which the MAC address is present. The same MAC
address may be seen on multiple VLANs in some cases.
    """
    return self.__vlan
      
  def _set_vlan(self, v, load=False):
    """
    Setter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/vlan (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan() directly.

    YANG Description: VLAN on which the MAC address is present. The same MAC
address may be seen on multiple VLANs in some cases.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan(self):
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_age(self):
    """
    Getter method for age, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/age (uint64)

    YANG Description: The time in seconds since the MAC address has been in the
table
    """
    return self.__age
      
  def _set_age(self, v, load=False):
    """
    Setter method for age, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/age (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_age is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_age() directly.

    YANG Description: The time in seconds since the MAC address has been in the
table
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """age must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)""",
        })

    self.__age = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_age(self):
    self.__age = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="age", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)


  def _get_entry_type(self):
    """
    Getter method for entry_type, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/entry_type (enumeration)

    YANG Description: Indicates whether the entry was statically configured, or
dynamically learned.
    """
    return self.__entry_type
      
  def _set_entry_type(self, v, load=False):
    """
    Setter method for entry_type, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/entry_type (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entry_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entry_type() directly.

    YANG Description: Indicates whether the entry was statically configured, or
dynamically learned.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC': {}, 'DYNAMIC': {}},), is_leaf=True, yang_name="entry-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entry_type must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC': {}, 'DYNAMIC': {}},), is_leaf=True, yang_name="entry-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)""",
        })

    self.__entry_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entry_type(self):
    self.__entry_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC': {}, 'DYNAMIC': {}},), is_leaf=True, yang_name="entry-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)


  def _get_evi(self):
    """
    Getter method for evi, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/evi (oc-evpn-types:vni-id)

    YANG Description: EVPN EVI to associate with the BD/VLAN
    """
    return self.__evi
      
  def _set_evi(self, v, load=False):
    """
    Setter method for evi, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state/evi (oc-evpn-types:vni-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_evi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_evi() directly.

    YANG Description: EVPN EVI to associate with the BD/VLAN
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """evi must be of a type compatible with oc-evpn-types:vni-id""",
          'defined-type': "oc-evpn-types:vni-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=False)""",
        })

    self.__evi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_evi(self):
    self.__evi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=False)

  mac_address = __builtin__.property(_get_mac_address)
  vlan = __builtin__.property(_get_vlan)
  age = __builtin__.property(_get_age)
  entry_type = __builtin__.property(_get_entry_type)
  evi = __builtin__.property(_get_evi)


  _pyangbind_elements = OrderedDict([('mac_address', mac_address), ('vlan', vlan), ('age', age), ('entry_type', entry_type), ('evi', evi), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table/entries/entry/interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table', 'entries', 'entry', 'interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table/entries/entry/interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table', 'entries', 'entry', 'interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table/entries/entry/interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table', 'entries', 'entry', 'interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_interface_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table/entries/entry/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to the base and/or subinterface for the
MAC table entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface_ref',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table', 'entries', 'entry', 'interface']

  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)


  _pyangbind_elements = OrderedDict([('interface_ref', interface_ref), ])


class yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table/entries/entry. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of learned MAC addresses
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_address','__vlan','__config','__state','__interface',)

  _yang_name = 'entry'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__interface = YANGDynClass(base=yc_interface_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface, is_container='container', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table', 'entries', 'entry']

  def _get_mac_address(self):
    """
    Getter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/mac_address (leafref)

    YANG Description: Reference to mac-address list key
    """
    return self.__mac_address
      
  def _set_mac_address(self, v, load=False):
    """
    Setter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/mac_address (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_address() directly.

    YANG Description: Reference to mac-address list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_address must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__mac_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_address(self):
    self.__mac_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_vlan(self):
    """
    Getter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/vlan (leafref)

    YANG Description: Reference to vlan list key
    """
    return self.__vlan
      
  def _set_vlan(self, v, load=False):
    """
    Setter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/vlan (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan() directly.

    YANG Description: Reference to vlan list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan(self):
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/config (container)

    YANG Description: Configuration data for MAC table entries
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for MAC table entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state (container)

    YANG Description: Operational state data for MAC table entries
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for MAC table entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface (container)

    YANG Description: Reference to the base and/or subinterface for the
MAC table entry
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry/interface (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to the base and/or subinterface for the
MAC table entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface, is_container='container', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface, is_container='container', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=yc_interface_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry_interface, is_container='container', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  mac_address = __builtin__.property(_get_mac_address, _set_mac_address)
  vlan = __builtin__.property(_get_vlan, _set_vlan)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('mac_address', mac_address), ('vlan', vlan), ('config', config), ('state', state), ('interface', interface), ])


class yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table/entries. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of MAC table entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__entry',)

  _yang_name = 'entries'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__entry = YANGDynClass(base=YANGListType("mac_address vlan",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address vlan', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table', 'entries']

  def _get_entry(self):
    """
    Getter method for entry, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry (list)

    YANG Description: List of learned MAC addresses
    """
    return self.__entry
      
  def _set_entry(self, v, load=False):
    """
    Setter method for entry, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries/entry (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entry is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entry() directly.

    YANG Description: List of learned MAC addresses
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("mac_address vlan",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address vlan', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entry must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("mac_address vlan",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address vlan', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)""",
        })

    self.__entry = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entry(self):
    self.__entry = YANGDynClass(base=YANGListType("mac_address vlan",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address vlan', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)

  entry = __builtin__.property(_get_entry, _set_entry)


  _pyangbind_elements = OrderedDict([('entry', entry), ])


class yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_mac_table(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-table. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Table of learned or statically configured MAC addresses and
corresponding VLANs in the bridge domain
  """
  __slots__ = ('_path_helper', '_extmethods', '__entries',)

  _yang_name = 'mac-table'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__entries = YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-table']

  def _get_entries(self):
    """
    Getter method for entries, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries (container)

    YANG Description: Enclosing container for list of MAC table entries
    """
    return self.__entries
      
  def _set_entries(self, v, load=False):
    """
    Setter method for entries, mapped from YANG variable /network_instances/network_instance/fdb/mac_table/entries (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entries() directly.

    YANG Description: Enclosing container for list of MAC table entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entries must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entries(self):
    self.__entries = YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_mac_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  entries = __builtin__.property(_get_entries, _set_entries)


  _pyangbind_elements = OrderedDict([('entries', entries), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-mobility/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data related to mac mobility.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_mobility','__mac_mobility_window','__mac_mobility_threshold','__ip_mobility_threshold','__duplicate_ip_detection_interval',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_mobility = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    self.__mac_mobility_window = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..600']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(180), is_leaf=True, yang_name="mac-mobility-window", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    self.__mac_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..50']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(5), is_leaf=True, yang_name="mac-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint8', is_config=True)
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-mobility', 'config']

  def _get_mac_mobility(self):
    """
    Getter method for mac_mobility, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/mac_mobility (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its MAC address) to move from one
Ethernet segment to another; this is referred to as 'MAC Mobility'
or 'MAC move. The configuration attributes includes: mac-mobility-window
and mac-mobility-threshold
    """
    return self.__mac_mobility
      
  def _set_mac_mobility(self, v, load=False):
    """
    Setter method for mac_mobility, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/mac_mobility (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_mobility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_mobility() directly.

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its MAC address) to move from one
Ethernet segment to another; this is referred to as 'MAC Mobility'
or 'MAC move. The configuration attributes includes: mac-mobility-window
and mac-mobility-threshold
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_mobility must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__mac_mobility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_mobility(self):
    self.__mac_mobility = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)


  def _get_mac_mobility_window(self):
    """
    Getter method for mac_mobility_window, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/mac_mobility_window (uint16)

    YANG Description: The time interval used in detecting a duplicate MAC address.
The value can be from 5 through 600 seconds.
The default is 180 seconds
    """
    return self.__mac_mobility_window
      
  def _set_mac_mobility_window(self, v, load=False):
    """
    Setter method for mac_mobility_window, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/mac_mobility_window (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_mobility_window is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_mobility_window() directly.

    YANG Description: The time interval used in detecting a duplicate MAC address.
The value can be from 5 through 600 seconds.
The default is 180 seconds
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..600']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(180), is_leaf=True, yang_name="mac-mobility-window", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_mobility_window must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..600']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(180), is_leaf=True, yang_name="mac-mobility-window", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__mac_mobility_window = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_mobility_window(self):
    self.__mac_mobility_window = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..600']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(180), is_leaf=True, yang_name="mac-mobility-window", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)


  def _get_mac_mobility_threshold(self):
    """
    Getter method for mac_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/mac_mobility_threshold (uint8)

    YANG Description: The number of MAC mobility events that are detected for a
given MAC address within the detection-window before it is identified
as a duplicate MAC address. Once the detection threshold is reached,
updates for the MAC address are suppressed.
    """
    return self.__mac_mobility_threshold
      
  def _set_mac_mobility_threshold(self, v, load=False):
    """
    Setter method for mac_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/mac_mobility_threshold (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_mobility_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_mobility_threshold() directly.

    YANG Description: The number of MAC mobility events that are detected for a
given MAC address within the detection-window before it is identified
as a duplicate MAC address. Once the detection threshold is reached,
updates for the MAC address are suppressed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..50']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(5), is_leaf=True, yang_name="mac-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint8', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_mobility_threshold must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..50']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(5), is_leaf=True, yang_name="mac-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint8', is_config=True)""",
        })

    self.__mac_mobility_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_mobility_threshold(self):
    self.__mac_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..50']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(5), is_leaf=True, yang_name="mac-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint8', is_config=True)


  def _get_ip_mobility_threshold(self):
    """
    Getter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/ip_mobility_threshold (uint16)

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    return self.__ip_mobility_threshold
      
  def _set_ip_mobility_threshold(self, v, load=False):
    """
    Setter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/ip_mobility_threshold (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ip_mobility_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ip_mobility_threshold() directly.

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ip_mobility_threshold must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__ip_mobility_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ip_mobility_threshold(self):
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)


  def _get_duplicate_ip_detection_interval(self):
    """
    Getter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/duplicate_ip_detection_interval (uint16)

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    return self.__duplicate_ip_detection_interval
      
  def _set_duplicate_ip_detection_interval(self, v, load=False):
    """
    Setter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config/duplicate_ip_detection_interval (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_duplicate_ip_detection_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_duplicate_ip_detection_interval() directly.

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """duplicate_ip_detection_interval must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__duplicate_ip_detection_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_duplicate_ip_detection_interval(self):
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)

  mac_mobility = __builtin__.property(_get_mac_mobility, _set_mac_mobility)
  mac_mobility_window = __builtin__.property(_get_mac_mobility_window, _set_mac_mobility_window)
  mac_mobility_threshold = __builtin__.property(_get_mac_mobility_threshold, _set_mac_mobility_threshold)
  ip_mobility_threshold = __builtin__.property(_get_ip_mobility_threshold, _set_ip_mobility_threshold)
  duplicate_ip_detection_interval = __builtin__.property(_get_duplicate_ip_detection_interval, _set_duplicate_ip_detection_interval)


  _pyangbind_elements = OrderedDict([('mac_mobility', mac_mobility), ('mac_mobility_window', mac_mobility_window), ('mac_mobility_threshold', mac_mobility_threshold), ('ip_mobility_threshold', ip_mobility_threshold), ('duplicate_ip_detection_interval', duplicate_ip_detection_interval), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-mobility/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data related to mac mobility.
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_mobility','__mac_mobility_window','__mac_mobility_threshold','__ip_mobility_threshold','__duplicate_ip_detection_interval',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_mobility = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__mac_mobility_window = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..600']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(180), is_leaf=True, yang_name="mac-mobility-window", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    self.__mac_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..50']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(5), is_leaf=True, yang_name="mac-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint8', is_config=False)
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-mobility', 'state']

  def _get_mac_mobility(self):
    """
    Getter method for mac_mobility, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/mac_mobility (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its MAC address) to move from one
Ethernet segment to another; this is referred to as 'MAC Mobility'
or 'MAC move. The configuration attributes includes: mac-mobility-window
and mac-mobility-threshold
    """
    return self.__mac_mobility
      
  def _set_mac_mobility(self, v, load=False):
    """
    Setter method for mac_mobility, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/mac_mobility (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_mobility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_mobility() directly.

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its MAC address) to move from one
Ethernet segment to another; this is referred to as 'MAC Mobility'
or 'MAC move. The configuration attributes includes: mac-mobility-window
and mac-mobility-threshold
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_mobility must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__mac_mobility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_mobility(self):
    self.__mac_mobility = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_mac_mobility_window(self):
    """
    Getter method for mac_mobility_window, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/mac_mobility_window (uint16)

    YANG Description: The time interval used in detecting a duplicate MAC address.
The value can be from 5 through 600 seconds.
The default is 180 seconds
    """
    return self.__mac_mobility_window
      
  def _set_mac_mobility_window(self, v, load=False):
    """
    Setter method for mac_mobility_window, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/mac_mobility_window (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_mobility_window is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_mobility_window() directly.

    YANG Description: The time interval used in detecting a duplicate MAC address.
The value can be from 5 through 600 seconds.
The default is 180 seconds
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..600']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(180), is_leaf=True, yang_name="mac-mobility-window", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_mobility_window must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..600']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(180), is_leaf=True, yang_name="mac-mobility-window", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__mac_mobility_window = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_mobility_window(self):
    self.__mac_mobility_window = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['0..600']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16)(180), is_leaf=True, yang_name="mac-mobility-window", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)


  def _get_mac_mobility_threshold(self):
    """
    Getter method for mac_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/mac_mobility_threshold (uint8)

    YANG Description: The number of MAC mobility events that are detected for a
given MAC address within the detection-window before it is identified
as a duplicate MAC address. Once the detection threshold is reached,
updates for the MAC address are suppressed.
    """
    return self.__mac_mobility_threshold
      
  def _set_mac_mobility_threshold(self, v, load=False):
    """
    Setter method for mac_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/mac_mobility_threshold (uint8)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_mobility_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_mobility_threshold() directly.

    YANG Description: The number of MAC mobility events that are detected for a
given MAC address within the detection-window before it is identified
as a duplicate MAC address. Once the detection threshold is reached,
updates for the MAC address are suppressed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..50']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(5), is_leaf=True, yang_name="mac-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint8', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_mobility_threshold must be of a type compatible with uint8""",
          'defined-type': "uint8",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..50']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(5), is_leaf=True, yang_name="mac-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint8', is_config=False)""",
        })

    self.__mac_mobility_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_mobility_threshold(self):
    self.__mac_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8), restriction_dict={'range': ['0..50']}), default=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..255']}, int_size=8)(5), is_leaf=True, yang_name="mac-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint8', is_config=False)


  def _get_ip_mobility_threshold(self):
    """
    Getter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/ip_mobility_threshold (uint16)

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    return self.__ip_mobility_threshold
      
  def _set_ip_mobility_threshold(self, v, load=False):
    """
    Setter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/ip_mobility_threshold (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ip_mobility_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ip_mobility_threshold() directly.

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ip_mobility_threshold must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__ip_mobility_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ip_mobility_threshold(self):
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)


  def _get_duplicate_ip_detection_interval(self):
    """
    Getter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/duplicate_ip_detection_interval (uint16)

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    return self.__duplicate_ip_detection_interval
      
  def _set_duplicate_ip_detection_interval(self, v, load=False):
    """
    Setter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state/duplicate_ip_detection_interval (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_duplicate_ip_detection_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_duplicate_ip_detection_interval() directly.

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """duplicate_ip_detection_interval must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__duplicate_ip_detection_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_duplicate_ip_detection_interval(self):
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)

  mac_mobility = __builtin__.property(_get_mac_mobility)
  mac_mobility_window = __builtin__.property(_get_mac_mobility_window)
  mac_mobility_threshold = __builtin__.property(_get_mac_mobility_threshold)
  ip_mobility_threshold = __builtin__.property(_get_ip_mobility_threshold)
  duplicate_ip_detection_interval = __builtin__.property(_get_duplicate_ip_detection_interval)


  _pyangbind_elements = OrderedDict([('mac_mobility', mac_mobility), ('mac_mobility_window', mac_mobility_window), ('mac_mobility_threshold', mac_mobility_threshold), ('ip_mobility_threshold', ip_mobility_threshold), ('duplicate_ip_detection_interval', duplicate_ip_detection_interval), ])


class yc_mac_mobility_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/mac-mobility. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top grouping the configuration and state data related to mac
mobility.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'mac-mobility'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'mac-mobility']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config (container)

    YANG Description: Configuration data related to mac mobility.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data related to mac mobility.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state (container)

    YANG Description: State data related to mac mobility.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data related to mac mobility.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/arp-proxy/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data related to ARP-Proxy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__arp_suppression','__ip_mobility_threshold','__duplicate_ip_detection_interval',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    self.__arp_suppression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="arp-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'arp-proxy', 'config']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config/enable (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) ARP proxy. If true
a proxy server on the network answers the
Address Resolution Protocol (ARP) queries for an
IP address that is not on that network.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) ARP proxy. If true
a proxy server on the network answers the
Address Resolution Protocol (ARP) queries for an
IP address that is not on that network.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)


  def _get_arp_suppression(self):
    """
    Getter method for arp_suppression, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config/arp_suppression (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) ARP suppression. If true
the  Address Resolution Protocol (ARP) queries for an
IP address that is not on that network are suppressed.
Address Resolution Protocol (ARP) suppression is a
technique used to reduce the amount of ARP broadcast
flooding within individual VXLAN segments, that is between
VMs connected to the same logical switch.
    """
    return self.__arp_suppression
      
  def _set_arp_suppression(self, v, load=False):
    """
    Setter method for arp_suppression, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config/arp_suppression (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_arp_suppression is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_arp_suppression() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) ARP suppression. If true
the  Address Resolution Protocol (ARP) queries for an
IP address that is not on that network are suppressed.
Address Resolution Protocol (ARP) suppression is a
technique used to reduce the amount of ARP broadcast
flooding within individual VXLAN segments, that is between
VMs connected to the same logical switch.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="arp-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """arp_suppression must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="arp-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__arp_suppression = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_arp_suppression(self):
    self.__arp_suppression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="arp-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)


  def _get_ip_mobility_threshold(self):
    """
    Getter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config/ip_mobility_threshold (uint16)

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    return self.__ip_mobility_threshold
      
  def _set_ip_mobility_threshold(self, v, load=False):
    """
    Setter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config/ip_mobility_threshold (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ip_mobility_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ip_mobility_threshold() directly.

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ip_mobility_threshold must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__ip_mobility_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ip_mobility_threshold(self):
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)


  def _get_duplicate_ip_detection_interval(self):
    """
    Getter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config/duplicate_ip_detection_interval (uint16)

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    return self.__duplicate_ip_detection_interval
      
  def _set_duplicate_ip_detection_interval(self, v, load=False):
    """
    Setter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config/duplicate_ip_detection_interval (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_duplicate_ip_detection_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_duplicate_ip_detection_interval() directly.

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """duplicate_ip_detection_interval must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__duplicate_ip_detection_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_duplicate_ip_detection_interval(self):
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)

  enable = __builtin__.property(_get_enable, _set_enable)
  arp_suppression = __builtin__.property(_get_arp_suppression, _set_arp_suppression)
  ip_mobility_threshold = __builtin__.property(_get_ip_mobility_threshold, _set_ip_mobility_threshold)
  duplicate_ip_detection_interval = __builtin__.property(_get_duplicate_ip_detection_interval, _set_duplicate_ip_detection_interval)


  _pyangbind_elements = OrderedDict([('enable', enable), ('arp_suppression', arp_suppression), ('ip_mobility_threshold', ip_mobility_threshold), ('duplicate_ip_detection_interval', duplicate_ip_detection_interval), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/arp-proxy/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data related to ARP-Proxy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__arp_suppression','__ip_mobility_threshold','__duplicate_ip_detection_interval',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__arp_suppression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="arp-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'arp-proxy', 'state']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state/enable (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) ARP proxy. If true
a proxy server on the network answers the
Address Resolution Protocol (ARP) queries for an
IP address that is not on that network.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) ARP proxy. If true
a proxy server on the network answers the
Address Resolution Protocol (ARP) queries for an
IP address that is not on that network.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_arp_suppression(self):
    """
    Getter method for arp_suppression, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state/arp_suppression (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) ARP suppression. If true
the  Address Resolution Protocol (ARP) queries for an
IP address that is not on that network are suppressed.
Address Resolution Protocol (ARP) suppression is a
technique used to reduce the amount of ARP broadcast
flooding within individual VXLAN segments, that is between
VMs connected to the same logical switch.
    """
    return self.__arp_suppression
      
  def _set_arp_suppression(self, v, load=False):
    """
    Setter method for arp_suppression, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state/arp_suppression (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_arp_suppression is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_arp_suppression() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) ARP suppression. If true
the  Address Resolution Protocol (ARP) queries for an
IP address that is not on that network are suppressed.
Address Resolution Protocol (ARP) suppression is a
technique used to reduce the amount of ARP broadcast
flooding within individual VXLAN segments, that is between
VMs connected to the same logical switch.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="arp-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """arp_suppression must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="arp-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__arp_suppression = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_arp_suppression(self):
    self.__arp_suppression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="arp-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_ip_mobility_threshold(self):
    """
    Getter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state/ip_mobility_threshold (uint16)

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    return self.__ip_mobility_threshold
      
  def _set_ip_mobility_threshold(self, v, load=False):
    """
    Setter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state/ip_mobility_threshold (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ip_mobility_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ip_mobility_threshold() directly.

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ip_mobility_threshold must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__ip_mobility_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ip_mobility_threshold(self):
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)


  def _get_duplicate_ip_detection_interval(self):
    """
    Getter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state/duplicate_ip_detection_interval (uint16)

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    return self.__duplicate_ip_detection_interval
      
  def _set_duplicate_ip_detection_interval(self, v, load=False):
    """
    Setter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state/duplicate_ip_detection_interval (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_duplicate_ip_detection_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_duplicate_ip_detection_interval() directly.

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """duplicate_ip_detection_interval must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__duplicate_ip_detection_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_duplicate_ip_detection_interval(self):
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)

  enable = __builtin__.property(_get_enable)
  arp_suppression = __builtin__.property(_get_arp_suppression)
  ip_mobility_threshold = __builtin__.property(_get_ip_mobility_threshold)
  duplicate_ip_detection_interval = __builtin__.property(_get_duplicate_ip_detection_interval)


  _pyangbind_elements = OrderedDict([('enable', enable), ('arp_suppression', arp_suppression), ('ip_mobility_threshold', ip_mobility_threshold), ('duplicate_ip_detection_interval', duplicate_ip_detection_interval), ])


class yc_arp_proxy_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/arp-proxy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top Container related to ARP-Proxy
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'arp-proxy'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'arp-proxy']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config (container)

    YANG Description: Configuration data related to ARP-Proxy.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data related to ARP-Proxy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state (container)

    YANG Description: State data related to ARP-Proxy.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data related to ARP-Proxy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/nd-proxy/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data related to ND-Proxy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__nd_suppression','__ip_mobility_threshold','__duplicate_ip_detection_interval',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    self.__nd_suppression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="nd-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'nd-proxy', 'config']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config/enable (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) Neighbor Discovery (ND)
proxy. If true a proxy server on the network answers the
NDP packets for an IP address that is not on that network.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) Neighbor Discovery (ND)
proxy. If true a proxy server on the network answers the
NDP packets for an IP address that is not on that network.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)


  def _get_nd_suppression(self):
    """
    Getter method for nd_suppression, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config/nd_suppression (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) Neighbor Discovery suppression.
If true the NDP queries for an IP address that is not on that
network are suppressed. NDP suppression is a
technique used to reduce the amount of NDP Packets
flooding within individual VXLAN segments, that is between
VMs connected to the same logical switch.
    """
    return self.__nd_suppression
      
  def _set_nd_suppression(self, v, load=False):
    """
    Setter method for nd_suppression, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config/nd_suppression (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_nd_suppression is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_nd_suppression() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) Neighbor Discovery suppression.
If true the NDP queries for an IP address that is not on that
network are suppressed. NDP suppression is a
technique used to reduce the amount of NDP Packets
flooding within individual VXLAN segments, that is between
VMs connected to the same logical switch.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="nd-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """nd_suppression must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="nd-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__nd_suppression = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_nd_suppression(self):
    self.__nd_suppression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="nd-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)


  def _get_ip_mobility_threshold(self):
    """
    Getter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config/ip_mobility_threshold (uint16)

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    return self.__ip_mobility_threshold
      
  def _set_ip_mobility_threshold(self, v, load=False):
    """
    Setter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config/ip_mobility_threshold (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ip_mobility_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ip_mobility_threshold() directly.

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ip_mobility_threshold must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__ip_mobility_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ip_mobility_threshold(self):
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)


  def _get_duplicate_ip_detection_interval(self):
    """
    Getter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config/duplicate_ip_detection_interval (uint16)

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    return self.__duplicate_ip_detection_interval
      
  def _set_duplicate_ip_detection_interval(self, v, load=False):
    """
    Setter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config/duplicate_ip_detection_interval (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_duplicate_ip_detection_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_duplicate_ip_detection_interval() directly.

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """duplicate_ip_detection_interval must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__duplicate_ip_detection_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_duplicate_ip_detection_interval(self):
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)

  enable = __builtin__.property(_get_enable, _set_enable)
  nd_suppression = __builtin__.property(_get_nd_suppression, _set_nd_suppression)
  ip_mobility_threshold = __builtin__.property(_get_ip_mobility_threshold, _set_ip_mobility_threshold)
  duplicate_ip_detection_interval = __builtin__.property(_get_duplicate_ip_detection_interval, _set_duplicate_ip_detection_interval)


  _pyangbind_elements = OrderedDict([('enable', enable), ('nd_suppression', nd_suppression), ('ip_mobility_threshold', ip_mobility_threshold), ('duplicate_ip_detection_interval', duplicate_ip_detection_interval), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/nd-proxy/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data related to ND-Proxy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__nd_suppression','__ip_mobility_threshold','__duplicate_ip_detection_interval',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__nd_suppression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="nd-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'nd-proxy', 'state']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state/enable (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) Neighbor Discovery (ND)
proxy. If true a proxy server on the network answers the
NDP packets for an IP address that is not on that network.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) Neighbor Discovery (ND)
proxy. If true a proxy server on the network answers the
NDP packets for an IP address that is not on that network.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_nd_suppression(self):
    """
    Getter method for nd_suppression, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state/nd_suppression (boolean)

    YANG Description: Enable (TRUE) or disable (FALSE) Neighbor Discovery suppression.
If true the NDP queries for an IP address that is not on that
network are suppressed. NDP suppression is a
technique used to reduce the amount of NDP Packets
flooding within individual VXLAN segments, that is between
VMs connected to the same logical switch.
    """
    return self.__nd_suppression
      
  def _set_nd_suppression(self, v, load=False):
    """
    Setter method for nd_suppression, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state/nd_suppression (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_nd_suppression is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_nd_suppression() directly.

    YANG Description: Enable (TRUE) or disable (FALSE) Neighbor Discovery suppression.
If true the NDP queries for an IP address that is not on that
network are suppressed. NDP suppression is a
technique used to reduce the amount of NDP Packets
flooding within individual VXLAN segments, that is between
VMs connected to the same logical switch.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="nd-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """nd_suppression must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="nd-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__nd_suppression = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_nd_suppression(self):
    self.__nd_suppression = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="nd-suppression", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_ip_mobility_threshold(self):
    """
    Getter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state/ip_mobility_threshold (uint16)

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    return self.__ip_mobility_threshold
      
  def _set_ip_mobility_threshold(self, v, load=False):
    """
    Setter method for ip_mobility_threshold, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state/ip_mobility_threshold (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ip_mobility_threshold is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ip_mobility_threshold() directly.

    YANG Description: Enable (TRUE) or disable (FALSE). It is possible for a given host
or end-station (as defined by its IP address) to move from one
Ethernet segment to another. The number of IP mobility events that
are detected for a given IP address within the detection-threshold
before it is identified as a duplicate IP address.
Once the detection threshold is reached, updates for the IP address
are suppressed.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ip_mobility_threshold must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__ip_mobility_threshold = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ip_mobility_threshold(self):
    self.__ip_mobility_threshold = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="ip-mobility-threshold", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)


  def _get_duplicate_ip_detection_interval(self):
    """
    Getter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state/duplicate_ip_detection_interval (uint16)

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    return self.__duplicate_ip_detection_interval
      
  def _set_duplicate_ip_detection_interval(self, v, load=False):
    """
    Setter method for duplicate_ip_detection_interval, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state/duplicate_ip_detection_interval (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_duplicate_ip_detection_interval is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_duplicate_ip_detection_interval() directly.

    YANG Description: The time interval used in detecting a duplicate IP address.
Duplicate ip detection number of host moves
allowed within interval period
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """duplicate_ip_detection_interval must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__duplicate_ip_detection_interval = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_duplicate_ip_detection_interval(self):
    self.__duplicate_ip_detection_interval = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="duplicate-ip-detection-interval", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)

  enable = __builtin__.property(_get_enable)
  nd_suppression = __builtin__.property(_get_nd_suppression)
  ip_mobility_threshold = __builtin__.property(_get_ip_mobility_threshold)
  duplicate_ip_detection_interval = __builtin__.property(_get_duplicate_ip_detection_interval)


  _pyangbind_elements = OrderedDict([('enable', enable), ('nd_suppression', nd_suppression), ('ip_mobility_threshold', ip_mobility_threshold), ('duplicate_ip_detection_interval', duplicate_ip_detection_interval), ])


class yc_nd_proxy_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/nd-proxy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top Container related to ND-Proxy.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'nd-proxy'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'nd-proxy']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config (container)

    YANG Description: Configuration data related to ND-Proxy.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data related to ND-Proxy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state (container)

    YANG Description: State data related to ND-Proxy.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data related to ND-Proxy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/entries/entry/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for L2RIB MAC table object entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_address','__vlan','__evi','__l2_vni',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__evi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    self.__l2_vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l2-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'entries', 'entry', 'state']

  def _get_mac_address(self):
    """
    Getter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state/mac_address (oc-yang:mac-address)

    YANG Description: MAC address of the L2RIB MAC or MAC-IP entry
    """
    return self.__mac_address
      
  def _set_mac_address(self, v, load=False):
    """
    Setter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state/mac_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_address() directly.

    YANG Description: MAC address of the L2RIB MAC or MAC-IP entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__mac_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_address(self):
    self.__mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)


  def _get_vlan(self):
    """
    Getter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state/vlan (leafref)

    YANG Description: VLAN on which the MAC or MAC-IP address is present.
    """
    return self.__vlan
      
  def _set_vlan(self, v, load=False):
    """
    Setter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state/vlan (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan() directly.

    YANG Description: VLAN on which the MAC or MAC-IP address is present.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan(self):
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_evi(self):
    """
    Getter method for evi, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state/evi (oc-evpn-types:evi-id)

    YANG Description: EVPN Instance Identifier for the MAC or MAC-IP
    """
    return self.__evi
      
  def _set_evi(self, v, load=False):
    """
    Setter method for evi, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state/evi (oc-evpn-types:evi-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_evi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_evi() directly.

    YANG Description: EVPN Instance Identifier for the MAC or MAC-IP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """evi must be of a type compatible with oc-evpn-types:evi-id""",
          'defined-type': "oc-evpn-types:evi-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)""",
        })

    self.__evi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_evi(self):
    self.__evi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)


  def _get_l2_vni(self):
    """
    Getter method for l2_vni, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state/l2_vni (oc-evpn-types:evi-id)

    YANG Description: Layer2 VNI segment mapped to given vlan-id
    """
    return self.__l2_vni
      
  def _set_l2_vni(self, v, load=False):
    """
    Setter method for l2_vni, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state/l2_vni (oc-evpn-types:evi-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_l2_vni is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_l2_vni() directly.

    YANG Description: Layer2 VNI segment mapped to given vlan-id
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l2-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """l2_vni must be of a type compatible with oc-evpn-types:evi-id""",
          'defined-type': "oc-evpn-types:evi-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l2-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)""",
        })

    self.__l2_vni = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_l2_vni(self):
    self.__l2_vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l2-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)

  mac_address = __builtin__.property(_get_mac_address)
  vlan = __builtin__.property(_get_vlan)
  evi = __builtin__.property(_get_evi)
  l2_vni = __builtin__.property(_get_l2_vni)


  _pyangbind_elements = OrderedDict([('mac_address', mac_address), ('vlan', vlan), ('evi', evi), ('l2_vni', l2_vni), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/entries/entry/producers/producer/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for L2RIB MAC Table Entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__producer','__seq_number','__mobility_state','__esi','__sticky','__next_hop','__derived_from_mac_ip','__directly_received',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__producer = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOCAL': {}, 'STATIC': {}, 'BGP': {}},), is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    self.__seq_number = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="seq-number", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)
    self.__mobility_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FROZEN': {}, 'DUPLICATE': {}},), is_leaf=True, yang_name="mobility-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    self.__esi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}), is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi', is_config=False)
    self.__sticky = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="sticky", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__next_hop = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__derived_from_mac_ip = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="derived-from-mac-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__directly_received = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="directly-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'entries', 'entry', 'producers', 'producer', 'state']

  def _get_producer(self):
    """
    Getter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/producer (enumeration)

    YANG Description: Source of the learned L2RIB route
    """
    return self.__producer
      
  def _set_producer(self, v, load=False):
    """
    Setter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/producer (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_producer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_producer() directly.

    YANG Description: Source of the learned L2RIB route
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOCAL': {}, 'STATIC': {}, 'BGP': {}},), is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """producer must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOCAL': {}, 'STATIC': {}, 'BGP': {}},), is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)""",
        })

    self.__producer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_producer(self):
    self.__producer = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOCAL': {}, 'STATIC': {}, 'BGP': {}},), is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)


  def _get_seq_number(self):
    """
    Getter method for seq_number, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/seq_number (uint32)

    YANG Description: The sequence number is used to ensure that PEs retain the correct
MAC/IP Advertisement route when multiple updates occur for the same
MAC address
    """
    return self.__seq_number
      
  def _set_seq_number(self, v, load=False):
    """
    Setter method for seq_number, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/seq_number (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_seq_number is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_seq_number() directly.

    YANG Description: The sequence number is used to ensure that PEs retain the correct
MAC/IP Advertisement route when multiple updates occur for the same
MAC address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="seq-number", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """seq_number must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="seq-number", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)""",
        })

    self.__seq_number = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_seq_number(self):
    self.__seq_number = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="seq-number", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)


  def _get_mobility_state(self):
    """
    Getter method for mobility_state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/mobility_state (enumeration)

    YANG Description: Indicates if learned MAC address is duplicate or frozen
    """
    return self.__mobility_state
      
  def _set_mobility_state(self, v, load=False):
    """
    Setter method for mobility_state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/mobility_state (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mobility_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mobility_state() directly.

    YANG Description: Indicates if learned MAC address is duplicate or frozen
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FROZEN': {}, 'DUPLICATE': {}},), is_leaf=True, yang_name="mobility-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mobility_state must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FROZEN': {}, 'DUPLICATE': {}},), is_leaf=True, yang_name="mobility-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)""",
        })

    self.__mobility_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mobility_state(self):
    self.__mobility_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FROZEN': {}, 'DUPLICATE': {}},), is_leaf=True, yang_name="mobility-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)


  def _get_esi(self):
    """
    Getter method for esi, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/esi (oc-evpn-types:esi)

    YANG Description: Ethernet Segment Identifier for local and remote routes
    """
    return self.__esi
      
  def _set_esi(self, v, load=False):
    """
    Setter method for esi, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/esi (oc-evpn-types:esi)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_esi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_esi() directly.

    YANG Description: Ethernet Segment Identifier for local and remote routes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}), is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """esi must be of a type compatible with oc-evpn-types:esi""",
          'defined-type': "oc-evpn-types:esi",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}), is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi', is_config=False)""",
        })

    self.__esi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_esi(self):
    self.__esi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}), is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi', is_config=False)


  def _get_sticky(self):
    """
    Getter method for sticky, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/sticky (boolean)

    YANG Description: MAC address is sticky and not subjected to MAC moves
    """
    return self.__sticky
      
  def _set_sticky(self, v, load=False):
    """
    Setter method for sticky, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/sticky (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sticky is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sticky() directly.

    YANG Description: MAC address is sticky and not subjected to MAC moves
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="sticky", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sticky must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="sticky", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__sticky = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sticky(self):
    self.__sticky = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="sticky", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_next_hop(self):
    """
    Getter method for next_hop, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/next_hop (leafref)

    YANG Description: Leafref next-hop for the MAC-IP table entry
    """
    return self.__next_hop
      
  def _set_next_hop(self, v, load=False):
    """
    Setter method for next_hop, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/next_hop (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_next_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_next_hop() directly.

    YANG Description: Leafref next-hop for the MAC-IP table entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """next_hop must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__next_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_next_hop(self):
    self.__next_hop = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_derived_from_mac_ip(self):
    """
    Getter method for derived_from_mac_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/derived_from_mac_ip (boolean)

    YANG Description: Derived from BGP MAC-IP route-type 2
    """
    return self.__derived_from_mac_ip
      
  def _set_derived_from_mac_ip(self, v, load=False):
    """
    Setter method for derived_from_mac_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/derived_from_mac_ip (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_derived_from_mac_ip is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_derived_from_mac_ip() directly.

    YANG Description: Derived from BGP MAC-IP route-type 2
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="derived-from-mac-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """derived_from_mac_ip must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="derived-from-mac-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__derived_from_mac_ip = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_derived_from_mac_ip(self):
    self.__derived_from_mac_ip = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="derived-from-mac-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_directly_received(self):
    """
    Getter method for directly_received, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/directly_received (boolean)

    YANG Description: BGP learned MAC route-type 2
    """
    return self.__directly_received
      
  def _set_directly_received(self, v, load=False):
    """
    Setter method for directly_received, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state/directly_received (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_directly_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_directly_received() directly.

    YANG Description: BGP learned MAC route-type 2
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="directly-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """directly_received must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="directly-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__directly_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_directly_received(self):
    self.__directly_received = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="directly-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)

  producer = __builtin__.property(_get_producer)
  seq_number = __builtin__.property(_get_seq_number)
  mobility_state = __builtin__.property(_get_mobility_state)
  esi = __builtin__.property(_get_esi)
  sticky = __builtin__.property(_get_sticky)
  next_hop = __builtin__.property(_get_next_hop)
  derived_from_mac_ip = __builtin__.property(_get_derived_from_mac_ip)
  directly_received = __builtin__.property(_get_directly_received)


  _pyangbind_elements = OrderedDict([('producer', producer), ('seq_number', seq_number), ('mobility_state', mobility_state), ('esi', esi), ('sticky', sticky), ('next_hop', next_hop), ('derived_from_mac_ip', derived_from_mac_ip), ('directly_received', directly_received), ])


class yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/entries/entry/producers/producer. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of producers for each MAC table entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__producer','__state',)

  _yang_name = 'producer'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__producer = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'entries', 'entry', 'producers', 'producer']

  def _get_producer(self):
    """
    Getter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/producer (leafref)

    YANG Description: Reference to producer list key
    """
    return self.__producer
      
  def _set_producer(self, v, load=False):
    """
    Setter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/producer (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_producer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_producer() directly.

    YANG Description: Reference to producer list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """producer must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__producer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_producer(self):
    self.__producer = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state (container)

    YANG Description: State container for L2RIB MAC Table Entries
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for L2RIB MAC Table Entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  producer = __builtin__.property(_get_producer)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('producer', producer), ('state', state), ])


class yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/entries/entry/producers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Source producers for each MAC Table entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__producer',)

  _yang_name = 'producers'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__producer = YANGDynClass(base=YANGListType("producer",yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer, yang_name="producer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='producer', extensions=None), is_container='list', yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'entries', 'entry', 'producers']

  def _get_producer(self):
    """
    Getter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer (list)

    YANG Description: List of producers for each MAC table entry
    """
    return self.__producer
      
  def _set_producer(self, v, load=False):
    """
    Setter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers/producer (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_producer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_producer() directly.

    YANG Description: List of producers for each MAC table entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("producer",yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer, yang_name="producer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='producer', extensions=None), is_container='list', yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """producer must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("producer",yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer, yang_name="producer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='producer', extensions=None), is_container='list', yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)""",
        })

    self.__producer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_producer(self):
    self.__producer = YANGDynClass(base=YANGListType("producer",yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers_producer, yang_name="producer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='producer', extensions=None), is_container='list', yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

  producer = __builtin__.property(_get_producer)


  _pyangbind_elements = OrderedDict([('producer', producer), ])


class yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/entries/entry. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of learned MAC addresses
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_address','__state','__producers',)

  _yang_name = 'entry'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    self.__producers = YANGDynClass(base=yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers, is_container='container', yang_name="producers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'entries', 'entry']

  def _get_mac_address(self):
    """
    Getter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/mac_address (leafref)

    YANG Description: Leafref of MAC address object
    """
    return self.__mac_address
      
  def _set_mac_address(self, v, load=False):
    """
    Setter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/mac_address (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_address() directly.

    YANG Description: Leafref of MAC address object
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_address must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__mac_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_address(self):
    self.__mac_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state (container)

    YANG Description: Operational state data for L2RIB MAC table object entry
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for L2RIB MAC table object entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)


  def _get_producers(self):
    """
    Getter method for producers, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers (container)

    YANG Description: Source producers for each MAC Table entry
    """
    return self.__producers
      
  def _set_producers(self, v, load=False):
    """
    Setter method for producers, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry/producers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_producers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_producers() directly.

    YANG Description: Source producers for each MAC Table entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers, is_container='container', yang_name="producers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """producers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers, is_container='container', yang_name="producers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__producers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_producers(self):
    self.__producers = YANGDynClass(base=yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry_producers, is_container='container', yang_name="producers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  mac_address = __builtin__.property(_get_mac_address)
  state = __builtin__.property(_get_state)
  producers = __builtin__.property(_get_producers)


  _pyangbind_elements = OrderedDict([('mac_address', mac_address), ('state', state), ('producers', producers), ])


class yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/entries. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of MAC address entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__entry',)

  _yang_name = 'entries'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__entry = YANGDynClass(base=YANGListType("mac_address",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'entries']

  def _get_entry(self):
    """
    Getter method for entry, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry (list)

    YANG Description: List of learned MAC addresses
    """
    return self.__entry
      
  def _set_entry(self, v, load=False):
    """
    Setter method for entry, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries/entry (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entry is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entry() directly.

    YANG Description: List of learned MAC addresses
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("mac_address",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entry must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("mac_address",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)""",
        })

    self.__entry = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entry(self):
    self.__entry = YANGDynClass(base=YANGListType("mac_address",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

  entry = __builtin__.property(_get_entry)


  _pyangbind_elements = OrderedDict([('entry', entry), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/next-hops/next-hop/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for common next-hop attributes
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__peer_ip','__label','__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)
    self.__peer_ip = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="peer-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    self.__label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'next-hops', 'next-hop', 'state']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/index (uint64)

    YANG Description: A unique entry for the next-hop.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/index (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: A unique entry for the next-hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)


  def _get_peer_ip(self):
    """
    Getter method for peer_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/peer_ip (oc-inet:ip-address)

    YANG Description: Next hop peer address
    """
    return self.__peer_ip
      
  def _set_peer_ip(self, v, load=False):
    """
    Setter method for peer_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/peer_ip (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_peer_ip is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_peer_ip() directly.

    YANG Description: Next hop peer address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="peer-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """peer_ip must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="peer-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__peer_ip = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_peer_ip(self):
    self.__peer_ip = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="peer-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)


  def _get_label(self):
    """
    Getter method for label, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/label (oc-evpn-types:evi-id)

    YANG Description: Next hop label representing the l2vni for the route
    """
    return self.__label
      
  def _set_label(self, v, load=False):
    """
    Setter method for label, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/label (oc-evpn-types:evi-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label() directly.

    YANG Description: Next hop label representing the l2vni for the route
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label must be of a type compatible with oc-evpn-types:evi-id""",
          'defined-type': "oc-evpn-types:evi-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)""",
        })

    self.__label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label(self):
    self.__label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)


  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

  index = __builtin__.property(_get_index)
  peer_ip = __builtin__.property(_get_peer_ip)
  label = __builtin__.property(_get_label)
  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('index', index), ('peer_ip', peer_ip), ('label', label), ('interface', interface), ('subinterface', subinterface), ])


class yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/next-hops/next-hop. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of next hop attributes for each MAC or MAC-IP
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__state',)

  _yang_name = 'next-hop'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'next-hops', 'next-hop']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/index (leafref)

    YANG Description: A unique index identifying the next-hop entry for the
MAC or MAC-IP entry
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/index (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: A unique index identifying the next-hop entry for the
MAC or MAC-IP entry
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state (container)

    YANG Description: State container for common next-hop attributes
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for common next-hop attributes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  index = __builtin__.property(_get_index)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('index', index), ('state', state), ])


class yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table/next-hops. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A next-hop associated with the MAC or MAC-IP entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__next_hop',)

  _yang_name = 'next-hops'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__next_hop = YANGDynClass(base=YANGListType("index",yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop, yang_name="next-hop", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table', 'next-hops']

  def _get_next_hop(self):
    """
    Getter method for next_hop, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop (list)

    YANG Description: List of next hop attributes for each MAC or MAC-IP
    """
    return self.__next_hop
      
  def _set_next_hop(self, v, load=False):
    """
    Setter method for next_hop, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops/next_hop (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_next_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_next_hop() directly.

    YANG Description: List of next hop attributes for each MAC or MAC-IP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop, yang_name="next-hop", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """next_hop must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop, yang_name="next-hop", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)""",
        })

    self.__next_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_next_hop(self):
    self.__next_hop = YANGDynClass(base=YANGListType("index",yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops_next_hop, yang_name="next-hop", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

  next_hop = __builtin__.property(_get_next_hop)


  _pyangbind_elements = OrderedDict([('next_hop', next_hop), ])


class yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-table. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state container for MAC address information installed
into the MAC VRF of the L2RIB
  """
  __slots__ = ('_path_helper', '_extmethods', '__entries','__next_hops',)

  _yang_name = 'mac-table'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__entries = YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    self.__next_hops = YANGDynClass(base=yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops, is_container='container', yang_name="next-hops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-table']

  def _get_entries(self):
    """
    Getter method for entries, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries (container)

    YANG Description: Enclosing container for list of MAC address entries
    """
    return self.__entries
      
  def _set_entries(self, v, load=False):
    """
    Setter method for entries, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/entries (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entries() directly.

    YANG Description: Enclosing container for list of MAC address entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entries must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entries(self):
    self.__entries = YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)


  def _get_next_hops(self):
    """
    Getter method for next_hops, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops (container)

    YANG Description: A next-hop associated with the MAC or MAC-IP entry
    """
    return self.__next_hops
      
  def _set_next_hops(self, v, load=False):
    """
    Setter method for next_hops, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table/next_hops (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_next_hops is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_next_hops() directly.

    YANG Description: A next-hop associated with the MAC or MAC-IP entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops, is_container='container', yang_name="next-hops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """next_hops must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops, is_container='container', yang_name="next-hops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__next_hops = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_next_hops(self):
    self.__next_hops = YANGDynClass(base=yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table_next_hops, is_container='container', yang_name="next-hops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  entries = __builtin__.property(_get_entries)
  next_hops = __builtin__.property(_get_next_hops)


  _pyangbind_elements = OrderedDict([('entries', entries), ('next_hops', next_hops), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/entries/entry/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for L2RIB MAC-IP table object entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_address','__vlan','__evi','__l2_vni','__host_ip','__l3_vni',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__evi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    self.__l2_vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l2-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    self.__host_ip = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="host-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    self.__l3_vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l3-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'entries', 'entry', 'state']

  def _get_mac_address(self):
    """
    Getter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/mac_address (oc-yang:mac-address)

    YANG Description: MAC address of the L2RIB MAC or MAC-IP entry
    """
    return self.__mac_address
      
  def _set_mac_address(self, v, load=False):
    """
    Setter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/mac_address (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_address() directly.

    YANG Description: MAC address of the L2RIB MAC or MAC-IP entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_address must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__mac_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_address(self):
    self.__mac_address = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)


  def _get_vlan(self):
    """
    Getter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/vlan (leafref)

    YANG Description: VLAN on which the MAC or MAC-IP address is present.
    """
    return self.__vlan
      
  def _set_vlan(self, v, load=False):
    """
    Setter method for vlan, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/vlan (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vlan() directly.

    YANG Description: VLAN on which the MAC or MAC-IP address is present.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vlan must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__vlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vlan(self):
    self.__vlan = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="vlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_evi(self):
    """
    Getter method for evi, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/evi (oc-evpn-types:evi-id)

    YANG Description: EVPN Instance Identifier for the MAC or MAC-IP
    """
    return self.__evi
      
  def _set_evi(self, v, load=False):
    """
    Setter method for evi, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/evi (oc-evpn-types:evi-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_evi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_evi() directly.

    YANG Description: EVPN Instance Identifier for the MAC or MAC-IP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """evi must be of a type compatible with oc-evpn-types:evi-id""",
          'defined-type': "oc-evpn-types:evi-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)""",
        })

    self.__evi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_evi(self):
    self.__evi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)


  def _get_l2_vni(self):
    """
    Getter method for l2_vni, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/l2_vni (oc-evpn-types:evi-id)

    YANG Description: Layer2 VNI segment mapped to given vlan-id
    """
    return self.__l2_vni
      
  def _set_l2_vni(self, v, load=False):
    """
    Setter method for l2_vni, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/l2_vni (oc-evpn-types:evi-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_l2_vni is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_l2_vni() directly.

    YANG Description: Layer2 VNI segment mapped to given vlan-id
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l2-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """l2_vni must be of a type compatible with oc-evpn-types:evi-id""",
          'defined-type': "oc-evpn-types:evi-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l2-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)""",
        })

    self.__l2_vni = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_l2_vni(self):
    self.__l2_vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l2-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)


  def _get_host_ip(self):
    """
    Getter method for host_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/host_ip (oc-inet:ip-address)

    YANG Description: Host IP address of the CE device for the L2RIB MAC-IP entry
    """
    return self.__host_ip
      
  def _set_host_ip(self, v, load=False):
    """
    Setter method for host_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/host_ip (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_host_ip is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_host_ip() directly.

    YANG Description: Host IP address of the CE device for the L2RIB MAC-IP entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="host-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """host_ip must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="host-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__host_ip = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_host_ip(self):
    self.__host_ip = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="host-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)


  def _get_l3_vni(self):
    """
    Getter method for l3_vni, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/l3_vni (oc-evpn-types:evi-id)

    YANG Description: Symmetric IRB uses the same forwarding semantics when routing
between IP subnets with VRF Lite or MPLS L3VPNs. With symmetric IRB,
all traffic egressing and returning from a VTEP uses the same VNI.
Specifically, the same Layer 3 VNI (L3VNI) associated with the VRF
is used for all routed traffic. Layer3 VNI used for inter-subnet
routing
    """
    return self.__l3_vni
      
  def _set_l3_vni(self, v, load=False):
    """
    Setter method for l3_vni, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state/l3_vni (oc-evpn-types:evi-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_l3_vni is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_l3_vni() directly.

    YANG Description: Symmetric IRB uses the same forwarding semantics when routing
between IP subnets with VRF Lite or MPLS L3VPNs. With symmetric IRB,
all traffic egressing and returning from a VTEP uses the same VNI.
Specifically, the same Layer 3 VNI (L3VNI) associated with the VRF
is used for all routed traffic. Layer3 VNI used for inter-subnet
routing
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l3-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """l3_vni must be of a type compatible with oc-evpn-types:evi-id""",
          'defined-type': "oc-evpn-types:evi-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l3-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)""",
        })

    self.__l3_vni = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_l3_vni(self):
    self.__l3_vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="l3-vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)

  mac_address = __builtin__.property(_get_mac_address)
  vlan = __builtin__.property(_get_vlan)
  evi = __builtin__.property(_get_evi)
  l2_vni = __builtin__.property(_get_l2_vni)
  host_ip = __builtin__.property(_get_host_ip)
  l3_vni = __builtin__.property(_get_l3_vni)


  _pyangbind_elements = OrderedDict([('mac_address', mac_address), ('vlan', vlan), ('evi', evi), ('l2_vni', l2_vni), ('host_ip', host_ip), ('l3_vni', l3_vni), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/entries/entry/producers/producer/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for L2RIB MAC Table Entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__producer','__seq_number','__mobility_state','__esi','__sticky','__next_hop',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__producer = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOCAL': {}, 'STATIC': {}, 'BGP': {}},), is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    self.__seq_number = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="seq-number", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)
    self.__mobility_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FROZEN': {}, 'DUPLICATE': {}},), is_leaf=True, yang_name="mobility-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    self.__esi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}), is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi', is_config=False)
    self.__sticky = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="sticky", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__next_hop = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'entries', 'entry', 'producers', 'producer', 'state']

  def _get_producer(self):
    """
    Getter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/producer (enumeration)

    YANG Description: Source of the learned L2RIB route
    """
    return self.__producer
      
  def _set_producer(self, v, load=False):
    """
    Setter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/producer (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_producer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_producer() directly.

    YANG Description: Source of the learned L2RIB route
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOCAL': {}, 'STATIC': {}, 'BGP': {}},), is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """producer must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOCAL': {}, 'STATIC': {}, 'BGP': {}},), is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)""",
        })

    self.__producer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_producer(self):
    self.__producer = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'LOCAL': {}, 'STATIC': {}, 'BGP': {}},), is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)


  def _get_seq_number(self):
    """
    Getter method for seq_number, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/seq_number (uint32)

    YANG Description: The sequence number is used to ensure that PEs retain the correct
MAC/IP Advertisement route when multiple updates occur for the same
MAC address
    """
    return self.__seq_number
      
  def _set_seq_number(self, v, load=False):
    """
    Setter method for seq_number, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/seq_number (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_seq_number is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_seq_number() directly.

    YANG Description: The sequence number is used to ensure that PEs retain the correct
MAC/IP Advertisement route when multiple updates occur for the same
MAC address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="seq-number", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """seq_number must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="seq-number", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)""",
        })

    self.__seq_number = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_seq_number(self):
    self.__seq_number = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="seq-number", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)


  def _get_mobility_state(self):
    """
    Getter method for mobility_state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/mobility_state (enumeration)

    YANG Description: Indicates if learned MAC address is duplicate or frozen
    """
    return self.__mobility_state
      
  def _set_mobility_state(self, v, load=False):
    """
    Setter method for mobility_state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/mobility_state (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mobility_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mobility_state() directly.

    YANG Description: Indicates if learned MAC address is duplicate or frozen
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FROZEN': {}, 'DUPLICATE': {}},), is_leaf=True, yang_name="mobility-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mobility_state must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FROZEN': {}, 'DUPLICATE': {}},), is_leaf=True, yang_name="mobility-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)""",
        })

    self.__mobility_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mobility_state(self):
    self.__mobility_state = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'FROZEN': {}, 'DUPLICATE': {}},), is_leaf=True, yang_name="mobility-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)


  def _get_esi(self):
    """
    Getter method for esi, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/esi (oc-evpn-types:esi)

    YANG Description: Ethernet Segment Identifier for local and remote routes
    """
    return self.__esi
      
  def _set_esi(self, v, load=False):
    """
    Setter method for esi, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/esi (oc-evpn-types:esi)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_esi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_esi() directly.

    YANG Description: Ethernet Segment Identifier for local and remote routes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}), is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """esi must be of a type compatible with oc-evpn-types:esi""",
          'defined-type': "oc-evpn-types:esi",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}), is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi', is_config=False)""",
        })

    self.__esi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_esi(self):
    self.__esi = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}), is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi', is_config=False)


  def _get_sticky(self):
    """
    Getter method for sticky, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/sticky (boolean)

    YANG Description: MAC address is sticky and not subjected to MAC moves
    """
    return self.__sticky
      
  def _set_sticky(self, v, load=False):
    """
    Setter method for sticky, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/sticky (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sticky is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sticky() directly.

    YANG Description: MAC address is sticky and not subjected to MAC moves
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="sticky", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sticky must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="sticky", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__sticky = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sticky(self):
    self.__sticky = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="sticky", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_next_hop(self):
    """
    Getter method for next_hop, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/next_hop (leafref)

    YANG Description: Leafref next-hop for the MAC-IP table entry
    """
    return self.__next_hop
      
  def _set_next_hop(self, v, load=False):
    """
    Setter method for next_hop, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state/next_hop (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_next_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_next_hop() directly.

    YANG Description: Leafref next-hop for the MAC-IP table entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """next_hop must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__next_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_next_hop(self):
    self.__next_hop = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

  producer = __builtin__.property(_get_producer)
  seq_number = __builtin__.property(_get_seq_number)
  mobility_state = __builtin__.property(_get_mobility_state)
  esi = __builtin__.property(_get_esi)
  sticky = __builtin__.property(_get_sticky)
  next_hop = __builtin__.property(_get_next_hop)


  _pyangbind_elements = OrderedDict([('producer', producer), ('seq_number', seq_number), ('mobility_state', mobility_state), ('esi', esi), ('sticky', sticky), ('next_hop', next_hop), ])


class yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/entries/entry/producers/producer. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of producers for each MAC-IP table entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__producer','__state',)

  _yang_name = 'producer'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__producer = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'entries', 'entry', 'producers', 'producer']

  def _get_producer(self):
    """
    Getter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/producer (leafref)

    YANG Description: Reference to producer list key
    """
    return self.__producer
      
  def _set_producer(self, v, load=False):
    """
    Setter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/producer (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_producer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_producer() directly.

    YANG Description: Reference to producer list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """producer must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__producer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_producer(self):
    self.__producer = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state (container)

    YANG Description: State container for L2RIB MAC Table Entries
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for L2RIB MAC Table Entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  producer = __builtin__.property(_get_producer)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('producer', producer), ('state', state), ])


class yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/entries/entry/producers. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Source producers for each MAC-IP Table entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__producer',)

  _yang_name = 'producers'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__producer = YANGDynClass(base=YANGListType("producer",yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer, yang_name="producer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='producer', extensions=None), is_container='list', yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'entries', 'entry', 'producers']

  def _get_producer(self):
    """
    Getter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer (list)

    YANG Description: List of producers for each MAC-IP table entry
    """
    return self.__producer
      
  def _set_producer(self, v, load=False):
    """
    Setter method for producer, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers/producer (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_producer is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_producer() directly.

    YANG Description: List of producers for each MAC-IP table entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("producer",yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer, yang_name="producer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='producer', extensions=None), is_container='list', yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """producer must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("producer",yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer, yang_name="producer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='producer', extensions=None), is_container='list', yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)""",
        })

    self.__producer = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_producer(self):
    self.__producer = YANGDynClass(base=YANGListType("producer",yc_producer_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers_producer, yang_name="producer", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='producer', extensions=None), is_container='list', yang_name="producer", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

  producer = __builtin__.property(_get_producer)


  _pyangbind_elements = OrderedDict([('producer', producer), ])


class yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/entries/entry. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of learned MAC-IP addresses
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_address','__host_ip','__state','__producers',)

  _yang_name = 'entry'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__host_ip = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="host-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    self.__producers = YANGDynClass(base=yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers, is_container='container', yang_name="producers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'entries', 'entry']

  def _get_mac_address(self):
    """
    Getter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/mac_address (leafref)

    YANG Description: Leafref of MAC-IP address object
    """
    return self.__mac_address
      
  def _set_mac_address(self, v, load=False):
    """
    Setter method for mac_address, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/mac_address (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_address() directly.

    YANG Description: Leafref of MAC-IP address object
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_address must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__mac_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_address(self):
    self.__mac_address = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="mac-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_host_ip(self):
    """
    Getter method for host_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/host_ip (leafref)

    YANG Description: IP address of the Customer Edge device
    """
    return self.__host_ip
      
  def _set_host_ip(self, v, load=False):
    """
    Setter method for host_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/host_ip (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_host_ip is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_host_ip() directly.

    YANG Description: IP address of the Customer Edge device
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="host-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """host_ip must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="host-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__host_ip = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_host_ip(self):
    self.__host_ip = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="host-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state (container)

    YANG Description: Operational state data for L2RIB MAC-IP table object entry
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for L2RIB MAC-IP table object entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)


  def _get_producers(self):
    """
    Getter method for producers, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers (container)

    YANG Description: Source producers for each MAC-IP Table entry
    """
    return self.__producers
      
  def _set_producers(self, v, load=False):
    """
    Setter method for producers, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry/producers (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_producers is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_producers() directly.

    YANG Description: Source producers for each MAC-IP Table entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers, is_container='container', yang_name="producers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """producers must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers, is_container='container', yang_name="producers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__producers = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_producers(self):
    self.__producers = YANGDynClass(base=yc_producers_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry_producers, is_container='container', yang_name="producers", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  mac_address = __builtin__.property(_get_mac_address)
  host_ip = __builtin__.property(_get_host_ip)
  state = __builtin__.property(_get_state)
  producers = __builtin__.property(_get_producers)


  _pyangbind_elements = OrderedDict([('mac_address', mac_address), ('host_ip', host_ip), ('state', state), ('producers', producers), ])


class yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/entries. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for list of MAC-IP address entries
  """
  __slots__ = ('_path_helper', '_extmethods', '__entry',)

  _yang_name = 'entries'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__entry = YANGDynClass(base=YANGListType("mac_address host_ip",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address host-ip', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'entries']

  def _get_entry(self):
    """
    Getter method for entry, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry (list)

    YANG Description: List of learned MAC-IP addresses
    """
    return self.__entry
      
  def _set_entry(self, v, load=False):
    """
    Setter method for entry, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries/entry (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entry is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entry() directly.

    YANG Description: List of learned MAC-IP addresses
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("mac_address host_ip",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address host-ip', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entry must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("mac_address host_ip",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address host-ip', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)""",
        })

    self.__entry = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entry(self):
    self.__entry = YANGDynClass(base=YANGListType("mac_address host_ip",yc_entry_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries_entry, yang_name="entry", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='mac-address host-ip', extensions=None), is_container='list', yang_name="entry", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

  entry = __builtin__.property(_get_entry)


  _pyangbind_elements = OrderedDict([('entry', entry), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/next-hops/next-hop/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State container for common next-hop attributes
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__peer_ip','__label','__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)
    self.__peer_ip = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="peer-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    self.__label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'next-hops', 'next-hop', 'state']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/index (uint64)

    YANG Description: A unique entry for the next-hop.
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/index (uint64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: A unique entry for the next-hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with uint64""",
          'defined-type': "uint64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint64', is_config=False)


  def _get_peer_ip(self):
    """
    Getter method for peer_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/peer_ip (oc-inet:ip-address)

    YANG Description: Next hop peer address
    """
    return self.__peer_ip
      
  def _set_peer_ip(self, v, load=False):
    """
    Setter method for peer_ip, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/peer_ip (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_peer_ip is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_peer_ip() directly.

    YANG Description: Next hop peer address
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="peer-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """peer_ip must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="peer-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__peer_ip = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_peer_ip(self):
    self.__peer_ip = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="peer-ip", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)


  def _get_label(self):
    """
    Getter method for label, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/label (oc-evpn-types:evi-id)

    YANG Description: Next hop label representing the l2vni for the route
    """
    return self.__label
      
  def _set_label(self, v, load=False):
    """
    Setter method for label, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/label (oc-evpn-types:evi-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_label is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_label() directly.

    YANG Description: Next hop label representing the l2vni for the route
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """label must be of a type compatible with oc-evpn-types:evi-id""",
          'defined-type': "oc-evpn-types:evi-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)""",
        })

    self.__label = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_label(self):
    self.__label = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="label", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:evi-id', is_config=False)


  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

  index = __builtin__.property(_get_index)
  peer_ip = __builtin__.property(_get_peer_ip)
  label = __builtin__.property(_get_label)
  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('index', index), ('peer_ip', peer_ip), ('label', label), ('interface', interface), ('subinterface', subinterface), ])


class yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/next-hops/next-hop. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of next hop attributes for each MAC or MAC-IP
  """
  __slots__ = ('_path_helper', '_extmethods', '__index','__state',)

  _yang_name = 'next-hop'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'next-hops', 'next-hop']

  def _get_index(self):
    """
    Getter method for index, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/index (leafref)

    YANG Description: A unique index identifying the next-hop entry for the
MAC or MAC-IP entry
    """
    return self.__index
      
  def _set_index(self, v, load=False):
    """
    Setter method for index, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/index (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_index is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_index() directly.

    YANG Description: A unique index identifying the next-hop entry for the
MAC or MAC-IP entry
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """index must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__index = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_index(self):
    self.__index = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="index", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state (container)

    YANG Description: State container for common next-hop attributes
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State container for common next-hop attributes
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  index = __builtin__.property(_get_index)
  state = __builtin__.property(_get_state)


  _pyangbind_elements = OrderedDict([('index', index), ('state', state), ])


class yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table/next-hops. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A next-hop associated with the MAC or MAC-IP entry
  """
  __slots__ = ('_path_helper', '_extmethods', '__next_hop',)

  _yang_name = 'next-hops'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__next_hop = YANGDynClass(base=YANGListType("index",yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop, yang_name="next-hop", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table', 'next-hops']

  def _get_next_hop(self):
    """
    Getter method for next_hop, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop (list)

    YANG Description: List of next hop attributes for each MAC or MAC-IP
    """
    return self.__next_hop
      
  def _set_next_hop(self, v, load=False):
    """
    Setter method for next_hop, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops/next_hop (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_next_hop is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_next_hop() directly.

    YANG Description: List of next hop attributes for each MAC or MAC-IP
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("index",yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop, yang_name="next-hop", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """next_hop must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("index",yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop, yang_name="next-hop", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)""",
        })

    self.__next_hop = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_next_hop(self):
    self.__next_hop = YANGDynClass(base=YANGListType("index",yc_next_hop_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops_next_hop, yang_name="next-hop", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='index', extensions=None), is_container='list', yang_name="next-hop", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=False)

  next_hop = __builtin__.property(_get_next_hop)


  _pyangbind_elements = OrderedDict([('next_hop', next_hop), ])


class yc_mac_ip_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib/mac-ip-table. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state container for MAC-IP address information installed
into the MAC VRF of the L2RIB
  """
  __slots__ = ('_path_helper', '_extmethods', '__entries','__next_hops',)

  _yang_name = 'mac-ip-table'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__entries = YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    self.__next_hops = YANGDynClass(base=yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops, is_container='container', yang_name="next-hops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib', 'mac-ip-table']

  def _get_entries(self):
    """
    Getter method for entries, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries (container)

    YANG Description: Enclosing container for list of MAC-IP address entries
    """
    return self.__entries
      
  def _set_entries(self, v, load=False):
    """
    Setter method for entries, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/entries (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_entries is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_entries() directly.

    YANG Description: Enclosing container for list of MAC-IP address entries
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """entries must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__entries = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_entries(self):
    self.__entries = YANGDynClass(base=yc_entries_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_entries, is_container='container', yang_name="entries", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)


  def _get_next_hops(self):
    """
    Getter method for next_hops, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops (container)

    YANG Description: A next-hop associated with the MAC or MAC-IP entry
    """
    return self.__next_hops
      
  def _set_next_hops(self, v, load=False):
    """
    Setter method for next_hops, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table/next_hops (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_next_hops is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_next_hops() directly.

    YANG Description: A next-hop associated with the MAC or MAC-IP entry
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops, is_container='container', yang_name="next-hops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """next_hops must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops, is_container='container', yang_name="next-hops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__next_hops = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_next_hops(self):
    self.__next_hops = YANGDynClass(base=yc_next_hops_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table_next_hops, is_container='container', yang_name="next-hops", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  entries = __builtin__.property(_get_entries)
  next_hops = __builtin__.property(_get_next_hops)


  _pyangbind_elements = OrderedDict([('entries', entries), ('next_hops', next_hops), ])


class yc_l2rib_openconfig_network_instance__network_instances_network_instance_fdb_l2rib(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb/l2rib. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state container for MAC address and MAC-IP address
information that is learned and installed into the MAC VRF Layer 2
Routing Information Base (L2RIB)
  """
  __slots__ = ('_path_helper', '_extmethods', '__mac_table','__mac_ip_table',)

  _yang_name = 'l2rib'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__mac_table = YANGDynClass(base=yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table, is_container='container', yang_name="mac-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    self.__mac_ip_table = YANGDynClass(base=yc_mac_ip_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table, is_container='container', yang_name="mac-ip-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb', 'l2rib']

  def _get_mac_table(self):
    """
    Getter method for mac_table, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table (container)

    YANG Description: Operational state container for MAC address information installed
into the MAC VRF of the L2RIB
    """
    return self.__mac_table
      
  def _set_mac_table(self, v, load=False):
    """
    Setter method for mac_table, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_table (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_table is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_table() directly.

    YANG Description: Operational state container for MAC address information installed
into the MAC VRF of the L2RIB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table, is_container='container', yang_name="mac-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_table must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table, is_container='container', yang_name="mac-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__mac_table = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_table(self):
    self.__mac_table = YANGDynClass(base=yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_table, is_container='container', yang_name="mac-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)


  def _get_mac_ip_table(self):
    """
    Getter method for mac_ip_table, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table (container)

    YANG Description: Operational state container for MAC-IP address information installed
into the MAC VRF of the L2RIB
    """
    return self.__mac_ip_table
      
  def _set_mac_ip_table(self, v, load=False):
    """
    Setter method for mac_ip_table, mapped from YANG variable /network_instances/network_instance/fdb/l2rib/mac_ip_table (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_ip_table is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_ip_table() directly.

    YANG Description: Operational state container for MAC-IP address information installed
into the MAC VRF of the L2RIB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mac_ip_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table, is_container='container', yang_name="mac-ip-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_ip_table must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mac_ip_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table, is_container='container', yang_name="mac-ip-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)""",
        })

    self.__mac_ip_table = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_ip_table(self):
    self.__mac_ip_table = YANGDynClass(base=yc_mac_ip_table_openconfig_network_instance__network_instances_network_instance_fdb_l2rib_mac_ip_table, is_container='container', yang_name="mac-ip-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=False)

  mac_table = __builtin__.property(_get_mac_table)
  mac_ip_table = __builtin__.property(_get_mac_ip_table)


  _pyangbind_elements = OrderedDict([('mac_table', mac_table), ('mac_ip_table', mac_ip_table), ])


class yc_fdb_openconfig_network_instance__network_instances_network_instance_fdb(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/fdb. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state and configuration parameters relating to
the forwarding database of the network instance
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__mac_table','__mac_mobility','__arp_proxy','__nd_proxy','__l2rib',)

  _yang_name = 'fdb'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__mac_table = YANGDynClass(base=yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_mac_table, is_container='container', yang_name="mac-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__mac_mobility = YANGDynClass(base=yc_mac_mobility_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility, is_container='container', yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__arp_proxy = YANGDynClass(base=yc_arp_proxy_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy, is_container='container', yang_name="arp-proxy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__nd_proxy = YANGDynClass(base=yc_nd_proxy_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy, is_container='container', yang_name="nd-proxy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__l2rib = YANGDynClass(base=yc_l2rib_openconfig_network_instance__network_instances_network_instance_fdb_l2rib, is_container='container', yang_name="l2rib", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'fdb']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/fdb/config (container)

    YANG Description: Configuration parameters relating to the FDB
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/fdb/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters relating to the FDB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_fdb_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/fdb/state (container)

    YANG Description: Operational state parameters relating to the FDB
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/fdb/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state parameters relating to the FDB
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_fdb_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_mac_table(self):
    """
    Getter method for mac_table, mapped from YANG variable /network_instances/network_instance/fdb/mac_table (container)

    YANG Description: Table of learned or statically configured MAC addresses and
corresponding VLANs in the bridge domain
    """
    return self.__mac_table
      
  def _set_mac_table(self, v, load=False):
    """
    Setter method for mac_table, mapped from YANG variable /network_instances/network_instance/fdb/mac_table (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_table is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_table() directly.

    YANG Description: Table of learned or statically configured MAC addresses and
corresponding VLANs in the bridge domain
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_mac_table, is_container='container', yang_name="mac-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_table must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_mac_table, is_container='container', yang_name="mac-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__mac_table = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_table(self):
    self.__mac_table = YANGDynClass(base=yc_mac_table_openconfig_network_instance__network_instances_network_instance_fdb_mac_table, is_container='container', yang_name="mac-table", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_mac_mobility(self):
    """
    Getter method for mac_mobility, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility (container)

    YANG Description: Top grouping the configuration and state data related to mac
mobility.
    """
    return self.__mac_mobility
      
  def _set_mac_mobility(self, v, load=False):
    """
    Setter method for mac_mobility, mapped from YANG variable /network_instances/network_instance/fdb/mac_mobility (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mac_mobility is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mac_mobility() directly.

    YANG Description: Top grouping the configuration and state data related to mac
mobility.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_mac_mobility_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility, is_container='container', yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mac_mobility must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_mac_mobility_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility, is_container='container', yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__mac_mobility = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mac_mobility(self):
    self.__mac_mobility = YANGDynClass(base=yc_mac_mobility_openconfig_network_instance__network_instances_network_instance_fdb_mac_mobility, is_container='container', yang_name="mac-mobility", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_arp_proxy(self):
    """
    Getter method for arp_proxy, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy (container)

    YANG Description: Top Container related to ARP-Proxy
    """
    return self.__arp_proxy
      
  def _set_arp_proxy(self, v, load=False):
    """
    Setter method for arp_proxy, mapped from YANG variable /network_instances/network_instance/fdb/arp_proxy (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_arp_proxy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_arp_proxy() directly.

    YANG Description: Top Container related to ARP-Proxy
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_arp_proxy_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy, is_container='container', yang_name="arp-proxy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """arp_proxy must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_arp_proxy_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy, is_container='container', yang_name="arp-proxy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__arp_proxy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_arp_proxy(self):
    self.__arp_proxy = YANGDynClass(base=yc_arp_proxy_openconfig_network_instance__network_instances_network_instance_fdb_arp_proxy, is_container='container', yang_name="arp-proxy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_nd_proxy(self):
    """
    Getter method for nd_proxy, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy (container)

    YANG Description: Top Container related to ND-Proxy.
    """
    return self.__nd_proxy
      
  def _set_nd_proxy(self, v, load=False):
    """
    Setter method for nd_proxy, mapped from YANG variable /network_instances/network_instance/fdb/nd_proxy (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_nd_proxy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_nd_proxy() directly.

    YANG Description: Top Container related to ND-Proxy.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_nd_proxy_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy, is_container='container', yang_name="nd-proxy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """nd_proxy must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_nd_proxy_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy, is_container='container', yang_name="nd-proxy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__nd_proxy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_nd_proxy(self):
    self.__nd_proxy = YANGDynClass(base=yc_nd_proxy_openconfig_network_instance__network_instances_network_instance_fdb_nd_proxy, is_container='container', yang_name="nd-proxy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_l2rib(self):
    """
    Getter method for l2rib, mapped from YANG variable /network_instances/network_instance/fdb/l2rib (container)

    YANG Description: Operational state container for MAC address and MAC-IP address
information that is learned and installed into the MAC VRF Layer 2
Routing Information Base (L2RIB)
    """
    return self.__l2rib
      
  def _set_l2rib(self, v, load=False):
    """
    Setter method for l2rib, mapped from YANG variable /network_instances/network_instance/fdb/l2rib (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_l2rib is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_l2rib() directly.

    YANG Description: Operational state container for MAC address and MAC-IP address
information that is learned and installed into the MAC VRF Layer 2
Routing Information Base (L2RIB)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_l2rib_openconfig_network_instance__network_instances_network_instance_fdb_l2rib, is_container='container', yang_name="l2rib", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """l2rib must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_l2rib_openconfig_network_instance__network_instances_network_instance_fdb_l2rib, is_container='container', yang_name="l2rib", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__l2rib = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_l2rib(self):
    self.__l2rib = YANGDynClass(base=yc_l2rib_openconfig_network_instance__network_instances_network_instance_fdb_l2rib, is_container='container', yang_name="l2rib", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  mac_table = __builtin__.property(_get_mac_table, _set_mac_table)
  mac_mobility = __builtin__.property(_get_mac_mobility, _set_mac_mobility)
  arp_proxy = __builtin__.property(_get_arp_proxy, _set_arp_proxy)
  nd_proxy = __builtin__.property(_get_nd_proxy, _set_nd_proxy)
  l2rib = __builtin__.property(_get_l2rib, _set_l2rib)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('mac_table', mac_table), ('mac_mobility', mac_mobility), ('arp_proxy', arp_proxy), ('nd_proxy', nd_proxy), ('l2rib', l2rib), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: EVPN Configuration parameters for
the participation in an EVPN Intance.
  """
  __slots__ = ('_path_helper', '_extmethods', '__evi','__encapsulation_type','__service_type','__multicast_group','__multicast_mask','__replication_mode','__route_distinguisher','__control_word_enabled',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__evi = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    self.__encapsulation_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="encapsulation-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)
    self.__service_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="service-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)
    self.__multicast_group = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)
    self.__multicast_mask = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)
    self.__replication_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC_INGRESS_REPLICATION': {}, 'BGP': {}, 'MULTICAST': {}},), is_leaf=True, yang_name="replication-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=True)
    self.__route_distinguisher = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)
    self.__control_word_enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="control-word-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'config']

  def _get_evi(self):
    """
    Getter method for evi, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/evi (string)

    YANG Description: EVPN Instance (EVI) identifier
    """
    return self.__evi
      
  def _set_evi(self, v, load=False):
    """
    Setter method for evi, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/evi (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_evi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_evi() directly.

    YANG Description: EVPN Instance (EVI) identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """evi must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)""",
        })

    self.__evi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_evi(self):
    self.__evi = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)


  def _get_encapsulation_type(self):
    """
    Getter method for encapsulation_type, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/encapsulation_type (identityref)

    YANG Description: The on-the-wire encapsulation that should be used when
exchanging traffic from this network instance to/from
destinations belonging to the EVI. The use of MPLS or
VXLAN is selected using this container.
    """
    return self.__encapsulation_type
      
  def _set_encapsulation_type(self, v, load=False):
    """
    Setter method for encapsulation_type, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/encapsulation_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_encapsulation_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_encapsulation_type() directly.

    YANG Description: The on-the-wire encapsulation that should be used when
exchanging traffic from this network instance to/from
destinations belonging to the EVI. The use of MPLS or
VXLAN is selected using this container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="encapsulation-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """encapsulation_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-network-instance:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="encapsulation-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)""",
        })

    self.__encapsulation_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_encapsulation_type(self):
    self.__encapsulation_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="encapsulation-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)


  def _get_service_type(self):
    """
    Getter method for service_type, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/service_type (identityref)

    YANG Description: Specifies the type of EVPN that is being created according
to the values in the EVPN_TYPES identity.
The options are VLAN-based, VLAN-Bundle or VLAN-aware.
VLAN-Based services consists of an EVPN instance of only a
single broadcast domain, the proper network-instance type used
for this kind of services is L2VSI.
    """
    return self.__service_type
      
  def _set_service_type(self, v, load=False):
    """
    Setter method for service_type, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/service_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_service_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_service_type() directly.

    YANG Description: Specifies the type of EVPN that is being created according
to the values in the EVPN_TYPES identity.
The options are VLAN-based, VLAN-Bundle or VLAN-aware.
VLAN-Based services consists of an EVPN instance of only a
single broadcast domain, the proper network-instance type used
for this kind of services is L2VSI.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="service-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """service_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-network-instance:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="service-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)""",
        })

    self.__service_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_service_type(self):
    self.__service_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="service-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)


  def _get_multicast_group(self):
    """
    Getter method for multicast_group, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/multicast_group (oc-inet:ip-address)

    YANG Description: Multicast group address for BUM traffic
    """
    return self.__multicast_group
      
  def _set_multicast_group(self, v, load=False):
    """
    Setter method for multicast_group, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/multicast_group (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_group() directly.

    YANG Description: Multicast group address for BUM traffic
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_group must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__multicast_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_group(self):
    self.__multicast_group = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)


  def _get_multicast_mask(self):
    """
    Getter method for multicast_mask, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/multicast_mask (oc-inet:ip-address)

    YANG Description: Multicast group address mask
    """
    return self.__multicast_mask
      
  def _set_multicast_mask(self, v, load=False):
    """
    Setter method for multicast_mask, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/multicast_mask (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_mask() directly.

    YANG Description: Multicast group address mask
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_mask must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__multicast_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_mask(self):
    self.__multicast_mask = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)


  def _get_replication_mode(self):
    """
    Getter method for replication_mode, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/replication_mode (enumeration)

    YANG Description: Replication mode to handle BUM traffic
    """
    return self.__replication_mode
      
  def _set_replication_mode(self, v, load=False):
    """
    Setter method for replication_mode, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/replication_mode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_replication_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_replication_mode() directly.

    YANG Description: Replication mode to handle BUM traffic
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC_INGRESS_REPLICATION': {}, 'BGP': {}, 'MULTICAST': {}},), is_leaf=True, yang_name="replication-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """replication_mode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC_INGRESS_REPLICATION': {}, 'BGP': {}, 'MULTICAST': {}},), is_leaf=True, yang_name="replication-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=True)""",
        })

    self.__replication_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_replication_mode(self):
    self.__replication_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC_INGRESS_REPLICATION': {}, 'BGP': {}, 'MULTICAST': {}},), is_leaf=True, yang_name="replication-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=True)


  def _get_route_distinguisher(self):
    """
    Getter method for route_distinguisher, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/route_distinguisher (union)

    YANG Description: Route Distinguisher (RD) associated to the EVPN-instance.
An RD MUST be assigned for a given EVPN-instance on a PE.
This RD MUST be unique across all EVPN-instances on a PE.
The route-distinguisher at this level overrides
the route-distinguisher value defined under
network-instance/config.
    """
    return self.__route_distinguisher
      
  def _set_route_distinguisher(self, v, load=False):
    """
    Setter method for route_distinguisher, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/route_distinguisher (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_route_distinguisher is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_route_distinguisher() directly.

    YANG Description: Route Distinguisher (RD) associated to the EVPN-instance.
An RD MUST be assigned for a given EVPN-instance on a PE.
This RD MUST be unique across all EVPN-instances on a PE.
The route-distinguisher at this level overrides
the route-distinguisher value defined under
network-instance/config.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """route_distinguisher must be of a type compatible with union""",
          'defined-type': "openconfig-network-instance:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)""",
        })

    self.__route_distinguisher = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_route_distinguisher(self):
    self.__route_distinguisher = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)


  def _get_control_word_enabled(self):
    """
    Getter method for control_word_enabled, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/control_word_enabled (boolean)

    YANG Description: When true, the control word is signaled and sent.
    """
    return self.__control_word_enabled
      
  def _set_control_word_enabled(self, v, load=False):
    """
    Setter method for control_word_enabled, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config/control_word_enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_word_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_word_enabled() directly.

    YANG Description: When true, the control word is signaled and sent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="control-word-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_word_enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="control-word-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__control_word_enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_word_enabled(self):
    self.__control_word_enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="control-word-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)

  evi = __builtin__.property(_get_evi, _set_evi)
  encapsulation_type = __builtin__.property(_get_encapsulation_type, _set_encapsulation_type)
  service_type = __builtin__.property(_get_service_type, _set_service_type)
  multicast_group = __builtin__.property(_get_multicast_group, _set_multicast_group)
  multicast_mask = __builtin__.property(_get_multicast_mask, _set_multicast_mask)
  replication_mode = __builtin__.property(_get_replication_mode, _set_replication_mode)
  route_distinguisher = __builtin__.property(_get_route_distinguisher, _set_route_distinguisher)
  control_word_enabled = __builtin__.property(_get_control_word_enabled, _set_control_word_enabled)


  _pyangbind_elements = OrderedDict([('evi', evi), ('encapsulation_type', encapsulation_type), ('service_type', service_type), ('multicast_group', multicast_group), ('multicast_mask', multicast_mask), ('replication_mode', replication_mode), ('route_distinguisher', route_distinguisher), ('control_word_enabled', control_word_enabled), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: EVPN State parameters for
the participation in an EVPN Intance.
  """
  __slots__ = ('_path_helper', '_extmethods', '__evi','__encapsulation_type','__service_type','__multicast_group','__multicast_mask','__replication_mode','__route_distinguisher','__control_word_enabled',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__evi = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    self.__encapsulation_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="encapsulation-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)
    self.__service_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="service-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)
    self.__multicast_group = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    self.__multicast_mask = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    self.__replication_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC_INGRESS_REPLICATION': {}, 'BGP': {}, 'MULTICAST': {}},), is_leaf=True, yang_name="replication-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    self.__route_distinguisher = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)
    self.__control_word_enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="control-word-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'state']

  def _get_evi(self):
    """
    Getter method for evi, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/evi (string)

    YANG Description: EVPN Instance (EVI) identifier
    """
    return self.__evi
      
  def _set_evi(self, v, load=False):
    """
    Setter method for evi, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/evi (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_evi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_evi() directly.

    YANG Description: EVPN Instance (EVI) identifier
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """evi must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)""",
        })

    self.__evi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_evi(self):
    self.__evi = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)


  def _get_encapsulation_type(self):
    """
    Getter method for encapsulation_type, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/encapsulation_type (identityref)

    YANG Description: The on-the-wire encapsulation that should be used when
exchanging traffic from this network instance to/from
destinations belonging to the EVI. The use of MPLS or
VXLAN is selected using this container.
    """
    return self.__encapsulation_type
      
  def _set_encapsulation_type(self, v, load=False):
    """
    Setter method for encapsulation_type, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/encapsulation_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_encapsulation_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_encapsulation_type() directly.

    YANG Description: The on-the-wire encapsulation that should be used when
exchanging traffic from this network instance to/from
destinations belonging to the EVI. The use of MPLS or
VXLAN is selected using this container.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="encapsulation-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """encapsulation_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-network-instance:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="encapsulation-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)""",
        })

    self.__encapsulation_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_encapsulation_type(self):
    self.__encapsulation_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:MPLS': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}, 'oc-ni-types:VXLAN': {'@module': 'openconfig-network-instance-types', '@namespace': 'http://openconfig.net/yang/network-instance-types'}},), is_leaf=True, yang_name="encapsulation-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)


  def _get_service_type(self):
    """
    Getter method for service_type, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/service_type (identityref)

    YANG Description: Specifies the type of EVPN that is being created according
to the values in the EVPN_TYPES identity.
The options are VLAN-based, VLAN-Bundle or VLAN-aware.
VLAN-Based services consists of an EVPN instance of only a
single broadcast domain, the proper network-instance type used
for this kind of services is L2VSI.
    """
    return self.__service_type
      
  def _set_service_type(self, v, load=False):
    """
    Setter method for service_type, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/service_type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_service_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_service_type() directly.

    YANG Description: Specifies the type of EVPN that is being created according
to the values in the EVPN_TYPES identity.
The options are VLAN-based, VLAN-Bundle or VLAN-aware.
VLAN-Based services consists of an EVPN instance of only a
single broadcast domain, the proper network-instance type used
for this kind of services is L2VSI.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="service-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """service_type must be of a type compatible with identityref""",
          'defined-type': "openconfig-network-instance:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="service-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)""",
        })

    self.__service_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_service_type(self):
    self.__service_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BASED': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_BUNDLE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:VLAN_AWARE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="service-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)


  def _get_multicast_group(self):
    """
    Getter method for multicast_group, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/multicast_group (oc-inet:ip-address)

    YANG Description: Multicast group address for BUM traffic
    """
    return self.__multicast_group
      
  def _set_multicast_group(self, v, load=False):
    """
    Setter method for multicast_group, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/multicast_group (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_group() directly.

    YANG Description: Multicast group address for BUM traffic
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_group must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__multicast_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_group(self):
    self.__multicast_group = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)


  def _get_multicast_mask(self):
    """
    Getter method for multicast_mask, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/multicast_mask (oc-inet:ip-address)

    YANG Description: Multicast group address mask
    """
    return self.__multicast_mask
      
  def _set_multicast_mask(self, v, load=False):
    """
    Setter method for multicast_mask, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/multicast_mask (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_mask() directly.

    YANG Description: Multicast group address mask
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_mask must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__multicast_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_mask(self):
    self.__multicast_mask = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)


  def _get_replication_mode(self):
    """
    Getter method for replication_mode, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/replication_mode (enumeration)

    YANG Description: Replication mode to handle BUM traffic
    """
    return self.__replication_mode
      
  def _set_replication_mode(self, v, load=False):
    """
    Setter method for replication_mode, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/replication_mode (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_replication_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_replication_mode() directly.

    YANG Description: Replication mode to handle BUM traffic
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC_INGRESS_REPLICATION': {}, 'BGP': {}, 'MULTICAST': {}},), is_leaf=True, yang_name="replication-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """replication_mode must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC_INGRESS_REPLICATION': {}, 'BGP': {}, 'MULTICAST': {}},), is_leaf=True, yang_name="replication-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)""",
        })

    self.__replication_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_replication_mode(self):
    self.__replication_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'STATIC_INGRESS_REPLICATION': {}, 'BGP': {}, 'MULTICAST': {}},), is_leaf=True, yang_name="replication-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)


  def _get_route_distinguisher(self):
    """
    Getter method for route_distinguisher, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/route_distinguisher (union)

    YANG Description: Route Distinguisher (RD) associated to the EVPN-instance.
An RD MUST be assigned for a given EVPN-instance on a PE.
This RD MUST be unique across all EVPN-instances on a PE.
The route-distinguisher at this level overrides
the route-distinguisher value defined under
network-instance/config.
    """
    return self.__route_distinguisher
      
  def _set_route_distinguisher(self, v, load=False):
    """
    Setter method for route_distinguisher, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/route_distinguisher (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_route_distinguisher is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_route_distinguisher() directly.

    YANG Description: Route Distinguisher (RD) associated to the EVPN-instance.
An RD MUST be assigned for a given EVPN-instance on a PE.
This RD MUST be unique across all EVPN-instances on a PE.
The route-distinguisher at this level overrides
the route-distinguisher value defined under
network-instance/config.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """route_distinguisher must be of a type compatible with union""",
          'defined-type': "openconfig-network-instance:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)""",
        })

    self.__route_distinguisher = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_route_distinguisher(self):
    self.__route_distinguisher = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]):([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}:([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]{1,8}|[1-3][0-9]{9}|4[01][0-9]{8}|42[0-8][0-9]{7}|429[0-3][0-9]{6}|4294[0-8][0-9]{5}|42949[0-5][0-9]{4}|429496[0-6][0-9]{3}|4294967[01][0-9]{2}|42949672[0-8][0-9]|429496729[0-5]):([0-9]|[1-9][0-9]{1,3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="route-distinguisher", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)


  def _get_control_word_enabled(self):
    """
    Getter method for control_word_enabled, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/control_word_enabled (boolean)

    YANG Description: When true, the control word is signaled and sent.
    """
    return self.__control_word_enabled
      
  def _set_control_word_enabled(self, v, load=False):
    """
    Setter method for control_word_enabled, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state/control_word_enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_control_word_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_control_word_enabled() directly.

    YANG Description: When true, the control word is signaled and sent.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="control-word-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """control_word_enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="control-word-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__control_word_enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_control_word_enabled(self):
    self.__control_word_enabled = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="control-word-enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)

  evi = __builtin__.property(_get_evi)
  encapsulation_type = __builtin__.property(_get_encapsulation_type)
  service_type = __builtin__.property(_get_service_type)
  multicast_group = __builtin__.property(_get_multicast_group)
  multicast_mask = __builtin__.property(_get_multicast_mask)
  replication_mode = __builtin__.property(_get_replication_mode)
  route_distinguisher = __builtin__.property(_get_route_distinguisher)
  control_word_enabled = __builtin__.property(_get_control_word_enabled)


  _pyangbind_elements = OrderedDict([('evi', evi), ('encapsulation_type', encapsulation_type), ('service_type', service_type), ('multicast_group', multicast_group), ('multicast_mask', multicast_mask), ('replication_mode', replication_mode), ('route_distinguisher', route_distinguisher), ('control_word_enabled', control_word_enabled), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/import-export-policy/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters to set the import and export policies
associated with a EVI
  """
  __slots__ = ('_path_helper', '_extmethods', '__export_route_target','__import_route_target',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__export_route_target = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="export-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)
    self.__import_route_target = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="import-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'import-export-policy', 'config']

  def _get_export_route_target(self):
    """
    Getter method for export_route_target, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/config/export_route_target (union)

    YANG Description: Export Route Target (RT) in the network-instance on a PE.
    """
    return self.__export_route_target
      
  def _set_export_route_target(self, v, load=False):
    """
    Setter method for export_route_target, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/config/export_route_target (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_export_route_target is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_export_route_target() directly.

    YANG Description: Export Route Target (RT) in the network-instance on a PE.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="export-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """export_route_target must be of a type compatible with union""",
          'defined-type': "openconfig-network-instance:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="export-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)""",
        })

    self.__export_route_target = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_export_route_target(self):
    self.__export_route_target = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="export-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)


  def _get_import_route_target(self):
    """
    Getter method for import_route_target, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/config/import_route_target (union)

    YANG Description: Import Route Target (RT) in the network-instance on a PE.
    """
    return self.__import_route_target
      
  def _set_import_route_target(self, v, load=False):
    """
    Setter method for import_route_target, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/config/import_route_target (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_import_route_target is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_import_route_target() directly.

    YANG Description: Import Route Target (RT) in the network-instance on a PE.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="import-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """import_route_target must be of a type compatible with union""",
          'defined-type': "openconfig-network-instance:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="import-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)""",
        })

    self.__import_route_target = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_import_route_target(self):
    self.__import_route_target = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="import-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)

  export_route_target = __builtin__.property(_get_export_route_target, _set_export_route_target)
  import_route_target = __builtin__.property(_get_import_route_target, _set_import_route_target)


  _pyangbind_elements = OrderedDict([('export_route_target', export_route_target), ('import_route_target', import_route_target), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/import-export-policy/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State parameters of the import and export policies
associated with a EVI
  """
  __slots__ = ('_path_helper', '_extmethods', '__export_route_target','__import_route_target',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__export_route_target = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="export-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)
    self.__import_route_target = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="import-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'import-export-policy', 'state']

  def _get_export_route_target(self):
    """
    Getter method for export_route_target, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/state/export_route_target (union)

    YANG Description: Export Route Target (RT) in the network-instance on a PE.
    """
    return self.__export_route_target
      
  def _set_export_route_target(self, v, load=False):
    """
    Setter method for export_route_target, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/state/export_route_target (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_export_route_target is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_export_route_target() directly.

    YANG Description: Export Route Target (RT) in the network-instance on a PE.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="export-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """export_route_target must be of a type compatible with union""",
          'defined-type': "openconfig-network-instance:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="export-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)""",
        })

    self.__export_route_target = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_export_route_target(self):
    self.__export_route_target = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="export-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)


  def _get_import_route_target(self):
    """
    Getter method for import_route_target, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/state/import_route_target (union)

    YANG Description: Import Route Target (RT) in the network-instance on a PE.
    """
    return self.__import_route_target
      
  def _set_import_route_target(self, v, load=False):
    """
    Setter method for import_route_target, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/state/import_route_target (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_import_route_target is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_import_route_target() directly.

    YANG Description: Import Route Target (RT) in the network-instance on a PE.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="import-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """import_route_target must be of a type compatible with union""",
          'defined-type': "openconfig-network-instance:union",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="import-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)""",
        })

    self.__import_route_target = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_import_route_target(self):
    self.__import_route_target = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-target:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9]):(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'route\\-origin:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9]):(6553[0-5]|655[0-2][0-9]|65[0-4][0-9]{2}|6[0-4][0-9]{3}|[1-5][0-9]{4}|[1-9][0-9]{1,3}|[0-9])'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': 'color:[0-1]{2}:(429496729[0-5]|42949672[0-8][0-9]|4294967[0-1][0-9]{2}|429496[0-6][0-9]{3}|42949[0-5][0-9]{4}|4294[0-8][0-9]{5}|429[0-3][0-9]{6}|42[0-8][0-9]{7}|4[0-1][0-9]{8}|[1-3][0-9]{9}|[1-9][0-9]{1,8}|[0-9])'}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),]), is_leaf=False, yang_name="import-route-target", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)

  export_route_target = __builtin__.property(_get_export_route_target)
  import_route_target = __builtin__.property(_get_import_route_target)


  _pyangbind_elements = OrderedDict([('export_route_target', export_route_target), ('import_route_target', import_route_target), ])


class yc_import_export_policy_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/import-export-policy. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top container to set the import and export policies
associated with a EVI
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'import-export-policy'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'import-export-policy']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/config (container)

    YANG Description: Configuration parameters to set the import and export policies
associated with a EVI
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters to set the import and export policies
associated with a EVI
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/state (container)

    YANG Description: State parameters of the import and export policies
associated with a EVI
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State parameters of the import and export policies
associated with a EVI
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/vxlan/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data related to Overlay Solution in EVPN.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vni','__overlay_endpoint_network_instance','__overlay_endpoint','__host_reachability_bgp','__multicast_group','__multicast_mask',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=True)
    self.__overlay_endpoint_network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__overlay_endpoint = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__host_reachability_bgp = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="host-reachability-bgp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    self.__multicast_group = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)
    self.__multicast_mask = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'vxlan', 'config']

  def _get_vni(self):
    """
    Getter method for vni, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/vni (oc-evpn-types:vni-id)

    YANG Description: Virtual Network Identifier (VNI) associated to the EVI. This VNI is used for
ingress and egress in the VXLAN domain.
    """
    return self.__vni
      
  def _set_vni(self, v, load=False):
    """
    Setter method for vni, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/vni (oc-evpn-types:vni-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vni is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vni() directly.

    YANG Description: Virtual Network Identifier (VNI) associated to the EVI. This VNI is used for
ingress and egress in the VXLAN domain.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vni must be of a type compatible with oc-evpn-types:vni-id""",
          'defined-type': "oc-evpn-types:vni-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=True)""",
        })

    self.__vni = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vni(self):
    self.__vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=True)


  def _get_overlay_endpoint_network_instance(self):
    """
    Getter method for overlay_endpoint_network_instance, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/overlay_endpoint_network_instance (leafref)

    YANG Description: The network instance to resolve the overlay-endpoint within.
    """
    return self.__overlay_endpoint_network_instance
      
  def _set_overlay_endpoint_network_instance(self, v, load=False):
    """
    Setter method for overlay_endpoint_network_instance, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/overlay_endpoint_network_instance (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_overlay_endpoint_network_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_overlay_endpoint_network_instance() directly.

    YANG Description: The network instance to resolve the overlay-endpoint within.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="overlay-endpoint-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """overlay_endpoint_network_instance must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__overlay_endpoint_network_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_overlay_endpoint_network_instance(self):
    self.__overlay_endpoint_network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_overlay_endpoint(self):
    """
    Getter method for overlay_endpoint, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/overlay_endpoint (leafref)

    YANG Description: Associate the EVI with an VXLAN Endpoint defined under connection
points. The network instance to resolve the overlay-endpoint within.
    """
    return self.__overlay_endpoint
      
  def _set_overlay_endpoint(self, v, load=False):
    """
    Setter method for overlay_endpoint, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/overlay_endpoint (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_overlay_endpoint is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_overlay_endpoint() directly.

    YANG Description: Associate the EVI with an VXLAN Endpoint defined under connection
points. The network instance to resolve the overlay-endpoint within.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="overlay-endpoint", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """overlay_endpoint must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__overlay_endpoint = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_overlay_endpoint(self):
    self.__overlay_endpoint = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_host_reachability_bgp(self):
    """
    Getter method for host_reachability_bgp, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/host_reachability_bgp (boolean)

    YANG Description: Enable or Disable the BGP control plane to be
used to exchange  updates from the NVE interface
    """
    return self.__host_reachability_bgp
      
  def _set_host_reachability_bgp(self, v, load=False):
    """
    Setter method for host_reachability_bgp, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/host_reachability_bgp (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_host_reachability_bgp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_host_reachability_bgp() directly.

    YANG Description: Enable or Disable the BGP control plane to be
used to exchange  updates from the NVE interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="host-reachability-bgp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """host_reachability_bgp must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="host-reachability-bgp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__host_reachability_bgp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_host_reachability_bgp(self):
    self.__host_reachability_bgp = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="host-reachability-bgp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)


  def _get_multicast_group(self):
    """
    Getter method for multicast_group, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/multicast_group (oc-inet:ip-address)

    YANG Description: Multicast group address for BUM traffic
    """
    return self.__multicast_group
      
  def _set_multicast_group(self, v, load=False):
    """
    Setter method for multicast_group, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/multicast_group (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_group() directly.

    YANG Description: Multicast group address for BUM traffic
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_group must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__multicast_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_group(self):
    self.__multicast_group = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)


  def _get_multicast_mask(self):
    """
    Getter method for multicast_mask, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/multicast_mask (oc-inet:ip-address)

    YANG Description: Multicast group address mask
    """
    return self.__multicast_mask
      
  def _set_multicast_mask(self, v, load=False):
    """
    Setter method for multicast_mask, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config/multicast_mask (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_mask() directly.

    YANG Description: Multicast group address mask
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_mask must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)""",
        })

    self.__multicast_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_mask(self):
    self.__multicast_mask = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=True)

  vni = __builtin__.property(_get_vni, _set_vni)
  overlay_endpoint_network_instance = __builtin__.property(_get_overlay_endpoint_network_instance, _set_overlay_endpoint_network_instance)
  overlay_endpoint = __builtin__.property(_get_overlay_endpoint, _set_overlay_endpoint)
  host_reachability_bgp = __builtin__.property(_get_host_reachability_bgp, _set_host_reachability_bgp)
  multicast_group = __builtin__.property(_get_multicast_group, _set_multicast_group)
  multicast_mask = __builtin__.property(_get_multicast_mask, _set_multicast_mask)


  _pyangbind_elements = OrderedDict([('vni', vni), ('overlay_endpoint_network_instance', overlay_endpoint_network_instance), ('overlay_endpoint', overlay_endpoint), ('host_reachability_bgp', host_reachability_bgp), ('multicast_group', multicast_group), ('multicast_mask', multicast_mask), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/vxlan/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State data related to Overlay Solution in EVPN.
  """
  __slots__ = ('_path_helper', '_extmethods', '__vni','__overlay_endpoint_network_instance','__overlay_endpoint','__host_reachability_bgp','__multicast_group','__multicast_mask',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=False)
    self.__overlay_endpoint_network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__overlay_endpoint = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__host_reachability_bgp = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="host-reachability-bgp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__multicast_group = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    self.__multicast_mask = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'vxlan', 'state']

  def _get_vni(self):
    """
    Getter method for vni, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/vni (oc-evpn-types:vni-id)

    YANG Description: Virtual Network Identifier (VNI) associated to the EVI. This VNI is used for
ingress and egress in the VXLAN domain.
    """
    return self.__vni
      
  def _set_vni(self, v, load=False):
    """
    Setter method for vni, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/vni (oc-evpn-types:vni-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vni is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vni() directly.

    YANG Description: Virtual Network Identifier (VNI) associated to the EVI. This VNI is used for
ingress and egress in the VXLAN domain.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vni must be of a type compatible with oc-evpn-types:vni-id""",
          'defined-type': "oc-evpn-types:vni-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=False)""",
        })

    self.__vni = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vni(self):
    self.__vni = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['1..16777215']}), is_leaf=True, yang_name="vni", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:vni-id', is_config=False)


  def _get_overlay_endpoint_network_instance(self):
    """
    Getter method for overlay_endpoint_network_instance, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/overlay_endpoint_network_instance (leafref)

    YANG Description: The network instance to resolve the overlay-endpoint within.
    """
    return self.__overlay_endpoint_network_instance
      
  def _set_overlay_endpoint_network_instance(self, v, load=False):
    """
    Setter method for overlay_endpoint_network_instance, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/overlay_endpoint_network_instance (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_overlay_endpoint_network_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_overlay_endpoint_network_instance() directly.

    YANG Description: The network instance to resolve the overlay-endpoint within.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="overlay-endpoint-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """overlay_endpoint_network_instance must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__overlay_endpoint_network_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_overlay_endpoint_network_instance(self):
    self.__overlay_endpoint_network_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint-network-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_overlay_endpoint(self):
    """
    Getter method for overlay_endpoint, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/overlay_endpoint (leafref)

    YANG Description: Associate the EVI with an VXLAN Endpoint defined under connection
points. The network instance to resolve the overlay-endpoint within.
    """
    return self.__overlay_endpoint
      
  def _set_overlay_endpoint(self, v, load=False):
    """
    Setter method for overlay_endpoint, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/overlay_endpoint (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_overlay_endpoint is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_overlay_endpoint() directly.

    YANG Description: Associate the EVI with an VXLAN Endpoint defined under connection
points. The network instance to resolve the overlay-endpoint within.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="overlay-endpoint", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """overlay_endpoint must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__overlay_endpoint = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_overlay_endpoint(self):
    self.__overlay_endpoint = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="overlay-endpoint", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_host_reachability_bgp(self):
    """
    Getter method for host_reachability_bgp, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/host_reachability_bgp (boolean)

    YANG Description: Enable or Disable the BGP control plane to be
used to exchange  updates from the NVE interface
    """
    return self.__host_reachability_bgp
      
  def _set_host_reachability_bgp(self, v, load=False):
    """
    Setter method for host_reachability_bgp, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/host_reachability_bgp (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_host_reachability_bgp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_host_reachability_bgp() directly.

    YANG Description: Enable or Disable the BGP control plane to be
used to exchange  updates from the NVE interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="host-reachability-bgp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """host_reachability_bgp must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="host-reachability-bgp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__host_reachability_bgp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_host_reachability_bgp(self):
    self.__host_reachability_bgp = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="host-reachability-bgp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_multicast_group(self):
    """
    Getter method for multicast_group, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/multicast_group (oc-inet:ip-address)

    YANG Description: Multicast group address for BUM traffic
    """
    return self.__multicast_group
      
  def _set_multicast_group(self, v, load=False):
    """
    Setter method for multicast_group, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/multicast_group (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_group is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_group() directly.

    YANG Description: Multicast group address for BUM traffic
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_group must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__multicast_group = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_group(self):
    self.__multicast_group = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-group", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)


  def _get_multicast_mask(self):
    """
    Getter method for multicast_mask, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/multicast_mask (oc-inet:ip-address)

    YANG Description: Multicast group address mask
    """
    return self.__multicast_mask
      
  def _set_multicast_mask(self, v, load=False):
    """
    Setter method for multicast_mask, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state/multicast_mask (oc-inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_multicast_mask is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_multicast_mask() directly.

    YANG Description: Multicast group address mask
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """multicast_mask must be of a type compatible with oc-inet:ip-address""",
          'defined-type': "oc-inet:ip-address",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)""",
        })

    self.__multicast_mask = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_multicast_mask(self):
    self.__multicast_mask = YANGDynClass(base=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\\.([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])){3}'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))'}),], is_leaf=True, yang_name="multicast-mask", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-inet:ip-address', is_config=False)

  vni = __builtin__.property(_get_vni)
  overlay_endpoint_network_instance = __builtin__.property(_get_overlay_endpoint_network_instance)
  overlay_endpoint = __builtin__.property(_get_overlay_endpoint)
  host_reachability_bgp = __builtin__.property(_get_host_reachability_bgp)
  multicast_group = __builtin__.property(_get_multicast_group)
  multicast_mask = __builtin__.property(_get_multicast_mask)


  _pyangbind_elements = OrderedDict([('vni', vni), ('overlay_endpoint_network_instance', overlay_endpoint_network_instance), ('overlay_endpoint', overlay_endpoint), ('host_reachability_bgp', host_reachability_bgp), ('multicast_group', multicast_group), ('multicast_mask', multicast_mask), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/vxlan/anycast-source-interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Anycast source interface configuration references
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'vxlan', 'anycast-source-interface', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/vxlan/anycast-source-interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Anycast source interface state references
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'vxlan', 'anycast-source-interface', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_anycast_source_interface_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/vxlan/anycast-source-interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Anycast source interface references
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'anycast-source-interface'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'vxlan', 'anycast-source-interface']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/config (container)

    YANG Description: Anycast source interface configuration references
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Anycast source interface configuration references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/state (container)

    YANG Description: Anycast source interface state references
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Anycast source interface state references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_vxlan_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/vxlan. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top container related to Overlay Solution in EVPN.
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__anycast_source_interface',)

  _yang_name = 'vxlan'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__anycast_source_interface = YANGDynClass(base=yc_anycast_source_interface_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface, is_container='container', yang_name="anycast-source-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'vxlan']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config (container)

    YANG Description: Configuration data related to Overlay Solution in EVPN.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data related to Overlay Solution in EVPN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state (container)

    YANG Description: State data related to Overlay Solution in EVPN.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State data related to Overlay Solution in EVPN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_anycast_source_interface(self):
    """
    Getter method for anycast_source_interface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface (container)

    YANG Description: Anycast source interface references
    """
    return self.__anycast_source_interface
      
  def _set_anycast_source_interface(self, v, load=False):
    """
    Setter method for anycast_source_interface, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan/anycast_source_interface (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_anycast_source_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_anycast_source_interface() directly.

    YANG Description: Anycast source interface references
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_anycast_source_interface_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface, is_container='container', yang_name="anycast-source-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """anycast_source_interface must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_anycast_source_interface_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface, is_container='container', yang_name="anycast-source-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__anycast_source_interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_anycast_source_interface(self):
    self.__anycast_source_interface = YANGDynClass(base=yc_anycast_source_interface_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan_anycast_source_interface, is_container='container', yang_name="anycast-source-interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  anycast_source_interface = __builtin__.property(_get_anycast_source_interface, _set_anycast_source_interface)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('anycast_source_interface', anycast_source_interface), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/pbb/b-component/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration variables for the b-components.
  """
  __slots__ = ('_path_helper', '_extmethods', '__b_component_name','__backbone_src_mac',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__b_component_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    self.__backbone_src_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="backbone-src-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'pbb', 'b-component', 'config']

  def _get_b_component_name(self):
    """
    Getter method for b_component_name, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/config/b_component_name (string)

    YANG Description: Type of the associated b-component
    """
    return self.__b_component_name
      
  def _set_b_component_name(self, v, load=False):
    """
    Setter method for b_component_name, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/config/b_component_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_b_component_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_b_component_name() directly.

    YANG Description: Type of the associated b-component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """b_component_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)""",
        })

    self.__b_component_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_b_component_name(self):
    self.__b_component_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)


  def _get_backbone_src_mac(self):
    """
    Getter method for backbone_src_mac, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/config/backbone_src_mac (oc-yang:mac-address)

    YANG Description: EVPN will run independently in both components,
the I-component MAC-VRF and B-component MAC-VRF.
The backbone-src-mac assigns the b-component MAC.
    """
    return self.__backbone_src_mac
      
  def _set_backbone_src_mac(self, v, load=False):
    """
    Setter method for backbone_src_mac, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/config/backbone_src_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_backbone_src_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_backbone_src_mac() directly.

    YANG Description: EVPN will run independently in both components,
the I-component MAC-VRF and B-component MAC-VRF.
The backbone-src-mac assigns the b-component MAC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="backbone-src-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """backbone_src_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="backbone-src-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)""",
        })

    self.__backbone_src_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_backbone_src_mac(self):
    self.__backbone_src_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="backbone-src-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=True)

  b_component_name = __builtin__.property(_get_b_component_name, _set_b_component_name)
  backbone_src_mac = __builtin__.property(_get_backbone_src_mac, _set_backbone_src_mac)


  _pyangbind_elements = OrderedDict([('b_component_name', b_component_name), ('backbone_src_mac', backbone_src_mac), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/pbb/b-component/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State variables for the b-components.
  """
  __slots__ = ('_path_helper', '_extmethods', '__b_component_name','__backbone_src_mac',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__b_component_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    self.__backbone_src_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="backbone-src-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'pbb', 'b-component', 'state']

  def _get_b_component_name(self):
    """
    Getter method for b_component_name, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/state/b_component_name (string)

    YANG Description: Type of the associated b-component
    """
    return self.__b_component_name
      
  def _set_b_component_name(self, v, load=False):
    """
    Setter method for b_component_name, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/state/b_component_name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_b_component_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_b_component_name() directly.

    YANG Description: Type of the associated b-component
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """b_component_name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)""",
        })

    self.__b_component_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_b_component_name(self):
    self.__b_component_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)


  def _get_backbone_src_mac(self):
    """
    Getter method for backbone_src_mac, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/state/backbone_src_mac (oc-yang:mac-address)

    YANG Description: EVPN will run independently in both components,
the I-component MAC-VRF and B-component MAC-VRF.
The backbone-src-mac assigns the b-component MAC.
    """
    return self.__backbone_src_mac
      
  def _set_backbone_src_mac(self, v, load=False):
    """
    Setter method for backbone_src_mac, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/state/backbone_src_mac (oc-yang:mac-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_backbone_src_mac is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_backbone_src_mac() directly.

    YANG Description: EVPN will run independently in both components,
the I-component MAC-VRF and B-component MAC-VRF.
The backbone-src-mac assigns the b-component MAC.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="backbone-src-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """backbone_src_mac must be of a type compatible with oc-yang:mac-address""",
          'defined-type': "oc-yang:mac-address",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="backbone-src-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)""",
        })

    self.__backbone_src_mac = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_backbone_src_mac(self):
    self.__backbone_src_mac = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]{2}(:[0-9a-fA-F]{2}){5}'}), is_leaf=True, yang_name="backbone-src-mac", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-yang:mac-address', is_config=False)

  b_component_name = __builtin__.property(_get_b_component_name)
  backbone_src_mac = __builtin__.property(_get_backbone_src_mac)


  _pyangbind_elements = OrderedDict([('b_component_name', b_component_name), ('backbone_src_mac', backbone_src_mac), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/pbb/b-component/i-components/i-component/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration variables for the i-sid
  """
  __slots__ = ('_path_helper', '_extmethods', '__i_sid',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__i_sid = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..16777215']}), is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'pbb', 'b-component', 'i-components', 'i-component', 'config']

  def _get_i_sid(self):
    """
    Getter method for i_sid, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/config/i_sid (uint32)

    YANG Description: Service Instance Identifier 24 bits and global within a PBB
network. I-SID defines the service instance that the frame should be
mapped to.
    """
    return self.__i_sid
      
  def _set_i_sid(self, v, load=False):
    """
    Setter method for i_sid, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/config/i_sid (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_i_sid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_i_sid() directly.

    YANG Description: Service Instance Identifier 24 bits and global within a PBB
network. I-SID defines the service instance that the frame should be
mapped to.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..16777215']}), is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """i_sid must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..16777215']}), is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=True)""",
        })

    self.__i_sid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_i_sid(self):
    self.__i_sid = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..16777215']}), is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=True)

  i_sid = __builtin__.property(_get_i_sid, _set_i_sid)


  _pyangbind_elements = OrderedDict([('i_sid', i_sid), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/pbb/b-component/i-components/i-component/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: State variables for the i-sid
  """
  __slots__ = ('_path_helper', '_extmethods', '__i_sid',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__i_sid = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..16777215']}), is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'pbb', 'b-component', 'i-components', 'i-component', 'state']

  def _get_i_sid(self):
    """
    Getter method for i_sid, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/state/i_sid (uint32)

    YANG Description: Service Instance Identifier 24 bits and global within a PBB
network. I-SID defines the service instance that the frame should be
mapped to.
    """
    return self.__i_sid
      
  def _set_i_sid(self, v, load=False):
    """
    Setter method for i_sid, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/state/i_sid (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_i_sid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_i_sid() directly.

    YANG Description: Service Instance Identifier 24 bits and global within a PBB
network. I-SID defines the service instance that the frame should be
mapped to.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..16777215']}), is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """i_sid must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..16777215']}), is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)""",
        })

    self.__i_sid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_i_sid(self):
    self.__i_sid = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), restriction_dict={'range': ['0..16777215']}), is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)

  i_sid = __builtin__.property(_get_i_sid)


  _pyangbind_elements = OrderedDict([('i_sid', i_sid), ])


class yc_i_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/pbb/b-component/i-components/i-component. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: list of i-components
  """
  __slots__ = ('_path_helper', '_extmethods', '__i_sid','__config','__state',)

  _yang_name = 'i-component'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__i_sid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'pbb', 'b-component', 'i-components', 'i-component']

  def _get_i_sid(self):
    """
    Getter method for i_sid, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/i_sid (leafref)

    YANG Description: I-SID represents a unique service identifier associated with
service instances
    """
    return self.__i_sid
      
  def _set_i_sid(self, v, load=False):
    """
    Setter method for i_sid, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/i_sid (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_i_sid is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_i_sid() directly.

    YANG Description: I-SID represents a unique service identifier associated with
service instances
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """i_sid must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__i_sid = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_i_sid(self):
    self.__i_sid = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="i-sid", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/config (container)

    YANG Description: Configuration variables for the i-sid
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration variables for the i-sid
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/state (container)

    YANG Description: State variables for the i-sid
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State variables for the i-sid
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  i_sid = __builtin__.property(_get_i_sid, _set_i_sid)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('i_sid', i_sid), ('config', config), ('state', state), ])


class yc_i_components_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/pbb/b-component/i-components. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: i-components container definition.
  """
  __slots__ = ('_path_helper', '_extmethods', '__i_component',)

  _yang_name = 'i-components'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__i_component = YANGDynClass(base=YANGListType("i_sid",yc_i_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component, yang_name="i-component", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='i-sid', extensions=None), is_container='list', yang_name="i-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'pbb', 'b-component', 'i-components']

  def _get_i_component(self):
    """
    Getter method for i_component, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component (list)

    YANG Description: list of i-components
    """
    return self.__i_component
      
  def _set_i_component(self, v, load=False):
    """
    Setter method for i_component, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components/i_component (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_i_component is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_i_component() directly.

    YANG Description: list of i-components
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("i_sid",yc_i_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component, yang_name="i-component", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='i-sid', extensions=None), is_container='list', yang_name="i-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """i_component must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("i_sid",yc_i_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component, yang_name="i-component", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='i-sid', extensions=None), is_container='list', yang_name="i-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)""",
        })

    self.__i_component = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_i_component(self):
    self.__i_component = YANGDynClass(base=YANGListType("i_sid",yc_i_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components_i_component, yang_name="i-component", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='i-sid', extensions=None), is_container='list', yang_name="i-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)

  i_component = __builtin__.property(_get_i_component, _set_i_component)


  _pyangbind_elements = OrderedDict([('i_component', i_component), ])


class yc_b_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/pbb/b-component. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of B-components. The b-component learns and forwards
traffic on the backbone in order to reduce the number of
BGP MAC Advertisement routes by aggregating Customer/Client
MAC (C-MAC) addresses via Provider Backbone MAC (B-MAC) address.
  """
  __slots__ = ('_path_helper', '_extmethods', '__b_component_name','__config','__state','__i_components',)

  _yang_name = 'b-component'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__b_component_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__i_components = YANGDynClass(base=yc_i_components_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components, is_container='container', yang_name="i-components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'pbb', 'b-component']

  def _get_b_component_name(self):
    """
    Getter method for b_component_name, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/b_component_name (leafref)

    YANG Description: Provider Backbone Bridging component name.
    """
    return self.__b_component_name
      
  def _set_b_component_name(self, v, load=False):
    """
    Setter method for b_component_name, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/b_component_name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_b_component_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_b_component_name() directly.

    YANG Description: Provider Backbone Bridging component name.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """b_component_name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__b_component_name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_b_component_name(self):
    self.__b_component_name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="b-component-name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/config (container)

    YANG Description: Configuration variables for the b-components.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration variables for the b-components.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/state (container)

    YANG Description: State variables for the b-components.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: State variables for the b-components.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_i_components(self):
    """
    Getter method for i_components, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components (container)

    YANG Description: i-components container definition.
    """
    return self.__i_components
      
  def _set_i_components(self, v, load=False):
    """
    Setter method for i_components, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component/i_components (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_i_components is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_i_components() directly.

    YANG Description: i-components container definition.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_i_components_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components, is_container='container', yang_name="i-components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """i_components must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_i_components_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components, is_container='container', yang_name="i-components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__i_components = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_i_components(self):
    self.__i_components = YANGDynClass(base=yc_i_components_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component_i_components, is_container='container', yang_name="i-components", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  b_component_name = __builtin__.property(_get_b_component_name, _set_b_component_name)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  i_components = __builtin__.property(_get_i_components, _set_i_components)


  _pyangbind_elements = OrderedDict([('b_component_name', b_component_name), ('config', config), ('state', state), ('i_components', i_components), ])


class yc_pbb_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance/pbb. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Container for EVPN with PBB PE functionality
for scaling over MPLS,
  """
  __slots__ = ('_path_helper', '_extmethods', '__b_component',)

  _yang_name = 'pbb'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__b_component = YANGDynClass(base=YANGListType("b_component_name",yc_b_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component, yang_name="b-component", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='b-component-name', extensions=None), is_container='list', yang_name="b-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance', 'pbb']

  def _get_b_component(self):
    """
    Getter method for b_component, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component (list)

    YANG Description: List of B-components. The b-component learns and forwards
traffic on the backbone in order to reduce the number of
BGP MAC Advertisement routes by aggregating Customer/Client
MAC (C-MAC) addresses via Provider Backbone MAC (B-MAC) address.
    """
    return self.__b_component
      
  def _set_b_component(self, v, load=False):
    """
    Setter method for b_component, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb/b_component (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_b_component is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_b_component() directly.

    YANG Description: List of B-components. The b-component learns and forwards
traffic on the backbone in order to reduce the number of
BGP MAC Advertisement routes by aggregating Customer/Client
MAC (C-MAC) addresses via Provider Backbone MAC (B-MAC) address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("b_component_name",yc_b_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component, yang_name="b-component", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='b-component-name', extensions=None), is_container='list', yang_name="b-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """b_component must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("b_component_name",yc_b_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component, yang_name="b-component", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='b-component-name', extensions=None), is_container='list', yang_name="b-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)""",
        })

    self.__b_component = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_b_component(self):
    self.__b_component = YANGDynClass(base=YANGListType("b_component_name",yc_b_component_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb_b_component, yang_name="b-component", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='b-component-name', extensions=None), is_container='list', yang_name="b-component", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)

  b_component = __builtin__.property(_get_b_component, _set_b_component)


  _pyangbind_elements = OrderedDict([('b_component', b_component), ])


class yc_evpn_instance_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances/evpn-instance. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: An EVPN instance (EVI) comprises Customer Edge devices
(CEs) that are connected to Provider Edge devices (PEs). One
network instance (representing a single MAC VRF) can
participate in one or more EVPN Instances. For each EVPN instance
in which the forwarding instance participates an
EVPN instance needs to be created.

The model supports BGP MPLS-Based Ethernet VPNs
(RFC 7432) and  Network Virtualization Overlay Solution
Using Ethernet VPN (RFC 8365). The use of MPLS or VXLAN
is selected via the encapsulation container within
EVPN instance. One use case requiring participating in
two EVIs is the Interconnect Solution for EVPN Overlay
networks (see draft-ietf-bess-dci-evpn-overlay-10)
  """
  __slots__ = ('_path_helper', '_extmethods', '__evi','__config','__state','__import_export_policy','__vxlan','__pbb',)

  _yang_name = 'evpn-instance'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__evi = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__import_export_policy = YANGDynClass(base=yc_import_export_policy_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy, is_container='container', yang_name="import-export-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__vxlan = YANGDynClass(base=yc_vxlan_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan, is_container='container', yang_name="vxlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__pbb = YANGDynClass(base=yc_pbb_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb, is_container='container', yang_name="pbb", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances', 'evpn-instance']

  def _get_evi(self):
    """
    Getter method for evi, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/evi (leafref)

    YANG Description: EVPN Intance (EVI) identifier
    """
    return self.__evi
      
  def _set_evi(self, v, load=False):
    """
    Setter method for evi, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/evi (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_evi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_evi() directly.

    YANG Description: EVPN Intance (EVI) identifier
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """evi must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__evi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_evi(self):
    self.__evi = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="evi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config (container)

    YANG Description: EVPN Configuration parameters for
the participation in an EVPN Intance.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: EVPN Configuration parameters for
the participation in an EVPN Intance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state (container)

    YANG Description: EVPN State parameters for
the participation in an EVPN Intance.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: EVPN State parameters for
the participation in an EVPN Intance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_import_export_policy(self):
    """
    Getter method for import_export_policy, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy (container)

    YANG Description: Top container to set the import and export policies
associated with a EVI
    """
    return self.__import_export_policy
      
  def _set_import_export_policy(self, v, load=False):
    """
    Setter method for import_export_policy, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/import_export_policy (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_import_export_policy is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_import_export_policy() directly.

    YANG Description: Top container to set the import and export policies
associated with a EVI
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_import_export_policy_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy, is_container='container', yang_name="import-export-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """import_export_policy must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_import_export_policy_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy, is_container='container', yang_name="import-export-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__import_export_policy = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_import_export_policy(self):
    self.__import_export_policy = YANGDynClass(base=yc_import_export_policy_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_import_export_policy, is_container='container', yang_name="import-export-policy", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_vxlan(self):
    """
    Getter method for vxlan, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan (container)

    YANG Description: Top container related to Overlay Solution in EVPN.
    """
    return self.__vxlan
      
  def _set_vxlan(self, v, load=False):
    """
    Setter method for vxlan, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/vxlan (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_vxlan is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_vxlan() directly.

    YANG Description: Top container related to Overlay Solution in EVPN.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_vxlan_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan, is_container='container', yang_name="vxlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """vxlan must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_vxlan_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan, is_container='container', yang_name="vxlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__vxlan = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_vxlan(self):
    self.__vxlan = YANGDynClass(base=yc_vxlan_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_vxlan, is_container='container', yang_name="vxlan", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_pbb(self):
    """
    Getter method for pbb, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb (container)

    YANG Description: Container for EVPN with PBB PE functionality
for scaling over MPLS,
    """
    return self.__pbb
      
  def _set_pbb(self, v, load=False):
    """
    Setter method for pbb, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance/pbb (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_pbb is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_pbb() directly.

    YANG Description: Container for EVPN with PBB PE functionality
for scaling over MPLS,
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_pbb_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb, is_container='container', yang_name="pbb", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """pbb must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_pbb_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb, is_container='container', yang_name="pbb", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__pbb = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_pbb(self):
    self.__pbb = YANGDynClass(base=yc_pbb_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance_pbb, is_container='container', yang_name="pbb", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  evi = __builtin__.property(_get_evi, _set_evi)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  import_export_policy = __builtin__.property(_get_import_export_policy, _set_import_export_policy)
  vxlan = __builtin__.property(_get_vxlan, _set_vxlan)
  pbb = __builtin__.property(_get_pbb, _set_pbb)


  _pyangbind_elements = OrderedDict([('evi', evi), ('config', config), ('state', state), ('import_export_policy', import_export_policy), ('vxlan', vxlan), ('pbb', pbb), ])


class yc_evpn_instances_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/evpn-instances. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration attributes of the EVPN Instance
  """
  __slots__ = ('_path_helper', '_extmethods', '__evpn_instance',)

  _yang_name = 'evpn-instances'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__evpn_instance = YANGDynClass(base=YANGListType("evi",yc_evpn_instance_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance, yang_name="evpn-instance", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='evi', extensions=None), is_container='list', yang_name="evpn-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'evpn-instances']

  def _get_evpn_instance(self):
    """
    Getter method for evpn_instance, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance (list)

    YANG Description: An EVPN instance (EVI) comprises Customer Edge devices
(CEs) that are connected to Provider Edge devices (PEs). One
network instance (representing a single MAC VRF) can
participate in one or more EVPN Instances. For each EVPN instance
in which the forwarding instance participates an
EVPN instance needs to be created.

The model supports BGP MPLS-Based Ethernet VPNs
(RFC 7432) and  Network Virtualization Overlay Solution
Using Ethernet VPN (RFC 8365). The use of MPLS or VXLAN
is selected via the encapsulation container within
EVPN instance. One use case requiring participating in
two EVIs is the Interconnect Solution for EVPN Overlay
networks (see draft-ietf-bess-dci-evpn-overlay-10)
    """
    return self.__evpn_instance
      
  def _set_evpn_instance(self, v, load=False):
    """
    Setter method for evpn_instance, mapped from YANG variable /network_instances/network_instance/evpn/evpn_instances/evpn_instance (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_evpn_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_evpn_instance() directly.

    YANG Description: An EVPN instance (EVI) comprises Customer Edge devices
(CEs) that are connected to Provider Edge devices (PEs). One
network instance (representing a single MAC VRF) can
participate in one or more EVPN Instances. For each EVPN instance
in which the forwarding instance participates an
EVPN instance needs to be created.

The model supports BGP MPLS-Based Ethernet VPNs
(RFC 7432) and  Network Virtualization Overlay Solution
Using Ethernet VPN (RFC 8365). The use of MPLS or VXLAN
is selected via the encapsulation container within
EVPN instance. One use case requiring participating in
two EVIs is the Interconnect Solution for EVPN Overlay
networks (see draft-ietf-bess-dci-evpn-overlay-10)
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("evi",yc_evpn_instance_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance, yang_name="evpn-instance", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='evi', extensions=None), is_container='list', yang_name="evpn-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """evpn_instance must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("evi",yc_evpn_instance_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance, yang_name="evpn-instance", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='evi', extensions=None), is_container='list', yang_name="evpn-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)""",
        })

    self.__evpn_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_evpn_instance(self):
    self.__evpn_instance = YANGDynClass(base=YANGListType("evi",yc_evpn_instance_openconfig_network_instance__network_instances_network_instance_evpn_evpn_instances_evpn_instance, yang_name="evpn-instance", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='evi', extensions=None), is_container='list', yang_name="evpn-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='list', is_config=True)

  evpn_instance = __builtin__.property(_get_evpn_instance, _set_evpn_instance)


  _pyangbind_elements = OrderedDict([('evpn_instance', evpn_instance), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/ethernet-segments/ethernet-segment/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the Ethernet Segments.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__esi_type','__esi','__redundancy_mode','__interface','__subinterface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    self.__esi_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TYPE_0_OPERATOR_CONFIGURED': {'value': 0}, 'TYPE_1_LACP_BASED': {'value': 1}, 'TYPE_2_BRIDGE_PROTOCOL_BASED': {'value': 2}, 'TYPE_3_MAC_BASED': {'value': 3}, 'TYPE_4_ROUTER_ID_BASED': {'value': 4}, 'TYPE_5_AS_BASED': {'value': 5}},), default=six.text_type("TYPE_0_OPERATOR_CONFIGURED"), is_leaf=True, yang_name="esi-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi-type', is_config=True)
    self.__esi = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)
    self.__redundancy_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="redundancy-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'ethernet-segments', 'ethernet-segment', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/name (string)

    YANG Description: Ethernet Segment name
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Ethernet Segment name
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=True)


  def _get_esi_type(self):
    """
    Getter method for esi_type, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/esi_type (oc-evpn-types:esi-type)

    YANG Description: ESI Type is a 1-octet field (most significant octet) that
specifies the format of the remaining 9 octets (ESI Value).
    """
    return self.__esi_type
      
  def _set_esi_type(self, v, load=False):
    """
    Setter method for esi_type, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/esi_type (oc-evpn-types:esi-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_esi_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_esi_type() directly.

    YANG Description: ESI Type is a 1-octet field (most significant octet) that
specifies the format of the remaining 9 octets (ESI Value).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TYPE_0_OPERATOR_CONFIGURED': {'value': 0}, 'TYPE_1_LACP_BASED': {'value': 1}, 'TYPE_2_BRIDGE_PROTOCOL_BASED': {'value': 2}, 'TYPE_3_MAC_BASED': {'value': 3}, 'TYPE_4_ROUTER_ID_BASED': {'value': 4}, 'TYPE_5_AS_BASED': {'value': 5}},), default=six.text_type("TYPE_0_OPERATOR_CONFIGURED"), is_leaf=True, yang_name="esi-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """esi_type must be of a type compatible with oc-evpn-types:esi-type""",
          'defined-type': "oc-evpn-types:esi-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TYPE_0_OPERATOR_CONFIGURED': {'value': 0}, 'TYPE_1_LACP_BASED': {'value': 1}, 'TYPE_2_BRIDGE_PROTOCOL_BASED': {'value': 2}, 'TYPE_3_MAC_BASED': {'value': 3}, 'TYPE_4_ROUTER_ID_BASED': {'value': 4}, 'TYPE_5_AS_BASED': {'value': 5}},), default=six.text_type("TYPE_0_OPERATOR_CONFIGURED"), is_leaf=True, yang_name="esi-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi-type', is_config=True)""",
        })

    self.__esi_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_esi_type(self):
    self.__esi_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TYPE_0_OPERATOR_CONFIGURED': {'value': 0}, 'TYPE_1_LACP_BASED': {'value': 1}, 'TYPE_2_BRIDGE_PROTOCOL_BASED': {'value': 2}, 'TYPE_3_MAC_BASED': {'value': 3}, 'TYPE_4_ROUTER_ID_BASED': {'value': 4}, 'TYPE_5_AS_BASED': {'value': 5}},), default=six.text_type("TYPE_0_OPERATOR_CONFIGURED"), is_leaf=True, yang_name="esi-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi-type', is_config=True)


  def _get_esi(self):
    """
    Getter method for esi, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/esi (union)

    YANG Description: Ethernet Segment Identifier (ESI) value.
For ESI Type 0: The esi leaf value is directly configured by the operator.
For ESI Type 1: The AUTO enum must be used.
For ESI Type 2: The AUTO enum must be used.
For ESI Type 3: The directly configured or AUTO enum must be used.
For ESI Type 4: The directly configured or AUTO enum must be used.
For ESI Type 5: The directly configured or AUTO enum must be used.
    """
    return self.__esi
      
  def _set_esi(self, v, load=False):
    """
    Setter method for esi, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/esi (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_esi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_esi() directly.

    YANG Description: Ethernet Segment Identifier (ESI) value.
For ESI Type 0: The esi leaf value is directly configured by the operator.
For ESI Type 1: The AUTO enum must be used.
For ESI Type 2: The AUTO enum must be used.
For ESI Type 3: The directly configured or AUTO enum must be used.
For ESI Type 4: The directly configured or AUTO enum must be used.
For ESI Type 5: The directly configured or AUTO enum must be used.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """esi must be of a type compatible with union""",
          'defined-type': "openconfig-network-instance:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)""",
        })

    self.__esi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_esi(self):
    self.__esi = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=True)


  def _get_redundancy_mode(self):
    """
    Getter method for redundancy_mode, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/redundancy_mode (identityref)

    YANG Description: Multihoming options for load balancing of
traffic in the Ethernet Segment.
    """
    return self.__redundancy_mode
      
  def _set_redundancy_mode(self, v, load=False):
    """
    Setter method for redundancy_mode, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/redundancy_mode (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_redundancy_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_redundancy_mode() directly.

    YANG Description: Multihoming options for load balancing of
traffic in the Ethernet Segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="redundancy-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """redundancy_mode must be of a type compatible with identityref""",
          'defined-type': "openconfig-network-instance:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="redundancy-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)""",
        })

    self.__redundancy_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_redundancy_mode(self):
    self.__redundancy_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="redundancy-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=True)


  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  esi_type = __builtin__.property(_get_esi_type, _set_esi_type)
  esi = __builtin__.property(_get_esi, _set_esi)
  redundancy_mode = __builtin__.property(_get_redundancy_mode, _set_redundancy_mode)
  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('name', name), ('esi_type', esi_type), ('esi', esi), ('redundancy_mode', redundancy_mode), ('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/ethernet-segments/ethernet-segment/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for the Ethernet Segments.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__esi_type','__esi','__redundancy_mode','__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    self.__esi_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TYPE_0_OPERATOR_CONFIGURED': {'value': 0}, 'TYPE_1_LACP_BASED': {'value': 1}, 'TYPE_2_BRIDGE_PROTOCOL_BASED': {'value': 2}, 'TYPE_3_MAC_BASED': {'value': 3}, 'TYPE_4_ROUTER_ID_BASED': {'value': 4}, 'TYPE_5_AS_BASED': {'value': 5}},), default=six.text_type("TYPE_0_OPERATOR_CONFIGURED"), is_leaf=True, yang_name="esi-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi-type', is_config=False)
    self.__esi = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)
    self.__redundancy_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="redundancy-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'ethernet-segments', 'ethernet-segment', 'state']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/name (string)

    YANG Description: Ethernet Segment name
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Ethernet Segment name
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='string', is_config=False)


  def _get_esi_type(self):
    """
    Getter method for esi_type, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/esi_type (oc-evpn-types:esi-type)

    YANG Description: ESI Type is a 1-octet field (most significant octet) that
specifies the format of the remaining 9 octets (ESI Value).
    """
    return self.__esi_type
      
  def _set_esi_type(self, v, load=False):
    """
    Setter method for esi_type, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/esi_type (oc-evpn-types:esi-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_esi_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_esi_type() directly.

    YANG Description: ESI Type is a 1-octet field (most significant octet) that
specifies the format of the remaining 9 octets (ESI Value).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TYPE_0_OPERATOR_CONFIGURED': {'value': 0}, 'TYPE_1_LACP_BASED': {'value': 1}, 'TYPE_2_BRIDGE_PROTOCOL_BASED': {'value': 2}, 'TYPE_3_MAC_BASED': {'value': 3}, 'TYPE_4_ROUTER_ID_BASED': {'value': 4}, 'TYPE_5_AS_BASED': {'value': 5}},), default=six.text_type("TYPE_0_OPERATOR_CONFIGURED"), is_leaf=True, yang_name="esi-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi-type', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """esi_type must be of a type compatible with oc-evpn-types:esi-type""",
          'defined-type': "oc-evpn-types:esi-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TYPE_0_OPERATOR_CONFIGURED': {'value': 0}, 'TYPE_1_LACP_BASED': {'value': 1}, 'TYPE_2_BRIDGE_PROTOCOL_BASED': {'value': 2}, 'TYPE_3_MAC_BASED': {'value': 3}, 'TYPE_4_ROUTER_ID_BASED': {'value': 4}, 'TYPE_5_AS_BASED': {'value': 5}},), default=six.text_type("TYPE_0_OPERATOR_CONFIGURED"), is_leaf=True, yang_name="esi-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi-type', is_config=False)""",
        })

    self.__esi_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_esi_type(self):
    self.__esi_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'TYPE_0_OPERATOR_CONFIGURED': {'value': 0}, 'TYPE_1_LACP_BASED': {'value': 1}, 'TYPE_2_BRIDGE_PROTOCOL_BASED': {'value': 2}, 'TYPE_3_MAC_BASED': {'value': 3}, 'TYPE_4_ROUTER_ID_BASED': {'value': 4}, 'TYPE_5_AS_BASED': {'value': 5}},), default=six.text_type("TYPE_0_OPERATOR_CONFIGURED"), is_leaf=True, yang_name="esi-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='oc-evpn-types:esi-type', is_config=False)


  def _get_esi(self):
    """
    Getter method for esi, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/esi (union)

    YANG Description: Ethernet Segment Identifier (ESI) value.
For ESI Type 0: The esi leaf value is directly configured by the operator.
For ESI Type 1: The AUTO enum must be used.
For ESI Type 2: The AUTO enum must be used.
For ESI Type 3: The directly configured or AUTO enum must be used.
For ESI Type 4: The directly configured or AUTO enum must be used.
For ESI Type 5: The directly configured or AUTO enum must be used.
    """
    return self.__esi
      
  def _set_esi(self, v, load=False):
    """
    Setter method for esi, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/esi (union)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_esi is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_esi() directly.

    YANG Description: Ethernet Segment Identifier (ESI) value.
For ESI Type 0: The esi leaf value is directly configured by the operator.
For ESI Type 1: The AUTO enum must be used.
For ESI Type 2: The AUTO enum must be used.
For ESI Type 3: The directly configured or AUTO enum must be used.
For ESI Type 4: The directly configured or AUTO enum must be used.
For ESI Type 5: The directly configured or AUTO enum must be used.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """esi must be of a type compatible with union""",
          'defined-type': "openconfig-network-instance:union",
          'generated-type': """YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)""",
        })

    self.__esi = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_esi(self):
    self.__esi = YANGDynClass(base=[RestrictedClassType(base_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '[0-9a-fA-F]*'}), restriction_dict={'length': ['20']}),RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'AUTO': {}},),], is_leaf=True, yang_name="esi", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='union', is_config=False)


  def _get_redundancy_mode(self):
    """
    Getter method for redundancy_mode, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/redundancy_mode (identityref)

    YANG Description: Multihoming options for load balancing of
traffic in the Ethernet Segment.
    """
    return self.__redundancy_mode
      
  def _set_redundancy_mode(self, v, load=False):
    """
    Setter method for redundancy_mode, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/redundancy_mode (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_redundancy_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_redundancy_mode() directly.

    YANG Description: Multihoming options for load balancing of
traffic in the Ethernet Segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="redundancy-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """redundancy_mode must be of a type compatible with identityref""",
          'defined-type': "openconfig-network-instance:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="redundancy-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)""",
        })

    self.__redundancy_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_redundancy_mode(self):
    self.__redundancy_mode = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:SINGLE_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}, 'oc-evpn-types:ALL_ACTIVE': {'@module': 'openconfig-evpn-types', '@namespace': 'http://openconfig.net/yang/evpn-types'}},), is_leaf=True, yang_name="redundancy-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='identityref', is_config=False)


  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=False)

  name = __builtin__.property(_get_name)
  esi_type = __builtin__.property(_get_esi_type)
  esi = __builtin__.property(_get_esi)
  redundancy_mode = __builtin__.property(_get_redundancy_mode)
  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('name', name), ('esi_type', esi_type), ('esi', esi), ('redundancy_mode', redundancy_mode), ('interface', interface), ('subinterface', subinterface), ])


class yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/ethernet-segments/ethernet-segment/df-election/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for the Designated forwarding Election
  """
  __slots__ = ('_path_helper', '_extmethods', '__df_election_method','__preference','__revertive','__election_wait_time',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__df_election_method = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'DEFAULT': {'value': 0}, 'HIGHEST_RANDOM_WEIGHT': {'value': 1}, 'PREFERENCE': {'value': 2}},), is_leaf=True, yang_name="df-election-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=True)
    self.__preference = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    self.__revertive = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    self.__election_wait_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="election-wait-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'ethernet-segments', 'ethernet-segment', 'df-election', 'config']

  def _get_df_election_method(self):
    """
    Getter method for df_election_method, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config/df_election_method (enumeration)

    YANG Description: Select the Designated Forwarder Election (DF) election method
    """
    return self.__df_election_method
      
  def _set_df_election_method(self, v, load=False):
    """
    Setter method for df_election_method, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config/df_election_method (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_df_election_method is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_df_election_method() directly.

    YANG Description: Select the Designated Forwarder Election (DF) election method
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'DEFAULT': {'value': 0}, 'HIGHEST_RANDOM_WEIGHT': {'value': 1}, 'PREFERENCE': {'value': 2}},), is_leaf=True, yang_name="df-election-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """df_election_method must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'DEFAULT': {'value': 0}, 'HIGHEST_RANDOM_WEIGHT': {'value': 1}, 'PREFERENCE': {'value': 2}},), is_leaf=True, yang_name="df-election-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=True)""",
        })

    self.__df_election_method = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_df_election_method(self):
    self.__df_election_method = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'DEFAULT': {'value': 0}, 'HIGHEST_RANDOM_WEIGHT': {'value': 1}, 'PREFERENCE': {'value': 2}},), is_leaf=True, yang_name="df-election-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=True)


  def _get_preference(self):
    """
    Getter method for preference, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config/preference (uint16)

    YANG Description: Defines a 2-octet value that indicates the PE
preference to become the DF in the Ethernet-Segment.
    """
    return self.__preference
      
  def _set_preference(self, v, load=False):
    """
    Setter method for preference, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config/preference (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_preference is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_preference() directly.

    YANG Description: Defines a 2-octet value that indicates the PE
preference to become the DF in the Ethernet-Segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """preference must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)""",
        })

    self.__preference = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_preference(self):
    self.__preference = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=True)


  def _get_revertive(self):
    """
    Getter method for revertive, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config/revertive (boolean)

    YANG Description: The 'preempt' or 'revertive' behavior. This option will allow a
non-revertive behavior in the DF election.
    """
    return self.__revertive
      
  def _set_revertive(self, v, load=False):
    """
    Setter method for revertive, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config/revertive (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_revertive is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_revertive() directly.

    YANG Description: The 'preempt' or 'revertive' behavior. This option will allow a
non-revertive behavior in the DF election.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """revertive must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)""",
        })

    self.__revertive = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_revertive(self):
    self.__revertive = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=True)


  def _get_election_wait_time(self):
    """
    Getter method for election_wait_time, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config/election_wait_time (uint32)

    YANG Description: Designated Forwarder Election wait-time. When the DF timer expires,
the PE device selects the DF based on the highest preference value
    """
    return self.__election_wait_time
      
  def _set_election_wait_time(self, v, load=False):
    """
    Setter method for election_wait_time, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config/election_wait_time (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_election_wait_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_election_wait_time() directly.

    YANG Description: Designated Forwarder Election wait-time. When the DF timer expires,
the PE device selects the DF based on the highest preference value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="election-wait-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """election_wait_time must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="election-wait-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=True)""",
        })

    self.__election_wait_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_election_wait_time(self):
    self.__election_wait_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="election-wait-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=True)

  df_election_method = __builtin__.property(_get_df_election_method, _set_df_election_method)
  preference = __builtin__.property(_get_preference, _set_preference)
  revertive = __builtin__.property(_get_revertive, _set_revertive)
  election_wait_time = __builtin__.property(_get_election_wait_time, _set_election_wait_time)


  _pyangbind_elements = OrderedDict([('df_election_method', df_election_method), ('preference', preference), ('revertive', revertive), ('election_wait_time', election_wait_time), ])


class yc_state_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/ethernet-segments/ethernet-segment/df-election/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration parameters for the Designated forwarding Election
  """
  __slots__ = ('_path_helper', '_extmethods', '__df_election_method','__preference','__revertive','__election_wait_time',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__df_election_method = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'DEFAULT': {'value': 0}, 'HIGHEST_RANDOM_WEIGHT': {'value': 1}, 'PREFERENCE': {'value': 2}},), is_leaf=True, yang_name="df-election-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    self.__preference = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    self.__revertive = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    self.__election_wait_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="election-wait-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'ethernet-segments', 'ethernet-segment', 'df-election', 'state']

  def _get_df_election_method(self):
    """
    Getter method for df_election_method, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state/df_election_method (enumeration)

    YANG Description: Select the Designated Forwarder Election (DF) election method
    """
    return self.__df_election_method
      
  def _set_df_election_method(self, v, load=False):
    """
    Setter method for df_election_method, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state/df_election_method (enumeration)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_df_election_method is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_df_election_method() directly.

    YANG Description: Select the Designated Forwarder Election (DF) election method
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'DEFAULT': {'value': 0}, 'HIGHEST_RANDOM_WEIGHT': {'value': 1}, 'PREFERENCE': {'value': 2}},), is_leaf=True, yang_name="df-election-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """df_election_method must be of a type compatible with enumeration""",
          'defined-type': "openconfig-network-instance:enumeration",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'DEFAULT': {'value': 0}, 'HIGHEST_RANDOM_WEIGHT': {'value': 1}, 'PREFERENCE': {'value': 2}},), is_leaf=True, yang_name="df-election-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)""",
        })

    self.__df_election_method = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_df_election_method(self):
    self.__df_election_method = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'DEFAULT': {'value': 0}, 'HIGHEST_RANDOM_WEIGHT': {'value': 1}, 'PREFERENCE': {'value': 2}},), is_leaf=True, yang_name="df-election-method", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='enumeration', is_config=False)


  def _get_preference(self):
    """
    Getter method for preference, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state/preference (uint16)

    YANG Description: Defines a 2-octet value that indicates the PE
preference to become the DF in the Ethernet-Segment.
    """
    return self.__preference
      
  def _set_preference(self, v, load=False):
    """
    Setter method for preference, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state/preference (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_preference is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_preference() directly.

    YANG Description: Defines a 2-octet value that indicates the PE
preference to become the DF in the Ethernet-Segment.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """preference must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)""",
        })

    self.__preference = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_preference(self):
    self.__preference = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="preference", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint16', is_config=False)


  def _get_revertive(self):
    """
    Getter method for revertive, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state/revertive (boolean)

    YANG Description: The 'preempt' or 'revertive' behavior. This option will allow a
non-revertive behavior in the DF election.
    """
    return self.__revertive
      
  def _set_revertive(self, v, load=False):
    """
    Setter method for revertive, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state/revertive (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_revertive is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_revertive() directly.

    YANG Description: The 'preempt' or 'revertive' behavior. This option will allow a
non-revertive behavior in the DF election.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """revertive must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)""",
        })

    self.__revertive = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_revertive(self):
    self.__revertive = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="revertive", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='boolean', is_config=False)


  def _get_election_wait_time(self):
    """
    Getter method for election_wait_time, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state/election_wait_time (uint32)

    YANG Description: Designated Forwarder Election wait-time. When the DF timer expires,
the PE device selects the DF based on the highest preference value
    """
    return self.__election_wait_time
      
  def _set_election_wait_time(self, v, load=False):
    """
    Setter method for election_wait_time, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state/election_wait_time (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_election_wait_time is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_election_wait_time() directly.

    YANG Description: Designated Forwarder Election wait-time. When the DF timer expires,
the PE device selects the DF based on the highest preference value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="election-wait-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """election_wait_time must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="election-wait-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)""",
        })

    self.__election_wait_time = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_election_wait_time(self):
    self.__election_wait_time = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="election-wait-time", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='uint32', is_config=False)

  df_election_method = __builtin__.property(_get_df_election_method)
  preference = __builtin__.property(_get_preference)
  revertive = __builtin__.property(_get_revertive)
  election_wait_time = __builtin__.property(_get_election_wait_time)


  _pyangbind_elements = OrderedDict([('df_election_method', df_election_method), ('preference', preference), ('revertive', revertive), ('election_wait_time', election_wait_time), ])


class yc_df_election_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/ethernet-segments/ethernet-segment/df-election. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top container for the configuration and state parameters
for the Designated forwarding Election
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'df-election'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'ethernet-segments', 'ethernet-segment', 'df-election']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config (container)

    YANG Description: Configuration parameters for the Designated forwarding Election
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration parameters for the Designated forwarding Election
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state (container)

    YANG Description: Configuration parameters for the Designated forwarding Election
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/df_election/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Configuration parameters for the Designated forwarding Election
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_ethernet_segment_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-network-instance - based on the path /network-instances/network-instance/evpn/ethernet-segments/ethernet-segment. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of Ethernet Segments.
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__config','__state','__df_election',)

  _yang_name = 'ethernet-segment'
  _yang_namespace = 'http://openconfig.net/yang/network-instance'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    self.__df_election = YANGDynClass(base=yc_df_election_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_df_election, is_container='container', yang_name="df-election", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['network-instances', 'network-instance', 'evpn', 'ethernet-segments', 'ethernet-segment']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/name (leafref)

    YANG Description: Ethernet Segment Name 
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/name (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Ethernet Segment Name 
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config (container)

    YANG Description: Configuration data for the Ethernet Segments.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the Ethernet Segments.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/network-instance', defining_module='openconfig-network-instance', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state (container)

    YANG Description: Operational state data for the Ethernet Segments.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /network_instances/network_instance/evpn/ethernet_segments/ethernet_segment/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for the Ethernet Segments.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_network_instance__network_instances_network_instance_evpn_ethernet_segments_ethernet_segment_state, is_container='container', yang_name="state",