# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class yc_config_openconfig_relay_agent__relay_agent_dhcp_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for global DHCPv4
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable_relay_agent',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable_relay_agent = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'config']

  def _get_enable_relay_agent(self):
    """
    Getter method for enable_relay_agent, mapped from YANG variable /relay_agent/dhcp/config/enable_relay_agent (boolean)

    YANG Description: Enables DHCP/BOOTP relay agent on all interfaces
    """
    return self.__enable_relay_agent
      
  def _set_enable_relay_agent(self, v, load=False):
    """
    Setter method for enable_relay_agent, mapped from YANG variable /relay_agent/dhcp/config/enable_relay_agent (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_relay_agent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_relay_agent() directly.

    YANG Description: Enables DHCP/BOOTP relay agent on all interfaces
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_relay_agent must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable_relay_agent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_relay_agent(self):
    self.__enable_relay_agent = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)

  enable_relay_agent = __builtin__.property(_get_enable_relay_agent, _set_enable_relay_agent)


  _pyangbind_elements = OrderedDict([('enable_relay_agent', enable_relay_agent), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcp_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data global DHCPv4
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable_relay_agent',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable_relay_agent = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'state']

  def _get_enable_relay_agent(self):
    """
    Getter method for enable_relay_agent, mapped from YANG variable /relay_agent/dhcp/state/enable_relay_agent (boolean)

    YANG Description: Enables DHCP/BOOTP relay agent on all interfaces
    """
    return self.__enable_relay_agent
      
  def _set_enable_relay_agent(self, v, load=False):
    """
    Setter method for enable_relay_agent, mapped from YANG variable /relay_agent/dhcp/state/enable_relay_agent (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_relay_agent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_relay_agent() directly.

    YANG Description: Enables DHCP/BOOTP relay agent on all interfaces
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_relay_agent must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable_relay_agent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_relay_agent(self):
    self.__enable_relay_agent = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)

  enable_relay_agent = __builtin__.property(_get_enable_relay_agent)


  _pyangbind_elements = OrderedDict([('enable_relay_agent', enable_relay_agent), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/agent-information-option/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the relay agent information
option
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'agent-information-option', 'config']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /relay_agent/dhcp/agent_information_option/config/enable (boolean)

    YANG Description: Enable sending the DHCP option for Relay Agent information
-- option 82.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /relay_agent/dhcp/agent_information_option/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable sending the DHCP option for Relay Agent information
-- option 82.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)

  enable = __builtin__.property(_get_enable, _set_enable)


  _pyangbind_elements = OrderedDict([('enable', enable), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/agent-information-option/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for agent information at global
level
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'agent-information-option', 'state']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /relay_agent/dhcp/agent_information_option/state/enable (boolean)

    YANG Description: Enable sending the DHCP option for Relay Agent information
-- option 82.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /relay_agent/dhcp/agent_information_option/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable sending the DHCP option for Relay Agent information
-- option 82.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)

  enable = __builtin__.property(_get_enable)


  _pyangbind_elements = OrderedDict([('enable', enable), ])


class yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_agent_information_option(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/agent-information-option. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for relay agent information option
data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'agent-information-option'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'agent-information-option']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcp/agent_information_option/config (container)

    YANG Description: Configuration data for the relay agent information
option
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcp/agent_information_option/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the relay agent information
option
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcp/agent_information_option/state (container)

    YANG Description: Operational state data for agent information at global
level
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcp/agent_information_option/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for agent information at global
level
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_agent_information_option_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for relay agent interfaces.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__enable','__helper_address',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=True)
    self.__enable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    self.__helper_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ip-address', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'config']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/config/id (oc-if:interface-id)

    YANG Description: Name of the interface on which relay agent is active
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/config/id (oc-if:interface-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Name of the interface on which relay agent is active
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with oc-if:interface-id""",
          'defined-type': "oc-if:interface-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=True)


  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/config/enable (boolean)

    YANG Description: Enables the relay agent on the referenced interface.
At least one helper address should also be configured
for forwarding requested.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enables the relay agent on the referenced interface.
At least one helper address should also be configured
for forwarding requested.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)


  def _get_helper_address(self):
    """
    Getter method for helper_address, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/config/helper_address (inet:ip-address)

    YANG Description: List of IPv4 or IPv6 addresses of DHCP servers to which the
relay agent should forward DHCPv4 requests.  The relay agent is
expected to forward DHCPv4/BOOTP requests to all listed
server addresses when DHCPv4 relaying is enabled globally, or
on the interface.
    """
    return self.__helper_address
      
  def _set_helper_address(self, v, load=False):
    """
    Setter method for helper_address, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/config/helper_address (inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_helper_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_helper_address() directly.

    YANG Description: List of IPv4 or IPv6 addresses of DHCP servers to which the
relay agent should forward DHCPv4 requests.  The relay agent is
expected to forward DHCPv4/BOOTP requests to all listed
server addresses when DHCPv4 relaying is enabled globally, or
on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ip-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """helper_address must be of a type compatible with inet:ip-address""",
          'defined-type': "inet:ip-address",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ip-address', is_config=True)""",
        })

    self.__helper_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_helper_address(self):
    self.__helper_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ip-address', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  enable = __builtin__.property(_get_enable, _set_enable)
  helper_address = __builtin__.property(_get_helper_address, _set_helper_address)


  _pyangbind_elements = OrderedDict([('id', id), ('enable', enable), ('helper_address', helper_address), ])


class yc_counters_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Counters and statistics for relay agent operation.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_dropped','__invalid_opcode','__invalid_options','__bootrequest_received','__dhcp_decline_received','__dhcp_discover_received','__dhcp_inform_received','__dhcp_release_received','__dhcp_request_received','__bootrequest_sent','__bootreply_sent','__dhcp_offer_sent','__dhcp_ack_sent','__dhcp_nack_sent',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_dropped = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-dropped", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__invalid_opcode = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-opcode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__invalid_options = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__bootrequest_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootrequest-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcp_decline_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-decline-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcp_discover_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-discover-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcp_inform_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-inform-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcp_release_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-release-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcp_request_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__bootrequest_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootrequest-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__bootreply_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootreply-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcp_offer_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-offer-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcp_ack_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-ack-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcp_nack_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-nack-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'state', 'counters']

  def _get_total_dropped(self):
    """
    Getter method for total_dropped, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/total_dropped (yang:counter64)

    YANG Description: Total number of DHCP packets dropped by the relay agent
    """
    return self.__total_dropped
      
  def _set_total_dropped(self, v, load=False):
    """
    Setter method for total_dropped, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/total_dropped (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_dropped is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_dropped() directly.

    YANG Description: Total number of DHCP packets dropped by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-dropped", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_dropped must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-dropped", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__total_dropped = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_dropped(self):
    self.__total_dropped = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-dropped", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_invalid_opcode(self):
    """
    Getter method for invalid_opcode, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/invalid_opcode (yang:counter64)

    YANG Description: Number of DHCP packets dropped due to an invalid opcode
    """
    return self.__invalid_opcode
      
  def _set_invalid_opcode(self, v, load=False):
    """
    Setter method for invalid_opcode, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/invalid_opcode (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_invalid_opcode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_invalid_opcode() directly.

    YANG Description: Number of DHCP packets dropped due to an invalid opcode
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-opcode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """invalid_opcode must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-opcode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__invalid_opcode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_invalid_opcode(self):
    self.__invalid_opcode = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-opcode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_invalid_options(self):
    """
    Getter method for invalid_options, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/invalid_options (yang:counter64)

    YANG Description: Number of DHCP packets dropped due to an invalid option
    """
    return self.__invalid_options
      
  def _set_invalid_options(self, v, load=False):
    """
    Setter method for invalid_options, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/invalid_options (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_invalid_options is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_invalid_options() directly.

    YANG Description: Number of DHCP packets dropped due to an invalid option
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """invalid_options must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__invalid_options = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_invalid_options(self):
    self.__invalid_options = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_bootrequest_received(self):
    """
    Getter method for bootrequest_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/bootrequest_received (yang:counter64)

    YANG Description: BOOTREQUEST messages received by the relay agent
    """
    return self.__bootrequest_received
      
  def _set_bootrequest_received(self, v, load=False):
    """
    Setter method for bootrequest_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/bootrequest_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bootrequest_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bootrequest_received() directly.

    YANG Description: BOOTREQUEST messages received by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootrequest-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bootrequest_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootrequest-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__bootrequest_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bootrequest_received(self):
    self.__bootrequest_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootrequest-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcp_decline_received(self):
    """
    Getter method for dhcp_decline_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_decline_received (yang:counter64)

    YANG Description: DHCP DECLINE messages received by the relay agent
    """
    return self.__dhcp_decline_received
      
  def _set_dhcp_decline_received(self, v, load=False):
    """
    Setter method for dhcp_decline_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_decline_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_decline_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_decline_received() directly.

    YANG Description: DHCP DECLINE messages received by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-decline-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_decline_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-decline-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcp_decline_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_decline_received(self):
    self.__dhcp_decline_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-decline-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcp_discover_received(self):
    """
    Getter method for dhcp_discover_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_discover_received (yang:counter64)

    YANG Description: DHCP DISCOVER messages received by the relay agent
    """
    return self.__dhcp_discover_received
      
  def _set_dhcp_discover_received(self, v, load=False):
    """
    Setter method for dhcp_discover_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_discover_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_discover_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_discover_received() directly.

    YANG Description: DHCP DISCOVER messages received by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-discover-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_discover_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-discover-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcp_discover_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_discover_received(self):
    self.__dhcp_discover_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-discover-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcp_inform_received(self):
    """
    Getter method for dhcp_inform_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_inform_received (yang:counter64)

    YANG Description: DHCP INFORM messages received by the relay agent
    """
    return self.__dhcp_inform_received
      
  def _set_dhcp_inform_received(self, v, load=False):
    """
    Setter method for dhcp_inform_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_inform_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_inform_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_inform_received() directly.

    YANG Description: DHCP INFORM messages received by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-inform-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_inform_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-inform-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcp_inform_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_inform_received(self):
    self.__dhcp_inform_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-inform-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcp_release_received(self):
    """
    Getter method for dhcp_release_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_release_received (yang:counter64)

    YANG Description: DHCP RELEASE messages received by the relay agent
    """
    return self.__dhcp_release_received
      
  def _set_dhcp_release_received(self, v, load=False):
    """
    Setter method for dhcp_release_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_release_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_release_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_release_received() directly.

    YANG Description: DHCP RELEASE messages received by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-release-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_release_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-release-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcp_release_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_release_received(self):
    self.__dhcp_release_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-release-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcp_request_received(self):
    """
    Getter method for dhcp_request_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_request_received (yang:counter64)

    YANG Description: DHCP REQUEST messages received by the relay agent
    """
    return self.__dhcp_request_received
      
  def _set_dhcp_request_received(self, v, load=False):
    """
    Setter method for dhcp_request_received, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_request_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_request_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_request_received() directly.

    YANG Description: DHCP REQUEST messages received by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_request_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcp_request_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_request_received(self):
    self.__dhcp_request_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_bootrequest_sent(self):
    """
    Getter method for bootrequest_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/bootrequest_sent (yang:counter64)

    YANG Description: BOOTREQUEST messages forwarded by the relay agent
    """
    return self.__bootrequest_sent
      
  def _set_bootrequest_sent(self, v, load=False):
    """
    Setter method for bootrequest_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/bootrequest_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bootrequest_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bootrequest_sent() directly.

    YANG Description: BOOTREQUEST messages forwarded by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootrequest-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bootrequest_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootrequest-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__bootrequest_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bootrequest_sent(self):
    self.__bootrequest_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootrequest-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_bootreply_sent(self):
    """
    Getter method for bootreply_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/bootreply_sent (yang:counter64)

    YANG Description: BOOTREPLY messages forwarded by the relay agent
    """
    return self.__bootreply_sent
      
  def _set_bootreply_sent(self, v, load=False):
    """
    Setter method for bootreply_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/bootreply_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_bootreply_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_bootreply_sent() directly.

    YANG Description: BOOTREPLY messages forwarded by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootreply-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """bootreply_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootreply-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__bootreply_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_bootreply_sent(self):
    self.__bootreply_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="bootreply-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcp_offer_sent(self):
    """
    Getter method for dhcp_offer_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_offer_sent (yang:counter64)

    YANG Description: DHCP OFFER messages sent by the relay agent
    """
    return self.__dhcp_offer_sent
      
  def _set_dhcp_offer_sent(self, v, load=False):
    """
    Setter method for dhcp_offer_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_offer_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_offer_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_offer_sent() directly.

    YANG Description: DHCP OFFER messages sent by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-offer-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_offer_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-offer-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcp_offer_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_offer_sent(self):
    self.__dhcp_offer_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-offer-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcp_ack_sent(self):
    """
    Getter method for dhcp_ack_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_ack_sent (yang:counter64)

    YANG Description: DHCP ACK messages sent by the relay agent
    """
    return self.__dhcp_ack_sent
      
  def _set_dhcp_ack_sent(self, v, load=False):
    """
    Setter method for dhcp_ack_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_ack_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_ack_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_ack_sent() directly.

    YANG Description: DHCP ACK messages sent by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-ack-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_ack_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-ack-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcp_ack_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_ack_sent(self):
    self.__dhcp_ack_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-ack-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcp_nack_sent(self):
    """
    Getter method for dhcp_nack_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_nack_sent (yang:counter64)

    YANG Description: DHCP NACK messages sent by the relay agent
    """
    return self.__dhcp_nack_sent
      
  def _set_dhcp_nack_sent(self, v, load=False):
    """
    Setter method for dhcp_nack_sent, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters/dhcp_nack_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp_nack_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp_nack_sent() directly.

    YANG Description: DHCP NACK messages sent by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-nack-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp_nack_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-nack-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcp_nack_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp_nack_sent(self):
    self.__dhcp_nack_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcp-nack-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)

  total_dropped = __builtin__.property(_get_total_dropped)
  invalid_opcode = __builtin__.property(_get_invalid_opcode)
  invalid_options = __builtin__.property(_get_invalid_options)
  bootrequest_received = __builtin__.property(_get_bootrequest_received)
  dhcp_decline_received = __builtin__.property(_get_dhcp_decline_received)
  dhcp_discover_received = __builtin__.property(_get_dhcp_discover_received)
  dhcp_inform_received = __builtin__.property(_get_dhcp_inform_received)
  dhcp_release_received = __builtin__.property(_get_dhcp_release_received)
  dhcp_request_received = __builtin__.property(_get_dhcp_request_received)
  bootrequest_sent = __builtin__.property(_get_bootrequest_sent)
  bootreply_sent = __builtin__.property(_get_bootreply_sent)
  dhcp_offer_sent = __builtin__.property(_get_dhcp_offer_sent)
  dhcp_ack_sent = __builtin__.property(_get_dhcp_ack_sent)
  dhcp_nack_sent = __builtin__.property(_get_dhcp_nack_sent)


  _pyangbind_elements = OrderedDict([('total_dropped', total_dropped), ('invalid_opcode', invalid_opcode), ('invalid_options', invalid_options), ('bootrequest_received', bootrequest_received), ('dhcp_decline_received', dhcp_decline_received), ('dhcp_discover_received', dhcp_discover_received), ('dhcp_inform_received', dhcp_inform_received), ('dhcp_release_received', dhcp_release_received), ('dhcp_request_received', dhcp_request_received), ('bootrequest_sent', bootrequest_sent), ('bootreply_sent', bootreply_sent), ('dhcp_offer_sent', dhcp_offer_sent), ('dhcp_ack_sent', dhcp_ack_sent), ('dhcp_nack_sent', dhcp_nack_sent), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for relay agent interfaces.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__enable','__helper_address','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=False)
    self.__enable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    self.__helper_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ip-address', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/id (oc-if:interface-id)

    YANG Description: Name of the interface on which relay agent is active
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/id (oc-if:interface-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Name of the interface on which relay agent is active
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with oc-if:interface-id""",
          'defined-type': "oc-if:interface-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=False)


  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/enable (boolean)

    YANG Description: Enables the relay agent on the referenced interface.
At least one helper address should also be configured
for forwarding requested.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enables the relay agent on the referenced interface.
At least one helper address should also be configured
for forwarding requested.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)


  def _get_helper_address(self):
    """
    Getter method for helper_address, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/helper_address (inet:ip-address)

    YANG Description: List of IPv4 or IPv6 addresses of DHCP servers to which the
relay agent should forward DHCPv4 requests.  The relay agent is
expected to forward DHCPv4/BOOTP requests to all listed
server addresses when DHCPv4 relaying is enabled globally, or
on the interface.
    """
    return self.__helper_address
      
  def _set_helper_address(self, v, load=False):
    """
    Setter method for helper_address, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/helper_address (inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_helper_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_helper_address() directly.

    YANG Description: List of IPv4 or IPv6 addresses of DHCP servers to which the
relay agent should forward DHCPv4 requests.  The relay agent is
expected to forward DHCPv4/BOOTP requests to all listed
server addresses when DHCPv4 relaying is enabled globally, or
on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """helper_address must be of a type compatible with inet:ip-address""",
          'defined-type': "inet:ip-address",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ip-address', is_config=False)""",
        })

    self.__helper_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_helper_address(self):
    self.__helper_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ip-address', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters (container)

    YANG Description: Counters and statistics for relay agent operation.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Counters and statistics for relay agent operation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  enable = __builtin__.property(_get_enable)
  helper_address = __builtin__.property(_get_helper_address)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('id', id), ('enable', enable), ('helper_address', helper_address), ('counters', counters), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/agent-information-option/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for the relay agent information
option
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__circuit_id','__remote_id',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    self.__circuit_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)
    self.__remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'agent-information-option', 'config']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/config/enable (boolean)

    YANG Description: Enable sending the DHCP option for Relay Agent information
-- option 82.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable sending the DHCP option for Relay Agent information
-- option 82.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)


  def _get_circuit_id(self):
    """
    Getter method for circuit_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/config/circuit_id (string)

    YANG Description: Encodes an agent-local identifier of the circuit from which
a DHCP client-to-server packet was received.  It is intended
for use by agents in relaying DHCP responses back to the
proper circuit.  The circuit id is an opaque value
    """
    return self.__circuit_id
      
  def _set_circuit_id(self, v, load=False):
    """
    Setter method for circuit_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/config/circuit_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_circuit_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_circuit_id() directly.

    YANG Description: Encodes an agent-local identifier of the circuit from which
a DHCP client-to-server packet was received.  It is intended
for use by agents in relaying DHCP responses back to the
proper circuit.  The circuit id is an opaque value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """circuit_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)""",
        })

    self.__circuit_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_circuit_id(self):
    self.__circuit_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)


  def _get_remote_id(self):
    """
    Getter method for remote_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/config/remote_id (string)

    YANG Description: Provides a mechanism to identify the remote host end of
the circuit.  The remote-id should be thought of as an
opaque value, but must be globally unique.
    """
    return self.__remote_id
      
  def _set_remote_id(self, v, load=False):
    """
    Setter method for remote_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/config/remote_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_id() directly.

    YANG Description: Provides a mechanism to identify the remote host end of
the circuit.  The remote-id should be thought of as an
opaque value, but must be globally unique.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)""",
        })

    self.__remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_id(self):
    self.__remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)

  enable = __builtin__.property(_get_enable, _set_enable)
  circuit_id = __builtin__.property(_get_circuit_id, _set_circuit_id)
  remote_id = __builtin__.property(_get_remote_id, _set_remote_id)


  _pyangbind_elements = OrderedDict([('enable', enable), ('circuit_id', circuit_id), ('remote_id', remote_id), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/agent-information-option/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable','__circuit_id','__remote_id','__sent_circuit_id','__sent_remote_id',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    self.__circuit_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    self.__remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    self.__sent_circuit_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    self.__sent_remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'agent-information-option', 'state']

  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/enable (boolean)

    YANG Description: Enable sending the DHCP option for Relay Agent information
-- option 82.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enable sending the DHCP option for Relay Agent information
-- option 82.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)


  def _get_circuit_id(self):
    """
    Getter method for circuit_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/circuit_id (string)

    YANG Description: Encodes an agent-local identifier of the circuit from which
a DHCP client-to-server packet was received.  It is intended
for use by agents in relaying DHCP responses back to the
proper circuit.  The circuit id is an opaque value
    """
    return self.__circuit_id
      
  def _set_circuit_id(self, v, load=False):
    """
    Setter method for circuit_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/circuit_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_circuit_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_circuit_id() directly.

    YANG Description: Encodes an agent-local identifier of the circuit from which
a DHCP client-to-server packet was received.  It is intended
for use by agents in relaying DHCP responses back to the
proper circuit.  The circuit id is an opaque value
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """circuit_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)""",
        })

    self.__circuit_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_circuit_id(self):
    self.__circuit_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)


  def _get_remote_id(self):
    """
    Getter method for remote_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/remote_id (string)

    YANG Description: Provides a mechanism to identify the remote host end of
the circuit.  The remote-id should be thought of as an
opaque value, but must be globally unique.
    """
    return self.__remote_id
      
  def _set_remote_id(self, v, load=False):
    """
    Setter method for remote_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/remote_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_id() directly.

    YANG Description: Provides a mechanism to identify the remote host end of
the circuit.  The remote-id should be thought of as an
opaque value, but must be globally unique.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)""",
        })

    self.__remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_id(self):
    self.__remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)


  def _get_sent_circuit_id(self):
    """
    Getter method for sent_circuit_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/sent_circuit_id (string)

    YANG Description: Reports the circuit-id sent by the system to the DHCP
server.
    """
    return self.__sent_circuit_id
      
  def _set_sent_circuit_id(self, v, load=False):
    """
    Setter method for sent_circuit_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/sent_circuit_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sent_circuit_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sent_circuit_id() directly.

    YANG Description: Reports the circuit-id sent by the system to the DHCP
server.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sent-circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sent_circuit_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)""",
        })

    self.__sent_circuit_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sent_circuit_id(self):
    self.__sent_circuit_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-circuit-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)


  def _get_sent_remote_id(self):
    """
    Getter method for sent_remote_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/sent_remote_id (string)

    YANG Description: Reports the remote-id value sent by the system to the DHCP
server
    """
    return self.__sent_remote_id
      
  def _set_sent_remote_id(self, v, load=False):
    """
    Setter method for sent_remote_id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state/sent_remote_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sent_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sent_remote_id() directly.

    YANG Description: Reports the remote-id value sent by the system to the DHCP
server
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sent-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sent_remote_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)""",
        })

    self.__sent_remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sent_remote_id(self):
    self.__sent_remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)

  enable = __builtin__.property(_get_enable)
  circuit_id = __builtin__.property(_get_circuit_id)
  remote_id = __builtin__.property(_get_remote_id)
  sent_circuit_id = __builtin__.property(_get_sent_circuit_id)
  sent_remote_id = __builtin__.property(_get_sent_remote_id)


  _pyangbind_elements = OrderedDict([('enable', enable), ('circuit_id', circuit_id), ('remote_id', remote_id), ('sent_circuit_id', sent_circuit_id), ('sent_remote_id', sent_remote_id), ])


class yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface/agent-information-option. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for relay agent information option
data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'agent-information-option'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface', 'agent-information-option']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/config (container)

    YANG Description: Configuration data for the relay agent information
option
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for the relay agent information
option
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state (container)

    YANG Description: Operational state data 
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_interface_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which the relay agent is
configured.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__config','__state','__interface_ref','__agent_information_option',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__agent_information_option = YANGDynClass(base=yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option, is_container='container', yang_name="agent-information-option", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces', 'interface']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/id (leafref)

    YANG Description: Reference to the interface list key
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to the interface list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/config (container)

    YANG Description: Configuration data for relay agent interfaces.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for relay agent interfaces.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state (container)

    YANG Description: Operational state data for relay agent interfaces.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for relay agent interfaces.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_agent_information_option(self):
    """
    Getter method for agent_information_option, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option (container)

    YANG Description: Top-level container for relay agent information option
data
    """
    return self.__agent_information_option
      
  def _set_agent_information_option(self, v, load=False):
    """
    Setter method for agent_information_option, mapped from YANG variable /relay_agent/dhcp/interfaces/interface/agent_information_option (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_agent_information_option is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_agent_information_option() directly.

    YANG Description: Top-level container for relay agent information option
data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option, is_container='container', yang_name="agent-information-option", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """agent_information_option must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option, is_container='container', yang_name="agent-information-option", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__agent_information_option = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_agent_information_option(self):
    self.__agent_information_option = YANGDynClass(base=yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface_agent_information_option, is_container='container', yang_name="agent-information-option", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)
  agent_information_option = __builtin__.property(_get_agent_information_option, _set_agent_information_option)


  _pyangbind_elements = OrderedDict([('id', id), ('config', config), ('state', state), ('interface_ref', interface_ref), ('agent_information_option', agent_information_option), ])


class yc_interfaces_openconfig_relay_agent__relay_agent_dhcp_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interface references.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("id",yc_interface_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface (list)

    YANG Description: List of interfaces on which the relay agent is
configured.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /relay_agent/dhcp/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which the relay agent is
configured.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_interface_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_interface_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("id",yc_interface_openconfig_relay_agent__relay_agent_dhcp_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_dhcp_openconfig_relay_agent__relay_agent_dhcp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for global relay agent data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__agent_information_option','__interfaces',)

  _yang_name = 'dhcp'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__agent_information_option = YANGDynClass(base=yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_agent_information_option, is_container='container', yang_name="agent-information-option", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_relay_agent__relay_agent_dhcp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcp']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcp/config (container)

    YANG Description: Configuration data for global DHCPv4
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcp/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for global DHCPv4
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcp_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcp/state (container)

    YANG Description: Operational state data global DHCPv4
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcp/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data global DHCPv4
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcp_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_agent_information_option(self):
    """
    Getter method for agent_information_option, mapped from YANG variable /relay_agent/dhcp/agent_information_option (container)

    YANG Description: Top-level container for relay agent information option
data
    """
    return self.__agent_information_option
      
  def _set_agent_information_option(self, v, load=False):
    """
    Setter method for agent_information_option, mapped from YANG variable /relay_agent/dhcp/agent_information_option (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_agent_information_option is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_agent_information_option() directly.

    YANG Description: Top-level container for relay agent information option
data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_agent_information_option, is_container='container', yang_name="agent-information-option", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """agent_information_option must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_agent_information_option, is_container='container', yang_name="agent-information-option", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__agent_information_option = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_agent_information_option(self):
    self.__agent_information_option = YANGDynClass(base=yc_agent_information_option_openconfig_relay_agent__relay_agent_dhcp_agent_information_option, is_container='container', yang_name="agent-information-option", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /relay_agent/dhcp/interfaces (container)

    YANG Description: Enclosing container for the list of interface references.
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /relay_agent/dhcp/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the list of interface references.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_relay_agent__relay_agent_dhcp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_relay_agent__relay_agent_dhcp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_relay_agent__relay_agent_dhcp_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  agent_information_option = __builtin__.property(_get_agent_information_option, _set_agent_information_option)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('agent_information_option', agent_information_option), ('interfaces', interfaces), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcpv6_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for global DHCPv6
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable_relay_agent',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable_relay_agent = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'config']

  def _get_enable_relay_agent(self):
    """
    Getter method for enable_relay_agent, mapped from YANG variable /relay_agent/dhcpv6/config/enable_relay_agent (boolean)

    YANG Description: Enables DHCP/BOOTP relay agent on all interfaces
    """
    return self.__enable_relay_agent
      
  def _set_enable_relay_agent(self, v, load=False):
    """
    Setter method for enable_relay_agent, mapped from YANG variable /relay_agent/dhcpv6/config/enable_relay_agent (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_relay_agent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_relay_agent() directly.

    YANG Description: Enables DHCP/BOOTP relay agent on all interfaces
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_relay_agent must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable_relay_agent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_relay_agent(self):
    self.__enable_relay_agent = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)

  enable_relay_agent = __builtin__.property(_get_enable_relay_agent, _set_enable_relay_agent)


  _pyangbind_elements = OrderedDict([('enable_relay_agent', enable_relay_agent), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcpv6_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data global DHCPv6
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable_relay_agent',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable_relay_agent = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'state']

  def _get_enable_relay_agent(self):
    """
    Getter method for enable_relay_agent, mapped from YANG variable /relay_agent/dhcpv6/state/enable_relay_agent (boolean)

    YANG Description: Enables DHCP/BOOTP relay agent on all interfaces
    """
    return self.__enable_relay_agent
      
  def _set_enable_relay_agent(self, v, load=False):
    """
    Setter method for enable_relay_agent, mapped from YANG variable /relay_agent/dhcpv6/state/enable_relay_agent (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_relay_agent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_relay_agent() directly.

    YANG Description: Enables DHCP/BOOTP relay agent on all interfaces
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_relay_agent must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable_relay_agent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_relay_agent(self):
    self.__enable_relay_agent = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)

  enable_relay_agent = __builtin__.property(_get_enable_relay_agent)


  _pyangbind_elements = OrderedDict([('enable_relay_agent', enable_relay_agent), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcpv6_options_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/options/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable_interface_id','__enable_remote_id',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable_interface_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    self.__enable_remote_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'options', 'config']

  def _get_enable_interface_id(self):
    """
    Getter method for enable_interface_id, mapped from YANG variable /relay_agent/dhcpv6/options/config/enable_interface_id (boolean)

    YANG Description: Enables DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    return self.__enable_interface_id
      
  def _set_enable_interface_id(self, v, load=False):
    """
    Setter method for enable_interface_id, mapped from YANG variable /relay_agent/dhcpv6/options/config/enable_interface_id (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_interface_id() directly.

    YANG Description: Enables DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_interface_id must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable_interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_interface_id(self):
    self.__enable_interface_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)


  def _get_enable_remote_id(self):
    """
    Getter method for enable_remote_id, mapped from YANG variable /relay_agent/dhcpv6/options/config/enable_remote_id (boolean)

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    return self.__enable_remote_id
      
  def _set_enable_remote_id(self, v, load=False):
    """
    Setter method for enable_remote_id, mapped from YANG variable /relay_agent/dhcpv6/options/config/enable_remote_id (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_remote_id() directly.

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_remote_id must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable_remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_remote_id(self):
    self.__enable_remote_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)

  enable_interface_id = __builtin__.property(_get_enable_interface_id, _set_enable_interface_id)
  enable_remote_id = __builtin__.property(_get_enable_remote_id, _set_enable_remote_id)


  _pyangbind_elements = OrderedDict([('enable_interface_id', enable_interface_id), ('enable_remote_id', enable_remote_id), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcpv6_options_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/options/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for DHCPv6 agent option on an
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable_interface_id','__enable_remote_id',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable_interface_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    self.__enable_remote_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'options', 'state']

  def _get_enable_interface_id(self):
    """
    Getter method for enable_interface_id, mapped from YANG variable /relay_agent/dhcpv6/options/state/enable_interface_id (boolean)

    YANG Description: Enables DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    return self.__enable_interface_id
      
  def _set_enable_interface_id(self, v, load=False):
    """
    Setter method for enable_interface_id, mapped from YANG variable /relay_agent/dhcpv6/options/state/enable_interface_id (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_interface_id() directly.

    YANG Description: Enables DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_interface_id must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable_interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_interface_id(self):
    self.__enable_interface_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)


  def _get_enable_remote_id(self):
    """
    Getter method for enable_remote_id, mapped from YANG variable /relay_agent/dhcpv6/options/state/enable_remote_id (boolean)

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    return self.__enable_remote_id
      
  def _set_enable_remote_id(self, v, load=False):
    """
    Setter method for enable_remote_id, mapped from YANG variable /relay_agent/dhcpv6/options/state/enable_remote_id (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_remote_id() directly.

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_remote_id must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable_remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_remote_id(self):
    self.__enable_remote_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)

  enable_interface_id = __builtin__.property(_get_enable_interface_id)
  enable_remote_id = __builtin__.property(_get_enable_remote_id)


  _pyangbind_elements = OrderedDict([('enable_interface_id', enable_interface_id), ('enable_remote_id', enable_remote_id), ])


class yc_options_openconfig_relay_agent__relay_agent_dhcpv6_options(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/options. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for DHCPv6 agent options on interfaces
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'options'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_options_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_options_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'options']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcpv6/options/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcpv6/options/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_options_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_options_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_options_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcpv6/options/state (container)

    YANG Description: Operational state data for DHCPv6 agent option on an
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcpv6/options/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for DHCPv6 agent option on an
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_options_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_options_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_options_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data for relay agent interfaces.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__enable','__helper_address',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=True)
    self.__enable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    self.__helper_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'})), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ipv6-address', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'config']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/config/id (oc-if:interface-id)

    YANG Description: Name of the interface on which relay agent is active
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/config/id (oc-if:interface-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Name of the interface on which relay agent is active
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with oc-if:interface-id""",
          'defined-type': "oc-if:interface-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=True)


  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/config/enable (boolean)

    YANG Description: Enables the relay agent on the referenced interface.
At least one helper address should also be configured
for forwarding requested.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/config/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enables the relay agent on the referenced interface.
At least one helper address should also be configured
for forwarding requested.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)


  def _get_helper_address(self):
    """
    Getter method for helper_address, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/config/helper_address (inet:ipv6-address)

    YANG Description: List of IPv6 addresses of DHCP servers to which the
relay agent should forward DHCPv6 requests.  The relay agent
is expected to forward DHCPv4/BOOTP requests to all listed
server addresses when DHCPv6 relaying is enabled globally, or
on the interface.
    """
    return self.__helper_address
      
  def _set_helper_address(self, v, load=False):
    """
    Setter method for helper_address, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/config/helper_address (inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_helper_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_helper_address() directly.

    YANG Description: List of IPv6 addresses of DHCP servers to which the
relay agent should forward DHCPv6 requests.  The relay agent
is expected to forward DHCPv4/BOOTP requests to all listed
server addresses when DHCPv6 relaying is enabled globally, or
on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'})), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ipv6-address', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """helper_address must be of a type compatible with inet:ipv6-address""",
          'defined-type': "inet:ipv6-address",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'})), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ipv6-address', is_config=True)""",
        })

    self.__helper_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_helper_address(self):
    self.__helper_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'})), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ipv6-address', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  enable = __builtin__.property(_get_enable, _set_enable)
  helper_address = __builtin__.property(_get_helper_address, _set_helper_address)


  _pyangbind_elements = OrderedDict([('id', id), ('enable', enable), ('helper_address', helper_address), ])


class yc_counters_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state_counters(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/state/counters. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Counters and statistics for relay agent operation.
  """
  __slots__ = ('_path_helper', '_extmethods', '__total_dropped','__invalid_opcode','__invalid_options','__dhcpv6_solicit_received','__dhcpv6_decline_received','__dhcpv6_request_received','__dhcpv6_release_received','__dhcpv6_confirm_received','__dhcpv6_rebind_received','__dhcpv6_info_request_received','__dhcpv6_relay_reply_received','__dhcpv6_adverstise_sent','__dhcpv6_reply_sent','__dhcpv6_reconfigure_sent','__dhcpv6_relay_forw_sent',)

  _yang_name = 'counters'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__total_dropped = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-dropped", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__invalid_opcode = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-opcode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__invalid_options = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_solicit_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-solicit-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_decline_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-decline-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_request_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_release_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-release-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_confirm_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-confirm-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_rebind_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-rebind-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_info_request_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-info-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_relay_reply_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-relay-reply-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_adverstise_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-adverstise-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_reply_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-reply-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_reconfigure_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-reconfigure-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    self.__dhcpv6_relay_forw_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-relay-forw-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'state', 'counters']

  def _get_total_dropped(self):
    """
    Getter method for total_dropped, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/total_dropped (yang:counter64)

    YANG Description: Total number of DHCP packets dropped by the relay agent
    """
    return self.__total_dropped
      
  def _set_total_dropped(self, v, load=False):
    """
    Setter method for total_dropped, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/total_dropped (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_total_dropped is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_total_dropped() directly.

    YANG Description: Total number of DHCP packets dropped by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-dropped", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """total_dropped must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-dropped", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__total_dropped = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_total_dropped(self):
    self.__total_dropped = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="total-dropped", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_invalid_opcode(self):
    """
    Getter method for invalid_opcode, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/invalid_opcode (yang:counter64)

    YANG Description: Number of DHCP packets dropped due to an invalid opcode
    """
    return self.__invalid_opcode
      
  def _set_invalid_opcode(self, v, load=False):
    """
    Setter method for invalid_opcode, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/invalid_opcode (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_invalid_opcode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_invalid_opcode() directly.

    YANG Description: Number of DHCP packets dropped due to an invalid opcode
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-opcode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """invalid_opcode must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-opcode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__invalid_opcode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_invalid_opcode(self):
    self.__invalid_opcode = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-opcode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_invalid_options(self):
    """
    Getter method for invalid_options, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/invalid_options (yang:counter64)

    YANG Description: Number of DHCP packets dropped due to an invalid option
    """
    return self.__invalid_options
      
  def _set_invalid_options(self, v, load=False):
    """
    Setter method for invalid_options, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/invalid_options (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_invalid_options is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_invalid_options() directly.

    YANG Description: Number of DHCP packets dropped due to an invalid option
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """invalid_options must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__invalid_options = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_invalid_options(self):
    self.__invalid_options = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="invalid-options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_solicit_received(self):
    """
    Getter method for dhcpv6_solicit_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_solicit_received (yang:counter64)

    YANG Description: Number of DHCPv6 SOLICIT messages received from clients
by the relay agent
    """
    return self.__dhcpv6_solicit_received
      
  def _set_dhcpv6_solicit_received(self, v, load=False):
    """
    Setter method for dhcpv6_solicit_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_solicit_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_solicit_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_solicit_received() directly.

    YANG Description: Number of DHCPv6 SOLICIT messages received from clients
by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-solicit-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_solicit_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-solicit-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_solicit_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_solicit_received(self):
    self.__dhcpv6_solicit_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-solicit-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_decline_received(self):
    """
    Getter method for dhcpv6_decline_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_decline_received (yang:counter64)

    YANG Description: Number of DHCPv6 DECLINE messages received from
clients by the relay agent
    """
    return self.__dhcpv6_decline_received
      
  def _set_dhcpv6_decline_received(self, v, load=False):
    """
    Setter method for dhcpv6_decline_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_decline_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_decline_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_decline_received() directly.

    YANG Description: Number of DHCPv6 DECLINE messages received from
clients by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-decline-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_decline_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-decline-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_decline_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_decline_received(self):
    self.__dhcpv6_decline_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-decline-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_request_received(self):
    """
    Getter method for dhcpv6_request_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_request_received (yang:counter64)

    YANG Description: Number of DHCPv6 request messages received from clients
by the relay agent
    """
    return self.__dhcpv6_request_received
      
  def _set_dhcpv6_request_received(self, v, load=False):
    """
    Setter method for dhcpv6_request_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_request_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_request_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_request_received() directly.

    YANG Description: Number of DHCPv6 request messages received from clients
by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_request_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_request_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_request_received(self):
    self.__dhcpv6_request_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_release_received(self):
    """
    Getter method for dhcpv6_release_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_release_received (yang:counter64)

    YANG Description: Number of DHCPv6 release messages received from clients
by the relay agent
    """
    return self.__dhcpv6_release_received
      
  def _set_dhcpv6_release_received(self, v, load=False):
    """
    Setter method for dhcpv6_release_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_release_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_release_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_release_received() directly.

    YANG Description: Number of DHCPv6 release messages received from clients
by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-release-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_release_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-release-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_release_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_release_received(self):
    self.__dhcpv6_release_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-release-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_confirm_received(self):
    """
    Getter method for dhcpv6_confirm_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_confirm_received (yang:counter64)

    YANG Description: Number of DHCPv6 confirm messages received from clients
by the relay agent
    """
    return self.__dhcpv6_confirm_received
      
  def _set_dhcpv6_confirm_received(self, v, load=False):
    """
    Setter method for dhcpv6_confirm_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_confirm_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_confirm_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_confirm_received() directly.

    YANG Description: Number of DHCPv6 confirm messages received from clients
by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-confirm-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_confirm_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-confirm-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_confirm_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_confirm_received(self):
    self.__dhcpv6_confirm_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-confirm-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_rebind_received(self):
    """
    Getter method for dhcpv6_rebind_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_rebind_received (yang:counter64)

    YANG Description: Number of DHCPv6 rebind messages received from clients
by the relay agent
    """
    return self.__dhcpv6_rebind_received
      
  def _set_dhcpv6_rebind_received(self, v, load=False):
    """
    Setter method for dhcpv6_rebind_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_rebind_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_rebind_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_rebind_received() directly.

    YANG Description: Number of DHCPv6 rebind messages received from clients
by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-rebind-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_rebind_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-rebind-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_rebind_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_rebind_received(self):
    self.__dhcpv6_rebind_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-rebind-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_info_request_received(self):
    """
    Getter method for dhcpv6_info_request_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_info_request_received (yang:counter64)

    YANG Description: Number of DHCPv6 information requests messages received from
clients by the relay agent
    """
    return self.__dhcpv6_info_request_received
      
  def _set_dhcpv6_info_request_received(self, v, load=False):
    """
    Setter method for dhcpv6_info_request_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_info_request_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_info_request_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_info_request_received() directly.

    YANG Description: Number of DHCPv6 information requests messages received from
clients by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-info-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_info_request_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-info-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_info_request_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_info_request_received(self):
    self.__dhcpv6_info_request_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-info-request-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_relay_reply_received(self):
    """
    Getter method for dhcpv6_relay_reply_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_relay_reply_received (yang:counter64)

    YANG Description: Number of DHCPv6 relay reply messages received from servers
by the relay agent
    """
    return self.__dhcpv6_relay_reply_received
      
  def _set_dhcpv6_relay_reply_received(self, v, load=False):
    """
    Setter method for dhcpv6_relay_reply_received, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_relay_reply_received (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_relay_reply_received is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_relay_reply_received() directly.

    YANG Description: Number of DHCPv6 relay reply messages received from servers
by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-relay-reply-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_relay_reply_received must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-relay-reply-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_relay_reply_received = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_relay_reply_received(self):
    self.__dhcpv6_relay_reply_received = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-relay-reply-received", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_adverstise_sent(self):
    """
    Getter method for dhcpv6_adverstise_sent, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_adverstise_sent (yang:counter64)

    YANG Description: Number of DHCPv6 adverstise messages sent to clients by
the relay agent
    """
    return self.__dhcpv6_adverstise_sent
      
  def _set_dhcpv6_adverstise_sent(self, v, load=False):
    """
    Setter method for dhcpv6_adverstise_sent, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_adverstise_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_adverstise_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_adverstise_sent() directly.

    YANG Description: Number of DHCPv6 adverstise messages sent to clients by
the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-adverstise-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_adverstise_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-adverstise-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_adverstise_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_adverstise_sent(self):
    self.__dhcpv6_adverstise_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-adverstise-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_reply_sent(self):
    """
    Getter method for dhcpv6_reply_sent, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_reply_sent (yang:counter64)

    YANG Description: Number of DHCPv6 reply messages sent to clients by
the relay agent
    """
    return self.__dhcpv6_reply_sent
      
  def _set_dhcpv6_reply_sent(self, v, load=False):
    """
    Setter method for dhcpv6_reply_sent, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_reply_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_reply_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_reply_sent() directly.

    YANG Description: Number of DHCPv6 reply messages sent to clients by
the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-reply-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_reply_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-reply-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_reply_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_reply_sent(self):
    self.__dhcpv6_reply_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-reply-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_reconfigure_sent(self):
    """
    Getter method for dhcpv6_reconfigure_sent, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_reconfigure_sent (yang:counter64)

    YANG Description: Number of DHCPv6 reconfigure messages sent to clients by
the relay agent
    """
    return self.__dhcpv6_reconfigure_sent
      
  def _set_dhcpv6_reconfigure_sent(self, v, load=False):
    """
    Setter method for dhcpv6_reconfigure_sent, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_reconfigure_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_reconfigure_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_reconfigure_sent() directly.

    YANG Description: Number of DHCPv6 reconfigure messages sent to clients by
the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-reconfigure-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_reconfigure_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-reconfigure-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_reconfigure_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_reconfigure_sent(self):
    self.__dhcpv6_reconfigure_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-reconfigure-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)


  def _get_dhcpv6_relay_forw_sent(self):
    """
    Getter method for dhcpv6_relay_forw_sent, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_relay_forw_sent (yang:counter64)

    YANG Description: Number of DHCPv6 relay-forward messages sent to servers
by the relay agent
    """
    return self.__dhcpv6_relay_forw_sent
      
  def _set_dhcpv6_relay_forw_sent(self, v, load=False):
    """
    Setter method for dhcpv6_relay_forw_sent, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters/dhcpv6_relay_forw_sent (yang:counter64)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6_relay_forw_sent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6_relay_forw_sent() directly.

    YANG Description: Number of DHCPv6 relay-forward messages sent to servers
by the relay agent
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-relay-forw-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6_relay_forw_sent must be of a type compatible with yang:counter64""",
          'defined-type': "yang:counter64",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-relay-forw-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)""",
        })

    self.__dhcpv6_relay_forw_sent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6_relay_forw_sent(self):
    self.__dhcpv6_relay_forw_sent = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range':  ['0..18446744073709551615']}, int_size=64), is_leaf=True, yang_name="dhcpv6-relay-forw-sent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='yang:counter64', is_config=False)

  total_dropped = __builtin__.property(_get_total_dropped)
  invalid_opcode = __builtin__.property(_get_invalid_opcode)
  invalid_options = __builtin__.property(_get_invalid_options)
  dhcpv6_solicit_received = __builtin__.property(_get_dhcpv6_solicit_received)
  dhcpv6_decline_received = __builtin__.property(_get_dhcpv6_decline_received)
  dhcpv6_request_received = __builtin__.property(_get_dhcpv6_request_received)
  dhcpv6_release_received = __builtin__.property(_get_dhcpv6_release_received)
  dhcpv6_confirm_received = __builtin__.property(_get_dhcpv6_confirm_received)
  dhcpv6_rebind_received = __builtin__.property(_get_dhcpv6_rebind_received)
  dhcpv6_info_request_received = __builtin__.property(_get_dhcpv6_info_request_received)
  dhcpv6_relay_reply_received = __builtin__.property(_get_dhcpv6_relay_reply_received)
  dhcpv6_adverstise_sent = __builtin__.property(_get_dhcpv6_adverstise_sent)
  dhcpv6_reply_sent = __builtin__.property(_get_dhcpv6_reply_sent)
  dhcpv6_reconfigure_sent = __builtin__.property(_get_dhcpv6_reconfigure_sent)
  dhcpv6_relay_forw_sent = __builtin__.property(_get_dhcpv6_relay_forw_sent)


  _pyangbind_elements = OrderedDict([('total_dropped', total_dropped), ('invalid_opcode', invalid_opcode), ('invalid_options', invalid_options), ('dhcpv6_solicit_received', dhcpv6_solicit_received), ('dhcpv6_decline_received', dhcpv6_decline_received), ('dhcpv6_request_received', dhcpv6_request_received), ('dhcpv6_release_received', dhcpv6_release_received), ('dhcpv6_confirm_received', dhcpv6_confirm_received), ('dhcpv6_rebind_received', dhcpv6_rebind_received), ('dhcpv6_info_request_received', dhcpv6_info_request_received), ('dhcpv6_relay_reply_received', dhcpv6_relay_reply_received), ('dhcpv6_adverstise_sent', dhcpv6_adverstise_sent), ('dhcpv6_reply_sent', dhcpv6_reply_sent), ('dhcpv6_reconfigure_sent', dhcpv6_reconfigure_sent), ('dhcpv6_relay_forw_sent', dhcpv6_relay_forw_sent), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for relay agent interfaces.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__enable','__helper_address','__counters',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=False)
    self.__enable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    self.__helper_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'})), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ipv6-address', is_config=False)
    self.__counters = YANGDynClass(base=yc_counters_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'state']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/id (oc-if:interface-id)

    YANG Description: Name of the interface on which relay agent is active
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/id (oc-if:interface-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Name of the interface on which relay agent is active
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with oc-if:interface-id""",
          'defined-type': "oc-if:interface-id",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=False)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='oc-if:interface-id', is_config=False)


  def _get_enable(self):
    """
    Getter method for enable, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/enable (boolean)

    YANG Description: Enables the relay agent on the referenced interface.
At least one helper address should also be configured
for forwarding requested.
    """
    return self.__enable
      
  def _set_enable(self, v, load=False):
    """
    Setter method for enable, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/enable (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable() directly.

    YANG Description: Enables the relay agent on the referenced interface.
At least one helper address should also be configured
for forwarding requested.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable(self):
    self.__enable = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="enable", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)


  def _get_helper_address(self):
    """
    Getter method for helper_address, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/helper_address (inet:ipv6-address)

    YANG Description: List of IPv6 addresses of DHCP servers to which the
relay agent should forward DHCPv6 requests.  The relay agent
is expected to forward DHCPv4/BOOTP requests to all listed
server addresses when DHCPv6 relaying is enabled globally, or
on the interface.
    """
    return self.__helper_address
      
  def _set_helper_address(self, v, load=False):
    """
    Setter method for helper_address, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/helper_address (inet:ipv6-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_helper_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_helper_address() directly.

    YANG Description: List of IPv6 addresses of DHCP servers to which the
relay agent should forward DHCPv6 requests.  The relay agent
is expected to forward DHCPv4/BOOTP requests to all listed
server addresses when DHCPv6 relaying is enabled globally, or
on the interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'})), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ipv6-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """helper_address must be of a type compatible with inet:ipv6-address""",
          'defined-type': "inet:ipv6-address",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'})), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ipv6-address', is_config=False)""",
        })

    self.__helper_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_helper_address(self):
    self.__helper_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'})), is_leaf=False, yang_name="helper-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='inet:ipv6-address', is_config=False)


  def _get_counters(self):
    """
    Getter method for counters, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters (container)

    YANG Description: Counters and statistics for relay agent operation.
    """
    return self.__counters
      
  def _set_counters(self, v, load=False):
    """
    Setter method for counters, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state/counters (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_counters is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_counters() directly.

    YANG Description: Counters and statistics for relay agent operation.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_counters_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """counters must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_counters_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=False)""",
        })

    self.__counters = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_counters(self):
    self.__counters = YANGDynClass(base=yc_counters_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state_counters, is_container='container', yang_name="counters", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=False)

  id = __builtin__.property(_get_id)
  enable = __builtin__.property(_get_enable)
  helper_address = __builtin__.property(_get_helper_address)
  counters = __builtin__.property(_get_counters)


  _pyangbind_elements = OrderedDict([('id', id), ('enable', enable), ('helper_address', helper_address), ('counters', counters), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/interface-ref/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configured reference to interface / subinterface
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'interface-ref', 'config']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/config/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/config/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/config/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/config/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)
  subinterface = __builtin__.property(_get_subinterface, _set_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/interface-ref/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state for interface-ref
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface','__subinterface',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'interface-ref', 'state']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/state/interface (leafref)

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/state/interface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: Reference to a base interface.  If a reference to a
subinterface is required, this leaf must be specified
to indicate the base interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)


  def _get_subinterface(self):
    """
    Getter method for subinterface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/state/subinterface (leafref)

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    return self.__subinterface
      
  def _set_subinterface(self, v, load=False):
    """
    Setter method for subinterface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/state/subinterface (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_subinterface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_subinterface() directly.

    YANG Description: Reference to a subinterface -- this requires the base
interface to be specified using the interface leaf in
this container.  If only a reference to a base interface
is requuired, this leaf should not be set.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """subinterface must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)""",
        })

    self.__subinterface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_subinterface(self):
    self.__subinterface = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="subinterface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=False)

  interface = __builtin__.property(_get_interface)
  subinterface = __builtin__.property(_get_subinterface)


  _pyangbind_elements = OrderedDict([('interface', interface), ('subinterface', subinterface), ])


class yc_interface_ref_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/interface-ref. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'interface-ref'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'interface-ref']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/config (container)

    YANG Description: Configured reference to interface / subinterface
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configured reference to interface / subinterface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/state (container)

    YANG Description: Operational state for interface-ref
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state for interface-ref
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/options/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configuration data 
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable_interface_id','__enable_remote_id','__interface_id','__remote_id',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable_interface_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    self.__enable_remote_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)
    self.__remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'options', 'config']

  def _get_enable_interface_id(self):
    """
    Getter method for enable_interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config/enable_interface_id (boolean)

    YANG Description: Enables DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    return self.__enable_interface_id
      
  def _set_enable_interface_id(self, v, load=False):
    """
    Setter method for enable_interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config/enable_interface_id (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_interface_id() directly.

    YANG Description: Enables DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_interface_id must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable_interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_interface_id(self):
    self.__enable_interface_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)


  def _get_enable_remote_id(self):
    """
    Getter method for enable_remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config/enable_remote_id (boolean)

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    return self.__enable_remote_id
      
  def _set_enable_remote_id(self, v, load=False):
    """
    Setter method for enable_remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config/enable_remote_id (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_remote_id() directly.

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_remote_id must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)""",
        })

    self.__enable_remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_remote_id(self):
    self.__enable_remote_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=True)


  def _get_interface_id(self):
    """
    Getter method for interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config/interface_id (string)

    YANG Description: Sets DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    return self.__interface_id
      
  def _set_interface_id(self, v, load=False):
    """
    Setter method for interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config/interface_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_id() directly.

    YANG Description: Sets DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)""",
        })

    self.__interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_id(self):
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)


  def _get_remote_id(self):
    """
    Getter method for remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config/remote_id (string)

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    return self.__remote_id
      
  def _set_remote_id(self, v, load=False):
    """
    Setter method for remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config/remote_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_id() directly.

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)""",
        })

    self.__remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_id(self):
    self.__remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=True)

  enable_interface_id = __builtin__.property(_get_enable_interface_id, _set_enable_interface_id)
  enable_remote_id = __builtin__.property(_get_enable_remote_id, _set_enable_remote_id)
  interface_id = __builtin__.property(_get_interface_id, _set_interface_id)
  remote_id = __builtin__.property(_get_remote_id, _set_remote_id)


  _pyangbind_elements = OrderedDict([('enable_interface_id', enable_interface_id), ('enable_remote_id', enable_remote_id), ('interface_id', interface_id), ('remote_id', remote_id), ])


class yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_state(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/options/state. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Operational state data for DHCPv6 agent option on an
interface
  """
  __slots__ = ('_path_helper', '_extmethods', '__enable_interface_id','__enable_remote_id','__interface_id','__remote_id','__sent_interface_id','__sent_remote_id',)

  _yang_name = 'state'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__enable_interface_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    self.__enable_remote_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    self.__remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    self.__sent_interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    self.__sent_remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'options', 'state']

  def _get_enable_interface_id(self):
    """
    Getter method for enable_interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/enable_interface_id (boolean)

    YANG Description: Enables DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    return self.__enable_interface_id
      
  def _set_enable_interface_id(self, v, load=False):
    """
    Setter method for enable_interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/enable_interface_id (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_interface_id() directly.

    YANG Description: Enables DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_interface_id must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable_interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_interface_id(self):
    self.__enable_interface_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)


  def _get_enable_remote_id(self):
    """
    Getter method for enable_remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/enable_remote_id (boolean)

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    return self.__enable_remote_id
      
  def _set_enable_remote_id(self, v, load=False):
    """
    Setter method for enable_remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/enable_remote_id (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enable_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enable_remote_id() directly.

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enable_remote_id must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)""",
        })

    self.__enable_remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enable_remote_id(self):
    self.__enable_remote_id = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="enable-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='boolean', is_config=False)


  def _get_interface_id(self):
    """
    Getter method for interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/interface_id (string)

    YANG Description: Sets DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    return self.__interface_id
      
  def _set_interface_id(self, v, load=False):
    """
    Setter method for interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/interface_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_id() directly.

    YANG Description: Sets DHCPv6 OPTION_INTERFACE_ID (18) to identify the
interface on which the client message was received.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)""",
        })

    self.__interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_id(self):
    self.__interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)


  def _get_remote_id(self):
    """
    Getter method for remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/remote_id (string)

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    return self.__remote_id
      
  def _set_remote_id(self, v, load=False):
    """
    Setter method for remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/remote_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_remote_id() directly.

    YANG Description: Sets DHCPv6 OPTION_REMOTE_ID (37).  This option is the
DHCPv6 equivalent for the IPv4 (DHCPv4) Relay Agent Option's
Remote-ID suboption as specified in RFC 3046. The remote-id
field may be used to encode a user name, remote IP address,
interface/port identifier, etc.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """remote_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)""",
        })

    self.__remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_remote_id(self):
    self.__remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)


  def _get_sent_interface_id(self):
    """
    Getter method for sent_interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/sent_interface_id (string)

    YANG Description: Reflects the DHCPv6 OPTION_INTERFACE_ID (18) sent to the
server by the system.
    """
    return self.__sent_interface_id
      
  def _set_sent_interface_id(self, v, load=False):
    """
    Setter method for sent_interface_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/sent_interface_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sent_interface_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sent_interface_id() directly.

    YANG Description: Reflects the DHCPv6 OPTION_INTERFACE_ID (18) sent to the
server by the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sent-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sent_interface_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)""",
        })

    self.__sent_interface_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sent_interface_id(self):
    self.__sent_interface_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-interface-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)


  def _get_sent_remote_id(self):
    """
    Getter method for sent_remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/sent_remote_id (string)

    YANG Description: Reflects the DHCPv6 OPTION_REMOTE_ID (37) sent to the
server by the system.
    """
    return self.__sent_remote_id
      
  def _set_sent_remote_id(self, v, load=False):
    """
    Setter method for sent_remote_id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state/sent_remote_id (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_sent_remote_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_sent_remote_id() directly.

    YANG Description: Reflects the DHCPv6 OPTION_REMOTE_ID (37) sent to the
server by the system.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="sent-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """sent_remote_id must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)""",
        })

    self.__sent_remote_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_sent_remote_id(self):
    self.__sent_remote_id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="sent-remote-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='string', is_config=False)

  enable_interface_id = __builtin__.property(_get_enable_interface_id)
  enable_remote_id = __builtin__.property(_get_enable_remote_id)
  interface_id = __builtin__.property(_get_interface_id)
  remote_id = __builtin__.property(_get_remote_id)
  sent_interface_id = __builtin__.property(_get_sent_interface_id)
  sent_remote_id = __builtin__.property(_get_sent_remote_id)


  _pyangbind_elements = OrderedDict([('enable_interface_id', enable_interface_id), ('enable_remote_id', enable_remote_id), ('interface_id', interface_id), ('remote_id', remote_id), ('sent_interface_id', sent_interface_id), ('sent_remote_id', sent_remote_id), ])


class yc_options_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface/options. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for DHCPv6 agent options on interfaces
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state',)

  _yang_name = 'options'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface', 'options']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config (container)

    YANG Description: Configuration data 
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data 
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state (container)

    YANG Description: Operational state data for DHCPv6 agent option on an
interface
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for DHCPv6 agent option on an
interface
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ])


class yc_interface_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces/interface. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: List of interfaces on which the relay agent is
configured.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
  """
  __slots__ = ('_path_helper', '_extmethods', '__id','__config','__state','__interface_ref','__options',)

  _yang_name = 'interface'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__options = YANGDynClass(base=yc_options_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options, is_container='container', yang_name="options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces', 'interface']

  def _get_id(self):
    """
    Getter method for id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/id (leafref)

    YANG Description: Reference to the interface list key
    """
    return self.__id
      
  def _set_id(self, v, load=False):
    """
    Setter method for id, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/id (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_id() directly.

    YANG Description: Reference to the interface list key
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """id must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)""",
        })

    self.__id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_id(self):
    self.__id = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='leafref', is_config=True)


  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/config (container)

    YANG Description: Configuration data for relay agent interfaces.
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for relay agent interfaces.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state (container)

    YANG Description: Operational state data for relay agent interfaces.
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data for relay agent interfaces.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_interface_ref(self):
    """
    Getter method for interface_ref, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref (container)

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    return self.__interface_ref
      
  def _set_interface_ref(self, v, load=False):
    """
    Setter method for interface_ref, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/interface_ref (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface_ref is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface_ref() directly.

    YANG Description: Reference to an interface or subinterface. The interface
that is being referenced is uniquely referenced based on
the specified interface and subinterface leaves. In contexts
where a Layer 3 interface is to be referenced, both the
interface and subinterface leaves must be populated, as
Layer 3 configuration within the OpenConfig models is
associated with a subinterface. In the case where a
Layer 2 interface is to be referenced, only the
interface is specified.

The interface/subinterface leaf tuple must be used as
the means by which the interface is specified, regardless
of any other context information (e.g., key in a list).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interface_ref_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface_ref must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interface_ref_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__interface_ref = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface_ref(self):
    self.__interface_ref = YANGDynClass(base=yc_interface_ref_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_interface_ref, is_container='container', yang_name="interface-ref", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_options(self):
    """
    Getter method for options, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options (container)

    YANG Description: Top-level container for DHCPv6 agent options on interfaces
    """
    return self.__options
      
  def _set_options(self, v, load=False):
    """
    Setter method for options, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface/options (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_options is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_options() directly.

    YANG Description: Top-level container for DHCPv6 agent options on interfaces
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_options_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options, is_container='container', yang_name="options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """options must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_options_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options, is_container='container', yang_name="options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__options = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_options(self):
    self.__options = YANGDynClass(base=yc_options_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface_options, is_container='container', yang_name="options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  id = __builtin__.property(_get_id, _set_id)
  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  interface_ref = __builtin__.property(_get_interface_ref, _set_interface_ref)
  options = __builtin__.property(_get_options, _set_options)


  _pyangbind_elements = OrderedDict([('id', id), ('config', config), ('state', state), ('interface_ref', interface_ref), ('options', options), ])


class yc_interfaces_openconfig_relay_agent__relay_agent_dhcpv6_interfaces(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6/interfaces. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Enclosing container for the list of interface references.
  """
  __slots__ = ('_path_helper', '_extmethods', '__interface',)

  _yang_name = 'interfaces'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__interface = YANGDynClass(base=YANGListType("id",yc_interface_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='list', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6', 'interfaces']

  def _get_interface(self):
    """
    Getter method for interface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface (list)

    YANG Description: List of interfaces on which the relay agent is
configured.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
    """
    return self.__interface
      
  def _set_interface(self, v, load=False):
    """
    Setter method for interface, mapped from YANG variable /relay_agent/dhcpv6/interfaces/interface (list)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interface is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interface() directly.

    YANG Description: List of interfaces on which the relay agent is
configured.

The interface referenced is based on the interface and
subinterface leaves within the interface-ref container -
which reference an entry in the /interfaces/interface list -
and should not rely on the value of the list key.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGListType("id",yc_interface_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='list', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interface must be of a type compatible with list""",
          'defined-type': "list",
          'generated-type': """YANGDynClass(base=YANGListType("id",yc_interface_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='list', is_config=True)""",
        })

    self.__interface = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interface(self):
    self.__interface = YANGDynClass(base=YANGListType("id",yc_interface_openconfig_relay_agent__relay_agent_dhcpv6_interfaces_interface, yang_name="interface", parent=self, is_container='list', user_ordered=False, path_helper=self._path_helper, yang_keys='id', extensions=None), is_container='list', yang_name="interface", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='list', is_config=True)

  interface = __builtin__.property(_get_interface, _set_interface)


  _pyangbind_elements = OrderedDict([('interface', interface), ])


class yc_dhcpv6_openconfig_relay_agent__relay_agent_dhcpv6(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent/dhcpv6. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top-level container for global relay agent data
  """
  __slots__ = ('_path_helper', '_extmethods', '__config','__state','__options','__interfaces',)

  _yang_name = 'dhcpv6'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__options = YANGDynClass(base=yc_options_openconfig_relay_agent__relay_agent_dhcpv6_options, is_container='container', yang_name="options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_relay_agent__relay_agent_dhcpv6_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent', 'dhcpv6']

  def _get_config(self):
    """
    Getter method for config, mapped from YANG variable /relay_agent/dhcpv6/config (container)

    YANG Description: Configuration data for global DHCPv6
    """
    return self.__config
      
  def _set_config(self, v, load=False):
    """
    Setter method for config, mapped from YANG variable /relay_agent/dhcpv6/config (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_config is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_config() directly.

    YANG Description: Configuration data for global DHCPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """config must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__config = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_config(self):
    self.__config = YANGDynClass(base=yc_config_openconfig_relay_agent__relay_agent_dhcpv6_config, is_container='container', yang_name="config", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_state(self):
    """
    Getter method for state, mapped from YANG variable /relay_agent/dhcpv6/state (container)

    YANG Description: Operational state data global DHCPv6
    """
    return self.__state
      
  def _set_state(self, v, load=False):
    """
    Setter method for state, mapped from YANG variable /relay_agent/dhcpv6/state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_state() directly.

    YANG Description: Operational state data global DHCPv6
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_state(self):
    self.__state = YANGDynClass(base=yc_state_openconfig_relay_agent__relay_agent_dhcpv6_state, is_container='container', yang_name="state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_options(self):
    """
    Getter method for options, mapped from YANG variable /relay_agent/dhcpv6/options (container)

    YANG Description: Top-level container for DHCPv6 agent options on interfaces
    """
    return self.__options
      
  def _set_options(self, v, load=False):
    """
    Setter method for options, mapped from YANG variable /relay_agent/dhcpv6/options (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_options is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_options() directly.

    YANG Description: Top-level container for DHCPv6 agent options on interfaces
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_options_openconfig_relay_agent__relay_agent_dhcpv6_options, is_container='container', yang_name="options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """options must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_options_openconfig_relay_agent__relay_agent_dhcpv6_options, is_container='container', yang_name="options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__options = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_options(self):
    self.__options = YANGDynClass(base=yc_options_openconfig_relay_agent__relay_agent_dhcpv6_options, is_container='container', yang_name="options", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_interfaces(self):
    """
    Getter method for interfaces, mapped from YANG variable /relay_agent/dhcpv6/interfaces (container)

    YANG Description: Enclosing container for the list of interface references.
    """
    return self.__interfaces
      
  def _set_interfaces(self, v, load=False):
    """
    Setter method for interfaces, mapped from YANG variable /relay_agent/dhcpv6/interfaces (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_interfaces is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_interfaces() directly.

    YANG Description: Enclosing container for the list of interface references.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_interfaces_openconfig_relay_agent__relay_agent_dhcpv6_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """interfaces must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_interfaces_openconfig_relay_agent__relay_agent_dhcpv6_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__interfaces = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_interfaces(self):
    self.__interfaces = YANGDynClass(base=yc_interfaces_openconfig_relay_agent__relay_agent_dhcpv6_interfaces, is_container='container', yang_name="interfaces", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  config = __builtin__.property(_get_config, _set_config)
  state = __builtin__.property(_get_state, _set_state)
  options = __builtin__.property(_get_options, _set_options)
  interfaces = __builtin__.property(_get_interfaces, _set_interfaces)


  _pyangbind_elements = OrderedDict([('config', config), ('state', state), ('options', options), ('interfaces', interfaces), ])


class yc_relay_agent_openconfig_relay_agent__relay_agent(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /relay-agent. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Top level container for relay-agent configuration and
operational state data
  """
  __slots__ = ('_path_helper', '_extmethods', '__dhcp','__dhcpv6',)

  _yang_name = 'relay-agent'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__dhcp = YANGDynClass(base=yc_dhcp_openconfig_relay_agent__relay_agent_dhcp, is_container='container', yang_name="dhcp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    self.__dhcpv6 = YANGDynClass(base=yc_dhcpv6_openconfig_relay_agent__relay_agent_dhcpv6, is_container='container', yang_name="dhcpv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['relay-agent']

  def _get_dhcp(self):
    """
    Getter method for dhcp, mapped from YANG variable /relay_agent/dhcp (container)

    YANG Description: Top-level container for global relay agent data
    """
    return self.__dhcp
      
  def _set_dhcp(self, v, load=False):
    """
    Setter method for dhcp, mapped from YANG variable /relay_agent/dhcp (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcp() directly.

    YANG Description: Top-level container for global relay agent data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_dhcp_openconfig_relay_agent__relay_agent_dhcp, is_container='container', yang_name="dhcp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcp must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_dhcp_openconfig_relay_agent__relay_agent_dhcp, is_container='container', yang_name="dhcp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__dhcp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcp(self):
    self.__dhcp = YANGDynClass(base=yc_dhcp_openconfig_relay_agent__relay_agent_dhcp, is_container='container', yang_name="dhcp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)


  def _get_dhcpv6(self):
    """
    Getter method for dhcpv6, mapped from YANG variable /relay_agent/dhcpv6 (container)

    YANG Description: Top-level container for global relay agent data
    """
    return self.__dhcpv6
      
  def _set_dhcpv6(self, v, load=False):
    """
    Setter method for dhcpv6, mapped from YANG variable /relay_agent/dhcpv6 (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_dhcpv6 is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_dhcpv6() directly.

    YANG Description: Top-level container for global relay agent data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_dhcpv6_openconfig_relay_agent__relay_agent_dhcpv6, is_container='container', yang_name="dhcpv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """dhcpv6 must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_dhcpv6_openconfig_relay_agent__relay_agent_dhcpv6, is_container='container', yang_name="dhcpv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__dhcpv6 = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_dhcpv6(self):
    self.__dhcpv6 = YANGDynClass(base=yc_dhcpv6_openconfig_relay_agent__relay_agent_dhcpv6, is_container='container', yang_name="dhcpv6", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  dhcp = __builtin__.property(_get_dhcp, _set_dhcp)
  dhcpv6 = __builtin__.property(_get_dhcpv6, _set_dhcpv6)


  _pyangbind_elements = OrderedDict([('dhcp', dhcp), ('dhcpv6', dhcpv6), ])


class openconfig_relay_agent(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-relay-agent - based on the path /openconfig-relay-agent. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This module describes a model for configuration and operational
state related to relay agents typically used for DHCP and BOOTP
packets.  The supports both DHCP and DHCPv6 and device-wide and
per-interface settings.
  """
  __slots__ = ('_path_helper', '_extmethods', '__relay_agent',)

  _yang_name = 'openconfig-relay-agent'
  _yang_namespace = 'http://openconfig.net/yang/relay-agent'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__relay_agent = YANGDynClass(base=yc_relay_agent_openconfig_relay_agent__relay_agent, is_container='container', yang_name="relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return []

  def _get_relay_agent(self):
    """
    Getter method for relay_agent, mapped from YANG variable /relay_agent (container)

    YANG Description: Top level container for relay-agent configuration and
operational state data
    """
    return self.__relay_agent
      
  def _set_relay_agent(self, v, load=False):
    """
    Setter method for relay_agent, mapped from YANG variable /relay_agent (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_relay_agent is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_relay_agent() directly.

    YANG Description: Top level container for relay-agent configuration and
operational state data
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=yc_relay_agent_openconfig_relay_agent__relay_agent, is_container='container', yang_name="relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """relay_agent must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=yc_relay_agent_openconfig_relay_agent__relay_agent, is_container='container', yang_name="relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)""",
        })

    self.__relay_agent = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_relay_agent(self):
    self.__relay_agent = YANGDynClass(base=yc_relay_agent_openconfig_relay_agent__relay_agent, is_container='container', yang_name="relay-agent", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='http://openconfig.net/yang/relay-agent', defining_module='openconfig-relay-agent', yang_type='container', is_config=True)

  relay_agent = __builtin__.property(_get_relay_agent, _set_relay_agent)


  _pyangbind_elements = OrderedDict([('relay_agent', relay_agent), ])


