// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pipes

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreatePipe = "CreatePipe"

// CreatePipeRequest generates a "aws/request.Request" representing the
// client's request for the CreatePipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePipe for more information on using the CreatePipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePipeRequest method.
//	req, resp := client.CreatePipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/CreatePipe
func (c *Pipes) CreatePipeRequest(input *CreatePipeInput) (req *request.Request, output *CreatePipeOutput) {
	op := &request.Operation{
		Name:       opCreatePipe,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/pipes/{Name}",
	}

	if input == nil {
		input = &CreatePipeInput{}
	}

	output = &CreatePipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePipe API operation for Amazon EventBridge Pipes.
//
// Create a pipe. Amazon EventBridge Pipes connect event sources to targets
// and reduces the need for specialized knowledge and integration code.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation CreatePipe for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - ThrottlingException
//     An action was throttled.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
//   - ConflictException
//     An action you attempted resulted in an exception.
//
//   - ServiceQuotaExceededException
//     A quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/CreatePipe
func (c *Pipes) CreatePipe(input *CreatePipeInput) (*CreatePipeOutput, error) {
	req, out := c.CreatePipeRequest(input)
	return out, req.Send()
}

// CreatePipeWithContext is the same as CreatePipe with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) CreatePipeWithContext(ctx aws.Context, input *CreatePipeInput, opts ...request.Option) (*CreatePipeOutput, error) {
	req, out := c.CreatePipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePipe = "DeletePipe"

// DeletePipeRequest generates a "aws/request.Request" representing the
// client's request for the DeletePipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePipe for more information on using the DeletePipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePipeRequest method.
//	req, resp := client.DeletePipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/DeletePipe
func (c *Pipes) DeletePipeRequest(input *DeletePipeInput) (req *request.Request, output *DeletePipeOutput) {
	op := &request.Operation{
		Name:       opDeletePipe,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v1/pipes/{Name}",
	}

	if input == nil {
		input = &DeletePipeInput{}
	}

	output = &DeletePipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePipe API operation for Amazon EventBridge Pipes.
//
// Delete an existing pipe. For more information about pipes, see Amazon EventBridge
// Pipes (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html)
// in the Amazon EventBridge User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation DeletePipe for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - ThrottlingException
//     An action was throttled.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
//   - ConflictException
//     An action you attempted resulted in an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/DeletePipe
func (c *Pipes) DeletePipe(input *DeletePipeInput) (*DeletePipeOutput, error) {
	req, out := c.DeletePipeRequest(input)
	return out, req.Send()
}

// DeletePipeWithContext is the same as DeletePipe with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) DeletePipeWithContext(ctx aws.Context, input *DeletePipeInput, opts ...request.Option) (*DeletePipeOutput, error) {
	req, out := c.DeletePipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePipe = "DescribePipe"

// DescribePipeRequest generates a "aws/request.Request" representing the
// client's request for the DescribePipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePipe for more information on using the DescribePipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePipeRequest method.
//	req, resp := client.DescribePipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/DescribePipe
func (c *Pipes) DescribePipeRequest(input *DescribePipeInput) (req *request.Request, output *DescribePipeOutput) {
	op := &request.Operation{
		Name:       opDescribePipe,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/pipes/{Name}",
	}

	if input == nil {
		input = &DescribePipeInput{}
	}

	output = &DescribePipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePipe API operation for Amazon EventBridge Pipes.
//
// Get the information about an existing pipe. For more information about pipes,
// see Amazon EventBridge Pipes (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html)
// in the Amazon EventBridge User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation DescribePipe for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - ThrottlingException
//     An action was throttled.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/DescribePipe
func (c *Pipes) DescribePipe(input *DescribePipeInput) (*DescribePipeOutput, error) {
	req, out := c.DescribePipeRequest(input)
	return out, req.Send()
}

// DescribePipeWithContext is the same as DescribePipe with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) DescribePipeWithContext(ctx aws.Context, input *DescribePipeInput, opts ...request.Option) (*DescribePipeOutput, error) {
	req, out := c.DescribePipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPipes = "ListPipes"

// ListPipesRequest generates a "aws/request.Request" representing the
// client's request for the ListPipes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPipes for more information on using the ListPipes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPipesRequest method.
//	req, resp := client.ListPipesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/ListPipes
func (c *Pipes) ListPipesRequest(input *ListPipesInput) (req *request.Request, output *ListPipesOutput) {
	op := &request.Operation{
		Name:       opListPipes,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/pipes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPipesInput{}
	}

	output = &ListPipesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPipes API operation for Amazon EventBridge Pipes.
//
// Get the pipes associated with this account. For more information about pipes,
// see Amazon EventBridge Pipes (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html)
// in the Amazon EventBridge User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation ListPipes for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - ThrottlingException
//     An action was throttled.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/ListPipes
func (c *Pipes) ListPipes(input *ListPipesInput) (*ListPipesOutput, error) {
	req, out := c.ListPipesRequest(input)
	return out, req.Send()
}

// ListPipesWithContext is the same as ListPipes with the addition of
// the ability to pass a context and additional request options.
//
// See ListPipes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) ListPipesWithContext(ctx aws.Context, input *ListPipesInput, opts ...request.Option) (*ListPipesOutput, error) {
	req, out := c.ListPipesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPipesPages iterates over the pages of a ListPipes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPipes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPipes operation.
//	pageNum := 0
//	err := client.ListPipesPages(params,
//	    func(page *pipes.ListPipesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Pipes) ListPipesPages(input *ListPipesInput, fn func(*ListPipesOutput, bool) bool) error {
	return c.ListPipesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPipesPagesWithContext same as ListPipesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) ListPipesPagesWithContext(ctx aws.Context, input *ListPipesInput, fn func(*ListPipesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPipesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPipesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPipesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/ListTagsForResource
func (c *Pipes) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon EventBridge Pipes.
//
// Displays the tags associated with a pipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/ListTagsForResource
func (c *Pipes) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartPipe = "StartPipe"

// StartPipeRequest generates a "aws/request.Request" representing the
// client's request for the StartPipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartPipe for more information on using the StartPipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartPipeRequest method.
//	req, resp := client.StartPipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/StartPipe
func (c *Pipes) StartPipeRequest(input *StartPipeInput) (req *request.Request, output *StartPipeOutput) {
	op := &request.Operation{
		Name:       opStartPipe,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/pipes/{Name}/start",
	}

	if input == nil {
		input = &StartPipeInput{}
	}

	output = &StartPipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartPipe API operation for Amazon EventBridge Pipes.
//
// Start an existing pipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation StartPipe for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - ThrottlingException
//     An action was throttled.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
//   - ConflictException
//     An action you attempted resulted in an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/StartPipe
func (c *Pipes) StartPipe(input *StartPipeInput) (*StartPipeOutput, error) {
	req, out := c.StartPipeRequest(input)
	return out, req.Send()
}

// StartPipeWithContext is the same as StartPipe with the addition of
// the ability to pass a context and additional request options.
//
// See StartPipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) StartPipeWithContext(ctx aws.Context, input *StartPipeInput, opts ...request.Option) (*StartPipeOutput, error) {
	req, out := c.StartPipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopPipe = "StopPipe"

// StopPipeRequest generates a "aws/request.Request" representing the
// client's request for the StopPipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopPipe for more information on using the StopPipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopPipeRequest method.
//	req, resp := client.StopPipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/StopPipe
func (c *Pipes) StopPipeRequest(input *StopPipeInput) (req *request.Request, output *StopPipeOutput) {
	op := &request.Operation{
		Name:       opStopPipe,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/pipes/{Name}/stop",
	}

	if input == nil {
		input = &StopPipeInput{}
	}

	output = &StopPipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopPipe API operation for Amazon EventBridge Pipes.
//
// Stop an existing pipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation StopPipe for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - ThrottlingException
//     An action was throttled.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
//   - ConflictException
//     An action you attempted resulted in an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/StopPipe
func (c *Pipes) StopPipe(input *StopPipeInput) (*StopPipeOutput, error) {
	req, out := c.StopPipeRequest(input)
	return out, req.Send()
}

// StopPipeWithContext is the same as StopPipe with the addition of
// the ability to pass a context and additional request options.
//
// See StopPipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) StopPipeWithContext(ctx aws.Context, input *StopPipeInput, opts ...request.Option) (*StopPipeOutput, error) {
	req, out := c.StopPipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/TagResource
func (c *Pipes) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon EventBridge Pipes.
//
// Assigns one or more tags (key-value pairs) to the specified pipe. Tags can
// help you organize and categorize your resources. You can also use them to
// scope user permissions by granting a user permission to access or change
// only resources with certain tag values.
//
// Tags don't have any semantic meaning to Amazon Web Services and are interpreted
// strictly as strings of characters.
//
// You can use the TagResource action with a pipe that already has tags. If
// you specify a new tag key, this tag is appended to the list of tags associated
// with the pipe. If you specify a tag key that is already associated with the
// pipe, the new tag value that you specify replaces the previous value for
// that tag.
//
// You can associate as many as 50 tags with a pipe.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/TagResource
func (c *Pipes) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/UntagResource
func (c *Pipes) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon EventBridge Pipes.
//
// Removes one or more tags from the specified pipes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/UntagResource
func (c *Pipes) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePipe = "UpdatePipe"

// UpdatePipeRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePipe operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePipe for more information on using the UpdatePipe
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePipeRequest method.
//	req, resp := client.UpdatePipeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/UpdatePipe
func (c *Pipes) UpdatePipeRequest(input *UpdatePipeInput) (req *request.Request, output *UpdatePipeOutput) {
	op := &request.Operation{
		Name:       opUpdatePipe,
		HTTPMethod: "PUT",
		HTTPPath:   "/v1/pipes/{Name}",
	}

	if input == nil {
		input = &UpdatePipeInput{}
	}

	output = &UpdatePipeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePipe API operation for Amazon EventBridge Pipes.
//
// Update an existing pipe. When you call UpdatePipe, EventBridge only the updates
// fields you have specified in the request; the rest remain unchanged. The
// exception to this is if you modify any Amazon Web Services-service specific
// fields in the SourceParameters, EnrichmentParameters, or TargetParameters
// objects. For example, DynamoDBStreamParameters or EventBridgeEventBusParameters.
// EventBridge updates the fields in these objects atomically as one and overrides
// existing values. This is by design, and means that if you don't specify an
// optional field in one of these Parameters objects, EventBridge sets that
// field to its system-default value during the update.
//
// For more information about pipes, see Amazon EventBridge Pipes (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html)
// in the Amazon EventBridge User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon EventBridge Pipes's
// API operation UpdatePipe for usage and error information.
//
// Returned Error Types:
//
//   - InternalException
//     This exception occurs due to unexpected causes.
//
//   - ValidationException
//     Indicates that an error has occurred while performing a validate operation.
//
//   - ThrottlingException
//     An action was throttled.
//
//   - NotFoundException
//     An entity that you specified does not exist.
//
//   - ConflictException
//     An action you attempted resulted in an exception.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/pipes-2015-10-07/UpdatePipe
func (c *Pipes) UpdatePipe(input *UpdatePipeInput) (*UpdatePipeOutput, error) {
	req, out := c.UpdatePipeRequest(input)
	return out, req.Send()
}

// UpdatePipeWithContext is the same as UpdatePipe with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePipe for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Pipes) UpdatePipeWithContext(ctx aws.Context, input *UpdatePipeInput, opts ...request.Option) (*UpdatePipeOutput, error) {
	req, out := c.UpdatePipeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// This structure specifies the VPC subnets and security groups for the task,
// and whether a public IP address is to be used. This structure is relevant
// only for ECS tasks that use the awsvpc network mode.
type AwsVpcConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies whether the task's elastic network interface receives a public
	// IP address. You can specify ENABLED only when LaunchType in EcsParameters
	// is set to FARGATE.
	AssignPublicIp *string `type:"string" enum:"AssignPublicIp"`

	// Specifies the security groups associated with the task. These security groups
	// must all be in the same VPC. You can specify as many as five security groups.
	// If you do not specify a security group, the default security group for the
	// VPC is used.
	SecurityGroups []*string `type:"list"`

	// Specifies the subnets associated with the task. These subnets must all be
	// in the same VPC. You can specify as many as 16 subnets.
	//
	// Subnets is a required field
	Subnets []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AwsVpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsVpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AwsVpcConfiguration"}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *AwsVpcConfiguration) SetAssignPublicIp(v string) *AwsVpcConfiguration {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *AwsVpcConfiguration) SetSecurityGroups(v []*string) *AwsVpcConfiguration {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *AwsVpcConfiguration) SetSubnets(v []*string) *AwsVpcConfiguration {
	s.Subnets = v
	return s
}

// The array properties for the submitted job, such as the size of the array.
// The array size can be between 2 and 10,000. If you specify array properties
// for a job, it becomes an array job. This parameter is used only if the target
// is an Batch job.
type BatchArrayProperties struct {
	_ struct{} `type:"structure"`

	// The size of the array, if this is an array batch job.
	Size *int64 `min:"2" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchArrayProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchArrayProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchArrayProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchArrayProperties"}
	if s.Size != nil && *s.Size < 2 {
		invalidParams.Add(request.NewErrParamMinValue("Size", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSize sets the Size field's value.
func (s *BatchArrayProperties) SetSize(v int64) *BatchArrayProperties {
	s.Size = &v
	return s
}

// The overrides that are sent to a container.
type BatchContainerOverrides struct {
	_ struct{} `type:"structure"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the task definition.
	Command []*string `type:"list"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override
	// the existing environment variables from the Docker image or the task definition.
	//
	// Environment variables cannot start with "Batch". This naming convention is
	// reserved for variables that Batch sets.
	Environment []*BatchEnvironmentVariable `type:"list"`

	// The instance type to use for a multi-node parallel job.
	//
	// This parameter isn't applicable to single-node container jobs or jobs that
	// run on Fargate resources, and shouldn't be provided.
	InstanceType *string `type:"string"`

	// The type and amount of resources to assign to a container. This overrides
	// the settings in the job definition. The supported resources include GPU,
	// MEMORY, and VCPU.
	ResourceRequirements []*BatchResourceRequirement `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchContainerOverrides) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchContainerOverrides) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchContainerOverrides) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchContainerOverrides"}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *BatchContainerOverrides) SetCommand(v []*string) *BatchContainerOverrides {
	s.Command = v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *BatchContainerOverrides) SetEnvironment(v []*BatchEnvironmentVariable) *BatchContainerOverrides {
	s.Environment = v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *BatchContainerOverrides) SetInstanceType(v string) *BatchContainerOverrides {
	s.InstanceType = &v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *BatchContainerOverrides) SetResourceRequirements(v []*BatchResourceRequirement) *BatchContainerOverrides {
	s.ResourceRequirements = v
	return s
}

// The environment variables to send to the container. You can add new environment
// variables, which are added to the container at launch, or you can override
// the existing environment variables from the Docker image or the task definition.
//
// Environment variables cannot start with "Batch". This naming convention is
// reserved for variables that Batch sets.
type BatchEnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// The name of the key-value pair. For environment variables, this is the name
	// of the environment variable.
	Name *string `type:"string"`

	// The value of the key-value pair. For environment variables, this is the value
	// of the environment variable.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchEnvironmentVariable) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *BatchEnvironmentVariable) SetName(v string) *BatchEnvironmentVariable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *BatchEnvironmentVariable) SetValue(v string) *BatchEnvironmentVariable {
	s.Value = &v
	return s
}

// An object that represents an Batch job dependency.
type BatchJobDependency struct {
	_ struct{} `type:"structure"`

	// The job ID of the Batch job that's associated with this dependency.
	JobId *string `type:"string"`

	// The type of the job dependency.
	Type *string `type:"string" enum:"BatchJobDependencyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchJobDependency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchJobDependency) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *BatchJobDependency) SetJobId(v string) *BatchJobDependency {
	s.JobId = &v
	return s
}

// SetType sets the Type field's value.
func (s *BatchJobDependency) SetType(v string) *BatchJobDependency {
	s.Type = &v
	return s
}

// The type and amount of a resource to assign to a container. The supported
// resources include GPU, MEMORY, and VCPU.
type BatchResourceRequirement struct {
	_ struct{} `type:"structure"`

	// The type of resource to assign to a container. The supported resources include
	// GPU, MEMORY, and VCPU.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"BatchResourceRequirementType"`

	// The quantity of the specified resource to reserve for the container. The
	// values vary based on the type specified.
	//
	// type="GPU"
	//
	// The number of physical GPUs to reserve for the container. Make sure that
	// the number of GPUs reserved for all containers in a job doesn't exceed the
	// number of available GPUs on the compute resource that the job is launched
	// on.
	//
	// GPUs aren't available for jobs that are running on Fargate resources.
	//
	// type="MEMORY"
	//
	// The memory hard limit (in MiB) present to the container. This parameter is
	// supported for jobs that are running on EC2 resources. If your container attempts
	// to exceed the memory specified, the container is terminated. This parameter
	// maps to Memory in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --memory option to docker run (https://docs.docker.com/engine/reference/run/).
	// You must specify at least 4 MiB of memory for a job. This is required but
	// can be specified in several places for multi-node parallel (MNP) jobs. It
	// must be specified for each node at least once. This parameter maps to Memory
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --memory option to docker run (https://docs.docker.com/engine/reference/run/).
	//
	// If you're trying to maximize your resource utilization by providing your
	// jobs as much memory as possible for a particular instance type, see Memory
	// management (https://docs.aws.amazon.com/batch/latest/userguide/memory-management.html)
	// in the Batch User Guide.
	//
	// For jobs that are running on Fargate resources, then value is the hard limit
	// (in MiB), and must match one of the supported values and the VCPU values
	// must be one of the values supported for that memory value.
	//
	// value = 512
	//
	// VCPU = 0.25
	//
	// value = 1024
	//
	// VCPU = 0.25 or 0.5
	//
	// value = 2048
	//
	// VCPU = 0.25, 0.5, or 1
	//
	// value = 3072
	//
	// VCPU = 0.5, or 1
	//
	// value = 4096
	//
	// VCPU = 0.5, 1, or 2
	//
	// value = 5120, 6144, or 7168
	//
	// VCPU = 1 or 2
	//
	// value = 8192
	//
	// VCPU = 1, 2, 4, or 8
	//
	// value = 9216, 10240, 11264, 12288, 13312, 14336, or 15360
	//
	// VCPU = 2 or 4
	//
	// value = 16384
	//
	// VCPU = 2, 4, or 8
	//
	// value = 17408, 18432, 19456, 21504, 22528, 23552, 25600, 26624, 27648, 29696,
	// or 30720
	//
	// VCPU = 4
	//
	// value = 20480, 24576, or 28672
	//
	// VCPU = 4 or 8
	//
	// value = 36864, 45056, 53248, or 61440
	//
	// VCPU = 8
	//
	// value = 32768, 40960, 49152, or 57344
	//
	// VCPU = 8 or 16
	//
	// value = 65536, 73728, 81920, 90112, 98304, 106496, 114688, or 122880
	//
	// VCPU = 16
	//
	// type="VCPU"
	//
	// The number of vCPUs reserved for the container. This parameter maps to CpuShares
	// in the Create a container (https://docs.docker.com/engine/api/v1.23/#create-a-container)
	// section of the Docker Remote API (https://docs.docker.com/engine/api/v1.23/)
	// and the --cpu-shares option to docker run (https://docs.docker.com/engine/reference/run/).
	// Each vCPU is equivalent to 1,024 CPU shares. For EC2 resources, you must
	// specify at least one vCPU. This is required but can be specified in several
	// places; it must be specified for each node at least once.
	//
	// The default for the Fargate On-Demand vCPU resource count quota is 6 vCPUs.
	// For more information about Fargate quotas, see Fargate quotas (https://docs.aws.amazon.com/general/latest/gr/ecs-service.html#service-quotas-fargate)
	// in the Amazon Web Services General Reference.
	//
	// For jobs that are running on Fargate resources, then value must match one
	// of the supported values and the MEMORY values must be one of the values supported
	// for that VCPU value. The supported values are 0.25, 0.5, 1, 2, 4, 8, and
	// 16
	//
	// value = 0.25
	//
	// MEMORY = 512, 1024, or 2048
	//
	// value = 0.5
	//
	// MEMORY = 1024, 2048, 3072, or 4096
	//
	// value = 1
	//
	// MEMORY = 2048, 3072, 4096, 5120, 6144, 7168, or 8192
	//
	// value = 2
	//
	// MEMORY = 4096, 5120, 6144, 7168, 8192, 9216, 10240, 11264, 12288, 13312,
	// 14336, 15360, or 16384
	//
	// value = 4
	//
	// MEMORY = 8192, 9216, 10240, 11264, 12288, 13312, 14336, 15360, 16384, 17408,
	// 18432, 19456, 20480, 21504, 22528, 23552, 24576, 25600, 26624, 27648, 28672,
	// 29696, or 30720
	//
	// value = 8
	//
	// MEMORY = 16384, 20480, 24576, 28672, 32768, 36864, 40960, 45056, 49152, 53248,
	// 57344, or 61440
	//
	// value = 16
	//
	// MEMORY = 32768, 40960, 49152, 57344, 65536, 73728, 81920, 90112, 98304, 106496,
	// 114688, or 122880
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchResourceRequirement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchResourceRequirement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchResourceRequirement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchResourceRequirement"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *BatchResourceRequirement) SetType(v string) *BatchResourceRequirement {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *BatchResourceRequirement) SetValue(v string) *BatchResourceRequirement {
	s.Value = &v
	return s
}

// The retry strategy that's associated with a job. For more information, see
// Automated job retries (https://docs.aws.amazon.com/batch/latest/userguide/job_retries.html)
// in the Batch User Guide.
type BatchRetryStrategy struct {
	_ struct{} `type:"structure"`

	// The number of times to move a job to the RUNNABLE status. If the value of
	// attempts is greater than one, the job is retried on failure the same number
	// of attempts as the value.
	Attempts *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchRetryStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BatchRetryStrategy) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchRetryStrategy) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchRetryStrategy"}
	if s.Attempts != nil && *s.Attempts < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Attempts", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttempts sets the Attempts field's value.
func (s *BatchRetryStrategy) SetAttempts(v int64) *BatchRetryStrategy {
	s.Attempts = &v
	return s
}

// The details of a capacity provider strategy. To learn more, see CapacityProviderStrategyItem
// (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CapacityProviderStrategyItem.html)
// in the Amazon ECS API Reference.
type CapacityProviderStrategyItem struct {
	_ struct{} `type:"structure"`

	// The base value designates how many tasks, at a minimum, to run on the specified
	// capacity provider. Only one capacity provider in a capacity provider strategy
	// can have a base defined. If no value is specified, the default value of 0
	// is used.
	Base *int64 `locationName:"base" type:"integer"`

	// The short name of the capacity provider.
	//
	// CapacityProvider is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CapacityProviderStrategyItem's
	// String and GoString methods.
	//
	// CapacityProvider is a required field
	CapacityProvider *string `locationName:"capacityProvider" min:"1" type:"string" required:"true" sensitive:"true"`

	// The weight value designates the relative percentage of the total number of
	// tasks launched that should use the specified capacity provider. The weight
	// value is taken into consideration after the base value, if defined, is satisfied.
	Weight *int64 `locationName:"weight" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProviderStrategyItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityProviderStrategyItem) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityProviderStrategyItem) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityProviderStrategyItem"}
	if s.CapacityProvider == nil {
		invalidParams.Add(request.NewErrParamRequired("CapacityProvider"))
	}
	if s.CapacityProvider != nil && len(*s.CapacityProvider) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CapacityProvider", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBase sets the Base field's value.
func (s *CapacityProviderStrategyItem) SetBase(v int64) *CapacityProviderStrategyItem {
	s.Base = &v
	return s
}

// SetCapacityProvider sets the CapacityProvider field's value.
func (s *CapacityProviderStrategyItem) SetCapacityProvider(v string) *CapacityProviderStrategyItem {
	s.CapacityProvider = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *CapacityProviderStrategyItem) SetWeight(v int64) *CapacityProviderStrategyItem {
	s.Weight = &v
	return s
}

// The Amazon CloudWatch Logs logging configuration settings for the pipe.
type CloudwatchLogsLogDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services Resource Name (ARN) for the CloudWatch log group
	// to which EventBridge sends the log records.
	LogGroupArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudwatchLogsLogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudwatchLogsLogDestination) GoString() string {
	return s.String()
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *CloudwatchLogsLogDestination) SetLogGroupArn(v string) *CloudwatchLogsLogDestination {
	s.LogGroupArn = &v
	return s
}

// The Amazon CloudWatch Logs logging configuration settings for the pipe.
type CloudwatchLogsLogDestinationParameters struct {
	_ struct{} `type:"structure"`

	// The Amazon Web Services Resource Name (ARN) for the CloudWatch log group
	// to which EventBridge sends the log records.
	//
	// LogGroupArn is a required field
	LogGroupArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudwatchLogsLogDestinationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudwatchLogsLogDestinationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudwatchLogsLogDestinationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudwatchLogsLogDestinationParameters"}
	if s.LogGroupArn == nil {
		invalidParams.Add(request.NewErrParamRequired("LogGroupArn"))
	}
	if s.LogGroupArn != nil && len(*s.LogGroupArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogGroupArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogGroupArn sets the LogGroupArn field's value.
func (s *CloudwatchLogsLogDestinationParameters) SetLogGroupArn(v string) *CloudwatchLogsLogDestinationParameters {
	s.LogGroupArn = &v
	return s
}

// An action you attempted resulted in an exception.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that caused the exception.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of resource that caused the exception.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreatePipeInput struct {
	_ struct{} `type:"structure"`

	// A description of the pipe.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreatePipeInput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeState"`

	// The ARN of the enrichment resource.
	Enrichment *string `type:"string"`

	// The parameters required to set up enrichment on your pipe.
	EnrichmentParameters *PipeEnrichmentParameters `type:"structure"`

	// The logging configuration settings for the pipe.
	LogConfiguration *PipeLogConfigurationParameters `type:"structure"`

	// The name of the pipe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The ARN of the role that allows the pipe to send data to the target.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The ARN of the source resource.
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`

	// The parameters required to set up a source for your pipe.
	SourceParameters *PipeSourceParameters `type:"structure"`

	// The list of key-value pairs to associate with the pipe.
	Tags map[string]*string `min:"1" type:"map"`

	// The ARN of the target resource.
	//
	// Target is a required field
	Target *string `min:"1" type:"string" required:"true"`

	// The parameters required to set up a target for your pipe.
	//
	// For more information about pipe target parameters, including how to use dynamic
	// path parameters, see Target parameters (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html)
	// in the Amazon EventBridge User Guide.
	TargetParameters *PipeTargetParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Target == nil {
		invalidParams.Add(request.NewErrParamRequired("Target"))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}
	if s.LogConfiguration != nil {
		if err := s.LogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceParameters != nil {
		if err := s.SourceParameters.Validate(); err != nil {
			invalidParams.AddNested("SourceParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetParameters != nil {
		if err := s.TargetParameters.Validate(); err != nil {
			invalidParams.AddNested("TargetParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreatePipeInput) SetDescription(v string) *CreatePipeInput {
	s.Description = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *CreatePipeInput) SetDesiredState(v string) *CreatePipeInput {
	s.DesiredState = &v
	return s
}

// SetEnrichment sets the Enrichment field's value.
func (s *CreatePipeInput) SetEnrichment(v string) *CreatePipeInput {
	s.Enrichment = &v
	return s
}

// SetEnrichmentParameters sets the EnrichmentParameters field's value.
func (s *CreatePipeInput) SetEnrichmentParameters(v *PipeEnrichmentParameters) *CreatePipeInput {
	s.EnrichmentParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *CreatePipeInput) SetLogConfiguration(v *PipeLogConfigurationParameters) *CreatePipeInput {
	s.LogConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePipeInput) SetName(v string) *CreatePipeInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreatePipeInput) SetRoleArn(v string) *CreatePipeInput {
	s.RoleArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreatePipeInput) SetSource(v string) *CreatePipeInput {
	s.Source = &v
	return s
}

// SetSourceParameters sets the SourceParameters field's value.
func (s *CreatePipeInput) SetSourceParameters(v *PipeSourceParameters) *CreatePipeInput {
	s.SourceParameters = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePipeInput) SetTags(v map[string]*string) *CreatePipeInput {
	s.Tags = v
	return s
}

// SetTarget sets the Target field's value.
func (s *CreatePipeInput) SetTarget(v string) *CreatePipeInput {
	s.Target = &v
	return s
}

// SetTargetParameters sets the TargetParameters field's value.
func (s *CreatePipeInput) SetTargetParameters(v *PipeTargetParameters) *CreatePipeInput {
	s.TargetParameters = v
	return s
}

type CreatePipeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipe.
	Arn *string `min:"1" type:"string"`

	// The time the pipe was created.
	CreationTime *time.Time `type:"timestamp"`

	// The state the pipe is in.
	CurrentState *string `type:"string" enum:"PipeState"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeState"`

	// When the pipe was last updated, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the pipe.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePipeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreatePipeOutput) SetArn(v string) *CreatePipeOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreatePipeOutput) SetCreationTime(v time.Time) *CreatePipeOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentState sets the CurrentState field's value.
func (s *CreatePipeOutput) SetCurrentState(v string) *CreatePipeOutput {
	s.CurrentState = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *CreatePipeOutput) SetDesiredState(v string) *CreatePipeOutput {
	s.DesiredState = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *CreatePipeOutput) SetLastModifiedTime(v time.Time) *CreatePipeOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePipeOutput) SetName(v string) *CreatePipeOutput {
	s.Name = &v
	return s
}

// A DeadLetterConfig object that contains information about a dead-letter queue
// configuration.
type DeadLetterConfig struct {
	_ struct{} `type:"structure"`

	// The ARN of the specified target for the dead-letter queue.
	//
	// For Amazon Kinesis stream and Amazon DynamoDB stream sources, specify either
	// an Amazon SNS topic or Amazon SQS queue ARN.
	Arn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeadLetterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeadLetterConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeadLetterConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeadLetterConfig"}
	if s.Arn != nil && len(*s.Arn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Arn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArn sets the Arn field's value.
func (s *DeadLetterConfig) SetArn(v string) *DeadLetterConfig {
	s.Arn = &v
	return s
}

type DeletePipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeletePipeInput) SetName(v string) *DeletePipeInput {
	s.Name = &v
	return s
}

type DeletePipeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipe.
	Arn *string `min:"1" type:"string"`

	// The time the pipe was created.
	CreationTime *time.Time `type:"timestamp"`

	// The state the pipe is in.
	CurrentState *string `type:"string" enum:"PipeState"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeStateDescribeResponse"`

	// When the pipe was last updated, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the pipe.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePipeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeletePipeOutput) SetArn(v string) *DeletePipeOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DeletePipeOutput) SetCreationTime(v time.Time) *DeletePipeOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentState sets the CurrentState field's value.
func (s *DeletePipeOutput) SetCurrentState(v string) *DeletePipeOutput {
	s.CurrentState = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *DeletePipeOutput) SetDesiredState(v string) *DeletePipeOutput {
	s.DesiredState = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DeletePipeOutput) SetLastModifiedTime(v time.Time) *DeletePipeOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeletePipeOutput) SetName(v string) *DeletePipeOutput {
	s.Name = &v
	return s
}

type DescribePipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribePipeInput) SetName(v string) *DescribePipeInput {
	s.Name = &v
	return s
}

type DescribePipeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipe.
	Arn *string `min:"1" type:"string"`

	// The time the pipe was created.
	CreationTime *time.Time `type:"timestamp"`

	// The state the pipe is in.
	CurrentState *string `type:"string" enum:"PipeState"`

	// A description of the pipe.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by DescribePipeOutput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeStateDescribeResponse"`

	// The ARN of the enrichment resource.
	Enrichment *string `type:"string"`

	// The parameters required to set up enrichment on your pipe.
	EnrichmentParameters *PipeEnrichmentParameters `type:"structure"`

	// When the pipe was last updated, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModifiedTime *time.Time `type:"timestamp"`

	// The logging configuration settings for the pipe.
	LogConfiguration *PipeLogConfiguration `type:"structure"`

	// The name of the pipe.
	Name *string `min:"1" type:"string"`

	// The ARN of the role that allows the pipe to send data to the target.
	RoleArn *string `min:"1" type:"string"`

	// The ARN of the source resource.
	Source *string `min:"1" type:"string"`

	// The parameters required to set up a source for your pipe.
	SourceParameters *PipeSourceParameters `type:"structure"`

	// The reason the pipe is in its current state.
	StateReason *string `type:"string"`

	// The list of key-value pairs to associate with the pipe.
	Tags map[string]*string `min:"1" type:"map"`

	// The ARN of the target resource.
	Target *string `min:"1" type:"string"`

	// The parameters required to set up a target for your pipe.
	//
	// For more information about pipe target parameters, including how to use dynamic
	// path parameters, see Target parameters (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html)
	// in the Amazon EventBridge User Guide.
	TargetParameters *PipeTargetParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePipeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribePipeOutput) SetArn(v string) *DescribePipeOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribePipeOutput) SetCreationTime(v time.Time) *DescribePipeOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentState sets the CurrentState field's value.
func (s *DescribePipeOutput) SetCurrentState(v string) *DescribePipeOutput {
	s.CurrentState = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribePipeOutput) SetDescription(v string) *DescribePipeOutput {
	s.Description = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *DescribePipeOutput) SetDesiredState(v string) *DescribePipeOutput {
	s.DesiredState = &v
	return s
}

// SetEnrichment sets the Enrichment field's value.
func (s *DescribePipeOutput) SetEnrichment(v string) *DescribePipeOutput {
	s.Enrichment = &v
	return s
}

// SetEnrichmentParameters sets the EnrichmentParameters field's value.
func (s *DescribePipeOutput) SetEnrichmentParameters(v *PipeEnrichmentParameters) *DescribePipeOutput {
	s.EnrichmentParameters = v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *DescribePipeOutput) SetLastModifiedTime(v time.Time) *DescribePipeOutput {
	s.LastModifiedTime = &v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *DescribePipeOutput) SetLogConfiguration(v *PipeLogConfiguration) *DescribePipeOutput {
	s.LogConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *DescribePipeOutput) SetName(v string) *DescribePipeOutput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *DescribePipeOutput) SetRoleArn(v string) *DescribePipeOutput {
	s.RoleArn = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DescribePipeOutput) SetSource(v string) *DescribePipeOutput {
	s.Source = &v
	return s
}

// SetSourceParameters sets the SourceParameters field's value.
func (s *DescribePipeOutput) SetSourceParameters(v *PipeSourceParameters) *DescribePipeOutput {
	s.SourceParameters = v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *DescribePipeOutput) SetStateReason(v string) *DescribePipeOutput {
	s.StateReason = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribePipeOutput) SetTags(v map[string]*string) *DescribePipeOutput {
	s.Tags = v
	return s
}

// SetTarget sets the Target field's value.
func (s *DescribePipeOutput) SetTarget(v string) *DescribePipeOutput {
	s.Target = &v
	return s
}

// SetTargetParameters sets the TargetParameters field's value.
func (s *DescribePipeOutput) SetTargetParameters(v *PipeTargetParameters) *DescribePipeOutput {
	s.TargetParameters = v
	return s
}

// Maps source data to a dimension in the target Timestream for LiveAnalytics
// table.
//
// For more information, see Amazon Timestream for LiveAnalytics concepts (https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html)
type DimensionMapping struct {
	_ struct{} `type:"structure"`

	// The metadata attributes of the time series. For example, the name and Availability
	// Zone of an Amazon EC2 instance or the name of the manufacturer of a wind
	// turbine are dimensions.
	//
	// DimensionName is a required field
	DimensionName *string `min:"1" type:"string" required:"true"`

	// Dynamic path to the dimension value in the source event.
	//
	// DimensionValue is a required field
	DimensionValue *string `min:"1" type:"string" required:"true"`

	// The data type of the dimension for the time-series data.
	//
	// DimensionValueType is a required field
	DimensionValueType *string `type:"string" required:"true" enum:"DimensionValueType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DimensionMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DimensionMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DimensionMapping"}
	if s.DimensionName == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionName"))
	}
	if s.DimensionName != nil && len(*s.DimensionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DimensionName", 1))
	}
	if s.DimensionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionValue"))
	}
	if s.DimensionValue != nil && len(*s.DimensionValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DimensionValue", 1))
	}
	if s.DimensionValueType == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionValueType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionName sets the DimensionName field's value.
func (s *DimensionMapping) SetDimensionName(v string) *DimensionMapping {
	s.DimensionName = &v
	return s
}

// SetDimensionValue sets the DimensionValue field's value.
func (s *DimensionMapping) SetDimensionValue(v string) *DimensionMapping {
	s.DimensionValue = &v
	return s
}

// SetDimensionValueType sets the DimensionValueType field's value.
func (s *DimensionMapping) SetDimensionValueType(v string) *DimensionMapping {
	s.DimensionValueType = &v
	return s
}

// The overrides that are sent to a container. An empty container override can
// be passed in. An example of an empty container override is {"containerOverrides":
// [ ] }. If a non-empty container override is specified, the name parameter
// must be included.
type EcsContainerOverride struct {
	_ struct{} `type:"structure"`

	// The command to send to the container that overrides the default command from
	// the Docker image or the task definition. You must also specify a container
	// name.
	Command []*string `type:"list"`

	// The number of cpu units reserved for the container, instead of the default
	// value from the task definition. You must also specify a container name.
	Cpu *int64 `type:"integer"`

	// The environment variables to send to the container. You can add new environment
	// variables, which are added to the container at launch, or you can override
	// the existing environment variables from the Docker image or the task definition.
	// You must also specify a container name.
	Environment []*EcsEnvironmentVariable `type:"list"`

	// A list of files containing the environment variables to pass to a container,
	// instead of the value from the container definition.
	EnvironmentFiles []*EcsEnvironmentFile `type:"list"`

	// The hard limit (in MiB) of memory to present to the container, instead of
	// the default value from the task definition. If your container attempts to
	// exceed the memory specified here, the container is killed. You must also
	// specify a container name.
	Memory *int64 `type:"integer"`

	// The soft limit (in MiB) of memory to reserve for the container, instead of
	// the default value from the task definition. You must also specify a container
	// name.
	MemoryReservation *int64 `type:"integer"`

	// The name of the container that receives the override. This parameter is required
	// if any override is specified.
	Name *string `type:"string"`

	// The type and amount of a resource to assign to a container, instead of the
	// default value from the task definition. The only supported resource is a
	// GPU.
	ResourceRequirements []*EcsResourceRequirement `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsContainerOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsContainerOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsContainerOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsContainerOverride"}
	if s.EnvironmentFiles != nil {
		for i, v := range s.EnvironmentFiles {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "EnvironmentFiles", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ResourceRequirements != nil {
		for i, v := range s.ResourceRequirements {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ResourceRequirements", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *EcsContainerOverride) SetCommand(v []*string) *EcsContainerOverride {
	s.Command = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *EcsContainerOverride) SetCpu(v int64) *EcsContainerOverride {
	s.Cpu = &v
	return s
}

// SetEnvironment sets the Environment field's value.
func (s *EcsContainerOverride) SetEnvironment(v []*EcsEnvironmentVariable) *EcsContainerOverride {
	s.Environment = v
	return s
}

// SetEnvironmentFiles sets the EnvironmentFiles field's value.
func (s *EcsContainerOverride) SetEnvironmentFiles(v []*EcsEnvironmentFile) *EcsContainerOverride {
	s.EnvironmentFiles = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *EcsContainerOverride) SetMemory(v int64) *EcsContainerOverride {
	s.Memory = &v
	return s
}

// SetMemoryReservation sets the MemoryReservation field's value.
func (s *EcsContainerOverride) SetMemoryReservation(v int64) *EcsContainerOverride {
	s.MemoryReservation = &v
	return s
}

// SetName sets the Name field's value.
func (s *EcsContainerOverride) SetName(v string) *EcsContainerOverride {
	s.Name = &v
	return s
}

// SetResourceRequirements sets the ResourceRequirements field's value.
func (s *EcsContainerOverride) SetResourceRequirements(v []*EcsResourceRequirement) *EcsContainerOverride {
	s.ResourceRequirements = v
	return s
}

// A list of files containing the environment variables to pass to a container.
// You can specify up to ten environment files. The file must have a .env file
// extension. Each line in an environment file should contain an environment
// variable in VARIABLE=VALUE format. Lines beginning with # are treated as
// comments and are ignored. For more information about the environment variable
// file syntax, see Declare default environment variables in file (https://docs.docker.com/compose/env-file/).
//
// If there are environment variables specified using the environment parameter
// in a container definition, they take precedence over the variables contained
// within an environment file. If multiple environment files are specified that
// contain the same variable, they're processed from the top down. We recommend
// that you use unique variable names. For more information, see Specifying
// environment variables (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/taskdef-envfiles.html)
// in the Amazon Elastic Container Service Developer Guide.
//
// This parameter is only supported for tasks hosted on Fargate using the following
// platform versions:
//
//   - Linux platform version 1.4.0 or later.
//
//   - Windows platform version 1.0.0 or later.
type EcsEnvironmentFile struct {
	_ struct{} `type:"structure"`

	// The file type to use. The only supported value is s3.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EcsEnvironmentFileType"`

	// The Amazon Resource Name (ARN) of the Amazon S3 object containing the environment
	// variable file.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsEnvironmentFile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsEnvironmentFile) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsEnvironmentFile) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsEnvironmentFile"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *EcsEnvironmentFile) SetType(v string) *EcsEnvironmentFile {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EcsEnvironmentFile) SetValue(v string) *EcsEnvironmentFile {
	s.Value = &v
	return s
}

// The environment variables to send to the container. You can add new environment
// variables, which are added to the container at launch, or you can override
// the existing environment variables from the Docker image or the task definition.
// You must also specify a container name.
type EcsEnvironmentVariable struct {
	_ struct{} `type:"structure"`

	// The name of the key-value pair. For environment variables, this is the name
	// of the environment variable.
	Name *string `locationName:"name" type:"string"`

	// The value of the key-value pair. For environment variables, this is the value
	// of the environment variable.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsEnvironmentVariable) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsEnvironmentVariable) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EcsEnvironmentVariable) SetName(v string) *EcsEnvironmentVariable {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EcsEnvironmentVariable) SetValue(v string) *EcsEnvironmentVariable {
	s.Value = &v
	return s
}

// The amount of ephemeral storage to allocate for the task. This parameter
// is used to expand the total amount of ephemeral storage available, beyond
// the default amount, for tasks hosted on Fargate. For more information, see
// Fargate task storage (https://docs.aws.amazon.com/AmazonECS/latest/userguide/using_data_volumes.html)
// in the Amazon ECS User Guide for Fargate.
//
// This parameter is only supported for tasks hosted on Fargate using Linux
// platform version 1.4.0 or later. This parameter is not supported for Windows
// containers on Fargate.
type EcsEphemeralStorage struct {
	_ struct{} `type:"structure"`

	// The total amount, in GiB, of ephemeral storage to set for the task. The minimum
	// supported value is 21 GiB and the maximum supported value is 200 GiB.
	//
	// SizeInGiB is a required field
	SizeInGiB *int64 `locationName:"sizeInGiB" min:"21" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsEphemeralStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsEphemeralStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsEphemeralStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsEphemeralStorage"}
	if s.SizeInGiB == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeInGiB"))
	}
	if s.SizeInGiB != nil && *s.SizeInGiB < 21 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInGiB", 21))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSizeInGiB sets the SizeInGiB field's value.
func (s *EcsEphemeralStorage) SetSizeInGiB(v int64) *EcsEphemeralStorage {
	s.SizeInGiB = &v
	return s
}

// Details on an Elastic Inference accelerator task override. This parameter
// is used to override the Elastic Inference accelerator specified in the task
// definition. For more information, see Working with Amazon Elastic Inference
// on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/userguide/ecs-inference.html)
// in the Amazon Elastic Container Service Developer Guide.
type EcsInferenceAcceleratorOverride struct {
	_ struct{} `type:"structure"`

	// The Elastic Inference accelerator device name to override for the task. This
	// parameter must match a deviceName specified in the task definition.
	DeviceName *string `locationName:"deviceName" type:"string"`

	// The Elastic Inference accelerator type to use.
	DeviceType *string `locationName:"deviceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsInferenceAcceleratorOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsInferenceAcceleratorOverride) GoString() string {
	return s.String()
}

// SetDeviceName sets the DeviceName field's value.
func (s *EcsInferenceAcceleratorOverride) SetDeviceName(v string) *EcsInferenceAcceleratorOverride {
	s.DeviceName = &v
	return s
}

// SetDeviceType sets the DeviceType field's value.
func (s *EcsInferenceAcceleratorOverride) SetDeviceType(v string) *EcsInferenceAcceleratorOverride {
	s.DeviceType = &v
	return s
}

// The type and amount of a resource to assign to a container. The supported
// resource types are GPUs and Elastic Inference accelerators. For more information,
// see Working with GPUs on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-gpu.html)
// or Working with Amazon Elastic Inference on Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-inference.html)
// in the Amazon Elastic Container Service Developer Guide
type EcsResourceRequirement struct {
	_ struct{} `type:"structure"`

	// The type of resource to assign to a container. The supported values are GPU
	// or InferenceAccelerator.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"EcsResourceRequirementType"`

	// The value for the specified resource type.
	//
	// If the GPU type is used, the value is the number of physical GPUs the Amazon
	// ECS container agent reserves for the container. The number of GPUs that's
	// reserved for all containers in a task can't exceed the number of available
	// GPUs on the container instance that the task is launched on.
	//
	// If the InferenceAccelerator type is used, the value matches the deviceName
	// for an InferenceAccelerator specified in a task definition.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsResourceRequirement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsResourceRequirement) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsResourceRequirement) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsResourceRequirement"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *EcsResourceRequirement) SetType(v string) *EcsResourceRequirement {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EcsResourceRequirement) SetValue(v string) *EcsResourceRequirement {
	s.Value = &v
	return s
}

// The overrides that are associated with a task.
type EcsTaskOverride struct {
	_ struct{} `type:"structure"`

	// One or more container overrides that are sent to a task.
	ContainerOverrides []*EcsContainerOverride `type:"list"`

	// The cpu override for the task.
	Cpu *string `type:"string"`

	// The ephemeral storage setting override for the task.
	//
	// This parameter is only supported for tasks hosted on Fargate that use the
	// following platform versions:
	//
	//    * Linux platform version 1.4.0 or later.
	//
	//    * Windows platform version 1.0.0 or later.
	EphemeralStorage *EcsEphemeralStorage `type:"structure"`

	// The Amazon Resource Name (ARN) of the task execution IAM role override for
	// the task. For more information, see Amazon ECS task execution IAM role (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_execution_IAM_role.html)
	// in the Amazon Elastic Container Service Developer Guide.
	ExecutionRoleArn *string `min:"1" type:"string"`

	// The Elastic Inference accelerator override for the task.
	InferenceAcceleratorOverrides []*EcsInferenceAcceleratorOverride `type:"list"`

	// The memory override for the task.
	Memory *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that containers in this task
	// can assume. All containers in this task are granted the permissions that
	// are specified in this role. For more information, see IAM Role for Tasks
	// (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html)
	// in the Amazon Elastic Container Service Developer Guide.
	TaskRoleArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsTaskOverride) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EcsTaskOverride) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EcsTaskOverride) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EcsTaskOverride"}
	if s.ExecutionRoleArn != nil && len(*s.ExecutionRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExecutionRoleArn", 1))
	}
	if s.TaskRoleArn != nil && len(*s.TaskRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskRoleArn", 1))
	}
	if s.ContainerOverrides != nil {
		for i, v := range s.ContainerOverrides {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ContainerOverrides", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.EphemeralStorage != nil {
		if err := s.EphemeralStorage.Validate(); err != nil {
			invalidParams.AddNested("EphemeralStorage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContainerOverrides sets the ContainerOverrides field's value.
func (s *EcsTaskOverride) SetContainerOverrides(v []*EcsContainerOverride) *EcsTaskOverride {
	s.ContainerOverrides = v
	return s
}

// SetCpu sets the Cpu field's value.
func (s *EcsTaskOverride) SetCpu(v string) *EcsTaskOverride {
	s.Cpu = &v
	return s
}

// SetEphemeralStorage sets the EphemeralStorage field's value.
func (s *EcsTaskOverride) SetEphemeralStorage(v *EcsEphemeralStorage) *EcsTaskOverride {
	s.EphemeralStorage = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *EcsTaskOverride) SetExecutionRoleArn(v string) *EcsTaskOverride {
	s.ExecutionRoleArn = &v
	return s
}

// SetInferenceAcceleratorOverrides sets the InferenceAcceleratorOverrides field's value.
func (s *EcsTaskOverride) SetInferenceAcceleratorOverrides(v []*EcsInferenceAcceleratorOverride) *EcsTaskOverride {
	s.InferenceAcceleratorOverrides = v
	return s
}

// SetMemory sets the Memory field's value.
func (s *EcsTaskOverride) SetMemory(v string) *EcsTaskOverride {
	s.Memory = &v
	return s
}

// SetTaskRoleArn sets the TaskRoleArn field's value.
func (s *EcsTaskOverride) SetTaskRoleArn(v string) *EcsTaskOverride {
	s.TaskRoleArn = &v
	return s
}

// Filter events using an event pattern. For more information, see Events and
// Event Patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
// in the Amazon EventBridge User Guide.
type Filter struct {
	_ struct{} `type:"structure"`

	// The event pattern.
	//
	// Pattern is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Filter's
	// String and GoString methods.
	Pattern *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Filter) GoString() string {
	return s.String()
}

// SetPattern sets the Pattern field's value.
func (s *Filter) SetPattern(v string) *Filter {
	s.Pattern = &v
	return s
}

// The collection of event patterns used to filter events.
//
// To remove a filter, specify a FilterCriteria object with an empty array of
// Filter objects.
//
// For more information, see Events and Event Patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
// in the Amazon EventBridge User Guide.
type FilterCriteria struct {
	_ struct{} `type:"structure"`

	// The event patterns.
	Filters []*Filter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCriteria) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FilterCriteria) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *FilterCriteria) SetFilters(v []*Filter) *FilterCriteria {
	s.Filters = v
	return s
}

// The Amazon Data Firehose logging configuration settings for the pipe.
type FirehoseLogDestination struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Firehose delivery stream to which EventBridge
	// delivers the pipe log records.
	DeliveryStreamArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseLogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseLogDestination) GoString() string {
	return s.String()
}

// SetDeliveryStreamArn sets the DeliveryStreamArn field's value.
func (s *FirehoseLogDestination) SetDeliveryStreamArn(v string) *FirehoseLogDestination {
	s.DeliveryStreamArn = &v
	return s
}

// The Amazon Data Firehose logging configuration settings for the pipe.
type FirehoseLogDestinationParameters struct {
	_ struct{} `type:"structure"`

	// Specifies the Amazon Resource Name (ARN) of the Firehose delivery stream
	// to which EventBridge delivers the pipe log records.
	//
	// DeliveryStreamArn is a required field
	DeliveryStreamArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseLogDestinationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FirehoseLogDestinationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FirehoseLogDestinationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FirehoseLogDestinationParameters"}
	if s.DeliveryStreamArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamArn"))
	}
	if s.DeliveryStreamArn != nil && len(*s.DeliveryStreamArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamArn sets the DeliveryStreamArn field's value.
func (s *FirehoseLogDestinationParameters) SetDeliveryStreamArn(v string) *FirehoseLogDestinationParameters {
	s.DeliveryStreamArn = &v
	return s
}

// This exception occurs due to unexpected causes.
type InternalException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The number of seconds to wait before retrying the action that caused the
	// exception.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalException) GoString() string {
	return s.String()
}

func newErrorInternalException(v protocol.ResponseMetadata) error {
	return &InternalException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalException) Code() string {
	return "InternalException"
}

// Message returns the exception's message.
func (s *InternalException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalException) OrigErr() error {
	return nil
}

func (s *InternalException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListPipesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The state the pipe is in.
	CurrentState *string `location:"querystring" locationName:"CurrentState" type:"string" enum:"PipeState"`

	// The state the pipe should be in.
	DesiredState *string `location:"querystring" locationName:"DesiredState" type:"string" enum:"RequestedPipeState"`

	// The maximum number of pipes to include in the response.
	Limit *int64 `location:"querystring" locationName:"Limit" min:"1" type:"integer"`

	// A value that will return a subset of the pipes associated with this account.
	// For example, "NamePrefix": "ABC" will return all endpoints with "ABC" in
	// the name.
	NamePrefix *string `location:"querystring" locationName:"NamePrefix" min:"1" type:"string"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListPipesInput's
	// String and GoString methods.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string" sensitive:"true"`

	// The prefix matching the pipe source.
	SourcePrefix *string `location:"querystring" locationName:"SourcePrefix" min:"1" type:"string"`

	// The prefix matching the pipe target.
	TargetPrefix *string `location:"querystring" locationName:"TargetPrefix" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPipesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPipesInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NamePrefix != nil && len(*s.NamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NamePrefix", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.SourcePrefix != nil && len(*s.SourcePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourcePrefix", 1))
	}
	if s.TargetPrefix != nil && len(*s.TargetPrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TargetPrefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentState sets the CurrentState field's value.
func (s *ListPipesInput) SetCurrentState(v string) *ListPipesInput {
	s.CurrentState = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *ListPipesInput) SetDesiredState(v string) *ListPipesInput {
	s.DesiredState = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListPipesInput) SetLimit(v int64) *ListPipesInput {
	s.Limit = &v
	return s
}

// SetNamePrefix sets the NamePrefix field's value.
func (s *ListPipesInput) SetNamePrefix(v string) *ListPipesInput {
	s.NamePrefix = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipesInput) SetNextToken(v string) *ListPipesInput {
	s.NextToken = &v
	return s
}

// SetSourcePrefix sets the SourcePrefix field's value.
func (s *ListPipesInput) SetSourcePrefix(v string) *ListPipesInput {
	s.SourcePrefix = &v
	return s
}

// SetTargetPrefix sets the TargetPrefix field's value.
func (s *ListPipesInput) SetTargetPrefix(v string) *ListPipesInput {
	s.TargetPrefix = &v
	return s
}

type ListPipesOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page. Keep all other arguments
	// unchanged. Each pagination token expires after 24 hours. Using an expired
	// pagination token will return an HTTP 400 InvalidToken error.
	//
	// NextToken is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListPipesOutput's
	// String and GoString methods.
	NextToken *string `min:"1" type:"string" sensitive:"true"`

	// The pipes returned by the call.
	Pipes []*Pipe `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPipesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListPipesOutput) SetNextToken(v string) *ListPipesOutput {
	s.NextToken = &v
	return s
}

// SetPipes sets the Pipes field's value.
func (s *ListPipesOutput) SetPipes(v []*Pipe) *ListPipesOutput {
	s.Pipes = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the pipe for which you want to view tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of key-value pairs to associate with the pipe.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The Secrets Manager secret that stores your broker credentials.
type MQBrokerAccessCredentials struct {
	_ struct{} `type:"structure"`

	// The ARN of the Secrets Manager secret.
	BasicAuth *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MQBrokerAccessCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MQBrokerAccessCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MQBrokerAccessCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MQBrokerAccessCredentials"}
	if s.BasicAuth != nil && len(*s.BasicAuth) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasicAuth", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasicAuth sets the BasicAuth field's value.
func (s *MQBrokerAccessCredentials) SetBasicAuth(v string) *MQBrokerAccessCredentials {
	s.BasicAuth = &v
	return s
}

// The Secrets Manager secret that stores your stream credentials.
type MSKAccessCredentials struct {
	_ struct{} `type:"structure"`

	// The ARN of the Secrets Manager secret.
	ClientCertificateTlsAuth *string `min:"1" type:"string"`

	// The ARN of the Secrets Manager secret.
	SaslScram512Auth *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MSKAccessCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MSKAccessCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MSKAccessCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MSKAccessCredentials"}
	if s.ClientCertificateTlsAuth != nil && len(*s.ClientCertificateTlsAuth) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientCertificateTlsAuth", 1))
	}
	if s.SaslScram512Auth != nil && len(*s.SaslScram512Auth) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SaslScram512Auth", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientCertificateTlsAuth sets the ClientCertificateTlsAuth field's value.
func (s *MSKAccessCredentials) SetClientCertificateTlsAuth(v string) *MSKAccessCredentials {
	s.ClientCertificateTlsAuth = &v
	return s
}

// SetSaslScram512Auth sets the SaslScram512Auth field's value.
func (s *MSKAccessCredentials) SetSaslScram512Auth(v string) *MSKAccessCredentials {
	s.SaslScram512Auth = &v
	return s
}

// A mapping of a source event data field to a measure in a Timestream for LiveAnalytics
// record.
type MultiMeasureAttributeMapping struct {
	_ struct{} `type:"structure"`

	// Dynamic path to the measurement attribute in the source event.
	//
	// MeasureValue is a required field
	MeasureValue *string `min:"1" type:"string" required:"true"`

	// Data type of the measurement attribute in the source event.
	//
	// MeasureValueType is a required field
	MeasureValueType *string `type:"string" required:"true" enum:"MeasureValueType"`

	// Target measure name to be used.
	//
	// MultiMeasureAttributeName is a required field
	MultiMeasureAttributeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureAttributeMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureAttributeMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiMeasureAttributeMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiMeasureAttributeMapping"}
	if s.MeasureValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureValue"))
	}
	if s.MeasureValue != nil && len(*s.MeasureValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureValue", 1))
	}
	if s.MeasureValueType == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureValueType"))
	}
	if s.MultiMeasureAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiMeasureAttributeName"))
	}
	if s.MultiMeasureAttributeName != nil && len(*s.MultiMeasureAttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiMeasureAttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeasureValue sets the MeasureValue field's value.
func (s *MultiMeasureAttributeMapping) SetMeasureValue(v string) *MultiMeasureAttributeMapping {
	s.MeasureValue = &v
	return s
}

// SetMeasureValueType sets the MeasureValueType field's value.
func (s *MultiMeasureAttributeMapping) SetMeasureValueType(v string) *MultiMeasureAttributeMapping {
	s.MeasureValueType = &v
	return s
}

// SetMultiMeasureAttributeName sets the MultiMeasureAttributeName field's value.
func (s *MultiMeasureAttributeMapping) SetMultiMeasureAttributeName(v string) *MultiMeasureAttributeMapping {
	s.MultiMeasureAttributeName = &v
	return s
}

// Maps multiple measures from the source event to the same Timestream for LiveAnalytics
// record.
//
// For more information, see Amazon Timestream for LiveAnalytics concepts (https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html)
type MultiMeasureMapping struct {
	_ struct{} `type:"structure"`

	// Mappings that represent multiple source event fields mapped to measures in
	// the same Timestream for LiveAnalytics record.
	//
	// MultiMeasureAttributeMappings is a required field
	MultiMeasureAttributeMappings []*MultiMeasureAttributeMapping `min:"1" type:"list" required:"true"`

	// The name of the multiple measurements per record (multi-measure).
	//
	// MultiMeasureName is a required field
	MultiMeasureName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MultiMeasureMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MultiMeasureMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MultiMeasureMapping"}
	if s.MultiMeasureAttributeMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiMeasureAttributeMappings"))
	}
	if s.MultiMeasureAttributeMappings != nil && len(s.MultiMeasureAttributeMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiMeasureAttributeMappings", 1))
	}
	if s.MultiMeasureName == nil {
		invalidParams.Add(request.NewErrParamRequired("MultiMeasureName"))
	}
	if s.MultiMeasureName != nil && len(*s.MultiMeasureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MultiMeasureName", 1))
	}
	if s.MultiMeasureAttributeMappings != nil {
		for i, v := range s.MultiMeasureAttributeMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MultiMeasureAttributeMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMultiMeasureAttributeMappings sets the MultiMeasureAttributeMappings field's value.
func (s *MultiMeasureMapping) SetMultiMeasureAttributeMappings(v []*MultiMeasureAttributeMapping) *MultiMeasureMapping {
	s.MultiMeasureAttributeMappings = v
	return s
}

// SetMultiMeasureName sets the MultiMeasureName field's value.
func (s *MultiMeasureMapping) SetMultiMeasureName(v string) *MultiMeasureMapping {
	s.MultiMeasureName = &v
	return s
}

// This structure specifies the network configuration for an Amazon ECS task.
type NetworkConfiguration struct {
	_ struct{} `type:"structure"`

	// Use this structure to specify the VPC subnets and security groups for the
	// task, and whether a public IP address is to be used. This structure is relevant
	// only for ECS tasks that use the awsvpc network mode.
	AwsvpcConfiguration *AwsVpcConfiguration `locationName:"awsvpcConfiguration" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkConfiguration"}
	if s.AwsvpcConfiguration != nil {
		if err := s.AwsvpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AwsvpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAwsvpcConfiguration sets the AwsvpcConfiguration field's value.
func (s *NetworkConfiguration) SetAwsvpcConfiguration(v *AwsVpcConfiguration) *NetworkConfiguration {
	s.AwsvpcConfiguration = v
	return s
}

// An entity that you specified does not exist.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents a pipe. Amazon EventBridgePipes connect event sources
// to targets and reduces the need for specialized knowledge and integration
// code.
type Pipe struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipe.
	Arn *string `min:"1" type:"string"`

	// The time the pipe was created.
	CreationTime *time.Time `type:"timestamp"`

	// The state the pipe is in.
	CurrentState *string `type:"string" enum:"PipeState"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeState"`

	// The ARN of the enrichment resource.
	Enrichment *string `type:"string"`

	// When the pipe was last updated, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the pipe.
	Name *string `min:"1" type:"string"`

	// The ARN of the source resource.
	Source *string `min:"1" type:"string"`

	// The reason the pipe is in its current state.
	StateReason *string `type:"string"`

	// The ARN of the target resource.
	Target *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Pipe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Pipe) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Pipe) SetArn(v string) *Pipe {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Pipe) SetCreationTime(v time.Time) *Pipe {
	s.CreationTime = &v
	return s
}

// SetCurrentState sets the CurrentState field's value.
func (s *Pipe) SetCurrentState(v string) *Pipe {
	s.CurrentState = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *Pipe) SetDesiredState(v string) *Pipe {
	s.DesiredState = &v
	return s
}

// SetEnrichment sets the Enrichment field's value.
func (s *Pipe) SetEnrichment(v string) *Pipe {
	s.Enrichment = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *Pipe) SetLastModifiedTime(v time.Time) *Pipe {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Pipe) SetName(v string) *Pipe {
	s.Name = &v
	return s
}

// SetSource sets the Source field's value.
func (s *Pipe) SetSource(v string) *Pipe {
	s.Source = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *Pipe) SetStateReason(v string) *Pipe {
	s.StateReason = &v
	return s
}

// SetTarget sets the Target field's value.
func (s *Pipe) SetTarget(v string) *Pipe {
	s.Target = &v
	return s
}

// These are custom parameter to be used when the target is an API Gateway REST
// APIs or EventBridge ApiDestinations. In the latter case, these are merged
// with any InvocationParameters specified on the Connection, with any values
// from the Connection taking precedence.
type PipeEnrichmentHttpParameters struct {
	_ struct{} `type:"structure"`

	// The headers that need to be sent as part of request invoking the API Gateway
	// REST API or EventBridge ApiDestination.
	HeaderParameters map[string]*string `type:"map"`

	// The path parameter values to be used to populate API Gateway REST API or
	// EventBridge ApiDestination path wildcards ("*").
	PathParameterValues []*string `type:"list"`

	// The query string keys/values that need to be sent as part of request invoking
	// the API Gateway REST API or EventBridge ApiDestination.
	QueryStringParameters map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeEnrichmentHttpParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeEnrichmentHttpParameters) GoString() string {
	return s.String()
}

// SetHeaderParameters sets the HeaderParameters field's value.
func (s *PipeEnrichmentHttpParameters) SetHeaderParameters(v map[string]*string) *PipeEnrichmentHttpParameters {
	s.HeaderParameters = v
	return s
}

// SetPathParameterValues sets the PathParameterValues field's value.
func (s *PipeEnrichmentHttpParameters) SetPathParameterValues(v []*string) *PipeEnrichmentHttpParameters {
	s.PathParameterValues = v
	return s
}

// SetQueryStringParameters sets the QueryStringParameters field's value.
func (s *PipeEnrichmentHttpParameters) SetQueryStringParameters(v map[string]*string) *PipeEnrichmentHttpParameters {
	s.QueryStringParameters = v
	return s
}

// The parameters required to set up enrichment on your pipe.
type PipeEnrichmentParameters struct {
	_ struct{} `type:"structure"`

	// Contains the HTTP parameters to use when the target is a API Gateway REST
	// endpoint or EventBridge ApiDestination.
	//
	// If you specify an API Gateway REST API or EventBridge ApiDestination as a
	// target, you can use this parameter to specify headers, path parameters, and
	// query string keys/values as part of your target invoking request. If you're
	// using ApiDestinations, the corresponding Connection can also have these values
	// configured. In case of any conflicting keys, values from the Connection take
	// precedence.
	HttpParameters *PipeEnrichmentHttpParameters `type:"structure"`

	// Valid JSON text passed to the enrichment. In this case, nothing from the
	// event itself is passed to the enrichment. For more information, see The JavaScript
	// Object Notation (JSON) Data Interchange Format (http://www.rfc-editor.org/rfc/rfc7159.txt).
	//
	// To remove an input template, specify an empty string.
	//
	// InputTemplate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeEnrichmentParameters's
	// String and GoString methods.
	InputTemplate *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeEnrichmentParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeEnrichmentParameters) GoString() string {
	return s.String()
}

// SetHttpParameters sets the HttpParameters field's value.
func (s *PipeEnrichmentParameters) SetHttpParameters(v *PipeEnrichmentHttpParameters) *PipeEnrichmentParameters {
	s.HttpParameters = v
	return s
}

// SetInputTemplate sets the InputTemplate field's value.
func (s *PipeEnrichmentParameters) SetInputTemplate(v string) *PipeEnrichmentParameters {
	s.InputTemplate = &v
	return s
}

// The logging configuration settings for the pipe.
type PipeLogConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch Logs logging configuration settings for the pipe.
	CloudwatchLogsLogDestination *CloudwatchLogsLogDestination `type:"structure"`

	// The Amazon Data Firehose logging configuration settings for the pipe.
	FirehoseLogDestination *FirehoseLogDestination `type:"structure"`

	// Whether the execution data (specifically, the payload, awsRequest, and awsResponse
	// fields) is included in the log messages for this pipe.
	//
	// This applies to all log destinations for the pipe.
	//
	// For more information, see Including execution data in logs (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-execution-data)
	// in the Amazon EventBridge User Guide.
	IncludeExecutionData []*string `type:"list" enum:"IncludeExecutionDataOption"`

	// The level of logging detail to include. This applies to all log destinations
	// for the pipe.
	Level *string `type:"string" enum:"LogLevel"`

	// The Amazon S3 logging configuration settings for the pipe.
	S3LogDestination *S3LogDestination `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeLogConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeLogConfiguration) GoString() string {
	return s.String()
}

// SetCloudwatchLogsLogDestination sets the CloudwatchLogsLogDestination field's value.
func (s *PipeLogConfiguration) SetCloudwatchLogsLogDestination(v *CloudwatchLogsLogDestination) *PipeLogConfiguration {
	s.CloudwatchLogsLogDestination = v
	return s
}

// SetFirehoseLogDestination sets the FirehoseLogDestination field's value.
func (s *PipeLogConfiguration) SetFirehoseLogDestination(v *FirehoseLogDestination) *PipeLogConfiguration {
	s.FirehoseLogDestination = v
	return s
}

// SetIncludeExecutionData sets the IncludeExecutionData field's value.
func (s *PipeLogConfiguration) SetIncludeExecutionData(v []*string) *PipeLogConfiguration {
	s.IncludeExecutionData = v
	return s
}

// SetLevel sets the Level field's value.
func (s *PipeLogConfiguration) SetLevel(v string) *PipeLogConfiguration {
	s.Level = &v
	return s
}

// SetS3LogDestination sets the S3LogDestination field's value.
func (s *PipeLogConfiguration) SetS3LogDestination(v *S3LogDestination) *PipeLogConfiguration {
	s.S3LogDestination = v
	return s
}

// Specifies the logging configuration settings for the pipe.
//
// When you call UpdatePipe, EventBridge updates the fields in the PipeLogConfigurationParameters
// object atomically as one and overrides existing values. This is by design.
// If you don't specify an optional field in any of the Amazon Web Services
// service parameters objects (CloudwatchLogsLogDestinationParameters, FirehoseLogDestinationParameters,
// or S3LogDestinationParameters), EventBridge sets that field to its system-default
// value during the update.
//
// For example, suppose when you created the pipe you specified a Firehose stream
// log destination. You then update the pipe to add an Amazon S3 log destination.
// In addition to specifying the S3LogDestinationParameters for the new log
// destination, you must also specify the fields in the FirehoseLogDestinationParameters
// object in order to retain the Firehose stream log destination.
//
// For more information on generating pipe log records, see Log EventBridge
// Pipes (eventbridge/latest/userguide/eb-pipes-logs.html) in the Amazon EventBridge
// User Guide.
type PipeLogConfigurationParameters struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch Logs logging configuration settings for the pipe.
	CloudwatchLogsLogDestination *CloudwatchLogsLogDestinationParameters `type:"structure"`

	// The Amazon Data Firehose logging configuration settings for the pipe.
	FirehoseLogDestination *FirehoseLogDestinationParameters `type:"structure"`

	// Specify ALL to include the execution data (specifically, the payload, awsRequest,
	// and awsResponse fields) in the log messages for this pipe.
	//
	// This applies to all log destinations for the pipe.
	//
	// For more information, see Including execution data in logs (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-execution-data)
	// in the Amazon EventBridge User Guide.
	//
	// By default, execution data is not included.
	IncludeExecutionData []*string `type:"list" enum:"IncludeExecutionDataOption"`

	// The level of logging detail to include. This applies to all log destinations
	// for the pipe.
	//
	// For more information, see Specifying EventBridge Pipes log level (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-logs.html#eb-pipes-logs-level)
	// in the Amazon EventBridge User Guide.
	//
	// Level is a required field
	Level *string `type:"string" required:"true" enum:"LogLevel"`

	// The Amazon S3 logging configuration settings for the pipe.
	S3LogDestination *S3LogDestinationParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeLogConfigurationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeLogConfigurationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeLogConfigurationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeLogConfigurationParameters"}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}
	if s.CloudwatchLogsLogDestination != nil {
		if err := s.CloudwatchLogsLogDestination.Validate(); err != nil {
			invalidParams.AddNested("CloudwatchLogsLogDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.FirehoseLogDestination != nil {
		if err := s.FirehoseLogDestination.Validate(); err != nil {
			invalidParams.AddNested("FirehoseLogDestination", err.(request.ErrInvalidParams))
		}
	}
	if s.S3LogDestination != nil {
		if err := s.S3LogDestination.Validate(); err != nil {
			invalidParams.AddNested("S3LogDestination", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudwatchLogsLogDestination sets the CloudwatchLogsLogDestination field's value.
func (s *PipeLogConfigurationParameters) SetCloudwatchLogsLogDestination(v *CloudwatchLogsLogDestinationParameters) *PipeLogConfigurationParameters {
	s.CloudwatchLogsLogDestination = v
	return s
}

// SetFirehoseLogDestination sets the FirehoseLogDestination field's value.
func (s *PipeLogConfigurationParameters) SetFirehoseLogDestination(v *FirehoseLogDestinationParameters) *PipeLogConfigurationParameters {
	s.FirehoseLogDestination = v
	return s
}

// SetIncludeExecutionData sets the IncludeExecutionData field's value.
func (s *PipeLogConfigurationParameters) SetIncludeExecutionData(v []*string) *PipeLogConfigurationParameters {
	s.IncludeExecutionData = v
	return s
}

// SetLevel sets the Level field's value.
func (s *PipeLogConfigurationParameters) SetLevel(v string) *PipeLogConfigurationParameters {
	s.Level = &v
	return s
}

// SetS3LogDestination sets the S3LogDestination field's value.
func (s *PipeLogConfigurationParameters) SetS3LogDestination(v *S3LogDestinationParameters) *PipeLogConfigurationParameters {
	s.S3LogDestination = v
	return s
}

// The parameters for using an Active MQ broker as a source.
type PipeSourceActiveMQBrokerParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The credentials needed to access the resource.
	//
	// Credentials is a required field
	Credentials *MQBrokerAccessCredentials `type:"structure" required:"true"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// The name of the destination queue to consume.
	//
	// QueueName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeSourceActiveMQBrokerParameters's
	// String and GoString methods.
	//
	// QueueName is a required field
	QueueName *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceActiveMQBrokerParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceActiveMQBrokerParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeSourceActiveMQBrokerParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeSourceActiveMQBrokerParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.Credentials == nil {
		invalidParams.Add(request.NewErrParamRequired("Credentials"))
	}
	if s.QueueName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueName"))
	}
	if s.QueueName != nil && len(*s.QueueName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueName", 1))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *PipeSourceActiveMQBrokerParameters) SetBatchSize(v int64) *PipeSourceActiveMQBrokerParameters {
	s.BatchSize = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *PipeSourceActiveMQBrokerParameters) SetCredentials(v *MQBrokerAccessCredentials) *PipeSourceActiveMQBrokerParameters {
	s.Credentials = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *PipeSourceActiveMQBrokerParameters) SetMaximumBatchingWindowInSeconds(v int64) *PipeSourceActiveMQBrokerParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetQueueName sets the QueueName field's value.
func (s *PipeSourceActiveMQBrokerParameters) SetQueueName(v string) *PipeSourceActiveMQBrokerParameters {
	s.QueueName = &v
	return s
}

// The parameters for using a DynamoDB stream as a source.
type PipeSourceDynamoDBStreamParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// Define the target queue to send dead-letter queue events to.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams only) Discard records older than the specified age. The default
	// value is -1, which sets the maximum age to infinite. When the value is set
	// to infinite, EventBridge never discards old records.
	MaximumRecordAgeInSeconds *int64 `type:"integer"`

	// (Streams only) Discard records after the specified number of retries. The
	// default value is -1, which sets the maximum number of retries to infinite.
	// When MaximumRetryAttempts is infinite, EventBridge retries failed records
	// until the record expires in the event source.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams only) Define how to handle item process failures. AUTOMATIC_BISECT
	// halves each batch and retry each half until all the records are processed
	// or there is one failed message left in the batch.
	OnPartialBatchItemFailure *string `type:"string" enum:"OnPartialBatchItemFailureStreams"`

	// (Streams only) The number of batches to process concurrently from each shard.
	// The default value is 1.
	ParallelizationFactor *int64 `min:"1" type:"integer"`

	// (Streams only) The position in a stream from which to start reading.
	//
	// StartingPosition is a required field
	StartingPosition *string `type:"string" required:"true" enum:"DynamoDBStreamStartPosition"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceDynamoDBStreamParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceDynamoDBStreamParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeSourceDynamoDBStreamParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeSourceDynamoDBStreamParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.MaximumRecordAgeInSeconds != nil && *s.MaximumRecordAgeInSeconds < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRecordAgeInSeconds", -1))
	}
	if s.MaximumRetryAttempts != nil && *s.MaximumRetryAttempts < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRetryAttempts", -1))
	}
	if s.ParallelizationFactor != nil && *s.ParallelizationFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelizationFactor", 1))
	}
	if s.StartingPosition == nil {
		invalidParams.Add(request.NewErrParamRequired("StartingPosition"))
	}
	if s.DeadLetterConfig != nil {
		if err := s.DeadLetterConfig.Validate(); err != nil {
			invalidParams.AddNested("DeadLetterConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *PipeSourceDynamoDBStreamParameters) SetBatchSize(v int64) *PipeSourceDynamoDBStreamParameters {
	s.BatchSize = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *PipeSourceDynamoDBStreamParameters) SetDeadLetterConfig(v *DeadLetterConfig) *PipeSourceDynamoDBStreamParameters {
	s.DeadLetterConfig = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *PipeSourceDynamoDBStreamParameters) SetMaximumBatchingWindowInSeconds(v int64) *PipeSourceDynamoDBStreamParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetMaximumRecordAgeInSeconds sets the MaximumRecordAgeInSeconds field's value.
func (s *PipeSourceDynamoDBStreamParameters) SetMaximumRecordAgeInSeconds(v int64) *PipeSourceDynamoDBStreamParameters {
	s.MaximumRecordAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *PipeSourceDynamoDBStreamParameters) SetMaximumRetryAttempts(v int64) *PipeSourceDynamoDBStreamParameters {
	s.MaximumRetryAttempts = &v
	return s
}

// SetOnPartialBatchItemFailure sets the OnPartialBatchItemFailure field's value.
func (s *PipeSourceDynamoDBStreamParameters) SetOnPartialBatchItemFailure(v string) *PipeSourceDynamoDBStreamParameters {
	s.OnPartialBatchItemFailure = &v
	return s
}

// SetParallelizationFactor sets the ParallelizationFactor field's value.
func (s *PipeSourceDynamoDBStreamParameters) SetParallelizationFactor(v int64) *PipeSourceDynamoDBStreamParameters {
	s.ParallelizationFactor = &v
	return s
}

// SetStartingPosition sets the StartingPosition field's value.
func (s *PipeSourceDynamoDBStreamParameters) SetStartingPosition(v string) *PipeSourceDynamoDBStreamParameters {
	s.StartingPosition = &v
	return s
}

// The parameters for using a Kinesis stream as a source.
type PipeSourceKinesisStreamParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// Define the target queue to send dead-letter queue events to.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams only) Discard records older than the specified age. The default
	// value is -1, which sets the maximum age to infinite. When the value is set
	// to infinite, EventBridge never discards old records.
	MaximumRecordAgeInSeconds *int64 `type:"integer"`

	// (Streams only) Discard records after the specified number of retries. The
	// default value is -1, which sets the maximum number of retries to infinite.
	// When MaximumRetryAttempts is infinite, EventBridge retries failed records
	// until the record expires in the event source.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams only) Define how to handle item process failures. AUTOMATIC_BISECT
	// halves each batch and retry each half until all the records are processed
	// or there is one failed message left in the batch.
	OnPartialBatchItemFailure *string `type:"string" enum:"OnPartialBatchItemFailureStreams"`

	// (Streams only) The number of batches to process concurrently from each shard.
	// The default value is 1.
	ParallelizationFactor *int64 `min:"1" type:"integer"`

	// (Streams only) The position in a stream from which to start reading.
	//
	// StartingPosition is a required field
	StartingPosition *string `type:"string" required:"true" enum:"KinesisStreamStartPosition"`

	// With StartingPosition set to AT_TIMESTAMP, the time from which to start reading,
	// in Unix time seconds.
	StartingPositionTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceKinesisStreamParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceKinesisStreamParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeSourceKinesisStreamParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeSourceKinesisStreamParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.MaximumRecordAgeInSeconds != nil && *s.MaximumRecordAgeInSeconds < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRecordAgeInSeconds", -1))
	}
	if s.MaximumRetryAttempts != nil && *s.MaximumRetryAttempts < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRetryAttempts", -1))
	}
	if s.ParallelizationFactor != nil && *s.ParallelizationFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelizationFactor", 1))
	}
	if s.StartingPosition == nil {
		invalidParams.Add(request.NewErrParamRequired("StartingPosition"))
	}
	if s.DeadLetterConfig != nil {
		if err := s.DeadLetterConfig.Validate(); err != nil {
			invalidParams.AddNested("DeadLetterConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *PipeSourceKinesisStreamParameters) SetBatchSize(v int64) *PipeSourceKinesisStreamParameters {
	s.BatchSize = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *PipeSourceKinesisStreamParameters) SetDeadLetterConfig(v *DeadLetterConfig) *PipeSourceKinesisStreamParameters {
	s.DeadLetterConfig = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *PipeSourceKinesisStreamParameters) SetMaximumBatchingWindowInSeconds(v int64) *PipeSourceKinesisStreamParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetMaximumRecordAgeInSeconds sets the MaximumRecordAgeInSeconds field's value.
func (s *PipeSourceKinesisStreamParameters) SetMaximumRecordAgeInSeconds(v int64) *PipeSourceKinesisStreamParameters {
	s.MaximumRecordAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *PipeSourceKinesisStreamParameters) SetMaximumRetryAttempts(v int64) *PipeSourceKinesisStreamParameters {
	s.MaximumRetryAttempts = &v
	return s
}

// SetOnPartialBatchItemFailure sets the OnPartialBatchItemFailure field's value.
func (s *PipeSourceKinesisStreamParameters) SetOnPartialBatchItemFailure(v string) *PipeSourceKinesisStreamParameters {
	s.OnPartialBatchItemFailure = &v
	return s
}

// SetParallelizationFactor sets the ParallelizationFactor field's value.
func (s *PipeSourceKinesisStreamParameters) SetParallelizationFactor(v int64) *PipeSourceKinesisStreamParameters {
	s.ParallelizationFactor = &v
	return s
}

// SetStartingPosition sets the StartingPosition field's value.
func (s *PipeSourceKinesisStreamParameters) SetStartingPosition(v string) *PipeSourceKinesisStreamParameters {
	s.StartingPosition = &v
	return s
}

// SetStartingPositionTimestamp sets the StartingPositionTimestamp field's value.
func (s *PipeSourceKinesisStreamParameters) SetStartingPositionTimestamp(v time.Time) *PipeSourceKinesisStreamParameters {
	s.StartingPositionTimestamp = &v
	return s
}

// The parameters for using an MSK stream as a source.
type PipeSourceManagedStreamingKafkaParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The name of the destination queue to consume.
	//
	// ConsumerGroupID is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeSourceManagedStreamingKafkaParameters's
	// String and GoString methods.
	ConsumerGroupID *string `min:"1" type:"string" sensitive:"true"`

	// The credentials needed to access the resource.
	Credentials *MSKAccessCredentials `type:"structure"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams only) The position in a stream from which to start reading.
	StartingPosition *string `type:"string" enum:"MSKStartPosition"`

	// The name of the topic that the pipe will read from.
	//
	// TopicName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeSourceManagedStreamingKafkaParameters's
	// String and GoString methods.
	//
	// TopicName is a required field
	TopicName *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceManagedStreamingKafkaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceManagedStreamingKafkaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeSourceManagedStreamingKafkaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeSourceManagedStreamingKafkaParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.ConsumerGroupID != nil && len(*s.ConsumerGroupID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerGroupID", 1))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicName", 1))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *PipeSourceManagedStreamingKafkaParameters) SetBatchSize(v int64) *PipeSourceManagedStreamingKafkaParameters {
	s.BatchSize = &v
	return s
}

// SetConsumerGroupID sets the ConsumerGroupID field's value.
func (s *PipeSourceManagedStreamingKafkaParameters) SetConsumerGroupID(v string) *PipeSourceManagedStreamingKafkaParameters {
	s.ConsumerGroupID = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *PipeSourceManagedStreamingKafkaParameters) SetCredentials(v *MSKAccessCredentials) *PipeSourceManagedStreamingKafkaParameters {
	s.Credentials = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *PipeSourceManagedStreamingKafkaParameters) SetMaximumBatchingWindowInSeconds(v int64) *PipeSourceManagedStreamingKafkaParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetStartingPosition sets the StartingPosition field's value.
func (s *PipeSourceManagedStreamingKafkaParameters) SetStartingPosition(v string) *PipeSourceManagedStreamingKafkaParameters {
	s.StartingPosition = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *PipeSourceManagedStreamingKafkaParameters) SetTopicName(v string) *PipeSourceManagedStreamingKafkaParameters {
	s.TopicName = &v
	return s
}

// The parameters required to set up a source for your pipe.
type PipeSourceParameters struct {
	_ struct{} `type:"structure"`

	// The parameters for using an Active MQ broker as a source.
	ActiveMQBrokerParameters *PipeSourceActiveMQBrokerParameters `type:"structure"`

	// The parameters for using a DynamoDB stream as a source.
	DynamoDBStreamParameters *PipeSourceDynamoDBStreamParameters `type:"structure"`

	// The collection of event patterns used to filter events.
	//
	// To remove a filter, specify a FilterCriteria object with an empty array of
	// Filter objects.
	//
	// For more information, see Events and Event Patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
	// in the Amazon EventBridge User Guide.
	FilterCriteria *FilterCriteria `type:"structure"`

	// The parameters for using a Kinesis stream as a source.
	KinesisStreamParameters *PipeSourceKinesisStreamParameters `type:"structure"`

	// The parameters for using an MSK stream as a source.
	ManagedStreamingKafkaParameters *PipeSourceManagedStreamingKafkaParameters `type:"structure"`

	// The parameters for using a Rabbit MQ broker as a source.
	RabbitMQBrokerParameters *PipeSourceRabbitMQBrokerParameters `type:"structure"`

	// The parameters for using a self-managed Apache Kafka stream as a source.
	//
	// A self managed cluster refers to any Apache Kafka cluster not hosted by Amazon
	// Web Services. This includes both clusters you manage yourself, as well as
	// those hosted by a third-party provider, such as Confluent Cloud (https://www.confluent.io/),
	// CloudKarafka (https://www.cloudkarafka.com/), or Redpanda (https://redpanda.com/).
	// For more information, see Apache Kafka streams as a source (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html)
	// in the Amazon EventBridge User Guide.
	SelfManagedKafkaParameters *PipeSourceSelfManagedKafkaParameters `type:"structure"`

	// The parameters for using a Amazon SQS stream as a source.
	SqsQueueParameters *PipeSourceSqsQueueParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeSourceParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeSourceParameters"}
	if s.ActiveMQBrokerParameters != nil {
		if err := s.ActiveMQBrokerParameters.Validate(); err != nil {
			invalidParams.AddNested("ActiveMQBrokerParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamoDBStreamParameters != nil {
		if err := s.DynamoDBStreamParameters.Validate(); err != nil {
			invalidParams.AddNested("DynamoDBStreamParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamParameters != nil {
		if err := s.KinesisStreamParameters.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.ManagedStreamingKafkaParameters != nil {
		if err := s.ManagedStreamingKafkaParameters.Validate(); err != nil {
			invalidParams.AddNested("ManagedStreamingKafkaParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RabbitMQBrokerParameters != nil {
		if err := s.RabbitMQBrokerParameters.Validate(); err != nil {
			invalidParams.AddNested("RabbitMQBrokerParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SelfManagedKafkaParameters != nil {
		if err := s.SelfManagedKafkaParameters.Validate(); err != nil {
			invalidParams.AddNested("SelfManagedKafkaParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SqsQueueParameters != nil {
		if err := s.SqsQueueParameters.Validate(); err != nil {
			invalidParams.AddNested("SqsQueueParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActiveMQBrokerParameters sets the ActiveMQBrokerParameters field's value.
func (s *PipeSourceParameters) SetActiveMQBrokerParameters(v *PipeSourceActiveMQBrokerParameters) *PipeSourceParameters {
	s.ActiveMQBrokerParameters = v
	return s
}

// SetDynamoDBStreamParameters sets the DynamoDBStreamParameters field's value.
func (s *PipeSourceParameters) SetDynamoDBStreamParameters(v *PipeSourceDynamoDBStreamParameters) *PipeSourceParameters {
	s.DynamoDBStreamParameters = v
	return s
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *PipeSourceParameters) SetFilterCriteria(v *FilterCriteria) *PipeSourceParameters {
	s.FilterCriteria = v
	return s
}

// SetKinesisStreamParameters sets the KinesisStreamParameters field's value.
func (s *PipeSourceParameters) SetKinesisStreamParameters(v *PipeSourceKinesisStreamParameters) *PipeSourceParameters {
	s.KinesisStreamParameters = v
	return s
}

// SetManagedStreamingKafkaParameters sets the ManagedStreamingKafkaParameters field's value.
func (s *PipeSourceParameters) SetManagedStreamingKafkaParameters(v *PipeSourceManagedStreamingKafkaParameters) *PipeSourceParameters {
	s.ManagedStreamingKafkaParameters = v
	return s
}

// SetRabbitMQBrokerParameters sets the RabbitMQBrokerParameters field's value.
func (s *PipeSourceParameters) SetRabbitMQBrokerParameters(v *PipeSourceRabbitMQBrokerParameters) *PipeSourceParameters {
	s.RabbitMQBrokerParameters = v
	return s
}

// SetSelfManagedKafkaParameters sets the SelfManagedKafkaParameters field's value.
func (s *PipeSourceParameters) SetSelfManagedKafkaParameters(v *PipeSourceSelfManagedKafkaParameters) *PipeSourceParameters {
	s.SelfManagedKafkaParameters = v
	return s
}

// SetSqsQueueParameters sets the SqsQueueParameters field's value.
func (s *PipeSourceParameters) SetSqsQueueParameters(v *PipeSourceSqsQueueParameters) *PipeSourceParameters {
	s.SqsQueueParameters = v
	return s
}

// The parameters for using a Rabbit MQ broker as a source.
type PipeSourceRabbitMQBrokerParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The credentials needed to access the resource.
	//
	// Credentials is a required field
	Credentials *MQBrokerAccessCredentials `type:"structure" required:"true"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// The name of the destination queue to consume.
	//
	// QueueName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeSourceRabbitMQBrokerParameters's
	// String and GoString methods.
	//
	// QueueName is a required field
	QueueName *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The name of the virtual host associated with the source broker.
	//
	// VirtualHost is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeSourceRabbitMQBrokerParameters's
	// String and GoString methods.
	VirtualHost *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceRabbitMQBrokerParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceRabbitMQBrokerParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeSourceRabbitMQBrokerParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeSourceRabbitMQBrokerParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.Credentials == nil {
		invalidParams.Add(request.NewErrParamRequired("Credentials"))
	}
	if s.QueueName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueName"))
	}
	if s.QueueName != nil && len(*s.QueueName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueName", 1))
	}
	if s.VirtualHost != nil && len(*s.VirtualHost) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VirtualHost", 1))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *PipeSourceRabbitMQBrokerParameters) SetBatchSize(v int64) *PipeSourceRabbitMQBrokerParameters {
	s.BatchSize = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *PipeSourceRabbitMQBrokerParameters) SetCredentials(v *MQBrokerAccessCredentials) *PipeSourceRabbitMQBrokerParameters {
	s.Credentials = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *PipeSourceRabbitMQBrokerParameters) SetMaximumBatchingWindowInSeconds(v int64) *PipeSourceRabbitMQBrokerParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetQueueName sets the QueueName field's value.
func (s *PipeSourceRabbitMQBrokerParameters) SetQueueName(v string) *PipeSourceRabbitMQBrokerParameters {
	s.QueueName = &v
	return s
}

// SetVirtualHost sets the VirtualHost field's value.
func (s *PipeSourceRabbitMQBrokerParameters) SetVirtualHost(v string) *PipeSourceRabbitMQBrokerParameters {
	s.VirtualHost = &v
	return s
}

// The parameters for using a self-managed Apache Kafka stream as a source.
//
// A self managed cluster refers to any Apache Kafka cluster not hosted by Amazon
// Web Services. This includes both clusters you manage yourself, as well as
// those hosted by a third-party provider, such as Confluent Cloud (https://www.confluent.io/),
// CloudKarafka (https://www.cloudkarafka.com/), or Redpanda (https://redpanda.com/).
// For more information, see Apache Kafka streams as a source (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html)
// in the Amazon EventBridge User Guide.
type PipeSourceSelfManagedKafkaParameters struct {
	_ struct{} `type:"structure"`

	// An array of server URLs.
	AdditionalBootstrapServers []*string `type:"list"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The name of the destination queue to consume.
	//
	// ConsumerGroupID is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeSourceSelfManagedKafkaParameters's
	// String and GoString methods.
	ConsumerGroupID *string `min:"1" type:"string" sensitive:"true"`

	// The credentials needed to access the resource.
	Credentials *SelfManagedKafkaAccessConfigurationCredentials `type:"structure"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// The ARN of the Secrets Manager secret used for certification.
	ServerRootCaCertificate *string `min:"1" type:"string"`

	// (Streams only) The position in a stream from which to start reading.
	StartingPosition *string `type:"string" enum:"SelfManagedKafkaStartPosition"`

	// The name of the topic that the pipe will read from.
	//
	// TopicName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeSourceSelfManagedKafkaParameters's
	// String and GoString methods.
	//
	// TopicName is a required field
	TopicName *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// This structure specifies the VPC subnets and security groups for the stream,
	// and whether a public IP address is to be used.
	Vpc *SelfManagedKafkaAccessConfigurationVpc `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceSelfManagedKafkaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceSelfManagedKafkaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeSourceSelfManagedKafkaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeSourceSelfManagedKafkaParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.ConsumerGroupID != nil && len(*s.ConsumerGroupID) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConsumerGroupID", 1))
	}
	if s.ServerRootCaCertificate != nil && len(*s.ServerRootCaCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerRootCaCertificate", 1))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}
	if s.TopicName != nil && len(*s.TopicName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TopicName", 1))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalBootstrapServers sets the AdditionalBootstrapServers field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetAdditionalBootstrapServers(v []*string) *PipeSourceSelfManagedKafkaParameters {
	s.AdditionalBootstrapServers = v
	return s
}

// SetBatchSize sets the BatchSize field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetBatchSize(v int64) *PipeSourceSelfManagedKafkaParameters {
	s.BatchSize = &v
	return s
}

// SetConsumerGroupID sets the ConsumerGroupID field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetConsumerGroupID(v string) *PipeSourceSelfManagedKafkaParameters {
	s.ConsumerGroupID = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetCredentials(v *SelfManagedKafkaAccessConfigurationCredentials) *PipeSourceSelfManagedKafkaParameters {
	s.Credentials = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetMaximumBatchingWindowInSeconds(v int64) *PipeSourceSelfManagedKafkaParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetServerRootCaCertificate sets the ServerRootCaCertificate field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetServerRootCaCertificate(v string) *PipeSourceSelfManagedKafkaParameters {
	s.ServerRootCaCertificate = &v
	return s
}

// SetStartingPosition sets the StartingPosition field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetStartingPosition(v string) *PipeSourceSelfManagedKafkaParameters {
	s.StartingPosition = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetTopicName(v string) *PipeSourceSelfManagedKafkaParameters {
	s.TopicName = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *PipeSourceSelfManagedKafkaParameters) SetVpc(v *SelfManagedKafkaAccessConfigurationVpc) *PipeSourceSelfManagedKafkaParameters {
	s.Vpc = v
	return s
}

// The parameters for using a Amazon SQS stream as a source.
type PipeSourceSqsQueueParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceSqsQueueParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeSourceSqsQueueParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeSourceSqsQueueParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeSourceSqsQueueParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *PipeSourceSqsQueueParameters) SetBatchSize(v int64) *PipeSourceSqsQueueParameters {
	s.BatchSize = &v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *PipeSourceSqsQueueParameters) SetMaximumBatchingWindowInSeconds(v int64) *PipeSourceSqsQueueParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// The parameters for using an Batch job as a target.
type PipeTargetBatchJobParameters struct {
	_ struct{} `type:"structure"`

	// The array properties for the submitted job, such as the size of the array.
	// The array size can be between 2 and 10,000. If you specify array properties
	// for a job, it becomes an array job. This parameter is used only if the target
	// is an Batch job.
	ArrayProperties *BatchArrayProperties `type:"structure"`

	// The overrides that are sent to a container.
	ContainerOverrides *BatchContainerOverrides `type:"structure"`

	// A list of dependencies for the job. A job can depend upon a maximum of 20
	// jobs. You can specify a SEQUENTIAL type dependency without specifying a job
	// ID for array jobs so that each child array job completes sequentially, starting
	// at index 0. You can also specify an N_TO_N type dependency with a job ID
	// for array jobs. In that case, each index child of this job must wait for
	// the corresponding index child of each dependency to complete before it can
	// begin.
	DependsOn []*BatchJobDependency `type:"list"`

	// The job definition used by this job. This value can be one of name, name:revision,
	// or the Amazon Resource Name (ARN) for the job definition. If name is specified
	// without a revision then the latest active revision is used.
	//
	// JobDefinition is a required field
	JobDefinition *string `type:"string" required:"true"`

	// The name of the job. It can be up to 128 letters long. The first character
	// must be alphanumeric, can contain uppercase and lowercase letters, numbers,
	// hyphens (-), and underscores (_).
	//
	// JobName is a required field
	JobName *string `type:"string" required:"true"`

	// Additional parameters passed to the job that replace parameter substitution
	// placeholders that are set in the job definition. Parameters are specified
	// as a key and value pair mapping. Parameters included here override any corresponding
	// parameter defaults from the job definition.
	Parameters map[string]*string `type:"map"`

	// The retry strategy to use for failed jobs. When a retry strategy is specified
	// here, it overrides the retry strategy defined in the job definition.
	RetryStrategy *BatchRetryStrategy `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetBatchJobParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetBatchJobParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetBatchJobParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetBatchJobParameters"}
	if s.JobDefinition == nil {
		invalidParams.Add(request.NewErrParamRequired("JobDefinition"))
	}
	if s.JobName == nil {
		invalidParams.Add(request.NewErrParamRequired("JobName"))
	}
	if s.ArrayProperties != nil {
		if err := s.ArrayProperties.Validate(); err != nil {
			invalidParams.AddNested("ArrayProperties", err.(request.ErrInvalidParams))
		}
	}
	if s.ContainerOverrides != nil {
		if err := s.ContainerOverrides.Validate(); err != nil {
			invalidParams.AddNested("ContainerOverrides", err.(request.ErrInvalidParams))
		}
	}
	if s.RetryStrategy != nil {
		if err := s.RetryStrategy.Validate(); err != nil {
			invalidParams.AddNested("RetryStrategy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArrayProperties sets the ArrayProperties field's value.
func (s *PipeTargetBatchJobParameters) SetArrayProperties(v *BatchArrayProperties) *PipeTargetBatchJobParameters {
	s.ArrayProperties = v
	return s
}

// SetContainerOverrides sets the ContainerOverrides field's value.
func (s *PipeTargetBatchJobParameters) SetContainerOverrides(v *BatchContainerOverrides) *PipeTargetBatchJobParameters {
	s.ContainerOverrides = v
	return s
}

// SetDependsOn sets the DependsOn field's value.
func (s *PipeTargetBatchJobParameters) SetDependsOn(v []*BatchJobDependency) *PipeTargetBatchJobParameters {
	s.DependsOn = v
	return s
}

// SetJobDefinition sets the JobDefinition field's value.
func (s *PipeTargetBatchJobParameters) SetJobDefinition(v string) *PipeTargetBatchJobParameters {
	s.JobDefinition = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *PipeTargetBatchJobParameters) SetJobName(v string) *PipeTargetBatchJobParameters {
	s.JobName = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PipeTargetBatchJobParameters) SetParameters(v map[string]*string) *PipeTargetBatchJobParameters {
	s.Parameters = v
	return s
}

// SetRetryStrategy sets the RetryStrategy field's value.
func (s *PipeTargetBatchJobParameters) SetRetryStrategy(v *BatchRetryStrategy) *PipeTargetBatchJobParameters {
	s.RetryStrategy = v
	return s
}

// The parameters for using an CloudWatch Logs log stream as a target.
type PipeTargetCloudWatchLogsParameters struct {
	_ struct{} `type:"structure"`

	// The name of the log stream.
	LogStreamName *string `min:"1" type:"string"`

	// The time the event occurred, expressed as the number of milliseconds after
	// Jan 1, 1970 00:00:00 UTC.
	Timestamp *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetCloudWatchLogsParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetCloudWatchLogsParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetCloudWatchLogsParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetCloudWatchLogsParameters"}
	if s.LogStreamName != nil && len(*s.LogStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogStreamName", 1))
	}
	if s.Timestamp != nil && len(*s.Timestamp) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Timestamp", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *PipeTargetCloudWatchLogsParameters) SetLogStreamName(v string) *PipeTargetCloudWatchLogsParameters {
	s.LogStreamName = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *PipeTargetCloudWatchLogsParameters) SetTimestamp(v string) *PipeTargetCloudWatchLogsParameters {
	s.Timestamp = &v
	return s
}

// The parameters for using an Amazon ECS task as a target.
type PipeTargetEcsTaskParameters struct {
	_ struct{} `type:"structure"`

	// The capacity provider strategy to use for the task.
	//
	// If a capacityProviderStrategy is specified, the launchType parameter must
	// be omitted. If no capacityProviderStrategy or launchType is specified, the
	// defaultCapacityProviderStrategy for the cluster is used.
	CapacityProviderStrategy []*CapacityProviderStrategyItem `type:"list"`

	// Specifies whether to enable Amazon ECS managed tags for the task. For more
	// information, see Tagging Your Amazon ECS Resources (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html)
	// in the Amazon Elastic Container Service Developer Guide.
	EnableECSManagedTags *bool `type:"boolean"`

	// Whether or not to enable the execute command functionality for the containers
	// in this task. If true, this enables execute command functionality on all
	// containers in the task.
	EnableExecuteCommand *bool `type:"boolean"`

	// Specifies an Amazon ECS task group for the task. The maximum length is 255
	// characters.
	Group *string `type:"string"`

	// Specifies the launch type on which your task is running. The launch type
	// that you specify here must match one of the launch type (compatibilities)
	// of the target task. The FARGATE value is supported only in the Regions where
	// Fargate with Amazon ECS is supported. For more information, see Fargate on
	// Amazon ECS (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/AWS-Fargate.html)
	// in the Amazon Elastic Container Service Developer Guide.
	LaunchType *string `type:"string" enum:"LaunchType"`

	// Use this structure if the Amazon ECS task uses the awsvpc network mode. This
	// structure specifies the VPC subnets and security groups associated with the
	// task, and whether a public IP address is to be used. This structure is required
	// if LaunchType is FARGATE because the awsvpc mode is required for Fargate
	// tasks.
	//
	// If you specify NetworkConfiguration when the target ECS task does not use
	// the awsvpc network mode, the task fails.
	NetworkConfiguration *NetworkConfiguration `type:"structure"`

	// The overrides that are associated with a task.
	Overrides *EcsTaskOverride `type:"structure"`

	// An array of placement constraint objects to use for the task. You can specify
	// up to 10 constraints per task (including constraints in the task definition
	// and those specified at runtime).
	PlacementConstraints []*PlacementConstraint `type:"list"`

	// The placement strategy objects to use for the task. You can specify a maximum
	// of five strategy rules per task.
	PlacementStrategy []*PlacementStrategy `type:"list"`

	// Specifies the platform version for the task. Specify only the numeric portion
	// of the platform version, such as 1.1.0.
	//
	// This structure is used only if LaunchType is FARGATE. For more information
	// about valid platform versions, see Fargate Platform Versions (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html)
	// in the Amazon Elastic Container Service Developer Guide.
	PlatformVersion *string `type:"string"`

	// Specifies whether to propagate the tags from the task definition to the task.
	// If no value is specified, the tags are not propagated. Tags can only be propagated
	// to the task during task creation. To add tags to a task after task creation,
	// use the TagResource API action.
	PropagateTags *string `type:"string" enum:"PropagateTags"`

	// The reference ID to use for the task.
	//
	// ReferenceId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetEcsTaskParameters's
	// String and GoString methods.
	ReferenceId *string `type:"string" sensitive:"true"`

	// The metadata that you apply to the task to help you categorize and organize
	// them. Each tag consists of a key and an optional value, both of which you
	// define. To learn more, see RunTask (https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html#ECS-RunTask-request-tags)
	// in the Amazon ECS API Reference.
	Tags []*Tag `type:"list"`

	// The number of tasks to create based on TaskDefinition. The default is 1.
	TaskCount *int64 `min:"1" type:"integer"`

	// The ARN of the task definition to use if the event target is an Amazon ECS
	// task.
	//
	// TaskDefinitionArn is a required field
	TaskDefinitionArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetEcsTaskParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetEcsTaskParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetEcsTaskParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetEcsTaskParameters"}
	if s.TaskCount != nil && *s.TaskCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("TaskCount", 1))
	}
	if s.TaskDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskDefinitionArn"))
	}
	if s.TaskDefinitionArn != nil && len(*s.TaskDefinitionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TaskDefinitionArn", 1))
	}
	if s.CapacityProviderStrategy != nil {
		for i, v := range s.CapacityProviderStrategy {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CapacityProviderStrategy", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.NetworkConfiguration != nil {
		if err := s.NetworkConfiguration.Validate(); err != nil {
			invalidParams.AddNested("NetworkConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Overrides != nil {
		if err := s.Overrides.Validate(); err != nil {
			invalidParams.AddNested("Overrides", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityProviderStrategy sets the CapacityProviderStrategy field's value.
func (s *PipeTargetEcsTaskParameters) SetCapacityProviderStrategy(v []*CapacityProviderStrategyItem) *PipeTargetEcsTaskParameters {
	s.CapacityProviderStrategy = v
	return s
}

// SetEnableECSManagedTags sets the EnableECSManagedTags field's value.
func (s *PipeTargetEcsTaskParameters) SetEnableECSManagedTags(v bool) *PipeTargetEcsTaskParameters {
	s.EnableECSManagedTags = &v
	return s
}

// SetEnableExecuteCommand sets the EnableExecuteCommand field's value.
func (s *PipeTargetEcsTaskParameters) SetEnableExecuteCommand(v bool) *PipeTargetEcsTaskParameters {
	s.EnableExecuteCommand = &v
	return s
}

// SetGroup sets the Group field's value.
func (s *PipeTargetEcsTaskParameters) SetGroup(v string) *PipeTargetEcsTaskParameters {
	s.Group = &v
	return s
}

// SetLaunchType sets the LaunchType field's value.
func (s *PipeTargetEcsTaskParameters) SetLaunchType(v string) *PipeTargetEcsTaskParameters {
	s.LaunchType = &v
	return s
}

// SetNetworkConfiguration sets the NetworkConfiguration field's value.
func (s *PipeTargetEcsTaskParameters) SetNetworkConfiguration(v *NetworkConfiguration) *PipeTargetEcsTaskParameters {
	s.NetworkConfiguration = v
	return s
}

// SetOverrides sets the Overrides field's value.
func (s *PipeTargetEcsTaskParameters) SetOverrides(v *EcsTaskOverride) *PipeTargetEcsTaskParameters {
	s.Overrides = v
	return s
}

// SetPlacementConstraints sets the PlacementConstraints field's value.
func (s *PipeTargetEcsTaskParameters) SetPlacementConstraints(v []*PlacementConstraint) *PipeTargetEcsTaskParameters {
	s.PlacementConstraints = v
	return s
}

// SetPlacementStrategy sets the PlacementStrategy field's value.
func (s *PipeTargetEcsTaskParameters) SetPlacementStrategy(v []*PlacementStrategy) *PipeTargetEcsTaskParameters {
	s.PlacementStrategy = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *PipeTargetEcsTaskParameters) SetPlatformVersion(v string) *PipeTargetEcsTaskParameters {
	s.PlatformVersion = &v
	return s
}

// SetPropagateTags sets the PropagateTags field's value.
func (s *PipeTargetEcsTaskParameters) SetPropagateTags(v string) *PipeTargetEcsTaskParameters {
	s.PropagateTags = &v
	return s
}

// SetReferenceId sets the ReferenceId field's value.
func (s *PipeTargetEcsTaskParameters) SetReferenceId(v string) *PipeTargetEcsTaskParameters {
	s.ReferenceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PipeTargetEcsTaskParameters) SetTags(v []*Tag) *PipeTargetEcsTaskParameters {
	s.Tags = v
	return s
}

// SetTaskCount sets the TaskCount field's value.
func (s *PipeTargetEcsTaskParameters) SetTaskCount(v int64) *PipeTargetEcsTaskParameters {
	s.TaskCount = &v
	return s
}

// SetTaskDefinitionArn sets the TaskDefinitionArn field's value.
func (s *PipeTargetEcsTaskParameters) SetTaskDefinitionArn(v string) *PipeTargetEcsTaskParameters {
	s.TaskDefinitionArn = &v
	return s
}

// The parameters for using an EventBridge event bus as a target.
type PipeTargetEventBridgeEventBusParameters struct {
	_ struct{} `type:"structure"`

	// A free-form string, with a maximum of 128 characters, used to decide what
	// fields to expect in the event detail.
	//
	// DetailType is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetEventBridgeEventBusParameters's
	// String and GoString methods.
	DetailType *string `min:"1" type:"string" sensitive:"true"`

	// The URL subdomain of the endpoint. For example, if the URL for Endpoint is
	// https://abcde.veo.endpoints.event.amazonaws.com, then the EndpointId is abcde.veo.
	//
	// EndpointId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetEventBridgeEventBusParameters's
	// String and GoString methods.
	EndpointId *string `min:"1" type:"string" sensitive:"true"`

	// Amazon Web Services resources, identified by Amazon Resource Name (ARN),
	// which the event primarily concerns. Any number, including zero, may be present.
	Resources []*string `type:"list"`

	// The source of the event.
	//
	// Source is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetEventBridgeEventBusParameters's
	// String and GoString methods.
	Source *string `min:"1" type:"string" sensitive:"true"`

	// The time stamp of the event, per RFC3339 (https://www.rfc-editor.org/rfc/rfc3339.txt).
	// If no time stamp is provided, the time stamp of the PutEvents (https://docs.aws.amazon.com/eventbridge/latest/APIReference/API_PutEvents.html)
	// call is used.
	Time *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetEventBridgeEventBusParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetEventBridgeEventBusParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetEventBridgeEventBusParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetEventBridgeEventBusParameters"}
	if s.DetailType != nil && len(*s.DetailType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DetailType", 1))
	}
	if s.EndpointId != nil && len(*s.EndpointId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EndpointId", 1))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}
	if s.Time != nil && len(*s.Time) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Time", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDetailType sets the DetailType field's value.
func (s *PipeTargetEventBridgeEventBusParameters) SetDetailType(v string) *PipeTargetEventBridgeEventBusParameters {
	s.DetailType = &v
	return s
}

// SetEndpointId sets the EndpointId field's value.
func (s *PipeTargetEventBridgeEventBusParameters) SetEndpointId(v string) *PipeTargetEventBridgeEventBusParameters {
	s.EndpointId = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *PipeTargetEventBridgeEventBusParameters) SetResources(v []*string) *PipeTargetEventBridgeEventBusParameters {
	s.Resources = v
	return s
}

// SetSource sets the Source field's value.
func (s *PipeTargetEventBridgeEventBusParameters) SetSource(v string) *PipeTargetEventBridgeEventBusParameters {
	s.Source = &v
	return s
}

// SetTime sets the Time field's value.
func (s *PipeTargetEventBridgeEventBusParameters) SetTime(v string) *PipeTargetEventBridgeEventBusParameters {
	s.Time = &v
	return s
}

// These are custom parameter to be used when the target is an API Gateway REST
// APIs or EventBridge ApiDestinations.
type PipeTargetHttpParameters struct {
	_ struct{} `type:"structure"`

	// The headers that need to be sent as part of request invoking the API Gateway
	// REST API or EventBridge ApiDestination.
	HeaderParameters map[string]*string `type:"map"`

	// The path parameter values to be used to populate API Gateway REST API or
	// EventBridge ApiDestination path wildcards ("*").
	PathParameterValues []*string `type:"list"`

	// The query string keys/values that need to be sent as part of request invoking
	// the API Gateway REST API or EventBridge ApiDestination.
	QueryStringParameters map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetHttpParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetHttpParameters) GoString() string {
	return s.String()
}

// SetHeaderParameters sets the HeaderParameters field's value.
func (s *PipeTargetHttpParameters) SetHeaderParameters(v map[string]*string) *PipeTargetHttpParameters {
	s.HeaderParameters = v
	return s
}

// SetPathParameterValues sets the PathParameterValues field's value.
func (s *PipeTargetHttpParameters) SetPathParameterValues(v []*string) *PipeTargetHttpParameters {
	s.PathParameterValues = v
	return s
}

// SetQueryStringParameters sets the QueryStringParameters field's value.
func (s *PipeTargetHttpParameters) SetQueryStringParameters(v map[string]*string) *PipeTargetHttpParameters {
	s.QueryStringParameters = v
	return s
}

// The parameters for using a Kinesis stream as a target.
type PipeTargetKinesisStreamParameters struct {
	_ struct{} `type:"structure"`

	// Determines which shard in the stream the data record is assigned to. Partition
	// keys are Unicode strings with a maximum length limit of 256 characters for
	// each key. Amazon Kinesis Data Streams uses the partition key as input to
	// a hash function that maps the partition key and associated data to a specific
	// shard. Specifically, an MD5 hash function is used to map partition keys to
	// 128-bit integer values and to map associated data records to shards. As a
	// result of this hashing mechanism, all data records with the same partition
	// key map to the same shard within the stream.
	//
	// PartitionKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetKinesisStreamParameters's
	// String and GoString methods.
	//
	// PartitionKey is a required field
	PartitionKey *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetKinesisStreamParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetKinesisStreamParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetKinesisStreamParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetKinesisStreamParameters"}
	if s.PartitionKey == nil {
		invalidParams.Add(request.NewErrParamRequired("PartitionKey"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPartitionKey sets the PartitionKey field's value.
func (s *PipeTargetKinesisStreamParameters) SetPartitionKey(v string) *PipeTargetKinesisStreamParameters {
	s.PartitionKey = &v
	return s
}

// The parameters for using a Lambda function as a target.
type PipeTargetLambdaFunctionParameters struct {
	_ struct{} `type:"structure"`

	// Specify whether to invoke the function synchronously or asynchronously.
	//
	//    * REQUEST_RESPONSE (default) - Invoke synchronously. This corresponds
	//    to the RequestResponse option in the InvocationType parameter for the
	//    Lambda Invoke (https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax)
	//    API.
	//
	//    * FIRE_AND_FORGET - Invoke asynchronously. This corresponds to the Event
	//    option in the InvocationType parameter for the Lambda Invoke (https://docs.aws.amazon.com/lambda/latest/dg/API_Invoke.html#API_Invoke_RequestSyntax)
	//    API.
	//
	// For more information, see Invocation types (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation)
	// in the Amazon EventBridge User Guide.
	InvocationType *string `type:"string" enum:"PipeTargetInvocationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetLambdaFunctionParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetLambdaFunctionParameters) GoString() string {
	return s.String()
}

// SetInvocationType sets the InvocationType field's value.
func (s *PipeTargetLambdaFunctionParameters) SetInvocationType(v string) *PipeTargetLambdaFunctionParameters {
	s.InvocationType = &v
	return s
}

// The parameters required to set up a target for your pipe.
//
// For more information about pipe target parameters, including how to use dynamic
// path parameters, see Target parameters (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html)
// in the Amazon EventBridge User Guide.
type PipeTargetParameters struct {
	_ struct{} `type:"structure"`

	// The parameters for using an Batch job as a target.
	BatchJobParameters *PipeTargetBatchJobParameters `type:"structure"`

	// The parameters for using an CloudWatch Logs log stream as a target.
	CloudWatchLogsParameters *PipeTargetCloudWatchLogsParameters `type:"structure"`

	// The parameters for using an Amazon ECS task as a target.
	EcsTaskParameters *PipeTargetEcsTaskParameters `type:"structure"`

	// The parameters for using an EventBridge event bus as a target.
	EventBridgeEventBusParameters *PipeTargetEventBridgeEventBusParameters `type:"structure"`

	// These are custom parameter to be used when the target is an API Gateway REST
	// APIs or EventBridge ApiDestinations.
	HttpParameters *PipeTargetHttpParameters `type:"structure"`

	// Valid JSON text passed to the target. In this case, nothing from the event
	// itself is passed to the target. For more information, see The JavaScript
	// Object Notation (JSON) Data Interchange Format (http://www.rfc-editor.org/rfc/rfc7159.txt).
	//
	// To remove an input template, specify an empty string.
	//
	// InputTemplate is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetParameters's
	// String and GoString methods.
	InputTemplate *string `type:"string" sensitive:"true"`

	// The parameters for using a Kinesis stream as a target.
	KinesisStreamParameters *PipeTargetKinesisStreamParameters `type:"structure"`

	// The parameters for using a Lambda function as a target.
	LambdaFunctionParameters *PipeTargetLambdaFunctionParameters `type:"structure"`

	// These are custom parameters to be used when the target is a Amazon Redshift
	// cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.
	RedshiftDataParameters *PipeTargetRedshiftDataParameters `type:"structure"`

	// The parameters for using a SageMaker pipeline as a target.
	SageMakerPipelineParameters *PipeTargetSageMakerPipelineParameters `type:"structure"`

	// The parameters for using a Amazon SQS stream as a target.
	SqsQueueParameters *PipeTargetSqsQueueParameters `type:"structure"`

	// The parameters for using a Step Functions state machine as a target.
	StepFunctionStateMachineParameters *PipeTargetStateMachineParameters `type:"structure"`

	// The parameters for using a Timestream for LiveAnalytics table as a target.
	TimestreamParameters *PipeTargetTimestreamParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetParameters"}
	if s.BatchJobParameters != nil {
		if err := s.BatchJobParameters.Validate(); err != nil {
			invalidParams.AddNested("BatchJobParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.CloudWatchLogsParameters != nil {
		if err := s.CloudWatchLogsParameters.Validate(); err != nil {
			invalidParams.AddNested("CloudWatchLogsParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.EcsTaskParameters != nil {
		if err := s.EcsTaskParameters.Validate(); err != nil {
			invalidParams.AddNested("EcsTaskParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.EventBridgeEventBusParameters != nil {
		if err := s.EventBridgeEventBusParameters.Validate(); err != nil {
			invalidParams.AddNested("EventBridgeEventBusParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamParameters != nil {
		if err := s.KinesisStreamParameters.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftDataParameters != nil {
		if err := s.RedshiftDataParameters.Validate(); err != nil {
			invalidParams.AddNested("RedshiftDataParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SageMakerPipelineParameters != nil {
		if err := s.SageMakerPipelineParameters.Validate(); err != nil {
			invalidParams.AddNested("SageMakerPipelineParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.TimestreamParameters != nil {
		if err := s.TimestreamParameters.Validate(); err != nil {
			invalidParams.AddNested("TimestreamParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchJobParameters sets the BatchJobParameters field's value.
func (s *PipeTargetParameters) SetBatchJobParameters(v *PipeTargetBatchJobParameters) *PipeTargetParameters {
	s.BatchJobParameters = v
	return s
}

// SetCloudWatchLogsParameters sets the CloudWatchLogsParameters field's value.
func (s *PipeTargetParameters) SetCloudWatchLogsParameters(v *PipeTargetCloudWatchLogsParameters) *PipeTargetParameters {
	s.CloudWatchLogsParameters = v
	return s
}

// SetEcsTaskParameters sets the EcsTaskParameters field's value.
func (s *PipeTargetParameters) SetEcsTaskParameters(v *PipeTargetEcsTaskParameters) *PipeTargetParameters {
	s.EcsTaskParameters = v
	return s
}

// SetEventBridgeEventBusParameters sets the EventBridgeEventBusParameters field's value.
func (s *PipeTargetParameters) SetEventBridgeEventBusParameters(v *PipeTargetEventBridgeEventBusParameters) *PipeTargetParameters {
	s.EventBridgeEventBusParameters = v
	return s
}

// SetHttpParameters sets the HttpParameters field's value.
func (s *PipeTargetParameters) SetHttpParameters(v *PipeTargetHttpParameters) *PipeTargetParameters {
	s.HttpParameters = v
	return s
}

// SetInputTemplate sets the InputTemplate field's value.
func (s *PipeTargetParameters) SetInputTemplate(v string) *PipeTargetParameters {
	s.InputTemplate = &v
	return s
}

// SetKinesisStreamParameters sets the KinesisStreamParameters field's value.
func (s *PipeTargetParameters) SetKinesisStreamParameters(v *PipeTargetKinesisStreamParameters) *PipeTargetParameters {
	s.KinesisStreamParameters = v
	return s
}

// SetLambdaFunctionParameters sets the LambdaFunctionParameters field's value.
func (s *PipeTargetParameters) SetLambdaFunctionParameters(v *PipeTargetLambdaFunctionParameters) *PipeTargetParameters {
	s.LambdaFunctionParameters = v
	return s
}

// SetRedshiftDataParameters sets the RedshiftDataParameters field's value.
func (s *PipeTargetParameters) SetRedshiftDataParameters(v *PipeTargetRedshiftDataParameters) *PipeTargetParameters {
	s.RedshiftDataParameters = v
	return s
}

// SetSageMakerPipelineParameters sets the SageMakerPipelineParameters field's value.
func (s *PipeTargetParameters) SetSageMakerPipelineParameters(v *PipeTargetSageMakerPipelineParameters) *PipeTargetParameters {
	s.SageMakerPipelineParameters = v
	return s
}

// SetSqsQueueParameters sets the SqsQueueParameters field's value.
func (s *PipeTargetParameters) SetSqsQueueParameters(v *PipeTargetSqsQueueParameters) *PipeTargetParameters {
	s.SqsQueueParameters = v
	return s
}

// SetStepFunctionStateMachineParameters sets the StepFunctionStateMachineParameters field's value.
func (s *PipeTargetParameters) SetStepFunctionStateMachineParameters(v *PipeTargetStateMachineParameters) *PipeTargetParameters {
	s.StepFunctionStateMachineParameters = v
	return s
}

// SetTimestreamParameters sets the TimestreamParameters field's value.
func (s *PipeTargetParameters) SetTimestreamParameters(v *PipeTargetTimestreamParameters) *PipeTargetParameters {
	s.TimestreamParameters = v
	return s
}

// These are custom parameters to be used when the target is a Amazon Redshift
// cluster to invoke the Amazon Redshift Data API BatchExecuteStatement.
type PipeTargetRedshiftDataParameters struct {
	_ struct{} `type:"structure"`

	// The name of the database. Required when authenticating using temporary credentials.
	//
	// Database is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetRedshiftDataParameters's
	// String and GoString methods.
	//
	// Database is a required field
	Database *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The database user name. Required when authenticating using temporary credentials.
	//
	// DbUser is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetRedshiftDataParameters's
	// String and GoString methods.
	DbUser *string `min:"1" type:"string" sensitive:"true"`

	// The name or ARN of the secret that enables access to the database. Required
	// when authenticating using Secrets Manager.
	SecretManagerArn *string `min:"1" type:"string"`

	// The SQL statement text to run.
	//
	// Sqls is a required field
	Sqls []*string `min:"1" type:"list" required:"true"`

	// The name of the SQL statement. You can name the SQL statement when you create
	// it to identify the query.
	//
	// StatementName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetRedshiftDataParameters's
	// String and GoString methods.
	StatementName *string `min:"1" type:"string" sensitive:"true"`

	// Indicates whether to send an event back to EventBridge after the SQL statement
	// runs.
	WithEvent *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetRedshiftDataParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetRedshiftDataParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetRedshiftDataParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetRedshiftDataParameters"}
	if s.Database == nil {
		invalidParams.Add(request.NewErrParamRequired("Database"))
	}
	if s.Database != nil && len(*s.Database) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Database", 1))
	}
	if s.DbUser != nil && len(*s.DbUser) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DbUser", 1))
	}
	if s.SecretManagerArn != nil && len(*s.SecretManagerArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecretManagerArn", 1))
	}
	if s.Sqls == nil {
		invalidParams.Add(request.NewErrParamRequired("Sqls"))
	}
	if s.Sqls != nil && len(s.Sqls) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Sqls", 1))
	}
	if s.StatementName != nil && len(*s.StatementName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatementName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDatabase sets the Database field's value.
func (s *PipeTargetRedshiftDataParameters) SetDatabase(v string) *PipeTargetRedshiftDataParameters {
	s.Database = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *PipeTargetRedshiftDataParameters) SetDbUser(v string) *PipeTargetRedshiftDataParameters {
	s.DbUser = &v
	return s
}

// SetSecretManagerArn sets the SecretManagerArn field's value.
func (s *PipeTargetRedshiftDataParameters) SetSecretManagerArn(v string) *PipeTargetRedshiftDataParameters {
	s.SecretManagerArn = &v
	return s
}

// SetSqls sets the Sqls field's value.
func (s *PipeTargetRedshiftDataParameters) SetSqls(v []*string) *PipeTargetRedshiftDataParameters {
	s.Sqls = v
	return s
}

// SetStatementName sets the StatementName field's value.
func (s *PipeTargetRedshiftDataParameters) SetStatementName(v string) *PipeTargetRedshiftDataParameters {
	s.StatementName = &v
	return s
}

// SetWithEvent sets the WithEvent field's value.
func (s *PipeTargetRedshiftDataParameters) SetWithEvent(v bool) *PipeTargetRedshiftDataParameters {
	s.WithEvent = &v
	return s
}

// The parameters for using a SageMaker pipeline as a target.
type PipeTargetSageMakerPipelineParameters struct {
	_ struct{} `type:"structure"`

	// List of Parameter names and values for SageMaker Model Building Pipeline
	// execution.
	PipelineParameterList []*SageMakerPipelineParameter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetSageMakerPipelineParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetSageMakerPipelineParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetSageMakerPipelineParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetSageMakerPipelineParameters"}
	if s.PipelineParameterList != nil {
		for i, v := range s.PipelineParameterList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PipelineParameterList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPipelineParameterList sets the PipelineParameterList field's value.
func (s *PipeTargetSageMakerPipelineParameters) SetPipelineParameterList(v []*SageMakerPipelineParameter) *PipeTargetSageMakerPipelineParameters {
	s.PipelineParameterList = v
	return s
}

// The parameters for using a Amazon SQS stream as a target.
type PipeTargetSqsQueueParameters struct {
	_ struct{} `type:"structure"`

	// This parameter applies only to FIFO (first-in-first-out) queues.
	//
	// The token used for deduplication of sent messages.
	//
	// MessageDeduplicationId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetSqsQueueParameters's
	// String and GoString methods.
	MessageDeduplicationId *string `type:"string" sensitive:"true"`

	// The FIFO message group ID to use as the target.
	//
	// MessageGroupId is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PipeTargetSqsQueueParameters's
	// String and GoString methods.
	MessageGroupId *string `type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetSqsQueueParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetSqsQueueParameters) GoString() string {
	return s.String()
}

// SetMessageDeduplicationId sets the MessageDeduplicationId field's value.
func (s *PipeTargetSqsQueueParameters) SetMessageDeduplicationId(v string) *PipeTargetSqsQueueParameters {
	s.MessageDeduplicationId = &v
	return s
}

// SetMessageGroupId sets the MessageGroupId field's value.
func (s *PipeTargetSqsQueueParameters) SetMessageGroupId(v string) *PipeTargetSqsQueueParameters {
	s.MessageGroupId = &v
	return s
}

// The parameters for using a Step Functions state machine as a target.
type PipeTargetStateMachineParameters struct {
	_ struct{} `type:"structure"`

	// Specify whether to invoke the Step Functions state machine synchronously
	// or asynchronously.
	//
	//    * REQUEST_RESPONSE (default) - Invoke synchronously. For more information,
	//    see StartSyncExecution (https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartSyncExecution.html)
	//    in the Step Functions API Reference. REQUEST_RESPONSE is not supported
	//    for STANDARD state machine workflows.
	//
	//    * FIRE_AND_FORGET - Invoke asynchronously. For more information, see StartExecution
	//    (https://docs.aws.amazon.com/step-functions/latest/apireference/API_StartExecution.html)
	//    in the Step Functions API Reference.
	//
	// For more information, see Invocation types (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes.html#pipes-invocation)
	// in the Amazon EventBridge User Guide.
	InvocationType *string `type:"string" enum:"PipeTargetInvocationType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetStateMachineParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetStateMachineParameters) GoString() string {
	return s.String()
}

// SetInvocationType sets the InvocationType field's value.
func (s *PipeTargetStateMachineParameters) SetInvocationType(v string) *PipeTargetStateMachineParameters {
	s.InvocationType = &v
	return s
}

// The parameters for using a Timestream for LiveAnalytics table as a target.
type PipeTargetTimestreamParameters struct {
	_ struct{} `type:"structure"`

	// Map source data to dimensions in the target Timestream for LiveAnalytics
	// table.
	//
	// For more information, see Amazon Timestream for LiveAnalytics concepts (https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html)
	//
	// DimensionMappings is a required field
	DimensionMappings []*DimensionMapping `min:"1" type:"list" required:"true"`

	// The granularity of the time units used. Default is MILLISECONDS.
	//
	// Required if TimeFieldType is specified as EPOCH.
	EpochTimeUnit *string `type:"string" enum:"EpochTimeUnit"`

	// Maps multiple measures from the source event to the same record in the specified
	// Timestream for LiveAnalytics table.
	MultiMeasureMappings []*MultiMeasureMapping `type:"list"`

	// Mappings of single source data fields to individual records in the specified
	// Timestream for LiveAnalytics table.
	SingleMeasureMappings []*SingleMeasureMapping `type:"list"`

	// The type of time value used.
	//
	// The default is EPOCH.
	TimeFieldType *string `type:"string" enum:"TimeFieldType"`

	// Dynamic path to the source data field that represents the time value for
	// your data.
	//
	// TimeValue is a required field
	TimeValue *string `min:"1" type:"string" required:"true"`

	// How to format the timestamps. For example, YYYY-MM-DDThh:mm:ss.sssTZD.
	//
	// Required if TimeFieldType is specified as TIMESTAMP_FORMAT.
	TimestampFormat *string `min:"1" type:"string"`

	// 64 bit version value or source data field that represents the version value
	// for your data.
	//
	// Write requests with a higher version number will update the existing measure
	// values of the record and version. In cases where the measure value is the
	// same, the version will still be updated.
	//
	// Default value is 1.
	//
	// Timestream for LiveAnalytics does not support updating partial measure values
	// in a record.
	//
	// Write requests for duplicate data with a higher version number will update
	// the existing measure value and version. In cases where the measure value
	// is the same, Version will still be updated. Default value is 1.
	//
	// Version must be 1 or greater, or you will receive a ValidationException error.
	//
	// VersionValue is a required field
	VersionValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetTimestreamParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PipeTargetTimestreamParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PipeTargetTimestreamParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PipeTargetTimestreamParameters"}
	if s.DimensionMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("DimensionMappings"))
	}
	if s.DimensionMappings != nil && len(s.DimensionMappings) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DimensionMappings", 1))
	}
	if s.TimeValue == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeValue"))
	}
	if s.TimeValue != nil && len(*s.TimeValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimeValue", 1))
	}
	if s.TimestampFormat != nil && len(*s.TimestampFormat) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TimestampFormat", 1))
	}
	if s.VersionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("VersionValue"))
	}
	if s.VersionValue != nil && len(*s.VersionValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionValue", 1))
	}
	if s.DimensionMappings != nil {
		for i, v := range s.DimensionMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DimensionMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.MultiMeasureMappings != nil {
		for i, v := range s.MultiMeasureMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MultiMeasureMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SingleMeasureMappings != nil {
		for i, v := range s.SingleMeasureMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SingleMeasureMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDimensionMappings sets the DimensionMappings field's value.
func (s *PipeTargetTimestreamParameters) SetDimensionMappings(v []*DimensionMapping) *PipeTargetTimestreamParameters {
	s.DimensionMappings = v
	return s
}

// SetEpochTimeUnit sets the EpochTimeUnit field's value.
func (s *PipeTargetTimestreamParameters) SetEpochTimeUnit(v string) *PipeTargetTimestreamParameters {
	s.EpochTimeUnit = &v
	return s
}

// SetMultiMeasureMappings sets the MultiMeasureMappings field's value.
func (s *PipeTargetTimestreamParameters) SetMultiMeasureMappings(v []*MultiMeasureMapping) *PipeTargetTimestreamParameters {
	s.MultiMeasureMappings = v
	return s
}

// SetSingleMeasureMappings sets the SingleMeasureMappings field's value.
func (s *PipeTargetTimestreamParameters) SetSingleMeasureMappings(v []*SingleMeasureMapping) *PipeTargetTimestreamParameters {
	s.SingleMeasureMappings = v
	return s
}

// SetTimeFieldType sets the TimeFieldType field's value.
func (s *PipeTargetTimestreamParameters) SetTimeFieldType(v string) *PipeTargetTimestreamParameters {
	s.TimeFieldType = &v
	return s
}

// SetTimeValue sets the TimeValue field's value.
func (s *PipeTargetTimestreamParameters) SetTimeValue(v string) *PipeTargetTimestreamParameters {
	s.TimeValue = &v
	return s
}

// SetTimestampFormat sets the TimestampFormat field's value.
func (s *PipeTargetTimestreamParameters) SetTimestampFormat(v string) *PipeTargetTimestreamParameters {
	s.TimestampFormat = &v
	return s
}

// SetVersionValue sets the VersionValue field's value.
func (s *PipeTargetTimestreamParameters) SetVersionValue(v string) *PipeTargetTimestreamParameters {
	s.VersionValue = &v
	return s
}

// An object representing a constraint on task placement. To learn more, see
// Task Placement Constraints (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html)
// in the Amazon Elastic Container Service Developer Guide.
type PlacementConstraint struct {
	_ struct{} `type:"structure"`

	// A cluster query language expression to apply to the constraint. You cannot
	// specify an expression if the constraint type is distinctInstance. To learn
	// more, see Cluster Query Language (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html)
	// in the Amazon Elastic Container Service Developer Guide.
	//
	// Expression is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PlacementConstraint's
	// String and GoString methods.
	Expression *string `locationName:"expression" type:"string" sensitive:"true"`

	// The type of constraint. Use distinctInstance to ensure that each task in
	// a particular group is running on a different container instance. Use memberOf
	// to restrict the selection to a group of valid candidates.
	Type *string `locationName:"type" type:"string" enum:"PlacementConstraintType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementConstraint) GoString() string {
	return s.String()
}

// SetExpression sets the Expression field's value.
func (s *PlacementConstraint) SetExpression(v string) *PlacementConstraint {
	s.Expression = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlacementConstraint) SetType(v string) *PlacementConstraint {
	s.Type = &v
	return s
}

// The task placement strategy for a task or service. To learn more, see Task
// Placement Strategies (https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html)
// in the Amazon Elastic Container Service Service Developer Guide.
type PlacementStrategy struct {
	_ struct{} `type:"structure"`

	// The field to apply the placement strategy against. For the spread placement
	// strategy, valid values are instanceId (or host, which has the same effect),
	// or any platform or custom attribute that is applied to a container instance,
	// such as attribute:ecs.availability-zone. For the binpack placement strategy,
	// valid values are cpu and memory. For the random placement strategy, this
	// field is not used.
	//
	// Field is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by PlacementStrategy's
	// String and GoString methods.
	Field *string `locationName:"field" type:"string" sensitive:"true"`

	// The type of placement strategy. The random placement strategy randomly places
	// tasks on available candidates. The spread placement strategy spreads placement
	// across available candidates evenly based on the field parameter. The binpack
	// strategy places tasks on available candidates that have the least available
	// amount of the resource that is specified with the field parameter. For example,
	// if you binpack on memory, a task is placed on the instance with the least
	// amount of remaining memory (but still enough to run the task).
	Type *string `locationName:"type" type:"string" enum:"PlacementStrategyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementStrategy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlacementStrategy) GoString() string {
	return s.String()
}

// SetField sets the Field field's value.
func (s *PlacementStrategy) SetField(v string) *PlacementStrategy {
	s.Field = &v
	return s
}

// SetType sets the Type field's value.
func (s *PlacementStrategy) SetType(v string) *PlacementStrategy {
	s.Type = &v
	return s
}

// The Amazon S3 logging configuration settings for the pipe.
type S3LogDestination struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon S3 bucket to which EventBridge delivers the log records
	// for the pipe.
	BucketName *string `type:"string"`

	// The Amazon Web Services account that owns the Amazon S3 bucket to which EventBridge
	// delivers the log records for the pipe.
	BucketOwner *string `type:"string"`

	// The format EventBridge uses for the log records.
	//
	//    * json: JSON
	//
	//    * plain: Plain text
	//
	//    * w3c: W3C extended logging file format (https://www.w3.org/TR/WD-logfile)
	OutputFormat *string `type:"string" enum:"S3OutputFormat"`

	// The prefix text with which to begin Amazon S3 log object names.
	//
	// For more information, see Organizing objects using prefixes (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html)
	// in the Amazon Simple Storage Service User Guide.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LogDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LogDestination) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *S3LogDestination) SetBucketName(v string) *S3LogDestination {
	s.BucketName = &v
	return s
}

// SetBucketOwner sets the BucketOwner field's value.
func (s *S3LogDestination) SetBucketOwner(v string) *S3LogDestination {
	s.BucketOwner = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *S3LogDestination) SetOutputFormat(v string) *S3LogDestination {
	s.OutputFormat = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3LogDestination) SetPrefix(v string) *S3LogDestination {
	s.Prefix = &v
	return s
}

// The Amazon S3 logging configuration settings for the pipe.
type S3LogDestinationParameters struct {
	_ struct{} `type:"structure"`

	// Specifies the name of the Amazon S3 bucket to which EventBridge delivers
	// the log records for the pipe.
	//
	// BucketName is a required field
	BucketName *string `min:"3" type:"string" required:"true"`

	// Specifies the Amazon Web Services account that owns the Amazon S3 bucket
	// to which EventBridge delivers the log records for the pipe.
	//
	// BucketOwner is a required field
	BucketOwner *string `type:"string" required:"true"`

	// How EventBridge should format the log records.
	//
	//    * json: JSON
	//
	//    * plain: Plain text
	//
	//    * w3c: W3C extended logging file format (https://www.w3.org/TR/WD-logfile)
	OutputFormat *string `type:"string" enum:"S3OutputFormat"`

	// Specifies any prefix text with which to begin Amazon S3 log object names.
	//
	// You can use prefixes to organize the data that you store in Amazon S3 buckets.
	// A prefix is a string of characters at the beginning of the object key name.
	// A prefix can be any length, subject to the maximum length of the object key
	// name (1,024 bytes). For more information, see Organizing objects using prefixes
	// (https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-prefixes.html)
	// in the Amazon Simple Storage Service User Guide.
	Prefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LogDestinationParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3LogDestinationParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3LogDestinationParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3LogDestinationParameters"}
	if s.BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketName"))
	}
	if s.BucketName != nil && len(*s.BucketName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("BucketName", 3))
	}
	if s.BucketOwner == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketOwner"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketName sets the BucketName field's value.
func (s *S3LogDestinationParameters) SetBucketName(v string) *S3LogDestinationParameters {
	s.BucketName = &v
	return s
}

// SetBucketOwner sets the BucketOwner field's value.
func (s *S3LogDestinationParameters) SetBucketOwner(v string) *S3LogDestinationParameters {
	s.BucketOwner = &v
	return s
}

// SetOutputFormat sets the OutputFormat field's value.
func (s *S3LogDestinationParameters) SetOutputFormat(v string) *S3LogDestinationParameters {
	s.OutputFormat = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3LogDestinationParameters) SetPrefix(v string) *S3LogDestinationParameters {
	s.Prefix = &v
	return s
}

// Name/Value pair of a parameter to start execution of a SageMaker Model Building
// Pipeline.
type SageMakerPipelineParameter struct {
	_ struct{} `type:"structure"`

	// Name of parameter to start execution of a SageMaker Model Building Pipeline.
	//
	// Name is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SageMakerPipelineParameter's
	// String and GoString methods.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// Value of parameter to start execution of a SageMaker Model Building Pipeline.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by SageMakerPipelineParameter's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SageMakerPipelineParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SageMakerPipelineParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SageMakerPipelineParameter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *SageMakerPipelineParameter) SetName(v string) *SageMakerPipelineParameter {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *SageMakerPipelineParameter) SetValue(v string) *SageMakerPipelineParameter {
	s.Value = &v
	return s
}

// The Secrets Manager secret that stores your stream credentials.
type SelfManagedKafkaAccessConfigurationCredentials struct {
	_ struct{} `type:"structure"`

	// The ARN of the Secrets Manager secret.
	BasicAuth *string `min:"1" type:"string"`

	// The ARN of the Secrets Manager secret.
	ClientCertificateTlsAuth *string `min:"1" type:"string"`

	// The ARN of the Secrets Manager secret.
	SaslScram256Auth *string `min:"1" type:"string"`

	// The ARN of the Secrets Manager secret.
	SaslScram512Auth *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfManagedKafkaAccessConfigurationCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfManagedKafkaAccessConfigurationCredentials) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SelfManagedKafkaAccessConfigurationCredentials) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SelfManagedKafkaAccessConfigurationCredentials"}
	if s.BasicAuth != nil && len(*s.BasicAuth) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasicAuth", 1))
	}
	if s.ClientCertificateTlsAuth != nil && len(*s.ClientCertificateTlsAuth) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientCertificateTlsAuth", 1))
	}
	if s.SaslScram256Auth != nil && len(*s.SaslScram256Auth) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SaslScram256Auth", 1))
	}
	if s.SaslScram512Auth != nil && len(*s.SaslScram512Auth) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SaslScram512Auth", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasicAuth sets the BasicAuth field's value.
func (s *SelfManagedKafkaAccessConfigurationCredentials) SetBasicAuth(v string) *SelfManagedKafkaAccessConfigurationCredentials {
	s.BasicAuth = &v
	return s
}

// SetClientCertificateTlsAuth sets the ClientCertificateTlsAuth field's value.
func (s *SelfManagedKafkaAccessConfigurationCredentials) SetClientCertificateTlsAuth(v string) *SelfManagedKafkaAccessConfigurationCredentials {
	s.ClientCertificateTlsAuth = &v
	return s
}

// SetSaslScram256Auth sets the SaslScram256Auth field's value.
func (s *SelfManagedKafkaAccessConfigurationCredentials) SetSaslScram256Auth(v string) *SelfManagedKafkaAccessConfigurationCredentials {
	s.SaslScram256Auth = &v
	return s
}

// SetSaslScram512Auth sets the SaslScram512Auth field's value.
func (s *SelfManagedKafkaAccessConfigurationCredentials) SetSaslScram512Auth(v string) *SelfManagedKafkaAccessConfigurationCredentials {
	s.SaslScram512Auth = &v
	return s
}

// This structure specifies the VPC subnets and security groups for the stream,
// and whether a public IP address is to be used.
type SelfManagedKafkaAccessConfigurationVpc struct {
	_ struct{} `type:"structure"`

	// Specifies the security groups associated with the stream. These security
	// groups must all be in the same VPC. You can specify as many as five security
	// groups. If you do not specify a security group, the default security group
	// for the VPC is used.
	SecurityGroup []*string `type:"list"`

	// Specifies the subnets associated with the stream. These subnets must all
	// be in the same VPC. You can specify as many as 16 subnets.
	Subnets []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfManagedKafkaAccessConfigurationVpc) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfManagedKafkaAccessConfigurationVpc) GoString() string {
	return s.String()
}

// SetSecurityGroup sets the SecurityGroup field's value.
func (s *SelfManagedKafkaAccessConfigurationVpc) SetSecurityGroup(v []*string) *SelfManagedKafkaAccessConfigurationVpc {
	s.SecurityGroup = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *SelfManagedKafkaAccessConfigurationVpc) SetSubnets(v []*string) *SelfManagedKafkaAccessConfigurationVpc {
	s.Subnets = v
	return s
}

// A quota has been exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the quota that caused the exception.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// The ID of the resource that caused the exception.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// The type of resource that caused the exception.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// The identifier of the service that caused the exception.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Maps a single source data field to a single record in the specified Timestream
// for LiveAnalytics table.
//
// For more information, see Amazon Timestream for LiveAnalytics concepts (https://docs.aws.amazon.com/timestream/latest/developerguide/concepts.html)
type SingleMeasureMapping struct {
	_ struct{} `type:"structure"`

	// Target measure name for the measurement attribute in the Timestream table.
	//
	// MeasureName is a required field
	MeasureName *string `min:"1" type:"string" required:"true"`

	// Dynamic path of the source field to map to the measure in the record.
	//
	// MeasureValue is a required field
	MeasureValue *string `min:"1" type:"string" required:"true"`

	// Data type of the source field.
	//
	// MeasureValueType is a required field
	MeasureValueType *string `type:"string" required:"true" enum:"MeasureValueType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SingleMeasureMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SingleMeasureMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SingleMeasureMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SingleMeasureMapping"}
	if s.MeasureName == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureName"))
	}
	if s.MeasureName != nil && len(*s.MeasureName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureName", 1))
	}
	if s.MeasureValue == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureValue"))
	}
	if s.MeasureValue != nil && len(*s.MeasureValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MeasureValue", 1))
	}
	if s.MeasureValueType == nil {
		invalidParams.Add(request.NewErrParamRequired("MeasureValueType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMeasureName sets the MeasureName field's value.
func (s *SingleMeasureMapping) SetMeasureName(v string) *SingleMeasureMapping {
	s.MeasureName = &v
	return s
}

// SetMeasureValue sets the MeasureValue field's value.
func (s *SingleMeasureMapping) SetMeasureValue(v string) *SingleMeasureMapping {
	s.MeasureValue = &v
	return s
}

// SetMeasureValueType sets the MeasureValueType field's value.
func (s *SingleMeasureMapping) SetMeasureValueType(v string) *SingleMeasureMapping {
	s.MeasureValueType = &v
	return s
}

type StartPipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartPipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartPipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartPipeInput) SetName(v string) *StartPipeInput {
	s.Name = &v
	return s
}

type StartPipeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipe.
	Arn *string `min:"1" type:"string"`

	// The time the pipe was created.
	CreationTime *time.Time `type:"timestamp"`

	// The state the pipe is in.
	CurrentState *string `type:"string" enum:"PipeState"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeState"`

	// When the pipe was last updated, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the pipe.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartPipeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartPipeOutput) SetArn(v string) *StartPipeOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *StartPipeOutput) SetCreationTime(v time.Time) *StartPipeOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentState sets the CurrentState field's value.
func (s *StartPipeOutput) SetCurrentState(v string) *StartPipeOutput {
	s.CurrentState = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *StartPipeOutput) SetDesiredState(v string) *StartPipeOutput {
	s.DesiredState = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *StartPipeOutput) SetLastModifiedTime(v time.Time) *StartPipeOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *StartPipeOutput) SetName(v string) *StartPipeOutput {
	s.Name = &v
	return s
}

type StopPipeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the pipe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopPipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopPipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopPipeInput) SetName(v string) *StopPipeInput {
	s.Name = &v
	return s
}

type StopPipeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipe.
	Arn *string `min:"1" type:"string"`

	// The time the pipe was created.
	CreationTime *time.Time `type:"timestamp"`

	// The state the pipe is in.
	CurrentState *string `type:"string" enum:"PipeState"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeState"`

	// When the pipe was last updated, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the pipe.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopPipeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StopPipeOutput) SetArn(v string) *StopPipeOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *StopPipeOutput) SetCreationTime(v time.Time) *StopPipeOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentState sets the CurrentState field's value.
func (s *StopPipeOutput) SetCurrentState(v string) *StopPipeOutput {
	s.CurrentState = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *StopPipeOutput) SetDesiredState(v string) *StopPipeOutput {
	s.DesiredState = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *StopPipeOutput) SetLastModifiedTime(v time.Time) *StopPipeOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *StopPipeOutput) SetName(v string) *StopPipeOutput {
	s.Name = &v
	return s
}

// A key-value pair associated with an Amazon Web Services resource. In EventBridge,
// rules and event buses support tagging.
type Tag struct {
	_ struct{} `type:"structure"`

	// A string you can use to assign a value. The combination of tag keys and values
	// can help you organize and categorize your resources.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value for the specified tag key.
	//
	// Value is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Tag's
	// String and GoString methods.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipe.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The list of key-value pairs associated with the pipe.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// An action was throttled.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the quota that caused the exception.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// The number of seconds to wait before retrying the action that caused the
	// exception.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// The identifier of the service that caused the exception.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of the pipe.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The list of tag keys to remove from the pipe.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdatePipeInput struct {
	_ struct{} `type:"structure"`

	// A description of the pipe.
	//
	// Description is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdatePipeInput's
	// String and GoString methods.
	Description *string `type:"string" sensitive:"true"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeState"`

	// The ARN of the enrichment resource.
	Enrichment *string `type:"string"`

	// The parameters required to set up enrichment on your pipe.
	EnrichmentParameters *PipeEnrichmentParameters `type:"structure"`

	// The logging configuration settings for the pipe.
	LogConfiguration *PipeLogConfigurationParameters `type:"structure"`

	// The name of the pipe.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The ARN of the role that allows the pipe to send data to the target.
	//
	// RoleArn is a required field
	RoleArn *string `min:"1" type:"string" required:"true"`

	// The parameters required to set up a source for your pipe.
	SourceParameters *UpdatePipeSourceParameters `type:"structure"`

	// The ARN of the target resource.
	Target *string `min:"1" type:"string"`

	// The parameters required to set up a target for your pipe.
	//
	// For more information about pipe target parameters, including how to use dynamic
	// path parameters, see Target parameters (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-event-target.html)
	// in the Amazon EventBridge User Guide.
	TargetParameters *PipeTargetParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 1))
	}
	if s.Target != nil && len(*s.Target) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Target", 1))
	}
	if s.LogConfiguration != nil {
		if err := s.LogConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SourceParameters != nil {
		if err := s.SourceParameters.Validate(); err != nil {
			invalidParams.AddNested("SourceParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.TargetParameters != nil {
		if err := s.TargetParameters.Validate(); err != nil {
			invalidParams.AddNested("TargetParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdatePipeInput) SetDescription(v string) *UpdatePipeInput {
	s.Description = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *UpdatePipeInput) SetDesiredState(v string) *UpdatePipeInput {
	s.DesiredState = &v
	return s
}

// SetEnrichment sets the Enrichment field's value.
func (s *UpdatePipeInput) SetEnrichment(v string) *UpdatePipeInput {
	s.Enrichment = &v
	return s
}

// SetEnrichmentParameters sets the EnrichmentParameters field's value.
func (s *UpdatePipeInput) SetEnrichmentParameters(v *PipeEnrichmentParameters) *UpdatePipeInput {
	s.EnrichmentParameters = v
	return s
}

// SetLogConfiguration sets the LogConfiguration field's value.
func (s *UpdatePipeInput) SetLogConfiguration(v *PipeLogConfigurationParameters) *UpdatePipeInput {
	s.LogConfiguration = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePipeInput) SetName(v string) *UpdatePipeInput {
	s.Name = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdatePipeInput) SetRoleArn(v string) *UpdatePipeInput {
	s.RoleArn = &v
	return s
}

// SetSourceParameters sets the SourceParameters field's value.
func (s *UpdatePipeInput) SetSourceParameters(v *UpdatePipeSourceParameters) *UpdatePipeInput {
	s.SourceParameters = v
	return s
}

// SetTarget sets the Target field's value.
func (s *UpdatePipeInput) SetTarget(v string) *UpdatePipeInput {
	s.Target = &v
	return s
}

// SetTargetParameters sets the TargetParameters field's value.
func (s *UpdatePipeInput) SetTargetParameters(v *PipeTargetParameters) *UpdatePipeInput {
	s.TargetParameters = v
	return s
}

type UpdatePipeOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the pipe.
	Arn *string `min:"1" type:"string"`

	// The time the pipe was created.
	CreationTime *time.Time `type:"timestamp"`

	// The state the pipe is in.
	CurrentState *string `type:"string" enum:"PipeState"`

	// The state the pipe should be in.
	DesiredState *string `type:"string" enum:"RequestedPipeState"`

	// When the pipe was last updated, in ISO-8601 format (https://www.w3.org/TR/NOTE-datetime)
	// (YYYY-MM-DDThh:mm:ss.sTZD).
	LastModifiedTime *time.Time `type:"timestamp"`

	// The name of the pipe.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdatePipeOutput) SetArn(v string) *UpdatePipeOutput {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *UpdatePipeOutput) SetCreationTime(v time.Time) *UpdatePipeOutput {
	s.CreationTime = &v
	return s
}

// SetCurrentState sets the CurrentState field's value.
func (s *UpdatePipeOutput) SetCurrentState(v string) *UpdatePipeOutput {
	s.CurrentState = &v
	return s
}

// SetDesiredState sets the DesiredState field's value.
func (s *UpdatePipeOutput) SetDesiredState(v string) *UpdatePipeOutput {
	s.DesiredState = &v
	return s
}

// SetLastModifiedTime sets the LastModifiedTime field's value.
func (s *UpdatePipeOutput) SetLastModifiedTime(v time.Time) *UpdatePipeOutput {
	s.LastModifiedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdatePipeOutput) SetName(v string) *UpdatePipeOutput {
	s.Name = &v
	return s
}

// The parameters for using an Active MQ broker as a source.
type UpdatePipeSourceActiveMQBrokerParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The credentials needed to access the resource.
	//
	// Credentials is a required field
	Credentials *MQBrokerAccessCredentials `type:"structure" required:"true"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceActiveMQBrokerParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceActiveMQBrokerParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeSourceActiveMQBrokerParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeSourceActiveMQBrokerParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.Credentials == nil {
		invalidParams.Add(request.NewErrParamRequired("Credentials"))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdatePipeSourceActiveMQBrokerParameters) SetBatchSize(v int64) *UpdatePipeSourceActiveMQBrokerParameters {
	s.BatchSize = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *UpdatePipeSourceActiveMQBrokerParameters) SetCredentials(v *MQBrokerAccessCredentials) *UpdatePipeSourceActiveMQBrokerParameters {
	s.Credentials = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *UpdatePipeSourceActiveMQBrokerParameters) SetMaximumBatchingWindowInSeconds(v int64) *UpdatePipeSourceActiveMQBrokerParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// The parameters for using a DynamoDB stream as a source.
type UpdatePipeSourceDynamoDBStreamParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// Define the target queue to send dead-letter queue events to.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams only) Discard records older than the specified age. The default
	// value is -1, which sets the maximum age to infinite. When the value is set
	// to infinite, EventBridge never discards old records.
	MaximumRecordAgeInSeconds *int64 `type:"integer"`

	// (Streams only) Discard records after the specified number of retries. The
	// default value is -1, which sets the maximum number of retries to infinite.
	// When MaximumRetryAttempts is infinite, EventBridge retries failed records
	// until the record expires in the event source.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams only) Define how to handle item process failures. AUTOMATIC_BISECT
	// halves each batch and retry each half until all the records are processed
	// or there is one failed message left in the batch.
	OnPartialBatchItemFailure *string `type:"string" enum:"OnPartialBatchItemFailureStreams"`

	// (Streams only) The number of batches to process concurrently from each shard.
	// The default value is 1.
	ParallelizationFactor *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceDynamoDBStreamParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceDynamoDBStreamParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeSourceDynamoDBStreamParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeSourceDynamoDBStreamParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.MaximumRecordAgeInSeconds != nil && *s.MaximumRecordAgeInSeconds < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRecordAgeInSeconds", -1))
	}
	if s.MaximumRetryAttempts != nil && *s.MaximumRetryAttempts < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRetryAttempts", -1))
	}
	if s.ParallelizationFactor != nil && *s.ParallelizationFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelizationFactor", 1))
	}
	if s.DeadLetterConfig != nil {
		if err := s.DeadLetterConfig.Validate(); err != nil {
			invalidParams.AddNested("DeadLetterConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdatePipeSourceDynamoDBStreamParameters) SetBatchSize(v int64) *UpdatePipeSourceDynamoDBStreamParameters {
	s.BatchSize = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *UpdatePipeSourceDynamoDBStreamParameters) SetDeadLetterConfig(v *DeadLetterConfig) *UpdatePipeSourceDynamoDBStreamParameters {
	s.DeadLetterConfig = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *UpdatePipeSourceDynamoDBStreamParameters) SetMaximumBatchingWindowInSeconds(v int64) *UpdatePipeSourceDynamoDBStreamParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetMaximumRecordAgeInSeconds sets the MaximumRecordAgeInSeconds field's value.
func (s *UpdatePipeSourceDynamoDBStreamParameters) SetMaximumRecordAgeInSeconds(v int64) *UpdatePipeSourceDynamoDBStreamParameters {
	s.MaximumRecordAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *UpdatePipeSourceDynamoDBStreamParameters) SetMaximumRetryAttempts(v int64) *UpdatePipeSourceDynamoDBStreamParameters {
	s.MaximumRetryAttempts = &v
	return s
}

// SetOnPartialBatchItemFailure sets the OnPartialBatchItemFailure field's value.
func (s *UpdatePipeSourceDynamoDBStreamParameters) SetOnPartialBatchItemFailure(v string) *UpdatePipeSourceDynamoDBStreamParameters {
	s.OnPartialBatchItemFailure = &v
	return s
}

// SetParallelizationFactor sets the ParallelizationFactor field's value.
func (s *UpdatePipeSourceDynamoDBStreamParameters) SetParallelizationFactor(v int64) *UpdatePipeSourceDynamoDBStreamParameters {
	s.ParallelizationFactor = &v
	return s
}

// The parameters for using a Kinesis stream as a source.
type UpdatePipeSourceKinesisStreamParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// Define the target queue to send dead-letter queue events to.
	DeadLetterConfig *DeadLetterConfig `type:"structure"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// (Streams only) Discard records older than the specified age. The default
	// value is -1, which sets the maximum age to infinite. When the value is set
	// to infinite, EventBridge never discards old records.
	MaximumRecordAgeInSeconds *int64 `type:"integer"`

	// (Streams only) Discard records after the specified number of retries. The
	// default value is -1, which sets the maximum number of retries to infinite.
	// When MaximumRetryAttempts is infinite, EventBridge retries failed records
	// until the record expires in the event source.
	MaximumRetryAttempts *int64 `type:"integer"`

	// (Streams only) Define how to handle item process failures. AUTOMATIC_BISECT
	// halves each batch and retry each half until all the records are processed
	// or there is one failed message left in the batch.
	OnPartialBatchItemFailure *string `type:"string" enum:"OnPartialBatchItemFailureStreams"`

	// (Streams only) The number of batches to process concurrently from each shard.
	// The default value is 1.
	ParallelizationFactor *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceKinesisStreamParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceKinesisStreamParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeSourceKinesisStreamParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeSourceKinesisStreamParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.MaximumRecordAgeInSeconds != nil && *s.MaximumRecordAgeInSeconds < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRecordAgeInSeconds", -1))
	}
	if s.MaximumRetryAttempts != nil && *s.MaximumRetryAttempts < -1 {
		invalidParams.Add(request.NewErrParamMinValue("MaximumRetryAttempts", -1))
	}
	if s.ParallelizationFactor != nil && *s.ParallelizationFactor < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ParallelizationFactor", 1))
	}
	if s.DeadLetterConfig != nil {
		if err := s.DeadLetterConfig.Validate(); err != nil {
			invalidParams.AddNested("DeadLetterConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdatePipeSourceKinesisStreamParameters) SetBatchSize(v int64) *UpdatePipeSourceKinesisStreamParameters {
	s.BatchSize = &v
	return s
}

// SetDeadLetterConfig sets the DeadLetterConfig field's value.
func (s *UpdatePipeSourceKinesisStreamParameters) SetDeadLetterConfig(v *DeadLetterConfig) *UpdatePipeSourceKinesisStreamParameters {
	s.DeadLetterConfig = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *UpdatePipeSourceKinesisStreamParameters) SetMaximumBatchingWindowInSeconds(v int64) *UpdatePipeSourceKinesisStreamParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetMaximumRecordAgeInSeconds sets the MaximumRecordAgeInSeconds field's value.
func (s *UpdatePipeSourceKinesisStreamParameters) SetMaximumRecordAgeInSeconds(v int64) *UpdatePipeSourceKinesisStreamParameters {
	s.MaximumRecordAgeInSeconds = &v
	return s
}

// SetMaximumRetryAttempts sets the MaximumRetryAttempts field's value.
func (s *UpdatePipeSourceKinesisStreamParameters) SetMaximumRetryAttempts(v int64) *UpdatePipeSourceKinesisStreamParameters {
	s.MaximumRetryAttempts = &v
	return s
}

// SetOnPartialBatchItemFailure sets the OnPartialBatchItemFailure field's value.
func (s *UpdatePipeSourceKinesisStreamParameters) SetOnPartialBatchItemFailure(v string) *UpdatePipeSourceKinesisStreamParameters {
	s.OnPartialBatchItemFailure = &v
	return s
}

// SetParallelizationFactor sets the ParallelizationFactor field's value.
func (s *UpdatePipeSourceKinesisStreamParameters) SetParallelizationFactor(v int64) *UpdatePipeSourceKinesisStreamParameters {
	s.ParallelizationFactor = &v
	return s
}

// The parameters for using an MSK stream as a source.
type UpdatePipeSourceManagedStreamingKafkaParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The credentials needed to access the resource.
	Credentials *MSKAccessCredentials `type:"structure"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceManagedStreamingKafkaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceManagedStreamingKafkaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeSourceManagedStreamingKafkaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeSourceManagedStreamingKafkaParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdatePipeSourceManagedStreamingKafkaParameters) SetBatchSize(v int64) *UpdatePipeSourceManagedStreamingKafkaParameters {
	s.BatchSize = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *UpdatePipeSourceManagedStreamingKafkaParameters) SetCredentials(v *MSKAccessCredentials) *UpdatePipeSourceManagedStreamingKafkaParameters {
	s.Credentials = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *UpdatePipeSourceManagedStreamingKafkaParameters) SetMaximumBatchingWindowInSeconds(v int64) *UpdatePipeSourceManagedStreamingKafkaParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// The parameters required to set up a source for your pipe.
type UpdatePipeSourceParameters struct {
	_ struct{} `type:"structure"`

	// The parameters for using an Active MQ broker as a source.
	ActiveMQBrokerParameters *UpdatePipeSourceActiveMQBrokerParameters `type:"structure"`

	// The parameters for using a DynamoDB stream as a source.
	DynamoDBStreamParameters *UpdatePipeSourceDynamoDBStreamParameters `type:"structure"`

	// The collection of event patterns used to filter events.
	//
	// To remove a filter, specify a FilterCriteria object with an empty array of
	// Filter objects.
	//
	// For more information, see Events and Event Patterns (https://docs.aws.amazon.com/eventbridge/latest/userguide/eventbridge-and-event-patterns.html)
	// in the Amazon EventBridge User Guide.
	FilterCriteria *FilterCriteria `type:"structure"`

	// The parameters for using a Kinesis stream as a source.
	KinesisStreamParameters *UpdatePipeSourceKinesisStreamParameters `type:"structure"`

	// The parameters for using an MSK stream as a source.
	ManagedStreamingKafkaParameters *UpdatePipeSourceManagedStreamingKafkaParameters `type:"structure"`

	// The parameters for using a Rabbit MQ broker as a source.
	RabbitMQBrokerParameters *UpdatePipeSourceRabbitMQBrokerParameters `type:"structure"`

	// The parameters for using a self-managed Apache Kafka stream as a source.
	//
	// A self managed cluster refers to any Apache Kafka cluster not hosted by Amazon
	// Web Services. This includes both clusters you manage yourself, as well as
	// those hosted by a third-party provider, such as Confluent Cloud (https://www.confluent.io/),
	// CloudKarafka (https://www.cloudkarafka.com/), or Redpanda (https://redpanda.com/).
	// For more information, see Apache Kafka streams as a source (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html)
	// in the Amazon EventBridge User Guide.
	SelfManagedKafkaParameters *UpdatePipeSourceSelfManagedKafkaParameters `type:"structure"`

	// The parameters for using a Amazon SQS stream as a source.
	SqsQueueParameters *UpdatePipeSourceSqsQueueParameters `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeSourceParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeSourceParameters"}
	if s.ActiveMQBrokerParameters != nil {
		if err := s.ActiveMQBrokerParameters.Validate(); err != nil {
			invalidParams.AddNested("ActiveMQBrokerParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.DynamoDBStreamParameters != nil {
		if err := s.DynamoDBStreamParameters.Validate(); err != nil {
			invalidParams.AddNested("DynamoDBStreamParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamParameters != nil {
		if err := s.KinesisStreamParameters.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.ManagedStreamingKafkaParameters != nil {
		if err := s.ManagedStreamingKafkaParameters.Validate(); err != nil {
			invalidParams.AddNested("ManagedStreamingKafkaParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.RabbitMQBrokerParameters != nil {
		if err := s.RabbitMQBrokerParameters.Validate(); err != nil {
			invalidParams.AddNested("RabbitMQBrokerParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SelfManagedKafkaParameters != nil {
		if err := s.SelfManagedKafkaParameters.Validate(); err != nil {
			invalidParams.AddNested("SelfManagedKafkaParameters", err.(request.ErrInvalidParams))
		}
	}
	if s.SqsQueueParameters != nil {
		if err := s.SqsQueueParameters.Validate(); err != nil {
			invalidParams.AddNested("SqsQueueParameters", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActiveMQBrokerParameters sets the ActiveMQBrokerParameters field's value.
func (s *UpdatePipeSourceParameters) SetActiveMQBrokerParameters(v *UpdatePipeSourceActiveMQBrokerParameters) *UpdatePipeSourceParameters {
	s.ActiveMQBrokerParameters = v
	return s
}

// SetDynamoDBStreamParameters sets the DynamoDBStreamParameters field's value.
func (s *UpdatePipeSourceParameters) SetDynamoDBStreamParameters(v *UpdatePipeSourceDynamoDBStreamParameters) *UpdatePipeSourceParameters {
	s.DynamoDBStreamParameters = v
	return s
}

// SetFilterCriteria sets the FilterCriteria field's value.
func (s *UpdatePipeSourceParameters) SetFilterCriteria(v *FilterCriteria) *UpdatePipeSourceParameters {
	s.FilterCriteria = v
	return s
}

// SetKinesisStreamParameters sets the KinesisStreamParameters field's value.
func (s *UpdatePipeSourceParameters) SetKinesisStreamParameters(v *UpdatePipeSourceKinesisStreamParameters) *UpdatePipeSourceParameters {
	s.KinesisStreamParameters = v
	return s
}

// SetManagedStreamingKafkaParameters sets the ManagedStreamingKafkaParameters field's value.
func (s *UpdatePipeSourceParameters) SetManagedStreamingKafkaParameters(v *UpdatePipeSourceManagedStreamingKafkaParameters) *UpdatePipeSourceParameters {
	s.ManagedStreamingKafkaParameters = v
	return s
}

// SetRabbitMQBrokerParameters sets the RabbitMQBrokerParameters field's value.
func (s *UpdatePipeSourceParameters) SetRabbitMQBrokerParameters(v *UpdatePipeSourceRabbitMQBrokerParameters) *UpdatePipeSourceParameters {
	s.RabbitMQBrokerParameters = v
	return s
}

// SetSelfManagedKafkaParameters sets the SelfManagedKafkaParameters field's value.
func (s *UpdatePipeSourceParameters) SetSelfManagedKafkaParameters(v *UpdatePipeSourceSelfManagedKafkaParameters) *UpdatePipeSourceParameters {
	s.SelfManagedKafkaParameters = v
	return s
}

// SetSqsQueueParameters sets the SqsQueueParameters field's value.
func (s *UpdatePipeSourceParameters) SetSqsQueueParameters(v *UpdatePipeSourceSqsQueueParameters) *UpdatePipeSourceParameters {
	s.SqsQueueParameters = v
	return s
}

// The parameters for using a Rabbit MQ broker as a source.
type UpdatePipeSourceRabbitMQBrokerParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The credentials needed to access the resource.
	//
	// Credentials is a required field
	Credentials *MQBrokerAccessCredentials `type:"structure" required:"true"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceRabbitMQBrokerParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceRabbitMQBrokerParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeSourceRabbitMQBrokerParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeSourceRabbitMQBrokerParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.Credentials == nil {
		invalidParams.Add(request.NewErrParamRequired("Credentials"))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdatePipeSourceRabbitMQBrokerParameters) SetBatchSize(v int64) *UpdatePipeSourceRabbitMQBrokerParameters {
	s.BatchSize = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *UpdatePipeSourceRabbitMQBrokerParameters) SetCredentials(v *MQBrokerAccessCredentials) *UpdatePipeSourceRabbitMQBrokerParameters {
	s.Credentials = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *UpdatePipeSourceRabbitMQBrokerParameters) SetMaximumBatchingWindowInSeconds(v int64) *UpdatePipeSourceRabbitMQBrokerParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// The parameters for using a self-managed Apache Kafka stream as a source.
//
// A self managed cluster refers to any Apache Kafka cluster not hosted by Amazon
// Web Services. This includes both clusters you manage yourself, as well as
// those hosted by a third-party provider, such as Confluent Cloud (https://www.confluent.io/),
// CloudKarafka (https://www.cloudkarafka.com/), or Redpanda (https://redpanda.com/).
// For more information, see Apache Kafka streams as a source (https://docs.aws.amazon.com/eventbridge/latest/userguide/eb-pipes-kafka.html)
// in the Amazon EventBridge User Guide.
type UpdatePipeSourceSelfManagedKafkaParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The credentials needed to access the resource.
	Credentials *SelfManagedKafkaAccessConfigurationCredentials `type:"structure"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`

	// The ARN of the Secrets Manager secret used for certification.
	ServerRootCaCertificate *string `min:"1" type:"string"`

	// This structure specifies the VPC subnets and security groups for the stream,
	// and whether a public IP address is to be used.
	Vpc *SelfManagedKafkaAccessConfigurationVpc `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceSelfManagedKafkaParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceSelfManagedKafkaParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeSourceSelfManagedKafkaParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeSourceSelfManagedKafkaParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}
	if s.ServerRootCaCertificate != nil && len(*s.ServerRootCaCertificate) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerRootCaCertificate", 1))
	}
	if s.Credentials != nil {
		if err := s.Credentials.Validate(); err != nil {
			invalidParams.AddNested("Credentials", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdatePipeSourceSelfManagedKafkaParameters) SetBatchSize(v int64) *UpdatePipeSourceSelfManagedKafkaParameters {
	s.BatchSize = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *UpdatePipeSourceSelfManagedKafkaParameters) SetCredentials(v *SelfManagedKafkaAccessConfigurationCredentials) *UpdatePipeSourceSelfManagedKafkaParameters {
	s.Credentials = v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *UpdatePipeSourceSelfManagedKafkaParameters) SetMaximumBatchingWindowInSeconds(v int64) *UpdatePipeSourceSelfManagedKafkaParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// SetServerRootCaCertificate sets the ServerRootCaCertificate field's value.
func (s *UpdatePipeSourceSelfManagedKafkaParameters) SetServerRootCaCertificate(v string) *UpdatePipeSourceSelfManagedKafkaParameters {
	s.ServerRootCaCertificate = &v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *UpdatePipeSourceSelfManagedKafkaParameters) SetVpc(v *SelfManagedKafkaAccessConfigurationVpc) *UpdatePipeSourceSelfManagedKafkaParameters {
	s.Vpc = v
	return s
}

// The parameters for using a Amazon SQS stream as a source.
type UpdatePipeSourceSqsQueueParameters struct {
	_ struct{} `type:"structure"`

	// The maximum number of records to include in each batch.
	BatchSize *int64 `min:"1" type:"integer"`

	// The maximum length of a time to wait for events.
	MaximumBatchingWindowInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceSqsQueueParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePipeSourceSqsQueueParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePipeSourceSqsQueueParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePipeSourceSqsQueueParameters"}
	if s.BatchSize != nil && *s.BatchSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BatchSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchSize sets the BatchSize field's value.
func (s *UpdatePipeSourceSqsQueueParameters) SetBatchSize(v int64) *UpdatePipeSourceSqsQueueParameters {
	s.BatchSize = &v
	return s
}

// SetMaximumBatchingWindowInSeconds sets the MaximumBatchingWindowInSeconds field's value.
func (s *UpdatePipeSourceSqsQueueParameters) SetMaximumBatchingWindowInSeconds(v int64) *UpdatePipeSourceSqsQueueParameters {
	s.MaximumBatchingWindowInSeconds = &v
	return s
}

// Indicates that an error has occurred while performing a validate operation.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The list of fields for which validation failed and the corresponding failure
	// messages.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates that an error has occurred while performing a validate operation.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// The message of the exception.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The name of the exception.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

const (
	// AssignPublicIpEnabled is a AssignPublicIp enum value
	AssignPublicIpEnabled = "ENABLED"

	// AssignPublicIpDisabled is a AssignPublicIp enum value
	AssignPublicIpDisabled = "DISABLED"
)

// AssignPublicIp_Values returns all elements of the AssignPublicIp enum
func AssignPublicIp_Values() []string {
	return []string{
		AssignPublicIpEnabled,
		AssignPublicIpDisabled,
	}
}

const (
	// BatchJobDependencyTypeNToN is a BatchJobDependencyType enum value
	BatchJobDependencyTypeNToN = "N_TO_N"

	// BatchJobDependencyTypeSequential is a BatchJobDependencyType enum value
	BatchJobDependencyTypeSequential = "SEQUENTIAL"
)

// BatchJobDependencyType_Values returns all elements of the BatchJobDependencyType enum
func BatchJobDependencyType_Values() []string {
	return []string{
		BatchJobDependencyTypeNToN,
		BatchJobDependencyTypeSequential,
	}
}

const (
	// BatchResourceRequirementTypeGpu is a BatchResourceRequirementType enum value
	BatchResourceRequirementTypeGpu = "GPU"

	// BatchResourceRequirementTypeMemory is a BatchResourceRequirementType enum value
	BatchResourceRequirementTypeMemory = "MEMORY"

	// BatchResourceRequirementTypeVcpu is a BatchResourceRequirementType enum value
	BatchResourceRequirementTypeVcpu = "VCPU"
)

// BatchResourceRequirementType_Values returns all elements of the BatchResourceRequirementType enum
func BatchResourceRequirementType_Values() []string {
	return []string{
		BatchResourceRequirementTypeGpu,
		BatchResourceRequirementTypeMemory,
		BatchResourceRequirementTypeVcpu,
	}
}

const (
	// DimensionValueTypeVarchar is a DimensionValueType enum value
	DimensionValueTypeVarchar = "VARCHAR"
)

// DimensionValueType_Values returns all elements of the DimensionValueType enum
func DimensionValueType_Values() []string {
	return []string{
		DimensionValueTypeVarchar,
	}
}

const (
	// DynamoDBStreamStartPositionTrimHorizon is a DynamoDBStreamStartPosition enum value
	DynamoDBStreamStartPositionTrimHorizon = "TRIM_HORIZON"

	// DynamoDBStreamStartPositionLatest is a DynamoDBStreamStartPosition enum value
	DynamoDBStreamStartPositionLatest = "LATEST"
)

// DynamoDBStreamStartPosition_Values returns all elements of the DynamoDBStreamStartPosition enum
func DynamoDBStreamStartPosition_Values() []string {
	return []string{
		DynamoDBStreamStartPositionTrimHorizon,
		DynamoDBStreamStartPositionLatest,
	}
}

const (
	// EcsEnvironmentFileTypeS3 is a EcsEnvironmentFileType enum value
	EcsEnvironmentFileTypeS3 = "s3"
)

// EcsEnvironmentFileType_Values returns all elements of the EcsEnvironmentFileType enum
func EcsEnvironmentFileType_Values() []string {
	return []string{
		EcsEnvironmentFileTypeS3,
	}
}

const (
	// EcsResourceRequirementTypeGpu is a EcsResourceRequirementType enum value
	EcsResourceRequirementTypeGpu = "GPU"

	// EcsResourceRequirementTypeInferenceAccelerator is a EcsResourceRequirementType enum value
	EcsResourceRequirementTypeInferenceAccelerator = "InferenceAccelerator"
)

// EcsResourceRequirementType_Values returns all elements of the EcsResourceRequirementType enum
func EcsResourceRequirementType_Values() []string {
	return []string{
		EcsResourceRequirementTypeGpu,
		EcsResourceRequirementTypeInferenceAccelerator,
	}
}

const (
	// EpochTimeUnitMilliseconds is a EpochTimeUnit enum value
	EpochTimeUnitMilliseconds = "MILLISECONDS"

	// EpochTimeUnitSeconds is a EpochTimeUnit enum value
	EpochTimeUnitSeconds = "SECONDS"

	// EpochTimeUnitMicroseconds is a EpochTimeUnit enum value
	EpochTimeUnitMicroseconds = "MICROSECONDS"

	// EpochTimeUnitNanoseconds is a EpochTimeUnit enum value
	EpochTimeUnitNanoseconds = "NANOSECONDS"
)

// EpochTimeUnit_Values returns all elements of the EpochTimeUnit enum
func EpochTimeUnit_Values() []string {
	return []string{
		EpochTimeUnitMilliseconds,
		EpochTimeUnitSeconds,
		EpochTimeUnitMicroseconds,
		EpochTimeUnitNanoseconds,
	}
}

const (
	// IncludeExecutionDataOptionAll is a IncludeExecutionDataOption enum value
	IncludeExecutionDataOptionAll = "ALL"
)

// IncludeExecutionDataOption_Values returns all elements of the IncludeExecutionDataOption enum
func IncludeExecutionDataOption_Values() []string {
	return []string{
		IncludeExecutionDataOptionAll,
	}
}

const (
	// KinesisStreamStartPositionTrimHorizon is a KinesisStreamStartPosition enum value
	KinesisStreamStartPositionTrimHorizon = "TRIM_HORIZON"

	// KinesisStreamStartPositionLatest is a KinesisStreamStartPosition enum value
	KinesisStreamStartPositionLatest = "LATEST"

	// KinesisStreamStartPositionAtTimestamp is a KinesisStreamStartPosition enum value
	KinesisStreamStartPositionAtTimestamp = "AT_TIMESTAMP"
)

// KinesisStreamStartPosition_Values returns all elements of the KinesisStreamStartPosition enum
func KinesisStreamStartPosition_Values() []string {
	return []string{
		KinesisStreamStartPositionTrimHorizon,
		KinesisStreamStartPositionLatest,
		KinesisStreamStartPositionAtTimestamp,
	}
}

const (
	// LaunchTypeEc2 is a LaunchType enum value
	LaunchTypeEc2 = "EC2"

	// LaunchTypeFargate is a LaunchType enum value
	LaunchTypeFargate = "FARGATE"

	// LaunchTypeExternal is a LaunchType enum value
	LaunchTypeExternal = "EXTERNAL"
)

// LaunchType_Values returns all elements of the LaunchType enum
func LaunchType_Values() []string {
	return []string{
		LaunchTypeEc2,
		LaunchTypeFargate,
		LaunchTypeExternal,
	}
}

const (
	// LogLevelOff is a LogLevel enum value
	LogLevelOff = "OFF"

	// LogLevelError is a LogLevel enum value
	LogLevelError = "ERROR"

	// LogLevelInfo is a LogLevel enum value
	LogLevelInfo = "INFO"

	// LogLevelTrace is a LogLevel enum value
	LogLevelTrace = "TRACE"
)

// LogLevel_Values returns all elements of the LogLevel enum
func LogLevel_Values() []string {
	return []string{
		LogLevelOff,
		LogLevelError,
		LogLevelInfo,
		LogLevelTrace,
	}
}

const (
	// MSKStartPositionTrimHorizon is a MSKStartPosition enum value
	MSKStartPositionTrimHorizon = "TRIM_HORIZON"

	// MSKStartPositionLatest is a MSKStartPosition enum value
	MSKStartPositionLatest = "LATEST"
)

// MSKStartPosition_Values returns all elements of the MSKStartPosition enum
func MSKStartPosition_Values() []string {
	return []string{
		MSKStartPositionTrimHorizon,
		MSKStartPositionLatest,
	}
}

const (
	// MeasureValueTypeDouble is a MeasureValueType enum value
	MeasureValueTypeDouble = "DOUBLE"

	// MeasureValueTypeBigint is a MeasureValueType enum value
	MeasureValueTypeBigint = "BIGINT"

	// MeasureValueTypeVarchar is a MeasureValueType enum value
	MeasureValueTypeVarchar = "VARCHAR"

	// MeasureValueTypeBoolean is a MeasureValueType enum value
	MeasureValueTypeBoolean = "BOOLEAN"

	// MeasureValueTypeTimestamp is a MeasureValueType enum value
	MeasureValueTypeTimestamp = "TIMESTAMP"
)

// MeasureValueType_Values returns all elements of the MeasureValueType enum
func MeasureValueType_Values() []string {
	return []string{
		MeasureValueTypeDouble,
		MeasureValueTypeBigint,
		MeasureValueTypeVarchar,
		MeasureValueTypeBoolean,
		MeasureValueTypeTimestamp,
	}
}

const (
	// OnPartialBatchItemFailureStreamsAutomaticBisect is a OnPartialBatchItemFailureStreams enum value
	OnPartialBatchItemFailureStreamsAutomaticBisect = "AUTOMATIC_BISECT"
)

// OnPartialBatchItemFailureStreams_Values returns all elements of the OnPartialBatchItemFailureStreams enum
func OnPartialBatchItemFailureStreams_Values() []string {
	return []string{
		OnPartialBatchItemFailureStreamsAutomaticBisect,
	}
}

const (
	// PipeStateRunning is a PipeState enum value
	PipeStateRunning = "RUNNING"

	// PipeStateStopped is a PipeState enum value
	PipeStateStopped = "STOPPED"

	// PipeStateCreating is a PipeState enum value
	PipeStateCreating = "CREATING"

	// PipeStateUpdating is a PipeState enum value
	PipeStateUpdating = "UPDATING"

	// PipeStateDeleting is a PipeState enum value
	PipeStateDeleting = "DELETING"

	// PipeStateStarting is a PipeState enum value
	PipeStateStarting = "STARTING"

	// PipeStateStopping is a PipeState enum value
	PipeStateStopping = "STOPPING"

	// PipeStateCreateFailed is a PipeState enum value
	PipeStateCreateFailed = "CREATE_FAILED"

	// PipeStateUpdateFailed is a PipeState enum value
	PipeStateUpdateFailed = "UPDATE_FAILED"

	// PipeStateStartFailed is a PipeState enum value
	PipeStateStartFailed = "START_FAILED"

	// PipeStateStopFailed is a PipeState enum value
	PipeStateStopFailed = "STOP_FAILED"

	// PipeStateDeleteFailed is a PipeState enum value
	PipeStateDeleteFailed = "DELETE_FAILED"

	// PipeStateCreateRollbackFailed is a PipeState enum value
	PipeStateCreateRollbackFailed = "CREATE_ROLLBACK_FAILED"

	// PipeStateDeleteRollbackFailed is a PipeState enum value
	PipeStateDeleteRollbackFailed = "DELETE_ROLLBACK_FAILED"

	// PipeStateUpdateRollbackFailed is a PipeState enum value
	PipeStateUpdateRollbackFailed = "UPDATE_ROLLBACK_FAILED"
)

// PipeState_Values returns all elements of the PipeState enum
func PipeState_Values() []string {
	return []string{
		PipeStateRunning,
		PipeStateStopped,
		PipeStateCreating,
		PipeStateUpdating,
		PipeStateDeleting,
		PipeStateStarting,
		PipeStateStopping,
		PipeStateCreateFailed,
		PipeStateUpdateFailed,
		PipeStateStartFailed,
		PipeStateStopFailed,
		PipeStateDeleteFailed,
		PipeStateCreateRollbackFailed,
		PipeStateDeleteRollbackFailed,
		PipeStateUpdateRollbackFailed,
	}
}

const (
	// PipeTargetInvocationTypeRequestResponse is a PipeTargetInvocationType enum value
	PipeTargetInvocationTypeRequestResponse = "REQUEST_RESPONSE"

	// PipeTargetInvocationTypeFireAndForget is a PipeTargetInvocationType enum value
	PipeTargetInvocationTypeFireAndForget = "FIRE_AND_FORGET"
)

// PipeTargetInvocationType_Values returns all elements of the PipeTargetInvocationType enum
func PipeTargetInvocationType_Values() []string {
	return []string{
		PipeTargetInvocationTypeRequestResponse,
		PipeTargetInvocationTypeFireAndForget,
	}
}

const (
	// PlacementConstraintTypeDistinctInstance is a PlacementConstraintType enum value
	PlacementConstraintTypeDistinctInstance = "distinctInstance"

	// PlacementConstraintTypeMemberOf is a PlacementConstraintType enum value
	PlacementConstraintTypeMemberOf = "memberOf"
)

// PlacementConstraintType_Values returns all elements of the PlacementConstraintType enum
func PlacementConstraintType_Values() []string {
	return []string{
		PlacementConstraintTypeDistinctInstance,
		PlacementConstraintTypeMemberOf,
	}
}

const (
	// PlacementStrategyTypeRandom is a PlacementStrategyType enum value
	PlacementStrategyTypeRandom = "random"

	// PlacementStrategyTypeSpread is a PlacementStrategyType enum value
	PlacementStrategyTypeSpread = "spread"

	// PlacementStrategyTypeBinpack is a PlacementStrategyType enum value
	PlacementStrategyTypeBinpack = "binpack"
)

// PlacementStrategyType_Values returns all elements of the PlacementStrategyType enum
func PlacementStrategyType_Values() []string {
	return []string{
		PlacementStrategyTypeRandom,
		PlacementStrategyTypeSpread,
		PlacementStrategyTypeBinpack,
	}
}

const (
	// PropagateTagsTaskDefinition is a PropagateTags enum value
	PropagateTagsTaskDefinition = "TASK_DEFINITION"
)

// PropagateTags_Values returns all elements of the PropagateTags enum
func PropagateTags_Values() []string {
	return []string{
		PropagateTagsTaskDefinition,
	}
}

const (
	// RequestedPipeStateRunning is a RequestedPipeState enum value
	RequestedPipeStateRunning = "RUNNING"

	// RequestedPipeStateStopped is a RequestedPipeState enum value
	RequestedPipeStateStopped = "STOPPED"
)

// RequestedPipeState_Values returns all elements of the RequestedPipeState enum
func RequestedPipeState_Values() []string {
	return []string{
		RequestedPipeStateRunning,
		RequestedPipeStateStopped,
	}
}

const (
	// RequestedPipeStateDescribeResponseRunning is a RequestedPipeStateDescribeResponse enum value
	RequestedPipeStateDescribeResponseRunning = "RUNNING"

	// RequestedPipeStateDescribeResponseStopped is a RequestedPipeStateDescribeResponse enum value
	RequestedPipeStateDescribeResponseStopped = "STOPPED"

	// RequestedPipeStateDescribeResponseDeleted is a RequestedPipeStateDescribeResponse enum value
	RequestedPipeStateDescribeResponseDeleted = "DELETED"
)

// RequestedPipeStateDescribeResponse_Values returns all elements of the RequestedPipeStateDescribeResponse enum
func RequestedPipeStateDescribeResponse_Values() []string {
	return []string{
		RequestedPipeStateDescribeResponseRunning,
		RequestedPipeStateDescribeResponseStopped,
		RequestedPipeStateDescribeResponseDeleted,
	}
}

const (
	// S3OutputFormatJson is a S3OutputFormat enum value
	S3OutputFormatJson = "json"

	// S3OutputFormatPlain is a S3OutputFormat enum value
	S3OutputFormatPlain = "plain"

	// S3OutputFormatW3c is a S3OutputFormat enum value
	S3OutputFormatW3c = "w3c"
)

// S3OutputFormat_Values returns all elements of the S3OutputFormat enum
func S3OutputFormat_Values() []string {
	return []string{
		S3OutputFormatJson,
		S3OutputFormatPlain,
		S3OutputFormatW3c,
	}
}

const (
	// SelfManagedKafkaStartPositionTrimHorizon is a SelfManagedKafkaStartPosition enum value
	SelfManagedKafkaStartPositionTrimHorizon = "TRIM_HORIZON"

	// SelfManagedKafkaStartPositionLatest is a SelfManagedKafkaStartPosition enum value
	SelfManagedKafkaStartPositionLatest = "LATEST"
)

// SelfManagedKafkaStartPosition_Values returns all elements of the SelfManagedKafkaStartPosition enum
func SelfManagedKafkaStartPosition_Values() []string {
	return []string{
		SelfManagedKafkaStartPositionTrimHorizon,
		SelfManagedKafkaStartPositionLatest,
	}
}

const (
	// TimeFieldTypeEpoch is a TimeFieldType enum value
	TimeFieldTypeEpoch = "EPOCH"

	// TimeFieldTypeTimestampFormat is a TimeFieldType enum value
	TimeFieldTypeTimestampFormat = "TIMESTAMP_FORMAT"
)

// TimeFieldType_Values returns all elements of the TimeFieldType enum
func TimeFieldType_Values() []string {
	return []string{
		TimeFieldTypeEpoch,
		TimeFieldTypeTimestampFormat,
	}
}
