// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAccessPolicy = "AssociateAccessPolicy"

// AssociateAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAccessPolicy for more information on using the AssociateAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateAccessPolicyRequest method.
//	req, resp := client.AssociateAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateAccessPolicy
func (c *EKS) AssociateAccessPolicyRequest(input *AssociateAccessPolicyInput) (req *request.Request, output *AssociateAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opAssociateAccessPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/access-entries/{principalArn}/access-policies",
	}

	if input == nil {
		input = &AssociateAccessPolicyInput{}
	}

	output = &AssociateAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAccessPolicy API operation for Amazon Elastic Kubernetes Service.
//
// Associates an access policy and its scope to an access entry. For more information
// about associating access policies, see Associating and disassociating access
// policies to and from access entries (https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation AssociateAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateAccessPolicy
func (c *EKS) AssociateAccessPolicy(input *AssociateAccessPolicyInput) (*AssociateAccessPolicyOutput, error) {
	req, out := c.AssociateAccessPolicyRequest(input)
	return out, req.Send()
}

// AssociateAccessPolicyWithContext is the same as AssociateAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) AssociateAccessPolicyWithContext(ctx aws.Context, input *AssociateAccessPolicyInput, opts ...request.Option) (*AssociateAccessPolicyOutput, error) {
	req, out := c.AssociateAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateEncryptionConfig = "AssociateEncryptionConfig"

// AssociateEncryptionConfigRequest generates a "aws/request.Request" representing the
// client's request for the AssociateEncryptionConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateEncryptionConfig for more information on using the AssociateEncryptionConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateEncryptionConfigRequest method.
//	req, resp := client.AssociateEncryptionConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateEncryptionConfig
func (c *EKS) AssociateEncryptionConfigRequest(input *AssociateEncryptionConfigInput) (req *request.Request, output *AssociateEncryptionConfigOutput) {
	op := &request.Operation{
		Name:       opAssociateEncryptionConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/encryption-config/associate",
	}

	if input == nil {
		input = &AssociateEncryptionConfigInput{}
	}

	output = &AssociateEncryptionConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateEncryptionConfig API operation for Amazon Elastic Kubernetes Service.
//
// Associates an encryption configuration to an existing cluster.
//
// Use this API to enable encryption on existing clusters that don't already
// have encryption enabled. This allows you to implement a defense-in-depth
// security strategy without migrating applications to new Amazon EKS clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation AssociateEncryptionConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateEncryptionConfig
func (c *EKS) AssociateEncryptionConfig(input *AssociateEncryptionConfigInput) (*AssociateEncryptionConfigOutput, error) {
	req, out := c.AssociateEncryptionConfigRequest(input)
	return out, req.Send()
}

// AssociateEncryptionConfigWithContext is the same as AssociateEncryptionConfig with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateEncryptionConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) AssociateEncryptionConfigWithContext(ctx aws.Context, input *AssociateEncryptionConfigInput, opts ...request.Option) (*AssociateEncryptionConfigOutput, error) {
	req, out := c.AssociateEncryptionConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIdentityProviderConfig = "AssociateIdentityProviderConfig"

// AssociateIdentityProviderConfigRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIdentityProviderConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIdentityProviderConfig for more information on using the AssociateIdentityProviderConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateIdentityProviderConfigRequest method.
//	req, resp := client.AssociateIdentityProviderConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateIdentityProviderConfig
func (c *EKS) AssociateIdentityProviderConfigRequest(input *AssociateIdentityProviderConfigInput) (req *request.Request, output *AssociateIdentityProviderConfigOutput) {
	op := &request.Operation{
		Name:       opAssociateIdentityProviderConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/identity-provider-configs/associate",
	}

	if input == nil {
		input = &AssociateIdentityProviderConfigInput{}
	}

	output = &AssociateIdentityProviderConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateIdentityProviderConfig API operation for Amazon Elastic Kubernetes Service.
//
// Associates an identity provider configuration to a cluster.
//
// If you want to authenticate identities using an identity provider, you can
// create an identity provider configuration and associate it to your cluster.
// After configuring authentication to your cluster you can create Kubernetes
// Role and ClusterRole objects, assign permissions to them, and then bind them
// to the identities using Kubernetes RoleBinding and ClusterRoleBinding objects.
// For more information see Using RBAC Authorization (https://kubernetes.io/docs/reference/access-authn-authz/rbac/)
// in the Kubernetes documentation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation AssociateIdentityProviderConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/AssociateIdentityProviderConfig
func (c *EKS) AssociateIdentityProviderConfig(input *AssociateIdentityProviderConfigInput) (*AssociateIdentityProviderConfigOutput, error) {
	req, out := c.AssociateIdentityProviderConfigRequest(input)
	return out, req.Send()
}

// AssociateIdentityProviderConfigWithContext is the same as AssociateIdentityProviderConfig with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIdentityProviderConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) AssociateIdentityProviderConfigWithContext(ctx aws.Context, input *AssociateIdentityProviderConfigInput, opts ...request.Option) (*AssociateIdentityProviderConfigOutput, error) {
	req, out := c.AssociateIdentityProviderConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAccessEntry = "CreateAccessEntry"

// CreateAccessEntryRequest generates a "aws/request.Request" representing the
// client's request for the CreateAccessEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAccessEntry for more information on using the CreateAccessEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAccessEntryRequest method.
//	req, resp := client.CreateAccessEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateAccessEntry
func (c *EKS) CreateAccessEntryRequest(input *CreateAccessEntryInput) (req *request.Request, output *CreateAccessEntryOutput) {
	op := &request.Operation{
		Name:       opCreateAccessEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/access-entries",
	}

	if input == nil {
		input = &CreateAccessEntryInput{}
	}

	output = &CreateAccessEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAccessEntry API operation for Amazon Elastic Kubernetes Service.
//
// Creates an access entry.
//
// An access entry allows an IAM principal to access your cluster. Access entries
// can replace the need to maintain entries in the aws-auth ConfigMap for authentication.
// You have the following options for authorizing an IAM principal to access
// Kubernetes objects on your cluster: Kubernetes role-based access control
// (RBAC), Amazon EKS, or both. Kubernetes RBAC authorization requires you to
// create and manage Kubernetes Role, ClusterRole, RoleBinding, and ClusterRoleBinding
// objects, in addition to managing access entries. If you use Amazon EKS authorization
// exclusively, you don't need to create and manage Kubernetes Role, ClusterRole,
// RoleBinding, and ClusterRoleBinding objects.
//
// For more information about access entries, see Access entries (https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateAccessEntry for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ResourceLimitExceededException
//     You have encountered a service limit on the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateAccessEntry
func (c *EKS) CreateAccessEntry(input *CreateAccessEntryInput) (*CreateAccessEntryOutput, error) {
	req, out := c.CreateAccessEntryRequest(input)
	return out, req.Send()
}

// CreateAccessEntryWithContext is the same as CreateAccessEntry with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAccessEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateAccessEntryWithContext(ctx aws.Context, input *CreateAccessEntryInput, opts ...request.Option) (*CreateAccessEntryOutput, error) {
	req, out := c.CreateAccessEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAddon = "CreateAddon"

// CreateAddonRequest generates a "aws/request.Request" representing the
// client's request for the CreateAddon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAddon for more information on using the CreateAddon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAddonRequest method.
//	req, resp := client.CreateAddonRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateAddon
func (c *EKS) CreateAddonRequest(input *CreateAddonInput) (req *request.Request, output *CreateAddonOutput) {
	op := &request.Operation{
		Name:       opCreateAddon,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/addons",
	}

	if input == nil {
		input = &CreateAddonInput{}
	}

	output = &CreateAddonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAddon API operation for Amazon Elastic Kubernetes Service.
//
// Creates an Amazon EKS add-on.
//
// Amazon EKS add-ons help to automate the provisioning and lifecycle management
// of common operational software for Amazon EKS clusters. For more information,
// see Amazon EKS add-ons (https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateAddon for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateAddon
func (c *EKS) CreateAddon(input *CreateAddonInput) (*CreateAddonOutput, error) {
	req, out := c.CreateAddonRequest(input)
	return out, req.Send()
}

// CreateAddonWithContext is the same as CreateAddon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateAddonWithContext(ctx aws.Context, input *CreateAddonInput, opts ...request.Option) (*CreateAddonOutput, error) {
	req, out := c.CreateAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCluster = "CreateCluster"

// CreateClusterRequest generates a "aws/request.Request" representing the
// client's request for the CreateCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCluster for more information on using the CreateCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateClusterRequest method.
//	req, resp := client.CreateClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateCluster
func (c *EKS) CreateClusterRequest(input *CreateClusterInput) (req *request.Request, output *CreateClusterOutput) {
	op := &request.Operation{
		Name:       opCreateCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters",
	}

	if input == nil {
		input = &CreateClusterInput{}
	}

	output = &CreateClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCluster API operation for Amazon Elastic Kubernetes Service.
//
// Creates an Amazon EKS control plane.
//
// The Amazon EKS control plane consists of control plane instances that run
// the Kubernetes software, such as etcd and the API server. The control plane
// runs in an account managed by Amazon Web Services, and the Kubernetes API
// is exposed by the Amazon EKS API server endpoint. Each Amazon EKS cluster
// control plane is single tenant and unique. It runs on its own set of Amazon
// EC2 instances.
//
// The cluster control plane is provisioned across multiple Availability Zones
// and fronted by an Elastic Load Balancing Network Load Balancer. Amazon EKS
// also provisions elastic network interfaces in your VPC subnets to provide
// connectivity from the control plane instances to the nodes (for example,
// to support kubectl exec, logs, and proxy data flows).
//
// Amazon EKS nodes run in your Amazon Web Services account and connect to your
// cluster's control plane over the Kubernetes API server endpoint and a certificate
// file that is created for your cluster.
//
// You can use the endpointPublicAccess and endpointPrivateAccess parameters
// to enable or disable public and private access to your cluster's Kubernetes
// API server endpoint. By default, public access is enabled, and private access
// is disabled. For more information, see Amazon EKS Cluster Endpoint Access
// Control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
// in the Amazon EKS User Guide .
//
// You can use the logging parameter to enable or disable exporting the Kubernetes
// control plane logs for your cluster to CloudWatch Logs. By default, cluster
// control plane logs aren't exported to CloudWatch Logs. For more information,
// see Amazon EKS Cluster Control Plane Logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
// in the Amazon EKS User Guide .
//
// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
// to exported control plane logs. For more information, see CloudWatch Pricing
// (http://aws.amazon.com/cloudwatch/pricing/).
//
// In most cases, it takes several minutes to create a cluster. After you create
// an Amazon EKS cluster, you must configure your Kubernetes tooling to communicate
// with the API server and launch nodes into your cluster. For more information,
// see Allowing users to access your cluster (https://docs.aws.amazon.com/eks/latest/userguide/cluster-auth.html)
// and Launching Amazon EKS nodes (https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateCluster for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceLimitExceededException
//     You have encountered a service limit on the specified resource.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
//   - UnsupportedAvailabilityZoneException
//     At least one of your specified cluster subnets is in an Availability Zone
//     that does not support Amazon EKS. The exception output specifies the supported
//     Availability Zones for your account, from which you can choose subnets for
//     your cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateCluster
func (c *EKS) CreateCluster(input *CreateClusterInput) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	return out, req.Send()
}

// CreateClusterWithContext is the same as CreateCluster with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateClusterWithContext(ctx aws.Context, input *CreateClusterInput, opts ...request.Option) (*CreateClusterOutput, error) {
	req, out := c.CreateClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEksAnywhereSubscription = "CreateEksAnywhereSubscription"

// CreateEksAnywhereSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEksAnywhereSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEksAnywhereSubscription for more information on using the CreateEksAnywhereSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEksAnywhereSubscriptionRequest method.
//	req, resp := client.CreateEksAnywhereSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateEksAnywhereSubscription
func (c *EKS) CreateEksAnywhereSubscriptionRequest(input *CreateEksAnywhereSubscriptionInput) (req *request.Request, output *CreateEksAnywhereSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEksAnywhereSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/eks-anywhere-subscriptions",
	}

	if input == nil {
		input = &CreateEksAnywhereSubscriptionInput{}
	}

	output = &CreateEksAnywhereSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEksAnywhereSubscription API operation for Amazon Elastic Kubernetes Service.
//
// Creates an EKS Anywhere subscription. When a subscription is created, it
// is a contract agreement for the length of the term specified in the request.
// Licenses that are used to validate support are provisioned in Amazon Web
// Services License Manager and the caller account is granted access to EKS
// Anywhere Curated Packages.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateEksAnywhereSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     You have encountered a service limit on the specified resource.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateEksAnywhereSubscription
func (c *EKS) CreateEksAnywhereSubscription(input *CreateEksAnywhereSubscriptionInput) (*CreateEksAnywhereSubscriptionOutput, error) {
	req, out := c.CreateEksAnywhereSubscriptionRequest(input)
	return out, req.Send()
}

// CreateEksAnywhereSubscriptionWithContext is the same as CreateEksAnywhereSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEksAnywhereSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateEksAnywhereSubscriptionWithContext(ctx aws.Context, input *CreateEksAnywhereSubscriptionInput, opts ...request.Option) (*CreateEksAnywhereSubscriptionOutput, error) {
	req, out := c.CreateEksAnywhereSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFargateProfile = "CreateFargateProfile"

// CreateFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFargateProfile for more information on using the CreateFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFargateProfileRequest method.
//	req, resp := client.CreateFargateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateFargateProfile
func (c *EKS) CreateFargateProfileRequest(input *CreateFargateProfileInput) (req *request.Request, output *CreateFargateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateFargateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/fargate-profiles",
	}

	if input == nil {
		input = &CreateFargateProfileInput{}
	}

	output = &CreateFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Creates an Fargate profile for your Amazon EKS cluster. You must have at
// least one Fargate profile in a cluster to be able to run pods on Fargate.
//
// The Fargate profile allows an administrator to declare which pods run on
// Fargate and specify which pods run on which Fargate profile. This declaration
// is done through the profile’s selectors. Each profile can have up to five
// selectors that contain a namespace and labels. A namespace is required for
// every selector. The label field consists of multiple optional key-value pairs.
// Pods that match the selectors are scheduled on Fargate. If a to-be-scheduled
// pod matches any of the selectors in the Fargate profile, then that pod is
// run on Fargate.
//
// When you create a Fargate profile, you must specify a pod execution role
// to use with the pods that are scheduled with the profile. This role is added
// to the cluster's Kubernetes Role Based Access Control (https://kubernetes.io/docs/reference/access-authn-authz/rbac/)
// (RBAC) for authorization so that the kubelet that is running on the Fargate
// infrastructure can register with your Amazon EKS cluster so that it can appear
// in your cluster as a node. The pod execution role also provides IAM permissions
// to the Fargate infrastructure to allow read access to Amazon ECR image repositories.
// For more information, see Pod Execution Role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
// in the Amazon EKS User Guide.
//
// Fargate profiles are immutable. However, you can create a new updated profile
// to replace an existing profile and then delete the original after the updated
// profile has finished creating.
//
// If any Fargate profiles in a cluster are in the DELETING status, you must
// wait for that Fargate profile to finish deleting before you can create any
// other profiles in that cluster.
//
// For more information, see Fargate profile (https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html)
// in the Amazon EKS User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateFargateProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceLimitExceededException
//     You have encountered a service limit on the specified resource.
//
//   - UnsupportedAvailabilityZoneException
//     At least one of your specified cluster subnets is in an Availability Zone
//     that does not support Amazon EKS. The exception output specifies the supported
//     Availability Zones for your account, from which you can choose subnets for
//     your cluster.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateFargateProfile
func (c *EKS) CreateFargateProfile(input *CreateFargateProfileInput) (*CreateFargateProfileOutput, error) {
	req, out := c.CreateFargateProfileRequest(input)
	return out, req.Send()
}

// CreateFargateProfileWithContext is the same as CreateFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateFargateProfileWithContext(ctx aws.Context, input *CreateFargateProfileInput, opts ...request.Option) (*CreateFargateProfileOutput, error) {
	req, out := c.CreateFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNodegroup = "CreateNodegroup"

// CreateNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNodegroup for more information on using the CreateNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNodegroupRequest method.
//	req, resp := client.CreateNodegroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup
func (c *EKS) CreateNodegroupRequest(input *CreateNodegroupInput) (req *request.Request, output *CreateNodegroupOutput) {
	op := &request.Operation{
		Name:       opCreateNodegroup,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups",
	}

	if input == nil {
		input = &CreateNodegroupInput{}
	}

	output = &CreateNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Creates a managed node group for an Amazon EKS cluster.
//
// You can only create a node group for your cluster that is equal to the current
// Kubernetes version for the cluster. All node groups are created with the
// latest AMI release version for the respective minor Kubernetes version of
// the cluster, unless you deploy a custom AMI using a launch template. For
// more information about using launch templates, see Customizing managed nodes
// with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
//
// An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and
// associated Amazon EC2 instances that are managed by Amazon Web Services for
// an Amazon EKS cluster. For more information, see Managed node groups (https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html)
// in the Amazon EKS User Guide.
//
// Windows AMI types are only supported for commercial Amazon Web Services Regions
// that support Windows on Amazon EKS.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreateNodegroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceLimitExceededException
//     You have encountered a service limit on the specified resource.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreateNodegroup
func (c *EKS) CreateNodegroup(input *CreateNodegroupInput) (*CreateNodegroupOutput, error) {
	req, out := c.CreateNodegroupRequest(input)
	return out, req.Send()
}

// CreateNodegroupWithContext is the same as CreateNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreateNodegroupWithContext(ctx aws.Context, input *CreateNodegroupInput, opts ...request.Option) (*CreateNodegroupOutput, error) {
	req, out := c.CreateNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePodIdentityAssociation = "CreatePodIdentityAssociation"

// CreatePodIdentityAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreatePodIdentityAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePodIdentityAssociation for more information on using the CreatePodIdentityAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreatePodIdentityAssociationRequest method.
//	req, resp := client.CreatePodIdentityAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreatePodIdentityAssociation
func (c *EKS) CreatePodIdentityAssociationRequest(input *CreatePodIdentityAssociationInput) (req *request.Request, output *CreatePodIdentityAssociationOutput) {
	op := &request.Operation{
		Name:       opCreatePodIdentityAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/pod-identity-associations",
	}

	if input == nil {
		input = &CreatePodIdentityAssociationInput{}
	}

	output = &CreatePodIdentityAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePodIdentityAssociation API operation for Amazon Elastic Kubernetes Service.
//
// Creates an EKS Pod Identity association between a service account in an Amazon
// EKS cluster and an IAM role with EKS Pod Identity. Use EKS Pod Identity to
// give temporary IAM credentials to pods and the credentials are rotated automatically.
//
// Amazon EKS Pod Identity associations provide the ability to manage credentials
// for your applications, similar to the way that Amazon EC2 instance profiles
// provide credentials to Amazon EC2 instances.
//
// If a pod uses a service account that has an association, Amazon EKS sets
// environment variables in the containers of the pod. The environment variables
// configure the Amazon Web Services SDKs, including the Command Line Interface,
// to use the EKS Pod Identity credentials.
//
// Pod Identity is a simpler method than IAM roles for service accounts, as
// this method doesn't use OIDC identity providers. Additionally, you can configure
// a role for Pod Identity once, and reuse it across clusters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation CreatePodIdentityAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ResourceLimitExceededException
//     You have encountered a service limit on the specified resource.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/CreatePodIdentityAssociation
func (c *EKS) CreatePodIdentityAssociation(input *CreatePodIdentityAssociationInput) (*CreatePodIdentityAssociationOutput, error) {
	req, out := c.CreatePodIdentityAssociationRequest(input)
	return out, req.Send()
}

// CreatePodIdentityAssociationWithContext is the same as CreatePodIdentityAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePodIdentityAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) CreatePodIdentityAssociationWithContext(ctx aws.Context, input *CreatePodIdentityAssociationInput, opts ...request.Option) (*CreatePodIdentityAssociationOutput, error) {
	req, out := c.CreatePodIdentityAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAccessEntry = "DeleteAccessEntry"

// DeleteAccessEntryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAccessEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAccessEntry for more information on using the DeleteAccessEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAccessEntryRequest method.
//	req, resp := client.DeleteAccessEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteAccessEntry
func (c *EKS) DeleteAccessEntryRequest(input *DeleteAccessEntryInput) (req *request.Request, output *DeleteAccessEntryOutput) {
	op := &request.Operation{
		Name:       opDeleteAccessEntry,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/access-entries/{principalArn}",
	}

	if input == nil {
		input = &DeleteAccessEntryInput{}
	}

	output = &DeleteAccessEntryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAccessEntry API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an access entry.
//
// Deleting an access entry of a type other than Standard can cause your cluster
// to function improperly. If you delete an access entry in error, you can recreate
// it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteAccessEntry for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteAccessEntry
func (c *EKS) DeleteAccessEntry(input *DeleteAccessEntryInput) (*DeleteAccessEntryOutput, error) {
	req, out := c.DeleteAccessEntryRequest(input)
	return out, req.Send()
}

// DeleteAccessEntryWithContext is the same as DeleteAccessEntry with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAccessEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteAccessEntryWithContext(ctx aws.Context, input *DeleteAccessEntryInput, opts ...request.Option) (*DeleteAccessEntryOutput, error) {
	req, out := c.DeleteAccessEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAddon = "DeleteAddon"

// DeleteAddonRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAddon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAddon for more information on using the DeleteAddon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteAddonRequest method.
//	req, resp := client.DeleteAddonRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteAddon
func (c *EKS) DeleteAddonRequest(input *DeleteAddonInput) (req *request.Request, output *DeleteAddonOutput) {
	op := &request.Operation{
		Name:       opDeleteAddon,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/addons/{addonName}",
	}

	if input == nil {
		input = &DeleteAddonInput{}
	}

	output = &DeleteAddonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAddon API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an Amazon EKS add-on.
//
// When you remove an add-on, it's deleted from the cluster. You can always
// manually start an add-on on the cluster using the Kubernetes API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteAddon for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteAddon
func (c *EKS) DeleteAddon(input *DeleteAddonInput) (*DeleteAddonOutput, error) {
	req, out := c.DeleteAddonRequest(input)
	return out, req.Send()
}

// DeleteAddonWithContext is the same as DeleteAddon with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteAddonWithContext(ctx aws.Context, input *DeleteAddonInput, opts ...request.Option) (*DeleteAddonOutput, error) {
	req, out := c.DeleteAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCluster = "DeleteCluster"

// DeleteClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCluster for more information on using the DeleteCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteClusterRequest method.
//	req, resp := client.DeleteClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteCluster
func (c *EKS) DeleteClusterRequest(input *DeleteClusterInput) (req *request.Request, output *DeleteClusterOutput) {
	op := &request.Operation{
		Name:       opDeleteCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}",
	}

	if input == nil {
		input = &DeleteClusterInput{}
	}

	output = &DeleteClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCluster API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an Amazon EKS cluster control plane.
//
// If you have active services in your cluster that are associated with a load
// balancer, you must delete those services before deleting the cluster so that
// the load balancers are deleted properly. Otherwise, you can have orphaned
// resources in your VPC that prevent you from being able to delete the VPC.
// For more information, see Deleting a cluster (https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html)
// in the Amazon EKS User Guide.
//
// If you have managed node groups or Fargate profiles attached to the cluster,
// you must delete them first. For more information, see DeleteNodgroup and
// DeleteFargateProfile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteCluster for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteCluster
func (c *EKS) DeleteCluster(input *DeleteClusterInput) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	return out, req.Send()
}

// DeleteClusterWithContext is the same as DeleteCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteClusterWithContext(ctx aws.Context, input *DeleteClusterInput, opts ...request.Option) (*DeleteClusterOutput, error) {
	req, out := c.DeleteClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEksAnywhereSubscription = "DeleteEksAnywhereSubscription"

// DeleteEksAnywhereSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEksAnywhereSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEksAnywhereSubscription for more information on using the DeleteEksAnywhereSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEksAnywhereSubscriptionRequest method.
//	req, resp := client.DeleteEksAnywhereSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteEksAnywhereSubscription
func (c *EKS) DeleteEksAnywhereSubscriptionRequest(input *DeleteEksAnywhereSubscriptionInput) (req *request.Request, output *DeleteEksAnywhereSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEksAnywhereSubscription,
		HTTPMethod: "DELETE",
		HTTPPath:   "/eks-anywhere-subscriptions/{id}",
	}

	if input == nil {
		input = &DeleteEksAnywhereSubscriptionInput{}
	}

	output = &DeleteEksAnywhereSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEksAnywhereSubscription API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an expired or inactive subscription. Deleting inactive subscriptions
// removes them from the Amazon Web Services Management Console view and from
// list/describe API responses. Subscriptions can only be cancelled within 7
// days of creation and are cancelled by creating a ticket in the Amazon Web
// Services Support Center.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteEksAnywhereSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteEksAnywhereSubscription
func (c *EKS) DeleteEksAnywhereSubscription(input *DeleteEksAnywhereSubscriptionInput) (*DeleteEksAnywhereSubscriptionOutput, error) {
	req, out := c.DeleteEksAnywhereSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteEksAnywhereSubscriptionWithContext is the same as DeleteEksAnywhereSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEksAnywhereSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteEksAnywhereSubscriptionWithContext(ctx aws.Context, input *DeleteEksAnywhereSubscriptionInput, opts ...request.Option) (*DeleteEksAnywhereSubscriptionOutput, error) {
	req, out := c.DeleteEksAnywhereSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFargateProfile = "DeleteFargateProfile"

// DeleteFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFargateProfile for more information on using the DeleteFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFargateProfileRequest method.
//	req, resp := client.DeleteFargateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile
func (c *EKS) DeleteFargateProfileRequest(input *DeleteFargateProfileInput) (req *request.Request, output *DeleteFargateProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteFargateProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/fargate-profiles/{fargateProfileName}",
	}

	if input == nil {
		input = &DeleteFargateProfileInput{}
	}

	output = &DeleteFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Deletes an Fargate profile.
//
// When you delete a Fargate profile, any Pod running on Fargate that was created
// with the profile is deleted. If the Pod matches another Fargate profile,
// then it is scheduled on Fargate with that profile. If it no longer matches
// any Fargate profiles, then it's not scheduled on Fargate and may remain in
// a pending state.
//
// Only one Fargate profile in a cluster can be in the DELETING status at a
// time. You must wait for a Fargate profile to finish deleting before you can
// delete any other profiles in that cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteFargateProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteFargateProfile
func (c *EKS) DeleteFargateProfile(input *DeleteFargateProfileInput) (*DeleteFargateProfileOutput, error) {
	req, out := c.DeleteFargateProfileRequest(input)
	return out, req.Send()
}

// DeleteFargateProfileWithContext is the same as DeleteFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteFargateProfileWithContext(ctx aws.Context, input *DeleteFargateProfileInput, opts ...request.Option) (*DeleteFargateProfileOutput, error) {
	req, out := c.DeleteFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNodegroup = "DeleteNodegroup"

// DeleteNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNodegroup for more information on using the DeleteNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNodegroupRequest method.
//	req, resp := client.DeleteNodegroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup
func (c *EKS) DeleteNodegroupRequest(input *DeleteNodegroupInput) (req *request.Request, output *DeleteNodegroupOutput) {
	op := &request.Operation{
		Name:       opDeleteNodegroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}",
	}

	if input == nil {
		input = &DeleteNodegroupInput{}
	}

	output = &DeleteNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Deletes a managed node group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeleteNodegroup for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeleteNodegroup
func (c *EKS) DeleteNodegroup(input *DeleteNodegroupInput) (*DeleteNodegroupOutput, error) {
	req, out := c.DeleteNodegroupRequest(input)
	return out, req.Send()
}

// DeleteNodegroupWithContext is the same as DeleteNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeleteNodegroupWithContext(ctx aws.Context, input *DeleteNodegroupInput, opts ...request.Option) (*DeleteNodegroupOutput, error) {
	req, out := c.DeleteNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePodIdentityAssociation = "DeletePodIdentityAssociation"

// DeletePodIdentityAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeletePodIdentityAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePodIdentityAssociation for more information on using the DeletePodIdentityAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeletePodIdentityAssociationRequest method.
//	req, resp := client.DeletePodIdentityAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeletePodIdentityAssociation
func (c *EKS) DeletePodIdentityAssociationRequest(input *DeletePodIdentityAssociationInput) (req *request.Request, output *DeletePodIdentityAssociationOutput) {
	op := &request.Operation{
		Name:       opDeletePodIdentityAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/pod-identity-associations/{associationId}",
	}

	if input == nil {
		input = &DeletePodIdentityAssociationInput{}
	}

	output = &DeletePodIdentityAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeletePodIdentityAssociation API operation for Amazon Elastic Kubernetes Service.
//
// Deletes a EKS Pod Identity association.
//
// The temporary Amazon Web Services credentials from the previous IAM role
// session might still be valid until the session expiry. If you need to immediately
// revoke the temporary session credentials, then go to the role in the IAM
// console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeletePodIdentityAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeletePodIdentityAssociation
func (c *EKS) DeletePodIdentityAssociation(input *DeletePodIdentityAssociationInput) (*DeletePodIdentityAssociationOutput, error) {
	req, out := c.DeletePodIdentityAssociationRequest(input)
	return out, req.Send()
}

// DeletePodIdentityAssociationWithContext is the same as DeletePodIdentityAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePodIdentityAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeletePodIdentityAssociationWithContext(ctx aws.Context, input *DeletePodIdentityAssociationInput, opts ...request.Option) (*DeletePodIdentityAssociationOutput, error) {
	req, out := c.DeletePodIdentityAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterCluster = "DeregisterCluster"

// DeregisterClusterRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterCluster for more information on using the DeregisterCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeregisterClusterRequest method.
//	req, resp := client.DeregisterClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeregisterCluster
func (c *EKS) DeregisterClusterRequest(input *DeregisterClusterInput) (req *request.Request, output *DeregisterClusterOutput) {
	op := &request.Operation{
		Name:       opDeregisterCluster,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cluster-registrations/{name}",
	}

	if input == nil {
		input = &DeregisterClusterInput{}
	}

	output = &DeregisterClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterCluster API operation for Amazon Elastic Kubernetes Service.
//
// Deregisters a connected cluster to remove it from the Amazon EKS control
// plane.
//
// A connected cluster is a Kubernetes cluster that you've connected to your
// control plane using the Amazon EKS Connector (https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DeregisterCluster for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The IAM principal
//     (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     making the request must have at least one IAM permissions policy attached
//     that grants the required permissions. For more information, see Access management
//     (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the IAM
//     User Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DeregisterCluster
func (c *EKS) DeregisterCluster(input *DeregisterClusterInput) (*DeregisterClusterOutput, error) {
	req, out := c.DeregisterClusterRequest(input)
	return out, req.Send()
}

// DeregisterClusterWithContext is the same as DeregisterCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DeregisterClusterWithContext(ctx aws.Context, input *DeregisterClusterInput, opts ...request.Option) (*DeregisterClusterOutput, error) {
	req, out := c.DeregisterClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccessEntry = "DescribeAccessEntry"

// DescribeAccessEntryRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccessEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccessEntry for more information on using the DescribeAccessEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAccessEntryRequest method.
//	req, resp := client.DescribeAccessEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAccessEntry
func (c *EKS) DescribeAccessEntryRequest(input *DescribeAccessEntryInput) (req *request.Request, output *DescribeAccessEntryOutput) {
	op := &request.Operation{
		Name:       opDescribeAccessEntry,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/access-entries/{principalArn}",
	}

	if input == nil {
		input = &DescribeAccessEntryInput{}
	}

	output = &DescribeAccessEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccessEntry API operation for Amazon Elastic Kubernetes Service.
//
// Describes an access entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeAccessEntry for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAccessEntry
func (c *EKS) DescribeAccessEntry(input *DescribeAccessEntryInput) (*DescribeAccessEntryOutput, error) {
	req, out := c.DescribeAccessEntryRequest(input)
	return out, req.Send()
}

// DescribeAccessEntryWithContext is the same as DescribeAccessEntry with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccessEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeAccessEntryWithContext(ctx aws.Context, input *DescribeAccessEntryInput, opts ...request.Option) (*DescribeAccessEntryOutput, error) {
	req, out := c.DescribeAccessEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddon = "DescribeAddon"

// DescribeAddonRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddon for more information on using the DescribeAddon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAddonRequest method.
//	req, resp := client.DescribeAddonRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddon
func (c *EKS) DescribeAddonRequest(input *DescribeAddonInput) (req *request.Request, output *DescribeAddonOutput) {
	op := &request.Operation{
		Name:       opDescribeAddon,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/addons/{addonName}",
	}

	if input == nil {
		input = &DescribeAddonInput{}
	}

	output = &DescribeAddonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddon API operation for Amazon Elastic Kubernetes Service.
//
// Describes an Amazon EKS add-on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeAddon for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddon
func (c *EKS) DescribeAddon(input *DescribeAddonInput) (*DescribeAddonOutput, error) {
	req, out := c.DescribeAddonRequest(input)
	return out, req.Send()
}

// DescribeAddonWithContext is the same as DescribeAddon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeAddonWithContext(ctx aws.Context, input *DescribeAddonInput, opts ...request.Option) (*DescribeAddonOutput, error) {
	req, out := c.DescribeAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddonConfiguration = "DescribeAddonConfiguration"

// DescribeAddonConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddonConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddonConfiguration for more information on using the DescribeAddonConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAddonConfigurationRequest method.
//	req, resp := client.DescribeAddonConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonConfiguration
func (c *EKS) DescribeAddonConfigurationRequest(input *DescribeAddonConfigurationInput) (req *request.Request, output *DescribeAddonConfigurationOutput) {
	op := &request.Operation{
		Name:       opDescribeAddonConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/addons/configuration-schemas",
	}

	if input == nil {
		input = &DescribeAddonConfigurationInput{}
	}

	output = &DescribeAddonConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddonConfiguration API operation for Amazon Elastic Kubernetes Service.
//
// Returns configuration options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeAddonConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonConfiguration
func (c *EKS) DescribeAddonConfiguration(input *DescribeAddonConfigurationInput) (*DescribeAddonConfigurationOutput, error) {
	req, out := c.DescribeAddonConfigurationRequest(input)
	return out, req.Send()
}

// DescribeAddonConfigurationWithContext is the same as DescribeAddonConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddonConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeAddonConfigurationWithContext(ctx aws.Context, input *DescribeAddonConfigurationInput, opts ...request.Option) (*DescribeAddonConfigurationOutput, error) {
	req, out := c.DescribeAddonConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddonVersions = "DescribeAddonVersions"

// DescribeAddonVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAddonVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAddonVersions for more information on using the DescribeAddonVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAddonVersionsRequest method.
//	req, resp := client.DescribeAddonVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions
func (c *EKS) DescribeAddonVersionsRequest(input *DescribeAddonVersionsInput) (req *request.Request, output *DescribeAddonVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeAddonVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/addons/supported-versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeAddonVersionsInput{}
	}

	output = &DescribeAddonVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAddonVersions API operation for Amazon Elastic Kubernetes Service.
//
// Describes the versions for an add-on.
//
// Information such as the Kubernetes versions that you can use the add-on with,
// the owner, publisher, and the type of the add-on are returned.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeAddonVersions for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeAddonVersions
func (c *EKS) DescribeAddonVersions(input *DescribeAddonVersionsInput) (*DescribeAddonVersionsOutput, error) {
	req, out := c.DescribeAddonVersionsRequest(input)
	return out, req.Send()
}

// DescribeAddonVersionsWithContext is the same as DescribeAddonVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddonVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeAddonVersionsWithContext(ctx aws.Context, input *DescribeAddonVersionsInput, opts ...request.Option) (*DescribeAddonVersionsOutput, error) {
	req, out := c.DescribeAddonVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeAddonVersionsPages iterates over the pages of a DescribeAddonVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeAddonVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a DescribeAddonVersions operation.
//	pageNum := 0
//	err := client.DescribeAddonVersionsPages(params,
//	    func(page *eks.DescribeAddonVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) DescribeAddonVersionsPages(input *DescribeAddonVersionsInput, fn func(*DescribeAddonVersionsOutput, bool) bool) error {
	return c.DescribeAddonVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeAddonVersionsPagesWithContext same as DescribeAddonVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeAddonVersionsPagesWithContext(ctx aws.Context, input *DescribeAddonVersionsInput, fn func(*DescribeAddonVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeAddonVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeAddonVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeAddonVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCluster for more information on using the DescribeCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeClusterRequest method.
//	req, resp := client.DescribeClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster
func (c *EKS) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	output = &DescribeClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCluster API operation for Amazon Elastic Kubernetes Service.
//
// Describes an Amazon EKS cluster.
//
// The API server endpoint and certificate authority data returned by this operation
// are required for kubelet and kubectl to communicate with your Kubernetes
// API server. For more information, see Creating or updating a kubeconfig file
// for an Amazon EKS cluster (https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
//
// The API server endpoint and certificate authority data aren't available until
// the cluster reaches the ACTIVE state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeCluster for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeCluster
func (c *EKS) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	return out, req.Send()
}

// DescribeClusterWithContext is the same as DescribeCluster with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeClusterWithContext(ctx aws.Context, input *DescribeClusterInput, opts ...request.Option) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEksAnywhereSubscription = "DescribeEksAnywhereSubscription"

// DescribeEksAnywhereSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEksAnywhereSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEksAnywhereSubscription for more information on using the DescribeEksAnywhereSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEksAnywhereSubscriptionRequest method.
//	req, resp := client.DescribeEksAnywhereSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeEksAnywhereSubscription
func (c *EKS) DescribeEksAnywhereSubscriptionRequest(input *DescribeEksAnywhereSubscriptionInput) (req *request.Request, output *DescribeEksAnywhereSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDescribeEksAnywhereSubscription,
		HTTPMethod: "GET",
		HTTPPath:   "/eks-anywhere-subscriptions/{id}",
	}

	if input == nil {
		input = &DescribeEksAnywhereSubscriptionInput{}
	}

	output = &DescribeEksAnywhereSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEksAnywhereSubscription API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about a subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeEksAnywhereSubscription for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeEksAnywhereSubscription
func (c *EKS) DescribeEksAnywhereSubscription(input *DescribeEksAnywhereSubscriptionInput) (*DescribeEksAnywhereSubscriptionOutput, error) {
	req, out := c.DescribeEksAnywhereSubscriptionRequest(input)
	return out, req.Send()
}

// DescribeEksAnywhereSubscriptionWithContext is the same as DescribeEksAnywhereSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEksAnywhereSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeEksAnywhereSubscriptionWithContext(ctx aws.Context, input *DescribeEksAnywhereSubscriptionInput, opts ...request.Option) (*DescribeEksAnywhereSubscriptionOutput, error) {
	req, out := c.DescribeEksAnywhereSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFargateProfile = "DescribeFargateProfile"

// DescribeFargateProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFargateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFargateProfile for more information on using the DescribeFargateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFargateProfileRequest method.
//	req, resp := client.DescribeFargateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile
func (c *EKS) DescribeFargateProfileRequest(input *DescribeFargateProfileInput) (req *request.Request, output *DescribeFargateProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeFargateProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/fargate-profiles/{fargateProfileName}",
	}

	if input == nil {
		input = &DescribeFargateProfileInput{}
	}

	output = &DescribeFargateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFargateProfile API operation for Amazon Elastic Kubernetes Service.
//
// Describes an Fargate profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeFargateProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeFargateProfile
func (c *EKS) DescribeFargateProfile(input *DescribeFargateProfileInput) (*DescribeFargateProfileOutput, error) {
	req, out := c.DescribeFargateProfileRequest(input)
	return out, req.Send()
}

// DescribeFargateProfileWithContext is the same as DescribeFargateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFargateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeFargateProfileWithContext(ctx aws.Context, input *DescribeFargateProfileInput, opts ...request.Option) (*DescribeFargateProfileOutput, error) {
	req, out := c.DescribeFargateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIdentityProviderConfig = "DescribeIdentityProviderConfig"

// DescribeIdentityProviderConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIdentityProviderConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIdentityProviderConfig for more information on using the DescribeIdentityProviderConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeIdentityProviderConfigRequest method.
//	req, resp := client.DescribeIdentityProviderConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeIdentityProviderConfig
func (c *EKS) DescribeIdentityProviderConfigRequest(input *DescribeIdentityProviderConfigInput) (req *request.Request, output *DescribeIdentityProviderConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeIdentityProviderConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/identity-provider-configs/describe",
	}

	if input == nil {
		input = &DescribeIdentityProviderConfigInput{}
	}

	output = &DescribeIdentityProviderConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIdentityProviderConfig API operation for Amazon Elastic Kubernetes Service.
//
// Describes an identity provider configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeIdentityProviderConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeIdentityProviderConfig
func (c *EKS) DescribeIdentityProviderConfig(input *DescribeIdentityProviderConfigInput) (*DescribeIdentityProviderConfigOutput, error) {
	req, out := c.DescribeIdentityProviderConfigRequest(input)
	return out, req.Send()
}

// DescribeIdentityProviderConfigWithContext is the same as DescribeIdentityProviderConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIdentityProviderConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeIdentityProviderConfigWithContext(ctx aws.Context, input *DescribeIdentityProviderConfigInput, opts ...request.Option) (*DescribeIdentityProviderConfigOutput, error) {
	req, out := c.DescribeIdentityProviderConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInsight = "DescribeInsight"

// DescribeInsightRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInsight operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInsight for more information on using the DescribeInsight
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInsightRequest method.
//	req, resp := client.DescribeInsightRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeInsight
func (c *EKS) DescribeInsightRequest(input *DescribeInsightInput) (req *request.Request, output *DescribeInsightOutput) {
	op := &request.Operation{
		Name:       opDescribeInsight,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/insights/{id}",
	}

	if input == nil {
		input = &DescribeInsightInput{}
	}

	output = &DescribeInsightOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInsight API operation for Amazon Elastic Kubernetes Service.
//
// Returns details about an insight that you specify using its ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeInsight for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeInsight
func (c *EKS) DescribeInsight(input *DescribeInsightInput) (*DescribeInsightOutput, error) {
	req, out := c.DescribeInsightRequest(input)
	return out, req.Send()
}

// DescribeInsightWithContext is the same as DescribeInsight with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInsight for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeInsightWithContext(ctx aws.Context, input *DescribeInsightInput, opts ...request.Option) (*DescribeInsightOutput, error) {
	req, out := c.DescribeInsightRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNodegroup = "DescribeNodegroup"

// DescribeNodegroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNodegroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNodegroup for more information on using the DescribeNodegroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeNodegroupRequest method.
//	req, resp := client.DescribeNodegroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeNodegroup
func (c *EKS) DescribeNodegroupRequest(input *DescribeNodegroupInput) (req *request.Request, output *DescribeNodegroupOutput) {
	op := &request.Operation{
		Name:       opDescribeNodegroup,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}",
	}

	if input == nil {
		input = &DescribeNodegroupInput{}
	}

	output = &DescribeNodegroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNodegroup API operation for Amazon Elastic Kubernetes Service.
//
// Describes a managed node group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeNodegroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeNodegroup
func (c *EKS) DescribeNodegroup(input *DescribeNodegroupInput) (*DescribeNodegroupOutput, error) {
	req, out := c.DescribeNodegroupRequest(input)
	return out, req.Send()
}

// DescribeNodegroupWithContext is the same as DescribeNodegroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNodegroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeNodegroupWithContext(ctx aws.Context, input *DescribeNodegroupInput, opts ...request.Option) (*DescribeNodegroupOutput, error) {
	req, out := c.DescribeNodegroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePodIdentityAssociation = "DescribePodIdentityAssociation"

// DescribePodIdentityAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DescribePodIdentityAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePodIdentityAssociation for more information on using the DescribePodIdentityAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePodIdentityAssociationRequest method.
//	req, resp := client.DescribePodIdentityAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribePodIdentityAssociation
func (c *EKS) DescribePodIdentityAssociationRequest(input *DescribePodIdentityAssociationInput) (req *request.Request, output *DescribePodIdentityAssociationOutput) {
	op := &request.Operation{
		Name:       opDescribePodIdentityAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/pod-identity-associations/{associationId}",
	}

	if input == nil {
		input = &DescribePodIdentityAssociationInput{}
	}

	output = &DescribePodIdentityAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePodIdentityAssociation API operation for Amazon Elastic Kubernetes Service.
//
// Returns descriptive information about an EKS Pod Identity association.
//
// This action requires the ID of the association. You can get the ID from the
// response to the CreatePodIdentityAssocation for newly created associations.
// Or, you can list the IDs for associations with ListPodIdentityAssociations
// and filter the list by namespace or service account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribePodIdentityAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribePodIdentityAssociation
func (c *EKS) DescribePodIdentityAssociation(input *DescribePodIdentityAssociationInput) (*DescribePodIdentityAssociationOutput, error) {
	req, out := c.DescribePodIdentityAssociationRequest(input)
	return out, req.Send()
}

// DescribePodIdentityAssociationWithContext is the same as DescribePodIdentityAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePodIdentityAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribePodIdentityAssociationWithContext(ctx aws.Context, input *DescribePodIdentityAssociationInput, opts ...request.Option) (*DescribePodIdentityAssociationOutput, error) {
	req, out := c.DescribePodIdentityAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUpdate = "DescribeUpdate"

// DescribeUpdateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUpdate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUpdate for more information on using the DescribeUpdate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeUpdateRequest method.
//	req, resp := client.DescribeUpdateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeUpdate
func (c *EKS) DescribeUpdateRequest(input *DescribeUpdateInput) (req *request.Request, output *DescribeUpdateOutput) {
	op := &request.Operation{
		Name:       opDescribeUpdate,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/updates/{updateId}",
	}

	if input == nil {
		input = &DescribeUpdateInput{}
	}

	output = &DescribeUpdateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUpdate API operation for Amazon Elastic Kubernetes Service.
//
// Describes an update to an Amazon EKS resource.
//
// When the status of the update is Succeeded, the update is complete. If an
// update fails, the status is Failed, and an error detail explains the reason
// for the failure.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DescribeUpdate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DescribeUpdate
func (c *EKS) DescribeUpdate(input *DescribeUpdateInput) (*DescribeUpdateOutput, error) {
	req, out := c.DescribeUpdateRequest(input)
	return out, req.Send()
}

// DescribeUpdateWithContext is the same as DescribeUpdate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUpdate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DescribeUpdateWithContext(ctx aws.Context, input *DescribeUpdateInput, opts ...request.Option) (*DescribeUpdateOutput, error) {
	req, out := c.DescribeUpdateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAccessPolicy = "DisassociateAccessPolicy"

// DisassociateAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAccessPolicy for more information on using the DisassociateAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateAccessPolicyRequest method.
//	req, resp := client.DisassociateAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DisassociateAccessPolicy
func (c *EKS) DisassociateAccessPolicyRequest(input *DisassociateAccessPolicyInput) (req *request.Request, output *DisassociateAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDisassociateAccessPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clusters/{name}/access-entries/{principalArn}/access-policies/{policyArn}",
	}

	if input == nil {
		input = &DisassociateAccessPolicyInput{}
	}

	output = &DisassociateAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateAccessPolicy API operation for Amazon Elastic Kubernetes Service.
//
// Disassociates an access policy from an access entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DisassociateAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DisassociateAccessPolicy
func (c *EKS) DisassociateAccessPolicy(input *DisassociateAccessPolicyInput) (*DisassociateAccessPolicyOutput, error) {
	req, out := c.DisassociateAccessPolicyRequest(input)
	return out, req.Send()
}

// DisassociateAccessPolicyWithContext is the same as DisassociateAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DisassociateAccessPolicyWithContext(ctx aws.Context, input *DisassociateAccessPolicyInput, opts ...request.Option) (*DisassociateAccessPolicyOutput, error) {
	req, out := c.DisassociateAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateIdentityProviderConfig = "DisassociateIdentityProviderConfig"

// DisassociateIdentityProviderConfigRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateIdentityProviderConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateIdentityProviderConfig for more information on using the DisassociateIdentityProviderConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateIdentityProviderConfigRequest method.
//	req, resp := client.DisassociateIdentityProviderConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DisassociateIdentityProviderConfig
func (c *EKS) DisassociateIdentityProviderConfigRequest(input *DisassociateIdentityProviderConfigInput) (req *request.Request, output *DisassociateIdentityProviderConfigOutput) {
	op := &request.Operation{
		Name:       opDisassociateIdentityProviderConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/identity-provider-configs/disassociate",
	}

	if input == nil {
		input = &DisassociateIdentityProviderConfigInput{}
	}

	output = &DisassociateIdentityProviderConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateIdentityProviderConfig API operation for Amazon Elastic Kubernetes Service.
//
// Disassociates an identity provider configuration from a cluster.
//
// If you disassociate an identity provider from your cluster, users included
// in the provider can no longer access the cluster. However, you can still
// access the cluster with IAM principals.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation DisassociateIdentityProviderConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/DisassociateIdentityProviderConfig
func (c *EKS) DisassociateIdentityProviderConfig(input *DisassociateIdentityProviderConfigInput) (*DisassociateIdentityProviderConfigOutput, error) {
	req, out := c.DisassociateIdentityProviderConfigRequest(input)
	return out, req.Send()
}

// DisassociateIdentityProviderConfigWithContext is the same as DisassociateIdentityProviderConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateIdentityProviderConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) DisassociateIdentityProviderConfigWithContext(ctx aws.Context, input *DisassociateIdentityProviderConfigInput, opts ...request.Option) (*DisassociateIdentityProviderConfigOutput, error) {
	req, out := c.DisassociateIdentityProviderConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAccessEntries = "ListAccessEntries"

// ListAccessEntriesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessEntries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessEntries for more information on using the ListAccessEntries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessEntriesRequest method.
//	req, resp := client.ListAccessEntriesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAccessEntries
func (c *EKS) ListAccessEntriesRequest(input *ListAccessEntriesInput) (req *request.Request, output *ListAccessEntriesOutput) {
	op := &request.Operation{
		Name:       opListAccessEntries,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/access-entries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessEntriesInput{}
	}

	output = &ListAccessEntriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccessEntries API operation for Amazon Elastic Kubernetes Service.
//
// Lists the access entries for your cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListAccessEntries for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAccessEntries
func (c *EKS) ListAccessEntries(input *ListAccessEntriesInput) (*ListAccessEntriesOutput, error) {
	req, out := c.ListAccessEntriesRequest(input)
	return out, req.Send()
}

// ListAccessEntriesWithContext is the same as ListAccessEntries with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessEntries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAccessEntriesWithContext(ctx aws.Context, input *ListAccessEntriesInput, opts ...request.Option) (*ListAccessEntriesOutput, error) {
	req, out := c.ListAccessEntriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessEntriesPages iterates over the pages of a ListAccessEntries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessEntries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessEntries operation.
//	pageNum := 0
//	err := client.ListAccessEntriesPages(params,
//	    func(page *eks.ListAccessEntriesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListAccessEntriesPages(input *ListAccessEntriesInput, fn func(*ListAccessEntriesOutput, bool) bool) error {
	return c.ListAccessEntriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessEntriesPagesWithContext same as ListAccessEntriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAccessEntriesPagesWithContext(ctx aws.Context, input *ListAccessEntriesInput, fn func(*ListAccessEntriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessEntriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessEntriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessEntriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAccessPolicies = "ListAccessPolicies"

// ListAccessPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAccessPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAccessPolicies for more information on using the ListAccessPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAccessPoliciesRequest method.
//	req, resp := client.ListAccessPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAccessPolicies
func (c *EKS) ListAccessPoliciesRequest(input *ListAccessPoliciesInput) (req *request.Request, output *ListAccessPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAccessPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/access-policies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAccessPoliciesInput{}
	}

	output = &ListAccessPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAccessPolicies API operation for Amazon Elastic Kubernetes Service.
//
// Lists the available access policies.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListAccessPolicies for usage and error information.
//
// Returned Error Types:
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAccessPolicies
func (c *EKS) ListAccessPolicies(input *ListAccessPoliciesInput) (*ListAccessPoliciesOutput, error) {
	req, out := c.ListAccessPoliciesRequest(input)
	return out, req.Send()
}

// ListAccessPoliciesWithContext is the same as ListAccessPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListAccessPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAccessPoliciesWithContext(ctx aws.Context, input *ListAccessPoliciesInput, opts ...request.Option) (*ListAccessPoliciesOutput, error) {
	req, out := c.ListAccessPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAccessPoliciesPages iterates over the pages of a ListAccessPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAccessPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAccessPolicies operation.
//	pageNum := 0
//	err := client.ListAccessPoliciesPages(params,
//	    func(page *eks.ListAccessPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListAccessPoliciesPages(input *ListAccessPoliciesInput, fn func(*ListAccessPoliciesOutput, bool) bool) error {
	return c.ListAccessPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAccessPoliciesPagesWithContext same as ListAccessPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAccessPoliciesPagesWithContext(ctx aws.Context, input *ListAccessPoliciesInput, fn func(*ListAccessPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAccessPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAccessPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAccessPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAddons = "ListAddons"

// ListAddonsRequest generates a "aws/request.Request" representing the
// client's request for the ListAddons operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAddons for more information on using the ListAddons
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAddonsRequest method.
//	req, resp := client.ListAddonsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAddons
func (c *EKS) ListAddonsRequest(input *ListAddonsInput) (req *request.Request, output *ListAddonsOutput) {
	op := &request.Operation{
		Name:       opListAddons,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/addons",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAddonsInput{}
	}

	output = &ListAddonsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAddons API operation for Amazon Elastic Kubernetes Service.
//
// Lists the installed add-ons.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListAddons for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAddons
func (c *EKS) ListAddons(input *ListAddonsInput) (*ListAddonsOutput, error) {
	req, out := c.ListAddonsRequest(input)
	return out, req.Send()
}

// ListAddonsWithContext is the same as ListAddons with the addition of
// the ability to pass a context and additional request options.
//
// See ListAddons for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAddonsWithContext(ctx aws.Context, input *ListAddonsInput, opts ...request.Option) (*ListAddonsOutput, error) {
	req, out := c.ListAddonsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAddonsPages iterates over the pages of a ListAddons operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAddons method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAddons operation.
//	pageNum := 0
//	err := client.ListAddonsPages(params,
//	    func(page *eks.ListAddonsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListAddonsPages(input *ListAddonsInput, fn func(*ListAddonsOutput, bool) bool) error {
	return c.ListAddonsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAddonsPagesWithContext same as ListAddonsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAddonsPagesWithContext(ctx aws.Context, input *ListAddonsInput, fn func(*ListAddonsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAddonsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAddonsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAddonsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssociatedAccessPolicies = "ListAssociatedAccessPolicies"

// ListAssociatedAccessPoliciesRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedAccessPolicies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedAccessPolicies for more information on using the ListAssociatedAccessPolicies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAssociatedAccessPoliciesRequest method.
//	req, resp := client.ListAssociatedAccessPoliciesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAssociatedAccessPolicies
func (c *EKS) ListAssociatedAccessPoliciesRequest(input *ListAssociatedAccessPoliciesInput) (req *request.Request, output *ListAssociatedAccessPoliciesOutput) {
	op := &request.Operation{
		Name:       opListAssociatedAccessPolicies,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/access-entries/{principalArn}/access-policies",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociatedAccessPoliciesInput{}
	}

	output = &ListAssociatedAccessPoliciesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedAccessPolicies API operation for Amazon Elastic Kubernetes Service.
//
// Lists the access policies associated with an access entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListAssociatedAccessPolicies for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListAssociatedAccessPolicies
func (c *EKS) ListAssociatedAccessPolicies(input *ListAssociatedAccessPoliciesInput) (*ListAssociatedAccessPoliciesOutput, error) {
	req, out := c.ListAssociatedAccessPoliciesRequest(input)
	return out, req.Send()
}

// ListAssociatedAccessPoliciesWithContext is the same as ListAssociatedAccessPolicies with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedAccessPolicies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAssociatedAccessPoliciesWithContext(ctx aws.Context, input *ListAssociatedAccessPoliciesInput, opts ...request.Option) (*ListAssociatedAccessPoliciesOutput, error) {
	req, out := c.ListAssociatedAccessPoliciesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociatedAccessPoliciesPages iterates over the pages of a ListAssociatedAccessPolicies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociatedAccessPolicies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAssociatedAccessPolicies operation.
//	pageNum := 0
//	err := client.ListAssociatedAccessPoliciesPages(params,
//	    func(page *eks.ListAssociatedAccessPoliciesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListAssociatedAccessPoliciesPages(input *ListAssociatedAccessPoliciesInput, fn func(*ListAssociatedAccessPoliciesOutput, bool) bool) error {
	return c.ListAssociatedAccessPoliciesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociatedAccessPoliciesPagesWithContext same as ListAssociatedAccessPoliciesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListAssociatedAccessPoliciesPagesWithContext(ctx aws.Context, input *ListAssociatedAccessPoliciesInput, fn func(*ListAssociatedAccessPoliciesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociatedAccessPoliciesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociatedAccessPoliciesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociatedAccessPoliciesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a "aws/request.Request" representing the
// client's request for the ListClusters operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListClusters for more information on using the ListClusters
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListClustersRequest method.
//	req, resp := client.ListClustersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters
func (c *EKS) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	output = &ListClustersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListClusters API operation for Amazon Elastic Kubernetes Service.
//
// Lists the Amazon EKS clusters in your Amazon Web Services account in the
// specified Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListClusters for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListClusters
func (c *EKS) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	return out, req.Send()
}

// ListClustersWithContext is the same as ListClusters with the addition of
// the ability to pass a context and additional request options.
//
// See ListClusters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListClustersWithContext(ctx aws.Context, input *ListClustersInput, opts ...request.Option) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListClustersPages iterates over the pages of a ListClusters operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListClusters method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListClusters operation.
//	pageNum := 0
//	err := client.ListClustersPages(params,
//	    func(page *eks.ListClustersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListClustersPages(input *ListClustersInput, fn func(*ListClustersOutput, bool) bool) error {
	return c.ListClustersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListClustersPagesWithContext same as ListClustersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListClustersPagesWithContext(ctx aws.Context, input *ListClustersInput, fn func(*ListClustersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListClustersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListClustersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListClustersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEksAnywhereSubscriptions = "ListEksAnywhereSubscriptions"

// ListEksAnywhereSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEksAnywhereSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEksAnywhereSubscriptions for more information on using the ListEksAnywhereSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEksAnywhereSubscriptionsRequest method.
//	req, resp := client.ListEksAnywhereSubscriptionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListEksAnywhereSubscriptions
func (c *EKS) ListEksAnywhereSubscriptionsRequest(input *ListEksAnywhereSubscriptionsInput) (req *request.Request, output *ListEksAnywhereSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListEksAnywhereSubscriptions,
		HTTPMethod: "GET",
		HTTPPath:   "/eks-anywhere-subscriptions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEksAnywhereSubscriptionsInput{}
	}

	output = &ListEksAnywhereSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEksAnywhereSubscriptions API operation for Amazon Elastic Kubernetes Service.
//
// Displays the full description of the subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListEksAnywhereSubscriptions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListEksAnywhereSubscriptions
func (c *EKS) ListEksAnywhereSubscriptions(input *ListEksAnywhereSubscriptionsInput) (*ListEksAnywhereSubscriptionsOutput, error) {
	req, out := c.ListEksAnywhereSubscriptionsRequest(input)
	return out, req.Send()
}

// ListEksAnywhereSubscriptionsWithContext is the same as ListEksAnywhereSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEksAnywhereSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListEksAnywhereSubscriptionsWithContext(ctx aws.Context, input *ListEksAnywhereSubscriptionsInput, opts ...request.Option) (*ListEksAnywhereSubscriptionsOutput, error) {
	req, out := c.ListEksAnywhereSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEksAnywhereSubscriptionsPages iterates over the pages of a ListEksAnywhereSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEksAnywhereSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEksAnywhereSubscriptions operation.
//	pageNum := 0
//	err := client.ListEksAnywhereSubscriptionsPages(params,
//	    func(page *eks.ListEksAnywhereSubscriptionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListEksAnywhereSubscriptionsPages(input *ListEksAnywhereSubscriptionsInput, fn func(*ListEksAnywhereSubscriptionsOutput, bool) bool) error {
	return c.ListEksAnywhereSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEksAnywhereSubscriptionsPagesWithContext same as ListEksAnywhereSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListEksAnywhereSubscriptionsPagesWithContext(ctx aws.Context, input *ListEksAnywhereSubscriptionsInput, fn func(*ListEksAnywhereSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEksAnywhereSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEksAnywhereSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEksAnywhereSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFargateProfiles = "ListFargateProfiles"

// ListFargateProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListFargateProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFargateProfiles for more information on using the ListFargateProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFargateProfilesRequest method.
//	req, resp := client.ListFargateProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles
func (c *EKS) ListFargateProfilesRequest(input *ListFargateProfilesInput) (req *request.Request, output *ListFargateProfilesOutput) {
	op := &request.Operation{
		Name:       opListFargateProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/fargate-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFargateProfilesInput{}
	}

	output = &ListFargateProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFargateProfiles API operation for Amazon Elastic Kubernetes Service.
//
// Lists the Fargate profiles associated with the specified cluster in your
// Amazon Web Services account in the specified Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListFargateProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListFargateProfiles
func (c *EKS) ListFargateProfiles(input *ListFargateProfilesInput) (*ListFargateProfilesOutput, error) {
	req, out := c.ListFargateProfilesRequest(input)
	return out, req.Send()
}

// ListFargateProfilesWithContext is the same as ListFargateProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListFargateProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListFargateProfilesWithContext(ctx aws.Context, input *ListFargateProfilesInput, opts ...request.Option) (*ListFargateProfilesOutput, error) {
	req, out := c.ListFargateProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFargateProfilesPages iterates over the pages of a ListFargateProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFargateProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFargateProfiles operation.
//	pageNum := 0
//	err := client.ListFargateProfilesPages(params,
//	    func(page *eks.ListFargateProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListFargateProfilesPages(input *ListFargateProfilesInput, fn func(*ListFargateProfilesOutput, bool) bool) error {
	return c.ListFargateProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFargateProfilesPagesWithContext same as ListFargateProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListFargateProfilesPagesWithContext(ctx aws.Context, input *ListFargateProfilesInput, fn func(*ListFargateProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFargateProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFargateProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFargateProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIdentityProviderConfigs = "ListIdentityProviderConfigs"

// ListIdentityProviderConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListIdentityProviderConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIdentityProviderConfigs for more information on using the ListIdentityProviderConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIdentityProviderConfigsRequest method.
//	req, resp := client.ListIdentityProviderConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListIdentityProviderConfigs
func (c *EKS) ListIdentityProviderConfigsRequest(input *ListIdentityProviderConfigsInput) (req *request.Request, output *ListIdentityProviderConfigsOutput) {
	op := &request.Operation{
		Name:       opListIdentityProviderConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/identity-provider-configs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIdentityProviderConfigsInput{}
	}

	output = &ListIdentityProviderConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIdentityProviderConfigs API operation for Amazon Elastic Kubernetes Service.
//
// Lists the identity provider configurations for your cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListIdentityProviderConfigs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListIdentityProviderConfigs
func (c *EKS) ListIdentityProviderConfigs(input *ListIdentityProviderConfigsInput) (*ListIdentityProviderConfigsOutput, error) {
	req, out := c.ListIdentityProviderConfigsRequest(input)
	return out, req.Send()
}

// ListIdentityProviderConfigsWithContext is the same as ListIdentityProviderConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListIdentityProviderConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListIdentityProviderConfigsWithContext(ctx aws.Context, input *ListIdentityProviderConfigsInput, opts ...request.Option) (*ListIdentityProviderConfigsOutput, error) {
	req, out := c.ListIdentityProviderConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIdentityProviderConfigsPages iterates over the pages of a ListIdentityProviderConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIdentityProviderConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIdentityProviderConfigs operation.
//	pageNum := 0
//	err := client.ListIdentityProviderConfigsPages(params,
//	    func(page *eks.ListIdentityProviderConfigsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListIdentityProviderConfigsPages(input *ListIdentityProviderConfigsInput, fn func(*ListIdentityProviderConfigsOutput, bool) bool) error {
	return c.ListIdentityProviderConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIdentityProviderConfigsPagesWithContext same as ListIdentityProviderConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListIdentityProviderConfigsPagesWithContext(ctx aws.Context, input *ListIdentityProviderConfigsInput, fn func(*ListIdentityProviderConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIdentityProviderConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIdentityProviderConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIdentityProviderConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInsights = "ListInsights"

// ListInsightsRequest generates a "aws/request.Request" representing the
// client's request for the ListInsights operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInsights for more information on using the ListInsights
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInsightsRequest method.
//	req, resp := client.ListInsightsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListInsights
func (c *EKS) ListInsightsRequest(input *ListInsightsInput) (req *request.Request, output *ListInsightsOutput) {
	op := &request.Operation{
		Name:       opListInsights,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/insights",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInsightsInput{}
	}

	output = &ListInsightsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInsights API operation for Amazon Elastic Kubernetes Service.
//
// Returns a list of all insights checked for against the specified cluster.
// You can filter which insights are returned by category, associated Kubernetes
// version, and status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListInsights for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListInsights
func (c *EKS) ListInsights(input *ListInsightsInput) (*ListInsightsOutput, error) {
	req, out := c.ListInsightsRequest(input)
	return out, req.Send()
}

// ListInsightsWithContext is the same as ListInsights with the addition of
// the ability to pass a context and additional request options.
//
// See ListInsights for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListInsightsWithContext(ctx aws.Context, input *ListInsightsInput, opts ...request.Option) (*ListInsightsOutput, error) {
	req, out := c.ListInsightsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInsightsPages iterates over the pages of a ListInsights operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInsights method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInsights operation.
//	pageNum := 0
//	err := client.ListInsightsPages(params,
//	    func(page *eks.ListInsightsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListInsightsPages(input *ListInsightsInput, fn func(*ListInsightsOutput, bool) bool) error {
	return c.ListInsightsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInsightsPagesWithContext same as ListInsightsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListInsightsPagesWithContext(ctx aws.Context, input *ListInsightsInput, fn func(*ListInsightsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInsightsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInsightsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInsightsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNodegroups = "ListNodegroups"

// ListNodegroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListNodegroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNodegroups for more information on using the ListNodegroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNodegroupsRequest method.
//	req, resp := client.ListNodegroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups
func (c *EKS) ListNodegroupsRequest(input *ListNodegroupsInput) (req *request.Request, output *ListNodegroupsOutput) {
	op := &request.Operation{
		Name:       opListNodegroups,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/node-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNodegroupsInput{}
	}

	output = &ListNodegroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNodegroups API operation for Amazon Elastic Kubernetes Service.
//
// Lists the managed node groups associated with the specified cluster in your
// Amazon Web Services account in the specified Amazon Web Services Region.
// Self-managed node groups aren't listed.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListNodegroups for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListNodegroups
func (c *EKS) ListNodegroups(input *ListNodegroupsInput) (*ListNodegroupsOutput, error) {
	req, out := c.ListNodegroupsRequest(input)
	return out, req.Send()
}

// ListNodegroupsWithContext is the same as ListNodegroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListNodegroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListNodegroupsWithContext(ctx aws.Context, input *ListNodegroupsInput, opts ...request.Option) (*ListNodegroupsOutput, error) {
	req, out := c.ListNodegroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNodegroupsPages iterates over the pages of a ListNodegroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNodegroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNodegroups operation.
//	pageNum := 0
//	err := client.ListNodegroupsPages(params,
//	    func(page *eks.ListNodegroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListNodegroupsPages(input *ListNodegroupsInput, fn func(*ListNodegroupsOutput, bool) bool) error {
	return c.ListNodegroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNodegroupsPagesWithContext same as ListNodegroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListNodegroupsPagesWithContext(ctx aws.Context, input *ListNodegroupsInput, fn func(*ListNodegroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNodegroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNodegroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNodegroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPodIdentityAssociations = "ListPodIdentityAssociations"

// ListPodIdentityAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListPodIdentityAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPodIdentityAssociations for more information on using the ListPodIdentityAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPodIdentityAssociationsRequest method.
//	req, resp := client.ListPodIdentityAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListPodIdentityAssociations
func (c *EKS) ListPodIdentityAssociationsRequest(input *ListPodIdentityAssociationsInput) (req *request.Request, output *ListPodIdentityAssociationsOutput) {
	op := &request.Operation{
		Name:       opListPodIdentityAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/pod-identity-associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPodIdentityAssociationsInput{}
	}

	output = &ListPodIdentityAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPodIdentityAssociations API operation for Amazon Elastic Kubernetes Service.
//
// List the EKS Pod Identity associations in a cluster. You can filter the list
// by the namespace that the association is in or the service account that the
// association uses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListPodIdentityAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListPodIdentityAssociations
func (c *EKS) ListPodIdentityAssociations(input *ListPodIdentityAssociationsInput) (*ListPodIdentityAssociationsOutput, error) {
	req, out := c.ListPodIdentityAssociationsRequest(input)
	return out, req.Send()
}

// ListPodIdentityAssociationsWithContext is the same as ListPodIdentityAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListPodIdentityAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListPodIdentityAssociationsWithContext(ctx aws.Context, input *ListPodIdentityAssociationsInput, opts ...request.Option) (*ListPodIdentityAssociationsOutput, error) {
	req, out := c.ListPodIdentityAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPodIdentityAssociationsPages iterates over the pages of a ListPodIdentityAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPodIdentityAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPodIdentityAssociations operation.
//	pageNum := 0
//	err := client.ListPodIdentityAssociationsPages(params,
//	    func(page *eks.ListPodIdentityAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListPodIdentityAssociationsPages(input *ListPodIdentityAssociationsInput, fn func(*ListPodIdentityAssociationsOutput, bool) bool) error {
	return c.ListPodIdentityAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPodIdentityAssociationsPagesWithContext same as ListPodIdentityAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListPodIdentityAssociationsPagesWithContext(ctx aws.Context, input *ListPodIdentityAssociationsInput, fn func(*ListPodIdentityAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPodIdentityAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPodIdentityAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPodIdentityAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListTagsForResource
func (c *EKS) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Elastic Kubernetes Service.
//
// List the tags for an Amazon EKS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     This exception is thrown if the request contains a semantic error. The precise
//     meaning will depend on the API, and will be documented in the error message.
//
//   - NotFoundException
//     A service resource associated with the request could not be found. Clients
//     should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListTagsForResource
func (c *EKS) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUpdates = "ListUpdates"

// ListUpdatesRequest generates a "aws/request.Request" representing the
// client's request for the ListUpdates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUpdates for more information on using the ListUpdates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUpdatesRequest method.
//	req, resp := client.ListUpdatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates
func (c *EKS) ListUpdatesRequest(input *ListUpdatesInput) (req *request.Request, output *ListUpdatesOutput) {
	op := &request.Operation{
		Name:       opListUpdates,
		HTTPMethod: "GET",
		HTTPPath:   "/clusters/{name}/updates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUpdatesInput{}
	}

	output = &ListUpdatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUpdates API operation for Amazon Elastic Kubernetes Service.
//
// Lists the updates associated with an Amazon EKS resource in your Amazon Web
// Services account, in the specified Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation ListUpdates for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/ListUpdates
func (c *EKS) ListUpdates(input *ListUpdatesInput) (*ListUpdatesOutput, error) {
	req, out := c.ListUpdatesRequest(input)
	return out, req.Send()
}

// ListUpdatesWithContext is the same as ListUpdates with the addition of
// the ability to pass a context and additional request options.
//
// See ListUpdates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListUpdatesWithContext(ctx aws.Context, input *ListUpdatesInput, opts ...request.Option) (*ListUpdatesOutput, error) {
	req, out := c.ListUpdatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUpdatesPages iterates over the pages of a ListUpdates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUpdates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUpdates operation.
//	pageNum := 0
//	err := client.ListUpdatesPages(params,
//	    func(page *eks.ListUpdatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *EKS) ListUpdatesPages(input *ListUpdatesInput, fn func(*ListUpdatesOutput, bool) bool) error {
	return c.ListUpdatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUpdatesPagesWithContext same as ListUpdatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) ListUpdatesPagesWithContext(ctx aws.Context, input *ListUpdatesInput, fn func(*ListUpdatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUpdatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUpdatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUpdatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRegisterCluster = "RegisterCluster"

// RegisterClusterRequest generates a "aws/request.Request" representing the
// client's request for the RegisterCluster operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterCluster for more information on using the RegisterCluster
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RegisterClusterRequest method.
//	req, resp := client.RegisterClusterRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/RegisterCluster
func (c *EKS) RegisterClusterRequest(input *RegisterClusterInput) (req *request.Request, output *RegisterClusterOutput) {
	op := &request.Operation{
		Name:       opRegisterCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/cluster-registrations",
	}

	if input == nil {
		input = &RegisterClusterInput{}
	}

	output = &RegisterClusterOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterCluster API operation for Amazon Elastic Kubernetes Service.
//
// Connects a Kubernetes cluster to the Amazon EKS control plane.
//
// Any Kubernetes cluster can be connected to the Amazon EKS control plane to
// view current information about the cluster and its nodes.
//
// Cluster connection requires two steps. First, send a RegisterClusterRequest
// to add it to the Amazon EKS control plane.
//
// Second, a Manifest (https://amazon-eks.s3.us-west-2.amazonaws.com/eks-connector/manifests/eks-connector/latest/eks-connector.yaml)
// containing the activationID and activationCode must be applied to the Kubernetes
// cluster through it's native provider to provide visibility.
//
// After the manifest is updated and applied, the connected cluster is visible
// to the Amazon EKS control plane. If the manifest isn't applied within three
// days, the connected cluster will no longer be visible and must be deregistered
// using DeregisterCluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation RegisterCluster for usage and error information.
//
// Returned Error Types:
//
//   - ResourceLimitExceededException
//     You have encountered a service limit on the specified resource.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation.
//
//   - AccessDeniedException
//     You don't have permissions to perform the requested operation. The IAM principal
//     (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     making the request must have at least one IAM permissions policy attached
//     that grants the required permissions. For more information, see Access management
//     (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the IAM
//     User Guide.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourcePropagationDelayException
//     Required resources (such as service-linked roles) were created and are still
//     propagating. Retry later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/RegisterCluster
func (c *EKS) RegisterCluster(input *RegisterClusterInput) (*RegisterClusterOutput, error) {
	req, out := c.RegisterClusterRequest(input)
	return out, req.Send()
}

// RegisterClusterWithContext is the same as RegisterCluster with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterCluster for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) RegisterClusterWithContext(ctx aws.Context, input *RegisterClusterInput, opts ...request.Option) (*RegisterClusterOutput, error) {
	req, out := c.RegisterClusterRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/TagResource
func (c *EKS) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Elastic Kubernetes Service.
//
// Associates the specified tags to an Amazon EKS resource with the specified
// resourceArn. If existing tags on a resource are not specified in the request
// parameters, they aren't changed. When a resource is deleted, the tags associated
// with that resource are also deleted. Tags that you create for Amazon EKS
// resources don't propagate to any other resources associated with the cluster.
// For example, if you tag a cluster with this operation, that tag doesn't automatically
// propagate to the subnets and nodes associated with the cluster.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     This exception is thrown if the request contains a semantic error. The precise
//     meaning will depend on the API, and will be documented in the error message.
//
//   - NotFoundException
//     A service resource associated with the request could not be found. Clients
//     should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/TagResource
func (c *EKS) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UntagResource
func (c *EKS) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Elastic Kubernetes Service.
//
// Deletes specified tags from an Amazon EKS resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - BadRequestException
//     This exception is thrown if the request contains a semantic error. The precise
//     meaning will depend on the API, and will be documented in the error message.
//
//   - NotFoundException
//     A service resource associated with the request could not be found. Clients
//     should not retry such requests.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UntagResource
func (c *EKS) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccessEntry = "UpdateAccessEntry"

// UpdateAccessEntryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccessEntry operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccessEntry for more information on using the UpdateAccessEntry
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAccessEntryRequest method.
//	req, resp := client.UpdateAccessEntryRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateAccessEntry
func (c *EKS) UpdateAccessEntryRequest(input *UpdateAccessEntryInput) (req *request.Request, output *UpdateAccessEntryOutput) {
	op := &request.Operation{
		Name:       opUpdateAccessEntry,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/access-entries/{principalArn}",
	}

	if input == nil {
		input = &UpdateAccessEntryInput{}
	}

	output = &UpdateAccessEntryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccessEntry API operation for Amazon Elastic Kubernetes Service.
//
// Updates an access entry.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateAccessEntry for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateAccessEntry
func (c *EKS) UpdateAccessEntry(input *UpdateAccessEntryInput) (*UpdateAccessEntryOutput, error) {
	req, out := c.UpdateAccessEntryRequest(input)
	return out, req.Send()
}

// UpdateAccessEntryWithContext is the same as UpdateAccessEntry with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccessEntry for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateAccessEntryWithContext(ctx aws.Context, input *UpdateAccessEntryInput, opts ...request.Option) (*UpdateAccessEntryOutput, error) {
	req, out := c.UpdateAccessEntryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAddon = "UpdateAddon"

// UpdateAddonRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAddon operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAddon for more information on using the UpdateAddon
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAddonRequest method.
//	req, resp := client.UpdateAddonRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateAddon
func (c *EKS) UpdateAddonRequest(input *UpdateAddonInput) (req *request.Request, output *UpdateAddonOutput) {
	op := &request.Operation{
		Name:       opUpdateAddon,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/addons/{addonName}/update",
	}

	if input == nil {
		input = &UpdateAddonInput{}
	}

	output = &UpdateAddonOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAddon API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS add-on.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateAddon for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateAddon
func (c *EKS) UpdateAddon(input *UpdateAddonInput) (*UpdateAddonOutput, error) {
	req, out := c.UpdateAddonRequest(input)
	return out, req.Send()
}

// UpdateAddonWithContext is the same as UpdateAddon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAddon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateAddonWithContext(ctx aws.Context, input *UpdateAddonInput, opts ...request.Option) (*UpdateAddonOutput, error) {
	req, out := c.UpdateAddonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterConfig = "UpdateClusterConfig"

// UpdateClusterConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterConfig for more information on using the UpdateClusterConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterConfigRequest method.
//	req, resp := client.UpdateClusterConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterConfig
func (c *EKS) UpdateClusterConfigRequest(input *UpdateClusterConfigInput) (req *request.Request, output *UpdateClusterConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/update-config",
	}

	if input == nil {
		input = &UpdateClusterConfigInput{}
	}

	output = &UpdateClusterConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterConfig API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS cluster configuration. Your cluster continues to function
// during the update. The response output includes an update ID that you can
// use to track the status of your cluster update with DescribeUpdate"/>.
//
// You can use this API operation to enable or disable exporting the Kubernetes
// control plane logs for your cluster to CloudWatch Logs. By default, cluster
// control plane logs aren't exported to CloudWatch Logs. For more information,
// see Amazon EKS Cluster control plane logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
// in the Amazon EKS User Guide .
//
// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
// to exported control plane logs. For more information, see CloudWatch Pricing
// (http://aws.amazon.com/cloudwatch/pricing/).
//
// You can also use this API operation to enable or disable public and private
// access to your cluster's Kubernetes API server endpoint. By default, public
// access is enabled, and private access is disabled. For more information,
// see Amazon EKS cluster endpoint access control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
// in the Amazon EKS User Guide .
//
// You can also use this API operation to choose different subnets and security
// groups for the cluster. You must specify at least two subnets that are in
// different Availability Zones. You can't change which VPC the subnets are
// from, the subnets must be in the same VPC as the subnets that the cluster
// was created with. For more information about the VPC requirements, see https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html
// (https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html) in the
// Amazon EKS User Guide .
//
// Cluster updates are asynchronous, and they should finish within a few minutes.
// During an update, the cluster status moves to UPDATING (this status transition
// is eventually consistent). When the update is complete (either Failed or
// Successful), the cluster status moves to Active.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateClusterConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterConfig
func (c *EKS) UpdateClusterConfig(input *UpdateClusterConfigInput) (*UpdateClusterConfigOutput, error) {
	req, out := c.UpdateClusterConfigRequest(input)
	return out, req.Send()
}

// UpdateClusterConfigWithContext is the same as UpdateClusterConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateClusterConfigWithContext(ctx aws.Context, input *UpdateClusterConfigInput, opts ...request.Option) (*UpdateClusterConfigOutput, error) {
	req, out := c.UpdateClusterConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClusterVersion = "UpdateClusterVersion"

// UpdateClusterVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClusterVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClusterVersion for more information on using the UpdateClusterVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateClusterVersionRequest method.
//	req, resp := client.UpdateClusterVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion
func (c *EKS) UpdateClusterVersionRequest(input *UpdateClusterVersionInput) (req *request.Request, output *UpdateClusterVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateClusterVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/updates",
	}

	if input == nil {
		input = &UpdateClusterVersionInput{}
	}

	output = &UpdateClusterVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClusterVersion API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS cluster to the specified Kubernetes version. Your cluster
// continues to function during the update. The response output includes an
// update ID that you can use to track the status of your cluster update with
// the DescribeUpdate API operation.
//
// Cluster updates are asynchronous, and they should finish within a few minutes.
// During an update, the cluster status moves to UPDATING (this status transition
// is eventually consistent). When the update is complete (either Failed or
// Successful), the cluster status moves to Active.
//
// If your cluster has managed node groups attached to it, all of your node
// groups’ Kubernetes versions must match the cluster’s Kubernetes version
// in order to update the cluster to a new Kubernetes version.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateClusterVersion for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateClusterVersion
func (c *EKS) UpdateClusterVersion(input *UpdateClusterVersionInput) (*UpdateClusterVersionOutput, error) {
	req, out := c.UpdateClusterVersionRequest(input)
	return out, req.Send()
}

// UpdateClusterVersionWithContext is the same as UpdateClusterVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClusterVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateClusterVersionWithContext(ctx aws.Context, input *UpdateClusterVersionInput, opts ...request.Option) (*UpdateClusterVersionOutput, error) {
	req, out := c.UpdateClusterVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEksAnywhereSubscription = "UpdateEksAnywhereSubscription"

// UpdateEksAnywhereSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEksAnywhereSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEksAnywhereSubscription for more information on using the UpdateEksAnywhereSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEksAnywhereSubscriptionRequest method.
//	req, resp := client.UpdateEksAnywhereSubscriptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateEksAnywhereSubscription
func (c *EKS) UpdateEksAnywhereSubscriptionRequest(input *UpdateEksAnywhereSubscriptionInput) (req *request.Request, output *UpdateEksAnywhereSubscriptionOutput) {
	op := &request.Operation{
		Name:       opUpdateEksAnywhereSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/eks-anywhere-subscriptions/{id}",
	}

	if input == nil {
		input = &UpdateEksAnywhereSubscriptionInput{}
	}

	output = &UpdateEksAnywhereSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEksAnywhereSubscription API operation for Amazon Elastic Kubernetes Service.
//
// Update an EKS Anywhere Subscription. Only auto renewal and tags can be updated
// after subscription creation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateEksAnywhereSubscription for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateEksAnywhereSubscription
func (c *EKS) UpdateEksAnywhereSubscription(input *UpdateEksAnywhereSubscriptionInput) (*UpdateEksAnywhereSubscriptionOutput, error) {
	req, out := c.UpdateEksAnywhereSubscriptionRequest(input)
	return out, req.Send()
}

// UpdateEksAnywhereSubscriptionWithContext is the same as UpdateEksAnywhereSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEksAnywhereSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateEksAnywhereSubscriptionWithContext(ctx aws.Context, input *UpdateEksAnywhereSubscriptionInput, opts ...request.Option) (*UpdateEksAnywhereSubscriptionOutput, error) {
	req, out := c.UpdateEksAnywhereSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNodegroupConfig = "UpdateNodegroupConfig"

// UpdateNodegroupConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNodegroupConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNodegroupConfig for more information on using the UpdateNodegroupConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateNodegroupConfigRequest method.
//	req, resp := client.UpdateNodegroupConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig
func (c *EKS) UpdateNodegroupConfigRequest(input *UpdateNodegroupConfigInput) (req *request.Request, output *UpdateNodegroupConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateNodegroupConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}/update-config",
	}

	if input == nil {
		input = &UpdateNodegroupConfigInput{}
	}

	output = &UpdateNodegroupConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNodegroupConfig API operation for Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS managed node group configuration. Your node group continues
// to function during the update. The response output includes an update ID
// that you can use to track the status of your node group update with the DescribeUpdate
// API operation. Currently you can update the Kubernetes labels for a node
// group or the scaling configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateNodegroupConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig
func (c *EKS) UpdateNodegroupConfig(input *UpdateNodegroupConfigInput) (*UpdateNodegroupConfigOutput, error) {
	req, out := c.UpdateNodegroupConfigRequest(input)
	return out, req.Send()
}

// UpdateNodegroupConfigWithContext is the same as UpdateNodegroupConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNodegroupConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateNodegroupConfigWithContext(ctx aws.Context, input *UpdateNodegroupConfigInput, opts ...request.Option) (*UpdateNodegroupConfigOutput, error) {
	req, out := c.UpdateNodegroupConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNodegroupVersion = "UpdateNodegroupVersion"

// UpdateNodegroupVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNodegroupVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNodegroupVersion for more information on using the UpdateNodegroupVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateNodegroupVersionRequest method.
//	req, resp := client.UpdateNodegroupVersionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion
func (c *EKS) UpdateNodegroupVersionRequest(input *UpdateNodegroupVersionInput) (req *request.Request, output *UpdateNodegroupVersionOutput) {
	op := &request.Operation{
		Name:       opUpdateNodegroupVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}/update-version",
	}

	if input == nil {
		input = &UpdateNodegroupVersionInput{}
	}

	output = &UpdateNodegroupVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNodegroupVersion API operation for Amazon Elastic Kubernetes Service.
//
// Updates the Kubernetes version or AMI version of an Amazon EKS managed node
// group.
//
// You can update a node group using a launch template only if the node group
// was originally deployed with a launch template. If you need to update a custom
// AMI in a node group that was deployed with a launch template, then update
// your custom AMI, specify the new ID in a new version of the launch template,
// and then update the node group to the new version of the launch template.
//
// If you update without a launch template, then you can update to the latest
// available AMI version of a node group's current Kubernetes version by not
// specifying a Kubernetes version in the request. You can update to the latest
// AMI version of your cluster's current Kubernetes version by specifying your
// cluster's Kubernetes version in the request. For information about Linux
// versions, see Amazon EKS optimized Amazon Linux AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
// in the Amazon EKS User Guide. For information about Windows versions, see
// Amazon EKS optimized Windows AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html)
// in the Amazon EKS User Guide.
//
// You cannot roll back a node group to an earlier Kubernetes version or AMI
// version.
//
// When a node in a managed node group is terminated due to a scaling action
// or update, every Pod on that node is drained first. Amazon EKS attempts to
// drain the nodes gracefully and will fail if it is unable to do so. You can
// force the update if Amazon EKS is unable to drain the nodes as a result of
// a Pod disruption budget issue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdateNodegroupVersion for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
//   - ClientException
//     These errors are usually caused by a client action. Actions can include using
//     an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
//     that doesn't have permissions to use the action or resource or specifying
//     an identifier that is not valid.
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceInUseException
//     The specified resource is in use.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupVersion
func (c *EKS) UpdateNodegroupVersion(input *UpdateNodegroupVersionInput) (*UpdateNodegroupVersionOutput, error) {
	req, out := c.UpdateNodegroupVersionRequest(input)
	return out, req.Send()
}

// UpdateNodegroupVersionWithContext is the same as UpdateNodegroupVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNodegroupVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdateNodegroupVersionWithContext(ctx aws.Context, input *UpdateNodegroupVersionInput, opts ...request.Option) (*UpdateNodegroupVersionOutput, error) {
	req, out := c.UpdateNodegroupVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePodIdentityAssociation = "UpdatePodIdentityAssociation"

// UpdatePodIdentityAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePodIdentityAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePodIdentityAssociation for more information on using the UpdatePodIdentityAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePodIdentityAssociationRequest method.
//	req, resp := client.UpdatePodIdentityAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdatePodIdentityAssociation
func (c *EKS) UpdatePodIdentityAssociationRequest(input *UpdatePodIdentityAssociationInput) (req *request.Request, output *UpdatePodIdentityAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdatePodIdentityAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/pod-identity-associations/{associationId}",
	}

	if input == nil {
		input = &UpdatePodIdentityAssociationInput{}
	}

	output = &UpdatePodIdentityAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePodIdentityAssociation API operation for Amazon Elastic Kubernetes Service.
//
// Updates a EKS Pod Identity association. Only the IAM role can be changed;
// an association can't be moved between clusters, namespaces, or service accounts.
// If you need to edit the namespace or service account, you need to delete
// the association and then create a new association with your desired settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elastic Kubernetes Service's
// API operation UpdatePodIdentityAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ServerException
//     These errors are usually caused by a server-side issue.
//
//   - ResourceNotFoundException
//     The specified resource could not be found. You can view your available clusters
//     with ListClusters. You can view your available managed node groups with ListNodegroups.
//     Amazon EKS clusters and node groups are Amazon Web Services Region specific.
//
//   - InvalidRequestException
//     The request is invalid given the state of the cluster. Check the state of
//     the cluster and the associated operations.
//
//   - InvalidParameterException
//     The specified parameter is invalid. Review the available parameters for the
//     API request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdatePodIdentityAssociation
func (c *EKS) UpdatePodIdentityAssociation(input *UpdatePodIdentityAssociationInput) (*UpdatePodIdentityAssociationOutput, error) {
	req, out := c.UpdatePodIdentityAssociationRequest(input)
	return out, req.Send()
}

// UpdatePodIdentityAssociationWithContext is the same as UpdatePodIdentityAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePodIdentityAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EKS) UpdatePodIdentityAssociationWithContext(ctx aws.Context, input *UpdatePodIdentityAssociationInput, opts ...request.Option) (*UpdatePodIdentityAssociationOutput, error) {
	req, out := c.UpdatePodIdentityAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The access configuration for the cluster.
type AccessConfigResponse struct {
	_ struct{} `type:"structure"`

	// The current authentication mode of the cluster.
	AuthenticationMode *string `locationName:"authenticationMode" type:"string" enum:"AuthenticationMode"`

	// Specifies whether or not the cluster creator IAM principal was set as a cluster
	// admin access entry during cluster creation time.
	BootstrapClusterCreatorAdminPermissions *bool `locationName:"bootstrapClusterCreatorAdminPermissions" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessConfigResponse) GoString() string {
	return s.String()
}

// SetAuthenticationMode sets the AuthenticationMode field's value.
func (s *AccessConfigResponse) SetAuthenticationMode(v string) *AccessConfigResponse {
	s.AuthenticationMode = &v
	return s
}

// SetBootstrapClusterCreatorAdminPermissions sets the BootstrapClusterCreatorAdminPermissions field's value.
func (s *AccessConfigResponse) SetBootstrapClusterCreatorAdminPermissions(v bool) *AccessConfigResponse {
	s.BootstrapClusterCreatorAdminPermissions = &v
	return s
}

// You don't have permissions to perform the requested operation. The IAM principal
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
// making the request must have at least one IAM permissions policy attached
// that grants the required permissions. For more information, see Access management
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html) in the IAM
// User Guide.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// You do not have sufficient access to perform this action.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An access entry allows an IAM principal (user or role) to access your cluster.
// Access entries can replace the need to maintain the aws-auth ConfigMap for
// authentication. For more information about access entries, see Access entries
// (https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html) in
// the Amazon EKS User Guide.
type AccessEntry struct {
	_ struct{} `type:"structure"`

	// The ARN of the access entry.
	AccessEntryArn *string `locationName:"accessEntryArn" type:"string"`

	// The name of your cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A name that you've specified in a Kubernetes RoleBinding or ClusterRoleBinding
	// object so that Kubernetes authorizes the principalARN access to cluster objects.
	KubernetesGroups []*string `locationName:"kubernetesGroups" type:"list"`

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The ARN of the IAM principal for the access entry. If you ever delete the
	// IAM principal with this ARN, the access entry isn't automatically deleted.
	// We recommend that you delete the access entry with an ARN for an IAM principal
	// that you delete. If you don't delete the access entry and ever recreate the
	// IAM principal, even if it has the same ARN, the access entry won't work.
	// This is because even though the ARN is the same for the recreated IAM principal,
	// the roleID or userID (you can see this with the Security Token Service GetCallerIdentity
	// API) is different for the recreated IAM principal than it was for the original
	// IAM principal. Even though you don't see the IAM principal's roleID or userID
	// for an access entry, Amazon EKS stores it with the access entry.
	PrincipalArn *string `locationName:"principalArn" type:"string"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The type of the access entry.
	Type *string `locationName:"type" type:"string"`

	// The name of a user that can authenticate to your cluster.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessEntry) GoString() string {
	return s.String()
}

// SetAccessEntryArn sets the AccessEntryArn field's value.
func (s *AccessEntry) SetAccessEntryArn(v string) *AccessEntry {
	s.AccessEntryArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *AccessEntry) SetClusterName(v string) *AccessEntry {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *AccessEntry) SetCreatedAt(v time.Time) *AccessEntry {
	s.CreatedAt = &v
	return s
}

// SetKubernetesGroups sets the KubernetesGroups field's value.
func (s *AccessEntry) SetKubernetesGroups(v []*string) *AccessEntry {
	s.KubernetesGroups = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *AccessEntry) SetModifiedAt(v time.Time) *AccessEntry {
	s.ModifiedAt = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *AccessEntry) SetPrincipalArn(v string) *AccessEntry {
	s.PrincipalArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AccessEntry) SetTags(v map[string]*string) *AccessEntry {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *AccessEntry) SetType(v string) *AccessEntry {
	s.Type = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *AccessEntry) SetUsername(v string) *AccessEntry {
	s.Username = &v
	return s
}

// An access policy includes permissions that allow Amazon EKS to authorize
// an IAM principal to work with Kubernetes objects on your cluster. The policies
// are managed by Amazon EKS, but they're not IAM policies. You can't view the
// permissions in the policies using the API. The permissions for many of the
// policies are similar to the Kubernetes cluster-admin, admin, edit, and view
// cluster roles. For more information about these cluster roles, see User-facing
// roles (https://kubernetes.io/docs/reference/access-authn-authz/rbac/#user-facing-roles)
// in the Kubernetes documentation. To view the contents of the policies, see
// Access policy permissions (https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions)
// in the Amazon EKS User Guide.
type AccessPolicy struct {
	_ struct{} `type:"structure"`

	// The ARN of the access policy.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the access policy.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessPolicy) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AccessPolicy) SetArn(v string) *AccessPolicy {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccessPolicy) SetName(v string) *AccessPolicy {
	s.Name = &v
	return s
}

// The scope of an AccessPolicy that's associated to an AccessEntry.
type AccessScope struct {
	_ struct{} `type:"structure"`

	// A Kubernetes namespace that an access policy is scoped to. A value is required
	// if you specified namespace for Type.
	Namespaces []*string `locationName:"namespaces" type:"list"`

	// The scope type of an access policy.
	Type *string `locationName:"type" type:"string" enum:"AccessScopeType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessScope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessScope) GoString() string {
	return s.String()
}

// SetNamespaces sets the Namespaces field's value.
func (s *AccessScope) SetNamespaces(v []*string) *AccessScope {
	s.Namespaces = v
	return s
}

// SetType sets the Type field's value.
func (s *AccessScope) SetType(v string) *AccessScope {
	s.Type = &v
	return s
}

// An Amazon EKS add-on. For more information, see Amazon EKS add-ons (https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html)
// in the Amazon EKS User Guide.
type Addon struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the add-on.
	AddonArn *string `locationName:"addonArn" type:"string"`

	// The name of the add-on.
	AddonName *string `locationName:"addonName" type:"string"`

	// The version of the add-on.
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// The name of your cluster.
	ClusterName *string `locationName:"clusterName" min:"1" type:"string"`

	// The configuration values that you provided.
	ConfigurationValues *string `locationName:"configurationValues" type:"string"`

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// An object that represents the health of the add-on.
	Health *AddonHealth `locationName:"health" type:"structure"`

	// Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
	MarketplaceInformation *MarketplaceInformation `locationName:"marketplaceInformation" type:"structure"`

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The owner of the add-on.
	Owner *string `locationName:"owner" type:"string"`

	// An array of Pod Identity Assocations owned by the Addon. Each EKS Pod Identity
	// association maps a role to a service account in a namespace in the cluster.
	//
	// For more information, see Attach an IAM Role to an Amazon EKS add-on using
	// Pod Identity (https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html)
	// in the EKS User Guide.
	PodIdentityAssociations []*string `locationName:"podIdentityAssociations" type:"list"`

	// The publisher of the add-on.
	Publisher *string `locationName:"publisher" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that's bound to the Kubernetes
	// ServiceAccount object that the add-on uses.
	ServiceAccountRoleArn *string `locationName:"serviceAccountRoleArn" type:"string"`

	// The status of the add-on.
	Status *string `locationName:"status" type:"string" enum:"AddonStatus"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Addon) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Addon) GoString() string {
	return s.String()
}

// SetAddonArn sets the AddonArn field's value.
func (s *Addon) SetAddonArn(v string) *Addon {
	s.AddonArn = &v
	return s
}

// SetAddonName sets the AddonName field's value.
func (s *Addon) SetAddonName(v string) *Addon {
	s.AddonName = &v
	return s
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *Addon) SetAddonVersion(v string) *Addon {
	s.AddonVersion = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Addon) SetClusterName(v string) *Addon {
	s.ClusterName = &v
	return s
}

// SetConfigurationValues sets the ConfigurationValues field's value.
func (s *Addon) SetConfigurationValues(v string) *Addon {
	s.ConfigurationValues = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Addon) SetCreatedAt(v time.Time) *Addon {
	s.CreatedAt = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *Addon) SetHealth(v *AddonHealth) *Addon {
	s.Health = v
	return s
}

// SetMarketplaceInformation sets the MarketplaceInformation field's value.
func (s *Addon) SetMarketplaceInformation(v *MarketplaceInformation) *Addon {
	s.MarketplaceInformation = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *Addon) SetModifiedAt(v time.Time) *Addon {
	s.ModifiedAt = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *Addon) SetOwner(v string) *Addon {
	s.Owner = &v
	return s
}

// SetPodIdentityAssociations sets the PodIdentityAssociations field's value.
func (s *Addon) SetPodIdentityAssociations(v []*string) *Addon {
	s.PodIdentityAssociations = v
	return s
}

// SetPublisher sets the Publisher field's value.
func (s *Addon) SetPublisher(v string) *Addon {
	s.Publisher = &v
	return s
}

// SetServiceAccountRoleArn sets the ServiceAccountRoleArn field's value.
func (s *Addon) SetServiceAccountRoleArn(v string) *Addon {
	s.ServiceAccountRoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Addon) SetStatus(v string) *Addon {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Addon) SetTags(v map[string]*string) *Addon {
	s.Tags = v
	return s
}

// The health of the add-on.
type AddonHealth struct {
	_ struct{} `type:"structure"`

	// An object representing the health issues for an add-on.
	Issues []*AddonIssue `locationName:"issues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonHealth) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *AddonHealth) SetIssues(v []*AddonIssue) *AddonHealth {
	s.Issues = v
	return s
}

// Information about an add-on.
type AddonInfo struct {
	_ struct{} `type:"structure"`

	// The name of the add-on.
	AddonName *string `locationName:"addonName" type:"string"`

	// An object representing information about available add-on versions and compatible
	// Kubernetes versions.
	AddonVersions []*AddonVersionInfo `locationName:"addonVersions" type:"list"`

	// Information about the add-on from the Amazon Web Services Marketplace.
	MarketplaceInformation *MarketplaceInformation `locationName:"marketplaceInformation" type:"structure"`

	// The owner of the add-on.
	Owner *string `locationName:"owner" type:"string"`

	// The publisher of the add-on.
	Publisher *string `locationName:"publisher" type:"string"`

	// The type of the add-on.
	Type *string `locationName:"type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonInfo) GoString() string {
	return s.String()
}

// SetAddonName sets the AddonName field's value.
func (s *AddonInfo) SetAddonName(v string) *AddonInfo {
	s.AddonName = &v
	return s
}

// SetAddonVersions sets the AddonVersions field's value.
func (s *AddonInfo) SetAddonVersions(v []*AddonVersionInfo) *AddonInfo {
	s.AddonVersions = v
	return s
}

// SetMarketplaceInformation sets the MarketplaceInformation field's value.
func (s *AddonInfo) SetMarketplaceInformation(v *MarketplaceInformation) *AddonInfo {
	s.MarketplaceInformation = v
	return s
}

// SetOwner sets the Owner field's value.
func (s *AddonInfo) SetOwner(v string) *AddonInfo {
	s.Owner = &v
	return s
}

// SetPublisher sets the Publisher field's value.
func (s *AddonInfo) SetPublisher(v string) *AddonInfo {
	s.Publisher = &v
	return s
}

// SetType sets the Type field's value.
func (s *AddonInfo) SetType(v string) *AddonInfo {
	s.Type = &v
	return s
}

// An issue related to an add-on.
type AddonIssue struct {
	_ struct{} `type:"structure"`

	// A code that describes the type of issue.
	Code *string `locationName:"code" type:"string" enum:"AddonIssueCode"`

	// A message that provides details about the issue and what might cause it.
	Message *string `locationName:"message" type:"string"`

	// The resource IDs of the issue.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonIssue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonIssue) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *AddonIssue) SetCode(v string) *AddonIssue {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AddonIssue) SetMessage(v string) *AddonIssue {
	s.Message = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *AddonIssue) SetResourceIds(v []*string) *AddonIssue {
	s.ResourceIds = v
	return s
}

// A type of Pod Identity Association owned by an Amazon EKS Add-on.
//
// Each EKS Pod Identity Association maps a role to a service account in a namespace
// in the cluster.
//
// For more information, see Attach an IAM Role to an Amazon EKS add-on using
// Pod Identity (https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html)
// in the EKS User Guide.
type AddonPodIdentityAssociations struct {
	_ struct{} `type:"structure"`

	// The ARN of an IAM Role.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of a Kubernetes Service Account.
	//
	// ServiceAccount is a required field
	ServiceAccount *string `locationName:"serviceAccount" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonPodIdentityAssociations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonPodIdentityAssociations) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddonPodIdentityAssociations) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddonPodIdentityAssociations"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.ServiceAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *AddonPodIdentityAssociations) SetRoleArn(v string) *AddonPodIdentityAssociations {
	s.RoleArn = &v
	return s
}

// SetServiceAccount sets the ServiceAccount field's value.
func (s *AddonPodIdentityAssociations) SetServiceAccount(v string) *AddonPodIdentityAssociations {
	s.ServiceAccount = &v
	return s
}

// Information about how to configure IAM for an Addon.
type AddonPodIdentityConfiguration struct {
	_ struct{} `type:"structure"`

	// A suggested IAM Policy for the addon.
	RecommendedManagedPolicies []*string `locationName:"recommendedManagedPolicies" type:"list"`

	// The Kubernetes Service Account name used by the addon.
	ServiceAccount *string `locationName:"serviceAccount" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonPodIdentityConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonPodIdentityConfiguration) GoString() string {
	return s.String()
}

// SetRecommendedManagedPolicies sets the RecommendedManagedPolicies field's value.
func (s *AddonPodIdentityConfiguration) SetRecommendedManagedPolicies(v []*string) *AddonPodIdentityConfiguration {
	s.RecommendedManagedPolicies = v
	return s
}

// SetServiceAccount sets the ServiceAccount field's value.
func (s *AddonPodIdentityConfiguration) SetServiceAccount(v string) *AddonPodIdentityConfiguration {
	s.ServiceAccount = &v
	return s
}

// Information about an add-on version.
type AddonVersionInfo struct {
	_ struct{} `type:"structure"`

	// The version of the add-on.
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// The architectures that the version supports.
	Architecture []*string `locationName:"architecture" type:"list"`

	// An object representing the compatibilities of a version.
	Compatibilities []*Compatibility `locationName:"compatibilities" type:"list"`

	// Whether the add-on requires configuration.
	RequiresConfiguration *bool `locationName:"requiresConfiguration" type:"boolean"`

	// Indicates if the Addon requires IAM Permissions to operate, such as networking
	// permissions.
	RequiresIamPermissions *bool `locationName:"requiresIamPermissions" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonVersionInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AddonVersionInfo) GoString() string {
	return s.String()
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *AddonVersionInfo) SetAddonVersion(v string) *AddonVersionInfo {
	s.AddonVersion = &v
	return s
}

// SetArchitecture sets the Architecture field's value.
func (s *AddonVersionInfo) SetArchitecture(v []*string) *AddonVersionInfo {
	s.Architecture = v
	return s
}

// SetCompatibilities sets the Compatibilities field's value.
func (s *AddonVersionInfo) SetCompatibilities(v []*Compatibility) *AddonVersionInfo {
	s.Compatibilities = v
	return s
}

// SetRequiresConfiguration sets the RequiresConfiguration field's value.
func (s *AddonVersionInfo) SetRequiresConfiguration(v bool) *AddonVersionInfo {
	s.RequiresConfiguration = &v
	return s
}

// SetRequiresIamPermissions sets the RequiresIamPermissions field's value.
func (s *AddonVersionInfo) SetRequiresIamPermissions(v bool) *AddonVersionInfo {
	s.RequiresIamPermissions = &v
	return s
}

type AssociateAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The scope for the AccessPolicy. You can scope access policies to an entire
	// cluster or to specific Kubernetes namespaces.
	//
	// AccessScope is a required field
	AccessScope *AccessScope `locationName:"accessScope" type:"structure" required:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The ARN of the AccessPolicy that you're associating. For a list of ARNs,
	// use ListAccessPolicies.
	//
	// PolicyArn is a required field
	PolicyArn *string `locationName:"policyArn" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM user or role for the AccessEntry
	// that you're associating the access policy to.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `location:"uri" locationName:"principalArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAccessPolicyInput"}
	if s.AccessScope == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessScope"))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}
	if s.PrincipalArn != nil && len(*s.PrincipalArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessScope sets the AccessScope field's value.
func (s *AssociateAccessPolicyInput) SetAccessScope(v *AccessScope) *AssociateAccessPolicyInput {
	s.AccessScope = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *AssociateAccessPolicyInput) SetClusterName(v string) *AssociateAccessPolicyInput {
	s.ClusterName = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *AssociateAccessPolicyInput) SetPolicyArn(v string) *AssociateAccessPolicyInput {
	s.PolicyArn = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *AssociateAccessPolicyInput) SetPrincipalArn(v string) *AssociateAccessPolicyInput {
	s.PrincipalArn = &v
	return s
}

type AssociateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The AccessPolicy and scope associated to the AccessEntry.
	AssociatedAccessPolicy *AssociatedAccessPolicy `locationName:"associatedAccessPolicy" type:"structure"`

	// The name of your cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The ARN of the IAM principal for the AccessEntry.
	PrincipalArn *string `locationName:"principalArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetAssociatedAccessPolicy sets the AssociatedAccessPolicy field's value.
func (s *AssociateAccessPolicyOutput) SetAssociatedAccessPolicy(v *AssociatedAccessPolicy) *AssociateAccessPolicyOutput {
	s.AssociatedAccessPolicy = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *AssociateAccessPolicyOutput) SetClusterName(v string) *AssociateAccessPolicyOutput {
	s.ClusterName = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *AssociateAccessPolicyOutput) SetPrincipalArn(v string) *AssociateAccessPolicyOutput {
	s.PrincipalArn = &v
	return s
}

type AssociateEncryptionConfigInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The configuration you are using for encryption.
	//
	// EncryptionConfig is a required field
	EncryptionConfig []*EncryptionConfig `locationName:"encryptionConfig" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEncryptionConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEncryptionConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateEncryptionConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateEncryptionConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.EncryptionConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("EncryptionConfig"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateEncryptionConfigInput) SetClientRequestToken(v string) *AssociateEncryptionConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *AssociateEncryptionConfigInput) SetClusterName(v string) *AssociateEncryptionConfigInput {
	s.ClusterName = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *AssociateEncryptionConfigInput) SetEncryptionConfig(v []*EncryptionConfig) *AssociateEncryptionConfigInput {
	s.EncryptionConfig = v
	return s
}

type AssociateEncryptionConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEncryptionConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateEncryptionConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *AssociateEncryptionConfigOutput) SetUpdate(v *Update) *AssociateEncryptionConfigOutput {
	s.Update = v
	return s
}

type AssociateIdentityProviderConfigInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object representing an OpenID Connect (OIDC) identity provider configuration.
	//
	// Oidc is a required field
	Oidc *OidcIdentityProviderConfigRequest `locationName:"oidc" type:"structure" required:"true"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIdentityProviderConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIdentityProviderConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIdentityProviderConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateIdentityProviderConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.Oidc == nil {
		invalidParams.Add(request.NewErrParamRequired("Oidc"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Oidc != nil {
		if err := s.Oidc.Validate(); err != nil {
			invalidParams.AddNested("Oidc", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *AssociateIdentityProviderConfigInput) SetClientRequestToken(v string) *AssociateIdentityProviderConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *AssociateIdentityProviderConfigInput) SetClusterName(v string) *AssociateIdentityProviderConfigInput {
	s.ClusterName = &v
	return s
}

// SetOidc sets the Oidc field's value.
func (s *AssociateIdentityProviderConfigInput) SetOidc(v *OidcIdentityProviderConfigRequest) *AssociateIdentityProviderConfigInput {
	s.Oidc = v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssociateIdentityProviderConfigInput) SetTags(v map[string]*string) *AssociateIdentityProviderConfigInput {
	s.Tags = v
	return s
}

type AssociateIdentityProviderConfigOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIdentityProviderConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIdentityProviderConfigOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *AssociateIdentityProviderConfigOutput) SetTags(v map[string]*string) *AssociateIdentityProviderConfigOutput {
	s.Tags = v
	return s
}

// SetUpdate sets the Update field's value.
func (s *AssociateIdentityProviderConfigOutput) SetUpdate(v *Update) *AssociateIdentityProviderConfigOutput {
	s.Update = v
	return s
}

// An access policy association.
type AssociatedAccessPolicy struct {
	_ struct{} `type:"structure"`

	// The scope of the access policy.
	AccessScope *AccessScope `locationName:"accessScope" type:"structure"`

	// The date and time the AccessPolicy was associated with an AccessEntry.
	AssociatedAt *time.Time `locationName:"associatedAt" type:"timestamp"`

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The ARN of the AccessPolicy.
	PolicyArn *string `locationName:"policyArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedAccessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatedAccessPolicy) GoString() string {
	return s.String()
}

// SetAccessScope sets the AccessScope field's value.
func (s *AssociatedAccessPolicy) SetAccessScope(v *AccessScope) *AssociatedAccessPolicy {
	s.AccessScope = v
	return s
}

// SetAssociatedAt sets the AssociatedAt field's value.
func (s *AssociatedAccessPolicy) SetAssociatedAt(v time.Time) *AssociatedAccessPolicy {
	s.AssociatedAt = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *AssociatedAccessPolicy) SetModifiedAt(v time.Time) *AssociatedAccessPolicy {
	s.ModifiedAt = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *AssociatedAccessPolicy) SetPolicyArn(v string) *AssociatedAccessPolicy {
	s.PolicyArn = &v
	return s
}

// An Auto Scaling group that is associated with an Amazon EKS managed node
// group.
type AutoScalingGroup struct {
	_ struct{} `type:"structure"`

	// The name of the Auto Scaling group associated with an Amazon EKS managed
	// node group.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AutoScalingGroup) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AutoScalingGroup) SetName(v string) *AutoScalingGroup {
	s.Name = &v
	return s
}

// This exception is thrown if the request contains a semantic error. The precise
// meaning will depend on the API, and will be documented in the error message.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// This exception is thrown if the request contains a semantic error. The precise
	// meaning will depend on the API, and will be documented in the error message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing the certificate-authority-data for your cluster.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Base64-encoded certificate data required to communicate with your cluster.
	// Add this to the certificate-authority-data section of the kubeconfig file
	// for your cluster.
	Data *string `locationName:"data" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Certificate) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *Certificate) SetData(v string) *Certificate {
	s.Data = &v
	return s
}

// These errors are usually caused by a client action. Actions can include using
// an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
// that doesn't have permissions to use the action or resource or specifying
// an identifier that is not valid.
type ClientException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS add-on name associated with the exception.
	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// These errors are usually caused by a client action. Actions can include using
	// an action or resource on behalf of an IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
	// that doesn't have permissions to use the action or resource or specifying
	// an identifier that is not valid.
	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The Amazon EKS subscription ID with the exception.
	SubscriptionId *string `locationName:"subscriptionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientException) GoString() string {
	return s.String()
}

func newErrorClientException(v protocol.ResponseMetadata) error {
	return &ClientException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ClientException) Code() string {
	return "ClientException"
}

// Message returns the exception's message.
func (s *ClientException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ClientException) OrigErr() error {
	return nil
}

func (s *ClientException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ClientException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ClientException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about clients using the deprecated resources.
type ClientStat struct {
	_ struct{} `type:"structure"`

	// The timestamp of the last request seen from the Kubernetes client.
	LastRequestTime *time.Time `locationName:"lastRequestTime" type:"timestamp"`

	// The number of requests from the Kubernetes client seen over the last 30 days.
	NumberOfRequestsLast30Days *int64 `locationName:"numberOfRequestsLast30Days" type:"integer"`

	// The user agent of the Kubernetes client using the deprecated resource.
	UserAgent *string `locationName:"userAgent" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientStat) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientStat) GoString() string {
	return s.String()
}

// SetLastRequestTime sets the LastRequestTime field's value.
func (s *ClientStat) SetLastRequestTime(v time.Time) *ClientStat {
	s.LastRequestTime = &v
	return s
}

// SetNumberOfRequestsLast30Days sets the NumberOfRequestsLast30Days field's value.
func (s *ClientStat) SetNumberOfRequestsLast30Days(v int64) *ClientStat {
	s.NumberOfRequestsLast30Days = &v
	return s
}

// SetUserAgent sets the UserAgent field's value.
func (s *ClientStat) SetUserAgent(v string) *ClientStat {
	s.UserAgent = &v
	return s
}

// An object representing an Amazon EKS cluster.
type Cluster struct {
	_ struct{} `type:"structure"`

	// The access configuration for the cluster.
	AccessConfig *AccessConfigResponse `locationName:"accessConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of the cluster.
	Arn *string `locationName:"arn" type:"string"`

	// The certificate-authority-data for your cluster.
	CertificateAuthority *Certificate `locationName:"certificateAuthority" type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The configuration used to connect to a cluster for registration.
	ConnectorConfig *ConnectorConfigResponse `locationName:"connectorConfig" type:"structure"`

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The encryption configuration for the cluster.
	EncryptionConfig []*EncryptionConfig `locationName:"encryptionConfig" type:"list"`

	// The endpoint for your Kubernetes API server.
	Endpoint *string `locationName:"endpoint" type:"string"`

	// An object representing the health of your Amazon EKS cluster.
	Health *ClusterHealth `locationName:"health" type:"structure"`

	// The ID of your local Amazon EKS cluster on an Amazon Web Services Outpost.
	// This property isn't available for an Amazon EKS cluster on the Amazon Web
	// Services cloud.
	Id *string `locationName:"id" type:"string"`

	// The identity provider information for the cluster.
	Identity *Identity `locationName:"identity" type:"structure"`

	// The Kubernetes network configuration for the cluster.
	KubernetesNetworkConfig *KubernetesNetworkConfigResponse `locationName:"kubernetesNetworkConfig" type:"structure"`

	// The logging configuration for your cluster.
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of your cluster.
	Name *string `locationName:"name" type:"string"`

	// An object representing the configuration of your local Amazon EKS cluster
	// on an Amazon Web Services Outpost. This object isn't available for clusters
	// on the Amazon Web Services cloud.
	OutpostConfig *OutpostConfigResponse `locationName:"outpostConfig" type:"structure"`

	// The platform version of your Amazon EKS cluster. For more information about
	// clusters deployed on the Amazon Web Services Cloud, see Platform versions
	// (https://docs.aws.amazon.com/eks/latest/userguide/platform-versions.html)
	// in the Amazon EKS User Guide . For more information about local clusters
	// deployed on an Outpost, see Amazon EKS local cluster platform versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-platform-versions.html)
	// in the Amazon EKS User Guide .
	PlatformVersion *string `locationName:"platformVersion" type:"string"`

	// The VPC configuration used by the cluster control plane. Amazon EKS VPC resources
	// have specific requirements to work properly with Kubernetes. For more information,
	// see Cluster VPC considerations (https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
	// and Cluster security group considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide.
	ResourcesVpcConfig *VpcConfigResponse `locationName:"resourcesVpcConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions
	// for the Kubernetes control plane to make calls to Amazon Web Services API
	// operations on your behalf.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The current status of the cluster.
	Status *string `locationName:"status" type:"string" enum:"ClusterStatus"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes server version for the cluster.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Cluster) GoString() string {
	return s.String()
}

// SetAccessConfig sets the AccessConfig field's value.
func (s *Cluster) SetAccessConfig(v *AccessConfigResponse) *Cluster {
	s.AccessConfig = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Cluster) SetArn(v string) *Cluster {
	s.Arn = &v
	return s
}

// SetCertificateAuthority sets the CertificateAuthority field's value.
func (s *Cluster) SetCertificateAuthority(v *Certificate) *Cluster {
	s.CertificateAuthority = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *Cluster) SetClientRequestToken(v string) *Cluster {
	s.ClientRequestToken = &v
	return s
}

// SetConnectorConfig sets the ConnectorConfig field's value.
func (s *Cluster) SetConnectorConfig(v *ConnectorConfigResponse) *Cluster {
	s.ConnectorConfig = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Cluster) SetCreatedAt(v time.Time) *Cluster {
	s.CreatedAt = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *Cluster) SetEncryptionConfig(v []*EncryptionConfig) *Cluster {
	s.EncryptionConfig = v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Cluster) SetEndpoint(v string) *Cluster {
	s.Endpoint = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *Cluster) SetHealth(v *ClusterHealth) *Cluster {
	s.Health = v
	return s
}

// SetId sets the Id field's value.
func (s *Cluster) SetId(v string) *Cluster {
	s.Id = &v
	return s
}

// SetIdentity sets the Identity field's value.
func (s *Cluster) SetIdentity(v *Identity) *Cluster {
	s.Identity = v
	return s
}

// SetKubernetesNetworkConfig sets the KubernetesNetworkConfig field's value.
func (s *Cluster) SetKubernetesNetworkConfig(v *KubernetesNetworkConfigResponse) *Cluster {
	s.KubernetesNetworkConfig = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *Cluster) SetLogging(v *Logging) *Cluster {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *Cluster) SetName(v string) *Cluster {
	s.Name = &v
	return s
}

// SetOutpostConfig sets the OutpostConfig field's value.
func (s *Cluster) SetOutpostConfig(v *OutpostConfigResponse) *Cluster {
	s.OutpostConfig = v
	return s
}

// SetPlatformVersion sets the PlatformVersion field's value.
func (s *Cluster) SetPlatformVersion(v string) *Cluster {
	s.PlatformVersion = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *Cluster) SetResourcesVpcConfig(v *VpcConfigResponse) *Cluster {
	s.ResourcesVpcConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *Cluster) SetRoleArn(v string) *Cluster {
	s.RoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Cluster) SetStatus(v string) *Cluster {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Cluster) SetTags(v map[string]*string) *Cluster {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Cluster) SetVersion(v string) *Cluster {
	s.Version = &v
	return s
}

// An object representing the health of your Amazon EKS cluster.
type ClusterHealth struct {
	_ struct{} `type:"structure"`

	// An object representing the health issues of your Amazon EKS cluster.
	Issues []*ClusterIssue `locationName:"issues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterHealth) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *ClusterHealth) SetIssues(v []*ClusterIssue) *ClusterHealth {
	s.Issues = v
	return s
}

// An issue with your Amazon EKS cluster.
type ClusterIssue struct {
	_ struct{} `type:"structure"`

	// The error code of the issue.
	Code *string `locationName:"code" type:"string" enum:"ClusterIssueCode"`

	// A description of the issue.
	Message *string `locationName:"message" type:"string"`

	// The resource IDs that the issue relates to.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterIssue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClusterIssue) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ClusterIssue) SetCode(v string) *ClusterIssue {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ClusterIssue) SetMessage(v string) *ClusterIssue {
	s.Message = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ClusterIssue) SetResourceIds(v []*string) *ClusterIssue {
	s.ResourceIds = v
	return s
}

// Compatibility information.
type Compatibility struct {
	_ struct{} `type:"structure"`

	// The supported Kubernetes version of the cluster.
	ClusterVersion *string `locationName:"clusterVersion" type:"string"`

	// The supported default version.
	DefaultVersion *bool `locationName:"defaultVersion" type:"boolean"`

	// The supported compute platform.
	PlatformVersions []*string `locationName:"platformVersions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Compatibility) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Compatibility) GoString() string {
	return s.String()
}

// SetClusterVersion sets the ClusterVersion field's value.
func (s *Compatibility) SetClusterVersion(v string) *Compatibility {
	s.ClusterVersion = &v
	return s
}

// SetDefaultVersion sets the DefaultVersion field's value.
func (s *Compatibility) SetDefaultVersion(v bool) *Compatibility {
	s.DefaultVersion = &v
	return s
}

// SetPlatformVersions sets the PlatformVersions field's value.
func (s *Compatibility) SetPlatformVersions(v []*string) *Compatibility {
	s.PlatformVersions = v
	return s
}

// The configuration sent to a cluster for configuration.
type ConnectorConfigRequest struct {
	_ struct{} `type:"structure"`

	// The cloud provider for the target cluster to connect.
	//
	// Provider is a required field
	Provider *string `locationName:"provider" type:"string" required:"true" enum:"ConnectorConfigProvider"`

	// The Amazon Resource Name (ARN) of the role that is authorized to request
	// the connector configuration.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorConfigRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectorConfigRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectorConfigRequest"}
	if s.Provider == nil {
		invalidParams.Add(request.NewErrParamRequired("Provider"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProvider sets the Provider field's value.
func (s *ConnectorConfigRequest) SetProvider(v string) *ConnectorConfigRequest {
	s.Provider = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ConnectorConfigRequest) SetRoleArn(v string) *ConnectorConfigRequest {
	s.RoleArn = &v
	return s
}

// The full description of your connected cluster.
type ConnectorConfigResponse struct {
	_ struct{} `type:"structure"`

	// A unique code associated with the cluster for registration purposes.
	ActivationCode *string `locationName:"activationCode" type:"string"`

	// The expiration time of the connected cluster. The cluster's YAML file must
	// be applied through the native provider.
	ActivationExpiry *time.Time `locationName:"activationExpiry" type:"timestamp"`

	// A unique ID associated with the cluster for registration purposes.
	ActivationId *string `locationName:"activationId" type:"string"`

	// The cluster's cloud service provider.
	Provider *string `locationName:"provider" type:"string"`

	// The Amazon Resource Name (ARN) of the role to communicate with services from
	// the connected Kubernetes cluster.
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectorConfigResponse) GoString() string {
	return s.String()
}

// SetActivationCode sets the ActivationCode field's value.
func (s *ConnectorConfigResponse) SetActivationCode(v string) *ConnectorConfigResponse {
	s.ActivationCode = &v
	return s
}

// SetActivationExpiry sets the ActivationExpiry field's value.
func (s *ConnectorConfigResponse) SetActivationExpiry(v time.Time) *ConnectorConfigResponse {
	s.ActivationExpiry = &v
	return s
}

// SetActivationId sets the ActivationId field's value.
func (s *ConnectorConfigResponse) SetActivationId(v string) *ConnectorConfigResponse {
	s.ActivationId = &v
	return s
}

// SetProvider sets the Provider field's value.
func (s *ConnectorConfigResponse) SetProvider(v string) *ConnectorConfigResponse {
	s.Provider = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ConnectorConfigResponse) SetRoleArn(v string) *ConnectorConfigResponse {
	s.RoleArn = &v
	return s
}

// The placement configuration for all the control plane instances of your local
// Amazon EKS cluster on an Amazon Web Services Outpost. For more information,
// see Capacity considerations (https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html)
// in the Amazon EKS User Guide.
type ControlPlanePlacementRequest struct {
	_ struct{} `type:"structure"`

	// The name of the placement group for the Kubernetes control plane instances.
	// This setting can't be changed after cluster creation.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlPlanePlacementRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlPlanePlacementRequest) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *ControlPlanePlacementRequest) SetGroupName(v string) *ControlPlanePlacementRequest {
	s.GroupName = &v
	return s
}

// The placement configuration for all the control plane instances of your local
// Amazon EKS cluster on an Amazon Web Services Outpost. For more information,
// see Capacity considerations (https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html)
// in the Amazon EKS User Guide.
type ControlPlanePlacementResponse struct {
	_ struct{} `type:"structure"`

	// The name of the placement group for the Kubernetes control plane instances.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlPlanePlacementResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlPlanePlacementResponse) GoString() string {
	return s.String()
}

// SetGroupName sets the GroupName field's value.
func (s *ControlPlanePlacementResponse) SetGroupName(v string) *ControlPlanePlacementResponse {
	s.GroupName = &v
	return s
}

// The access configuration information for the cluster.
type CreateAccessConfigRequest struct {
	_ struct{} `type:"structure"`

	// The desired authentication mode for the cluster. If you create a cluster
	// by using the EKS API, Amazon Web Services SDKs, or CloudFormation, the default
	// is CONFIG_MAP. If you create the cluster by using the Amazon Web Services
	// Management Console, the default value is API_AND_CONFIG_MAP.
	AuthenticationMode *string `locationName:"authenticationMode" type:"string" enum:"AuthenticationMode"`

	// Specifies whether or not the cluster creator IAM principal was set as a cluster
	// admin access entry during cluster creation time. The default value is true.
	BootstrapClusterCreatorAdminPermissions *bool `locationName:"bootstrapClusterCreatorAdminPermissions" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessConfigRequest) GoString() string {
	return s.String()
}

// SetAuthenticationMode sets the AuthenticationMode field's value.
func (s *CreateAccessConfigRequest) SetAuthenticationMode(v string) *CreateAccessConfigRequest {
	s.AuthenticationMode = &v
	return s
}

// SetBootstrapClusterCreatorAdminPermissions sets the BootstrapClusterCreatorAdminPermissions field's value.
func (s *CreateAccessConfigRequest) SetBootstrapClusterCreatorAdminPermissions(v bool) *CreateAccessConfigRequest {
	s.BootstrapClusterCreatorAdminPermissions = &v
	return s
}

type CreateAccessEntryInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The value for name that you've specified for kind: Group as a subject in
	// a Kubernetes RoleBinding or ClusterRoleBinding object. Amazon EKS doesn't
	// confirm that the value for name exists in any bindings on your cluster. You
	// can specify one or more names.
	//
	// Kubernetes authorizes the principalArn of the access entry to access any
	// cluster objects that you've specified in a Kubernetes Role or ClusterRole
	// object that is also specified in a binding's roleRef. For more information
	// about creating Kubernetes RoleBinding, ClusterRoleBinding, Role, or ClusterRole
	// objects, see Using RBAC Authorization in the Kubernetes documentation (https://kubernetes.io/docs/reference/access-authn-authz/rbac/).
	//
	// If you want Amazon EKS to authorize the principalArn (instead of, or in addition
	// to Kubernetes authorizing the principalArn), you can associate one or more
	// access policies to the access entry using AssociateAccessPolicy. If you associate
	// any access policies, the principalARN has all permissions assigned in the
	// associated access policies and all permissions in any Kubernetes Role or
	// ClusterRole objects that the group names are bound to.
	KubernetesGroups []*string `locationName:"kubernetesGroups" type:"list"`

	// The ARN of the IAM principal for the AccessEntry. You can specify one ARN
	// for each access entry. You can't specify the same ARN in more than one access
	// entry. This value can't be changed after access entry creation.
	//
	// The valid principals differ depending on the type of the access entry in
	// the type field. The only valid ARN is IAM roles for the types of access entries
	// for nodes: . You can use every IAM principal type for STANDARD access entries.
	// You can't use the STS session principal type with access entries because
	// this is a temporary principal for each session and not a permanent identity
	// that can be assigned permissions.
	//
	// IAM best practices (https://docs.aws.amazon.com/IAM/latest/UserGuide/best-practices.html#bp-users-federation-idp)
	// recommend using IAM roles with temporary credentials, rather than IAM users
	// with long-term credentials.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `locationName:"principalArn" type:"string" required:"true"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The type of the new access entry. Valid values are Standard, FARGATE_LINUX,
	// EC2_LINUX, and EC2_WINDOWS.
	//
	// If the principalArn is for an IAM role that's used for self-managed Amazon
	// EC2 nodes, specify EC2_LINUX or EC2_WINDOWS. Amazon EKS grants the necessary
	// permissions to the node for you. If the principalArn is for any other purpose,
	// specify STANDARD. If you don't specify a value, Amazon EKS sets the value
	// to STANDARD. It's unnecessary to create access entries for IAM roles used
	// with Fargate profiles or managed Amazon EC2 nodes, because Amazon EKS creates
	// entries in the aws-auth ConfigMap for the roles. You can't change this value
	// once you've created the access entry.
	//
	// If you set the value to EC2_LINUX or EC2_WINDOWS, you can't specify values
	// for kubernetesGroups, or associate an AccessPolicy to the access entry.
	Type *string `locationName:"type" type:"string"`

	// The username to authenticate to Kubernetes with. We recommend not specifying
	// a username and letting Amazon EKS specify it for you. For more information
	// about the value Amazon EKS specifies for you, or constraints before specifying
	// your own username, see Creating access entries (https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries)
	// in the Amazon EKS User Guide.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAccessEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAccessEntryInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAccessEntryInput) SetClientRequestToken(v string) *CreateAccessEntryInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateAccessEntryInput) SetClusterName(v string) *CreateAccessEntryInput {
	s.ClusterName = &v
	return s
}

// SetKubernetesGroups sets the KubernetesGroups field's value.
func (s *CreateAccessEntryInput) SetKubernetesGroups(v []*string) *CreateAccessEntryInput {
	s.KubernetesGroups = v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *CreateAccessEntryInput) SetPrincipalArn(v string) *CreateAccessEntryInput {
	s.PrincipalArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAccessEntryInput) SetTags(v map[string]*string) *CreateAccessEntryInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateAccessEntryInput) SetType(v string) *CreateAccessEntryInput {
	s.Type = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateAccessEntryInput) SetUsername(v string) *CreateAccessEntryInput {
	s.Username = &v
	return s
}

type CreateAccessEntryOutput struct {
	_ struct{} `type:"structure"`

	// An access entry allows an IAM principal (user or role) to access your cluster.
	// Access entries can replace the need to maintain the aws-auth ConfigMap for
	// authentication. For more information about access entries, see Access entries
	// (https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html) in
	// the Amazon EKS User Guide.
	AccessEntry *AccessEntry `locationName:"accessEntry" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAccessEntryOutput) GoString() string {
	return s.String()
}

// SetAccessEntry sets the AccessEntry field's value.
func (s *CreateAccessEntryOutput) SetAccessEntry(v *AccessEntry) *CreateAccessEntryOutput {
	s.AccessEntry = v
	return s
}

type CreateAddonInput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on. The name must match one of the names returned by
	// DescribeAddonVersions.
	//
	// AddonName is a required field
	AddonName *string `locationName:"addonName" type:"string" required:"true"`

	// The version of the add-on. The version must match one of the versions returned
	// by DescribeAddonVersions (https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The set of configuration values for the add-on that's created. The values
	// that you provide are validated against the schema returned by DescribeAddonConfiguration.
	ConfigurationValues *string `locationName:"configurationValues" type:"string"`

	// An array of Pod Identity Assocations to be created. Each EKS Pod Identity
	// association maps a Kubernetes service account to an IAM Role.
	//
	// For more information, see Attach an IAM Role to an Amazon EKS add-on using
	// Pod Identity (https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html)
	// in the EKS User Guide.
	PodIdentityAssociations []*AddonPodIdentityAssociations `locationName:"podIdentityAssociations" type:"list"`

	// How to resolve field value conflicts for an Amazon EKS add-on. Conflicts
	// are handled based on the value you choose:
	//
	//    * None – If the self-managed version of the add-on is installed on your
	//    cluster, Amazon EKS doesn't change the value. Creation of the add-on might
	//    fail.
	//
	//    * Overwrite – If the self-managed version of the add-on is installed
	//    on your cluster and the Amazon EKS default value is different than the
	//    existing value, Amazon EKS changes the value to the Amazon EKS default
	//    value.
	//
	//    * Preserve – This is similar to the NONE option. If the self-managed
	//    version of the add-on is installed on your cluster Amazon EKS doesn't
	//    change the add-on resource properties. Creation of the add-on might fail
	//    if conflicts are detected. This option works differently during the update
	//    operation. For more information, see UpdateAddon (https://docs.aws.amazon.com/eks/latest/APIReference/API_UpdateAddon.html).
	//
	// If you don't currently have the self-managed version of the add-on installed
	// on your cluster, the Amazon EKS add-on is installed. Amazon EKS sets all
	// values to default values, regardless of the option that you specify.
	ResolveConflicts *string `locationName:"resolveConflicts" type:"string" enum:"ResolveConflicts"`

	// The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's
	// service account. The role must be assigned the IAM permissions required by
	// the add-on. If you don't specify an existing IAM role, then the add-on uses
	// the permissions assigned to the node IAM role. For more information, see
	// Amazon EKS node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
	// in the Amazon EKS User Guide.
	//
	// To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
	// provider created for your cluster. For more information, see Enabling IAM
	// roles for service accounts on your cluster (https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
	// in the Amazon EKS User Guide.
	ServiceAccountRoleArn *string `locationName:"serviceAccountRoleArn" min:"1" type:"string"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAddonInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.ServiceAccountRoleArn != nil && len(*s.ServiceAccountRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceAccountRoleArn", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.PodIdentityAssociations != nil {
		for i, v := range s.PodIdentityAssociations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PodIdentityAssociations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *CreateAddonInput) SetAddonName(v string) *CreateAddonInput {
	s.AddonName = &v
	return s
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *CreateAddonInput) SetAddonVersion(v string) *CreateAddonInput {
	s.AddonVersion = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateAddonInput) SetClientRequestToken(v string) *CreateAddonInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateAddonInput) SetClusterName(v string) *CreateAddonInput {
	s.ClusterName = &v
	return s
}

// SetConfigurationValues sets the ConfigurationValues field's value.
func (s *CreateAddonInput) SetConfigurationValues(v string) *CreateAddonInput {
	s.ConfigurationValues = &v
	return s
}

// SetPodIdentityAssociations sets the PodIdentityAssociations field's value.
func (s *CreateAddonInput) SetPodIdentityAssociations(v []*AddonPodIdentityAssociations) *CreateAddonInput {
	s.PodIdentityAssociations = v
	return s
}

// SetResolveConflicts sets the ResolveConflicts field's value.
func (s *CreateAddonInput) SetResolveConflicts(v string) *CreateAddonInput {
	s.ResolveConflicts = &v
	return s
}

// SetServiceAccountRoleArn sets the ServiceAccountRoleArn field's value.
func (s *CreateAddonInput) SetServiceAccountRoleArn(v string) *CreateAddonInput {
	s.ServiceAccountRoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAddonInput) SetTags(v map[string]*string) *CreateAddonInput {
	s.Tags = v
	return s
}

type CreateAddonOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon EKS add-on. For more information, see Amazon EKS add-ons (https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html)
	// in the Amazon EKS User Guide.
	Addon *Addon `locationName:"addon" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAddonOutput) GoString() string {
	return s.String()
}

// SetAddon sets the Addon field's value.
func (s *CreateAddonOutput) SetAddon(v *Addon) *CreateAddonOutput {
	s.Addon = v
	return s
}

type CreateClusterInput struct {
	_ struct{} `type:"structure"`

	// The access configuration for the cluster.
	AccessConfig *CreateAccessConfigRequest `locationName:"accessConfig" type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The encryption configuration for the cluster.
	EncryptionConfig []*EncryptionConfig `locationName:"encryptionConfig" type:"list"`

	// The Kubernetes network configuration for the cluster.
	KubernetesNetworkConfig *KubernetesNetworkConfigRequest `locationName:"kubernetesNetworkConfig" type:"structure"`

	// Enable or disable exporting the Kubernetes control plane logs for your cluster
	// to CloudWatch Logs. By default, cluster control plane logs aren't exported
	// to CloudWatch Logs. For more information, see Amazon EKS Cluster control
	// plane logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
	// in the Amazon EKS User Guide .
	//
	// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
	// to exported control plane logs. For more information, see CloudWatch Pricing
	// (http://aws.amazon.com/cloudwatch/pricing/).
	Logging *Logging `locationName:"logging" type:"structure"`

	// The unique name to give to your cluster.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// An object representing the configuration of your local Amazon EKS cluster
	// on an Amazon Web Services Outpost. Before creating a local cluster on an
	// Outpost, review Local clusters for Amazon EKS on Amazon Web Services Outposts
	// (https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-overview.html)
	// in the Amazon EKS User Guide. This object isn't available for creating Amazon
	// EKS clusters on the Amazon Web Services cloud.
	OutpostConfig *OutpostConfigRequest `locationName:"outpostConfig" type:"structure"`

	// The VPC configuration that's used by the cluster control plane. Amazon EKS
	// VPC resources have specific requirements to work properly with Kubernetes.
	// For more information, see Cluster VPC Considerations (https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
	// and Cluster Security Group Considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide. You must specify at least two subnets. You
	// can specify up to five security groups. However, we recommend that you use
	// a dedicated security group for your cluster control plane.
	//
	// ResourcesVpcConfig is a required field
	ResourcesVpcConfig *VpcConfigRequest `locationName:"resourcesVpcConfig" type:"structure" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that provides permissions
	// for the Kubernetes control plane to make calls to Amazon Web Services API
	// operations on your behalf. For more information, see Amazon EKS Service IAM
	// Role (https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html)
	// in the Amazon EKS User Guide .
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The desired Kubernetes version for your cluster. If you don't specify a value
	// here, the default version available in Amazon EKS is used.
	//
	// The default version might not be the latest version available.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourcesVpcConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourcesVpcConfig"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.OutpostConfig != nil {
		if err := s.OutpostConfig.Validate(); err != nil {
			invalidParams.AddNested("OutpostConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessConfig sets the AccessConfig field's value.
func (s *CreateClusterInput) SetAccessConfig(v *CreateAccessConfigRequest) *CreateClusterInput {
	s.AccessConfig = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateClusterInput) SetClientRequestToken(v string) *CreateClusterInput {
	s.ClientRequestToken = &v
	return s
}

// SetEncryptionConfig sets the EncryptionConfig field's value.
func (s *CreateClusterInput) SetEncryptionConfig(v []*EncryptionConfig) *CreateClusterInput {
	s.EncryptionConfig = v
	return s
}

// SetKubernetesNetworkConfig sets the KubernetesNetworkConfig field's value.
func (s *CreateClusterInput) SetKubernetesNetworkConfig(v *KubernetesNetworkConfigRequest) *CreateClusterInput {
	s.KubernetesNetworkConfig = v
	return s
}

// SetLogging sets the Logging field's value.
func (s *CreateClusterInput) SetLogging(v *Logging) *CreateClusterInput {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateClusterInput) SetName(v string) *CreateClusterInput {
	s.Name = &v
	return s
}

// SetOutpostConfig sets the OutpostConfig field's value.
func (s *CreateClusterInput) SetOutpostConfig(v *OutpostConfigRequest) *CreateClusterInput {
	s.OutpostConfig = v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *CreateClusterInput) SetResourcesVpcConfig(v *VpcConfigRequest) *CreateClusterInput {
	s.ResourcesVpcConfig = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateClusterInput) SetRoleArn(v string) *CreateClusterInput {
	s.RoleArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateClusterInput) SetTags(v map[string]*string) *CreateClusterInput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateClusterInput) SetVersion(v string) *CreateClusterInput {
	s.Version = &v
	return s
}

type CreateClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *CreateClusterOutput) SetCluster(v *Cluster) *CreateClusterOutput {
	s.Cluster = v
	return s
}

type CreateEksAnywhereSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether the subscription auto renews at the end of the
	// term.
	AutoRenew *bool `locationName:"autoRenew" type:"boolean"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The number of licenses to purchase with the subscription. Valid values are
	// between 1 and 100. This value can't be changed after creating the subscription.
	LicenseQuantity *int64 `locationName:"licenseQuantity" type:"integer"`

	// The license type for all licenses in the subscription. Valid value is CLUSTER.
	// With the CLUSTER license type, each license covers support for a single EKS
	// Anywhere cluster.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"EksAnywhereSubscriptionLicenseType"`

	// The unique name for your subscription. It must be unique in your Amazon Web
	// Services account in the Amazon Web Services Region you're creating the subscription
	// in. The name can contain only alphanumeric characters (case-sensitive), hyphens,
	// and underscores. It must start with an alphabetic character and can't be
	// longer than 100 characters.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The metadata for a subscription to assist with categorization and organization.
	// Each tag consists of a key and an optional value. Subscription tags don't
	// propagate to any other resources associated with the subscription.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// An object representing the term duration and term unit type of your subscription.
	// This determines the term length of your subscription. Valid values are MONTHS
	// for term unit and 12 or 36 for term duration, indicating a 12 month or 36
	// month subscription. This value cannot be changed after creating the subscription.
	//
	// Term is a required field
	Term *EksAnywhereSubscriptionTerm `locationName:"term" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEksAnywhereSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEksAnywhereSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEksAnywhereSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEksAnywhereSubscriptionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Term == nil {
		invalidParams.Add(request.NewErrParamRequired("Term"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *CreateEksAnywhereSubscriptionInput) SetAutoRenew(v bool) *CreateEksAnywhereSubscriptionInput {
	s.AutoRenew = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateEksAnywhereSubscriptionInput) SetClientRequestToken(v string) *CreateEksAnywhereSubscriptionInput {
	s.ClientRequestToken = &v
	return s
}

// SetLicenseQuantity sets the LicenseQuantity field's value.
func (s *CreateEksAnywhereSubscriptionInput) SetLicenseQuantity(v int64) *CreateEksAnywhereSubscriptionInput {
	s.LicenseQuantity = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *CreateEksAnywhereSubscriptionInput) SetLicenseType(v string) *CreateEksAnywhereSubscriptionInput {
	s.LicenseType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEksAnywhereSubscriptionInput) SetName(v string) *CreateEksAnywhereSubscriptionInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEksAnywhereSubscriptionInput) SetTags(v map[string]*string) *CreateEksAnywhereSubscriptionInput {
	s.Tags = v
	return s
}

// SetTerm sets the Term field's value.
func (s *CreateEksAnywhereSubscriptionInput) SetTerm(v *EksAnywhereSubscriptionTerm) *CreateEksAnywhereSubscriptionInput {
	s.Term = v
	return s
}

type CreateEksAnywhereSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the subscription.
	Subscription *EksAnywhereSubscription `locationName:"subscription" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEksAnywhereSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEksAnywhereSubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscription sets the Subscription field's value.
func (s *CreateEksAnywhereSubscriptionOutput) SetSubscription(v *EksAnywhereSubscription) *CreateEksAnywhereSubscriptionOutput {
	s.Subscription = v
	return s
}

type CreateFargateProfileInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `locationName:"fargateProfileName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the Pod execution role to use for a Pod
	// that matches the selectors in the Fargate profile. The Pod execution role
	// allows Fargate infrastructure to register with your cluster as a node, and
	// it provides read access to Amazon ECR image repositories. For more information,
	// see Pod execution role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
	// in the Amazon EKS User Guide.
	//
	// PodExecutionRoleArn is a required field
	PodExecutionRoleArn *string `locationName:"podExecutionRoleArn" type:"string" required:"true"`

	// The selectors to match for a Pod to use this Fargate profile. Each selector
	// must have an associated Kubernetes namespace. Optionally, you can also specify
	// labels for a namespace. You may specify up to five selectors in a Fargate
	// profile.
	Selectors []*FargateProfileSelector `locationName:"selectors" type:"list"`

	// The IDs of subnets to launch a Pod into. A Pod running on Fargate isn't assigned
	// a public IP address, so only private subnets (with no direct route to an
	// Internet Gateway) are accepted for this parameter.
	Subnets []*string `locationName:"subnets" type:"list"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.PodExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PodExecutionRoleArn"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateFargateProfileInput) SetClientRequestToken(v string) *CreateFargateProfileInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateFargateProfileInput) SetClusterName(v string) *CreateFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *CreateFargateProfileInput) SetFargateProfileName(v string) *CreateFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

// SetPodExecutionRoleArn sets the PodExecutionRoleArn field's value.
func (s *CreateFargateProfileInput) SetPodExecutionRoleArn(v string) *CreateFargateProfileInput {
	s.PodExecutionRoleArn = &v
	return s
}

// SetSelectors sets the Selectors field's value.
func (s *CreateFargateProfileInput) SetSelectors(v []*FargateProfileSelector) *CreateFargateProfileInput {
	s.Selectors = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *CreateFargateProfileInput) SetSubnets(v []*string) *CreateFargateProfileInput {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFargateProfileInput) SetTags(v map[string]*string) *CreateFargateProfileInput {
	s.Tags = v
	return s
}

type CreateFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *CreateFargateProfileOutput) SetFargateProfile(v *FargateProfile) *CreateFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type CreateNodegroupInput struct {
	_ struct{} `type:"structure"`

	// The AMI type for your node group. If you specify launchTemplate, and your
	// launch template uses a custom AMI, then don't specify amiType, or the node
	// group deployment will fail. If your launch template uses a Windows custom
	// AMI, then add eks:kube-proxy-windows to your Windows nodes rolearn in the
	// aws-auth ConfigMap. For more information about using launch templates with
	// Amazon EKS, see Customizing managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	AmiType *string `locationName:"amiType" type:"string" enum:"AMITypes"`

	// The capacity type for your node group.
	CapacityType *string `locationName:"capacityType" type:"string" enum:"CapacityTypes"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The root device disk size (in GiB) for your node group instances. The default
	// disk size is 20 GiB for Linux and Bottlerocket. The default disk size is
	// 50 GiB for Windows. If you specify launchTemplate, then don't specify diskSize,
	// or the node group deployment will fail. For more information about using
	// launch templates with Amazon EKS, see Customizing managed nodes with launch
	// templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	DiskSize *int64 `locationName:"diskSize" type:"integer"`

	// Specify the instance types for a node group. If you specify a GPU instance
	// type, make sure to also specify an applicable GPU AMI type with the amiType
	// parameter. If you specify launchTemplate, then you can specify zero or one
	// instance type in your launch template or you can specify 0-20 instance types
	// for instanceTypes. If however, you specify an instance type in your launch
	// template and specify any instanceTypes, the node group deployment will fail.
	// If you don't specify an instance type in a launch template or for instanceTypes,
	// then t3.medium is used, by default. If you specify Spot for capacityType,
	// then we recommend specifying multiple values for instanceTypes. For more
	// information, see Managed node group capacity types (https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html#managed-node-group-capacity-types)
	// and Customizing managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The Kubernetes labels to apply to the nodes in the node group when they are
	// created.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// An object representing a node group's launch template specification. When
	// using this object, don't directly specify instanceTypes, diskSize, or remoteAccess.
	// Make sure that the launch template meets the requirements in launchTemplateSpecification.
	// Also refer to Customizing managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with your node
	// group. The Amazon EKS worker node kubelet daemon makes calls to Amazon Web
	// Services APIs on your behalf. Nodes receive permissions for these API calls
	// through an IAM instance profile and associated policies. Before you can launch
	// nodes and register them into a cluster, you must create an IAM role for those
	// nodes to use when they are launched. For more information, see Amazon EKS
	// node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
	// in the Amazon EKS User Guide . If you specify launchTemplate, then don't
	// specify IamInstanceProfile (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html)
	// in your launch template, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Customizing
	// managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	//
	// NodeRole is a required field
	NodeRole *string `locationName:"nodeRole" type:"string" required:"true"`

	// The unique name to give your node group.
	//
	// NodegroupName is a required field
	NodegroupName *string `locationName:"nodegroupName" type:"string" required:"true"`

	// The AMI version of the Amazon EKS optimized AMI to use with your node group.
	// By default, the latest available AMI version for the node group's current
	// Kubernetes version is used. For information about Linux versions, see Amazon
	// EKS optimized Amazon Linux AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide. Amazon EKS managed node groups support the
	// November 2022 and later releases of the Windows AMIs. For information about
	// Windows versions, see Amazon EKS optimized Windows AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html)
	// in the Amazon EKS User Guide.
	//
	// If you specify launchTemplate, and your launch template uses a custom AMI,
	// then don't specify releaseVersion, or the node group deployment will fail.
	// For more information about using launch templates with Amazon EKS, see Customizing
	// managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The remote access configuration to use with your node group. For Linux, the
	// protocol is SSH. For Windows, the protocol is RDP. If you specify launchTemplate,
	// then don't specify remoteAccess, or the node group deployment will fail.
	// For more information about using launch templates with Amazon EKS, see Customizing
	// managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	RemoteAccess *RemoteAccessConfig `locationName:"remoteAccess" type:"structure"`

	// The scaling configuration details for the Auto Scaling group that is created
	// for your node group.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The subnets to use for the Auto Scaling group that is created for your node
	// group. If you specify launchTemplate, then don't specify SubnetId (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html)
	// in your launch template, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Customizing
	// managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	//
	// Subnets is a required field
	Subnets []*string `locationName:"subnets" type:"list" required:"true"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes taints to be applied to the nodes in the node group. For more
	// information, see Node taints on managed node groups (https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
	Taints []*Taint `locationName:"taints" type:"list"`

	// The node group update configuration.
	UpdateConfig *NodegroupUpdateConfig `locationName:"updateConfig" type:"structure"`

	// The Kubernetes version to use for your managed nodes. By default, the Kubernetes
	// version of the cluster is used, and this is the only accepted specified value.
	// If you specify launchTemplate, and your launch template uses a custom AMI,
	// then don't specify version, or the node group deployment will fail. For more
	// information about using launch templates with Amazon EKS, see Customizing
	// managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodeRole == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeRole"))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ScalingConfig != nil {
		if err := s.ScalingConfig.Validate(); err != nil {
			invalidParams.AddNested("ScalingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Taints != nil {
		for i, v := range s.Taints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Taints", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UpdateConfig != nil {
		if err := s.UpdateConfig.Validate(); err != nil {
			invalidParams.AddNested("UpdateConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmiType sets the AmiType field's value.
func (s *CreateNodegroupInput) SetAmiType(v string) *CreateNodegroupInput {
	s.AmiType = &v
	return s
}

// SetCapacityType sets the CapacityType field's value.
func (s *CreateNodegroupInput) SetCapacityType(v string) *CreateNodegroupInput {
	s.CapacityType = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateNodegroupInput) SetClientRequestToken(v string) *CreateNodegroupInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreateNodegroupInput) SetClusterName(v string) *CreateNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetDiskSize sets the DiskSize field's value.
func (s *CreateNodegroupInput) SetDiskSize(v int64) *CreateNodegroupInput {
	s.DiskSize = &v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *CreateNodegroupInput) SetInstanceTypes(v []*string) *CreateNodegroupInput {
	s.InstanceTypes = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *CreateNodegroupInput) SetLabels(v map[string]*string) *CreateNodegroupInput {
	s.Labels = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *CreateNodegroupInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *CreateNodegroupInput {
	s.LaunchTemplate = v
	return s
}

// SetNodeRole sets the NodeRole field's value.
func (s *CreateNodegroupInput) SetNodeRole(v string) *CreateNodegroupInput {
	s.NodeRole = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *CreateNodegroupInput) SetNodegroupName(v string) *CreateNodegroupInput {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *CreateNodegroupInput) SetReleaseVersion(v string) *CreateNodegroupInput {
	s.ReleaseVersion = &v
	return s
}

// SetRemoteAccess sets the RemoteAccess field's value.
func (s *CreateNodegroupInput) SetRemoteAccess(v *RemoteAccessConfig) *CreateNodegroupInput {
	s.RemoteAccess = v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *CreateNodegroupInput) SetScalingConfig(v *NodegroupScalingConfig) *CreateNodegroupInput {
	s.ScalingConfig = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *CreateNodegroupInput) SetSubnets(v []*string) *CreateNodegroupInput {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNodegroupInput) SetTags(v map[string]*string) *CreateNodegroupInput {
	s.Tags = v
	return s
}

// SetTaints sets the Taints field's value.
func (s *CreateNodegroupInput) SetTaints(v []*Taint) *CreateNodegroupInput {
	s.Taints = v
	return s
}

// SetUpdateConfig sets the UpdateConfig field's value.
func (s *CreateNodegroupInput) SetUpdateConfig(v *NodegroupUpdateConfig) *CreateNodegroupInput {
	s.UpdateConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateNodegroupInput) SetVersion(v string) *CreateNodegroupInput {
	s.Version = &v
	return s
}

type CreateNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *CreateNodegroupOutput) SetNodegroup(v *Nodegroup) *CreateNodegroupOutput {
	s.Nodegroup = v
	return s
}

type CreatePodIdentityAssociationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster to create the association in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Kubernetes namespace inside the cluster to create the association
	// in. The service account and the pods that use the service account must be
	// in this namespace.
	//
	// Namespace is a required field
	Namespace *string `locationName:"namespace" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with the service
	// account. The EKS Pod Identity agent manages credentials to assume this role
	// for applications in the containers in the pods that use this service account.
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The name of the Kubernetes service account inside the cluster to associate
	// the IAM credentials with.
	//
	// ServiceAccount is a required field
	ServiceAccount *string `locationName:"serviceAccount" type:"string" required:"true"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource – 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length – 128 Unicode characters in UTF-8
	//
	//    * Maximum value length – 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePodIdentityAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePodIdentityAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePodIdentityAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePodIdentityAssociationInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.ServiceAccount == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccount"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreatePodIdentityAssociationInput) SetClientRequestToken(v string) *CreatePodIdentityAssociationInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *CreatePodIdentityAssociationInput) SetClusterName(v string) *CreatePodIdentityAssociationInput {
	s.ClusterName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreatePodIdentityAssociationInput) SetNamespace(v string) *CreatePodIdentityAssociationInput {
	s.Namespace = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreatePodIdentityAssociationInput) SetRoleArn(v string) *CreatePodIdentityAssociationInput {
	s.RoleArn = &v
	return s
}

// SetServiceAccount sets the ServiceAccount field's value.
func (s *CreatePodIdentityAssociationInput) SetServiceAccount(v string) *CreatePodIdentityAssociationInput {
	s.ServiceAccount = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePodIdentityAssociationInput) SetTags(v map[string]*string) *CreatePodIdentityAssociationInput {
	s.Tags = v
	return s
}

type CreatePodIdentityAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your new association.
	//
	// The description includes an ID for the association. Use the ID of the association
	// in further actions to manage the association.
	Association *PodIdentityAssociation `locationName:"association" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePodIdentityAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreatePodIdentityAssociationOutput) GoString() string {
	return s.String()
}

// SetAssociation sets the Association field's value.
func (s *CreatePodIdentityAssociationOutput) SetAssociation(v *PodIdentityAssociation) *CreatePodIdentityAssociationOutput {
	s.Association = v
	return s
}

type DeleteAccessEntryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The ARN of the IAM principal for the AccessEntry.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `location:"uri" locationName:"principalArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAccessEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAccessEntryInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}
	if s.PrincipalArn != nil && len(*s.PrincipalArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteAccessEntryInput) SetClusterName(v string) *DeleteAccessEntryInput {
	s.ClusterName = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *DeleteAccessEntryInput) SetPrincipalArn(v string) *DeleteAccessEntryInput {
	s.PrincipalArn = &v
	return s
}

type DeleteAccessEntryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAccessEntryOutput) GoString() string {
	return s.String()
}

type DeleteAddonInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	//
	// AddonName is a required field
	AddonName *string `location:"uri" locationName:"addonName" type:"string" required:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// Specifying this option preserves the add-on software on your cluster but
	// Amazon EKS stops managing any settings for the add-on. If an IAM account
	// is associated with the add-on, it isn't removed.
	Preserve *bool `location:"querystring" locationName:"preserve" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAddonInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.AddonName != nil && len(*s.AddonName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddonName", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DeleteAddonInput) SetAddonName(v string) *DeleteAddonInput {
	s.AddonName = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteAddonInput) SetClusterName(v string) *DeleteAddonInput {
	s.ClusterName = &v
	return s
}

// SetPreserve sets the Preserve field's value.
func (s *DeleteAddonInput) SetPreserve(v bool) *DeleteAddonInput {
	s.Preserve = &v
	return s
}

type DeleteAddonOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon EKS add-on. For more information, see Amazon EKS add-ons (https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html)
	// in the Amazon EKS User Guide.
	Addon *Addon `locationName:"addon" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAddonOutput) GoString() string {
	return s.String()
}

// SetAddon sets the Addon field's value.
func (s *DeleteAddonOutput) SetAddon(v *Addon) *DeleteAddonOutput {
	s.Addon = v
	return s
}

type DeleteClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the cluster to delete.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteClusterInput) SetName(v string) *DeleteClusterInput {
	s.Name = &v
	return s
}

type DeleteClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the cluster to delete.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeleteClusterOutput) SetCluster(v *Cluster) *DeleteClusterOutput {
	s.Cluster = v
	return s
}

type DeleteEksAnywhereSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the subscription.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEksAnywhereSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEksAnywhereSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEksAnywhereSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEksAnywhereSubscriptionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteEksAnywhereSubscriptionInput) SetId(v string) *DeleteEksAnywhereSubscriptionInput {
	s.Id = &v
	return s
}

type DeleteEksAnywhereSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the subscription to be deleted.
	Subscription *EksAnywhereSubscription `locationName:"subscription" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEksAnywhereSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEksAnywhereSubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscription sets the Subscription field's value.
func (s *DeleteEksAnywhereSubscriptionOutput) SetSubscription(v *EksAnywhereSubscription) *DeleteEksAnywhereSubscriptionOutput {
	s.Subscription = v
	return s
}

type DeleteFargateProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile to delete.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `location:"uri" locationName:"fargateProfileName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.FargateProfileName != nil && len(*s.FargateProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FargateProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteFargateProfileInput) SetClusterName(v string) *DeleteFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *DeleteFargateProfileInput) SetFargateProfileName(v string) *DeleteFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

type DeleteFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The deleted Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *DeleteFargateProfileOutput) SetFargateProfile(v *FargateProfile) *DeleteFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type DeleteNodegroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the node group to delete.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DeleteNodegroupInput) SetClusterName(v string) *DeleteNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DeleteNodegroupInput) SetNodegroupName(v string) *DeleteNodegroupInput {
	s.NodegroupName = &v
	return s
}

type DeleteNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your deleted node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *DeleteNodegroupOutput) SetNodegroup(v *Nodegroup) *DeleteNodegroupOutput {
	s.Nodegroup = v
	return s
}

type DeletePodIdentityAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the association to be deleted.
	//
	// AssociationId is a required field
	AssociationId *string `location:"uri" locationName:"associationId" type:"string" required:"true"`

	// The cluster name that
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePodIdentityAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePodIdentityAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePodIdentityAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePodIdentityAssociationInput"}
	if s.AssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationId"))
	}
	if s.AssociationId != nil && len(*s.AssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationId", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationId sets the AssociationId field's value.
func (s *DeletePodIdentityAssociationInput) SetAssociationId(v string) *DeletePodIdentityAssociationInput {
	s.AssociationId = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DeletePodIdentityAssociationInput) SetClusterName(v string) *DeletePodIdentityAssociationInput {
	s.ClusterName = &v
	return s
}

type DeletePodIdentityAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the EKS Pod Identity association that was deleted.
	Association *PodIdentityAssociation `locationName:"association" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePodIdentityAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeletePodIdentityAssociationOutput) GoString() string {
	return s.String()
}

// SetAssociation sets the Association field's value.
func (s *DeletePodIdentityAssociationOutput) SetAssociation(v *PodIdentityAssociation) *DeletePodIdentityAssociationOutput {
	s.Association = v
	return s
}

// The summary information about deprecated resource usage for an insight check
// in the UPGRADE_READINESS category.
type DeprecationDetail struct {
	_ struct{} `type:"structure"`

	// Details about Kubernetes clients using the deprecated resources.
	ClientStats []*ClientStat `locationName:"clientStats" type:"list"`

	// The newer version of the resource to migrate to if applicable.
	ReplacedWith *string `locationName:"replacedWith" type:"string"`

	// The version of the software where the newer resource version became available
	// to migrate to if applicable.
	StartServingReplacementVersion *string `locationName:"startServingReplacementVersion" type:"string"`

	// The version of the software where the deprecated resource version will stop
	// being served.
	StopServingVersion *string `locationName:"stopServingVersion" type:"string"`

	// The deprecated version of the resource.
	Usage *string `locationName:"usage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeprecationDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeprecationDetail) GoString() string {
	return s.String()
}

// SetClientStats sets the ClientStats field's value.
func (s *DeprecationDetail) SetClientStats(v []*ClientStat) *DeprecationDetail {
	s.ClientStats = v
	return s
}

// SetReplacedWith sets the ReplacedWith field's value.
func (s *DeprecationDetail) SetReplacedWith(v string) *DeprecationDetail {
	s.ReplacedWith = &v
	return s
}

// SetStartServingReplacementVersion sets the StartServingReplacementVersion field's value.
func (s *DeprecationDetail) SetStartServingReplacementVersion(v string) *DeprecationDetail {
	s.StartServingReplacementVersion = &v
	return s
}

// SetStopServingVersion sets the StopServingVersion field's value.
func (s *DeprecationDetail) SetStopServingVersion(v string) *DeprecationDetail {
	s.StopServingVersion = &v
	return s
}

// SetUsage sets the Usage field's value.
func (s *DeprecationDetail) SetUsage(v string) *DeprecationDetail {
	s.Usage = &v
	return s
}

type DeregisterClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the connected cluster to deregister.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeregisterClusterInput) SetName(v string) *DeregisterClusterInput {
	s.Name = &v
	return s
}

type DeregisterClusterOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an Amazon EKS cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DeregisterClusterOutput) SetCluster(v *Cluster) *DeregisterClusterOutput {
	s.Cluster = v
	return s
}

type DescribeAccessEntryInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The ARN of the IAM principal for the AccessEntry.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `location:"uri" locationName:"principalArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccessEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccessEntryInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}
	if s.PrincipalArn != nil && len(*s.PrincipalArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeAccessEntryInput) SetClusterName(v string) *DescribeAccessEntryInput {
	s.ClusterName = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *DescribeAccessEntryInput) SetPrincipalArn(v string) *DescribeAccessEntryInput {
	s.PrincipalArn = &v
	return s
}

type DescribeAccessEntryOutput struct {
	_ struct{} `type:"structure"`

	// Information about the access entry.
	AccessEntry *AccessEntry `locationName:"accessEntry" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccessEntryOutput) GoString() string {
	return s.String()
}

// SetAccessEntry sets the AccessEntry field's value.
func (s *DescribeAccessEntryOutput) SetAccessEntry(v *AccessEntry) *DescribeAccessEntryOutput {
	s.AccessEntry = v
	return s
}

type DescribeAddonConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the add-on. The name must match one of the names returned by
	// DescribeAddonVersions.
	//
	// AddonName is a required field
	AddonName *string `location:"querystring" locationName:"addonName" type:"string" required:"true"`

	// The version of the add-on. The version must match one of the versions returned
	// by DescribeAddonVersions (https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
	//
	// AddonVersion is a required field
	AddonVersion *string `location:"querystring" locationName:"addonVersion" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddonConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddonConfigurationInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.AddonVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonVersion"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DescribeAddonConfigurationInput) SetAddonName(v string) *DescribeAddonConfigurationInput {
	s.AddonName = &v
	return s
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *DescribeAddonConfigurationInput) SetAddonVersion(v string) *DescribeAddonConfigurationInput {
	s.AddonVersion = &v
	return s
}

type DescribeAddonConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on.
	AddonName *string `locationName:"addonName" type:"string"`

	// The version of the add-on. The version must match one of the versions returned
	// by DescribeAddonVersions (https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// A JSON schema that's used to validate the configuration values you provide
	// when an add-on is created or updated.
	ConfigurationSchema *string `locationName:"configurationSchema" type:"string"`

	// The Kubernetes service account name used by the addon, and any suggested
	// IAM policies. Use this information to create an IAM Role for the Addon.
	PodIdentityConfiguration []*AddonPodIdentityConfiguration `locationName:"podIdentityConfiguration" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonConfigurationOutput) GoString() string {
	return s.String()
}

// SetAddonName sets the AddonName field's value.
func (s *DescribeAddonConfigurationOutput) SetAddonName(v string) *DescribeAddonConfigurationOutput {
	s.AddonName = &v
	return s
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *DescribeAddonConfigurationOutput) SetAddonVersion(v string) *DescribeAddonConfigurationOutput {
	s.AddonVersion = &v
	return s
}

// SetConfigurationSchema sets the ConfigurationSchema field's value.
func (s *DescribeAddonConfigurationOutput) SetConfigurationSchema(v string) *DescribeAddonConfigurationOutput {
	s.ConfigurationSchema = &v
	return s
}

// SetPodIdentityConfiguration sets the PodIdentityConfiguration field's value.
func (s *DescribeAddonConfigurationOutput) SetPodIdentityConfiguration(v []*AddonPodIdentityConfiguration) *DescribeAddonConfigurationOutput {
	s.PodIdentityConfiguration = v
	return s
}

type DescribeAddonInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	//
	// AddonName is a required field
	AddonName *string `location:"uri" locationName:"addonName" type:"string" required:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddonInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.AddonName != nil && len(*s.AddonName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddonName", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DescribeAddonInput) SetAddonName(v string) *DescribeAddonInput {
	s.AddonName = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeAddonInput) SetClusterName(v string) *DescribeAddonInput {
	s.ClusterName = &v
	return s
}

type DescribeAddonOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon EKS add-on. For more information, see Amazon EKS add-ons (https://docs.aws.amazon.com/eks/latest/userguide/eks-add-ons.html)
	// in the Amazon EKS User Guide.
	Addon *Addon `locationName:"addon" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonOutput) GoString() string {
	return s.String()
}

// SetAddon sets the Addon field's value.
func (s *DescribeAddonOutput) SetAddon(v *Addon) *DescribeAddonOutput {
	s.Addon = v
	return s
}

type DescribeAddonVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	AddonName *string `location:"querystring" locationName:"addonName" type:"string"`

	// The Kubernetes versions that you can use the add-on with.
	KubernetesVersion *string `location:"querystring" locationName:"kubernetesVersion" type:"string"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The owner of the add-on. For valid owners, don't specify a value for this
	// property.
	Owners []*string `location:"querystring" locationName:"owners" type:"list"`

	// The publisher of the add-on. For valid publishers, don't specify a value
	// for this property.
	Publishers []*string `location:"querystring" locationName:"publishers" type:"list"`

	// The type of the add-on. For valid types, don't specify a value for this property.
	Types []*string `location:"querystring" locationName:"types" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddonVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddonVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DescribeAddonVersionsInput) SetAddonName(v string) *DescribeAddonVersionsInput {
	s.AddonName = &v
	return s
}

// SetKubernetesVersion sets the KubernetesVersion field's value.
func (s *DescribeAddonVersionsInput) SetKubernetesVersion(v string) *DescribeAddonVersionsInput {
	s.KubernetesVersion = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeAddonVersionsInput) SetMaxResults(v int64) *DescribeAddonVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAddonVersionsInput) SetNextToken(v string) *DescribeAddonVersionsInput {
	s.NextToken = &v
	return s
}

// SetOwners sets the Owners field's value.
func (s *DescribeAddonVersionsInput) SetOwners(v []*string) *DescribeAddonVersionsInput {
	s.Owners = v
	return s
}

// SetPublishers sets the Publishers field's value.
func (s *DescribeAddonVersionsInput) SetPublishers(v []*string) *DescribeAddonVersionsInput {
	s.Publishers = v
	return s
}

// SetTypes sets the Types field's value.
func (s *DescribeAddonVersionsInput) SetTypes(v []*string) *DescribeAddonVersionsInput {
	s.Types = v
	return s
}

type DescribeAddonVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The list of available versions with Kubernetes version compatibility and
	// other properties.
	Addons []*AddonInfo `locationName:"addons" type:"list"`

	// The nextToken value to include in a future DescribeAddonVersions request.
	// When the results of a DescribeAddonVersions request exceed maxResults, you
	// can use this value to retrieve the next page of results. This value is null
	// when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAddonVersionsOutput) GoString() string {
	return s.String()
}

// SetAddons sets the Addons field's value.
func (s *DescribeAddonVersionsOutput) SetAddons(v []*AddonInfo) *DescribeAddonVersionsOutput {
	s.Addons = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAddonVersionsOutput) SetNextToken(v string) *DescribeAddonVersionsOutput {
	s.NextToken = &v
	return s
}

type DescribeClusterInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClusterInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DescribeClusterInput) SetName(v string) *DescribeClusterInput {
	s.Name = &v
	return s
}

type DescribeClusterOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your specified cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *DescribeClusterOutput) SetCluster(v *Cluster) *DescribeClusterOutput {
	s.Cluster = v
	return s
}

type DescribeEksAnywhereSubscriptionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the subscription.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEksAnywhereSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEksAnywhereSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEksAnywhereSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEksAnywhereSubscriptionInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeEksAnywhereSubscriptionInput) SetId(v string) *DescribeEksAnywhereSubscriptionInput {
	s.Id = &v
	return s
}

type DescribeEksAnywhereSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the subscription.
	Subscription *EksAnywhereSubscription `locationName:"subscription" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEksAnywhereSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeEksAnywhereSubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscription sets the Subscription field's value.
func (s *DescribeEksAnywhereSubscriptionOutput) SetSubscription(v *EksAnywhereSubscription) *DescribeEksAnywhereSubscriptionOutput {
	s.Subscription = v
	return s
}

type DescribeFargateProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Fargate profile to describe.
	//
	// FargateProfileName is a required field
	FargateProfileName *string `location:"uri" locationName:"fargateProfileName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFargateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFargateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFargateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFargateProfileInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.FargateProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("FargateProfileName"))
	}
	if s.FargateProfileName != nil && len(*s.FargateProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FargateProfileName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeFargateProfileInput) SetClusterName(v string) *DescribeFargateProfileInput {
	s.ClusterName = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *DescribeFargateProfileInput) SetFargateProfileName(v string) *DescribeFargateProfileInput {
	s.FargateProfileName = &v
	return s
}

type DescribeFargateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your Fargate profile.
	FargateProfile *FargateProfile `locationName:"fargateProfile" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFargateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFargateProfileOutput) GoString() string {
	return s.String()
}

// SetFargateProfile sets the FargateProfile field's value.
func (s *DescribeFargateProfileOutput) SetFargateProfile(v *FargateProfile) *DescribeFargateProfileOutput {
	s.FargateProfile = v
	return s
}

type DescribeIdentityProviderConfigInput struct {
	_ struct{} `type:"structure"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object representing an identity provider configuration.
	//
	// IdentityProviderConfig is a required field
	IdentityProviderConfig *IdentityProviderConfig `locationName:"identityProviderConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIdentityProviderConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIdentityProviderConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.IdentityProviderConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderConfig"))
	}
	if s.IdentityProviderConfig != nil {
		if err := s.IdentityProviderConfig.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeIdentityProviderConfigInput) SetClusterName(v string) *DescribeIdentityProviderConfigInput {
	s.ClusterName = &v
	return s
}

// SetIdentityProviderConfig sets the IdentityProviderConfig field's value.
func (s *DescribeIdentityProviderConfigInput) SetIdentityProviderConfig(v *IdentityProviderConfig) *DescribeIdentityProviderConfigInput {
	s.IdentityProviderConfig = v
	return s
}

type DescribeIdentityProviderConfigOutput struct {
	_ struct{} `type:"structure"`

	// The object that represents an OpenID Connect (OIDC) identity provider configuration.
	IdentityProviderConfig *IdentityProviderConfigResponse `locationName:"identityProviderConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIdentityProviderConfigOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderConfig sets the IdentityProviderConfig field's value.
func (s *DescribeIdentityProviderConfigOutput) SetIdentityProviderConfig(v *IdentityProviderConfigResponse) *DescribeIdentityProviderConfigOutput {
	s.IdentityProviderConfig = v
	return s
}

type DescribeInsightInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the cluster to describe the insight for.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The identity of the insight to describe.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInsightInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInsightInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeInsightInput) SetClusterName(v string) *DescribeInsightInput {
	s.ClusterName = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeInsightInput) SetId(v string) *DescribeInsightInput {
	s.Id = &v
	return s
}

type DescribeInsightOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the insight.
	Insight *Insight `locationName:"insight" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeInsightOutput) GoString() string {
	return s.String()
}

// SetInsight sets the Insight field's value.
func (s *DescribeInsightOutput) SetInsight(v *Insight) *DescribeInsightOutput {
	s.Insight = v
	return s
}

type DescribeNodegroupInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the node group to describe.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodegroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodegroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNodegroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNodegroupInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribeNodegroupInput) SetClusterName(v string) *DescribeNodegroupInput {
	s.ClusterName = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DescribeNodegroupInput) SetNodegroupName(v string) *DescribeNodegroupInput {
	s.NodegroupName = &v
	return s
}

type DescribeNodegroupOutput struct {
	_ struct{} `type:"structure"`

	// The full description of your node group.
	Nodegroup *Nodegroup `locationName:"nodegroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodegroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeNodegroupOutput) GoString() string {
	return s.String()
}

// SetNodegroup sets the Nodegroup field's value.
func (s *DescribeNodegroupOutput) SetNodegroup(v *Nodegroup) *DescribeNodegroupOutput {
	s.Nodegroup = v
	return s
}

type DescribePodIdentityAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the association that you want the description of.
	//
	// AssociationId is a required field
	AssociationId *string `location:"uri" locationName:"associationId" type:"string" required:"true"`

	// The name of the cluster that the association is in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePodIdentityAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePodIdentityAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePodIdentityAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePodIdentityAssociationInput"}
	if s.AssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationId"))
	}
	if s.AssociationId != nil && len(*s.AssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationId", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationId sets the AssociationId field's value.
func (s *DescribePodIdentityAssociationInput) SetAssociationId(v string) *DescribePodIdentityAssociationInput {
	s.AssociationId = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DescribePodIdentityAssociationInput) SetClusterName(v string) *DescribePodIdentityAssociationInput {
	s.ClusterName = &v
	return s
}

type DescribePodIdentityAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the EKS Pod Identity association.
	Association *PodIdentityAssociation `locationName:"association" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePodIdentityAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribePodIdentityAssociationOutput) GoString() string {
	return s.String()
}

// SetAssociation sets the Association field's value.
func (s *DescribePodIdentityAssociationOutput) SetAssociation(v *PodIdentityAssociation) *DescribePodIdentityAssociationOutput {
	s.Association = v
	return s
}

// Describes an update request.
type DescribeUpdateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	// This parameter is required if the update is an add-on update.
	AddonName *string `location:"querystring" locationName:"addonName" type:"string"`

	// The name of the Amazon EKS cluster associated with the update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The name of the Amazon EKS node group associated with the update. This parameter
	// is required if the update is a node group update.
	NodegroupName *string `location:"querystring" locationName:"nodegroupName" type:"string"`

	// The ID of the update to describe.
	//
	// UpdateId is a required field
	UpdateId *string `location:"uri" locationName:"updateId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUpdateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUpdateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUpdateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeUpdateInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.UpdateId == nil {
		invalidParams.Add(request.NewErrParamRequired("UpdateId"))
	}
	if s.UpdateId != nil && len(*s.UpdateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UpdateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *DescribeUpdateInput) SetAddonName(v string) *DescribeUpdateInput {
	s.AddonName = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeUpdateInput) SetName(v string) *DescribeUpdateInput {
	s.Name = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *DescribeUpdateInput) SetNodegroupName(v string) *DescribeUpdateInput {
	s.NodegroupName = &v
	return s
}

// SetUpdateId sets the UpdateId field's value.
func (s *DescribeUpdateInput) SetUpdateId(v string) *DescribeUpdateInput {
	s.UpdateId = &v
	return s
}

type DescribeUpdateOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the specified update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUpdateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeUpdateOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *DescribeUpdateOutput) SetUpdate(v *Update) *DescribeUpdateOutput {
	s.Update = v
	return s
}

type DisassociateAccessPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The ARN of the policy to disassociate from the access entry. For a list of
	// associated policies ARNs, use ListAssociatedAccessPolicies.
	//
	// PolicyArn is a required field
	PolicyArn *string `location:"uri" locationName:"policyArn" type:"string" required:"true"`

	// The ARN of the IAM principal for the AccessEntry.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `location:"uri" locationName:"principalArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAccessPolicyInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.PolicyArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PolicyArn", 1))
	}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}
	if s.PrincipalArn != nil && len(*s.PrincipalArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *DisassociateAccessPolicyInput) SetClusterName(v string) *DisassociateAccessPolicyInput {
	s.ClusterName = &v
	return s
}

// SetPolicyArn sets the PolicyArn field's value.
func (s *DisassociateAccessPolicyInput) SetPolicyArn(v string) *DisassociateAccessPolicyInput {
	s.PolicyArn = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *DisassociateAccessPolicyInput) SetPrincipalArn(v string) *DisassociateAccessPolicyInput {
	s.PrincipalArn = &v
	return s
}

type DisassociateAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAccessPolicyOutput) GoString() string {
	return s.String()
}

type DisassociateIdentityProviderConfigInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object representing an identity provider configuration.
	//
	// IdentityProviderConfig is a required field
	IdentityProviderConfig *IdentityProviderConfig `locationName:"identityProviderConfig" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIdentityProviderConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIdentityProviderConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateIdentityProviderConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateIdentityProviderConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.IdentityProviderConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderConfig"))
	}
	if s.IdentityProviderConfig != nil {
		if err := s.IdentityProviderConfig.Validate(); err != nil {
			invalidParams.AddNested("IdentityProviderConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DisassociateIdentityProviderConfigInput) SetClientRequestToken(v string) *DisassociateIdentityProviderConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *DisassociateIdentityProviderConfigInput) SetClusterName(v string) *DisassociateIdentityProviderConfigInput {
	s.ClusterName = &v
	return s
}

// SetIdentityProviderConfig sets the IdentityProviderConfig field's value.
func (s *DisassociateIdentityProviderConfigInput) SetIdentityProviderConfig(v *IdentityProviderConfig) *DisassociateIdentityProviderConfigInput {
	s.IdentityProviderConfig = v
	return s
}

type DisassociateIdentityProviderConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIdentityProviderConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIdentityProviderConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *DisassociateIdentityProviderConfigOutput) SetUpdate(v *Update) *DisassociateIdentityProviderConfigOutput {
	s.Update = v
	return s
}

// An EKS Anywhere subscription authorizing the customer to support for licensed
// clusters and access to EKS Anywhere Curated Packages.
type EksAnywhereSubscription struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the subscription.
	Arn *string `locationName:"arn" type:"string"`

	// A boolean indicating whether or not a subscription will auto renew when it
	// expires.
	AutoRenew *bool `locationName:"autoRenew" type:"boolean"`

	// The Unix timestamp in seconds for when the subscription was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Unix timestamp in seconds for when the subscription is effective.
	EffectiveDate *time.Time `locationName:"effectiveDate" type:"timestamp"`

	// The Unix timestamp in seconds for when the subscription will expire or auto
	// renew, depending on the auto renew configuration of the subscription object.
	ExpirationDate *time.Time `locationName:"expirationDate" type:"timestamp"`

	// UUID identifying a subscription.
	Id *string `locationName:"id" type:"string"`

	// Amazon Web Services License Manager ARN associated with the subscription.
	LicenseArns []*string `locationName:"licenseArns" type:"list"`

	// The number of licenses included in a subscription. Valid values are between
	// 1 and 100.
	LicenseQuantity *int64 `locationName:"licenseQuantity" type:"integer"`

	// The type of licenses included in the subscription. Valid value is CLUSTER.
	// With the CLUSTER license type, each license covers support for a single EKS
	// Anywhere cluster.
	LicenseType *string `locationName:"licenseType" type:"string" enum:"EksAnywhereSubscriptionLicenseType"`

	// The status of a subscription.
	Status *string `locationName:"status" type:"string"`

	// The metadata for a subscription to assist with categorization and organization.
	// Each tag consists of a key and an optional value. Subscription tags do not
	// propagate to any other resources associated with the subscription.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// An EksAnywhereSubscriptionTerm object.
	Term *EksAnywhereSubscriptionTerm `locationName:"term" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksAnywhereSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksAnywhereSubscription) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *EksAnywhereSubscription) SetArn(v string) *EksAnywhereSubscription {
	s.Arn = &v
	return s
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *EksAnywhereSubscription) SetAutoRenew(v bool) *EksAnywhereSubscription {
	s.AutoRenew = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *EksAnywhereSubscription) SetCreatedAt(v time.Time) *EksAnywhereSubscription {
	s.CreatedAt = &v
	return s
}

// SetEffectiveDate sets the EffectiveDate field's value.
func (s *EksAnywhereSubscription) SetEffectiveDate(v time.Time) *EksAnywhereSubscription {
	s.EffectiveDate = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *EksAnywhereSubscription) SetExpirationDate(v time.Time) *EksAnywhereSubscription {
	s.ExpirationDate = &v
	return s
}

// SetId sets the Id field's value.
func (s *EksAnywhereSubscription) SetId(v string) *EksAnywhereSubscription {
	s.Id = &v
	return s
}

// SetLicenseArns sets the LicenseArns field's value.
func (s *EksAnywhereSubscription) SetLicenseArns(v []*string) *EksAnywhereSubscription {
	s.LicenseArns = v
	return s
}

// SetLicenseQuantity sets the LicenseQuantity field's value.
func (s *EksAnywhereSubscription) SetLicenseQuantity(v int64) *EksAnywhereSubscription {
	s.LicenseQuantity = &v
	return s
}

// SetLicenseType sets the LicenseType field's value.
func (s *EksAnywhereSubscription) SetLicenseType(v string) *EksAnywhereSubscription {
	s.LicenseType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EksAnywhereSubscription) SetStatus(v string) *EksAnywhereSubscription {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EksAnywhereSubscription) SetTags(v map[string]*string) *EksAnywhereSubscription {
	s.Tags = v
	return s
}

// SetTerm sets the Term field's value.
func (s *EksAnywhereSubscription) SetTerm(v *EksAnywhereSubscriptionTerm) *EksAnywhereSubscription {
	s.Term = v
	return s
}

// An object representing the term duration and term unit type of your subscription.
// This determines the term length of your subscription. Valid values are MONTHS
// for term unit and 12 or 36 for term duration, indicating a 12 month or 36
// month subscription.
type EksAnywhereSubscriptionTerm struct {
	_ struct{} `type:"structure"`

	// The duration of the subscription term. Valid values are 12 and 36, indicating
	// a 12 month or 36 month subscription.
	Duration *int64 `locationName:"duration" type:"integer"`

	// The term unit of the subscription. Valid value is MONTHS.
	Unit *string `locationName:"unit" type:"string" enum:"EksAnywhereSubscriptionTermUnit"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksAnywhereSubscriptionTerm) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EksAnywhereSubscriptionTerm) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *EksAnywhereSubscriptionTerm) SetDuration(v int64) *EksAnywhereSubscriptionTerm {
	s.Duration = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *EksAnywhereSubscriptionTerm) SetUnit(v string) *EksAnywhereSubscriptionTerm {
	s.Unit = &v
	return s
}

// The encryption configuration for the cluster.
type EncryptionConfig struct {
	_ struct{} `type:"structure"`

	// Key Management Service (KMS) key. Either the ARN or the alias can be used.
	Provider *Provider `locationName:"provider" type:"structure"`

	// Specifies the resources to be encrypted. The only supported value is secrets.
	Resources []*string `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfig) GoString() string {
	return s.String()
}

// SetProvider sets the Provider field's value.
func (s *EncryptionConfig) SetProvider(v *Provider) *EncryptionConfig {
	s.Provider = v
	return s
}

// SetResources sets the Resources field's value.
func (s *EncryptionConfig) SetResources(v []*string) *EncryptionConfig {
	s.Resources = v
	return s
}

// An object representing an error when an asynchronous operation fails.
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// A brief description of the error.
	//
	//    * SubnetNotFound: We couldn't find one of the subnets associated with
	//    the cluster.
	//
	//    * SecurityGroupNotFound: We couldn't find one of the security groups associated
	//    with the cluster.
	//
	//    * EniLimitReached: You have reached the elastic network interface limit
	//    for your account.
	//
	//    * IpNotAvailable: A subnet associated with the cluster doesn't have any
	//    available IP addresses.
	//
	//    * AccessDenied: You don't have permissions to perform the specified operation.
	//
	//    * OperationNotPermitted: The service role associated with the cluster
	//    doesn't have the required access permissions for Amazon EKS.
	//
	//    * VpcIdNotFound: We couldn't find the VPC associated with the cluster.
	ErrorCode *string `locationName:"errorCode" type:"string" enum:"ErrorCode"`

	// A more complete description of the error.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// An optional field that contains the resource IDs associated with the error.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ErrorDetail) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *ErrorDetail) SetErrorCode(v string) *ErrorDetail {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ErrorDetail) SetErrorMessage(v string) *ErrorDetail {
	s.ErrorMessage = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *ErrorDetail) SetResourceIds(v []*string) *ErrorDetail {
	s.ResourceIds = v
	return s
}

// An object representing an Fargate profile.
type FargateProfile struct {
	_ struct{} `type:"structure"`

	// The name of your cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The full Amazon Resource Name (ARN) of the Fargate profile.
	FargateProfileArn *string `locationName:"fargateProfileArn" type:"string"`

	// The name of the Fargate profile.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	// The Amazon Resource Name (ARN) of the Pod execution role to use for any Pod
	// that matches the selectors in the Fargate profile. For more information,
	// see Pod execution role (https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
	// in the Amazon EKS User Guide.
	PodExecutionRoleArn *string `locationName:"podExecutionRoleArn" type:"string"`

	// The selectors to match for a Pod to use this Fargate profile.
	Selectors []*FargateProfileSelector `locationName:"selectors" type:"list"`

	// The current status of the Fargate profile.
	Status *string `locationName:"status" type:"string" enum:"FargateProfileStatus"`

	// The IDs of subnets to launch a Pod into.
	Subnets []*string `locationName:"subnets" type:"list"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargateProfile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargateProfile) GoString() string {
	return s.String()
}

// SetClusterName sets the ClusterName field's value.
func (s *FargateProfile) SetClusterName(v string) *FargateProfile {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *FargateProfile) SetCreatedAt(v time.Time) *FargateProfile {
	s.CreatedAt = &v
	return s
}

// SetFargateProfileArn sets the FargateProfileArn field's value.
func (s *FargateProfile) SetFargateProfileArn(v string) *FargateProfile {
	s.FargateProfileArn = &v
	return s
}

// SetFargateProfileName sets the FargateProfileName field's value.
func (s *FargateProfile) SetFargateProfileName(v string) *FargateProfile {
	s.FargateProfileName = &v
	return s
}

// SetPodExecutionRoleArn sets the PodExecutionRoleArn field's value.
func (s *FargateProfile) SetPodExecutionRoleArn(v string) *FargateProfile {
	s.PodExecutionRoleArn = &v
	return s
}

// SetSelectors sets the Selectors field's value.
func (s *FargateProfile) SetSelectors(v []*FargateProfileSelector) *FargateProfile {
	s.Selectors = v
	return s
}

// SetStatus sets the Status field's value.
func (s *FargateProfile) SetStatus(v string) *FargateProfile {
	s.Status = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *FargateProfile) SetSubnets(v []*string) *FargateProfile {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *FargateProfile) SetTags(v map[string]*string) *FargateProfile {
	s.Tags = v
	return s
}

// An object representing an Fargate profile selector.
type FargateProfileSelector struct {
	_ struct{} `type:"structure"`

	// The Kubernetes labels that the selector should match. A pod must contain
	// all of the labels that are specified in the selector for it to be considered
	// a match.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// The Kubernetes namespace that the selector should match.
	Namespace *string `locationName:"namespace" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargateProfileSelector) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FargateProfileSelector) GoString() string {
	return s.String()
}

// SetLabels sets the Labels field's value.
func (s *FargateProfileSelector) SetLabels(v map[string]*string) *FargateProfileSelector {
	s.Labels = v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *FargateProfileSelector) SetNamespace(v string) *FargateProfileSelector {
	s.Namespace = &v
	return s
}

// An object representing an identity provider.
type Identity struct {
	_ struct{} `type:"structure"`

	// An object representing the OpenID Connect (https://openid.net/connect/) identity
	// provider information.
	Oidc *OIDC `locationName:"oidc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Identity) GoString() string {
	return s.String()
}

// SetOidc sets the Oidc field's value.
func (s *Identity) SetOidc(v *OIDC) *Identity {
	s.Oidc = v
	return s
}

// An object representing an identity provider configuration.
type IdentityProviderConfig struct {
	_ struct{} `type:"structure"`

	// The name of the identity provider configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The type of the identity provider configuration. The only type available
	// is oidc.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IdentityProviderConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IdentityProviderConfig"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *IdentityProviderConfig) SetName(v string) *IdentityProviderConfig {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *IdentityProviderConfig) SetType(v string) *IdentityProviderConfig {
	s.Type = &v
	return s
}

// The full description of your identity configuration.
type IdentityProviderConfigResponse struct {
	_ struct{} `type:"structure"`

	// An object representing an OpenID Connect (OIDC) identity provider configuration.
	Oidc *OidcIdentityProviderConfig `locationName:"oidc" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityProviderConfigResponse) GoString() string {
	return s.String()
}

// SetOidc sets the Oidc field's value.
func (s *IdentityProviderConfigResponse) SetOidc(v *OidcIdentityProviderConfig) *IdentityProviderConfigResponse {
	s.Oidc = v
	return s
}

// A check that provides recommendations to remedy potential upgrade-impacting
// issues.
type Insight struct {
	_ struct{} `type:"structure"`

	// Links to sources that provide additional context on the insight.
	AdditionalInfo map[string]*string `locationName:"additionalInfo" type:"map"`

	// The category of the insight.
	Category *string `locationName:"category" type:"string" enum:"Category"`

	// Summary information that relates to the category of the insight. Currently
	// only returned with certain insights having category UPGRADE_READINESS.
	CategorySpecificSummary *InsightCategorySpecificSummary `locationName:"categorySpecificSummary" type:"structure"`

	// The description of the insight which includes alert criteria, remediation
	// recommendation, and additional resources (contains Markdown).
	Description *string `locationName:"description" type:"string"`

	// The ID of the insight.
	Id *string `locationName:"id" type:"string"`

	// An object containing more detail on the status of the insight resource.
	InsightStatus *InsightStatus `locationName:"insightStatus" type:"structure"`

	// The Kubernetes minor version associated with an insight if applicable.
	KubernetesVersion *string `locationName:"kubernetesVersion" type:"string"`

	// The time Amazon EKS last successfully completed a refresh of this insight
	// check on the cluster.
	LastRefreshTime *time.Time `locationName:"lastRefreshTime" type:"timestamp"`

	// The time the status of the insight last changed.
	LastTransitionTime *time.Time `locationName:"lastTransitionTime" type:"timestamp"`

	// The name of the insight.
	Name *string `locationName:"name" type:"string"`

	// A summary of how to remediate the finding of this insight if applicable.
	Recommendation *string `locationName:"recommendation" type:"string"`

	// The details about each resource listed in the insight check result.
	Resources []*InsightResourceDetail `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Insight) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Insight) GoString() string {
	return s.String()
}

// SetAdditionalInfo sets the AdditionalInfo field's value.
func (s *Insight) SetAdditionalInfo(v map[string]*string) *Insight {
	s.AdditionalInfo = v
	return s
}

// SetCategory sets the Category field's value.
func (s *Insight) SetCategory(v string) *Insight {
	s.Category = &v
	return s
}

// SetCategorySpecificSummary sets the CategorySpecificSummary field's value.
func (s *Insight) SetCategorySpecificSummary(v *InsightCategorySpecificSummary) *Insight {
	s.CategorySpecificSummary = v
	return s
}

// SetDescription sets the Description field's value.
func (s *Insight) SetDescription(v string) *Insight {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Insight) SetId(v string) *Insight {
	s.Id = &v
	return s
}

// SetInsightStatus sets the InsightStatus field's value.
func (s *Insight) SetInsightStatus(v *InsightStatus) *Insight {
	s.InsightStatus = v
	return s
}

// SetKubernetesVersion sets the KubernetesVersion field's value.
func (s *Insight) SetKubernetesVersion(v string) *Insight {
	s.KubernetesVersion = &v
	return s
}

// SetLastRefreshTime sets the LastRefreshTime field's value.
func (s *Insight) SetLastRefreshTime(v time.Time) *Insight {
	s.LastRefreshTime = &v
	return s
}

// SetLastTransitionTime sets the LastTransitionTime field's value.
func (s *Insight) SetLastTransitionTime(v time.Time) *Insight {
	s.LastTransitionTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Insight) SetName(v string) *Insight {
	s.Name = &v
	return s
}

// SetRecommendation sets the Recommendation field's value.
func (s *Insight) SetRecommendation(v string) *Insight {
	s.Recommendation = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *Insight) SetResources(v []*InsightResourceDetail) *Insight {
	s.Resources = v
	return s
}

// Summary information that relates to the category of the insight. Currently
// only returned with certain insights having category UPGRADE_READINESS.
type InsightCategorySpecificSummary struct {
	_ struct{} `type:"structure"`

	// The summary information about deprecated resource usage for an insight check
	// in the UPGRADE_READINESS category.
	DeprecationDetails []*DeprecationDetail `locationName:"deprecationDetails" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightCategorySpecificSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightCategorySpecificSummary) GoString() string {
	return s.String()
}

// SetDeprecationDetails sets the DeprecationDetails field's value.
func (s *InsightCategorySpecificSummary) SetDeprecationDetails(v []*DeprecationDetail) *InsightCategorySpecificSummary {
	s.DeprecationDetails = v
	return s
}

// Returns information about the resource being evaluated.
type InsightResourceDetail struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) if applicable.
	Arn *string `locationName:"arn" type:"string"`

	// An object containing more detail on the status of the insight resource.
	InsightStatus *InsightStatus `locationName:"insightStatus" type:"structure"`

	// The Kubernetes resource URI if applicable.
	KubernetesResourceUri *string `locationName:"kubernetesResourceUri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightResourceDetail) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *InsightResourceDetail) SetArn(v string) *InsightResourceDetail {
	s.Arn = &v
	return s
}

// SetInsightStatus sets the InsightStatus field's value.
func (s *InsightResourceDetail) SetInsightStatus(v *InsightStatus) *InsightResourceDetail {
	s.InsightStatus = v
	return s
}

// SetKubernetesResourceUri sets the KubernetesResourceUri field's value.
func (s *InsightResourceDetail) SetKubernetesResourceUri(v string) *InsightResourceDetail {
	s.KubernetesResourceUri = &v
	return s
}

// The status of the insight.
type InsightStatus struct {
	_ struct{} `type:"structure"`

	// Explanation on the reasoning for the status of the resource.
	Reason *string `locationName:"reason" type:"string"`

	// The status of the resource.
	Status *string `locationName:"status" type:"string" enum:"InsightStatusValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightStatus) GoString() string {
	return s.String()
}

// SetReason sets the Reason field's value.
func (s *InsightStatus) SetReason(v string) *InsightStatus {
	s.Reason = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InsightStatus) SetStatus(v string) *InsightStatus {
	s.Status = &v
	return s
}

// The summarized description of the insight.
type InsightSummary struct {
	_ struct{} `type:"structure"`

	// The category of the insight.
	Category *string `locationName:"category" type:"string" enum:"Category"`

	// The description of the insight which includes alert criteria, remediation
	// recommendation, and additional resources (contains Markdown).
	Description *string `locationName:"description" type:"string"`

	// The ID of the insight.
	Id *string `locationName:"id" type:"string"`

	// An object containing more detail on the status of the insight.
	InsightStatus *InsightStatus `locationName:"insightStatus" type:"structure"`

	// The Kubernetes minor version associated with an insight if applicable.
	KubernetesVersion *string `locationName:"kubernetesVersion" type:"string"`

	// The time Amazon EKS last successfully completed a refresh of this insight
	// check on the cluster.
	LastRefreshTime *time.Time `locationName:"lastRefreshTime" type:"timestamp"`

	// The time the status of the insight last changed.
	LastTransitionTime *time.Time `locationName:"lastTransitionTime" type:"timestamp"`

	// The name of the insight.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightSummary) GoString() string {
	return s.String()
}

// SetCategory sets the Category field's value.
func (s *InsightSummary) SetCategory(v string) *InsightSummary {
	s.Category = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *InsightSummary) SetDescription(v string) *InsightSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *InsightSummary) SetId(v string) *InsightSummary {
	s.Id = &v
	return s
}

// SetInsightStatus sets the InsightStatus field's value.
func (s *InsightSummary) SetInsightStatus(v *InsightStatus) *InsightSummary {
	s.InsightStatus = v
	return s
}

// SetKubernetesVersion sets the KubernetesVersion field's value.
func (s *InsightSummary) SetKubernetesVersion(v string) *InsightSummary {
	s.KubernetesVersion = &v
	return s
}

// SetLastRefreshTime sets the LastRefreshTime field's value.
func (s *InsightSummary) SetLastRefreshTime(v time.Time) *InsightSummary {
	s.LastRefreshTime = &v
	return s
}

// SetLastTransitionTime sets the LastTransitionTime field's value.
func (s *InsightSummary) SetLastTransitionTime(v time.Time) *InsightSummary {
	s.LastTransitionTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *InsightSummary) SetName(v string) *InsightSummary {
	s.Name = &v
	return s
}

// The criteria to use for the insights.
type InsightsFilter struct {
	_ struct{} `type:"structure"`

	// The categories to use to filter insights.
	Categories []*string `locationName:"categories" type:"list" enum:"Category"`

	// The Kubernetes versions to use to filter the insights.
	KubernetesVersions []*string `locationName:"kubernetesVersions" type:"list"`

	// The statuses to use to filter the insights.
	Statuses []*string `locationName:"statuses" type:"list" enum:"InsightStatusValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightsFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsightsFilter) GoString() string {
	return s.String()
}

// SetCategories sets the Categories field's value.
func (s *InsightsFilter) SetCategories(v []*string) *InsightsFilter {
	s.Categories = v
	return s
}

// SetKubernetesVersions sets the KubernetesVersions field's value.
func (s *InsightsFilter) SetKubernetesVersions(v []*string) *InsightsFilter {
	s.KubernetesVersions = v
	return s
}

// SetStatuses sets the Statuses field's value.
func (s *InsightsFilter) SetStatuses(v []*string) *InsightsFilter {
	s.Statuses = v
	return s
}

// The specified parameter is invalid. Review the available parameters for the
// API request.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The specified parameter for the add-on name is invalid. Review the available
	// parameters for the API request
	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Fargate profile associated with the exception.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	// The specified parameter is invalid. Review the available parameters for the
	// API request.
	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The Amazon EKS subscription ID with the exception.
	SubscriptionId *string `locationName:"subscriptionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is invalid given the state of the cluster. Check the state of
// the cluster and the associated operations.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The request is invalid given the state of the add-on name. Check the state
	// of the cluster and the associated operations.
	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Amazon EKS add-on name associated with the exception.
	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The Amazon EKS subscription ID with the exception.
	SubscriptionId *string `locationName:"subscriptionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing an issue with an Amazon EKS resource.
type Issue struct {
	_ struct{} `type:"structure"`

	// A brief description of the error.
	//
	//    * AccessDenied: Amazon EKS or one or more of your managed nodes is failing
	//    to authenticate or authorize with your Kubernetes cluster API server.
	//
	//    * AsgInstanceLaunchFailures: Your Auto Scaling group is experiencing failures
	//    while attempting to launch instances.
	//
	//    * AutoScalingGroupNotFound: We couldn't find the Auto Scaling group associated
	//    with the managed node group. You may be able to recreate an Auto Scaling
	//    group with the same settings to recover.
	//
	//    * ClusterUnreachable: Amazon EKS or one or more of your managed nodes
	//    is unable to to communicate with your Kubernetes cluster API server. This
	//    can happen if there are network disruptions or if API servers are timing
	//    out processing requests.
	//
	//    * Ec2LaunchTemplateNotFound: We couldn't find the Amazon EC2 launch template
	//    for your managed node group. You may be able to recreate a launch template
	//    with the same settings to recover.
	//
	//    * Ec2LaunchTemplateVersionMismatch: The Amazon EC2 launch template version
	//    for your managed node group does not match the version that Amazon EKS
	//    created. You may be able to revert to the version that Amazon EKS created
	//    to recover.
	//
	//    * Ec2SecurityGroupDeletionFailure: We could not delete the remote access
	//    security group for your managed node group. Remove any dependencies from
	//    the security group.
	//
	//    * Ec2SecurityGroupNotFound: We couldn't find the cluster security group
	//    for the cluster. You must recreate your cluster.
	//
	//    * Ec2SubnetInvalidConfiguration: One or more Amazon EC2 subnets specified
	//    for a node group do not automatically assign public IP addresses to instances
	//    launched into it. If you want your instances to be assigned a public IP
	//    address, then you need to enable the auto-assign public IP address setting
	//    for the subnet. See Modifying the public IPv4 addressing attribute for
	//    your subnet (https://docs.aws.amazon.com/vpc/latest/userguide/vpc-ip-addressing.html#subnet-public-ip)
	//    in the Amazon VPC User Guide.
	//
	//    * IamInstanceProfileNotFound: We couldn't find the IAM instance profile
	//    for your managed node group. You may be able to recreate an instance profile
	//    with the same settings to recover.
	//
	//    * IamNodeRoleNotFound: We couldn't find the IAM role for your managed
	//    node group. You may be able to recreate an IAM role with the same settings
	//    to recover.
	//
	//    * InstanceLimitExceeded: Your Amazon Web Services account is unable to
	//    launch any more instances of the specified instance type. You may be able
	//    to request an Amazon EC2 instance limit increase to recover.
	//
	//    * InsufficientFreeAddresses: One or more of the subnets associated with
	//    your managed node group does not have enough available IP addresses for
	//    new nodes.
	//
	//    * InternalFailure: These errors are usually caused by an Amazon EKS server-side
	//    issue.
	//
	//    * NodeCreationFailure: Your launched instances are unable to register
	//    with your Amazon EKS cluster. Common causes of this failure are insufficient
	//    node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
	//    permissions or lack of outbound internet access for the nodes.
	Code *string `locationName:"code" type:"string" enum:"NodegroupIssueCode"`

	// The error message associated with the issue.
	Message *string `locationName:"message" type:"string"`

	// The Amazon Web Services resources that are afflicted by this issue.
	ResourceIds []*string `locationName:"resourceIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Issue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Issue) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *Issue) SetCode(v string) *Issue {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *Issue) SetMessage(v string) *Issue {
	s.Message = &v
	return s
}

// SetResourceIds sets the ResourceIds field's value.
func (s *Issue) SetResourceIds(v []*string) *Issue {
	s.ResourceIds = v
	return s
}

// The Kubernetes network configuration for the cluster.
type KubernetesNetworkConfigRequest struct {
	_ struct{} `type:"structure"`

	// Specify which IP family is used to assign Kubernetes pod and service IP addresses.
	// If you don't specify a value, ipv4 is used by default. You can only specify
	// an IP family when you create a cluster and can't change this value once the
	// cluster is created. If you specify ipv6, the VPC and subnets that you specify
	// for cluster creation must have both IPv4 and IPv6 CIDR blocks assigned to
	// them. You can't specify ipv6 for clusters in China Regions.
	//
	// You can only specify ipv6 for 1.21 and later clusters that use version 1.10.1
	// or later of the Amazon VPC CNI add-on. If you specify ipv6, then ensure that
	// your VPC meets the requirements listed in the considerations listed in Assigning
	// IPv6 addresses to pods and services (https://docs.aws.amazon.com/eks/latest/userguide/cni-ipv6.html)
	// in the Amazon EKS User Guide. Kubernetes assigns services IPv6 addresses
	// from the unique local address range (fc00::/7). You can't specify a custom
	// IPv6 CIDR block. Pod addresses are assigned from the subnet's IPv6 CIDR.
	IpFamily *string `locationName:"ipFamily" type:"string" enum:"IpFamily"`

	// Don't specify a value if you select ipv6 for ipFamily. The CIDR block to
	// assign Kubernetes service IP addresses from. If you don't specify a block,
	// Kubernetes assigns addresses from either the 10.100.0.0/16 or 172.20.0.0/16
	// CIDR blocks. We recommend that you specify a block that does not overlap
	// with resources in other networks that are peered or connected to your VPC.
	// The block must meet the following requirements:
	//
	//    * Within one of the following private IP address blocks: 10.0.0.0/8, 172.16.0.0/12,
	//    or 192.168.0.0/16.
	//
	//    * Doesn't overlap with any CIDR block assigned to the VPC that you selected
	//    for VPC.
	//
	//    * Between /24 and /12.
	//
	// You can only specify a custom CIDR block when you create a cluster. You can't
	// change this value after the cluster is created.
	ServiceIpv4Cidr *string `locationName:"serviceIpv4Cidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KubernetesNetworkConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KubernetesNetworkConfigRequest) GoString() string {
	return s.String()
}

// SetIpFamily sets the IpFamily field's value.
func (s *KubernetesNetworkConfigRequest) SetIpFamily(v string) *KubernetesNetworkConfigRequest {
	s.IpFamily = &v
	return s
}

// SetServiceIpv4Cidr sets the ServiceIpv4Cidr field's value.
func (s *KubernetesNetworkConfigRequest) SetServiceIpv4Cidr(v string) *KubernetesNetworkConfigRequest {
	s.ServiceIpv4Cidr = &v
	return s
}

// The Kubernetes network configuration for the cluster. The response contains
// a value for serviceIpv6Cidr or serviceIpv4Cidr, but not both.
type KubernetesNetworkConfigResponse struct {
	_ struct{} `type:"structure"`

	// The IP family used to assign Kubernetes Pod and Service objects IP addresses.
	// The IP family is always ipv4, unless you have a 1.21 or later cluster running
	// version 1.10.1 or later of the Amazon VPC CNI plugin for Kubernetes and specified
	// ipv6 when you created the cluster.
	IpFamily *string `locationName:"ipFamily" type:"string" enum:"IpFamily"`

	// The CIDR block that Kubernetes Pod and Service object IP addresses are assigned
	// from. Kubernetes assigns addresses from an IPv4 CIDR block assigned to a
	// subnet that the node is in. If you didn't specify a CIDR block when you created
	// the cluster, then Kubernetes assigns addresses from either the 10.100.0.0/16
	// or 172.20.0.0/16 CIDR blocks. If this was specified, then it was specified
	// when the cluster was created and it can't be changed.
	ServiceIpv4Cidr *string `locationName:"serviceIpv4Cidr" type:"string"`

	// The CIDR block that Kubernetes pod and service IP addresses are assigned
	// from if you created a 1.21 or later cluster with version 1.10.1 or later
	// of the Amazon VPC CNI add-on and specified ipv6 for ipFamily when you created
	// the cluster. Kubernetes assigns service addresses from the unique local address
	// range (fc00::/7) because you can't specify a custom IPv6 CIDR block when
	// you create the cluster.
	ServiceIpv6Cidr *string `locationName:"serviceIpv6Cidr" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KubernetesNetworkConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KubernetesNetworkConfigResponse) GoString() string {
	return s.String()
}

// SetIpFamily sets the IpFamily field's value.
func (s *KubernetesNetworkConfigResponse) SetIpFamily(v string) *KubernetesNetworkConfigResponse {
	s.IpFamily = &v
	return s
}

// SetServiceIpv4Cidr sets the ServiceIpv4Cidr field's value.
func (s *KubernetesNetworkConfigResponse) SetServiceIpv4Cidr(v string) *KubernetesNetworkConfigResponse {
	s.ServiceIpv4Cidr = &v
	return s
}

// SetServiceIpv6Cidr sets the ServiceIpv6Cidr field's value.
func (s *KubernetesNetworkConfigResponse) SetServiceIpv6Cidr(v string) *KubernetesNetworkConfigResponse {
	s.ServiceIpv6Cidr = &v
	return s
}

// An object representing a node group launch template specification. The launch
// template can't include SubnetId (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html),
// IamInstanceProfile (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html),
// RequestSpotInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_RequestSpotInstances.html),
// HibernationOptions (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_HibernationOptionsRequest.html),
// or TerminateInstances (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_TerminateInstances.html),
// or the node group deployment or update will fail. For more information about
// launch templates, see CreateLaunchTemplate (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
// in the Amazon EC2 API Reference. For more information about using launch
// templates with Amazon EKS, see Customizing managed nodes with launch templates
// (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
// in the Amazon EKS User Guide.
//
// You must specify either the launch template ID or the launch template name
// in the request, but not both.
type LaunchTemplateSpecification struct {
	_ struct{} `type:"structure"`

	// The ID of the launch template.
	//
	// You must specify either the launch template ID or the launch template name
	// in the request, but not both.
	Id *string `locationName:"id" type:"string"`

	// The name of the launch template.
	//
	// You must specify either the launch template name or the launch template ID
	// in the request, but not both.
	Name *string `locationName:"name" type:"string"`

	// The version number of the launch template to use. If no version is specified,
	// then the template's default version is used.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LaunchTemplateSpecification) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *LaunchTemplateSpecification) SetId(v string) *LaunchTemplateSpecification {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *LaunchTemplateSpecification) SetName(v string) *LaunchTemplateSpecification {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *LaunchTemplateSpecification) SetVersion(v string) *LaunchTemplateSpecification {
	s.Version = &v
	return s
}

type ListAccessEntriesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ARN of an AccessPolicy. When you specify an access policy ARN, only the
	// access entries associated to that access policy are returned. For a list
	// of available policy ARNs, use ListAccessPolicies.
	AssociatedPolicyArn *string `location:"querystring" locationName:"associatedPolicyArn" type:"string"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessEntriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessEntriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessEntriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessEntriesInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatedPolicyArn sets the AssociatedPolicyArn field's value.
func (s *ListAccessEntriesInput) SetAssociatedPolicyArn(v string) *ListAccessEntriesInput {
	s.AssociatedPolicyArn = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *ListAccessEntriesInput) SetClusterName(v string) *ListAccessEntriesInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessEntriesInput) SetMaxResults(v int64) *ListAccessEntriesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessEntriesInput) SetNextToken(v string) *ListAccessEntriesInput {
	s.NextToken = &v
	return s
}

type ListAccessEntriesOutput struct {
	_ struct{} `type:"structure"`

	// The list of access entries that exist for the cluster.
	AccessEntries []*string `locationName:"accessEntries" type:"list"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessEntriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessEntriesOutput) GoString() string {
	return s.String()
}

// SetAccessEntries sets the AccessEntries field's value.
func (s *ListAccessEntriesOutput) SetAccessEntries(v []*string) *ListAccessEntriesOutput {
	s.AccessEntries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessEntriesOutput) SetNextToken(v string) *ListAccessEntriesOutput {
	s.NextToken = &v
	return s
}

type ListAccessPoliciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAccessPoliciesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAccessPoliciesInput) SetMaxResults(v int64) *ListAccessPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPoliciesInput) SetNextToken(v string) *ListAccessPoliciesInput {
	s.NextToken = &v
	return s
}

type ListAccessPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The list of available access policies. You can't view the contents of an
	// access policy using the API. To view the contents, see Access policy permissions
	// (https://docs.aws.amazon.com/eks/latest/userguide/access-policies.html#access-policy-permissions)
	// in the Amazon EKS User Guide.
	AccessPolicies []*AccessPolicy `locationName:"accessPolicies" type:"list"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAccessPoliciesOutput) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ListAccessPoliciesOutput) SetAccessPolicies(v []*AccessPolicy) *ListAccessPoliciesOutput {
	s.AccessPolicies = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAccessPoliciesOutput) SetNextToken(v string) *ListAccessPoliciesOutput {
	s.NextToken = &v
	return s
}

type ListAddonsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAddonsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAddonsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListAddonsInput) SetClusterName(v string) *ListAddonsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAddonsInput) SetMaxResults(v int64) *ListAddonsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAddonsInput) SetNextToken(v string) *ListAddonsInput {
	s.NextToken = &v
	return s
}

type ListAddonsOutput struct {
	_ struct{} `type:"structure"`

	// A list of installed add-ons.
	Addons []*string `locationName:"addons" type:"list"`

	// The nextToken value to include in a future ListAddons request. When the results
	// of a ListAddons request exceed maxResults, you can use this value to retrieve
	// the next page of results. This value is null when there are no more results
	// to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAddonsOutput) GoString() string {
	return s.String()
}

// SetAddons sets the Addons field's value.
func (s *ListAddonsOutput) SetAddons(v []*string) *ListAddonsOutput {
	s.Addons = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAddonsOutput) SetNextToken(v string) *ListAddonsOutput {
	s.NextToken = &v
	return s
}

type ListAssociatedAccessPoliciesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ARN of the IAM principal for the AccessEntry.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `location:"uri" locationName:"principalArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAccessPoliciesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAccessPoliciesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedAccessPoliciesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedAccessPoliciesInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}
	if s.PrincipalArn != nil && len(*s.PrincipalArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListAssociatedAccessPoliciesInput) SetClusterName(v string) *ListAssociatedAccessPoliciesInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociatedAccessPoliciesInput) SetMaxResults(v int64) *ListAssociatedAccessPoliciesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedAccessPoliciesInput) SetNextToken(v string) *ListAssociatedAccessPoliciesInput {
	s.NextToken = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *ListAssociatedAccessPoliciesInput) SetPrincipalArn(v string) *ListAssociatedAccessPoliciesInput {
	s.PrincipalArn = &v
	return s
}

type ListAssociatedAccessPoliciesOutput struct {
	_ struct{} `type:"structure"`

	// The list of access policies associated with the access entry.
	AssociatedAccessPolicies []*AssociatedAccessPolicy `locationName:"associatedAccessPolicies" type:"list"`

	// The name of your cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The ARN of the IAM principal for the AccessEntry.
	PrincipalArn *string `locationName:"principalArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAccessPoliciesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAccessPoliciesOutput) GoString() string {
	return s.String()
}

// SetAssociatedAccessPolicies sets the AssociatedAccessPolicies field's value.
func (s *ListAssociatedAccessPoliciesOutput) SetAssociatedAccessPolicies(v []*AssociatedAccessPolicy) *ListAssociatedAccessPoliciesOutput {
	s.AssociatedAccessPolicies = v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *ListAssociatedAccessPoliciesOutput) SetClusterName(v string) *ListAssociatedAccessPoliciesOutput {
	s.ClusterName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedAccessPoliciesOutput) SetNextToken(v string) *ListAssociatedAccessPoliciesOutput {
	s.NextToken = &v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *ListAssociatedAccessPoliciesOutput) SetPrincipalArn(v string) *ListAssociatedAccessPoliciesOutput {
	s.PrincipalArn = &v
	return s
}

type ListClustersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Indicates whether external clusters are included in the returned list. Use
	// 'all' to return https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html
	// (https://docs.aws.amazon.com/eks/latest/userguide/eks-connector.html)connected
	// clusters, or blank to return only Amazon EKS clusters. 'all' must be in lowercase
	// otherwise an error occurs.
	Include []*string `location:"querystring" locationName:"include" type:"list"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListClustersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListClustersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInclude sets the Include field's value.
func (s *ListClustersInput) SetInclude(v []*string) *ListClustersInput {
	s.Include = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListClustersInput) SetMaxResults(v int64) *ListClustersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersInput) SetNextToken(v string) *ListClustersInput {
	s.NextToken = &v
	return s
}

type ListClustersOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of the clusters for your account in the specified Amazon Web
	// Services Region.
	Clusters []*string `locationName:"clusters" type:"list"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// SetClusters sets the Clusters field's value.
func (s *ListClustersOutput) SetClusters(v []*string) *ListClustersOutput {
	s.Clusters = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListClustersOutput) SetNextToken(v string) *ListClustersOutput {
	s.NextToken = &v
	return s
}

type ListEksAnywhereSubscriptionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An array of subscription statuses to filter on.
	IncludeStatus []*string `location:"querystring" locationName:"includeStatus" type:"list" enum:"EksAnywhereSubscriptionStatus"`

	// The maximum number of cluster results returned by ListEksAnywhereSubscriptions
	// in paginated output. When you use this parameter, ListEksAnywhereSubscriptions
	// returns only maxResults results in a single page along with a nextToken response
	// element. You can see the remaining results of the initial request by sending
	// another ListEksAnywhereSubscriptions request with the returned nextToken
	// value. This value can be between 1 and 100. If you don't use this parameter,
	// ListEksAnywhereSubscriptions returns up to 10 results and a nextToken value
	// if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListEksAnywhereSubscriptions
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEksAnywhereSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEksAnywhereSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEksAnywhereSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEksAnywhereSubscriptionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeStatus sets the IncludeStatus field's value.
func (s *ListEksAnywhereSubscriptionsInput) SetIncludeStatus(v []*string) *ListEksAnywhereSubscriptionsInput {
	s.IncludeStatus = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEksAnywhereSubscriptionsInput) SetMaxResults(v int64) *ListEksAnywhereSubscriptionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEksAnywhereSubscriptionsInput) SetNextToken(v string) *ListEksAnywhereSubscriptionsInput {
	s.NextToken = &v
	return s
}

type ListEksAnywhereSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListEksAnywhereSubscriptions request.
	// When the results of a ListEksAnywhereSubscriptions request exceed maxResults,
	// you can use this value to retrieve the next page of results. This value is
	// null when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all subscription objects in the region, filtered by includeStatus
	// and paginated by nextToken and maxResults.
	Subscriptions []*EksAnywhereSubscription `locationName:"subscriptions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEksAnywhereSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEksAnywhereSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListEksAnywhereSubscriptionsOutput) SetNextToken(v string) *ListEksAnywhereSubscriptionsOutput {
	s.NextToken = &v
	return s
}

// SetSubscriptions sets the Subscriptions field's value.
func (s *ListEksAnywhereSubscriptionsOutput) SetSubscriptions(v []*EksAnywhereSubscription) *ListEksAnywhereSubscriptionsOutput {
	s.Subscriptions = v
	return s
}

type ListFargateProfilesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFargateProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFargateProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFargateProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFargateProfilesInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListFargateProfilesInput) SetClusterName(v string) *ListFargateProfilesInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFargateProfilesInput) SetMaxResults(v int64) *ListFargateProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFargateProfilesInput) SetNextToken(v string) *ListFargateProfilesInput {
	s.NextToken = &v
	return s
}

type ListFargateProfilesOutput struct {
	_ struct{} `type:"structure"`

	// A list of all of the Fargate profiles associated with the specified cluster.
	FargateProfileNames []*string `locationName:"fargateProfileNames" type:"list"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFargateProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFargateProfilesOutput) GoString() string {
	return s.String()
}

// SetFargateProfileNames sets the FargateProfileNames field's value.
func (s *ListFargateProfilesOutput) SetFargateProfileNames(v []*string) *ListFargateProfilesOutput {
	s.FargateProfileNames = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFargateProfilesOutput) SetNextToken(v string) *ListFargateProfilesOutput {
	s.NextToken = &v
	return s
}

type ListIdentityProviderConfigsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProviderConfigsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProviderConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIdentityProviderConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIdentityProviderConfigsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListIdentityProviderConfigsInput) SetClusterName(v string) *ListIdentityProviderConfigsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListIdentityProviderConfigsInput) SetMaxResults(v int64) *ListIdentityProviderConfigsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProviderConfigsInput) SetNextToken(v string) *ListIdentityProviderConfigsInput {
	s.NextToken = &v
	return s
}

type ListIdentityProviderConfigsOutput struct {
	_ struct{} `type:"structure"`

	// The identity provider configurations for the cluster.
	IdentityProviderConfigs []*IdentityProviderConfig `locationName:"identityProviderConfigs" type:"list"`

	// The nextToken value to include in a future ListIdentityProviderConfigsResponse
	// request. When the results of a ListIdentityProviderConfigsResponse request
	// exceed maxResults, you can use this value to retrieve the next page of results.
	// This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProviderConfigsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListIdentityProviderConfigsOutput) GoString() string {
	return s.String()
}

// SetIdentityProviderConfigs sets the IdentityProviderConfigs field's value.
func (s *ListIdentityProviderConfigsOutput) SetIdentityProviderConfigs(v []*IdentityProviderConfig) *ListIdentityProviderConfigsOutput {
	s.IdentityProviderConfigs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListIdentityProviderConfigsOutput) SetNextToken(v string) *ListIdentityProviderConfigsOutput {
	s.NextToken = &v
	return s
}

type ListInsightsInput struct {
	_ struct{} `type:"structure"`

	// The name of the Amazon EKS cluster associated with the insights.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The criteria to filter your list of insights for your cluster. You can filter
	// which insights are returned by category, associated Kubernetes version, and
	// status.
	Filter *InsightsFilter `locationName:"filter" type:"structure"`

	// The maximum number of identity provider configurations returned by ListInsights
	// in paginated output. When you use this parameter, ListInsights returns only
	// maxResults results in a single page along with a nextToken response element.
	// You can see the remaining results of the initial request by sending another
	// ListInsights request with the returned nextToken value. This value can be
	// between 1 and 100. If you don't use this parameter, ListInsights returns
	// up to 100 results and a nextToken value, if applicable.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated ListInsights request.
	// When the results of a ListInsights request exceed maxResults, you can use
	// this value to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInsightsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInsightsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListInsightsInput) SetClusterName(v string) *ListInsightsInput {
	s.ClusterName = &v
	return s
}

// SetFilter sets the Filter field's value.
func (s *ListInsightsInput) SetFilter(v *InsightsFilter) *ListInsightsInput {
	s.Filter = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInsightsInput) SetMaxResults(v int64) *ListInsightsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInsightsInput) SetNextToken(v string) *ListInsightsInput {
	s.NextToken = &v
	return s
}

type ListInsightsOutput struct {
	_ struct{} `type:"structure"`

	// The returned list of insights.
	Insights []*InsightSummary `locationName:"insights" type:"list"`

	// The nextToken value to include in a future ListInsights request. When the
	// results of a ListInsights request exceed maxResults, you can use this value
	// to retrieve the next page of results. This value is null when there are no
	// more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListInsightsOutput) GoString() string {
	return s.String()
}

// SetInsights sets the Insights field's value.
func (s *ListInsightsOutput) SetInsights(v []*InsightSummary) *ListInsightsOutput {
	s.Insights = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInsightsOutput) SetNextToken(v string) *ListInsightsOutput {
	s.NextToken = &v
	return s
}

type ListNodegroupsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodegroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodegroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNodegroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNodegroupsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListNodegroupsInput) SetClusterName(v string) *ListNodegroupsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNodegroupsInput) SetMaxResults(v int64) *ListNodegroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodegroupsInput) SetNextToken(v string) *ListNodegroupsInput {
	s.NextToken = &v
	return s
}

type ListNodegroupsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all of the node groups associated with the specified cluster.
	Nodegroups []*string `locationName:"nodegroups" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodegroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNodegroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListNodegroupsOutput) SetNextToken(v string) *ListNodegroupsOutput {
	s.NextToken = &v
	return s
}

// SetNodegroups sets the Nodegroups field's value.
func (s *ListNodegroupsOutput) SetNodegroups(v []*string) *ListNodegroupsOutput {
	s.Nodegroups = v
	return s
}

type ListPodIdentityAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the cluster that the associations are in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The maximum number of EKS Pod Identity association results returned by ListPodIdentityAssociations
	// in paginated output. When you use this parameter, ListPodIdentityAssociations
	// returns only maxResults results in a single page along with a nextToken response
	// element. You can see the remaining results of the initial request by sending
	// another ListPodIdentityAssociations request with the returned nextToken value.
	// This value can be between 1 and 100. If you don't use this parameter, ListPodIdentityAssociations
	// returns up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the Kubernetes namespace inside the cluster that the associations
	// are in.
	Namespace *string `location:"querystring" locationName:"namespace" type:"string"`

	// The nextToken value returned from a previous paginated ListUpdates request
	// where maxResults was used and the results exceeded the value of that parameter.
	// Pagination continues from the end of the previous results that returned the
	// nextToken value.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the Kubernetes service account that the associations use.
	ServiceAccount *string `location:"querystring" locationName:"serviceAccount" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPodIdentityAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPodIdentityAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPodIdentityAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPodIdentityAssociationsInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClusterName sets the ClusterName field's value.
func (s *ListPodIdentityAssociationsInput) SetClusterName(v string) *ListPodIdentityAssociationsInput {
	s.ClusterName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListPodIdentityAssociationsInput) SetMaxResults(v int64) *ListPodIdentityAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *ListPodIdentityAssociationsInput) SetNamespace(v string) *ListPodIdentityAssociationsInput {
	s.Namespace = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPodIdentityAssociationsInput) SetNextToken(v string) *ListPodIdentityAssociationsInput {
	s.NextToken = &v
	return s
}

// SetServiceAccount sets the ServiceAccount field's value.
func (s *ListPodIdentityAssociationsInput) SetServiceAccount(v string) *ListPodIdentityAssociationsInput {
	s.ServiceAccount = &v
	return s
}

type ListPodIdentityAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of summarized descriptions of the associations that are in the cluster
	// and match any filters that you provided.
	//
	// Each summary is simplified by removing these fields compared to the full
	// PodIdentityAssociation :
	//
	//    * The IAM role: roleArn
	//
	//    * The timestamp that the association was created at: createdAt
	//
	//    * The most recent timestamp that the association was modified at:. modifiedAt
	//
	//    * The tags on the association: tags
	Associations []*PodIdentityAssociationSummary `locationName:"associations" type:"list"`

	// The nextToken value to include in a future ListPodIdentityAssociations request.
	// When the results of a ListPodIdentityAssociations request exceed maxResults,
	// you can use this value to retrieve the next page of results. This value is
	// null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPodIdentityAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListPodIdentityAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *ListPodIdentityAssociationsOutput) SetAssociations(v []*PodIdentityAssociationSummary) *ListPodIdentityAssociationsOutput {
	s.Associations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListPodIdentityAssociationsOutput) SetNextToken(v string) *ListPodIdentityAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) that identifies the resource to list tags
	// for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags for the resource.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUpdatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The names of the installed add-ons that have available updates.
	AddonName *string `location:"querystring" locationName:"addonName" type:"string"`

	// The maximum number of results, returned in paginated output. You receive
	// maxResults in a single page, along with a nextToken response element. You
	// can see the remaining results of the initial request by sending another request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// you don't use this parameter, 100 results and a nextToken value, if applicable,
	// are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The name of the Amazon EKS cluster to list updates for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The name of the Amazon EKS managed node group to list updates for.
	NodegroupName *string `location:"querystring" locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUpdatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUpdatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUpdatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *ListUpdatesInput) SetAddonName(v string) *ListUpdatesInput {
	s.AddonName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUpdatesInput) SetMaxResults(v int64) *ListUpdatesInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListUpdatesInput) SetName(v string) *ListUpdatesInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUpdatesInput) SetNextToken(v string) *ListUpdatesInput {
	s.NextToken = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *ListUpdatesInput) SetNodegroupName(v string) *ListUpdatesInput {
	s.NodegroupName = &v
	return s
}

type ListUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value returned from a previous paginated request, where maxResults
	// was used and the results exceeded the value of that parameter. Pagination
	// continues from the end of the previous results that returned the nextToken
	// value. This value is null when there are no more results to return.
	//
	// This token should be treated as an opaque identifier that is used only to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" type:"string"`

	// A list of all the updates for the specified cluster and Region.
	UpdateIds []*string `locationName:"updateIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUpdatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUpdatesOutput) SetNextToken(v string) *ListUpdatesOutput {
	s.NextToken = &v
	return s
}

// SetUpdateIds sets the UpdateIds field's value.
func (s *ListUpdatesOutput) SetUpdateIds(v []*string) *ListUpdatesOutput {
	s.UpdateIds = v
	return s
}

// An object representing the enabled or disabled Kubernetes control plane logs
// for your cluster.
type LogSetup struct {
	_ struct{} `type:"structure"`

	// If a log type is enabled, that log type exports its control plane logs to
	// CloudWatch Logs. If a log type isn't enabled, that log type doesn't export
	// its control plane logs. Each individual log type can be enabled or disabled
	// independently.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The available cluster control plane log types.
	Types []*string `locationName:"types" type:"list" enum:"LogType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogSetup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LogSetup) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *LogSetup) SetEnabled(v bool) *LogSetup {
	s.Enabled = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *LogSetup) SetTypes(v []*string) *LogSetup {
	s.Types = v
	return s
}

// An object representing the logging configuration for resources in your cluster.
type Logging struct {
	_ struct{} `type:"structure"`

	// The cluster control plane logging configuration for your cluster.
	ClusterLogging []*LogSetup `locationName:"clusterLogging" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Logging) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Logging) GoString() string {
	return s.String()
}

// SetClusterLogging sets the ClusterLogging field's value.
func (s *Logging) SetClusterLogging(v []*LogSetup) *Logging {
	s.ClusterLogging = v
	return s
}

// Information about an Amazon EKS add-on from the Amazon Web Services Marketplace.
type MarketplaceInformation struct {
	_ struct{} `type:"structure"`

	// The product ID from the Amazon Web Services Marketplace.
	ProductId *string `locationName:"productId" type:"string"`

	// The product URL from the Amazon Web Services Marketplace.
	ProductUrl *string `locationName:"productUrl" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MarketplaceInformation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MarketplaceInformation) GoString() string {
	return s.String()
}

// SetProductId sets the ProductId field's value.
func (s *MarketplaceInformation) SetProductId(v string) *MarketplaceInformation {
	s.ProductId = &v
	return s
}

// SetProductUrl sets the ProductUrl field's value.
func (s *MarketplaceInformation) SetProductUrl(v string) *MarketplaceInformation {
	s.ProductUrl = &v
	return s
}

// An object representing an Amazon EKS managed node group.
type Nodegroup struct {
	_ struct{} `type:"structure"`

	// If the node group was deployed using a launch template with a custom AMI,
	// then this is CUSTOM. For node groups that weren't deployed using a launch
	// template, this is the AMI type that was specified in the node group configuration.
	AmiType *string `locationName:"amiType" type:"string" enum:"AMITypes"`

	// The capacity type of your managed node group.
	CapacityType *string `locationName:"capacityType" type:"string" enum:"CapacityTypes"`

	// The name of your cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// If the node group wasn't deployed with a launch template, then this is the
	// disk size in the node group configuration. If the node group was deployed
	// with a launch template, then this is null.
	DiskSize *int64 `locationName:"diskSize" type:"integer"`

	// The health status of the node group. If there are issues with your node group's
	// health, they are listed here.
	Health *NodegroupHealth `locationName:"health" type:"structure"`

	// If the node group wasn't deployed with a launch template, then this is the
	// instance type that is associated with the node group. If the node group was
	// deployed with a launch template, then this is null.
	InstanceTypes []*string `locationName:"instanceTypes" type:"list"`

	// The Kubernetes labels applied to the nodes in the node group.
	//
	// Only labels that are applied with the Amazon EKS API are shown here. There
	// may be other Kubernetes labels applied to the nodes in this group.
	Labels map[string]*string `locationName:"labels" type:"map"`

	// If a launch template was used to create the node group, then this is the
	// launch template that was used.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The Unix epoch timestamp for the last modification to the object.
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The IAM role associated with your node group. The Amazon EKS node kubelet
	// daemon makes calls to Amazon Web Services APIs on your behalf. Nodes receive
	// permissions for these API calls through an IAM instance profile and associated
	// policies.
	NodeRole *string `locationName:"nodeRole" type:"string"`

	// The Amazon Resource Name (ARN) associated with the managed node group.
	NodegroupArn *string `locationName:"nodegroupArn" type:"string"`

	// The name associated with an Amazon EKS managed node group.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// If the node group was deployed using a launch template with a custom AMI,
	// then this is the AMI ID that was specified in the launch template. For node
	// groups that weren't deployed using a launch template, this is the version
	// of the Amazon EKS optimized AMI that the node group was deployed with.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// If the node group wasn't deployed with a launch template, then this is the
	// remote access configuration that is associated with the node group. If the
	// node group was deployed with a launch template, then this is null.
	RemoteAccess *RemoteAccessConfig `locationName:"remoteAccess" type:"structure"`

	// The resources associated with the node group, such as Auto Scaling groups
	// and security groups for remote access.
	Resources *NodegroupResources `locationName:"resources" type:"structure"`

	// The scaling configuration details for the Auto Scaling group that is associated
	// with your node group.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The current status of the managed node group.
	Status *string `locationName:"status" type:"string" enum:"NodegroupStatus"`

	// The subnets that were specified for the Auto Scaling group that is associated
	// with your node group.
	Subnets []*string `locationName:"subnets" type:"list"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The Kubernetes taints to be applied to the nodes in the node group when they
	// are created. Effect is one of No_Schedule, Prefer_No_Schedule, or No_Execute.
	// Kubernetes taints can be used together with tolerations to control how workloads
	// are scheduled to your nodes. For more information, see Node taints on managed
	// node groups (https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
	Taints []*Taint `locationName:"taints" type:"list"`

	// The node group update configuration.
	UpdateConfig *NodegroupUpdateConfig `locationName:"updateConfig" type:"structure"`

	// The Kubernetes version of the managed node group.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Nodegroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Nodegroup) GoString() string {
	return s.String()
}

// SetAmiType sets the AmiType field's value.
func (s *Nodegroup) SetAmiType(v string) *Nodegroup {
	s.AmiType = &v
	return s
}

// SetCapacityType sets the CapacityType field's value.
func (s *Nodegroup) SetCapacityType(v string) *Nodegroup {
	s.CapacityType = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *Nodegroup) SetClusterName(v string) *Nodegroup {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Nodegroup) SetCreatedAt(v time.Time) *Nodegroup {
	s.CreatedAt = &v
	return s
}

// SetDiskSize sets the DiskSize field's value.
func (s *Nodegroup) SetDiskSize(v int64) *Nodegroup {
	s.DiskSize = &v
	return s
}

// SetHealth sets the Health field's value.
func (s *Nodegroup) SetHealth(v *NodegroupHealth) *Nodegroup {
	s.Health = v
	return s
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *Nodegroup) SetInstanceTypes(v []*string) *Nodegroup {
	s.InstanceTypes = v
	return s
}

// SetLabels sets the Labels field's value.
func (s *Nodegroup) SetLabels(v map[string]*string) *Nodegroup {
	s.Labels = v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *Nodegroup) SetLaunchTemplate(v *LaunchTemplateSpecification) *Nodegroup {
	s.LaunchTemplate = v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *Nodegroup) SetModifiedAt(v time.Time) *Nodegroup {
	s.ModifiedAt = &v
	return s
}

// SetNodeRole sets the NodeRole field's value.
func (s *Nodegroup) SetNodeRole(v string) *Nodegroup {
	s.NodeRole = &v
	return s
}

// SetNodegroupArn sets the NodegroupArn field's value.
func (s *Nodegroup) SetNodegroupArn(v string) *Nodegroup {
	s.NodegroupArn = &v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *Nodegroup) SetNodegroupName(v string) *Nodegroup {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *Nodegroup) SetReleaseVersion(v string) *Nodegroup {
	s.ReleaseVersion = &v
	return s
}

// SetRemoteAccess sets the RemoteAccess field's value.
func (s *Nodegroup) SetRemoteAccess(v *RemoteAccessConfig) *Nodegroup {
	s.RemoteAccess = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Nodegroup) SetResources(v *NodegroupResources) *Nodegroup {
	s.Resources = v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *Nodegroup) SetScalingConfig(v *NodegroupScalingConfig) *Nodegroup {
	s.ScalingConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Nodegroup) SetStatus(v string) *Nodegroup {
	s.Status = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *Nodegroup) SetSubnets(v []*string) *Nodegroup {
	s.Subnets = v
	return s
}

// SetTags sets the Tags field's value.
func (s *Nodegroup) SetTags(v map[string]*string) *Nodegroup {
	s.Tags = v
	return s
}

// SetTaints sets the Taints field's value.
func (s *Nodegroup) SetTaints(v []*Taint) *Nodegroup {
	s.Taints = v
	return s
}

// SetUpdateConfig sets the UpdateConfig field's value.
func (s *Nodegroup) SetUpdateConfig(v *NodegroupUpdateConfig) *Nodegroup {
	s.UpdateConfig = v
	return s
}

// SetVersion sets the Version field's value.
func (s *Nodegroup) SetVersion(v string) *Nodegroup {
	s.Version = &v
	return s
}

// An object representing the health status of the node group.
type NodegroupHealth struct {
	_ struct{} `type:"structure"`

	// Any issues that are associated with the node group.
	Issues []*Issue `locationName:"issues" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupHealth) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupHealth) GoString() string {
	return s.String()
}

// SetIssues sets the Issues field's value.
func (s *NodegroupHealth) SetIssues(v []*Issue) *NodegroupHealth {
	s.Issues = v
	return s
}

// An object representing the resources associated with the node group, such
// as Auto Scaling groups and security groups for remote access.
type NodegroupResources struct {
	_ struct{} `type:"structure"`

	// The Auto Scaling groups associated with the node group.
	AutoScalingGroups []*AutoScalingGroup `locationName:"autoScalingGroups" type:"list"`

	// The remote access security group associated with the node group. This security
	// group controls SSH access to the nodes.
	RemoteAccessSecurityGroup *string `locationName:"remoteAccessSecurityGroup" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupResources) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupResources) GoString() string {
	return s.String()
}

// SetAutoScalingGroups sets the AutoScalingGroups field's value.
func (s *NodegroupResources) SetAutoScalingGroups(v []*AutoScalingGroup) *NodegroupResources {
	s.AutoScalingGroups = v
	return s
}

// SetRemoteAccessSecurityGroup sets the RemoteAccessSecurityGroup field's value.
func (s *NodegroupResources) SetRemoteAccessSecurityGroup(v string) *NodegroupResources {
	s.RemoteAccessSecurityGroup = &v
	return s
}

// An object representing the scaling configuration details for the Auto Scaling
// group that is associated with your node group. When creating a node group,
// you must specify all or none of the properties. When updating a node group,
// you can specify any or none of the properties.
type NodegroupScalingConfig struct {
	_ struct{} `type:"structure"`

	// The current number of nodes that the managed node group should maintain.
	//
	// If you use the Kubernetes Cluster Autoscaler (https://github.com/kubernetes/autoscaler#kubernetes-autoscaler),
	// you shouldn't change the desiredSize value directly, as this can cause the
	// Cluster Autoscaler to suddenly scale up or scale down.
	//
	// Whenever this parameter changes, the number of worker nodes in the node group
	// is updated to the specified size. If this parameter is given a value that
	// is smaller than the current number of running worker nodes, the necessary
	// number of worker nodes are terminated to match the given value. When using
	// CloudFormation, no action occurs if you remove this parameter from your CFN
	// template.
	//
	// This parameter can be different from minSize in some cases, such as when
	// starting with extra hosts for testing. This parameter can also be different
	// when you want to start with an estimated number of needed hosts, but let
	// the Cluster Autoscaler reduce the number if there are too many. When the
	// Cluster Autoscaler is used, the desiredSize parameter is altered by the Cluster
	// Autoscaler (but can be out-of-date for short periods of time). the Cluster
	// Autoscaler doesn't scale a managed node group lower than minSize or higher
	// than maxSize.
	DesiredSize *int64 `locationName:"desiredSize" type:"integer"`

	// The maximum number of nodes that the managed node group can scale out to.
	// For information about the maximum number that you can specify, see Amazon
	// EKS service quotas (https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html)
	// in the Amazon EKS User Guide.
	MaxSize *int64 `locationName:"maxSize" min:"1" type:"integer"`

	// The minimum number of nodes that the managed node group can scale in to.
	MinSize *int64 `locationName:"minSize" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupScalingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupScalingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodegroupScalingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodegroupScalingConfig"}
	if s.MaxSize != nil && *s.MaxSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxSize", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDesiredSize sets the DesiredSize field's value.
func (s *NodegroupScalingConfig) SetDesiredSize(v int64) *NodegroupScalingConfig {
	s.DesiredSize = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *NodegroupScalingConfig) SetMaxSize(v int64) *NodegroupScalingConfig {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *NodegroupScalingConfig) SetMinSize(v int64) *NodegroupScalingConfig {
	s.MinSize = &v
	return s
}

// The node group update configuration.
type NodegroupUpdateConfig struct {
	_ struct{} `type:"structure"`

	// The maximum number of nodes unavailable at once during a version update.
	// Nodes are updated in parallel. This value or maxUnavailablePercentage is
	// required to have a value.The maximum number is 100.
	MaxUnavailable *int64 `locationName:"maxUnavailable" min:"1" type:"integer"`

	// The maximum percentage of nodes unavailable during a version update. This
	// percentage of nodes are updated in parallel, up to 100 nodes at once. This
	// value or maxUnavailable is required to have a value.
	MaxUnavailablePercentage *int64 `locationName:"maxUnavailablePercentage" min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupUpdateConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NodegroupUpdateConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NodegroupUpdateConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NodegroupUpdateConfig"}
	if s.MaxUnavailable != nil && *s.MaxUnavailable < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxUnavailable", 1))
	}
	if s.MaxUnavailablePercentage != nil && *s.MaxUnavailablePercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxUnavailablePercentage", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxUnavailable sets the MaxUnavailable field's value.
func (s *NodegroupUpdateConfig) SetMaxUnavailable(v int64) *NodegroupUpdateConfig {
	s.MaxUnavailable = &v
	return s
}

// SetMaxUnavailablePercentage sets the MaxUnavailablePercentage field's value.
func (s *NodegroupUpdateConfig) SetMaxUnavailablePercentage(v int64) *NodegroupUpdateConfig {
	s.MaxUnavailablePercentage = &v
	return s
}

// A service resource associated with the request could not be found. Clients
// should not retry such requests.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A service resource associated with the request could not be found. Clients
	// should not retry such requests.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object representing the OpenID Connect (https://openid.net/connect/) (OIDC)
// identity provider information for the cluster.
type OIDC struct {
	_ struct{} `type:"structure"`

	// The issuer URL for the OIDC identity provider.
	Issuer *string `locationName:"issuer" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OIDC) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OIDC) GoString() string {
	return s.String()
}

// SetIssuer sets the Issuer field's value.
func (s *OIDC) SetIssuer(v string) *OIDC {
	s.Issuer = &v
	return s
}

// An object representing the configuration for an OpenID Connect (OIDC) identity
// provider.
type OidcIdentityProviderConfig struct {
	_ struct{} `type:"structure"`

	// This is also known as audience. The ID of the client application that makes
	// authentication requests to the OIDC identity provider.
	ClientId *string `locationName:"clientId" type:"string"`

	// The name of your cluster.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The JSON web token (JWT) claim that the provider uses to return your groups.
	GroupsClaim *string `locationName:"groupsClaim" type:"string"`

	// The prefix that is prepended to group claims to prevent clashes with existing
	// names (such as system: groups). For example, the valueoidc: creates group
	// names like oidc:engineering and oidc:infra. The prefix can't contain system:
	GroupsPrefix *string `locationName:"groupsPrefix" type:"string"`

	// The ARN of the configuration.
	IdentityProviderConfigArn *string `locationName:"identityProviderConfigArn" type:"string"`

	// The name of the configuration.
	IdentityProviderConfigName *string `locationName:"identityProviderConfigName" type:"string"`

	// The URL of the OIDC identity provider that allows the API server to discover
	// public signing keys for verifying tokens.
	IssuerUrl *string `locationName:"issuerUrl" type:"string"`

	// The key-value pairs that describe required claims in the identity token.
	// If set, each claim is verified to be present in the token with a matching
	// value.
	RequiredClaims map[string]*string `locationName:"requiredClaims" type:"map"`

	// The status of the OIDC identity provider.
	Status *string `locationName:"status" type:"string" enum:"ConfigStatus"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`

	// The JSON Web token (JWT) claim that is used as the username.
	UsernameClaim *string `locationName:"usernameClaim" type:"string"`

	// The prefix that is prepended to username claims to prevent clashes with existing
	// names. The prefix can't contain system:
	UsernamePrefix *string `locationName:"usernamePrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcIdentityProviderConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcIdentityProviderConfig) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *OidcIdentityProviderConfig) SetClientId(v string) *OidcIdentityProviderConfig {
	s.ClientId = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *OidcIdentityProviderConfig) SetClusterName(v string) *OidcIdentityProviderConfig {
	s.ClusterName = &v
	return s
}

// SetGroupsClaim sets the GroupsClaim field's value.
func (s *OidcIdentityProviderConfig) SetGroupsClaim(v string) *OidcIdentityProviderConfig {
	s.GroupsClaim = &v
	return s
}

// SetGroupsPrefix sets the GroupsPrefix field's value.
func (s *OidcIdentityProviderConfig) SetGroupsPrefix(v string) *OidcIdentityProviderConfig {
	s.GroupsPrefix = &v
	return s
}

// SetIdentityProviderConfigArn sets the IdentityProviderConfigArn field's value.
func (s *OidcIdentityProviderConfig) SetIdentityProviderConfigArn(v string) *OidcIdentityProviderConfig {
	s.IdentityProviderConfigArn = &v
	return s
}

// SetIdentityProviderConfigName sets the IdentityProviderConfigName field's value.
func (s *OidcIdentityProviderConfig) SetIdentityProviderConfigName(v string) *OidcIdentityProviderConfig {
	s.IdentityProviderConfigName = &v
	return s
}

// SetIssuerUrl sets the IssuerUrl field's value.
func (s *OidcIdentityProviderConfig) SetIssuerUrl(v string) *OidcIdentityProviderConfig {
	s.IssuerUrl = &v
	return s
}

// SetRequiredClaims sets the RequiredClaims field's value.
func (s *OidcIdentityProviderConfig) SetRequiredClaims(v map[string]*string) *OidcIdentityProviderConfig {
	s.RequiredClaims = v
	return s
}

// SetStatus sets the Status field's value.
func (s *OidcIdentityProviderConfig) SetStatus(v string) *OidcIdentityProviderConfig {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *OidcIdentityProviderConfig) SetTags(v map[string]*string) *OidcIdentityProviderConfig {
	s.Tags = v
	return s
}

// SetUsernameClaim sets the UsernameClaim field's value.
func (s *OidcIdentityProviderConfig) SetUsernameClaim(v string) *OidcIdentityProviderConfig {
	s.UsernameClaim = &v
	return s
}

// SetUsernamePrefix sets the UsernamePrefix field's value.
func (s *OidcIdentityProviderConfig) SetUsernamePrefix(v string) *OidcIdentityProviderConfig {
	s.UsernamePrefix = &v
	return s
}

// An object representing an OpenID Connect (OIDC) configuration. Before associating
// an OIDC identity provider to your cluster, review the considerations in Authenticating
// users for your cluster from an OIDC identity provider (https://docs.aws.amazon.com/eks/latest/userguide/authenticate-oidc-identity-provider.html)
// in the Amazon EKS User Guide.
type OidcIdentityProviderConfigRequest struct {
	_ struct{} `type:"structure"`

	// This is also known as audience. The ID for the client application that makes
	// authentication requests to the OIDC identity provider.
	//
	// ClientId is a required field
	ClientId *string `locationName:"clientId" type:"string" required:"true"`

	// The JWT claim that the provider uses to return your groups.
	GroupsClaim *string `locationName:"groupsClaim" type:"string"`

	// The prefix that is prepended to group claims to prevent clashes with existing
	// names (such as system: groups). For example, the valueoidc: will create group
	// names like oidc:engineering and oidc:infra.
	GroupsPrefix *string `locationName:"groupsPrefix" type:"string"`

	// The name of the OIDC provider configuration.
	//
	// IdentityProviderConfigName is a required field
	IdentityProviderConfigName *string `locationName:"identityProviderConfigName" type:"string" required:"true"`

	// The URL of the OIDC identity provider that allows the API server to discover
	// public signing keys for verifying tokens. The URL must begin with https://
	// and should correspond to the iss claim in the provider's OIDC ID tokens.
	// Based on the OIDC standard, path components are allowed but query parameters
	// are not. Typically the URL consists of only a hostname, like https://server.example.org
	// or https://example.com. This URL should point to the level below .well-known/openid-configuration
	// and must be publicly accessible over the internet.
	//
	// IssuerUrl is a required field
	IssuerUrl *string `locationName:"issuerUrl" type:"string" required:"true"`

	// The key value pairs that describe required claims in the identity token.
	// If set, each claim is verified to be present in the token with a matching
	// value. For the maximum number of claims that you can require, see Amazon
	// EKS service quotas (https://docs.aws.amazon.com/eks/latest/userguide/service-quotas.html)
	// in the Amazon EKS User Guide.
	RequiredClaims map[string]*string `locationName:"requiredClaims" type:"map"`

	// The JSON Web Token (JWT) claim to use as the username. The default is sub,
	// which is expected to be a unique identifier of the end user. You can choose
	// other claims, such as email or name, depending on the OIDC identity provider.
	// Claims other than email are prefixed with the issuer URL to prevent naming
	// clashes with other plug-ins.
	UsernameClaim *string `locationName:"usernameClaim" type:"string"`

	// The prefix that is prepended to username claims to prevent clashes with existing
	// names. If you do not provide this field, and username is a value other than
	// email, the prefix defaults to issuerurl#. You can use the value - to disable
	// all prefixing.
	UsernamePrefix *string `locationName:"usernamePrefix" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcIdentityProviderConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OidcIdentityProviderConfigRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OidcIdentityProviderConfigRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OidcIdentityProviderConfigRequest"}
	if s.ClientId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientId"))
	}
	if s.IdentityProviderConfigName == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityProviderConfigName"))
	}
	if s.IssuerUrl == nil {
		invalidParams.Add(request.NewErrParamRequired("IssuerUrl"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientId sets the ClientId field's value.
func (s *OidcIdentityProviderConfigRequest) SetClientId(v string) *OidcIdentityProviderConfigRequest {
	s.ClientId = &v
	return s
}

// SetGroupsClaim sets the GroupsClaim field's value.
func (s *OidcIdentityProviderConfigRequest) SetGroupsClaim(v string) *OidcIdentityProviderConfigRequest {
	s.GroupsClaim = &v
	return s
}

// SetGroupsPrefix sets the GroupsPrefix field's value.
func (s *OidcIdentityProviderConfigRequest) SetGroupsPrefix(v string) *OidcIdentityProviderConfigRequest {
	s.GroupsPrefix = &v
	return s
}

// SetIdentityProviderConfigName sets the IdentityProviderConfigName field's value.
func (s *OidcIdentityProviderConfigRequest) SetIdentityProviderConfigName(v string) *OidcIdentityProviderConfigRequest {
	s.IdentityProviderConfigName = &v
	return s
}

// SetIssuerUrl sets the IssuerUrl field's value.
func (s *OidcIdentityProviderConfigRequest) SetIssuerUrl(v string) *OidcIdentityProviderConfigRequest {
	s.IssuerUrl = &v
	return s
}

// SetRequiredClaims sets the RequiredClaims field's value.
func (s *OidcIdentityProviderConfigRequest) SetRequiredClaims(v map[string]*string) *OidcIdentityProviderConfigRequest {
	s.RequiredClaims = v
	return s
}

// SetUsernameClaim sets the UsernameClaim field's value.
func (s *OidcIdentityProviderConfigRequest) SetUsernameClaim(v string) *OidcIdentityProviderConfigRequest {
	s.UsernameClaim = &v
	return s
}

// SetUsernamePrefix sets the UsernamePrefix field's value.
func (s *OidcIdentityProviderConfigRequest) SetUsernamePrefix(v string) *OidcIdentityProviderConfigRequest {
	s.UsernamePrefix = &v
	return s
}

// The configuration of your local Amazon EKS cluster on an Amazon Web Services
// Outpost. Before creating a cluster on an Outpost, review Creating a local
// cluster on an Outpost (https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-local-cluster-create.html)
// in the Amazon EKS User Guide. This API isn't available for Amazon EKS clusters
// on the Amazon Web Services cloud.
type OutpostConfigRequest struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 instance type that you want to use for your local Amazon EKS
	// cluster on Outposts. Choose an instance type based on the number of nodes
	// that your cluster will have. For more information, see Capacity considerations
	// (https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html)
	// in the Amazon EKS User Guide.
	//
	// The instance type that you specify is used for all Kubernetes control plane
	// instances. The instance type can't be changed after cluster creation. The
	// control plane is not automatically scaled by Amazon EKS.
	//
	// ControlPlaneInstanceType is a required field
	ControlPlaneInstanceType *string `locationName:"controlPlaneInstanceType" type:"string" required:"true"`

	// An object representing the placement configuration for all the control plane
	// instances of your local Amazon EKS cluster on an Amazon Web Services Outpost.
	// For more information, see Capacity considerations (https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html)
	// in the Amazon EKS User Guide.
	ControlPlanePlacement *ControlPlanePlacementRequest `locationName:"controlPlanePlacement" type:"structure"`

	// The ARN of the Outpost that you want to use for your local Amazon EKS cluster
	// on Outposts. Only a single Outpost ARN is supported.
	//
	// OutpostArns is a required field
	OutpostArns []*string `locationName:"outpostArns" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutpostConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutpostConfigRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutpostConfigRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutpostConfigRequest"}
	if s.ControlPlaneInstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlPlaneInstanceType"))
	}
	if s.OutpostArns == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostArns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlPlaneInstanceType sets the ControlPlaneInstanceType field's value.
func (s *OutpostConfigRequest) SetControlPlaneInstanceType(v string) *OutpostConfigRequest {
	s.ControlPlaneInstanceType = &v
	return s
}

// SetControlPlanePlacement sets the ControlPlanePlacement field's value.
func (s *OutpostConfigRequest) SetControlPlanePlacement(v *ControlPlanePlacementRequest) *OutpostConfigRequest {
	s.ControlPlanePlacement = v
	return s
}

// SetOutpostArns sets the OutpostArns field's value.
func (s *OutpostConfigRequest) SetOutpostArns(v []*string) *OutpostConfigRequest {
	s.OutpostArns = v
	return s
}

// An object representing the configuration of your local Amazon EKS cluster
// on an Amazon Web Services Outpost. This API isn't available for Amazon EKS
// clusters on the Amazon Web Services cloud.
type OutpostConfigResponse struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 instance type used for the control plane. The instance type
	// is the same for all control plane instances.
	//
	// ControlPlaneInstanceType is a required field
	ControlPlaneInstanceType *string `locationName:"controlPlaneInstanceType" type:"string" required:"true"`

	// An object representing the placement configuration for all the control plane
	// instances of your local Amazon EKS cluster on an Amazon Web Services Outpost.
	// For more information, see Capacity considerations (https://docs.aws.amazon.com/eks/latest/userguide/eks-outposts-capacity-considerations.html)
	// in the Amazon EKS User Guide.
	ControlPlanePlacement *ControlPlanePlacementResponse `locationName:"controlPlanePlacement" type:"structure"`

	// The ARN of the Outpost that you specified for use with your local Amazon
	// EKS cluster on Outposts.
	//
	// OutpostArns is a required field
	OutpostArns []*string `locationName:"outpostArns" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutpostConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutpostConfigResponse) GoString() string {
	return s.String()
}

// SetControlPlaneInstanceType sets the ControlPlaneInstanceType field's value.
func (s *OutpostConfigResponse) SetControlPlaneInstanceType(v string) *OutpostConfigResponse {
	s.ControlPlaneInstanceType = &v
	return s
}

// SetControlPlanePlacement sets the ControlPlanePlacement field's value.
func (s *OutpostConfigResponse) SetControlPlanePlacement(v *ControlPlanePlacementResponse) *OutpostConfigResponse {
	s.ControlPlanePlacement = v
	return s
}

// SetOutpostArns sets the OutpostArns field's value.
func (s *OutpostConfigResponse) SetOutpostArns(v []*string) *OutpostConfigResponse {
	s.OutpostArns = v
	return s
}

// Amazon EKS Pod Identity associations provide the ability to manage credentials
// for your applications, similar to the way that Amazon EC2 instance profiles
// provide credentials to Amazon EC2 instances.
type PodIdentityAssociation struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	AssociationArn *string `locationName:"associationArn" type:"string"`

	// The ID of the association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The name of the cluster that the association is in.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The timestamp that the association was created at.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The most recent timestamp that the association was modified at
	ModifiedAt *time.Time `locationName:"modifiedAt" type:"timestamp"`

	// The name of the Kubernetes namespace inside the cluster to create the association
	// in. The service account and the pods that use the service account must be
	// in this namespace.
	Namespace *string `locationName:"namespace" type:"string"`

	// If defined, the Pod Identity Association is owned by an Amazon EKS Addon.
	OwnerArn *string `locationName:"ownerArn" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role to associate with the service
	// account. The EKS Pod Identity agent manages credentials to assume this role
	// for applications in the containers in the pods that use this service account.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The name of the Kubernetes service account inside the cluster to associate
	// the IAM credentials with.
	ServiceAccount *string `locationName:"serviceAccount" type:"string"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	//
	// The following basic restrictions apply to tags:
	//
	//    * Maximum number of tags per resource – 50
	//
	//    * For each resource, each tag key must be unique, and each tag key can
	//    have only one value.
	//
	//    * Maximum key length – 128 Unicode characters in UTF-8
	//
	//    * Maximum value length – 256 Unicode characters in UTF-8
	//
	//    * If your tagging schema is used across multiple services and resources,
	//    remember that other services may have restrictions on allowed characters.
	//    Generally allowed characters are: letters, numbers, and spaces representable
	//    in UTF-8, and the following characters: + - = . _ : / @.
	//
	//    * Tag keys and values are case-sensitive.
	//
	//    * Do not use aws:, AWS:, or any upper or lowercase combination of such
	//    as a prefix for either keys or values as it is reserved for Amazon Web
	//    Services use. You cannot edit or delete tag keys or values with this prefix.
	//    Tags with this prefix do not count against your tags per resource limit.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PodIdentityAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PodIdentityAssociation) GoString() string {
	return s.String()
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *PodIdentityAssociation) SetAssociationArn(v string) *PodIdentityAssociation {
	s.AssociationArn = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *PodIdentityAssociation) SetAssociationId(v string) *PodIdentityAssociation {
	s.AssociationId = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *PodIdentityAssociation) SetClusterName(v string) *PodIdentityAssociation {
	s.ClusterName = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *PodIdentityAssociation) SetCreatedAt(v time.Time) *PodIdentityAssociation {
	s.CreatedAt = &v
	return s
}

// SetModifiedAt sets the ModifiedAt field's value.
func (s *PodIdentityAssociation) SetModifiedAt(v time.Time) *PodIdentityAssociation {
	s.ModifiedAt = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PodIdentityAssociation) SetNamespace(v string) *PodIdentityAssociation {
	s.Namespace = &v
	return s
}

// SetOwnerArn sets the OwnerArn field's value.
func (s *PodIdentityAssociation) SetOwnerArn(v string) *PodIdentityAssociation {
	s.OwnerArn = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *PodIdentityAssociation) SetRoleArn(v string) *PodIdentityAssociation {
	s.RoleArn = &v
	return s
}

// SetServiceAccount sets the ServiceAccount field's value.
func (s *PodIdentityAssociation) SetServiceAccount(v string) *PodIdentityAssociation {
	s.ServiceAccount = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *PodIdentityAssociation) SetTags(v map[string]*string) *PodIdentityAssociation {
	s.Tags = v
	return s
}

// The summarized description of the association.
//
// Each summary is simplified by removing these fields compared to the full
// PodIdentityAssociation :
//
//   - The IAM role: roleArn
//
//   - The timestamp that the association was created at: createdAt
//
//   - The most recent timestamp that the association was modified at:. modifiedAt
//
//   - The tags on the association: tags
type PodIdentityAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the association.
	AssociationArn *string `locationName:"associationArn" type:"string"`

	// The ID of the association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The name of the cluster that the association is in.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The name of the Kubernetes namespace inside the cluster to create the association
	// in. The service account and the pods that use the service account must be
	// in this namespace.
	Namespace *string `locationName:"namespace" type:"string"`

	// If defined, the Pod Identity Association is owned by an Amazon EKS Addon.
	OwnerArn *string `locationName:"ownerArn" type:"string"`

	// The name of the Kubernetes service account inside the cluster to associate
	// the IAM credentials with.
	ServiceAccount *string `locationName:"serviceAccount" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PodIdentityAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PodIdentityAssociationSummary) GoString() string {
	return s.String()
}

// SetAssociationArn sets the AssociationArn field's value.
func (s *PodIdentityAssociationSummary) SetAssociationArn(v string) *PodIdentityAssociationSummary {
	s.AssociationArn = &v
	return s
}

// SetAssociationId sets the AssociationId field's value.
func (s *PodIdentityAssociationSummary) SetAssociationId(v string) *PodIdentityAssociationSummary {
	s.AssociationId = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *PodIdentityAssociationSummary) SetClusterName(v string) *PodIdentityAssociationSummary {
	s.ClusterName = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *PodIdentityAssociationSummary) SetNamespace(v string) *PodIdentityAssociationSummary {
	s.Namespace = &v
	return s
}

// SetOwnerArn sets the OwnerArn field's value.
func (s *PodIdentityAssociationSummary) SetOwnerArn(v string) *PodIdentityAssociationSummary {
	s.OwnerArn = &v
	return s
}

// SetServiceAccount sets the ServiceAccount field's value.
func (s *PodIdentityAssociationSummary) SetServiceAccount(v string) *PodIdentityAssociationSummary {
	s.ServiceAccount = &v
	return s
}

// Identifies the Key Management Service (KMS) key used to encrypt the secrets.
type Provider struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) or alias of the KMS key. The KMS key must be symmetric
	// and created in the same Amazon Web Services Region as the cluster. If the
	// KMS key was created in a different account, the IAM principal (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html)
	// must have access to the KMS key. For more information, see Allowing users
	// in other accounts to use a KMS key (https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html)
	// in the Key Management Service Developer Guide.
	KeyArn *string `locationName:"keyArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Provider) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Provider) GoString() string {
	return s.String()
}

// SetKeyArn sets the KeyArn field's value.
func (s *Provider) SetKeyArn(v string) *Provider {
	s.KeyArn = &v
	return s
}

type RegisterClusterInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The configuration settings required to connect the Kubernetes cluster to
	// the Amazon EKS control plane.
	//
	// ConnectorConfig is a required field
	ConnectorConfig *ConnectorConfigRequest `locationName:"connectorConfig" type:"structure" required:"true"`

	// A unique name for this cluster in your Amazon Web Services Region.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterClusterInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterClusterInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterClusterInput"}
	if s.ConnectorConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectorConfig"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ConnectorConfig != nil {
		if err := s.ConnectorConfig.Validate(); err != nil {
			invalidParams.AddNested("ConnectorConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *RegisterClusterInput) SetClientRequestToken(v string) *RegisterClusterInput {
	s.ClientRequestToken = &v
	return s
}

// SetConnectorConfig sets the ConnectorConfig field's value.
func (s *RegisterClusterInput) SetConnectorConfig(v *ConnectorConfigRequest) *RegisterClusterInput {
	s.ConnectorConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *RegisterClusterInput) SetName(v string) *RegisterClusterInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterClusterInput) SetTags(v map[string]*string) *RegisterClusterInput {
	s.Tags = v
	return s
}

type RegisterClusterOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an Amazon EKS cluster.
	Cluster *Cluster `locationName:"cluster" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterClusterOutput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *RegisterClusterOutput) SetCluster(v *Cluster) *RegisterClusterOutput {
	s.Cluster = v
	return s
}

// An object representing the remote access configuration for the managed node
// group.
type RemoteAccessConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon EC2 SSH key name that provides access for SSH communication with
	// the nodes in the managed node group. For more information, see Amazon EC2
	// key pairs and Linux instances (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
	// in the Amazon Elastic Compute Cloud User Guide for Linux Instances. For Windows,
	// an Amazon EC2 SSH key is used to obtain the RDP password. For more information,
	// see Amazon EC2 key pairs and Windows instances (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-key-pairs.html)
	// in the Amazon Elastic Compute Cloud User Guide for Windows Instances.
	Ec2SshKey *string `locationName:"ec2SshKey" type:"string"`

	// The security group IDs that are allowed SSH access (port 22) to the nodes.
	// For Windows, the port is 3389. If you specify an Amazon EC2 SSH key but don't
	// specify a source security group when you create a managed node group, then
	// the port on the nodes is opened to the internet (0.0.0.0/0). For more information,
	// see Security Groups for Your VPC (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SourceSecurityGroups []*string `locationName:"sourceSecurityGroups" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoteAccessConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RemoteAccessConfig) GoString() string {
	return s.String()
}

// SetEc2SshKey sets the Ec2SshKey field's value.
func (s *RemoteAccessConfig) SetEc2SshKey(v string) *RemoteAccessConfig {
	s.Ec2SshKey = &v
	return s
}

// SetSourceSecurityGroups sets the SourceSecurityGroups field's value.
func (s *RemoteAccessConfig) SetSourceSecurityGroups(v []*string) *RemoteAccessConfig {
	s.SourceSecurityGroups = v
	return s
}

// The specified resource is in use.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The specified add-on name is in use.
	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Amazon EKS message associated with the exception.
	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have encountered a service limit on the specified resource.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Amazon EKS message associated with the exception.
	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The Amazon EKS subscription ID with the exception.
	SubscriptionId *string `locationName:"subscriptionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource could not be found. You can view your available clusters
// with ListClusters. You can view your available managed node groups with ListNodegroups.
// Amazon EKS clusters and node groups are Amazon Web Services Region specific.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS add-on name associated with the exception.
	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// The Fargate profile associated with the exception.
	FargateProfileName *string `locationName:"fargateProfileName" type:"string"`

	// The Amazon EKS message associated with the exception.
	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The Amazon EKS subscription ID with the exception.
	SubscriptionId *string `locationName:"subscriptionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Required resources (such as service-linked roles) were created and are still
// propagating. Retry later.
type ResourcePropagationDelayException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Required resources (such as service-linked roles) were created and are still
	// propagating. Retry later.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePropagationDelayException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePropagationDelayException) GoString() string {
	return s.String()
}

func newErrorResourcePropagationDelayException(v protocol.ResponseMetadata) error {
	return &ResourcePropagationDelayException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourcePropagationDelayException) Code() string {
	return "ResourcePropagationDelayException"
}

// Message returns the exception's message.
func (s *ResourcePropagationDelayException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourcePropagationDelayException) OrigErr() error {
	return nil
}

func (s *ResourcePropagationDelayException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourcePropagationDelayException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourcePropagationDelayException) RequestID() string {
	return s.RespMetadata.RequestID
}

// These errors are usually caused by a server-side issue.
type ServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS add-on name associated with the exception.
	AddonName *string `locationName:"addonName" type:"string"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// These errors are usually caused by a server-side issue.
	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The Amazon EKS subscription ID with the exception.
	SubscriptionId *string `locationName:"subscriptionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServerException) GoString() string {
	return s.String()
}

func newErrorServerException(v protocol.ResponseMetadata) error {
	return &ServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServerException) Code() string {
	return "ServerException"
}

// Message returns the exception's message.
func (s *ServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServerException) OrigErr() error {
	return nil
}

func (s *ServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The service is unavailable. Back off and retry the operation.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The request has failed due to a temporary failure of the server.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to add tags to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Metadata that assists with categorization and organization. Each tag consists
	// of a key and an optional value. You define both. Tags don't propagate to
	// any other cluster or Amazon Web Services resources.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A property that allows a node to repel a Pod. For more information, see Node
// taints on managed node groups (https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html)
// in the Amazon EKS User Guide.
type Taint struct {
	_ struct{} `type:"structure"`

	// The effect of the taint.
	Effect *string `locationName:"effect" type:"string" enum:"TaintEffect"`

	// The key of the taint.
	Key *string `locationName:"key" min:"1" type:"string"`

	// The value of the taint.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Taint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Taint) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Taint) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Taint"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEffect sets the Effect field's value.
func (s *Taint) SetEffect(v string) *Taint {
	s.Effect = &v
	return s
}

// SetKey sets the Key field's value.
func (s *Taint) SetKey(v string) *Taint {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Taint) SetValue(v string) *Taint {
	s.Value = &v
	return s
}

// At least one of your specified cluster subnets is in an Availability Zone
// that does not support Amazon EKS. The exception output specifies the supported
// Availability Zones for your account, from which you can choose subnets for
// your cluster.
type UnsupportedAvailabilityZoneException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The Amazon EKS cluster associated with the exception.
	ClusterName *string `locationName:"clusterName" type:"string"`

	// At least one of your specified cluster subnets is in an Availability Zone
	// that does not support Amazon EKS. The exception output specifies the supported
	// Availability Zones for your account, from which you can choose subnets for
	// your cluster.
	Message_ *string `locationName:"message" type:"string"`

	// The Amazon EKS managed node group associated with the exception.
	NodegroupName *string `locationName:"nodegroupName" type:"string"`

	// The supported Availability Zones for your account. Choose subnets in these
	// Availability Zones for your cluster.
	ValidZones []*string `locationName:"validZones" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedAvailabilityZoneException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedAvailabilityZoneException) GoString() string {
	return s.String()
}

func newErrorUnsupportedAvailabilityZoneException(v protocol.ResponseMetadata) error {
	return &UnsupportedAvailabilityZoneException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedAvailabilityZoneException) Code() string {
	return "UnsupportedAvailabilityZoneException"
}

// Message returns the exception's message.
func (s *UnsupportedAvailabilityZoneException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedAvailabilityZoneException) OrigErr() error {
	return nil
}

func (s *UnsupportedAvailabilityZoneException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedAvailabilityZoneException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedAvailabilityZoneException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource to delete tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The keys of the tags to remove.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// An object representing an asynchronous update.
type Update struct {
	_ struct{} `type:"structure"`

	// The Unix epoch timestamp at object creation.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Any errors associated with a Failed update.
	Errors []*ErrorDetail `locationName:"errors" type:"list"`

	// A UUID that is used to track the update.
	Id *string `locationName:"id" type:"string"`

	// A key-value map that contains the parameters associated with the update.
	Params []*UpdateParam `locationName:"params" type:"list"`

	// The current status of the update.
	Status *string `locationName:"status" type:"string" enum:"UpdateStatus"`

	// The type of the update.
	Type *string `locationName:"type" type:"string" enum:"UpdateType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Update) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Update) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Update) SetCreatedAt(v time.Time) *Update {
	s.CreatedAt = &v
	return s
}

// SetErrors sets the Errors field's value.
func (s *Update) SetErrors(v []*ErrorDetail) *Update {
	s.Errors = v
	return s
}

// SetId sets the Id field's value.
func (s *Update) SetId(v string) *Update {
	s.Id = &v
	return s
}

// SetParams sets the Params field's value.
func (s *Update) SetParams(v []*UpdateParam) *Update {
	s.Params = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Update) SetStatus(v string) *Update {
	s.Status = &v
	return s
}

// SetType sets the Type field's value.
func (s *Update) SetType(v string) *Update {
	s.Type = &v
	return s
}

// The access configuration information for the cluster.
type UpdateAccessConfigRequest struct {
	_ struct{} `type:"structure"`

	// The desired authentication mode for the cluster.
	AuthenticationMode *string `locationName:"authenticationMode" type:"string" enum:"AuthenticationMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessConfigRequest) GoString() string {
	return s.String()
}

// SetAuthenticationMode sets the AuthenticationMode field's value.
func (s *UpdateAccessConfigRequest) SetAuthenticationMode(v string) *UpdateAccessConfigRequest {
	s.AuthenticationMode = &v
	return s
}

type UpdateAccessEntryInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The value for name that you've specified for kind: Group as a subject in
	// a Kubernetes RoleBinding or ClusterRoleBinding object. Amazon EKS doesn't
	// confirm that the value for name exists in any bindings on your cluster. You
	// can specify one or more names.
	//
	// Kubernetes authorizes the principalArn of the access entry to access any
	// cluster objects that you've specified in a Kubernetes Role or ClusterRole
	// object that is also specified in a binding's roleRef. For more information
	// about creating Kubernetes RoleBinding, ClusterRoleBinding, Role, or ClusterRole
	// objects, see Using RBAC Authorization in the Kubernetes documentation (https://kubernetes.io/docs/reference/access-authn-authz/rbac/).
	//
	// If you want Amazon EKS to authorize the principalArn (instead of, or in addition
	// to Kubernetes authorizing the principalArn), you can associate one or more
	// access policies to the access entry using AssociateAccessPolicy. If you associate
	// any access policies, the principalARN has all permissions assigned in the
	// associated access policies and all permissions in any Kubernetes Role or
	// ClusterRole objects that the group names are bound to.
	KubernetesGroups []*string `locationName:"kubernetesGroups" type:"list"`

	// The ARN of the IAM principal for the AccessEntry.
	//
	// PrincipalArn is a required field
	PrincipalArn *string `location:"uri" locationName:"principalArn" type:"string" required:"true"`

	// The username to authenticate to Kubernetes with. We recommend not specifying
	// a username and letting Amazon EKS specify it for you. For more information
	// about the value Amazon EKS specifies for you, or constraints before specifying
	// your own username, see Creating access entries (https://docs.aws.amazon.com/eks/latest/userguide/access-entries.html#creating-access-entries)
	// in the Amazon EKS User Guide.
	Username *string `locationName:"username" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessEntryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessEntryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAccessEntryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAccessEntryInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.PrincipalArn == nil {
		invalidParams.Add(request.NewErrParamRequired("PrincipalArn"))
	}
	if s.PrincipalArn != nil && len(*s.PrincipalArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PrincipalArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateAccessEntryInput) SetClientRequestToken(v string) *UpdateAccessEntryInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateAccessEntryInput) SetClusterName(v string) *UpdateAccessEntryInput {
	s.ClusterName = &v
	return s
}

// SetKubernetesGroups sets the KubernetesGroups field's value.
func (s *UpdateAccessEntryInput) SetKubernetesGroups(v []*string) *UpdateAccessEntryInput {
	s.KubernetesGroups = v
	return s
}

// SetPrincipalArn sets the PrincipalArn field's value.
func (s *UpdateAccessEntryInput) SetPrincipalArn(v string) *UpdateAccessEntryInput {
	s.PrincipalArn = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *UpdateAccessEntryInput) SetUsername(v string) *UpdateAccessEntryInput {
	s.Username = &v
	return s
}

type UpdateAccessEntryOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM principal for the AccessEntry.
	AccessEntry *AccessEntry `locationName:"accessEntry" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessEntryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccessEntryOutput) GoString() string {
	return s.String()
}

// SetAccessEntry sets the AccessEntry field's value.
func (s *UpdateAccessEntryOutput) SetAccessEntry(v *AccessEntry) *UpdateAccessEntryOutput {
	s.AccessEntry = v
	return s
}

type UpdateAddonInput struct {
	_ struct{} `type:"structure"`

	// The name of the add-on. The name must match one of the names returned by
	// ListAddons (https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html).
	//
	// AddonName is a required field
	AddonName *string `location:"uri" locationName:"addonName" type:"string" required:"true"`

	// The version of the add-on. The version must match one of the versions returned
	// by DescribeAddonVersions (https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html).
	AddonVersion *string `locationName:"addonVersion" type:"string"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// The set of configuration values for the add-on that's created. The values
	// that you provide are validated against the schema returned by DescribeAddonConfiguration.
	ConfigurationValues *string `locationName:"configurationValues" type:"string"`

	// An array of Pod Identity Assocations to be updated. Each EKS Pod Identity
	// association maps a Kubernetes service account to an IAM Role. If this value
	// is left blank, no change. If an empty array is provided, existing Pod Identity
	// Assocations owned by the Addon are deleted.
	//
	// For more information, see Attach an IAM Role to an Amazon EKS add-on using
	// Pod Identity (https://docs.aws.amazon.com/eks/latest/userguide/add-ons-iam.html)
	// in the EKS User Guide.
	PodIdentityAssociations []*AddonPodIdentityAssociations `locationName:"podIdentityAssociations" type:"list"`

	// How to resolve field value conflicts for an Amazon EKS add-on if you've changed
	// a value from the Amazon EKS default value. Conflicts are handled based on
	// the option you choose:
	//
	//    * None – Amazon EKS doesn't change the value. The update might fail.
	//
	//    * Overwrite – Amazon EKS overwrites the changed value back to the Amazon
	//    EKS default value.
	//
	//    * Preserve – Amazon EKS preserves the value. If you choose this option,
	//    we recommend that you test any field and value changes on a non-production
	//    cluster before updating the add-on on your production cluster.
	ResolveConflicts *string `locationName:"resolveConflicts" type:"string" enum:"ResolveConflicts"`

	// The Amazon Resource Name (ARN) of an existing IAM role to bind to the add-on's
	// service account. The role must be assigned the IAM permissions required by
	// the add-on. If you don't specify an existing IAM role, then the add-on uses
	// the permissions assigned to the node IAM role. For more information, see
	// Amazon EKS node IAM role (https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
	// in the Amazon EKS User Guide.
	//
	// To specify an existing IAM role, you must have an IAM OpenID Connect (OIDC)
	// provider created for your cluster. For more information, see Enabling IAM
	// roles for service accounts on your cluster (https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
	// in the Amazon EKS User Guide.
	ServiceAccountRoleArn *string `locationName:"serviceAccountRoleArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddonInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAddonInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAddonInput"}
	if s.AddonName == nil {
		invalidParams.Add(request.NewErrParamRequired("AddonName"))
	}
	if s.AddonName != nil && len(*s.AddonName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AddonName", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.ServiceAccountRoleArn != nil && len(*s.ServiceAccountRoleArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServiceAccountRoleArn", 1))
	}
	if s.PodIdentityAssociations != nil {
		for i, v := range s.PodIdentityAssociations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PodIdentityAssociations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddonName sets the AddonName field's value.
func (s *UpdateAddonInput) SetAddonName(v string) *UpdateAddonInput {
	s.AddonName = &v
	return s
}

// SetAddonVersion sets the AddonVersion field's value.
func (s *UpdateAddonInput) SetAddonVersion(v string) *UpdateAddonInput {
	s.AddonVersion = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateAddonInput) SetClientRequestToken(v string) *UpdateAddonInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateAddonInput) SetClusterName(v string) *UpdateAddonInput {
	s.ClusterName = &v
	return s
}

// SetConfigurationValues sets the ConfigurationValues field's value.
func (s *UpdateAddonInput) SetConfigurationValues(v string) *UpdateAddonInput {
	s.ConfigurationValues = &v
	return s
}

// SetPodIdentityAssociations sets the PodIdentityAssociations field's value.
func (s *UpdateAddonInput) SetPodIdentityAssociations(v []*AddonPodIdentityAssociations) *UpdateAddonInput {
	s.PodIdentityAssociations = v
	return s
}

// SetResolveConflicts sets the ResolveConflicts field's value.
func (s *UpdateAddonInput) SetResolveConflicts(v string) *UpdateAddonInput {
	s.ResolveConflicts = &v
	return s
}

// SetServiceAccountRoleArn sets the ServiceAccountRoleArn field's value.
func (s *UpdateAddonInput) SetServiceAccountRoleArn(v string) *UpdateAddonInput {
	s.ServiceAccountRoleArn = &v
	return s
}

type UpdateAddonOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAddonOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateAddonOutput) SetUpdate(v *Update) *UpdateAddonOutput {
	s.Update = v
	return s
}

type UpdateClusterConfigInput struct {
	_ struct{} `type:"structure"`

	// The access configuration for the cluster.
	AccessConfig *UpdateAccessConfigRequest `locationName:"accessConfig" type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// Enable or disable exporting the Kubernetes control plane logs for your cluster
	// to CloudWatch Logs. By default, cluster control plane logs aren't exported
	// to CloudWatch Logs. For more information, see Amazon EKS cluster control
	// plane logs (https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
	// in the Amazon EKS User Guide .
	//
	// CloudWatch Logs ingestion, archive storage, and data scanning rates apply
	// to exported control plane logs. For more information, see CloudWatch Pricing
	// (http://aws.amazon.com/cloudwatch/pricing/).
	Logging *Logging `locationName:"logging" type:"structure"`

	// The name of the Amazon EKS cluster to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// An object representing the VPC configuration to use for an Amazon EKS cluster.
	ResourcesVpcConfig *VpcConfigRequest `locationName:"resourcesVpcConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterConfigInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessConfig sets the AccessConfig field's value.
func (s *UpdateClusterConfigInput) SetAccessConfig(v *UpdateAccessConfigRequest) *UpdateClusterConfigInput {
	s.AccessConfig = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateClusterConfigInput) SetClientRequestToken(v string) *UpdateClusterConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetLogging sets the Logging field's value.
func (s *UpdateClusterConfigInput) SetLogging(v *Logging) *UpdateClusterConfigInput {
	s.Logging = v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateClusterConfigInput) SetName(v string) *UpdateClusterConfigInput {
	s.Name = &v
	return s
}

// SetResourcesVpcConfig sets the ResourcesVpcConfig field's value.
func (s *UpdateClusterConfigInput) SetResourcesVpcConfig(v *VpcConfigRequest) *UpdateClusterConfigInput {
	s.ResourcesVpcConfig = v
	return s
}

type UpdateClusterConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateClusterConfigOutput) SetUpdate(v *Update) *UpdateClusterConfigOutput {
	s.Update = v
	return s
}

type UpdateClusterVersionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster to update.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The desired Kubernetes version following a successful update.
	//
	// Version is a required field
	Version *string `locationName:"version" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClusterVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClusterVersionInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version == nil {
		invalidParams.Add(request.NewErrParamRequired("Version"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateClusterVersionInput) SetClientRequestToken(v string) *UpdateClusterVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateClusterVersionInput) SetName(v string) *UpdateClusterVersionInput {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateClusterVersionInput) SetVersion(v string) *UpdateClusterVersionInput {
	s.Version = &v
	return s
}

type UpdateClusterVersionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the specified update
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClusterVersionOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateClusterVersionOutput) SetUpdate(v *Update) *UpdateClusterVersionOutput {
	s.Update = v
	return s
}

type UpdateEksAnywhereSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether or not to automatically renew the subscription.
	//
	// AutoRenew is a required field
	AutoRenew *bool `locationName:"autoRenew" type:"boolean" required:"true"`

	// Unique, case-sensitive identifier to ensure the idempotency of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The ID of the subscription.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEksAnywhereSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEksAnywhereSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEksAnywhereSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEksAnywhereSubscriptionInput"}
	if s.AutoRenew == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoRenew"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *UpdateEksAnywhereSubscriptionInput) SetAutoRenew(v bool) *UpdateEksAnywhereSubscriptionInput {
	s.AutoRenew = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateEksAnywhereSubscriptionInput) SetClientRequestToken(v string) *UpdateEksAnywhereSubscriptionInput {
	s.ClientRequestToken = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateEksAnywhereSubscriptionInput) SetId(v string) *UpdateEksAnywhereSubscriptionInput {
	s.Id = &v
	return s
}

type UpdateEksAnywhereSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the updated subscription.
	Subscription *EksAnywhereSubscription `locationName:"subscription" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEksAnywhereSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEksAnywhereSubscriptionOutput) GoString() string {
	return s.String()
}

// SetSubscription sets the Subscription field's value.
func (s *UpdateEksAnywhereSubscriptionOutput) SetSubscription(v *EksAnywhereSubscription) *UpdateEksAnywhereSubscriptionOutput {
	s.Subscription = v
	return s
}

// An object representing a Kubernetes label change for a managed node group.
type UpdateLabelsPayload struct {
	_ struct{} `type:"structure"`

	// The Kubernetes labels to add or update.
	AddOrUpdateLabels map[string]*string `locationName:"addOrUpdateLabels" type:"map"`

	// The Kubernetes labels to remove.
	RemoveLabels []*string `locationName:"removeLabels" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLabelsPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateLabelsPayload) GoString() string {
	return s.String()
}

// SetAddOrUpdateLabels sets the AddOrUpdateLabels field's value.
func (s *UpdateLabelsPayload) SetAddOrUpdateLabels(v map[string]*string) *UpdateLabelsPayload {
	s.AddOrUpdateLabels = v
	return s
}

// SetRemoveLabels sets the RemoveLabels field's value.
func (s *UpdateLabelsPayload) SetRemoveLabels(v []*string) *UpdateLabelsPayload {
	s.RemoveLabels = v
	return s
}

type UpdateNodegroupConfigInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The Kubernetes labels to apply to the nodes in the node group after the update.
	Labels *UpdateLabelsPayload `locationName:"labels" type:"structure"`

	// The name of the managed node group to update.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`

	// The scaling configuration details for the Auto Scaling group after the update.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`

	// The Kubernetes taints to be applied to the nodes in the node group after
	// the update. For more information, see Node taints on managed node groups
	// (https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html).
	Taints *UpdateTaintsPayload `locationName:"taints" type:"structure"`

	// The node group update configuration.
	UpdateConfig *NodegroupUpdateConfig `locationName:"updateConfig" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodegroupConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNodegroupConfigInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}
	if s.ScalingConfig != nil {
		if err := s.ScalingConfig.Validate(); err != nil {
			invalidParams.AddNested("ScalingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Taints != nil {
		if err := s.Taints.Validate(); err != nil {
			invalidParams.AddNested("Taints", err.(request.ErrInvalidParams))
		}
	}
	if s.UpdateConfig != nil {
		if err := s.UpdateConfig.Validate(); err != nil {
			invalidParams.AddNested("UpdateConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateNodegroupConfigInput) SetClientRequestToken(v string) *UpdateNodegroupConfigInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateNodegroupConfigInput) SetClusterName(v string) *UpdateNodegroupConfigInput {
	s.ClusterName = &v
	return s
}

// SetLabels sets the Labels field's value.
func (s *UpdateNodegroupConfigInput) SetLabels(v *UpdateLabelsPayload) *UpdateNodegroupConfigInput {
	s.Labels = v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *UpdateNodegroupConfigInput) SetNodegroupName(v string) *UpdateNodegroupConfigInput {
	s.NodegroupName = &v
	return s
}

// SetScalingConfig sets the ScalingConfig field's value.
func (s *UpdateNodegroupConfigInput) SetScalingConfig(v *NodegroupScalingConfig) *UpdateNodegroupConfigInput {
	s.ScalingConfig = v
	return s
}

// SetTaints sets the Taints field's value.
func (s *UpdateNodegroupConfigInput) SetTaints(v *UpdateTaintsPayload) *UpdateNodegroupConfigInput {
	s.Taints = v
	return s
}

// SetUpdateConfig sets the UpdateConfig field's value.
func (s *UpdateNodegroupConfigInput) SetUpdateConfig(v *NodegroupUpdateConfig) *UpdateNodegroupConfigInput {
	s.UpdateConfig = v
	return s
}

type UpdateNodegroupConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupConfigOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateNodegroupConfigOutput) SetUpdate(v *Update) *UpdateNodegroupConfigOutput {
	s.Update = v
	return s
}

type UpdateNodegroupVersionInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of your cluster.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// Force the update if any Pod on the existing node group can't be drained due
	// to a Pod disruption budget issue. If an update fails because all Pods can't
	// be drained, you can force the update after it fails to terminate the old
	// node whether or not any Pod is running on the node.
	Force *bool `locationName:"force" type:"boolean"`

	// An object representing a node group's launch template specification. You
	// can only update a node group using a launch template if the node group was
	// originally deployed with a launch template.
	LaunchTemplate *LaunchTemplateSpecification `locationName:"launchTemplate" type:"structure"`

	// The name of the managed node group to update.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`

	// The AMI version of the Amazon EKS optimized AMI to use for the update. By
	// default, the latest available AMI version for the node group's Kubernetes
	// version is used. For information about Linux versions, see Amazon EKS optimized
	// Amazon Linux AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
	// in the Amazon EKS User Guide. Amazon EKS managed node groups support the
	// November 2022 and later releases of the Windows AMIs. For information about
	// Windows versions, see Amazon EKS optimized Windows AMI versions (https://docs.aws.amazon.com/eks/latest/userguide/eks-ami-versions-windows.html)
	// in the Amazon EKS User Guide.
	//
	// If you specify launchTemplate, and your launch template uses a custom AMI,
	// then don't specify releaseVersion, or the node group update will fail. For
	// more information about using launch templates with Amazon EKS, see Customizing
	// managed nodes with launch templates (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	ReleaseVersion *string `locationName:"releaseVersion" type:"string"`

	// The Kubernetes version to update to. If no version is specified, then the
	// Kubernetes version of the node group does not change. You can specify the
	// Kubernetes version of the cluster to update the node group to the latest
	// AMI version of the cluster's Kubernetes version. If you specify launchTemplate,
	// and your launch template uses a custom AMI, then don't specify version, or
	// the node group update will fail. For more information about using launch
	// templates with Amazon EKS, see Customizing managed nodes with launch templates
	// (https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
	// in the Amazon EKS User Guide.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodegroupVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNodegroupVersionInput"}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}
	if s.NodegroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodegroupName"))
	}
	if s.NodegroupName != nil && len(*s.NodegroupName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NodegroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdateNodegroupVersionInput) SetClientRequestToken(v string) *UpdateNodegroupVersionInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdateNodegroupVersionInput) SetClusterName(v string) *UpdateNodegroupVersionInput {
	s.ClusterName = &v
	return s
}

// SetForce sets the Force field's value.
func (s *UpdateNodegroupVersionInput) SetForce(v bool) *UpdateNodegroupVersionInput {
	s.Force = &v
	return s
}

// SetLaunchTemplate sets the LaunchTemplate field's value.
func (s *UpdateNodegroupVersionInput) SetLaunchTemplate(v *LaunchTemplateSpecification) *UpdateNodegroupVersionInput {
	s.LaunchTemplate = v
	return s
}

// SetNodegroupName sets the NodegroupName field's value.
func (s *UpdateNodegroupVersionInput) SetNodegroupName(v string) *UpdateNodegroupVersionInput {
	s.NodegroupName = &v
	return s
}

// SetReleaseVersion sets the ReleaseVersion field's value.
func (s *UpdateNodegroupVersionInput) SetReleaseVersion(v string) *UpdateNodegroupVersionInput {
	s.ReleaseVersion = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateNodegroupVersionInput) SetVersion(v string) *UpdateNodegroupVersionInput {
	s.Version = &v
	return s
}

type UpdateNodegroupVersionOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNodegroupVersionOutput) GoString() string {
	return s.String()
}

// SetUpdate sets the Update field's value.
func (s *UpdateNodegroupVersionOutput) SetUpdate(v *Update) *UpdateNodegroupVersionOutput {
	s.Update = v
	return s
}

// An object representing the details of an update request.
type UpdateParam struct {
	_ struct{} `type:"structure"`

	// The keys associated with an update request.
	Type *string `locationName:"type" type:"string" enum:"UpdateParamType"`

	// The value of the keys submitted as part of an update request.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParam) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateParam) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *UpdateParam) SetType(v string) *UpdateParam {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *UpdateParam) SetValue(v string) *UpdateParam {
	s.Value = &v
	return s
}

type UpdatePodIdentityAssociationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the association to be updated.
	//
	// AssociationId is a required field
	AssociationId *string `location:"uri" locationName:"associationId" type:"string" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the cluster that you want to update the association in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The new IAM role to change the
	RoleArn *string `locationName:"roleArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePodIdentityAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePodIdentityAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdatePodIdentityAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdatePodIdentityAssociationInput"}
	if s.AssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("AssociationId"))
	}
	if s.AssociationId != nil && len(*s.AssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AssociationId", 1))
	}
	if s.ClusterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterName"))
	}
	if s.ClusterName != nil && len(*s.ClusterName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociationId sets the AssociationId field's value.
func (s *UpdatePodIdentityAssociationInput) SetAssociationId(v string) *UpdatePodIdentityAssociationInput {
	s.AssociationId = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *UpdatePodIdentityAssociationInput) SetClientRequestToken(v string) *UpdatePodIdentityAssociationInput {
	s.ClientRequestToken = &v
	return s
}

// SetClusterName sets the ClusterName field's value.
func (s *UpdatePodIdentityAssociationInput) SetClusterName(v string) *UpdatePodIdentityAssociationInput {
	s.ClusterName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdatePodIdentityAssociationInput) SetRoleArn(v string) *UpdatePodIdentityAssociationInput {
	s.RoleArn = &v
	return s
}

type UpdatePodIdentityAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The full description of the EKS Pod Identity association that was updated.
	Association *PodIdentityAssociation `locationName:"association" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePodIdentityAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdatePodIdentityAssociationOutput) GoString() string {
	return s.String()
}

// SetAssociation sets the Association field's value.
func (s *UpdatePodIdentityAssociationOutput) SetAssociation(v *PodIdentityAssociation) *UpdatePodIdentityAssociationOutput {
	s.Association = v
	return s
}

// An object representing the details of an update to a taints payload. For
// more information, see Node taints on managed node groups (https://docs.aws.amazon.com/eks/latest/userguide/node-taints-managed-node-groups.html)
// in the Amazon EKS User Guide.
type UpdateTaintsPayload struct {
	_ struct{} `type:"structure"`

	// Kubernetes taints to be added or updated.
	AddOrUpdateTaints []*Taint `locationName:"addOrUpdateTaints" type:"list"`

	// Kubernetes taints to remove.
	RemoveTaints []*Taint `locationName:"removeTaints" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaintsPayload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateTaintsPayload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateTaintsPayload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateTaintsPayload"}
	if s.AddOrUpdateTaints != nil {
		for i, v := range s.AddOrUpdateTaints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "AddOrUpdateTaints", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.RemoveTaints != nil {
		for i, v := range s.RemoveTaints {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RemoveTaints", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddOrUpdateTaints sets the AddOrUpdateTaints field's value.
func (s *UpdateTaintsPayload) SetAddOrUpdateTaints(v []*Taint) *UpdateTaintsPayload {
	s.AddOrUpdateTaints = v
	return s
}

// SetRemoveTaints sets the RemoveTaints field's value.
func (s *UpdateTaintsPayload) SetRemoveTaints(v []*Taint) *UpdateTaintsPayload {
	s.RemoveTaints = v
	return s
}

// An object representing the VPC configuration to use for an Amazon EKS cluster.
type VpcConfigRequest struct {
	_ struct{} `type:"structure"`

	// Set this value to true to enable private access for your cluster's Kubernetes
	// API server endpoint. If you enable private access, Kubernetes API requests
	// from within your cluster's VPC use the private VPC endpoint. The default
	// value for this parameter is false, which disables private access for your
	// Kubernetes API server. If you disable private access and you have nodes or
	// Fargate pods in the cluster, then ensure that publicAccessCidrs includes
	// the necessary CIDR blocks for communication with the nodes or Fargate pods.
	// For more information, see Amazon EKS cluster endpoint access control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPrivateAccess *bool `locationName:"endpointPrivateAccess" type:"boolean"`

	// Set this value to false to disable public access to your cluster's Kubernetes
	// API server endpoint. If you disable public access, your cluster's Kubernetes
	// API server can only receive requests from within the cluster VPC. The default
	// value for this parameter is true, which enables public access for your Kubernetes
	// API server. For more information, see Amazon EKS cluster endpoint access
	// control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPublicAccess *bool `locationName:"endpointPublicAccess" type:"boolean"`

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes
	// API server endpoint. Communication to the endpoint from addresses outside
	// of the CIDR blocks that you specify is denied. The default value is 0.0.0.0/0.
	// If you've disabled private endpoint access, make sure that you specify the
	// necessary CIDR blocks for every node and Fargate Pod in the cluster. For
	// more information, see Amazon EKS cluster endpoint access control (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	PublicAccessCidrs []*string `locationName:"publicAccessCidrs" type:"list"`

	// Specify one or more security groups for the cross-account elastic network
	// interfaces that Amazon EKS creates to use that allow communication between
	// your nodes and the Kubernetes control plane. If you don't specify any security
	// groups, then familiarize yourself with the difference between Amazon EKS
	// defaults for clusters deployed with Kubernetes. For more information, see
	// Amazon EKS security group considerations (https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
	// in the Amazon EKS User Guide .
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// Specify subnets for your Amazon EKS nodes. Amazon EKS creates cross-account
	// elastic network interfaces in these subnets to allow communication between
	// your nodes and the Kubernetes control plane.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigRequest) GoString() string {
	return s.String()
}

// SetEndpointPrivateAccess sets the EndpointPrivateAccess field's value.
func (s *VpcConfigRequest) SetEndpointPrivateAccess(v bool) *VpcConfigRequest {
	s.EndpointPrivateAccess = &v
	return s
}

// SetEndpointPublicAccess sets the EndpointPublicAccess field's value.
func (s *VpcConfigRequest) SetEndpointPublicAccess(v bool) *VpcConfigRequest {
	s.EndpointPublicAccess = &v
	return s
}

// SetPublicAccessCidrs sets the PublicAccessCidrs field's value.
func (s *VpcConfigRequest) SetPublicAccessCidrs(v []*string) *VpcConfigRequest {
	s.PublicAccessCidrs = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigRequest) SetSecurityGroupIds(v []*string) *VpcConfigRequest {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigRequest) SetSubnetIds(v []*string) *VpcConfigRequest {
	s.SubnetIds = v
	return s
}

// An object representing an Amazon EKS cluster VPC configuration response.
type VpcConfigResponse struct {
	_ struct{} `type:"structure"`

	// The cluster security group that was created by Amazon EKS for the cluster.
	// Managed node groups use this security group for control-plane-to-data-plane
	// communication.
	ClusterSecurityGroupId *string `locationName:"clusterSecurityGroupId" type:"string"`

	// This parameter indicates whether the Amazon EKS private API server endpoint
	// is enabled. If the Amazon EKS private API server endpoint is enabled, Kubernetes
	// API requests that originate from within your cluster's VPC use the private
	// VPC endpoint instead of traversing the internet. If this value is disabled
	// and you have nodes or Fargate pods in the cluster, then ensure that publicAccessCidrs
	// includes the necessary CIDR blocks for communication with the nodes or Fargate
	// pods. For more information, see Amazon EKS cluster endpoint access control
	// (https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
	// in the Amazon EKS User Guide .
	EndpointPrivateAccess *bool `locationName:"endpointPrivateAccess" type:"boolean"`

	// Whether the public API server endpoint is enabled.
	EndpointPublicAccess *bool `locationName:"endpointPublicAccess" type:"boolean"`

	// The CIDR blocks that are allowed access to your cluster's public Kubernetes
	// API server endpoint.
	PublicAccessCidrs []*string `locationName:"publicAccessCidrs" type:"list"`

	// The security groups associated with the cross-account elastic network interfaces
	// that are used to allow communication between your nodes and the Kubernetes
	// control plane.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The subnets associated with your cluster.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The VPC associated with your cluster.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigResponse) GoString() string {
	return s.String()
}

// SetClusterSecurityGroupId sets the ClusterSecurityGroupId field's value.
func (s *VpcConfigResponse) SetClusterSecurityGroupId(v string) *VpcConfigResponse {
	s.ClusterSecurityGroupId = &v
	return s
}

// SetEndpointPrivateAccess sets the EndpointPrivateAccess field's value.
func (s *VpcConfigResponse) SetEndpointPrivateAccess(v bool) *VpcConfigResponse {
	s.EndpointPrivateAccess = &v
	return s
}

// SetEndpointPublicAccess sets the EndpointPublicAccess field's value.
func (s *VpcConfigResponse) SetEndpointPublicAccess(v bool) *VpcConfigResponse {
	s.EndpointPublicAccess = &v
	return s
}

// SetPublicAccessCidrs sets the PublicAccessCidrs field's value.
func (s *VpcConfigResponse) SetPublicAccessCidrs(v []*string) *VpcConfigResponse {
	s.PublicAccessCidrs = v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigResponse) SetSecurityGroupIds(v []*string) *VpcConfigResponse {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigResponse) SetSubnetIds(v []*string) *VpcConfigResponse {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigResponse) SetVpcId(v string) *VpcConfigResponse {
	s.VpcId = &v
	return s
}

const (
	// AMITypesAl2X8664 is a AMITypes enum value
	AMITypesAl2X8664 = "AL2_x86_64"

	// AMITypesAl2X8664Gpu is a AMITypes enum value
	AMITypesAl2X8664Gpu = "AL2_x86_64_GPU"

	// AMITypesAl2Arm64 is a AMITypes enum value
	AMITypesAl2Arm64 = "AL2_ARM_64"

	// AMITypesCustom is a AMITypes enum value
	AMITypesCustom = "CUSTOM"

	// AMITypesBottlerocketArm64 is a AMITypes enum value
	AMITypesBottlerocketArm64 = "BOTTLEROCKET_ARM_64"

	// AMITypesBottlerocketX8664 is a AMITypes enum value
	AMITypesBottlerocketX8664 = "BOTTLEROCKET_x86_64"

	// AMITypesBottlerocketArm64Nvidia is a AMITypes enum value
	AMITypesBottlerocketArm64Nvidia = "BOTTLEROCKET_ARM_64_NVIDIA"

	// AMITypesBottlerocketX8664Nvidia is a AMITypes enum value
	AMITypesBottlerocketX8664Nvidia = "BOTTLEROCKET_x86_64_NVIDIA"

	// AMITypesWindowsCore2019X8664 is a AMITypes enum value
	AMITypesWindowsCore2019X8664 = "WINDOWS_CORE_2019_x86_64"

	// AMITypesWindowsFull2019X8664 is a AMITypes enum value
	AMITypesWindowsFull2019X8664 = "WINDOWS_FULL_2019_x86_64"

	// AMITypesWindowsCore2022X8664 is a AMITypes enum value
	AMITypesWindowsCore2022X8664 = "WINDOWS_CORE_2022_x86_64"

	// AMITypesWindowsFull2022X8664 is a AMITypes enum value
	AMITypesWindowsFull2022X8664 = "WINDOWS_FULL_2022_x86_64"

	// AMITypesAl2023X8664Standard is a AMITypes enum value
	AMITypesAl2023X8664Standard = "AL2023_x86_64_STANDARD"

	// AMITypesAl2023Arm64Standard is a AMITypes enum value
	AMITypesAl2023Arm64Standard = "AL2023_ARM_64_STANDARD"
)

// AMITypes_Values returns all elements of the AMITypes enum
func AMITypes_Values() []string {
	return []string{
		AMITypesAl2X8664,
		AMITypesAl2X8664Gpu,
		AMITypesAl2Arm64,
		AMITypesCustom,
		AMITypesBottlerocketArm64,
		AMITypesBottlerocketX8664,
		AMITypesBottlerocketArm64Nvidia,
		AMITypesBottlerocketX8664Nvidia,
		AMITypesWindowsCore2019X8664,
		AMITypesWindowsFull2019X8664,
		AMITypesWindowsCore2022X8664,
		AMITypesWindowsFull2022X8664,
		AMITypesAl2023X8664Standard,
		AMITypesAl2023Arm64Standard,
	}
}

const (
	// AccessScopeTypeCluster is a AccessScopeType enum value
	AccessScopeTypeCluster = "cluster"

	// AccessScopeTypeNamespace is a AccessScopeType enum value
	AccessScopeTypeNamespace = "namespace"
)

// AccessScopeType_Values returns all elements of the AccessScopeType enum
func AccessScopeType_Values() []string {
	return []string{
		AccessScopeTypeCluster,
		AccessScopeTypeNamespace,
	}
}

const (
	// AddonIssueCodeAccessDenied is a AddonIssueCode enum value
	AddonIssueCodeAccessDenied = "AccessDenied"

	// AddonIssueCodeInternalFailure is a AddonIssueCode enum value
	AddonIssueCodeInternalFailure = "InternalFailure"

	// AddonIssueCodeClusterUnreachable is a AddonIssueCode enum value
	AddonIssueCodeClusterUnreachable = "ClusterUnreachable"

	// AddonIssueCodeInsufficientNumberOfReplicas is a AddonIssueCode enum value
	AddonIssueCodeInsufficientNumberOfReplicas = "InsufficientNumberOfReplicas"

	// AddonIssueCodeConfigurationConflict is a AddonIssueCode enum value
	AddonIssueCodeConfigurationConflict = "ConfigurationConflict"

	// AddonIssueCodeAdmissionRequestDenied is a AddonIssueCode enum value
	AddonIssueCodeAdmissionRequestDenied = "AdmissionRequestDenied"

	// AddonIssueCodeUnsupportedAddonModification is a AddonIssueCode enum value
	AddonIssueCodeUnsupportedAddonModification = "UnsupportedAddonModification"

	// AddonIssueCodeK8sResourceNotFound is a AddonIssueCode enum value
	AddonIssueCodeK8sResourceNotFound = "K8sResourceNotFound"

	// AddonIssueCodeAddonSubscriptionNeeded is a AddonIssueCode enum value
	AddonIssueCodeAddonSubscriptionNeeded = "AddonSubscriptionNeeded"

	// AddonIssueCodeAddonPermissionFailure is a AddonIssueCode enum value
	AddonIssueCodeAddonPermissionFailure = "AddonPermissionFailure"
)

// AddonIssueCode_Values returns all elements of the AddonIssueCode enum
func AddonIssueCode_Values() []string {
	return []string{
		AddonIssueCodeAccessDenied,
		AddonIssueCodeInternalFailure,
		AddonIssueCodeClusterUnreachable,
		AddonIssueCodeInsufficientNumberOfReplicas,
		AddonIssueCodeConfigurationConflict,
		AddonIssueCodeAdmissionRequestDenied,
		AddonIssueCodeUnsupportedAddonModification,
		AddonIssueCodeK8sResourceNotFound,
		AddonIssueCodeAddonSubscriptionNeeded,
		AddonIssueCodeAddonPermissionFailure,
	}
}

const (
	// AddonStatusCreating is a AddonStatus enum value
	AddonStatusCreating = "CREATING"

	// AddonStatusActive is a AddonStatus enum value
	AddonStatusActive = "ACTIVE"

	// AddonStatusCreateFailed is a AddonStatus enum value
	AddonStatusCreateFailed = "CREATE_FAILED"

	// AddonStatusUpdating is a AddonStatus enum value
	AddonStatusUpdating = "UPDATING"

	// AddonStatusDeleting is a AddonStatus enum value
	AddonStatusDeleting = "DELETING"

	// AddonStatusDeleteFailed is a AddonStatus enum value
	AddonStatusDeleteFailed = "DELETE_FAILED"

	// AddonStatusDegraded is a AddonStatus enum value
	AddonStatusDegraded = "DEGRADED"

	// AddonStatusUpdateFailed is a AddonStatus enum value
	AddonStatusUpdateFailed = "UPDATE_FAILED"
)

// AddonStatus_Values returns all elements of the AddonStatus enum
func AddonStatus_Values() []string {
	return []string{
		AddonStatusCreating,
		AddonStatusActive,
		AddonStatusCreateFailed,
		AddonStatusUpdating,
		AddonStatusDeleting,
		AddonStatusDeleteFailed,
		AddonStatusDegraded,
		AddonStatusUpdateFailed,
	}
}

const (
	// AuthenticationModeApi is a AuthenticationMode enum value
	AuthenticationModeApi = "API"

	// AuthenticationModeApiAndConfigMap is a AuthenticationMode enum value
	AuthenticationModeApiAndConfigMap = "API_AND_CONFIG_MAP"

	// AuthenticationModeConfigMap is a AuthenticationMode enum value
	AuthenticationModeConfigMap = "CONFIG_MAP"
)

// AuthenticationMode_Values returns all elements of the AuthenticationMode enum
func AuthenticationMode_Values() []string {
	return []string{
		AuthenticationModeApi,
		AuthenticationModeApiAndConfigMap,
		AuthenticationModeConfigMap,
	}
}

const (
	// CapacityTypesOnDemand is a CapacityTypes enum value
	CapacityTypesOnDemand = "ON_DEMAND"

	// CapacityTypesSpot is a CapacityTypes enum value
	CapacityTypesSpot = "SPOT"
)

// CapacityTypes_Values returns all elements of the CapacityTypes enum
func CapacityTypes_Values() []string {
	return []string{
		CapacityTypesOnDemand,
		CapacityTypesSpot,
	}
}

const (
	// CategoryUpgradeReadiness is a Category enum value
	CategoryUpgradeReadiness = "UPGRADE_READINESS"
)

// Category_Values returns all elements of the Category enum
func Category_Values() []string {
	return []string{
		CategoryUpgradeReadiness,
	}
}

const (
	// ClusterIssueCodeAccessDenied is a ClusterIssueCode enum value
	ClusterIssueCodeAccessDenied = "AccessDenied"

	// ClusterIssueCodeClusterUnreachable is a ClusterIssueCode enum value
	ClusterIssueCodeClusterUnreachable = "ClusterUnreachable"

	// ClusterIssueCodeConfigurationConflict is a ClusterIssueCode enum value
	ClusterIssueCodeConfigurationConflict = "ConfigurationConflict"

	// ClusterIssueCodeInternalFailure is a ClusterIssueCode enum value
	ClusterIssueCodeInternalFailure = "InternalFailure"

	// ClusterIssueCodeResourceLimitExceeded is a ClusterIssueCode enum value
	ClusterIssueCodeResourceLimitExceeded = "ResourceLimitExceeded"

	// ClusterIssueCodeResourceNotFound is a ClusterIssueCode enum value
	ClusterIssueCodeResourceNotFound = "ResourceNotFound"

	// ClusterIssueCodeIamRoleNotFound is a ClusterIssueCode enum value
	ClusterIssueCodeIamRoleNotFound = "IamRoleNotFound"

	// ClusterIssueCodeVpcNotFound is a ClusterIssueCode enum value
	ClusterIssueCodeVpcNotFound = "VpcNotFound"

	// ClusterIssueCodeInsufficientFreeAddresses is a ClusterIssueCode enum value
	ClusterIssueCodeInsufficientFreeAddresses = "InsufficientFreeAddresses"

	// ClusterIssueCodeEc2serviceNotSubscribed is a ClusterIssueCode enum value
	ClusterIssueCodeEc2serviceNotSubscribed = "Ec2ServiceNotSubscribed"

	// ClusterIssueCodeEc2subnetNotFound is a ClusterIssueCode enum value
	ClusterIssueCodeEc2subnetNotFound = "Ec2SubnetNotFound"

	// ClusterIssueCodeEc2securityGroupNotFound is a ClusterIssueCode enum value
	ClusterIssueCodeEc2securityGroupNotFound = "Ec2SecurityGroupNotFound"

	// ClusterIssueCodeKmsGrantRevoked is a ClusterIssueCode enum value
	ClusterIssueCodeKmsGrantRevoked = "KmsGrantRevoked"

	// ClusterIssueCodeKmsKeyNotFound is a ClusterIssueCode enum value
	ClusterIssueCodeKmsKeyNotFound = "KmsKeyNotFound"

	// ClusterIssueCodeKmsKeyMarkedForDeletion is a ClusterIssueCode enum value
	ClusterIssueCodeKmsKeyMarkedForDeletion = "KmsKeyMarkedForDeletion"

	// ClusterIssueCodeKmsKeyDisabled is a ClusterIssueCode enum value
	ClusterIssueCodeKmsKeyDisabled = "KmsKeyDisabled"

	// ClusterIssueCodeStsRegionalEndpointDisabled is a ClusterIssueCode enum value
	ClusterIssueCodeStsRegionalEndpointDisabled = "StsRegionalEndpointDisabled"

	// ClusterIssueCodeUnsupportedVersion is a ClusterIssueCode enum value
	ClusterIssueCodeUnsupportedVersion = "UnsupportedVersion"

	// ClusterIssueCodeOther is a ClusterIssueCode enum value
	ClusterIssueCodeOther = "Other"
)

// ClusterIssueCode_Values returns all elements of the ClusterIssueCode enum
func ClusterIssueCode_Values() []string {
	return []string{
		ClusterIssueCodeAccessDenied,
		ClusterIssueCodeClusterUnreachable,
		ClusterIssueCodeConfigurationConflict,
		ClusterIssueCodeInternalFailure,
		ClusterIssueCodeResourceLimitExceeded,
		ClusterIssueCodeResourceNotFound,
		ClusterIssueCodeIamRoleNotFound,
		ClusterIssueCodeVpcNotFound,
		ClusterIssueCodeInsufficientFreeAddresses,
		ClusterIssueCodeEc2serviceNotSubscribed,
		ClusterIssueCodeEc2subnetNotFound,
		ClusterIssueCodeEc2securityGroupNotFound,
		ClusterIssueCodeKmsGrantRevoked,
		ClusterIssueCodeKmsKeyNotFound,
		ClusterIssueCodeKmsKeyMarkedForDeletion,
		ClusterIssueCodeKmsKeyDisabled,
		ClusterIssueCodeStsRegionalEndpointDisabled,
		ClusterIssueCodeUnsupportedVersion,
		ClusterIssueCodeOther,
	}
}

const (
	// ClusterStatusCreating is a ClusterStatus enum value
	ClusterStatusCreating = "CREATING"

	// ClusterStatusActive is a ClusterStatus enum value
	ClusterStatusActive = "ACTIVE"

	// ClusterStatusDeleting is a ClusterStatus enum value
	ClusterStatusDeleting = "DELETING"

	// ClusterStatusFailed is a ClusterStatus enum value
	ClusterStatusFailed = "FAILED"

	// ClusterStatusUpdating is a ClusterStatus enum value
	ClusterStatusUpdating = "UPDATING"

	// ClusterStatusPending is a ClusterStatus enum value
	ClusterStatusPending = "PENDING"
)

// ClusterStatus_Values returns all elements of the ClusterStatus enum
func ClusterStatus_Values() []string {
	return []string{
		ClusterStatusCreating,
		ClusterStatusActive,
		ClusterStatusDeleting,
		ClusterStatusFailed,
		ClusterStatusUpdating,
		ClusterStatusPending,
	}
}

const (
	// ConfigStatusCreating is a ConfigStatus enum value
	ConfigStatusCreating = "CREATING"

	// ConfigStatusDeleting is a ConfigStatus enum value
	ConfigStatusDeleting = "DELETING"

	// ConfigStatusActive is a ConfigStatus enum value
	ConfigStatusActive = "ACTIVE"
)

// ConfigStatus_Values returns all elements of the ConfigStatus enum
func ConfigStatus_Values() []string {
	return []string{
		ConfigStatusCreating,
		ConfigStatusDeleting,
		ConfigStatusActive,
	}
}

const (
	// ConnectorConfigProviderEksAnywhere is a ConnectorConfigProvider enum value
	ConnectorConfigProviderEksAnywhere = "EKS_ANYWHERE"

	// ConnectorConfigProviderAnthos is a ConnectorConfigProvider enum value
	ConnectorConfigProviderAnthos = "ANTHOS"

	// ConnectorConfigProviderGke is a ConnectorConfigProvider enum value
	ConnectorConfigProviderGke = "GKE"

	// ConnectorConfigProviderAks is a ConnectorConfigProvider enum value
	ConnectorConfigProviderAks = "AKS"

	// ConnectorConfigProviderOpenshift is a ConnectorConfigProvider enum value
	ConnectorConfigProviderOpenshift = "OPENSHIFT"

	// ConnectorConfigProviderTanzu is a ConnectorConfigProvider enum value
	ConnectorConfigProviderTanzu = "TANZU"

	// ConnectorConfigProviderRancher is a ConnectorConfigProvider enum value
	ConnectorConfigProviderRancher = "RANCHER"

	// ConnectorConfigProviderEc2 is a ConnectorConfigProvider enum value
	ConnectorConfigProviderEc2 = "EC2"

	// ConnectorConfigProviderOther is a ConnectorConfigProvider enum value
	ConnectorConfigProviderOther = "OTHER"
)

// ConnectorConfigProvider_Values returns all elements of the ConnectorConfigProvider enum
func ConnectorConfigProvider_Values() []string {
	return []string{
		ConnectorConfigProviderEksAnywhere,
		ConnectorConfigProviderAnthos,
		ConnectorConfigProviderGke,
		ConnectorConfigProviderAks,
		ConnectorConfigProviderOpenshift,
		ConnectorConfigProviderTanzu,
		ConnectorConfigProviderRancher,
		ConnectorConfigProviderEc2,
		ConnectorConfigProviderOther,
	}
}

const (
	// EksAnywhereSubscriptionLicenseTypeCluster is a EksAnywhereSubscriptionLicenseType enum value
	EksAnywhereSubscriptionLicenseTypeCluster = "Cluster"
)

// EksAnywhereSubscriptionLicenseType_Values returns all elements of the EksAnywhereSubscriptionLicenseType enum
func EksAnywhereSubscriptionLicenseType_Values() []string {
	return []string{
		EksAnywhereSubscriptionLicenseTypeCluster,
	}
}

const (
	// EksAnywhereSubscriptionStatusCreating is a EksAnywhereSubscriptionStatus enum value
	EksAnywhereSubscriptionStatusCreating = "CREATING"

	// EksAnywhereSubscriptionStatusActive is a EksAnywhereSubscriptionStatus enum value
	EksAnywhereSubscriptionStatusActive = "ACTIVE"

	// EksAnywhereSubscriptionStatusUpdating is a EksAnywhereSubscriptionStatus enum value
	EksAnywhereSubscriptionStatusUpdating = "UPDATING"

	// EksAnywhereSubscriptionStatusExpiring is a EksAnywhereSubscriptionStatus enum value
	EksAnywhereSubscriptionStatusExpiring = "EXPIRING"

	// EksAnywhereSubscriptionStatusExpired is a EksAnywhereSubscriptionStatus enum value
	EksAnywhereSubscriptionStatusExpired = "EXPIRED"

	// EksAnywhereSubscriptionStatusDeleting is a EksAnywhereSubscriptionStatus enum value
	EksAnywhereSubscriptionStatusDeleting = "DELETING"
)

// EksAnywhereSubscriptionStatus_Values returns all elements of the EksAnywhereSubscriptionStatus enum
func EksAnywhereSubscriptionStatus_Values() []string {
	return []string{
		EksAnywhereSubscriptionStatusCreating,
		EksAnywhereSubscriptionStatusActive,
		EksAnywhereSubscriptionStatusUpdating,
		EksAnywhereSubscriptionStatusExpiring,
		EksAnywhereSubscriptionStatusExpired,
		EksAnywhereSubscriptionStatusDeleting,
	}
}

const (
	// EksAnywhereSubscriptionTermUnitMonths is a EksAnywhereSubscriptionTermUnit enum value
	EksAnywhereSubscriptionTermUnitMonths = "MONTHS"
)

// EksAnywhereSubscriptionTermUnit_Values returns all elements of the EksAnywhereSubscriptionTermUnit enum
func EksAnywhereSubscriptionTermUnit_Values() []string {
	return []string{
		EksAnywhereSubscriptionTermUnitMonths,
	}
}

const (
	// ErrorCodeSubnetNotFound is a ErrorCode enum value
	ErrorCodeSubnetNotFound = "SubnetNotFound"

	// ErrorCodeSecurityGroupNotFound is a ErrorCode enum value
	ErrorCodeSecurityGroupNotFound = "SecurityGroupNotFound"

	// ErrorCodeEniLimitReached is a ErrorCode enum value
	ErrorCodeEniLimitReached = "EniLimitReached"

	// ErrorCodeIpNotAvailable is a ErrorCode enum value
	ErrorCodeIpNotAvailable = "IpNotAvailable"

	// ErrorCodeAccessDenied is a ErrorCode enum value
	ErrorCodeAccessDenied = "AccessDenied"

	// ErrorCodeOperationNotPermitted is a ErrorCode enum value
	ErrorCodeOperationNotPermitted = "OperationNotPermitted"

	// ErrorCodeVpcIdNotFound is a ErrorCode enum value
	ErrorCodeVpcIdNotFound = "VpcIdNotFound"

	// ErrorCodeUnknown is a ErrorCode enum value
	ErrorCodeUnknown = "Unknown"

	// ErrorCodeNodeCreationFailure is a ErrorCode enum value
	ErrorCodeNodeCreationFailure = "NodeCreationFailure"

	// ErrorCodePodEvictionFailure is a ErrorCode enum value
	ErrorCodePodEvictionFailure = "PodEvictionFailure"

	// ErrorCodeInsufficientFreeAddresses is a ErrorCode enum value
	ErrorCodeInsufficientFreeAddresses = "InsufficientFreeAddresses"

	// ErrorCodeClusterUnreachable is a ErrorCode enum value
	ErrorCodeClusterUnreachable = "ClusterUnreachable"

	// ErrorCodeInsufficientNumberOfReplicas is a ErrorCode enum value
	ErrorCodeInsufficientNumberOfReplicas = "InsufficientNumberOfReplicas"

	// ErrorCodeConfigurationConflict is a ErrorCode enum value
	ErrorCodeConfigurationConflict = "ConfigurationConflict"

	// ErrorCodeAdmissionRequestDenied is a ErrorCode enum value
	ErrorCodeAdmissionRequestDenied = "AdmissionRequestDenied"

	// ErrorCodeUnsupportedAddonModification is a ErrorCode enum value
	ErrorCodeUnsupportedAddonModification = "UnsupportedAddonModification"

	// ErrorCodeK8sResourceNotFound is a ErrorCode enum value
	ErrorCodeK8sResourceNotFound = "K8sResourceNotFound"
)

// ErrorCode_Values returns all elements of the ErrorCode enum
func ErrorCode_Values() []string {
	return []string{
		ErrorCodeSubnetNotFound,
		ErrorCodeSecurityGroupNotFound,
		ErrorCodeEniLimitReached,
		ErrorCodeIpNotAvailable,
		ErrorCodeAccessDenied,
		ErrorCodeOperationNotPermitted,
		ErrorCodeVpcIdNotFound,
		ErrorCodeUnknown,
		ErrorCodeNodeCreationFailure,
		ErrorCodePodEvictionFailure,
		ErrorCodeInsufficientFreeAddresses,
		ErrorCodeClusterUnreachable,
		ErrorCodeInsufficientNumberOfReplicas,
		ErrorCodeConfigurationConflict,
		ErrorCodeAdmissionRequestDenied,
		ErrorCodeUnsupportedAddonModification,
		ErrorCodeK8sResourceNotFound,
	}
}

const (
	// FargateProfileStatusCreating is a FargateProfileStatus enum value
	FargateProfileStatusCreating = "CREATING"

	// FargateProfileStatusActive is a FargateProfileStatus enum value
	FargateProfileStatusActive = "ACTIVE"

	// FargateProfileStatusDeleting is a FargateProfileStatus enum value
	FargateProfileStatusDeleting = "DELETING"

	// FargateProfileStatusCreateFailed is a FargateProfileStatus enum value
	FargateProfileStatusCreateFailed = "CREATE_FAILED"

	// FargateProfileStatusDeleteFailed is a FargateProfileStatus enum value
	FargateProfileStatusDeleteFailed = "DELETE_FAILED"
)

// FargateProfileStatus_Values returns all elements of the FargateProfileStatus enum
func FargateProfileStatus_Values() []string {
	return []string{
		FargateProfileStatusCreating,
		FargateProfileStatusActive,
		FargateProfileStatusDeleting,
		FargateProfileStatusCreateFailed,
		FargateProfileStatusDeleteFailed,
	}
}

const (
	// InsightStatusValuePassing is a InsightStatusValue enum value
	InsightStatusValuePassing = "PASSING"

	// InsightStatusValueWarning is a InsightStatusValue enum value
	InsightStatusValueWarning = "WARNING"

	// InsightStatusValueError is a InsightStatusValue enum value
	InsightStatusValueError = "ERROR"

	// InsightStatusValueUnknown is a InsightStatusValue enum value
	InsightStatusValueUnknown = "UNKNOWN"
)

// InsightStatusValue_Values returns all elements of the InsightStatusValue enum
func InsightStatusValue_Values() []string {
	return []string{
		InsightStatusValuePassing,
		InsightStatusValueWarning,
		InsightStatusValueError,
		InsightStatusValueUnknown,
	}
}

const (
	// IpFamilyIpv4 is a IpFamily enum value
	IpFamilyIpv4 = "ipv4"

	// IpFamilyIpv6 is a IpFamily enum value
	IpFamilyIpv6 = "ipv6"
)

// IpFamily_Values returns all elements of the IpFamily enum
func IpFamily_Values() []string {
	return []string{
		IpFamilyIpv4,
		IpFamilyIpv6,
	}
}

const (
	// LogTypeApi is a LogType enum value
	LogTypeApi = "api"

	// LogTypeAudit is a LogType enum value
	LogTypeAudit = "audit"

	// LogTypeAuthenticator is a LogType enum value
	LogTypeAuthenticator = "authenticator"

	// LogTypeControllerManager is a LogType enum value
	LogTypeControllerManager = "controllerManager"

	// LogTypeScheduler is a LogType enum value
	LogTypeScheduler = "scheduler"
)

// LogType_Values returns all elements of the LogType enum
func LogType_Values() []string {
	return []string{
		LogTypeApi,
		LogTypeAudit,
		LogTypeAuthenticator,
		LogTypeControllerManager,
		LogTypeScheduler,
	}
}

const (
	// NodegroupIssueCodeAutoScalingGroupNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupNotFound = "AutoScalingGroupNotFound"

	// NodegroupIssueCodeAutoScalingGroupInvalidConfiguration is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupInvalidConfiguration = "AutoScalingGroupInvalidConfiguration"

	// NodegroupIssueCodeEc2securityGroupNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2securityGroupNotFound = "Ec2SecurityGroupNotFound"

	// NodegroupIssueCodeEc2securityGroupDeletionFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2securityGroupDeletionFailure = "Ec2SecurityGroupDeletionFailure"

	// NodegroupIssueCodeEc2launchTemplateNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateNotFound = "Ec2LaunchTemplateNotFound"

	// NodegroupIssueCodeEc2launchTemplateVersionMismatch is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateVersionMismatch = "Ec2LaunchTemplateVersionMismatch"

	// NodegroupIssueCodeEc2subnetNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2subnetNotFound = "Ec2SubnetNotFound"

	// NodegroupIssueCodeEc2subnetInvalidConfiguration is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2subnetInvalidConfiguration = "Ec2SubnetInvalidConfiguration"

	// NodegroupIssueCodeIamInstanceProfileNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamInstanceProfileNotFound = "IamInstanceProfileNotFound"

	// NodegroupIssueCodeEc2subnetMissingIpv6assignment is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2subnetMissingIpv6assignment = "Ec2SubnetMissingIpv6Assignment"

	// NodegroupIssueCodeIamLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamLimitExceeded = "IamLimitExceeded"

	// NodegroupIssueCodeIamNodeRoleNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamNodeRoleNotFound = "IamNodeRoleNotFound"

	// NodegroupIssueCodeNodeCreationFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeNodeCreationFailure = "NodeCreationFailure"

	// NodegroupIssueCodeAsgInstanceLaunchFailures is a NodegroupIssueCode enum value
	NodegroupIssueCodeAsgInstanceLaunchFailures = "AsgInstanceLaunchFailures"

	// NodegroupIssueCodeInstanceLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeInstanceLimitExceeded = "InstanceLimitExceeded"

	// NodegroupIssueCodeInsufficientFreeAddresses is a NodegroupIssueCode enum value
	NodegroupIssueCodeInsufficientFreeAddresses = "InsufficientFreeAddresses"

	// NodegroupIssueCodeAccessDenied is a NodegroupIssueCode enum value
	NodegroupIssueCodeAccessDenied = "AccessDenied"

	// NodegroupIssueCodeInternalFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeInternalFailure = "InternalFailure"

	// NodegroupIssueCodeClusterUnreachable is a NodegroupIssueCode enum value
	NodegroupIssueCodeClusterUnreachable = "ClusterUnreachable"

	// NodegroupIssueCodeAmiIdNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeAmiIdNotFound = "AmiIdNotFound"

	// NodegroupIssueCodeAutoScalingGroupOptInRequired is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupOptInRequired = "AutoScalingGroupOptInRequired"

	// NodegroupIssueCodeAutoScalingGroupRateLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupRateLimitExceeded = "AutoScalingGroupRateLimitExceeded"

	// NodegroupIssueCodeEc2launchTemplateDeletionFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateDeletionFailure = "Ec2LaunchTemplateDeletionFailure"

	// NodegroupIssueCodeEc2launchTemplateInvalidConfiguration is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateInvalidConfiguration = "Ec2LaunchTemplateInvalidConfiguration"

	// NodegroupIssueCodeEc2launchTemplateMaxLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateMaxLimitExceeded = "Ec2LaunchTemplateMaxLimitExceeded"

	// NodegroupIssueCodeEc2subnetListTooLong is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2subnetListTooLong = "Ec2SubnetListTooLong"

	// NodegroupIssueCodeIamThrottling is a NodegroupIssueCode enum value
	NodegroupIssueCodeIamThrottling = "IamThrottling"

	// NodegroupIssueCodeNodeTerminationFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodeNodeTerminationFailure = "NodeTerminationFailure"

	// NodegroupIssueCodePodEvictionFailure is a NodegroupIssueCode enum value
	NodegroupIssueCodePodEvictionFailure = "PodEvictionFailure"

	// NodegroupIssueCodeSourceEc2launchTemplateNotFound is a NodegroupIssueCode enum value
	NodegroupIssueCodeSourceEc2launchTemplateNotFound = "SourceEc2LaunchTemplateNotFound"

	// NodegroupIssueCodeLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeLimitExceeded = "LimitExceeded"

	// NodegroupIssueCodeUnknown is a NodegroupIssueCode enum value
	NodegroupIssueCodeUnknown = "Unknown"

	// NodegroupIssueCodeAutoScalingGroupInstanceRefreshActive is a NodegroupIssueCode enum value
	NodegroupIssueCodeAutoScalingGroupInstanceRefreshActive = "AutoScalingGroupInstanceRefreshActive"

	// NodegroupIssueCodeKubernetesLabelInvalid is a NodegroupIssueCode enum value
	NodegroupIssueCodeKubernetesLabelInvalid = "KubernetesLabelInvalid"

	// NodegroupIssueCodeEc2launchTemplateVersionMaxLimitExceeded is a NodegroupIssueCode enum value
	NodegroupIssueCodeEc2launchTemplateVersionMaxLimitExceeded = "Ec2LaunchTemplateVersionMaxLimitExceeded"
)

// NodegroupIssueCode_Values returns all elements of the NodegroupIssueCode enum
func NodegroupIssueCode_Values() []string {
	return []string{
		NodegroupIssueCodeAutoScalingGroupNotFound,
		NodegroupIssueCodeAutoScalingGroupInvalidConfiguration,
		NodegroupIssueCodeEc2securityGroupNotFound,
		NodegroupIssueCodeEc2securityGroupDeletionFailure,
		NodegroupIssueCodeEc2launchTemplateNotFound,
		NodegroupIssueCodeEc2launchTemplateVersionMismatch,
		NodegroupIssueCodeEc2subnetNotFound,
		NodegroupIssueCodeEc2subnetInvalidConfiguration,
		NodegroupIssueCodeIamInstanceProfileNotFound,
		NodegroupIssueCodeEc2subnetMissingIpv6assignment,
		NodegroupIssueCodeIamLimitExceeded,
		NodegroupIssueCodeIamNodeRoleNotFound,
		NodegroupIssueCodeNodeCreationFailure,
		NodegroupIssueCodeAsgInstanceLaunchFailures,
		NodegroupIssueCodeInstanceLimitExceeded,
		NodegroupIssueCodeInsufficientFreeAddresses,
		NodegroupIssueCodeAccessDenied,
		NodegroupIssueCodeInternalFailure,
		NodegroupIssueCodeClusterUnreachable,
		NodegroupIssueCodeAmiIdNotFound,
		NodegroupIssueCodeAutoScalingGroupOptInRequired,
		NodegroupIssueCodeAutoScalingGroupRateLimitExceeded,
		NodegroupIssueCodeEc2launchTemplateDeletionFailure,
		NodegroupIssueCodeEc2launchTemplateInvalidConfiguration,
		NodegroupIssueCodeEc2launchTemplateMaxLimitExceeded,
		NodegroupIssueCodeEc2subnetListTooLong,
		NodegroupIssueCodeIamThrottling,
		NodegroupIssueCodeNodeTerminationFailure,
		NodegroupIssueCodePodEvictionFailure,
		NodegroupIssueCodeSourceEc2launchTemplateNotFound,
		NodegroupIssueCodeLimitExceeded,
		NodegroupIssueCodeUnknown,
		NodegroupIssueCodeAutoScalingGroupInstanceRefreshActive,
		NodegroupIssueCodeKubernetesLabelInvalid,
		NodegroupIssueCodeEc2launchTemplateVersionMaxLimitExceeded,
	}
}

const (
	// NodegroupStatusCreating is a NodegroupStatus enum value
	NodegroupStatusCreating = "CREATING"

	// NodegroupStatusActive is a NodegroupStatus enum value
	NodegroupStatusActive = "ACTIVE"

	// NodegroupStatusUpdating is a NodegroupStatus enum value
	NodegroupStatusUpdating = "UPDATING"

	// NodegroupStatusDeleting is a NodegroupStatus enum value
	NodegroupStatusDeleting = "DELETING"

	// NodegroupStatusCreateFailed is a NodegroupStatus enum value
	NodegroupStatusCreateFailed = "CREATE_FAILED"

	// NodegroupStatusDeleteFailed is a NodegroupStatus enum value
	NodegroupStatusDeleteFailed = "DELETE_FAILED"

	// NodegroupStatusDegraded is a NodegroupStatus enum value
	NodegroupStatusDegraded = "DEGRADED"
)

// NodegroupStatus_Values returns all elements of the NodegroupStatus enum
func NodegroupStatus_Values() []string {
	return []string{
		NodegroupStatusCreating,
		NodegroupStatusActive,
		NodegroupStatusUpdating,
		NodegroupStatusDeleting,
		NodegroupStatusCreateFailed,
		NodegroupStatusDeleteFailed,
		NodegroupStatusDegraded,
	}
}

const (
	// ResolveConflictsOverwrite is a ResolveConflicts enum value
	ResolveConflictsOverwrite = "OVERWRITE"

	// ResolveConflictsNone is a ResolveConflicts enum value
	ResolveConflictsNone = "NONE"

	// ResolveConflictsPreserve is a ResolveConflicts enum value
	ResolveConflictsPreserve = "PRESERVE"
)

// ResolveConflicts_Values returns all elements of the ResolveConflicts enum
func ResolveConflicts_Values() []string {
	return []string{
		ResolveConflictsOverwrite,
		ResolveConflictsNone,
		ResolveConflictsPreserve,
	}
}

const (
	// TaintEffectNoSchedule is a TaintEffect enum value
	TaintEffectNoSchedule = "NO_SCHEDULE"

	// TaintEffectNoExecute is a TaintEffect enum value
	TaintEffectNoExecute = "NO_EXECUTE"

	// TaintEffectPreferNoSchedule is a TaintEffect enum value
	TaintEffectPreferNoSchedule = "PREFER_NO_SCHEDULE"
)

// TaintEffect_Values returns all elements of the TaintEffect enum
func TaintEffect_Values() []string {
	return []string{
		TaintEffectNoSchedule,
		TaintEffectNoExecute,
		TaintEffectPreferNoSchedule,
	}
}

const (
	// UpdateParamTypeVersion is a UpdateParamType enum value
	UpdateParamTypeVersion = "Version"

	// UpdateParamTypePlatformVersion is a UpdateParamType enum value
	UpdateParamTypePlatformVersion = "PlatformVersion"

	// UpdateParamTypeEndpointPrivateAccess is a UpdateParamType enum value
	UpdateParamTypeEndpointPrivateAccess = "EndpointPrivateAccess"

	// UpdateParamTypeEndpointPublicAccess is a UpdateParamType enum value
	UpdateParamTypeEndpointPublicAccess = "EndpointPublicAccess"

	// UpdateParamTypeClusterLogging is a UpdateParamType enum value
	UpdateParamTypeClusterLogging = "ClusterLogging"

	// UpdateParamTypeDesiredSize is a UpdateParamType enum value
	UpdateParamTypeDesiredSize = "DesiredSize"

	// UpdateParamTypeLabelsToAdd is a UpdateParamType enum value
	UpdateParamTypeLabelsToAdd = "LabelsToAdd"

	// UpdateParamTypeLabelsToRemove is a UpdateParamType enum value
	UpdateParamTypeLabelsToRemove = "LabelsToRemove"

	// UpdateParamTypeTaintsToAdd is a UpdateParamType enum value
	UpdateParamTypeTaintsToAdd = "TaintsToAdd"

	// UpdateParamTypeTaintsToRemove is a UpdateParamType enum value
	UpdateParamTypeTaintsToRemove = "TaintsToRemove"

	// UpdateParamTypeMaxSize is a UpdateParamType enum value
	UpdateParamTypeMaxSize = "MaxSize"

	// UpdateParamTypeMinSize is a UpdateParamType enum value
	UpdateParamTypeMinSize = "MinSize"

	// UpdateParamTypeReleaseVersion is a UpdateParamType enum value
	UpdateParamTypeReleaseVersion = "ReleaseVersion"

	// UpdateParamTypePublicAccessCidrs is a UpdateParamType enum value
	UpdateParamTypePublicAccessCidrs = "PublicAccessCidrs"

	// UpdateParamTypeLaunchTemplateName is a UpdateParamType enum value
	UpdateParamTypeLaunchTemplateName = "LaunchTemplateName"

	// UpdateParamTypeLaunchTemplateVersion is a UpdateParamType enum value
	UpdateParamTypeLaunchTemplateVersion = "LaunchTemplateVersion"

	// UpdateParamTypeIdentityProviderConfig is a UpdateParamType enum value
	UpdateParamTypeIdentityProviderConfig = "IdentityProviderConfig"

	// UpdateParamTypeEncryptionConfig is a UpdateParamType enum value
	UpdateParamTypeEncryptionConfig = "EncryptionConfig"

	// UpdateParamTypeAddonVersion is a UpdateParamType enum value
	UpdateParamTypeAddonVersion = "AddonVersion"

	// UpdateParamTypeServiceAccountRoleArn is a UpdateParamType enum value
	UpdateParamTypeServiceAccountRoleArn = "ServiceAccountRoleArn"

	// UpdateParamTypeResolveConflicts is a UpdateParamType enum value
	UpdateParamTypeResolveConflicts = "ResolveConflicts"

	// UpdateParamTypeMaxUnavailable is a UpdateParamType enum value
	UpdateParamTypeMaxUnavailable = "MaxUnavailable"

	// UpdateParamTypeMaxUnavailablePercentage is a UpdateParamType enum value
	UpdateParamTypeMaxUnavailablePercentage = "MaxUnavailablePercentage"

	// UpdateParamTypeConfigurationValues is a UpdateParamType enum value
	UpdateParamTypeConfigurationValues = "ConfigurationValues"

	// UpdateParamTypeSecurityGroups is a UpdateParamType enum value
	UpdateParamTypeSecurityGroups = "SecurityGroups"

	// UpdateParamTypeSubnets is a UpdateParamType enum value
	UpdateParamTypeSubnets = "Subnets"

	// UpdateParamTypeAuthenticationMode is a UpdateParamType enum value
	UpdateParamTypeAuthenticationMode = "AuthenticationMode"

	// UpdateParamTypePodIdentityAssociations is a UpdateParamType enum value
	UpdateParamTypePodIdentityAssociations = "PodIdentityAssociations"
)

// UpdateParamType_Values returns all elements of the UpdateParamType enum
func UpdateParamType_Values() []string {
	return []string{
		UpdateParamTypeVersion,
		UpdateParamTypePlatformVersion,
		UpdateParamTypeEndpointPrivateAccess,
		UpdateParamTypeEndpointPublicAccess,
		UpdateParamTypeClusterLogging,
		UpdateParamTypeDesiredSize,
		UpdateParamTypeLabelsToAdd,
		UpdateParamTypeLabelsToRemove,
		UpdateParamTypeTaintsToAdd,
		UpdateParamTypeTaintsToRemove,
		UpdateParamTypeMaxSize,
		UpdateParamTypeMinSize,
		UpdateParamTypeReleaseVersion,
		UpdateParamTypePublicAccessCidrs,
		UpdateParamTypeLaunchTemplateName,
		UpdateParamTypeLaunchTemplateVersion,
		UpdateParamTypeIdentityProviderConfig,
		UpdateParamTypeEncryptionConfig,
		UpdateParamTypeAddonVersion,
		UpdateParamTypeServiceAccountRoleArn,
		UpdateParamTypeResolveConflicts,
		UpdateParamTypeMaxUnavailable,
		UpdateParamTypeMaxUnavailablePercentage,
		UpdateParamTypeConfigurationValues,
		UpdateParamTypeSecurityGroups,
		UpdateParamTypeSubnets,
		UpdateParamTypeAuthenticationMode,
		UpdateParamTypePodIdentityAssociations,
	}
}

const (
	// UpdateStatusInProgress is a UpdateStatus enum value
	UpdateStatusInProgress = "InProgress"

	// UpdateStatusFailed is a UpdateStatus enum value
	UpdateStatusFailed = "Failed"

	// UpdateStatusCancelled is a UpdateStatus enum value
	UpdateStatusCancelled = "Cancelled"

	// UpdateStatusSuccessful is a UpdateStatus enum value
	UpdateStatusSuccessful = "Successful"
)

// UpdateStatus_Values returns all elements of the UpdateStatus enum
func UpdateStatus_Values() []string {
	return []string{
		UpdateStatusInProgress,
		UpdateStatusFailed,
		UpdateStatusCancelled,
		UpdateStatusSuccessful,
	}
}

const (
	// UpdateTypeVersionUpdate is a UpdateType enum value
	UpdateTypeVersionUpdate = "VersionUpdate"

	// UpdateTypeEndpointAccessUpdate is a UpdateType enum value
	UpdateTypeEndpointAccessUpdate = "EndpointAccessUpdate"

	// UpdateTypeLoggingUpdate is a UpdateType enum value
	UpdateTypeLoggingUpdate = "LoggingUpdate"

	// UpdateTypeConfigUpdate is a UpdateType enum value
	UpdateTypeConfigUpdate = "ConfigUpdate"

	// UpdateTypeAssociateIdentityProviderConfig is a UpdateType enum value
	UpdateTypeAssociateIdentityProviderConfig = "AssociateIdentityProviderConfig"

	// UpdateTypeDisassociateIdentityProviderConfig is a UpdateType enum value
	UpdateTypeDisassociateIdentityProviderConfig = "DisassociateIdentityProviderConfig"

	// UpdateTypeAssociateEncryptionConfig is a UpdateType enum value
	UpdateTypeAssociateEncryptionConfig = "AssociateEncryptionConfig"

	// UpdateTypeAddonUpdate is a UpdateType enum value
	UpdateTypeAddonUpdate = "AddonUpdate"

	// UpdateTypeVpcConfigUpdate is a UpdateType enum value
	UpdateTypeVpcConfigUpdate = "VpcConfigUpdate"

	// UpdateTypeAccessConfigUpdate is a UpdateType enum value
	UpdateTypeAccessConfigUpdate = "AccessConfigUpdate"
)

// UpdateType_Values returns all elements of the UpdateType enum
func UpdateType_Values() []string {
	return []string{
		UpdateTypeVersionUpdate,
		UpdateTypeEndpointAccessUpdate,
		UpdateTypeLoggingUpdate,
		UpdateTypeConfigUpdate,
		UpdateTypeAssociateIdentityProviderConfig,
		UpdateTypeDisassociateIdentityProviderConfig,
		UpdateTypeAssociateEncryptionConfig,
		UpdateTypeAddonUpdate,
		UpdateTypeVpcConfigUpdate,
		UpdateTypeAccessConfigUpdate,
	}
}
