// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpmetrics "go.opentelemetry.io/proto/slim/otlp/metrics/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyMetric(t *testing.T) {
	for name, src := range genTestEncodingValuesMetric() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewMetric()
				CopyMetric(dest, src)
				assert.Equal(t, src, dest)
				CopyMetric(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyMetricSlice(t *testing.T) {
	src := []Metric{}
	dest := []Metric{}
	// Test CopyTo empty
	dest = CopyMetricSlice(dest, src)
	assert.Equal(t, []Metric{}, dest)

	// Test CopyTo larger slice
	src = GenTestMetricSlice()
	dest = CopyMetricSlice(dest, src)
	assert.Equal(t, GenTestMetricSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyMetricSlice(dest, src)
	assert.Equal(t, GenTestMetricSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyMetricSlice(dest, []Metric{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyMetricSlice(dest, src)
	assert.Equal(t, GenTestMetricSlice(), dest)
}

func TestCopyMetricPtrSlice(t *testing.T) {
	src := []*Metric{}
	dest := []*Metric{}
	// Test CopyTo empty
	dest = CopyMetricPtrSlice(dest, src)
	assert.Equal(t, []*Metric{}, dest)

	// Test CopyTo larger slice
	src = GenTestMetricPtrSlice()
	dest = CopyMetricPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyMetricPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyMetricPtrSlice(dest, []*Metric{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyMetricPtrSlice(dest, src)
	assert.Equal(t, GenTestMetricPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONMetricUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewMetric()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewMetric(), dest)
}

func TestMarshalAndUnmarshalJSONMetric(t *testing.T) {
	for name, src := range genTestEncodingValuesMetric() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewMetric()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteMetric(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoMetricFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesMetric() {
		t.Run(name, func(t *testing.T) {
			dest := NewMetric()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoMetricUnknown(t *testing.T) {
	dest := NewMetric()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewMetric(), dest)
}

func TestMarshalAndUnmarshalProtoMetric(t *testing.T) {
	for name, src := range genTestEncodingValuesMetric() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewMetric()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteMetric(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufMetric(t *testing.T) {
	for name, src := range genTestEncodingValuesMetric() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpmetrics.Metric{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewMetric()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesMetric() map[string][]byte {
	return map[string][]byte{
		"invalid_field":               {0x02},
		"Name/wrong_wire_type":        {0xc},
		"Name/missing_value":          {0xa},
		"Description/wrong_wire_type": {0x14},
		"Description/missing_value":   {0x12},
		"Unit/wrong_wire_type":        {0x1c},
		"Unit/missing_value":          {0x1a},

		"Gauge/wrong_wire_type": {0x2c},
		"Gauge/missing_value":   {0x2a},

		"Sum/wrong_wire_type": {0x3c},
		"Sum/missing_value":   {0x3a},

		"Histogram/wrong_wire_type": {0x4c},
		"Histogram/missing_value":   {0x4a},

		"ExponentialHistogram/wrong_wire_type": {0x54},
		"ExponentialHistogram/missing_value":   {0x52},

		"Summary/wrong_wire_type":  {0x5c},
		"Summary/missing_value":    {0x5a},
		"Metadata/wrong_wire_type": {0x64},
		"Metadata/missing_value":   {0x62},
	}
}

func genTestEncodingValuesMetric() map[string]*Metric {
	return map[string]*Metric{
		"empty":                        NewMetric(),
		"Name/test":                    {Name: "test_name"},
		"Description/test":             {Description: "test_description"},
		"Unit/test":                    {Unit: "test_unit"},
		"Gauge/default":                {Data: &Metric_Gauge{Gauge: &Gauge{}}},
		"Gauge/test":                   {Data: &Metric_Gauge{Gauge: GenTestGauge()}},
		"Sum/default":                  {Data: &Metric_Sum{Sum: &Sum{}}},
		"Sum/test":                     {Data: &Metric_Sum{Sum: GenTestSum()}},
		"Histogram/default":            {Data: &Metric_Histogram{Histogram: &Histogram{}}},
		"Histogram/test":               {Data: &Metric_Histogram{Histogram: GenTestHistogram()}},
		"ExponentialHistogram/default": {Data: &Metric_ExponentialHistogram{ExponentialHistogram: &ExponentialHistogram{}}},
		"ExponentialHistogram/test":    {Data: &Metric_ExponentialHistogram{ExponentialHistogram: GenTestExponentialHistogram()}},
		"Summary/default":              {Data: &Metric_Summary{Summary: &Summary{}}},
		"Summary/test":                 {Data: &Metric_Summary{Summary: GenTestSummary()}},
		"Metadata/test":                {Metadata: []KeyValue{{}, *GenTestKeyValue()}},
	}
}
