// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyUDPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesUDPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewUDPAddr()
				CopyUDPAddr(dest, src)
				assert.Equal(t, src, dest)
				CopyUDPAddr(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyUDPAddrSlice(t *testing.T) {
	src := []UDPAddr{}
	dest := []UDPAddr{}
	// Test CopyTo empty
	dest = CopyUDPAddrSlice(dest, src)
	assert.Equal(t, []UDPAddr{}, dest)

	// Test CopyTo larger slice
	src = GenTestUDPAddrSlice()
	dest = CopyUDPAddrSlice(dest, src)
	assert.Equal(t, GenTestUDPAddrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyUDPAddrSlice(dest, src)
	assert.Equal(t, GenTestUDPAddrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyUDPAddrSlice(dest, []UDPAddr{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyUDPAddrSlice(dest, src)
	assert.Equal(t, GenTestUDPAddrSlice(), dest)
}

func TestCopyUDPAddrPtrSlice(t *testing.T) {
	src := []*UDPAddr{}
	dest := []*UDPAddr{}
	// Test CopyTo empty
	dest = CopyUDPAddrPtrSlice(dest, src)
	assert.Equal(t, []*UDPAddr{}, dest)

	// Test CopyTo larger slice
	src = GenTestUDPAddrPtrSlice()
	dest = CopyUDPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestUDPAddrPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyUDPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestUDPAddrPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyUDPAddrPtrSlice(dest, []*UDPAddr{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyUDPAddrPtrSlice(dest, src)
	assert.Equal(t, GenTestUDPAddrPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONUDPAddrUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewUDPAddr()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewUDPAddr(), dest)
}

func TestMarshalAndUnmarshalJSONUDPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesUDPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewUDPAddr()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteUDPAddr(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoUDPAddrFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesUDPAddr() {
		t.Run(name, func(t *testing.T) {
			dest := NewUDPAddr()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoUDPAddrUnknown(t *testing.T) {
	dest := NewUDPAddr()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewUDPAddr(), dest)
}

func TestMarshalAndUnmarshalProtoUDPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesUDPAddr() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewUDPAddr()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteUDPAddr(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufUDPAddr(t *testing.T) {
	for name, src := range genTestEncodingValuesUDPAddr() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewUDPAddr()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesUDPAddr() map[string][]byte {
	return map[string][]byte{
		"invalid_field":        {0x02},
		"IP/wrong_wire_type":   {0xc},
		"IP/missing_value":     {0xa},
		"Port/wrong_wire_type": {0x14},
		"Port/missing_value":   {0x10},
		"Zone/wrong_wire_type": {0x1c},
		"Zone/missing_value":   {0x1a},
	}
}

func genTestEncodingValuesUDPAddr() map[string]*UDPAddr {
	return map[string]*UDPAddr{
		"empty":     NewUDPAddr(),
		"IP/test":   {IP: []byte{1, 2, 3}},
		"Port/test": {Port: int64(13)},
		"Zone/test": {Zone: "test_zone"},
	}
}
