// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/documentai/v1beta3/dataset.proto

package documentaipb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Different states of a dataset.
type Dataset_State int32

const (
	// Default unspecified enum, should not be used.
	Dataset_STATE_UNSPECIFIED Dataset_State = 0
	// Dataset has not been initialized.
	Dataset_UNINITIALIZED Dataset_State = 1
	// Dataset is being initialized.
	Dataset_INITIALIZING Dataset_State = 2
	// Dataset has been initialized.
	Dataset_INITIALIZED Dataset_State = 3
)

// Enum value maps for Dataset_State.
var (
	Dataset_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "UNINITIALIZED",
		2: "INITIALIZING",
		3: "INITIALIZED",
	}
	Dataset_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"UNINITIALIZED":     1,
		"INITIALIZING":      2,
		"INITIALIZED":       3,
	}
)

func (x Dataset_State) Enum() *Dataset_State {
	p := new(Dataset_State)
	*p = x
	return p
}

func (x Dataset_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Dataset_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_documentai_v1beta3_dataset_proto_enumTypes[0].Descriptor()
}

func (Dataset_State) Type() protoreflect.EnumType {
	return &file_google_cloud_documentai_v1beta3_dataset_proto_enumTypes[0]
}

func (x Dataset_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Dataset_State.Descriptor instead.
func (Dataset_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{0, 0}
}

// A singleton resource under a
// [Processor][google.cloud.documentai.v1beta3.Processor] which configures a
// collection of documents.
type Dataset struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to StorageSource:
	//
	//	*Dataset_GcsManagedConfig
	//	*Dataset_DocumentWarehouseConfig_
	//	*Dataset_UnmanagedDatasetConfig_
	StorageSource isDataset_StorageSource `protobuf_oneof:"storage_source"`
	// Types that are assignable to IndexingSource:
	//
	//	*Dataset_SpannerIndexingConfig_
	IndexingSource isDataset_IndexingSource `protobuf_oneof:"indexing_source"`
	// Dataset resource name.
	// Format:
	// `projects/{project}/locations/{location}/processors/{processor}/dataset`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. State of the dataset. Ignored when updating dataset.
	State Dataset_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.documentai.v1beta3.Dataset_State" json:"state,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,8,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,9,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
}

func (x *Dataset) Reset() {
	*x = Dataset{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dataset) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dataset) ProtoMessage() {}

func (x *Dataset) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dataset.ProtoReflect.Descriptor instead.
func (*Dataset) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{0}
}

func (m *Dataset) GetStorageSource() isDataset_StorageSource {
	if m != nil {
		return m.StorageSource
	}
	return nil
}

func (x *Dataset) GetGcsManagedConfig() *Dataset_GCSManagedConfig {
	if x, ok := x.GetStorageSource().(*Dataset_GcsManagedConfig); ok {
		return x.GcsManagedConfig
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1beta3/dataset.proto.
func (x *Dataset) GetDocumentWarehouseConfig() *Dataset_DocumentWarehouseConfig {
	if x, ok := x.GetStorageSource().(*Dataset_DocumentWarehouseConfig_); ok {
		return x.DocumentWarehouseConfig
	}
	return nil
}

func (x *Dataset) GetUnmanagedDatasetConfig() *Dataset_UnmanagedDatasetConfig {
	if x, ok := x.GetStorageSource().(*Dataset_UnmanagedDatasetConfig_); ok {
		return x.UnmanagedDatasetConfig
	}
	return nil
}

func (m *Dataset) GetIndexingSource() isDataset_IndexingSource {
	if m != nil {
		return m.IndexingSource
	}
	return nil
}

func (x *Dataset) GetSpannerIndexingConfig() *Dataset_SpannerIndexingConfig {
	if x, ok := x.GetIndexingSource().(*Dataset_SpannerIndexingConfig_); ok {
		return x.SpannerIndexingConfig
	}
	return nil
}

func (x *Dataset) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Dataset) GetState() Dataset_State {
	if x != nil {
		return x.State
	}
	return Dataset_STATE_UNSPECIFIED
}

func (x *Dataset) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *Dataset) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

type isDataset_StorageSource interface {
	isDataset_StorageSource()
}

type Dataset_GcsManagedConfig struct {
	// Optional. User-managed Cloud Storage dataset configuration. Use this
	// configuration if the dataset documents are stored under a user-managed
	// Cloud Storage location.
	GcsManagedConfig *Dataset_GCSManagedConfig `protobuf:"bytes,3,opt,name=gcs_managed_config,json=gcsManagedConfig,proto3,oneof"`
}

type Dataset_DocumentWarehouseConfig_ struct {
	// Optional. Deprecated. Warehouse-based dataset configuration is not
	// supported.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1beta3/dataset.proto.
	DocumentWarehouseConfig *Dataset_DocumentWarehouseConfig `protobuf:"bytes,5,opt,name=document_warehouse_config,json=documentWarehouseConfig,proto3,oneof"`
}

type Dataset_UnmanagedDatasetConfig_ struct {
	// Optional. Unmanaged dataset configuration. Use this configuration if the
	// dataset documents are managed by the document service internally (not
	// user-managed).
	UnmanagedDatasetConfig *Dataset_UnmanagedDatasetConfig `protobuf:"bytes,6,opt,name=unmanaged_dataset_config,json=unmanagedDatasetConfig,proto3,oneof"`
}

func (*Dataset_GcsManagedConfig) isDataset_StorageSource() {}

func (*Dataset_DocumentWarehouseConfig_) isDataset_StorageSource() {}

func (*Dataset_UnmanagedDatasetConfig_) isDataset_StorageSource() {}

type isDataset_IndexingSource interface {
	isDataset_IndexingSource()
}

type Dataset_SpannerIndexingConfig_ struct {
	// Optional. A lightweight indexing source with low latency and high
	// reliability, but lacking advanced features like CMEK and content-based
	// search.
	SpannerIndexingConfig *Dataset_SpannerIndexingConfig `protobuf:"bytes,4,opt,name=spanner_indexing_config,json=spannerIndexingConfig,proto3,oneof"`
}

func (*Dataset_SpannerIndexingConfig_) isDataset_IndexingSource() {}

// Document Identifier.
type DocumentId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Type:
	//
	//	*DocumentId_GcsManagedDocId
	//	*DocumentId_UnmanagedDocId
	Type isDocumentId_Type `protobuf_oneof:"type"`
	// Points to a specific revision of the document if set.
	RevisionRef *RevisionRef `protobuf:"bytes,3,opt,name=revision_ref,json=revisionRef,proto3" json:"revision_ref,omitempty"`
}

func (x *DocumentId) Reset() {
	*x = DocumentId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentId) ProtoMessage() {}

func (x *DocumentId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentId.ProtoReflect.Descriptor instead.
func (*DocumentId) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{1}
}

func (m *DocumentId) GetType() isDocumentId_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (x *DocumentId) GetGcsManagedDocId() *DocumentId_GCSManagedDocumentId {
	if x, ok := x.GetType().(*DocumentId_GcsManagedDocId); ok {
		return x.GcsManagedDocId
	}
	return nil
}

func (x *DocumentId) GetUnmanagedDocId() *DocumentId_UnmanagedDocumentId {
	if x, ok := x.GetType().(*DocumentId_UnmanagedDocId); ok {
		return x.UnmanagedDocId
	}
	return nil
}

func (x *DocumentId) GetRevisionRef() *RevisionRef {
	if x != nil {
		return x.RevisionRef
	}
	return nil
}

type isDocumentId_Type interface {
	isDocumentId_Type()
}

type DocumentId_GcsManagedDocId struct {
	// A document id within user-managed Cloud Storage.
	GcsManagedDocId *DocumentId_GCSManagedDocumentId `protobuf:"bytes,1,opt,name=gcs_managed_doc_id,json=gcsManagedDocId,proto3,oneof"`
}

type DocumentId_UnmanagedDocId struct {
	// A document id within unmanaged dataset.
	UnmanagedDocId *DocumentId_UnmanagedDocumentId `protobuf:"bytes,4,opt,name=unmanaged_doc_id,json=unmanagedDocId,proto3,oneof"`
}

func (*DocumentId_GcsManagedDocId) isDocumentId_Type() {}

func (*DocumentId_UnmanagedDocId) isDocumentId_Type() {}

// Dataset Schema.
type DatasetSchema struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Dataset schema resource name.
	// Format:
	// `projects/{project}/locations/{location}/processors/{processor}/dataset/datasetSchema`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. Schema of the dataset.
	DocumentSchema *DocumentSchema `protobuf:"bytes,3,opt,name=document_schema,json=documentSchema,proto3" json:"document_schema,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,4,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,5,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
}

func (x *DatasetSchema) Reset() {
	*x = DatasetSchema{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DatasetSchema) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatasetSchema) ProtoMessage() {}

func (x *DatasetSchema) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatasetSchema.ProtoReflect.Descriptor instead.
func (*DatasetSchema) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{2}
}

func (x *DatasetSchema) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatasetSchema) GetDocumentSchema() *DocumentSchema {
	if x != nil {
		return x.DocumentSchema
	}
	return nil
}

func (x *DatasetSchema) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *DatasetSchema) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

// Dataset documents that the batch operation will be applied to.
type BatchDatasetDocuments struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Criteria:
	//
	//	*BatchDatasetDocuments_IndividualDocumentIds_
	//	*BatchDatasetDocuments_Filter
	Criteria isBatchDatasetDocuments_Criteria `protobuf_oneof:"criteria"`
}

func (x *BatchDatasetDocuments) Reset() {
	*x = BatchDatasetDocuments{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDatasetDocuments) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDatasetDocuments) ProtoMessage() {}

func (x *BatchDatasetDocuments) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDatasetDocuments.ProtoReflect.Descriptor instead.
func (*BatchDatasetDocuments) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{3}
}

func (m *BatchDatasetDocuments) GetCriteria() isBatchDatasetDocuments_Criteria {
	if m != nil {
		return m.Criteria
	}
	return nil
}

func (x *BatchDatasetDocuments) GetIndividualDocumentIds() *BatchDatasetDocuments_IndividualDocumentIds {
	if x, ok := x.GetCriteria().(*BatchDatasetDocuments_IndividualDocumentIds_); ok {
		return x.IndividualDocumentIds
	}
	return nil
}

func (x *BatchDatasetDocuments) GetFilter() string {
	if x, ok := x.GetCriteria().(*BatchDatasetDocuments_Filter); ok {
		return x.Filter
	}
	return ""
}

type isBatchDatasetDocuments_Criteria interface {
	isBatchDatasetDocuments_Criteria()
}

type BatchDatasetDocuments_IndividualDocumentIds_ struct {
	// Document identifiers.
	IndividualDocumentIds *BatchDatasetDocuments_IndividualDocumentIds `protobuf:"bytes,1,opt,name=individual_document_ids,json=individualDocumentIds,proto3,oneof"`
}

type BatchDatasetDocuments_Filter struct {
	// A filter matching the documents.
	// Follows the same format and restriction as
	// [google.cloud.documentai.master.ListDocumentsRequest.filter].
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3,oneof"`
}

func (*BatchDatasetDocuments_IndividualDocumentIds_) isBatchDatasetDocuments_Criteria() {}

func (*BatchDatasetDocuments_Filter) isBatchDatasetDocuments_Criteria() {}

// Configuration specific to the Cloud Storage-based implementation.
type Dataset_GCSManagedConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cloud Storage URI (a directory) where the documents
	// belonging to the dataset must be stored.
	GcsPrefix *GcsPrefix `protobuf:"bytes,1,opt,name=gcs_prefix,json=gcsPrefix,proto3" json:"gcs_prefix,omitempty"`
}

func (x *Dataset_GCSManagedConfig) Reset() {
	*x = Dataset_GCSManagedConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dataset_GCSManagedConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dataset_GCSManagedConfig) ProtoMessage() {}

func (x *Dataset_GCSManagedConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dataset_GCSManagedConfig.ProtoReflect.Descriptor instead.
func (*Dataset_GCSManagedConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Dataset_GCSManagedConfig) GetGcsPrefix() *GcsPrefix {
	if x != nil {
		return x.GcsPrefix
	}
	return nil
}

// Configuration specific to the Document AI Warehouse-based implementation.
type Dataset_DocumentWarehouseConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The collection in Document AI Warehouse associated with the
	// dataset.
	Collection string `protobuf:"bytes,1,opt,name=collection,proto3" json:"collection,omitempty"`
	// Output only. The schema in Document AI Warehouse associated with the
	// dataset.
	Schema string `protobuf:"bytes,2,opt,name=schema,proto3" json:"schema,omitempty"`
}

func (x *Dataset_DocumentWarehouseConfig) Reset() {
	*x = Dataset_DocumentWarehouseConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dataset_DocumentWarehouseConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dataset_DocumentWarehouseConfig) ProtoMessage() {}

func (x *Dataset_DocumentWarehouseConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dataset_DocumentWarehouseConfig.ProtoReflect.Descriptor instead.
func (*Dataset_DocumentWarehouseConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Dataset_DocumentWarehouseConfig) GetCollection() string {
	if x != nil {
		return x.Collection
	}
	return ""
}

func (x *Dataset_DocumentWarehouseConfig) GetSchema() string {
	if x != nil {
		return x.Schema
	}
	return ""
}

// Configuration specific to an unmanaged dataset.
type Dataset_UnmanagedDatasetConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Dataset_UnmanagedDatasetConfig) Reset() {
	*x = Dataset_UnmanagedDatasetConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dataset_UnmanagedDatasetConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dataset_UnmanagedDatasetConfig) ProtoMessage() {}

func (x *Dataset_UnmanagedDatasetConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dataset_UnmanagedDatasetConfig.ProtoReflect.Descriptor instead.
func (*Dataset_UnmanagedDatasetConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{0, 2}
}

// Configuration specific to spanner-based indexing.
type Dataset_SpannerIndexingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Dataset_SpannerIndexingConfig) Reset() {
	*x = Dataset_SpannerIndexingConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Dataset_SpannerIndexingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Dataset_SpannerIndexingConfig) ProtoMessage() {}

func (x *Dataset_SpannerIndexingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Dataset_SpannerIndexingConfig.ProtoReflect.Descriptor instead.
func (*Dataset_SpannerIndexingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{0, 3}
}

// Identifies a document uniquely within the scope of a dataset in the
// user-managed Cloud Storage option.
type DocumentId_GCSManagedDocumentId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cloud Storage URI where the actual document is stored.
	GcsUri string `protobuf:"bytes,1,opt,name=gcs_uri,json=gcsUri,proto3" json:"gcs_uri,omitempty"`
	// Id of the document (indexed) managed by Content Warehouse.
	//
	// Deprecated: Marked as deprecated in google/cloud/documentai/v1beta3/dataset.proto.
	CwDocId string `protobuf:"bytes,2,opt,name=cw_doc_id,json=cwDocId,proto3" json:"cw_doc_id,omitempty"`
}

func (x *DocumentId_GCSManagedDocumentId) Reset() {
	*x = DocumentId_GCSManagedDocumentId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentId_GCSManagedDocumentId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentId_GCSManagedDocumentId) ProtoMessage() {}

func (x *DocumentId_GCSManagedDocumentId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentId_GCSManagedDocumentId.ProtoReflect.Descriptor instead.
func (*DocumentId_GCSManagedDocumentId) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{1, 0}
}

func (x *DocumentId_GCSManagedDocumentId) GetGcsUri() string {
	if x != nil {
		return x.GcsUri
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/documentai/v1beta3/dataset.proto.
func (x *DocumentId_GCSManagedDocumentId) GetCwDocId() string {
	if x != nil {
		return x.CwDocId
	}
	return ""
}

// Identifies a document uniquely within the scope of a dataset in unmanaged
// option.
type DocumentId_UnmanagedDocumentId struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The id of the document.
	DocId string `protobuf:"bytes,1,opt,name=doc_id,json=docId,proto3" json:"doc_id,omitempty"`
}

func (x *DocumentId_UnmanagedDocumentId) Reset() {
	*x = DocumentId_UnmanagedDocumentId{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DocumentId_UnmanagedDocumentId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DocumentId_UnmanagedDocumentId) ProtoMessage() {}

func (x *DocumentId_UnmanagedDocumentId) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DocumentId_UnmanagedDocumentId.ProtoReflect.Descriptor instead.
func (*DocumentId_UnmanagedDocumentId) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{1, 1}
}

func (x *DocumentId_UnmanagedDocumentId) GetDocId() string {
	if x != nil {
		return x.DocId
	}
	return ""
}

// List of individual DocumentIds.
type BatchDatasetDocuments_IndividualDocumentIds struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. List of Document IDs indicating where the actual documents are
	// stored.
	DocumentIds []*DocumentId `protobuf:"bytes,1,rep,name=document_ids,json=documentIds,proto3" json:"document_ids,omitempty"`
}

func (x *BatchDatasetDocuments_IndividualDocumentIds) Reset() {
	*x = BatchDatasetDocuments_IndividualDocumentIds{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *BatchDatasetDocuments_IndividualDocumentIds) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BatchDatasetDocuments_IndividualDocumentIds) ProtoMessage() {}

func (x *BatchDatasetDocuments_IndividualDocumentIds) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BatchDatasetDocuments_IndividualDocumentIds.ProtoReflect.Descriptor instead.
func (*BatchDatasetDocuments_IndividualDocumentIds) Descriptor() ([]byte, []int) {
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP(), []int{3, 0}
}

func (x *BatchDatasetDocuments_IndividualDocumentIds) GetDocumentIds() []*DocumentId {
	if x != nil {
		return x.DocumentIds
	}
	return nil
}

var File_google_cloud_documentai_v1beta3_dataset_proto protoreflect.FileDescriptor

var file_google_cloud_documentai_v1beta3_dataset_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc1, 0x09, 0x0a, 0x07, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x12, 0x6e, 0x0a, 0x12, 0x67, 0x63, 0x73, 0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x47, 0x43, 0x53, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x10, 0x67, 0x63, 0x73, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x19, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x48,
	0x00, 0x52, 0x17, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x57, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x80, 0x01, 0x0a, 0x18, 0x75,
	0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x16, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7d, 0x0a,
	0x17, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72,
	0x49, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x15, 0x73, 0x70, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x49, 0x6e,
	0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x33, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73,
	0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69,
	0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69,
	0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x1a,
	0x62, 0x0a, 0x10, 0x47, 0x43, 0x53, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x4e, 0x0a, 0x0a, 0x67, 0x63, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69,
	0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x47, 0x63, 0x73, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x67, 0x63, 0x73, 0x50, 0x72, 0x65,
	0x66, 0x69, 0x78, 0x1a, 0x86, 0x01, 0x0a, 0x17, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x57, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x23, 0x0a, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x1a, 0x18, 0x0a, 0x16,
	0x55, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x17, 0x0a, 0x15, 0x53, 0x70, 0x61, 0x6e, 0x6e, 0x65,
	0x72, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x10, 0x0a, 0x0c, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49, 0x5a, 0x49,
	0x4e, 0x47, 0x10, 0x02, 0x12, 0x0f, 0x0a, 0x0b, 0x49, 0x4e, 0x49, 0x54, 0x49, 0x41, 0x4c, 0x49,
	0x5a, 0x45, 0x44, 0x10, 0x03, 0x3a, 0x6e, 0xea, 0x41, 0x6b, 0x0a, 0x21, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12, 0x46, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x7d, 0x2f, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x10, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x69, 0x6e, 0x64, 0x65, 0x78,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xcc, 0x03, 0x0a, 0x0a, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x6f, 0x0a, 0x12, 0x67, 0x63, 0x73,
	0x5f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x49, 0x64, 0x2e, 0x47, 0x43, 0x53, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x67, 0x63, 0x73, 0x4d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x49, 0x64, 0x12, 0x6b, 0x0a, 0x10, 0x75, 0x6e,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x5f, 0x64, 0x6f, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x2e, 0x55, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x49, 0x64, 0x48, 0x00, 0x52, 0x0e, 0x75, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x64, 0x44, 0x6f, 0x63, 0x49, 0x64, 0x12, 0x4f, 0x0a, 0x0c, 0x72, 0x65, 0x76, 0x69, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x66, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e,
	0x52, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x52, 0x0b, 0x72, 0x65, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x66, 0x1a, 0x54, 0x0a, 0x14, 0x47, 0x43, 0x53, 0x4d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x1c, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x67, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x1e,
	0x0a, 0x09, 0x63, 0x77, 0x5f, 0x64, 0x6f, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x07, 0x63, 0x77, 0x44, 0x6f, 0x63, 0x49, 0x64, 0x1a, 0x31,
	0x0a, 0x13, 0x55, 0x6e, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x06, 0x64, 0x6f, 0x63, 0x5f, 0x69, 0x64, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x64, 0x6f, 0x63, 0x49,
	0x64, 0x42, 0x06, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x22, 0xdb, 0x02, 0x0a, 0x0d, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x5d, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x28,
	0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50,
	0x7a, 0x69, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x27, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x61, 0x69, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x54, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65,
	0x73, 0x73, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72,
	0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0xb4, 0x02, 0x0a, 0x15, 0x42, 0x61, 0x74, 0x63,
	0x68, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x86, 0x01, 0x0a, 0x17, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c,
	0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2e, 0x49, 0x6e, 0x64, 0x69,
	0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x73, 0x48, 0x00, 0x52, 0x15, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x18, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x1a, 0x6c, 0x0a, 0x15, 0x49, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75,
	0x61, 0x6c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x73, 0x12, 0x53, 0x0a,
	0x0c, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x33, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x64, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61, 0x42, 0xc8,
	0x02, 0xea, 0x41, 0x62, 0x0a, 0x26, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x38, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x7b, 0x73,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x7d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x61, 0x69, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x42, 0x0c, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61,
	0x69, 0x70, 0x62, 0x3b, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x69, 0x70, 0x62,
	0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74,
	0x61, 0x33, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x33, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x49,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_documentai_v1beta3_dataset_proto_rawDescOnce sync.Once
	file_google_cloud_documentai_v1beta3_dataset_proto_rawDescData = file_google_cloud_documentai_v1beta3_dataset_proto_rawDesc
)

func file_google_cloud_documentai_v1beta3_dataset_proto_rawDescGZIP() []byte {
	file_google_cloud_documentai_v1beta3_dataset_proto_rawDescOnce.Do(func() {
		file_google_cloud_documentai_v1beta3_dataset_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_documentai_v1beta3_dataset_proto_rawDescData)
	})
	return file_google_cloud_documentai_v1beta3_dataset_proto_rawDescData
}

var file_google_cloud_documentai_v1beta3_dataset_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_documentai_v1beta3_dataset_proto_goTypes = []any{
	(Dataset_State)(0),                                  // 0: google.cloud.documentai.v1beta3.Dataset.State
	(*Dataset)(nil),                                     // 1: google.cloud.documentai.v1beta3.Dataset
	(*DocumentId)(nil),                                  // 2: google.cloud.documentai.v1beta3.DocumentId
	(*DatasetSchema)(nil),                               // 3: google.cloud.documentai.v1beta3.DatasetSchema
	(*BatchDatasetDocuments)(nil),                       // 4: google.cloud.documentai.v1beta3.BatchDatasetDocuments
	(*Dataset_GCSManagedConfig)(nil),                    // 5: google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig
	(*Dataset_DocumentWarehouseConfig)(nil),             // 6: google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
	(*Dataset_UnmanagedDatasetConfig)(nil),              // 7: google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
	(*Dataset_SpannerIndexingConfig)(nil),               // 8: google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
	(*DocumentId_GCSManagedDocumentId)(nil),             // 9: google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
	(*DocumentId_UnmanagedDocumentId)(nil),              // 10: google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
	(*BatchDatasetDocuments_IndividualDocumentIds)(nil), // 11: google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
	(*RevisionRef)(nil),                                 // 12: google.cloud.documentai.v1beta3.RevisionRef
	(*DocumentSchema)(nil),                              // 13: google.cloud.documentai.v1beta3.DocumentSchema
	(*GcsPrefix)(nil),                                   // 14: google.cloud.documentai.v1beta3.GcsPrefix
}
var file_google_cloud_documentai_v1beta3_dataset_proto_depIdxs = []int32{
	5,  // 0: google.cloud.documentai.v1beta3.Dataset.gcs_managed_config:type_name -> google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig
	6,  // 1: google.cloud.documentai.v1beta3.Dataset.document_warehouse_config:type_name -> google.cloud.documentai.v1beta3.Dataset.DocumentWarehouseConfig
	7,  // 2: google.cloud.documentai.v1beta3.Dataset.unmanaged_dataset_config:type_name -> google.cloud.documentai.v1beta3.Dataset.UnmanagedDatasetConfig
	8,  // 3: google.cloud.documentai.v1beta3.Dataset.spanner_indexing_config:type_name -> google.cloud.documentai.v1beta3.Dataset.SpannerIndexingConfig
	0,  // 4: google.cloud.documentai.v1beta3.Dataset.state:type_name -> google.cloud.documentai.v1beta3.Dataset.State
	9,  // 5: google.cloud.documentai.v1beta3.DocumentId.gcs_managed_doc_id:type_name -> google.cloud.documentai.v1beta3.DocumentId.GCSManagedDocumentId
	10, // 6: google.cloud.documentai.v1beta3.DocumentId.unmanaged_doc_id:type_name -> google.cloud.documentai.v1beta3.DocumentId.UnmanagedDocumentId
	12, // 7: google.cloud.documentai.v1beta3.DocumentId.revision_ref:type_name -> google.cloud.documentai.v1beta3.RevisionRef
	13, // 8: google.cloud.documentai.v1beta3.DatasetSchema.document_schema:type_name -> google.cloud.documentai.v1beta3.DocumentSchema
	11, // 9: google.cloud.documentai.v1beta3.BatchDatasetDocuments.individual_document_ids:type_name -> google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds
	14, // 10: google.cloud.documentai.v1beta3.Dataset.GCSManagedConfig.gcs_prefix:type_name -> google.cloud.documentai.v1beta3.GcsPrefix
	2,  // 11: google.cloud.documentai.v1beta3.BatchDatasetDocuments.IndividualDocumentIds.document_ids:type_name -> google.cloud.documentai.v1beta3.DocumentId
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_documentai_v1beta3_dataset_proto_init() }
func file_google_cloud_documentai_v1beta3_dataset_proto_init() {
	if File_google_cloud_documentai_v1beta3_dataset_proto != nil {
		return
	}
	file_google_cloud_documentai_v1beta3_document_proto_init()
	file_google_cloud_documentai_v1beta3_document_io_proto_init()
	file_google_cloud_documentai_v1beta3_document_schema_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*Dataset); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*DocumentId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*DatasetSchema); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*BatchDatasetDocuments); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*Dataset_GCSManagedConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*Dataset_DocumentWarehouseConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*Dataset_UnmanagedDatasetConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*Dataset_SpannerIndexingConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*DocumentId_GCSManagedDocumentId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*DocumentId_UnmanagedDocumentId); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*BatchDatasetDocuments_IndividualDocumentIds); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[0].OneofWrappers = []any{
		(*Dataset_GcsManagedConfig)(nil),
		(*Dataset_DocumentWarehouseConfig_)(nil),
		(*Dataset_UnmanagedDatasetConfig_)(nil),
		(*Dataset_SpannerIndexingConfig_)(nil),
	}
	file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[1].OneofWrappers = []any{
		(*DocumentId_GcsManagedDocId)(nil),
		(*DocumentId_UnmanagedDocId)(nil),
	}
	file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes[3].OneofWrappers = []any{
		(*BatchDatasetDocuments_IndividualDocumentIds_)(nil),
		(*BatchDatasetDocuments_Filter)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_documentai_v1beta3_dataset_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_documentai_v1beta3_dataset_proto_goTypes,
		DependencyIndexes: file_google_cloud_documentai_v1beta3_dataset_proto_depIdxs,
		EnumInfos:         file_google_cloud_documentai_v1beta3_dataset_proto_enumTypes,
		MessageInfos:      file_google_cloud_documentai_v1beta3_dataset_proto_msgTypes,
	}.Build()
	File_google_cloud_documentai_v1beta3_dataset_proto = out.File
	file_google_cloud_documentai_v1beta3_dataset_proto_rawDesc = nil
	file_google_cloud_documentai_v1beta3_dataset_proto_goTypes = nil
	file_google_cloud_documentai_v1beta3_dataset_proto_depIdxs = nil
}
