// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
	"net/http"
	"net/url"
	"regexp"
)

// AccountsServer is a fake server for instances of the armstorage.AccountsClient type.
type AccountsServer struct {
	// BeginAbortHierarchicalNamespaceMigration is the fake for method AccountsClient.BeginAbortHierarchicalNamespaceMigration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginAbortHierarchicalNamespaceMigration func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.AccountsClientBeginAbortHierarchicalNamespaceMigrationOptions) (resp azfake.PollerResponder[armstorage.AccountsClientAbortHierarchicalNamespaceMigrationResponse], errResp azfake.ErrorResponder)

	// CheckNameAvailability is the fake for method AccountsClient.CheckNameAvailability
	// HTTP status codes to indicate success: http.StatusOK
	CheckNameAvailability func(ctx context.Context, accountName armstorage.AccountCheckNameAvailabilityParameters, options *armstorage.AccountsClientCheckNameAvailabilityOptions) (resp azfake.Responder[armstorage.AccountsClientCheckNameAvailabilityResponse], errResp azfake.ErrorResponder)

	// BeginCreate is the fake for method AccountsClient.BeginCreate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginCreate func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.AccountCreateParameters, options *armstorage.AccountsClientBeginCreateOptions) (resp azfake.PollerResponder[armstorage.AccountsClientCreateResponse], errResp azfake.ErrorResponder)

	// BeginCustomerInitiatedMigration is the fake for method AccountsClient.BeginCustomerInitiatedMigration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginCustomerInitiatedMigration func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.AccountMigration, options *armstorage.AccountsClientBeginCustomerInitiatedMigrationOptions) (resp azfake.PollerResponder[armstorage.AccountsClientCustomerInitiatedMigrationResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method AccountsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.AccountsClientDeleteOptions) (resp azfake.Responder[armstorage.AccountsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginFailover is the fake for method AccountsClient.BeginFailover
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginFailover func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.AccountsClientBeginFailoverOptions) (resp azfake.PollerResponder[armstorage.AccountsClientFailoverResponse], errResp azfake.ErrorResponder)

	// GetCustomerInitiatedMigration is the fake for method AccountsClient.GetCustomerInitiatedMigration
	// HTTP status codes to indicate success: http.StatusOK
	GetCustomerInitiatedMigration func(ctx context.Context, resourceGroupName string, accountName string, migrationName armstorage.MigrationName, options *armstorage.AccountsClientGetCustomerInitiatedMigrationOptions) (resp azfake.Responder[armstorage.AccountsClientGetCustomerInitiatedMigrationResponse], errResp azfake.ErrorResponder)

	// GetProperties is the fake for method AccountsClient.GetProperties
	// HTTP status codes to indicate success: http.StatusOK
	GetProperties func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.AccountsClientGetPropertiesOptions) (resp azfake.Responder[armstorage.AccountsClientGetPropertiesResponse], errResp azfake.ErrorResponder)

	// BeginHierarchicalNamespaceMigration is the fake for method AccountsClient.BeginHierarchicalNamespaceMigration
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginHierarchicalNamespaceMigration func(ctx context.Context, resourceGroupName string, accountName string, requestType string, options *armstorage.AccountsClientBeginHierarchicalNamespaceMigrationOptions) (resp azfake.PollerResponder[armstorage.AccountsClientHierarchicalNamespaceMigrationResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AccountsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armstorage.AccountsClientListOptions) (resp azfake.PagerResponder[armstorage.AccountsClientListResponse])

	// ListAccountSAS is the fake for method AccountsClient.ListAccountSAS
	// HTTP status codes to indicate success: http.StatusOK
	ListAccountSAS func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.AccountSasParameters, options *armstorage.AccountsClientListAccountSASOptions) (resp azfake.Responder[armstorage.AccountsClientListAccountSASResponse], errResp azfake.ErrorResponder)

	// NewListByResourceGroupPager is the fake for method AccountsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armstorage.AccountsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armstorage.AccountsClientListByResourceGroupResponse])

	// ListKeys is the fake for method AccountsClient.ListKeys
	// HTTP status codes to indicate success: http.StatusOK
	ListKeys func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.AccountsClientListKeysOptions) (resp azfake.Responder[armstorage.AccountsClientListKeysResponse], errResp azfake.ErrorResponder)

	// ListServiceSAS is the fake for method AccountsClient.ListServiceSAS
	// HTTP status codes to indicate success: http.StatusOK
	ListServiceSAS func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.ServiceSasParameters, options *armstorage.AccountsClientListServiceSASOptions) (resp azfake.Responder[armstorage.AccountsClientListServiceSASResponse], errResp azfake.ErrorResponder)

	// RegenerateKey is the fake for method AccountsClient.RegenerateKey
	// HTTP status codes to indicate success: http.StatusOK
	RegenerateKey func(ctx context.Context, resourceGroupName string, accountName string, regenerateKey armstorage.AccountRegenerateKeyParameters, options *armstorage.AccountsClientRegenerateKeyOptions) (resp azfake.Responder[armstorage.AccountsClientRegenerateKeyResponse], errResp azfake.ErrorResponder)

	// BeginRestoreBlobRanges is the fake for method AccountsClient.BeginRestoreBlobRanges
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestoreBlobRanges func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.BlobRestoreParameters, options *armstorage.AccountsClientBeginRestoreBlobRangesOptions) (resp azfake.PollerResponder[armstorage.AccountsClientRestoreBlobRangesResponse], errResp azfake.ErrorResponder)

	// RevokeUserDelegationKeys is the fake for method AccountsClient.RevokeUserDelegationKeys
	// HTTP status codes to indicate success: http.StatusOK
	RevokeUserDelegationKeys func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.AccountsClientRevokeUserDelegationKeysOptions) (resp azfake.Responder[armstorage.AccountsClientRevokeUserDelegationKeysResponse], errResp azfake.ErrorResponder)

	// Update is the fake for method AccountsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.AccountUpdateParameters, options *armstorage.AccountsClientUpdateOptions) (resp azfake.Responder[armstorage.AccountsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewAccountsServerTransport creates a new instance of AccountsServerTransport with the provided implementation.
// The returned AccountsServerTransport instance is connected to an instance of armstorage.AccountsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccountsServerTransport(srv *AccountsServer) *AccountsServerTransport {
	return &AccountsServerTransport{
		srv:                                      srv,
		beginAbortHierarchicalNamespaceMigration: newTracker[azfake.PollerResponder[armstorage.AccountsClientAbortHierarchicalNamespaceMigrationResponse]](),
		beginCreate:                              newTracker[azfake.PollerResponder[armstorage.AccountsClientCreateResponse]](),
		beginCustomerInitiatedMigration:          newTracker[azfake.PollerResponder[armstorage.AccountsClientCustomerInitiatedMigrationResponse]](),
		beginFailover:                            newTracker[azfake.PollerResponder[armstorage.AccountsClientFailoverResponse]](),
		beginHierarchicalNamespaceMigration:      newTracker[azfake.PollerResponder[armstorage.AccountsClientHierarchicalNamespaceMigrationResponse]](),
		newListPager:                             newTracker[azfake.PagerResponder[armstorage.AccountsClientListResponse]](),
		newListByResourceGroupPager:              newTracker[azfake.PagerResponder[armstorage.AccountsClientListByResourceGroupResponse]](),
		beginRestoreBlobRanges:                   newTracker[azfake.PollerResponder[armstorage.AccountsClientRestoreBlobRangesResponse]](),
	}
}

// AccountsServerTransport connects instances of armstorage.AccountsClient to instances of AccountsServer.
// Don't use this type directly, use NewAccountsServerTransport instead.
type AccountsServerTransport struct {
	srv                                      *AccountsServer
	beginAbortHierarchicalNamespaceMigration *tracker[azfake.PollerResponder[armstorage.AccountsClientAbortHierarchicalNamespaceMigrationResponse]]
	beginCreate                              *tracker[azfake.PollerResponder[armstorage.AccountsClientCreateResponse]]
	beginCustomerInitiatedMigration          *tracker[azfake.PollerResponder[armstorage.AccountsClientCustomerInitiatedMigrationResponse]]
	beginFailover                            *tracker[azfake.PollerResponder[armstorage.AccountsClientFailoverResponse]]
	beginHierarchicalNamespaceMigration      *tracker[azfake.PollerResponder[armstorage.AccountsClientHierarchicalNamespaceMigrationResponse]]
	newListPager                             *tracker[azfake.PagerResponder[armstorage.AccountsClientListResponse]]
	newListByResourceGroupPager              *tracker[azfake.PagerResponder[armstorage.AccountsClientListByResourceGroupResponse]]
	beginRestoreBlobRanges                   *tracker[azfake.PollerResponder[armstorage.AccountsClientRestoreBlobRangesResponse]]
}

// Do implements the policy.Transporter interface for AccountsServerTransport.
func (a *AccountsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	return a.dispatchToMethodFake(req, method)
}

func (a *AccountsServerTransport) dispatchToMethodFake(req *http.Request, method string) (*http.Response, error) {
	resultChan := make(chan result)
	defer close(resultChan)

	go func() {
		var intercepted bool
		var res result
		if accountsServerTransportInterceptor != nil {
			res.resp, res.err, intercepted = accountsServerTransportInterceptor.Do(req)
		}
		if !intercepted {
			switch method {
			case "AccountsClient.BeginAbortHierarchicalNamespaceMigration":
				res.resp, res.err = a.dispatchBeginAbortHierarchicalNamespaceMigration(req)
			case "AccountsClient.CheckNameAvailability":
				res.resp, res.err = a.dispatchCheckNameAvailability(req)
			case "AccountsClient.BeginCreate":
				res.resp, res.err = a.dispatchBeginCreate(req)
			case "AccountsClient.BeginCustomerInitiatedMigration":
				res.resp, res.err = a.dispatchBeginCustomerInitiatedMigration(req)
			case "AccountsClient.Delete":
				res.resp, res.err = a.dispatchDelete(req)
			case "AccountsClient.BeginFailover":
				res.resp, res.err = a.dispatchBeginFailover(req)
			case "AccountsClient.GetCustomerInitiatedMigration":
				res.resp, res.err = a.dispatchGetCustomerInitiatedMigration(req)
			case "AccountsClient.GetProperties":
				res.resp, res.err = a.dispatchGetProperties(req)
			case "AccountsClient.BeginHierarchicalNamespaceMigration":
				res.resp, res.err = a.dispatchBeginHierarchicalNamespaceMigration(req)
			case "AccountsClient.NewListPager":
				res.resp, res.err = a.dispatchNewListPager(req)
			case "AccountsClient.ListAccountSAS":
				res.resp, res.err = a.dispatchListAccountSAS(req)
			case "AccountsClient.NewListByResourceGroupPager":
				res.resp, res.err = a.dispatchNewListByResourceGroupPager(req)
			case "AccountsClient.ListKeys":
				res.resp, res.err = a.dispatchListKeys(req)
			case "AccountsClient.ListServiceSAS":
				res.resp, res.err = a.dispatchListServiceSAS(req)
			case "AccountsClient.RegenerateKey":
				res.resp, res.err = a.dispatchRegenerateKey(req)
			case "AccountsClient.BeginRestoreBlobRanges":
				res.resp, res.err = a.dispatchBeginRestoreBlobRanges(req)
			case "AccountsClient.RevokeUserDelegationKeys":
				res.resp, res.err = a.dispatchRevokeUserDelegationKeys(req)
			case "AccountsClient.Update":
				res.resp, res.err = a.dispatchUpdate(req)
			default:
				res.err = fmt.Errorf("unhandled API %s", method)
			}

		}
		select {
		case resultChan <- res:
		case <-req.Context().Done():
		}
	}()

	select {
	case <-req.Context().Done():
		return nil, req.Context().Err()
	case res := <-resultChan:
		return res.resp, res.err
	}
}

func (a *AccountsServerTransport) dispatchBeginAbortHierarchicalNamespaceMigration(req *http.Request) (*http.Response, error) {
	if a.srv.BeginAbortHierarchicalNamespaceMigration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginAbortHierarchicalNamespaceMigration not implemented")}
	}
	beginAbortHierarchicalNamespaceMigration := a.beginAbortHierarchicalNamespaceMigration.get(req)
	if beginAbortHierarchicalNamespaceMigration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/aborthnsonmigration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginAbortHierarchicalNamespaceMigration(req.Context(), resourceGroupNameParam, accountNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginAbortHierarchicalNamespaceMigration = &respr
		a.beginAbortHierarchicalNamespaceMigration.add(req, beginAbortHierarchicalNamespaceMigration)
	}

	resp, err := server.PollerResponderNext(beginAbortHierarchicalNamespaceMigration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginAbortHierarchicalNamespaceMigration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginAbortHierarchicalNamespaceMigration) {
		a.beginAbortHierarchicalNamespaceMigration.remove(req)
	}

	return resp, nil
}

func (a *AccountsServerTransport) dispatchCheckNameAvailability(req *http.Request) (*http.Response, error) {
	if a.srv.CheckNameAvailability == nil {
		return nil, &nonRetriableError{errors.New("fake for method CheckNameAvailability not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/checkNameAvailability`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.AccountCheckNameAvailabilityParameters](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.CheckNameAvailability(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).CheckNameAvailabilityResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchBeginCreate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCreate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreate not implemented")}
	}
	beginCreate := a.beginCreate.get(req)
	if beginCreate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorage.AccountCreateParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCreate(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreate = &respr
		a.beginCreate.add(req, beginCreate)
	}

	resp, err := server.PollerResponderNext(beginCreate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginCreate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreate) {
		a.beginCreate.remove(req)
	}

	return resp, nil
}

func (a *AccountsServerTransport) dispatchBeginCustomerInitiatedMigration(req *http.Request) (*http.Response, error) {
	if a.srv.BeginCustomerInitiatedMigration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCustomerInitiatedMigration not implemented")}
	}
	beginCustomerInitiatedMigration := a.beginCustomerInitiatedMigration.get(req)
	if beginCustomerInitiatedMigration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/startAccountMigration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorage.AccountMigration](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginCustomerInitiatedMigration(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCustomerInitiatedMigration = &respr
		a.beginCustomerInitiatedMigration.add(req, beginCustomerInitiatedMigration)
	}

	resp, err := server.PollerResponderNext(beginCustomerInitiatedMigration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginCustomerInitiatedMigration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCustomerInitiatedMigration) {
		a.beginCustomerInitiatedMigration.remove(req)
	}

	return resp, nil
}

func (a *AccountsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if a.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Delete(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchBeginFailover(req *http.Request) (*http.Response, error) {
	if a.srv.BeginFailover == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginFailover not implemented")}
	}
	beginFailover := a.beginFailover.get(req)
	if beginFailover == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/failover`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		failoverTypeUnescaped, err := url.QueryUnescape(qp.Get("failoverType"))
		if err != nil {
			return nil, err
		}
		failoverTypeParam := getOptional(failoverTypeUnescaped)
		var options *armstorage.AccountsClientBeginFailoverOptions
		if failoverTypeParam != nil {
			options = &armstorage.AccountsClientBeginFailoverOptions{
				FailoverType: failoverTypeParam,
			}
		}
		respr, errRespr := a.srv.BeginFailover(req.Context(), resourceGroupNameParam, accountNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginFailover = &respr
		a.beginFailover.add(req, beginFailover)
	}

	resp, err := server.PollerResponderNext(beginFailover, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginFailover.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginFailover) {
		a.beginFailover.remove(req)
	}

	return resp, nil
}

func (a *AccountsServerTransport) dispatchGetCustomerInitiatedMigration(req *http.Request) (*http.Response, error) {
	if a.srv.GetCustomerInitiatedMigration == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetCustomerInitiatedMigration not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/accountMigrations/(?P<migrationName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	migrationNameParam, err := parseWithCast(matches[regex.SubexpIndex("migrationName")], func(v string) (armstorage.MigrationName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armstorage.MigrationName(p), nil
	})
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetCustomerInitiatedMigration(req.Context(), resourceGroupNameParam, accountNameParam, migrationNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccountMigration, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchGetProperties(req *http.Request) (*http.Response, error) {
	if a.srv.GetProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(armstorage.StorageAccountExpand(expandUnescaped))
	var options *armstorage.AccountsClientGetPropertiesOptions
	if expandParam != nil {
		options = &armstorage.AccountsClientGetPropertiesOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := a.srv.GetProperties(req.Context(), resourceGroupNameParam, accountNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Account, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchBeginHierarchicalNamespaceMigration(req *http.Request) (*http.Response, error) {
	if a.srv.BeginHierarchicalNamespaceMigration == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginHierarchicalNamespaceMigration not implemented")}
	}
	beginHierarchicalNamespaceMigration := a.beginHierarchicalNamespaceMigration.get(req)
	if beginHierarchicalNamespaceMigration == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourcegroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/hnsonmigration`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		requestTypeParam, err := url.QueryUnescape(qp.Get("requestType"))
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginHierarchicalNamespaceMigration(req.Context(), resourceGroupNameParam, accountNameParam, requestTypeParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginHierarchicalNamespaceMigration = &respr
		a.beginHierarchicalNamespaceMigration.add(req, beginHierarchicalNamespaceMigration)
	}

	resp, err := server.PollerResponderNext(beginHierarchicalNamespaceMigration, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		a.beginHierarchicalNamespaceMigration.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginHierarchicalNamespaceMigration) {
		a.beginHierarchicalNamespaceMigration.remove(req)
	}

	return resp, nil
}

func (a *AccountsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewListPager(nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armstorage.AccountsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchListAccountSAS(req *http.Request) (*http.Response, error) {
	if a.srv.ListAccountSAS == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListAccountSAS not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ListAccountSas`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.AccountSasParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListAccountSAS(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListAccountSasResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := a.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		a.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armstorage.AccountsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		a.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchListKeys(req *http.Request) (*http.Response, error) {
	if a.srv.ListKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/listKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	expandUnescaped, err := url.QueryUnescape(qp.Get("$expand"))
	if err != nil {
		return nil, err
	}
	expandParam := getOptional(expandUnescaped)
	var options *armstorage.AccountsClientListKeysOptions
	if expandParam != nil {
		options = &armstorage.AccountsClientListKeysOptions{
			Expand: expandParam,
		}
	}
	respr, errRespr := a.srv.ListKeys(req.Context(), resourceGroupNameParam, accountNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccountListKeysResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchListServiceSAS(req *http.Request) (*http.Response, error) {
	if a.srv.ListServiceSAS == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListServiceSAS not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/ListServiceSas`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.ServiceSasParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.ListServiceSAS(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ListServiceSasResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchRegenerateKey(req *http.Request) (*http.Response, error) {
	if a.srv.RegenerateKey == nil {
		return nil, &nonRetriableError{errors.New("fake for method RegenerateKey not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/regenerateKey`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.AccountRegenerateKeyParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.RegenerateKey(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).AccountListKeysResult, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchBeginRestoreBlobRanges(req *http.Request) (*http.Response, error) {
	if a.srv.BeginRestoreBlobRanges == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestoreBlobRanges not implemented")}
	}
	beginRestoreBlobRanges := a.beginRestoreBlobRanges.get(req)
	if beginRestoreBlobRanges == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restoreBlobRanges`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armstorage.BlobRestoreParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginRestoreBlobRanges(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestoreBlobRanges = &respr
		a.beginRestoreBlobRanges.add(req, beginRestoreBlobRanges)
	}

	resp, err := server.PollerResponderNext(beginRestoreBlobRanges, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		a.beginRestoreBlobRanges.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestoreBlobRanges) {
		a.beginRestoreBlobRanges.remove(req)
	}

	return resp, nil
}

func (a *AccountsServerTransport) dispatchRevokeUserDelegationKeys(req *http.Request) (*http.Response, error) {
	if a.srv.RevokeUserDelegationKeys == nil {
		return nil, &nonRetriableError{errors.New("fake for method RevokeUserDelegationKeys not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/revokeUserDelegationKeys`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.RevokeUserDelegationKeys(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AccountsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if a.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.AccountUpdateParameters](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.Update(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Account, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// set this to conditionally intercept incoming requests to AccountsServerTransport
var accountsServerTransportInterceptor interface {
	// Do returns true if the server transport should use the returned response/error
	Do(*http.Request) (*http.Response, error, bool)
}
