//****************************************************************************
// Model: pelican.qm
// File:  ./pelican.cpp
//
// This code has been generated by QM tool (see state-machine.com/qm).
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// This program is open source software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published
// by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
// for more details.
//****************************************************************************
//${.::pelican.cpp} ..........................................................
#include "qpcpp.h"
#include "bsp.h"
#include "pelican.h"

Q_DEFINE_THIS_FILE

// Pelican class -------------------------------------------------------------
namespace PELICAN {


#if ((QP_VERSION < 580) || (QP_VERSION != ((QP_RELEASE^4294967295U) % 0x3E8)))
#error qpcpp version 5.8.0 or higher required
#endif

//${components::Pelican} .....................................................
class Pelican : public QP::GuiQActive {
private:
    QP::QTimeEvt m_timeout;
    uint8_t m_flashCtr;

public:
    Pelican()
     : GuiQActive(Q_STATE_CAST(&Pelican::initial)),
       m_timeout(this, TIMEOUT_SIG)
    {}

protected:
    static QP::QState initial(Pelican * const me, QP::QEvt const * const e);
    static QP::QState operational(Pelican * const me, QP::QEvt const * const e);
    static QP::QState carsEnabled(Pelican * const me, QP::QEvt const * const e);
    static QP::QState carsGreen(Pelican * const me, QP::QEvt const * const e);
    static QP::QState carsGreenNoPed(Pelican * const me, QP::QEvt const * const e);
    static QP::QState carsGreenInt(Pelican * const me, QP::QEvt const * const e);
    static QP::QState carsGreenPedWait(Pelican * const me, QP::QEvt const * const e);
    static QP::QState carsYellow(Pelican * const me, QP::QEvt const * const e);
    static QP::QState pedsEnabled(Pelican * const me, QP::QEvt const * const e);
    static QP::QState pedsWalk(Pelican * const me, QP::QEvt const * const e);
    static QP::QState pedsFlash(Pelican * const me, QP::QEvt const * const e);
    static QP::QState offline(Pelican * const me, QP::QEvt const * const e);
};

} // namespace PELICAN

namespace PELICAN {

enum PelicanTimeouts {  // various timeouts in ticks
    CARS_GREEN_MIN_TOUT = BSP_TICKS_PER_SEC * 8, // min green for cars
    CARS_YELLOW_TOUT = BSP_TICKS_PER_SEC * 3,  // yellow for cars
    PEDS_WALK_TOUT   = BSP_TICKS_PER_SEC * 3,  // walking time for peds
    PEDS_FLASH_TOUT  = BSP_TICKS_PER_SEC / 5,  // flashing timeout for peds
    PEDS_FLASH_NUM   = 5*2,                    // number of flashes for peds
    OFF_FLASH_TOUT   = BSP_TICKS_PER_SEC / 2   // flashing timeout when off
};

// Local objects -------------------------------------------------------------
static Pelican l_Pelican; // the single instance of Pelican active object

// Global objects ------------------------------------------------------------
QP::QActive * const AO_Pelican = &l_Pelican; // the opaque pointer

} // namespace PELICAN

// Pelican class definition --------------------------------------------------
namespace PELICAN {

//${components::Pelican} .....................................................

//${components::Pelican::SM} .................................................
QP::QState Pelican::initial(Pelican * const me, QP::QEvt const * const e) {
    // ${components::Pelican::SM::initial}
    me->subscribe(PEDS_WAITING_SIG);
    me->subscribe(TERMINATE_SIG);

    QS_OBJ_DICTIONARY(&l_Pelican);
    QS_OBJ_DICTIONARY(&l_Pelican.m_timeout);

    QS_FUN_DICTIONARY(&QP::QHsm::top);
    QS_FUN_DICTIONARY(&Pelican::initial);
    QS_FUN_DICTIONARY(&Pelican::offline);
    QS_FUN_DICTIONARY(&Pelican::operational);
    QS_FUN_DICTIONARY(&Pelican::carsEnabled);
    QS_FUN_DICTIONARY(&Pelican::carsGreen);
    QS_FUN_DICTIONARY(&Pelican::carsGreenNoPed);
    QS_FUN_DICTIONARY(&Pelican::carsGreenPedWait);
    QS_FUN_DICTIONARY(&Pelican::carsGreenInt);
    QS_FUN_DICTIONARY(&Pelican::carsYellow);
    QS_FUN_DICTIONARY(&Pelican::pedsEnabled);
    QS_FUN_DICTIONARY(&Pelican::pedsWalk);
    QS_FUN_DICTIONARY(&Pelican::pedsFlash);

    QS_SIG_DICTIONARY(PEDS_WAITING_SIG, (void *)0);  // global signals
    QS_SIG_DICTIONARY(ON_SIG,           (void *)0);
    QS_SIG_DICTIONARY(OFF_SIG,          (void *)0);

    QS_SIG_DICTIONARY(TIMEOUT_SIG,      &l_Pelican); // just for Pelican

    (void)e; // unused parameter
    return Q_TRAN(&operational);
}
//${components::Pelican::SM::operational} ....................................
QP::QState Pelican::operational(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational}
        case Q_ENTRY_SIG: {
            BSP_signalCars(CARS_RED);
            BSP_signalPeds(PEDS_DONT_WALK);
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::initial}
        case Q_INIT_SIG: {
            status_ = Q_TRAN(&carsEnabled);
            break;
        }
        // ${components::Pelican::SM::operational::OFF}
        case OFF_SIG: {
            status_ = Q_TRAN(&offline);
            break;
        }
        // ${components::Pelican::SM::operational::TERMINATE}
        case TERMINATE_SIG: {
            BSP_terminate(0);
            status_ = Q_HANDLED();
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::carsEnabled} .......................
QP::QState Pelican::carsEnabled(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::carsEnabled}
        case Q_EXIT_SIG: {
            BSP_signalCars(CARS_RED);
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::initial}
        case Q_INIT_SIG: {
            status_ = Q_TRAN(&carsGreen);
            break;
        }
        default: {
            status_ = Q_SUPER(&operational);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::carsEnabled::carsGreen} ............
QP::QState Pelican::carsGreen(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen}
        case Q_ENTRY_SIG: {
            BSP_signalCars(CARS_GREEN);
            me->m_timeout.armX(CARS_GREEN_MIN_TOUT);
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen}
        case Q_EXIT_SIG: {
            (void)me->m_timeout.disarm();
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen::initial}
        case Q_INIT_SIG: {
            status_ = Q_TRAN(&carsGreenNoPed);
            break;
        }
        default: {
            status_ = Q_SUPER(&carsEnabled);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenNoPed}
QP::QState Pelican::carsGreenNoPed(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenNoPed}
        case Q_ENTRY_SIG: {
            BSP_showState("carsGreenNoPed");
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenNoPed::PEDS_WAITING}
        case PEDS_WAITING_SIG: {
            status_ = Q_TRAN(&carsGreenPedWait);
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenNoPed::TIMEOUT}
        case TIMEOUT_SIG: {
            status_ = Q_TRAN(&carsGreenInt);
            break;
        }
        default: {
            status_ = Q_SUPER(&carsGreen);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenInt}
QP::QState Pelican::carsGreenInt(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenInt}
        case Q_ENTRY_SIG: {
            BSP_showState("carsGreenInt");
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenInt::PEDS_WAITING}
        case PEDS_WAITING_SIG: {
            status_ = Q_TRAN(&carsYellow);
            break;
        }
        default: {
            status_ = Q_SUPER(&carsGreen);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenPedWait}
QP::QState Pelican::carsGreenPedWait(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenPedWait}
        case Q_ENTRY_SIG: {
            BSP_showState("carsGreenPedWait");
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::carsGreen::carsGreenPedWait::TIMEOUT}
        case TIMEOUT_SIG: {
            status_ = Q_TRAN(&carsYellow);
            break;
        }
        default: {
            status_ = Q_SUPER(&carsGreen);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::carsEnabled::carsYellow} ...........
QP::QState Pelican::carsYellow(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::carsEnabled::carsYellow}
        case Q_ENTRY_SIG: {
            BSP_showState("carsYellow");
            BSP_signalCars(CARS_YELLOW);
            me->m_timeout.armX(CARS_YELLOW_TOUT);
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::carsYellow}
        case Q_EXIT_SIG: {
            (void)me->m_timeout.disarm();
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::carsEnabled::carsYellow::TIMEOUT}
        case TIMEOUT_SIG: {
            status_ = Q_TRAN(&pedsEnabled);
            break;
        }
        default: {
            status_ = Q_SUPER(&carsEnabled);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::pedsEnabled} .......................
QP::QState Pelican::pedsEnabled(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::pedsEnabled}
        case Q_EXIT_SIG: {
            BSP_signalPeds(PEDS_DONT_WALK);
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::pedsEnabled::initial}
        case Q_INIT_SIG: {
            status_ = Q_TRAN(&pedsWalk);
            break;
        }
        default: {
            status_ = Q_SUPER(&operational);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::pedsEnabled::pedsWalk} .............
QP::QState Pelican::pedsWalk(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::pedsEnabled::pedsWalk}
        case Q_ENTRY_SIG: {
            BSP_showState("pedsWalk");
            BSP_signalPeds(PEDS_WALK);
            me->m_timeout.armX(PEDS_WALK_TOUT);
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::pedsEnabled::pedsWalk}
        case Q_EXIT_SIG: {
            (void)me->m_timeout.disarm();
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::pedsEnabled::pedsWalk::TIMEOUT}
        case TIMEOUT_SIG: {
            status_ = Q_TRAN(&pedsFlash);
            break;
        }
        default: {
            status_ = Q_SUPER(&pedsEnabled);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::operational::pedsEnabled::pedsFlash} ............
QP::QState Pelican::pedsFlash(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::operational::pedsEnabled::pedsFlash}
        case Q_ENTRY_SIG: {
            BSP_showState("pedsFlash");
            me->m_timeout.armX(PEDS_FLASH_TOUT, PEDS_FLASH_TOUT);
            me->m_flashCtr = PEDS_FLASH_NUM*2 + 1;
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::pedsEnabled::pedsFlash}
        case Q_EXIT_SIG: {
            (void)me->m_timeout.disarm();
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::operational::pedsEnabled::pedsFlash::TIMEOUT}
        case TIMEOUT_SIG: {
            // ${components::Pelican::SM::operational::pedsEnabled::pedsFlash::TIMEOUT::[me->m_flashCtr!=0U]}
            if (me->m_flashCtr != 0U) {
                --me->m_flashCtr;
                // ${components::Pelican::SM::operational::pedsEnabled::pedsFlash::TIMEOUT::[me->m_flashCtr!~::[(me->m_flashCtr&1U)==0U]}
                if ((me->m_flashCtr & 1U) == 0U) {
                    BSP_signalPeds(PEDS_DONT_WALK);
                    status_ = Q_HANDLED();
                }
                // ${components::Pelican::SM::operational::pedsEnabled::pedsFlash::TIMEOUT::[me->m_flashCtr!~::[else]}
                else {
                    BSP_signalPeds(PEDS_BLANK);
                    status_ = Q_HANDLED();
                }
            }
            // ${components::Pelican::SM::operational::pedsEnabled::pedsFlash::TIMEOUT::[else]}
            else {
                status_ = Q_TRAN(&carsEnabled);
            }
            break;
        }
        default: {
            status_ = Q_SUPER(&pedsEnabled);
            break;
        }
    }
    return status_;
}
//${components::Pelican::SM::offline} ........................................
QP::QState Pelican::offline(Pelican * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${components::Pelican::SM::offline}
        case Q_ENTRY_SIG: {
            BSP_showState("offline");
            me->m_timeout.armX(OFF_FLASH_TOUT, OFF_FLASH_TOUT);
            me->m_flashCtr = 0U;
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::offline}
        case Q_EXIT_SIG: {
            (void)me->m_timeout.disarm();
            status_ = Q_HANDLED();
            break;
        }
        // ${components::Pelican::SM::offline::TIMEOUT}
        case TIMEOUT_SIG: {
            me->m_flashCtr ^= 1U;
            // ${components::Pelican::SM::offline::TIMEOUT::[(me->m_flashCtr&1U)==0U]}
            if ((me->m_flashCtr & 1U) == 0U) {
                BSP_signalCars(CARS_RED);
                BSP_signalPeds(PEDS_DONT_WALK);
                status_ = Q_HANDLED();
            }
            // ${components::Pelican::SM::offline::TIMEOUT::[else]}
            else {
                BSP_signalCars(CARS_BLANK);
                BSP_signalPeds(PEDS_BLANK);
                status_ = Q_HANDLED();
            }
            break;
        }
        // ${components::Pelican::SM::offline::ON}
        case ON_SIG: {
            status_ = Q_TRAN(&operational);
            break;
        }
        // ${components::Pelican::SM::offline::TERMINATE}
        case TERMINATE_SIG: {
            BSP_terminate(0);
            status_ = Q_HANDLED();
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}

} // namespace PELICAN
