//****************************************************************************
// Model: comp.qm
// File:  ./alarm.cpp
//
// This code has been generated by QM tool (see state-machine.com/qm).
// DO NOT EDIT THIS FILE MANUALLY. All your changes will be lost.
//
// This program is open source software: you can redistribute it and/or
// modify it under the terms of the GNU General Public License as published
// by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
// or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
// for more details.
//****************************************************************************
//${.::alarm.cpp} ............................................................
#include "qpcpp.h"
#include "bsp.h"
#include "alarm.h"
#include "clock.h"

Q_DEFINE_THIS_FILE

// Alarm component --------------------

#if ((QP_VERSION < 580) || (QP_VERSION != ((QP_RELEASE^4294967295U) % 0x3E8)))
#error qpcpp version 5.8.0 or higher required
#endif

//${Components::Alarm} .......................................................
//${Components::Alarm::Alarm} ................................................
Alarm::Alarm()
 : QHsm(Q_STATE_CAST(&Alarm::initial))
{}

//${Components::Alarm::SM} ...................................................
QP::QState Alarm::initial(Alarm * const me, QP::QEvt const * const e) {
    // ${Components::Alarm::SM::initial}
    me->m_alarm_time = 12U*60U;
    (void)e; // unused parameter
    return Q_TRAN(&off);
}
//${Components::Alarm::SM::off} ..............................................
QP::QState Alarm::off(Alarm * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${Components::Alarm::SM::off}
        case Q_ENTRY_SIG: {
            // while in the off state, the alarm is kept in decimal format
            me->m_alarm_time = (me->m_alarm_time/60)*100 + me->m_alarm_time%60;
            BSP_showTime24H("*** Alarm OFF ", me->m_alarm_time, 100U);
            status_ = Q_HANDLED();
            break;
        }
        // ${Components::Alarm::SM::off}
        case Q_EXIT_SIG: {
            // upon exit, the alarm is converted to binary format
            me->m_alarm_time = (me->m_alarm_time/100U)*60U + me->m_alarm_time%100U;
            status_ = Q_HANDLED();
            break;
        }
        // ${Components::Alarm::SM::off::ALARM_ON}
        case ALARM_ON_SIG: {
            // ${Components::Alarm::SM::off::ALARM_ON::[alarminrange?]}
            if ((me->m_alarm_time / 100U < 24U)
                && (me->m_alarm_time % 100U < 60U))
            {
                status_ = Q_TRAN(&on);
            }
            // ${Components::Alarm::SM::off::ALARM_ON::[else]}
            else {
                me->m_alarm_time = 0U;
                BSP_showTime24H("*** Alarm reset", me->m_alarm_time, 100U);
                status_ = Q_HANDLED();
            }
            break;
        }
        // ${Components::Alarm::SM::off::ALARM_SET}
        case ALARM_SET_SIG: {
            // while setting, the alarm is kept in decimal format
            me->m_alarm_time =
                 (10U * me->m_alarm_time + Q_EVT_CAST(SetEvt)->digit) % 10000U;
            BSP_showTime24H("*** Alarm reset ",  me->m_alarm_time, 100U);
            status_ = Q_HANDLED();
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}
//${Components::Alarm::SM::on} ...............................................
QP::QState Alarm::on(Alarm * const me, QP::QEvt const * const e) {
    QP::QState status_;
    switch (e->sig) {
        // ${Components::Alarm::SM::on}
        case Q_ENTRY_SIG: {
            BSP_showTime24H("*** Alarm ON ",  me->m_alarm_time, 60U);
            status_ = Q_HANDLED();
            break;
        }
        // ${Components::Alarm::SM::on::ALARM_OFF}
        case ALARM_OFF_SIG: {
            status_ = Q_TRAN(&off);
            break;
        }
        // ${Components::Alarm::SM::on::ALARM_SET}
        case ALARM_SET_SIG: {
            BSP_showMsg("*** Cannot set Alarm when it is ON");
            status_ = Q_HANDLED();
            break;
        }
        // ${Components::Alarm::SM::on::TIME}
        case TIME_SIG: {
            // ${Components::Alarm::SM::on::TIME::[Q_EVT_CAST(TimeEvt)->current_ti~}
            if (Q_EVT_CAST(TimeEvt)->current_time == me->m_alarm_time) {
                BSP_showMsg("ALARM!!!");

                // asynchronously post the event to the container AO
                APP_alarmClock->POST(Q_NEW(QEvt, ALARM_SIG), this);
                status_ = Q_HANDLED();
            }
            else {
                status_ = Q_UNHANDLED();
            }
            break;
        }
        default: {
            status_ = Q_SUPER(&top);
            break;
        }
    }
    return status_;
}

