#!/bin/bash

# -----------------Configurable Section------------------------------
# Java options here, you can add more options if needed.
# See http://kb.almworks.com/wiki/Deskzilla_Command_Line_Options

JAVA_OPTIONS="-Xmx600m"
I4JSCRIPT="true"

# -----------------End of Configurable Secion------------------------

ME=$0
while [ -L "$ME" ]; do
  _dir="`dirname \"$ME\"`"
  _link="`readlink \"$ME\"`"
  if [ "x$?" != "x0" ]; then break; fi
  if [ "x${_link}" = "x" ]; then break; fi
  if [ "x${_link:0:1}" != "x/" ]; then
    ME="${_dir}/${_link}"
  else 
    ME="${_link}"
  fi
done
MYDIR="`dirname \"$ME\"`"

PROGRAM_JAR=deskzilla.jar
PROGRAM_NAME="Deskzilla Lite"
LAUNCHER=launch.sh
LAUNCH="$MYDIR/$LAUNCHER"
ROOT_LAUNCHER="$MYDIR/../deskzilla"
SHELL=/bin/bash

if [ "x$I4JSCRIPT" != "xfalse" ]; then
  if [ -x "$ROOT_LAUNCHER" ]; then
    "$ROOT_LAUNCHER" $*
    exit $?
  fi
fi

if [ ! -f "$LAUNCH" ] ; then
echo ==========================================================================
echo ERROR: Cannot start $PROGRAM_NAME
echo Cannot find $LAUNCHER in $MYDIR
echo ==========================================================================
exit 1
fi

X_ALMWORKS_LAUNCH_PERMIT=true
export PROGRAM_JAR PROGRAM_NAME X_ALMWORKS_LAUNCH_PERMIT JAVA_OPTIONS
$SHELL "$LAUNCH" $*
exit $?
