// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2beta1/agent.proto

package dialogflowpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Agents_GetAgent_FullMethodName            = "/google.cloud.dialogflow.v2beta1.Agents/GetAgent"
	Agents_SetAgent_FullMethodName            = "/google.cloud.dialogflow.v2beta1.Agents/SetAgent"
	Agents_DeleteAgent_FullMethodName         = "/google.cloud.dialogflow.v2beta1.Agents/DeleteAgent"
	Agents_SearchAgents_FullMethodName        = "/google.cloud.dialogflow.v2beta1.Agents/SearchAgents"
	Agents_TrainAgent_FullMethodName          = "/google.cloud.dialogflow.v2beta1.Agents/TrainAgent"
	Agents_ExportAgent_FullMethodName         = "/google.cloud.dialogflow.v2beta1.Agents/ExportAgent"
	Agents_ImportAgent_FullMethodName         = "/google.cloud.dialogflow.v2beta1.Agents/ImportAgent"
	Agents_RestoreAgent_FullMethodName        = "/google.cloud.dialogflow.v2beta1.Agents/RestoreAgent"
	Agents_GetValidationResult_FullMethodName = "/google.cloud.dialogflow.v2beta1.Agents/GetValidationResult"
)

// AgentsClient is the client API for Agents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AgentsClient interface {
	// Retrieves the specified agent.
	GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Creates/updates the specified agent.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	SetAgent(ctx context.Context, in *SetAgentRequest, opts ...grpc.CallOption) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Returns the list of agents.
	// Since there is at most one conversational agent per project, this method is
	// useful primarily for listing all agents across projects the caller has
	// access to. One can achieve that with a wildcard project collection id "-".
	// Refer to [List
	// Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
	SearchAgents(ctx context.Context, in *SearchAgentsRequest, opts ...grpc.CallOption) (*SearchAgentsResponse, error)
	// Trains the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	TrainAgent(ctx context.Context, in *TrainAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports the specified agent to a ZIP file.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [ExportAgentResponse][google.cloud.dialogflow.v2beta1.ExportAgentResponse]
	ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports the specified agent from a ZIP file.
	//
	// Uploads new intents and entity types without deleting the existing ones.
	// Intents and entity types with the same name are replaced with the new
	// versions from
	// [ImportAgentRequest][google.cloud.dialogflow.v2beta1.ImportAgentRequest].
	// After the import, the imported draft agent will be trained automatically
	// (unless disabled in agent settings). However, once the import is done,
	// training may not be completed yet. Please call
	// [TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent] and wait
	// for the operation it returns in order to train explicitly.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// The operation only tracks when importing is complete, not when it is done
	// training.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	ImportAgent(ctx context.Context, in *ImportAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores the specified agent from a ZIP file.
	//
	// Replaces the current agent version with a new one. All the intents and
	// entity types in the older version are deleted. After the restore, the
	// restored draft agent will be trained automatically (unless disabled in
	// agent settings). However, once the restore is done, training may not be
	// completed yet. Please call
	// [TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent] and wait
	// for the operation it returns in order to train explicitly.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// The operation only tracks when restoring is complete, not when it is done
	// training.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets agent validation result. Agent validation is performed during
	// training time and is updated automatically when training is completed.
	GetValidationResult(ctx context.Context, in *GetValidationResultRequest, opts ...grpc.CallOption) (*ValidationResult, error)
}

type agentsClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentsClient(cc grpc.ClientConnInterface) AgentsClient {
	return &agentsClient{cc}
}

func (c *agentsClient) GetAgent(ctx context.Context, in *GetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, Agents_GetAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) SetAgent(ctx context.Context, in *SetAgentRequest, opts ...grpc.CallOption) (*Agent, error) {
	out := new(Agent)
	err := c.cc.Invoke(ctx, Agents_SetAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) DeleteAgent(ctx context.Context, in *DeleteAgentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Agents_DeleteAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) SearchAgents(ctx context.Context, in *SearchAgentsRequest, opts ...grpc.CallOption) (*SearchAgentsResponse, error) {
	out := new(SearchAgentsResponse)
	err := c.cc.Invoke(ctx, Agents_SearchAgents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) TrainAgent(ctx context.Context, in *TrainAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Agents_TrainAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ExportAgent(ctx context.Context, in *ExportAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Agents_ExportAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) ImportAgent(ctx context.Context, in *ImportAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Agents_ImportAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) RestoreAgent(ctx context.Context, in *RestoreAgentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Agents_RestoreAgent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentsClient) GetValidationResult(ctx context.Context, in *GetValidationResultRequest, opts ...grpc.CallOption) (*ValidationResult, error) {
	out := new(ValidationResult)
	err := c.cc.Invoke(ctx, Agents_GetValidationResult_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentsServer is the server API for Agents service.
// All implementations should embed UnimplementedAgentsServer
// for forward compatibility
type AgentsServer interface {
	// Retrieves the specified agent.
	GetAgent(context.Context, *GetAgentRequest) (*Agent, error)
	// Creates/updates the specified agent.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	SetAgent(context.Context, *SetAgentRequest) (*Agent, error)
	// Deletes the specified agent.
	DeleteAgent(context.Context, *DeleteAgentRequest) (*emptypb.Empty, error)
	// Returns the list of agents.
	// Since there is at most one conversational agent per project, this method is
	// useful primarily for listing all agents across projects the caller has
	// access to. One can achieve that with a wildcard project collection id "-".
	// Refer to [List
	// Sub-Collections](https://cloud.google.com/apis/design/design_patterns#list_sub-collections).
	SearchAgents(context.Context, *SearchAgentsRequest) (*SearchAgentsResponse, error)
	// Trains the specified agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	TrainAgent(context.Context, *TrainAgentRequest) (*longrunningpb.Operation, error)
	// Exports the specified agent to a ZIP file.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`:
	//
	// [ExportAgentResponse][google.cloud.dialogflow.v2beta1.ExportAgentResponse]
	ExportAgent(context.Context, *ExportAgentRequest) (*longrunningpb.Operation, error)
	// Imports the specified agent from a ZIP file.
	//
	// Uploads new intents and entity types without deleting the existing ones.
	// Intents and entity types with the same name are replaced with the new
	// versions from
	// [ImportAgentRequest][google.cloud.dialogflow.v2beta1.ImportAgentRequest].
	// After the import, the imported draft agent will be trained automatically
	// (unless disabled in agent settings). However, once the import is done,
	// training may not be completed yet. Please call
	// [TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent] and wait
	// for the operation it returns in order to train explicitly.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// The operation only tracks when importing is complete, not when it is done
	// training.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	ImportAgent(context.Context, *ImportAgentRequest) (*longrunningpb.Operation, error)
	// Restores the specified agent from a ZIP file.
	//
	// Replaces the current agent version with a new one. All the intents and
	// entity types in the older version are deleted. After the restore, the
	// restored draft agent will be trained automatically (unless disabled in
	// agent settings). However, once the restore is done, training may not be
	// completed yet. Please call
	// [TrainAgent][google.cloud.dialogflow.v2beta1.Agents.TrainAgent] and wait
	// for the operation it returns in order to train explicitly.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	//   - `metadata`: An empty [Struct
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#struct)
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	//
	// The operation only tracks when restoring is complete, not when it is done
	// training.
	//
	// Note: You should always train an agent prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/es/docs/training).
	RestoreAgent(context.Context, *RestoreAgentRequest) (*longrunningpb.Operation, error)
	// Gets agent validation result. Agent validation is performed during
	// training time and is updated automatically when training is completed.
	GetValidationResult(context.Context, *GetValidationResultRequest) (*ValidationResult, error)
}

// UnimplementedAgentsServer should be embedded to have forward compatible implementations.
type UnimplementedAgentsServer struct {
}

func (UnimplementedAgentsServer) GetAgent(context.Context, *GetAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAgent not implemented")
}
func (UnimplementedAgentsServer) SetAgent(context.Context, *SetAgentRequest) (*Agent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAgent not implemented")
}
func (UnimplementedAgentsServer) DeleteAgent(context.Context, *DeleteAgentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAgent not implemented")
}
func (UnimplementedAgentsServer) SearchAgents(context.Context, *SearchAgentsRequest) (*SearchAgentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAgents not implemented")
}
func (UnimplementedAgentsServer) TrainAgent(context.Context, *TrainAgentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TrainAgent not implemented")
}
func (UnimplementedAgentsServer) ExportAgent(context.Context, *ExportAgentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportAgent not implemented")
}
func (UnimplementedAgentsServer) ImportAgent(context.Context, *ImportAgentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAgent not implemented")
}
func (UnimplementedAgentsServer) RestoreAgent(context.Context, *RestoreAgentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreAgent not implemented")
}
func (UnimplementedAgentsServer) GetValidationResult(context.Context, *GetValidationResultRequest) (*ValidationResult, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetValidationResult not implemented")
}

// UnsafeAgentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AgentsServer will
// result in compilation errors.
type UnsafeAgentsServer interface {
	mustEmbedUnimplementedAgentsServer()
}

func RegisterAgentsServer(s grpc.ServiceRegistrar, srv AgentsServer) {
	s.RegisterService(&Agents_ServiceDesc, srv)
}

func _Agents_GetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_GetAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetAgent(ctx, req.(*GetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_SetAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).SetAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_SetAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).SetAgent(ctx, req.(*SetAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_DeleteAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).DeleteAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_DeleteAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).DeleteAgent(ctx, req.(*DeleteAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_SearchAgents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAgentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).SearchAgents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_SearchAgents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).SearchAgents(ctx, req.(*SearchAgentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_TrainAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TrainAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).TrainAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_TrainAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).TrainAgent(ctx, req.(*TrainAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ExportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ExportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_ExportAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ExportAgent(ctx, req.(*ExportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_ImportAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).ImportAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_ImportAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).ImportAgent(ctx, req.(*ImportAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_RestoreAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).RestoreAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_RestoreAgent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).RestoreAgent(ctx, req.(*RestoreAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Agents_GetValidationResult_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetValidationResultRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentsServer).GetValidationResult(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Agents_GetValidationResult_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentsServer).GetValidationResult(ctx, req.(*GetValidationResultRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Agents_ServiceDesc is the grpc.ServiceDesc for Agents service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Agents_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Agents",
	HandlerType: (*AgentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAgent",
			Handler:    _Agents_GetAgent_Handler,
		},
		{
			MethodName: "SetAgent",
			Handler:    _Agents_SetAgent_Handler,
		},
		{
			MethodName: "DeleteAgent",
			Handler:    _Agents_DeleteAgent_Handler,
		},
		{
			MethodName: "SearchAgents",
			Handler:    _Agents_SearchAgents_Handler,
		},
		{
			MethodName: "TrainAgent",
			Handler:    _Agents_TrainAgent_Handler,
		},
		{
			MethodName: "ExportAgent",
			Handler:    _Agents_ExportAgent_Handler,
		},
		{
			MethodName: "ImportAgent",
			Handler:    _Agents_ImportAgent_Handler,
		},
		{
			MethodName: "RestoreAgent",
			Handler:    _Agents_RestoreAgent_Handler,
		},
		{
			MethodName: "GetValidationResult",
			Handler:    _Agents_GetValidationResult_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/agent.proto",
}
