// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/trace.proto

package cxpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Output state.
type OutputState int32

const (
	// Unspecified output.
	OutputState_OUTPUT_STATE_UNSPECIFIED OutputState = 0
	// Succeeded.
	OutputState_OUTPUT_STATE_OK OutputState = 1
	// Cancelled.
	OutputState_OUTPUT_STATE_CANCELLED OutputState = 2
	// Failed.
	OutputState_OUTPUT_STATE_FAILED OutputState = 3
	// Escalated.
	OutputState_OUTPUT_STATE_ESCALATED OutputState = 4
	// Pending.
	OutputState_OUTPUT_STATE_PENDING OutputState = 5
)

// Enum value maps for OutputState.
var (
	OutputState_name = map[int32]string{
		0: "OUTPUT_STATE_UNSPECIFIED",
		1: "OUTPUT_STATE_OK",
		2: "OUTPUT_STATE_CANCELLED",
		3: "OUTPUT_STATE_FAILED",
		4: "OUTPUT_STATE_ESCALATED",
		5: "OUTPUT_STATE_PENDING",
	}
	OutputState_value = map[string]int32{
		"OUTPUT_STATE_UNSPECIFIED": 0,
		"OUTPUT_STATE_OK":          1,
		"OUTPUT_STATE_CANCELLED":   2,
		"OUTPUT_STATE_FAILED":      3,
		"OUTPUT_STATE_ESCALATED":   4,
		"OUTPUT_STATE_PENDING":     5,
	}
)

func (x OutputState) Enum() *OutputState {
	p := new(OutputState)
	*p = x
	return p
}

func (x OutputState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OutputState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_enumTypes[0].Descriptor()
}

func (OutputState) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_enumTypes[0]
}

func (x OutputState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OutputState.Descriptor instead.
func (OutputState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0}
}

// Retrieval strategy on how the example is selected to be fed to the prompt.
type RetrievalStrategy int32

const (
	// Not specified. `DEFAULT` will be used.
	RetrievalStrategy_RETRIEVAL_STRATEGY_UNSPECIFIED RetrievalStrategy = 0
	// Default retrieval strategy.
	RetrievalStrategy_DEFAULT RetrievalStrategy = 1
	// Static example will always be inserted to the prompt.
	RetrievalStrategy_STATIC RetrievalStrategy = 2
	// Example will never be inserted into the prompt.
	RetrievalStrategy_NEVER RetrievalStrategy = 3
)

// Enum value maps for RetrievalStrategy.
var (
	RetrievalStrategy_name = map[int32]string{
		0: "RETRIEVAL_STRATEGY_UNSPECIFIED",
		1: "DEFAULT",
		2: "STATIC",
		3: "NEVER",
	}
	RetrievalStrategy_value = map[string]int32{
		"RETRIEVAL_STRATEGY_UNSPECIFIED": 0,
		"DEFAULT":                        1,
		"STATIC":                         2,
		"NEVER":                          3,
	}
)

func (x RetrievalStrategy) Enum() *RetrievalStrategy {
	p := new(RetrievalStrategy)
	*p = x
	return p
}

func (x RetrievalStrategy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (RetrievalStrategy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_enumTypes[1].Descriptor()
}

func (RetrievalStrategy) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_enumTypes[1]
}

func (x RetrievalStrategy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use RetrievalStrategy.Descriptor instead.
func (RetrievalStrategy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{1}
}

// Playbook output state.
//
// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/trace.proto.
type PlaybookOutput_State int32

const (
	// Unspecified state.
	PlaybookOutput_STATE_UNSPECIFIED PlaybookOutput_State = 0
	// Playbook succeeded.
	PlaybookOutput_OK PlaybookOutput_State = 1
	// Playbook cancelled.
	PlaybookOutput_CANCELLED PlaybookOutput_State = 2
	// Playbook failed.
	PlaybookOutput_FAILED PlaybookOutput_State = 3
	// Playbook failed due to escalation.
	PlaybookOutput_ESCALATED PlaybookOutput_State = 4
)

// Enum value maps for PlaybookOutput_State.
var (
	PlaybookOutput_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "OK",
		2: "CANCELLED",
		3: "FAILED",
		4: "ESCALATED",
	}
	PlaybookOutput_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"OK":                1,
		"CANCELLED":         2,
		"FAILED":            3,
		"ESCALATED":         4,
	}
)

func (x PlaybookOutput_State) Enum() *PlaybookOutput_State {
	p := new(PlaybookOutput_State)
	*p = x
	return p
}

func (x PlaybookOutput_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PlaybookOutput_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_enumTypes[2].Descriptor()
}

func (PlaybookOutput_State) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_enumTypes[2]
}

func (x PlaybookOutput_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PlaybookOutput_State.Descriptor instead.
func (PlaybookOutput_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{11, 0}
}

// Action performed by end user or Dialogflow agent in the conversation.
type Action struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Action details.
	//
	// Types that are assignable to Action:
	//
	//	*Action_UserUtterance
	//	*Action_Event
	//	*Action_AgentUtterance
	//	*Action_ToolUse
	//	*Action_LlmCall
	//	*Action_IntentMatch_
	//	*Action_FlowStateUpdate_
	//	*Action_PlaybookInvocation
	//	*Action_FlowInvocation
	//	*Action_PlaybookTransition
	//	*Action_FlowTransition
	//	*Action_Tts
	//	*Action_Stt
	Action isAction_Action `protobuf_oneof:"action"`
	// Output only. The display name of the action.
	DisplayName string `protobuf:"bytes,15,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Timestamp of the start of the agent action.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Timestamp of the completion of the agent action.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
	// Optional. The detailed tracing information for sub execution steps of the
	// action.
	SubExecutionSteps []*Span `protobuf:"bytes,11,rep,name=sub_execution_steps,json=subExecutionSteps,proto3" json:"sub_execution_steps,omitempty"`
	// Optional. Output only. The status of the action.
	Status *Status `protobuf:"bytes,16,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *Action) Reset() {
	*x = Action{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action) ProtoMessage() {}

func (x *Action) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action.ProtoReflect.Descriptor instead.
func (*Action) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0}
}

func (m *Action) GetAction() isAction_Action {
	if m != nil {
		return m.Action
	}
	return nil
}

func (x *Action) GetUserUtterance() *UserUtterance {
	if x, ok := x.GetAction().(*Action_UserUtterance); ok {
		return x.UserUtterance
	}
	return nil
}

func (x *Action) GetEvent() *Event {
	if x, ok := x.GetAction().(*Action_Event); ok {
		return x.Event
	}
	return nil
}

func (x *Action) GetAgentUtterance() *AgentUtterance {
	if x, ok := x.GetAction().(*Action_AgentUtterance); ok {
		return x.AgentUtterance
	}
	return nil
}

func (x *Action) GetToolUse() *ToolUse {
	if x, ok := x.GetAction().(*Action_ToolUse); ok {
		return x.ToolUse
	}
	return nil
}

func (x *Action) GetLlmCall() *LlmCall {
	if x, ok := x.GetAction().(*Action_LlmCall); ok {
		return x.LlmCall
	}
	return nil
}

func (x *Action) GetIntentMatch() *Action_IntentMatch {
	if x, ok := x.GetAction().(*Action_IntentMatch_); ok {
		return x.IntentMatch
	}
	return nil
}

func (x *Action) GetFlowStateUpdate() *Action_FlowStateUpdate {
	if x, ok := x.GetAction().(*Action_FlowStateUpdate_); ok {
		return x.FlowStateUpdate
	}
	return nil
}

func (x *Action) GetPlaybookInvocation() *PlaybookInvocation {
	if x, ok := x.GetAction().(*Action_PlaybookInvocation); ok {
		return x.PlaybookInvocation
	}
	return nil
}

func (x *Action) GetFlowInvocation() *FlowInvocation {
	if x, ok := x.GetAction().(*Action_FlowInvocation); ok {
		return x.FlowInvocation
	}
	return nil
}

func (x *Action) GetPlaybookTransition() *PlaybookTransition {
	if x, ok := x.GetAction().(*Action_PlaybookTransition); ok {
		return x.PlaybookTransition
	}
	return nil
}

func (x *Action) GetFlowTransition() *FlowTransition {
	if x, ok := x.GetAction().(*Action_FlowTransition); ok {
		return x.FlowTransition
	}
	return nil
}

func (x *Action) GetTts() *Action_TTS {
	if x, ok := x.GetAction().(*Action_Tts); ok {
		return x.Tts
	}
	return nil
}

func (x *Action) GetStt() *Action_STT {
	if x, ok := x.GetAction().(*Action_Stt); ok {
		return x.Stt
	}
	return nil
}

func (x *Action) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Action) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Action) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

func (x *Action) GetSubExecutionSteps() []*Span {
	if x != nil {
		return x.SubExecutionSteps
	}
	return nil
}

func (x *Action) GetStatus() *Status {
	if x != nil {
		return x.Status
	}
	return nil
}

type isAction_Action interface {
	isAction_Action()
}

type Action_UserUtterance struct {
	// Optional. Agent obtained a message from the customer.
	UserUtterance *UserUtterance `protobuf:"bytes,1,opt,name=user_utterance,json=userUtterance,proto3,oneof"`
}

type Action_Event struct {
	// Optional. The agent received an event from the customer or a system event
	// is emitted.
	Event *Event `protobuf:"bytes,7,opt,name=event,proto3,oneof"`
}

type Action_AgentUtterance struct {
	// Optional. Action performed by the agent as a message.
	AgentUtterance *AgentUtterance `protobuf:"bytes,2,opt,name=agent_utterance,json=agentUtterance,proto3,oneof"`
}

type Action_ToolUse struct {
	// Optional. Action performed on behalf of the agent by calling a plugin
	// tool.
	ToolUse *ToolUse `protobuf:"bytes,3,opt,name=tool_use,json=toolUse,proto3,oneof"`
}

type Action_LlmCall struct {
	// Optional. Output only. LLM call performed by the agent.
	LlmCall *LlmCall `protobuf:"bytes,14,opt,name=llm_call,json=llmCall,proto3,oneof"`
}

type Action_IntentMatch_ struct {
	// Optional. Output only. Intent Match in flows.
	IntentMatch *Action_IntentMatch `protobuf:"bytes,17,opt,name=intent_match,json=intentMatch,proto3,oneof"`
}

type Action_FlowStateUpdate_ struct {
	// Optional. Output only. The state machine update in flows.
	FlowStateUpdate *Action_FlowStateUpdate `protobuf:"bytes,18,opt,name=flow_state_update,json=flowStateUpdate,proto3,oneof"`
}

type Action_PlaybookInvocation struct {
	// Optional. Action performed on behalf of the agent by invoking a child
	// playbook.
	PlaybookInvocation *PlaybookInvocation `protobuf:"bytes,4,opt,name=playbook_invocation,json=playbookInvocation,proto3,oneof"`
}

type Action_FlowInvocation struct {
	// Optional. Action performed on behalf of the agent by invoking a CX flow.
	FlowInvocation *FlowInvocation `protobuf:"bytes,5,opt,name=flow_invocation,json=flowInvocation,proto3,oneof"`
}

type Action_PlaybookTransition struct {
	// Optional. Action performed on behalf of the agent by transitioning to a
	// target playbook.
	PlaybookTransition *PlaybookTransition `protobuf:"bytes,12,opt,name=playbook_transition,json=playbookTransition,proto3,oneof"`
}

type Action_FlowTransition struct {
	// Optional. Action performed on behalf of the agent by transitioning to a
	// target CX flow.
	FlowTransition *FlowTransition `protobuf:"bytes,13,opt,name=flow_transition,json=flowTransition,proto3,oneof"`
}

type Action_Tts struct {
	// Optional. Text-to-speech action performed by the agent.
	Tts *Action_TTS `protobuf:"bytes,19,opt,name=tts,proto3,oneof"`
}

type Action_Stt struct {
	// Optional. Speech-to-text action performed by the agent.
	Stt *Action_STT `protobuf:"bytes,20,opt,name=stt,proto3,oneof"`
}

func (*Action_UserUtterance) isAction_Action() {}

func (*Action_Event) isAction_Action() {}

func (*Action_AgentUtterance) isAction_Action() {}

func (*Action_ToolUse) isAction_Action() {}

func (*Action_LlmCall) isAction_Action() {}

func (*Action_IntentMatch_) isAction_Action() {}

func (*Action_FlowStateUpdate_) isAction_Action() {}

func (*Action_PlaybookInvocation) isAction_Action() {}

func (*Action_FlowInvocation) isAction_Action() {}

func (*Action_PlaybookTransition) isAction_Action() {}

func (*Action_FlowTransition) isAction_Action() {}

func (*Action_Tts) isAction_Action() {}

func (*Action_Stt) isAction_Action() {}

// UserUtterance represents one message sent by the customer.
type UserUtterance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Message content in text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. Tokens of the audio input.
	AudioTokens []int32 `protobuf:"varint,2,rep,packed,name=audio_tokens,json=audioTokens,proto3" json:"audio_tokens,omitempty"`
	// Optional. Audio input.
	Audio []byte `protobuf:"bytes,3,opt,name=audio,proto3" json:"audio,omitempty"`
}

func (x *UserUtterance) Reset() {
	*x = UserUtterance{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UserUtterance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UserUtterance) ProtoMessage() {}

func (x *UserUtterance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UserUtterance.ProtoReflect.Descriptor instead.
func (*UserUtterance) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{1}
}

func (x *UserUtterance) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *UserUtterance) GetAudioTokens() []int32 {
	if x != nil {
		return x.AudioTokens
	}
	return nil
}

func (x *UserUtterance) GetAudio() []byte {
	if x != nil {
		return x.Audio
	}
	return nil
}

// Event represents the event sent by the customer.
type Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the event.
	Event string `protobuf:"bytes,1,opt,name=event,proto3" json:"event,omitempty"`
	// Payload of the event.
	//
	// Types that are assignable to Payload:
	//
	//	*Event_Text
	Payload isEvent_Payload `protobuf_oneof:"payload"`
}

func (x *Event) Reset() {
	*x = Event{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Event) ProtoMessage() {}

func (x *Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Event.ProtoReflect.Descriptor instead.
func (*Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{2}
}

func (x *Event) GetEvent() string {
	if x != nil {
		return x.Event
	}
	return ""
}

func (m *Event) GetPayload() isEvent_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *Event) GetText() string {
	if x, ok := x.GetPayload().(*Event_Text); ok {
		return x.Text
	}
	return ""
}

type isEvent_Payload interface {
	isEvent_Payload()
}

type Event_Text struct {
	// Optional. Unstructured text payload of the event.
	Text string `protobuf:"bytes,2,opt,name=text,proto3,oneof"`
}

func (*Event_Text) isEvent_Payload() {}

// AgentUtterance represents one message sent by the agent.
type AgentUtterance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Message content in text.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. True if the agent utterance needs to be generated by the LLM.
	// Only used in webhook response to differentiate from empty text. Revisit
	// whether we need this field or mark `text` as optional when we expose
	// webhook interface to customer.
	RequireGeneration bool `protobuf:"varint,2,opt,name=require_generation,json=requireGeneration,proto3" json:"require_generation,omitempty"`
}

func (x *AgentUtterance) Reset() {
	*x = AgentUtterance{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AgentUtterance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AgentUtterance) ProtoMessage() {}

func (x *AgentUtterance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AgentUtterance.ProtoReflect.Descriptor instead.
func (*AgentUtterance) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{3}
}

func (x *AgentUtterance) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

func (x *AgentUtterance) GetRequireGeneration() bool {
	if x != nil {
		return x.RequireGeneration
	}
	return false
}

// Stores metadata of the invocation of an action supported by a tool.
type ToolUse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [tool][google.cloud.dialogflow.cx.v3beta1.Tool] that should
	// be used. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/tools/<ToolID>`.
	Tool string `protobuf:"bytes,1,opt,name=tool,proto3" json:"tool,omitempty"`
	// Output only. The display name of the tool.
	DisplayName string `protobuf:"bytes,8,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Name of the action to be called during the tool use.
	Action string `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
	// Optional. A list of input parameters for the action.
	InputActionParameters *structpb.Struct `protobuf:"bytes,5,opt,name=input_action_parameters,json=inputActionParameters,proto3" json:"input_action_parameters,omitempty"`
	// Optional. A list of output parameters generated by the action.
	OutputActionParameters *structpb.Struct `protobuf:"bytes,6,opt,name=output_action_parameters,json=outputActionParameters,proto3" json:"output_action_parameters,omitempty"`
	// The tracing information for different tools.
	//
	// Types that are assignable to ToolTrace:
	//
	//	*ToolUse_DataStoreToolTrace_
	//	*ToolUse_WebhookToolTrace_
	ToolTrace isToolUse_ToolTrace `protobuf_oneof:"ToolTrace"`
}

func (x *ToolUse) Reset() {
	*x = ToolUse{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolUse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolUse) ProtoMessage() {}

func (x *ToolUse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolUse.ProtoReflect.Descriptor instead.
func (*ToolUse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{4}
}

func (x *ToolUse) GetTool() string {
	if x != nil {
		return x.Tool
	}
	return ""
}

func (x *ToolUse) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *ToolUse) GetAction() string {
	if x != nil {
		return x.Action
	}
	return ""
}

func (x *ToolUse) GetInputActionParameters() *structpb.Struct {
	if x != nil {
		return x.InputActionParameters
	}
	return nil
}

func (x *ToolUse) GetOutputActionParameters() *structpb.Struct {
	if x != nil {
		return x.OutputActionParameters
	}
	return nil
}

func (m *ToolUse) GetToolTrace() isToolUse_ToolTrace {
	if m != nil {
		return m.ToolTrace
	}
	return nil
}

func (x *ToolUse) GetDataStoreToolTrace() *ToolUse_DataStoreToolTrace {
	if x, ok := x.GetToolTrace().(*ToolUse_DataStoreToolTrace_); ok {
		return x.DataStoreToolTrace
	}
	return nil
}

func (x *ToolUse) GetWebhookToolTrace() *ToolUse_WebhookToolTrace {
	if x, ok := x.GetToolTrace().(*ToolUse_WebhookToolTrace_); ok {
		return x.WebhookToolTrace
	}
	return nil
}

type isToolUse_ToolTrace interface {
	isToolUse_ToolTrace()
}

type ToolUse_DataStoreToolTrace_ struct {
	// Optional. Data store tool trace.
	DataStoreToolTrace *ToolUse_DataStoreToolTrace `protobuf:"bytes,7,opt,name=data_store_tool_trace,json=dataStoreToolTrace,proto3,oneof"`
}

type ToolUse_WebhookToolTrace_ struct {
	// Optional. Webhook tool trace.
	WebhookToolTrace *ToolUse_WebhookToolTrace `protobuf:"bytes,9,opt,name=webhook_tool_trace,json=webhookToolTrace,proto3,oneof"`
}

func (*ToolUse_DataStoreToolTrace_) isToolUse_ToolTrace() {}

func (*ToolUse_WebhookToolTrace_) isToolUse_ToolTrace() {}

// Stores metadata of the call of an LLM.
type LlmCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of relevant examples used for the LLM prompt.
	RetrievedExamples []*LlmCall_RetrievedExample `protobuf:"bytes,1,rep,name=retrieved_examples,json=retrievedExamples,proto3" json:"retrieved_examples,omitempty"`
	// The token counts of the LLM call.
	TokenCount *LlmCall_TokenCount `protobuf:"bytes,2,opt,name=token_count,json=tokenCount,proto3" json:"token_count,omitempty"`
	// The model of the LLM call.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// The temperature of the LLM call.
	Temperature float32 `protobuf:"fixed32,4,opt,name=temperature,proto3" json:"temperature,omitempty"`
}

func (x *LlmCall) Reset() {
	*x = LlmCall{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LlmCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LlmCall) ProtoMessage() {}

func (x *LlmCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LlmCall.ProtoReflect.Descriptor instead.
func (*LlmCall) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{5}
}

func (x *LlmCall) GetRetrievedExamples() []*LlmCall_RetrievedExample {
	if x != nil {
		return x.RetrievedExamples
	}
	return nil
}

func (x *LlmCall) GetTokenCount() *LlmCall_TokenCount {
	if x != nil {
		return x.TokenCount
	}
	return nil
}

func (x *LlmCall) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *LlmCall) GetTemperature() float32 {
	if x != nil {
		return x.Temperature
	}
	return 0
}

// Stores metadata of the invocation of a child playbook. Playbook invocation
// actions enter the child playbook.
type PlaybookInvocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Playbook string `protobuf:"bytes,1,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// Output only. The display name of the playbook.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Input of the child playbook invocation.
	PlaybookInput *PlaybookInput `protobuf:"bytes,2,opt,name=playbook_input,json=playbookInput,proto3" json:"playbook_input,omitempty"`
	// Optional. Output of the child playbook invocation.
	PlaybookOutput *PlaybookOutput `protobuf:"bytes,3,opt,name=playbook_output,json=playbookOutput,proto3" json:"playbook_output,omitempty"`
	// Required. Playbook invocation's output state.
	PlaybookState OutputState `protobuf:"varint,4,opt,name=playbook_state,json=playbookState,proto3,enum=google.cloud.dialogflow.cx.v3beta1.OutputState" json:"playbook_state,omitempty"`
}

func (x *PlaybookInvocation) Reset() {
	*x = PlaybookInvocation{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookInvocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookInvocation) ProtoMessage() {}

func (x *PlaybookInvocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookInvocation.ProtoReflect.Descriptor instead.
func (*PlaybookInvocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{6}
}

func (x *PlaybookInvocation) GetPlaybook() string {
	if x != nil {
		return x.Playbook
	}
	return ""
}

func (x *PlaybookInvocation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PlaybookInvocation) GetPlaybookInput() *PlaybookInput {
	if x != nil {
		return x.PlaybookInput
	}
	return nil
}

func (x *PlaybookInvocation) GetPlaybookOutput() *PlaybookOutput {
	if x != nil {
		return x.PlaybookOutput
	}
	return nil
}

func (x *PlaybookInvocation) GetPlaybookState() OutputState {
	if x != nil {
		return x.PlaybookState
	}
	return OutputState_OUTPUT_STATE_UNSPECIFIED
}

// Stores metadata of the invocation of a child CX flow. Flow invocation actions
// enter the child flow.
type FlowInvocation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the flow.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<Agentflows/<FlowID>`.
	Flow string `protobuf:"bytes,1,opt,name=flow,proto3" json:"flow,omitempty"`
	// Output only. The display name of the flow.
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. A list of input parameters for the flow.
	InputActionParameters *structpb.Struct `protobuf:"bytes,5,opt,name=input_action_parameters,json=inputActionParameters,proto3" json:"input_action_parameters,omitempty"`
	// Optional. A list of output parameters generated by the flow invocation.
	OutputActionParameters *structpb.Struct `protobuf:"bytes,6,opt,name=output_action_parameters,json=outputActionParameters,proto3" json:"output_action_parameters,omitempty"`
	// Required. Flow invocation's output state.
	FlowState OutputState `protobuf:"varint,4,opt,name=flow_state,json=flowState,proto3,enum=google.cloud.dialogflow.cx.v3beta1.OutputState" json:"flow_state,omitempty"`
}

func (x *FlowInvocation) Reset() {
	*x = FlowInvocation{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowInvocation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowInvocation) ProtoMessage() {}

func (x *FlowInvocation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowInvocation.ProtoReflect.Descriptor instead.
func (*FlowInvocation) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{7}
}

func (x *FlowInvocation) GetFlow() string {
	if x != nil {
		return x.Flow
	}
	return ""
}

func (x *FlowInvocation) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *FlowInvocation) GetInputActionParameters() *structpb.Struct {
	if x != nil {
		return x.InputActionParameters
	}
	return nil
}

func (x *FlowInvocation) GetOutputActionParameters() *structpb.Struct {
	if x != nil {
		return x.OutputActionParameters
	}
	return nil
}

func (x *FlowInvocation) GetFlowState() OutputState {
	if x != nil {
		return x.FlowState
	}
	return OutputState_OUTPUT_STATE_UNSPECIFIED
}

// Stores metadata of the transition to another target playbook. Playbook
// transition actions exit the caller playbook and enter the target playbook.
type PlaybookTransition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the playbook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookID>`.
	Playbook string `protobuf:"bytes,1,opt,name=playbook,proto3" json:"playbook,omitempty"`
	// Output only. The display name of the playbook.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A list of input parameters for the action.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/trace.proto.
	InputActionParameters *structpb.Struct `protobuf:"bytes,2,opt,name=input_action_parameters,json=inputActionParameters,proto3" json:"input_action_parameters,omitempty"`
}

func (x *PlaybookTransition) Reset() {
	*x = PlaybookTransition{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookTransition) ProtoMessage() {}

func (x *PlaybookTransition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookTransition.ProtoReflect.Descriptor instead.
func (*PlaybookTransition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{8}
}

func (x *PlaybookTransition) GetPlaybook() string {
	if x != nil {
		return x.Playbook
	}
	return ""
}

func (x *PlaybookTransition) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/trace.proto.
func (x *PlaybookTransition) GetInputActionParameters() *structpb.Struct {
	if x != nil {
		return x.InputActionParameters
	}
	return nil
}

// Stores metadata of the transition to a target CX flow. Flow transition
// actions exit the caller playbook and enter the child flow.
type FlowTransition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique identifier of the flow.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<Agentflows/<FlowID>`.
	Flow string `protobuf:"bytes,1,opt,name=flow,proto3" json:"flow,omitempty"`
	// Output only. The display name of the flow.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// A list of input parameters for the action.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/trace.proto.
	InputActionParameters *structpb.Struct `protobuf:"bytes,2,opt,name=input_action_parameters,json=inputActionParameters,proto3" json:"input_action_parameters,omitempty"`
}

func (x *FlowTransition) Reset() {
	*x = FlowTransition{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FlowTransition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FlowTransition) ProtoMessage() {}

func (x *FlowTransition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FlowTransition.ProtoReflect.Descriptor instead.
func (*FlowTransition) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{9}
}

func (x *FlowTransition) GetFlow() string {
	if x != nil {
		return x.Flow
	}
	return ""
}

func (x *FlowTransition) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/trace.proto.
func (x *FlowTransition) GetInputActionParameters() *structpb.Struct {
	if x != nil {
		return x.InputActionParameters
	}
	return nil
}

// Input of the playbook.
type PlaybookInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Summary string of the preceding conversation for the child
	// playbook invocation.
	PrecedingConversationSummary string `protobuf:"bytes,1,opt,name=preceding_conversation_summary,json=precedingConversationSummary,proto3" json:"preceding_conversation_summary,omitempty"`
	// Optional. A list of input parameters for the action.
	ActionParameters *structpb.Struct `protobuf:"bytes,3,opt,name=action_parameters,json=actionParameters,proto3" json:"action_parameters,omitempty"`
}

func (x *PlaybookInput) Reset() {
	*x = PlaybookInput{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookInput) ProtoMessage() {}

func (x *PlaybookInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookInput.ProtoReflect.Descriptor instead.
func (*PlaybookInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{10}
}

func (x *PlaybookInput) GetPrecedingConversationSummary() string {
	if x != nil {
		return x.PrecedingConversationSummary
	}
	return ""
}

func (x *PlaybookInput) GetActionParameters() *structpb.Struct {
	if x != nil {
		return x.ActionParameters
	}
	return nil
}

// Output of the playbook.
type PlaybookOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Summary string of the execution result of the child playbook.
	ExecutionSummary string `protobuf:"bytes,1,opt,name=execution_summary,json=executionSummary,proto3" json:"execution_summary,omitempty"`
	// End state of the playbook.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/trace.proto.
	State PlaybookOutput_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.dialogflow.cx.v3beta1.PlaybookOutput_State" json:"state,omitempty"`
	// Optional. A Struct object of output parameters for the action.
	ActionParameters *structpb.Struct `protobuf:"bytes,4,opt,name=action_parameters,json=actionParameters,proto3" json:"action_parameters,omitempty"`
}

func (x *PlaybookOutput) Reset() {
	*x = PlaybookOutput{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PlaybookOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PlaybookOutput) ProtoMessage() {}

func (x *PlaybookOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PlaybookOutput.ProtoReflect.Descriptor instead.
func (*PlaybookOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{11}
}

func (x *PlaybookOutput) GetExecutionSummary() string {
	if x != nil {
		return x.ExecutionSummary
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3beta1/trace.proto.
func (x *PlaybookOutput) GetState() PlaybookOutput_State {
	if x != nil {
		return x.State
	}
	return PlaybookOutput_STATE_UNSPECIFIED
}

func (x *PlaybookOutput) GetActionParameters() *structpb.Struct {
	if x != nil {
		return x.ActionParameters
	}
	return nil
}

// A span represents a sub execution step of an action.
type Span struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the span.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The metadata tags of the span such as span type.
	Tags []string `protobuf:"bytes,2,rep,name=tags,proto3" json:"tags,omitempty"`
	// The unordered collection of metrics in this span.
	Metrics []*NamedMetric `protobuf:"bytes,3,rep,name=metrics,proto3" json:"metrics,omitempty"`
	// Timestamp of the start of the span.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Timestamp of the completion of the span.
	CompleteTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=complete_time,json=completeTime,proto3" json:"complete_time,omitempty"`
}

func (x *Span) Reset() {
	*x = Span{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Span) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Span) ProtoMessage() {}

func (x *Span) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Span.ProtoReflect.Descriptor instead.
func (*Span) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{12}
}

func (x *Span) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Span) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *Span) GetMetrics() []*NamedMetric {
	if x != nil {
		return x.Metrics
	}
	return nil
}

func (x *Span) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *Span) GetCompleteTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CompleteTime
	}
	return nil
}

// A named metric is a metric with name, value and unit.
type NamedMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the metric.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The value of the metric.
	Value *structpb.Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// The unit in which this metric is reported. Follows [The Unified Code for
	// Units of Measure](https://unitsofmeasure.org/ucum.html) standard.
	Unit string `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
}

func (x *NamedMetric) Reset() {
	*x = NamedMetric{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NamedMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NamedMetric) ProtoMessage() {}

func (x *NamedMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NamedMetric.ProtoReflect.Descriptor instead.
func (*NamedMetric) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{13}
}

func (x *NamedMetric) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NamedMetric) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *NamedMetric) GetUnit() string {
	if x != nil {
		return x.Unit
	}
	return ""
}

// The status of the action.
type Status struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The exception thrown during the execution of the action.
	Exception *ExceptionDetail `protobuf:"bytes,1,opt,name=exception,proto3" json:"exception,omitempty"`
}

func (x *Status) Reset() {
	*x = Status{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Status) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Status) ProtoMessage() {}

func (x *Status) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Status.ProtoReflect.Descriptor instead.
func (*Status) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{14}
}

func (x *Status) GetException() *ExceptionDetail {
	if x != nil {
		return x.Exception
	}
	return nil
}

// Exception thrown during the execution of an action.
type ExceptionDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The error message.
	ErrorMessage string `protobuf:"bytes,1,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
}

func (x *ExceptionDetail) Reset() {
	*x = ExceptionDetail{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExceptionDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExceptionDetail) ProtoMessage() {}

func (x *ExceptionDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExceptionDetail.ProtoReflect.Descriptor instead.
func (*ExceptionDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{15}
}

func (x *ExceptionDetail) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

// Stores metadata of the intent match action.
type Action_IntentMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The matched intent.
	MatchedIntents []*Action_IntentMatch_MatchedIntent `protobuf:"bytes,1,rep,name=matched_intents,json=matchedIntents,proto3" json:"matched_intents,omitempty"`
}

func (x *Action_IntentMatch) Reset() {
	*x = Action_IntentMatch{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action_IntentMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_IntentMatch) ProtoMessage() {}

func (x *Action_IntentMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_IntentMatch.ProtoReflect.Descriptor instead.
func (*Action_IntentMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Action_IntentMatch) GetMatchedIntents() []*Action_IntentMatch_MatchedIntent {
	if x != nil {
		return x.MatchedIntents
	}
	return nil
}

// Stores metadata of the state update action, such as a state machine
// execution in flows.
type Action_FlowStateUpdate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the event that triggered the state update.
	EventType string `protobuf:"bytes,1,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// The updated page and flow state.
	PageState *Action_FlowStateUpdate_PageState `protobuf:"bytes,2,opt,name=page_state,json=pageState,proto3" json:"page_state,omitempty"`
	// The updated parameters.
	UpdatedParameters *structpb.Struct `protobuf:"bytes,3,opt,name=updated_parameters,json=updatedParameters,proto3" json:"updated_parameters,omitempty"`
	// The destination of the transition.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/pages/<PageID>`
	// or
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/playbooks/<PlaybookId>`.
	Destination string `protobuf:"bytes,4,opt,name=destination,proto3" json:"destination,omitempty"`
	// The function call to execute.
	FunctionCall *Action_FlowStateUpdate_FunctionCall `protobuf:"bytes,5,opt,name=function_call,json=functionCall,proto3" json:"function_call,omitempty"`
}

func (x *Action_FlowStateUpdate) Reset() {
	*x = Action_FlowStateUpdate{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action_FlowStateUpdate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_FlowStateUpdate) ProtoMessage() {}

func (x *Action_FlowStateUpdate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_FlowStateUpdate.ProtoReflect.Descriptor instead.
func (*Action_FlowStateUpdate) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Action_FlowStateUpdate) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (x *Action_FlowStateUpdate) GetPageState() *Action_FlowStateUpdate_PageState {
	if x != nil {
		return x.PageState
	}
	return nil
}

func (x *Action_FlowStateUpdate) GetUpdatedParameters() *structpb.Struct {
	if x != nil {
		return x.UpdatedParameters
	}
	return nil
}

func (x *Action_FlowStateUpdate) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *Action_FlowStateUpdate) GetFunctionCall() *Action_FlowStateUpdate_FunctionCall {
	if x != nil {
		return x.FunctionCall
	}
	return nil
}

// Stores metadata of the Text-to-Speech action.
type Action_TTS struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_TTS) Reset() {
	*x = Action_TTS{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action_TTS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_TTS) ProtoMessage() {}

func (x *Action_TTS) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_TTS.ProtoReflect.Descriptor instead.
func (*Action_TTS) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0, 2}
}

// Stores metadata of the Speech-to-Text action.
type Action_STT struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Action_STT) Reset() {
	*x = Action_STT{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action_STT) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_STT) ProtoMessage() {}

func (x *Action_STT) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_STT.ProtoReflect.Descriptor instead.
func (*Action_STT) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0, 3}
}

// Stores the matched intent, which is the result of the intent match
// action.
type Action_IntentMatch_MatchedIntent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the matched intent.
	IntentId string `protobuf:"bytes,1,opt,name=intent_id,json=intentId,proto3" json:"intent_id,omitempty"`
	// The display name of the matched intent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The score of the matched intent.
	Score float32 `protobuf:"fixed32,3,opt,name=score,proto3" json:"score,omitempty"`
	// The generative fallback response of the matched intent.
	GenerativeFallback *structpb.Struct `protobuf:"bytes,4,opt,name=generative_fallback,json=generativeFallback,proto3" json:"generative_fallback,omitempty"`
}

func (x *Action_IntentMatch_MatchedIntent) Reset() {
	*x = Action_IntentMatch_MatchedIntent{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action_IntentMatch_MatchedIntent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_IntentMatch_MatchedIntent) ProtoMessage() {}

func (x *Action_IntentMatch_MatchedIntent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_IntentMatch_MatchedIntent.ProtoReflect.Descriptor instead.
func (*Action_IntentMatch_MatchedIntent) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Action_IntentMatch_MatchedIntent) GetIntentId() string {
	if x != nil {
		return x.IntentId
	}
	return ""
}

func (x *Action_IntentMatch_MatchedIntent) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Action_IntentMatch_MatchedIntent) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *Action_IntentMatch_MatchedIntent) GetGenerativeFallback() *structpb.Struct {
	if x != nil {
		return x.GenerativeFallback
	}
	return nil
}

// Stores the state of a page and its flow.
type Action_FlowStateUpdate_PageState struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the page.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/pages/<PageID>`.
	Page string `protobuf:"bytes,1,opt,name=page,proto3" json:"page,omitempty"`
	// The display name of the page.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The status of the page.
	Status string `protobuf:"bytes,3,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *Action_FlowStateUpdate_PageState) Reset() {
	*x = Action_FlowStateUpdate_PageState{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action_FlowStateUpdate_PageState) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_FlowStateUpdate_PageState) ProtoMessage() {}

func (x *Action_FlowStateUpdate_PageState) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_FlowStateUpdate_PageState.ProtoReflect.Descriptor instead.
func (*Action_FlowStateUpdate_PageState) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *Action_FlowStateUpdate_PageState) GetPage() string {
	if x != nil {
		return x.Page
	}
	return ""
}

func (x *Action_FlowStateUpdate_PageState) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Action_FlowStateUpdate_PageState) GetStatus() string {
	if x != nil {
		return x.Status
	}
	return ""
}

// Stores the metadata of a function call to execute.
type Action_FlowStateUpdate_FunctionCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the function call.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *Action_FlowStateUpdate_FunctionCall) Reset() {
	*x = Action_FlowStateUpdate_FunctionCall{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Action_FlowStateUpdate_FunctionCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Action_FlowStateUpdate_FunctionCall) ProtoMessage() {}

func (x *Action_FlowStateUpdate_FunctionCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Action_FlowStateUpdate_FunctionCall.ProtoReflect.Descriptor instead.
func (*Action_FlowStateUpdate_FunctionCall) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{0, 1, 1}
}

func (x *Action_FlowStateUpdate_FunctionCall) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The tracing information for the data store tool.
type ToolUse_DataStoreToolTrace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Data store connection feature output signals.
	DataStoreConnectionSignals *DataStoreConnectionSignals `protobuf:"bytes,1,opt,name=data_store_connection_signals,json=dataStoreConnectionSignals,proto3" json:"data_store_connection_signals,omitempty"`
}

func (x *ToolUse_DataStoreToolTrace) Reset() {
	*x = ToolUse_DataStoreToolTrace{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolUse_DataStoreToolTrace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolUse_DataStoreToolTrace) ProtoMessage() {}

func (x *ToolUse_DataStoreToolTrace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolUse_DataStoreToolTrace.ProtoReflect.Descriptor instead.
func (*ToolUse_DataStoreToolTrace) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ToolUse_DataStoreToolTrace) GetDataStoreConnectionSignals() *DataStoreConnectionSignals {
	if x != nil {
		return x.DataStoreConnectionSignals
	}
	return nil
}

// The tracing information for the webhook tool.
type ToolUse_WebhookToolTrace struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The tag of the webhook.
	WebhookTag string `protobuf:"bytes,1,opt,name=webhook_tag,json=webhookTag,proto3" json:"webhook_tag,omitempty"`
	// Optional. The url of the webhook.
	WebhookUri string `protobuf:"bytes,2,opt,name=webhook_uri,json=webhookUri,proto3" json:"webhook_uri,omitempty"`
}

func (x *ToolUse_WebhookToolTrace) Reset() {
	*x = ToolUse_WebhookToolTrace{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolUse_WebhookToolTrace) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolUse_WebhookToolTrace) ProtoMessage() {}

func (x *ToolUse_WebhookToolTrace) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolUse_WebhookToolTrace.ProtoReflect.Descriptor instead.
func (*ToolUse_WebhookToolTrace) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{4, 1}
}

func (x *ToolUse_WebhookToolTrace) GetWebhookTag() string {
	if x != nil {
		return x.WebhookTag
	}
	return ""
}

func (x *ToolUse_WebhookToolTrace) GetWebhookUri() string {
	if x != nil {
		return x.WebhookUri
	}
	return ""
}

// Relevant example used for the LLM prompt.
type LlmCall_RetrievedExample struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The id of the example.
	ExampleId string `protobuf:"bytes,1,opt,name=example_id,json=exampleId,proto3" json:"example_id,omitempty"`
	// The display name of the example.
	ExampleDisplayName string `protobuf:"bytes,2,opt,name=example_display_name,json=exampleDisplayName,proto3" json:"example_display_name,omitempty"`
	// Retrieval strategy of the example.
	RetrievalStrategy RetrievalStrategy `protobuf:"varint,3,opt,name=retrieval_strategy,json=retrievalStrategy,proto3,enum=google.cloud.dialogflow.cx.v3beta1.RetrievalStrategy" json:"retrieval_strategy,omitempty"`
	// Optional. The matched retrieval label of this LLM call.
	MatchedRetrievalLabel string `protobuf:"bytes,14,opt,name=matched_retrieval_label,json=matchedRetrievalLabel,proto3" json:"matched_retrieval_label,omitempty"`
}

func (x *LlmCall_RetrievedExample) Reset() {
	*x = LlmCall_RetrievedExample{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LlmCall_RetrievedExample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LlmCall_RetrievedExample) ProtoMessage() {}

func (x *LlmCall_RetrievedExample) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LlmCall_RetrievedExample.ProtoReflect.Descriptor instead.
func (*LlmCall_RetrievedExample) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{5, 0}
}

func (x *LlmCall_RetrievedExample) GetExampleId() string {
	if x != nil {
		return x.ExampleId
	}
	return ""
}

func (x *LlmCall_RetrievedExample) GetExampleDisplayName() string {
	if x != nil {
		return x.ExampleDisplayName
	}
	return ""
}

func (x *LlmCall_RetrievedExample) GetRetrievalStrategy() RetrievalStrategy {
	if x != nil {
		return x.RetrievalStrategy
	}
	return RetrievalStrategy_RETRIEVAL_STRATEGY_UNSPECIFIED
}

func (x *LlmCall_RetrievedExample) GetMatchedRetrievalLabel() string {
	if x != nil {
		return x.MatchedRetrievalLabel
	}
	return ""
}

// Stores token counts of the LLM call.
type LlmCall_TokenCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of tokens used for the input to the LLM call.
	TotalInputTokenCount int64 `protobuf:"varint,1,opt,name=total_input_token_count,json=totalInputTokenCount,proto3" json:"total_input_token_count,omitempty"`
	// The number of tokens used for the conversation history in the prompt.
	ConversationContextTokenCount int64 `protobuf:"varint,3,opt,name=conversation_context_token_count,json=conversationContextTokenCount,proto3" json:"conversation_context_token_count,omitempty"`
	// The number of tokens used for the retrieved examples in the prompt.
	ExampleTokenCount int64 `protobuf:"varint,4,opt,name=example_token_count,json=exampleTokenCount,proto3" json:"example_token_count,omitempty"`
	// The total number of tokens used for the output of the LLM call.
	TotalOutputTokenCount int64 `protobuf:"varint,5,opt,name=total_output_token_count,json=totalOutputTokenCount,proto3" json:"total_output_token_count,omitempty"`
}

func (x *LlmCall_TokenCount) Reset() {
	*x = LlmCall_TokenCount{}
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LlmCall_TokenCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LlmCall_TokenCount) ProtoMessage() {}

func (x *LlmCall_TokenCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LlmCall_TokenCount.ProtoReflect.Descriptor instead.
func (*LlmCall_TokenCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP(), []int{5, 1}
}

func (x *LlmCall_TokenCount) GetTotalInputTokenCount() int64 {
	if x != nil {
		return x.TotalInputTokenCount
	}
	return 0
}

func (x *LlmCall_TokenCount) GetConversationContextTokenCount() int64 {
	if x != nil {
		return x.ConversationContextTokenCount
	}
	return 0
}

func (x *LlmCall_TokenCount) GetExampleTokenCount() int64 {
	if x != nil {
		return x.ExampleTokenCount
	}
	return 0
}

func (x *LlmCall_TokenCount) GetTotalOutputTokenCount() int64 {
	if x != nil {
		return x.TotalOutputTokenCount
	}
	return 0
}

var File_google_cloud_dialogflow_cx_v3beta1_trace_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0xd9, 0x12, 0x0a, 0x06, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5f, 0x0a, 0x0e, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x75, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x73, 0x65, 0x72, 0x55, 0x74, 0x74, 0x65,
	0x72, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0d, 0x75, 0x73,
	0x65, 0x72, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x05, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x12, 0x62, 0x0a, 0x0f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x74, 0x74,
	0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x74,
	0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x4d, 0x0a, 0x08, 0x74, 0x6f, 0x6f, 0x6c, 0x5f,
	0x75, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x07, 0x74,
	0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x08, 0x6c, 0x6c, 0x6d, 0x5f, 0x63, 0x61,
	0x6c, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6c,
	0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x07, 0x6c, 0x6c, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x63, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x70, 0x0a,
	0x11, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x42, 0x06, 0xe0, 0x41, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0f,
	0x66, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12,
	0x6e, 0x0a, 0x13, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x6e, 0x76, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x12, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x62, 0x0a, 0x0f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x6c,
	0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x0e, 0x66, 0x6c, 0x6f, 0x77, 0x49, 0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x6e, 0x0a, 0x13, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x12, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0f, 0x66, 0x6c, 0x6f, 0x77, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0e, 0x66, 0x6c, 0x6f, 0x77, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x47, 0x0a, 0x03, 0x74, 0x74, 0x73, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x54, 0x54, 0x53, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x03, 0x74, 0x74, 0x73,
	0x12, 0x47, 0x0a, 0x03, 0x73, 0x74, 0x74, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x54, 0x54, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x03, 0x73, 0x74, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x44, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x13, 0x73, 0x75, 0x62, 0x5f, 0x65,
	0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x75, 0x62, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x65, 0x70, 0x73, 0x12, 0x4a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x1a, 0xae, 0x02, 0x0a, 0x0b, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x12, 0x6d, 0x0a, 0x0f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x2e, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x0e, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x1a, 0xaf, 0x01, 0x0a, 0x0d, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x64,
	0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x48, 0x0a, 0x13, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x66, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52,
	0x12, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x46, 0x61, 0x6c, 0x6c, 0x62,
	0x61, 0x63, 0x6b, 0x1a, 0xed, 0x03, 0x0a, 0x0f, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x63, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x46, 0x0a, 0x12, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x52, 0x11, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x6c, 0x0a, 0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x46, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x61, 0x6c, 0x6c, 0x1a, 0x5a, 0x0a, 0x09, 0x50, 0x61, 0x67, 0x65, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x70, 0x61, 0x67, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x1a,
	0x22, 0x0a, 0x0c, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x1a, 0x05, 0x0a, 0x03, 0x54, 0x54, 0x53, 0x1a, 0x05, 0x0a, 0x03, 0x53, 0x54,
	0x54, 0x42, 0x08, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a, 0x0d, 0x55,
	0x73, 0x65, 0x72, 0x55, 0x74, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x19, 0x0a,
	0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x05, 0x61, 0x75, 0x64, 0x69, 0x6f, 0x22, 0x48, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x12, 0x19, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x22, 0x5d, 0x0a, 0x0e, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x55, 0x74, 0x74, 0x65, 0x72,
	0x61, 0x6e, 0x63, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x32, 0x0a,
	0x12, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11,
	0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xb2, 0x06, 0x0a, 0x07, 0x54, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x12, 0x3a, 0x0a,
	0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x74, 0x6f, 0x6f, 0x6c, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x1b, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x54,
	0x0a, 0x17, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x12, 0x56, 0x0a, 0x18, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x78, 0x0a, 0x15,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x74, 0x6f, 0x6f, 0x6c, 0x5f,
	0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x54, 0x72, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x12, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f,
	0x6c, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x71, 0x0a, 0x12, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f,
	0x6b, 0x5f, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x55, 0x73, 0x65, 0x2e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x6f, 0x6f, 0x6c, 0x54, 0x72, 0x61, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x54, 0x6f, 0x6f, 0x6c, 0x54, 0x72, 0x61, 0x63, 0x65, 0x1a, 0x9d, 0x01, 0x0a, 0x12, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x54, 0x6f, 0x6f, 0x6c, 0x54, 0x72, 0x61, 0x63, 0x65,
	0x12, 0x86, 0x01, 0x0a, 0x1d, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1a, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x1a, 0x5e, 0x0a, 0x10, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x6f, 0x6f, 0x6c, 0x54, 0x72, 0x61, 0x63, 0x65, 0x12, 0x24, 0x0a,
	0x0b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x54, 0x61, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x75,
	0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x77,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x55, 0x72, 0x69, 0x42, 0x0b, 0x0a, 0x09, 0x54, 0x6f, 0x6f,
	0x6c, 0x54, 0x72, 0x61, 0x63, 0x65, 0x22, 0x88, 0x06, 0x0a, 0x07, 0x4c, 0x6c, 0x6d, 0x43, 0x61,
	0x6c, 0x6c, 0x12, 0x6b, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64, 0x5f,
	0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6c, 0x6d, 0x43, 0x61, 0x6c, 0x6c, 0x2e, 0x52, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x65, 0x64, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x11, 0x72, 0x65,
	0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12,
	0x57, 0x0a, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6c, 0x6d, 0x43, 0x61, 0x6c,
	0x6c, 0x2e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0a, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x20,
	0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x1a, 0x86, 0x02, 0x0a, 0x10, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64, 0x45, 0x78,
	0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x78, 0x61, 0x6d, 0x70,
	0x6c, 0x65, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x14, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x12, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x44, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x6c, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x52, 0x11, 0x72, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x3b, 0x0a, 0x17,
	0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x6c, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x15, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x52, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x61, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x1a, 0xf5, 0x01, 0x0a, 0x0a, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x35, 0x0a, 0x17, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x14, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x47, 0x0a, 0x20, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x1d, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x65, 0x78, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x37, 0x0a, 0x18, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e,
	0x74, 0x22, 0xa2, 0x03, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e,
	0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c,
	0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b,
	0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5d, 0x0a, 0x0e, 0x70, 0x6c, 0x61, 0x79,
	0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x60, 0x0a, 0x0f, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x5b, 0x0a, 0x0e, 0x70, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f,
	0x6b, 0x53, 0x74, 0x61, 0x74, 0x65, 0x22, 0xf7, 0x02, 0x0a, 0x0e, 0x46, 0x6c, 0x6f, 0x77, 0x49,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x04, 0x66, 0x6c, 0x6f,
	0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x52,
	0x04, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a,
	0x17, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x15, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x12, 0x56, 0x0a, 0x18, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x16, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x53, 0x0a, 0x0a, 0x66,
	0x6c, 0x6f, 0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x6c, 0x6f, 0x77, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x22, 0xd9, 0x01, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62,
	0x6f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x52, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x12,
	0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x42, 0x02, 0x18, 0x01, 0x52, 0x15, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xc9, 0x01, 0x0a,
	0x0e, 0x46, 0x6c, 0x6f, 0x77, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x3a, 0x0a, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x52, 0x04, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x26, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x53, 0x0a, 0x17, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x02, 0x18,
	0x01, 0x52, 0x15, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xa5, 0x01, 0x0a, 0x0d, 0x50, 0x6c, 0x61,
	0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x49, 0x0a, 0x1e, 0x70, 0x72,
	0x65, 0x63, 0x65, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x69,
	0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x49, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x22, 0xb7, 0x02, 0x0a, 0x0e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f, 0x6f, 0x6b, 0x4f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x12, 0x30, 0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x79, 0x12, 0x52, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x6c, 0x61, 0x79, 0x62, 0x6f,
	0x6f, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x02,
	0x18, 0x01, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x49, 0x0a, 0x11, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x22, 0x54, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4b, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46,
	0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x53, 0x43, 0x41, 0x4c,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x04, 0x1a, 0x02, 0x18, 0x01, 0x22, 0xf5, 0x01, 0x0a, 0x04, 0x53,
	0x70, 0x61, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x49, 0x0a, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x07, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x3f, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0c, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x22, 0x63, 0x0a, 0x0b, 0x4e, 0x61, 0x6d, 0x65, 0x64, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x22, 0x60, 0x0a, 0x06, 0x53, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x12, 0x56, 0x0a, 0x09, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x63, 0x65, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09,
	0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3b, 0x0a, 0x0f, 0x45, 0x78, 0x63,
	0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x28, 0x0a, 0x0d,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2a, 0xab, 0x01, 0x0a, 0x0b, 0x4f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54,
	0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x4f, 0x4b, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x4f, 0x55, 0x54,
	0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x17, 0x0a, 0x13, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x1a,
	0x0a, 0x16, 0x4f, 0x55, 0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x45,
	0x53, 0x43, 0x41, 0x4c, 0x41, 0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x18, 0x0a, 0x14, 0x4f, 0x55,
	0x54, 0x50, 0x55, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x50, 0x45, 0x4e, 0x44, 0x49,
	0x4e, 0x47, 0x10, 0x05, 0x2a, 0x5b, 0x0a, 0x11, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61,
	0x6c, 0x53, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x54,
	0x52, 0x49, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x53, 0x54, 0x52, 0x41, 0x54, 0x45, 0x47, 0x59, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a,
	0x07, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x54,
	0x41, 0x54, 0x49, 0x43, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x4e, 0x45, 0x56, 0x45, 0x52, 0x10,
	0x03, 0x42, 0xc1, 0x01, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0a, 0x54, 0x72,
	0x61, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x36, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x33, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78,
	0x70, 0x62, 0xa2, 0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x43, 0x78, 0x2e, 0x56, 0x33, 0x42, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x26, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescData = file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3beta1_trace_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes = make([]protoimpl.MessageInfo, 27)
var file_google_cloud_dialogflow_cx_v3beta1_trace_proto_goTypes = []any{
	(OutputState)(0),                            // 0: google.cloud.dialogflow.cx.v3beta1.OutputState
	(RetrievalStrategy)(0),                      // 1: google.cloud.dialogflow.cx.v3beta1.RetrievalStrategy
	(PlaybookOutput_State)(0),                   // 2: google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.State
	(*Action)(nil),                              // 3: google.cloud.dialogflow.cx.v3beta1.Action
	(*UserUtterance)(nil),                       // 4: google.cloud.dialogflow.cx.v3beta1.UserUtterance
	(*Event)(nil),                               // 5: google.cloud.dialogflow.cx.v3beta1.Event
	(*AgentUtterance)(nil),                      // 6: google.cloud.dialogflow.cx.v3beta1.AgentUtterance
	(*ToolUse)(nil),                             // 7: google.cloud.dialogflow.cx.v3beta1.ToolUse
	(*LlmCall)(nil),                             // 8: google.cloud.dialogflow.cx.v3beta1.LlmCall
	(*PlaybookInvocation)(nil),                  // 9: google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation
	(*FlowInvocation)(nil),                      // 10: google.cloud.dialogflow.cx.v3beta1.FlowInvocation
	(*PlaybookTransition)(nil),                  // 11: google.cloud.dialogflow.cx.v3beta1.PlaybookTransition
	(*FlowTransition)(nil),                      // 12: google.cloud.dialogflow.cx.v3beta1.FlowTransition
	(*PlaybookInput)(nil),                       // 13: google.cloud.dialogflow.cx.v3beta1.PlaybookInput
	(*PlaybookOutput)(nil),                      // 14: google.cloud.dialogflow.cx.v3beta1.PlaybookOutput
	(*Span)(nil),                                // 15: google.cloud.dialogflow.cx.v3beta1.Span
	(*NamedMetric)(nil),                         // 16: google.cloud.dialogflow.cx.v3beta1.NamedMetric
	(*Status)(nil),                              // 17: google.cloud.dialogflow.cx.v3beta1.Status
	(*ExceptionDetail)(nil),                     // 18: google.cloud.dialogflow.cx.v3beta1.ExceptionDetail
	(*Action_IntentMatch)(nil),                  // 19: google.cloud.dialogflow.cx.v3beta1.Action.IntentMatch
	(*Action_FlowStateUpdate)(nil),              // 20: google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate
	(*Action_TTS)(nil),                          // 21: google.cloud.dialogflow.cx.v3beta1.Action.TTS
	(*Action_STT)(nil),                          // 22: google.cloud.dialogflow.cx.v3beta1.Action.STT
	(*Action_IntentMatch_MatchedIntent)(nil),    // 23: google.cloud.dialogflow.cx.v3beta1.Action.IntentMatch.MatchedIntent
	(*Action_FlowStateUpdate_PageState)(nil),    // 24: google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate.PageState
	(*Action_FlowStateUpdate_FunctionCall)(nil), // 25: google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate.FunctionCall
	(*ToolUse_DataStoreToolTrace)(nil),          // 26: google.cloud.dialogflow.cx.v3beta1.ToolUse.DataStoreToolTrace
	(*ToolUse_WebhookToolTrace)(nil),            // 27: google.cloud.dialogflow.cx.v3beta1.ToolUse.WebhookToolTrace
	(*LlmCall_RetrievedExample)(nil),            // 28: google.cloud.dialogflow.cx.v3beta1.LlmCall.RetrievedExample
	(*LlmCall_TokenCount)(nil),                  // 29: google.cloud.dialogflow.cx.v3beta1.LlmCall.TokenCount
	(*timestamppb.Timestamp)(nil),               // 30: google.protobuf.Timestamp
	(*structpb.Struct)(nil),                     // 31: google.protobuf.Struct
	(*structpb.Value)(nil),                      // 32: google.protobuf.Value
	(*DataStoreConnectionSignals)(nil),          // 33: google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionSignals
}
var file_google_cloud_dialogflow_cx_v3beta1_trace_proto_depIdxs = []int32{
	4,  // 0: google.cloud.dialogflow.cx.v3beta1.Action.user_utterance:type_name -> google.cloud.dialogflow.cx.v3beta1.UserUtterance
	5,  // 1: google.cloud.dialogflow.cx.v3beta1.Action.event:type_name -> google.cloud.dialogflow.cx.v3beta1.Event
	6,  // 2: google.cloud.dialogflow.cx.v3beta1.Action.agent_utterance:type_name -> google.cloud.dialogflow.cx.v3beta1.AgentUtterance
	7,  // 3: google.cloud.dialogflow.cx.v3beta1.Action.tool_use:type_name -> google.cloud.dialogflow.cx.v3beta1.ToolUse
	8,  // 4: google.cloud.dialogflow.cx.v3beta1.Action.llm_call:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmCall
	19, // 5: google.cloud.dialogflow.cx.v3beta1.Action.intent_match:type_name -> google.cloud.dialogflow.cx.v3beta1.Action.IntentMatch
	20, // 6: google.cloud.dialogflow.cx.v3beta1.Action.flow_state_update:type_name -> google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate
	9,  // 7: google.cloud.dialogflow.cx.v3beta1.Action.playbook_invocation:type_name -> google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation
	10, // 8: google.cloud.dialogflow.cx.v3beta1.Action.flow_invocation:type_name -> google.cloud.dialogflow.cx.v3beta1.FlowInvocation
	11, // 9: google.cloud.dialogflow.cx.v3beta1.Action.playbook_transition:type_name -> google.cloud.dialogflow.cx.v3beta1.PlaybookTransition
	12, // 10: google.cloud.dialogflow.cx.v3beta1.Action.flow_transition:type_name -> google.cloud.dialogflow.cx.v3beta1.FlowTransition
	21, // 11: google.cloud.dialogflow.cx.v3beta1.Action.tts:type_name -> google.cloud.dialogflow.cx.v3beta1.Action.TTS
	22, // 12: google.cloud.dialogflow.cx.v3beta1.Action.stt:type_name -> google.cloud.dialogflow.cx.v3beta1.Action.STT
	30, // 13: google.cloud.dialogflow.cx.v3beta1.Action.start_time:type_name -> google.protobuf.Timestamp
	30, // 14: google.cloud.dialogflow.cx.v3beta1.Action.complete_time:type_name -> google.protobuf.Timestamp
	15, // 15: google.cloud.dialogflow.cx.v3beta1.Action.sub_execution_steps:type_name -> google.cloud.dialogflow.cx.v3beta1.Span
	17, // 16: google.cloud.dialogflow.cx.v3beta1.Action.status:type_name -> google.cloud.dialogflow.cx.v3beta1.Status
	31, // 17: google.cloud.dialogflow.cx.v3beta1.ToolUse.input_action_parameters:type_name -> google.protobuf.Struct
	31, // 18: google.cloud.dialogflow.cx.v3beta1.ToolUse.output_action_parameters:type_name -> google.protobuf.Struct
	26, // 19: google.cloud.dialogflow.cx.v3beta1.ToolUse.data_store_tool_trace:type_name -> google.cloud.dialogflow.cx.v3beta1.ToolUse.DataStoreToolTrace
	27, // 20: google.cloud.dialogflow.cx.v3beta1.ToolUse.webhook_tool_trace:type_name -> google.cloud.dialogflow.cx.v3beta1.ToolUse.WebhookToolTrace
	28, // 21: google.cloud.dialogflow.cx.v3beta1.LlmCall.retrieved_examples:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmCall.RetrievedExample
	29, // 22: google.cloud.dialogflow.cx.v3beta1.LlmCall.token_count:type_name -> google.cloud.dialogflow.cx.v3beta1.LlmCall.TokenCount
	13, // 23: google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.playbook_input:type_name -> google.cloud.dialogflow.cx.v3beta1.PlaybookInput
	14, // 24: google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.playbook_output:type_name -> google.cloud.dialogflow.cx.v3beta1.PlaybookOutput
	0,  // 25: google.cloud.dialogflow.cx.v3beta1.PlaybookInvocation.playbook_state:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputState
	31, // 26: google.cloud.dialogflow.cx.v3beta1.FlowInvocation.input_action_parameters:type_name -> google.protobuf.Struct
	31, // 27: google.cloud.dialogflow.cx.v3beta1.FlowInvocation.output_action_parameters:type_name -> google.protobuf.Struct
	0,  // 28: google.cloud.dialogflow.cx.v3beta1.FlowInvocation.flow_state:type_name -> google.cloud.dialogflow.cx.v3beta1.OutputState
	31, // 29: google.cloud.dialogflow.cx.v3beta1.PlaybookTransition.input_action_parameters:type_name -> google.protobuf.Struct
	31, // 30: google.cloud.dialogflow.cx.v3beta1.FlowTransition.input_action_parameters:type_name -> google.protobuf.Struct
	31, // 31: google.cloud.dialogflow.cx.v3beta1.PlaybookInput.action_parameters:type_name -> google.protobuf.Struct
	2,  // 32: google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.state:type_name -> google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.State
	31, // 33: google.cloud.dialogflow.cx.v3beta1.PlaybookOutput.action_parameters:type_name -> google.protobuf.Struct
	16, // 34: google.cloud.dialogflow.cx.v3beta1.Span.metrics:type_name -> google.cloud.dialogflow.cx.v3beta1.NamedMetric
	30, // 35: google.cloud.dialogflow.cx.v3beta1.Span.start_time:type_name -> google.protobuf.Timestamp
	30, // 36: google.cloud.dialogflow.cx.v3beta1.Span.complete_time:type_name -> google.protobuf.Timestamp
	32, // 37: google.cloud.dialogflow.cx.v3beta1.NamedMetric.value:type_name -> google.protobuf.Value
	18, // 38: google.cloud.dialogflow.cx.v3beta1.Status.exception:type_name -> google.cloud.dialogflow.cx.v3beta1.ExceptionDetail
	23, // 39: google.cloud.dialogflow.cx.v3beta1.Action.IntentMatch.matched_intents:type_name -> google.cloud.dialogflow.cx.v3beta1.Action.IntentMatch.MatchedIntent
	24, // 40: google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate.page_state:type_name -> google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate.PageState
	31, // 41: google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate.updated_parameters:type_name -> google.protobuf.Struct
	25, // 42: google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate.function_call:type_name -> google.cloud.dialogflow.cx.v3beta1.Action.FlowStateUpdate.FunctionCall
	31, // 43: google.cloud.dialogflow.cx.v3beta1.Action.IntentMatch.MatchedIntent.generative_fallback:type_name -> google.protobuf.Struct
	33, // 44: google.cloud.dialogflow.cx.v3beta1.ToolUse.DataStoreToolTrace.data_store_connection_signals:type_name -> google.cloud.dialogflow.cx.v3beta1.DataStoreConnectionSignals
	1,  // 45: google.cloud.dialogflow.cx.v3beta1.LlmCall.RetrievedExample.retrieval_strategy:type_name -> google.cloud.dialogflow.cx.v3beta1.RetrievalStrategy
	46, // [46:46] is the sub-list for method output_type
	46, // [46:46] is the sub-list for method input_type
	46, // [46:46] is the sub-list for extension type_name
	46, // [46:46] is the sub-list for extension extendee
	0,  // [0:46] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3beta1_trace_proto_init() }
func file_google_cloud_dialogflow_cx_v3beta1_trace_proto_init() {
	if File_google_cloud_dialogflow_cx_v3beta1_trace_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3beta1_data_store_connection_proto_init()
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[0].OneofWrappers = []any{
		(*Action_UserUtterance)(nil),
		(*Action_Event)(nil),
		(*Action_AgentUtterance)(nil),
		(*Action_ToolUse)(nil),
		(*Action_LlmCall)(nil),
		(*Action_IntentMatch_)(nil),
		(*Action_FlowStateUpdate_)(nil),
		(*Action_PlaybookInvocation)(nil),
		(*Action_FlowInvocation)(nil),
		(*Action_PlaybookTransition)(nil),
		(*Action_FlowTransition)(nil),
		(*Action_Tts)(nil),
		(*Action_Stt)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[2].OneofWrappers = []any{
		(*Event_Text)(nil),
	}
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes[4].OneofWrappers = []any{
		(*ToolUse_DataStoreToolTrace_)(nil),
		(*ToolUse_WebhookToolTrace_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   27,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3beta1_trace_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3beta1_trace_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3beta1_trace_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3beta1_trace_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3beta1_trace_proto = out.File
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3beta1_trace_proto_depIdxs = nil
}
