// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3/intent.proto

package cxpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Intents_ListIntents_FullMethodName   = "/google.cloud.dialogflow.cx.v3.Intents/ListIntents"
	Intents_GetIntent_FullMethodName     = "/google.cloud.dialogflow.cx.v3.Intents/GetIntent"
	Intents_CreateIntent_FullMethodName  = "/google.cloud.dialogflow.cx.v3.Intents/CreateIntent"
	Intents_UpdateIntent_FullMethodName  = "/google.cloud.dialogflow.cx.v3.Intents/UpdateIntent"
	Intents_DeleteIntent_FullMethodName  = "/google.cloud.dialogflow.cx.v3.Intents/DeleteIntent"
	Intents_ImportIntents_FullMethodName = "/google.cloud.dialogflow.cx.v3.Intents/ImportIntents"
	Intents_ExportIntents_FullMethodName = "/google.cloud.dialogflow.cx.v3.Intents/ExportIntents"
)

// IntentsClient is the client API for Intents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type IntentsClient interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Creates an intent in the specified agent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Updates the specified intent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Deletes the specified intent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Imports the specified intents into the agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportIntentsMetadata][google.cloud.dialogflow.cx.v3.ImportIntentsMetadata]
	// - `response`:
	// [ImportIntentsResponse][google.cloud.dialogflow.cx.v3.ImportIntentsResponse]
	ImportIntents(ctx context.Context, in *ImportIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports the selected intents.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ExportIntentsMetadata][google.cloud.dialogflow.cx.v3.ExportIntentsMetadata]
	// - `response`:
	// [ExportIntentsResponse][google.cloud.dialogflow.cx.v3.ExportIntentsResponse]
	ExportIntents(ctx context.Context, in *ExportIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type intentsClient struct {
	cc grpc.ClientConnInterface
}

func NewIntentsClient(cc grpc.ClientConnInterface) IntentsClient {
	return &intentsClient{cc}
}

func (c *intentsClient) ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error) {
	out := new(ListIntentsResponse)
	err := c.cc.Invoke(ctx, Intents_ListIntents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, Intents_GetIntent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, Intents_CreateIntent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, Intents_UpdateIntent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Intents_DeleteIntent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) ImportIntents(ctx context.Context, in *ImportIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Intents_ImportIntents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) ExportIntents(ctx context.Context, in *ExportIntentsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Intents_ExportIntents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IntentsServer is the server API for Intents service.
// All implementations should embed UnimplementedIntentsServer
// for forward compatibility
type IntentsServer interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(context.Context, *GetIntentRequest) (*Intent, error)
	// Creates an intent in the specified agent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error)
	// Updates the specified intent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error)
	// Deletes the specified intent.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeleteIntent(context.Context, *DeleteIntentRequest) (*emptypb.Empty, error)
	// Imports the specified intents into the agent.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ImportIntentsMetadata][google.cloud.dialogflow.cx.v3.ImportIntentsMetadata]
	// - `response`:
	// [ImportIntentsResponse][google.cloud.dialogflow.cx.v3.ImportIntentsResponse]
	ImportIntents(context.Context, *ImportIntentsRequest) (*longrunningpb.Operation, error)
	// Exports the selected intents.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/cx/docs/how/long-running-operation).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [ExportIntentsMetadata][google.cloud.dialogflow.cx.v3.ExportIntentsMetadata]
	// - `response`:
	// [ExportIntentsResponse][google.cloud.dialogflow.cx.v3.ExportIntentsResponse]
	ExportIntents(context.Context, *ExportIntentsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedIntentsServer should be embedded to have forward compatible implementations.
type UnimplementedIntentsServer struct {
}

func (UnimplementedIntentsServer) ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIntents not implemented")
}
func (UnimplementedIntentsServer) GetIntent(context.Context, *GetIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIntent not implemented")
}
func (UnimplementedIntentsServer) CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIntent not implemented")
}
func (UnimplementedIntentsServer) UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateIntent not implemented")
}
func (UnimplementedIntentsServer) DeleteIntent(context.Context, *DeleteIntentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIntent not implemented")
}
func (UnimplementedIntentsServer) ImportIntents(context.Context, *ImportIntentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportIntents not implemented")
}
func (UnimplementedIntentsServer) ExportIntents(context.Context, *ExportIntentsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportIntents not implemented")
}

// UnsafeIntentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to IntentsServer will
// result in compilation errors.
type UnsafeIntentsServer interface {
	mustEmbedUnimplementedIntentsServer()
}

func RegisterIntentsServer(s grpc.ServiceRegistrar, srv IntentsServer) {
	s.RegisterService(&Intents_ServiceDesc, srv)
}

func _Intents_ListIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ListIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Intents_ListIntents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ListIntents(ctx, req.(*ListIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_GetIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).GetIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Intents_GetIntent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).GetIntent(ctx, req.(*GetIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_CreateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).CreateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Intents_CreateIntent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).CreateIntent(ctx, req.(*CreateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_UpdateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).UpdateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Intents_UpdateIntent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).UpdateIntent(ctx, req.(*UpdateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_DeleteIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).DeleteIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Intents_DeleteIntent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).DeleteIntent(ctx, req.(*DeleteIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_ImportIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ImportIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Intents_ImportIntents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ImportIntents(ctx, req.(*ImportIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_ExportIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ExportIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Intents_ExportIntents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ExportIntents(ctx, req.(*ExportIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Intents_ServiceDesc is the grpc.ServiceDesc for Intents service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Intents_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Intents",
	HandlerType: (*IntentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListIntents",
			Handler:    _Intents_ListIntents_Handler,
		},
		{
			MethodName: "GetIntent",
			Handler:    _Intents_GetIntent_Handler,
		},
		{
			MethodName: "CreateIntent",
			Handler:    _Intents_CreateIntent_Handler,
		},
		{
			MethodName: "UpdateIntent",
			Handler:    _Intents_UpdateIntent_Handler,
		},
		{
			MethodName: "DeleteIntent",
			Handler:    _Intents_DeleteIntent_Handler,
		},
		{
			MethodName: "ImportIntents",
			Handler:    _Intents_ImportIntents_Handler,
		},
		{
			MethodName: "ExportIntents",
			Handler:    _Intents_ExportIntents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/intent.proto",
}
