// Code generated by radius-dict-gen. DO NOT EDIT.

package aruba

import (
	"crypto/rand"
	"net"
	"strconv"

	"layeh.com/radius"
	"layeh.com/radius/rfc2865"
)

const (
	_Aruba_VendorID = 14823
)

func _Aruba_AddVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	var vsa radius.Attribute
	vendor := make(radius.Attribute, 2+len(attr))
	vendor[0] = typ
	vendor[1] = byte(len(vendor))
	copy(vendor[2:], attr)
	vsa, err = radius.NewVendorSpecific(_Aruba_VendorID, vendor)
	if err != nil {
		return
	}
	p.Add(rfc2865.VendorSpecific_Type, vsa)
	return
}

func _Aruba_GetsVendor(p *radius.Packet, typ byte) (values []radius.Attribute) {
	for _, avp := range p.Attributes {
		if avp.Type != rfc2865.VendorSpecific_Type {
			continue
		}
		attr := avp.Attribute
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _Aruba_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				values = append(values, vsa[2:int(vsaLen)])
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _Aruba_LookupVendor(p *radius.Packet, typ byte) (attr radius.Attribute, ok bool) {
	for _, avp := range p.Attributes {
		if avp.Type != rfc2865.VendorSpecific_Type {
			continue
		}
		attr := avp.Attribute
		vendorID, vsa, err := radius.VendorSpecific(attr)
		if err != nil || vendorID != _Aruba_VendorID {
			continue
		}
		for len(vsa) >= 3 {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				break
			}
			if vsaTyp == typ {
				return vsa[2:int(vsaLen)], true
			}
			vsa = vsa[int(vsaLen):]
		}
	}
	return
}

func _Aruba_SetVendor(p *radius.Packet, typ byte, attr radius.Attribute) (err error) {
	for i := 0; i < len(p.Attributes); {
		avp := p.Attributes[i]
		if avp.Type != rfc2865.VendorSpecific_Type {
			i++
			continue
		}
		vendorID, vsa, err := radius.VendorSpecific(avp.Attribute)
		if err != nil || vendorID != _Aruba_VendorID {
			i++
			continue
		}
		for j := 0; len(vsa[j:]) >= 3; {
			vsaTyp, vsaLen := vsa[0], vsa[1]
			if int(vsaLen) > len(vsa[j:]) || vsaLen < 3 {
				i++
				break
			}
			if vsaTyp == typ {
				vsa = append(vsa[:j], vsa[j+int(vsaLen):]...)
			}
			j += int(vsaLen)
		}
		if len(vsa) > 0 {
			copy(avp.Attribute[4:], vsa)
			i++
		} else {
			p.Attributes = append(p.Attributes[:i], p.Attributes[i+i:]...)
		}
	}
	return _Aruba_AddVendor(p, typ, attr)
}

func _Aruba_DelVendor(p *radius.Packet, typ byte) {
vsaLoop:
	for i := 0; i < len(p.Attributes); {
		avp := p.Attributes[i]
		if avp.Type != rfc2865.VendorSpecific_Type {
			i++
			continue
		}
		vendorID, vsa, err := radius.VendorSpecific(avp.Attribute)
		if err != nil || vendorID != _Aruba_VendorID {
			i++
			continue
		}
		offset := 0
		for len(vsa[offset:]) >= 3 {
			vsaTyp, vsaLen := vsa[offset], vsa[offset+1]
			if int(vsaLen) > len(vsa) || vsaLen < 3 {
				continue vsaLoop
			}
			if vsaTyp == typ {
				copy(vsa[offset:], vsa[offset+int(vsaLen):])
				vsa = vsa[:len(vsa)-int(vsaLen)]
			} else {
				offset += int(vsaLen)
			}
		}
		if offset == 0 {
			p.Attributes = append(p.Attributes[:i], p.Attributes[i+1:]...)
		} else {
			i++
		}
	}
	return
}

func ArubaUserRole_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 1, a)
}

func ArubaUserRole_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 1, a)
}

func ArubaUserRole_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaUserRole_Lookup(p)
	return
}

func ArubaUserRole_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaUserRole_LookupString(p)
	return
}

func ArubaUserRole_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 1) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaUserRole_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 1) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaUserRole_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 1)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaUserRole_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 1)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaUserRole_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 1, a)
}

func ArubaUserRole_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 1, a)
}

func ArubaUserRole_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 1)
}

type ArubaUserVlan uint32

var ArubaUserVlan_Strings = map[ArubaUserVlan]string{}

func (a ArubaUserVlan) String() string {
	if str, ok := ArubaUserVlan_Strings[a]; ok {
		return str
	}
	return "ArubaUserVlan(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaUserVlan_Add(p *radius.Packet, value ArubaUserVlan) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 2, a)
}

func ArubaUserVlan_Get(p *radius.Packet) (value ArubaUserVlan) {
	value, _ = ArubaUserVlan_Lookup(p)
	return
}

func ArubaUserVlan_Gets(p *radius.Packet) (values []ArubaUserVlan, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 2) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaUserVlan(i))
	}
	return
}

func ArubaUserVlan_Lookup(p *radius.Packet) (value ArubaUserVlan, err error) {
	a, ok := _Aruba_LookupVendor(p, 2)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaUserVlan(i)
	return
}

func ArubaUserVlan_Set(p *radius.Packet, value ArubaUserVlan) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 2, a)
}

func ArubaUserVlan_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 2)
}

type ArubaPrivAdminUser uint32

var ArubaPrivAdminUser_Strings = map[ArubaPrivAdminUser]string{}

func (a ArubaPrivAdminUser) String() string {
	if str, ok := ArubaPrivAdminUser_Strings[a]; ok {
		return str
	}
	return "ArubaPrivAdminUser(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaPrivAdminUser_Add(p *radius.Packet, value ArubaPrivAdminUser) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 3, a)
}

func ArubaPrivAdminUser_Get(p *radius.Packet) (value ArubaPrivAdminUser) {
	value, _ = ArubaPrivAdminUser_Lookup(p)
	return
}

func ArubaPrivAdminUser_Gets(p *radius.Packet) (values []ArubaPrivAdminUser, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 3) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaPrivAdminUser(i))
	}
	return
}

func ArubaPrivAdminUser_Lookup(p *radius.Packet) (value ArubaPrivAdminUser, err error) {
	a, ok := _Aruba_LookupVendor(p, 3)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaPrivAdminUser(i)
	return
}

func ArubaPrivAdminUser_Set(p *radius.Packet, value ArubaPrivAdminUser) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 3, a)
}

func ArubaPrivAdminUser_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 3)
}

func ArubaAdminRole_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 4, a)
}

func ArubaAdminRole_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 4, a)
}

func ArubaAdminRole_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAdminRole_Lookup(p)
	return
}

func ArubaAdminRole_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAdminRole_LookupString(p)
	return
}

func ArubaAdminRole_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 4) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAdminRole_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 4) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAdminRole_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 4)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAdminRole_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 4)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAdminRole_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 4, a)
}

func ArubaAdminRole_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 4, a)
}

func ArubaAdminRole_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 4)
}

func ArubaEssidName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 5, a)
}

func ArubaEssidName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 5, a)
}

func ArubaEssidName_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaEssidName_Lookup(p)
	return
}

func ArubaEssidName_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaEssidName_LookupString(p)
	return
}

func ArubaEssidName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 5) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaEssidName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 5) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaEssidName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 5)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaEssidName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 5)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaEssidName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 5, a)
}

func ArubaEssidName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 5, a)
}

func ArubaEssidName_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 5)
}

func ArubaLocationID_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 6, a)
}

func ArubaLocationID_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 6, a)
}

func ArubaLocationID_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaLocationID_Lookup(p)
	return
}

func ArubaLocationID_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaLocationID_LookupString(p)
	return
}

func ArubaLocationID_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 6) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaLocationID_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 6) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaLocationID_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 6)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaLocationID_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 6)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaLocationID_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 6, a)
}

func ArubaLocationID_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 6, a)
}

func ArubaLocationID_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 6)
}

func ArubaPortIdentifier_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 7, a)
}

func ArubaPortIdentifier_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 7, a)
}

func ArubaPortIdentifier_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaPortIdentifier_Lookup(p)
	return
}

func ArubaPortIdentifier_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaPortIdentifier_LookupString(p)
	return
}

func ArubaPortIdentifier_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 7) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaPortIdentifier_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 7) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaPortIdentifier_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 7)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaPortIdentifier_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 7)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaPortIdentifier_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 7, a)
}

func ArubaPortIdentifier_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 7, a)
}

func ArubaPortIdentifier_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 7)
}

func ArubaMMSUserTemplate_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 8, a)
}

func ArubaMMSUserTemplate_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 8, a)
}

func ArubaMMSUserTemplate_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMMSUserTemplate_Lookup(p)
	return
}

func ArubaMMSUserTemplate_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMMSUserTemplate_LookupString(p)
	return
}

func ArubaMMSUserTemplate_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 8) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMMSUserTemplate_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 8) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMMSUserTemplate_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 8)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMMSUserTemplate_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 8)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMMSUserTemplate_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 8, a)
}

func ArubaMMSUserTemplate_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 8, a)
}

func ArubaMMSUserTemplate_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 8)
}

func ArubaNamedUserVlan_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 9, a)
}

func ArubaNamedUserVlan_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 9, a)
}

func ArubaNamedUserVlan_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaNamedUserVlan_Lookup(p)
	return
}

func ArubaNamedUserVlan_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaNamedUserVlan_LookupString(p)
	return
}

func ArubaNamedUserVlan_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 9) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaNamedUserVlan_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 9) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaNamedUserVlan_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 9)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaNamedUserVlan_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 9)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaNamedUserVlan_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 9, a)
}

func ArubaNamedUserVlan_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 9, a)
}

func ArubaNamedUserVlan_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 9)
}

func ArubaAPGroup_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 10, a)
}

func ArubaAPGroup_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 10, a)
}

func ArubaAPGroup_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAPGroup_Lookup(p)
	return
}

func ArubaAPGroup_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAPGroup_LookupString(p)
	return
}

func ArubaAPGroup_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 10) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAPGroup_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 10) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAPGroup_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 10)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAPGroup_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 10)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAPGroup_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 10, a)
}

func ArubaAPGroup_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 10, a)
}

func ArubaAPGroup_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 10)
}

func ArubaFramedIPv6Address_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 11, a)
}

func ArubaFramedIPv6Address_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 11, a)
}

func ArubaFramedIPv6Address_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaFramedIPv6Address_Lookup(p)
	return
}

func ArubaFramedIPv6Address_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaFramedIPv6Address_LookupString(p)
	return
}

func ArubaFramedIPv6Address_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 11) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaFramedIPv6Address_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 11) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaFramedIPv6Address_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 11)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaFramedIPv6Address_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 11)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaFramedIPv6Address_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 11, a)
}

func ArubaFramedIPv6Address_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 11, a)
}

func ArubaFramedIPv6Address_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 11)
}

func ArubaDeviceType_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 12, a)
}

func ArubaDeviceType_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 12, a)
}

func ArubaDeviceType_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaDeviceType_Lookup(p)
	return
}

func ArubaDeviceType_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaDeviceType_LookupString(p)
	return
}

func ArubaDeviceType_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 12) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaDeviceType_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 12) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaDeviceType_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 12)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaDeviceType_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 12)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaDeviceType_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 12, a)
}

func ArubaDeviceType_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 12, a)
}

func ArubaDeviceType_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 12)
}

type ArubaNoDHCPFingerprint uint32

var ArubaNoDHCPFingerprint_Strings = map[ArubaNoDHCPFingerprint]string{}

func (a ArubaNoDHCPFingerprint) String() string {
	if str, ok := ArubaNoDHCPFingerprint_Strings[a]; ok {
		return str
	}
	return "ArubaNoDHCPFingerprint(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaNoDHCPFingerprint_Add(p *radius.Packet, value ArubaNoDHCPFingerprint) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 14, a)
}

func ArubaNoDHCPFingerprint_Get(p *radius.Packet) (value ArubaNoDHCPFingerprint) {
	value, _ = ArubaNoDHCPFingerprint_Lookup(p)
	return
}

func ArubaNoDHCPFingerprint_Gets(p *radius.Packet) (values []ArubaNoDHCPFingerprint, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 14) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaNoDHCPFingerprint(i))
	}
	return
}

func ArubaNoDHCPFingerprint_Lookup(p *radius.Packet) (value ArubaNoDHCPFingerprint, err error) {
	a, ok := _Aruba_LookupVendor(p, 14)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaNoDHCPFingerprint(i)
	return
}

func ArubaNoDHCPFingerprint_Set(p *radius.Packet, value ArubaNoDHCPFingerprint) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 14, a)
}

func ArubaNoDHCPFingerprint_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 14)
}

func ArubaMdpsDeviceUdid_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 15, a)
}

func ArubaMdpsDeviceUdid_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 15, a)
}

func ArubaMdpsDeviceUdid_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsDeviceUdid_Lookup(p)
	return
}

func ArubaMdpsDeviceUdid_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsDeviceUdid_LookupString(p)
	return
}

func ArubaMdpsDeviceUdid_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 15) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceUdid_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 15) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceUdid_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 15)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsDeviceUdid_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 15)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsDeviceUdid_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 15, a)
}

func ArubaMdpsDeviceUdid_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 15, a)
}

func ArubaMdpsDeviceUdid_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 15)
}

func ArubaMdpsDeviceImei_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 16, a)
}

func ArubaMdpsDeviceImei_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 16, a)
}

func ArubaMdpsDeviceImei_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsDeviceImei_Lookup(p)
	return
}

func ArubaMdpsDeviceImei_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsDeviceImei_LookupString(p)
	return
}

func ArubaMdpsDeviceImei_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 16) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceImei_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 16) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceImei_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 16)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsDeviceImei_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 16)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsDeviceImei_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 16, a)
}

func ArubaMdpsDeviceImei_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 16, a)
}

func ArubaMdpsDeviceImei_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 16)
}

func ArubaMdpsDeviceIccid_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 17, a)
}

func ArubaMdpsDeviceIccid_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 17, a)
}

func ArubaMdpsDeviceIccid_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsDeviceIccid_Lookup(p)
	return
}

func ArubaMdpsDeviceIccid_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsDeviceIccid_LookupString(p)
	return
}

func ArubaMdpsDeviceIccid_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 17) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceIccid_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 17) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceIccid_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 17)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsDeviceIccid_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 17)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsDeviceIccid_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 17, a)
}

func ArubaMdpsDeviceIccid_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 17, a)
}

func ArubaMdpsDeviceIccid_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 17)
}

type ArubaMdpsMaxDevices uint32

var ArubaMdpsMaxDevices_Strings = map[ArubaMdpsMaxDevices]string{}

func (a ArubaMdpsMaxDevices) String() string {
	if str, ok := ArubaMdpsMaxDevices_Strings[a]; ok {
		return str
	}
	return "ArubaMdpsMaxDevices(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaMdpsMaxDevices_Add(p *radius.Packet, value ArubaMdpsMaxDevices) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 18, a)
}

func ArubaMdpsMaxDevices_Get(p *radius.Packet) (value ArubaMdpsMaxDevices) {
	value, _ = ArubaMdpsMaxDevices_Lookup(p)
	return
}

func ArubaMdpsMaxDevices_Gets(p *radius.Packet) (values []ArubaMdpsMaxDevices, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 18) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaMdpsMaxDevices(i))
	}
	return
}

func ArubaMdpsMaxDevices_Lookup(p *radius.Packet) (value ArubaMdpsMaxDevices, err error) {
	a, ok := _Aruba_LookupVendor(p, 18)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaMdpsMaxDevices(i)
	return
}

func ArubaMdpsMaxDevices_Set(p *radius.Packet, value ArubaMdpsMaxDevices) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 18, a)
}

func ArubaMdpsMaxDevices_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 18)
}

func ArubaMdpsDeviceName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 19, a)
}

func ArubaMdpsDeviceName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 19, a)
}

func ArubaMdpsDeviceName_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsDeviceName_Lookup(p)
	return
}

func ArubaMdpsDeviceName_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsDeviceName_LookupString(p)
	return
}

func ArubaMdpsDeviceName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 19) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 19) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 19)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsDeviceName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 19)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsDeviceName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 19, a)
}

func ArubaMdpsDeviceName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 19, a)
}

func ArubaMdpsDeviceName_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 19)
}

func ArubaMdpsDeviceProduct_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 20, a)
}

func ArubaMdpsDeviceProduct_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 20, a)
}

func ArubaMdpsDeviceProduct_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsDeviceProduct_Lookup(p)
	return
}

func ArubaMdpsDeviceProduct_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsDeviceProduct_LookupString(p)
	return
}

func ArubaMdpsDeviceProduct_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 20) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceProduct_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 20) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceProduct_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 20)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsDeviceProduct_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 20)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsDeviceProduct_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 20, a)
}

func ArubaMdpsDeviceProduct_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 20, a)
}

func ArubaMdpsDeviceProduct_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 20)
}

func ArubaMdpsDeviceVersion_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 21, a)
}

func ArubaMdpsDeviceVersion_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 21, a)
}

func ArubaMdpsDeviceVersion_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsDeviceVersion_Lookup(p)
	return
}

func ArubaMdpsDeviceVersion_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsDeviceVersion_LookupString(p)
	return
}

func ArubaMdpsDeviceVersion_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 21) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceVersion_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 21) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceVersion_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 21)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsDeviceVersion_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 21)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsDeviceVersion_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 21, a)
}

func ArubaMdpsDeviceVersion_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 21, a)
}

func ArubaMdpsDeviceVersion_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 21)
}

func ArubaMdpsDeviceSerial_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 22, a)
}

func ArubaMdpsDeviceSerial_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 22, a)
}

func ArubaMdpsDeviceSerial_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsDeviceSerial_Lookup(p)
	return
}

func ArubaMdpsDeviceSerial_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsDeviceSerial_LookupString(p)
	return
}

func ArubaMdpsDeviceSerial_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 22) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceSerial_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 22) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceSerial_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 22)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsDeviceSerial_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 22)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsDeviceSerial_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 22, a)
}

func ArubaMdpsDeviceSerial_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 22, a)
}

func ArubaMdpsDeviceSerial_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 22)
}

func ArubaCPPMRole_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 23, a)
}

func ArubaCPPMRole_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 23, a)
}

func ArubaCPPMRole_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaCPPMRole_Lookup(p)
	return
}

func ArubaCPPMRole_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaCPPMRole_LookupString(p)
	return
}

func ArubaCPPMRole_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 23) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaCPPMRole_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 23) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaCPPMRole_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 23)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaCPPMRole_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 23)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaCPPMRole_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 23, a)
}

func ArubaCPPMRole_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 23, a)
}

func ArubaCPPMRole_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 23)
}

func ArubaAirGroupUserName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 24, a)
}

func ArubaAirGroupUserName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 24, a)
}

func ArubaAirGroupUserName_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAirGroupUserName_Lookup(p)
	return
}

func ArubaAirGroupUserName_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAirGroupUserName_LookupString(p)
	return
}

func ArubaAirGroupUserName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 24) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAirGroupUserName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 24) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAirGroupUserName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 24)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAirGroupUserName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 24)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAirGroupUserName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 24, a)
}

func ArubaAirGroupUserName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 24, a)
}

func ArubaAirGroupUserName_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 24)
}

func ArubaAirGroupSharedUser_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 25, a)
}

func ArubaAirGroupSharedUser_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 25, a)
}

func ArubaAirGroupSharedUser_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAirGroupSharedUser_Lookup(p)
	return
}

func ArubaAirGroupSharedUser_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAirGroupSharedUser_LookupString(p)
	return
}

func ArubaAirGroupSharedUser_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 25) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAirGroupSharedUser_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 25) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAirGroupSharedUser_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 25)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAirGroupSharedUser_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 25)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAirGroupSharedUser_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 25, a)
}

func ArubaAirGroupSharedUser_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 25, a)
}

func ArubaAirGroupSharedUser_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 25)
}

func ArubaAirGroupSharedRole_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 26, a)
}

func ArubaAirGroupSharedRole_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 26, a)
}

func ArubaAirGroupSharedRole_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAirGroupSharedRole_Lookup(p)
	return
}

func ArubaAirGroupSharedRole_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAirGroupSharedRole_LookupString(p)
	return
}

func ArubaAirGroupSharedRole_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 26) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAirGroupSharedRole_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 26) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAirGroupSharedRole_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 26)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAirGroupSharedRole_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 26)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAirGroupSharedRole_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 26, a)
}

func ArubaAirGroupSharedRole_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 26, a)
}

func ArubaAirGroupSharedRole_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 26)
}

type ArubaAirGroupDeviceType uint32

const (
	ArubaAirGroupDeviceType_Value_PersonalDevice ArubaAirGroupDeviceType = 1
	ArubaAirGroupDeviceType_Value_SharedDevice   ArubaAirGroupDeviceType = 2
	ArubaAirGroupDeviceType_Value_DeletedDevice  ArubaAirGroupDeviceType = 3
)

var ArubaAirGroupDeviceType_Strings = map[ArubaAirGroupDeviceType]string{
	ArubaAirGroupDeviceType_Value_PersonalDevice: "Personal-Device",
	ArubaAirGroupDeviceType_Value_SharedDevice:   "Shared-Device",
	ArubaAirGroupDeviceType_Value_DeletedDevice:  "Deleted-Device",
}

func (a ArubaAirGroupDeviceType) String() string {
	if str, ok := ArubaAirGroupDeviceType_Strings[a]; ok {
		return str
	}
	return "ArubaAirGroupDeviceType(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaAirGroupDeviceType_Add(p *radius.Packet, value ArubaAirGroupDeviceType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 27, a)
}

func ArubaAirGroupDeviceType_Get(p *radius.Packet) (value ArubaAirGroupDeviceType) {
	value, _ = ArubaAirGroupDeviceType_Lookup(p)
	return
}

func ArubaAirGroupDeviceType_Gets(p *radius.Packet) (values []ArubaAirGroupDeviceType, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 27) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaAirGroupDeviceType(i))
	}
	return
}

func ArubaAirGroupDeviceType_Lookup(p *radius.Packet) (value ArubaAirGroupDeviceType, err error) {
	a, ok := _Aruba_LookupVendor(p, 27)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaAirGroupDeviceType(i)
	return
}

func ArubaAirGroupDeviceType_Set(p *radius.Packet, value ArubaAirGroupDeviceType) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 27, a)
}

func ArubaAirGroupDeviceType_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 27)
}

func ArubaAuthSurvivability_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 28, a)
}

func ArubaAuthSurvivability_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 28, a)
}

func ArubaAuthSurvivability_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAuthSurvivability_Lookup(p)
	return
}

func ArubaAuthSurvivability_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAuthSurvivability_LookupString(p)
	return
}

func ArubaAuthSurvivability_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 28) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAuthSurvivability_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 28) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAuthSurvivability_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 28)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAuthSurvivability_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 28)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAuthSurvivability_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 28, a)
}

func ArubaAuthSurvivability_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 28, a)
}

func ArubaAuthSurvivability_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 28)
}

func ArubaASUserName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 29, a)
}

func ArubaASUserName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 29, a)
}

func ArubaASUserName_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaASUserName_Lookup(p)
	return
}

func ArubaASUserName_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaASUserName_LookupString(p)
	return
}

func ArubaASUserName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 29) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaASUserName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 29) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaASUserName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 29)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaASUserName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 29)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaASUserName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 29, a)
}

func ArubaASUserName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 29, a)
}

func ArubaASUserName_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 29)
}

func ArubaASCredentialHash_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 30, a)
}

func ArubaASCredentialHash_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 30, a)
}

func ArubaASCredentialHash_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaASCredentialHash_Lookup(p)
	return
}

func ArubaASCredentialHash_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaASCredentialHash_LookupString(p)
	return
}

func ArubaASCredentialHash_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 30) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaASCredentialHash_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 30) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaASCredentialHash_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 30)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaASCredentialHash_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 30)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaASCredentialHash_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 30, a)
}

func ArubaASCredentialHash_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 30, a)
}

func ArubaASCredentialHash_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 30)
}

func ArubaWorkSpaceAppName_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 31, a)
}

func ArubaWorkSpaceAppName_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 31, a)
}

func ArubaWorkSpaceAppName_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaWorkSpaceAppName_Lookup(p)
	return
}

func ArubaWorkSpaceAppName_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaWorkSpaceAppName_LookupString(p)
	return
}

func ArubaWorkSpaceAppName_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 31) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaWorkSpaceAppName_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 31) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaWorkSpaceAppName_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 31)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaWorkSpaceAppName_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 31)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaWorkSpaceAppName_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 31, a)
}

func ArubaWorkSpaceAppName_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 31, a)
}

func ArubaWorkSpaceAppName_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 31)
}

func ArubaMdpsProvisioningSettings_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 32, a)
}

func ArubaMdpsProvisioningSettings_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 32, a)
}

func ArubaMdpsProvisioningSettings_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsProvisioningSettings_Lookup(p)
	return
}

func ArubaMdpsProvisioningSettings_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsProvisioningSettings_LookupString(p)
	return
}

func ArubaMdpsProvisioningSettings_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 32) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsProvisioningSettings_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 32) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsProvisioningSettings_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 32)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsProvisioningSettings_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 32)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsProvisioningSettings_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 32, a)
}

func ArubaMdpsProvisioningSettings_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 32, a)
}

func ArubaMdpsProvisioningSettings_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 32)
}

func ArubaMdpsDeviceProfile_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 33, a)
}

func ArubaMdpsDeviceProfile_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 33, a)
}

func ArubaMdpsDeviceProfile_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaMdpsDeviceProfile_Lookup(p)
	return
}

func ArubaMdpsDeviceProfile_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaMdpsDeviceProfile_LookupString(p)
	return
}

func ArubaMdpsDeviceProfile_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 33) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceProfile_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 33) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMdpsDeviceProfile_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 33)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaMdpsDeviceProfile_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 33)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaMdpsDeviceProfile_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 33, a)
}

func ArubaMdpsDeviceProfile_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 33, a)
}

func ArubaMdpsDeviceProfile_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 33)
}

func ArubaAPIPAddress_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 34, a)
}

func ArubaAPIPAddress_Get(p *radius.Packet) (value net.IP) {
	value, _ = ArubaAPIPAddress_Lookup(p)
	return
}

func ArubaAPIPAddress_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Aruba_GetsVendor(p, 34) {
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAPIPAddress_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Aruba_LookupVendor(p, 34)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func ArubaAPIPAddress_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 34, a)
}

func ArubaAPIPAddress_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 34)
}

func ArubaAirGroupSharedGroup_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 35, a)
}

func ArubaAirGroupSharedGroup_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 35, a)
}

func ArubaAirGroupSharedGroup_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAirGroupSharedGroup_Lookup(p)
	return
}

func ArubaAirGroupSharedGroup_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAirGroupSharedGroup_LookupString(p)
	return
}

func ArubaAirGroupSharedGroup_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 35) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAirGroupSharedGroup_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 35) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAirGroupSharedGroup_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 35)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAirGroupSharedGroup_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 35)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAirGroupSharedGroup_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 35, a)
}

func ArubaAirGroupSharedGroup_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 35, a)
}

func ArubaAirGroupSharedGroup_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 35)
}

func ArubaUserGroup_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 36, a)
}

func ArubaUserGroup_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 36, a)
}

func ArubaUserGroup_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaUserGroup_Lookup(p)
	return
}

func ArubaUserGroup_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaUserGroup_LookupString(p)
	return
}

func ArubaUserGroup_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 36) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaUserGroup_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 36) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaUserGroup_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 36)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaUserGroup_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 36)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaUserGroup_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 36, a)
}

func ArubaUserGroup_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 36, a)
}

func ArubaUserGroup_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 36)
}

func ArubaNetworkSSOToken_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 37, a)
}

func ArubaNetworkSSOToken_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 37, a)
}

func ArubaNetworkSSOToken_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaNetworkSSOToken_Lookup(p)
	return
}

func ArubaNetworkSSOToken_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaNetworkSSOToken_LookupString(p)
	return
}

func ArubaNetworkSSOToken_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 37) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaNetworkSSOToken_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 37) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaNetworkSSOToken_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 37)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaNetworkSSOToken_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 37)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaNetworkSSOToken_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 37, a)
}

func ArubaNetworkSSOToken_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 37, a)
}

func ArubaNetworkSSOToken_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 37)
}

type ArubaAirGroupVersion uint32

const (
	ArubaAirGroupVersion_Value_AirGroupV1 ArubaAirGroupVersion = 1
	ArubaAirGroupVersion_Value_AirGroupV2 ArubaAirGroupVersion = 2
)

var ArubaAirGroupVersion_Strings = map[ArubaAirGroupVersion]string{
	ArubaAirGroupVersion_Value_AirGroupV1: "AirGroup-v1",
	ArubaAirGroupVersion_Value_AirGroupV2: "AirGroup-v2",
}

func (a ArubaAirGroupVersion) String() string {
	if str, ok := ArubaAirGroupVersion_Strings[a]; ok {
		return str
	}
	return "ArubaAirGroupVersion(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaAirGroupVersion_Add(p *radius.Packet, value ArubaAirGroupVersion) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 38, a)
}

func ArubaAirGroupVersion_Get(p *radius.Packet) (value ArubaAirGroupVersion) {
	value, _ = ArubaAirGroupVersion_Lookup(p)
	return
}

func ArubaAirGroupVersion_Gets(p *radius.Packet) (values []ArubaAirGroupVersion, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 38) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaAirGroupVersion(i))
	}
	return
}

func ArubaAirGroupVersion_Lookup(p *radius.Packet) (value ArubaAirGroupVersion, err error) {
	a, ok := _Aruba_LookupVendor(p, 38)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaAirGroupVersion(i)
	return
}

func ArubaAirGroupVersion_Set(p *radius.Packet, value ArubaAirGroupVersion) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 38, a)
}

func ArubaAirGroupVersion_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 38)
}

type ArubaAuthSurvMethod uint32

var ArubaAuthSurvMethod_Strings = map[ArubaAuthSurvMethod]string{}

func (a ArubaAuthSurvMethod) String() string {
	if str, ok := ArubaAuthSurvMethod_Strings[a]; ok {
		return str
	}
	return "ArubaAuthSurvMethod(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaAuthSurvMethod_Add(p *radius.Packet, value ArubaAuthSurvMethod) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 39, a)
}

func ArubaAuthSurvMethod_Get(p *radius.Packet) (value ArubaAuthSurvMethod) {
	value, _ = ArubaAuthSurvMethod_Lookup(p)
	return
}

func ArubaAuthSurvMethod_Gets(p *radius.Packet) (values []ArubaAuthSurvMethod, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 39) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaAuthSurvMethod(i))
	}
	return
}

func ArubaAuthSurvMethod_Lookup(p *radius.Packet) (value ArubaAuthSurvMethod, err error) {
	a, ok := _Aruba_LookupVendor(p, 39)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaAuthSurvMethod(i)
	return
}

func ArubaAuthSurvMethod_Set(p *radius.Packet, value ArubaAuthSurvMethod) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 39, a)
}

func ArubaAuthSurvMethod_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 39)
}

type ArubaPortBounceHost uint32

var ArubaPortBounceHost_Strings = map[ArubaPortBounceHost]string{}

func (a ArubaPortBounceHost) String() string {
	if str, ok := ArubaPortBounceHost_Strings[a]; ok {
		return str
	}
	return "ArubaPortBounceHost(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaPortBounceHost_Add(p *radius.Packet, value ArubaPortBounceHost) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 40, a)
}

func ArubaPortBounceHost_Get(p *radius.Packet) (value ArubaPortBounceHost) {
	value, _ = ArubaPortBounceHost_Lookup(p)
	return
}

func ArubaPortBounceHost_Gets(p *radius.Packet) (values []ArubaPortBounceHost, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 40) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaPortBounceHost(i))
	}
	return
}

func ArubaPortBounceHost_Lookup(p *radius.Packet) (value ArubaPortBounceHost, err error) {
	a, ok := _Aruba_LookupVendor(p, 40)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaPortBounceHost(i)
	return
}

func ArubaPortBounceHost_Set(p *radius.Packet, value ArubaPortBounceHost) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 40, a)
}

func ArubaPortBounceHost_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 40)
}

func ArubaCaleaServerIP_Add(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 41, a)
}

func ArubaCaleaServerIP_Get(p *radius.Packet) (value net.IP) {
	value, _ = ArubaCaleaServerIP_Lookup(p)
	return
}

func ArubaCaleaServerIP_Gets(p *radius.Packet) (values []net.IP, err error) {
	var i net.IP
	for _, attr := range _Aruba_GetsVendor(p, 41) {
		i, err = radius.IPAddr(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaCaleaServerIP_Lookup(p *radius.Packet) (value net.IP, err error) {
	a, ok := _Aruba_LookupVendor(p, 41)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, err = radius.IPAddr(a)
	return
}

func ArubaCaleaServerIP_Set(p *radius.Packet, value net.IP) (err error) {
	var a radius.Attribute
	a, err = radius.NewIPAddr(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 41, a)
}

func ArubaCaleaServerIP_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 41)
}

func ArubaAdminPath_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 42, a)
}

func ArubaAdminPath_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 42, a)
}

func ArubaAdminPath_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAdminPath_Lookup(p)
	return
}

func ArubaAdminPath_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAdminPath_LookupString(p)
	return
}

func ArubaAdminPath_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 42) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAdminPath_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 42) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAdminPath_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 42)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAdminPath_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 42)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAdminPath_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 42, a)
}

func ArubaAdminPath_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 42, a)
}

func ArubaAdminPath_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 42)
}

func ArubaCaptivePortalURL_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 43, a)
}

func ArubaCaptivePortalURL_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 43, a)
}

func ArubaCaptivePortalURL_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaCaptivePortalURL_Lookup(p)
	return
}

func ArubaCaptivePortalURL_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaCaptivePortalURL_LookupString(p)
	return
}

func ArubaCaptivePortalURL_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 43) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaCaptivePortalURL_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 43) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaCaptivePortalURL_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 43)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaCaptivePortalURL_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 43)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaCaptivePortalURL_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 43, a)
}

func ArubaCaptivePortalURL_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 43, a)
}

func ArubaCaptivePortalURL_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 43)
}

func ArubaMPSKPassphrase_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword(value, salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 44, a)
}

func ArubaMPSKPassphrase_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword([]byte(value), salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 44, a)
}

func ArubaMPSKPassphrase_Get(p, q *radius.Packet) (value []byte) {
	value, _ = ArubaMPSKPassphrase_Lookup(p, q)
	return
}

func ArubaMPSKPassphrase_GetString(p, q *radius.Packet) (value string) {
	value, _ = ArubaMPSKPassphrase_LookupString(p, q)
	return
}

func ArubaMPSKPassphrase_Gets(p, q *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 44) {
		i, _, err = radius.TunnelPassword(attr, p.Secret, q.Authenticator[:])
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMPSKPassphrase_GetStrings(p, q *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 44) {
		var up []byte
		up, _, err = radius.TunnelPassword(attr, p.Secret, q.Authenticator[:])
		if err == nil {
			i = string(up)
		}
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaMPSKPassphrase_Lookup(p, q *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 44)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value, _, err = radius.TunnelPassword(a, p.Secret, q.Authenticator[:])
	return
}

func ArubaMPSKPassphrase_LookupString(p, q *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 44)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var b []byte
	b, _, err = radius.TunnelPassword(a, p.Secret, q.Authenticator[:])
	if err == nil {
		value = string(b)
	}
	return
}

func ArubaMPSKPassphrase_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword(value, salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 44, a)
}

func ArubaMPSKPassphrase_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	var salt [2]byte
	_, err = rand.Read(salt[:])
	if err != nil {
		return
	}
	salt[0] |= 1 << 7
	a, err = radius.NewTunnelPassword([]byte(value), salt[:], p.Secret, p.Authenticator[:])
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 44, a)
}

func ArubaMPSKPassphrase_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 44)
}

func ArubaACLServerQueryInfo_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 45, a)
}

func ArubaACLServerQueryInfo_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 45, a)
}

func ArubaACLServerQueryInfo_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaACLServerQueryInfo_Lookup(p)
	return
}

func ArubaACLServerQueryInfo_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaACLServerQueryInfo_LookupString(p)
	return
}

func ArubaACLServerQueryInfo_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 45) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaACLServerQueryInfo_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 45) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaACLServerQueryInfo_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 45)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaACLServerQueryInfo_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 45)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaACLServerQueryInfo_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 45, a)
}

func ArubaACLServerQueryInfo_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 45, a)
}

func ArubaACLServerQueryInfo_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 45)
}

func ArubaCommandString_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 46, a)
}

func ArubaCommandString_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 46, a)
}

func ArubaCommandString_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaCommandString_Lookup(p)
	return
}

func ArubaCommandString_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaCommandString_LookupString(p)
	return
}

func ArubaCommandString_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 46) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaCommandString_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 46) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaCommandString_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 46)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaCommandString_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 46)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaCommandString_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 46, a)
}

func ArubaCommandString_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 46, a)
}

func ArubaCommandString_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 46)
}

func ArubaNetworkProfile_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 47, a)
}

func ArubaNetworkProfile_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 47, a)
}

func ArubaNetworkProfile_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaNetworkProfile_Lookup(p)
	return
}

func ArubaNetworkProfile_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaNetworkProfile_LookupString(p)
	return
}

func ArubaNetworkProfile_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 47) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaNetworkProfile_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 47) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaNetworkProfile_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 47)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaNetworkProfile_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 47)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaNetworkProfile_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 47, a)
}

func ArubaNetworkProfile_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 47, a)
}

func ArubaNetworkProfile_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 47)
}

func ArubaAdminDeviceGroup_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 48, a)
}

func ArubaAdminDeviceGroup_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 48, a)
}

func ArubaAdminDeviceGroup_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaAdminDeviceGroup_Lookup(p)
	return
}

func ArubaAdminDeviceGroup_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaAdminDeviceGroup_LookupString(p)
	return
}

func ArubaAdminDeviceGroup_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 48) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAdminDeviceGroup_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 48) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaAdminDeviceGroup_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 48)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaAdminDeviceGroup_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 48)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaAdminDeviceGroup_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 48, a)
}

func ArubaAdminDeviceGroup_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 48, a)
}

func ArubaAdminDeviceGroup_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 48)
}

type ArubaPoEPriority uint32

const (
	ArubaPoEPriority_Value_Critical ArubaPoEPriority = 0
	ArubaPoEPriority_Value_High     ArubaPoEPriority = 1
	ArubaPoEPriority_Value_Low      ArubaPoEPriority = 2
)

var ArubaPoEPriority_Strings = map[ArubaPoEPriority]string{
	ArubaPoEPriority_Value_Critical: "Critical",
	ArubaPoEPriority_Value_High:     "High",
	ArubaPoEPriority_Value_Low:      "Low",
}

func (a ArubaPoEPriority) String() string {
	if str, ok := ArubaPoEPriority_Strings[a]; ok {
		return str
	}
	return "ArubaPoEPriority(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaPoEPriority_Add(p *radius.Packet, value ArubaPoEPriority) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 49, a)
}

func ArubaPoEPriority_Get(p *radius.Packet) (value ArubaPoEPriority) {
	value, _ = ArubaPoEPriority_Lookup(p)
	return
}

func ArubaPoEPriority_Gets(p *radius.Packet) (values []ArubaPoEPriority, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 49) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaPoEPriority(i))
	}
	return
}

func ArubaPoEPriority_Lookup(p *radius.Packet) (value ArubaPoEPriority, err error) {
	a, ok := _Aruba_LookupVendor(p, 49)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaPoEPriority(i)
	return
}

func ArubaPoEPriority_Set(p *radius.Packet, value ArubaPoEPriority) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 49, a)
}

func ArubaPoEPriority_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 49)
}

type ArubaPortAuthMode uint32

const (
	ArubaPortAuthMode_Value_InfrastructureMode ArubaPortAuthMode = 1
	ArubaPortAuthMode_Value_ClientMode         ArubaPortAuthMode = 2
)

var ArubaPortAuthMode_Strings = map[ArubaPortAuthMode]string{
	ArubaPortAuthMode_Value_InfrastructureMode: "Infrastructure-Mode",
	ArubaPortAuthMode_Value_ClientMode:         "Client-Mode",
}

func (a ArubaPortAuthMode) String() string {
	if str, ok := ArubaPortAuthMode_Strings[a]; ok {
		return str
	}
	return "ArubaPortAuthMode(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaPortAuthMode_Add(p *radius.Packet, value ArubaPortAuthMode) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 50, a)
}

func ArubaPortAuthMode_Get(p *radius.Packet) (value ArubaPortAuthMode) {
	value, _ = ArubaPortAuthMode_Lookup(p)
	return
}

func ArubaPortAuthMode_Gets(p *radius.Packet) (values []ArubaPortAuthMode, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 50) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaPortAuthMode(i))
	}
	return
}

func ArubaPortAuthMode_Lookup(p *radius.Packet) (value ArubaPortAuthMode, err error) {
	a, ok := _Aruba_LookupVendor(p, 50)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaPortAuthMode(i)
	return
}

func ArubaPortAuthMode_Set(p *radius.Packet, value ArubaPortAuthMode) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 50, a)
}

func ArubaPortAuthMode_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 50)
}

func ArubaNASFilterRule_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 51, a)
}

func ArubaNASFilterRule_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 51, a)
}

func ArubaNASFilterRule_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaNASFilterRule_Lookup(p)
	return
}

func ArubaNASFilterRule_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaNASFilterRule_LookupString(p)
	return
}

func ArubaNASFilterRule_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 51) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaNASFilterRule_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 51) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaNASFilterRule_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 51)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaNASFilterRule_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 51)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaNASFilterRule_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 51, a)
}

func ArubaNASFilterRule_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 51, a)
}

func ArubaNASFilterRule_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 51)
}

type ArubaQoSTrustMode uint32

const (
	ArubaQoSTrustMode_Value_DSCP ArubaQoSTrustMode = 0
	ArubaQoSTrustMode_Value_QoS  ArubaQoSTrustMode = 1
	ArubaQoSTrustMode_Value_None ArubaQoSTrustMode = 2
)

var ArubaQoSTrustMode_Strings = map[ArubaQoSTrustMode]string{
	ArubaQoSTrustMode_Value_DSCP: "DSCP",
	ArubaQoSTrustMode_Value_QoS:  "QoS",
	ArubaQoSTrustMode_Value_None: "None",
}

func (a ArubaQoSTrustMode) String() string {
	if str, ok := ArubaQoSTrustMode_Strings[a]; ok {
		return str
	}
	return "ArubaQoSTrustMode(" + strconv.FormatUint(uint64(a), 10) + ")"
}

func ArubaQoSTrustMode_Add(p *radius.Packet, value ArubaQoSTrustMode) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_AddVendor(p, 52, a)
}

func ArubaQoSTrustMode_Get(p *radius.Packet) (value ArubaQoSTrustMode) {
	value, _ = ArubaQoSTrustMode_Lookup(p)
	return
}

func ArubaQoSTrustMode_Gets(p *radius.Packet) (values []ArubaQoSTrustMode, err error) {
	var i uint32
	for _, attr := range _Aruba_GetsVendor(p, 52) {
		i, err = radius.Integer(attr)
		if err != nil {
			return
		}
		values = append(values, ArubaQoSTrustMode(i))
	}
	return
}

func ArubaQoSTrustMode_Lookup(p *radius.Packet) (value ArubaQoSTrustMode, err error) {
	a, ok := _Aruba_LookupVendor(p, 52)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	var i uint32
	i, err = radius.Integer(a)
	if err != nil {
		return
	}
	value = ArubaQoSTrustMode(i)
	return
}

func ArubaQoSTrustMode_Set(p *radius.Packet, value ArubaQoSTrustMode) (err error) {
	a := radius.NewInteger(uint32(value))
	return _Aruba_SetVendor(p, 52, a)
}

func ArubaQoSTrustMode_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 52)
}

func ArubaUBTGatewayRole_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 53, a)
}

func ArubaUBTGatewayRole_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 53, a)
}

func ArubaUBTGatewayRole_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaUBTGatewayRole_Lookup(p)
	return
}

func ArubaUBTGatewayRole_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaUBTGatewayRole_LookupString(p)
	return
}

func ArubaUBTGatewayRole_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 53) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaUBTGatewayRole_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 53) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaUBTGatewayRole_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 53)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaUBTGatewayRole_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 53)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaUBTGatewayRole_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 53, a)
}

func ArubaUBTGatewayRole_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 53, a)
}

func ArubaUBTGatewayRole_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 53)
}

func ArubaGatewayZone_Add(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 54, a)
}

func ArubaGatewayZone_AddString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_AddVendor(p, 54, a)
}

func ArubaGatewayZone_Get(p *radius.Packet) (value []byte) {
	value, _ = ArubaGatewayZone_Lookup(p)
	return
}

func ArubaGatewayZone_GetString(p *radius.Packet) (value string) {
	value, _ = ArubaGatewayZone_LookupString(p)
	return
}

func ArubaGatewayZone_Gets(p *radius.Packet) (values [][]byte, err error) {
	var i []byte
	for _, attr := range _Aruba_GetsVendor(p, 54) {
		i = radius.Bytes(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaGatewayZone_GetStrings(p *radius.Packet) (values []string, err error) {
	var i string
	for _, attr := range _Aruba_GetsVendor(p, 54) {
		i = radius.String(attr)
		if err != nil {
			return
		}
		values = append(values, i)
	}
	return
}

func ArubaGatewayZone_Lookup(p *radius.Packet) (value []byte, err error) {
	a, ok := _Aruba_LookupVendor(p, 54)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.Bytes(a)
	return
}

func ArubaGatewayZone_LookupString(p *radius.Packet) (value string, err error) {
	a, ok := _Aruba_LookupVendor(p, 54)
	if !ok {
		err = radius.ErrNoAttribute
		return
	}
	value = radius.String(a)
	return
}

func ArubaGatewayZone_Set(p *radius.Packet, value []byte) (err error) {
	var a radius.Attribute
	a, err = radius.NewBytes(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 54, a)
}

func ArubaGatewayZone_SetString(p *radius.Packet, value string) (err error) {
	var a radius.Attribute
	a, err = radius.NewString(value)
	if err != nil {
		return
	}
	return _Aruba_SetVendor(p, 54, a)
}

func ArubaGatewayZone_Del(p *radius.Packet) {
	_Aruba_DelVendor(p, 54)
}
