/*
 * Npcf_PolicyAuthorization Service API
 *
 * This is the Policy Authorization Service
 *
 * API version: 1.0.1
 * Generated by: OpenAPI Generator (https://openapi-generator.tech)
 */

package Npcf_PolicyAuthorization

import (
	"crypto/tls"
	"net/http"

	"golang.org/x/net/http2"
)

// APIClient manages communication with the Npcf_PolicyAuthorization Service API API v1.0.1
// In most cases there should be only one, shared, APIClient.
type APIClient struct {
	cfg    *Configuration
	common service // Reuse a single struct instead of allocating one for each service on the heap.

	// API Services
	ApplicationSessionsCollectionApi               *ApplicationSessionsCollectionApiService
	EventsSubscriptionDocumentApi                  *EventsSubscriptionDocumentApiService
	IndividualApplicationSessionContextDocumentApi *IndividualApplicationSessionContextDocumentApiService
	PolicyAuthorizationEventNotificationApi        *PolicyAuthorizationEventNotificationApiService
	PolicyAuthorizationTerminateRequestApi         *PolicyAuthorizationTerminateRequestApiService
}

type service struct {
	client *APIClient
}

// NewAPIClient creates a new API client. Requires a userAgent string describing your application.
// optionally a custom http.Client to allow for advanced features such as caching.
func NewAPIClient(cfg *Configuration) *APIClient {
	if cfg.httpClient == nil {
		cfg.httpClient = http.DefaultClient
		cfg.httpClient.Transport = &http2.Transport{
			TLSClientConfig: &tls.Config{InsecureSkipVerify: true},
		}
	}

	c := &APIClient{}
	c.cfg = cfg
	c.common.client = c

	// API Services
	c.ApplicationSessionsCollectionApi = (*ApplicationSessionsCollectionApiService)(&c.common)
	c.EventsSubscriptionDocumentApi = (*EventsSubscriptionDocumentApiService)(&c.common)
	c.IndividualApplicationSessionContextDocumentApi = (*IndividualApplicationSessionContextDocumentApiService)(&c.common)
	c.PolicyAuthorizationEventNotificationApi = (*PolicyAuthorizationEventNotificationApiService)(&c.common)
	c.PolicyAuthorizationTerminateRequestApi = (*PolicyAuthorizationTerminateRequestApiService)(&c.common)
	return c
}
