// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/iam/v2/policy.proto

package iampb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Policies_ListPolicies_FullMethodName = "/google.iam.v2.Policies/ListPolicies"
	Policies_GetPolicy_FullMethodName    = "/google.iam.v2.Policies/GetPolicy"
	Policies_CreatePolicy_FullMethodName = "/google.iam.v2.Policies/CreatePolicy"
	Policies_UpdatePolicy_FullMethodName = "/google.iam.v2.Policies/UpdatePolicy"
	Policies_DeletePolicy_FullMethodName = "/google.iam.v2.Policies/DeletePolicy"
)

// PoliciesClient is the client API for Policies service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PoliciesClient interface {
	// Retrieves the policies of the specified kind that are attached to a
	// resource.
	//
	// The response lists only policy metadata. In particular, policy rules are
	// omitted.
	ListPolicies(ctx context.Context, in *ListPoliciesRequest, opts ...grpc.CallOption) (*ListPoliciesResponse, error)
	// Gets a policy.
	GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a policy.
	CreatePolicy(ctx context.Context, in *CreatePolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the specified policy.
	//
	// You can update only the rules and the display name for the policy.
	//
	// To update a policy, you should use a read-modify-write loop:
	//
	// 1. Use [GetPolicy][google.iam.v2.Policies.GetPolicy] to read the current version of the policy.
	// 2. Modify the policy as needed.
	// 3. Use `UpdatePolicy` to write the updated policy.
	//
	// This pattern helps prevent conflicts between concurrent updates.
	UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a policy. This action is permanent.
	DeletePolicy(ctx context.Context, in *DeletePolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type policiesClient struct {
	cc grpc.ClientConnInterface
}

func NewPoliciesClient(cc grpc.ClientConnInterface) PoliciesClient {
	return &policiesClient{cc}
}

func (c *policiesClient) ListPolicies(ctx context.Context, in *ListPoliciesRequest, opts ...grpc.CallOption) (*ListPoliciesResponse, error) {
	out := new(ListPoliciesResponse)
	err := c.cc.Invoke(ctx, Policies_ListPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policiesClient) GetPolicy(ctx context.Context, in *GetPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Policies_GetPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policiesClient) CreatePolicy(ctx context.Context, in *CreatePolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Policies_CreatePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policiesClient) UpdatePolicy(ctx context.Context, in *UpdatePolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Policies_UpdatePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *policiesClient) DeletePolicy(ctx context.Context, in *DeletePolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Policies_DeletePolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PoliciesServer is the server API for Policies service.
// All implementations should embed UnimplementedPoliciesServer
// for forward compatibility
type PoliciesServer interface {
	// Retrieves the policies of the specified kind that are attached to a
	// resource.
	//
	// The response lists only policy metadata. In particular, policy rules are
	// omitted.
	ListPolicies(context.Context, *ListPoliciesRequest) (*ListPoliciesResponse, error)
	// Gets a policy.
	GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error)
	// Creates a policy.
	CreatePolicy(context.Context, *CreatePolicyRequest) (*longrunningpb.Operation, error)
	// Updates the specified policy.
	//
	// You can update only the rules and the display name for the policy.
	//
	// To update a policy, you should use a read-modify-write loop:
	//
	// 1. Use [GetPolicy][google.iam.v2.Policies.GetPolicy] to read the current version of the policy.
	// 2. Modify the policy as needed.
	// 3. Use `UpdatePolicy` to write the updated policy.
	//
	// This pattern helps prevent conflicts between concurrent updates.
	UpdatePolicy(context.Context, *UpdatePolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a policy. This action is permanent.
	DeletePolicy(context.Context, *DeletePolicyRequest) (*longrunningpb.Operation, error)
}

// UnimplementedPoliciesServer should be embedded to have forward compatible implementations.
type UnimplementedPoliciesServer struct {
}

func (UnimplementedPoliciesServer) ListPolicies(context.Context, *ListPoliciesRequest) (*ListPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPolicies not implemented")
}
func (UnimplementedPoliciesServer) GetPolicy(context.Context, *GetPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPolicy not implemented")
}
func (UnimplementedPoliciesServer) CreatePolicy(context.Context, *CreatePolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePolicy not implemented")
}
func (UnimplementedPoliciesServer) UpdatePolicy(context.Context, *UpdatePolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePolicy not implemented")
}
func (UnimplementedPoliciesServer) DeletePolicy(context.Context, *DeletePolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePolicy not implemented")
}

// UnsafePoliciesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PoliciesServer will
// result in compilation errors.
type UnsafePoliciesServer interface {
	mustEmbedUnimplementedPoliciesServer()
}

func RegisterPoliciesServer(s grpc.ServiceRegistrar, srv PoliciesServer) {
	s.RegisterService(&Policies_ServiceDesc, srv)
}

func _Policies_ListPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PoliciesServer).ListPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Policies_ListPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PoliciesServer).ListPolicies(ctx, req.(*ListPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Policies_GetPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PoliciesServer).GetPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Policies_GetPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PoliciesServer).GetPolicy(ctx, req.(*GetPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Policies_CreatePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PoliciesServer).CreatePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Policies_CreatePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PoliciesServer).CreatePolicy(ctx, req.(*CreatePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Policies_UpdatePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PoliciesServer).UpdatePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Policies_UpdatePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PoliciesServer).UpdatePolicy(ctx, req.(*UpdatePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Policies_DeletePolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PoliciesServer).DeletePolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Policies_DeletePolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PoliciesServer).DeletePolicy(ctx, req.(*DeletePolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Policies_ServiceDesc is the grpc.ServiceDesc for Policies service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Policies_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.v2.Policies",
	HandlerType: (*PoliciesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPolicies",
			Handler:    _Policies_ListPolicies_Handler,
		},
		{
			MethodName: "GetPolicy",
			Handler:    _Policies_GetPolicy_Handler,
		},
		{
			MethodName: "CreatePolicy",
			Handler:    _Policies_CreatePolicy_Handler,
		},
		{
			MethodName: "UpdatePolicy",
			Handler:    _Policies_UpdatePolicy_Handler,
		},
		{
			MethodName: "DeletePolicy",
			Handler:    _Policies_DeletePolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/v2/policy.proto",
}
