// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/content.proto

package aiplatformpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Harm categories that will block the content.
type HarmCategory int32

const (
	// The harm category is unspecified.
	HarmCategory_HARM_CATEGORY_UNSPECIFIED HarmCategory = 0
	// The harm category is hate speech.
	HarmCategory_HARM_CATEGORY_HATE_SPEECH HarmCategory = 1
	// The harm category is dangerous content.
	HarmCategory_HARM_CATEGORY_DANGEROUS_CONTENT HarmCategory = 2
	// The harm category is harassment.
	HarmCategory_HARM_CATEGORY_HARASSMENT HarmCategory = 3
	// The harm category is sexually explicit content.
	HarmCategory_HARM_CATEGORY_SEXUALLY_EXPLICIT HarmCategory = 4
	// Deprecated: Election filter is not longer supported.
	// The harm category is civic integrity.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/content.proto.
	HarmCategory_HARM_CATEGORY_CIVIC_INTEGRITY HarmCategory = 5
	// The harm category is for jailbreak prompts.
	HarmCategory_HARM_CATEGORY_JAILBREAK HarmCategory = 6
)

// Enum value maps for HarmCategory.
var (
	HarmCategory_name = map[int32]string{
		0: "HARM_CATEGORY_UNSPECIFIED",
		1: "HARM_CATEGORY_HATE_SPEECH",
		2: "HARM_CATEGORY_DANGEROUS_CONTENT",
		3: "HARM_CATEGORY_HARASSMENT",
		4: "HARM_CATEGORY_SEXUALLY_EXPLICIT",
		5: "HARM_CATEGORY_CIVIC_INTEGRITY",
		6: "HARM_CATEGORY_JAILBREAK",
	}
	HarmCategory_value = map[string]int32{
		"HARM_CATEGORY_UNSPECIFIED":       0,
		"HARM_CATEGORY_HATE_SPEECH":       1,
		"HARM_CATEGORY_DANGEROUS_CONTENT": 2,
		"HARM_CATEGORY_HARASSMENT":        3,
		"HARM_CATEGORY_SEXUALLY_EXPLICIT": 4,
		"HARM_CATEGORY_CIVIC_INTEGRITY":   5,
		"HARM_CATEGORY_JAILBREAK":         6,
	}
)

func (x HarmCategory) Enum() *HarmCategory {
	p := new(HarmCategory)
	*p = x
	return p
}

func (x HarmCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HarmCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[0].Descriptor()
}

func (HarmCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[0]
}

func (x HarmCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HarmCategory.Descriptor instead.
func (HarmCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{0}
}

// Content Part modality
type Modality int32

const (
	// Unspecified modality.
	Modality_MODALITY_UNSPECIFIED Modality = 0
	// Plain text.
	Modality_TEXT Modality = 1
	// Image.
	Modality_IMAGE Modality = 2
	// Video.
	Modality_VIDEO Modality = 3
	// Audio.
	Modality_AUDIO Modality = 4
	// Document, e.g. PDF.
	Modality_DOCUMENT Modality = 5
)

// Enum value maps for Modality.
var (
	Modality_name = map[int32]string{
		0: "MODALITY_UNSPECIFIED",
		1: "TEXT",
		2: "IMAGE",
		3: "VIDEO",
		4: "AUDIO",
		5: "DOCUMENT",
	}
	Modality_value = map[string]int32{
		"MODALITY_UNSPECIFIED": 0,
		"TEXT":                 1,
		"IMAGE":                2,
		"VIDEO":                3,
		"AUDIO":                4,
		"DOCUMENT":             5,
	}
)

func (x Modality) Enum() *Modality {
	p := new(Modality)
	*p = x
	return p
}

func (x Modality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Modality) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[1].Descriptor()
}

func (Modality) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[1]
}

func (x Modality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Modality.Descriptor instead.
func (Modality) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{1}
}

// The modalities of the response.
type GenerationConfig_Modality int32

const (
	// Unspecified modality. Will be processed as text.
	GenerationConfig_MODALITY_UNSPECIFIED GenerationConfig_Modality = 0
	// Text modality.
	GenerationConfig_TEXT GenerationConfig_Modality = 1
	// Image modality.
	GenerationConfig_IMAGE GenerationConfig_Modality = 2
	// Audio modality.
	GenerationConfig_AUDIO GenerationConfig_Modality = 3
)

// Enum value maps for GenerationConfig_Modality.
var (
	GenerationConfig_Modality_name = map[int32]string{
		0: "MODALITY_UNSPECIFIED",
		1: "TEXT",
		2: "IMAGE",
		3: "AUDIO",
	}
	GenerationConfig_Modality_value = map[string]int32{
		"MODALITY_UNSPECIFIED": 0,
		"TEXT":                 1,
		"IMAGE":                2,
		"AUDIO":                3,
	}
)

func (x GenerationConfig_Modality) Enum() *GenerationConfig_Modality {
	p := new(GenerationConfig_Modality)
	*p = x
	return p
}

func (x GenerationConfig_Modality) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerationConfig_Modality) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[2].Descriptor()
}

func (GenerationConfig_Modality) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[2]
}

func (x GenerationConfig_Modality) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerationConfig_Modality.Descriptor instead.
func (GenerationConfig_Modality) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 0}
}

// Media resolution for the input media.
type GenerationConfig_MediaResolution int32

const (
	// Media resolution has not been set.
	GenerationConfig_MEDIA_RESOLUTION_UNSPECIFIED GenerationConfig_MediaResolution = 0
	// Media resolution set to low (64 tokens).
	GenerationConfig_MEDIA_RESOLUTION_LOW GenerationConfig_MediaResolution = 1
	// Media resolution set to medium (256 tokens).
	GenerationConfig_MEDIA_RESOLUTION_MEDIUM GenerationConfig_MediaResolution = 2
	// Media resolution set to high (zoomed reframing with 256 tokens).
	GenerationConfig_MEDIA_RESOLUTION_HIGH GenerationConfig_MediaResolution = 3
)

// Enum value maps for GenerationConfig_MediaResolution.
var (
	GenerationConfig_MediaResolution_name = map[int32]string{
		0: "MEDIA_RESOLUTION_UNSPECIFIED",
		1: "MEDIA_RESOLUTION_LOW",
		2: "MEDIA_RESOLUTION_MEDIUM",
		3: "MEDIA_RESOLUTION_HIGH",
	}
	GenerationConfig_MediaResolution_value = map[string]int32{
		"MEDIA_RESOLUTION_UNSPECIFIED": 0,
		"MEDIA_RESOLUTION_LOW":         1,
		"MEDIA_RESOLUTION_MEDIUM":      2,
		"MEDIA_RESOLUTION_HIGH":        3,
	}
)

func (x GenerationConfig_MediaResolution) Enum() *GenerationConfig_MediaResolution {
	p := new(GenerationConfig_MediaResolution)
	*p = x
	return p
}

func (x GenerationConfig_MediaResolution) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerationConfig_MediaResolution) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[3].Descriptor()
}

func (GenerationConfig_MediaResolution) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[3]
}

func (x GenerationConfig_MediaResolution) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerationConfig_MediaResolution.Descriptor instead.
func (GenerationConfig_MediaResolution) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 1}
}

// The model routing preference.
type GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference int32

const (
	// Unspecified model routing preference.
	GenerationConfig_RoutingConfig_AutoRoutingMode_UNKNOWN GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference = 0
	// Prefer higher quality over low cost.
	GenerationConfig_RoutingConfig_AutoRoutingMode_PRIORITIZE_QUALITY GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference = 1
	// Balanced model routing preference.
	GenerationConfig_RoutingConfig_AutoRoutingMode_BALANCED GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference = 2
	// Prefer lower cost over higher quality.
	GenerationConfig_RoutingConfig_AutoRoutingMode_PRIORITIZE_COST GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference = 3
)

// Enum value maps for GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference.
var (
	GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference_name = map[int32]string{
		0: "UNKNOWN",
		1: "PRIORITIZE_QUALITY",
		2: "BALANCED",
		3: "PRIORITIZE_COST",
	}
	GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference_value = map[string]int32{
		"UNKNOWN":            0,
		"PRIORITIZE_QUALITY": 1,
		"BALANCED":           2,
		"PRIORITIZE_COST":    3,
	}
)

func (x GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference) Enum() *GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference {
	p := new(GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference)
	*p = x
	return p
}

func (x GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[4].Descriptor()
}

func (GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[4]
}

func (x GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference.Descriptor instead.
func (GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 0, 0, 0}
}

// Options for feature selection preference.
type GenerationConfig_ModelConfig_FeatureSelectionPreference int32

const (
	// Unspecified feature selection preference.
	GenerationConfig_ModelConfig_FEATURE_SELECTION_PREFERENCE_UNSPECIFIED GenerationConfig_ModelConfig_FeatureSelectionPreference = 0
	// Prefer higher quality over lower cost.
	GenerationConfig_ModelConfig_PRIORITIZE_QUALITY GenerationConfig_ModelConfig_FeatureSelectionPreference = 1
	// Balanced feature selection preference.
	GenerationConfig_ModelConfig_BALANCED GenerationConfig_ModelConfig_FeatureSelectionPreference = 2
	// Prefer lower cost over higher quality.
	GenerationConfig_ModelConfig_PRIORITIZE_COST GenerationConfig_ModelConfig_FeatureSelectionPreference = 3
)

// Enum value maps for GenerationConfig_ModelConfig_FeatureSelectionPreference.
var (
	GenerationConfig_ModelConfig_FeatureSelectionPreference_name = map[int32]string{
		0: "FEATURE_SELECTION_PREFERENCE_UNSPECIFIED",
		1: "PRIORITIZE_QUALITY",
		2: "BALANCED",
		3: "PRIORITIZE_COST",
	}
	GenerationConfig_ModelConfig_FeatureSelectionPreference_value = map[string]int32{
		"FEATURE_SELECTION_PREFERENCE_UNSPECIFIED": 0,
		"PRIORITIZE_QUALITY":                       1,
		"BALANCED":                                 2,
		"PRIORITIZE_COST":                          3,
	}
)

func (x GenerationConfig_ModelConfig_FeatureSelectionPreference) Enum() *GenerationConfig_ModelConfig_FeatureSelectionPreference {
	p := new(GenerationConfig_ModelConfig_FeatureSelectionPreference)
	*p = x
	return p
}

func (x GenerationConfig_ModelConfig_FeatureSelectionPreference) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerationConfig_ModelConfig_FeatureSelectionPreference) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[5].Descriptor()
}

func (GenerationConfig_ModelConfig_FeatureSelectionPreference) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[5]
}

func (x GenerationConfig_ModelConfig_FeatureSelectionPreference) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerationConfig_ModelConfig_FeatureSelectionPreference.Descriptor instead.
func (GenerationConfig_ModelConfig_FeatureSelectionPreference) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 2, 0}
}

// Probability based thresholds levels for blocking.
type SafetySetting_HarmBlockThreshold int32

const (
	// Unspecified harm block threshold.
	SafetySetting_HARM_BLOCK_THRESHOLD_UNSPECIFIED SafetySetting_HarmBlockThreshold = 0
	// Block low threshold and above (i.e. block more).
	SafetySetting_BLOCK_LOW_AND_ABOVE SafetySetting_HarmBlockThreshold = 1
	// Block medium threshold and above.
	SafetySetting_BLOCK_MEDIUM_AND_ABOVE SafetySetting_HarmBlockThreshold = 2
	// Block only high threshold (i.e. block less).
	SafetySetting_BLOCK_ONLY_HIGH SafetySetting_HarmBlockThreshold = 3
	// Block none.
	SafetySetting_BLOCK_NONE SafetySetting_HarmBlockThreshold = 4
	// Turn off the safety filter.
	SafetySetting_OFF SafetySetting_HarmBlockThreshold = 5
)

// Enum value maps for SafetySetting_HarmBlockThreshold.
var (
	SafetySetting_HarmBlockThreshold_name = map[int32]string{
		0: "HARM_BLOCK_THRESHOLD_UNSPECIFIED",
		1: "BLOCK_LOW_AND_ABOVE",
		2: "BLOCK_MEDIUM_AND_ABOVE",
		3: "BLOCK_ONLY_HIGH",
		4: "BLOCK_NONE",
		5: "OFF",
	}
	SafetySetting_HarmBlockThreshold_value = map[string]int32{
		"HARM_BLOCK_THRESHOLD_UNSPECIFIED": 0,
		"BLOCK_LOW_AND_ABOVE":              1,
		"BLOCK_MEDIUM_AND_ABOVE":           2,
		"BLOCK_ONLY_HIGH":                  3,
		"BLOCK_NONE":                       4,
		"OFF":                              5,
	}
)

func (x SafetySetting_HarmBlockThreshold) Enum() *SafetySetting_HarmBlockThreshold {
	p := new(SafetySetting_HarmBlockThreshold)
	*p = x
	return p
}

func (x SafetySetting_HarmBlockThreshold) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetySetting_HarmBlockThreshold) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[6].Descriptor()
}

func (SafetySetting_HarmBlockThreshold) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[6]
}

func (x SafetySetting_HarmBlockThreshold) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetySetting_HarmBlockThreshold.Descriptor instead.
func (SafetySetting_HarmBlockThreshold) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{10, 0}
}

// Probability vs severity.
type SafetySetting_HarmBlockMethod int32

const (
	// The harm block method is unspecified.
	SafetySetting_HARM_BLOCK_METHOD_UNSPECIFIED SafetySetting_HarmBlockMethod = 0
	// The harm block method uses both probability and severity scores.
	SafetySetting_SEVERITY SafetySetting_HarmBlockMethod = 1
	// The harm block method uses the probability score.
	SafetySetting_PROBABILITY SafetySetting_HarmBlockMethod = 2
)

// Enum value maps for SafetySetting_HarmBlockMethod.
var (
	SafetySetting_HarmBlockMethod_name = map[int32]string{
		0: "HARM_BLOCK_METHOD_UNSPECIFIED",
		1: "SEVERITY",
		2: "PROBABILITY",
	}
	SafetySetting_HarmBlockMethod_value = map[string]int32{
		"HARM_BLOCK_METHOD_UNSPECIFIED": 0,
		"SEVERITY":                      1,
		"PROBABILITY":                   2,
	}
)

func (x SafetySetting_HarmBlockMethod) Enum() *SafetySetting_HarmBlockMethod {
	p := new(SafetySetting_HarmBlockMethod)
	*p = x
	return p
}

func (x SafetySetting_HarmBlockMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetySetting_HarmBlockMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[7].Descriptor()
}

func (SafetySetting_HarmBlockMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[7]
}

func (x SafetySetting_HarmBlockMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetySetting_HarmBlockMethod.Descriptor instead.
func (SafetySetting_HarmBlockMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{10, 1}
}

// Harm probability levels in the content.
type SafetyRating_HarmProbability int32

const (
	// Harm probability unspecified.
	SafetyRating_HARM_PROBABILITY_UNSPECIFIED SafetyRating_HarmProbability = 0
	// Negligible level of harm.
	SafetyRating_NEGLIGIBLE SafetyRating_HarmProbability = 1
	// Low level of harm.
	SafetyRating_LOW SafetyRating_HarmProbability = 2
	// Medium level of harm.
	SafetyRating_MEDIUM SafetyRating_HarmProbability = 3
	// High level of harm.
	SafetyRating_HIGH SafetyRating_HarmProbability = 4
)

// Enum value maps for SafetyRating_HarmProbability.
var (
	SafetyRating_HarmProbability_name = map[int32]string{
		0: "HARM_PROBABILITY_UNSPECIFIED",
		1: "NEGLIGIBLE",
		2: "LOW",
		3: "MEDIUM",
		4: "HIGH",
	}
	SafetyRating_HarmProbability_value = map[string]int32{
		"HARM_PROBABILITY_UNSPECIFIED": 0,
		"NEGLIGIBLE":                   1,
		"LOW":                          2,
		"MEDIUM":                       3,
		"HIGH":                         4,
	}
)

func (x SafetyRating_HarmProbability) Enum() *SafetyRating_HarmProbability {
	p := new(SafetyRating_HarmProbability)
	*p = x
	return p
}

func (x SafetyRating_HarmProbability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetyRating_HarmProbability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[8].Descriptor()
}

func (SafetyRating_HarmProbability) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[8]
}

func (x SafetyRating_HarmProbability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetyRating_HarmProbability.Descriptor instead.
func (SafetyRating_HarmProbability) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{11, 0}
}

// Harm severity levels.
type SafetyRating_HarmSeverity int32

const (
	// Harm severity unspecified.
	SafetyRating_HARM_SEVERITY_UNSPECIFIED SafetyRating_HarmSeverity = 0
	// Negligible level of harm severity.
	SafetyRating_HARM_SEVERITY_NEGLIGIBLE SafetyRating_HarmSeverity = 1
	// Low level of harm severity.
	SafetyRating_HARM_SEVERITY_LOW SafetyRating_HarmSeverity = 2
	// Medium level of harm severity.
	SafetyRating_HARM_SEVERITY_MEDIUM SafetyRating_HarmSeverity = 3
	// High level of harm severity.
	SafetyRating_HARM_SEVERITY_HIGH SafetyRating_HarmSeverity = 4
)

// Enum value maps for SafetyRating_HarmSeverity.
var (
	SafetyRating_HarmSeverity_name = map[int32]string{
		0: "HARM_SEVERITY_UNSPECIFIED",
		1: "HARM_SEVERITY_NEGLIGIBLE",
		2: "HARM_SEVERITY_LOW",
		3: "HARM_SEVERITY_MEDIUM",
		4: "HARM_SEVERITY_HIGH",
	}
	SafetyRating_HarmSeverity_value = map[string]int32{
		"HARM_SEVERITY_UNSPECIFIED": 0,
		"HARM_SEVERITY_NEGLIGIBLE":  1,
		"HARM_SEVERITY_LOW":         2,
		"HARM_SEVERITY_MEDIUM":      3,
		"HARM_SEVERITY_HIGH":        4,
	}
)

func (x SafetyRating_HarmSeverity) Enum() *SafetyRating_HarmSeverity {
	p := new(SafetyRating_HarmSeverity)
	*p = x
	return p
}

func (x SafetyRating_HarmSeverity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetyRating_HarmSeverity) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[9].Descriptor()
}

func (SafetyRating_HarmSeverity) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[9]
}

func (x SafetyRating_HarmSeverity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetyRating_HarmSeverity.Descriptor instead.
func (SafetyRating_HarmSeverity) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{11, 1}
}

// The reason why the model stopped generating tokens.
// If empty, the model has not stopped generating the tokens.
type Candidate_FinishReason int32

const (
	// The finish reason is unspecified.
	Candidate_FINISH_REASON_UNSPECIFIED Candidate_FinishReason = 0
	// Token generation reached a natural stopping point or a configured stop
	// sequence.
	Candidate_STOP Candidate_FinishReason = 1
	// Token generation reached the configured maximum output tokens.
	Candidate_MAX_TOKENS Candidate_FinishReason = 2
	// Token generation stopped because the content potentially contains safety
	// violations. NOTE: When streaming,
	// [content][google.cloud.aiplatform.v1beta1.Candidate.content] is empty if
	// content filters blocks the output.
	Candidate_SAFETY Candidate_FinishReason = 3
	// Token generation stopped because the content potentially contains
	// copyright violations.
	Candidate_RECITATION Candidate_FinishReason = 4
	// All other reasons that stopped the token generation.
	Candidate_OTHER Candidate_FinishReason = 5
	// Token generation stopped because the content contains forbidden terms.
	Candidate_BLOCKLIST Candidate_FinishReason = 6
	// Token generation stopped for potentially containing prohibited content.
	Candidate_PROHIBITED_CONTENT Candidate_FinishReason = 7
	// Token generation stopped because the content potentially contains
	// Sensitive Personally Identifiable Information (SPII).
	Candidate_SPII Candidate_FinishReason = 8
	// The function call generated by the model is invalid.
	Candidate_MALFORMED_FUNCTION_CALL Candidate_FinishReason = 9
	// The model response was blocked by Model Armor.
	Candidate_MODEL_ARMOR Candidate_FinishReason = 10
)

// Enum value maps for Candidate_FinishReason.
var (
	Candidate_FinishReason_name = map[int32]string{
		0:  "FINISH_REASON_UNSPECIFIED",
		1:  "STOP",
		2:  "MAX_TOKENS",
		3:  "SAFETY",
		4:  "RECITATION",
		5:  "OTHER",
		6:  "BLOCKLIST",
		7:  "PROHIBITED_CONTENT",
		8:  "SPII",
		9:  "MALFORMED_FUNCTION_CALL",
		10: "MODEL_ARMOR",
	}
	Candidate_FinishReason_value = map[string]int32{
		"FINISH_REASON_UNSPECIFIED": 0,
		"STOP":                      1,
		"MAX_TOKENS":                2,
		"SAFETY":                    3,
		"RECITATION":                4,
		"OTHER":                     5,
		"BLOCKLIST":                 6,
		"PROHIBITED_CONTENT":        7,
		"SPII":                      8,
		"MALFORMED_FUNCTION_CALL":   9,
		"MODEL_ARMOR":               10,
	}
)

func (x Candidate_FinishReason) Enum() *Candidate_FinishReason {
	p := new(Candidate_FinishReason)
	*p = x
	return p
}

func (x Candidate_FinishReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Candidate_FinishReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[10].Descriptor()
}

func (Candidate_FinishReason) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[10]
}

func (x Candidate_FinishReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Candidate_FinishReason.Descriptor instead.
func (Candidate_FinishReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{14, 0}
}

// Status of the url retrieval.
type UrlMetadata_UrlRetrievalStatus int32

const (
	// Default value. This value is unused.
	UrlMetadata_URL_RETRIEVAL_STATUS_UNSPECIFIED UrlMetadata_UrlRetrievalStatus = 0
	// Url retrieval is successful.
	UrlMetadata_URL_RETRIEVAL_STATUS_SUCCESS UrlMetadata_UrlRetrievalStatus = 1
	// Url retrieval is failed due to error.
	UrlMetadata_URL_RETRIEVAL_STATUS_ERROR UrlMetadata_UrlRetrievalStatus = 2
)

// Enum value maps for UrlMetadata_UrlRetrievalStatus.
var (
	UrlMetadata_UrlRetrievalStatus_name = map[int32]string{
		0: "URL_RETRIEVAL_STATUS_UNSPECIFIED",
		1: "URL_RETRIEVAL_STATUS_SUCCESS",
		2: "URL_RETRIEVAL_STATUS_ERROR",
	}
	UrlMetadata_UrlRetrievalStatus_value = map[string]int32{
		"URL_RETRIEVAL_STATUS_UNSPECIFIED": 0,
		"URL_RETRIEVAL_STATUS_SUCCESS":     1,
		"URL_RETRIEVAL_STATUS_ERROR":       2,
	}
)

func (x UrlMetadata_UrlRetrievalStatus) Enum() *UrlMetadata_UrlRetrievalStatus {
	p := new(UrlMetadata_UrlRetrievalStatus)
	*p = x
	return p
}

func (x UrlMetadata_UrlRetrievalStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UrlMetadata_UrlRetrievalStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[11].Descriptor()
}

func (UrlMetadata_UrlRetrievalStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[11]
}

func (x UrlMetadata_UrlRetrievalStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UrlMetadata_UrlRetrievalStatus.Descriptor instead.
func (UrlMetadata_UrlRetrievalStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{16, 0}
}

// The base structured datatype containing multi-part content of a message.
//
// A `Content` includes a `role` field designating the producer of the `Content`
// and a `parts` field containing multi-part data that contains the content of
// the message turn.
type Content struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The producer of the content. Must be either 'user' or 'model'.
	//
	// Useful to set for multi-turn conversations, otherwise can be left blank
	// or unset.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// Required. Ordered `Parts` that constitute a single message. Parts may have
	// different IANA MIME types.
	Parts []*Part `protobuf:"bytes,2,rep,name=parts,proto3" json:"parts,omitempty"`
}

func (x *Content) Reset() {
	*x = Content{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Content) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Content) ProtoMessage() {}

func (x *Content) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Content.ProtoReflect.Descriptor instead.
func (*Content) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{0}
}

func (x *Content) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *Content) GetParts() []*Part {
	if x != nil {
		return x.Parts
	}
	return nil
}

// A datatype containing media that is part of a multi-part `Content` message.
//
// A `Part` consists of data which has an associated datatype. A `Part` can only
// contain one of the accepted types in `Part.data`.
//
// A `Part` must have a fixed IANA MIME type identifying the type and subtype
// of the media if `inline_data` or `file_data` field is filled with raw bytes.
type Part struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Data:
	//
	//	*Part_Text
	//	*Part_InlineData
	//	*Part_FileData
	//	*Part_FunctionCall
	//	*Part_FunctionResponse
	//	*Part_ExecutableCode
	//	*Part_CodeExecutionResult
	Data isPart_Data `protobuf_oneof:"data"`
	// Types that are assignable to Metadata:
	//
	//	*Part_VideoMetadata
	Metadata isPart_Metadata `protobuf_oneof:"metadata"`
	// Indicates if the part is thought from the model.
	Thought bool `protobuf:"varint,10,opt,name=thought,proto3" json:"thought,omitempty"`
	// An opaque signature for the thought so it can be reused in subsequent
	// requests.
	ThoughtSignature []byte `protobuf:"bytes,11,opt,name=thought_signature,json=thoughtSignature,proto3" json:"thought_signature,omitempty"`
}

func (x *Part) Reset() {
	*x = Part{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Part) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Part) ProtoMessage() {}

func (x *Part) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Part.ProtoReflect.Descriptor instead.
func (*Part) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{1}
}

func (m *Part) GetData() isPart_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *Part) GetText() string {
	if x, ok := x.GetData().(*Part_Text); ok {
		return x.Text
	}
	return ""
}

func (x *Part) GetInlineData() *Blob {
	if x, ok := x.GetData().(*Part_InlineData); ok {
		return x.InlineData
	}
	return nil
}

func (x *Part) GetFileData() *FileData {
	if x, ok := x.GetData().(*Part_FileData); ok {
		return x.FileData
	}
	return nil
}

func (x *Part) GetFunctionCall() *FunctionCall {
	if x, ok := x.GetData().(*Part_FunctionCall); ok {
		return x.FunctionCall
	}
	return nil
}

func (x *Part) GetFunctionResponse() *FunctionResponse {
	if x, ok := x.GetData().(*Part_FunctionResponse); ok {
		return x.FunctionResponse
	}
	return nil
}

func (x *Part) GetExecutableCode() *ExecutableCode {
	if x, ok := x.GetData().(*Part_ExecutableCode); ok {
		return x.ExecutableCode
	}
	return nil
}

func (x *Part) GetCodeExecutionResult() *CodeExecutionResult {
	if x, ok := x.GetData().(*Part_CodeExecutionResult); ok {
		return x.CodeExecutionResult
	}
	return nil
}

func (m *Part) GetMetadata() isPart_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *Part) GetVideoMetadata() *VideoMetadata {
	if x, ok := x.GetMetadata().(*Part_VideoMetadata); ok {
		return x.VideoMetadata
	}
	return nil
}

func (x *Part) GetThought() bool {
	if x != nil {
		return x.Thought
	}
	return false
}

func (x *Part) GetThoughtSignature() []byte {
	if x != nil {
		return x.ThoughtSignature
	}
	return nil
}

type isPart_Data interface {
	isPart_Data()
}

type Part_Text struct {
	// Optional. Text part (can be code).
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type Part_InlineData struct {
	// Optional. Inlined bytes data.
	InlineData *Blob `protobuf:"bytes,2,opt,name=inline_data,json=inlineData,proto3,oneof"`
}

type Part_FileData struct {
	// Optional. URI based data.
	FileData *FileData `protobuf:"bytes,3,opt,name=file_data,json=fileData,proto3,oneof"`
}

type Part_FunctionCall struct {
	// Optional. A predicted [FunctionCall] returned from the model that
	// contains a string representing the [FunctionDeclaration.name] with the
	// parameters and their values.
	FunctionCall *FunctionCall `protobuf:"bytes,5,opt,name=function_call,json=functionCall,proto3,oneof"`
}

type Part_FunctionResponse struct {
	// Optional. The result output of a [FunctionCall] that contains a string
	// representing the [FunctionDeclaration.name] and a structured JSON object
	// containing any output from the function call. It is used as context to
	// the model.
	FunctionResponse *FunctionResponse `protobuf:"bytes,6,opt,name=function_response,json=functionResponse,proto3,oneof"`
}

type Part_ExecutableCode struct {
	// Optional. Code generated by the model that is meant to be executed.
	ExecutableCode *ExecutableCode `protobuf:"bytes,8,opt,name=executable_code,json=executableCode,proto3,oneof"`
}

type Part_CodeExecutionResult struct {
	// Optional. Result of executing the [ExecutableCode].
	CodeExecutionResult *CodeExecutionResult `protobuf:"bytes,9,opt,name=code_execution_result,json=codeExecutionResult,proto3,oneof"`
}

func (*Part_Text) isPart_Data() {}

func (*Part_InlineData) isPart_Data() {}

func (*Part_FileData) isPart_Data() {}

func (*Part_FunctionCall) isPart_Data() {}

func (*Part_FunctionResponse) isPart_Data() {}

func (*Part_ExecutableCode) isPart_Data() {}

func (*Part_CodeExecutionResult) isPart_Data() {}

type isPart_Metadata interface {
	isPart_Metadata()
}

type Part_VideoMetadata struct {
	// Optional. Video metadata. The metadata should only be specified while the
	// video data is presented in inline_data or file_data.
	VideoMetadata *VideoMetadata `protobuf:"bytes,4,opt,name=video_metadata,json=videoMetadata,proto3,oneof"`
}

func (*Part_VideoMetadata) isPart_Metadata() {}

// Content blob.
//
// It's preferred to send as [text][google.cloud.aiplatform.v1beta1.Part.text]
// directly rather than raw bytes.
type Blob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The IANA standard MIME type of the source data.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Required. Raw bytes.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *Blob) Reset() {
	*x = Blob{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Blob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Blob) ProtoMessage() {}

func (x *Blob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Blob.ProtoReflect.Descriptor instead.
func (*Blob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{2}
}

func (x *Blob) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *Blob) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// URI based data.
type FileData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The IANA standard MIME type of the source data.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Required. URI.
	FileUri string `protobuf:"bytes,2,opt,name=file_uri,json=fileUri,proto3" json:"file_uri,omitempty"`
}

func (x *FileData) Reset() {
	*x = FileData{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FileData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileData) ProtoMessage() {}

func (x *FileData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileData.ProtoReflect.Descriptor instead.
func (*FileData) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{3}
}

func (x *FileData) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *FileData) GetFileUri() string {
	if x != nil {
		return x.FileUri
	}
	return ""
}

// Metadata describes the input video content.
type VideoMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The start offset of the video.
	StartOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Optional. The end offset of the video.
	EndOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
}

func (x *VideoMetadata) Reset() {
	*x = VideoMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VideoMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoMetadata) ProtoMessage() {}

func (x *VideoMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoMetadata.ProtoReflect.Descriptor instead.
func (*VideoMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{4}
}

func (x *VideoMetadata) GetStartOffset() *durationpb.Duration {
	if x != nil {
		return x.StartOffset
	}
	return nil
}

func (x *VideoMetadata) GetEndOffset() *durationpb.Duration {
	if x != nil {
		return x.EndOffset
	}
	return nil
}

// The configuration for the prebuilt speaker to use.
type PrebuiltVoiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the preset voice to use.
	VoiceName *string `protobuf:"bytes,1,opt,name=voice_name,json=voiceName,proto3,oneof" json:"voice_name,omitempty"`
}

func (x *PrebuiltVoiceConfig) Reset() {
	*x = PrebuiltVoiceConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrebuiltVoiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrebuiltVoiceConfig) ProtoMessage() {}

func (x *PrebuiltVoiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrebuiltVoiceConfig.ProtoReflect.Descriptor instead.
func (*PrebuiltVoiceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{5}
}

func (x *PrebuiltVoiceConfig) GetVoiceName() string {
	if x != nil && x.VoiceName != nil {
		return *x.VoiceName
	}
	return ""
}

// The configuration for the voice to use.
type VoiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration for the speaker to use.
	//
	// Types that are assignable to VoiceConfig:
	//
	//	*VoiceConfig_PrebuiltVoiceConfig
	VoiceConfig isVoiceConfig_VoiceConfig `protobuf_oneof:"voice_config"`
}

func (x *VoiceConfig) Reset() {
	*x = VoiceConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VoiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VoiceConfig) ProtoMessage() {}

func (x *VoiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VoiceConfig.ProtoReflect.Descriptor instead.
func (*VoiceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{6}
}

func (m *VoiceConfig) GetVoiceConfig() isVoiceConfig_VoiceConfig {
	if m != nil {
		return m.VoiceConfig
	}
	return nil
}

func (x *VoiceConfig) GetPrebuiltVoiceConfig() *PrebuiltVoiceConfig {
	if x, ok := x.GetVoiceConfig().(*VoiceConfig_PrebuiltVoiceConfig); ok {
		return x.PrebuiltVoiceConfig
	}
	return nil
}

type isVoiceConfig_VoiceConfig interface {
	isVoiceConfig_VoiceConfig()
}

type VoiceConfig_PrebuiltVoiceConfig struct {
	// The configuration for the prebuilt voice to use.
	PrebuiltVoiceConfig *PrebuiltVoiceConfig `protobuf:"bytes,1,opt,name=prebuilt_voice_config,json=prebuiltVoiceConfig,proto3,oneof"`
}

func (*VoiceConfig_PrebuiltVoiceConfig) isVoiceConfig_VoiceConfig() {}

// The speech generation config.
type SpeechConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The configuration for the speaker to use.
	VoiceConfig *VoiceConfig `protobuf:"bytes,1,opt,name=voice_config,json=voiceConfig,proto3" json:"voice_config,omitempty"`
}

func (x *SpeechConfig) Reset() {
	*x = SpeechConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpeechConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpeechConfig) ProtoMessage() {}

func (x *SpeechConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpeechConfig.ProtoReflect.Descriptor instead.
func (*SpeechConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{7}
}

func (x *SpeechConfig) GetVoiceConfig() *VoiceConfig {
	if x != nil {
		return x.VoiceConfig
	}
	return nil
}

// Config for image generation features.
type ImageConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The desired aspect ratio for the generated images. The following
	// aspect ratios are supported:
	//
	// "1:1"
	// "2:3", "3:2"
	// "3:4", "4:3"
	// "4:5", "5:4"
	// "9:16", "16:9"
	// "21:9"
	AspectRatio *string `protobuf:"bytes,2,opt,name=aspect_ratio,json=aspectRatio,proto3,oneof" json:"aspect_ratio,omitempty"`
}

func (x *ImageConfig) Reset() {
	*x = ImageConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageConfig) ProtoMessage() {}

func (x *ImageConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageConfig.ProtoReflect.Descriptor instead.
func (*ImageConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{8}
}

func (x *ImageConfig) GetAspectRatio() string {
	if x != nil && x.AspectRatio != nil {
		return *x.AspectRatio
	}
	return ""
}

// Generation config.
type GenerationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Controls the randomness of predictions.
	Temperature *float32 `protobuf:"fixed32,1,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
	// Optional. If specified, nucleus sampling will be used.
	TopP *float32 `protobuf:"fixed32,2,opt,name=top_p,json=topP,proto3,oneof" json:"top_p,omitempty"`
	// Optional. If specified, top-k sampling will be used.
	TopK *float32 `protobuf:"fixed32,3,opt,name=top_k,json=topK,proto3,oneof" json:"top_k,omitempty"`
	// Optional. Number of candidates to generate.
	CandidateCount *int32 `protobuf:"varint,4,opt,name=candidate_count,json=candidateCount,proto3,oneof" json:"candidate_count,omitempty"`
	// Optional. The maximum number of output tokens to generate per message.
	MaxOutputTokens *int32 `protobuf:"varint,5,opt,name=max_output_tokens,json=maxOutputTokens,proto3,oneof" json:"max_output_tokens,omitempty"`
	// Optional. Stop sequences.
	StopSequences []string `protobuf:"bytes,6,rep,name=stop_sequences,json=stopSequences,proto3" json:"stop_sequences,omitempty"`
	// Optional. If true, export the logprobs results in response.
	ResponseLogprobs *bool `protobuf:"varint,18,opt,name=response_logprobs,json=responseLogprobs,proto3,oneof" json:"response_logprobs,omitempty"`
	// Optional. Logit probabilities.
	Logprobs *int32 `protobuf:"varint,7,opt,name=logprobs,proto3,oneof" json:"logprobs,omitempty"`
	// Optional. Positive penalties.
	PresencePenalty *float32 `protobuf:"fixed32,8,opt,name=presence_penalty,json=presencePenalty,proto3,oneof" json:"presence_penalty,omitempty"`
	// Optional. Frequency penalties.
	FrequencyPenalty *float32 `protobuf:"fixed32,9,opt,name=frequency_penalty,json=frequencyPenalty,proto3,oneof" json:"frequency_penalty,omitempty"`
	// Optional. Seed.
	Seed *int32 `protobuf:"varint,12,opt,name=seed,proto3,oneof" json:"seed,omitempty"`
	// Optional. Output response mimetype of the generated candidate text.
	// Supported mimetype:
	// - `text/plain`: (default) Text output.
	// - `application/json`: JSON response in the candidates.
	// The model needs to be prompted to output the appropriate response type,
	// otherwise the behavior is undefined.
	// This is a preview feature.
	ResponseMimeType string `protobuf:"bytes,13,opt,name=response_mime_type,json=responseMimeType,proto3" json:"response_mime_type,omitempty"`
	// Optional. The `Schema` object allows the definition of input and output
	// data types. These types can be objects, but also primitives and arrays.
	// Represents a select subset of an [OpenAPI 3.0 schema
	// object](https://spec.openapis.org/oas/v3.0.3#schema).
	// If set, a compatible response_mime_type must also be set.
	// Compatible mimetypes:
	// `application/json`: Schema for JSON response.
	ResponseSchema *Schema `protobuf:"bytes,16,opt,name=response_schema,json=responseSchema,proto3,oneof" json:"response_schema,omitempty"`
	// Optional. Output schema of the generated response. This is an alternative
	// to `response_schema` that accepts [JSON Schema](https://json-schema.org/).
	//
	// If set, `response_schema` must be omitted, but `response_mime_type` is
	// required.
	//
	// While the full JSON Schema may be sent, not all features are supported.
	// Specifically, only the following properties are supported:
	//
	// - `$id`
	// - `$defs`
	// - `$ref`
	// - `$anchor`
	// - `type`
	// - `format`
	// - `title`
	// - `description`
	// - `enum` (for strings and numbers)
	// - `items`
	// - `prefixItems`
	// - `minItems`
	// - `maxItems`
	// - `minimum`
	// - `maximum`
	// - `anyOf`
	// - `oneOf` (interpreted the same as `anyOf`)
	// - `properties`
	// - `additionalProperties`
	// - `required`
	//
	// The non-standard `propertyOrdering` property may also be set.
	//
	// Cyclic references are unrolled to a limited degree and, as such, may only
	// be used within non-required properties. (Nullable properties are not
	// sufficient.) If `$ref` is set on a sub-schema, no other properties, except
	// for than those starting as a `$`, may be set.
	ResponseJsonSchema *structpb.Value `protobuf:"bytes,28,opt,name=response_json_schema,json=responseJsonSchema,proto3,oneof" json:"response_json_schema,omitempty"`
	// Optional. Routing configuration.
	RoutingConfig *GenerationConfig_RoutingConfig `protobuf:"bytes,17,opt,name=routing_config,json=routingConfig,proto3,oneof" json:"routing_config,omitempty"`
	// Optional. If enabled, audio timestamp will be included in the request to
	// the model.
	AudioTimestamp *bool `protobuf:"varint,20,opt,name=audio_timestamp,json=audioTimestamp,proto3,oneof" json:"audio_timestamp,omitempty"`
	// Optional. The modalities of the response.
	ResponseModalities []GenerationConfig_Modality `protobuf:"varint,21,rep,packed,name=response_modalities,json=responseModalities,proto3,enum=google.cloud.aiplatform.v1beta1.GenerationConfig_Modality" json:"response_modalities,omitempty"`
	// Optional. If specified, the media resolution specified will be used.
	MediaResolution *GenerationConfig_MediaResolution `protobuf:"varint,22,opt,name=media_resolution,json=mediaResolution,proto3,enum=google.cloud.aiplatform.v1beta1.GenerationConfig_MediaResolution,oneof" json:"media_resolution,omitempty"`
	// Optional. The speech generation config.
	SpeechConfig *SpeechConfig `protobuf:"bytes,23,opt,name=speech_config,json=speechConfig,proto3,oneof" json:"speech_config,omitempty"`
	// Optional. Config for thinking features.
	// An error will be returned if this field is set for models that don't
	// support thinking.
	ThinkingConfig *GenerationConfig_ThinkingConfig `protobuf:"bytes,25,opt,name=thinking_config,json=thinkingConfig,proto3" json:"thinking_config,omitempty"`
	// Optional. Config for model selection.
	ModelConfig *GenerationConfig_ModelConfig `protobuf:"bytes,27,opt,name=model_config,json=modelConfig,proto3" json:"model_config,omitempty"`
	// Optional. Config for image generation features.
	ImageConfig *ImageConfig `protobuf:"bytes,30,opt,name=image_config,json=imageConfig,proto3,oneof" json:"image_config,omitempty"`
}

func (x *GenerationConfig) Reset() {
	*x = GenerationConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig) ProtoMessage() {}

func (x *GenerationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig.ProtoReflect.Descriptor instead.
func (*GenerationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9}
}

func (x *GenerationConfig) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

func (x *GenerationConfig) GetTopP() float32 {
	if x != nil && x.TopP != nil {
		return *x.TopP
	}
	return 0
}

func (x *GenerationConfig) GetTopK() float32 {
	if x != nil && x.TopK != nil {
		return *x.TopK
	}
	return 0
}

func (x *GenerationConfig) GetCandidateCount() int32 {
	if x != nil && x.CandidateCount != nil {
		return *x.CandidateCount
	}
	return 0
}

func (x *GenerationConfig) GetMaxOutputTokens() int32 {
	if x != nil && x.MaxOutputTokens != nil {
		return *x.MaxOutputTokens
	}
	return 0
}

func (x *GenerationConfig) GetStopSequences() []string {
	if x != nil {
		return x.StopSequences
	}
	return nil
}

func (x *GenerationConfig) GetResponseLogprobs() bool {
	if x != nil && x.ResponseLogprobs != nil {
		return *x.ResponseLogprobs
	}
	return false
}

func (x *GenerationConfig) GetLogprobs() int32 {
	if x != nil && x.Logprobs != nil {
		return *x.Logprobs
	}
	return 0
}

func (x *GenerationConfig) GetPresencePenalty() float32 {
	if x != nil && x.PresencePenalty != nil {
		return *x.PresencePenalty
	}
	return 0
}

func (x *GenerationConfig) GetFrequencyPenalty() float32 {
	if x != nil && x.FrequencyPenalty != nil {
		return *x.FrequencyPenalty
	}
	return 0
}

func (x *GenerationConfig) GetSeed() int32 {
	if x != nil && x.Seed != nil {
		return *x.Seed
	}
	return 0
}

func (x *GenerationConfig) GetResponseMimeType() string {
	if x != nil {
		return x.ResponseMimeType
	}
	return ""
}

func (x *GenerationConfig) GetResponseSchema() *Schema {
	if x != nil {
		return x.ResponseSchema
	}
	return nil
}

func (x *GenerationConfig) GetResponseJsonSchema() *structpb.Value {
	if x != nil {
		return x.ResponseJsonSchema
	}
	return nil
}

func (x *GenerationConfig) GetRoutingConfig() *GenerationConfig_RoutingConfig {
	if x != nil {
		return x.RoutingConfig
	}
	return nil
}

func (x *GenerationConfig) GetAudioTimestamp() bool {
	if x != nil && x.AudioTimestamp != nil {
		return *x.AudioTimestamp
	}
	return false
}

func (x *GenerationConfig) GetResponseModalities() []GenerationConfig_Modality {
	if x != nil {
		return x.ResponseModalities
	}
	return nil
}

func (x *GenerationConfig) GetMediaResolution() GenerationConfig_MediaResolution {
	if x != nil && x.MediaResolution != nil {
		return *x.MediaResolution
	}
	return GenerationConfig_MEDIA_RESOLUTION_UNSPECIFIED
}

func (x *GenerationConfig) GetSpeechConfig() *SpeechConfig {
	if x != nil {
		return x.SpeechConfig
	}
	return nil
}

func (x *GenerationConfig) GetThinkingConfig() *GenerationConfig_ThinkingConfig {
	if x != nil {
		return x.ThinkingConfig
	}
	return nil
}

func (x *GenerationConfig) GetModelConfig() *GenerationConfig_ModelConfig {
	if x != nil {
		return x.ModelConfig
	}
	return nil
}

func (x *GenerationConfig) GetImageConfig() *ImageConfig {
	if x != nil {
		return x.ImageConfig
	}
	return nil
}

// Safety settings.
type SafetySetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Harm category.
	Category HarmCategory `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.aiplatform.v1beta1.HarmCategory" json:"category,omitempty"`
	// Required. The harm block threshold.
	Threshold SafetySetting_HarmBlockThreshold `protobuf:"varint,2,opt,name=threshold,proto3,enum=google.cloud.aiplatform.v1beta1.SafetySetting_HarmBlockThreshold" json:"threshold,omitempty"`
	// Optional. Specify if the threshold is used for probability or severity
	// score. If not specified, the threshold is used for probability score.
	Method SafetySetting_HarmBlockMethod `protobuf:"varint,4,opt,name=method,proto3,enum=google.cloud.aiplatform.v1beta1.SafetySetting_HarmBlockMethod" json:"method,omitempty"`
}

func (x *SafetySetting) Reset() {
	*x = SafetySetting{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetySetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySetting) ProtoMessage() {}

func (x *SafetySetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySetting.ProtoReflect.Descriptor instead.
func (*SafetySetting) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{10}
}

func (x *SafetySetting) GetCategory() HarmCategory {
	if x != nil {
		return x.Category
	}
	return HarmCategory_HARM_CATEGORY_UNSPECIFIED
}

func (x *SafetySetting) GetThreshold() SafetySetting_HarmBlockThreshold {
	if x != nil {
		return x.Threshold
	}
	return SafetySetting_HARM_BLOCK_THRESHOLD_UNSPECIFIED
}

func (x *SafetySetting) GetMethod() SafetySetting_HarmBlockMethod {
	if x != nil {
		return x.Method
	}
	return SafetySetting_HARM_BLOCK_METHOD_UNSPECIFIED
}

// Safety rating corresponding to the generated content.
type SafetyRating struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Harm category.
	Category HarmCategory `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.aiplatform.v1beta1.HarmCategory" json:"category,omitempty"`
	// Output only. Harm probability levels in the content.
	Probability SafetyRating_HarmProbability `protobuf:"varint,2,opt,name=probability,proto3,enum=google.cloud.aiplatform.v1beta1.SafetyRating_HarmProbability" json:"probability,omitempty"`
	// Output only. Harm probability score.
	ProbabilityScore float32 `protobuf:"fixed32,5,opt,name=probability_score,json=probabilityScore,proto3" json:"probability_score,omitempty"`
	// Output only. Harm severity levels in the content.
	Severity SafetyRating_HarmSeverity `protobuf:"varint,6,opt,name=severity,proto3,enum=google.cloud.aiplatform.v1beta1.SafetyRating_HarmSeverity" json:"severity,omitempty"`
	// Output only. Harm severity score.
	SeverityScore float32 `protobuf:"fixed32,7,opt,name=severity_score,json=severityScore,proto3" json:"severity_score,omitempty"`
	// Output only. Indicates whether the content was filtered out because of this
	// rating.
	Blocked bool `protobuf:"varint,3,opt,name=blocked,proto3" json:"blocked,omitempty"`
}

func (x *SafetyRating) Reset() {
	*x = SafetyRating{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetyRating) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetyRating) ProtoMessage() {}

func (x *SafetyRating) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetyRating.ProtoReflect.Descriptor instead.
func (*SafetyRating) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{11}
}

func (x *SafetyRating) GetCategory() HarmCategory {
	if x != nil {
		return x.Category
	}
	return HarmCategory_HARM_CATEGORY_UNSPECIFIED
}

func (x *SafetyRating) GetProbability() SafetyRating_HarmProbability {
	if x != nil {
		return x.Probability
	}
	return SafetyRating_HARM_PROBABILITY_UNSPECIFIED
}

func (x *SafetyRating) GetProbabilityScore() float32 {
	if x != nil {
		return x.ProbabilityScore
	}
	return 0
}

func (x *SafetyRating) GetSeverity() SafetyRating_HarmSeverity {
	if x != nil {
		return x.Severity
	}
	return SafetyRating_HARM_SEVERITY_UNSPECIFIED
}

func (x *SafetyRating) GetSeverityScore() float32 {
	if x != nil {
		return x.SeverityScore
	}
	return 0
}

func (x *SafetyRating) GetBlocked() bool {
	if x != nil {
		return x.Blocked
	}
	return false
}

// A collection of source attributions for a piece of content.
type CitationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of citations.
	Citations []*Citation `protobuf:"bytes,1,rep,name=citations,proto3" json:"citations,omitempty"`
}

func (x *CitationMetadata) Reset() {
	*x = CitationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CitationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CitationMetadata) ProtoMessage() {}

func (x *CitationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CitationMetadata.ProtoReflect.Descriptor instead.
func (*CitationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{12}
}

func (x *CitationMetadata) GetCitations() []*Citation {
	if x != nil {
		return x.Citations
	}
	return nil
}

// Source attributions for content.
type Citation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Start index into the content.
	StartIndex int32 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// Output only. End index into the content.
	EndIndex int32 `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	// Output only. Url reference of the attribution.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// Output only. Title of the attribution.
	Title string `protobuf:"bytes,4,opt,name=title,proto3" json:"title,omitempty"`
	// Output only. License of the attribution.
	License string `protobuf:"bytes,5,opt,name=license,proto3" json:"license,omitempty"`
	// Output only. Publication date of the attribution.
	PublicationDate *date.Date `protobuf:"bytes,6,opt,name=publication_date,json=publicationDate,proto3" json:"publication_date,omitempty"`
}

func (x *Citation) Reset() {
	*x = Citation{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Citation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Citation) ProtoMessage() {}

func (x *Citation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Citation.ProtoReflect.Descriptor instead.
func (*Citation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{13}
}

func (x *Citation) GetStartIndex() int32 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *Citation) GetEndIndex() int32 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

func (x *Citation) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Citation) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Citation) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

func (x *Citation) GetPublicationDate() *date.Date {
	if x != nil {
		return x.PublicationDate
	}
	return nil
}

// A response candidate generated from the model.
type Candidate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Index of the candidate.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Output only. Content parts of the candidate.
	Content *Content `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Output only. Average log probability score of the candidate.
	AvgLogprobs float64 `protobuf:"fixed64,9,opt,name=avg_logprobs,json=avgLogprobs,proto3" json:"avg_logprobs,omitempty"`
	// Output only. Log-likelihood scores for the response tokens and top tokens
	LogprobsResult *LogprobsResult `protobuf:"bytes,10,opt,name=logprobs_result,json=logprobsResult,proto3" json:"logprobs_result,omitempty"`
	// Output only. The reason why the model stopped generating tokens.
	// If empty, the model has not stopped generating the tokens.
	FinishReason Candidate_FinishReason `protobuf:"varint,3,opt,name=finish_reason,json=finishReason,proto3,enum=google.cloud.aiplatform.v1beta1.Candidate_FinishReason" json:"finish_reason,omitempty"`
	// Output only. List of ratings for the safety of a response candidate.
	//
	// There is at most one rating per category.
	SafetyRatings []*SafetyRating `protobuf:"bytes,4,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
	// Output only. Describes the reason the mode stopped generating tokens in
	// more detail. This is only filled when `finish_reason` is set.
	FinishMessage *string `protobuf:"bytes,5,opt,name=finish_message,json=finishMessage,proto3,oneof" json:"finish_message,omitempty"`
	// Output only. Source attribution of the generated content.
	CitationMetadata *CitationMetadata `protobuf:"bytes,6,opt,name=citation_metadata,json=citationMetadata,proto3" json:"citation_metadata,omitempty"`
	// Output only. Metadata specifies sources used to ground generated content.
	GroundingMetadata *GroundingMetadata `protobuf:"bytes,7,opt,name=grounding_metadata,json=groundingMetadata,proto3" json:"grounding_metadata,omitempty"`
	// Output only. Metadata related to url context retrieval tool.
	UrlContextMetadata *UrlContextMetadata `protobuf:"bytes,11,opt,name=url_context_metadata,json=urlContextMetadata,proto3" json:"url_context_metadata,omitempty"`
}

func (x *Candidate) Reset() {
	*x = Candidate{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Candidate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Candidate) ProtoMessage() {}

func (x *Candidate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Candidate.ProtoReflect.Descriptor instead.
func (*Candidate) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{14}
}

func (x *Candidate) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *Candidate) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Candidate) GetAvgLogprobs() float64 {
	if x != nil {
		return x.AvgLogprobs
	}
	return 0
}

func (x *Candidate) GetLogprobsResult() *LogprobsResult {
	if x != nil {
		return x.LogprobsResult
	}
	return nil
}

func (x *Candidate) GetFinishReason() Candidate_FinishReason {
	if x != nil {
		return x.FinishReason
	}
	return Candidate_FINISH_REASON_UNSPECIFIED
}

func (x *Candidate) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

func (x *Candidate) GetFinishMessage() string {
	if x != nil && x.FinishMessage != nil {
		return *x.FinishMessage
	}
	return ""
}

func (x *Candidate) GetCitationMetadata() *CitationMetadata {
	if x != nil {
		return x.CitationMetadata
	}
	return nil
}

func (x *Candidate) GetGroundingMetadata() *GroundingMetadata {
	if x != nil {
		return x.GroundingMetadata
	}
	return nil
}

func (x *Candidate) GetUrlContextMetadata() *UrlContextMetadata {
	if x != nil {
		return x.UrlContextMetadata
	}
	return nil
}

// Metadata related to url context retrieval tool.
type UrlContextMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of url context.
	UrlMetadata []*UrlMetadata `protobuf:"bytes,1,rep,name=url_metadata,json=urlMetadata,proto3" json:"url_metadata,omitempty"`
}

func (x *UrlContextMetadata) Reset() {
	*x = UrlContextMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UrlContextMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UrlContextMetadata) ProtoMessage() {}

func (x *UrlContextMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UrlContextMetadata.ProtoReflect.Descriptor instead.
func (*UrlContextMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{15}
}

func (x *UrlContextMetadata) GetUrlMetadata() []*UrlMetadata {
	if x != nil {
		return x.UrlMetadata
	}
	return nil
}

// Context of the a single url retrieval.
type UrlMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Retrieved url by the tool.
	RetrievedUrl string `protobuf:"bytes,1,opt,name=retrieved_url,json=retrievedUrl,proto3" json:"retrieved_url,omitempty"`
	// Status of the url retrieval.
	UrlRetrievalStatus UrlMetadata_UrlRetrievalStatus `protobuf:"varint,2,opt,name=url_retrieval_status,json=urlRetrievalStatus,proto3,enum=google.cloud.aiplatform.v1beta1.UrlMetadata_UrlRetrievalStatus" json:"url_retrieval_status,omitempty"`
}

func (x *UrlMetadata) Reset() {
	*x = UrlMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UrlMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UrlMetadata) ProtoMessage() {}

func (x *UrlMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UrlMetadata.ProtoReflect.Descriptor instead.
func (*UrlMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{16}
}

func (x *UrlMetadata) GetRetrievedUrl() string {
	if x != nil {
		return x.RetrievedUrl
	}
	return ""
}

func (x *UrlMetadata) GetUrlRetrievalStatus() UrlMetadata_UrlRetrievalStatus {
	if x != nil {
		return x.UrlRetrievalStatus
	}
	return UrlMetadata_URL_RETRIEVAL_STATUS_UNSPECIFIED
}

// Logprobs Result
type LogprobsResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Length = total number of decoding steps.
	TopCandidates []*LogprobsResult_TopCandidates `protobuf:"bytes,1,rep,name=top_candidates,json=topCandidates,proto3" json:"top_candidates,omitempty"`
	// Length = total number of decoding steps.
	// The chosen candidates may or may not be in top_candidates.
	ChosenCandidates []*LogprobsResult_Candidate `protobuf:"bytes,2,rep,name=chosen_candidates,json=chosenCandidates,proto3" json:"chosen_candidates,omitempty"`
}

func (x *LogprobsResult) Reset() {
	*x = LogprobsResult{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogprobsResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogprobsResult) ProtoMessage() {}

func (x *LogprobsResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogprobsResult.ProtoReflect.Descriptor instead.
func (*LogprobsResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{17}
}

func (x *LogprobsResult) GetTopCandidates() []*LogprobsResult_TopCandidates {
	if x != nil {
		return x.TopCandidates
	}
	return nil
}

func (x *LogprobsResult) GetChosenCandidates() []*LogprobsResult_Candidate {
	if x != nil {
		return x.ChosenCandidates
	}
	return nil
}

// Segment of the content.
type Segment struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The index of a Part object within its parent Content object.
	PartIndex int32 `protobuf:"varint,1,opt,name=part_index,json=partIndex,proto3" json:"part_index,omitempty"`
	// Output only. Start index in the given Part, measured in bytes. Offset from
	// the start of the Part, inclusive, starting at zero.
	StartIndex int32 `protobuf:"varint,2,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// Output only. End index in the given Part, measured in bytes. Offset from
	// the start of the Part, exclusive, starting at zero.
	EndIndex int32 `protobuf:"varint,3,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	// Output only. The text corresponding to the segment from the response.
	Text string `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
}

func (x *Segment) Reset() {
	*x = Segment{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Segment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Segment) ProtoMessage() {}

func (x *Segment) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Segment.ProtoReflect.Descriptor instead.
func (*Segment) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{18}
}

func (x *Segment) GetPartIndex() int32 {
	if x != nil {
		return x.PartIndex
	}
	return 0
}

func (x *Segment) GetStartIndex() int32 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *Segment) GetEndIndex() int32 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

func (x *Segment) GetText() string {
	if x != nil {
		return x.Text
	}
	return ""
}

// Grounding chunk.
type GroundingChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Chunk type.
	//
	// Types that are assignable to ChunkType:
	//
	//	*GroundingChunk_Web_
	//	*GroundingChunk_RetrievedContext_
	//	*GroundingChunk_Maps_
	ChunkType isGroundingChunk_ChunkType `protobuf_oneof:"chunk_type"`
}

func (x *GroundingChunk) Reset() {
	*x = GroundingChunk{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingChunk) ProtoMessage() {}

func (x *GroundingChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingChunk.ProtoReflect.Descriptor instead.
func (*GroundingChunk) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{19}
}

func (m *GroundingChunk) GetChunkType() isGroundingChunk_ChunkType {
	if m != nil {
		return m.ChunkType
	}
	return nil
}

func (x *GroundingChunk) GetWeb() *GroundingChunk_Web {
	if x, ok := x.GetChunkType().(*GroundingChunk_Web_); ok {
		return x.Web
	}
	return nil
}

func (x *GroundingChunk) GetRetrievedContext() *GroundingChunk_RetrievedContext {
	if x, ok := x.GetChunkType().(*GroundingChunk_RetrievedContext_); ok {
		return x.RetrievedContext
	}
	return nil
}

func (x *GroundingChunk) GetMaps() *GroundingChunk_Maps {
	if x, ok := x.GetChunkType().(*GroundingChunk_Maps_); ok {
		return x.Maps
	}
	return nil
}

type isGroundingChunk_ChunkType interface {
	isGroundingChunk_ChunkType()
}

type GroundingChunk_Web_ struct {
	// Grounding chunk from the web.
	Web *GroundingChunk_Web `protobuf:"bytes,1,opt,name=web,proto3,oneof"`
}

type GroundingChunk_RetrievedContext_ struct {
	// Grounding chunk from context retrieved by the retrieval tools.
	RetrievedContext *GroundingChunk_RetrievedContext `protobuf:"bytes,2,opt,name=retrieved_context,json=retrievedContext,proto3,oneof"`
}

type GroundingChunk_Maps_ struct {
	// Grounding chunk from Google Maps.
	Maps *GroundingChunk_Maps `protobuf:"bytes,3,opt,name=maps,proto3,oneof"`
}

func (*GroundingChunk_Web_) isGroundingChunk_ChunkType() {}

func (*GroundingChunk_RetrievedContext_) isGroundingChunk_ChunkType() {}

func (*GroundingChunk_Maps_) isGroundingChunk_ChunkType() {}

// Grounding support.
type GroundingSupport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Segment of the content this support belongs to.
	Segment *Segment `protobuf:"bytes,1,opt,name=segment,proto3,oneof" json:"segment,omitempty"`
	// A list of indices (into 'grounding_chunk') specifying the
	// citations associated with the claim. For instance [1,3,4] means
	// that grounding_chunk[1], grounding_chunk[3],
	// grounding_chunk[4] are the retrieved content attributed to the claim.
	GroundingChunkIndices []int32 `protobuf:"varint,2,rep,packed,name=grounding_chunk_indices,json=groundingChunkIndices,proto3" json:"grounding_chunk_indices,omitempty"`
	// Confidence score of the support references. Ranges from 0 to 1. 1 is the
	// most confident. This list must have the same size as the
	// grounding_chunk_indices.
	ConfidenceScores []float32 `protobuf:"fixed32,3,rep,packed,name=confidence_scores,json=confidenceScores,proto3" json:"confidence_scores,omitempty"`
}

func (x *GroundingSupport) Reset() {
	*x = GroundingSupport{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingSupport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingSupport) ProtoMessage() {}

func (x *GroundingSupport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingSupport.ProtoReflect.Descriptor instead.
func (*GroundingSupport) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{20}
}

func (x *GroundingSupport) GetSegment() *Segment {
	if x != nil {
		return x.Segment
	}
	return nil
}

func (x *GroundingSupport) GetGroundingChunkIndices() []int32 {
	if x != nil {
		return x.GroundingChunkIndices
	}
	return nil
}

func (x *GroundingSupport) GetConfidenceScores() []float32 {
	if x != nil {
		return x.ConfidenceScores
	}
	return nil
}

// Metadata returned to client when grounding is enabled.
type GroundingMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Web search queries for the following-up web search.
	WebSearchQueries []string `protobuf:"bytes,1,rep,name=web_search_queries,json=webSearchQueries,proto3" json:"web_search_queries,omitempty"`
	// Optional. Google search entry for the following-up web searches.
	SearchEntryPoint *SearchEntryPoint `protobuf:"bytes,4,opt,name=search_entry_point,json=searchEntryPoint,proto3,oneof" json:"search_entry_point,omitempty"`
	// Optional. Queries executed by the retrieval tools.
	RetrievalQueries []string `protobuf:"bytes,3,rep,name=retrieval_queries,json=retrievalQueries,proto3" json:"retrieval_queries,omitempty"`
	// List of supporting references retrieved from specified grounding source.
	GroundingChunks []*GroundingChunk `protobuf:"bytes,5,rep,name=grounding_chunks,json=groundingChunks,proto3" json:"grounding_chunks,omitempty"`
	// Optional. List of grounding support.
	GroundingSupports []*GroundingSupport `protobuf:"bytes,6,rep,name=grounding_supports,json=groundingSupports,proto3" json:"grounding_supports,omitempty"`
	// Optional. Output only. Retrieval metadata.
	RetrievalMetadata *RetrievalMetadata `protobuf:"bytes,7,opt,name=retrieval_metadata,json=retrievalMetadata,proto3,oneof" json:"retrieval_metadata,omitempty"`
	// Optional. Output only. Resource name of the Google Maps widget context
	// token to be used with the PlacesContextElement widget to render contextual
	// data. This is populated only for Google Maps grounding.
	GoogleMapsWidgetContextToken *string `protobuf:"bytes,8,opt,name=google_maps_widget_context_token,json=googleMapsWidgetContextToken,proto3,oneof" json:"google_maps_widget_context_token,omitempty"`
	// List of source flagging uris. This is currently populated only for Google
	// Maps grounding.
	SourceFlaggingUris []*GroundingMetadata_SourceFlaggingUri `protobuf:"bytes,9,rep,name=source_flagging_uris,json=sourceFlaggingUris,proto3" json:"source_flagging_uris,omitempty"`
}

func (x *GroundingMetadata) Reset() {
	*x = GroundingMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingMetadata) ProtoMessage() {}

func (x *GroundingMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingMetadata.ProtoReflect.Descriptor instead.
func (*GroundingMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{21}
}

func (x *GroundingMetadata) GetWebSearchQueries() []string {
	if x != nil {
		return x.WebSearchQueries
	}
	return nil
}

func (x *GroundingMetadata) GetSearchEntryPoint() *SearchEntryPoint {
	if x != nil {
		return x.SearchEntryPoint
	}
	return nil
}

func (x *GroundingMetadata) GetRetrievalQueries() []string {
	if x != nil {
		return x.RetrievalQueries
	}
	return nil
}

func (x *GroundingMetadata) GetGroundingChunks() []*GroundingChunk {
	if x != nil {
		return x.GroundingChunks
	}
	return nil
}

func (x *GroundingMetadata) GetGroundingSupports() []*GroundingSupport {
	if x != nil {
		return x.GroundingSupports
	}
	return nil
}

func (x *GroundingMetadata) GetRetrievalMetadata() *RetrievalMetadata {
	if x != nil {
		return x.RetrievalMetadata
	}
	return nil
}

func (x *GroundingMetadata) GetGoogleMapsWidgetContextToken() string {
	if x != nil && x.GoogleMapsWidgetContextToken != nil {
		return *x.GoogleMapsWidgetContextToken
	}
	return ""
}

func (x *GroundingMetadata) GetSourceFlaggingUris() []*GroundingMetadata_SourceFlaggingUri {
	if x != nil {
		return x.SourceFlaggingUris
	}
	return nil
}

// Google search entry point.
type SearchEntryPoint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Web content snippet that can be embedded in a web page or an app
	// webview.
	RenderedContent string `protobuf:"bytes,1,opt,name=rendered_content,json=renderedContent,proto3" json:"rendered_content,omitempty"`
	// Optional. Base64 encoded JSON representing array of <search term, search
	// url> tuple.
	SdkBlob []byte `protobuf:"bytes,2,opt,name=sdk_blob,json=sdkBlob,proto3" json:"sdk_blob,omitempty"`
}

func (x *SearchEntryPoint) Reset() {
	*x = SearchEntryPoint{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchEntryPoint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntryPoint) ProtoMessage() {}

func (x *SearchEntryPoint) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntryPoint.ProtoReflect.Descriptor instead.
func (*SearchEntryPoint) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{22}
}

func (x *SearchEntryPoint) GetRenderedContent() string {
	if x != nil {
		return x.RenderedContent
	}
	return ""
}

func (x *SearchEntryPoint) GetSdkBlob() []byte {
	if x != nil {
		return x.SdkBlob
	}
	return nil
}

// Metadata related to retrieval in the grounding flow.
type RetrievalMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Score indicating how likely information from Google Search could
	// help answer the prompt. The score is in the range `[0, 1]`, where 0 is the
	// least likely and 1 is the most likely. This score is only populated when
	// Google Search grounding and dynamic retrieval is enabled. It will be
	// compared to the threshold to determine whether to trigger Google Search.
	GoogleSearchDynamicRetrievalScore float32 `protobuf:"fixed32,2,opt,name=google_search_dynamic_retrieval_score,json=googleSearchDynamicRetrievalScore,proto3" json:"google_search_dynamic_retrieval_score,omitempty"`
}

func (x *RetrievalMetadata) Reset() {
	*x = RetrievalMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RetrievalMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RetrievalMetadata) ProtoMessage() {}

func (x *RetrievalMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RetrievalMetadata.ProtoReflect.Descriptor instead.
func (*RetrievalMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{23}
}

func (x *RetrievalMetadata) GetGoogleSearchDynamicRetrievalScore() float32 {
	if x != nil {
		return x.GoogleSearchDynamicRetrievalScore
	}
	return 0
}

// Configuration for Model Armor integrations of prompt and responses.
type ModelArmorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the Model Armor template to use for prompt
	// sanitization.
	PromptTemplateName string `protobuf:"bytes,1,opt,name=prompt_template_name,json=promptTemplateName,proto3" json:"prompt_template_name,omitempty"`
	// Optional. The name of the Model Armor template to use for response
	// sanitization.
	ResponseTemplateName string `protobuf:"bytes,2,opt,name=response_template_name,json=responseTemplateName,proto3" json:"response_template_name,omitempty"`
}

func (x *ModelArmorConfig) Reset() {
	*x = ModelArmorConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModelArmorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModelArmorConfig) ProtoMessage() {}

func (x *ModelArmorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModelArmorConfig.ProtoReflect.Descriptor instead.
func (*ModelArmorConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{24}
}

func (x *ModelArmorConfig) GetPromptTemplateName() string {
	if x != nil {
		return x.PromptTemplateName
	}
	return ""
}

func (x *ModelArmorConfig) GetResponseTemplateName() string {
	if x != nil {
		return x.ResponseTemplateName
	}
	return ""
}

// Represents token counting info for a single modality.
type ModalityTokenCount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The modality associated with this token count.
	Modality Modality `protobuf:"varint,1,opt,name=modality,proto3,enum=google.cloud.aiplatform.v1beta1.Modality" json:"modality,omitempty"`
	// Number of tokens.
	TokenCount int32 `protobuf:"varint,2,opt,name=token_count,json=tokenCount,proto3" json:"token_count,omitempty"`
}

func (x *ModalityTokenCount) Reset() {
	*x = ModalityTokenCount{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ModalityTokenCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ModalityTokenCount) ProtoMessage() {}

func (x *ModalityTokenCount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ModalityTokenCount.ProtoReflect.Descriptor instead.
func (*ModalityTokenCount) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{25}
}

func (x *ModalityTokenCount) GetModality() Modality {
	if x != nil {
		return x.Modality
	}
	return Modality_MODALITY_UNSPECIFIED
}

func (x *ModalityTokenCount) GetTokenCount() int32 {
	if x != nil {
		return x.TokenCount
	}
	return 0
}

// The configuration for routing the request to a specific model.
type GenerationConfig_RoutingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Routing mode.
	//
	// Types that are assignable to RoutingConfig:
	//
	//	*GenerationConfig_RoutingConfig_AutoMode
	//	*GenerationConfig_RoutingConfig_ManualMode
	RoutingConfig isGenerationConfig_RoutingConfig_RoutingConfig `protobuf_oneof:"routing_config"`
}

func (x *GenerationConfig_RoutingConfig) Reset() {
	*x = GenerationConfig_RoutingConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerationConfig_RoutingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig_RoutingConfig) ProtoMessage() {}

func (x *GenerationConfig_RoutingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig_RoutingConfig.ProtoReflect.Descriptor instead.
func (*GenerationConfig_RoutingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 0}
}

func (m *GenerationConfig_RoutingConfig) GetRoutingConfig() isGenerationConfig_RoutingConfig_RoutingConfig {
	if m != nil {
		return m.RoutingConfig
	}
	return nil
}

func (x *GenerationConfig_RoutingConfig) GetAutoMode() *GenerationConfig_RoutingConfig_AutoRoutingMode {
	if x, ok := x.GetRoutingConfig().(*GenerationConfig_RoutingConfig_AutoMode); ok {
		return x.AutoMode
	}
	return nil
}

func (x *GenerationConfig_RoutingConfig) GetManualMode() *GenerationConfig_RoutingConfig_ManualRoutingMode {
	if x, ok := x.GetRoutingConfig().(*GenerationConfig_RoutingConfig_ManualMode); ok {
		return x.ManualMode
	}
	return nil
}

type isGenerationConfig_RoutingConfig_RoutingConfig interface {
	isGenerationConfig_RoutingConfig_RoutingConfig()
}

type GenerationConfig_RoutingConfig_AutoMode struct {
	// Automated routing.
	AutoMode *GenerationConfig_RoutingConfig_AutoRoutingMode `protobuf:"bytes,1,opt,name=auto_mode,json=autoMode,proto3,oneof"`
}

type GenerationConfig_RoutingConfig_ManualMode struct {
	// Manual routing.
	ManualMode *GenerationConfig_RoutingConfig_ManualRoutingMode `protobuf:"bytes,2,opt,name=manual_mode,json=manualMode,proto3,oneof"`
}

func (*GenerationConfig_RoutingConfig_AutoMode) isGenerationConfig_RoutingConfig_RoutingConfig() {}

func (*GenerationConfig_RoutingConfig_ManualMode) isGenerationConfig_RoutingConfig_RoutingConfig() {}

// Config for thinking features.
type GenerationConfig_ThinkingConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Indicates whether to include thoughts in the response.
	// If true, thoughts are returned only when available.
	IncludeThoughts *bool `protobuf:"varint,1,opt,name=include_thoughts,json=includeThoughts,proto3,oneof" json:"include_thoughts,omitempty"`
	// Optional. Indicates the thinking budget in tokens.
	// This is only applied when enable_thinking is true.
	ThinkingBudget *int32 `protobuf:"varint,3,opt,name=thinking_budget,json=thinkingBudget,proto3,oneof" json:"thinking_budget,omitempty"`
}

func (x *GenerationConfig_ThinkingConfig) Reset() {
	*x = GenerationConfig_ThinkingConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerationConfig_ThinkingConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig_ThinkingConfig) ProtoMessage() {}

func (x *GenerationConfig_ThinkingConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig_ThinkingConfig.ProtoReflect.Descriptor instead.
func (*GenerationConfig_ThinkingConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 1}
}

func (x *GenerationConfig_ThinkingConfig) GetIncludeThoughts() bool {
	if x != nil && x.IncludeThoughts != nil {
		return *x.IncludeThoughts
	}
	return false
}

func (x *GenerationConfig_ThinkingConfig) GetThinkingBudget() int32 {
	if x != nil && x.ThinkingBudget != nil {
		return *x.ThinkingBudget
	}
	return 0
}

// Config for model selection.
type GenerationConfig_ModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Feature selection preference.
	FeatureSelectionPreference GenerationConfig_ModelConfig_FeatureSelectionPreference `protobuf:"varint,1,opt,name=feature_selection_preference,json=featureSelectionPreference,proto3,enum=google.cloud.aiplatform.v1beta1.GenerationConfig_ModelConfig_FeatureSelectionPreference" json:"feature_selection_preference,omitempty"`
}

func (x *GenerationConfig_ModelConfig) Reset() {
	*x = GenerationConfig_ModelConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerationConfig_ModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig_ModelConfig) ProtoMessage() {}

func (x *GenerationConfig_ModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig_ModelConfig.ProtoReflect.Descriptor instead.
func (*GenerationConfig_ModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 2}
}

func (x *GenerationConfig_ModelConfig) GetFeatureSelectionPreference() GenerationConfig_ModelConfig_FeatureSelectionPreference {
	if x != nil {
		return x.FeatureSelectionPreference
	}
	return GenerationConfig_ModelConfig_FEATURE_SELECTION_PREFERENCE_UNSPECIFIED
}

// When automated routing is specified, the routing will be determined by
// the pretrained routing model and customer provided model routing
// preference.
type GenerationConfig_RoutingConfig_AutoRoutingMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The model routing preference.
	ModelRoutingPreference *GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference `protobuf:"varint,1,opt,name=model_routing_preference,json=modelRoutingPreference,proto3,enum=google.cloud.aiplatform.v1beta1.GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference,oneof" json:"model_routing_preference,omitempty"`
}

func (x *GenerationConfig_RoutingConfig_AutoRoutingMode) Reset() {
	*x = GenerationConfig_RoutingConfig_AutoRoutingMode{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerationConfig_RoutingConfig_AutoRoutingMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig_RoutingConfig_AutoRoutingMode) ProtoMessage() {}

func (x *GenerationConfig_RoutingConfig_AutoRoutingMode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig_RoutingConfig_AutoRoutingMode.ProtoReflect.Descriptor instead.
func (*GenerationConfig_RoutingConfig_AutoRoutingMode) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 0, 0}
}

func (x *GenerationConfig_RoutingConfig_AutoRoutingMode) GetModelRoutingPreference() GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference {
	if x != nil && x.ModelRoutingPreference != nil {
		return *x.ModelRoutingPreference
	}
	return GenerationConfig_RoutingConfig_AutoRoutingMode_UNKNOWN
}

// When manual routing is set, the specified model will be used directly.
type GenerationConfig_RoutingConfig_ManualRoutingMode struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The model name to use. Only the public LLM models are accepted. e.g.
	// 'gemini-1.5-pro-001'.
	ModelName *string `protobuf:"bytes,1,opt,name=model_name,json=modelName,proto3,oneof" json:"model_name,omitempty"`
}

func (x *GenerationConfig_RoutingConfig_ManualRoutingMode) Reset() {
	*x = GenerationConfig_RoutingConfig_ManualRoutingMode{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerationConfig_RoutingConfig_ManualRoutingMode) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig_RoutingConfig_ManualRoutingMode) ProtoMessage() {}

func (x *GenerationConfig_RoutingConfig_ManualRoutingMode) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig_RoutingConfig_ManualRoutingMode.ProtoReflect.Descriptor instead.
func (*GenerationConfig_RoutingConfig_ManualRoutingMode) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9, 0, 1}
}

func (x *GenerationConfig_RoutingConfig_ManualRoutingMode) GetModelName() string {
	if x != nil && x.ModelName != nil {
		return *x.ModelName
	}
	return ""
}

// Candidate for the logprobs token and score.
type LogprobsResult_Candidate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The candidate’s token string value.
	Token *string `protobuf:"bytes,1,opt,name=token,proto3,oneof" json:"token,omitempty"`
	// The candidate’s token id value.
	TokenId *int32 `protobuf:"varint,3,opt,name=token_id,json=tokenId,proto3,oneof" json:"token_id,omitempty"`
	// The candidate's log probability.
	LogProbability *float32 `protobuf:"fixed32,2,opt,name=log_probability,json=logProbability,proto3,oneof" json:"log_probability,omitempty"`
}

func (x *LogprobsResult_Candidate) Reset() {
	*x = LogprobsResult_Candidate{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogprobsResult_Candidate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogprobsResult_Candidate) ProtoMessage() {}

func (x *LogprobsResult_Candidate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogprobsResult_Candidate.ProtoReflect.Descriptor instead.
func (*LogprobsResult_Candidate) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{17, 0}
}

func (x *LogprobsResult_Candidate) GetToken() string {
	if x != nil && x.Token != nil {
		return *x.Token
	}
	return ""
}

func (x *LogprobsResult_Candidate) GetTokenId() int32 {
	if x != nil && x.TokenId != nil {
		return *x.TokenId
	}
	return 0
}

func (x *LogprobsResult_Candidate) GetLogProbability() float32 {
	if x != nil && x.LogProbability != nil {
		return *x.LogProbability
	}
	return 0
}

// Candidates with top log probabilities at each decoding step.
type LogprobsResult_TopCandidates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sorted by log probability in descending order.
	Candidates []*LogprobsResult_Candidate `protobuf:"bytes,1,rep,name=candidates,proto3" json:"candidates,omitempty"`
}

func (x *LogprobsResult_TopCandidates) Reset() {
	*x = LogprobsResult_TopCandidates{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LogprobsResult_TopCandidates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LogprobsResult_TopCandidates) ProtoMessage() {}

func (x *LogprobsResult_TopCandidates) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LogprobsResult_TopCandidates.ProtoReflect.Descriptor instead.
func (*LogprobsResult_TopCandidates) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{17, 1}
}

func (x *LogprobsResult_TopCandidates) GetCandidates() []*LogprobsResult_Candidate {
	if x != nil {
		return x.Candidates
	}
	return nil
}

// Chunk from the web.
type GroundingChunk_Web struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI reference of the chunk.
	Uri *string `protobuf:"bytes,1,opt,name=uri,proto3,oneof" json:"uri,omitempty"`
	// Title of the chunk.
	Title *string `protobuf:"bytes,2,opt,name=title,proto3,oneof" json:"title,omitempty"`
}

func (x *GroundingChunk_Web) Reset() {
	*x = GroundingChunk_Web{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingChunk_Web) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingChunk_Web) ProtoMessage() {}

func (x *GroundingChunk_Web) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingChunk_Web.ProtoReflect.Descriptor instead.
func (*GroundingChunk_Web) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{19, 0}
}

func (x *GroundingChunk_Web) GetUri() string {
	if x != nil && x.Uri != nil {
		return *x.Uri
	}
	return ""
}

func (x *GroundingChunk_Web) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

// Chunk from context retrieved by the retrieval tools.
type GroundingChunk_RetrievedContext struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Tool-specific details about the retrieved context.
	//
	// Types that are assignable to ContextDetails:
	//
	//	*GroundingChunk_RetrievedContext_RagChunk
	ContextDetails isGroundingChunk_RetrievedContext_ContextDetails `protobuf_oneof:"context_details"`
	// URI reference of the attribution.
	Uri *string `protobuf:"bytes,1,opt,name=uri,proto3,oneof" json:"uri,omitempty"`
	// Title of the attribution.
	Title *string `protobuf:"bytes,2,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Text of the attribution.
	Text *string `protobuf:"bytes,3,opt,name=text,proto3,oneof" json:"text,omitempty"`
	// Output only. The full document name for the referenced Vertex AI Search
	// document.
	DocumentName *string `protobuf:"bytes,6,opt,name=document_name,json=documentName,proto3,oneof" json:"document_name,omitempty"`
}

func (x *GroundingChunk_RetrievedContext) Reset() {
	*x = GroundingChunk_RetrievedContext{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingChunk_RetrievedContext) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingChunk_RetrievedContext) ProtoMessage() {}

func (x *GroundingChunk_RetrievedContext) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingChunk_RetrievedContext.ProtoReflect.Descriptor instead.
func (*GroundingChunk_RetrievedContext) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{19, 1}
}

func (m *GroundingChunk_RetrievedContext) GetContextDetails() isGroundingChunk_RetrievedContext_ContextDetails {
	if m != nil {
		return m.ContextDetails
	}
	return nil
}

func (x *GroundingChunk_RetrievedContext) GetRagChunk() *RagChunk {
	if x, ok := x.GetContextDetails().(*GroundingChunk_RetrievedContext_RagChunk); ok {
		return x.RagChunk
	}
	return nil
}

func (x *GroundingChunk_RetrievedContext) GetUri() string {
	if x != nil && x.Uri != nil {
		return *x.Uri
	}
	return ""
}

func (x *GroundingChunk_RetrievedContext) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *GroundingChunk_RetrievedContext) GetText() string {
	if x != nil && x.Text != nil {
		return *x.Text
	}
	return ""
}

func (x *GroundingChunk_RetrievedContext) GetDocumentName() string {
	if x != nil && x.DocumentName != nil {
		return *x.DocumentName
	}
	return ""
}

type isGroundingChunk_RetrievedContext_ContextDetails interface {
	isGroundingChunk_RetrievedContext_ContextDetails()
}

type GroundingChunk_RetrievedContext_RagChunk struct {
	// Additional context for the RAG retrieval result. This is only populated
	// when using the RAG retrieval tool.
	RagChunk *RagChunk `protobuf:"bytes,4,opt,name=rag_chunk,json=ragChunk,proto3,oneof"`
}

func (*GroundingChunk_RetrievedContext_RagChunk) isGroundingChunk_RetrievedContext_ContextDetails() {}

// Chunk from Google Maps.
type GroundingChunk_Maps struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URI reference of the chunk.
	Uri *string `protobuf:"bytes,1,opt,name=uri,proto3,oneof" json:"uri,omitempty"`
	// Title of the chunk.
	Title *string `protobuf:"bytes,2,opt,name=title,proto3,oneof" json:"title,omitempty"`
	// Text of the chunk.
	Text *string `protobuf:"bytes,3,opt,name=text,proto3,oneof" json:"text,omitempty"`
	// This Place's resource name, in `places/{place_id}` format.  Can be used
	// to look up the Place.
	PlaceId *string `protobuf:"bytes,4,opt,name=place_id,json=placeId,proto3,oneof" json:"place_id,omitempty"`
	// Sources used to generate the place answer.
	// This includes review snippets and photos that were used to generate the
	// answer, as well as uris to flag content.
	PlaceAnswerSources *GroundingChunk_Maps_PlaceAnswerSources `protobuf:"bytes,5,opt,name=place_answer_sources,json=placeAnswerSources,proto3" json:"place_answer_sources,omitempty"`
}

func (x *GroundingChunk_Maps) Reset() {
	*x = GroundingChunk_Maps{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingChunk_Maps) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingChunk_Maps) ProtoMessage() {}

func (x *GroundingChunk_Maps) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingChunk_Maps.ProtoReflect.Descriptor instead.
func (*GroundingChunk_Maps) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{19, 2}
}

func (x *GroundingChunk_Maps) GetUri() string {
	if x != nil && x.Uri != nil {
		return *x.Uri
	}
	return ""
}

func (x *GroundingChunk_Maps) GetTitle() string {
	if x != nil && x.Title != nil {
		return *x.Title
	}
	return ""
}

func (x *GroundingChunk_Maps) GetText() string {
	if x != nil && x.Text != nil {
		return *x.Text
	}
	return ""
}

func (x *GroundingChunk_Maps) GetPlaceId() string {
	if x != nil && x.PlaceId != nil {
		return *x.PlaceId
	}
	return ""
}

func (x *GroundingChunk_Maps) GetPlaceAnswerSources() *GroundingChunk_Maps_PlaceAnswerSources {
	if x != nil {
		return x.PlaceAnswerSources
	}
	return nil
}

type GroundingChunk_Maps_PlaceAnswerSources struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Snippets of reviews that are used to generate the answer.
	ReviewSnippets []*GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet `protobuf:"bytes,1,rep,name=review_snippets,json=reviewSnippets,proto3" json:"review_snippets,omitempty"`
}

func (x *GroundingChunk_Maps_PlaceAnswerSources) Reset() {
	*x = GroundingChunk_Maps_PlaceAnswerSources{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingChunk_Maps_PlaceAnswerSources) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingChunk_Maps_PlaceAnswerSources) ProtoMessage() {}

func (x *GroundingChunk_Maps_PlaceAnswerSources) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingChunk_Maps_PlaceAnswerSources.ProtoReflect.Descriptor instead.
func (*GroundingChunk_Maps_PlaceAnswerSources) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{19, 2, 0}
}

func (x *GroundingChunk_Maps_PlaceAnswerSources) GetReviewSnippets() []*GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet {
	if x != nil {
		return x.ReviewSnippets
	}
	return nil
}

// Encapsulates a review snippet.
type GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Id of the review referencing the place.
	ReviewId string `protobuf:"bytes,1,opt,name=review_id,json=reviewId,proto3" json:"review_id,omitempty"`
	// A link to show the review on Google Maps.
	GoogleMapsUri string `protobuf:"bytes,2,opt,name=google_maps_uri,json=googleMapsUri,proto3" json:"google_maps_uri,omitempty"`
	// Title of the review.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
}

func (x *GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet) Reset() {
	*x = GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet) ProtoMessage() {}

func (x *GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet.ProtoReflect.Descriptor instead.
func (*GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{19, 2, 0, 0}
}

func (x *GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet) GetReviewId() string {
	if x != nil {
		return x.ReviewId
	}
	return ""
}

func (x *GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet) GetGoogleMapsUri() string {
	if x != nil {
		return x.GoogleMapsUri
	}
	return ""
}

func (x *GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

// Source content flagging uri for a place or review. This is currently
// populated only for Google Maps grounding.
type GroundingMetadata_SourceFlaggingUri struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Id of the place or review.
	SourceId string `protobuf:"bytes,1,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// A link where users can flag a problem with the source (place or review).
	// (-- The link is generated by Google and it does not contain
	// information from the user query. It may contain information of the
	// content it is flagging, which can be used to identify places. --)
	FlagContentUri string `protobuf:"bytes,2,opt,name=flag_content_uri,json=flagContentUri,proto3" json:"flag_content_uri,omitempty"`
}

func (x *GroundingMetadata_SourceFlaggingUri) Reset() {
	*x = GroundingMetadata_SourceFlaggingUri{}
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundingMetadata_SourceFlaggingUri) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundingMetadata_SourceFlaggingUri) ProtoMessage() {}

func (x *GroundingMetadata_SourceFlaggingUri) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundingMetadata_SourceFlaggingUri.ProtoReflect.Descriptor instead.
func (*GroundingMetadata_SourceFlaggingUri) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{21, 0}
}

func (x *GroundingMetadata_SourceFlaggingUri) GetSourceId() string {
	if x != nil {
		return x.SourceId
	}
	return ""
}

func (x *GroundingMetadata_SourceFlaggingUri) GetFlagContentUri() string {
	if x != nil {
		return x.FlagContentUri
	}
	return ""
}

var File_google_cloud_aiplatform_v1beta1_content_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_content_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6f, 0x70,
	0x65, 0x6e, 0x61, 0x70, 0x69, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x6f, 0x6f,
	0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x76, 0x65, 0x72, 0x74, 0x65, 0x78, 0x5f,
	0x72, 0x61, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x64, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x17, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x70, 0x61, 0x72, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x22, 0x96, 0x06, 0x0a, 0x04, 0x50,
	0x61, 0x72, 0x74, 0x12, 0x19, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4d,
	0x0a, 0x0b, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6c, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x00, 0x52, 0x0a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x4d, 0x0a,
	0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0d,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61,
	0x6c, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x65, 0x0a, 0x11, 0x66, 0x75, 0x6e, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5f,
	0x0a, 0x0f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x0e, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x6f, 0x0a, 0x15, 0x63, 0x6f, 0x64, 0x65, 0x5f, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x64, 0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x13, 0x63, 0x6f, 0x64,
	0x65, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x5c, 0x0a, 0x0e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52,
	0x0d, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x1d,
	0x0a, 0x07, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x12, 0x30, 0x0a,
	0x11, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x74,
	0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42,
	0x06, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0x22, 0x41, 0x0a, 0x04, 0x42, 0x6c, 0x6f, 0x62, 0x12, 0x20, 0x0a, 0x09, 0x6d,
	0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x4c, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x6c,
	0x65, 0x55, 0x72, 0x69, 0x22, 0x91, 0x01, 0x0a, 0x0d, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x41, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x3d, 0x0a, 0x0a, 0x65, 0x6e, 0x64,
	0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x65,
	0x6e, 0x64, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0x48, 0x0a, 0x13, 0x50, 0x72, 0x65, 0x62,
	0x75, 0x69, 0x6c, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x22, 0x0a, 0x0a, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0x89, 0x01, 0x0a, 0x0b, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x6a, 0x0a, 0x15, 0x70, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x5f, 0x76,
	0x6f, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x56, 0x6f, 0x69, 0x63,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x13, 0x70, 0x72, 0x65, 0x62, 0x75,
	0x69, 0x6c, 0x74, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x0e,
	0x0a, 0x0c, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x5f,
	0x0a, 0x0c, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x4f,
	0x0a, 0x0c, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x0b, 0x76, 0x6f, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22,
	0x4b, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2b,
	0x0a, 0x0c, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x73, 0x70,
	0x65, 0x63, 0x74, 0x52, 0x61, 0x74, 0x69, 0x6f, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f,
	0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x22, 0xe4, 0x18, 0x0a,
	0x10, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x2a, 0x0a, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x74,
	0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a,
	0x05, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x01, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x50, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05,
	0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x02, 0x52, 0x04, 0x74, 0x6f, 0x70, 0x4b, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x0f, 0x63,
	0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x0e, 0x63, 0x61, 0x6e,
	0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x34,
	0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04,
	0x52, 0x0f, 0x6d, 0x61, 0x78, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x65, 0x71,
	0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0d, 0x73, 0x74, 0x6f, 0x70, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x12, 0x35, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x6f, 0x67,
	0x70, 0x72, 0x6f, 0x62, 0x73, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x05, 0x52, 0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4c, 0x6f, 0x67, 0x70,
	0x72, 0x6f, 0x62, 0x73, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x08, 0x6c, 0x6f, 0x67, 0x70, 0x72,
	0x6f, 0x62, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x06,
	0x52, 0x08, 0x6c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x88, 0x01, 0x01, 0x12, 0x33, 0x0a,
	0x10, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74,
	0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x07, 0x52, 0x0f,
	0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x50, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x88,
	0x01, 0x01, 0x12, 0x35, 0x0a, 0x11, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f,
	0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x08, 0x52, 0x10, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x50,
	0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x1c, 0x0a, 0x04, 0x73, 0x65, 0x65,
	0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x09, 0x52, 0x04,
	0x73, 0x65, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x72, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x4d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5a, 0x0a, 0x0f, 0x72, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x0a, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x88, 0x01, 0x01, 0x12, 0x52, 0x0a, 0x14, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x1c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x0b, 0x52, 0x12, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4a, 0x73, 0x6f,
	0x6e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x88, 0x01, 0x01, 0x12, 0x70, 0x0a, 0x0e, 0x72, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0c, 0x52, 0x0d, 0x72, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x0f,
	0x61, 0x75, 0x64, 0x69, 0x6f, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x14, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x0d, 0x52, 0x0e, 0x61, 0x75,
	0x64, 0x69, 0x6f, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x88, 0x01, 0x01, 0x12,
	0x70, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x61,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x15, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x76, 0x0a, 0x10, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x0e, 0x52, 0x0f, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x73, 0x6f,
	0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x5c, 0x0a, 0x0d, 0x73, 0x70, 0x65,
	0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x0f, 0x52, 0x0c, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x12, 0x6e, 0x0a, 0x0f, 0x74, 0x68, 0x69, 0x6e, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x54, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x59,
	0x0a, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x1e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x10, 0x52, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x1a, 0x8a, 0x05, 0x0a, 0x0d, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x6e, 0x0a, 0x09, 0x61,
	0x75, 0x74, 0x6f, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x41, 0x75, 0x74, 0x6f, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x48,
	0x00, 0x52, 0x08, 0x61, 0x75, 0x74, 0x6f, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x74, 0x0a, 0x0b, 0x6d,
	0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x51, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d,
	0x6f, 0x64, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x4d, 0x6f, 0x64,
	0x65, 0x1a, 0xb8, 0x02, 0x0a, 0x0f, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0xa5, 0x01, 0x0a, 0x18, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x66, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x52, 0x6f, 0x75, 0x74,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x75, 0x74, 0x6f, 0x52, 0x6f,
	0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64, 0x65, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x48, 0x00, 0x52, 0x16, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x22, 0x60, 0x0a,
	0x16, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f,
	0x57, 0x4e, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x49,
	0x5a, 0x45, 0x5f, 0x51, 0x55, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08,
	0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x50, 0x52,
	0x49, 0x4f, 0x52, 0x49, 0x54, 0x49, 0x5a, 0x45, 0x5f, 0x43, 0x4f, 0x53, 0x54, 0x10, 0x03, 0x42,
	0x1b, 0x0a, 0x19, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x46, 0x0a, 0x11,
	0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x52, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x6f, 0x64,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61,
	0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0xa1, 0x01, 0x0a, 0x0e, 0x54, 0x68, 0x69, 0x6e, 0x6b,
	0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x33, 0x0a, 0x10, 0x69, 0x6e, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x54, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x88, 0x01, 0x01, 0x12, 0x31,
	0x0a, 0x0f, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0e,
	0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x88, 0x01,
	0x01, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x68,
	0x6f, 0x75, 0x67, 0x68, 0x74, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x74, 0x68, 0x69, 0x6e, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74, 0x1a, 0xb7, 0x02, 0x0a, 0x0b, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x9f, 0x01, 0x0a, 0x1c, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x1a, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x85, 0x01, 0x0a,
	0x1a, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x50, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x2c, 0x0a, 0x28, 0x46,
	0x45, 0x41, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x53, 0x45, 0x4c, 0x45, 0x43, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x50, 0x52, 0x45, 0x46, 0x45, 0x52, 0x45, 0x4e, 0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x49,
	0x4f, 0x52, 0x49, 0x54, 0x49, 0x5a, 0x45, 0x5f, 0x51, 0x55, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x10,
	0x01, 0x12, 0x0c, 0x0a, 0x08, 0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x02, 0x12,
	0x13, 0x0a, 0x0f, 0x50, 0x52, 0x49, 0x4f, 0x52, 0x49, 0x54, 0x49, 0x5a, 0x45, 0x5f, 0x43, 0x4f,
	0x53, 0x54, 0x10, 0x03, 0x22, 0x44, 0x0a, 0x08, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x18, 0x0a, 0x14, 0x4d, 0x4f, 0x44, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45,
	0x58, 0x54, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x02, 0x12,
	0x09, 0x0a, 0x05, 0x41, 0x55, 0x44, 0x49, 0x4f, 0x10, 0x03, 0x22, 0x85, 0x01, 0x0a, 0x0f, 0x4d,
	0x65, 0x64, 0x69, 0x61, 0x52, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x20,
	0x0a, 0x1c, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x18, 0x0a, 0x14, 0x4d, 0x45, 0x44, 0x49, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55,
	0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x45,
	0x44, 0x49, 0x41, 0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x4d,
	0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x4d, 0x45, 0x44, 0x49, 0x41,
	0x5f, 0x52, 0x45, 0x53, 0x4f, 0x4c, 0x55, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x48, 0x49, 0x47, 0x48,
	0x10, 0x03, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x70, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d,
	0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x42, 0x14, 0x0a, 0x12, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6c, 0x6f,
	0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x6c, 0x6f, 0x67, 0x70, 0x72,
	0x6f, 0x62, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x66, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x70, 0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x42, 0x07,
	0x0a, 0x05, 0x5f, 0x73, 0x65, 0x65, 0x64, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x72, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42, 0x17, 0x0a, 0x15, 0x5f,
	0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x61, 0x75, 0x64, 0x69,
	0x6f, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x13, 0x0a, 0x11, 0x5f,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x22, 0x97, 0x04, 0x0a, 0x0d, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x4e, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x61, 0x72, 0x6d, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x61, 0x74,
	0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x64, 0x0a, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f,
	0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x48, 0x61, 0x72, 0x6d, 0x42, 0x6c, 0x6f,
	0x63, 0x6b, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x5b, 0x0a, 0x06, 0x6d,
	0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x48, 0x61, 0x72, 0x6d,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x22, 0x9d, 0x01, 0x0a, 0x12, 0x48, 0x61, 0x72,
	0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12,
	0x24, 0x0a, 0x20, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x54, 0x48,
	0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a, 0x13, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4c,
	0x4f, 0x57, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x10, 0x01, 0x12, 0x1a,
	0x0a, 0x16, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x5f, 0x41,
	0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45, 0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x42, 0x4c,
	0x4f, 0x43, 0x4b, 0x5f, 0x4f, 0x4e, 0x4c, 0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x12,
	0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x04, 0x12,
	0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x05, 0x22, 0x53, 0x0a, 0x0f, 0x48, 0x61, 0x72, 0x6d,
	0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x21, 0x0a, 0x1d, 0x48,
	0x41, 0x52, 0x4d, 0x5f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c,
	0x0a, 0x08, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b,
	0x50, 0x52, 0x4f, 0x42, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x10, 0x02, 0x22, 0x99, 0x05,
	0x0a, 0x0c, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x4e,
	0x0a, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x48, 0x61, 0x72, 0x6d, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x64,
	0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x2e, 0x48, 0x61, 0x72, 0x6d, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x79, 0x12, 0x30, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x79, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x5b, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69,
	0x74, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x48, 0x61, 0x72, 0x6d, 0x53, 0x65, 0x76, 0x65,
	0x72, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x12,
	0x1d, 0x0a, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x22, 0x62,
	0x0a, 0x0f, 0x48, 0x61, 0x72, 0x6d, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
	0x79, 0x12, 0x20, 0x0a, 0x1c, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x50, 0x52, 0x4f, 0x42, 0x41, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x45, 0x47, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c,
	0x45, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06,
	0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48,
	0x10, 0x04, 0x22, 0x94, 0x01, 0x0a, 0x0c, 0x48, 0x61, 0x72, 0x6d, 0x53, 0x65, 0x76, 0x65, 0x72,
	0x69, 0x74, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x53, 0x45, 0x56, 0x45,
	0x52, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52,
	0x49, 0x54, 0x59, 0x5f, 0x4e, 0x45, 0x47, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x01,
	0x12, 0x15, 0x0a, 0x11, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54,
	0x59, 0x5f, 0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x18, 0x0a, 0x14, 0x48, 0x41, 0x52, 0x4d, 0x5f,
	0x53, 0x45, 0x56, 0x45, 0x52, 0x49, 0x54, 0x59, 0x5f, 0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x10,
	0x03, 0x12, 0x16, 0x0a, 0x12, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x53, 0x45, 0x56, 0x45, 0x52, 0x49,
	0x54, 0x59, 0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x04, 0x22, 0x60, 0x0a, 0x10, 0x43, 0x69, 0x74,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4c, 0x0a,
	0x09, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x09, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xe6, 0x01, 0x0a, 0x08,
	0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x20,
	0x0a, 0x09, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73,
	0x65, 0x12, 0x41, 0x0a, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x61, 0x74, 0x65, 0x22, 0x81, 0x08, 0x0a, 0x09, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x47, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x26, 0x0a, 0x0c, 0x61, 0x76, 0x67, 0x5f, 0x6c, 0x6f,
	0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x61, 0x76, 0x67, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x12, 0x5d,
	0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f,
	0x62, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6c,
	0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x61, 0x0a,
	0x0d, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x2e, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0c, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x12, 0x59, 0x0a, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x61,
	0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2f, 0x0a, 0x0e, 0x66,
	0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x66, 0x69, 0x6e, 0x69,
	0x73, 0x68, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x11,
	0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x66, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x6a, 0x0a, 0x14, 0x75, 0x72, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x72, 0x6c, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x12, 0x75, 0x72, 0x6c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xcd, 0x01, 0x0a, 0x0c, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48,
	0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x4f, 0x50, 0x10, 0x01, 0x12,
	0x0e, 0x0a, 0x0a, 0x4d, 0x41, 0x58, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x53, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x53, 0x41, 0x46, 0x45, 0x54, 0x59, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x52,
	0x45, 0x43, 0x49, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4f,
	0x54, 0x48, 0x45, 0x52, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x4c,
	0x49, 0x53, 0x54, 0x10, 0x06, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x4f, 0x48, 0x49, 0x42, 0x49,
	0x54, 0x45, 0x44, 0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x07, 0x12, 0x08, 0x0a,
	0x04, 0x53, 0x50, 0x49, 0x49, 0x10, 0x08, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x41, 0x4c, 0x46, 0x4f,
	0x52, 0x4d, 0x45, 0x44, 0x5f, 0x46, 0x55, 0x4e, 0x43, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x41,
	0x4c, 0x4c, 0x10, 0x09, 0x12, 0x0f, 0x0a, 0x0b, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x41, 0x52,
	0x4d, 0x4f, 0x52, 0x10, 0x0a, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x6a, 0x0a, 0x12, 0x55, 0x72, 0x6c, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x54,
	0x0a, 0x0c, 0x75, 0x72, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x72, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x72, 0x6c, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x22, 0xa3, 0x02, 0x0a, 0x0b, 0x55, 0x72, 0x6c, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65,
	0x64, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x65, 0x64, 0x55, 0x72, 0x6c, 0x12, 0x71, 0x0a, 0x14, 0x75, 0x72, 0x6c,
	0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x55, 0x72, 0x6c, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x55, 0x72, 0x6c, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76,
	0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x12, 0x75, 0x72, 0x6c, 0x52, 0x65, 0x74,
	0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0x7c, 0x0a, 0x12,
	0x55, 0x72, 0x6c, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x12, 0x24, 0x0a, 0x20, 0x55, 0x52, 0x4c, 0x5f, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45,
	0x56, 0x41, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x20, 0x0a, 0x1c, 0x55, 0x52, 0x4c, 0x5f,
	0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x55, 0x53,
	0x5f, 0x53, 0x55, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x01, 0x12, 0x1e, 0x0a, 0x1a, 0x55, 0x52,
	0x4c, 0x5f, 0x52, 0x45, 0x54, 0x52, 0x49, 0x45, 0x56, 0x41, 0x4c, 0x5f, 0x53, 0x54, 0x41, 0x54,
	0x55, 0x53, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x22, 0xec, 0x03, 0x0a, 0x0e, 0x4c,
	0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x64, 0x0a,
	0x0e, 0x74, 0x6f, 0x70, 0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e, 0x54, 0x6f, 0x70, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x52, 0x0d, 0x74, 0x6f, 0x70, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x73, 0x12, 0x66, 0x0a, 0x11, 0x63, 0x68, 0x6f, 0x73, 0x65, 0x6e, 0x5f, 0x63, 0x61,
	0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2e,
	0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x10, 0x63, 0x68, 0x6f, 0x73, 0x65,
	0x6e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x1a, 0x9f, 0x01, 0x0a, 0x09,
	0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x08, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x48, 0x01, 0x52, 0x07, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x49,
	0x64, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x6c, 0x6f, 0x67, 0x5f, 0x70, 0x72, 0x6f, 0x62,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x48, 0x02, 0x52,
	0x0e, 0x6c, 0x6f, 0x67, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x88,
	0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x0b, 0x0a, 0x09,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x69, 0x64, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x6c, 0x6f,
	0x67, 0x5f, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x1a, 0x6a, 0x0a,
	0x0d, 0x54, 0x6f, 0x70, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x12, 0x59,
	0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x6f, 0x67, 0x70, 0x72, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x63,
	0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x22, 0x8e, 0x01, 0x0a, 0x07, 0x53, 0x65,
	0x67, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x70, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12,
	0x20, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65,
	0x78, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x22, 0xa2, 0x09, 0x0a, 0x0e, 0x47,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x47, 0x0a,
	0x03, 0x77, 0x65, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x2e, 0x57, 0x65, 0x62, 0x48,
	0x00, 0x52, 0x03, 0x77, 0x65, 0x62, 0x12, 0x6f, 0x0a, 0x11, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65,
	0x76, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x48, 0x00, 0x52, 0x10, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6d, 0x61, 0x70, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x48, 0x00, 0x52, 0x04, 0x6d,
	0x61, 0x70, 0x73, 0x1a, 0x49, 0x0a, 0x03, 0x57, 0x65, 0x62, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x03, 0x75, 0x72, 0x69, 0x88, 0x01,
	0x01, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x01, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x42, 0x06, 0x0a, 0x04,
	0x5f, 0x75, 0x72, 0x69, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x1a, 0x96,
	0x02, 0x0a, 0x10, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x12, 0x48, 0x0a, 0x09, 0x72, 0x61, 0x67, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x61, 0x67, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x48, 0x00, 0x52, 0x08, 0x72, 0x61, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x15, 0x0a,
	0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x03, 0x75, 0x72,
	0x69, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88, 0x01, 0x01, 0x12,
	0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52,
	0x04, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2d, 0x0a, 0x0d, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x04, 0x52, 0x0c, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x42, 0x11, 0x0a, 0x0f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x75,
	0x72, 0x69, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x07, 0x0a, 0x05,
	0x5f, 0x74, 0x65, 0x78, 0x74, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x1a, 0x97, 0x04, 0x0a, 0x04, 0x4d, 0x61, 0x70, 0x73,
	0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x03, 0x75, 0x72, 0x69, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x17, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x02, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x08, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52,
	0x07, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x79, 0x0a, 0x14, 0x70,
	0x6c, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e,
	0x50, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x52, 0x12, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0x80, 0x02, 0x0a, 0x12, 0x50, 0x6c, 0x61, 0x63, 0x65,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x7e, 0x0a,
	0x0f, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x73, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
	0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x2e, 0x4d, 0x61, 0x70, 0x73, 0x2e, 0x50, 0x6c, 0x61,
	0x63, 0x65, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x52, 0x0e, 0x72,
	0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x73, 0x1a, 0x6a, 0x0a,
	0x0d, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x49, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x4d, 0x61, 0x70, 0x73,
	0x55, 0x72, 0x69, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x5f, 0x75, 0x72,
	0x69, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x5f,
	0x74, 0x65, 0x78, 0x74, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x42, 0x0c, 0x0a, 0x0a, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22,
	0xcc, 0x01, 0x0a, 0x10, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x70,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x47, 0x0a, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x48,
	0x00, 0x52, 0x07, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x36, 0x0a,
	0x17, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b,
	0x5f, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x05, 0x52, 0x15,
	0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x49, 0x6e,
	0x64, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x11, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x02,
	0x52, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72,
	0x65, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x92,
	0x07, 0x0a, 0x11, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x31, 0x0a, 0x12, 0x77, 0x65, 0x62, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x77, 0x65, 0x62, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x51, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x69, 0x0a, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x88,
	0x01, 0x01, 0x12, 0x30, 0x0a, 0x11, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f,
	0x71, 0x75, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x51, 0x75, 0x65,
	0x72, 0x69, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x10, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52,
	0x0f, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x73,
	0x12, 0x65, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x75,
	0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x53,
	0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x6e, 0x0a, 0x12, 0x72, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x07, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0x48,
	0x01, 0x52, 0x11, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x88, 0x01, 0x01, 0x12, 0x53, 0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x5f, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0x48, 0x02, 0x52, 0x1c, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x4d, 0x61, 0x70, 0x73, 0x57, 0x69, 0x64, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x76, 0x0a, 0x14,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x6c, 0x61, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f,
	0x75, 0x72, 0x69, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x69,
	0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x55, 0x72, 0x69, 0x73, 0x1a, 0x5a, 0x0a, 0x11, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x6c,
	0x61, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x69, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x66, 0x6c, 0x61, 0x67, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x66, 0x6c, 0x61, 0x67, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x55, 0x72, 0x69,
	0x42, 0x15, 0x0a, 0x13, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x65, 0x6e, 0x74, 0x72,
	0x79, 0x5f, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x72, 0x65, 0x74, 0x72,
	0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x23,
	0x0a, 0x21, 0x5f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x6d, 0x61, 0x70, 0x73, 0x5f, 0x77,
	0x69, 0x64, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x62, 0x0a, 0x10, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x10, 0x72, 0x65, 0x6e, 0x64, 0x65,
	0x72, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x64, 0x6b, 0x5f, 0x62,
	0x6c, 0x6f, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x73, 0x64, 0x6b, 0x42, 0x6c, 0x6f, 0x62, 0x22, 0x6a, 0x0a, 0x11, 0x52, 0x65, 0x74, 0x72, 0x69,
	0x65, 0x76, 0x61, 0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x55, 0x0a, 0x25,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x64, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x44, 0x79,
	0x6e, 0x61, 0x6d, 0x69, 0x63, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x61, 0x6c, 0x53, 0x63,
	0x6f, 0x72, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x10, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x41, 0x72, 0x6d,
	0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x5c, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x12, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x60, 0x0a, 0x16, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d, 0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x52, 0x14, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x7c, 0x0a, 0x12, 0x4d, 0x6f, 0x64, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x45,
	0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x08, 0x6d, 0x6f, 0x64,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x2a, 0xf8, 0x01, 0x0a, 0x0c, 0x48, 0x61, 0x72, 0x6d, 0x43,
	0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x41, 0x52, 0x4d, 0x5f,
	0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43,
	0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x48, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x50, 0x45,
	0x45, 0x43, 0x48, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41,
	0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x44, 0x41, 0x4e, 0x47, 0x45, 0x52, 0x4f, 0x55, 0x53,
	0x5f, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x41,
	0x52, 0x4d, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x48, 0x41, 0x52, 0x41,
	0x53, 0x53, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x41, 0x52, 0x4d,
	0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x53, 0x45, 0x58, 0x55, 0x41, 0x4c,
	0x4c, 0x59, 0x5f, 0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x04, 0x12, 0x25, 0x0a,
	0x1d, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x43,
	0x49, 0x56, 0x49, 0x43, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x47, 0x52, 0x49, 0x54, 0x59, 0x10, 0x05,
	0x1a, 0x02, 0x08, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41, 0x54,
	0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x4a, 0x41, 0x49, 0x4c, 0x42, 0x52, 0x45, 0x41, 0x4b, 0x10,
	0x06, 0x2a, 0x5d, 0x0a, 0x08, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x18, 0x0a,
	0x14, 0x4d, 0x4f, 0x44, 0x41, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x45, 0x58, 0x54, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05,
	0x56, 0x49, 0x44, 0x45, 0x4f, 0x10, 0x03, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x55, 0x44, 0x49, 0x4f,
	0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x4f, 0x43, 0x55, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x05,
	0x42, 0xc8, 0x02, 0xea, 0x41, 0x62, 0x0a, 0x22, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x61, 0x72, 0x6d,
	0x6f, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x74,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0c, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42,
	0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_content_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_content_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_content_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_content_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_content_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_content_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes = make([]protoimpl.EnumInfo, 12)
var file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes = make([]protoimpl.MessageInfo, 39)
var file_google_cloud_aiplatform_v1beta1_content_proto_goTypes = []any{
	(HarmCategory)(0),                     // 0: google.cloud.aiplatform.v1beta1.HarmCategory
	(Modality)(0),                         // 1: google.cloud.aiplatform.v1beta1.Modality
	(GenerationConfig_Modality)(0),        // 2: google.cloud.aiplatform.v1beta1.GenerationConfig.Modality
	(GenerationConfig_MediaResolution)(0), // 3: google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution
	(GenerationConfig_RoutingConfig_AutoRoutingMode_ModelRoutingPreference)(0), // 4: google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference
	(GenerationConfig_ModelConfig_FeatureSelectionPreference)(0),               // 5: google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference
	(SafetySetting_HarmBlockThreshold)(0),                                      // 6: google.cloud.aiplatform.v1beta1.SafetySetting.HarmBlockThreshold
	(SafetySetting_HarmBlockMethod)(0),                                         // 7: google.cloud.aiplatform.v1beta1.SafetySetting.HarmBlockMethod
	(SafetyRating_HarmProbability)(0),                                          // 8: google.cloud.aiplatform.v1beta1.SafetyRating.HarmProbability
	(SafetyRating_HarmSeverity)(0),                                             // 9: google.cloud.aiplatform.v1beta1.SafetyRating.HarmSeverity
	(Candidate_FinishReason)(0),                                                // 10: google.cloud.aiplatform.v1beta1.Candidate.FinishReason
	(UrlMetadata_UrlRetrievalStatus)(0),                                        // 11: google.cloud.aiplatform.v1beta1.UrlMetadata.UrlRetrievalStatus
	(*Content)(nil),                                                            // 12: google.cloud.aiplatform.v1beta1.Content
	(*Part)(nil),                                                               // 13: google.cloud.aiplatform.v1beta1.Part
	(*Blob)(nil),                                                               // 14: google.cloud.aiplatform.v1beta1.Blob
	(*FileData)(nil),                                                           // 15: google.cloud.aiplatform.v1beta1.FileData
	(*VideoMetadata)(nil),                                                      // 16: google.cloud.aiplatform.v1beta1.VideoMetadata
	(*PrebuiltVoiceConfig)(nil),                                                // 17: google.cloud.aiplatform.v1beta1.PrebuiltVoiceConfig
	(*VoiceConfig)(nil),                                                        // 18: google.cloud.aiplatform.v1beta1.VoiceConfig
	(*SpeechConfig)(nil),                                                       // 19: google.cloud.aiplatform.v1beta1.SpeechConfig
	(*ImageConfig)(nil),                                                        // 20: google.cloud.aiplatform.v1beta1.ImageConfig
	(*GenerationConfig)(nil),                                                   // 21: google.cloud.aiplatform.v1beta1.GenerationConfig
	(*SafetySetting)(nil),                                                      // 22: google.cloud.aiplatform.v1beta1.SafetySetting
	(*SafetyRating)(nil),                                                       // 23: google.cloud.aiplatform.v1beta1.SafetyRating
	(*CitationMetadata)(nil),                                                   // 24: google.cloud.aiplatform.v1beta1.CitationMetadata
	(*Citation)(nil),                                                           // 25: google.cloud.aiplatform.v1beta1.Citation
	(*Candidate)(nil),                                                          // 26: google.cloud.aiplatform.v1beta1.Candidate
	(*UrlContextMetadata)(nil),                                                 // 27: google.cloud.aiplatform.v1beta1.UrlContextMetadata
	(*UrlMetadata)(nil),                                                        // 28: google.cloud.aiplatform.v1beta1.UrlMetadata
	(*LogprobsResult)(nil),                                                     // 29: google.cloud.aiplatform.v1beta1.LogprobsResult
	(*Segment)(nil),                                                            // 30: google.cloud.aiplatform.v1beta1.Segment
	(*GroundingChunk)(nil),                                                     // 31: google.cloud.aiplatform.v1beta1.GroundingChunk
	(*GroundingSupport)(nil),                                                   // 32: google.cloud.aiplatform.v1beta1.GroundingSupport
	(*GroundingMetadata)(nil),                                                  // 33: google.cloud.aiplatform.v1beta1.GroundingMetadata
	(*SearchEntryPoint)(nil),                                                   // 34: google.cloud.aiplatform.v1beta1.SearchEntryPoint
	(*RetrievalMetadata)(nil),                                                  // 35: google.cloud.aiplatform.v1beta1.RetrievalMetadata
	(*ModelArmorConfig)(nil),                                                   // 36: google.cloud.aiplatform.v1beta1.ModelArmorConfig
	(*ModalityTokenCount)(nil),                                                 // 37: google.cloud.aiplatform.v1beta1.ModalityTokenCount
	(*GenerationConfig_RoutingConfig)(nil),                                     // 38: google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
	(*GenerationConfig_ThinkingConfig)(nil),                                    // 39: google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
	(*GenerationConfig_ModelConfig)(nil),                                       // 40: google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
	(*GenerationConfig_RoutingConfig_AutoRoutingMode)(nil),                     // 41: google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
	(*GenerationConfig_RoutingConfig_ManualRoutingMode)(nil),                   // 42: google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
	(*LogprobsResult_Candidate)(nil),                                           // 43: google.cloud.aiplatform.v1beta1.LogprobsResult.Candidate
	(*LogprobsResult_TopCandidates)(nil),                                       // 44: google.cloud.aiplatform.v1beta1.LogprobsResult.TopCandidates
	(*GroundingChunk_Web)(nil),                                                 // 45: google.cloud.aiplatform.v1beta1.GroundingChunk.Web
	(*GroundingChunk_RetrievedContext)(nil),                                    // 46: google.cloud.aiplatform.v1beta1.GroundingChunk.RetrievedContext
	(*GroundingChunk_Maps)(nil),                                                // 47: google.cloud.aiplatform.v1beta1.GroundingChunk.Maps
	(*GroundingChunk_Maps_PlaceAnswerSources)(nil),                             // 48: google.cloud.aiplatform.v1beta1.GroundingChunk.Maps.PlaceAnswerSources
	(*GroundingChunk_Maps_PlaceAnswerSources_ReviewSnippet)(nil),               // 49: google.cloud.aiplatform.v1beta1.GroundingChunk.Maps.PlaceAnswerSources.ReviewSnippet
	(*GroundingMetadata_SourceFlaggingUri)(nil),                                // 50: google.cloud.aiplatform.v1beta1.GroundingMetadata.SourceFlaggingUri
	(*FunctionCall)(nil),                                                       // 51: google.cloud.aiplatform.v1beta1.FunctionCall
	(*FunctionResponse)(nil),                                                   // 52: google.cloud.aiplatform.v1beta1.FunctionResponse
	(*ExecutableCode)(nil),                                                     // 53: google.cloud.aiplatform.v1beta1.ExecutableCode
	(*CodeExecutionResult)(nil),                                                // 54: google.cloud.aiplatform.v1beta1.CodeExecutionResult
	(*durationpb.Duration)(nil),                                                // 55: google.protobuf.Duration
	(*Schema)(nil),                                                             // 56: google.cloud.aiplatform.v1beta1.Schema
	(*structpb.Value)(nil),                                                     // 57: google.protobuf.Value
	(*date.Date)(nil),                                                          // 58: google.type.Date
	(*RagChunk)(nil),                                                           // 59: google.cloud.aiplatform.v1beta1.RagChunk
}
var file_google_cloud_aiplatform_v1beta1_content_proto_depIdxs = []int32{
	13, // 0: google.cloud.aiplatform.v1beta1.Content.parts:type_name -> google.cloud.aiplatform.v1beta1.Part
	14, // 1: google.cloud.aiplatform.v1beta1.Part.inline_data:type_name -> google.cloud.aiplatform.v1beta1.Blob
	15, // 2: google.cloud.aiplatform.v1beta1.Part.file_data:type_name -> google.cloud.aiplatform.v1beta1.FileData
	51, // 3: google.cloud.aiplatform.v1beta1.Part.function_call:type_name -> google.cloud.aiplatform.v1beta1.FunctionCall
	52, // 4: google.cloud.aiplatform.v1beta1.Part.function_response:type_name -> google.cloud.aiplatform.v1beta1.FunctionResponse
	53, // 5: google.cloud.aiplatform.v1beta1.Part.executable_code:type_name -> google.cloud.aiplatform.v1beta1.ExecutableCode
	54, // 6: google.cloud.aiplatform.v1beta1.Part.code_execution_result:type_name -> google.cloud.aiplatform.v1beta1.CodeExecutionResult
	16, // 7: google.cloud.aiplatform.v1beta1.Part.video_metadata:type_name -> google.cloud.aiplatform.v1beta1.VideoMetadata
	55, // 8: google.cloud.aiplatform.v1beta1.VideoMetadata.start_offset:type_name -> google.protobuf.Duration
	55, // 9: google.cloud.aiplatform.v1beta1.VideoMetadata.end_offset:type_name -> google.protobuf.Duration
	17, // 10: google.cloud.aiplatform.v1beta1.VoiceConfig.prebuilt_voice_config:type_name -> google.cloud.aiplatform.v1beta1.PrebuiltVoiceConfig
	18, // 11: google.cloud.aiplatform.v1beta1.SpeechConfig.voice_config:type_name -> google.cloud.aiplatform.v1beta1.VoiceConfig
	56, // 12: google.cloud.aiplatform.v1beta1.GenerationConfig.response_schema:type_name -> google.cloud.aiplatform.v1beta1.Schema
	57, // 13: google.cloud.aiplatform.v1beta1.GenerationConfig.response_json_schema:type_name -> google.protobuf.Value
	38, // 14: google.cloud.aiplatform.v1beta1.GenerationConfig.routing_config:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig
	2,  // 15: google.cloud.aiplatform.v1beta1.GenerationConfig.response_modalities:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.Modality
	3,  // 16: google.cloud.aiplatform.v1beta1.GenerationConfig.media_resolution:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.MediaResolution
	19, // 17: google.cloud.aiplatform.v1beta1.GenerationConfig.speech_config:type_name -> google.cloud.aiplatform.v1beta1.SpeechConfig
	39, // 18: google.cloud.aiplatform.v1beta1.GenerationConfig.thinking_config:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.ThinkingConfig
	40, // 19: google.cloud.aiplatform.v1beta1.GenerationConfig.model_config:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig
	20, // 20: google.cloud.aiplatform.v1beta1.GenerationConfig.image_config:type_name -> google.cloud.aiplatform.v1beta1.ImageConfig
	0,  // 21: google.cloud.aiplatform.v1beta1.SafetySetting.category:type_name -> google.cloud.aiplatform.v1beta1.HarmCategory
	6,  // 22: google.cloud.aiplatform.v1beta1.SafetySetting.threshold:type_name -> google.cloud.aiplatform.v1beta1.SafetySetting.HarmBlockThreshold
	7,  // 23: google.cloud.aiplatform.v1beta1.SafetySetting.method:type_name -> google.cloud.aiplatform.v1beta1.SafetySetting.HarmBlockMethod
	0,  // 24: google.cloud.aiplatform.v1beta1.SafetyRating.category:type_name -> google.cloud.aiplatform.v1beta1.HarmCategory
	8,  // 25: google.cloud.aiplatform.v1beta1.SafetyRating.probability:type_name -> google.cloud.aiplatform.v1beta1.SafetyRating.HarmProbability
	9,  // 26: google.cloud.aiplatform.v1beta1.SafetyRating.severity:type_name -> google.cloud.aiplatform.v1beta1.SafetyRating.HarmSeverity
	25, // 27: google.cloud.aiplatform.v1beta1.CitationMetadata.citations:type_name -> google.cloud.aiplatform.v1beta1.Citation
	58, // 28: google.cloud.aiplatform.v1beta1.Citation.publication_date:type_name -> google.type.Date
	12, // 29: google.cloud.aiplatform.v1beta1.Candidate.content:type_name -> google.cloud.aiplatform.v1beta1.Content
	29, // 30: google.cloud.aiplatform.v1beta1.Candidate.logprobs_result:type_name -> google.cloud.aiplatform.v1beta1.LogprobsResult
	10, // 31: google.cloud.aiplatform.v1beta1.Candidate.finish_reason:type_name -> google.cloud.aiplatform.v1beta1.Candidate.FinishReason
	23, // 32: google.cloud.aiplatform.v1beta1.Candidate.safety_ratings:type_name -> google.cloud.aiplatform.v1beta1.SafetyRating
	24, // 33: google.cloud.aiplatform.v1beta1.Candidate.citation_metadata:type_name -> google.cloud.aiplatform.v1beta1.CitationMetadata
	33, // 34: google.cloud.aiplatform.v1beta1.Candidate.grounding_metadata:type_name -> google.cloud.aiplatform.v1beta1.GroundingMetadata
	27, // 35: google.cloud.aiplatform.v1beta1.Candidate.url_context_metadata:type_name -> google.cloud.aiplatform.v1beta1.UrlContextMetadata
	28, // 36: google.cloud.aiplatform.v1beta1.UrlContextMetadata.url_metadata:type_name -> google.cloud.aiplatform.v1beta1.UrlMetadata
	11, // 37: google.cloud.aiplatform.v1beta1.UrlMetadata.url_retrieval_status:type_name -> google.cloud.aiplatform.v1beta1.UrlMetadata.UrlRetrievalStatus
	44, // 38: google.cloud.aiplatform.v1beta1.LogprobsResult.top_candidates:type_name -> google.cloud.aiplatform.v1beta1.LogprobsResult.TopCandidates
	43, // 39: google.cloud.aiplatform.v1beta1.LogprobsResult.chosen_candidates:type_name -> google.cloud.aiplatform.v1beta1.LogprobsResult.Candidate
	45, // 40: google.cloud.aiplatform.v1beta1.GroundingChunk.web:type_name -> google.cloud.aiplatform.v1beta1.GroundingChunk.Web
	46, // 41: google.cloud.aiplatform.v1beta1.GroundingChunk.retrieved_context:type_name -> google.cloud.aiplatform.v1beta1.GroundingChunk.RetrievedContext
	47, // 42: google.cloud.aiplatform.v1beta1.GroundingChunk.maps:type_name -> google.cloud.aiplatform.v1beta1.GroundingChunk.Maps
	30, // 43: google.cloud.aiplatform.v1beta1.GroundingSupport.segment:type_name -> google.cloud.aiplatform.v1beta1.Segment
	34, // 44: google.cloud.aiplatform.v1beta1.GroundingMetadata.search_entry_point:type_name -> google.cloud.aiplatform.v1beta1.SearchEntryPoint
	31, // 45: google.cloud.aiplatform.v1beta1.GroundingMetadata.grounding_chunks:type_name -> google.cloud.aiplatform.v1beta1.GroundingChunk
	32, // 46: google.cloud.aiplatform.v1beta1.GroundingMetadata.grounding_supports:type_name -> google.cloud.aiplatform.v1beta1.GroundingSupport
	35, // 47: google.cloud.aiplatform.v1beta1.GroundingMetadata.retrieval_metadata:type_name -> google.cloud.aiplatform.v1beta1.RetrievalMetadata
	50, // 48: google.cloud.aiplatform.v1beta1.GroundingMetadata.source_flagging_uris:type_name -> google.cloud.aiplatform.v1beta1.GroundingMetadata.SourceFlaggingUri
	1,  // 49: google.cloud.aiplatform.v1beta1.ModalityTokenCount.modality:type_name -> google.cloud.aiplatform.v1beta1.Modality
	41, // 50: google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.auto_mode:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode
	42, // 51: google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.manual_mode:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.ManualRoutingMode
	5,  // 52: google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.feature_selection_preference:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.ModelConfig.FeatureSelectionPreference
	4,  // 53: google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.model_routing_preference:type_name -> google.cloud.aiplatform.v1beta1.GenerationConfig.RoutingConfig.AutoRoutingMode.ModelRoutingPreference
	43, // 54: google.cloud.aiplatform.v1beta1.LogprobsResult.TopCandidates.candidates:type_name -> google.cloud.aiplatform.v1beta1.LogprobsResult.Candidate
	59, // 55: google.cloud.aiplatform.v1beta1.GroundingChunk.RetrievedContext.rag_chunk:type_name -> google.cloud.aiplatform.v1beta1.RagChunk
	48, // 56: google.cloud.aiplatform.v1beta1.GroundingChunk.Maps.place_answer_sources:type_name -> google.cloud.aiplatform.v1beta1.GroundingChunk.Maps.PlaceAnswerSources
	49, // 57: google.cloud.aiplatform.v1beta1.GroundingChunk.Maps.PlaceAnswerSources.review_snippets:type_name -> google.cloud.aiplatform.v1beta1.GroundingChunk.Maps.PlaceAnswerSources.ReviewSnippet
	58, // [58:58] is the sub-list for method output_type
	58, // [58:58] is the sub-list for method input_type
	58, // [58:58] is the sub-list for extension type_name
	58, // [58:58] is the sub-list for extension extendee
	0,  // [0:58] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_content_proto_init() }
func file_google_cloud_aiplatform_v1beta1_content_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_content_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_openapi_proto_init()
	file_google_cloud_aiplatform_v1beta1_tool_proto_init()
	file_google_cloud_aiplatform_v1beta1_vertex_rag_data_proto_init()
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[1].OneofWrappers = []any{
		(*Part_Text)(nil),
		(*Part_InlineData)(nil),
		(*Part_FileData)(nil),
		(*Part_FunctionCall)(nil),
		(*Part_FunctionResponse)(nil),
		(*Part_ExecutableCode)(nil),
		(*Part_CodeExecutionResult)(nil),
		(*Part_VideoMetadata)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[5].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[6].OneofWrappers = []any{
		(*VoiceConfig_PrebuiltVoiceConfig)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[8].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[9].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[14].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[19].OneofWrappers = []any{
		(*GroundingChunk_Web_)(nil),
		(*GroundingChunk_RetrievedContext_)(nil),
		(*GroundingChunk_Maps_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[20].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[21].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[26].OneofWrappers = []any{
		(*GenerationConfig_RoutingConfig_AutoMode)(nil),
		(*GenerationConfig_RoutingConfig_ManualMode)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[27].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[29].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[30].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[31].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[33].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[34].OneofWrappers = []any{
		(*GroundingChunk_RetrievedContext_RagChunk)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[35].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_content_proto_rawDesc,
			NumEnums:      12,
			NumMessages:   39,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_content_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_content_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_content_proto = out.File
	file_google_cloud_aiplatform_v1beta1_content_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_content_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_content_proto_depIdxs = nil
}
