// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package bucket

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// ListExternalBucketsOKCode is the HTTP code returned for type ListExternalBucketsOK
const ListExternalBucketsOKCode int = 200

/*
ListExternalBucketsOK A successful response.

swagger:response listExternalBucketsOK
*/
type ListExternalBucketsOK struct {

	/*
	  In: Body
	*/
	Payload *models.ListBucketsResponse `json:"body,omitempty"`
}

// NewListExternalBucketsOK creates ListExternalBucketsOK with default headers values
func NewListExternalBucketsOK() *ListExternalBucketsOK {

	return &ListExternalBucketsOK{}
}

// WithPayload adds the payload to the list external buckets o k response
func (o *ListExternalBucketsOK) WithPayload(payload *models.ListBucketsResponse) *ListExternalBucketsOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list external buckets o k response
func (o *ListExternalBucketsOK) SetPayload(payload *models.ListBucketsResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListExternalBucketsOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ListExternalBucketsDefault Generic error response.

swagger:response listExternalBucketsDefault
*/
type ListExternalBucketsDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewListExternalBucketsDefault creates ListExternalBucketsDefault with default headers values
func NewListExternalBucketsDefault(code int) *ListExternalBucketsDefault {
	if code <= 0 {
		code = 500
	}

	return &ListExternalBucketsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the list external buckets default response
func (o *ListExternalBucketsDefault) WithStatusCode(code int) *ListExternalBucketsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the list external buckets default response
func (o *ListExternalBucketsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the list external buckets default response
func (o *ListExternalBucketsDefault) WithPayload(payload *models.APIError) *ListExternalBucketsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list external buckets default response
func (o *ListExternalBucketsDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListExternalBucketsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
