// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// SiteReplicationInfoResponse site replication info response
//
// swagger:model siteReplicationInfoResponse
type SiteReplicationInfoResponse struct {

	// enabled
	Enabled bool `json:"enabled,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// service account access key
	ServiceAccountAccessKey string `json:"serviceAccountAccessKey,omitempty"`

	// sites
	Sites []*PeerInfo `json:"sites"`
}

// Validate validates this site replication info response
func (m *SiteReplicationInfoResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateSites(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SiteReplicationInfoResponse) validateSites(formats strfmt.Registry) error {
	if swag.IsZero(m.Sites) { // not required
		return nil
	}

	for i := 0; i < len(m.Sites); i++ {
		if swag.IsZero(m.Sites[i]) { // not required
			continue
		}

		if m.Sites[i] != nil {
			if err := m.Sites[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sites" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("sites" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this site replication info response based on the context it is used
func (m *SiteReplicationInfoResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateSites(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SiteReplicationInfoResponse) contextValidateSites(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Sites); i++ {

		if m.Sites[i] != nil {

			if swag.IsZero(m.Sites[i]) { // not required
				return nil
			}

			if err := m.Sites[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("sites" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("sites" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *SiteReplicationInfoResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SiteReplicationInfoResponse) UnmarshalBinary(b []byte) error {
	var res SiteReplicationInfoResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
