// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package kubernetesconfiguration

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/kubernetesconfiguration/mgmt/2021-03-01/kubernetesconfiguration"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ComplianceStateType = original.ComplianceStateType

const (
	Compliant    ComplianceStateType = original.Compliant
	Failed       ComplianceStateType = original.Failed
	Installed    ComplianceStateType = original.Installed
	Noncompliant ComplianceStateType = original.Noncompliant
	Pending      ComplianceStateType = original.Pending
)

type CreatedByType = original.CreatedByType

const (
	Application     CreatedByType = original.Application
	Key             CreatedByType = original.Key
	ManagedIdentity CreatedByType = original.ManagedIdentity
	User            CreatedByType = original.User
)

type MessageLevelType = original.MessageLevelType

const (
	Error       MessageLevelType = original.Error
	Information MessageLevelType = original.Information
	Warning     MessageLevelType = original.Warning
)

type OperatorScopeType = original.OperatorScopeType

const (
	Cluster   OperatorScopeType = original.Cluster
	Namespace OperatorScopeType = original.Namespace
)

type OperatorType = original.OperatorType

const (
	Flux OperatorType = original.Flux
)

type ProvisioningStateType = original.ProvisioningStateType

const (
	ProvisioningStateTypeAccepted  ProvisioningStateType = original.ProvisioningStateTypeAccepted
	ProvisioningStateTypeDeleting  ProvisioningStateType = original.ProvisioningStateTypeDeleting
	ProvisioningStateTypeFailed    ProvisioningStateType = original.ProvisioningStateTypeFailed
	ProvisioningStateTypeRunning   ProvisioningStateType = original.ProvisioningStateTypeRunning
	ProvisioningStateTypeSucceeded ProvisioningStateType = original.ProvisioningStateTypeSucceeded
)

type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type ComplianceStatus = original.ComplianceStatus
type ErrorDefinition = original.ErrorDefinition
type ErrorResponse = original.ErrorResponse
type HelmOperatorProperties = original.HelmOperatorProperties
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type ResourceProviderOperation = original.ResourceProviderOperation
type ResourceProviderOperationDisplay = original.ResourceProviderOperationDisplay
type ResourceProviderOperationList = original.ResourceProviderOperationList
type ResourceProviderOperationListIterator = original.ResourceProviderOperationListIterator
type ResourceProviderOperationListPage = original.ResourceProviderOperationListPage
type Result = original.Result
type SourceControlConfiguration = original.SourceControlConfiguration
type SourceControlConfigurationList = original.SourceControlConfigurationList
type SourceControlConfigurationListIterator = original.SourceControlConfigurationListIterator
type SourceControlConfigurationListPage = original.SourceControlConfigurationListPage
type SourceControlConfigurationProperties = original.SourceControlConfigurationProperties
type SourceControlConfigurationsClient = original.SourceControlConfigurationsClient
type SourceControlConfigurationsDeleteFuture = original.SourceControlConfigurationsDeleteFuture
type SystemData = original.SystemData
type TrackedResource = original.TrackedResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceProviderOperationListIterator(page ResourceProviderOperationListPage) ResourceProviderOperationListIterator {
	return original.NewResourceProviderOperationListIterator(page)
}
func NewResourceProviderOperationListPage(cur ResourceProviderOperationList, getNextPage func(context.Context, ResourceProviderOperationList) (ResourceProviderOperationList, error)) ResourceProviderOperationListPage {
	return original.NewResourceProviderOperationListPage(cur, getNextPage)
}
func NewSourceControlConfigurationListIterator(page SourceControlConfigurationListPage) SourceControlConfigurationListIterator {
	return original.NewSourceControlConfigurationListIterator(page)
}
func NewSourceControlConfigurationListPage(cur SourceControlConfigurationList, getNextPage func(context.Context, SourceControlConfigurationList) (SourceControlConfigurationList, error)) SourceControlConfigurationListPage {
	return original.NewSourceControlConfigurationListPage(cur, getNextPage)
}
func NewSourceControlConfigurationsClient(subscriptionID string) SourceControlConfigurationsClient {
	return original.NewSourceControlConfigurationsClient(subscriptionID)
}
func NewSourceControlConfigurationsClientWithBaseURI(baseURI string, subscriptionID string) SourceControlConfigurationsClient {
	return original.NewSourceControlConfigurationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleComplianceStateTypeValues() []ComplianceStateType {
	return original.PossibleComplianceStateTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleMessageLevelTypeValues() []MessageLevelType {
	return original.PossibleMessageLevelTypeValues()
}
func PossibleOperatorScopeTypeValues() []OperatorScopeType {
	return original.PossibleOperatorScopeTypeValues()
}
func PossibleOperatorTypeValues() []OperatorType {
	return original.PossibleOperatorTypeValues()
}
func PossibleProvisioningStateTypeValues() []ProvisioningStateType {
	return original.PossibleProvisioningStateTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/latest"
}
func Version() string {
	return original.Version()
}
