// +build go1.9

// Copyright 2021 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package eventhub

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/eventhub/mgmt/2018-01-01-preview/eventhub"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AccessRights = original.AccessRights

const (
	Listen        AccessRights = original.Listen
	Manage        AccessRights = original.Manage
	SendEnumValue AccessRights = original.SendEnumValue
)

type DefaultAction = original.DefaultAction

const (
	Allow DefaultAction = original.Allow
	Deny  DefaultAction = original.Deny
)

type EncodingCaptureDescription = original.EncodingCaptureDescription

const (
	Avro        EncodingCaptureDescription = original.Avro
	AvroDeflate EncodingCaptureDescription = original.AvroDeflate
)

type EndPointProvisioningState = original.EndPointProvisioningState

const (
	Canceled  EndPointProvisioningState = original.Canceled
	Creating  EndPointProvisioningState = original.Creating
	Deleting  EndPointProvisioningState = original.Deleting
	Failed    EndPointProvisioningState = original.Failed
	Succeeded EndPointProvisioningState = original.Succeeded
	Updating  EndPointProvisioningState = original.Updating
)

type EntityStatus = original.EntityStatus

const (
	EntityStatusActive          EntityStatus = original.EntityStatusActive
	EntityStatusCreating        EntityStatus = original.EntityStatusCreating
	EntityStatusDeleting        EntityStatus = original.EntityStatusDeleting
	EntityStatusDisabled        EntityStatus = original.EntityStatusDisabled
	EntityStatusReceiveDisabled EntityStatus = original.EntityStatusReceiveDisabled
	EntityStatusRenaming        EntityStatus = original.EntityStatusRenaming
	EntityStatusRestoring       EntityStatus = original.EntityStatusRestoring
	EntityStatusSendDisabled    EntityStatus = original.EntityStatusSendDisabled
	EntityStatusUnknown         EntityStatus = original.EntityStatusUnknown
)

type IPAction = original.IPAction

const (
	Accept IPAction = original.Accept
	Reject IPAction = original.Reject
)

type IdentityType = original.IdentityType

const (
	SystemAssigned IdentityType = original.SystemAssigned
)

type KeySource = original.KeySource

const (
	MicrosoftKeyVault KeySource = original.MicrosoftKeyVault
)

type KeyType = original.KeyType

const (
	PrimaryKey   KeyType = original.PrimaryKey
	SecondaryKey KeyType = original.SecondaryKey
)

type NetworkRuleIPAction = original.NetworkRuleIPAction

const (
	NetworkRuleIPActionAllow NetworkRuleIPAction = original.NetworkRuleIPActionAllow
)

type PrivateLinkConnectionStatus = original.PrivateLinkConnectionStatus

const (
	Approved     PrivateLinkConnectionStatus = original.Approved
	Disconnected PrivateLinkConnectionStatus = original.Disconnected
	Pending      PrivateLinkConnectionStatus = original.Pending
	Rejected     PrivateLinkConnectionStatus = original.Rejected
)

type ProvisioningStateDR = original.ProvisioningStateDR

const (
	ProvisioningStateDRAccepted  ProvisioningStateDR = original.ProvisioningStateDRAccepted
	ProvisioningStateDRFailed    ProvisioningStateDR = original.ProvisioningStateDRFailed
	ProvisioningStateDRSucceeded ProvisioningStateDR = original.ProvisioningStateDRSucceeded
)

type RoleDisasterRecovery = original.RoleDisasterRecovery

const (
	Primary               RoleDisasterRecovery = original.Primary
	PrimaryNotReplicating RoleDisasterRecovery = original.PrimaryNotReplicating
	Secondary             RoleDisasterRecovery = original.Secondary
)

type SkuName = original.SkuName

const (
	Basic    SkuName = original.Basic
	Standard SkuName = original.Standard
)

type SkuTier = original.SkuTier

const (
	SkuTierBasic    SkuTier = original.SkuTierBasic
	SkuTierStandard SkuTier = original.SkuTierStandard
)

type UnavailableReason = original.UnavailableReason

const (
	InvalidName                           UnavailableReason = original.InvalidName
	NameInLockdown                        UnavailableReason = original.NameInLockdown
	NameInUse                             UnavailableReason = original.NameInUse
	None                                  UnavailableReason = original.None
	SubscriptionIsDisabled                UnavailableReason = original.SubscriptionIsDisabled
	TooManyNamespaceInCurrentSubscription UnavailableReason = original.TooManyNamespaceInCurrentSubscription
)

type AccessKeys = original.AccessKeys
type ArmDisasterRecovery = original.ArmDisasterRecovery
type ArmDisasterRecoveryListResult = original.ArmDisasterRecoveryListResult
type ArmDisasterRecoveryListResultIterator = original.ArmDisasterRecoveryListResultIterator
type ArmDisasterRecoveryListResultPage = original.ArmDisasterRecoveryListResultPage
type ArmDisasterRecoveryProperties = original.ArmDisasterRecoveryProperties
type AuthorizationRule = original.AuthorizationRule
type AuthorizationRuleListResult = original.AuthorizationRuleListResult
type AuthorizationRuleListResultIterator = original.AuthorizationRuleListResultIterator
type AuthorizationRuleListResultPage = original.AuthorizationRuleListResultPage
type AuthorizationRuleProperties = original.AuthorizationRuleProperties
type AvailableCluster = original.AvailableCluster
type AvailableClustersList = original.AvailableClustersList
type BaseClient = original.BaseClient
type CaptureDescription = original.CaptureDescription
type CheckNameAvailabilityParameter = original.CheckNameAvailabilityParameter
type CheckNameAvailabilityResult = original.CheckNameAvailabilityResult
type Cluster = original.Cluster
type ClusterListResult = original.ClusterListResult
type ClusterListResultIterator = original.ClusterListResultIterator
type ClusterListResultPage = original.ClusterListResultPage
type ClusterProperties = original.ClusterProperties
type ClusterQuotaConfigurationProperties = original.ClusterQuotaConfigurationProperties
type ClusterSku = original.ClusterSku
type ClustersClient = original.ClustersClient
type ClustersCreateOrUpdateFuture = original.ClustersCreateOrUpdateFuture
type ClustersDeleteFuture = original.ClustersDeleteFuture
type ClustersUpdateFuture = original.ClustersUpdateFuture
type ConfigurationClient = original.ConfigurationClient
type ConnectionState = original.ConnectionState
type ConsumerGroup = original.ConsumerGroup
type ConsumerGroupListResult = original.ConsumerGroupListResult
type ConsumerGroupListResultIterator = original.ConsumerGroupListResultIterator
type ConsumerGroupListResultPage = original.ConsumerGroupListResultPage
type ConsumerGroupProperties = original.ConsumerGroupProperties
type ConsumerGroupsClient = original.ConsumerGroupsClient
type Destination = original.Destination
type DestinationProperties = original.DestinationProperties
type DisasterRecoveryConfigsClient = original.DisasterRecoveryConfigsClient
type EHNamespace = original.EHNamespace
type EHNamespaceIDContainer = original.EHNamespaceIDContainer
type EHNamespaceIDListResult = original.EHNamespaceIDListResult
type EHNamespaceListResult = original.EHNamespaceListResult
type EHNamespaceListResultIterator = original.EHNamespaceListResultIterator
type EHNamespaceListResultPage = original.EHNamespaceListResultPage
type EHNamespaceProperties = original.EHNamespaceProperties
type Encryption = original.Encryption
type ErrorResponse = original.ErrorResponse
type EventHubsClient = original.EventHubsClient
type IPFilterRule = original.IPFilterRule
type IPFilterRuleListResult = original.IPFilterRuleListResult
type IPFilterRuleListResultIterator = original.IPFilterRuleListResultIterator
type IPFilterRuleListResultPage = original.IPFilterRuleListResultPage
type IPFilterRuleProperties = original.IPFilterRuleProperties
type Identity = original.Identity
type KeyVaultProperties = original.KeyVaultProperties
type ListResult = original.ListResult
type ListResultIterator = original.ListResultIterator
type ListResultPage = original.ListResultPage
type MessagingRegions = original.MessagingRegions
type MessagingRegionsListResult = original.MessagingRegionsListResult
type MessagingRegionsListResultIterator = original.MessagingRegionsListResultIterator
type MessagingRegionsListResultPage = original.MessagingRegionsListResultPage
type MessagingRegionsProperties = original.MessagingRegionsProperties
type Model = original.Model
type NWRuleSetIPRules = original.NWRuleSetIPRules
type NWRuleSetVirtualNetworkRules = original.NWRuleSetVirtualNetworkRules
type NamespacesClient = original.NamespacesClient
type NamespacesCreateOrUpdateFuture = original.NamespacesCreateOrUpdateFuture
type NamespacesDeleteFuture = original.NamespacesDeleteFuture
type NetworkRuleSet = original.NetworkRuleSet
type NetworkRuleSetProperties = original.NetworkRuleSetProperties
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationListResult = original.OperationListResult
type OperationListResultIterator = original.OperationListResultIterator
type OperationListResultPage = original.OperationListResultPage
type OperationsClient = original.OperationsClient
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionListResultIterator = original.PrivateEndpointConnectionListResultIterator
type PrivateEndpointConnectionListResultPage = original.PrivateEndpointConnectionListResultPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateEndpointConnectionsClient = original.PrivateEndpointConnectionsClient
type PrivateEndpointConnectionsDeleteFuture = original.PrivateEndpointConnectionsDeleteFuture
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkResourcesClient = original.PrivateLinkResourcesClient
type PrivateLinkResourcesListResult = original.PrivateLinkResourcesListResult
type Properties = original.Properties
type RegenerateAccessKeyParameters = original.RegenerateAccessKeyParameters
type RegionsClient = original.RegionsClient
type Resource = original.Resource
type Sku = original.Sku
type Subnet = original.Subnet
type TrackedResource = original.TrackedResource
type VirtualNetworkRule = original.VirtualNetworkRule
type VirtualNetworkRuleListResult = original.VirtualNetworkRuleListResult
type VirtualNetworkRuleListResultIterator = original.VirtualNetworkRuleListResultIterator
type VirtualNetworkRuleListResultPage = original.VirtualNetworkRuleListResultPage
type VirtualNetworkRuleProperties = original.VirtualNetworkRuleProperties

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewArmDisasterRecoveryListResultIterator(page ArmDisasterRecoveryListResultPage) ArmDisasterRecoveryListResultIterator {
	return original.NewArmDisasterRecoveryListResultIterator(page)
}
func NewArmDisasterRecoveryListResultPage(cur ArmDisasterRecoveryListResult, getNextPage func(context.Context, ArmDisasterRecoveryListResult) (ArmDisasterRecoveryListResult, error)) ArmDisasterRecoveryListResultPage {
	return original.NewArmDisasterRecoveryListResultPage(cur, getNextPage)
}
func NewAuthorizationRuleListResultIterator(page AuthorizationRuleListResultPage) AuthorizationRuleListResultIterator {
	return original.NewAuthorizationRuleListResultIterator(page)
}
func NewAuthorizationRuleListResultPage(cur AuthorizationRuleListResult, getNextPage func(context.Context, AuthorizationRuleListResult) (AuthorizationRuleListResult, error)) AuthorizationRuleListResultPage {
	return original.NewAuthorizationRuleListResultPage(cur, getNextPage)
}
func NewClusterListResultIterator(page ClusterListResultPage) ClusterListResultIterator {
	return original.NewClusterListResultIterator(page)
}
func NewClusterListResultPage(cur ClusterListResult, getNextPage func(context.Context, ClusterListResult) (ClusterListResult, error)) ClusterListResultPage {
	return original.NewClusterListResultPage(cur, getNextPage)
}
func NewClustersClient(subscriptionID string) ClustersClient {
	return original.NewClustersClient(subscriptionID)
}
func NewClustersClientWithBaseURI(baseURI string, subscriptionID string) ClustersClient {
	return original.NewClustersClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationClient(subscriptionID string) ConfigurationClient {
	return original.NewConfigurationClient(subscriptionID)
}
func NewConfigurationClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationClient {
	return original.NewConfigurationClientWithBaseURI(baseURI, subscriptionID)
}
func NewConsumerGroupListResultIterator(page ConsumerGroupListResultPage) ConsumerGroupListResultIterator {
	return original.NewConsumerGroupListResultIterator(page)
}
func NewConsumerGroupListResultPage(cur ConsumerGroupListResult, getNextPage func(context.Context, ConsumerGroupListResult) (ConsumerGroupListResult, error)) ConsumerGroupListResultPage {
	return original.NewConsumerGroupListResultPage(cur, getNextPage)
}
func NewConsumerGroupsClient(subscriptionID string) ConsumerGroupsClient {
	return original.NewConsumerGroupsClient(subscriptionID)
}
func NewConsumerGroupsClientWithBaseURI(baseURI string, subscriptionID string) ConsumerGroupsClient {
	return original.NewConsumerGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDisasterRecoveryConfigsClient(subscriptionID string) DisasterRecoveryConfigsClient {
	return original.NewDisasterRecoveryConfigsClient(subscriptionID)
}
func NewDisasterRecoveryConfigsClientWithBaseURI(baseURI string, subscriptionID string) DisasterRecoveryConfigsClient {
	return original.NewDisasterRecoveryConfigsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEHNamespaceListResultIterator(page EHNamespaceListResultPage) EHNamespaceListResultIterator {
	return original.NewEHNamespaceListResultIterator(page)
}
func NewEHNamespaceListResultPage(cur EHNamespaceListResult, getNextPage func(context.Context, EHNamespaceListResult) (EHNamespaceListResult, error)) EHNamespaceListResultPage {
	return original.NewEHNamespaceListResultPage(cur, getNextPage)
}
func NewEventHubsClient(subscriptionID string) EventHubsClient {
	return original.NewEventHubsClient(subscriptionID)
}
func NewEventHubsClientWithBaseURI(baseURI string, subscriptionID string) EventHubsClient {
	return original.NewEventHubsClientWithBaseURI(baseURI, subscriptionID)
}
func NewIPFilterRuleListResultIterator(page IPFilterRuleListResultPage) IPFilterRuleListResultIterator {
	return original.NewIPFilterRuleListResultIterator(page)
}
func NewIPFilterRuleListResultPage(cur IPFilterRuleListResult, getNextPage func(context.Context, IPFilterRuleListResult) (IPFilterRuleListResult, error)) IPFilterRuleListResultPage {
	return original.NewIPFilterRuleListResultPage(cur, getNextPage)
}
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return original.NewListResultIterator(page)
}
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return original.NewListResultPage(cur, getNextPage)
}
func NewMessagingRegionsListResultIterator(page MessagingRegionsListResultPage) MessagingRegionsListResultIterator {
	return original.NewMessagingRegionsListResultIterator(page)
}
func NewMessagingRegionsListResultPage(cur MessagingRegionsListResult, getNextPage func(context.Context, MessagingRegionsListResult) (MessagingRegionsListResult, error)) MessagingRegionsListResultPage {
	return original.NewMessagingRegionsListResultPage(cur, getNextPage)
}
func NewNamespacesClient(subscriptionID string) NamespacesClient {
	return original.NewNamespacesClient(subscriptionID)
}
func NewNamespacesClientWithBaseURI(baseURI string, subscriptionID string) NamespacesClient {
	return original.NewNamespacesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return original.NewOperationListResultIterator(page)
}
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return original.NewOperationListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return original.NewPrivateEndpointConnectionListResultIterator(page)
}
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return original.NewPrivateEndpointConnectionListResultPage(cur, getNextPage)
}
func NewPrivateEndpointConnectionsClient(subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClient(subscriptionID)
}
func NewPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) PrivateEndpointConnectionsClient {
	return original.NewPrivateEndpointConnectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateLinkResourcesClient(subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClient(subscriptionID)
}
func NewPrivateLinkResourcesClientWithBaseURI(baseURI string, subscriptionID string) PrivateLinkResourcesClient {
	return original.NewPrivateLinkResourcesClientWithBaseURI(baseURI, subscriptionID)
}
func NewRegionsClient(subscriptionID string) RegionsClient {
	return original.NewRegionsClient(subscriptionID)
}
func NewRegionsClientWithBaseURI(baseURI string, subscriptionID string) RegionsClient {
	return original.NewRegionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualNetworkRuleListResultIterator(page VirtualNetworkRuleListResultPage) VirtualNetworkRuleListResultIterator {
	return original.NewVirtualNetworkRuleListResultIterator(page)
}
func NewVirtualNetworkRuleListResultPage(cur VirtualNetworkRuleListResult, getNextPage func(context.Context, VirtualNetworkRuleListResult) (VirtualNetworkRuleListResult, error)) VirtualNetworkRuleListResultPage {
	return original.NewVirtualNetworkRuleListResultPage(cur, getNextPage)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessRightsValues() []AccessRights {
	return original.PossibleAccessRightsValues()
}
func PossibleDefaultActionValues() []DefaultAction {
	return original.PossibleDefaultActionValues()
}
func PossibleEncodingCaptureDescriptionValues() []EncodingCaptureDescription {
	return original.PossibleEncodingCaptureDescriptionValues()
}
func PossibleEndPointProvisioningStateValues() []EndPointProvisioningState {
	return original.PossibleEndPointProvisioningStateValues()
}
func PossibleEntityStatusValues() []EntityStatus {
	return original.PossibleEntityStatusValues()
}
func PossibleIPActionValues() []IPAction {
	return original.PossibleIPActionValues()
}
func PossibleIdentityTypeValues() []IdentityType {
	return original.PossibleIdentityTypeValues()
}
func PossibleKeySourceValues() []KeySource {
	return original.PossibleKeySourceValues()
}
func PossibleKeyTypeValues() []KeyType {
	return original.PossibleKeyTypeValues()
}
func PossibleNetworkRuleIPActionValues() []NetworkRuleIPAction {
	return original.PossibleNetworkRuleIPActionValues()
}
func PossiblePrivateLinkConnectionStatusValues() []PrivateLinkConnectionStatus {
	return original.PossiblePrivateLinkConnectionStatusValues()
}
func PossibleProvisioningStateDRValues() []ProvisioningStateDR {
	return original.PossibleProvisioningStateDRValues()
}
func PossibleRoleDisasterRecoveryValues() []RoleDisasterRecovery {
	return original.PossibleRoleDisasterRecoveryValues()
}
func PossibleSkuNameValues() []SkuName {
	return original.PossibleSkuNameValues()
}
func PossibleSkuTierValues() []SkuTier {
	return original.PossibleSkuTierValues()
}
func PossibleUnavailableReasonValues() []UnavailableReason {
	return original.PossibleUnavailableReasonValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
