package adhybridhealthservice

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/tracing"
	"github.com/gofrs/uuid"
	"net/http"
)

// ServiceMembersClient is the REST APIs for Azure Active Directory Connect Health
type ServiceMembersClient struct {
	BaseClient
}

// NewServiceMembersClient creates an instance of the ServiceMembersClient client.
func NewServiceMembersClient() ServiceMembersClient {
	return NewServiceMembersClientWithBaseURI(DefaultBaseURI)
}

// NewServiceMembersClientWithBaseURI creates an instance of the ServiceMembersClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewServiceMembersClientWithBaseURI(baseURI string) ServiceMembersClient {
	return ServiceMembersClient{NewWithBaseURI(baseURI)}
}

// Add onboards  a server, for a given service, to Azure Active Directory Connect Health Service.
// Parameters:
// serviceName - the name of the service under which the server is to be onboarded.
// serviceMember - the server object.
func (client ServiceMembersClient) Add(ctx context.Context, serviceName string, serviceMember ServiceMember) (result ServiceMember, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.Add")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.AddPreparer(ctx, serviceName, serviceMember)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Add", nil, "Failure preparing request")
		return
	}

	resp, err := client.AddSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Add", resp, "Failure sending request")
		return
	}

	result, err = client.AddResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Add", resp, "Failure responding to request")
		return
	}

	return
}

// AddPreparer prepares the Add request.
func (client ServiceMembersClient) AddPreparer(ctx context.Context, serviceName string, serviceMember ServiceMember) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers", pathParameters),
		autorest.WithJSON(serviceMember),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// AddSender sends the Add request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) AddSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// AddResponder handles the response to the Add request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) AddResponder(resp *http.Response) (result ServiceMember, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a server that has been onboarded to Azure Active Directory Connect Health Service.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server Id.
// confirm - indicates if the server will be permanently deleted or disabled. True indicates that the server
// will be permanently deleted and False indicates that the server will be marked disabled and then deleted
// after 30 days, if it is not re-registered.
func (client ServiceMembersClient) Delete(ctx context.Context, serviceName string, serviceMemberID uuid.UUID, confirm *bool) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, serviceName, serviceMemberID, confirm)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ServiceMembersClient) DeletePreparer(ctx context.Context, serviceName string, serviceMemberID uuid.UUID, confirm *bool) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if confirm != nil {
		queryParameters["confirm"] = autorest.Encode("query", *confirm)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteData deletes the data uploaded by the server to Azure Active Directory Connect Health Service.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server Id.
func (client ServiceMembersClient) DeleteData(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.DeleteData")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteDataPreparer(ctx, serviceName, serviceMemberID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "DeleteData", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteDataSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "DeleteData", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteDataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "DeleteData", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteDataPreparer prepares the DeleteData request.
func (client ServiceMembersClient) DeleteDataPreparer(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/data", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteDataSender sends the DeleteData request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) DeleteDataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteDataResponder handles the response to the DeleteData request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) DeleteDataResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets the details of a server, for a given service, that are onboarded to Azure Active Directory Connect Health
// Service.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server Id.
func (client ServiceMembersClient) Get(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (result ServiceMember, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, serviceName, serviceMemberID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ServiceMembersClient) GetPreparer(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) GetResponder(resp *http.Response) (result ServiceMember, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetConnectorMetadata gets the list of connectors and run profile names.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the service member id.
// metricName - the name of the metric.
func (client ServiceMembersClient) GetConnectorMetadata(ctx context.Context, serviceName string, serviceMemberID uuid.UUID, metricName string) (result ConnectorMetadata, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.GetConnectorMetadata")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetConnectorMetadataPreparer(ctx, serviceName, serviceMemberID, metricName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetConnectorMetadata", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetConnectorMetadataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetConnectorMetadata", resp, "Failure sending request")
		return
	}

	result, err = client.GetConnectorMetadataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetConnectorMetadata", resp, "Failure responding to request")
		return
	}

	return
}

// GetConnectorMetadataPreparer prepares the GetConnectorMetadata request.
func (client ServiceMembersClient) GetConnectorMetadataPreparer(ctx context.Context, serviceName string, serviceMemberID uuid.UUID, metricName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"metricName":      autorest.Encode("path", metricName),
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/metrics/{metricName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetConnectorMetadataSender sends the GetConnectorMetadata request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) GetConnectorMetadataSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetConnectorMetadataResponder handles the response to the GetConnectorMetadata request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) GetConnectorMetadataResponder(resp *http.Response) (result ConnectorMetadata, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetMetrics gets the server related metrics for a given metric and group combination.
// Parameters:
// serviceName - the name of the service.
// metricName - the metric name
// groupName - the group name
// serviceMemberID - the server id.
// groupKey - the group key
// fromDate - the start date.
// toDate - the end date.
func (client ServiceMembersClient) GetMetrics(ctx context.Context, serviceName string, metricName string, groupName string, serviceMemberID uuid.UUID, groupKey string, fromDate *date.Time, toDate *date.Time) (result MetricSets, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.GetMetrics")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetMetricsPreparer(ctx, serviceName, metricName, groupName, serviceMemberID, groupKey, fromDate, toDate)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetMetrics", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetMetrics", resp, "Failure sending request")
		return
	}

	result, err = client.GetMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetMetrics", resp, "Failure responding to request")
		return
	}

	return
}

// GetMetricsPreparer prepares the GetMetrics request.
func (client ServiceMembersClient) GetMetricsPreparer(ctx context.Context, serviceName string, metricName string, groupName string, serviceMemberID uuid.UUID, groupKey string, fromDate *date.Time, toDate *date.Time) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"groupName":       autorest.Encode("path", groupName),
		"metricName":      autorest.Encode("path", metricName),
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(groupKey) > 0 {
		queryParameters["groupKey"] = autorest.Encode("query", groupKey)
	}
	if fromDate != nil {
		queryParameters["fromDate"] = autorest.Encode("query", *fromDate)
	}
	if toDate != nil {
		queryParameters["toDate"] = autorest.Encode("query", *toDate)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/metrics/{metricName}/groups/{groupName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetMetricsSender sends the GetMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) GetMetricsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetMetricsResponder handles the response to the GetMetrics request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) GetMetricsResponder(resp *http.Response) (result MetricSets, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetServiceConfiguration gets the service configuration.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server Id.
func (client ServiceMembersClient) GetServiceConfiguration(ctx context.Context, serviceName string, serviceMemberID string) (result ServiceConfiguration, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.GetServiceConfiguration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetServiceConfigurationPreparer(ctx, serviceName, serviceMemberID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetServiceConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetServiceConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetServiceConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.GetServiceConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "GetServiceConfiguration", resp, "Failure responding to request")
		return
	}

	return
}

// GetServiceConfigurationPreparer prepares the GetServiceConfiguration request.
func (client ServiceMembersClient) GetServiceConfigurationPreparer(ctx context.Context, serviceName string, serviceMemberID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/serviceconfiguration", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetServiceConfigurationSender sends the GetServiceConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) GetServiceConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetServiceConfigurationResponder handles the response to the GetServiceConfiguration request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) GetServiceConfigurationResponder(resp *http.Response) (result ServiceConfiguration, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List gets the details of the servers, for a given service, that are onboarded to Azure Active Directory Connect
// Health Service.
// Parameters:
// serviceName - the name of the service.
// filter - the server property filter to apply.
// dimensionType - the server specific dimension.
// dimensionSignature - the value of the dimension.
func (client ServiceMembersClient) List(ctx context.Context, serviceName string, filter string, dimensionType string, dimensionSignature string) (result ServiceMembersPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.List")
		defer func() {
			sc := -1
			if result.sm.Response.Response != nil {
				sc = result.sm.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, serviceName, filter, dimensionType, dimensionSignature)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.sm.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "List", resp, "Failure sending request")
		return
	}

	result.sm, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "List", resp, "Failure responding to request")
		return
	}
	if result.sm.hasNextLink() && result.sm.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client ServiceMembersClient) ListPreparer(ctx context.Context, serviceName string, filter string, dimensionType string, dimensionSignature string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceName": autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(dimensionType) > 0 {
		queryParameters["dimensionType"] = autorest.Encode("query", dimensionType)
	}
	if len(dimensionSignature) > 0 {
		queryParameters["dimensionSignature"] = autorest.Encode("query", dimensionSignature)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) ListResponder(resp *http.Response) (result ServiceMembers, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ServiceMembersClient) listNextResults(ctx context.Context, lastResults ServiceMembers) (result ServiceMembers, err error) {
	req, err := lastResults.serviceMembersPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServiceMembersClient) ListComplete(ctx context.Context, serviceName string, filter string, dimensionType string, dimensionSignature string) (result ServiceMembersIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, serviceName, filter, dimensionType, dimensionSignature)
	return
}

// ListAlerts gets the details of an alert for a given service and server combination.
// Parameters:
// serviceMemberID - the server Id for which the alert details needs to be queried.
// serviceName - the name of the service.
// filter - the alert property filter to apply.
// state - the alert state to query for.
// from - the start date to query for.
// toParameter - the end date till when to query for.
func (client ServiceMembersClient) ListAlerts(ctx context.Context, serviceMemberID uuid.UUID, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (result AlertsPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.ListAlerts")
		defer func() {
			sc := -1
			if result.a.Response.Response != nil {
				sc = result.a.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listAlertsNextResults
	req, err := client.ListAlertsPreparer(ctx, serviceMemberID, serviceName, filter, state, from, toParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListAlerts", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListAlertsSender(req)
	if err != nil {
		result.a.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListAlerts", resp, "Failure sending request")
		return
	}

	result.a, err = client.ListAlertsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListAlerts", resp, "Failure responding to request")
		return
	}
	if result.a.hasNextLink() && result.a.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListAlertsPreparer prepares the ListAlerts request.
func (client ServiceMembersClient) ListAlertsPreparer(ctx context.Context, serviceMemberID uuid.UUID, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(state) > 0 {
		queryParameters["state"] = autorest.Encode("query", state)
	}
	if from != nil {
		queryParameters["from"] = autorest.Encode("query", *from)
	}
	if toParameter != nil {
		queryParameters["to"] = autorest.Encode("query", *toParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/alerts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListAlertsSender sends the ListAlerts request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) ListAlertsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListAlertsResponder handles the response to the ListAlerts request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) ListAlertsResponder(resp *http.Response) (result Alerts, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listAlertsNextResults retrieves the next set of results, if any.
func (client ServiceMembersClient) listAlertsNextResults(ctx context.Context, lastResults Alerts) (result Alerts, err error) {
	req, err := lastResults.alertsPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listAlertsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListAlertsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listAlertsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListAlertsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listAlertsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListAlertsComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServiceMembersClient) ListAlertsComplete(ctx context.Context, serviceMemberID uuid.UUID, serviceName string, filter string, state string, from *date.Time, toParameter *date.Time) (result AlertsIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.ListAlerts")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListAlerts(ctx, serviceMemberID, serviceName, filter, state, from, toParameter)
	return
}

// ListConnectors gets the connector details for a service.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server Id.
func (client ServiceMembersClient) ListConnectors(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (result Connectors, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.ListConnectors")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListConnectorsPreparer(ctx, serviceName, serviceMemberID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListConnectors", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListConnectorsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListConnectors", resp, "Failure sending request")
		return
	}

	result, err = client.ListConnectorsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListConnectors", resp, "Failure responding to request")
		return
	}

	return
}

// ListConnectorsPreparer prepares the ListConnectors request.
func (client ServiceMembersClient) ListConnectorsPreparer(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/service/{serviceName}/servicemembers/{serviceMemberId}/connectors", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListConnectorsSender sends the ListConnectors request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) ListConnectorsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListConnectorsResponder handles the response to the ListConnectors request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) ListConnectorsResponder(resp *http.Response) (result Connectors, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListCredentials gets the credentials of the server which is needed by the agent to connect to Azure Active Directory
// Connect Health Service.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server Id.
// filter - the property filter to apply.
func (client ServiceMembersClient) ListCredentials(ctx context.Context, serviceName string, serviceMemberID uuid.UUID, filter string) (result Credentials, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.ListCredentials")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListCredentialsPreparer(ctx, serviceName, serviceMemberID, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListCredentials", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListCredentialsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListCredentials", resp, "Failure sending request")
		return
	}

	result, err = client.ListCredentialsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListCredentials", resp, "Failure responding to request")
		return
	}

	return
}

// ListCredentialsPreparer prepares the ListCredentials request.
func (client ServiceMembersClient) ListCredentialsPreparer(ctx context.Context, serviceName string, serviceMemberID uuid.UUID, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/credentials", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListCredentialsSender sends the ListCredentials request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) ListCredentialsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListCredentialsResponder handles the response to the ListCredentials request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) ListCredentialsResponder(resp *http.Response) (result Credentials, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListDataFreshness gets the last time when the server uploaded data to Azure Active Directory Connect Health Service.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server Id.
func (client ServiceMembersClient) ListDataFreshness(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (result DataFreshnessDetails, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.ListDataFreshness")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListDataFreshnessPreparer(ctx, serviceName, serviceMemberID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListDataFreshness", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListDataFreshnessSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListDataFreshness", resp, "Failure sending request")
		return
	}

	result, err = client.ListDataFreshnessResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListDataFreshness", resp, "Failure responding to request")
		return
	}

	return
}

// ListDataFreshnessPreparer prepares the ListDataFreshness request.
func (client ServiceMembersClient) ListDataFreshnessPreparer(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/datafreshness", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListDataFreshnessSender sends the ListDataFreshness request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) ListDataFreshnessSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListDataFreshnessResponder handles the response to the ListDataFreshness request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) ListDataFreshnessResponder(resp *http.Response) (result DataFreshnessDetails, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListExportStatus gets the export status.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server Id.
func (client ServiceMembersClient) ListExportStatus(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (result ExportStatusesPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.ListExportStatus")
		defer func() {
			sc := -1
			if result.es.Response.Response != nil {
				sc = result.es.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listExportStatusNextResults
	req, err := client.ListExportStatusPreparer(ctx, serviceName, serviceMemberID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListExportStatus", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListExportStatusSender(req)
	if err != nil {
		result.es.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListExportStatus", resp, "Failure sending request")
		return
	}

	result.es, err = client.ListExportStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListExportStatus", resp, "Failure responding to request")
		return
	}
	if result.es.hasNextLink() && result.es.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListExportStatusPreparer prepares the ListExportStatus request.
func (client ServiceMembersClient) ListExportStatusPreparer(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/exportstatus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListExportStatusSender sends the ListExportStatus request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) ListExportStatusSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListExportStatusResponder handles the response to the ListExportStatus request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) ListExportStatusResponder(resp *http.Response) (result ExportStatuses, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listExportStatusNextResults retrieves the next set of results, if any.
func (client ServiceMembersClient) listExportStatusNextResults(ctx context.Context, lastResults ExportStatuses) (result ExportStatuses, err error) {
	req, err := lastResults.exportStatusesPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listExportStatusNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListExportStatusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listExportStatusNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListExportStatusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "listExportStatusNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListExportStatusComplete enumerates all values, automatically crossing page boundaries as required.
func (client ServiceMembersClient) ListExportStatusComplete(ctx context.Context, serviceName string, serviceMemberID uuid.UUID) (result ExportStatusesIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.ListExportStatus")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListExportStatus(ctx, serviceName, serviceMemberID)
	return
}

// ListGlobalConfiguration gets the global configuration.
// Parameters:
// serviceName - the name of the service.
// serviceMemberID - the server id.
func (client ServiceMembersClient) ListGlobalConfiguration(ctx context.Context, serviceName string, serviceMemberID string) (result GlobalConfigurations, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceMembersClient.ListGlobalConfiguration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ListGlobalConfigurationPreparer(ctx, serviceName, serviceMemberID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListGlobalConfiguration", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListGlobalConfigurationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListGlobalConfiguration", resp, "Failure sending request")
		return
	}

	result, err = client.ListGlobalConfigurationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "adhybridhealthservice.ServiceMembersClient", "ListGlobalConfiguration", resp, "Failure responding to request")
		return
	}

	return
}

// ListGlobalConfigurationPreparer prepares the ListGlobalConfiguration request.
func (client ServiceMembersClient) ListGlobalConfigurationPreparer(ctx context.Context, serviceName string, serviceMemberID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"serviceMemberId": autorest.Encode("path", serviceMemberID),
		"serviceName":     autorest.Encode("path", serviceName),
	}

	const APIVersion = "2014-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.ADHybridHealthService/services/{serviceName}/servicemembers/{serviceMemberId}/globalconfiguration", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListGlobalConfigurationSender sends the ListGlobalConfiguration request. The method will close the
// http.Response Body if it receives an error.
func (client ServiceMembersClient) ListGlobalConfigurationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListGlobalConfigurationResponder handles the response to the ListGlobalConfiguration request. The method always
// closes the http.Response Body.
func (client ServiceMembersClient) ListGlobalConfigurationResponder(resp *http.Response) (result GlobalConfigurations, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
